<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2013 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
     * details.
     *
     * You should have received a copy of the GNU General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2013. All rights reserved".
     ********************************************************************************/

    require_once 'BaseUpgraderComponent.php';

    class UpgraderComponent extends BaseUpgraderComponent
    {
        /**
         * Process config files.
         * Problem here is that some config files might be modified, so there
         * can be some additional config options. We need to modify config
         * files(debug.php, debugTest.php, perInstance.php, perInstanceTest.php),
         * without loosing settings entered by user, so in most cases we will add
         * content at the end of those files where possible.
         * Should be used to files like debug.php, debugTest.php, perInstance.php, perInstanceTest.php,
         * which are not tracked by SCM tools, other files are updated automatically.
         */
        public function processConfigFiles($pathToConfigurationFolder)
        {
            $zurmoVersionBeforeUpgrade = UpgradeUtil::getUpgradeState('zurmoVersionBeforeUpgrade');
            if ($this->shouldRunTasksByVersion($zurmoVersionBeforeUpgrade, '1.5.15'))
            {
            }
        }

        /**
         * Process files
         * @param string $source
         * @param string $destination
         * @param array $configuration
         */
        public function processFiles($source, $destination, $configuration)
        {
            $zurmoVersionBeforeUpgrade = UpgradeUtil::getUpgradeState('zurmoVersionBeforeUpgrade');
            if ($this->shouldRunTasksByVersion($zurmoVersionBeforeUpgrade, '1.5.15'))
            {
                // Remove files that are marked for removal in manifest.php.
                if (isset($configuration['removedFiles']) && !empty($configuration['removedFiles']))
                {
                    foreach ($configuration['removedFiles'] as $fileOrFolderToRemove)
                    {
                        // Replace Lunux directory separators(from upgrade manifest file)
                        // with one used by system(DIRECTORY_SEPARATOR)
                        $fileOrFolderToRemove = str_replace('/', DIRECTORY_SEPARATOR, $fileOrFolderToRemove);
                        $fileOrFolderToRemove = $destination . DIRECTORY_SEPARATOR . trim($fileOrFolderToRemove, DIRECTORY_SEPARATOR);
                        if (is_dir($fileOrFolderToRemove))
                        {
                            FileUtil::deleteDirectoryRecursive($fileOrFolderToRemove);
                        }
                        elseif (is_file($fileOrFolderToRemove))
                        {
                            unlink($fileOrFolderToRemove);
                        }
                    }
                }
                // Copy new or modified files.
                FileUtil::copyRecursive($source, $destination);

                // Trick to disable gamification on EndRequestBehaviour
                Yii::app()->user->userModel = null;
            }
        }

        /**
         * Tasks that should be executed before updating schema.
         *
         */
        public function processBeforeUpdateSchema()
        {
            $zurmoVersionBeforeUpgrade = UpgradeUtil::getUpgradeState('zurmoVersionBeforeUpgrade');
            if ($this->shouldRunTasksByVersion($zurmoVersionBeforeUpgrade, '1.5.15'))
            {
                // Clear portlet table
                R::exec('delete from portlet');

                if (GlobalMetadata::isClassMetadataSavedInDatabase('Account'))
                {
                    $metadata = Account::getMetadata();
                    $metadata['Account']['relations']['billingAddress'] =
                        array(RedBeanModel::HAS_ONE,          'Address',             RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'billingAddress');
                    $metadata['Account']['relations']['industry'] =
                        array(RedBeanModel::HAS_ONE,              'OwnedCustomField', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'industry');
                    $metadata['Account']['relations']['primaryEmail'] =
                        array(RedBeanModel::HAS_ONE,              'Email',            RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'primaryEmail');
                    $metadata['Account']['relations']['secondaryEmail'] =
                        array(RedBeanModel::HAS_ONE,              'Email',            RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'secondaryEmail');
                    $metadata['Account']['relations']['shippingAddress'] =
                        array(RedBeanModel::HAS_ONE,              'Address',          RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'shippingAddress');
                    $metadata['Account']['relations']['type'] =
                        array(RedBeanModel::HAS_ONE,              'OwnedCustomField', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'type');

                    $metadata['Account']['derivedRelationsViaCastedUpModel']['meetings'] =
                        array(RedBeanModel::MANY_MANY, 'Meeting', 'activityItems');
                    $metadata['Account']['derivedRelationsViaCastedUpModel']['notes'] =
                        array(RedBeanModel::MANY_MANY, 'Note',    'activityItems');
                    $metadata['Account']['derivedRelationsViaCastedUpModel']['tasks'] =
                        array(RedBeanModel::MANY_MANY, 'Task',    'activityItems');

                    foreach ($metadata['Account']['rules'] as $key => $rule)
                    {
                        if ($rule[0] == 'officePhone' && $rule[1] == 'length')
                        {
                            $metadata['Account']['rules'][$key] = array('officePhone', 'length', 'min'  => 1, 'max' => 24);
                        }
                        elseif ($rule[0] == 'officeFax' && $rule[1] == 'length')
                        {
                            $metadata['Account']['rules'][$key] = array('officeFax', 'length', 'min'  => 1, 'max' => 24);
                        }
                        elseif ($rule[0] == 'website' && $rule[1] == 'url')
                        {
                            $metadata['Account']['rules'][$key] = array('website', 'url', 'defaultScheme' => 'http');
                        }
                    }
                    Account::setMetadata($metadata);
                }

                if (GlobalMetadata::isClassMetadataSavedInDatabase('AccountEditAndDetailsView'))
                {
                    $metadata = AccountEditAndDetailsView::getMetadata();
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'SaveButton', 0);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'CancelLink', 1);
                    AccountEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('DashboardEditView'))
                {
                    $metadata = DashboardEditView::getMetadata();
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'SaveButton', 0);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'CancelToListLink', 1);
                    DashboardEditView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('ContactEditAndDetailsView'))
                {
                    $metadata = ContactEditAndDetailsView::getMetadata();
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'SaveButton', 0);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'CancelLink', 1);
                    ContactEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('LeadEditAndDetailsView'))
                {
                    $metadata = LeadEditAndDetailsView::getMetadata();
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'SaveButton', 0);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'CancelLink', 1);
                    LeadEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('MeetingEditAndDetailsView'))
                {
                    $metadata = MeetingEditAndDetailsView::getMetadata();
                    //CancelChangesLink
                    $search = array('type' => 'CancelChangesLink');
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['renderType'] = 'Edit';
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['type'] = 'CancelLink';
                    }

                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'SaveButton', 0);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'CancelLink', 1);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'MeetingDeleteLink', 2);

                    MeetingEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('NoteEditAndDetailsView'))
                {
                    $metadata = NoteEditAndDetailsView::getMetadata();
                    //CancelChangesLink
                    $search = array('type' => 'CancelChangesLink');
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['renderType'] = 'Edit';
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['type'] = 'CancelLink';
                    }
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'SaveButton', 0);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'CancelLink', 1);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'NoteDeleteLink', 2);


                    NoteEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('OpportunityEditAndDetailsView'))
                {
                    $metadata = OpportunityEditAndDetailsView::getMetadata();
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'SaveButton', 0);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'CancelLink', 1);
                    OpportunityEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('RoleEditAndDetailsView'))
                {
                    $metadata = RoleEditAndDetailsView::getMetadata();
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'SaveButton', 0);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'CancelToListLink', 1);
                    RoleEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('TaskEditAndDetailsView'))
                {
                    $metadata = TaskEditAndDetailsView::getMetadata();
                    //CancelChangesLink
                    $search = array('type' => 'CancelChangesLink');
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['renderType'] = 'Edit';
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['type'] = 'CancelLink';
                    }
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'SaveButton', 0);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'CancelLink', 1);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'TaskDeleteLink', 2);

                    TaskEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('UserChangeAvatarView'))
                {
                    $metadata = UserChangeAvatarView::getMetadata();
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'SaveButton', 0);
                    UserChangeAvatarView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('ContactEditAndDetailsView'))
                {
                    $metadata = ContactEditAndDetailsView::getMetadata();
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'SaveButton', 0);
                    $this->setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray($metadata, 'CancelLink', 1);
                    ContactEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('AccountsModule'))
                {
                    $metadata = AccountsModule::getMetadata();
                    $metadata['global']['tabMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('AccountsModule', 'AccountsModulePluralLabel', \$translationParams)",
                            'url'    => array('/accounts/default'),
                            'right'  => AccountsModule::RIGHT_ACCESS_ACCOUNTS,
                            'mobile' => true,
                        ),
                    );
                    $metadata['global']['shortcutsCreateMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('AccountsModule', 'AccountsModuleSingularLabel', \$translationParams)",
                            'url'    => array('/accounts/default/create'),
                            'right'  => AccountsModule::RIGHT_CREATE_ACCOUNTS,
                            'mobile' => true,
                        ),
                    );
                    AccountsModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('ConfigurationModule'))
                {
                    $metadata = ConfigurationModule::getMetadata();
                    $metadata['global']['adminTabMenuItems'] = array(
                        array(
                            'label' => "eval:Zurmo::t('ConfigurationModule', 'Settings')",
                            'url'   => array('/configuration/default'),
                            'right' => ZurmoModule::RIGHT_ACCESS_ADMINISTRATION
                        ),
                    );
                    ConfigurationModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('ContactsModule'))
                {
                    $metadata = ContactsModule::getMetadata();
                    $metadata['global']['tabMenuItems'] = array(
                        array(
                            'label' => "eval:Zurmo::t('ContactsModule', 'ContactsModulePluralLabel', \$translationParams)",
                            'url'   => array('/contacts/default'),
                            'right' => ContactsModule::RIGHT_ACCESS_CONTACTS,
                            'mobile' => true,
                        ),
                    );
                    $metadata['global']['shortcutsCreateMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('ContactsModule', 'ContactsModuleSingularLabel', \$translationParams)",
                            'url'    => array('/contacts/default/create'),
                            'right'  => ContactsModule::RIGHT_CREATE_CONTACTS,
                            'mobile' => true,
                        ),
                    );
                    ContactsModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('Contact'))
                {
                    $metadata = Contact::getMetadata();
                    $metadata['Contact']['relations']['industry'] =
                        array(RedBeanModel::HAS_ONE,   'OwnedCustomField', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'industry');
                    $metadata['Contact']['relations']['secondaryAddress'] =
                        array(RedBeanModel::HAS_ONE,   'Address',          RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'secondaryAddress');
                    $metadata['Contact']['relations']['secondaryEmail'] =
                        array(RedBeanModel::HAS_ONE,   'Email',            RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'secondaryEmail');
                    $metadata['Contact']['relations']['source'] =
                        array(RedBeanModel::HAS_ONE,   'OwnedCustomField', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'source');
                    $metadata['Contact']['relations']['state'] =
                        array(RedBeanModel::HAS_ONE,   'ContactState', RedBeanModel::NOT_OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'state');

                    $metadata['Contact']['derivedRelationsViaCastedUpModel']['meetings'] =
                        array(RedBeanModel::MANY_MANY, 'Meeting', 'activityItems');
                    $metadata['Contact']['derivedRelationsViaCastedUpModel']['notes'] =
                        array(RedBeanModel::MANY_MANY, 'Note',    'activityItems');
                    $metadata['Contact']['derivedRelationsViaCastedUpModel']['tasks'] =
                        array(RedBeanModel::MANY_MANY, 'Task',    'activityItems');

                    Contact::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('Conversation'))
                {
                    $metadata = Conversation::getMetadata();
                    $metadata['Conversation']['relations']['comments'] =
                        array(RedBeanModel::HAS_MANY,  'Comment', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_POLYMORPHIC, 'relatedModel');
                    $metadata['Conversation']['relations']['files'] =
                        array(RedBeanModel::HAS_MANY,  'FileModel', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_POLYMORPHIC, 'relatedModel');
                    Conversation::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('ConversationsModule'))
                {
                    $metadata = ConversationsModule::getMetadata();
                    unset($metadata['global']['tabMenuItems']);

                    $metadata['global']['shortcutsCreateMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('ConversationsModule', 'Conversation')",
                            'url'    => array('/conversations/default/create'),
                            'right'  => ConversationsModule::RIGHT_CREATE_CONVERSATIONS,
                            'mobile' => true,
                        ),
                    );
                    ConversationsModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('DesignerModule'))
                {
                    $metadata = DesignerModule::getMetadata();
                    $metadata['global']['configureMenuItems'] = array(
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('DesignerModule', 'Designer')",
                            'descriptionLabel' => "eval:Zurmo::t('DesignerModule', 'Manage module fields, layouts, and labels.')",
                            'route'            => '/designer/default',
                            'right'            => DesignerModule::RIGHT_ACCESS_DESIGNER,
                        ),
                    );
                    $metadata['global']['headerMenuItems'] = array(
                        array(
                            'label' => "eval:Zurmo::t('DesignerModule', 'Designer')",
                            'url' => array('/designer/default'),
                            'right' => DesignerModule::RIGHT_ACCESS_DESIGNER,
                            'order' => 1,
                            'mobile' => false,
                        ),
                    );
                    DesignerModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('EmailMessagesModule'))
                {
                    $metadata = EmailMessagesModule::getMetadata();
                    $metadata['global']['configureMenuItems'] = array(
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('EmailMessagesModule', 'Email Configuration')",
                            'descriptionLabel' => "eval:Zurmo::t('EmailMessagesModule', 'Manage Email Configuration')",
                            'route'            => '/emailMessages/default/configurationEdit',
                            'right'            => EmailMessagesModule::RIGHT_ACCESS_CONFIGURATION,
                        ),
                    );
                    if (isset($metadata['global']['headerMenuItems']))
                    {
                        unset($metadata['global']['headerMenuItems']);
                    }
                    $metadata['global']['userHeaderMenuItems'] = array(
                        array(
                            'label' => "eval:Zurmo::t('EmailMessagesModule', 'Data Cleanup')",
                            'url' => array('/emailMessages/default/matchingList'),
                            'right' => EmailMessagesModule::RIGHT_ACCESS_EMAIL_MESSAGES,
                            'order' => 3,
                        ),
                    );
                    $metadata['global']['configureSubMenuItems'] = array(
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('EmailMessagesModule', 'Email SMTP Configuration')",
                            'descriptionLabel' => "eval:Zurmo::t('EmailMessagesModule', 'Manage Email SMTP Configuration')",
                            'route'            => '/emailMessages/default/configurationEditOutbound',
                            'right'            => EmailMessagesModule::RIGHT_ACCESS_CONFIGURATION,
                        ),
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('EmailMessagesModule', 'Email Archiving Configuration')",
                            'descriptionLabel' => "eval:Zurmo::t('EmailMessagesModule', 'Manage Email Archiving Configuration')",
                            'route'            => '/emailMessages/default/configurationEditArchiving',
                            'right'            => EmailMessagesModule::RIGHT_ACCESS_CONFIGURATION,
                        ),
                    );
                    EmailMessagesModule::setMetadata($metadata);
                }

                if (GlobalMetadata::isClassMetadataSavedInDatabase('GamificationModule'))
                {
                    $metadata = GamificationModule::getMetadata();
                    $metadata['global']['userHeaderMenuItems'] = array(
                        array(
                            'label' => "eval:Zurmo::t('GamificationModule', 'Leaderboard')",
                            'url' => array('/gamification/default/leaderboard'),
                            'order' => 2,
                        ),
                    );
                    GamificationModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('HomeModule'))
                {
                    $metadata = HomeModule::getMetadata();
                    $metadata['global']['adminTabMenuItems'] = array(
                        array(
                            'label'       => "eval:Zurmo::t('HomeModule', 'Back to Application')",
                            'url'         => array('/home/default'),
                            'itemOptions' => array('class' => 'back-to-app-menu-item')
                        ),
                    );
                    $metadata['global']['tabMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('HomeModule', 'Home')",
                            'url'    => array('/home/default'),
                            'mobile' => true,
                        ),
                    );
                    HomeModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('ImportModule'))
                {
                    $metadata = ImportModule::getMetadata();
                    $metadata['global']['adminTabMenuItems'] = array(
                        array(
                            'label' => "eval:Zurmo::t('ImportModule', 'Import')",
                            'url'   => array('/import/default'),
                            'right' => ImportModule::RIGHT_ACCESS_IMPORT,
                        ),
                    );
                    $metadata['global']['configureMenuItems'] = array(
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('ImportModule', 'Import')",
                            'descriptionLabel' => "eval:Zurmo::t('ImportModule', 'Import data into Zurmo')",
                            'route'            => '/import/default',
                            'right'            => ImportModule::RIGHT_ACCESS_IMPORT,
                        ),
                    );
                    $metadata['global']['headerMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('ImportModule', 'Import')",
                            'url'    => array('/import/default'),
                            'right'  => ImportModule::RIGHT_ACCESS_IMPORT,
                            'order'  => 2,
                            'mobile' => false,
                        ),
                    );
                    ImportModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('GroupsModule'))
                {
                    $metadata = GroupsModule::getMetadata();
                    if (isset($metadata['global']['headerMenuItems']))
                    {
                        unset($metadata['global']['headerMenuItems']);
                    }

                    GroupsModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('JobsManagerModule'))
                {
                    $metadata = JobsManagerModule::getMetadata();
                    $metadata['global']['configureMenuItems'] = array(
                            array(
                                'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                                'titleLabel'       => "eval:Zurmo::t('JobsManagerModule', 'Job Manager')",
                                'descriptionLabel' => "eval:Zurmo::t('JobsManagerModule', 'Manage Scheduled Jobs')",
                                'route'            => '/jobsManager/default/list',
                                'right'            => JobsManagerModule::RIGHT_ACCESS_JOBSMANAGER,
                            ),
                        );
                    JobsManagerModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('LeadsModule'))
                {
                    $metadata = LeadsModule::getMetadata();
                    if (isset($metadata['global']['convertToAccountAttributesMapping']['owner']))
                    {
                        unset($metadata['global']['convertToAccountAttributesMapping']['owner']);
                    }

                    $metadata['global']['tabMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('LeadsModule', 'LeadsModulePluralLabel', \$translationParams)",
                            'url'    => array('/leads/default'),
                            'right'  => LeadsModule::RIGHT_ACCESS_LEADS,
                            'mobile' => true,
                        ),
                    );
                    $metadata['global']['shortcutsCreateMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('LeadsModule', 'LeadsModuleSingularLabel', \$translationParams)",
                            'url'    => array('/leads/default/create'),
                            'right'  => LeadsModule::RIGHT_CREATE_LEADS,
                            'mobile' => true,
                        ),
                    );
                    LeadsModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('MapsModule'))
                {
                    $metadata = MapsModule::getMetadata();
                    $metadata['global']['configureMenuItems'] = array(
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('MapsModule', 'Maps')",
                            'descriptionLabel' => "eval:Zurmo::t('MapsModule', 'Manage Map Configuration')",
                            'route'            => '/maps/default/configurationView',
                            'right'            => MapsModule::RIGHT_ACCESS_MAPS_ADMINISTRATION,
                        ),
                    );
                    MapsModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('MissionsModule'))
                {
                    $metadata = MissionsModule::getMetadata();
                    if (isset($metadata['global']['userHeaderMenuItems']))
                    {
                        unset($metadata['global']['userHeaderMenuItems']);
                    }
                    $metadata['global']['shortcutsCreateMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('MissionsModule', 'Mission')",
                            'url'    => array('/missions/default/create'),
                            'right'  => MissionsModule::RIGHT_CREATE_MISSIONS,
                            'mobile' => true,
                        ),
                    );
                    MissionsModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('OpportunitiesModule'))
                {
                    $metadata = OpportunitiesModule::getMetadata();
                    $metadata['global']['tabMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('OpportunitiesModule', 'OpportunitiesModulePluralLabel', \$translationParams)",
                            'url'    => array('/opportunities/default'),
                            'right'  => OpportunitiesModule::RIGHT_ACCESS_OPPORTUNITIES,
                            'mobile' => true,
                        ),
                    );
                    $metadata['global']['shortcutsCreateMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('OpportunitiesModule', 'OpportunitiesModuleSingularLabel', \$translationParams)",
                            'url'    => array('/opportunities/default/create'),
                            'right'  => OpportunitiesModule::RIGHT_CREATE_OPPORTUNITIES,
                            'mobile' => true,
                        ),
                    );
                    OpportunitiesModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('RolesModule'))
                {
                    $metadata = RolesModule::getMetadata();
                    if (isset($metadata['global']['headerMenuItems']))
                    {
                        unset($metadata['global']['headerMenuItems']);
                    }

                    RolesModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('UsersModule'))
                {
                    $metadata = UsersModule::getMetadata();
                    $metadata['global']['adminTabMenuItems'] = array(
                        array(
                            'label' => 'Users',
                            'url'   => array('/users/default'),
                            'right' => UsersModule::RIGHT_ACCESS_USERS,
                            'items' => array(
                                array(
                                    'label' => "eval:Zurmo::t('UsersModule', 'Create User')",
                                    'url'   => array('/users/default/create'),
                                    'right' => UsersModule::RIGHT_CREATE_USERS
                                ),
                                array(
                                    'label' => "eval:Zurmo::t('UsersModule', 'Users')",
                                    'url'   => array('/users/default'),
                                    'right' => UsersModule::RIGHT_ACCESS_USERS
                                ),
                            ),
                        ),
                    );
                    $metadata['global']['configureMenuItems'] = array(
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('UsersModule', 'Users')",
                            'descriptionLabel' => "eval:Zurmo::t('UsersModule', 'Manage Users')",
                            'route'            => '/users/default',
                            'right'            => UsersModule::RIGHT_ACCESS_USERS,
                        ),
                    );
                    $metadata['global']['headerMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('UsersModule', 'Users')",
                            'url'    => array('/users/default'),
                            'right'  => UsersModule::RIGHT_ACCESS_USERS,
                            'order'  => 4,
                            'mobile' => false,
                        ),
                    );
                    $metadata['global']['userHeaderMenuItems'] = array(
                        array(
                            'label' => "eval:Zurmo::t('UsersModule', 'My Profile')",
                            'url' => array('/users/default/profile'),
                            'order' => 1,
                        ),
                        array(
                            'label' => "eval:Zurmo::t('UsersModule', 'Sign out')",
                            'url' => array('/zurmo/default/logout'),
                            'order' => 4,
                        ),
                    );
                    UsersModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('ZurmoModule'))
                {
                    $metadata = ZurmoModule::getMetadata();
                    $metadata['global']['configureMenuItems'] = array(
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('ZurmoModule', 'Global Configuration')",
                            'descriptionLabel' => "eval:Zurmo::t('ZurmoModule', 'Manage Global Configuration')",
                            'route'            => '/zurmo/default/configurationEdit',
                            'right'            => ZurmoModule::RIGHT_ACCESS_GLOBAL_CONFIGURATION,
                        ),
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('ZurmoModule', 'Currency Configuration')",
                            'descriptionLabel' => "eval:Zurmo::t('ZurmoModule', 'Manage Currency Configuration')",
                            'route'            => '/zurmo/currency/configurationList',
                            'right'            => ZurmoModule::RIGHT_ACCESS_CURRENCY_CONFIGURATION,
                        ),
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('ZurmoModule', 'Languages')",
                            'descriptionLabel' => "eval:Zurmo::t('ZurmoModule', 'Manage Active Languages')",
                            'route'            => '/zurmo/language/configurationList',
                            'right'            => ZurmoModule::RIGHT_ACCESS_GLOBAL_CONFIGURATION,
                        ),
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('ZurmoModule', 'Developer Tools')",
                            'descriptionLabel' => "eval:Zurmo::t('ZurmoModule', 'Access Developer Tools')",
                            'route'            => '/zurmo/development/',
                            'right'            => ZurmoModule::RIGHT_ACCESS_GLOBAL_CONFIGURATION,
                        ),
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('ZurmoModule', 'Authentication Configuration')",
                            'descriptionLabel' => "eval:Zurmo::t('ZurmoModule', 'Manage Authentication Configuration')",
                            'route'            => '/zurmo/authentication/configurationEdit',
                            'right'            => ZurmoModule::RIGHT_ACCESS_GLOBAL_CONFIGURATION,
                        ),
                    );
                    $metadata['global']['headerMenuItems'] = array(
                        array(
                            'label'  => "eval:Zurmo::t('ZurmoModule', 'Settings')",
                            'url'    => array('/configuration'),
                            'right'  => ZurmoModule::RIGHT_ACCESS_ADMINISTRATION,
                            'order'  => 6,
                            'mobile' => false,
                        ),
                        array(
                            'label'  => "eval:Zurmo::t('ZurmoModule', 'Need Support?')",
                            'url'    => 'http://www.zurmo.com/needSupport.php',
                            'order'  => 9,
                            'mobile' => true,
                        ),
                        array(
                            'label'  => "eval:Zurmo::t('ZurmoModule', 'About Zurmo')",
                            'url'    => array('/zurmo/default/about'),
                            'order'  => 10,
                            'mobile' => true,
                        ),
                    );
                    $metadata['global']['configureSubMenuItems'] = array(
                        array(
                            'category'         => ZurmoModule::ADMINISTRATION_CATEGORY_GENERAL,
                            'titleLabel'       => "eval:Zurmo::t('ZurmoModule', 'LDAP Configuration')",
                            'descriptionLabel' => "eval:Zurmo::t('ZurmoModule', 'Manage LDAP Authentication')",
                            'route'            => '/zurmo/ldap/configurationEditLdap',
                            'right'            => ZurmoModule::RIGHT_ACCESS_GLOBAL_CONFIGURATION,
                        ),
                    );

                    $metadata['global']['adminTabMenuItemsModuleOrdering'] = array(
                        'home',
                        'configuration',
                        'designer',
                        'import',
                        'groups',
                        'users',
                        'roles',
                        'workflows',
                    );

                    $metadata['global']['tabMenuItemsModuleOrdering'] = array(
                        'home',
                        'mashableInbox',
                        'accounts',
                        'leads',
                        'contacts',
                        'opportunities',
                        'marketing',
                        'reports',
                    );

                    ZurmoModule::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('LdapConfigurationEditAndDetailsView'))
                {
                    $metadata = LdapConfigurationEditAndDetailsView::getMetadata();
                    $search = array('attributeName' => 'baseDomain');
                    if ($result = $this->findPositionOfElementInViewPanels($metadata, $search))
                    {
                        $metadata['global']['panels'][$result['panelKey']]['rows'][$result['rowKey']]['cells'][$result['cellKey']]['elements'][$result['elementKey']]['type'] = 'BaseDomain';
                    }
                    $search = array('attributeName' => 'host', 'type' => 'Text');
                    // We need to execute this, just to find position of panel
                    if ($result = $this->findPositionOfElementInViewPanels($metadata, $search))
                    {
                        $row = array(
                            'cells' => array(
                                array(
                                    'elements' => array(
                                        array(
                                            'attributeName' => 'serverType',
                                            'type' => 'LDAPAuthenticationServerTypeStaticStaticDropDown'
                                        )
                                    )
                                )
                            )
                        );
                        array_unshift($metadata['global']['panels'][$result['panelKey']]['rows'], $row);
                    }
                    LdapConfigurationEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('Mission'))
                {
                    $metadata = Mission::getMetadata();
                    $metadata['Mission']['relations']['comments'] =
                        array(RedBeanModel::HAS_MANY,  'Comment', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_POLYMORPHIC, 'relatedModel');
                    $metadata['Mission']['relations']['files'] =
                        array(RedBeanModel::HAS_MANY,  'FileModel', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_POLYMORPHIC, 'relatedModel');
                    $metadata['Mission']['relations']['takenByUser'] =
                        array(RedBeanModel::HAS_ONE,   'User', RedBeanModel::NOT_OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'takenByUser');
                    $metadata['Mission']['relations']['personsWhoHaveNotReadLatest'] =
                        array(RedBeanModel::HAS_MANY,  'PersonWhoHaveNotReadLatest',
                            RedBeanModel::OWNED);

                    foreach ($metadata['Mission']['members'] as $key => $member)
                    {
                        if ($member == 'ownerHasReadLatest' || $member == 'takenByUserHasReadLatest')
                        {
                            unset($metadata['Mission']['members'][$key]);
                        }
                    }
                    $metadata['Mission']['members'] = array_values($metadata['Mission']['members']);
                    foreach ($metadata['Mission']['rules'] as $key => $rule)
                    {
                        if ($rule[0] == 'ownerHasReadLatest' || $rule[0] == 'takenByUserHasReadLatest')
                        {
                            unset($metadata['Mission']['rules'][$key]);
                        }
                    }
                    $metadata['Mission']['rules'] = array_values($metadata['Mission']['rules']);
                    $metadata['Mission']['defaultSortAttribute'] = 'description';
                    foreach ($metadata['Mission']['noAudit'] as $key => $noAuditField)
                    {
                        if ($noAuditField == 'ownerHasReadLatest' || $noAuditField == 'takenByUserHasReadLatest')
                        {
                            unset($metadata['Mission']['noAudit'][$key]);
                        }
                    }
                    $metadata['Mission']['noAudit'] = array_values($metadata['Mission']['noAudit']);
                    Mission::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('Note'))
                {
                    $metadata = Note::getMetadata();
                    $metadata['Note']['relations']['files'] =
                        array(RedBeanModel::HAS_MANY,  'FileModel', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_POLYMORPHIC, 'relatedModel');
                    Note::setMetadata($metadata);
                }

                if (GlobalMetadata::isClassMetadataSavedInDatabase('MissionsListView'))
                {
                    $metadata = MissionsListView::getMetadata();
                    $search = array('attributeName' => 'status', 'type' => 'MissionStatus');
                    if ($result = $this->findPositionOfElementInViewPanels($metadata, $search))
                    {
                        unset($metadata['global']['panels'][$result['panelKey']]['rows'][$result['rowKey']]);
                        $metadata['global']['panels'][$result['panelKey']]['rows'] = array_values($metadata['global']['panels'][$result['panelKey']]['rows']);
                    }
                    MissionsListView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('MissionsPortletListView'))
                {
                    $metadata = MissionsPortletListView::getMetadata();
                    $search = array('attributeName' => 'status', 'type' => 'MissionStatus');
                    if ($result = $this->findPositionOfElementInViewPanels($metadata, $search))
                    {
                        unset($metadata['global']['panels'][$result['panelKey']]['rows'][$result['rowKey']]);
                        $metadata['global']['panels'][$result['panelKey']]['rows'] = array_values($metadata['global']['panels'][$result['panelKey']]['rows']);
                    }
                    MissionsPortletListView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('NotificationsForUserListView'))
                {
                    $metadata = NotificationsForUserListView::getMetadata();
                    $search = array('attributeName' => '', 'type' => 'DeleteNotification');
                    if ($result = $this->findPositionOfElementInViewPanels($metadata, $search))
                    {
                        unset($metadata['global']['panels'][$result['panelKey']]['rows'][$result['rowKey']]);
                        $metadata['global']['panels'][$result['panelKey']]['rows'] = array_values($metadata['global']['panels'][$result['panelKey']]['rows']);
                    }
                    NotificationsForUserListView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('UserChangeAvatarView'))
                {
                    $metadata = UserChangeAvatarView::getMetadata();
                    $search = array('type' => 'CancelLink');
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]);
                        $metadata['global']['toolbar']['elements'] = array_values($metadata['global']['toolbar']['elements']);
                    }
                    UserChangeAvatarView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('ZurmoConfigurationEditAndDetailsView'))
                {
                    $metadata = ZurmoConfigurationEditAndDetailsView::getMetadata();

                    $search = array('attributeName' => 'gamificationModalNotificationsEnabled', 'type' => 'CheckBox');
                    // We need to execute this, just to find position of panel
                    if ($result = $this->findPositionOfElementInViewPanels($metadata, $search))
                    {
                        $row = array(
                            'cells' => array(
                                array(
                                    'elements' => array(
                                        array(
                                            'attributeName' => 'userIdOfUserToRunWorkflowsAs',
                                            'type' => 'UserToRunWorkflowsAs'
                                        )
                                    )
                                )
                            )
                        );
                        $gamificationModalNotificationsEnabledRow = $metadata['global']['panels'][$result['panelKey']]['rows'][$result['rowKey']];
                        $metadata['global']['panels'][$result['panelKey']]['rows'][$result['rowKey']] = $row;

                        if (isset($metadata['global']['panels'][$result['panelKey']]['rows'][$result['rowKey'] + 1]))
                        {
                            $tempRes = $metadata['global']['panels'][$result['panelKey']]['rows'][$result['rowKey'] + 1];
                        }
                        $metadata['global']['panels'][$result['panelKey']]['rows'][$result['rowKey'] + 1] = $gamificationModalNotificationsEnabledRow;

                        if (isset($tempRes))
                        {
                            $metadata['global']['panels'][$result['panelKey']]['rows'][] = $tempRes;
                        }

                        $row = array(
                            'cells' => array(
                                array(
                                    'elements' => array(
                                        array(
                                            'attributeName' => 'null',
                                            'type' => 'SettingsLogoFileUpload'
                                        )
                                    )
                                )
                            )
                        );
                        $metadata['global']['panels'][$result['panelKey']]['rows'][] = $row;
                    }
                    ZurmoConfigurationEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('Opportunity'))
                {
                    $metadata = Opportunity::getMetadata();
                    $metadata['Opportunity']['relations']['amount'] =
                        array(RedBeanModel::HAS_ONE,   'CurrencyValue',    RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'amount');
                    $metadata['Opportunity']['relations']['stage'] =
                        array(RedBeanModel::HAS_ONE,   'OwnedCustomField', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'stage');
                    $metadata['Opportunity']['relations']['source'] =
                        array(RedBeanModel::HAS_ONE,   'OwnedCustomField', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'source');

                    $metadata['Opportunity']['derivedRelationsViaCastedUpModel']['meetings'] =
                        array(RedBeanModel::MANY_MANY, 'Meeting', 'activityItems');
                    $metadata['Opportunity']['derivedRelationsViaCastedUpModel']['notes'] =
                        array(RedBeanModel::MANY_MANY, 'Note',    'activityItems');
                    $metadata['Opportunity']['derivedRelationsViaCastedUpModel']['tasks'] =
                        array(RedBeanModel::MANY_MANY, 'Task',    'activityItems');
                    Opportunity::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('Meeting'))
                {
                    $metadata = Meeting::getMetadata();
                    $metadata['Meeting']['relations']['category'] =
                        array(RedBeanModel::HAS_ONE, 'OwnedCustomField', RedBeanModel::OWNED,
                            RedBeanModel::LINK_TYPE_SPECIFIC, 'category');
                    Meeting::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('GroupEditAndDetailsView'))
                {
                    $metadata = GroupEditAndDetailsView::getMetadata();
                    $metadata['global']['toolbar']['elements'][] = array('type'           => 'GroupDeleteLink');
                    GroupEditAndDetailsView::setMetadata($metadata);
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('UserConfigurationEditView'))
                {
                    $metadata = UserConfigurationEditView::getMetadata();

                    $row = array(
                        'cells' => array(
                            array(
                                'elements' => array(
                                    array(
                                        'attributeName' => 'null',
                                        'type' => 'MenuItemsSelection'
                                    )
                                )
                            )
                        )
                    );
                    $metadata['global']['panels'][]['rows'][] = $row;
                    UserConfigurationEditView::setMetadata($metadata);
                }
            }
        }

        /**
         * Update schema.
         */
        public function processUpdateSchema($messageLogger)
        {
            // We must update schema via command line, to ensure that newly
            // copied files are loaded into application correctly.
            $zurmoVersionBeforeUpgrade = UpgradeUtil::getUpgradeState('zurmoVersionBeforeUpgrade');
            if ($this->shouldRunTasksByVersion($zurmoVersionBeforeUpgrade, '1.5.15'))
            {
                InstallUtil::runAutoBuildFromUpdateSchemaCommand($messageLogger);
                ReadPermissionsOptimizationUtil::rebuild();
            }
        }

        /**
         * Tasks to be executed after update schema
         */
        public function processAfterUpdateSchema()
        {
            $zurmoVersionBeforeUpgrade = UpgradeUtil::getUpgradeState('zurmoVersionBeforeUpgrade');
            if ($this->shouldRunTasksByVersion($zurmoVersionBeforeUpgrade, '1.5.15'))
            {
                // Update LDAP settings
                if (Yii::app()->authenticationHelper->ldapEnabled)
                {
                    Yii::app()->authenticationHelper->ldapServerType = ZurmoAuthenticationHelper::SERVER_TYPE_OPEN_LDAP;
                    Yii::app()->authenticationHelper->setLdapSettings();
                }
            }
        }

        /**
         * Set first element of Toolbar elements to be SaveButton, and second CancelLink
         * @param array $metadata
         * @param string $elementType
         * @param integer $position
         */
        protected function setSaveButtonAndCancelLinkOnBegingOfViewToolbarElementArray(&$metadata, $elementType, $position)
        {
            $search = array('type' => $elementType);
            if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
            {
                $temp = $metadata['global']['toolbar']['elements'][$position];
                $metadata['global']['toolbar']['elements'][$position] = $metadata['global']['toolbar']['elements'][$result['elementKey']];
                $metadata['global']['toolbar']['elements'][$result['elementKey']] = $temp;
            }
        }
    }
?>
