<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2014 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2014. All rights reserved".
     ********************************************************************************/

    require_once 'BaseUpgraderComponent.php';

    // TODO: @Shoaibi: Critical: Add type hinting
    // TODO: @Shoaibi: Critical: find unused functions
    // TODO: @Shoaibi: Critical: Coding violations
    class UpgraderComponent extends BaseUpgraderComponent
    {
        public function processBeforeConfigFiles()
        {
            parent::processBeforeConfigFiles();
            Yii::app()->gameHelper->enabled = false;
        }

        /**
         * Process any config file changes
         * @param $pathToConfigurationFolder
         */
        public function processConfigFiles($pathToConfigurationFolder)
        {
            parent::processConfigFiles($pathToConfigurationFolder);
            // FORCE_NO_FREEZE and relevant configs are gone due to removal of no-freeze mode
            // from, almost, everywhere.
        }

        /**
         * Carry out any metadata changes tasks
         */
        public function processBeforeUpdateSchema()
        {
            parent::processBeforeUpdateSchema();
            if ($this->shouldRunTasksByVersion('2.6.0'))
            {
                $this->editNonPlaceableAttributeNamesForAccountEditAndDetailsViewMetadata();
                $this->editNonPlaceableAttributeNamesForAccountsListViewMetadata();
                $this->addRelationshipsToAccountMetadata();
                $this->addDefaultDataForAccountContactAffiliation();
                $this->updateContactsModuleMetadata();
                $this->updateAccountsModuleMetadata();
                $this->editCampaignMetadata();
                $this->editNonPlaceableAttributeNamesForMeetingEditAndDetailsViewMetadata();
                $this->addRelationshipsToContactMetadata();
                $this->editNonPlaceableAttributeNamesForLeadEditAndDetailsViewMetadata();
                $this->editProjectMetadata();
                $this->editMeetingMetadata();
                $this->updateProjectStatuses();
            }
			if ($this->shouldRunTasksByVersion('2.6.5'))
            {
                $this->editMeetingMetadataDescriptionElement();
                $this->editTaskMetadataRules();
            }
            if ($this->shouldRunTasksByVersion('2.6.0') && Yii::app()->edition == 'Commercial')
            {
                $this->updateQueueDistributionTypes();
                $this->editImplicitSyncModuleData();
                $this->editQueueModelMetadata();
                $this->editQueuesModuleMetadata();
            }
        }

        /**
         * Carry out any tasks that need to be done after updateSchema, say renaming columns, migrating data...
         */
        public function processAfterUpdateSchema()
        {
            parent::processAfterUpdateSchema();
        }

        protected function editNonPlaceableAttributeNamesForAccountEditAndDetailsViewMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('AccountEditAndDetailsView'))
            {
                $metadata = AccountEditAndDetailsView::getMetadata();
                $metadata['global']['nonPlaceableAttributeNames'] = array('account', 'owner', 'latestActivityDateTime');
                AccountEditAndDetailsView::setMetadata($metadata);
            }
        }

        protected function editNonPlaceableAttributeNamesForAccountsListViewMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('AccountsListView'))
            {
                $metadata = AccountsListView::getMetadata();
                $metadata['global']['nonPlaceableAttributeNames'] = array('account');
                AccountsListView::setMetadata($metadata);
            }
        }

        protected function updateAccountsModuleMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('AccountsModule'))
            {
                $metadata = AccountsModule::getMetadata();
                $metadata['global']['updateLatestActivityDateTimeWhenATaskIsCompleted'] = true;
                $metadata['global']['updateLatestActivityDateTimeWhenANoteIsCreated'] = true;
                $metadata['global']['updateLatestActivityDateTimeWhenAnEmailIsSentOrArchived'] = true;
                $metadata['global']['updateLatestActivityDateTimeWhenAMeetingIsInThePast'] = true;
                AccountsModule::setMetadata($metadata);
            }
        }

        protected function updateContactsModuleMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('ContactsModule'))
            {
                $metadata = ContactsModule::getMetadata();
                $metadata['global']['updateLatestActivityDateTimeWhenATaskIsCompleted'] = true;
                $metadata['global']['updateLatestActivityDateTimeWhenANoteIsCreated'] = true;
                $metadata['global']['updateLatestActivityDateTimeWhenAnEmailIsSentOrArchived'] = true;
                $metadata['global']['updateLatestActivityDateTimeWhenAMeetingIsInThePast'] = true;
                ContactsModule::setMetadata($metadata);
            }
        }

        protected function addRelationshipsToAccountMetadata()
        {
            $metadataChanges = array(
                'relations' => array(
                    'primaryAccountAffiliations' => array(
                        RedBeanModel::HAS_MANY,
                        'AccountAccountAffiliation',
                        RedBeanModel::OWNED,
                        RedBeanModel::LINK_TYPE_SPECIFIC,
                        'primaryAccountAffiliation'
                    ),
                    'secondaryAccountAffiliations' => array(
                        RedBeanModel::HAS_MANY,
                        'AccountAccountAffiliation',
                        RedBeanModel::OWNED,
                        RedBeanModel::LINK_TYPE_SPECIFIC,
                        'secondaryAccountAffiliation'
                    ),
                    'contactAffiliations'          => array(
                        RedBeanModel::HAS_MANY,
                        'AccountContactAffiliation',
                        RedBeanModel::OWNED,
                        RedBeanModel::LINK_TYPE_SPECIFIC,
                        'accountAffiliation'
                    ),
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Account', $metadataChanges);
        }

        protected function addDefaultDataForAccountContactAffiliation()
        {
            $dataMaker = new AccountContactAffiliationsDefaultDataMaker();
            $dataMaker->make();
        }

        protected function editCampaignMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('Campaign'))
            {
                $metadata = Campaign::getMetadata();
                unset($metadata['Campaign']['elements']['sendDateTime']);
                foreach ($metadata['Campaign']['rules'] as $key => $rule)
                {
                    if ($rule[0] == 'htmlContent' && $rule[1] == 'AtLeastOneContentAreaRequiredValidator')
                    {
                        unset($metadata['Campaign']['rules'][$key]);
                    }
                    if ($rule[0] == 'textContent' && $rule[1] == 'AtLeastOneContentAreaRequiredValidator')
                    {
                        unset($metadata['Campaign']['rules'][$key]);
                    }
                    if ($rule[0] == 'htmlContent' && $rule[1] == 'CampaignMergeTagsValidator')
                    {
                        unset($metadata['Campaign']['rules'][$key]);
                    }
                    if ($rule[0] == 'textContent' && $rule[1] == 'CampaignMergeTagsValidator')
                    {
                        unset($metadata['Campaign']['rules'][$key]);
                    }
                }
                Campaign::setMetadata($metadata);
            }
            $metadataChanges = array(
                'elements' => array(
                    'sendOnDateTime' => 'DateTime'
                ),
                'rules' => array(
                    24 => array('htmlContent',            'AtLeastOneContentAreaRequiredValidator', 'except' => 'searchModel'),
                    25 => array('textContent',            'AtLeastOneContentAreaRequiredValidator', 'except' => 'searchModel'),
                    26 => array('htmlContent',            'CampaignMergeTagsValidator', 'except' => 'searchModel'),
                    27 => array('textContent',            'CampaignMergeTagsValidator', 'except' => 'searchModel'),
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Campaign', $metadataChanges);
        }

        protected function editNonPlaceableAttributeNamesForMeetingEditAndDetailsViewMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('MeetingEditAndDetailsView'))
            {
                $metadata = MeetingEditAndDetailsView::getMetadata();
                $metadata['global']['nonPlaceableAttributeNames'] = array('processedForLatestActivity', 'latestDateTime', 'owner');
                MeetingEditAndDetailsView::setMetadata($metadata);
            }
        }

        protected function addRelationshipsToContactMetadata()
        {
            $metadataChanges = array(
                'relations' => array(
                    'accountAffiliations' => array(
                        RedBeanModel::HAS_MANY,
                        'AccountContactAffiliation',
                        RedBeanModel::OWNED,
                        RedBeanModel::LINK_TYPE_SPECIFIC,
                        'contactAffiliation'
                    ),
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Contact', $metadataChanges);
        }

        protected function editNonPlaceableAttributeNamesForLeadEditAndDetailsViewMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('LeadEditAndDetailsView'))
            {
                $metadata = LeadEditAndDetailsView::getMetadata();
                $metadata['global']['nonPlaceableAttributeNames'] = array(
                    'title',
                    'firstName',
                    'lastName',
                    'state',
                    'account',
                    'owner',
                    'latestActivityDateTime');
                LeadEditAndDetailsView::setMetadata($metadata);
            }
        }

        protected function editProjectMetadata()
        {
            $metadataChanges = array(
                'rules' => array(
                    6   => array('status', 'required'),
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Project', $metadataChanges);
        }

        protected function updateZurmoModuleMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('ZurmoModule'))
            {
                $metadata = ZurmoModule::getMetadata();
                $metadata['global']['configureMenuItems'] = array(
                    'title',
                    'firstName',
                    'lastName',
                    'state',
                    'account',
                    'owner',
                    'latestActivityDateTime');
                ZurmoModule::setMetadata($metadata);
            }
        }

        protected function editMeetingMetadata()
        {
            $metadataChanges = array(
                'members' => array(
                    2   => 'processedForLatestActivity',
                ),
                'rules' => array(
                    3 => array('processedForLatestActivity', 'boolean'),
                ),
                'noAudit' => array(
                    1 => 'processedForLatestActivity'
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Meeting', $metadataChanges);
        }

        protected function editMeetingMetadataDescriptionElement()
        {
            $metadataChanges = array(
                'elements' => array(
                    'description'   => 'TextArea'
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Meeting', $metadataChanges);
        }

        protected function editTaskMetadataRules()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('Task'))
            {
                $metadata = Task::getMetadata();
                foreach ($metadata['Task']['rules'] as $key => $rule)
                {
                    if ($rule[0] == 'name' && $rule[1] == 'length' )
                    {
                        unset($metadata['Task']['rules'][$key]);
                        //$metadata['Task']['rules'][$key] = array('name', 'length',  'min'  => 1, 'max' => 128);
                    }
                }
                Task::setMetadata($metadata);
            }

            $metadataChanges = array(
                'rules' => array(
                    6   => array('name', 'length',  'min'  => 1, 'max' => 128),
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Task', $metadataChanges);
        }

        protected function updateProjectStatuses()
        {
            ZurmoRedBean::exec('update `project` set `status`=2 where `status`=0');
        }

        /**
         * Provided a model class name and metachanges array, apply changes to the metadata saved in db.
         * @param $className
         * @param array $metadataChanges
         */
        protected function updateModelMetadataWithNewMetaDefinition($className, array $metadataChanges)
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase($className))
            {
                // list of keys we can handle change requested enclosed in metadataChanges array
                $validMetadataChangesKeys   = array('members', 'rules', 'relations', 'elements', 'noAudit');
                $metadata                   = $className::getMetadata();
                $ownMetadata                = $metadata[$className];
                // loop through valid keys one by one
                foreach ($validMetadataChangesKeys as $key)
                {
                    // this shouldn't happen, i mean why would i declared metadataChanges for member but no specifications?
                    // still, time has proven me wrong when date changes and i still decide to finish up some code.
                    if (!isset($metadataChanges[$key]))
                    {
                        continue;
                    }
                    // get the change requests for current key.
                    $metadataChangesForCurrentKey   = $metadataChanges[$key];
                    // initialized own metadata for that key to an empty array
                    $ownMetadataForCurrentKey       = array();
                    if (isset($ownMetadata[$key]))
                    {
                        // oh, wait, we found metadata for the key in question, lets grab it from there.
                        $ownMetadataForCurrentKey       = $ownMetadata[$key];
                    }
                    // looping through change requests one by one, $position tells us where
                    // to add and $newItem is what to add
                    foreach ($metadataChangesForCurrentKey as $position => $newItem)
                    {
                        // cool, add it into array.
                        $this->insertIntoArray($ownMetadataForCurrentKey, $newItem, $position);
                    }
                    // assigned it back to $ownMetadata, we could check if $ownMetadataForCurrentKey is not empty
                    // and only assigned it back then but not worth the effort. if it was empty, nature wanted it
                    // that way.
                    $ownMetadata[$key]              = $ownMetadataForCurrentKey;
                }
                // assigned ownMetadata back, we could check if ownMetadata was modified at all but again, not worth it.
                // plus, we know that it was modified, we never sent empty $metadataChanges
                $metadata[$className] = $ownMetadata;
                $className::setMetadata($metadata);
            }
        }

        /**
         * Push an element at a specific position in an array.
         * If its integer position, then push any element on provided position to next index and place provided
         * element at position.
         * If its string key, say its for relations, then just replace the old value
         * @param array $array
         * @param $element
         * @param $position
         */
        protected function insertIntoArray(array & $array, $element, $position)
        {
            if (is_int($position))
            {
                $array = CMap::mergeArray(array_slice($array, 0, $position), array($element), array_slice($array, $position));
            }
            else
            {
                $array[$position] = $element;
            }
        }

        protected function updateQueueDistributionTypes()
        {
            ZurmoRedBean::exec('update `queuemodel` set `distributionruletype`="Manual" where `distributionruletype`="1"');
            ZurmoRedBean::exec('update `queuemodel` set `distributionruletype`="RoundRobin" where `distributionruletype`="2"');
        }

        protected function editImplicitSyncModuleData()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('ImplicitSyncModule'))
            {
                $metadata = ImplicitSyncModule::getMetadata();
                $metadata['global']['configureSubMenuItems'][0]['route'] = '/implicitSync/configuration/serverInfoConfiguration';
                ImplicitSyncModule::setMetadata($metadata);
            }
        }

        protected function editQueueModelMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('QueueModel'))
            {
                $metadata = QueueModel::getMetadata();
                foreach ($metadata['QueueModel']['rules'] as $key => $rule)
                {
                    if ($rule[0] == 'distributionRuleType' && $rule[1] == 'type' )
                    {
                        unset($metadata['QueueModel']['rules'][$key]);
                    }
                    if ($rule[0] == 'distributionRuleType' && $rule[1] == 'numerical' )
                    {
                        unset($metadata['QueueModel']['rules'][$key]);
                    }
                }
                QueueModel::setMetadata($metadata);
            }

            $metadataChanges = array(
                'rules' => array(
                    4 => array('distributionRuleType', 'type', 'type' => 'string'),
                    5 => array('name', 'length',  'max' => 64),
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('QueueModel', $metadataChanges);
        }

        protected function editQueuesModuleMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('QueuesModule'))
            {
                $metadata = QueuesModule::getMetadata();
                $metadata['global']['enabledDistributionRulesTypes'] = array(
                    QueueModel::RULE_TYPE_NONE,
                    QueueModel::RULE_TYPE_ROUND_ROBIN
                );
                QueuesModule::setMetadata($metadata);
            }
        }

        /**
         * List Classes for which metadata changed but we can safely purge the metadata saved in db
         * @return array
         */
        protected function getModelClassNamesToPurgeGlobalMetadata()
        {
            // format: version => model class names to purge globalmetadata for.
            $models = array(
                '2.6.0' => array(
                    'AccountsMassEditView',
                    'AccountsModalListView',
                    'AccountsModalSearchView',
                    'AccountsModuleEditView',
                    'AccountsModuleEditView',
                    'BounceConfigurationEditAndDetailsView',
                    'ContactsMassEditView',
                    'ContactInlineCreateForArchivedEmailCreateView',
                    'ContactsModuleEditView',
                    'CreateEmailMessageModalEditView',
                    'EmailArchivingConfigurationEditAndDetailsView',
                    'EmailSmtpConfigurationEditAndDetailsView',
                    'GameRewardsMassEditView',
                    'LdapConfigurationEditAndDetailsView',
                    'LeadsMassEditView',
                    'LeadsMergedEditAndDetailsView',
                    'LeadsModuleEditView',
                    'MapConfigurationView',
                    'MarketingConfigurationEditAndDetailsView',
                    'OpenTasksForAccountRelatedListView',
                    'OpenTasksForContactRelatedListView',
                    'OpenTasksForOpportunityRelatedListView',
                    'OpportunitiesMassEditView',
                    'OpportunitiesModuleEditView',
                    'ProductTemplatesModuleEditView',
                    'ProductsModuleEditView',
                    'ProjectsMassEditView',
                    'ProjectsModuleEditView',
                    'SocialItemInlineEditView',
                    'TaskModalDetailsView',
                    'TasksMassEditView',
                    'TasksModuleEditView',
                    'TasksSearchView',
                    'UserChangePasswordView',
                    'UserCreateView',
                    'UserConfigurationEditView',
                    'UserEditView',
                    'UserEmailConfigurationEditView',
                    'UsersMassEditView',
                    'ZurmoConfigurationEditAndDetailsView',
                    'MeetingsModuleEditView',
                    'NotesModuleEditView',),
            );
            if (Yii::app()->edition == 'Commercial')
            {
                $models['2.6.0'][] = 'LicenseManagerConfigurationView';
                $models['2.6.0'][] = 'FullContactConfigurationView';
                $models['2.6.0'][] = 'RapleafConfigurationView';
            }
            return $models;
        }
    }
?>