<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2014 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2014. All rights reserved".
     ********************************************************************************/

    require_once 'BaseUpgraderComponent.php';

    class UpgraderComponent extends BaseUpgraderComponent
    {
        /**
         * Carry out any metadata changes tasks
         */
        public function processBeforeUpdateSchema()
        {
            parent::processBeforeUpdateSchema();
            if ($this->shouldRunTasksByVersion('2.7.0'))
            {
                // 2.7.0 introduced the attendees relation. Update metadata for meetings.
                $this->updateMeetingsMetadataForUserAttendeesRelation();
            }
            if ($this->shouldRunTasksByVersion('2.7.3'))
            {

                // 2.7.3
                $this->updateTasksModuleMetadata();
                $this->updateTaskModelAddDescriptionElementMetadata();
            }
        }

        /**
         * Carry out any tasks that need to be done after updateSchema, say renaming columns, migrating data...
         */
        public function processAfterUpdateSchema()
        {
            parent::processAfterUpdateSchema();
            if ($this->shouldRunTasksByVersion('2.7.0'))
            {
                // set default builtType for existing ones to pasted html
                $this->setDefaultBuiltTypeForExistingTemplates();

                // set isdraft for existing templates to f0
                $this->setIsDraftToZeroForExistingTemplates();
                // add predefined templates
                $this->addPredefinedEmailTemplates();
            }
        }

        /**
         * Set default builtType for existing templates.
         */
        protected function setDefaultBuiltTypeForExistingTemplates()
        {
            $query  = $this->resolveSetDefaultBuiltTypeForExistingTemplates();
            ZurmoRedBean::exec($query);
        }

        /**
         * Resolve query to set default builtType for existing templates.
         */
        protected function resolveSetDefaultBuiltTypeForExistingTemplates()
        {
            $defaultBuiltType   = $this->resolveDefaultBuiltType();
            $tableName          = EmailTemplate::getTableName();
            $columnName         = 'builttype';
            $query              = "update $tableName set $columnName = $defaultBuiltType where ";
            $query              .= "$columnName is null;";
            return $query;
        }

        /**
         * Resolve default builtType for emailTemplates
         */
        protected function resolveDefaultBuiltType()
        {
            return EmailTemplate::BUILT_TYPE_PASTED_HTML;
        }

        /**
         * Set isdraft column to zero for existing templates
         */
        protected function setIsDraftToZeroForExistingTemplates()
        {
            $query  = $this->resolveSetIsDraftToZeroForExistingTemplates();
            ZurmoRedBean::exec($query);
        }

        /**
         * Resolve query to set isdraft to zero for existing templates.
         */
        protected function resolveSetIsDraftToZeroForExistingTemplates()
        {
            $tableName          = EmailTemplate::getTableName();
            $columnName         = 'isdraft';
            $query              = "update $tableName set $columnName = 0 where ";
            $query              .= "$columnName is null;";
            return $query;
        }

        /**
         * Add predefined email Templates
         */
        protected function addPredefinedEmailTemplates()
        {
            $defaultDataMaker   = new EmailTemplatesDefaultDataMaker();
            $defaultDataMaker->make();
        }

        /**
         * Update Meetings metadata for UserAttendees relation
         */
        protected function updateMeetingsMetadataForUserAttendeesRelation()
        {
            // this array is almost same as the metadata array in models except it used hardcoded indexes on which
            // an element should be placed. If an element exists at this index already, it would be pushed to next index.
            // Indices at which a member, rule, or noAudit attribute is listed does not matter, we just use hardcoded
            // integer values to make them appear in same order in db as they do in files. I didn't mention relations
            // here explicitly, because relations change requested in $metadataChanges always overwrite the existing
            // relation against that key.
            $metadataChanges = array(
                'relations' => array(
                    'userAttendees'        => array(RedBeanModel::MANY_MANY, 'User'),
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Meeting', $metadataChanges);
        }

        protected function updateTaskModelAddDescriptionElementMetadata()
        {
            $metadataChanges = array(
                'elements' => array(
                    'description'        => 'TextArea',
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Task', $metadataChanges);
        }

        protected function updateTasksModuleMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('TasksModule'))
            {
                $metadata = TasksModule::getMetadata();
                $metadata['global']['globalSearchAttributeNames'] = array(
                    'uniqueIdentifier',
                    'name',
                );
                TasksModule::setMetadata($metadata);
            }
        }

        protected function getModelClassNamesToPurgeGlobalMetadata()
        {
            // format: version => model class names to purge globalmetadata for.
            $models = array(
                '2.7.0' => array(
                    'ActiveProjectsPortletView',
                    'Autoresponder',
                    'AutoresponderEditAndDetailsView',
                    'Campaign',
                    'CampaignEditView',
                    'ContactWebFormEntryListView',
                    'CreateEmailMessageModalEditView',
                    'Currency',
                    'EmailMessageEditAndDetailsView',
                    'EmailTemplate',
                    'EmailTemplateEditAndDetailsView',
                    'EmailTemplatesListView',
                    'LeadsMassEditView',
                    'MarketingListEditView',
                    'UserEmailConfigurationEditView',
                ),
                '2.7.3' => array(
                    'AccountConvertToView',
                    'ActiveProjectsPortletView',
                    'Autoresponder',
                    'AutoresponderEditAndDetailsView',
                    'Campaign',
                    'CampaignEditView',
                    'CampaignItem',
                    'ContactWebFormEntryListView',
                    'CreateEmailMessageModalEditView',
                    'Currency',
                    'EmailMessageEditAndDetailsView',
                    'EmailTemplate',
                    'EmailTemplatesListView',
                    'LeadsMassEditView',
                    'MarketingListEditView',
                    'TaskModalDetailsView',
                    'TasksModuleEditView',
                    'UserEmailConfigurationEditView',
                ),
            );
            if (Yii::app()->edition == 'Commercial')
            {
                $models['2.7.0'][] = 'GoogleAppsConfigurationView';
            }
            return $models;
        }
    }
?>