<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2015 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2015. All rights reserved".
     ********************************************************************************/

    class MixedModelsSearchAndListView extends View
    {
        private $views;
        private $term;
        private $scopeData;

        public function __construct(Array $views, $term, $scopeData)
        {
            $this->views     = $views;
            $this->term      = $term;
            $this->scopeData = $scopeData;
        }

        protected function renderContent()
        {
            $content = '';
            $content = $this->renderSearchView();
            $content .= $this->renderListViews();
            $this->renderScripts();
            return $content;
        }

        protected function renderSearchView()
        {
            $moduleNamesAndLabels     = GlobalSearchUtil::
                                        getGlobalSearchScopingModuleNamesAndLabelsDataByUser(Yii::app()->user->userModel);
            $sourceUrl                = Yii::app()->createUrl('zurmo/default/globallist');
            GlobalSearchUtil::resolveModuleNamesAndLabelsDataWithAllOption(
                                        $moduleNamesAndLabels);
            $searchView = new MixedModelsSearchView($moduleNamesAndLabels, $sourceUrl, $this->term, $this->scopeData);
            return $searchView->render();
        }

        /**
         * Render a group of lists that contains the search result from GlobalList
         *
         */
        protected function renderListViews()
        {
            $rows = count($this->views);
            $gridView = new GridView($rows, 1);
            $row = 0;
            foreach ($this->views as $view)
            {
                $gridView->setView($view, $row++, 0);
            }
            return ZurmoHtml::tag('div', array('id' => 'MixedModelsMultipleListsView'), $gridView->render());
        }

        protected function renderScripts()
        {
            // Begin Not Coding Standard
            //On page ready load all the List View with data
            $script = "$(document).ready(function () {
                            $('#MixedModelsSearchView').find('a').click();
                       });";
            Yii::app()->clientScript->registerScript('LoadListViews', $script);
            // End Not Coding Standard
        }
    }
?>