/*
 * timeout-dialog.js v1.0.1, 01-03-2012
 *
 * @author: Rodrigo Neri (@rigoneri)
 *
 * (The MIT License)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


/* String formatting, you might want to remove this if you already use it.
 * Example:
 *
 * var location = 'World';
 * alert('Hello {0}'.format(location));
 */
String.prototype.format = function() {
  var s = this,
      i = arguments.length;

  while (i--) {
    s = s.replace(new RegExp('\\{' + i + '\\}', 'gm'), arguments[i]);
  }
  return s;
};

!function($) {
  $.timeoutDialog = function(options) {
    var settings = {
      timeout: 1200,
      countdown: 60,
      title : 'Your session is about to expire!',
      message : 'You will be logged out in {0} seconds.',
      question: 'Do you want to stay signed in?',
      keep_alive_button_text: 'Yes, Keep me signed in',
      sign_out_button_text: 'No, Sign me out',
      keep_alive_url: '/keep-alive',
      logout_url: null,
      logout_redirect_url: '/',
      restart_on_yes: true,
      dialog_width: 350,
      start_countdown_timestamp_cookie_name: 'StartCountdownTimestamp',
    }

    $.extend(settings, options);

    var TimeoutDialog = {
      init: function () {
        this.setupDialogTimer();
      },

      setupDialogTimer: function(timeout) {
        var self = this;
        if (typeof(timeout)==='undefined') timeout = settings.timeout;
        now = Math.round(new Date().getTime() / 1000);
        timestampStart = parseInt(now) + parseInt(timeout)  - parseInt(settings.countdown)  - 2;
        $.cookie(settings.start_countdown_timestamp_cookie_name, timestampStart, {path:  "/"});
        window.setTimeout(function() {
          self.setupDialog();
        }, (timeout - settings.countdown) * 1000);
      },

      setupDialog: function() {
        var self = this;
        self.destroyDialog();

        $('<div id="timeout-dialog" class="left-column full-width">' +
            '<p id="timeout-message">' + settings.message.format('<span id="timeout-countdown">' + settings.countdown + '</span>') + '</p>' +
            '<p id="timeout-question">' + settings.question + '</p>' +
            '<div class="float-bar"><div class="view-toolbar-container clearfix dock"><div class="form-toolbar">' +
            '<a href="#" id="timeout-keep-signin-btn" class="z-button"><span class="z-label">' + settings.keep_alive_button_text + '</span></a>' +
            '<a href="#" id="timeout-sign-out-button" class="z-button secondary-button"><span class="z-label">' + settings.sign_out_button_text + '</span></a>' +
            '</div></div></div></div>' +
            '</div>')
            .appendTo('body')
            .dialog({
              modal: true,
              width: settings.dialog_width,
              minHeight: 'auto',
              zIndex: 10000,
              closeOnEscape: false,
              draggable: false,
              resizable: false,
              dialogClass: 'timeout-dialog',
              title: settings.title
            });

        $('#timeout-keep-signin-btn').click(function(){ self.keepAlive(); });
        $('#timeout-sign-out-button').click(function(){ self.signOut(true); });
        $('.ui-dialog-titlebar-close .ui-button-text').remove();

        self.startCountdown();
      },

      destroyDialog: function() {
        if ($("#timeout-dialog").length) {
          $("#timeout-dialog").dialog("close");
          $('#timeout-dialog').remove();
        }
      },

      startCountdown: function() {
        var self = this,
            counter = settings.countdown;
        if (parseInt(Math.round(new Date().getTime() / 1000)) > parseInt($.cookie(settings.start_countdown_timestamp_cookie_name)))
        {
          this.countdown = window.setInterval(function () {
            counter -= 1;
            $("#timeout-countdown").html(counter);

            if (parseInt(Math.round(new Date().getTime() / 1000)) < parseInt($.cookie(settings.start_countdown_timestamp_cookie_name)))
            {
              window.clearInterval(self.countdown);
              self.destroyDialog();
              self.setupDialogTimer(parseInt($.cookie(settings.start_countdown_timestamp_cookie_name)) - parseInt(Math.round(new Date().getTime() / 1000)) + parseInt(settings.countdown));
            }
            if (counter <= 0) {
              window.clearInterval(self.countdown);
              self.signOut(false);
            }
          }, 1000);
        }
        else
        {
          self.destroyDialog();
          self.setupDialogTimer($.cookie(settings.start_countdown_timestamp_cookie_name) - Math.round(new Date().getTime() / 1000) + settings.countdown);
        }
      },

      keepAlive: function() {
        var self = this;
        this.destroyDialog();
        window.clearInterval(this.countdown);
        $.get(settings.keep_alive_url, function(data) {
          if (data != null) {
            if (settings.restart_on_yes) {
              self.setupDialogTimer();
            }
          }
          else {
            self.signOut(false);
          }
        });
      },

      signOut: function(is_forced) {
        var self = this;
        this.destroyDialog();
        if (settings.logout_url != null) {
          $.get(settings.logout_url, function(data){
            self.redirectLogout(is_forced);
          });
        }
        else {
          self.redirectLogout(is_forced);
        }
      },

      redirectLogout: function(is_forced){
        var target = settings.logout_redirect_url + '?next=' + encodeURIComponent(window.location.pathname + window.location.search);
        if (!is_forced)
          target += '&timeout=t';
        window.location = target;
      }
    };

    TimeoutDialog.init();
  };
}(window.jQuery);