<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2014 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2014. All rights reserved".
     ********************************************************************************/

    /**
     * Export module walkthrough tests.
     */
    class ProductsRegularUserExportWalkthroughTest extends ZurmoRegularUserWalkthroughBaseTest
    {
        protected static $asynchronousThreshold;

        public static function setUpBeforeClass()
        {
            parent::setUpBeforeClass();
            SecurityTestHelper::createSuperAdmin();
            $super = User::getByUsername('super');
            Yii::app()->user->userModel = $super;

            self::$asynchronousThreshold = ExportModule::$asynchronousThreshold;
            ExportModule::$asynchronousThreshold = 3;
            AllPermissionsOptimizationUtil::rebuild();
        }

        public static function tearDownAfterClass()
        {
            ExportModule::$asynchronousThreshold = self::$asynchronousThreshold;
            parent::tearDownAfterClass();
        }

        /**
         * Walkthrough test for synchronous download
         */
        public function testDownloadDefaultControllerActions()
        {
            $super = $this->logoutCurrentUserLoginNewUserAndGetByUsername('super');

            $products = array();
            for ($i = 0; $i < 2; $i++)
            {
                $products[] = ProductTestHelper::createProductByNameForOwner('superProduct' . $i, $super);
            }

            // Check if access is denied if user doesn't have access privileges at all to export actions
            Yii::app()->user->userModel = User::getByUsername('nobody');
            $nobody = $this->logoutCurrentUserLoginNewUserAndGetByUsername('nobody');

            $this->runControllerShouldResultInAccessFailureAndGetContent('products/default/list');
            $this->setGetArray(array(
                'Product_page' => '1',
                'export' => '',
                'ajax' => '',
                'selectAll' => '',
                'selectedIds' => '')
            );
            $this->runControllerShouldResultInAccessFailureAndGetContent('products/default/export');
            // Check if user have access to module action, but not to export action
            // Now test peon with elevated rights to accounts
            $nobody->setRight('ProductsModule', ProductsModule::RIGHT_ACCESS_PRODUCTS);
            $nobody->setRight('ProductsModule', ProductsModule::RIGHT_CREATE_PRODUCTS);
            $nobody->setRight('ProductsModule', ProductsModule::RIGHT_DELETE_PRODUCTS);
            $nobody->setRight('ExportModule', ExportModule::RIGHT_ACCESS_EXPORT);
            $this->assertTrue($nobody->save());

            // Check if access is denied if user doesn't have access privileges at all to export actions
            $nobody = $this->logoutCurrentUserLoginNewUserAndGetByUsername('nobody');
            Yii::app()->user->userModel = User::getByUsername('nobody');

            $this->runControllerWithNoExceptionsAndGetContent('products/default/list');
            $this->setGetArray(array(
                'Product_page' => '1',
                'export' => '',
                'ajax' => '',
                'selectAll' => '',
                'selectedIds' => '')
            );
            $response = $this->runControllerWithRedirectExceptionAndGetUrl('products/default/export');
            $this->assertTrue(strstr($response, 'products/default/index') !== false);

            $this->setGetArray(array(
                'ProductsSearchForm' => array(
                    'anyMixedAttributesScope' => array(0 => 'All'),
                    'anyMixedAttributes'      => '',
                    'name'                    => 'superProduct'
                ),
                'multiselect_ProductsSearchForm_anyMixedAttributesScope' => 'All',
                'Product_page'   => '1',
                'export'         => '',
                'ajax'           => '',
                'selectAll' => '1',
                'selectedIds' => '')
            );
              //TODO Need to ask jason
            $response = $this->runControllerWithRedirectExceptionAndGetUrl('products/default/export');
            $this->assertTrue(strstr($response, 'products/default/index') !== false);

            $this->setGetArray(array(
                'ProductsSearchForm' => array(
                    'anyMixedAttributesScope' => array(0 => 'All'),
                    'anyMixedAttributes'      => '',
                    'name'                    => 'superProduct'
                ),
                'multiselect_ProductsSearchForm_anyMixedAttributesScope' => 'All',
                'Product_page'   => '1',
                'export'         => '',
                'ajax'           => '',
                'selectAll' => '',
                'selectedIds' => "{$products[0]->id}, {$products[1]->id}")
            );
            $response = $this->runControllerWithRedirectExceptionAndGetUrl('products/default/export');
            $this->assertTrue(strstr($response, 'products/default/index') !== false);
            $this->assertContains('There is no data to export.',
            Yii::app()->user->getFlash('notification'));

            //give nobody access to read and write
            Yii::app()->user->userModel = $super;
            foreach ($products as $product)
            {
                $product->addPermissions($nobody, Permission::READ_WRITE_CHANGE_PERMISSIONS);
                AllPermissionsOptimizationUtil::securableItemGivenPermissionsForUser($product, $nobody);
                $this->assertTrue($product->save());
            }
            //Now the nobody user should be able to access the edit view and still the details view.
            Yii::app()->user->userModel = $nobody;

            $this->setGetArray(array(
                'ProductsSearchForm' => array(
                    'anyMixedAttributesScope' => array(0 => 'All'),
                    'anyMixedAttributes'      => '',
                    'name'                    => 'superProduct'
                ),
                'multiselect_ProductsSearchForm_anyMixedAttributesScope' => 'All',
                'Product_page'   => '1',
                'export'         => '',
                'ajax'           => '',
                'selectAll' => '1',
                'selectedIds' => '')
            );
              //TODO Need to ask jason
            $response = $this->runControllerWithExitExceptionAndGetContent('products/default/export');
            $this->assertEquals('Testing download.', $response);

            $this->setGetArray(array(
                'ProductsSearchForm' => array(
                    'anyMixedAttributesScope' => array(0 => 'All'),
                    'anyMixedAttributes'      => '',
                    'name'                    => 'superProduct'
                ),
                'multiselect_ProductsSearchForm_anyMixedAttributesScope' => 'All',
                'Product_page'   => '1',
                'export'         => '',
                'ajax'           => '',
                'selectAll' => '',
                'selectedIds' => "{$products[0]->id}, {$products[1]->id}")
            );
            $response = $this->runControllerWithExitExceptionAndGetContent('products/default/export');
            $this->assertEquals('Testing download.', $response);

            // No mathces
            $this->setGetArray(array(
                'ProductsSearchForm' => array(
                    'anyMixedAttributesScope' => array(0 => 'All'),
                    'anyMixedAttributes'      => '',
                    'name'                    => 'missingName'
                ),
                'multiselect_ProductsSearchForm_anyMixedAttributesScope' => 'All',
                'Product_page' => '1',
                'export'       => '',
                'ajax'         => '',
                'selectAll' => '1',
                'selectedIds' => '')
            );
            $response = $this->runControllerWithRedirectExceptionAndGetUrl('products/default/export');
            $this->assertTrue(strstr($response, 'products/default/index') !== false);
        }
    }
?>