-- MySQL dump 10.13  Distrib 5.5.49, for Linux (x86_64)
--
-- Host: localhost    Database: zurmo327
-- ------------------------------------------------------
-- Server version	5.5.49

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `__role_children_cache`
--

DROP TABLE IF EXISTS `__role_children_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `__role_children_cache` (
  `permitable_id` int(11) NOT NULL DEFAULT '0',
  `role_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`permitable_id`,`role_id`),
  UNIQUE KEY `permitable_id` (`permitable_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__role_children_cache`
--

LOCK TABLES `__role_children_cache` WRITE;
/*!40000 ALTER TABLE `__role_children_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `__role_children_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_group`
--

DROP TABLE IF EXISTS `_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_group` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permitable_id` int(11) unsigned DEFAULT NULL,
  `_group_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_eman` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_group`
--

LOCK TABLES `_group` WRITE;
/*!40000 ALTER TABLE `_group` DISABLE KEYS */;
INSERT INTO `_group` VALUES (1,'Super Administrators',2,NULL),(2,'Everyone',3,NULL);
/*!40000 ALTER TABLE `_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_group__user`
--

DROP TABLE IF EXISTS `_group__user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_group__user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `_group_id` int(11) unsigned DEFAULT NULL,
  `_user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_resu__di_puorg_` (`_group_id`,`_user_id`),
  KEY `di_puorg_` (`_group_id`),
  KEY `di_resu_` (`_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_group__user`
--

LOCK TABLES `_group__user` WRITE;
/*!40000 ALTER TABLE `_group__user` DISABLE KEYS */;
INSERT INTO `_group__user` VALUES (1,1,1),(2,1,2);
/*!40000 ALTER TABLE `_group__user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_right`
--

DROP TABLE IF EXISTS `_right`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_right` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `modulename` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` tinyint(11) DEFAULT NULL,
  `permitable_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_right`
--

LOCK TABLES `_right` WRITE;
/*!40000 ALTER TABLE `_right` DISABLE KEYS */;
INSERT INTO `_right` VALUES (1,'UsersModule','Login Via Web',1,3),(2,'UsersModule','Login Via Mobile',1,3),(3,'UsersModule','Login Via Web API',1,3),(4,'AccountsModule','Access Accounts Tab',1,3),(5,'AccountsModule','Create Accounts',1,3),(6,'AccountsModule','Delete Accounts',1,3),(7,'CampaignsModule','Access Campaigns Tab',1,3),(8,'CampaignsModule','Create Campaigns',1,3),(9,'CampaignsModule','Delete Campaigns',1,3),(10,'ContactsModule','Access Contacts Tab',1,3),(11,'ContactsModule','Create Contacts',1,3),(12,'ContactsModule','Delete Contacts',1,3),(13,'ConversationsModule','Access Conversations Tab',1,3),(14,'ConversationsModule','Create Conversations',1,3),(15,'ConversationsModule','Delete Conversations',1,3),(16,'EmailMessagesModule','Access Emails Tab',1,3),(17,'EmailMessagesModule','Create Emails',1,3),(18,'EmailMessagesModule','Delete Emails',1,3),(19,'EmailTemplatesModule','Access Email Templates',1,3),(20,'EmailTemplatesModule','Create Email Templates',1,3),(21,'EmailTemplatesModule','Delete Email Templates',1,3),(22,'LeadsModule','Access Leads Tab',1,3),(23,'LeadsModule','Create Leads',1,3),(24,'LeadsModule','Delete Leads',1,3),(25,'LeadsModule','Convert Leads',1,3),(26,'OpportunitiesModule','Access Opportunities Tab',1,3),(27,'OpportunitiesModule','Create Opportunities',1,3),(28,'OpportunitiesModule','Delete Opportunities',1,3),(29,'MarketingModule','Access Marketing Tab',1,3),(30,'MarketingListsModule','Access Marketing Lists Tab',1,3),(31,'MarketingListsModule','Create Marketing Lists',1,3),(32,'MarketingListsModule','Delete Marketing Lists',1,3),(33,'MeetingsModule','Access Meetings',1,3),(34,'MeetingsModule','Create Meetings',1,3),(35,'MeetingsModule','Delete Meetings',1,3),(36,'MissionsModule','Access Missions Tab',1,3),(37,'MissionsModule','Create Missions',1,3),(38,'MissionsModule','Delete Missions',1,3),(39,'NotesModule','Access Notes',1,3),(40,'NotesModule','Create Notes',1,3),(41,'NotesModule','Delete Notes',1,3),(42,'ReportsModule','Access Reports Tab',1,3),(43,'ReportsModule','Create Reports',1,3),(44,'ReportsModule','Delete Reports',1,3),(45,'TasksModule','Access Tasks',1,3),(46,'TasksModule','Create Tasks',1,3),(47,'TasksModule','Delete Tasks',1,3),(48,'HomeModule','Access Dashboards',1,3),(49,'HomeModule','Create Dashboards',1,3),(50,'HomeModule','Delete Dashboards',1,3),(51,'ExportModule','Access Export Tool',1,3),(52,'SocialItemsModule','Access Social Items',1,3),(53,'ProductsModule','Access Products Tab',1,3),(54,'ProductsModule','Create Products',1,3),(55,'ProductsModule','Delete Products',1,3),(56,'ProductTemplatesModule','Access Catalog Items Tab',1,3),(57,'ProductTemplatesModule','Create Catalog Items',1,3),(58,'ProductTemplatesModule','Delete Catalog Items',1,3),(59,'ProjectsModule','Access Projects Tab',1,3),(60,'ProjectsModule','Create Projects',1,3),(61,'ProjectsModule','Delete Projects',1,3),(62,'CalendarsModule','Access Calandar Tab',1,3),(63,'CalendarsModule','Create Calendar',1,3),(64,'CalendarsModule','Delete Calendar',1,3),(65,'UsersModule','Login Via Mobile',2,4),(66,'UsersModule','Login Via Web',2,4),(67,'UsersModule','Login Via Web API',2,4);
/*!40000 ALTER TABLE `_right` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_user`
--

DROP TABLE IF EXISTS `_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `locale` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `timezone` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `username` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serializedavatardata` text COLLATE utf8_unicode_ci,
  `isactive` tinyint(1) unsigned DEFAULT NULL,
  `isrootuser` tinyint(1) unsigned DEFAULT NULL,
  `hidefromselecting` tinyint(1) unsigned DEFAULT NULL,
  `issystemuser` tinyint(1) unsigned DEFAULT NULL,
  `hidefromleaderboard` tinyint(1) unsigned DEFAULT NULL,
  `lastlogindatetime` datetime DEFAULT NULL,
  `permitable_id` int(11) unsigned DEFAULT NULL,
  `person_id` int(11) unsigned DEFAULT NULL,
  `currency_id` int(11) unsigned DEFAULT NULL,
  `manager__user_id` int(11) unsigned DEFAULT NULL,
  `role_id` int(11) unsigned DEFAULT NULL,
  `secondaryemail_email_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_emanresu` (`username`),
  KEY `permitable_id` (`permitable_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_user`
--

LOCK TABLES `_user` WRITE;
/*!40000 ALTER TABLE `_user` DISABLE KEYS */;
INSERT INTO `_user` VALUES (1,'[[admin_pass]]',NULL,NULL,'America/Chicago','super',NULL,1,1,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL),(2,'$2y$12$8JogkPrMyWUs.JAEcM50eu82gc2BrHRutmg/V7JacMmqdTOaLFwXO',NULL,NULL,'America/Chicago','backendjoboractionuser',NULL,0,NULL,1,1,1,NULL,4,2,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `_user_meeting`
--

DROP TABLE IF EXISTS `_user_meeting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `_user_meeting` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `meeting_id` int(11) unsigned DEFAULT NULL,
  `_user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_resu__di_gniteem` (`meeting_id`,`_user_id`),
  KEY `di_gniteem` (`meeting_id`),
  KEY `di_resu_` (`_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `_user_meeting`
--

LOCK TABLES `_user_meeting` WRITE;
/*!40000 ALTER TABLE `_user_meeting` DISABLE KEYS */;
/*!40000 ALTER TABLE `_user_meeting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `account`
--

DROP TABLE IF EXISTS `account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `annualrevenue` double DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `employees` int(11) DEFAULT NULL,
  `latestactivitydatetime` datetime DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `officephone` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `officefax` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  `account_id` int(11) unsigned DEFAULT NULL,
  `billingaddress_address_id` int(11) unsigned DEFAULT NULL,
  `industry_customfield_id` int(11) unsigned DEFAULT NULL,
  `primaryemail_email_id` int(11) unsigned DEFAULT NULL,
  `secondaryemail_email_id` int(11) unsigned DEFAULT NULL,
  `shippingaddress_address_id` int(11) unsigned DEFAULT NULL,
  `type_customfield_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account`
--

LOCK TABLES `account` WRITE;
/*!40000 ALTER TABLE `account` DISABLE KEYS */;
/*!40000 ALTER TABLE `account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `account_project`
--

DROP TABLE IF EXISTS `account_project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_project` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) unsigned DEFAULT NULL,
  `project_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_tcejorp_di_tnuocca` (`account_id`,`project_id`),
  KEY `di_tnuocca` (`account_id`),
  KEY `di_tcejorp` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_project`
--

LOCK TABLES `account_project` WRITE;
/*!40000 ALTER TABLE `account_project` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `account_read`
--

DROP TABLE IF EXISTS `account_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `account_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_read`
--

LOCK TABLES `account_read` WRITE;
/*!40000 ALTER TABLE `account_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `account_read_subscription`
--

DROP TABLE IF EXISTS `account_read_subscription`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_read_subscription` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) unsigned NOT NULL,
  `modelid` int(11) unsigned NOT NULL,
  `modifieddatetime` datetime DEFAULT NULL,
  `subscriptiontype` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `userid_modelid` (`userid`,`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_read_subscription`
--

LOCK TABLES `account_read_subscription` WRITE;
/*!40000 ALTER TABLE `account_read_subscription` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_read_subscription` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `account_read_subscription_temp_build`
--

DROP TABLE IF EXISTS `account_read_subscription_temp_build`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_read_subscription_temp_build` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `accountid` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_read_subscription_temp_build`
--

LOCK TABLES `account_read_subscription_temp_build` WRITE;
/*!40000 ALTER TABLE `account_read_subscription_temp_build` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_read_subscription_temp_build` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accountaccountaffiliation`
--

DROP TABLE IF EXISTS `accountaccountaffiliation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accountaccountaffiliation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) unsigned DEFAULT NULL,
  `primaryaccountaffiliation_account_id` int(11) unsigned DEFAULT NULL,
  `secondaryaccountaffiliation_account_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accountaccountaffiliation`
--

LOCK TABLES `accountaccountaffiliation` WRITE;
/*!40000 ALTER TABLE `accountaccountaffiliation` DISABLE KEYS */;
/*!40000 ALTER TABLE `accountaccountaffiliation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accountcontactaffiliation`
--

DROP TABLE IF EXISTS `accountcontactaffiliation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accountcontactaffiliation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `primary` tinyint(1) unsigned DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `role_customfield_id` int(11) unsigned DEFAULT NULL,
  `accountaffiliation_account_id` int(11) unsigned DEFAULT NULL,
  `contactaffiliation_contact_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accountcontactaffiliation`
--

LOCK TABLES `accountcontactaffiliation` WRITE;
/*!40000 ALTER TABLE `accountcontactaffiliation` DISABLE KEYS */;
/*!40000 ALTER TABLE `accountcontactaffiliation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accountstarred`
--

DROP TABLE IF EXISTS `accountstarred`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accountstarred` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `basestarredmodel_id` int(11) unsigned DEFAULT NULL,
  `account_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `basestarredmodel_id_account_id` (`basestarredmodel_id`,`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accountstarred`
--

LOCK TABLES `accountstarred` WRITE;
/*!40000 ALTER TABLE `accountstarred` DISABLE KEYS */;
/*!40000 ALTER TABLE `accountstarred` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activelanguage`
--

DROP TABLE IF EXISTS `activelanguage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activelanguage` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nativename` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `activationdatetime` datetime DEFAULT NULL,
  `lastupdatedatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activelanguage`
--

LOCK TABLES `activelanguage` WRITE;
/*!40000 ALTER TABLE `activelanguage` DISABLE KEYS */;
/*!40000 ALTER TABLE `activelanguage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activity`
--

DROP TABLE IF EXISTS `activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `latestdatetime` datetime DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ownedsecurableitem_id` (`ownedsecurableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activity`
--

LOCK TABLES `activity` WRITE;
/*!40000 ALTER TABLE `activity` DISABLE KEYS */;
/*!40000 ALTER TABLE `activity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activity_item`
--

DROP TABLE IF EXISTS `activity_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_item` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `activity_id` int(11) unsigned DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_meti_di_ytivitca` (`activity_id`,`item_id`),
  KEY `di_ytivitca` (`activity_id`),
  KEY `di_meti` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activity_item`
--

LOCK TABLES `activity_item` WRITE;
/*!40000 ALTER TABLE `activity_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `activity_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actual_permissions_cache`
--

DROP TABLE IF EXISTS `actual_permissions_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actual_permissions_cache` (
  `securableitem_id` int(11) unsigned NOT NULL,
  `permitable_id` int(11) unsigned NOT NULL,
  `allow_permissions` tinyint(3) unsigned NOT NULL,
  `deny_permissions` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`securableitem_id`,`permitable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actual_permissions_cache`
--

LOCK TABLES `actual_permissions_cache` WRITE;
/*!40000 ALTER TABLE `actual_permissions_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `actual_permissions_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actual_rights_cache`
--

DROP TABLE IF EXISTS `actual_rights_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actual_rights_cache` (
  `identifier` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `entry` int(11) unsigned NOT NULL,
  PRIMARY KEY (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actual_rights_cache`
--

LOCK TABLES `actual_rights_cache` WRITE;
/*!40000 ALTER TABLE `actual_rights_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `actual_rights_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `address`
--

DROP TABLE IF EXISTS `address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `address` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `city` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `invalid` tinyint(1) unsigned DEFAULT NULL,
  `latitude` double DEFAULT NULL,
  `longitude` double DEFAULT NULL,
  `postalcode` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `street1` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `street2` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `address`
--

LOCK TABLES `address` WRITE;
/*!40000 ALTER TABLE `address` DISABLE KEYS */;
/*!40000 ALTER TABLE `address` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auditevent`
--

DROP TABLE IF EXISTS `auditevent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auditevent` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` datetime DEFAULT NULL,
  `eventname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `modulename` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `modelclassname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `modelid` int(11) DEFAULT NULL,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `_user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `modelclass_modelid_index` (`modelclassname`,`modelid`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auditevent`
--

LOCK TABLES `auditevent` WRITE;
/*!40000 ALTER TABLE `auditevent` DISABLE KEYS */;
INSERT INTO `auditevent` VALUES (1,'[[regtime]]','User Password Changed','UsersModule','User',1,'s:5:\"super\";',1),(2,'[[regtime]]','Item Modified','ZurmoModule','User',1,'a:4:{i:0;s:10:\"Super User\";i:1;a:1:{i:0;s:8:\"isActive\";}i:2;s:5:\"false\";i:3;s:4:\"true\";}',1),(3,'[[regtime]]','User Password Changed','UsersModule','User',2,'s:22:\"backendjoboractionuser\";',1),(4,'[[regtime]]','Item Modified','ZurmoModule','User',2,'a:4:{i:0;s:11:\"System User\";i:1;a:1:{i:0;s:8:\"isActive\";}i:2;s:5:\"false\";i:3;s:4:\"true\";}',1),(5,'[[regtime]]','Item Modified','ZurmoModule','User',2,'a:4:{i:0;s:11:\"System User\";i:1;a:1:{i:0;s:8:\"isActive\";}i:2;s:4:\"true\";i:3;s:5:\"false\";}',1);
/*!40000 ALTER TABLE `auditevent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `autoresponder`
--

DROP TABLE IF EXISTS `autoresponder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `autoresponder` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `htmlcontent` text COLLATE utf8_unicode_ci,
  `textcontent` text COLLATE utf8_unicode_ci,
  `fromoperationdurationinterval` int(11) DEFAULT NULL,
  `fromoperationdurationtype` text COLLATE utf8_unicode_ci,
  `operationtype` int(11) DEFAULT NULL,
  `enabletracking` tinyint(1) unsigned DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `marketinglist_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `autoresponder`
--

LOCK TABLES `autoresponder` WRITE;
/*!40000 ALTER TABLE `autoresponder` DISABLE KEYS */;
/*!40000 ALTER TABLE `autoresponder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `autoresponderemailmessagecontent`
--

DROP TABLE IF EXISTS `autoresponderemailmessagecontent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `autoresponderemailmessagecontent` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `htmlcontent` text COLLATE utf8_unicode_ci,
  `textcontent` text COLLATE utf8_unicode_ci,
  `item_id` int(11) unsigned DEFAULT NULL,
  `autoresponder_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `autoresponderemailmessagecontent`
--

LOCK TABLES `autoresponderemailmessagecontent` WRITE;
/*!40000 ALTER TABLE `autoresponderemailmessagecontent` DISABLE KEYS */;
/*!40000 ALTER TABLE `autoresponderemailmessagecontent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `autoresponderitem`
--

DROP TABLE IF EXISTS `autoresponderitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `autoresponderitem` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `processdatetime` datetime DEFAULT NULL,
  `processed` tinyint(1) unsigned DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `emailmessage_id` int(11) unsigned DEFAULT NULL,
  `autoresponder_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `autoresponderitem`
--

LOCK TABLES `autoresponderitem` WRITE;
/*!40000 ALTER TABLE `autoresponderitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `autoresponderitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `autoresponderitemactivity`
--

DROP TABLE IF EXISTS `autoresponderitemactivity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `autoresponderitemactivity` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emailmessageactivity_id` int(11) unsigned DEFAULT NULL,
  `autoresponderitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `emailmessageactivity_id_autoresponderitem_id` (`emailmessageactivity_id`,`autoresponderitem_id`),
  KEY `emailmessageactivity_id` (`emailmessageactivity_id`),
  KEY `autoresponderitem_id` (`autoresponderitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `autoresponderitemactivity`
--

LOCK TABLES `autoresponderitemactivity` WRITE;
/*!40000 ALTER TABLE `autoresponderitemactivity` DISABLE KEYS */;
/*!40000 ALTER TABLE `autoresponderitemactivity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `basecustomfield`
--

DROP TABLE IF EXISTS `basecustomfield`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `basecustomfield` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `data_customfielddata_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `basecustomfield`
--

LOCK TABLES `basecustomfield` WRITE;
/*!40000 ALTER TABLE `basecustomfield` DISABLE KEYS */;
/*!40000 ALTER TABLE `basecustomfield` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `basestarredmodel`
--

DROP TABLE IF EXISTS `basestarredmodel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `basestarredmodel` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `_user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `basestarredmodel`
--

LOCK TABLES `basestarredmodel` WRITE;
/*!40000 ALTER TABLE `basestarredmodel` DISABLE KEYS */;
/*!40000 ALTER TABLE `basestarredmodel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bytimeworkflowinqueue`
--

DROP TABLE IF EXISTS `bytimeworkflowinqueue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bytimeworkflowinqueue` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `modelclassname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `processdatetime` datetime DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `modelitem_item_id` int(11) unsigned DEFAULT NULL,
  `savedworkflow_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bytimeworkflowinqueue`
--

LOCK TABLES `bytimeworkflowinqueue` WRITE;
/*!40000 ALTER TABLE `bytimeworkflowinqueue` DISABLE KEYS */;
/*!40000 ALTER TABLE `bytimeworkflowinqueue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calculatedderivedattributemetadata`
--

DROP TABLE IF EXISTS `calculatedderivedattributemetadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calculatedderivedattributemetadata` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `derivedattributemetadata_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calculatedderivedattributemetadata`
--

LOCK TABLES `calculatedderivedattributemetadata` WRITE;
/*!40000 ALTER TABLE `calculatedderivedattributemetadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `calculatedderivedattributemetadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaign`
--

DROP TABLE IF EXISTS `campaign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `campaign` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `supportsrichtext` tinyint(1) unsigned DEFAULT NULL,
  `sendondatetime` datetime DEFAULT NULL,
  `fromname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fromaddress` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `htmlcontent` text COLLATE utf8_unicode_ci,
  `textcontent` text COLLATE utf8_unicode_ci,
  `enabletracking` tinyint(1) unsigned DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  `marketinglist_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaign`
--

LOCK TABLES `campaign` WRITE;
/*!40000 ALTER TABLE `campaign` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaign` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaign_read`
--

DROP TABLE IF EXISTS `campaign_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `campaign_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `campaign_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaign_read`
--

LOCK TABLES `campaign_read` WRITE;
/*!40000 ALTER TABLE `campaign_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaign_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaignemailmessagecontent`
--

DROP TABLE IF EXISTS `campaignemailmessagecontent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `campaignemailmessagecontent` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `htmlcontent` text COLLATE utf8_unicode_ci,
  `textcontent` text COLLATE utf8_unicode_ci,
  `item_id` int(11) unsigned DEFAULT NULL,
  `campaign_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaignemailmessagecontent`
--

LOCK TABLES `campaignemailmessagecontent` WRITE;
/*!40000 ALTER TABLE `campaignemailmessagecontent` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaignemailmessagecontent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaignitem`
--

DROP TABLE IF EXISTS `campaignitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `campaignitem` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `processed` tinyint(1) unsigned DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `emailmessage_id` int(11) unsigned DEFAULT NULL,
  `campaign_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `campaign_id` (`campaign_id`),
  KEY `contact_id` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaignitem`
--

LOCK TABLES `campaignitem` WRITE;
/*!40000 ALTER TABLE `campaignitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaignitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaignitemactivity`
--

DROP TABLE IF EXISTS `campaignitemactivity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `campaignitemactivity` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emailmessageactivity_id` int(11) unsigned DEFAULT NULL,
  `campaignitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `emailmessageactivity_id_campaignitem_id` (`emailmessageactivity_id`,`campaignitem_id`),
  KEY `emailmessageactivity_id` (`emailmessageactivity_id`),
  KEY `campaignitem_id` (`campaignitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaignitemactivity`
--

LOCK TABLES `campaignitemactivity` WRITE;
/*!40000 ALTER TABLE `campaignitemactivity` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaignitemactivity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comment`
--

DROP TABLE IF EXISTS `comment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8_unicode_ci,
  `item_id` int(11) unsigned DEFAULT NULL,
  `relatedmodel_id` int(11) unsigned DEFAULT NULL,
  `relatedmodel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comment`
--

LOCK TABLES `comment` WRITE;
/*!40000 ALTER TABLE `comment` DISABLE KEYS */;
/*!40000 ALTER TABLE `comment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact`
--

DROP TABLE IF EXISTS `contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `companyname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `latestactivitydatetime` datetime DEFAULT NULL,
  `website` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `googlewebtrackingid` text COLLATE utf8_unicode_ci,
  `twitterid` text COLLATE utf8_unicode_ci,
  `facebookid` text COLLATE utf8_unicode_ci,
  `person_id` int(11) unsigned DEFAULT NULL,
  `account_id` int(11) unsigned DEFAULT NULL,
  `industry_customfield_id` int(11) unsigned DEFAULT NULL,
  `secondaryaddress_address_id` int(11) unsigned DEFAULT NULL,
  `secondaryemail_email_id` int(11) unsigned DEFAULT NULL,
  `source_customfield_id` int(11) unsigned DEFAULT NULL,
  `state_contactstate_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `person_id` (`person_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact`
--

LOCK TABLES `contact` WRITE;
/*!40000 ALTER TABLE `contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_opportunity`
--

DROP TABLE IF EXISTS `contact_opportunity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact_opportunity` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `opportunity_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_ytinutroppo_di_tcatnoc` (`contact_id`,`opportunity_id`),
  KEY `di_tcatnoc` (`contact_id`),
  KEY `di_ytinutroppo` (`opportunity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_opportunity`
--

LOCK TABLES `contact_opportunity` WRITE;
/*!40000 ALTER TABLE `contact_opportunity` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_opportunity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_project`
--

DROP TABLE IF EXISTS `contact_project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact_project` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `project_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_tcejorp_di_tcatnoc` (`contact_id`,`project_id`),
  KEY `di_tcatnoc` (`contact_id`),
  KEY `di_tcejorp` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_project`
--

LOCK TABLES `contact_project` WRITE;
/*!40000 ALTER TABLE `contact_project` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_read`
--

DROP TABLE IF EXISTS `contact_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `contact_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_read`
--

LOCK TABLES `contact_read` WRITE;
/*!40000 ALTER TABLE `contact_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_read_subscription`
--

DROP TABLE IF EXISTS `contact_read_subscription`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contact_read_subscription` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) unsigned NOT NULL,
  `modelid` int(11) unsigned NOT NULL,
  `modifieddatetime` datetime DEFAULT NULL,
  `subscriptiontype` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `userid_modelid` (`userid`,`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_read_subscription`
--

LOCK TABLES `contact_read_subscription` WRITE;
/*!40000 ALTER TABLE `contact_read_subscription` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_read_subscription` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contactstarred`
--

DROP TABLE IF EXISTS `contactstarred`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contactstarred` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `basestarredmodel_id` int(11) unsigned DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `basestarredmodel_id_contact_id` (`basestarredmodel_id`,`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contactstarred`
--

LOCK TABLES `contactstarred` WRITE;
/*!40000 ALTER TABLE `contactstarred` DISABLE KEYS */;
/*!40000 ALTER TABLE `contactstarred` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contactstate`
--

DROP TABLE IF EXISTS `contactstate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contactstate` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order` int(11) DEFAULT NULL,
  `serializedlabels` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contactstate`
--

LOCK TABLES `contactstate` WRITE;
/*!40000 ALTER TABLE `contactstate` DISABLE KEYS */;
INSERT INTO `contactstate` VALUES (1,'New',0,NULL),(2,'In Progress',1,NULL),(3,'Recycled',2,NULL),(4,'Dead',3,NULL),(5,'Qualified',4,NULL),(6,'Customer',5,NULL);
/*!40000 ALTER TABLE `contactstate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contactwebform`
--

DROP TABLE IF EXISTS `contactwebform`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contactwebform` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8_unicode_ci,
  `redirecturl` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `submitbuttonlabel` text COLLATE utf8_unicode_ci,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `excludestyles` tinyint(1) unsigned DEFAULT NULL,
  `enablecaptcha` tinyint(1) unsigned DEFAULT NULL,
  `language` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `defaultpermissionsetting` tinyint(11) DEFAULT NULL,
  `defaultpermissiongroupsetting` int(11) DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  `defaultstate_contactstate_id` int(11) unsigned DEFAULT NULL,
  `defaultowner__user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contactwebform`
--

LOCK TABLES `contactwebform` WRITE;
/*!40000 ALTER TABLE `contactwebform` DISABLE KEYS */;
/*!40000 ALTER TABLE `contactwebform` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contactwebform_read`
--

DROP TABLE IF EXISTS `contactwebform_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contactwebform_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `contactwebform_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contactwebform_read`
--

LOCK TABLES `contactwebform_read` WRITE;
/*!40000 ALTER TABLE `contactwebform_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `contactwebform_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contactwebformentry`
--

DROP TABLE IF EXISTS `contactwebformentry`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contactwebformentry` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  `message` text COLLATE utf8_unicode_ci,
  `hashindex` text COLLATE utf8_unicode_ci,
  `item_id` int(11) unsigned DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `entries_contactwebform_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contactwebformentry`
--

LOCK TABLES `contactwebformentry` WRITE;
/*!40000 ALTER TABLE `contactwebformentry` DISABLE KEYS */;
/*!40000 ALTER TABLE `contactwebformentry` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversation`
--

DROP TABLE IF EXISTS `conversation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8_unicode_ci,
  `latestdatetime` datetime DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ownerhasreadlatest` tinyint(1) unsigned DEFAULT NULL,
  `isclosed` tinyint(1) unsigned DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversation`
--

LOCK TABLES `conversation` WRITE;
/*!40000 ALTER TABLE `conversation` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversation_item`
--

DROP TABLE IF EXISTS `conversation_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversation_item` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `conversation_id` int(11) unsigned DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_meti_di_noitasrevnoc` (`conversation_id`,`item_id`),
  KEY `di_noitasrevnoc` (`conversation_id`),
  KEY `di_meti` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversation_item`
--

LOCK TABLES `conversation_item` WRITE;
/*!40000 ALTER TABLE `conversation_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversation_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversation_read`
--

DROP TABLE IF EXISTS `conversation_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversation_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `conversation_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversation_read`
--

LOCK TABLES `conversation_read` WRITE;
/*!40000 ALTER TABLE `conversation_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversation_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversationparticipant`
--

DROP TABLE IF EXISTS `conversationparticipant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversationparticipant` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hasreadlatest` tinyint(1) unsigned DEFAULT NULL,
  `person_item_id` int(11) unsigned DEFAULT NULL,
  `conversation_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversationparticipant`
--

LOCK TABLES `conversationparticipant` WRITE;
/*!40000 ALTER TABLE `conversationparticipant` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversationparticipant` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversationstarred`
--

DROP TABLE IF EXISTS `conversationstarred`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversationstarred` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `basestarredmodel_id` int(11) unsigned DEFAULT NULL,
  `conversation_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `basestarredmodel_id_conversation_id` (`basestarredmodel_id`,`conversation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversationstarred`
--

LOCK TABLES `conversationstarred` WRITE;
/*!40000 ALTER TABLE `conversationstarred` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversationstarred` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currency`
--

DROP TABLE IF EXISTS `currency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currency` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) unsigned DEFAULT NULL,
  `code` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ratetobase` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_edoc` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currency`
--

LOCK TABLES `currency` WRITE;
/*!40000 ALTER TABLE `currency` DISABLE KEYS */;
INSERT INTO `currency` VALUES (1,1,'USD',1);
/*!40000 ALTER TABLE `currency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currencyvalue`
--

DROP TABLE IF EXISTS `currencyvalue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencyvalue` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ratetobase` double DEFAULT NULL,
  `value` double DEFAULT NULL,
  `currency_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currencyvalue`
--

LOCK TABLES `currencyvalue` WRITE;
/*!40000 ALTER TABLE `currencyvalue` DISABLE KEYS */;
/*!40000 ALTER TABLE `currencyvalue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customfield`
--

DROP TABLE IF EXISTS `customfield`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customfield` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `value` text COLLATE utf8_unicode_ci,
  `basecustomfield_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customfield`
--

LOCK TABLES `customfield` WRITE;
/*!40000 ALTER TABLE `customfield` DISABLE KEYS */;
/*!40000 ALTER TABLE `customfield` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customfielddata`
--

DROP TABLE IF EXISTS `customfielddata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customfielddata` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `defaultvalue` text COLLATE utf8_unicode_ci,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `serializedlabels` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_eman` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customfielddata`
--

LOCK TABLES `customfielddata` WRITE;
/*!40000 ALTER TABLE `customfielddata` DISABLE KEYS */;
INSERT INTO `customfielddata` VALUES (1,'AccountContactAffiliationRoles',NULL,'a:6:{i:0;s:7:\"Billing\";i:1;s:8:\"Shipping\";i:2;s:7:\"Support\";i:3;s:9:\"Technical\";i:4;s:14:\"Administrative\";i:5;s:15:\"Project Manager\";}',NULL),(2,'Industries',NULL,'a:9:{i:0;s:10:\"Automotive\";i:1;s:7:\"Banking\";i:2;s:17:\"Business Services\";i:3;s:6:\"Energy\";i:4;s:18:\"Financial Services\";i:5;s:9:\"Insurance\";i:6;s:13:\"Manufacturing\";i:7;s:6:\"Retail\";i:8;s:10:\"Technology\";}',NULL),(3,'AccountTypes',NULL,'a:3:{i:0;s:8:\"Prospect\";i:1;s:8:\"Customer\";i:2;s:6:\"Vendor\";}',NULL),(4,'LeadSources',NULL,'a:4:{i:0;s:14:\"Self-Generated\";i:1;s:12:\"Inbound Call\";i:2;s:9:\"Tradeshow\";i:3;s:13:\"Word of Mouth\";}',NULL),(5,'MeetingCategories','Meeting','a:2:{i:0;s:7:\"Meeting\";i:1;s:4:\"Call\";}',NULL),(6,'SalesStages','Prospecting','a:6:{i:0;s:11:\"Prospecting\";i:1;s:13:\"Qualification\";i:2;s:11:\"Negotiating\";i:3;s:6:\"Verbal\";i:4;s:10:\"Closed Won\";i:5;s:11:\"Closed Lost\";}',NULL),(7,'ProductStages',NULL,'a:3:{i:0;s:4:\"Open\";i:1;s:4:\"Lost\";i:2;s:3:\"Won\";}',NULL),(8,'Titles',NULL,'a:4:{i:0;s:3:\"Mr.\";i:1;s:4:\"Mrs.\";i:2;s:3:\"Ms.\";i:3;s:3:\"Dr.\";}',NULL);
/*!40000 ALTER TABLE `customfielddata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customfieldvalue`
--

DROP TABLE IF EXISTS `customfieldvalue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customfieldvalue` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `multiplevaluescustomfield_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `multiplevaluescustomfield_id` (`multiplevaluescustomfield_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customfieldvalue`
--

LOCK TABLES `customfieldvalue` WRITE;
/*!40000 ALTER TABLE `customfieldvalue` DISABLE KEYS */;
/*!40000 ALTER TABLE `customfieldvalue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard`
--

DROP TABLE IF EXISTS `dashboard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dashboard` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `isdefault` tinyint(1) unsigned DEFAULT NULL,
  `layoutid` int(11) DEFAULT NULL,
  `layouttype` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard`
--

LOCK TABLES `dashboard` WRITE;
/*!40000 ALTER TABLE `dashboard` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `derivedattributemetadata`
--

DROP TABLE IF EXISTS `derivedattributemetadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `derivedattributemetadata` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `modelclassname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serializedmetadata` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `derivedattributemetadata`
--

LOCK TABLES `derivedattributemetadata` WRITE;
/*!40000 ALTER TABLE `derivedattributemetadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `derivedattributemetadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dropdowndependencyderivedattributemetadata`
--

DROP TABLE IF EXISTS `dropdowndependencyderivedattributemetadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dropdowndependencyderivedattributemetadata` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `derivedattributemetadata_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dropdowndependencyderivedattributemetadata`
--

LOCK TABLES `dropdowndependencyderivedattributemetadata` WRITE;
/*!40000 ALTER TABLE `dropdowndependencyderivedattributemetadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `dropdowndependencyderivedattributemetadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email`
--

DROP TABLE IF EXISTS `email`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emailaddress` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isinvalid` tinyint(1) unsigned DEFAULT NULL,
  `optout` tinyint(1) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email`
--

LOCK TABLES `email` WRITE;
/*!40000 ALTER TABLE `email` DISABLE KEYS */;
/*!40000 ALTER TABLE `email` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailaccount`
--

DROP TABLE IF EXISTS `emailaccount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailaccount` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fromname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fromaddress` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` text COLLATE utf8_unicode_ci,
  `replytoname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outboundhost` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outboundusername` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outboundpassword` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outboundsecurity` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outboundtype` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outboundport` int(11) DEFAULT NULL,
  `usecustomoutboundsettings` int(11) DEFAULT NULL,
  `replytoaddress` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `_user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailaccount`
--

LOCK TABLES `emailaccount` WRITE;
/*!40000 ALTER TABLE `emailaccount` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailaccount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailbox`
--

DROP TABLE IF EXISTS `emailbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailbox` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `_user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailbox`
--

LOCK TABLES `emailbox` WRITE;
/*!40000 ALTER TABLE `emailbox` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailfolder`
--

DROP TABLE IF EXISTS `emailfolder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailfolder` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `emailbox_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailfolder`
--

LOCK TABLES `emailfolder` WRITE;
/*!40000 ALTER TABLE `emailfolder` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailfolder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailmessage`
--

DROP TABLE IF EXISTS `emailmessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailmessage` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sendattempts` int(11) DEFAULT NULL,
  `sentdatetime` datetime DEFAULT NULL,
  `sendondatetime` datetime DEFAULT NULL,
  `headers` text COLLATE utf8_unicode_ci,
  `mailertype` text COLLATE utf8_unicode_ci,
  `mailersettings` text COLLATE utf8_unicode_ci,
  `contenttype` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  `folder_emailfolder_id` int(11) unsigned DEFAULT NULL,
  `content_emailmessagecontent_id` int(11) unsigned DEFAULT NULL,
  `sender_emailmessagesender_id` int(11) unsigned DEFAULT NULL,
  `error_emailmessagesenderror_id` int(11) unsigned DEFAULT NULL,
  `account_emailaccount_id` int(11) unsigned DEFAULT NULL,
  `sendgridaccount_sendgridemailaccount_id` int(11) unsigned DEFAULT NULL,
  `contact_contact_id` int(11) unsigned DEFAULT NULL,
  `campaigncontent_campaignemailmessagecontent_id` int(11) unsigned DEFAULT NULL,
  `autorespondercontent_autoresponderemailmessagecontent_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailmessage`
--

LOCK TABLES `emailmessage` WRITE;
/*!40000 ALTER TABLE `emailmessage` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailmessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailmessage_read`
--

DROP TABLE IF EXISTS `emailmessage_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailmessage_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `emailmessage_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailmessage_read`
--

LOCK TABLES `emailmessage_read` WRITE;
/*!40000 ALTER TABLE `emailmessage_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailmessage_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailmessageactivity`
--

DROP TABLE IF EXISTS `emailmessageactivity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailmessageactivity` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `latestdatetime` datetime DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `latestsourceip` text COLLATE utf8_unicode_ci,
  `item_id` int(11) unsigned DEFAULT NULL,
  `person_id` int(11) unsigned DEFAULT NULL,
  `emailmessageurl_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailmessageactivity`
--

LOCK TABLES `emailmessageactivity` WRITE;
/*!40000 ALTER TABLE `emailmessageactivity` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailmessageactivity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailmessagecontactvariablecontent`
--

DROP TABLE IF EXISTS `emailmessagecontactvariablecontent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailmessagecontactvariablecontent` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `serializedcontent` text COLLATE utf8_unicode_ci,
  `item_id` int(11) unsigned DEFAULT NULL,
  `contact_contact_id` int(11) unsigned DEFAULT NULL,
  `emailmessage_emailmessage_id` int(11) unsigned DEFAULT NULL,
  `campaign_campaign_id` int(11) unsigned DEFAULT NULL,
  `autoresponder_autoresponder_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailmessagecontactvariablecontent`
--

LOCK TABLES `emailmessagecontactvariablecontent` WRITE;
/*!40000 ALTER TABLE `emailmessagecontactvariablecontent` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailmessagecontactvariablecontent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailmessagecontent`
--

DROP TABLE IF EXISTS `emailmessagecontent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailmessagecontent` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `htmlcontent` text COLLATE utf8_unicode_ci,
  `textcontent` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailmessagecontent`
--

LOCK TABLES `emailmessagecontent` WRITE;
/*!40000 ALTER TABLE `emailmessagecontent` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailmessagecontent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailmessagerecipient`
--

DROP TABLE IF EXISTS `emailmessagerecipient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailmessagerecipient` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `toaddress` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `toname` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `emailmessage_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `remailmessage` (`emailmessage_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailmessagerecipient`
--

LOCK TABLES `emailmessagerecipient` WRITE;
/*!40000 ALTER TABLE `emailmessagerecipient` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailmessagerecipient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailmessagerecipient_item`
--

DROP TABLE IF EXISTS `emailmessagerecipient_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailmessagerecipient_item` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emailmessagerecipient_id` int(11) unsigned DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_meti_di_tneipiceregassemliame` (`emailmessagerecipient_id`,`item_id`),
  KEY `di_tneipiceregassemliame` (`emailmessagerecipient_id`),
  KEY `di_meti` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailmessagerecipient_item`
--

LOCK TABLES `emailmessagerecipient_item` WRITE;
/*!40000 ALTER TABLE `emailmessagerecipient_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailmessagerecipient_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailmessagesender`
--

DROP TABLE IF EXISTS `emailmessagesender`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailmessagesender` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fromaddress` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fromname` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailmessagesender`
--

LOCK TABLES `emailmessagesender` WRITE;
/*!40000 ALTER TABLE `emailmessagesender` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailmessagesender` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailmessagesender_item`
--

DROP TABLE IF EXISTS `emailmessagesender_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailmessagesender_item` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emailmessagesender_id` int(11) unsigned DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_meti_di_rednesegassemliame` (`emailmessagesender_id`,`item_id`),
  KEY `di_rednesegassemliame` (`emailmessagesender_id`),
  KEY `di_meti` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailmessagesender_item`
--

LOCK TABLES `emailmessagesender_item` WRITE;
/*!40000 ALTER TABLE `emailmessagesender_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailmessagesender_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailmessagesenderror`
--

DROP TABLE IF EXISTS `emailmessagesenderror`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailmessagesenderror` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `createddatetime` datetime DEFAULT NULL,
  `serializeddata` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailmessagesenderror`
--

LOCK TABLES `emailmessagesenderror` WRITE;
/*!40000 ALTER TABLE `emailmessagesenderror` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailmessagesenderror` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailmessageurl`
--

DROP TABLE IF EXISTS `emailmessageurl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailmessageurl` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `emailmessageactivity_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailmessageurl`
--

LOCK TABLES `emailmessageurl` WRITE;
/*!40000 ALTER TABLE `emailmessageurl` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailmessageurl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailsignature`
--

DROP TABLE IF EXISTS `emailsignature`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailsignature` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `textcontent` text COLLATE utf8_unicode_ci,
  `htmlcontent` text COLLATE utf8_unicode_ci,
  `_user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailsignature`
--

LOCK TABLES `emailsignature` WRITE;
/*!40000 ALTER TABLE `emailsignature` DISABLE KEYS */;
/*!40000 ALTER TABLE `emailsignature` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailtemplate`
--

DROP TABLE IF EXISTS `emailtemplate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailtemplate` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(11) DEFAULT NULL,
  `isdraft` tinyint(1) unsigned DEFAULT NULL,
  `builttype` int(11) DEFAULT NULL,
  `modelclassname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `htmlcontent` text COLLATE utf8_unicode_ci,
  `textcontent` text COLLATE utf8_unicode_ci,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `isfeatured` tinyint(1) unsigned DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailtemplate`
--

LOCK TABLES `emailtemplate` WRITE;
/*!40000 ALTER TABLE `emailtemplate` DISABLE KEYS */;
INSERT INTO `emailtemplate` VALUES (1,NULL,0,3,NULL,'Blank','Blank','en',NULL,NULL,'{\"baseTemplateId\":\"\",\"icon\":\"icon-template-0\",\"dom\":{\"canvas1\":{\"content\":{\"builderrowelement_1393965668_53163a6448794\":{\"content\":{\"buildercolumnelement_1393965668_53163a644866d\":{\"content\":[],\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":{\"backend\":{\"configuration\":\"1\"}},\"class\":\"BuilderRowElement\"}},\"properties\":{\"frontend\":{\"inlineStyles\":{\"background-color\":\"#ffffff\",\"color\":\"#545454\"}}},\"class\":\"BuilderCanvasElement\"}}}',NULL,1),(2,NULL,0,3,NULL,'1 Column','1 Column','en',NULL,NULL,'{\"baseTemplateId\":\"\",\"icon\":\"icon-template-5\",\"dom\":{\"canvas1\":{\"content\":{\"builderheaderimagetextelement_1393965594_53163a1a0eb53\":{\"content\":{\"buildercolumnelement_1393965594_53163a1a0ef48\":{\"content\":{\"builderimageelement_1393965594_53163a1a0ee52\":{\"content\":{\"image\":1},\"properties\":[],\"class\":\"BuilderImageElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"},\"buildercolumnelement_1393965594_53163a1a145cc\":{\"content\":{\"builderheadertextelement_1393965594_53163a1a14515\":{\"content\":{\"text\":\"Acme Inc. Newsletter\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"color\":\"#ffffff\",\"font-weight\":\"bold\",\"text-align\":\"right\"}}},\"class\":\"BuilderHeaderTextElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":{\"backend\":{\"configuration\":\"1:2\",\"header\":\"1\"},\"frontend\":{\"inlineStyles\":{\"background-color\":\"#282a76\"}}},\"class\":\"BuilderHeaderImageTextElement\"},\"builderrowelement_1393965668_53163a6448794\":{\"content\":{\"buildercolumnelement_1393965668_53163a644866d\":{\"content\":{\"buildertitleelement_1393965668_53163a6447762\":{\"content\":{\"text\":\"Hello there William S...\"},\"properties\":{\"backend\":{\"headingLevel\":\"h3\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#666666\",\"font-size\":\"24\",\"font-weight\":\"bold\",\"text-align\":\"center\"}}},\"class\":\"BuilderTitleElement\"},\"builderimageelement_1393970522_53164d5a3787a\":{\"content\":{\"image\":3},\"properties\":[],\"class\":\"BuilderImageElement\"},\"builderexpanderelement_1393970557_53164d7d2881e\":{\"content\":[],\"properties\":{\"frontend\":{\"height\":\"10\"}},\"class\":\"BuilderExpanderElement\"},\"buildertextelement_1393965781_53163ad53b77c\":{\"content\":{\"text\":\"\\n<p>\\n    Orsino, the <i>Duke of Illyria<\\/i>, is consumed by his passion for the melancholy Countess Olivia. His ostentatious musings on the nature of love begin with what has become one of Shakespeare\'s most famous lines: \\\"If music be the food of love, play on.\\\" It is apparent that Orsino\'s love is hollow. He is a romantic dreamer, for whom the idea of being in love is most important. When Valentine gives him the terrible news that <b>Olivia<\\/b> plans to seclude herself for seven years to mourn her deceased brother, Orsino seems unfazed, and hopes Olivia may one day be as bewitched by love (the one self king) as he. Fittingly, the scene ends with Orsino off to lay in a bed of flowers, where he can be alone with his love-thoughts. Later in the play it will be up to Viola to teach Orsino the true meaning of love.\\n<\\/p>\\n\"},\"properties\":[],\"class\":\"BuilderTextElement\"},\"builderbuttonelement_1393965942_53163b76e666c\":{\"content\":[],\"properties\":{\"backend\":{\"text\":\"Call Me\",\"sizeClass\":\"medium-button\",\"align\":\"left\"},\"frontend\":{\"href\":\"http:\\/\\/localhost\\/Zurmo\\/app\\/index.php\",\"target\":\"_blank\",\"inlineStyles\":{\"background-color\":\"#97c43d\",\"border-color\":\"#7cb830\"}}},\"class\":\"BuilderButtonElement\"},\"builderdividerelement_1393965948_53163b7cb98ae\":{\"content\":[],\"properties\":{\"frontend\":{\"inlineStyles\":{\"border-top-width\":\"1\",\"border-top-style\":\"solid\",\"border-top-color\":\"#cccccc\"}},\"backend\":{\"divider-padding\":\"10\"}},\"class\":\"BuilderDividerElement\"},\"buildersocialelement_1394060039_5317ab07cf03d\":{\"content\":[],\"properties\":{\"backend\":{\"layout\":\"vertical\",\"services\":{\"Twitter\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/www.twitter.com\\/\"},\"Facebook\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/www.facebook.com\\/\"},\"GooglePlus\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/gplus.com\"}}}},\"class\":\"BuilderSocialElement\"},\"builderexpanderelement_1393970592_53164da0bd137\":{\"content\":[],\"properties\":{\"frontend\":{\"height\":\"10\"}},\"class\":\"BuilderExpanderElement\"},\"builderfooterelement_1393966090_53163c0ac51bd\":{\"content\":{\"text\":\"[[GLOBAL^MARKETING^FOOTER^HTML]]\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"background-color\":\"#efefef\",\"font-size\":\"10\"}}},\"class\":\"BuilderFooterElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"}},\"properties\":{\"frontend\":{\"inlineStyles\":{\"background-color\":\"#ffffff\",\"color\":\"#545454\"}}},\"class\":\"BuilderCanvasElement\"}}}',NULL,2),(3,NULL,0,3,NULL,'2 Columns','2 Columns','en',NULL,NULL,'{\"baseTemplateId\":\"\",\"icon\":\"icon-template-2\",\"dom\":{\"canvas1\":{\"content\":{\"builderheaderimagetextelement_1393965594_53163a1a0eb53\":{\"content\":{\"buildercolumnelement_1393965594_53163a1a0ef48\":{\"content\":{\"builderimageelement_1393965594_53163a1a0ee52\":{\"content\":{\"image\":1},\"properties\":[],\"class\":\"BuilderImageElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"},\"buildercolumnelement_1393965594_53163a1a145cc\":{\"content\":{\"builderheadertextelement_1393965594_53163a1a14515\":{\"content\":{\"text\":\"Acme Inc. Newsletter\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"color\":\"#ffffff\",\"font-weight\":\"bold\",\"text-align\":\"right\"}}},\"class\":\"BuilderHeaderTextElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":{\"backend\":{\"configuration\":\"1:2\",\"header\":\"1\"},\"frontend\":{\"inlineStyles\":{\"background-color\":\"#282a76\"}}},\"class\":\"BuilderHeaderImageTextElement\"},\"builderrowelement_1394062546_5317b4d264a62\":{\"content\":{\"buildercolumnelement_1394062546_5317b4d26488b\":{\"content\":{\"buildertitleelement_1394062546_5317b4d263942\":{\"content\":{\"text\":\"Hello there William S...\"},\"properties\":{\"backend\":{\"headingLevel\":\"h1\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#666666\",\"font-size\":\"28\",\"font-weight\":\"bold\",\"line-height\":\"200\"}}},\"class\":\"BuilderTitleElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"},\"builderrowelement_1393965668_53163a6448794\":{\"content\":{\"buildercolumnelement_1393965668_53163a644866d\":{\"content\":{\"buildertextelement_1393965781_53163ad53b77c\":{\"content\":{\"text\":\"\\n<p>\\n    Orsino, the <i>Duke of Illyria<\\/i>, is consumed by his passion for the melancholy Countess Olivia. His ostentatious musings on the nature of love begin with what has become one of Shakespeare\'s most famous lines: \\\"If music be the food of love, play on.\\\" It is apparent that Orsino\'s love is hollow. He is a romantic dreamer, for whom the idea of being in love is most important. When Valentine gives him the terrible news that <b>Olivia<\\/b> plans to seclude herself for seven years to mourn her deceased brother, Orsino seems unfazed, and hopes Olivia may one day be as bewitched by love (the one self king) as he. Fittingly, the scene ends with Orsino off to lay in a bed of flowers, where he can be alone with his love-thoughts. Later in the play it will be up to Viola to teach Orsino the true meaning of love.\\n<\\/p>\\n\"},\"properties\":[],\"class\":\"BuilderTextElement\"},\"builderbuttonelement_1393965942_53163b76e666c\":{\"content\":[],\"properties\":{\"backend\":{\"text\":\"Contact Us Now\",\"sizeClass\":\"medium-button\",\"align\":\"left\"},\"frontend\":{\"href\":\"http:\\/\\/localhost\\/Zurmo\\/app\\/index.php\",\"target\":\"_blank\",\"inlineStyles\":{\"background-color\":\"#97c43d\",\"border-color\":\"#7cb830\"}}},\"class\":\"BuilderButtonElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"},\"buildercolumnelement_1394061698_5317b182c1f19\":{\"content\":{\"buildertextelement_1394061967_5317b28fc8088\":{\"content\":{\"text\":\"\\n<b>New Articles<\\/b>\\n<ul>\\n    <li>Article Name about something<\\/li>\\n    <li>10 ways to create email templates<\\/li>\\n    <li>Great new marketing tools from Acme<\\/li>\\n    <li>Best blog post of the year<\\/li>\\n    <li>Meet our new chef<\\/li>\\n<\\/ul>\\n\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"background-color\":\"#f6f6f7\",\"color\":\"#323232\",\"font-size\":\"16\"}}},\"class\":\"BuilderTextElement\"},\"builderexpanderelement_1394062193_5317b37137abc\":{\"content\":[],\"properties\":{\"frontend\":{\"height\":\"10\"}},\"class\":\"BuilderExpanderElement\"},\"buildertitleelement_1394062361_5317b419e1c51\":{\"content\":{\"text\":\"Acme Elsewhere\"},\"properties\":{\"backend\":{\"headingLevel\":\"h3\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#6c1d1d\",\"font-weight\":\"bold\",\"line-height\":\"200\"}}},\"class\":\"BuilderTitleElement\"},\"buildersocialelement_1394060039_5317ab07cf03d\":{\"content\":[],\"properties\":{\"backend\":{\"layout\":\"vertical\",\"services\":{\"Twitter\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/www.twitter.com\\/\"},\"Facebook\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/www.facebook.com\\/\"},\"GooglePlus\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/gplus.com\"}}}},\"class\":\"BuilderSocialElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":{\"backend\":{\"configuration\":\"2\"}},\"class\":\"BuilderRowElement\"},\"builderrowelement_1394062652_5317b53c906f9\":{\"content\":{\"buildercolumnelement_1394062652_5317b53c90615\":{\"content\":{\"builderdividerelement_1394062652_5317b53c901fc\":{\"content\":[],\"properties\":{\"frontend\":{\"inlineStyles\":{\"border-top-width\":\"1\",\"border-top-style\":\"dotted\",\"border-top-color\":\"#efefef\"}},\"backend\":{\"divider-padding\":\"10\"}},\"class\":\"BuilderDividerElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"},\"builderrowelement_1394062641_5317b53112a36\":{\"content\":{\"buildercolumnelement_1394062641_5317b5311291a\":{\"content\":{\"builderfooterelement_1394062641_5317b5311226e\":{\"content\":{\"text\":\"[[GLOBAL^MARKETING^FOOTER^HTML]]\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"font-size\":\"11\",\"background-color\":\"#ebebeb\"}}},\"class\":\"BuilderFooterElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"}},\"properties\":{\"frontend\":{\"inlineStyles\":{\"background-color\":\"#ffffff\",\"color\":\"#545454\"}}},\"class\":\"BuilderCanvasElement\"}}}',NULL,3),(4,NULL,0,3,NULL,'2 Columns with strong right','2 Columns with strong right','en',NULL,NULL,'{\"baseTemplateId\":\"\",\"icon\":\"icon-template-3\",\"dom\":{\"canvas1\":{\"content\":{\"builderheaderimagetextelement_1393965594_53163a1a0eb53\":{\"content\":{\"buildercolumnelement_1393965594_53163a1a0ef48\":{\"content\":{\"builderimageelement_1393965594_53163a1a0ee52\":{\"content\":{\"image\":1},\"properties\":[],\"class\":\"BuilderImageElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"},\"buildercolumnelement_1393965594_53163a1a145cc\":{\"content\":{\"builderheadertextelement_1393965594_53163a1a14515\":{\"content\":{\"text\":\"Acme Inc. Newsletter\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"color\":\"#ffffff\",\"font-weight\":\"bold\",\"text-align\":\"right\"}}},\"class\":\"BuilderHeaderTextElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":{\"backend\":{\"configuration\":\"1:2\",\"header\":\"1\"},\"frontend\":{\"inlineStyles\":{\"background-color\":\"#282a76\"}}},\"class\":\"BuilderHeaderImageTextElement\"},\"builderrowelement_1394062546_5317b4d264a62\":{\"content\":{\"buildercolumnelement_1394062546_5317b4d26488b\":{\"content\":{\"buildertitleelement_1394062546_5317b4d263942\":{\"content\":{\"text\":\"Hello there William S...\"},\"properties\":{\"backend\":{\"headingLevel\":\"h1\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#666666\",\"font-size\":\"28\",\"font-weight\":\"bold\",\"line-height\":\"200\"}}},\"class\":\"BuilderTitleElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"},\"builderrowelement_1393965668_53163a6448794\":{\"content\":{\"buildercolumnelement_1393965668_53163a644866d\":{\"content\":{\"buildertextelement_1394061967_5317b28fc8088\":{\"content\":{\"text\":\"\\n <b>New Products<\\/b>\\n<ul>\\n    <li><a href=\\\"#\\\" target=\\\"_blank\\\">AcmeMaster 10,000<\\/a><\\/li>\\n    <li><a href=\\\"#\\\">ProAcme 5,000<\\/a><\\/li>\\n    <li><a href=\\\"#\\\">AcmeMaster++<\\/a><\\/li>\\n    <li><a href=\\\"#\\\" target=\\\"_blank\\\">The Acme Beginner pro<\\/a><\\/li>\\n<\\/ul>\\n\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"background-color\":\"#f6f6f7\",\"color\":\"#323232\",\"font-size\":\"16\"}}},\"class\":\"BuilderTextElement\"},\"buildertitleelement_1394062361_5317b419e1c51\":{\"content\":{\"text\":\"Follow Us!\"},\"properties\":{\"backend\":{\"headingLevel\":\"h3\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#6c1d1d\",\"font-weight\":\"bold\",\"line-height\":\"200\"}}},\"class\":\"BuilderTitleElement\"},\"buildersocialelement_1394060039_5317ab07cf03d\":{\"content\":[],\"properties\":{\"backend\":{\"layout\":\"vertical\",\"services\":{\"Twitter\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/www.twitter.com\\/\"},\"Facebook\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/www.facebook.com\\/\"},\"GooglePlus\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/gplus.com\"}}}},\"class\":\"BuilderSocialElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"},\"buildercolumnelement_1394061698_5317b182c1f19\":{\"content\":{\"buildertextelement_1393965781_53163ad53b77c\":{\"content\":{\"text\":\"\\n<p>\\n    Orsino, the <i>Duke of Illyria<\\/i>, is consumed by his passion for the melancholy Countess Olivia. His ostentatious musings on the nature of love begin with what has become one of Shakespeare\'s most famous lines: \\\"If music be the food of love, play on.\\\" It is apparent that Orsino\'s love is hollow. He is a romantic dreamer, for whom the idea of being in love is most important. When Valentine gives him the terrible news that <b>Olivia<\\/b> plans to seclude herself for seven years to mourn her deceased brother, Orsino seems unfazed, and hopes Olivia may one day be as bewitched by love (the one self king) as he. Fittingly, the scene ends with Orsino off to lay in a bed of flowers, where he can be alone with his love-thoughts. Later in the play it will be up to Viola to teach Orsino the true meaning of love.\\n<\\/p>\\n\"},\"properties\":[],\"class\":\"BuilderTextElement\"},\"builderbuttonelement_1393965942_53163b76e666c\":{\"content\":[],\"properties\":{\"backend\":{\"text\":\"Contact Us Now\",\"sizeClass\":\"medium-button\",\"align\":\"left\"},\"frontend\":{\"href\":\"http:\\/\\/localhost\\/Zurmo\\/app\\/index.php\",\"target\":\"_blank\",\"inlineStyles\":{\"background-color\":\"#97c43d\",\"border-color\":\"#7cb830\"}}},\"class\":\"BuilderButtonElement\"},\"builderexpanderelement_1394062193_5317b37137abc\":{\"content\":[],\"properties\":{\"frontend\":{\"height\":\"10\"}},\"class\":\"BuilderExpanderElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":{\"backend\":{\"configuration\":\"1:2\"}},\"class\":\"BuilderRowElement\"},\"builderrowelement_1394062652_5317b53c906f9\":{\"content\":{\"buildercolumnelement_1394062652_5317b53c90615\":{\"content\":{\"builderdividerelement_1394062652_5317b53c901fc\":{\"content\":[],\"properties\":{\"frontend\":{\"inlineStyles\":{\"border-top-width\":\"1\",\"border-top-style\":\"dotted\",\"border-top-color\":\"#efefef\"}},\"backend\":{\"divider-padding\":\"10\"}},\"class\":\"BuilderDividerElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"},\"builderrowelement_1394062641_5317b53112a36\":{\"content\":{\"buildercolumnelement_1394062641_5317b5311291a\":{\"content\":{\"builderfooterelement_1394062641_5317b5311226e\":{\"content\":{\"text\":\"[[GLOBAL^MARKETING^FOOTER^HTML]]\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"font-size\":\"11\",\"background-color\":\"#ebebeb\"}}},\"class\":\"BuilderFooterElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"}},\"properties\":{\"frontend\":{\"inlineStyles\":{\"background-color\":\"#ffffff\",\"color\":\"#545454\"}}},\"class\":\"BuilderCanvasElement\"}}}',NULL,4),(5,NULL,0,3,NULL,'3 Columns','3 Columns','en',NULL,NULL,'{\"baseTemplateId\":\"\",\"icon\":\"icon-template-4\",\"dom\":{\"canvas1\":{\"content\":{\"builderheaderimagetextelement_1393965594_53163a1a0eb53\":{\"content\":{\"buildercolumnelement_1393965594_53163a1a0ef48\":{\"content\":{\"builderimageelement_1393965594_53163a1a0ee52\":{\"content\":{\"image\":1},\"properties\":[],\"class\":\"BuilderImageElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"},\"buildercolumnelement_1393965594_53163a1a145cc\":{\"content\":{\"builderheadertextelement_1393965594_53163a1a14515\":{\"content\":{\"text\":\"Acme Inc. Newsletter\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"color\":\"#ffffff\",\"font-weight\":\"bold\",\"text-align\":\"right\"}}},\"class\":\"BuilderHeaderTextElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":{\"backend\":{\"configuration\":\"1:2\"},\"frontend\":{\"inlineStyles\":{\"background-color\":\"#282a76\"}}},\"class\":\"BuilderHeaderImageTextElement\"},\"builderrowelement_1394062546_5317b4d264a62\":{\"content\":{\"buildercolumnelement_1394062546_5317b4d26488b\":{\"content\":{\"buildertitleelement_1394062546_5317b4d263942\":{\"content\":{\"text\":\"Latest entries on our database\"},\"properties\":{\"backend\":{\"headingLevel\":\"h1\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#666666\",\"font-size\":\"28\",\"font-weight\":\"bold\",\"line-height\":\"200\"}}},\"class\":\"BuilderTitleElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"},\"builderrowelement_1393965668_53163a6448794\":{\"content\":{\"buildercolumnelement_1393965668_53163a644866d\":{\"content\":{\"builderimageelement_1394063801_5317b9b9eedc5\":{\"content\":{\"image\":2},\"properties\":[],\"class\":\"BuilderImageElement\"},\"buildertitleelement_1394063416_5317b838c6ce1\":{\"content\":{\"text\":\"Property at NYC\"},\"properties\":{\"backend\":{\"headingLevel\":\"h2\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#323232\",\"font-size\":\"18\",\"font-family\":\"Georgia\",\"font-weight\":\"bold\"}}},\"class\":\"BuilderTitleElement\"},\"builderplaintextelement_1394063772_5317b99cab31e\":{\"content\":{\"text\":\"Orsino, the Duke of Illyria, is consumed by his passion for the melancholy Countess Olivia. His ostentatious musings on the nature of love begin with what has become one of Shakespeare\'s most famous lines: \\\"If music be the food of love, play on.\\\" It is apparent that Orsino\'s love is hollow. He is a romantic dreamer, for whom the idea of being in love is most important. When Valentine gives him the terrible news that Olivia plans to seclude herself for seven years to mourn her deceased brother, Orsino seems unfazed, and hopes Olivia may one day be as bewitched by love (the one self king) as he. Fittingly, the scene ends with Orsino off to lay in a bed of flowers, where he can be alone with his love-thoughts. Later in the play it will be up to Viola to teach Orsino the true meaning of love.\"},\"properties\":[],\"class\":\"BuilderPlainTextElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"},\"buildercolumnelement_1394061698_5317b182c1f19\":{\"content\":{\"builderimageelement_1394063806_5317b9be406a3\":{\"content\":{\"image\":2},\"properties\":[],\"class\":\"BuilderImageElement\"},\"buildertitleelement_1394063420_5317b83cb81a3\":{\"content\":{\"text\":\"Chalet in Bs. As.\"},\"properties\":{\"backend\":{\"headingLevel\":\"h3\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#323232\",\"font-size\":\"18\",\"font-family\":\"Georgia\",\"font-weight\":\"bold\"}}},\"class\":\"BuilderTitleElement\"},\"builderplaintextelement_1394063737_5317b979ce2a3\":{\"content\":{\"text\":\"Orsino, the Duke of Illyria, is consumed by his passion for the melancholy Countess Olivia. His ostentatious musings on the nature of love begin with what has become one of Shakespeare\'s most famous lines: \\\"If music be the food of love, play on.\\\" It is apparent that Orsino\'s love is hollow. He is a romantic dreamer, for whom the idea of being in love is most important. When Valentine gives him the terrible news that Olivia plans to seclude herself for seven years to mourn her deceased brother, Orsino seems unfazed, and hopes Olivia may one day be as bewitched by love (the one self king) as he. Fittingly, the scene ends with Orsino off to lay in a bed of flowers, where he can be alone with his love-thoughts. Later in the play it will be up to Viola to teach Orsino the true meaning of love.\"},\"properties\":[],\"class\":\"BuilderPlainTextElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"},\"buildercolumnelement_1394063404_5317b82c72b5c\":{\"content\":{\"builderimageelement_1394063809_5317b9c1da156\":{\"content\":{\"image\":2},\"properties\":[],\"class\":\"BuilderImageElement\"},\"buildertitleelement_1394063425_5317b8410f24b\":{\"content\":{\"text\":\"Tiny Island\"},\"properties\":{\"backend\":{\"headingLevel\":\"h3\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#323232\",\"font-size\":\"18\",\"font-family\":\"Georgia\",\"font-weight\":\"bold\"}}},\"class\":\"BuilderTitleElement\"},\"builderplaintextelement_1394063741_5317b97d68d8d\":{\"content\":{\"text\":\"Orsino, the Duke of Illyria, is consumed by his passion for the melancholy Countess Olivia. His ostentatious musings on the nature of love begin with what has become one of Shakespeare\'s most famous lines: \\\"If music be the food of love, play on.\\\" It is apparent that Orsino\'s love is hollow. He is a romantic dreamer, for whom the idea of being in love is most important. When Valentine gives him the terrible news that Olivia plans to seclude herself for seven years to mourn her deceased brother, Orsino seems unfazed, and hopes Olivia may one day be as bewitched by love (the one self king) as he. Fittingly, the scene ends with Orsino off to lay in a bed of flowers, where he can be alone with his love-thoughts. Later in the play it will be up to Viola to teach Orsino the true meaning of love.\"},\"properties\":[],\"class\":\"BuilderPlainTextElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":{\"backend\":{\"configuration\":\"3\"}},\"class\":\"BuilderRowElement\"},\"builderrowelement_1394062652_5317b53c906f9\":{\"content\":{\"buildercolumnelement_1394062652_5317b53c90615\":{\"content\":{\"builderbuttonelement_1394063832_5317b9d8a797c\":{\"content\":[],\"properties\":{\"backend\":{\"text\":\"Click for more details\",\"sizeClass\":\"large-button\",\"width\":\"100%\",\"align\":\"center\"},\"frontend\":{\"href\":\"http:\\/\\/google.com\",\"target\":\"_blank\",\"inlineStyles\":{\"background-color\":\"#8224e3\",\"color\":\"#ffffff\",\"font-weight\":\"bold\",\"text-align\":\"center\",\"border-color\":\"#8224e3\",\"border-width\":\"1\",\"border-style\":\"solid\"}}},\"class\":\"BuilderButtonElement\"},\"builderdividerelement_1394062652_5317b53c901fc\":{\"content\":[],\"properties\":{\"frontend\":{\"inlineStyles\":{\"border-top-width\":\"1\",\"border-top-style\":\"dotted\",\"border-top-color\":\"#efefef\"}},\"backend\":{\"divider-padding\":\"10\"}},\"class\":\"BuilderDividerElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"},\"builderrowelement_1394062641_5317b53112a36\":{\"content\":{\"buildercolumnelement_1394062641_5317b5311291a\":{\"content\":{\"builderfooterelement_1394062641_5317b5311226e\":{\"content\":{\"text\":\"[[GLOBAL^MARKETING^FOOTER^HTML]]\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"font-size\":\"11\",\"background-color\":\"#ebebeb\"}}},\"class\":\"BuilderFooterElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"}},\"properties\":{\"frontend\":{\"inlineStyles\":{\"background-color\":\"#ffffff\",\"color\":\"#545454\"}}},\"class\":\"BuilderCanvasElement\"}}}',NULL,5),(6,NULL,0,3,NULL,'3 Columns with Hero','3 Columns with Hero','en',NULL,NULL,'{\"baseTemplateId\":\"\",\"icon\":\"icon-template-1\",\"dom\":{\"canvas1\":{\"content\":{\"builderheaderimagetextelement_1393965594_53163a1a0eb53\":{\"content\":{\"buildercolumnelement_1393965594_53163a1a0ef48\":{\"content\":{\"builderimageelement_1393965594_53163a1a0ee52\":{\"content\":{\"image\":1},\"properties\":[],\"class\":\"BuilderImageElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"},\"buildercolumnelement_1393965594_53163a1a145cc\":{\"content\":{\"builderheadertextelement_1393965594_53163a1a14515\":{\"content\":{\"text\":\"Acme Real Estate\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"color\":\"#ffffff\",\"font-weight\":\"bold\",\"text-align\":\"right\"}}},\"class\":\"BuilderHeaderTextElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":{\"backend\":{\"configuration\":\"1:2\",\"header\":\"1\",\"border-negation\":{\"border-top\":\"none\",\"border-right\":\"none\",\"border-bottom\":\"none\",\"border-left\":\"none\"}},\"frontend\":{\"inlineStyles\":{\"background-color\":\"#282a76\"}}},\"class\":\"BuilderHeaderImageTextElement\"},\"builderrowelement_1394062546_5317b4d264a62\":{\"content\":{\"buildercolumnelement_1394062546_5317b4d26488b\":{\"content\":{\"buildertitleelement_1394062546_5317b4d263942\":{\"content\":{\"text\":\"New on our Downtown NYC locations\"},\"properties\":{\"backend\":{\"headingLevel\":\"h1\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#323232\",\"font-size\":\"28\",\"font-weight\":\"bold\",\"line-height\":\"100\"}}},\"class\":\"BuilderTitleElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"},\"builderrowelement_1394122137_53189d999cade\":{\"content\":{\"buildercolumnelement_1394122137_53189d999c769\":{\"content\":{\"builderimageelement_1394122137_53189d999b21b\":{\"content\":{\"image\":4},\"properties\":[],\"class\":\"BuilderImageElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"},\"builderrowelement_1393965668_53163a6448794\":{\"content\":{\"buildercolumnelement_1393965668_53163a644866d\":{\"content\":{\"builderimageelement_1394063801_5317b9b9eedc5\":{\"content\":{\"image\":2},\"properties\":[],\"class\":\"BuilderImageElement\"},\"buildertitleelement_1394063416_5317b838c6ce1\":{\"content\":{\"text\":\"Property at NYC\"},\"properties\":{\"backend\":{\"headingLevel\":\"h2\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#323232\",\"font-size\":\"18\",\"font-family\":\"Georgia\",\"font-weight\":\"bold\"}}},\"class\":\"BuilderTitleElement\"},\"builderplaintextelement_1394063772_5317b99cab31e\":{\"content\":{\"text\":\"With its welcoming fireplace, wood-paneled ceiling, limestone floor, and luminous\\nview into a stunning courtyard, The Sterling Mason lobby imparts the intimate warmth of home.\"},\"properties\":{\"backend\":{\"border-negation\":{\"border-top\":\"none\",\"border-right\":\"none\",\"border-bottom\":\"none\",\"border-left\":\"none\"}}},\"class\":\"BuilderPlainTextElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"},\"buildercolumnelement_1394061698_5317b182c1f19\":{\"content\":{\"builderimageelement_1394063806_5317b9be406a3\":{\"content\":{\"image\":2},\"properties\":[],\"class\":\"BuilderImageElement\"},\"buildertitleelement_1394063420_5317b83cb81a3\":{\"content\":{\"text\":\"Chalet in Bs. As.\"},\"properties\":{\"backend\":{\"headingLevel\":\"h3\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#323232\",\"font-size\":\"18\",\"font-family\":\"Georgia\",\"font-weight\":\"bold\"}}},\"class\":\"BuilderTitleElement\"},\"builderplaintextelement_1394063737_5317b979ce2a3\":{\"content\":{\"text\":\"With its welcoming fireplace, wood-paneled ceiling, limestone floor, and luminous\\nview into a stunning courtyard, The Sterling Mason lobby imparts the intimate warmth of home.\"},\"properties\":{\"backend\":{\"border-negation\":{\"border-top\":\"none\",\"border-right\":\"none\",\"border-bottom\":\"none\",\"border-left\":\"none\"}}},\"class\":\"BuilderPlainTextElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"},\"buildercolumnelement_1394063404_5317b82c72b5c\":{\"content\":{\"builderimageelement_1394063809_5317b9c1da156\":{\"content\":{\"image\":2},\"properties\":[],\"class\":\"BuilderImageElement\"},\"buildertitleelement_1394063425_5317b8410f24b\":{\"content\":{\"text\":\"Luminus Loft\"},\"properties\":{\"backend\":{\"headingLevel\":\"h3\"},\"frontend\":{\"inlineStyles\":{\"color\":\"#323232\",\"font-size\":\"18\",\"font-family\":\"Georgia\",\"font-weight\":\"bold\"}}},\"class\":\"BuilderTitleElement\"},\"builderplaintextelement_1394063741_5317b97d68d8d\":{\"content\":{\"text\":\"With its welcoming fireplace, wood-paneled ceiling, limestone floor, and luminous\\nview into a stunning courtyard, The Sterling Mason lobby imparts the intimate warmth of home.\"},\"properties\":{\"backend\":{\"border-negation\":{\"border-top\":\"none\",\"border-right\":\"none\",\"border-bottom\":\"none\",\"border-left\":\"none\"}}},\"class\":\"BuilderPlainTextElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":{\"backend\":{\"configuration\":\"3\"}},\"class\":\"BuilderRowElement\"},\"builderrowelement_1394062641_5317b53112a36\":{\"content\":{\"buildercolumnelement_1394062641_5317b5311291a\":{\"content\":{\"buildersocialelement_1394121396_53189ab49a77c\":{\"content\":[],\"properties\":{\"backend\":{\"layout\":\"horizontal\",\"services\":{\"Facebook\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/www.facebook.com\\/\"},\"GooglePlus\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/gplus.con\"},\"Instagram\":{\"enabled\":\"1\",\"url\":\"http:\\/\\/www.instagram.com\\/\"}}}},\"class\":\"BuilderSocialElement\"},\"builderfooterelement_1394062641_5317b5311226e\":{\"content\":{\"text\":\"[[GLOBAL^MARKETING^FOOTER^HTML]]\"},\"properties\":{\"frontend\":{\"inlineStyles\":{\"font-size\":\"11\",\"background-color\":\"#ebebeb\"}}},\"class\":\"BuilderFooterElement\"}},\"properties\":[],\"class\":\"BuilderColumnElement\"}},\"properties\":[],\"class\":\"BuilderRowElement\"}},\"properties\":{\"frontend\":{\"inlineStyles\":{\"background-color\":\"#fefefe\",\"color\":\"#545454\",\"border-color\":\"#284b7d\",\"border-width\":\"10\",\"border-style\":\"solid\"}},\"backend\":{\"border-negation\":{\"border-top\":\"none\",\"border-right\":\"none\",\"border-bottom\":\"none\",\"border-left\":\"none\"}}},\"class\":\"BuilderCanvasElement\"}}}',NULL,6),(7,1,0,3,'Opportunity','We closed a deal - Sample Email Template','We closed a deal','en','<p>Hello!!!</p>\n<p>We just closed new deal, please check details: [[MODEL^URL]]</p>\n<p>Thanks!</p>','Hello!!!\nWe just closed new deal, please check details: [[MODEL^URL]]\nThanks!',NULL,NULL,7);
/*!40000 ALTER TABLE `emailtemplate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emailtemplate_read`
--

DROP TABLE IF EXISTS `emailtemplate_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emailtemplate_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `emailtemplate_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emailtemplate_read`
--

LOCK TABLES `emailtemplate_read` WRITE;
/*!40000 ALTER TABLE `emailtemplate_read` DISABLE KEYS */;
INSERT INTO `emailtemplate_read` VALUES (1,1,'G2',1),(2,2,'G2',1),(3,3,'G2',1),(4,4,'G2',1),(5,5,'G2',1),(6,6,'G2',1);
/*!40000 ALTER TABLE `emailtemplate_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exportfilemodel`
--

DROP TABLE IF EXISTS `exportfilemodel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `exportfilemodel` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `filemodel_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exportfilemodel`
--

LOCK TABLES `exportfilemodel` WRITE;
/*!40000 ALTER TABLE `exportfilemodel` DISABLE KEYS */;
/*!40000 ALTER TABLE `exportfilemodel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exportitem`
--

DROP TABLE IF EXISTS `exportitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `exportitem` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `iscompleted` tinyint(1) unsigned DEFAULT NULL,
  `exportfiletype` text COLLATE utf8_unicode_ci,
  `exportfilename` text COLLATE utf8_unicode_ci,
  `modelclassname` text COLLATE utf8_unicode_ci,
  `processoffset` int(11) DEFAULT NULL,
  `serializeddata` longtext COLLATE utf8_unicode_ci,
  `isjobrunning` tinyint(1) unsigned DEFAULT NULL,
  `cancelexport` tinyint(1) unsigned DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  `exportfilemodel_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exportitem`
--

LOCK TABLES `exportitem` WRITE;
/*!40000 ALTER TABLE `exportitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `exportitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exportitem_read`
--

DROP TABLE IF EXISTS `exportitem_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `exportitem_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `exportitem_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exportitem_read`
--

LOCK TABLES `exportitem_read` WRITE;
/*!40000 ALTER TABLE `exportitem_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `exportitem_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `externalapiemailmessageactivity`
--

DROP TABLE IF EXISTS `externalapiemailmessageactivity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `externalapiemailmessageactivity` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `api` text COLLATE utf8_unicode_ci,
  `type` int(11) DEFAULT NULL,
  `emailaddress` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `itemclass` text COLLATE utf8_unicode_ci,
  `itemid` int(11) DEFAULT NULL,
  `datetime` datetime DEFAULT NULL,
  `reason` text COLLATE utf8_unicode_ci,
  `item_id` int(11) unsigned DEFAULT NULL,
  `emailmessageactivity_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `externalapiemailmessageactivity`
--

LOCK TABLES `externalapiemailmessageactivity` WRITE;
/*!40000 ALTER TABLE `externalapiemailmessageactivity` DISABLE KEYS */;
/*!40000 ALTER TABLE `externalapiemailmessageactivity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `filecontent`
--

DROP TABLE IF EXISTS `filecontent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filecontent` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `content` longblob,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `filecontent`
--

LOCK TABLES `filecontent` WRITE;
/*!40000 ALTER TABLE `filecontent` DISABLE KEYS */;
INSERT INTO `filecontent` VALUES (1,'GIF87a\02\0\0\0̖Ū\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0,\0\0\0\0\02\0\0I8ͻ`(dihlp,tmx|pH,\ZȤrl:ШtJZجvzxL.tT0\nv``餀^jCz}msnyC\0\0}#Bmu\0D\0sǞzn@׫\0{>t4!`8{qWԙ6d\Z陨aYfws83:Xt2!u*\r(rślƼh$K]\"Wп))1(á4q\'@G]^ec\"~b]˶۷pʝKݻx˷߿La\0\0;'),(2,'GIF87a\0\0\0\0̖\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0,\0\0\0\0\0\0\0I8ͻ`(dihlp,tmx|pH,\ZȤrl:ШtJZجvzxL.zn|N~љ*\0%X\0X`\Z\0[AA0B޺	%롬xBo*%<)塎SBOv^`W3\0@siPD$Vpb`g\rQz\0VY׶1/,,0ڗh¥)pUbz#H\r\'ئBJ\\rjlm2zAT-A\ng?M]EJ:ٱ	Ճ])ӧI5V|a+q;3	To͋Cwz\'d߈Qպڶ\0*o4@nm%y4|7}A_<Md>\nX4fv ($h(,0(4h8<@)DiH&L6PF)TViXf\\v`)d:\0;'),(3,'GIF87aD\0\0\0̖\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0,\0\0\0\0D\0\0I8ͻ`(dihlp,tmx|pH,\ZȤrl:ШtJZجvzxL.zn|N~\0\nH*\\ȰÇ#JHŋ3jȱǏ CIɓ(S\\ɲe\00cʜ)S0@\0$\n9@/j9ϠCy\ZuIU: 8p5\0 \nt\043mzkرe~J7;^XT޽,av3x/zR1lɔ-_LWs-gF `3M;૞1N\r[lʵOcJMU8:fn&r \r\'ZuW\':}WZ@`o)ܶ>!LIk{My~E^	7wY0^ou]\rV\0!g!}	Z 	WAVLNbL\Z1bLH`3$HS@%:q^ФrI`K:2 MR$YP&\0F^p&\0k\ZӕeZirD`ťL\0	#=zTI~JHSC\n.wZ:)P)igerLHRĂP\0(j҄fppy*LD0஺`w@5ZyF t\\Wjʚ\0dx$^KS(\0P,^pc\0yWbkoZo;o+c2aWc&O02S\nSq1\0+|)j\04₰0\0v4)]S=UŖ\Z +gZv=ڔ6;4rh\ZYyӺ6zmvd#>@~bOw3ۘK0tVY܋a,3ŵLgjyʮ:w(#asF޺9KS@],2._;CQ\Z_BO> \'N^K~LDr_$ Ͱ\nrO_{y,=)T\n	V3ȩ;`*\0Bд/\0T![*Aq03AE1o6QAv$D+<ڄA\Z+]&0ėCу8a{hQki%RF	038dA٬_-\"Ưݕ3UĻ\rG?xםbTl3G\n2hK=	H)%y(oY(DH!q^}eܤ9y%+Cyc|HuID[\\ O汌r`֑-]βXpu*۵*ar!/U&l\"R\"4ew;f\',(5\0!Nryy2|:[|aU\ZKr}sVGur3Q3Θ25IJyҐ`cfͮHr}	曝fj6Aze-%\nHӞ2wW?$UTx/\0SuQTB\r\n?!\Z\nDA+T֯\r`K\ZMb:d\'KZͬf7z\rhGKҚMjWֺlgKͭnw\rpK\ZMr&:ЍtKZͮvz\rxK^D\0\0;'),(4,'PNG\r\n\Z\n\0\0\0\rIHDR\0\0D\0\0\0\0\0\0B3X\0\0\0PLTE\"\Z! 0=\0&&&05)<74,<X\"I8F9]87Ihx;DB=XQ?cvGDBOWCPNNYVL[YZEXyPqTa\\J`_\\keUjuYlBeefljhnotzufyws8xKeWq_}_}vyb|jpsxk r*v\0]yrBmdwu~{Tkjru{ځFWs8uM}XkLaa)2\n\"1)>2:Cwu`nDBWHVN8HTY`ޠ4	\Z)$=ƾAҴAԡfٷ{MXrXubhƋˊӘƔҗو狵䙷画ױͣđװںӸڻʤŸߪѲܲɽּ޼ʃϒѧݽڪ\n\0\0\0bKGD\0\0 \0IDATxڼ[lIzdYۂ !h[RѬ\0ѭbe[^{[n{Ep^\\&|C%KՒ܌DD\0|FUREf.ىLU,^3ޘiXU$+#Ǿ)^.[La\Z/R\\ްu;aښQơ\Z4,F\0a1>M\'31FjGiHO{2A#ܽ_嗿W_\'42zXū>.+X!c\\6G°+gXaXtS9{l7\0AQ޼y#g+GI\\=\\de~͛Wєk1A0r«2873Y%9~`^)GV)V|6݄qFW[@nuHL[nJh:i?L06upQ.	0D75)e\n\r553>;M-g!Le~/\r۟`\Z+m<KY\0ij̋a,rwٌk|7KjNntY`xUa,D\rg\0sKUR<[Y|`%?e8\rb_-N\Z\\Ao-|!咣q&ncՁJ{(#DrI9_%d3`g\0e.d\rMVsILI̲v%&-4쐃4XhFY,\\	\'đx?_m2V Vkzx;h_!t*,-)\\^#|K`DOȗON\0Q!bq%ïV\'aIJ֋אw}/\",tB98Bt=C@Q>׉#7-W\\g;@4&Z_|NewI$W\n\nk$HPqId$H HWK \ZL{@\Zg$Lai&đηB\nǐkP;M	|s|*Gm6D\"H\\=bBKL^_1N3;~Hk7]ɧ7_Coا89y %,u:|#(>+<y2@gyf<)KKLfmV S4D$d*o8<j/g8+e	TgK6(T/1Q(WZ:R꺥n*\'K 5O\Z0b80\"cqĪ͢EMhm:7AQ>0şR\\xE+AR^8\\O~ϟ	۷o?כDIG\'Xx0%ju,(0%0L4$	T4Ç[Z,d{(x_r^,!DTI!gIB(,0Ĵ$`h6|=\ZBA Bnkhd@X¬LᯀߔG^KA~	\"\0m`3?dE5P$\"%zPj<g8892!80&	\rߌEZ*e_WgcG\rU@TsDd^{*غ w-Oo8ec9S!\r)	|é㢈Uk3\n\nxP7jVf8h7\'Ќ\nq(,Sj)0]H#߆eڍ\Z́]D\ZcZv4yXď9@m)6UJ\nH({\ZJDy8z4la.B2iy**i%׳2S}Dj/t֯ukkk\\N4x Ҁ\nEn].?ЬFNSn2U\0AOD}`EڌL 0đA ,$+đ	X+%w)t\r,KHJӅlgC`;\n\Z|DOd_+Aߧ8ANvG猼C\'}\'OvcD3+ʣhPg=;`<ܫ$!JHeB[/zTcg큛J\\R6,_Zf.t6\\uˑz$APi]qxM2-V%,Gj)s!6A/wf㨈\0*{[БlJdPυ<G\'P8|CBwyt1R`!$Zfn>8K&`>?88`DvHє$K꼎no]{xo4o::˝\nܜD 5t)(%8)#\0Q.!{sAз%d˄0Cuonl6\rAyEYUG47gwł2#LMRiJ;*Q-6TPRva,?]\\\\\r?\n6W!\n)\nB,\'V1\n%$PBZLٯV77W:Di0C BE9\\v(\0qB<y^w\ZSr襲H1l?3́ir\rd[/(!4nL1Vi/b\ntF.G#Pf5PhЪ׉ooov>M\rj)_JF9ҸD=+K*|ޡ9%xP@Dw6\'\"]W;`o!IItveuu-M brvAjܱR0:-ںb\0\";w5)e\ZWBϤVP[B1R`11^t,fF*q$	&o~D z\nNx;cK4)Y)X\nK&\\9_A/}f[	\0faE#ǌGYJ:{loIV(Ҏ=5IOQ.jV\\(mm:Z֨c)50pV($FY(BjMu8]aX$1#AL@xcB?d#m\n|/#>9G%kiLJ*()/J8p\"o,q*|/+}`/8<o\\gkyQJ.vĬ7MxEb#ÃO92e2;-D$1K9ϟN{1;zu9%4q#41K|w3΅/~M{ +%2\Z\0KA;:qbr;qd(nDl7_14 =bn%(̱QxV$\"\0A?8?>46չ){gq\\Q2	T;J4aG˔LLmV,F)VkDhz\"JZy3˙0~Ks\r9_`=t7</i:c 1*BaFc s\0Mwg ՙjtKcAŎQ.W q]4O3R\Zom((V*DHR1Q4_;D Q\"ݷ\r!T$r=JSLFN7\'J*C2/J{c杮	kr<qq)\0\raKQaɮ%Q!\ZW?Wd@u\n3ЎJBЊfၖZkѸ>txz*/إN58xژ{<?N<_jq$u0x	9*Q1J fi`HQ*͐|H\'}pzQ9k=9q,bUpJZ:emtrx>nqǶ^x+RhMH2O˾2]I B<|4lޯ⣿9[\Z֜T`\"\"-\"FcFD5`fm-\"S>@)vv=/`*H0eD_\nq*Y\0BUFU8k2ko63\\$0ڱAGj\re0|0)ٸdvdA<Yt\\MU\ZKi1.\0፥|B)H1kkk0.a{<s]!\nC$rewgj4r]Pgѯs4~/-{c\\U&\"y/f\0)[3L\ZnW)ȑPp3t\Z\'5,ȅ(I\Z+HH:HVPDBΚ-3khV_A!=jDA1\"\'71+qQehVQPS1C,$JX!Ar,N=\r&ܘJZC<|5u\0klXk6һՁ\0fL%IOcZ\"s壿ωB;N+W`Y{Q&\r@bLuTBTu\01x	\Zk99r$ڛ\\.\'up$JQJqQa.?{rY̐M!̲5<p\\cfd*T*Cse!<m\"R^<+(D\Zt:~Qyәu\0֎TШcEO,kݭ4vqk_ßDh/ַ~?k\\GkWDSwٶ4/tIٞ;>xkmcayav, 0ug}q,jPITZS#lE%Z.7\n76|*KuaSJ6`}Eqr)Y+k4}\"+$!*ɧA\n}xG1m\Z\"ޘt֦Tu㾯X]ufwjņ,\"iH𥭗Okxi<:YY;YF rWkke\ZY\\^.H60Z,zUT4f\'cYc)PXq|D8ױ]/)i=jȬ\0#(r%&Y($4J[~EEGCF:^z@G!u曗J\",#u_tlk jgVMlnvbh\'HBT:4owɈӼDI%}*&T@\"VkZX&բZM4I%Gt6wJ\"8ɦ \" gmF4\ZV7\nc=@Bbċ%W}\\^\0+hy\"\0EkEʗT8,;ҰnoodAc% Kenv+-D(AɕVQS课g~.O\\AQKdq\\\n\Z1Cd(aèM ѩVPQn	9Vl<Ӆ)H\Z㓥f&{:n\0LPT+3q<TEq`7RfQ|>@A6*JF<,`cX;\0A{c낹utv\Z>wz#[hBU؟Mt@p ?C\"k\\UN^YfID>#>sF̼)-EEQI#x2,OV2Tf\ZqQPlff| $.<ѵfX\Z۸\nS	7$Ga0JRTtĨ$ڍC%0w!>dX\n#ȣH\Z`}}GDe%-k7NHNS\ZV(0#B	:4VuqJ\nqO&1]Dbا,9y,o$	|3g=YP:3BY|mJvo.(gmppWK	lӋ\rJFT% Xp׎H3((JU5-dI xby# Xɒy$R\"ɷV5Dv6SkLg~&!.|DQ5`p7\"XLi(0M\r\'\'-+<`eA~$rh֠\'=1iV:i\"$kWB`4qO #Pt֭q1(za<726\\]Eȫ0hr\'~]obU(^$K&ck9HqsXV	»D{hY%.<Y.Eӡª&?-K\",B#i TUL68êؤ7`K&BjA@[/Oz嬭ykAa֦ j1h(PX#OߚyoY#{z=;f$d7Kb͹RfVTk4*!p<L0x%Dr8.yR	[GXBi}vQC*j5SgG}[}|߄\'iAjA䤓wSb^Yc(LLIl(STemaYsc.qX1C֔Y$q$6Ƣ:$¼77nޝ}I?Y3\\\"OfFF)20431CWLNNj,14]AZaMH<D4@%!*I明fU@9|9OKBR>/?q㴖0V#̈6{ë}{	HrI87k$sAi\r%,.oY[ߟdA:1(	1+=Uf;->\ZX/ffoN$hޭ~Fn~Dn7#y\"!bHJ7ݳJ|vזD\0f-^&(6953<qΆ*_*]t4<$_Eb⻦\nh(B\"차4\0?6ˉ7}KWdL]V@,3@_DE=랝C1u/hi1ois?=7\0n3Ksgf{yz\"KeR,IC%#EOt%j7>nk\'kߢ\'JC(2Txhv\\e	۬R2WD!\"{2a+k)p4cX8:\r^70\r?)\ZUHtPbqگ|\0{K%Xor{-\rA]4A]]도uGk\ZꏴyqCAc.4d]]](><FكG+QCҥaJ_9)@tlM3CT+ \"Qrٱ4]|th&q8;g05[Z|[Fv~u1dY	~Ns\"&\n+@,5kdq*ҭPxW6\0UdA\0N5ҎwD& ʣY-	Z\Z<H^Ad57;Fj w{[=tdeH݈!2;ev:̈́-斥ѺgQ2BYe2E;f)@t|\"a$jKKά	bQH!bZYTZrPXZ|vu%D%31/bO?\Zw`֒CQ+IiŬEH%UZYg৑-Uؑ\r@NYdo;䵵fI(<.7i6A4-\n\"/GfzpH7̸o.r$bCdAQfe@[(.ﶌJFF&B-QLsFOi^\"TYq^kݶf\r|W<+wu42G\n>D4YDtՠ~ ˏce-h%cSRֳY	Ȉu0)266@(<exQVpO@MDBCuչ.<Wv@a[Vgݙ\rQ+0z\rs\\q`FpcHf,,êI9@BdԂ6olxNxv\Z|C屈ƛam|*G>@D6ٞvՆYz8~TCT\nrښH3\0\0 \0IDATנ\\+%%N8ԇ^UQ\rb,s;Ki*Ƃh{.9DBYA:@tX\\V\"9HV:/Z-#C+]zR/P[oOʼ=A:EL|TΥD<[\"\0ҋ{xmI\";</`&gV9hv$jxdD\"vhh=D3h}iϿ??La\"\ZC6B+Zq\"}`Lr+CMۭ3=,q5t7ͺ7{N3f+	.xG	\"ܪiz,.[o_ײ&QD03Qxj\Z-Dl;m6dHFORX.-]1aG\"S\"L=4e5>pY}sCs0V?9\0y}\Zy5fV\'D;@400DhWz\\ßg{\rCj+#SH=f&DO\"愺qWMOTAFhDɰGkvaHUt<󀝲B<3;;;J7VPN{\0xԕ@\"{5B9T__\r;!hσ\"iGe=VΨ-XM=*bϵ 2-у/Xں܉}lb7A!UŅ C4@=($τ6+Du\\Q]2J\n_Crh!3aOrbc	qJ\"wÍ?gnB|Τbx͇7{zyt;;rphZpo`oOo:3WĲyvP_e5y-΅:lx``\Zx&4LxmH%Q[<*15?77k9ݶ5ף_ ڵ~ J[M\"?-Xn!hBpJ`ׄC\'Ӄ_\npslވ$ 1nYn4BoG-DS);,Ą@`{	*G\\aCq\'Z4Ftv%gWʫ(+ՀH8g8h+᪃:׺\r>Nlh/-}Fm۾\'ӣΪB@l:к!F-1tU\\1;!cU62aL\"ȶhAYZѸsml4_q#~Dڰ˥d1cz=}ۑ`@6c	{kJXHd\rJ9{0zF8#Լ9\rmnPobKYuѣ!`./Wf>@m**\ZqnXJ24o̨1Dvfn\r\rZb*dJpQU\' K\"z%Ҷ]FbH\\llރky1,,Tg+& BA.~#\n\"GՀ[ODO+/\n;M(5ײ/[Co$ʤ	#iW3M?h#@)*TH7/^|9Wy#\rrj嗘N/yRՄȁUuV~O3nbڭ4ƱIC{Z8<J19¨`\r]~=%i\n3$T;O\\A\rs S1uÙk5\nQ.->AvgW_X)dUSv?D/_+-	x9	8q1}-9^al(-em<iJop;YwOf\\웉,#DWn^oF:~%\nxmI$!\ZN\0ǯ*{xhhɫ\\z\'b\0dޮ]|WO`GdS T:(n|!m%0x2[mI-4ѴE㐃e[$@*trܔ7\":f1kzGV\rk7x<\".%Ukqc\\L)L{Z\Ż9)妞\r\rh.\"#Q `-ўwZD9+|qi~;	\ZByCn\Z \\G_WjxS&E1MLVkhiڌ(15\0\\BNP=4 R9Q*2\n3p߳®V/@n$r`	߰E\"\\CA${˩UeiD t5\'Ēr.yhQ%ʽ-H$L_=1͟<	\rA&\'\"rsau``bLlFB\Z-Oo g$JBYMեqHv1lp>?vnyo#oo(DU,S%a8#TWaYDd*E=D	Z2j7,,ji\'v/\"<=m%2f00\0_0A{Tw;qڧC}9ZbBғgi\riRjV+DšYr\"Cro(d(xm~).]Iĭ%F[`Q .	Hb(He2j@d%Ć	G	@pK&CQD6oOhaV7o-) (g5taIZ4\rXv(ra,~(¿mSjI*ڸUJn^xT{iI\ZGRyԏ{~{-+70)rWbAn<ϑ7lOt2j]y5?yA% ڡ\"-d:žQ]\\^\rbXC\"(zRgh]ω&CN\\ar#WY&Bp\"{HKڍIT ^)f.[*;\r^[G{nոn5ap\\2\rNbՀD\rGF3eIK}6 %d\r dvh4)\Z412[bBҁ\'0i(C3뺄hnjb2Q  ,Hd-d! sC\ny#~$௕mdޫ M`C3̵#\\bs̶aؐw@Â\"[cMׅ z\nixf x&JA\reUH$CCOLX r5EvRLIDUhWPCAdL]ૃˡrXvVE/怡k妌@D	,*U a	+gDxZ$T}CA!k5MQ\\ݠm1CxۢCuEG^\n!V\\xqϺN{.)@#T!U`F\"lі!\ZH9їNpd~ύȦ\r-KJ\\qͺ\0QlUx<j(f0u];=,! 5Qyh\"-iqSWYBOk^IM;s,fC6cDퟪB/߽u*y=bhiWle5tƐ+%\Z18*{mݞuTĩw\rjFwB.]Ox¬F\\%{>f\'{OIGϞNUh\Zhapp\0|?32D{p7\nz` 2juӕ3c06JY=yFk.xhUIh\n|;aoHmdxŽ{wo5]iv:Ƌ`(ѩܭk[h\r!Ye,:{nz-<f6xEU76(z(zBrOʌ}N:;t鞡ёQi` w̉g}GӸ\r|J` Jčzj=p3)n-jYQEݑ6炢oBI(U҈Ɇa9XĶZ<|+W+zBWoS?UͻOW54[6Qx\"A!8gAws(J\ngXGF9v\ZWP\Z<%@0\r;1r~<=C#==<3rD> ĳ[	 הč!m&3,&*	(:@v$:hLE&Y1iT5rLH\"@[%wGgF/s/Er\0;ItԸvLC{`(ы/Ǻ57il̬j2?8Ԑ-?)kh:Dy0c	@<#1A}hDtt3\'FA<N?M@]6wǽ FN?C{Uo*S)&kѝG<<&\Z1{%`כ}rGeιBBvaܻ镫m0uݹXd4\"vx=s,:!\"J\n֌^ݤ00^)J#F,moyQ(\"noVEK dޞS#\'FF\0Q_@t\nXEp:fӉ3=N\0Qe&D	Lh3 LݕI$Oτ+\n$]sɨ-[ǳiXw9Gk;_L5qQ-P\\nlCu955]魻fbR-n]?@j˖hd[Wg8B)&ׯ=?Zԉ\"PM\Z>@}|gгF\r&FIwTg=OmiGwh)\r ʨ&m:o>Jh(qɁaMщk\"272x!h@}駷\0\"gP(d2r!\Zˎo67N4%\00Ȓ	<\'@V6.ļ/߀O}C#N$)aE\n4Q;1P1SR~L GN^gzzO\ri>ݓQl`xDCCdpMlb>)WxQo*٭ܛWt`D[Qhi\\4޼ۋs\r{KKո9ˏu׏`c{GX*z!TE7\Z@bfwM0d4Z\"WK$a\Znp_z5=(v(+DO(@\"!Ai DQW\'?|ܸ1RUzq9S:/}n*|^}b\\{,I *ՙ\rfOZw1u\r ϋ)a!*kTt7(\Z)iT% *n|7 3T{{Ec[,iWKL:g1sda1DOARz(Me=55==\0} ;\rV\r,qY\\$#=j<Q~1Ͱ~\rKr,ZԿ|+H\' ںl+DIC؞<|80Vў!C{KzkE4Je%Og|q\nhMjĦkAW%-5qO*@͟+U3`-ߛyQ-1A4\\.AwuYߋ2nq\ZZj5X@\\nJ+Vw uډhW.\'6UnQ\\/$X)\'XΘHzѻ]MՁ|YKtkIy\"ӈ|,Fl(\\~|$6y>m؋{7nqyuO.F3	 \"!`q˕H)}HqaH=nb4h\nܸɟUFWlPv(fIؕSC\rڛ]-:KxٯyK4٠OV?푝h\ZGQ\r0nEcW<<~dn{;;/3{s+?bNjUg,2\ZJlϚJvY}}}C=\'2EsVG]~41NY_6+FpP7*v丑qpo%pMQ=\r\":ǋM.!h\'>#fTCfz;dN2َY\nfz\\**(R7ڎP\\:ܙ}afoI~=Dg2F()p}Q\'B(84`\0b\Zi8EOzESdm#\"\"Dbh_.m`@kj3阊Z-&D<|M䛙z9ɺ2:	.>\n{}k`_%%|xo߾0{ϟp{?3@X<<#	Bl¢v	NРIx#\Z(%jׅpJk2`\ZE(v@oZR<\r@)ԕ\"-`sS -&@Yɢ3hۜ!\"d-67{̽py/߾|@}T\n9P L\0FUH SYRqLi^O⊂R@e\rfA)\'z\'~258^ 9S3 P\nmF298덕x\"<jCG̓.3s۳_>~_~WF\rAn(nE$!\Z.?\nX3u:=JAFθҝh8 6%382JlS9I&({]\ZDqZ^68vqittZF@pѦ(`Ȣa+ Υ^k;{_̒\"|@IjPB4L>!NL3FH,jfH)lN\rJ~.0{9zE\Z9ٍ_m\rkI[]!!,\\GMW\Zb.\ZOPՀ\"2yY_eWwX;<ɋn޼;@4܋7WV?Y]/\\cȆ=T!C*7\"t\rckRJ6`w}V	.9g8{7\"ADCiQ^r\Zn/#DUj@Dv5^FI)kA4R0xba}b;D9x8Svs\\OҲ֝P\r^P[Ǿbf/n63s\n\"\0QB*-!³fݞgGۼLU&:X:Ժ>8Ocnu#{ccKHbdT=J{mw	Py?`-Fv	[4󱣛纾<JqC`MX$:Y`G;]\0=u~pu{O\ZXDHQyܒe2<bN,n7Yy;?ʆ#\n/`̄NцuсGIXDGw r\\axtTwUg[=*UNyYDcK㡝J5ZA5w).ȸ	6l&koϟCVfgdaea+?4,AIĿ9B0+BR!˸%E~̱D<x.\"leEe~\\sy5O:wJ^+N8`j3$IYҴx6K̮))iQ[,,5qTp<K3>RC\\\'v7.uaι{3@aûN aOzpV\" ;!ˊ W/zǽ )$Qg*^j\rS_c4ZFX~Odc˹\0\0 \0IDATT4}5Q=Q;B \Z;LѮ1LDs9pl v@u7:;<p{>9\"!6eh9PQ^(/Μ~2_y=IВ#Rڻ1ZQ!joQ,\'\Zi{Ydh4j)-5V捥;gF58Ag4jQGpw8T5.A\ZM)#WC8=Ι9xڱxZ;Wan<uyO9i1!<a\r[F!؉9w{.^˿^XX؋[xheEƠd!kgmطZ9gll\"VSq%! sR~0{VS{D0><U S2d&j\'v\r=dnl2\\9b:\Z;\'KQxHGaa-t5o~~[}nfs/w2`M[c,$3E,# z&Vyԍ2,^Q\raNg*nK6	Sͬe^+@\nD`)eVo!-QBGf+?f[ccx\0W?VxǘSq\"*.76d)kܔw\Z?)2(sgg\n{\0)\nDh% !c\ry+.H<ղݎ{1Iƌ7Qϸ5蒡_=x%Ⱥ[`]rΚP-ֆ9\rD[@uňD;BUT=GO\r	]p?j 9mj^Fi0\rl̬1?:{ڹ33\'|a[7 To\r\"A4P$D|ñN{Hwг6!@(xi)N4Uk]o7{=9HZ06֚~6	L#<jԝ$D%nG5DdO֝\'aF9}3hzq޺TthhD0aR\rD/_2r\\[೒r\"oӆrLq!)YJbހWffN(\ZFһd08k%u&(uThC:4?-j&\n}G#[7Im~+УlY;ZK;>vq`)|\ZILh-MMOkHΆ4Ijm-j0mS(FGWVWF$DW#nFFVZʐ}ByT \\ײ<ܬЁΘ1a\rHlf<t&=/fΝb1؎?]o^Rֲ+U~8POe`ǛZ!Gd?0m{[C:Lkˡؿcsҥv<<CɝD&D\'OLGY77 D&4n֜F\'^9l\\녕B$V޿\nHl޿\n	ɉ\\	AzL[߻tsXԗJ6_	Mǳ,660<ͥ2\"aAtE\"GMMfѨ~~rAh;aa辵(z*4V*ǚ;M( $q.p=^ei5<K\n!i6L#`N=\Zk9a]w+(fr|	yܽ8ݯrm8~jJfՕ͕ՕёGGA|:XX,7>Z-0z2O2SQ=^nn6exȣ\0| Pb*$@_\r:#\rc0qh[W/f.\\XmWwε}2(Nh#3z\n\Z\n^t]<;\0tIټ3n|MqkZy\\Ks,p:aG!lr-75 a\"{0@7vwDG&h:P_`k;p8v<0\\.o<ز2)ѮGO]}=\n Zz/l=tpp A𷅨*sl\"k5D}1;K㝭wABS4dIH4&0K/NgUDݝwJnp23CH~*(\Z\0X \Z;돁\\\0DChZʥ٨^>hlMਸt,\nVFQyLLQȅ!2;aX^;8jb=fN=pjmgpkrk\'W7n,lل7GA<ծ\0Ń#fA>mO3W_PgVbԝqiV\"!X@U\\sg@F~d\\OBD^~-QTS!\"%=\0L0q#ea8:Vbopܝ`O9x2FZv!*d,E6N>DDe!Dѫ0\0\Z=zgѣGAu]s\Z@M]u;`=\noQXYX=z}@p@as<m \Z	DN;{XM~L݃_B8\0CV)\ri;N=q%MZIkIŦفH_]s˗-z1XD.Z@h<\"@d(ԛeAn(譨:71Oj&rW\Z#ɈM),PCξj&:Ǆ6°sUWkcG浵u\r;-y`ΙX^yPl7#b\n&j-V.09{DYt\\q\0_\\ϥ!wv:D\0,؁q:[QD9掖C5Dׯ-YÕ.ς0|sut/(8P%H{0Q$!*M$!NwCw,rF%C	H0D,Ň1Nl$L\'\'Z؃9W JgRQ.ʺNkGz嶃Nre7w\0@t~a`G\'OZltqude\0Pe<(<:ѓ̙G̭Wfc68wvxij.JS\"cH~!~^<;ߞ_o(7Ĩ%vChHfሢqީGfmQ,\"0uU2vNt6b	aRԘN!L$DE	nQRj.~h}]k;ztZ<E41Jm%0nA N\0ɣ?Ƀҵ =wdcCF@?濦/;::;dZ`ut:	u95!-Ʀ&мC|ӧJW8A._~ۍ{pШ\Z=s3C2Hm\"I@d:]]Nñn(uGFONҸƕC4.[$ʪ=Fe͘g%)J@4dhb&X>++X~_54<-\",.R	Ϊ\Z+#E|z܌^D\"9-?S/\\²>q.KϳYGD#⇌\'&J]o^m])ޞKw\'+Epޕ023\"YBT7-E-sZۺ05bYd5\roQR)ʗ%a=gz{ Cj&Sx251===5jӯ@íQ3 Q:}gQ^ ($ǯw0THG@{c\'>%shrdZ\Z].Y_[M	/]	axHPq\"qʐ7ե<0C+1)E,\Z4KQ#ܢZRY/≨y&4rDUM<yUoOO8*ٲZ?RQ(xn]GwLpY/7wDׂjU*A0+%D!s\r՞ƪզus<K8Dң;`\rp.\"IPXM	Dq 0Sh(wԑ@!^O,CWĹ_^h3kBl:	Ѡj\'S!^JO	AԿ#Dt;k$=G;DZ~d#^0d\\\Z2;ʚ~Ftyc{?Q>Fkp/,f\nvƳ儌^\Z=}Z00fɻ DCDvbDi	ǭ+*P\0I${wPCJ$rZ~	\\dvG\Zܓ蹥Rm!z;D	EǇ4/!=A?C0!Bd)&BbD]y..^:]mAeE\rmۊӧT/j!(푀ԂbU~Ɗ\rY&M`QgY[`!2?H zJ}44]!F)z~V[\Z겧SCg`|XuZq߯6gi/ pyZb]W@;lw/.+\ZÙGVYᧅL-ğ($ 1A\"]hU5EƓFZ@f.EoMj3[,rӌ\"TSSrZn\ZJJ\"h^V5+D#щ;ʬF7)pܩG؈!jV$Cr94nXJ9߸G<j>{6؎c\"J{ئhm/$HJ!G$D̐E}=N.)`mS+ccUX2]!$	|cWVLL\rdUDM^Z5 \"\0lm z~~ĿУeVC$-؋\0mk2I0=2xب<{)]rVydYH؊1WU/\\sD{e4(\"N^,48Ϣ?UWR{e\Z&\n(wM\'>VX`mCu4Ts?S\'ZD\ne	xX4)o& cD++QuZatPXn9|V$m&BԎP\"}D*ONJ>%u>?3;{{ukv.[ak&CQU`ۖ4Hg,UңgB,=}:ZSϣ/`a劰atWҨQʖt5KpMEDDd[v/c)V׭ba\ZH׋Opwxm- ^Z~E͉KML*T6eՇԐ!\'i\'~X^(1:oq+˳3^]Wm5ꁧD׆(\rTyr>׳pjj\'d̍jitApY>[cP%\"fMB\'ՖU-Hq[eȑ}hmcph[;gAth!\nK$FV+.ntyNp|{|{T`G$E?`a֋b\\@ecۏ>Gw@}a뷁\Z\Z㫰9\nɓm)\"S֙gFϜ]}|zԙхgN-GgFFzz?<ey?u7ۓ~@R^mu]=h1]:6 \n,nX2ҘĶI\rһgB>@rᖍKu6:yku<zd͖-O\ZkwAk0NO7=\rQpGSԔ,@SkTOb NH٧;^Jϥ;Xt%\r kmvb#ATKT/B=@͙3S鑾F֩S>ctO{\ZELP%R4?>qo״ʷzB,,KXjk1DUٶe\0~u\\=.#խn=Z}珬l7<ZyTyG6Nary-\nEUE61\rwˤ\nE^yvx4~ۗ/_n\\y9Ɍ.E4=MZ,5G|҇]N/>ubTD҉=#}zz<Y81Xg[NxdȟI982U\nي))Z \\4ro}4\0yꙒ_?qb-04\rĞ{	޶\0Qݑ͖Y]Y)Z]=T\0P٭7_Xwܿ6757~ Y<ۮ5\',bM#F_^8w6عgn\'*!Ձd$U}z:Ny\"yd~WfS`mgNYtqPkNHȚI-u^Ef%3lvQeGhI*R;Ֆuub\n\0*DWVVkX.|I~G!1DgF\'jx*qg~H%2>{5Zi}~v~NDDCI,+0 \ZgJb~@d\'zNkٙ3-\'FϜ91TϩgN=:,w넉/3உhנdta\'G/Z\"n0ztkV-yDSM`v-M\rm	3D6),SKiyqec[rK[M	8-B/UH 肹nh]a!yʄ\0C\'sӝN6{Cq4j4[< %׶FÀ|{{^BmqV걱1(~j->揮xW&@y]\rj(cbUW:X!Q泽1Ղh%3n[_cYѬd`INQK0zNB$iU1P`K\'V#`0\Za9\\Z9a!۞QYaۤOfXigc\\,t~]U\Z/DsGh_\0\"3[C{[CUu֪6Aܪz>5־ڃ?\'CU(I[t <z</X+ZLC!ݝJv7m[۷$AhY%qopл֝\"/Iv~pJھ?3dX\ZΎKhwv&8ޤ5)Ebho\"=OT>ZJyX%R,+(\"ĚM_f J`\ZYzԦ)Xjl)}un?lhG3$%;p`3:aVl2r*!<6חK;NmTN\nmUeU4;tHcƾ@zҁ/\n*o\'7ʉe?_Z%,͓pߓzO͐ ŲXIK+ڟD\"J<ciMᏄBACJܦ¯[7fpVE\"10Ɗ|AY#!neӲRۼ0CG˨mly~4I&ʁT;rSM.NfhoݚEJC_2xgQ5\\a5DvR!D]LD/he3D:$YI,&r4\'a0L;+?;C!x7D|fdt\Z+@EԗZRAU}|.hq*SK<B|0.׀esծ2$\"\Z4bobAߊ\"c\nq<+4?;|(Y!7H#^! i5ɍ92xmfF_\0\0 \0IDATY34U\0ݿEүٔ&ȬMv	cU{g_QWo\n@Dfp8QaZԍG7?COTu셥ADE/z$K\"\\6fnư,>Z!qGѿ\'	D\"iYKX\\{l q(Dsrl_`̡w@-Ý\nZ-ߢ6X|=~SX_5~̟Dy\0Ll\ruVU-T}Gz| c֪!Q\ZSԤnl-\ZLS{aqwaݕgK9 ri^x̌DD^r%a-=^)B\"Zj!H}ɚz&\\t#hO@ľR!uv{AF[\0pD8q~GŇȗ3aQg2?\0ncZ|BԹ۲pDѷvO VVS LBkvrJz&ؒ%Jf$cŷjFq.\0^~9`3]Iﲫ\'P䦿뢕Ϧ6>N_Tv7|X) <Ivk\ZbE;eaTq{cahj@D흫4kWչW~Q?dڏ/zՆh|o7wt-y\n-<<MDC/z@H(Ej\0X,mkeR2yt(,.վ!]\ZX8Ĵ%MQ	]5TCŭf)Od&EIVU5xe_9GaD/۬(XߓWCJ\rOd^D:dyn  \Z=ǵᡣq\0e\0-(x/mSç^\ZNU\']zRq@*V3ffgE1Ӂ`*q{d,I!F\ZU\rdQx8<4;9\'EHh[\nЁM\"@$Uͨ|I^[,\"E,L@c\0}\'Ĵ\\+k]Hȝ61Z *!juY!\Z6r\nQڢUuvA\n?7j0H-wW;;Ud`\"FVW#1NL#P-o]<D:*yU)s{.&4,\0CWuC2Dn ^3;Q{M|*(d9-Ii\\t ۲-|QeGz2>?y49\Z߇\"ϡq,xr);ip͛;KqEL-\'Nt{D@Y*FV(/ :\Z $1cIxje:pשv/Bظ3E_`C6vْ`bDvNcfV#SMZr-Y%6놨G9a0.]t{.) SMZ|\0h\0QB4aFCgG	n6\\]\")mv._F`rx@kּy@$[e3t5˂(>|܂ԩN\"9揿Z8h@o~\"@!2EQ3f\Z(\"x2K7L8U\Zsg-aYXhjZyƾj	()zN׻\"F㫓p2|}=8!RUʍ6\'n \Ziy1È\0ȵKp5T4^VjQU,T1	řQl\0LGJKvCt8JќB4VGb{C{X;D~\\˽SU\0\"ǪN\rJn៪=^_m?k~V̞7L\"9\rU*74:tj)C24ٴ)tmq&t[G}QJ ң]Fpe<rS/$ JNܺ5*Ƴb(ƀbe,ԩHWv.t+\'N9=˶EIDAbMNݿD$Tmgt{ęlY)c\"0Lm%haaep(SqSy\rNKMcJ6mpڷζ,FODKs\'zI].׋j8BwQӢJzQD5P(r,\ZeNUqtgTWubQsd1Tz@tl;Ƈ3Ϧ,c]N>x\0Fa{i)*%U֣ik}x韋9&W9pXpI*z`f[m/v\0R㈗pB!D\ZBZWfISE>Rg\0$?̗GmZYr	lk&?y1Q!.;,ҭ͹ӵch<GI{}ؿ%eҵMօuf4JK&yFA43k\"l\'mDӻN2Drl):-*z.<>_.&H\".>.Nf̲rC02	4./RJz:U7UW\"tex{Ƨ)\"1^ayMD2\\%CZ˦Z.D|UV:B\",8~LȁWvzļ@|\'1(尡{c\r2۽\')aUU)e9	+2<Yd)eQd^汢Jf:0:N;h<Η1V_,@z\"ܢvGr2twjs3A6W\"A4TE\\.k%|iݯ̷45[f(d.jZjk^P>~KѰ\r9ȠD\\+[iL\"EÜHP31\0N?0.H~Y[H{LKY\"ިw۫RcD Dmc=<$hsǲ1q^LL8BʲDK- AW.7.Wv-|KՆօݥ͋Ņږ	GXmkS{zZ{|,&x\"C$o﮺D\"΅ѾX#z[ bmDOۇHjao,%)h* :ɲZ&6i \ZP`1\"y@ĭf7o=C<l-5-\0CTfe׮6]ԺZAНyjzC|.CVy!*D.m_%Br(^N*u\n0	3)8Y7D{ɵdr\n!_W)Tu%k[[8p!*A\rGF $oG`萪~`~ I`˃ģvJBw\0プ6-<þ,r%%A@d\ng!#Iy\"KoUh)b\nX4ˤc=+*D)(:\nZi3޶G&\0DSީSرc$ČxN=@6LNC1(V;QqI=\\B֖gRKmo5/^_IcCkR\nE!V9{%qEd\Zg\"V(<8(&IŮ)f( mLvP5T,+XPIrbOdBO`=/\'/\0Po^\\04\\+\rMqWκ=Q1!rcD{g]teI>d.^v+/]E6gI\"9\n{56x\nQ!C-BQ>Dl$gمXtlkg5с-c@\0nŎ\0(B3\0pr@VUչl{2IBT/M5cBƜ:\r)nuEYڏYlE{Zb5[AL7֒!(tMv+.^&~]3A5D4n!rS\",hj]sV\ZjV?DÒ\"ɞJދg܆Rg[ccCɻ	TgkzXӂh܂z>s3/5]v6v풭=|!\ZEl:3;`!$#x^X3b-b* teѳj|$e|V̎Sk\Z!!2 1Id~\n\\Y|tF1{AΆ{;4Z6!DNs?!ѡxBj@D\"mQaQtqvlvbK,&d੃ch-(bnϒlUXH5Kt8Fl+66H\"IM\"e6\n]Y\"EbYI]8#kj^st#N]\02I)¹	V:A%Yjdʶ!Kk\r|lbݽRd8D!{}qޖ<\nr|p8c3E!D!G}XD$ii E\"ODEf93٘:wю75lhE/7~\"\0)ڄ\"4wH-YɎj~!ڇ\"h505oA$ˡDv|np} 30Z4ƦǤP(f6i}/X&H}\0\"b	D(eg:\Zt$AE@({||\\_\n;3Q=/wŉ<&}V=wq\Zi`b[jݳ.H	`dmbRFfue2vwr-P	h[C#ĸ~mD@jfZhIFqI$nID)ǐ=/\"X<R>&E *Dk$eJ\"FeUv3xS:3%31r\'hTҪ%)D\"φQC聏DP<OM=BQ0_kg7,2\Z׻+WlƘ@D͗F!Fd٦\'ق.{)Ŵi^Ӗ5:933\'gz_9e*@a74{aU(UMU*zQ(1Y=@4|\0DSČۓ:ܮD1+2!-ufijhG,?_-F͵oj:pPdC$A$Y\"ȖC\";>?nｗ.0D=?$DV(-h󢢫ֵS%{@#$%y!D\"-!QV\"JjU9DM\rHo`$FQ	D@ӓI=E?i- zY\'jQٙȋa80~^ڗ.4>3]2%҂ku&3Ir,j\"eI={Q1Pgt$R,e`qW깃E2q^ws0CFCE.ʬz2\rLqT$_\"E}d4ۯI(NP7փDwI=)mgn7Utezjjj1n6Voq[8Q\0s4.7m\Z`~otCAW:{0YCxhzZDMü&o[XSXu3$~?)j)AJP6/AhMU{7\rw8\nQ\ZS6S`2i-Ct5/\\=q+F#8kTv=3L`\'q<e1ȡ\"b1hC@GLmcN5`~|D4ɫ\':T\"&|dKF9!xJ``eVtPKs2>9\0D}L\"}(.bcպ%͵*\r\"Wqr6DW.53Ei	$36@|ge᭶66\"3eLGqs/@=Gg4щ 	\0X>\n:;ըIGQ^ĄFd5䳃S&]HɁ3\'D(44IIfEqL#(F	\ZpkHN[\'l{Y]\\\\lmX~Lo2Pb\n.bWhU\ZflFsSԊ8XD| Q(2tfd(宍miSv,Kp|Q\\c2cpÖGW\0A4^\rb(1RS=\ZOxx4Q{i/fmXOJYO)JL?\0\nGZP5m\Ze(x uej_ykn\'8DhG$9b-#˱[CNHXE\'\'^G bs\";jz2 ΜFYq\Z	!|x_IT#(B㷳 X ^֌me%aߪ&t&ci>[A.痿O]y\"&\r1o*$_[TSLÙւ;H|X1ӖcA<q\0hQ^%wfsxę3(:`/8u_|mF,0(հ=pd3=LXa/=^#s!ҹ~!ːŊ3} RJlT@:T9oD3K_&{weqZHBCDRq*FCɚfhdHS\'*ژ4J= DT(ž5KA \"eb<=i[|!+϶H.Bu?Ok\"CC#hڐ.:RY<h`؁3/TTO\0Dg2\nǫkjjHF$8#Y\'ͽ= lRV\ZN1h\rQLJI{7׮}o<GW.YDy,,Sc;lVD6#mml;杁cL>cYt5\0Dy\Z)\Z\"jԣE4N:S=<Q3R2t%)O${!\nYYs\n\\+ӕĬvcAd́\0.\'Pt8#\ZL<\\aEX)\\9BqZ3\n\\UXGcغ\"	1d\'n+̚el:QIw\"\0)\Z\"fN%@Q3ՀĹx(^PI#\n^\ZESy;O:{6	]ne6\n$g!(!D\r\\ʘ!>\\|%&z[b\ZXZrx*@Z/\n8(.7\rMAy>3̈́\nX#dɓCyv8tj\"!U\'&O\'\'O\'kD \rTl?=bإ	*P2\'X} \Zt6jKKV1sȆ>LB\r1iYۈqBDj!lFk1sCDC\r8/ܝ֚. gCnD*Ds \nRKϢhWxU*DCCkAmxV39\rLP\"DROCt*z Ks*V4)a} kvx@$U壑H4ʰ(sh88j? Ή:Q\r:(E,%a\nѕgEP 2v̝9SV!Ge#ɂL؜<C<$0h})ptDOIJ?YS$ςDUBȑEȲ\0DmY&a֕Jj\\٩2)a@E@GwQt\"?.Bmh՞&\Z^<x⛂Q{n&&	CBĚɂ8G6Q r#1$JDwubsi4ٙYqF`n\0\0?IDAT;A\"fV[{]DWr YFY+pe2Ax^ULĢdr2,A%#w$osޛ>*\"p|\ZS:O(eD$zLh9}בkYCES\"DP:]}s]c>3$7\0q/`ѓ4HD7ac--\n8=|h\Z3+xYK\\pta B~8¿gJR_L1s?ᬌ<DIDM:$Dk)J\'O	%\"$ƞ\\m\\>S(qwuhKu@=yVg5k4d!vcϭ~y0yBd\"\\1E#u\ZUrƇ-Lz=xԆv!&8)\"ُ2^&ʥhJT\":gT3BQXGɑl)1hW28E,AU.O+:A\"vEg4d :s o.\Z\">80\'?d\'Ru3*yvQU$7\rm;bNJd]mCV9u`ҘY%鑴sx>EE*v~?@(ҙM0:\ne!)_\\a@:6&A\"$ff=Mբ@@ZJ\rIw	ֶ\Z6Do!!HYɕ+P_:V1ZS\"J_A_ɉY_0ZE`?w3ህ_~OMQ2蠃ϛGLmђ5%l$Q,tanySN&j9\"+ךZU2ۇ<V9Le	kόlu3O]m\'jPrsb]TG*y\'Ř=[A*jJM\'FD-,Y :MmӇ3FM+=5D&qpTMl@\"N~`7{ D8Wfh\'VuRJմX.D?X\\\"hjsh 𳮪]K>4D\\̤\\\Zmo?\"=2Q9X\'@DWV\\B*H5\"\r|*>1.]><=Ar!woA,ļ)QO7*C\r$itJb䀓\r(W-gp\\>,Mi:ʫy|a|t03ۀ\"(BS+0D9\\-0am	YTDt,F\"CwTP$iǴLpKs}u;wA[rN9@GC*6b0Eh5!HMɚD4\0Q^+	5 &|^=?Qe}\\76Ztd2Apci=cp>	wt@5(J#NVؖbk\Z:3LD+@n D^萴^+Lf{[; 6Ia2~6y|o*i(Bt/]!X9H2kCOۦ(0:f.ʢ^ӅvTb :9\\ᓔz=Zs]b.lԟ1z9NQ+L)܎BQ2̧ZFiJr!9R&~QC@T༺..-#z*>|&o`֙牺 3_aLOjʟ|:_If~6	\"G a\rlIv>.]3!:D=O0xCRJ=f7#}~\"Y=}F˨KIaސ1\n#D[v+qV~ex4OOsLm˥S`EY5j7]H#\nݬH{WVҪ\"Oz@\Z|.L/C9pco`w杽/y7n\"D[{7n|n~@(\"&\ZGFHL-~v9 _]\'V5W4W)Q{F\\.+<_\ZDO!S{|T+^\0z]=--mߛ+(ܦK)\'hvz\\J#[\\%:0o;5@qF7HWԊTۭG{u\'wX\nAĬ|?go38iҼ?xЇ?߄;?Bn_/,\"]EIJPC0̥鳒5TA\"DpCG%^V	\'32uڼoq sF?g}]@ 330@T|zoi@ˍ\Z\Z\Z\Z/vKPb,t0+ɍl1t>\0US+P{%}>PG	%Q>߱\ZL\07+G٧5a	Sw@̟h>0W7n$*2< )ș352	*g\0:dN˨ի .`J+\"qQ=zףTYiV\ZrEz}Ki\"{#;\0Fj8cy\ZJ\rE|!b?9FjlB=z\"D>p4u`6NLSfSsmɧO}l~4濁(D1pȽRzA#Lև(x\0D,mv*%R=(t z{@4\\d	D=}|oXN+}i\r7׈gVl|.^ljmkkEf||&UN\"CXUG4@utg^n6~^чԉd?)~_CBl&G@s\rv$h}kt9Ə\'u4\'~4Gf-\\qPVy\Z| |A:6?GDSްf\0*q1z5W(vijC̆+MaAZABy\Z-?3|ؘ5{߃Qkƛkk[B4=\"kNK[BDV2#(i`G\ZupΛVf-4ѝ̯>@ ߚ%vɷ>03O[777!D5~ps>Λ$Xذ*}Ґ.n|1R]};\\UL|Z)@:@EBz.^p4^}` n7M+b^Q^f:dGM\\5\r.RfmpDwYlY7ߌ#no~ӏO}潑L큁4?_L~|N	\0WJzppxc(uO3ۼ=#^qJ)Ӕ$C$xv>|o򴏃pʈ\"H5^7\0\Z\0^}؋×5\"˺װ`!}`j6\'qP|	drnuhChݯfCdͯ~l/޹3O1Foܸy\' >w9_ qNwbsIsLZ&TǮCьlW\r\rnT\\Ec~R54=$ĉ\"oJ]K昰X#&P6\\1|\0$$񗯿+.5ʘGeVTUfMe 7<]!I97ݛ7n6pc`&*o{I3>0rsFo~[:BS2ؾs l&#AΧj\Z\\A7,DE_FN0T\"!RM1lʅ R$Q̩RIp$7_KנMBۖ$:ܓʣG)&Mѩhџ)񔃹)#O?Aoxr@1;q;\0w;,H>|G~x/X\ZCC@	ZȌ~.A4w{ܝ5#tCtbZ}1jhZf4\r\rn\rSydp?ۗqAn\\]ޕ1+U\Z.Wր)jZ]Z;;6hn^$7ĕkغ1ֹaGs\0tz.૎*_Ϫ!Qjo{:32fgff+3R3zl95u;\0ezUi\\a)؄<0<G1YxL|IFeFŝQKQ dg\rcV23=*ו!AnR6_4g)B$)5Ƽ{\0S3}#=e燞r2og垯u\\owЁC2?)S^C^*<~-|z\"<>Ubv)xOm+sh$xw{L|B(x1՘]i}hP1[@4Hdilg=\\XQi{@{\'hv=z\rH/SJOU+3$mVe29}VI!r<\\%!`d\ZG{IG9.v)GQ\'=</<ʃ#D\n\"q<xdHޓTG;ZQ=ת*;yt۝(JPy͏RF4ttƌ= bLՠӲU.}u \0\"o{{p}Od\'3\0Ugf%q]朮GJ{|]Ocn} ]h9R?(kGˀ+?CG*(?HAɣl߅w].O_敲@#yiUO+^^ѲO1D쓊{QV\"W7p\rfd!v{D4H$Y54zR>d3:F$Y0\0Q\Z=]Qi Pe8LinH\0T9b;RHQ_9(9Uso=<\0?F<DW:;\0uO$O\n\ZܞUPjޘu*2H[ޯD?+!?>{Pyds+K8+6KcEbdb,Dp \";$}X5I%&DL/(j׵>3ӫCt)i\"tA䊿gbn]/f>gly28@t4r8c~#e/q(Ek0oyk#txHWO~bi}:~T8*@U~4%!:8C	B(f^({W0D-\\A\"rmI0@W_S37²ŌtI=탍(KiK 1ʹrWje3&{k@\\PF2<eG~/{.~RG<G~wNQq\"۝o-8^vDė7HgQ>(;4<C>Bt`Nu)lA9Y-$A0>HkX;1RLmֲ\Z%)ndAےs}vl\Z(vS>ywu3\"Z!B]@bME#2kY\"@\\4x\ZciŲ̪Wt[UU>}\\C\"TR1 1sեu]2b*Dt^:ODvc徽\"U#!/͆10\rN´\rDK/*C*gyOoQ-llXVDT+ĎHHE]gt@3XdVU)BgZe[9\0\0\0\0IENDB`');
/*!40000 ALTER TABLE `filecontent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `filemodel`
--

DROP TABLE IF EXISTS `filemodel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filemodel` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `type` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `filecontent_id` int(11) unsigned DEFAULT NULL,
  `relatedmodel_id` int(11) unsigned DEFAULT NULL,
  `relatedmodel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `filemodel`
--

LOCK TABLES `filemodel` WRITE;
/*!40000 ALTER TABLE `filemodel` DISABLE KEYS */;
INSERT INTO `filemodel` VALUES (1,'200x50.gif',449,'image/gif',3,1,NULL,NULL),(2,'200x200.gif',712,'image/gif',4,2,NULL,NULL),(3,'580x180.gif',1898,'image/gif',5,3,NULL,NULL),(4,'googleMaps.png',39873,'image/png',6,4,NULL,NULL);
/*!40000 ALTER TABLE `filemodel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gamebadge`
--

DROP TABLE IF EXISTS `gamebadge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gamebadge` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grade` int(11) DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `person_item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gamebadge`
--

LOCK TABLES `gamebadge` WRITE;
/*!40000 ALTER TABLE `gamebadge` DISABLE KEYS */;
/*!40000 ALTER TABLE `gamebadge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gamecoin`
--

DROP TABLE IF EXISTS `gamecoin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gamecoin` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `value` int(11) DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `person_item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gamecoin`
--

LOCK TABLES `gamecoin` WRITE;
/*!40000 ALTER TABLE `gamecoin` DISABLE KEYS */;
/*!40000 ALTER TABLE `gamecoin` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gamecollection`
--

DROP TABLE IF EXISTS `gamecollection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gamecollection` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `item_id` int(11) unsigned DEFAULT NULL,
  `person_item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gamecollection`
--

LOCK TABLES `gamecollection` WRITE;
/*!40000 ALTER TABLE `gamecollection` DISABLE KEYS */;
/*!40000 ALTER TABLE `gamecollection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gamelevel`
--

DROP TABLE IF EXISTS `gamelevel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gamelevel` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` int(11) DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `person_item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gamelevel`
--

LOCK TABLES `gamelevel` WRITE;
/*!40000 ALTER TABLE `gamelevel` DISABLE KEYS */;
/*!40000 ALTER TABLE `gamelevel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gamenotification`
--

DROP TABLE IF EXISTS `gamenotification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gamenotification` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `_user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gamenotification`
--

LOCK TABLES `gamenotification` WRITE;
/*!40000 ALTER TABLE `gamenotification` DISABLE KEYS */;
/*!40000 ALTER TABLE `gamenotification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gamepoint`
--

DROP TABLE IF EXISTS `gamepoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gamepoint` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` int(11) DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `person_item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gamepoint`
--

LOCK TABLES `gamepoint` WRITE;
/*!40000 ALTER TABLE `gamepoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `gamepoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gamepointtransaction`
--

DROP TABLE IF EXISTS `gamepointtransaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gamepointtransaction` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `value` int(11) DEFAULT NULL,
  `createddatetime` datetime DEFAULT NULL,
  `gamepoint_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gamepoint_id` (`gamepoint_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gamepointtransaction`
--

LOCK TABLES `gamepointtransaction` WRITE;
/*!40000 ALTER TABLE `gamepointtransaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `gamepointtransaction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gamereward`
--

DROP TABLE IF EXISTS `gamereward`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gamereward` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cost` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `expirationdatetime` datetime DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gamereward`
--

LOCK TABLES `gamereward` WRITE;
/*!40000 ALTER TABLE `gamereward` DISABLE KEYS */;
/*!40000 ALTER TABLE `gamereward` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gamereward_read`
--

DROP TABLE IF EXISTS `gamereward_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gamereward_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `gamereward_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gamereward_read`
--

LOCK TABLES `gamereward_read` WRITE;
/*!40000 ALTER TABLE `gamereward_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `gamereward_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gamerewardtransaction`
--

DROP TABLE IF EXISTS `gamerewardtransaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gamerewardtransaction` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `redemptiondatetime` datetime DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `person_item_id` int(11) unsigned DEFAULT NULL,
  `transactions_gamereward_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gamerewardtransaction`
--

LOCK TABLES `gamerewardtransaction` WRITE;
/*!40000 ALTER TABLE `gamerewardtransaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `gamerewardtransaction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gamescore`
--

DROP TABLE IF EXISTS `gamescore`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gamescore` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` int(11) DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `person_item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gamescore`
--

LOCK TABLES `gamescore` WRITE;
/*!40000 ALTER TABLE `gamescore` DISABLE KEYS */;
/*!40000 ALTER TABLE `gamescore` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `globalmetadata`
--

DROP TABLE IF EXISTS `globalmetadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `globalmetadata` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `classname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serializedmetadata` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_emaNssalc` (`classname`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `globalmetadata`
--

LOCK TABLES `globalmetadata` WRITE;
/*!40000 ALTER TABLE `globalmetadata` DISABLE KEYS */;
INSERT INTO `globalmetadata` VALUES (1,'ContactsModule','a:10:{s:17:\"designerMenuItems\";a:4:{s:14:\"showFieldsLink\";b:1;s:15:\"showGeneralLink\";b:1;s:15:\"showLayoutsLink\";b:1;s:13:\"showMenusLink\";b:1;}s:26:\"globalSearchAttributeNames\";a:4:{i:0;s:8:\"fullName\";i:1;s:8:\"anyEmail\";i:2;s:11:\"officePhone\";i:3;s:11:\"mobilePhone\";}s:13:\"startingState\";i:1;s:12:\"tabMenuItems\";a:1:{i:0;a:4:{s:5:\"label\";s:80:\"eval:Zurmo::t(\'ContactsModule\', \'ContactsModulePluralLabel\', $translationParams)\";s:3:\"url\";a:1:{i:0;s:17:\"/contacts/default\";}s:5:\"right\";s:19:\"Access Contacts Tab\";s:6:\"mobile\";b:1;}}s:24:\"shortcutsCreateMenuItems\";a:1:{i:0;a:4:{s:5:\"label\";s:82:\"eval:Zurmo::t(\'ContactsModule\', \'ContactsModuleSingularLabel\', $translationParams)\";s:3:\"url\";a:1:{i:0;s:24:\"/contacts/default/create\";}s:5:\"right\";s:15:\"Create Contacts\";s:6:\"mobile\";b:1;}}s:48:\"updateLatestActivityDateTimeWhenATaskIsCompleted\";b:1;s:46:\"updateLatestActivityDateTimeWhenANoteIsCreated\";b:1;s:55:\"updateLatestActivityDateTimeWhenAnEmailIsSentOrArchived\";b:1;s:51:\"updateLatestActivityDateTimeWhenAMeetingIsInThePast\";b:1;s:15:\"startingStateId\";i:5;}');
/*!40000 ALTER TABLE `globalmetadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `imagefilemodel`
--

DROP TABLE IF EXISTS `imagefilemodel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `imagefilemodel` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `isshared` tinyint(1) unsigned DEFAULT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `inactive` tinyint(1) unsigned DEFAULT NULL,
  `filemodel_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `imagefilemodel`
--

LOCK TABLES `imagefilemodel` WRITE;
/*!40000 ALTER TABLE `imagefilemodel` DISABLE KEYS */;
INSERT INTO `imagefilemodel` VALUES (1,0,200,50,0,1),(2,0,200,200,0,2),(3,0,580,180,0,3),(4,0,580,180,0,4);
/*!40000 ALTER TABLE `imagefilemodel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `import`
--

DROP TABLE IF EXISTS `import`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `import` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `import`
--

LOCK TABLES `import` WRITE;
/*!40000 ALTER TABLE `import` DISABLE KEYS */;
/*!40000 ALTER TABLE `import` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `item`
--

DROP TABLE IF EXISTS `item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `item` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `createddatetime` datetime DEFAULT NULL,
  `modifieddatetime` datetime DEFAULT NULL,
  `createdbyuser__user_id` int(11) unsigned DEFAULT NULL,
  `modifiedbyuser__user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `item`
--

LOCK TABLES `item` WRITE;
/*!40000 ALTER TABLE `item` DISABLE KEYS */;
INSERT INTO `item` VALUES (1,'[[regtime]]','[[regtime]]',NULL,NULL),(2,'[[regtime]]','[[regtime]]',1,1),(3,'[[regtime]]','[[regtime]]',1,1),(4,'[[regtime]]','[[regtime]]',1,1),(5,'[[regtime]]','[[regtime]]',1,1),(6,'[[regtime]]','[[regtime]]',1,1),(7,'[[regtime]]','[[regtime]]',1,1),(8,'[[regtime]]','[[regtime]]',1,1),(9,'[[regtime]]','[[regtime]]',1,1),(10,'[[regtime]]','[[regtime]]',1,1),(11,'[[regtime]]','[[regtime]]',1,1),(12,'[[regtime]]','[[regtime]]',1,1),(13,'[[regtime]]','[[regtime]]',1,1),(14,'[[regtime]]','[[regtime]]',1,1),(15,'[[regtime]]','[[regtime]]',1,1),(16,'[[regtime]]','[[regtime]]',1,1),(17,'[[regtime]]','[[regtime]]',1,1),(18,'[[regtime]]','[[regtime]]',1,1),(19,'[[regtime]]','[[regtime]]',1,1);
/*!40000 ALTER TABLE `item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobinprocess`
--

DROP TABLE IF EXISTS `jobinprocess`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobinprocess` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobinprocess`
--

LOCK TABLES `jobinprocess` WRITE;
/*!40000 ALTER TABLE `jobinprocess` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobinprocess` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `joblog`
--

DROP TABLE IF EXISTS `joblog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `joblog` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `enddatetime` datetime DEFAULT NULL,
  `isprocessed` tinyint(1) unsigned DEFAULT NULL,
  `message` text COLLATE utf8_unicode_ci,
  `startdatetime` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `joblog`
--

LOCK TABLES `joblog` WRITE;
/*!40000 ALTER TABLE `joblog` DISABLE KEYS */;
/*!40000 ALTER TABLE `joblog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kanbanitem`
--

DROP TABLE IF EXISTS `kanbanitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kanbanitem` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(11) DEFAULT NULL,
  `sortorder` int(11) DEFAULT NULL,
  `kanbanrelateditem_item_id` int(11) unsigned DEFAULT NULL,
  `task_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kanbanitem`
--

LOCK TABLES `kanbanitem` WRITE;
/*!40000 ALTER TABLE `kanbanitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `kanbanitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `marketinglist`
--

DROP TABLE IF EXISTS `marketinglist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `marketinglist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `fromname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fromaddress` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `anyonecansubscribe` tinyint(1) unsigned DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `marketinglist`
--

LOCK TABLES `marketinglist` WRITE;
/*!40000 ALTER TABLE `marketinglist` DISABLE KEYS */;
/*!40000 ALTER TABLE `marketinglist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `marketinglist_read`
--

DROP TABLE IF EXISTS `marketinglist_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `marketinglist_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `marketinglist_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `marketinglist_read`
--

LOCK TABLES `marketinglist_read` WRITE;
/*!40000 ALTER TABLE `marketinglist_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `marketinglist_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `marketinglistmember`
--

DROP TABLE IF EXISTS `marketinglistmember`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `marketinglistmember` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `createddatetime` datetime DEFAULT NULL,
  `modifieddatetime` datetime DEFAULT NULL,
  `unsubscribed` tinyint(1) unsigned DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `marketinglist_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_id` (`contact_id`),
  KEY `marketinglist_id` (`marketinglist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `marketinglistmember`
--

LOCK TABLES `marketinglistmember` WRITE;
/*!40000 ALTER TABLE `marketinglistmember` DISABLE KEYS */;
/*!40000 ALTER TABLE `marketinglistmember` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meeting`
--

DROP TABLE IF EXISTS `meeting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `meeting` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8_unicode_ci,
  `enddatetime` datetime DEFAULT NULL,
  `processedforlatestactivity` tinyint(1) unsigned DEFAULT NULL,
  `location` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `logged` tinyint(1) unsigned DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `startdatetime` datetime DEFAULT NULL,
  `activity_id` int(11) unsigned DEFAULT NULL,
  `category_customfield_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meeting`
--

LOCK TABLES `meeting` WRITE;
/*!40000 ALTER TABLE `meeting` DISABLE KEYS */;
/*!40000 ALTER TABLE `meeting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meeting_read`
--

DROP TABLE IF EXISTS `meeting_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `meeting_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `meeting_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meeting_read`
--

LOCK TABLES `meeting_read` WRITE;
/*!40000 ALTER TABLE `meeting_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `meeting_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meeting_read_subscription`
--

DROP TABLE IF EXISTS `meeting_read_subscription`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `meeting_read_subscription` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) unsigned NOT NULL,
  `modelid` int(11) unsigned NOT NULL,
  `modifieddatetime` datetime DEFAULT NULL,
  `subscriptiontype` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `userid_modelid` (`userid`,`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meeting_read_subscription`
--

LOCK TABLES `meeting_read_subscription` WRITE;
/*!40000 ALTER TABLE `meeting_read_subscription` DISABLE KEYS */;
/*!40000 ALTER TABLE `meeting_read_subscription` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messagesource`
--

DROP TABLE IF EXISTS `messagesource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `messagesource` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `category` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `source` blob,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sourceCategory` (`category`,`source`(767))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messagesource`
--

LOCK TABLES `messagesource` WRITE;
/*!40000 ALTER TABLE `messagesource` DISABLE KEYS */;
/*!40000 ALTER TABLE `messagesource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messagetranslation`
--

DROP TABLE IF EXISTS `messagetranslation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `messagetranslation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `translation` blob,
  `language` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `messagesource_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sourceLanguageTranslation` (`messagesource_id`,`language`,`translation`(767))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messagetranslation`
--

LOCK TABLES `messagetranslation` WRITE;
/*!40000 ALTER TABLE `messagetranslation` DISABLE KEYS */;
/*!40000 ALTER TABLE `messagetranslation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mission`
--

DROP TABLE IF EXISTS `mission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mission` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8_unicode_ci,
  `duedatetime` datetime DEFAULT NULL,
  `latestdatetime` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `reward` text COLLATE utf8_unicode_ci,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  `takenbyuser__user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mission`
--

LOCK TABLES `mission` WRITE;
/*!40000 ALTER TABLE `mission` DISABLE KEYS */;
/*!40000 ALTER TABLE `mission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mission_read`
--

DROP TABLE IF EXISTS `mission_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mission_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `mission_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mission_read`
--

LOCK TABLES `mission_read` WRITE;
/*!40000 ALTER TABLE `mission_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `mission_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `modelcreationapisync`
--

DROP TABLE IF EXISTS `modelcreationapisync`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `modelcreationapisync` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `servicename` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `modelid` int(11) unsigned NOT NULL,
  `modelclassname` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `createddatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `modelcreationapisync`
--

LOCK TABLES `modelcreationapisync` WRITE;
/*!40000 ALTER TABLE `modelcreationapisync` DISABLE KEYS */;
/*!40000 ALTER TABLE `modelcreationapisync` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `multiplevaluescustomfield`
--

DROP TABLE IF EXISTS `multiplevaluescustomfield`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `multiplevaluescustomfield` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `basecustomfield_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `basecustomfield_id` (`basecustomfield_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `multiplevaluescustomfield`
--

LOCK TABLES `multiplevaluescustomfield` WRITE;
/*!40000 ALTER TABLE `multiplevaluescustomfield` DISABLE KEYS */;
/*!40000 ALTER TABLE `multiplevaluescustomfield` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `named_securable_actual_permissions_cache`
--

DROP TABLE IF EXISTS `named_securable_actual_permissions_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `named_securable_actual_permissions_cache` (
  `securableitem_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `permitable_id` int(11) unsigned NOT NULL,
  `allow_permissions` tinyint(3) unsigned NOT NULL,
  `deny_permissions` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`securableitem_name`,`permitable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `named_securable_actual_permissions_cache`
--

LOCK TABLES `named_securable_actual_permissions_cache` WRITE;
/*!40000 ALTER TABLE `named_securable_actual_permissions_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `named_securable_actual_permissions_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `namedsecurableitem`
--

DROP TABLE IF EXISTS `namedsecurableitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `namedsecurableitem` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `securableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_eman` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `namedsecurableitem`
--

LOCK TABLES `namedsecurableitem` WRITE;
/*!40000 ALTER TABLE `namedsecurableitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `namedsecurableitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `note`
--

DROP TABLE IF EXISTS `note`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `note` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8_unicode_ci,
  `occurredondatetime` datetime DEFAULT NULL,
  `activity_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `note`
--

LOCK TABLES `note` WRITE;
/*!40000 ALTER TABLE `note` DISABLE KEYS */;
/*!40000 ALTER TABLE `note` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `note_read`
--

DROP TABLE IF EXISTS `note_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `note_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `note_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `note_read`
--

LOCK TABLES `note_read` WRITE;
/*!40000 ALTER TABLE `note_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `note_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notification`
--

DROP TABLE IF EXISTS `notification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ownerhasreadlatest` tinyint(1) unsigned DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `notificationmessage_id` int(11) unsigned DEFAULT NULL,
  `owner__user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notification`
--

LOCK TABLES `notification` WRITE;
/*!40000 ALTER TABLE `notification` DISABLE KEYS */;
INSERT INTO `notification` VALUES (1,'RemoveApiTestEntryScriptFile',NULL,18,1,1);
/*!40000 ALTER TABLE `notification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notificationmessage`
--

DROP TABLE IF EXISTS `notificationmessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notificationmessage` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `htmlcontent` text COLLATE utf8_unicode_ci,
  `textcontent` text COLLATE utf8_unicode_ci,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notificationmessage`
--

LOCK TABLES `notificationmessage` WRITE;
/*!40000 ALTER TABLE `notificationmessage` DISABLE KEYS */;
INSERT INTO `notificationmessage` VALUES (1,NULL,'If this website is in production mode, please remove the app/test.php file.',19);
/*!40000 ALTER TABLE `notificationmessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notificationsubscriber`
--

DROP TABLE IF EXISTS `notificationsubscriber`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notificationsubscriber` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hasreadlatest` tinyint(1) unsigned DEFAULT NULL,
  `person_item_id` int(11) unsigned DEFAULT NULL,
  `relatedmodel_id` int(11) unsigned DEFAULT NULL,
  `relatedmodel_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notificationsubscriber`
--

LOCK TABLES `notificationsubscriber` WRITE;
/*!40000 ALTER TABLE `notificationsubscriber` DISABLE KEYS */;
/*!40000 ALTER TABLE `notificationsubscriber` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opportunity`
--

DROP TABLE IF EXISTS `opportunity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opportunity` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `closedate` date DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `probability` tinyint(11) DEFAULT NULL,
  `stagemodifieddatetime` datetime DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  `account_id` int(11) unsigned DEFAULT NULL,
  `amount_currencyvalue_id` int(11) unsigned DEFAULT NULL,
  `stage_customfield_id` int(11) unsigned DEFAULT NULL,
  `source_customfield_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opportunity`
--

LOCK TABLES `opportunity` WRITE;
/*!40000 ALTER TABLE `opportunity` DISABLE KEYS */;
/*!40000 ALTER TABLE `opportunity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opportunity_project`
--

DROP TABLE IF EXISTS `opportunity_project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opportunity_project` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `opportunity_id` int(11) unsigned DEFAULT NULL,
  `project_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_tcejorp_di_ytinutroppo` (`opportunity_id`,`project_id`),
  KEY `di_ytinutroppo` (`opportunity_id`),
  KEY `di_tcejorp` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opportunity_project`
--

LOCK TABLES `opportunity_project` WRITE;
/*!40000 ALTER TABLE `opportunity_project` DISABLE KEYS */;
/*!40000 ALTER TABLE `opportunity_project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opportunity_read`
--

DROP TABLE IF EXISTS `opportunity_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opportunity_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `opportunity_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opportunity_read`
--

LOCK TABLES `opportunity_read` WRITE;
/*!40000 ALTER TABLE `opportunity_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `opportunity_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `opportunitystarred`
--

DROP TABLE IF EXISTS `opportunitystarred`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `opportunitystarred` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `basestarredmodel_id` int(11) unsigned DEFAULT NULL,
  `opportunity_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `basestarredmodel_id_opportunity_id` (`basestarredmodel_id`,`opportunity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `opportunitystarred`
--

LOCK TABLES `opportunitystarred` WRITE;
/*!40000 ALTER TABLE `opportunitystarred` DISABLE KEYS */;
/*!40000 ALTER TABLE `opportunitystarred` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ownedsecurableitem`
--

DROP TABLE IF EXISTS `ownedsecurableitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ownedsecurableitem` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned DEFAULT NULL,
  `owner__user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `owner__user_id` (`owner__user_id`),
  KEY `securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ownedsecurableitem`
--

LOCK TABLES `ownedsecurableitem` WRITE;
/*!40000 ALTER TABLE `ownedsecurableitem` DISABLE KEYS */;
INSERT INTO `ownedsecurableitem` VALUES (1,1,1),(2,2,1),(3,3,1),(4,4,1),(5,5,1),(6,6,1),(7,7,1);
/*!40000 ALTER TABLE `ownedsecurableitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permission`
--

DROP TABLE IF EXISTS `permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permission` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permissions` tinyint(11) DEFAULT NULL,
  `type` tinyint(11) DEFAULT NULL,
  `permitable_id` int(11) unsigned DEFAULT NULL,
  `securableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permission`
--

LOCK TABLES `permission` WRITE;
/*!40000 ALTER TABLE `permission` DISABLE KEYS */;
INSERT INTO `permission` VALUES (1,27,1,3,1),(2,27,1,3,2),(3,27,1,3,3),(4,27,1,3,4),(5,27,1,3,5),(6,27,1,3,6);
/*!40000 ALTER TABLE `permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permitable`
--

DROP TABLE IF EXISTS `permitable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permitable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permitable`
--

LOCK TABLES `permitable` WRITE;
/*!40000 ALTER TABLE `permitable` DISABLE KEYS */;
INSERT INTO `permitable` VALUES (1,1),(2,2),(3,8),(4,17);
/*!40000 ALTER TABLE `permitable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `person`
--

DROP TABLE IF EXISTS `person`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `person` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `department` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `firstname` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jobtitle` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastname` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobilephone` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `officephone` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `officefax` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  `primaryaddress_address_id` int(11) unsigned DEFAULT NULL,
  `primaryemail_email_id` int(11) unsigned DEFAULT NULL,
  `title_customfield_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ownedsecurableitem_id` (`ownedsecurableitem_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `person`
--

LOCK TABLES `person` WRITE;
/*!40000 ALTER TABLE `person` DISABLE KEYS */;
INSERT INTO `person` VALUES (1,NULL,'Super',NULL,'User',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,NULL,'System',NULL,'User',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `person` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personwhohavenotreadlatest`
--

DROP TABLE IF EXISTS `personwhohavenotreadlatest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personwhohavenotreadlatest` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `person_item_id` int(11) unsigned DEFAULT NULL,
  `mission_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personwhohavenotreadlatest`
--

LOCK TABLES `personwhohavenotreadlatest` WRITE;
/*!40000 ALTER TABLE `personwhohavenotreadlatest` DISABLE KEYS */;
/*!40000 ALTER TABLE `personwhohavenotreadlatest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `perusermetadata`
--

DROP TABLE IF EXISTS `perusermetadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `perusermetadata` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `classname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serializedmetadata` text COLLATE utf8_unicode_ci,
  `_user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `perusermetadata`
--

LOCK TABLES `perusermetadata` WRITE;
/*!40000 ALTER TABLE `perusermetadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `perusermetadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `policy` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `modulename` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permitable_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `portlet`
--

DROP TABLE IF EXISTS `portlet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `portlet` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `column` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `layoutid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `viewtype` text COLLATE utf8_unicode_ci,
  `serializedviewdata` text COLLATE utf8_unicode_ci,
  `collapsed` tinyint(1) unsigned DEFAULT NULL,
  `_user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `portlet`
--

LOCK TABLES `portlet` WRITE;
/*!40000 ALTER TABLE `portlet` DISABLE KEYS */;
/*!40000 ALTER TABLE `portlet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product`
--

DROP TABLE IF EXISTS `product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `quantity` int(11) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `pricefrequency` int(11) DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  `account_id` int(11) unsigned DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `opportunity_id` int(11) unsigned DEFAULT NULL,
  `producttemplate_id` int(11) unsigned DEFAULT NULL,
  `stage_customfield_id` int(11) unsigned DEFAULT NULL,
  `sellprice_currencyvalue_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product`
--

LOCK TABLES `product` WRITE;
/*!40000 ALTER TABLE `product` DISABLE KEYS */;
/*!40000 ALTER TABLE `product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_productcategory`
--

DROP TABLE IF EXISTS `product_productcategory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_productcategory` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) unsigned DEFAULT NULL,
  `productcategory_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_yrogetactcudorp_di_tcudorp` (`product_id`,`productcategory_id`),
  KEY `di_tcudorp` (`product_id`),
  KEY `di_yrogetactcudorp` (`productcategory_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_productcategory`
--

LOCK TABLES `product_productcategory` WRITE;
/*!40000 ALTER TABLE `product_productcategory` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_productcategory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_read`
--

DROP TABLE IF EXISTS `product_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `product_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_read`
--

LOCK TABLES `product_read` WRITE;
/*!40000 ALTER TABLE `product_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productcatalog`
--

DROP TABLE IF EXISTS `productcatalog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productcatalog` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productcatalog`
--

LOCK TABLES `productcatalog` WRITE;
/*!40000 ALTER TABLE `productcatalog` DISABLE KEYS */;
/*!40000 ALTER TABLE `productcatalog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productcatalog_productcategory`
--

DROP TABLE IF EXISTS `productcatalog_productcategory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productcatalog_productcategory` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `productcatalog_id` int(11) unsigned DEFAULT NULL,
  `productcategory_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_yrogetactcudorp_di_golatactcudorp` (`productcatalog_id`,`productcategory_id`),
  KEY `di_golatactcudorp` (`productcatalog_id`),
  KEY `di_yrogetactcudorp` (`productcategory_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productcatalog_productcategory`
--

LOCK TABLES `productcatalog_productcategory` WRITE;
/*!40000 ALTER TABLE `productcatalog_productcategory` DISABLE KEYS */;
/*!40000 ALTER TABLE `productcatalog_productcategory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productcategory`
--

DROP TABLE IF EXISTS `productcategory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productcategory` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `productcategory_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productcategory`
--

LOCK TABLES `productcategory` WRITE;
/*!40000 ALTER TABLE `productcategory` DISABLE KEYS */;
/*!40000 ALTER TABLE `productcategory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productcategory_producttemplate`
--

DROP TABLE IF EXISTS `productcategory_producttemplate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `productcategory_producttemplate` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `productcategory_id` int(11) unsigned DEFAULT NULL,
  `producttemplate_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_di_etalpmettcudorp_di_yrogetactcudorp` (`productcategory_id`,`producttemplate_id`),
  KEY `di_yrogetactcudorp` (`productcategory_id`),
  KEY `di_etalpmettcudorp` (`producttemplate_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productcategory_producttemplate`
--

LOCK TABLES `productcategory_producttemplate` WRITE;
/*!40000 ALTER TABLE `productcategory_producttemplate` DISABLE KEYS */;
/*!40000 ALTER TABLE `productcategory_producttemplate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `producttemplate`
--

DROP TABLE IF EXISTS `producttemplate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `producttemplate` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `pricefrequency` int(11) DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `sellpriceformula_id` int(11) unsigned DEFAULT NULL,
  `cost_currencyvalue_id` int(11) unsigned DEFAULT NULL,
  `listprice_currencyvalue_id` int(11) unsigned DEFAULT NULL,
  `sellprice_currencyvalue_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `producttemplate`
--

LOCK TABLES `producttemplate` WRITE;
/*!40000 ALTER TABLE `producttemplate` DISABLE KEYS */;
/*!40000 ALTER TABLE `producttemplate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `status` int(11) DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_read`
--

DROP TABLE IF EXISTS `project_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `project_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_read`
--

LOCK TABLES `project_read` WRITE;
/*!40000 ALTER TABLE `project_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projectauditevent`
--

DROP TABLE IF EXISTS `projectauditevent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `projectauditevent` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` datetime DEFAULT NULL,
  `eventname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `_user_id` int(11) unsigned DEFAULT NULL,
  `project_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projectauditevent`
--

LOCK TABLES `projectauditevent` WRITE;
/*!40000 ALTER TABLE `projectauditevent` DISABLE KEYS */;
/*!40000 ALTER TABLE `projectauditevent` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projectstarred`
--

DROP TABLE IF EXISTS `projectstarred`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `projectstarred` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `basestarredmodel_id` int(11) unsigned DEFAULT NULL,
  `project_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `basestarredmodel_id_project_id` (`basestarredmodel_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projectstarred`
--

LOCK TABLES `projectstarred` WRITE;
/*!40000 ALTER TABLE `projectstarred` DISABLE KEYS */;
/*!40000 ALTER TABLE `projectstarred` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `role_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_eman` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `savedcalendar`
--

DROP TABLE IF EXISTS `savedcalendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `savedcalendar` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `location` text COLLATE utf8_unicode_ci,
  `moduleclassname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `startattributename` text COLLATE utf8_unicode_ci,
  `endattributename` text COLLATE utf8_unicode_ci,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `timezone` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `color` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `savedcalendar`
--

LOCK TABLES `savedcalendar` WRITE;
/*!40000 ALTER TABLE `savedcalendar` DISABLE KEYS */;
/*!40000 ALTER TABLE `savedcalendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `savedcalendar_read`
--

DROP TABLE IF EXISTS `savedcalendar_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `savedcalendar_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `savedcalendar_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `savedcalendar_read`
--

LOCK TABLES `savedcalendar_read` WRITE;
/*!40000 ALTER TABLE `savedcalendar_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `savedcalendar_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `savedcalendarsubscription`
--

DROP TABLE IF EXISTS `savedcalendarsubscription`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `savedcalendarsubscription` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `color` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `_user_id` int(11) unsigned DEFAULT NULL,
  `savedcalendar_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `savedcalendarsubscription`
--

LOCK TABLES `savedcalendarsubscription` WRITE;
/*!40000 ALTER TABLE `savedcalendarsubscription` DISABLE KEYS */;
/*!40000 ALTER TABLE `savedcalendarsubscription` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `savedreport`
--

DROP TABLE IF EXISTS `savedreport`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `savedreport` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8_unicode_ci,
  `moduleclassname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `type` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `savedreport`
--

LOCK TABLES `savedreport` WRITE;
/*!40000 ALTER TABLE `savedreport` DISABLE KEYS */;
/*!40000 ALTER TABLE `savedreport` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `savedreport_read`
--

DROP TABLE IF EXISTS `savedreport_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `savedreport_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `savedreport_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `savedreport_read`
--

LOCK TABLES `savedreport_read` WRITE;
/*!40000 ALTER TABLE `savedreport_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `savedreport_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `savedreportstarred`
--

DROP TABLE IF EXISTS `savedreportstarred`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `savedreportstarred` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `basestarredmodel_id` int(11) unsigned DEFAULT NULL,
  `savedreport_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `basestarredmodel_id_savedreport_id` (`basestarredmodel_id`,`savedreport_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `savedreportstarred`
--

LOCK TABLES `savedreportstarred` WRITE;
/*!40000 ALTER TABLE `savedreportstarred` DISABLE KEYS */;
/*!40000 ALTER TABLE `savedreportstarred` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `savedsearch`
--

DROP TABLE IF EXISTS `savedsearch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `savedsearch` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `viewclassname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `savedsearch`
--

LOCK TABLES `savedsearch` WRITE;
/*!40000 ALTER TABLE `savedsearch` DISABLE KEYS */;
/*!40000 ALTER TABLE `savedsearch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `savedworkflow`
--

DROP TABLE IF EXISTS `savedworkflow`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `savedworkflow` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8_unicode_ci,
  `isactive` tinyint(1) unsigned DEFAULT NULL,
  `moduleclassname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order` int(11) DEFAULT NULL,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `type` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `triggeron` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `savedworkflow`
--

LOCK TABLES `savedworkflow` WRITE;
/*!40000 ALTER TABLE `savedworkflow` DISABLE KEYS */;
INSERT INTO `savedworkflow` VALUES (1,'This will create a task for the Contact owner to follow up with a contact if there has been no activity for 1 month',0,'ContactsModule','Contact follow up Task',1,'a:5:{s:17:\"triggersStructure\";s:1:\"1\";s:8:\"Triggers\";a:0:{}s:7:\"Actions\";a:1:{i:0;a:5:{s:4:\"type\";s:6:\"Create\";s:8:\"relation\";s:5:\"tasks\";s:14:\"relationFilter\";s:17:\"RelationFilterAll\";s:20:\"relatedModelRelation\";N;s:16:\"ActionAttributes\";a:4:{s:4:\"name\";a:3:{s:4:\"type\";s:6:\"Static\";s:5:\"value\";s:22:\"Follow up with contact\";s:14:\"shouldSetValue\";s:1:\"1\";}s:11:\"owner__User\";a:3:{s:4:\"type\";s:21:\"OwnerOfTriggeredModel\";s:5:\"value\";N;s:14:\"shouldSetValue\";s:1:\"1\";}s:6:\"status\";a:3:{s:4:\"type\";s:6:\"Static\";s:5:\"value\";i:1;s:14:\"shouldSetValue\";s:1:\"1\";}s:11:\"permissions\";a:3:{s:4:\"type\";s:20:\"SameAsTriggeredModel\";s:5:\"value\";N;s:14:\"shouldSetValue\";s:1:\"1\";}}}}s:13:\"EmailMessages\";a:0:{}s:11:\"TimeTrigger\";a:12:{s:16:\"durationInterval\";i:1;s:12:\"durationSign\";s:8:\"Positive\";s:12:\"durationType\";s:5:\"Month\";s:18:\"currencyIdForValue\";N;s:5:\"value\";N;s:11:\"secondValue\";N;s:26:\"thirdValueDurationInterval\";N;s:22:\"thirdValueDurationType\";N;s:9:\"valueType\";s:11:\"Is Time For\";s:14:\"relationFilter\";s:17:\"RelationFilterAny\";s:27:\"attributeIndexOrDerivedType\";s:22:\"latestActivityDateTime\";s:8:\"operator\";N;}}','ByTime','NewAndExisting',14),(2,'This will send an email to recipients that you choose when you close a deal!',0,'OpportunitiesModule','Closed won Opportunity alert',2,'a:4:{s:17:\"triggersStructure\";s:1:\"1\";s:8:\"Triggers\";a:1:{i:0;a:10:{s:18:\"currencyIdForValue\";N;s:5:\"value\";s:10:\"Closed Won\";s:11:\"secondValue\";N;s:26:\"thirdValueDurationInterval\";N;s:22:\"thirdValueDurationType\";N;s:24:\"stringifiedModelForValue\";N;s:9:\"valueType\";N;s:14:\"relationFilter\";s:17:\"RelationFilterAny\";s:27:\"attributeIndexOrDerivedType\";s:5:\"stage\";s:8:\"operator\";s:7:\"becomes\";}}s:7:\"Actions\";a:0:{}s:13:\"EmailMessages\";a:1:{i:0;a:8:{s:15:\"emailTemplateId\";i:7;s:25:\"sendAfterDurationInterval\";i:0;s:21:\"sendAfterDurationType\";s:6:\"Minute\";s:12:\"sendFromType\";s:7:\"Default\";s:12:\"sendFromName\";N;s:15:\"sendFromAddress\";N;s:24:\"excludeIfTriggeredByUser\";b:0;s:22:\"EmailMessageRecipients\";a:1:{i:0;a:4:{s:6:\"toName\";s:14:\"The Sales Team\";s:9:\"toAddress\";s:23:\"SalesTeam@mycompany.com\";s:4:\"type\";s:13:\"StaticAddress\";s:12:\"audienceType\";i:1;}}}}}','OnSave','NewAndExisting',16);
/*!40000 ALTER TABLE `savedworkflow` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `securableitem`
--

DROP TABLE IF EXISTS `securableitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `securableitem` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `securableitem`
--

LOCK TABLES `securableitem` WRITE;
/*!40000 ALTER TABLE `securableitem` DISABLE KEYS */;
INSERT INTO `securableitem` VALUES (1,7),(2,9),(3,10),(4,11),(5,12),(6,13),(7,15);
/*!40000 ALTER TABLE `securableitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sellpriceformula`
--

DROP TABLE IF EXISTS `sellpriceformula`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sellpriceformula` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(11) DEFAULT NULL,
  `discountormarkuppercentage` double DEFAULT NULL,
  `producttemplate_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sellpriceformula`
--

LOCK TABLES `sellpriceformula` WRITE;
/*!40000 ALTER TABLE `sellpriceformula` DISABLE KEYS */;
/*!40000 ALTER TABLE `sellpriceformula` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sendgridemailaccount`
--

DROP TABLE IF EXISTS `sendgridemailaccount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sendgridemailaccount` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apiusername` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `apipassword` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fromname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fromaddress` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` text COLLATE utf8_unicode_ci,
  `replytoaddress` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_id` int(11) unsigned DEFAULT NULL,
  `_user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sendgridemailaccount`
--

LOCK TABLES `sendgridemailaccount` WRITE;
/*!40000 ALTER TABLE `sendgridemailaccount` DISABLE KEYS */;
/*!40000 ALTER TABLE `sendgridemailaccount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shorturl`
--

DROP TABLE IF EXISTS `shorturl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shorturl` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` text COLLATE utf8_unicode_ci,
  `createddatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shorturl`
--

LOCK TABLES `shorturl` WRITE;
/*!40000 ALTER TABLE `shorturl` DISABLE KEYS */;
/*!40000 ALTER TABLE `shorturl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `socialitem`
--

DROP TABLE IF EXISTS `socialitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `socialitem` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8_unicode_ci,
  `latestdatetime` datetime DEFAULT NULL,
  `ownedsecurableitem_id` int(11) unsigned DEFAULT NULL,
  `note_id` int(11) unsigned DEFAULT NULL,
  `touser__user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `socialitem`
--

LOCK TABLES `socialitem` WRITE;
/*!40000 ALTER TABLE `socialitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `socialitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `socialitem_read`
--

DROP TABLE IF EXISTS `socialitem_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `socialitem_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `socialitem_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `socialitem_read`
--

LOCK TABLES `socialitem_read` WRITE;
/*!40000 ALTER TABLE `socialitem_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `socialitem_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stuckjob`
--

DROP TABLE IF EXISTS `stuckjob`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stuckjob` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stuckjob`
--

LOCK TABLES `stuckjob` WRITE;
/*!40000 ALTER TABLE `stuckjob` DISABLE KEYS */;
/*!40000 ALTER TABLE `stuckjob` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task`
--

DROP TABLE IF EXISTS `task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `task` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `completeddatetime` datetime DEFAULT NULL,
  `completed` tinyint(1) unsigned DEFAULT NULL,
  `duedatetime` datetime DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `name` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `activity_id` int(11) unsigned DEFAULT NULL,
  `requestedbyuser__user_id` int(11) unsigned DEFAULT NULL,
  `project_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task`
--

LOCK TABLES `task` WRITE;
/*!40000 ALTER TABLE `task` DISABLE KEYS */;
/*!40000 ALTER TABLE `task` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_read`
--

DROP TABLE IF EXISTS `task_read`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `task_read` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `securableitem_id` int(11) unsigned NOT NULL,
  `munge_id` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `securableitem_id_munge_id` (`securableitem_id`,`munge_id`),
  KEY `task_read_securableitem_id` (`securableitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_read`
--

LOCK TABLES `task_read` WRITE;
/*!40000 ALTER TABLE `task_read` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_read` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_read_subscription`
--

DROP TABLE IF EXISTS `task_read_subscription`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `task_read_subscription` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) unsigned NOT NULL,
  `modelid` int(11) unsigned NOT NULL,
  `modifieddatetime` datetime DEFAULT NULL,
  `subscriptiontype` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `userid_modelid` (`userid`,`modelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_read_subscription`
--

LOCK TABLES `task_read_subscription` WRITE;
/*!40000 ALTER TABLE `task_read_subscription` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_read_subscription` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `taskchecklistitem`
--

DROP TABLE IF EXISTS `taskchecklistitem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taskchecklistitem` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8_unicode_ci,
  `sortorder` int(11) DEFAULT NULL,
  `completed` tinyint(1) unsigned DEFAULT NULL,
  `task_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `taskchecklistitem`
--

LOCK TABLES `taskchecklistitem` WRITE;
/*!40000 ALTER TABLE `taskchecklistitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `taskchecklistitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workflowmessageinqueue`
--

DROP TABLE IF EXISTS `workflowmessageinqueue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `workflowmessageinqueue` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `modelclassname` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `processdatetime` datetime DEFAULT NULL,
  `serializeddata` text COLLATE utf8_unicode_ci,
  `item_id` int(11) unsigned DEFAULT NULL,
  `modelitem_item_id` int(11) unsigned DEFAULT NULL,
  `savedworkflow_id` int(11) unsigned DEFAULT NULL,
  `triggeredbyuser__user_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workflowmessageinqueue`
--

LOCK TABLES `workflowmessageinqueue` WRITE;
/*!40000 ALTER TABLE `workflowmessageinqueue` DISABLE KEYS */;
/*!40000 ALTER TABLE `workflowmessageinqueue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'zurmo327'
--
/*!50003 DROP FUNCTION IF EXISTS `any_user_in_a_sub_role_has_read_permission` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `any_user_in_a_sub_role_has_read_permission`(
                                securableitem_id int(11),
                                role_id          int(11),
                                class_name       varchar(255),
                                module_name      varchar(255)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare has_read tinyint default 0;

                call any_user_in_a_sub_role_has_read_permission(securableitem_id, role_id, class_name, module_name, has_read);
                return has_read;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `create_email_message` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `create_email_message`(text_content text, html_content text, from_name varchar(128),
                                                    from_address varchar(255), user_id int, owner_id int,
                                                    subject varchar(255), headers text, folder_id int,
                                                    serialized_data text, to_address varchar(255), to_name varchar(128),
                                                    recipient_type int, contact_item_id int,
                                                    related_model_type varchar(255), related_model_id int,
                                                    now_timestamp datetime, content_type varchar(255), 
                                                    campaign_content_id int, contact_id int, autoresponder_content_id int) RETURNS int(11)
    MODIFIES SQL DATA
begin
                insert into `emailmessagecontent` ( `textcontent`, `htmlcontent` )
                            values ( text_content, html_content );
                set @contentId = last_insert_id();
                insert into `emailmessagesender` ( `fromname`, `fromaddress` )
                            values ( from_name, from_address );
                set @senderId = last_insert_id();
                set @emailMessageItemId = create_item(1, now_timestamp);
                insert into `securableitem` ( `item_id` )
                            values ( @emailMessageItemId );
                insert into `ownedsecurableitem` ( `securableitem_id`, `owner__user_id` )
                            values ( last_insert_id(), owner_id );
                insert into `emailmessage` ( `subject`, `headers`, `ownedsecurableitem_id`,
                                                `content_emailmessagecontent_id`, `sender_emailmessagesender_id`,
                                                 `folder_emailfolder_id`, `contenttype`, 
                                                 `campaigncontent_campaignemailmessagecontent_id`, `contact_contact_id`, `autorespondercontent_autoresponderemailmessagecontent_id`)
                             values ( subject, headers, last_insert_id(), @contentId, @senderId, folder_id, content_type, campaign_content_id, contact_id, autoresponder_content_id);
                set @emailMessageId = LAST_INSERT_ID();
                insert into `auditevent` ( `datetime`, `modulename`, `eventname`, `_user_id`,
                                            `modelclassname`, `modelid`, `serializeddata` )
                            values ( now_timestamp, "ZurmoModule", "Item Created", user_id,
                                    "EmailMessage", @emailMessageId, serialized_data );
                insert into `emailmessagerecipient` ( `toaddress`, `toname`, `type`, `emailmessage_id` )
                            values ( to_address, to_name, recipient_type, @emailMessageId );
                set @recipientId = last_insert_id();
                insert into `emailmessagerecipient_item` ( `emailmessagerecipient_id`, `item_id` )
                            values ( @recipientId, contact_item_id );
                call duplicate_filemodels(related_model_type, related_model_id, "emailmessage", @emailMessageId, user_id, now_timestamp);
                return @emailMessageId;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `create_item` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `create_item`(user_id int, now_timestamp datetime) RETURNS int(11)
begin
              insert into `item` ( `id`, `createddatetime`, `modifieddatetime`,
                    `createdbyuser__user_id`, `modifiedbyuser__user_id` )
                    VALUES ( NULL,  now_timestamp , now_timestamp, user_id, user_id  );
               return last_insert_id();
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_group_actual_right` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_group_actual_right`(
                                _group_id   int(11),
                                module_name varchar(255),
                                right_name  varchar(255)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint;

                select get_group_explicit_actual_right (_group_id, module_name, right_name) |
                       get_group_inherited_actual_right(_group_id, module_name, right_name)
                into result;
                if (result & 2) = 2 then
                    return 2;
                end if;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_group_explicit_actual_policy` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_group_explicit_actual_policy`(
                                _group_id   int(11),
                                module_name varchar(255),
                                policy_name varchar(255)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint;
                declare _permitable_id int;

                select permitable_id
                into   _permitable_id
                from   _group
                where  id = _group_id;
                select get_permitable_explicit_actual_policy(_permitable_id, module_name, policy_name)
                into result;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_group_explicit_actual_right` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_group_explicit_actual_right`(
                                _group_id   int(11),
                                module_name varchar(255),
                                right_name  varchar(255)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint;
                declare _permitable_id int;

                select permitable_id
                into   _permitable_id
                from   _group
                where  id = _group_id;
                select get_permitable_explicit_actual_right(_permitable_id, module_name, right_name)
                into result;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_group_inherited_actual_right` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_group_inherited_actual_right`(
                                _group_id   int(11),
                                module_name varchar(255),
                                right_name  varchar(255)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare combined_right tinyint;

                call get_group_inherited_actual_right_ignoring_everyone(_group_id, module_name, right_name, combined_right);
                select combined_right |
                       get_named_group_explicit_actual_right('Everyone', module_name, right_name)
                into combined_right;
                if (combined_right & 2) = 2 then
                    return 2;
                end if;
                return combined_right;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_named_group_explicit_actual_policy` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_named_group_explicit_actual_policy`(
                                group_name  varchar(255),
                                module_name varchar(255),
                                policy_name varchar(255)
                             ) RETURNS varchar(255) CHARSET utf8 COLLATE utf8_unicode_ci
    READS SQL DATA
    DETERMINISTIC
begin                # but since PDO returns it as a string I am too, until I know if that is a bad thing.
                declare result tinyint;
                declare _permitable_id int;

                select permitable_id
                into   _permitable_id
                from   _group
                where  name = group_name;
                select get_permitable_explicit_actual_policy(_permitable_id, module_name, policy_name)
                into result;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_named_group_explicit_actual_right` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_named_group_explicit_actual_right`(
                                group_name  varchar(255),
                                module_name varchar(255),
                                right_name  varchar(255)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint;
                declare _permitable_id int;

                select permitable_id
                into   _permitable_id
                from   _group
                where  name = group_name;
                select get_permitable_explicit_actual_right(_permitable_id, module_name, right_name)
                into result;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_permitable_explicit_actual_policy` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_permitable_explicit_actual_policy`(
                                permitable_id int(11),
                                module_name   varchar(255),
                                policy_name   varchar(255)
                             ) RETURNS varchar(255) CHARSET utf8 COLLATE utf8_unicode_ci
    READS SQL DATA
    DETERMINISTIC
begin                # but since PDO returns it as a string I am too, until I know if that is a bad thing.
                declare result tinyint;

                select value
                into   result
                from   policy
                where  policy.modulename    = module_name and
                       name                 = policy_name and
                       policy.permitable_id = permitable_id
                limit  1;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_permitable_explicit_actual_right` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_permitable_explicit_actual_right`(
                                permitable_id int(11),
                                module_name   varchar(255),
                                right_name    varchar(255)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint;

                select max(type)
                into   result
                from   _right
                where  _right.modulename    = module_name and
                       name                 = right_name and
                       _right.permitable_id = permitable_id;
                if result is null then
                    return 0;
                end if;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_permitable_group_id` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_permitable_group_id`(
                                _permitable_id int(11)
                            ) RETURNS int(11)
begin
                declare result int(11);

                select id
                into   result
                from   _group
                where  _group.permitable_id = _permitable_id;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_permitable_user_id` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_permitable_user_id`(
                                _permitable_id int(11)
                            ) RETURNS int(11)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result int(11);

                select id
                into   result
                from   _user
                where  _user.permitable_id = _permitable_id;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_securableitem_actual_permissions_for_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_securableitem_actual_permissions_for_permitable`(
                                _securableitem_id int(11),
                                _permitable_id    int(11),
                                class_name        varchar(255),
                                module_name       varchar(255),
                                caching_on        tinyint
                             ) RETURNS smallint(6)
    READS SQL DATA
    DETERMINISTIC
begin
                declare allow_permissions, deny_permissions smallint default 0;
                declare is_super_administrator, is_owner tinyint;

                delete from __role_children_cache;

                select named_group_contains_permitable('Super Administrators', _permitable_id)
                into is_super_administrator;
                if is_super_administrator then
                    set allow_permissions = 31;
                    set deny_permissions  = 0;
                else                                                            # Not Coding Standard
                    begin
                        select _securableitem_id in
                            (select securableitem_id
                             from   _user, ownedsecurableitem
                             where  _user.id = ownedsecurableitem.owner__user_id and
                                    permitable_id = _permitable_id)
                        into is_owner;
                    end;
                    if is_owner then
                        set allow_permissions = 31;
                        set deny_permissions  = 0;
                    else                                                        # Not Coding Standard
                        if caching_on then
                            call get_securableitem_cached_actual_permissions_for_permitable(_securableitem_id, _permitable_id, allow_permissions, deny_permissions);
                            if allow_permissions is null then
                                call recursive_get_securableitem_actual_permissions_for_permitable(_securableitem_id, _permitable_id, class_name, module_name, allow_permissions, deny_permissions);
                                call cache_securableitem_actual_permissions_for_permitable(_securableitem_id, _permitable_id, allow_permissions, deny_permissions);
                            end if;
                        else                                                    # Not Coding Standard
                            call recursive_get_securableitem_actual_permissions_for_permitable(_securableitem_id, _permitable_id, class_name, module_name, allow_permissions, deny_permissions);
                        end if;
                    end if;
                end if;
                return (allow_permissions << 8) | deny_permissions;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_user_actual_right` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_user_actual_right`(
                                _user_id    int(11),
                                module_name varchar(255),
                                right_name  varchar(255)
                            ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint;
                declare is_super_administrator tinyint;

                select named_group_contains_user('Super Administrators', _user_id)
                into   is_super_administrator;
                if is_super_administrator then
                    set result = 1;
                else                                                            # Not Coding Standard
                    call recursive_get_user_actual_right(_user_id, module_name, right_name, result);
                end if;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_user_explicit_actual_policy` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_user_explicit_actual_policy`(
                                _user_id    int(11),
                                module_name varchar(255),
                                policy_name varchar(255)
                             ) RETURNS varchar(255) CHARSET utf8 COLLATE utf8_unicode_ci
    READS SQL DATA
    DETERMINISTIC
begin                # but since PDO returns it as a string I am too, until I know if that is a bad thing.
                declare result tinyint;
                declare _permitable_id int;

                select permitable_id
                into   _permitable_id
                from   _user
                where  id = _user_id;
                select get_permitable_explicit_actual_policy(_permitable_id, module_name, policy_name)
                into result;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_user_explicit_actual_right` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_user_explicit_actual_right`(
                                _user_id    int(11),
                                module_name varchar(255),
                                right_name  varchar(255)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint;
                declare _permitable_id int;

                select permitable_id
                into   _permitable_id
                from   _user
                where  id = _user_id;
                select get_permitable_explicit_actual_right(_permitable_id, module_name, right_name)
                into result;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `get_user_inherited_actual_right` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `get_user_inherited_actual_right`(
                                _user_id    int(11),
                                module_name varchar(255),
                                right_name  varchar(255)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare combined_right tinyint default 0;
                declare __group_id int(11);
                declare no_more_records tinyint default 0;
                declare _group_ids cursor for
                    select _group_id
                    from   _group__user
                    where  _group__user._user_id = _user_id;
                declare continue handler for not found
                    set no_more_records = 1;

                open _group_ids;
                fetch _group_ids into __group_id;
                while no_more_records = 0 do
                    select combined_right |
                           get_group_explicit_actual_right (__group_id, module_name, right_name) |
                           get_group_inherited_actual_right(__group_id, module_name, right_name)
                    into combined_right;
                    fetch _group_ids into __group_id;
                end while;
                close _group_ids;

                select combined_right |
                       get_named_group_explicit_actual_right('Everyone', module_name, right_name)
                into combined_right;

                if (combined_right & 2) = 2 then
                    return 2;
                end if;
                return combined_right;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `group_contains_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `group_contains_permitable`(
                                _group_id      int(11),
                                _permitable_id int(11)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint default 0;
                declare _group_name varchar(255);
                declare is_everyone tinyint;
                declare _user_id int(11);
                declare group_id_2 int(11);

                select name
                into   _group_name
                from   _group
                where  _group.id = _group_id;
                if _group_name = 'Everyone' then
                    set result = 1;
                else                                                            # Not Coding Standard
                    set _user_id = get_permitable_user_id(_permitable_id);
                    if _user_id is not null then
                        call recursive_group_contains_user(_group_id, _user_id, result);
                    else                                                        # Not Coding Standard
                        set group_id_2 = get_permitable_group_id(_permitable_id);
                        if group_id_2 is not null then
                            call recursive_group_contains_group(_group_id, group_id_2, result);
                        end if;
                    end if;
                end if;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `group_contains_user` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `group_contains_user`(
                                _group_id int(11),
                                _user_id  int(11)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint default 0;

                call recursive_group_contains_user(_group_id, _user_id, result);
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `named_group_contains_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `named_group_contains_permitable`(
                                group_name     varchar(255),
                                _permitable_id int(11)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint default 0;
                declare group_id_1 int(11);
                declare _user_id   int(11);
                declare group_id_2 int(11);

                if group_name = 'Everyone' then
                    set result = 1;
                else                                                            # Not Coding Standard
                    select id
                    into   group_id_1
                    from   _group
                    where  _group.name = group_name;
                    set _user_id = get_permitable_user_id(_permitable_id);
                    if _user_id is not null then
                        call recursive_group_contains_user(group_id_1, _user_id, result);
                    else                                                        # Not Coding Standard
                        set group_id_2 = get_permitable_group_id(_permitable_id);
                        if group_id_2 is not null then
                            call recursive_group_contains_group(group_id_1, group_id_2, result);
                        end if;
                    end if;
                end if;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `named_group_contains_user` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `named_group_contains_user`(
                                _group_name varchar(255),
                                _user_id    int(11)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint default 0;
                declare _group_id int(11);

                if _group_name = 'Everyone' then
                    set result = 1;
                else                                                            # Not Coding Standard
                    select id
                    into   _group_id
                    from   _group
                    where  _group.name = _group_name;
                    call recursive_group_contains_user(_group_id, _user_id, result);
                end if;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `permitable_contains_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE FUNCTION `permitable_contains_permitable`(
                                permitable_id_1 int(11),
                                permitable_id_2 int(11)
                             ) RETURNS tinyint(4)
    READS SQL DATA
    DETERMINISTIC
begin
                declare result tinyint;
                declare user_id_1, user_id_2, group_id_1, group_id_2 int(11);

                # If they are both users just compare if they are the same user.
                select get_permitable_user_id(permitable_id_1)
                into   user_id_1;
                select get_permitable_user_id(permitable_id_2)
                into   user_id_2;
                if user_id_1 is not null and user_id_2 is not null then
                    set result = permitable_id_1 = permitable_id_2;
                else                                                            # Not Coding Standard
                    # If the first is a user and the second is a group return false.
                    select get_permitable_group_id(permitable_id_2)
                    into   group_id_2;
                    if user_id_1 is not null and group_id_2 is not null then
                        set result = 0;
                    else                                                        # Not Coding Standard
                        # Otherwise the first is a group, just return if it contains
                        # the second.
                        select get_permitable_group_id(permitable_id_1)
                        into   group_id_1;
                        if group_id_1 is not null then
                            select group_contains_permitable(group_id_1, permitable_id_2)
                            into result;
                        end if;
                    end if;
                end if;
                return result;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `cache_securableitem_actual_permissions_for_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `cache_securableitem_actual_permissions_for_permitable`(
                                in _securableitem_id  int(11),
                                in _permitable_id     int(11),
                                in _allow_permissions tinyint,
                                in _deny_permissions  tinyint
                              )
begin
                # Tables cannot be created inside stored routines
                # so this cannot automatically create the cache
                # table if it doesn't exist. So it is done when
                # the stored routines are created.
                insert into actual_permissions_cache
                values (_securableitem_id, _permitable_id, _allow_permissions, _deny_permissions);
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `clear_cache_actual_rights` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `clear_cache_actual_rights`()
    READS SQL DATA
begin
                delete from actual_rights_cache;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `clear_cache_all_actual_permissions` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `clear_cache_all_actual_permissions`()
    READS SQL DATA
begin
                delete from actual_permissions_cache;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `clear_cache_named_securable_all_actual_permissions` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `clear_cache_named_securable_all_actual_permissions`()
    READS SQL DATA
begin
                delete from named_securable_actual_permissions_cache;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `clear_cache_securableitem_actual_permissions` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `clear_cache_securableitem_actual_permissions`(
                                in _securableitem_id int(11)
                              )
begin
                delete from actual_permissions_cache
                where securableitem_id = _securableitem_id;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `create_campaign_items` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `create_campaign_items`(campaign_id int, marketing_list_id int, processed int)
begin
                insert into `campaignitem` (`id`, `processed`, `campaign_id`, `contact_id`)
                    select null as id, processed as `processed`, campaign_id as `campaign_id`, `marketinglistmember`.`contact_id`
                        from `marketinglistmember`
                            left join `campaignitem` on `campaignitem`.`contact_id` = `marketinglistmember`.`contact_id`
                                and `campaignitem`.`campaign_id` = campaign_id
                            left join `contact` on `contact`.`id` = `marketinglistmember`.`contact_id`
                        where (`marketinglistmember`.`marketinglist_id` = marketing_list_id
                                and `campaignitem`.`id` is null and `contact`.`id` is not null);
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `decrement_count` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `decrement_count`(
                                in munge_table_name  varchar(255),
                                in _securableitem_id int(11),
                                in item_id           int(11),
                                in _type             char
                             )
begin

                update munge_table_name
                set count = count - 1
                where securableitem_id = _securableitem_id and
                      munge_id         = concat(_type, item_id);
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `decrement_parent_roles_counts` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `decrement_parent_roles_counts`(
                                in munge_table_name varchar(255),
                                in securableitem_id int(11),
                                in role_id          int(11)
                              )
begin
                declare parent_role_id int(11);

                select role_id
                into   parent_role_id
                from   role
                where  id = role_id;
                if parent_role_id is not null then
                    call decrement_count              (munge_table_name, securableitem_id, parent_role_id);
                    call decrement_parent_roles_counts(munge_table_name, securableitem_id, parent_role_id);
                end if;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `duplicate_filemodels` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `duplicate_filemodels`(related_model_type varchar(255), related_model_id int,
                                                new_model_type varchar(255), new_model_id int, user_id int,
                                                 now_timestamp datetime)
begin
                insert into `filemodel` (`id`, `name`, `size`, `type`, `item_id`,
                                                    `filecontent_id`, `relatedmodel_id`, `relatedmodel_type`)
                    select null as `id`, `name`, `size`, `type`, (select create_item(user_id, now_timestamp)) as `item_id`, `filecontent_id`,
                        new_model_id as `relatedmodel_id`, new_model_type as `relatedmodel_type`
                    from `filemodel`
                    where `relatedmodel_type` = related_model_type and `relatedmodel_id` = related_model_id;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `generate_campaign_items` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `generate_campaign_items`(active_status int, processing_status int, now_timestamp datetime)
begin
                  declare loop0_eof boolean default false;
                  declare campaign_id int(11);
                  declare marketinglist_id int(11);

                  declare cursor0 cursor for select `campaign`.`id`, `campaign`.`marketinglist_id` from `campaign`
                        where ((`campaign`.`status` = active_status) and (`campaign`.`sendondatetime` < now_timestamp));
                  declare continue handler for not found set loop0_eof = TRUE;
                  open cursor0;
                        loop0: loop
                              fetch cursor0 into campaign_id, marketinglist_id;
                              if loop0_eof then
                                    leave loop0;
                              end if;
                              call create_campaign_items(campaign_id, marketinglist_id, 0);
                              update `campaign` set `status` = processing_status where id = campaign_id;
                        end loop loop0;
                  close cursor0;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `get_group_inherited_actual_right_ignoring_everyone` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `get_group_inherited_actual_right_ignoring_everyone`(
                                in  _group_id   int(11),
                                in  module_name varchar(255),
                                in  right_name  varchar(255),
                                out result      tinyint
                              )
begin
                declare parent_group_id int(11);

                set result = 0;
                select _group._group_id
                into   parent_group_id
                from   _group
                where  id = _group_id;
                if parent_group_id is not null then
                    call get_group_inherited_actual_right_ignoring_everyone(parent_group_id, module_name, right_name, result);
                    select result |
                           get_group_explicit_actual_right(parent_group_id, module_name, right_name)
                    into result;
                    if (result & 2) = 2 then
                        set result = 2;
                    end if;
                end if;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `get_securableitem_cached_actual_permissions_for_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `get_securableitem_cached_actual_permissions_for_permitable`(
                                in  _securableitem_id  int(11),
                                in  _permitable_id     int(11),
                                out _allow_permissions tinyint,
                                out _deny_permissions  tinyint
                             )
begin
                select allow_permissions, deny_permissions
                into   _allow_permissions, _deny_permissions
                from   actual_permissions_cache
                where  securableitem_id = _securableitem_id and
                       permitable_id    = _permitable_id;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `get_securableitem_explicit_actual_permissions_for_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `get_securableitem_explicit_actual_permissions_for_permitable`(
                                in  _securableitem_id int(11),
                                in  _permitable_id    int(11),
                                out allow_permissions tinyint,
                                out deny_permissions  tinyint
                              )
begin
                select bit_or(permissions)
                into   allow_permissions
                from   permission
                where  type = 1                          and
                       permitable_id    = _permitable_id and
                       securableitem_id = _securableitem_id;

                select bit_or(permissions)
                into   deny_permissions
                from   permission
                where  type = 2                       and
                       permitable_id = _permitable_id and
                securableitem_id = _securableitem_id;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `get_securableitem_explicit_inherited_permissions_for_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `get_securableitem_explicit_inherited_permissions_for_permitable`(
                                in  _securableitem_id int(11),
                                in  _permitable_id    int(11),
                                out allow_permissions tinyint,
                                out deny_permissions  tinyint
                              )
begin
                declare permissions_permitable_id int(11);
                declare _type, _permissions, permission_applies tinyint;
                declare no_more_records tinyint default 0;
                declare permitable_id_type_and_permissions cursor for
                    select permitable_id, type, bit_or(permissions)
                    from   permission
                    where  securableitem_id = _securableitem_id
                    group  by permitable_id, type;
                declare continue handler for not found
                    set no_more_records = 1;

                set allow_permissions = 0;
                set deny_permissions  = 0;
                open permitable_id_type_and_permissions;
                fetch permitable_id_type_and_permissions into
                            permissions_permitable_id, _type, _permissions;
                # The query will return at most one row with the allow bits and
                # one with the deny bits, so this loop will loop 0, 1, or 2 times.
                while no_more_records = 0 do
                    select permitable_contains_permitable(permissions_permitable_id, _permitable_id)
                    into   permission_applies;
                    if permission_applies then
                        if _type = 1 then
                            set allow_permissions = allow_permissions | _permissions;
                        else                                                    # Not Coding Standard
                            set deny_permissions  = deny_permissions  | _permissions;
                        end if;
                    end if;
                    fetch permitable_id_type_and_permissions into
                                permissions_permitable_id, _type, _permissions;
                end while;
                close permitable_id_type_and_permissions;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `get_securableitem_module_and_model_permissions_for_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `get_securableitem_module_and_model_permissions_for_permitable`(
                                in  _securableitem_id int(11),
                                in  _permitable_id    int(11),
                                in  class_name        varchar(255),
                                in  module_name       varchar(255),
                                out allow_permissions tinyint,
                                out deny_permissions  tinyint
                               )
begin
                declare permissions_permitable_id int(11);
                declare _type, _permissions, permission_applies tinyint;
                declare no_more_records                         tinyint default 0;
                declare permitable_id_type_and_permissions_for_namedsecurableitem cursor for
                    select permitable_id, type, bit_or(permissions)
                    from   permission, namedsecurableitem
                    where  permission.securableitem_id = namedsecurableitem.securableitem_id and
                           (name = class_name or name = module_name)
                           group by permitable_id, type;
                declare continue handler for not found
                    set no_more_records = 1;

                set allow_permissions = 0;
                set deny_permissions  = 0;
                open permitable_id_type_and_permissions_for_namedsecurableitem;
                fetch permitable_id_type_and_permissions_for_namedsecurableitem into
                            permissions_permitable_id, _type, _permissions;
                # The query will return at most one row with the allow bits and
                # one with the deny bits, so this loop will loop 0, 1, or 2 times.
                while no_more_records = 0 do
                    select permitable_contains_permitable(permissions_permitable_id, _permitable_id)
                    into   permission_applies;
                    if permission_applies then
                        if _type = 1 then
                            set allow_permissions = allow_permissions | _permissions;
                        else                                                    # Not Coding Standard
                            set deny_permissions  = deny_permissions  | _permissions;
                        end if;
                    end if;
                    fetch permitable_id_type_and_permissions_for_namedsecurableitem into
                                permissions_permitable_id, _type, _permissions;
                end while;
                close permitable_id_type_and_permissions_for_namedsecurableitem;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `get_securableitem_propagated_allow_permissions_for_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `get_securableitem_propagated_allow_permissions_for_permitable`(
                                in  _securableitem_id int(11),
                                in  _permitable_id    int(11),
                                in  class_name        varchar(255),
                                in  module_name       varchar(255),
                                out allow_permissions tinyint
                              )
begin
                declare user_id int(11);
                declare user_role_id int(11);
                declare parent_role_id int(11);

                select role_id into user_role_id from _user where permitable_id = _permitable_id;
                set allow_permissions = 0;
                select get_permitable_user_id(_permitable_id)
                into   user_id;
                if user_id is not null then
                    call recursive_get_all_descendent_roles(_permitable_id, user_role_id);
                    call recursive_get_securableitem_propagated_allow_permissions_permit(_securableitem_id, _permitable_id, class_name, module_name, allow_permissions);
                end if;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `increment_count` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `increment_count`(
                                in munge_table_name varchar(255),
                                in securableitem_id int(11),
                                in item_id          int(11),
                                in _type            char
                              )
begin
                # TODO: insert only if the row doesn't exist
                # in a way that doesn't ignore all errors.

                set @sql = concat("insert into ", munge_table_name,
                                  "(securableitem_id, munge_id, count) ",
                                  "values (", securableitem_id, ", '", concat(_type, item_id), "', 1) ",
                                  "on duplicate key ",
                                  "update count = count + 1");
                prepare statement from @sql;
                execute statement;
                deallocate prepare statement;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `increment_parent_roles_counts` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `increment_parent_roles_counts`(
                                in munge_table_name varchar(255),
                                in securableitem_id int(11),
                                in _role_id         int(11)
                              )
begin
                declare parent_role_id int(11);

                select role_id
                into   parent_role_id
                from   role
                where  id = _role_id;
                if parent_role_id is not null then
                    call increment_count              (munge_table_name, securableitem_id, parent_role_id, "R");
                    call increment_parent_roles_counts(munge_table_name, securableitem_id, parent_role_id);
                end if;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `rebuild` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `rebuild`(
                                in model_table_name varchar(255),
                                in munge_table_name varchar(255)
                              )
begin
                call recreate_tables(munge_table_name);
                call rebuild_users  (model_table_name, munge_table_name);
                call rebuild_groups (model_table_name, munge_table_name);
                call rebuild_roles  (model_table_name, munge_table_name);
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `rebuild_a_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `rebuild_a_permitable`(
                                in munge_table_name varchar(255),
                                in securableitem_id int(11),
                                in actual_id        int(11),
                                in _permitable_id   int(11),
                                in _type            char
                              )
begin
                declare allow_permissions, deny_permissions, effective_explicit_permissions smallint default 0;

                call get_securableitem_explicit_actual_permissions_for_permitable(securableitem_id, _permitable_id, allow_permissions, deny_permissions);
                set effective_explicit_permissions = allow_permissions & ~deny_permissions;
                if (effective_explicit_permissions & 1) = 1 then # Permission::READ
                    call increment_count(munge_table_name, securableitem_id, actual_id, _type);
                    if _type = "G" then
                        call rebuild_roles_for_users_in_group(munge_table_name, securableitem_id, actual_id);
                        call rebuild_sub_groups              (munge_table_name, securableitem_id, actual_id);
                    end if;
                end if;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `rebuild_groups` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `rebuild_groups`(
                                in model_table_name varchar(255),
                                in munge_table_name varchar(255)
                              )
begin
                set @select_statement  = concat("select permission.securableitem_id, _group.id, permission.permitable_id
                                         from ", model_table_name , ", ownedsecurableitem, permission, _group
                                         where
                                         ", model_table_name, ".ownedsecurableitem_id = ownedsecurableitem.id AND
                                         ownedsecurableitem.securableitem_id = permission.securableitem_id AND
                                         permission.permitable_id = _group.permitable_id");
                set @rebuild_groups_temp_table = CONCAT("create temporary table rebuild_temp_table as ", @select_statement);
                prepare statement FROM @rebuild_groups_temp_table;
                execute statement;
                deallocate prepare statement;
                begin
                    declare _securableitem_id, __group_id, _permitable_id int(11);
                    declare no_more_records tinyint default 0;
                    declare securableitem_group_and_permitable_ids cursor for
                        select * from rebuild_temp_table;
                    declare continue handler for not found
                        set no_more_records = 1;
                    open securableitem_group_and_permitable_ids;
                    fetch securableitem_group_and_permitable_ids into _securableitem_id, __group_id, _permitable_id;
                    while no_more_records = 0 do
                        call rebuild_a_permitable(munge_table_name, _securableitem_id, __group_id, _permitable_id, "G");
                        fetch securableitem_group_and_permitable_ids into _securableitem_id, __group_id, _permitable_id;
                    end while;
                    close securableitem_group_and_permitable_ids;
                    drop temporary table if exists rebuild_temp_table;
                end;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `rebuild_roles` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `rebuild_roles`(
                                in model_table_name varchar(255),
                                in munge_table_name varchar(255)
                              )
begin
                call rebuild_roles_owned_securableitems                         (model_table_name, munge_table_name);
                call rebuild_roles_securableitem_with_explicit_user_permissions (model_table_name, munge_table_name);
                call rebuild_roles_securableitem_with_explicit_group_permissions(model_table_name, munge_table_name);
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `rebuild_roles_for_users_in_group` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `rebuild_roles_for_users_in_group`(
                                in munge_table_name  varchar(255),
                                in _securableitem_id int(11),
                                in __group_id        int(11)
                              )
begin
                declare _role_id int(11);
                declare no_more_records tinyint default 0;
                declare role_ids cursor for
                    select role_id
                    from   _group__user, _user
                    where  _group__user._group_id = __group_id and
                           _user.id = _group__user._user_id;
                declare continue handler for not found
                    set no_more_records = 1;

                open role_ids;
                fetch role_ids into _role_id;
                while no_more_records = 0 do
                    call increment_parent_roles_counts(munge_table_name, _securableitem_id, _role_id);
                    fetch role_ids into _role_id;
                end while;
                close role_ids;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `rebuild_roles_owned_securableitems` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `rebuild_roles_owned_securableitems`(
                                in model_table_name varchar(255),
                                in munge_table_name varchar(255)
                              )
begin
                set @select_statement  = concat("select role_id, ownedsecurableitem.securableitem_id
                                         from ", model_table_name, ", _user, ownedsecurableitem
                                         where ", model_table_name, ".ownedsecurableitem_id = ownedsecurableitem.id AND
                                         _user.id = ownedsecurableitem.owner__user_id and _user.role_id is not null");
                set @rebuild_roles_temp_table = CONCAT("create temporary table rebuild_temp_table as ", @select_statement);
                prepare statement FROM @rebuild_roles_temp_table;
                execute statement;
                deallocate prepare statement;
                   begin
                declare _role_id, _securableitem_id int(11);
                declare no_more_records tinyint default 0;
                declare role_and_securableitem_ids cursor for
                    select * from rebuild_temp_table;
                declare continue handler for not found
                    set no_more_records = 1;
                open role_and_securableitem_ids;
                fetch role_and_securableitem_ids into _role_id, _securableitem_id;
                while no_more_records = 0 do
                    call increment_parent_roles_counts(munge_table_name, _securableitem_id, _role_id);
                    fetch role_and_securableitem_ids into _role_id, _securableitem_id;
                end while;
                close role_and_securableitem_ids;
                drop temporary table if exists rebuild_temp_table;
                end;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `rebuild_roles_securableitem_with_explicit_group_permissions` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `rebuild_roles_securableitem_with_explicit_group_permissions`(
                                in model_table_name varchar(255),
                                in munge_table_name varchar(255)
                              )
begin
                set @select_statement  =  concat("select role.role_id, permission.securableitem_id
                                           from ", model_table_name, ", ownedsecurableitem, _user, _group, _group__user, permission, role
                                           where ", model_table_name, ".ownedsecurableitem_id = ownedsecurableitem.id and
                                           ownedsecurableitem.securableitem_id = permission.securableitem_id and
                                           _user.id = _group__user._user_id                and
                                           permission.permitable_id = _group.permitable_id and
                                           _group__user._group_id = _group.id              and
                                           _user.role_id = role.role_id                    and
                                           ((permission.permissions & 1) = 1)              and
                                           permission.type = 1");
                set @rebuild_roles_temp_table = CONCAT("create temporary table rebuild_temp_table as ", @select_statement);
                prepare statement FROM @rebuild_roles_temp_table;
                execute statement;
                deallocate prepare statement;
                begin
                    declare _role_id, _securableitem_id int(11);
                    declare no_more_records tinyint default 0;
                    declare role_and_securableitem_ids cursor for
                        select * from rebuild_temp_table;
                    declare continue handler for not found
                        set no_more_records = 1;
                    open role_and_securableitem_ids;
                    fetch role_and_securableitem_ids into _role_id, _securableitem_id;
                    while no_more_records = 0 do
                        call increment_count              (munge_table_name, _securableitem_id, _role_id, "R");
                        call increment_parent_roles_counts(munge_table_name, _securableitem_id, _role_id);
                        fetch role_and_securableitem_ids into _role_id, _securableitem_id;
                    end while;
                    close role_and_securableitem_ids;
                    drop temporary table if exists rebuild_temp_table;
                end;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `rebuild_roles_securableitem_with_explicit_user_permissions` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `rebuild_roles_securableitem_with_explicit_user_permissions`(
                                in model_table_name varchar(255),
                                in munge_table_name varchar(255)
                              )
begin
                set @select_statement  = concat("select role_id, permission.securableitem_id
                                         from ", model_table_name, ", ownedsecurableitem, permission, _user
                                         where ", model_table_name, ".ownedsecurableitem_id = ownedsecurableitem.id AND
                                         ownedsecurableitem.securableitem_id = permission.securableitem_id AND
                                         permission.permitable_id = _user.permitable_id and
                                         ((permission.permissions & 1) = 1) and permission.type = 1");
                set @rebuild_roles_temp_table = CONCAT("create temporary table rebuild_temp_table as ", @select_statement);
                prepare statement FROM @rebuild_roles_temp_table;
                execute statement;
                deallocate prepare statement;
                begin
                    declare _role_id, _securableitem_id int(11);
                    declare no_more_records tinyint default 0;
                    declare role_and_securableitem_ids cursor for
                        select * from rebuild_temp_table;
                    declare continue handler for not found
                        set no_more_records = 1;
                    open role_and_securableitem_ids;
                    fetch role_and_securableitem_ids into _role_id, _securableitem_id;
                    while no_more_records = 0 do
                        call increment_parent_roles_counts(munge_table_name, _securableitem_id, _role_id);
                        fetch role_and_securableitem_ids into _role_id, _securableitem_id;
                    end while;
                    close role_and_securableitem_ids;
                    drop temporary table if exists rebuild_temp_table;
                end;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `rebuild_sub_groups` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `rebuild_sub_groups`(
                                in munge_table_name  varchar(255),
                                in _securableitem_id int(11),
                                in __group_id        int(11)
                              )
begin
                declare sub_group_id int(11);
                declare no_more_records tinyint default 0;
                declare sub_group_ids cursor for
                    select id
                    from   _group
                    where  _group_id = __group_id;
                declare continue handler for not found
                    set no_more_records = 1;

                open sub_group_ids;
                fetch sub_group_ids into sub_group_id;
                while no_more_records = 0 do
                    call increment_count                 (munge_table_name, _securableitem_id, sub_group_id, "G");
                    call rebuild_roles_for_users_in_group(munge_table_name, _securableitem_id, sub_group_id);
                    call rebuild_sub_groups              (munge_table_name, _securableitem_id, sub_group_id);
                    fetch sub_group_ids into sub_group_id;
                end while;
                close sub_group_ids;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `rebuild_users` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `rebuild_users`(
                                in model_table_name varchar(255),
                                in munge_table_name varchar(255)
                              )
begin
                set @select_statement  = concat("select permission.securableitem_id, _user.id, permission.permitable_id
                                         from ", model_table_name, ", ownedsecurableitem, permission, _user
                                         where ", model_table_name , ".ownedsecurableitem_id = ownedsecurableitem.id and
                                         ownedsecurableitem.securableitem_id = permission.securableitem_id and
                                         permission.permitable_id = _user.permitable_id");
                set @rebuild_users_temp_table = CONCAT("create temporary table rebuild_temp_table as ", @select_statement);
                prepare statement FROM @rebuild_users_temp_table;
                execute statement;
                deallocate prepare statement;
                begin
                    declare _securableitem_id, __user_id, _permitable_id int(11);
                    declare no_more_records tinyint default 0;
                    declare securableitem_user_and_permitable_ids cursor for
                        select * from rebuild_temp_table;
                    declare continue handler for not found
                        set no_more_records = 1;
                    open securableitem_user_and_permitable_ids;
                    fetch securableitem_user_and_permitable_ids into _securableitem_id, __user_id, _permitable_id;
                    while no_more_records = 0 do
                        call rebuild_a_permitable(munge_table_name, _securableitem_id, __user_id, _permitable_id, "U");
                        fetch securableitem_user_and_permitable_ids into _securableitem_id, __user_id, _permitable_id;
                    end while;
                    close securableitem_user_and_permitable_ids;
                    drop temporary table if exists rebuild_temp_table;
                end;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `recreate_tables` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `recreate_tables`(
                                in munge_table_name varchar(255)
                              )
begin
                set @sql = concat("drop table if exists ", munge_table_name);
                prepare statement from @sql;
                execute statement;
                deallocate prepare statement;

                set @sql = concat("create table ", munge_table_name, " (",
                                        "securableitem_id      int(11)     unsigned not null, ",
                                        "munge_id              varchar(12)              null, ",
                                        "count                 int(8)      unsigned not null, ",
                                        "primary key (securableitem_id, munge_id))");
                prepare statement from @sql;
                execute statement;
                deallocate prepare statement;

                set @sql = concat("create index index_", munge_table_name, "_securableitem_id", " ",
                                        "on ", munge_table_name, " (securableitem_id)");
                prepare statement from @sql;
                execute statement;
                deallocate prepare statement;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `recursive_get_all_descendent_roles` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `recursive_get_all_descendent_roles`(in _permitable_id int(11), in parent_role_id int(11))
begin
                declare child_role_id int(11);
                declare no_more_records tinyint default 0;
                declare child_role_ids cursor for
                    select id
                    from   role
                    where  role_id = parent_role_id;
                declare continue handler for not found
                    set no_more_records = 1;

                open child_role_ids;
                fetch child_role_ids into child_role_id;
                while no_more_records = 0 do
                    INSERT IGNORE INTO __role_children_cache VALUES (_permitable_id, child_role_id);
                    call recursive_get_all_descendent_roles(_permitable_id, child_role_id);
                    fetch child_role_ids into child_role_id;
                end while;
                close child_role_ids;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `recursive_get_securableitem_actual_permissions_for_permitable` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `recursive_get_securableitem_actual_permissions_for_permitable`(
                                in  _securableitem_id int(11),
                                in  _permitable_id    int(11),
                                in  class_name        varchar(255),
                                in  module_name       varchar(255),
                                out allow_permissions tinyint,
                                out deny_permissions  tinyint
                              )
begin
                declare propagated_allow_permissions                            tinyint default 0;
                declare nameditem_allow_permissions, nameditem_deny_permissions tinyint default 0;
                declare is_owner tinyint;
                begin
                    select _securableitem_id in
                        (select securableitem_id
                         from   _user, ownedsecurableitem
                         where  _user.id = ownedsecurableitem.owner__user_id and
                                permitable_id = _permitable_id)
                    into is_owner;
                end;
                if is_owner then
                    set allow_permissions = 31;
                    set deny_permissions  = 0;
                else                                                            # Not Coding Standard
                    set allow_permissions = 0;
                    set deny_permissions  = 0;
                    call get_securableitem_explicit_inherited_permissions_for_permitable(_securableitem_id, _permitable_id, allow_permissions, deny_permissions);
                    call get_securableitem_propagated_allow_permissions_for_permitable  (_securableitem_id, _permitable_id, class_name, module_name, propagated_allow_permissions);
                    call get_securableitem_module_and_model_permissions_for_permitable  (_securableitem_id, _permitable_id, class_name, module_name, nameditem_allow_permissions, nameditem_deny_permissions);
                    set allow_permissions = allow_permissions | propagated_allow_permissions | nameditem_allow_permissions;
                    set deny_permissions  = deny_permissions                                 | nameditem_deny_permissions;
                end if;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `recursive_get_securableitem_propagated_allow_permissions_permit` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `recursive_get_securableitem_propagated_allow_permissions_permit`(
                                in  _securableitem_id int(11),
                                in  _permitable_id    int(11),
                                in  class_name        varchar(255),
                                in  module_name       varchar(255),
                                out allow_permissions tinyint
                              )
begin
                declare user_allow_permissions, user_deny_permissions, user_propagated_allow_permissions tinyint;

                set allow_permissions = 0;

                begin
                    declare sub_role_id int(11);
                    declare no_more_records tinyint default 0;
                    declare sub_role_ids cursor for
                        select role_id
                        from   __role_children_cache
                        where  permitable_id = _permitable_id;
                    declare continue handler for not found
                        begin
                            set no_more_records = 1;
                        end;

                    open sub_role_ids;
                    fetch sub_role_ids into sub_role_id;
                    while no_more_records = 0 do
                        begin
                            declare propagated_allow_permissions tinyint;
                            declare user_in_role_id, permitable_in_role_id int(11);
                            declare permitable_in_role_ids cursor for
                                select permitable_id
                                from   _user
                                where  role_id = sub_role_id;

                            open permitable_in_role_ids;
                            fetch permitable_in_role_ids into permitable_in_role_id;
                            while no_more_records = 0 do
                                call recursive_get_securableitem_actual_permissions_for_permitable  (_securableitem_id, permitable_in_role_id, class_name, module_name, user_allow_permissions, user_deny_permissions);
                                call recursive_get_securableitem_propagated_allow_permissions_permit(_securableitem_id, permitable_in_role_id, class_name, module_name, propagated_allow_permissions);
                                set allow_permissions =
                                        allow_permissions                                 |
                                        (user_allow_permissions & ~user_deny_permissions) |
                                        propagated_allow_permissions;
                                fetch permitable_in_role_ids into permitable_in_role_id;
                            end while;
                        end;
                        set no_more_records = 0;
                        fetch sub_role_ids into sub_role_id;
                    end while;
                    close sub_role_ids;
                end;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `recursive_get_user_actual_right` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `recursive_get_user_actual_right`(
                                in  _user_id    int(11),
                                in  module_name varchar(255),
                                in  right_name  varchar(255),
                                out result      tinyint
                              )
begin
                declare _role_id int;

                set result = 0;
                begin

                    select role_id
                    into   _role_id
                    from   _user
                    where  _user.id = _user_id;
                    if _role_id is not null then
                        call recursive_get_user_role_propagated_actual_allow_right(_role_id, module_name, right_name, result);
                        set result = result & 1;
                    end if;
                end;
                select get_user_explicit_actual_right (_user_id, module_name, right_name) |
                       get_user_inherited_actual_right(_user_id, module_name, right_name) |
                       result
                into result;

                if (result & 2) = 2 then
                    set result = 2;
                end if;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `recursive_get_user_role_propagated_actual_allow_right` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `recursive_get_user_role_propagated_actual_allow_right`(
                                in  _role_id    int(11),
                                in  module_name varchar(255),
                                in  right_name  varchar(255),
                                out result      tinyint
                              )
begin
                declare sub_role_id int(11);
                declare no_more_records tinyint default 0;
                declare sub_role_ids cursor for
                    select id
                    from   role
                    where  role.role_id = _role_id;
                declare continue handler for not found
                    set no_more_records = 1;

                set result = 0;
                open sub_role_ids;
                fetch sub_role_ids into sub_role_id;
                while result = 0 and no_more_records = 0 do
                  begin
                      declare _user_id int(11);
                      declare _user_ids cursor for
                          select id
                          from   _user
                          where  _user.role_id = sub_role_id;

                      open _user_ids;
                      fetch _user_ids into _user_id;
                      while result = 0 and no_more_records = 0 do
                          call recursive_get_user_actual_right(_user_id, module_name, right_name, result);
                          fetch _user_ids into _user_id;
                      end while;
                      close _user_ids;
                      if result = 0 then
                          call recursive_get_user_role_propagated_actual_allow_right(sub_role_id, module_name, right_name, result);
                      end if;
                      set no_more_records = 0;
                      fetch sub_role_ids into sub_role_id;
                  end;
                end while;
                close sub_role_ids;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `recursive_group_contains_group` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `recursive_group_contains_group`(
                                in  group_id_1 int(11),
                                in  group_id_2 int(11),
                                out result     tinyint
                              )
begin
                declare group_2_parent_group_id, child_group_id int(11);
                declare no_more_records tinyint default 0;
                declare child_group_ids cursor for
                    select id
                    from   _group
                    where  _group._group_id = group_id_1;
                declare continue handler for not found
                    set no_more_records = 1;

                set result = 0;
                if group_id_1 = group_id_2 then
                    set result = 1;
                else                                                            # Not Coding Standard
                    select _group_id
                    into   group_2_parent_group_id
                    from   _group
                    where  id = group_id_2;
                    if group_id_1 = group_2_parent_group_id then
                        set result = 1;
                    else                                                        # Not Coding Standard
                        open child_group_ids;
                        fetch child_group_ids into child_group_id;
                        while result = 0 and no_more_records = 0 do
                            call recursive_group_contains_user(child_group_id, group_id_2, result);
                            fetch child_group_ids into child_group_id;
                        end while;
                        close child_group_ids;
                    end if;
                end if;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `recursive_group_contains_user` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `recursive_group_contains_user`(
                                in  _group_id int(11),
                                in  _user_id  int(11),
                                out result    tinyint
                              )
begin
                declare child_group_id, count tinyint;
                declare no_more_records tinyint default 0;
                declare child_group_ids cursor for
                    select id
                    from   _group
                    where  _group._group_id = _group_id;
                declare continue handler for not found
                    set no_more_records = 1;

                set result = 0;
                select count(*)
                into count
                from _group__user
                where _group__user._group_id = _group_id and
                      _group__user._user_id  = _user_id;

                if count > 0 then
                    set result = 1;
                else                                                            # Not Coding Standard
                    open child_group_ids;
                    fetch child_group_ids into child_group_id;
                    while result = 0 and no_more_records = 0 do
                        call recursive_group_contains_user(child_group_id, _user_id, result);
                        fetch child_group_ids into child_group_id;
                    end while;
                    close child_group_ids;
                end if;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `update_email_message_for_sending` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
CREATE PROCEDURE `update_email_message_for_sending`(message_id int, send_attempts int, sent_datetime datetime,
                                                                folder_id int, error_serialized_data text, now_timestamp datetime)
begin
                set @emailMessageSendErrorId    = null;
                delete from `emailmessagesenderror`
                        where id = (select error_emailmessagesenderror_id
                                    from `emailmessage`
                                    where id = message_id);
                if (error_serialized_data is not null) then
                    insert into `emailmessagesenderror` ( id, `createddatetime`,`serializeddata` ) values
                            (null,  now_timestamp , error_serialized_data);
                    set @emailMessageSendErrorId = last_insert_id();
                end if;

                update `emailmessage` set
                        `sendattempts` = send_attempts,
                        `sentdatetime` = sent_datetime,
                        `folder_emailfolder_id` = folder_id,
                        `error_emailmessagesenderror_id` = @emailMessageSendErrorId
                        where id = message_id;
            end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on [[regtime]]
