<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2013 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2013. All rights reserved".
     ********************************************************************************/

    /**
     * Provides a pager used for displaying lists with a simple pagination of previous and next.
     */
    class SimpleListLinkPager extends LinkPager
    {
        /**
         * Set the header to empty
         * @var string
         */
        public $header = '';

        /**
         * Creates the page buttons.
         * @return array a list of page buttons (in HTML code).
         */
        protected function createPageButtons()
        {
            $buttons = array();
            list($beginPage, $endPage) = $this->getPageRange();
            $currentPage = $this->getCurrentPage(false); // currentPage is calculated in getPageRange()
            $buttons[]   = $this->createPageButton('refresh', 0, 'refresh', true, true);
            if (($pageCount = $this->getPageCount()) <= 1)
            {
                return $buttons;
            }
            $buttons[]= $this->createPageButtonNoLinkIfHidden($this->firstPageLabel, 0, $this->firstPageCssClass, $currentPage <= 0, false);
            // prev page
            if (($page = $currentPage-1) < 0)
            {
                $page = 0;
            }
            $buttons[]= $this->createPageButtonNoLinkIfHidden($this->prevPageLabel, $page, $this->previousPageCssClass, $currentPage <= 0, false);

            // next page
            if (($page = $currentPage + 1) >= $pageCount - 1)
            {
                $page = $pageCount - 1;
            }
            $buttons[]= $this->createPageButtonNoLinkIfHidden($this->nextPageLabel, $page, $this->nextPageCssClass, $currentPage >= $pageCount-1, false);

            // last page
            $buttons[] = $this->createPageButtonNoLinkIfHidden($this->lastPageLabel, $pageCount - 1, $this->lastPageCssClass, $currentPage >= $pageCount - 1, false);

            return $buttons;
        }

        /**
         * Creates a page button.
         * You may override this method to customize the page buttons.
         * @param string $label the text label for the button
         * @param integer $page the page number
         * @param string $class the CSS class for the page button. This could be 'page', 'first', 'last', 'next' or 'previous'.
         * @param boolean $hidden whether this page button is visible
         * @param boolean $selected whether this page button is selected
         * @return string the generated button
         */
        protected function createPageButtonNoLinkIfHidden($label, $page, $class, $hidden, $selected)
        {
            if ($hidden || $selected)
            {
                $class .= ' ' . ($hidden ? self::CSS_HIDDEN_PAGE : self::CSS_SELECTED_PAGE);
            }
            if (!$hidden)
            {
                return '<li class="' . $class . '">' . ZurmoHtml::link($label, $this->createPageUrl($page)) . '</li>';
            }
            else
            {
                return '<li class="' . $class . '">' . $label . '</li>';
            }
        }
    }
?>
