<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2017 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2017. All rights reserved".
     ********************************************************************************/

    class StarDataColumn extends DataColumn
    {
        protected function renderHeaderCellContent()
        {
            if ($this->grid->dataProvider instanceof StarredModelDataProvider)
            {
                echo $this->renderStarredFilterHidenField($this->grid->dataProvider->getModelClassName(), 1);
            }
            elseif ($this->grid->dataProvider instanceof RedBeanModelDataProvider)
            {
                echo $this->renderStarredFilterHidenField($this->grid->dataProvider->getModelClassName(), 0);
            }
        }

        protected function renderStarredFilterHidenField($modelClassName, $isFilteredByStarred)
        {
            $class = $isFilteredByStarred ? 'starred' : 'unstarred';
            $url   = Yii::app()->controller->createUrl('');
            if (get_class(Yii::app()->controller) == 'MashableInboxDefaultController')
            {
                $ajaxOptions = array();
            }
            else
            {
                $ajaxOptions = array('success' => "js:function(data){window.location.href = \"{$url}\";}");
            }
            $link  = ZurmoHtml::ajaxLink(
                        'w',
                        '',
                        $ajaxOptions,
                        array('class'       => 'icon-star ' . $class,
                              'id'          => 'starDataColumn_filterByStarred',
                              'onclick'     => $this->getAjaxSubmitScript($modelClassName, $isFilteredByStarred),
                              'namespace'   => 'starDataColumn'));
            return $link;
        }

        private function getAjaxSubmitScript($modelClassName, $isFilteredByStarred)
        {
            $id               = $this->grid->id;
            $url              = Yii::app()->controller->createUrl('', array('modelClassName' => $modelClassName));
            $ajaxSubmitScript = "
                var newVal = (parseInt($('.search-form_filterByStarred').val()) + 1) % 2;
                if (isNaN(newVal))
                {
                    newVal = 1;
                }
                $('.search-form_filterByStarred').val(newVal);
                $('#{$id}').yiiGridView('update', {url: '{$url}', data: $('#search-form').serialize()});
                ";
            return $ajaxSubmitScript;
        }
    }
?>