<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2015 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2015. All rights reserved".
     ********************************************************************************/

    /**
     * Override class is used specifically by the
     * testing framework to handle testing of inbound and outbound email.
     */
    class EmailHelperForTesting extends EmailHelper
    {
        public $sendEmailThroughTransport = false;

        //For testing only
        public function getSentCount()
        {
            return count(EmailMessage::getAllByFolderType(EmailFolder::TYPE_SENT));
        }

        /**
         * For testing only
         * @param string $subject
         * @param string $from
         * @param mixed(string || array) $to
         * @param string $textContent
         * @param string $htmlContent
         * @param mixed(string || array) $cc
         * @param mixed(string || array) $bcc
         * @param array $attachments
         * @param array $settings
         * @param array $headers
         * @param array $parts
         */
        public function sendRawEmail($subject, $from, $to, $textContent = '', $htmlContent = '', $cc = null, $bcc = null, $attachments = null, $settings = null, $headers = array(), $parts = array())
        {
            assert('is_string($subject) && $subject != ""');
            assert('is_string($from)    && $from != ""');
            assert('(is_array($to) && !empty($to)) || is_string($to) || !isset($to)');
            assert('is_string($textContent) || $textContent == null');
            assert('is_string($htmlContent) || $htmlContent == null');
            assert('(is_array($cc) && !empty($cc)) || is_string($cc) || !isset($cc)');
            assert('(is_array($bcc) && !empty($bcc)) || is_string($bcc) || !isset($bcc)');
            assert('isset($to) || isset($cc) || isset($bcc)');
            assert('is_array($attachments) || !isset($attachments)');
            assert('is_array($parts) || !isset($parts)');
            $toName = null;
            $toAddress = null;
            if (is_string($to))
            {
                $toAddress = $to;
            }
            elseif (is_array($to))
            {
                foreach ($to as $key => $value)
                {
                    $toName     = $key;
                    $toAddress  = $value;
                }
            }
            $emailMessage = EmailMessageTestHelper::createOutboxEmail(Yii::app()->user->userModel,
                                                      $subject, $htmlContent, $textContent, null, $from, $toName, $toAddress,
                                                      $cc, $bcc);
            $mailer = new ZurmoSwiftMailer($emailMessage, null);
            if (!empty($parts))
            {
                $mailer->parts = $parts;
            }

            $mailer->From = $from;

            if (is_array($to) && !empty($to))
            {
                foreach ($to as $recipientEmail)
                {
                    $mailer->addAddressByType($recipientEmail, '', EmailMessageRecipient::TYPE_TO);
                }
            }
            elseif (is_string($to))
            {
                $mailer->addAddressByType($to, '', EmailMessageRecipient::TYPE_TO);
            }

            if (is_array($cc) && !empty($cc))
            {
                foreach ($cc as $recipientEmail)
                {
                    $mailer->addAddressByType($recipientEmail, '', EmailMessageRecipient::TYPE_CC);
                }
            }
            elseif (is_string($cc))
            {
                $mailer->addAddressByType($cc, '', EmailMessageRecipient::TYPE_CC);
            }

            if (is_array($bcc) && !empty($bcc))
            {
                foreach ($bcc as $recipientEmail)
                {
                    $mailer->addAddressByType($recipientEmail, '', EmailMessageRecipient::TYPE_BCC);
                }
            }
            elseif (is_string($bcc))
            {
                $mailer->addAddressByType($bcc, '', EmailMessageRecipient::TYPE_BCC);
            }

            if (isset($attachments) && !empty($attachments))
            {
                foreach ($attachments as $file)
                {
                    $mailer->attachFromPath($file);
                }
            }

            $mailer->headers    = $headers;
            $acceptedRecipients = $mailer->send();
            if ($acceptedRecipients > 0)
            {
                // Do nothing
            }
            else
            {
                // To-Do: make exception or something else
                echo "There was error while sending email";
            }
        }

        /**
         * Resolve mailer factory class.
         * @return string
         */
        protected static function resolveMailerFactoryClass()
        {
            return 'ZurmoMailerFactoryForTesting';
        }
    }
?>