<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2017 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2017. All rights reserved".
     ********************************************************************************/

    class CampaignsDefaultController extends EmailTemplatesOrCampaignsBaseController
    {
        const USER_REQUIRED_MODULES_ACCESS_FILTER_PATH =
            'application.modules.campaigns.controllers.filters.UserCanAccessRequiredModulesForCampaignCheckControllerFilter';

        const ZERO_MODELS_CHECK_FILTER_PATH =
            'application.modules.campaigns.controllers.filters.CampaignsZeroModelsCheckControllerFilter';

        const JOBS_CHECK_FILTER_PATH =
            'application.modules.campaigns.controllers.filters.CampaignJobsCheckControllerFilter';

        public static function getListBreadcrumbLinks()
        {
            $title = Zurmo::t('CampaignsModule', 'Campaigns');
            return array($title);
        }

        public static function getDetailsAndEditBreadcrumbLinks()
        {
            return array(Zurmo::t('CampaignsModule', 'Campaigns') => array('default/list'));
        }

        public function filters()
        {
            return array_merge(parent::filters(),
                array(
                    array(
                        static::USER_REQUIRED_MODULES_ACCESS_FILTER_PATH,
                        'controller' => $this,
                    ),
                    array(
                        static::ZERO_MODELS_CHECK_FILTER_PATH . ' + list, index',
                        'controller'                    => $this,
                        'activeActionElementType'       => 'CampaignsMenu',
                        'breadCrumbLinks'               => static::getListBreadcrumbLinks(),
                    ),
                    array(
                        static::JOBS_CHECK_FILTER_PATH . ' + create, details, edit',
                    ),
                )
            );
        }

        public function actionIndex()
        {
            $this->actionList();
        }

        public function actionList()
        {
            $pageSize                       = Yii::app()->pagination->resolveActiveForCurrentUserByType(
                                                                        'listPageSize', get_class($this->getModule()));
            $campaign                       = new Campaign(false);
            $searchForm                     = new CampaignsSearchForm($campaign);
            $listAttributesSelector         = new ListAttributesSelector('CampaignsListView',
                                                                                get_class($this->getModule()));
            $searchForm->setListAttributesSelector($listAttributesSelector);
            $dataProvider = $this->resolveSearchDataProvider(
                $searchForm,
                $pageSize,
                null,
                'CampaignsSearchView'
            );
            if (isset($_GET['ajax']) && $_GET['ajax'] == 'list-view')
            {
                $mixedView = $this->makeListView(
                    $searchForm,
                    $dataProvider
                );
                $view = new CampaignsPageView($mixedView);
            }
            else
            {
                $mixedView = $this->makeActionBarSearchAndListView($searchForm, $dataProvider,
                             'SecuredActionBarForMarketingListsSearchAndListView', null, 'CampaignsMenu');
                $breadCrumbLinks = static::getListBreadcrumbLinks();
                $view      = new CampaignsPageView(MarketingDefaultViewUtil::
                                 makeViewWithBreadcrumbsForCurrentUser($this, $mixedView, $breadCrumbLinks,
                                 'MarketingBreadCrumbView'));
            }
            echo $view->render();
        }

        public function actionCreate()
        {
            $this->actionCreateByModel(new Campaign());
        }

        public function actionCreateFromRelation($relationAttributeName, $relationModelId, $relationModuleId, $redirectUrl)
        {
            $campaign             = $this->resolveNewModelByRelationInformation( new Campaign(),
                                    $relationAttributeName,
                                    (int)$relationModelId,
                                    $relationModuleId);
            $this->actionCreateByModel($campaign, $redirectUrl);
        }

        protected function actionCreateByModel(Campaign $campaign, $redirectUrl = null)
        {
            $breadCrumbLinks            = static::getDetailsAndEditBreadcrumbLinks();
            $breadCrumbLinks[]          = Zurmo::t('Core', 'Create');
            $campaign->status           = Campaign::STATUS_ACTIVE;
            $campaign->supportsRichText = true;
            $campaign->enableTracking   = true;
            $editView                   = new CampaignEditView($this->getId(), $this->getModule()->getId(),
                                          $this->attemptToSaveModelFromPost($campaign, $redirectUrl),
                                          Zurmo::t('CampaignsModule', 'Create Campaign'));
            $view                       = new CampaignsPageView(MarketingDefaultViewUtil::
                                          makeViewWithBreadcrumbsForCurrentUser($this, $editView,
                                          $breadCrumbLinks, 'MarketingBreadCrumbView'));
            echo $view->render();
        }
        
        protected function actionAfterSuccessfulModelSave($model, $modelToStringValue, $redirectUrlParams = null)
        {
            $campaignEmailMessageContent = CampaignEmailMessageContent::getByCampaignId($model->id);
            if ($campaignEmailMessageContent === false)
            {
                $campaignEmailMessageContent = new CampaignEmailMessageContent();
                $campaignEmailMessageContent->campaign = $model;
            }
            $htmlContent = $model->htmlContent;
            $textContent = $model->textContent;
            GlobalMarketingFooterUtil::resolveContentsForGlobalFooter($textContent, $htmlContent);
            $campaignEmailMessageContent->htmlContent = $htmlContent;
            $campaignEmailMessageContent->textContent = $textContent;
            $campaignEmailMessageContent->save();
            
            parent::actionAfterSuccessfulModelSave($model, $modelToStringValue, $redirectUrlParams);
        }

        public function actionDetails($id)
        {
            $campaign = static::getModelAndCatchNotFoundAndDisplayError('Campaign', intval($id));
            ControllerSecurityUtil::resolveAccessCanCurrentUserReadModel($campaign);
            AuditEvent::logAuditEvent('ZurmoModule', ZurmoModule::AUDIT_EVENT_ITEM_VIEWED,
                                      array(strval($campaign), 'CampaignsModule'), $campaign);
            $breadCrumbView             = CampaignsStickySearchUtil::
                                          resolveBreadCrumbViewForDetailsControllerAction($this,
                                          'CampaignsSearchView', $campaign);
            $detailsAndRelationsView    = $this->makeDetailsAndRelationsView($campaign, 'CampaignsModule',
                                                                                'CampaignDetailsAndRelationsView',
                                                                                Yii::app()->request->getRequestUri(),
                                                                                $breadCrumbView);
            $view                       = new CampaignsPageView(MarketingDefaultViewUtil::
                                              makeStandardViewForCurrentUser($this, $detailsAndRelationsView));
            echo $view->render();
        }

        public function actionEdit($id)
        {
            $campaign           = Campaign::getById(intval($id));
            ControllerSecurityUtil::resolveAccessCanCurrentUserWriteModel($campaign);
            $this->processEdit($campaign);
        }

        public function actionCopy($id)
        {
            $copyToCampaign  = new Campaign();
            $postVariableName   = get_class($copyToCampaign);
            if (!isset($_POST[$postVariableName]))
            {
                $campaign = Campaign::getById((int)$id);
                ControllerSecurityUtil::resolveAccessCanCurrentUserReadModel($campaign);
                CampaignCopyModelUtil::copy($campaign, $copyToCampaign);
            }
            $this->processEdit($copyToCampaign);
        }

        protected function processEdit(Campaign $campaign)
        {
            if ($campaign->status != Campaign::STATUS_ACTIVE)
            {
                Yii::app()->user->setFlash('notification',
                    Zurmo::t('CampaignsModule', 'This campaign has already started, you can only edit its name, rights and permissions.')
                );
            }
            $breadCrumbLinks    = static::getDetailsAndEditBreadcrumbLinks();
            $breadCrumbLinks[]  = StringUtil::getChoppedStringContent(strval($campaign), 25);
            //todo: wizard
            $editView = new CampaignEditView($this->getId(), $this->getModule()->getId(),
                                                 $this->attemptToSaveModelFromPost($campaign),
                                                 strval($campaign));
            $view               = new CampaignsPageView(MarketingDefaultViewUtil::
                                  makeViewWithBreadcrumbsForCurrentUser($this, $editView,
                                  $breadCrumbLinks, 'MarketingBreadCrumbView'));
            echo $view->render();
        }

        public function actionDelete($id)
        {
            $campaign = static::getModelAndCatchNotFoundAndDisplayError('Campaign', intval($id));
            ControllerSecurityUtil::resolveAccessCanCurrentUserDeleteModel($campaign);
            $campaign->delete();
            $this->redirect(array($this->getId() . '/index'));
        }

        public function actionModalList()
        {
            $modalListLinkProvider = new SelectFromRelatedEditModalListLinkProvider(
                                            $_GET['modalTransferInformation']['sourceIdFieldId'],
                                            $_GET['modalTransferInformation']['sourceNameFieldId'],
                                            $_GET['modalTransferInformation']['modalId']
            );
            echo ModalSearchListControllerUtil::setAjaxModeAndRenderModalSearchList($this, $modalListLinkProvider);
        }

        public function actionDrillDownDetails($campaignItemId)
        {
            $id = (int) $campaignItemId;
            $campaignItem = CampaignItem::getById($id);
            ControllerSecurityUtil::resolveAccessCanCurrentUserReadModel($campaignItem->campaign);
            ControllerSecurityUtil::resolveAccessCanCurrentUserReadModel($campaignItem->contact);
            ControllerSecurityUtil::resolveAccessCanCurrentUserReadModel($campaignItem->emailMessage);
            echo CampaignItemSummaryListViewColumnAdapter::resolveDrillDownMetricsSummaryContent($campaignItem);
        }

        public function actionTogglePaused($id)
        {
            $campaign               = Campaign::GetById(intval($id));
            ControllerSecurityUtil::resolveAccessCanCurrentUserWriteModel($campaign);
            $campaign->status       = ($campaign->status == Campaign::STATUS_PAUSED)?
                                            Campaign::STATUS_ACTIVE : Campaign::STATUS_PAUSED;
            $saved                  = $campaign->save();
            if (!$saved)
            {
                throw new FailedToSaveModelException("Unable to toggle status");
            }
            echo true;
        }

        protected static function getSearchFormClassName()
        {
            return 'CampaignsSearchForm';
        }

        protected static function getZurmoControllerUtil()
        {
            return new CampaignZurmoControllerUtil();
        }

        protected function getSendTestEmailUtil()
        {
            return 'CampaignSendTestEmailUtil';
        }
    }
?>