<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2012 Zurmo Inc.
     *
     * This program is free software; you can redistribute it and/or modify it under
     * the terms of the GNU General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * This program is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
     * details.
     *
     * You should have received a copy of the GNU General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 113 McHenry Road Suite 207,
     * Buffalo Grove, IL 60089, USA. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in modified source and object code versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the "Powered by
     * Zurmo" logo. If the display of the logo is not reasonably feasible for
     * technical reasons, the Appropriate Legal Notices must display the words
     * "Powered by Zurmo".
     ********************************************************************************/

    require_once 'BaseUpgraderComponent.php';
    class UpgraderComponent extends BaseUpgraderComponent
    {
        /**
         * Tasks that should be executed before updating schema.
         * @param string $currentZurmoVersion
         *
         * @code
        <?php
        $zurmoVersionBeforeUpgrade = UpgradeUtil::getUpgradeState('zurmoVersionBeforeUpgrade');
        if ($this->shouldRunTasksByVersion($zurmoVersionBeforeUpgrade, '0.6.80'))
        {
        $metadata = AccountsModule::getMetadata();
        if(!isset($metadata['global']['newElement']))
        {
        $metadata['global']['newElement'] = 'Some Content';
        AccountsModule::setMetadata($metadata);
        }
        GeneralCache::forgetAll();
        }
        ?>
         * @endcode
         */
        public function processBeforeUpdateSchema()
        {
            $zurmoVersionBeforeUpgrade = UpgradeUtil::getUpgradeState('zurmoVersionBeforeUpgrade');
            if ($this->shouldRunTasksByVersion($zurmoVersionBeforeUpgrade, '0.8.50'))
            {
                if (GlobalMetadata::isClassMetadataSavedInDatabase('AccountsMassEditView'))
                {
                    $search = array('type' => 'ListLink', 'label' => "eval:Yii::t('Default', 'Cancel')");
                    $metadata = AccountsMassEditView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['type'] = 'CancelLink';
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]['label']);
                        AccountsMassEditView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('CalculatedNumberAttributeEditView'))
                {
                    $search = array('type' => 'SaveButton');
                    $metadata = CalculatedNumberAttributeEditView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]);
                        $metadata['global']['toolbar']['elements'] = array_values($metadata['global']['toolbar']['elements']);
                        $metadata['global']['toolbar']['elements'][]['type'] = 'CancelLink';
                        $metadata['global']['toolbar']['elements'][]['type'] = 'SaveButton';
                        CalculatedNumberAttributeEditView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('ContactEditAndDetailsView'))
                {
                    $search = array('type' => 'ListLink', 'label' => "eval:Yii::t('Default', 'Return to List')");
                    $metadata = ContactEditAndDetailsView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]);
                        $metadata['global']['toolbar']['elements'] = array_values($metadata['global']['toolbar']['elements']);
                        ContactEditAndDetailsView::setMetadata($metadata);
                    }

                    $search = array('type' => 'ContactDeleteLink');
                    $metadata = ContactEditAndDetailsView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['renderType'] = 'Details';
                        ContactEditAndDetailsView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('ContactsMassEditView'))
                {
                    $search = array('type' => 'ListLink', 'label' => "eval:Yii::t('Default', 'Cancel')");
                    $metadata = ContactsMassEditView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['type'] = 'CancelLink';
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]['label']);
                        ContactsMassEditView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('DashboardEditView'))
                {
                    $search = array('type' => 'ListLink', 'label' => "eval:Yii::t('Default', 'Cancel')");
                    $metadata = DashboardEditView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['type'] = 'CancelToListLink';
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]['label']);
                        DashboardEditView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('JobLogDetailsView'))
                {
                    $search = array('type' => 'ListLink');
                    $metadata = JobLogDetailsView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['type'] = 'CancelToListLink';
                        JobLogDetailsView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('LeadEditAndDetailsView'))
                {
                    $search = array('type' => 'ListLink', 'label' => "eval:Yii::t('Default', 'Return to List')");
                    $metadata = LeadEditAndDetailsView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]);
                        $metadata['global']['toolbar']['elements'] = array_values($metadata['global']['toolbar']['elements']);
                        LeadEditAndDetailsView::setMetadata($metadata);
                    }

                    $search = array('type' => 'LeadDeleteLink', 'renderType' => "Details");
                    $metadata = LeadEditAndDetailsView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]['renderType']);
                        LeadEditAndDetailsView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('LeadsMassEditView'))
                {
                    $search = array('type' => 'ListLink', 'label' => "eval:Yii::t('Default', 'Cancel')");
                    $metadata = LeadsMassEditView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['type'] = 'CancelLink';
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]['label']);
                        LeadsMassEditView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('MapConfigurationView'))
                {
                    $search = array('type' => 'ConfigurationLink');
                    $metadata = MapConfigurationView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['label'] = "eval:ZurmoHtml::tag('span', array('class' => 'z-label'), Yii::t('Default', 'Cancel'))";
                        MapConfigurationView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('OpportunitiesMassEditView'))
                {
                    $search = array('type' => 'ListLink', 'label' => "eval:Yii::t('Default', 'Cancel')");
                    $metadata = OpportunitiesMassEditView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['type'] = 'CancelLink';
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]['label']);
                        OpportunitiesMassEditView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('OpportunityEditAndDetailsView'))
                {
                    $search = array('type' => 'ListLink', 'label' => "eval:Yii::t('Default', 'Return to List')");
                    $metadata = OpportunityEditAndDetailsView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]);
                        $metadata['global']['toolbar']['elements'] = array_values($metadata['global']['toolbar']['elements']);
                        OpportunityEditAndDetailsView::setMetadata($metadata);
                    }

                    $search = array('type' => 'OpportunityDeleteLink', 'renderType' => "Details");
                    $metadata = OpportunityEditAndDetailsView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]['renderType']);
                        OpportunityEditAndDetailsView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('RoleEditAndDetailsView'))
                {
                    $search = array('type' => 'ListLink');
                    $metadata = RoleEditAndDetailsView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['type'] = 'CancelToListLink';
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]['label']);
                        RoleEditAndDetailsView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('UsersMassEditView'))
                {
                    $search = array('type' => 'ListLink', 'label' => "eval:Yii::t('Default', 'Cancel')");
                    $metadata = UsersMassEditView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['type'] = 'CancelLink';
                        unset($metadata['global']['toolbar']['elements'][$result['elementKey']]['label']);
                        UsersMassEditView::setMetadata($metadata);
                    }
                }
                if (GlobalMetadata::isClassMetadataSavedInDatabase('ZurmoConfigurationEditAndDetailsView'))
                {
                    $search = array('type' => 'ConfigurationLink');
                    $metadata = ZurmoConfigurationEditAndDetailsView::getMetadata();
                    if($result = $this->findPositionOfElementInViewToolbarsAndRowMenu($metadata, 'toolbar', $search))
                    {
                        $metadata['global']['toolbar']['elements'][$result['elementKey']]['label'] = "eval:ZurmoHtml::tag('span', array('class' => 'z-label'), Yii::t('Default', 'Cancel'))";
                        ZurmoConfigurationEditAndDetailsView::setMetadata($metadata);
                    }
                }

                GeneralCache::forgetAll();
            }
        }
    }
?>
