<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2012 Zurmo Inc.
     *
     * This program is free software; you can redistribute it and/or modify it under
     * the terms of the GNU General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * This program is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
     * details.
     *
     * You should have received a copy of the GNU General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 113 McHenry Road Suite 207,
     * Buffalo Grove, IL 60089, USA. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in modified source and object code versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the "Powered by
     * Zurmo" logo. If the display of the logo is not reasonably feasible for
     * technical reasons, the Appropriate Legal Notices must display the words
     * "Powered by Zurmo".
     ********************************************************************************/

    require_once 'BaseUpgraderComponent.php';
    class UpgraderComponent extends BaseUpgraderComponent
    {
        /**
         * Process config files.
         * Problem here is that some config files might be modified, so there
         * can be some additional config options. We need to modify config
         * files(debug.php, debugTest.php, perInstance.php, perInstanceTest.php),
         * without loosing settings entered by user, so in most cases we will add
         * content at the end of those files where possible.
         * Should be used to files like debug.php, debugTest.php, perInstance.php, perInstanceTest.php,
         * which are not tracked by SCM tools, other files are updated automatically.
         *
         * @code
            <?php
                //Below is just sample code to add $myVariable to perInstance.php and perInstanceTest.php files.
                $zurmoVersionBeforeUpgrade = UpgradeUtil::getUpgradeState('zurmoVersionBeforeUpgrade');
                if ($this->shouldRunTasksByVersion($zurmoVersionBeforeUpgrade, '0.6.80'))
                {
                    $perInstanceTestFile = $pathToConfigurationFolder . DIRECTORY_SEPARATOR . 'perInstanceTest.php';
                    if (is_file($perInstanceTestFile))
                    {
                        $perInstanceTestContent = file_get_contents($perInstanceTestFile);

                        $contentToAdd = "\$myVariable = 'aaa';\n";
                        $perInstanceTestContent = preg_replace('/\?\>/',
                                                               "\n" . $contentToAdd . "\n" . "?>",
                                                               $perInstanceTestContent);
                        file_put_contents($perInstanceTestFile, $perInstanceTestContent);
                    }
                    $perInstanceFile = $pathToConfigurationFolder . DIRECTORY_SEPARATOR . 'perInstance.php';
                    if (is_file($perInstanceFile))
                    {
                        $perInstanceContent = file_get_contents($perInstanceFile);

                        $contentToAdd = "\$myVariable = 'aaa';\n";
                        $perInstanceContent = preg_replace('/\?\>/',
                                                           "\n" . $contentToAdd . "\n" . "?>",
                                                           $perInstanceContent);
                        file_put_contents($perInstanceFile, $perInstanceContent);
                    }
                }
            ?>
         * @endcode
         */
        public function processConfigFiles($pathToConfigurationFolder)
        {
            $zurmoVersionBeforeUpgrade = UpgradeUtil::getUpgradeState('zurmoVersionBeforeUpgrade');
            if ($this->shouldRunTasksByVersion($zurmoVersionBeforeUpgrade, '0.8.50'))
            {
                $debugFile = $pathToConfigurationFolder . DIRECTORY_SEPARATOR . 'debug.php';
                if (is_file($debugFile))
                {
                    $debugContent = file_get_contents($debugFile);

                    if (stristr($debugContent, 'SUBMIT_CRASH_TO_SENTRY') === false)
                    {
                        $contentToAdd = "// Should Crash reports be automatically submitted to Sentry\n";
                        $contentToAdd .= "\$submitCrashToSentry = true;\n";
                        $contentToAdd .= "define('SUBMIT_CRASH_TO_SENTRY', \$submitCrashToSentry);\n";

                        $debugContent = preg_replace('/\?\>/',
                                                     "\n" . $contentToAdd . "\n" . "?>",
                                                     $debugContent);
                        file_put_contents($debugFile, $debugContent);
                    }
                }
            }
        }

        /**
         * Tasks to be executed after update schema
         */
        public function processAfterUpdateSchema()
        {
            $this->fixDatabaseDataClassBeanRefactor();
        }

        /**
         * RedBean class is refactored, so ownedcustomfield, multiplevaluescustomfield
         * and mashableactivity tables are removed
         */
        protected function fixDatabaseDataClassBeanRefactor()
        {
            $allModelClassNames   = array();
            foreach (Module::getModuleObjects() as $module)
            {
                $moduleModelNames = $module->getModelClassNames();
                $allModelClassNames = array_merge($allModelClassNames, array_diff($moduleModelNames, $allModelClassNames));
            }

            foreach ($allModelClassNames as $modelClassName)
            {
                // OwnedModel::getMetadata get in some infinite loop, so just skip this method
                if ($modelClassName == "OwnedModel") continue;

                $classToEvaluate     = new ReflectionClass($modelClassName);
                if (is_subclass_of($modelClassName, 'RedBeanModel') &&
                    !$classToEvaluate->isAbstract())
                {
                    $model = new $modelClassName;
                    $modelAttributes = $model->getAttributes();
                    foreach ($modelAttributes as $attributeName => $notUsed)
                    {
                        if ($model->isRelation($attributeName) &&
                            $model->getRelationModelClassName($attributeName) == 'OwnedCustomField')
                        {
                            $tableName = RedBeanModel::getTableName($modelClassName);
                            $joinModelClassName = $model->getRelationModelClassName($attributeName);
                            $joinTableName = RedBeanModel::getTableName($joinModelClassName);

                            $columnName = $model->getColumnNameByAttribute($attributeName);
                            $originalColumnName = str_replace('customfield', 'ownedcustomfield', $columnName);
                            $res = R::getAll("SHOW COLUMNS FROM $tableName LIKE '{$originalColumnName}'");
                            if (count($res))
                            {
                               R::exec("UPDATE  {$tableName} LEFT JOIN  $joinTableName
                               ON {$joinTableName}.id = {$tableName}.{$originalColumnName}
                               SET {$tableName}.{$columnName} = {$joinTableName}.customfield_id ");
                            }
                        }
                        elseif ($model->isRelation($attributeName) &&
                                $model->getRelationModelClassName($attributeName) == 'OwnedMultipleValuesCustomField')
                        {
                            $tableName = RedBeanModel::getTableName($modelClassName);
                            $joinModelClassName = $model->getRelationModelClassName($attributeName);
                            $joinTableName = RedBeanModel::getTableName($joinModelClassName);

                            $columnName = $model->getColumnNameByAttribute($attributeName);
                            $originalColumnName = str_replace('multiplevaluescustomfield', 'ownedmultiplevaluescustomfield', $columnName);
                            $res = R::getAll("SHOW COLUMNS FROM $tableName LIKE '{$originalColumnName}'");
                            if (count($res))
                            {
                               R::exec("UPDATE  {$tableName} LEFT JOIN  $joinTableName
                               ON {$joinTableName}.id = {$tableName}.{$originalColumnName}
                               SET {$tableName}.{$columnName} = {$joinTableName}.multiplevaluescustomfield_id ");
                            }
                        }
                    }

                    // MashableActivity
                    if (is_subclass_of($modelClassName, 'MashableActivity'))
                    {
                        $model = new $modelClassName;
                        $tableName = RedBeanModel::getTableName($modelClassName);
                        $joinTableName = RedBeanModel::getTableName('MashableActivity');

                        $columnName = 'activity_id';
                        $originalColumnName = 'mashableactivity_id';
                        $res = R::getAll("SHOW COLUMNS FROM $tableName LIKE '{$originalColumnName}'");
                        if (count($res))
                        {
                            R::exec("UPDATE  {$tableName} LEFT JOIN  $joinTableName
                               ON {$joinTableName}.id = {$tableName}.{$originalColumnName}
                               SET {$tableName}.{$columnName} = {$joinTableName}.activity_id ");
                        }
                    }
                }
            }
        }
    }
?>
