<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2015 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2015. All rights reserved".
     ********************************************************************************/
    class EmailMessageUrlTest extends ZurmoBaseTest
    {
        public static function setUpBeforeClass()
        {
            parent::setUpBeforeClass();
            SecurityTestHelper::createSuperAdmin();
            SecurityTestHelper::createUsers();
        }

        public function setUp()
        {
            parent::setUp();
            Yii::app()->user->userModel = User::getByUsername('super');
        }

        public function testGetModuleClassName()
        {
            $this->assertEquals('EmailMessagesModule', EmailMessageUrl::getModuleClassName());
        }

        public function testCreateAndGetEmailMessageUrlById()
        {
            $emailMessageUrl                          = new EmailMessageUrl();
            $emailMessageUrl->url                     = 'http://www.zurmo.com';
            $this->assertTrue($emailMessageUrl->unrestrictedSave());
            $id = $emailMessageUrl->id;
            unset($emailMessageUrl);
            $emailMessageUrl = EmailMessageUrl::getById($id);
            $this->assertEquals('http://www.zurmo.com'        ,   $emailMessageUrl->url);
        }

        /**
         * @depends testCreateAndGetEmailMessageUrlById
         */
        public function testRequiredAttributes()
        {
            $emailMessageUrl                          = new EmailMessageUrl();
            $this->assertFalse($emailMessageUrl->unrestrictedSave());
            $errors = $emailMessageUrl->getErrors();
            $this->assertNotEmpty($errors);
            $this->assertCount(1, $errors);
            $this->assertArrayHasKey('url', $errors);
            $this->assertEquals('Url cannot be blank.', $errors['url'][0]);

            $emailMessageUrl->url                     = 'http://www.zurmo.org';
            $this->assertTrue($emailMessageUrl->unrestrictedSave());
            $id = $emailMessageUrl->id;
            unset($emailMessageUrl);
            $emailMessageUrl = EmailMessageUrl::getById($id);
            $this->assertEquals('http://www.zurmo.org'        ,   $emailMessageUrl->url);
        }

        /**
         * @depends testCreateAndGetEmailMessageUrlById
         */
        public function testGetByUrl()
        {
            $emailMessageUrls = EmailMessageUrl::getByUrl('http://www.zurmo.org');
            $this->assertCount(1, $emailMessageUrls);
            $emailMessageUrls = EmailMessageUrl::getByUrl('http://www.zurmo.com');
            $this->assertCount(1, $emailMessageUrls);
        }

        /**
         * @depends testCreateAndGetEmailMessageUrlById
         */
        public function testGetLabel()
        {
            $emailMessageUrl  = RandomDataUtil::getRandomValueFromArray(EmailMessageUrl::getAll());
            $this->assertNotNull($emailMessageUrl);
            $this->assertEquals('Email Message Url',  $emailMessageUrl::getModelLabelByTypeAndLanguage('Singular'));
            $this->assertEquals('Email Message Urls', $emailMessageUrl::getModelLabelByTypeAndLanguage('Plural'));
        }

        /**
         * @depends testCreateAndGetEmailMessageUrlById
         */
        public function testDeleteEmailMessageUrl()
        {
            $emailMessageUrls = EmailMessageUrl::getAll();
            $this->assertCount(2, $emailMessageUrls);
            $emailMessageUrls[0]->delete();
            $emailMessageUrls = EmailMessageUrl::getAll();
            $this->assertEquals(1, count($emailMessageUrls));
        }

        /**
         * @depends testCreateAndGetEmailMessageUrlById
         */
        public function testEmailMessageUrlStringValue()
        {
            $emailMessageUrls = EmailMessageUrl::getAll();
            $this->assertCount(1, $emailMessageUrls);
            $this->assertEquals($emailMessageUrls[0]->url, strval($emailMessageUrls[0]));
        }
    }
?>