<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2015 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2014. All rights reserved".
     ********************************************************************************/

    require_once 'BaseUpgraderComponent.php';
    class UpgraderComponent extends BaseUpgraderComponent
    {
        protected $unsubscribeMethod            = null;

        protected $manageSubscriptionsMethod    = null;

        public function processBeforeUpdateSchema()
        {
            parent::processBeforeUpdateSchema();
            if ($this->shouldRunTasksByVersion('3.0.0'))
            {
                // Update order of items in userHeaderMenuItems
                $this->updateModulesMetadataForUserHeaderMenuItemsOrder();
                // Update MashableInboxModule Metadata
                $this->updateMashableInboxModuleMetadata();
                // Update ProjectsModule metadata
                $this->updateProjectsModuleMetadata();
                $this->updateZurmoModuleMetadata();
            }
            if ($this->shouldRunTasksByVersion('3.0.3'))
            {
                // Update AuditEvents data
                $this->updateAuditEventsTableData();
                $this->updateLeadsModuleMetadata();
                $this->updateTasksMyListViewMetadata();
            }
            if ($this->shouldRunTasksByVersion('3.1.0'))
            {
                // Update reports with new User filter
                $this->updateModelDetailsPortletsToIncludeCommentsFeedPortlet();
                $this->updateModelMetadataAndUpdateDataForComments();
                $this->addOwnerInfoToDetailsViewMetadata();
            }
            if (Yii::app()->edition == 'Commercial')
            {
                if ($this->shouldRunTasksByVersion('3.1.0'))
                {
                    $this->updateQueuesMetadata();
                }
            }
        }

        public function processAfterUpdateSchema()
        {
            parent::processAfterUpdateSchema();
            if ($this->shouldRunTasksByVersion('3.0.0'))
            {
                // Update Mailer Type and Settings for Existing Email Messages
                $this->updateMailerTypeAndSettingsForEmailMessage();
                $this->updateCampaignItemsToEmailMessageIdToNull();
            }
            if ($this->shouldRunTasksByVersion('3.0.5'))
            {
                // Update reports with new User filter
                $this->updateReportFiltersWithUserModels();
            }
            if ($this->shouldRunTasksByVersion('3.1.0'))
            {
                $this->updateModelsDataForComments();
            }
            if (Yii::app()->edition == 'Commercial')
            {
                if ($this->shouldRunTasksByVersion('3.0.5'))
                {
                    $this->removeWebApiClientEmailFromGoogleGlobalConfig();
                }
                if ($this->shouldRunTasksByVersion('3.1.0'))
                {
                    $this->updateQueuesData();
                }
            }
        }

        protected function updateModulesMetadataForUserHeaderMenuItemsOrder()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('EmailMessagesModule'))
            {
                $metadata = EmailMessagesModule::getMetadata();
                $metadata['global']['userHeaderMenuItems'] = array(
                    array(
                        'label' => "eval:Zurmo::t('EmailMessagesModule', 'Data Cleanup')",
                        'url' => array('/emailMessages/default/matchingList'),
                        'right' => EmailMessagesModule::RIGHT_ACCESS_EMAIL_MESSAGES,
                        'order' => 30,
                    ),
                );
                EmailMessagesModule::setMetadata($metadata);
            }
            if (GlobalMetadata::isClassMetadataSavedInDatabase('GamificationModule'))
            {
                $metadata = GamificationModule::getMetadata();
                $metadata['global']['userHeaderMenuItems'] = array(
                    array(
                        'label' => "eval:Zurmo::t('GamificationModule', 'Leaderboard')",
                        'url' => array('/gamification/default/leaderboard'),
                        'order' => 20,
                    ),
                );
                GamificationModule::setMetadata($metadata);
            }
            if (GlobalMetadata::isClassMetadataSavedInDatabase('UsersModule'))
            {
                $metadata = UsersModule::getMetadata();
                $metadata['global']['userHeaderMenuItems'] = array(
                    array(
                        'label' => "eval:Zurmo::t('UsersModule', 'My Profile')",
                        'url' => array('/users/default/profile'),
                        'order' => 10,
                    ),
                    array(
                        'label' => "eval:Zurmo::t('UsersModule', 'Sign out')",
                        'url' => array('/zurmo/default/logout'),
                        'order' => 40,
                    ),
                );
                UsersModule::setMetadata($metadata);
            }
        }

        protected function updateMashableInboxModuleMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('MashableInboxModule'))
            {
                $metadata = MashableInboxModule::getMetadata();
                $metadata['global']['tabMenuItems'] = array(
                    array(
                        'label'               => "eval:Zurmo::t('EmailMessagesModule', 'Inbox')",
                        'url'                 => array('/mashableInbox/default'),
                        'dynamicLabelContent' => 'eval:MashableUtil::renderUnreadCountForDynamicLabelContent()',
                        'mobile'              => true,
                    ),
                );
                MashableInboxModule::setMetadata($metadata);
            }
        }

        protected function updateProjectsModuleMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('ProjectsModule'))
            {
                $metadata = ProjectsModule::getMetadata();
                $metadata['global']['shortcutsCreateMenuItems'] = array(
                    array(
                        'label'  => "eval:Zurmo::t('ProjectsModule', 'ProjectsModuleSingularLabel', \$translationParams)",
                        'url'    => array('/projects/default/create'),
                        'right'  => ProjectsModule::RIGHT_CREATE_PROJECTS,
                        'mobile' => true,
                    ),
                );
                ProjectsModule::setMetadata($metadata);
            }
        }

        protected function updateZurmoModuleMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('ZurmoModule'))
            {
                $metadata = ZurmoModule::getMetadata();
                $metadata['global']['headerMenuItems'] = array(
                     array(
                        'label'  => "eval:Zurmo::t('ZurmoModule', 'Administration')",
                        'url'    => array('/configuration'),
                        'right'  => ZurmoModule::RIGHT_ACCESS_ADMINISTRATION,
                        'order'  => 1,
                        'mobile' => false,
                    ),
                    array(
                        'label'  => "eval:Zurmo::t('ZurmoModule', 'About Gravity4')",
                        'url'    => 'http://www.gravity4.com',
                        'order'  => 10,
                        'mobile' => true,
                    ),
                );
                ZurmoModule::setMetadata($metadata);
            }
        }

        protected function updateMailerTypeAndSettingsForEmailMessage()
        {
            $folders           = self::getEmailFoldersByType(EmailFolder::TYPE_SENT);
            foreach ($folders as $folder)
            {
                $sql = "SELECT e.id, e.mailerType, o.owner__user_id as owner_id, ea.id as account_id FROM `emailmessage` e  left join ownedsecurableitem o on o.id = e.`ownedsecurableitem_id`";
                $sql .= "LEFT JOIN emailaccount ea on ea._user_id = o.owner__user_id";
                $sql .= " WHERE e.folder_emailfolder_id=" . $folder->id .  " AND (e.mailertype IS NULL OR e.mailertype='')";
                $records   = ZurmoRedBean::getAll($sql);

                foreach ($records as $record)
                {
                    if ($record['account_id'] != null)
                    {
                        $mailerSettings = 'personal';
                    }
                    else
                    {
                        $mailerSettings = 'global';
                    }
                    $sql = "UPDATE emailmessage set mailertype='smtp', mailersettings='$mailerSettings' where id=" . $record['id'];
                    ZurmoRedBean::exec($sql);
                }
            }
        }

        protected function updateCampaignItemsToEmailMessageIdToNull()
        {
            $query = "UPDATE campaignitem SET emailmessage_id=NULL WHERE emailmessage_id=0";
            ZurmoRedBean::exec($query);
        }

        /**
         * Get by type.
         * @param string $type
         * @return array of models
         * @throws NotFoundException
         * @throws NotSupportedException
         */
        protected static function getEmailFoldersByType($type)
        {
            assert('is_string($type)');
            $searchAttributeData = array();
            $searchAttributeData['clauses'] = array(
                1 => array(
                    'attributeName'        => 'type',
                    'operatorType'         => 'equals',
                    'value'                => $type,
                )
            );
            $searchAttributeData['structure'] = '1';
            $joinTablesAdapter = new RedBeanModelJoinTablesQueryAdapter('EmailFolder');
            $where = RedBeanModelDataProvider::makeWhere('EmailFolder', $searchAttributeData, $joinTablesAdapter);
            return EmailFolder::getSubset($joinTablesAdapter, null, null, $where, null);
        }

        protected function getModelClassNamesToPurgeGlobalMetadata()
        {
            // format: version => model class names to purge globalmetadata for.
            $models = array(
                '3.0.0' => array(
                    'Campaign',
                    'CampaignEditView',
                    'CampaignsListView',
                    'EmailTemplateDetailsView',
                    'MarketingListMembersMassSubscribeView',
                    'SendTestEmailModalEditView',
                    'UserConfigurationEditView',
                    'UserEmailConfigurationEditView',
                ),
                '3.0.3' => array(
                    'AccountConvertToView',
                    'LeadsModuleEditView'
                ),
                '3.0.5' => array(
                    'ContactsForAccountRelatedListView',
                    'ContactsForOpportunityRelatedListView',
                    'OpenTasksForAccountRelatedListView',
                    'OpenTasksForContactRelatedListView',
                    'OpenTasksForOpportunityRelatedListView',
                    'OpportunitiesForAccountRelatedListView',
                    'OpportunitiesForContactRelatedListView',
                    'AccountConvertToView',
                    'LeadsModuleEditView',
                    'CampaignEditView',
                    'Email' // Just for some backward compability, Email model can't save metadata
                ),
                '3.1.0' => array(
                    'NotificationSubscriber', // Just for any case, NotificationSubscriber model can't save metadata
                    'CommentForSocialItemInlineEditView',
                    'CommentInlineEditView',
                    'SocialItemInlineEditView',
                    'MarketingListMember',
                    'ProductsMassEditView'
                ),
            );

            if (Yii::app()->edition == 'Commercial')
            {
                $models['3.0.1'][] = 'ZurmoSystemConfigurationEditAndDetailsView';
                $models['3.1.0'][] = 'QueueModel';
                $models['3.1.0'][] = 'ContactAcceptanceState';
                $models['3.1.0'][] = 'QueueModelEditAndDetailsView';
            }
            // re-purging metadata for 3.0.0 files just to be sure.
            // We should never need to do this but in this case lets just do it to avoid surprises.
            return $models;
        }

        protected function updateAuditEventsTableData()
        {
            // Remove data for nonaudit tables that is already recorded
            $auditEventTableName = AuditEvent::getTableName();
            $nonAuditableModels = array(
                'EmailBox',
                'EmailFolder',
                'EmailMessage',
                'EmailMessageActivity',
                'EmailMessageContent',
                'EmailMessageRecipient',
                'EmailMessageSendError',
                'EmailMessageSender',
                'EmailMessageUrl',
                'EmailSignature',
                'GameBadge',
                'GameCoin',
                'GameCollection',
                'GameLevel',
                'GameNotification',
                'GamePoint',
                'GamePointTransaction',
                'GameScore',
                'FileModel');
            $quotedNonAuditableStringModeIds = "'" . implode("','", $nonAuditableModels) . "'";
            $sql = "DELETE FROM $auditEventTableName where modelclassname in ($quotedNonAuditableStringModeIds)";
            ZurmoRedBean::exec($sql);

            // Remote ITEM_VIEWED audit events
            $deleteEventDataByNames = array(
                ZurmoModule::AUDIT_EVENT_ITEM_CREATED,
                ZurmoModule::AUDIT_EVENT_ITEM_VIEWED,
                UsersModule::AUDIT_EVENT_USER_LOGGED_IN,
                UsersModule::AUDIT_EVENT_USER_LOGGED_OUT
            );
            $quotedNonAuditableEvents = "'" . implode("','", $deleteEventDataByNames) . "'";
            $sql = "DELETE FROM $auditEventTableName where eventname in ($quotedNonAuditableEvents)";
            ZurmoRedBean::exec($sql);
        }

        protected function updateLeadsModuleMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('LeadsModule'))
            {
                $metadata = LeadsModule::getMetadata();
                $metadata['global']['convertToOpportunitySetting'] = LeadsModule::CONVERT_OPPORTUNITY_NOT_REQUIRED;
                LeadsModule::setMetadata($metadata);
            }
        }

        protected function updateTasksMyListViewMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('TasksMyListView'))
            {
                $metadata = TasksMyListView::getMetadata();
                if (!in_array('TaskActivityItems', $metadata['global']['derivedAttributeTypes']))
                {
                    $metadata['global']['derivedAttributeTypes'][] = 'TaskActivityItems';
                }

                $search = array('attributeName' => 'activityItems', 'type' => 'TaskActivityItems', 'isLink' => true);
                $result = $this->findPositionOfElementInViewPanels($metadata, $search);
                if (!$result)
                {
                    // Add to the end of first panel
                    $metadata['global']['panels'][0]['rows'][] =
                        array('cells' =>
                                  array(
                                      array(
                                          'elements' => array(
                                              array('attributeName' => 'null', 'type' => 'TaskActivityItems', 'isLink' => true),
                                          ),
                                      ),
                                  ),
                        );
                }
                $search = array('attributeName' => 'project', 'type' => 'ProjectForTask', 'isLink' => true);
                $result = $this->findPositionOfElementInViewPanels($metadata, $search);
                if (!$result)
                {
                    // Add to the end of first panel
                    $metadata['global']['panels'][0]['rows'][] =
                        array('cells' =>
                                  array(
                                      array(
                                          'elements' => array(
                                              array('attributeName' => 'project', 'type' => 'ProjectForTask', 'isLink' => true),
                                          ),
                                      ),
                                  ),
                        );
                }
                TasksMyListView::setMetadata($metadata);
            }
        }

        protected function updateReportFiltersWithUserModels()
        {
            $savedReports = SavedReport::getAll();
            foreach ($savedReports as $savedReport)
            {
                $shouldSaveReport = false;
                $report = SavedReportToReportAdapter::makeReportBySavedReport($savedReport);
                if ($report->getType() == Report::TYPE_ROWS_AND_COLUMNS)
                {
                    $filters = $report->getFilters();
                    foreach ($filters as $filter)
                    {
                        if (in_array($filter->getAttributeIndexOrDerivedType(), array('owner__User', 'createdByUser__User', 'modifiedByUser__User')))
                        {
                            $filter->valueType = MixedLoggedInUserTypesAndUsersSearchFormAttributeMappingRules::TYPE_SELECT_USER;
                            $shouldSaveReport = true;
                        }
                    }
                }
                if ($shouldSaveReport)
                {
                    SavedReportToReportAdapter::resolveReportToSavedReport($report, $savedReport);
                    $savedReport->save();
                }
            }
        }

        protected function removeWebApiClientEmailFromGoogleGlobalConfig()
        {
            $googleAppsSettings = ZurmoGoogleAppsHelper::getGoogleAppsSettings();
            if (isset($googleAppsSettings) && is_array($googleAppsSettings))
            {
                unset($googleAppsSettings['webappApiClientEmail']);
                ZurmoGoogleAppsHelper::setGoogleAppsSettings($googleAppsSettings);
            }
        }

        protected function updateModelMetadataAndUpdateDataForComments()
        {
            // Update model metadata for Task, NotificationSubscriber, Opportunity, Account, Contact
            $metadataChanges = array(
                'relations' => array(
                    'notificationSubscribers'   => array(RedBeanModel::HAS_MANY, 'NotificationSubscriber', RedBeanModel::OWNED,
                        RedBeanModel::LINK_TYPE_POLYMORPHIC, 'relatedModel'),
                    'comments'         => array(RedBeanModel::HAS_MANY, 'Comment', RedBeanModel::OWNED,
                        RedBeanModel::LINK_TYPE_POLYMORPHIC, 'relatedModel')
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Account', $metadataChanges);
            $this->updateModelMetadataWithNewMetaDefinition('Contact', $metadataChanges);
            $this->updateModelMetadataWithNewMetaDefinition('Opportunity', $metadataChanges);

            $metadataChanges = array(
                'relations' => array(
                    'notificationSubscribers'   => array(RedBeanModel::HAS_MANY, 'NotificationSubscriber', RedBeanModel::OWNED,
                        RedBeanModel::LINK_TYPE_POLYMORPHIC, 'relatedModel')
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Task', $metadataChanges);
        }

        protected function updateModelsDataForComments()
        {
            // 2. Update data in notification subscriber table, so we need to convert task_id to relatedmodel_id(it is actually id of task item) and relatedmodel_type(this need to be set to 'task'). This need to be done afterSchema update action.
            $sql = "UPDATE notificationsubscriber set relatedmodel_id=task_id, relatedmodel_type='task'";
            ZurmoRedBean::exec($sql);
            // 2.a ToDO: remove task_id once everything is done

            // 3. Add Account/Contact/Task owners as default subscribers(this need to be done after Schema updated) for existing models
            $this->subscribeModelsForNotifications('Account', Account::getTableName());
            $this->subscribeModelsForNotifications('Contact', Contact::getTableName());
            $this->subscribeModelsForNotifications('Opportunity', Opportunity::getTableName());
        }

        protected function updateModelDetailsPortletsToIncludeCommentsFeedPortlet()
        {
            $users = User::getAll(); // ToDo: get only real users not backendjob or queue one
            foreach ($users as $user)
            {
                // System Users can't save portlets, either access UI
                if ($user->isSystemUser)
                {
                    continue;
                }
                $affectedItems = array('Account', 'Contact', 'Lead', 'Opportunity');
                foreach ($affectedItems as $affectedItem)
                {
                    $uniqueLayoutId = $affectedItem . 'DetailsAndRelationsView';
                    $portletType = 'CommentsFor' . $affectedItem . 'RelatedModelPortlet';

                    if (GlobalMetadata::isClassMetadataSavedInDatabase($uniqueLayoutId))
                    {
                        $metadata = $uniqueLayoutId::getMetadata();
                        if (!$this->checkIfViewExistInRelatedViewMetadata($metadata, $portletType))
                        {
                            $metadata['global']['columns'][1]['rows'][] = array('type' => $portletType);
                            $uniqueLayoutId::setMetadata($metadata);
                        }
                    }

                    $placedViewTypes = Portlet::getPlacedViewTypesByLayoutIdAndUser($uniqueLayoutId, $user->id);
                    if (!empty($placedViewTypes) &&
                        !in_array($portletType, $placedViewTypes))
                    {
                        $maximumColumns = $this->resolveMaximumColumnsByLayoutId();
                        $position = $this->getMaximumPositionInLayoutColumn($uniqueLayoutId, $maximumColumns, $user->id);
                        $this->makePortletUsingViewType($portletType, $uniqueLayoutId, $user, intval($maximumColumns), $position + 1);
                    }
                }
            }
        }

        protected function makePortletUsingViewType($viewType, $uniqueLayoutId, $user, $numberOfColumns, $position)
        {
            $portlet = new Portlet();
            $portlet->column    = $numberOfColumns;
            $portlet->position  = $position;
            $portlet->layoutId  = $uniqueLayoutId;
            $portlet->collapsed = false;
            $portlet->viewType  = $viewType;
            $portlet->user      = $user;
            $portlet->save();
        }

        protected function addOwnerInfoToDetailsViewMetadata()
        {
            $affectedViewsToRemoveOwnerFromNonPlaceableAttributeNames = array(
                'AccountEditAndDetailsView', // ToDo: Check if during upgrade is removed 'owner'
                'AccountModalCreateView',
                'AccountsMergedEditAndDetailsView',
                'ContactEditAndDetailsView',
                'ContactsMergedEditAndDetailsView',
                'LeadEditAndDetailsView',
                'LeadsMergedEditAndDetailsView',
                'MeetingEditAndDetailsView',
                'NoteEditAndDetailsView',
                'OpportunityEditAndDetailsView',
                'ProductEditAndDetailsView',
                'ProjectEditAndDetailsView',
            );
            foreach ($affectedViewsToRemoveOwnerFromNonPlaceableAttributeNames as $viewClassName)
            {
                if (GlobalMetadata::isClassMetadataSavedInDatabase($viewClassName))
                {
                    $metadata = $viewClassName::getMetadata();
                    if (isset($metadata['global']['nonPlaceableAttributeNames']))
                    {
                        if(($key = array_search('owner', $metadata['global']['nonPlaceableAttributeNames'])) !== false) {
                            unset($metadata['global']['nonPlaceableAttributeNames'][$key]);
                        }
                    }
                    $viewClassName::setMetadata($metadata);
                }
            }

            $affectedViewsToAddOwnerFromNonPlaceableAttributeNames = array(
                'AccountsMergedEditAndDetailsView', // ToDo: Check if during upgrade is added 'owner
                'ContactsMergedEditAndDetailsView',
                'LeadsMergedEditAndDetailsView',
                'NoteInlineEditView' // ToDo: Check if during upgrade is added 'owner to existing nonPlaceableAttributeNames
            );
            foreach ($affectedViewsToAddOwnerFromNonPlaceableAttributeNames as $viewClassName)
            {
                if (GlobalMetadata::isClassMetadataSavedInDatabase($viewClassName))
                {
                    $metadata = $viewClassName::getMetadata();
                    if (!isset($metadata['global']['nonPlaceableAttributeNames']))
                    {
                        $metadata['global']['nonPlaceableAttributeNames'] = array();
                    }
                    if (!in_array('owner', $metadata['global']['nonPlaceableAttributeNames']))
                    {
                        $metadata['global']['nonPlaceableAttributeNames'][] = 'owner';
                    }
                    $viewClassName::setMetadata($metadata);
                }
            }
        }

        protected function updateQueuesMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('QueuesModule'))
            {
                $metadata = QueuesModule::getMetadata();
                $metadata['global']['enabledDistributionRulesTypes'] = array(
                    QueueModel::RULE_TYPE_NONE,
                    QueueModel::RULE_TYPE_ROUND_ROBIN,
                    QueueModel::RULE_TYPE_MANUAL_WITH_ACCEPTANCE,
                    QueueModel::RULE_TYPE_MANUAL_ROUND_ROBIN_WITH_ACCEPTANCE);
                QueuesModule::setMetadata($metadata);
            }
        }

        protected function updateQueuesData()
        {
            $sql = "update queuemodel set distributionruledurationinterval=1, distributionruledurationtype='Minute'";
            ZurmoRedBean::exec($sql);
        }

        protected function resolveMaximumColumnsByLayoutId()
        {
            $layoutTypes    = ConfigurableDetailsAndRelationsView::getLayoutTypesData();
            $layoutType     = $layoutTypes[ConfigurableDetailsAndRelationsView::getDefaultLayoutType()];
            $maximumColumns = substr($layoutType, 0, 1);
            return $maximumColumns;
        }

        protected function getMaximumPositionInLayoutColumn($uniqueLayoutId, $maximumColumns, $userId)
        {
            $portletCollection = Portlet::getByLayoutIdAndUserSortedByColumnIdAndPosition($uniqueLayoutId, $userId, array());
            $maximumIndexFromCollection = max(array_keys($portletCollection));
            $maximumIterativeIndex = min($maximumIndexFromCollection, $maximumColumns);
            $maxPosition = 1;
            if (!empty($portletCollection))
            {
                if ($maximumIterativeIndex > 1)
                {
                    foreach ($portletCollection[$maximumIterativeIndex] as $position => $portlet)
                    {
                        if ($portlet->position > $maxPosition)
                        {
                            $maxPosition = $portlet->position;
                        }
                    }
                }
            }
            return $maxPosition;
        }

        /**
         * @param $relatedViewMetadata
         * @param $viewClassName
         * @return bool
         */
        protected function checkIfViewExistInRelatedViewMetadata($relatedViewMetadata, $viewClassName)
        {
            $exists = false;
            foreach ($relatedViewMetadata['global']['columns'][1]['rows'] as $row)
            {
                if ($row['type'] == $viewClassName)
                {
                    $exists = true;
                    break;
                }
            }
            return $exists;
        }

        protected function subscribeModelsForNotifications($modelClassName, $tableName)
        {
            $offset = 0;
            $pageSize = 1000;
            do
            {
                $sql = $this->getSqlForSubscribeModelsForNotifications($modelClassName, $tableName);
                $sql .= " LIMIT $pageSize OFFSET $offset";
                $records = ZurmoRedBean::getAll($sql);

                foreach ($records as $record)
                {
                    $modelId = $record['id'];
                    $personItemId = $record['person_item_id'];
                    $query = "select * from notificationsubscriber where
                            person_item_id = $personItemId and relatedmodel_id = $modelId AND
                            relatedmodel_type = '$modelClassName'";

                    $res = ZurmoRedBean::getAll($query);
                    if (empty($res))
                    {
                        $sql = "INSERT INTO notificationsubscriber
                            (hasreadlatest, person_item_id, relatedmodel_id, relatedmodel_type)
                            VALUES (0, $personItemId, $modelId, '$modelClassName')";
                        ZurmoRedBean::exec($sql);
                    }
                }
                $offset = $offset + $pageSize;
            } while (!empty($records));
        }

        protected function getSqlForSubscribeModelsForNotifications($modelClassName, $tableName)
        {
            if ($modelClassName != 'Contact')
            {
                $sql = "SELECT m.id as id, p.item_id as person_item_id FROM `$tableName` m
                        left join ownedsecurableitem o on o.id = m.`ownedsecurableitem_id`
                        left join _user u on u.id = o.owner__user_id
                        left join permitable p on p.id = u.permitable_id";
            }
            else
            {
                $sql = "SELECT m.id as id, p.item_id as person_item_id FROM `$tableName` m
                        left join person ps on ps.id = m.person_id
                        left join ownedsecurableitem o on o.id = ps.`ownedsecurableitem_id`
                        left join _user u on u.id = o.owner__user_id
                        left join permitable p on p.id = u.permitable_id";
            }
            return $sql;
        }
    }
?>