<?php
    /*********************************************************************************
     * Zurmo is a customer relationship management program developed by
     * Zurmo, Inc. Copyright (C) 2015 Zurmo Inc.
     *
     * Zurmo is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Affero General Public License version 3 as published by the
     * Free Software Foundation with the addition of the following permission added
     * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
     * IN WHICH THE COPYRIGHT IS OWNED BY ZURMO, ZURMO DISCLAIMS THE WARRANTY
     * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
     *
     * Zurmo is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
     * details.
     *
     * You should have received a copy of the GNU Affero General Public License along with
     * this program; if not, see http://www.gnu.org/licenses or write to the Free
     * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
     * 02110-1301 USA.
     *
     * You can contact Zurmo, Inc. with a mailing address at 27 North Wacker Drive
     * Suite 370 Chicago, IL 60606. or at email address contact@zurmo.com.
     *
     * The interactive user interfaces in original and modified versions
     * of this program must display Appropriate Legal Notices, as required under
     * Section 5 of the GNU Affero General Public License version 3.
     *
     * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
     * these Appropriate Legal Notices must retain the display of the Zurmo
     * logo and Zurmo copyright notice. If the display of the logo is not reasonably
     * feasible for technical reasons, the Appropriate Legal Notices must display the words
     * "Copyright Zurmo Inc. 2014. All rights reserved".
     ********************************************************************************/

    require_once 'BaseUpgraderComponent.php';
    class UpgraderComponent extends BaseUpgraderComponent
    {
        /**
         * Process config files.
         * Problem here is that some config files might be modified, so there
         * can be some additional config options. We need to modify config
         * files(debug.php, debugTest.php, perInstance.php, perInstanceTest.php),
         * without loosing settings entered by user, so in most cases we will add
         * content at the end of those files where possible.
         * Should be used to files like debug.php, debugTest.php, perInstance.php, perInstanceTest.php,
         * which are not tracked by SCM tools, other files are updated automatically.
         *
         * @code
            <?php
                //Below is just sample code to add $myVariable to perInstance.php and perInstanceTest.php files.
                $zurmoVersionBeforeUpgrade = UpgradeUtil::getUpgradeState('zurmoVersionBeforeUpgrade');
                if ($this->shouldRunTasksByVersion($zurmoVersionBeforeUpgrade, '0.6.80'))
                {
                    $perInstanceTestFile = $pathToConfigurationFolder . DIRECTORY_SEPARATOR . 'perInstanceTest.php';
                    if (is_file($perInstanceTestFile))
                    {
                        $perInstanceTestContent = file_get_contents($perInstanceTestFile);

                        $contentToAdd = "\$myVariable = 'aaa';\n";
                        $perInstanceTestContent = preg_replace('/\?\>/',
                                                               "\n" . $contentToAdd . "\n" . "?>",
                                                               $perInstanceTestContent);
                        file_put_contents($perInstanceTestFile, $perInstanceTestContent);
                    }
                    $perInstanceFile = $pathToConfigurationFolder . DIRECTORY_SEPARATOR . 'perInstance.php';
                    if (is_file($perInstanceFile))
                    {
                        $perInstanceContent = file_get_contents($perInstanceFile);

                        $contentToAdd = "\$myVariable = 'aaa';\n";
                        $perInstanceContent = preg_replace('/\?\>/',
                                                           "\n" . $contentToAdd . "\n" . "?>",
                                                           $perInstanceContent);
                        file_put_contents($perInstanceFile, $perInstanceContent);
                    }
                }
            ?>
         * @endcode
         */
        public function processConfigFiles($pathToConfigurationFolder)
        {
            if ($this->shouldRunTasksByVersion('3.2.0'))
            {
                $debugFile = $pathToConfigurationFolder . DIRECTORY_SEPARATOR . 'debug.php';
                if (is_file($debugFile))
                {
                    $debugContent = file_get_contents($debugFile);
                    if(strpos($debugContent, 'if ($phpVersion[0] >= 7 && $debugOn)') === false)
                    {
                        $contentToAdd = '    // Content added for 3.2.0 Upgrade
    $phpVersion' . " = explode('.', phpversion());
    if (" . '$phpVersion[0]' . " >= 7 && " . '$debugOn' . ")
    {
        if (ini_get('zend.assertions') == 0)
        {
            ini_set('zend.assertions', '1');
        }
        ini_set('assert.exception', '0');
    }
    // End 3.2.0 Upgrade";

                        $debugContent = preg_replace('/\?\>/',
                            "\n" . $contentToAdd . "\n" . "?>",
                            $debugContent);
                        file_put_contents($debugFile, $debugContent);
                    }  
                }
                
                $debugTestFile = $pathToConfigurationFolder . DIRECTORY_SEPARATOR . 'debugTest.php';
                if (is_file($debugTestFile))
                {
                    $debugTestContent = file_get_contents($debugTestFile);
                    if(strpos($debugTestContent, 'if ($phpVersion[0] >= 7 && $debugOn)') === false)
                    {
                        $contentToAdd = '    // Content added for 3.2.0 Upgrade
    $phpVersion' . " = explode('.', phpversion());
    if (" . '$phpVersion[0]' . " >= 7 && " . '$debugOn' . ")
    {
        if (ini_get('zend.assertions') == 0)
        {
            ini_set('zend.assertions', '1');
        }
        ini_set('assert.exception', '0');
    }
    // End 3.2.0 Upgrade";

                        $debugTestContent = preg_replace('/\?\>/',
                            "\n" . $contentToAdd . "\n" . "?>",
                            $debugTestContent);
                        file_put_contents($debugTestFile, $debugTestContent);
                    }  
                }
            }
        }
        
        public function processBeforeUpdateSchema()
        {
            parent::processBeforeUpdateSchema();
            if ($this->shouldRunTasksByVersion('3.1.1'))
            {
                $this->updateContactMetadataAddTwitterAndFacebook();
                $this->updateMetadataChangesRelatedToOpportunityStageDatiTimeAndRots();
            }
            if ($this->shouldRunTasksByVersion('3.1.3'))
            {
                $this->updateProductsRelatedViewsMetadata();
            }
            if ($this->shouldRunTasksByVersion('3.2.1'))
            {
                $this->updateActivityMetadataAddIndex();
            }
            if (Yii::app()->edition == 'Commercial')
            {
                if ($this->shouldRunTasksByVersion('3.2.4'))
                {
                    $this->updateZurmoModuleMetadata();
                }
                if ($this->shouldRunTasksByVersion('3.2.6'))
                {
                    $this->updateZurmoModuleMetadataFor3_2_6();
                }
                if ($this->shouldRunTasksByVersion('3.2.7'))
                {
                    $this->dropCreateEmailMessageFunction();
                }
            }
        }

        public function processUpdateSchema($messageLogger)
        {
            if ($this->shouldRunTasksByVersion('3.1.1'))
            {
                User::forgetAll();
            }
            parent::processUpdateSchema($messageLogger);
        }

        public function processAfterUpdateSchema()
        {
            parent::processAfterUpdateSchema();
            if ($this->shouldRunTasksByVersion('3.1.1'))
            {
                $this->updateRightsTableChangeNameForManageUsers();
            }
            if ($this->shouldRunTasksByVersion('3.1.4'))
            {
                $this->updateOpportunityTableSetStageModifiedDateTime();
            }
        }

        protected function getModelClassNamesToPurgeGlobalMetadata()
        {
            // format: version => model class names to purge globalmetadata for.
            $models = array(
                '3.1.1' => array(
                    'OpportunitiesModuleEditView',
                    'User',
                    'UserCreateView',
                    'UserDetailsView',
                    'UserEditView',
                    'ZurmoSystemConfigurationEditAndDetailsView',
                    'ZurmoConfigurationEditAndDetailsView',
                ),
                '3.1.3' => array(
                    'UserNotificationConfigurationEditView',
                    'SecuredActionBarForTasksSearchAndListView',
                ),
                '3.1.5' => array(
                    'ZurmoSystemConfigurationEditAndDetailsView',
                    'ZurmoConfigurationEditAndDetailsView',
                ),
                '3.2.1' => array(
                    'OwnedSecurableItem',
                    'SecurableItem',
                ),
                '3.2.7' => array(
                    'EmailMessage',
                ),
            );

            if (Yii::app()->edition == 'Commercial')
            {
                //$models['3.1.1'][] = '';
            }
            // re-purging metadata for 3.0.0 files just to be sure.
            // We should never need to do this but in this case lets just do it to avoid surprises.
            return $models;
        }

        protected function updateContactMetadataAddTwitterAndFacebook()
        {
            $this->getMessageLogger()->addInfoMessage('Patching Contact metadata to add twitter and facebook');
            $metadataChanges = array(
                'members' => array(
                    5 => 'twitterId',
                    6 => 'facebookId'
                ),
                'rules' => array(
                    8   => array('twitterId', 'type', 'type' => 'string'),
                    9   => array('facebookId', 'type', 'type' => 'string'),
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Contact', $metadataChanges);
            $this->getMessageLogger()->addInfoMessage('Contact metadata patched');
        }

        protected function updateMetadataChangesRelatedToOpportunityStageDatiTimeAndRots()
        {
            $this->updateOpportunityMetadataRelatedAddStageDatetime();
            $this->updateOpportunityModuleAddRotting();
            $this->updateOpportunityViewsAddStagingDatetime();
        }

        protected function updateOpportunityMetadataRelatedAddStageDatetime()
        {
            $this->getMessageLogger()->addInfoMessage('Patching Opportunity metadata to add stage date time');
            $metadataChanges = array(
                'members' => array(
                    4 => 'stageModifiedDateTime'
                ),
                'rules' => array(
                    13   => array('stageModifiedDateTime',  'required'),
                    14   => array('stageModifiedDateTime',  'readOnly'),
                    15   => array('stageModifiedDateTime',  'type', 'type' => 'datetime')
                ),
                'elements' => array(
                    'stageModifiedDateTime' => 'DateTime',
                )
            );
            $this->updateModelMetadataWithNewMetaDefinition('Opportunity', $metadataChanges);
            $this->getMessageLogger()->addInfoMessage('Opportunity metadata patched (stage added)');
        }

        protected function updateOpportunityModuleAddRotting()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('OpportunitiesModule'))
            {
                $metadata = OpportunitiesModule::getMetadata();
                $metadata['global']['stageToRottingMapping'] = array(
                    'Prospecting'   => 0,
                    'Qualification' => 0,
                    'Negotiating'   => 0,
                    'Verbal'        => 0,
                    'Closed Won'    => 0,
                    'Closed Lost'   => 0,
                );
                $metadata['global']['opportunityRottingMappingEnabled'] = false;
                OpportunitiesModule::setMetadata($metadata);
            }
        }

        protected function updateOpportunityViewsAddStagingDatetime()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('OpportunitiesForAccountRelatedListView'))
            {
                $metadata = OpportunitiesForAccountRelatedListView::getMetadata();
                $metadata['global']['derivedAttributeTypes'][] = 'OpportunityTimeInStage';
                OpportunitiesForAccountRelatedListView::setMetadata($metadata);
            }
            if (GlobalMetadata::isClassMetadataSavedInDatabase('OpportunitiesForContactRelatedListView'))
            {
                $metadata = OpportunitiesForContactRelatedListView::getMetadata();
                $metadata['global']['derivedAttributeTypes'][] = 'OpportunityTimeInStage';
                OpportunitiesForContactRelatedListView::setMetadata($metadata);
            }
            if (GlobalMetadata::isClassMetadataSavedInDatabase('OpportunitiesListView'))
            {
                $metadata = OpportunitiesListView::getMetadata();
                $metadata['global']['derivedAttributeTypes'][] = 'OpportunityTimeInStage';
                OpportunitiesListView::setMetadata($metadata);
            }
            if (GlobalMetadata::isClassMetadataSavedInDatabase('OpportunitiesMyListView'))
            {
                $metadata = OpportunitiesMyListView::getMetadata();
                $metadata['global']['derivedAttributeTypes'][] = 'OpportunityTimeInStage';
                OpportunitiesMyListView::setMetadata($metadata);
            }
            if (GlobalMetadata::isClassMetadataSavedInDatabase('OpportunityEditAndDetailsView'))
            {
                $metadata = OpportunityEditAndDetailsView::getMetadata();
                $metadata['global']['nonPlaceableAttributeNames'][] = 'stageModifiedDateTime';
                OpportunityEditAndDetailsView::setMetadata($metadata);
            }
            if (GlobalMetadata::isClassMetadataSavedInDatabase('OpportunitiesMassEditView'))
            {
                $metadata = OpportunitiesMassEditView::getMetadata();
                $metadata['global']['nonPlaceableAttributeNames'][] = 'stageModifiedDateTime';
                OpportunitiesMassEditView::setMetadata($metadata);
            }
        }
        
        protected function updateOpportunityTableSetStageModifiedDateTime()
        {
            $sql = "UPDATE opportunity SET stagemodifieddatetime='0000-00-00 00:00:00' WHERE stagemodifieddatetime IS NULL;";
            ZurmoRedBean::exec($sql);
        }
        
        protected function updateProductsRelatedViewsMetadata()
        {
            $this->getMessageLogger()->addInfoMessage('Patching Products related views metadata.');
            if (GlobalMetadata::isClassMetadataSavedInDatabase('ProductsForAccountRelatedListView'))
            {
                $metadata = ProductsForAccountRelatedListView::getMetadata();
                $metadata['global']['toolbar']['elements'][0] = array(
                                        'type'             => 'CreateFromRelatedModalLink',
                                        'portletId'        => 'eval:$this->params["portletId"]',
                                        'routeModuleId'    => 'eval:$this->moduleId',
                                        'routeParameters'  => 'eval:$this->getCreateLinkRouteParameters()',
                                        'ajaxOptions'      => 'eval:ProductsUtil::resolveAjaxOptionsForModalView("Create")',
                                        'uniqueLayoutId'   => 'eval:$this->uniqueLayoutId',
                                        'modalContainerId' => 'eval:ProductsUtil::getModalContainerId()'
                                    );  
                $metadata['global']['rowMenu']['elements'][0] = array(
                                        'type'             => 'EditModalLink',
                                        'htmlOptions'      => 'eval:$this->getActionModalLinksHtmlOptions("Edit")'
                                    );
                ProductsForAccountRelatedListView::setMetadata($metadata);
            }
            if (GlobalMetadata::isClassMetadataSavedInDatabase('ProductsForContactRelatedListView'))
            {
                $metadata = ProductsForContactRelatedListView::getMetadata();
                $metadata['global']['toolbar']['elements'][0] = array(
                                        'type'             => 'CreateFromRelatedModalLink',
                                        'portletId'        => 'eval:$this->params["portletId"]',
                                        'routeModuleId'    => 'eval:$this->moduleId',
                                        'routeParameters'  => 'eval:$this->getCreateLinkRouteParameters()',
                                        'ajaxOptions'      => 'eval:ProductsUtil::resolveAjaxOptionsForModalView("Create")',
                                        'uniqueLayoutId'   => 'eval:$this->uniqueLayoutId',
                                        'modalContainerId' => 'eval:ProductsUtil::getModalContainerId()'
                                    );
                $metadata['global']['rowMenu']['elements'][0] = array(
                                        'type'             => 'EditModalLink',
                                        'htmlOptions'      => 'eval:$this->getActionModalLinksHtmlOptions("Edit")'
                                    );
                ProductsForContactRelatedListView::setMetadata($metadata);
            }
            if (GlobalMetadata::isClassMetadataSavedInDatabase('ProductsForOpportunityRelatedListView'))
            {
                $metadata = ProductsForOpportunityRelatedListView::getMetadata();
                $metadata['global']['toolbar']['elements'][0] = array(
                                        'type'             => 'CreateFromRelatedModalLink',
                                        'portletId'        => 'eval:$this->params["portletId"]',
                                        'routeModuleId'    => 'eval:$this->moduleId',
                                        'routeParameters'  => 'eval:$this->getCreateLinkRouteParameters()',
                                        'ajaxOptions'      => 'eval:ProductsUtil::resolveAjaxOptionsForModalView("Create")',
                                        'uniqueLayoutId'   => 'eval:$this->uniqueLayoutId',
                                        'modalContainerId' => 'eval:ProductsUtil::getModalContainerId()'
                                    );
                $metadata['global']['rowMenu']['elements'][0] = array(
                                        'type'             => 'EditModalLink',
                                        'htmlOptions'      => 'eval:$this->getActionModalLinksHtmlOptions("Edit")'
                                    );
                ProductsForOpportunityRelatedListView::setMetadata($metadata);
            }
            $this->getMessageLogger()->addInfoMessage('Patched Products related views metadata.');
        }

        protected function updateRightsTableChangeNameForManageUsers()
        {
            $sql = "UPDATE _right SET name='Manage Users' WHERE name='Change User Passwords';";
            ZurmoRedBean::exec($sql);
        }
        
        protected function updateActivityMetadataAddIndex()
        {
            $this->getMessageLogger()->addInfoMessage('Patching Activity metadata to add index on ownedsecurableitem_id');
            $metadataChanges = array(
                'indexes' => array(
                    'ownedsecurableitem_id' => array(
                        'members' => array('ownedsecurableitem_id'),
                        'unique' => false),
                ),
            );
            $this->updateModelMetadataWithNewMetaDefinition('Activity', $metadataChanges);
            $this->getMessageLogger()->addInfoMessage('Activity metadata patched (index added)');
        }
        
        protected function updateZurmoModuleMetadata()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('ZurmoModule'))
            {
                $this->getMessageLogger()->addInfoMessage('Patching ZurmoModule metadata to change About us');
                $metadata = ZurmoModule::getMetadata();
                $metadata['global']['headerMenuItems'] = array(
                     array(
                        'label'  => "eval:Zurmo::t('ZurmoModule', 'Administration')",
                        'url'    => array('/configuration'),
                        'right'  => ZurmoModule::RIGHT_ACCESS_ADMINISTRATION,
                        'order'  => 1,
                        'mobile' => false,
                    ),
                    array(
                        'label'  => "eval:Zurmo::t('ZurmoModule', 'About DaVinci11')",
                        'url'    => 'https://davinci11.com',
                        'order'  => 10,
                        'mobile' => true,
                    ),
                );
                ZurmoModule::setMetadata($metadata);
                $this->getMessageLogger()->addInfoMessage('ZurmoModule metadata patched (About us changed)');
            }
        }
        
        protected function updateZurmoModuleMetadataFor3_2_6()
        {
            if (GlobalMetadata::isClassMetadataSavedInDatabase('ZurmoModule'))
            {
                $this->getMessageLogger()->addInfoMessage('Patching ZurmoModule metadata to change About us');
                $metadata = ZurmoModule::getMetadata();
                $metadata['global']['headerMenuItems'] = array(
                     array(
                        'label'  => "eval:Zurmo::t('ZurmoModule', 'Administration')",
                        'url'    => array('/configuration'),
                        'right'  => ZurmoModule::RIGHT_ACCESS_ADMINISTRATION,
                        'order'  => 1,
                        'mobile' => false,
                    ),
                    array(
                        'label'  => "eval:Zurmo::t('ZurmoModule', 'About RedLotus')",
                        'url'    => 'https://redlotus.com',
                        'order'  => 10,
                        'mobile' => true,
                    ),
                );
                ZurmoModule::setMetadata($metadata);
                $this->getMessageLogger()->addInfoMessage('ZurmoModule metadata patched (About us changed)');
            }
        }
        
        protected function dropCreateEmailMessageFunction()
        {
            $sql = "DROP FUNCTION `create_email_message`;";
            ZurmoRedBean::exec($sql);
        }
    }
?>