<?php

namespace ContainerHjOmHJG;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\InvalidArgumentException;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/*
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class KernelDevContainer extends Container
{
    protected $containerDir;
    protected $targetDir;
    protected $parameters = [];
    private $buildParameters;
    protected $getService;

    public function __construct(array $buildParameters = [], $containerDir = __DIR__)
    {
        $this->getService = \Closure::fromCallable([$this, 'getService']);
        $this->buildParameters = $buildParameters;
        $this->containerDir = $containerDir;
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'kernel' => true,
        ];
        $this->methodMap = [
            'Translation\\Bundle\\EditInPlace\\Activator' => 'getActivatorService',
            'Zikula\\ExtensionsModule\\Api\\VariableApi' => 'getVariableApiService',
            'Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionRepository' => 'getExtensionRepositoryService',
            'Zikula\\RoutesModule\\Entity\\Factory\\EntityFactory' => 'getEntityFactoryService',
            'Zikula\\ThemeModule\\Engine\\Asset' => 'getAssetService',
            'Zikula\\UsersModule\\Api\\CurrentUserApi' => 'getCurrentUserApiService',
            'cache_warmer' => 'getCacheWarmerService',
            'data_collector.cache' => 'getDataCollector_CacheService',
            'data_collector.dump' => 'getDataCollector_DumpService',
            'doctrine' => 'getDoctrineService',
            'doctrine.dbal.default_connection' => 'getDoctrine_Dbal_DefaultConnectionService',
            'doctrine.orm.default_entity_manager' => 'getDoctrine_Orm_DefaultEntityManagerService',
            'event_dispatcher' => 'getEventDispatcherService',
            'filesystem' => 'getFilesystemService',
            'fos_js_routing.extractor' => 'getFosJsRouting_ExtractorService',
            'http_kernel' => 'getHttpKernelService',
            'knp_menu.matcher' => 'getKnpMenu_MatcherService',
            'liip_imagine.cache.manager' => 'getLiipImagine_Cache_ManagerService',
            'liip_imagine.cache.resolver.default' => 'getLiipImagine_Cache_Resolver_DefaultService',
            'liip_imagine.cache.resolver.no_cache_web_path' => 'getLiipImagine_Cache_Resolver_NoCacheWebPathService',
            'liip_imagine.cache.signer' => 'getLiipImagine_Cache_SignerService',
            'monolog.logger.mail' => 'getMonolog_Logger_MailService',
            'monolog.logger.zikula' => 'getMonolog_Logger_ZikulaService',
            'profiler' => 'getProfilerService',
            'request_stack' => 'getRequestStackService',
            'router' => 'getRouterService',
            'security.authorization_checker' => 'getSecurity_AuthorizationCheckerService',
            'security.token_storage' => 'getSecurity_TokenStorageService',
            'session' => 'getSessionService',
            'state_machine.zikularoutesmodule_none' => 'getStateMachine_ZikularoutesmoduleNoneService',
            'translator' => 'getTranslatorService',
            'twig' => 'getTwigService',
            'validator' => 'getValidatorService',
            'var_dumper.cloner' => 'getVarDumper_ClonerService',
            'zikula_core.common.theme.assets_css' => 'getZikulaCore_Common_Theme_AssetsCssService',
            'zikula_core.common.theme.themevars' => 'getZikulaCore_Common_Theme_ThemevarsService',
        ];
        $this->fileMap = [
            'Liip\\ImagineBundle\\Controller\\ImagineController' => 'getImagineControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController' => 'getRedirectControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController' => 'getTemplateControllerService',
            'Translation\\Bundle\\Catalogue\\CatalogueCounter' => 'getCatalogueCounterService',
            'Translation\\Bundle\\Catalogue\\CatalogueFetcher' => 'getCatalogueFetcherService',
            'Translation\\Bundle\\Catalogue\\CatalogueManager' => 'getCatalogueManagerService',
            'Translation\\Bundle\\Catalogue\\CatalogueWriter' => 'getCatalogueWriterService',
            'Translation\\Bundle\\Command\\CheckMissingCommand' => 'getCheckMissingCommandService',
            'Translation\\Bundle\\Command\\DeleteObsoleteCommand' => 'getDeleteObsoleteCommandService',
            'Translation\\Bundle\\Command\\DownloadCommand' => 'getDownloadCommandService',
            'Translation\\Bundle\\Command\\ExtractCommand' => 'getExtractCommandService',
            'Translation\\Bundle\\Command\\StatusCommand' => 'getStatusCommandService',
            'Translation\\Bundle\\Command\\SyncCommand' => 'getSyncCommandService',
            'Translation\\Bundle\\Controller\\EditInPlaceController' => 'getEditInPlaceControllerService',
            'Translation\\Bundle\\Controller\\SymfonyProfilerController' => 'getSymfonyProfilerControllerService',
            'Translation\\Bundle\\Controller\\WebUIController' => 'getWebUIControllerService',
            'Translation\\Bundle\\Service\\CacheClearer' => 'getCacheClearerService',
            'Translation\\Bundle\\Service\\ConfigurationManager' => 'getConfigurationManagerService',
            'Translation\\Bundle\\Service\\Importer' => 'getImporterService',
            'Translation\\Bundle\\Service\\StorageManager' => 'getStorageManagerService',
            'Zikula\\AdminModule\\Block\\AdminnavBlock' => 'getAdminnavBlockService',
            'Zikula\\AdminModule\\Controller\\AdminController' => 'getAdminControllerService',
            'Zikula\\AdminModule\\Controller\\AdminInterfaceController' => 'getAdminInterfaceControllerService',
            'Zikula\\AdminModule\\Controller\\AjaxController' => 'getAjaxControllerService',
            'Zikula\\AdminModule\\Controller\\ConfigController' => 'getConfigControllerService',
            'Zikula\\BlocksModule\\Block\\FincludeBlock' => 'getFincludeBlockService',
            'Zikula\\BlocksModule\\Block\\HtmlBlock' => 'getHtmlBlockService',
            'Zikula\\BlocksModule\\Block\\PendingContentBlock' => 'getPendingContentBlockService',
            'Zikula\\BlocksModule\\Block\\TextBlock' => 'getTextBlockService',
            'Zikula\\BlocksModule\\Block\\XsltBlock' => 'getXsltBlockService',
            'Zikula\\BlocksModule\\Controller\\AdminController' => 'getAdminController2Service',
            'Zikula\\BlocksModule\\Controller\\BlockController' => 'getBlockControllerService',
            'Zikula\\BlocksModule\\Controller\\ConfigController' => 'getConfigController2Service',
            'Zikula\\BlocksModule\\Controller\\PlacementController' => 'getPlacementControllerService',
            'Zikula\\BlocksModule\\Controller\\PositionController' => 'getPositionControllerService',
            'Zikula\\BootstrapTheme\\Controller\\AjaxController' => 'getAjaxController2Service',
            'Zikula\\Bundle\\CoreBundle\\Controller\\MainController' => 'getMainControllerService',
            'Zikula\\Bundle\\CoreInstallerBundle\\Controller\\AjaxInstallController' => 'getAjaxInstallControllerService',
            'Zikula\\Bundle\\CoreInstallerBundle\\Controller\\AjaxUpgradeController' => 'getAjaxUpgradeControllerService',
            'Zikula\\Bundle\\CoreInstallerBundle\\Controller\\InstallerController' => 'getInstallerControllerService',
            'Zikula\\Bundle\\CoreInstallerBundle\\Controller\\MigrationController' => 'getMigrationControllerService',
            'Zikula\\Bundle\\CoreInstallerBundle\\Controller\\UpgraderController' => 'getUpgraderControllerService',
            'Zikula\\Bundle\\HookBundle\\Controller\\HookController' => 'getHookControllerService',
            'Zikula\\Bundle\\WorkflowBundle\\Controller\\EditorController' => 'getEditorControllerService',
            'Zikula\\CategoriesModule\\Controller\\CategoryController' => 'getCategoryControllerService',
            'Zikula\\CategoriesModule\\Controller\\NodeController' => 'getNodeControllerService',
            'Zikula\\CategoriesModule\\Controller\\RegistryController' => 'getRegistryControllerService',
            'Zikula\\ExtensionsModule\\Controller\\ConfigController' => 'getConfigController3Service',
            'Zikula\\ExtensionsModule\\Controller\\ExtensionController' => 'getExtensionControllerService',
            'Zikula\\ExtensionsModule\\Controller\\ExtensionInstallerController' => 'getExtensionInstallerControllerService',
            'Zikula\\ExtensionsModule\\Controller\\ExtensionsInterfaceController' => 'getExtensionsInterfaceControllerService',
            'Zikula\\ExtensionsModule\\Controller\\HelpController' => 'getHelpControllerService',
            'Zikula\\GroupsModule\\Controller\\ApplicationController' => 'getApplicationControllerService',
            'Zikula\\GroupsModule\\Controller\\ConfigController' => 'getConfigController4Service',
            'Zikula\\GroupsModule\\Controller\\GroupController' => 'getGroupControllerService',
            'Zikula\\GroupsModule\\Controller\\MembershipController' => 'getMembershipControllerService',
            'Zikula\\GroupsModule\\Entity\\Repository\\GroupRepository' => 'getGroupRepositoryService',
            'Zikula\\MailerModule\\Controller\\ConfigController' => 'getConfigController5Service',
            'Zikula\\MenuModule\\Block\\MenuBlock' => 'getMenuBlockService',
            'Zikula\\MenuModule\\Controller\\ConfigController' => 'getConfigController6Service',
            'Zikula\\MenuModule\\Controller\\MenuController' => 'getMenuControllerService',
            'Zikula\\MenuModule\\Controller\\NodeController' => 'getNodeController2Service',
            'Zikula\\PermissionsModule\\Controller\\ConfigController' => 'getConfigController7Service',
            'Zikula\\PermissionsModule\\Controller\\PermissionController' => 'getPermissionControllerService',
            'Zikula\\RoutesModule\\Controller\\AjaxController' => 'getAjaxController3Service',
            'Zikula\\RoutesModule\\Controller\\ConfigController' => 'getConfigController8Service',
            'Zikula\\RoutesModule\\Controller\\RouteController' => 'getRouteControllerService',
            'Zikula\\RoutesModule\\Controller\\UpdateController' => 'getUpdateControllerService',
            'Zikula\\SearchModule\\Block\\SearchBlock' => 'getSearchBlockService',
            'Zikula\\SearchModule\\Controller\\ConfigController' => 'getConfigController9Service',
            'Zikula\\SearchModule\\Controller\\SearchController' => 'getSearchControllerService',
            'Zikula\\SecurityCenterModule\\Controller\\ConfigController' => 'getConfigController10Service',
            'Zikula\\SecurityCenterModule\\Controller\\IdsLogController' => 'getIdsLogControllerService',
            'Zikula\\SettingsModule\\Block\\LocaleBlock' => 'getLocaleBlockService',
            'Zikula\\SettingsModule\\Controller\\SettingsController' => 'getSettingsControllerService',
            'Zikula\\ThemeModule\\Controller\\CombinedAssetController' => 'getCombinedAssetControllerService',
            'Zikula\\ThemeModule\\Controller\\ConfigController' => 'getConfigController11Service',
            'Zikula\\ThemeModule\\Controller\\VarController' => 'getVarControllerService',
            'Zikula\\UsersModule\\Block\\AccountLinksBlock' => 'getAccountLinksBlockService',
            'Zikula\\UsersModule\\Block\\LoginBlock' => 'getLoginBlockService',
            'Zikula\\UsersModule\\Block\\OnlineBlock' => 'getOnlineBlockService',
            'Zikula\\UsersModule\\Controller\\AccessController' => 'getAccessControllerService',
            'Zikula\\UsersModule\\Controller\\AccountController' => 'getAccountControllerService',
            'Zikula\\UsersModule\\Controller\\ConfigController' => 'getConfigController12Service',
            'Zikula\\UsersModule\\Controller\\FileIOController' => 'getFileIOControllerService',
            'Zikula\\UsersModule\\Controller\\LiveSearchController' => 'getLiveSearchControllerService',
            'Zikula\\UsersModule\\Controller\\RegistrationController' => 'getRegistrationControllerService',
            'Zikula\\UsersModule\\Controller\\UserAdministrationController' => 'getUserAdministrationControllerService',
            'Zikula\\ZAuthModule\\Controller\\AccountController' => 'getAccountController2Service',
            'Zikula\\ZAuthModule\\Controller\\ConfigController' => 'getConfigController13Service',
            'Zikula\\ZAuthModule\\Controller\\FileIOController' => 'getFileIOController2Service',
            'Zikula\\ZAuthModule\\Controller\\RegistrationController' => 'getRegistrationController2Service',
            'Zikula\\ZAuthModule\\Controller\\UserAdministrationController' => 'getUserAdministrationController2Service',
            'bazinga.jstranslation.controller' => 'getBazinga_Jstranslation_ControllerService',
            'bazinga.jstranslation.dump_command' => 'getBazinga_Jstranslation_DumpCommandService',
            'bazinga.jstranslation.translation_dumper' => 'getBazinga_Jstranslation_TranslationDumperService',
            'bazinga.jstranslation.translation_finder' => 'getBazinga_Jstranslation_TranslationFinderService',
            'cache.app' => 'getCache_AppService',
            'cache.app_clearer' => 'getCache_AppClearerService',
            'cache.global_clearer' => 'getCache_GlobalClearerService',
            'cache.system' => 'getCache_SystemService',
            'cache.system_clearer' => 'getCache_SystemClearerService',
            'cache_clearer' => 'getCacheClearer2Service',
            'console.command_loader' => 'getConsole_CommandLoaderService',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'error_controller' => 'getErrorControllerService',
            'form.factory' => 'getForm_FactoryService',
            'form.type.file' => 'getForm_Type_FileService',
            'fos_js_routing.controller' => 'getFosJsRouting_ControllerService',
            'fos_js_routing.serializer' => 'getFosJsRouting_SerializerService',
            'jms_i18n_routing.loader' => 'getJmsI18nRouting_LoaderService',
            'knp_menu.factory' => 'getKnpMenu_FactoryService',
            'liip_imagine.binary.loader.default' => 'getLiipImagine_Binary_Loader_DefaultService',
            'liip_imagine.binary.loader.zikula_root' => 'getLiipImagine_Binary_Loader_ZikulaRootService',
            'liip_imagine.config.stack_collection' => 'getLiipImagine_Config_StackCollectionService',
            'liip_imagine.data.manager' => 'getLiipImagine_Data_ManagerService',
            'liip_imagine.filter.loader.downscale' => 'getLiipImagine_Filter_Loader_DownscaleService',
            'liip_imagine.filter.loader.fixed' => 'getLiipImagine_Filter_Loader_FixedService',
            'liip_imagine.filter.loader.flip' => 'getLiipImagine_Filter_Loader_FlipService',
            'liip_imagine.filter.loader.grayscale' => 'getLiipImagine_Filter_Loader_GrayscaleService',
            'liip_imagine.filter.loader.interlace' => 'getLiipImagine_Filter_Loader_InterlaceService',
            'liip_imagine.filter.loader.resample' => 'getLiipImagine_Filter_Loader_ResampleService',
            'liip_imagine.filter.loader.rotate' => 'getLiipImagine_Filter_Loader_RotateService',
            'liip_imagine.filter.manager' => 'getLiipImagine_Filter_ManagerService',
            'matthias_symfony_console.register_styles_event_listener' => 'getMatthiasSymfonyConsole_RegisterStylesEventListenerService',
            'matthias_symfony_console_form.console_form_type_extension' => 'getMatthiasSymfonyConsoleForm_ConsoleFormTypeExtensionService',
            'matthias_symfony_console_form.handle_form_based_command_event_listener' => 'getMatthiasSymfonyConsoleForm_HandleFormBasedCommandEventListenerService',
            'matthias_symfony_console_form.register_helpers_event_listener' => 'getMatthiasSymfonyConsoleForm_RegisterHelpersEventListenerService',
            'matthias_symfony_console_form.set_input_definition_of_form_based_command_event_listener' => 'getMatthiasSymfonyConsoleForm_SetInputDefinitionOfFormBasedCommandEventListenerService',
            'oro_twig_inspector.controller.open_template' => 'getOroTwigInspector_Controller_OpenTemplateService',
            'php_translation.cache_clearer' => 'getPhpTranslation_CacheClearerService',
            'php_translation.catalogue_counter' => 'getPhpTranslation_CatalogueCounterService',
            'php_translation.catalogue_fetcher' => 'getPhpTranslation_CatalogueFetcherService',
            'php_translation.catalogue_manager' => 'getPhpTranslation_CatalogueManagerService',
            'php_translation.catalogue_writer' => 'getPhpTranslation_CatalogueWriterService',
            'php_translation.configuration_manager' => 'getPhpTranslation_ConfigurationManagerService',
            'php_translation.edit_in_place.activator' => 'getPhpTranslation_EditInPlace_ActivatorService',
            'php_translation.importer' => 'getPhpTranslation_ImporterService',
            'php_translation.storage.extension' => 'getPhpTranslation_Storage_ExtensionService',
            'php_translation.storage.zikula' => 'getPhpTranslation_Storage_ZikulaService',
            'php_translation.storage_manager' => 'getPhpTranslation_StorageManagerService',
            'php_translator.console.delete_obsolete' => 'getPhpTranslator_Console_DeleteObsoleteService',
            'php_translator.console.download' => 'getPhpTranslator_Console_DownloadService',
            'php_translator.console.extract' => 'getPhpTranslator_Console_ExtractService',
            'php_translator.console.status' => 'getPhpTranslator_Console_StatusService',
            'php_translator.console.sync' => 'getPhpTranslator_Console_SyncService',
            'routing.loader' => 'getRouting_LoaderService',
            'security.authentication_utils' => 'getSecurity_AuthenticationUtilsService',
            'security.csrf.token_manager' => 'getSecurity_Csrf_TokenManagerService',
            'security.password_encoder' => 'getSecurity_PasswordEncoderService',
            'services_resetter' => 'getServicesResetterService',
            'stof_doctrine_extensions.uploadable.manager' => 'getStofDoctrineExtensions_Uploadable_ManagerService',
            'web_profiler.controller.exception_panel' => 'getWebProfiler_Controller_ExceptionPanelService',
            'web_profiler.controller.profiler' => 'getWebProfiler_Controller_ProfilerService',
            'web_profiler.controller.router' => 'getWebProfiler_Controller_RouterService',
        ];
        $this->aliases = [
            'Kernel' => 'kernel',
            'Translation\\Bundle\\Service\\StorageService' => 'php_translation.storage.zikula',
            'database_connection' => 'doctrine.dbal.default_connection',
            'doctrine.orm.entity_manager' => 'doctrine.orm.default_entity_manager',
            'liip_imagine.controller' => 'Liip\\ImagineBundle\\Controller\\ImagineController',
            'php_translation.storage' => 'php_translation.storage.zikula',
            'php_translation.storage.default' => 'php_translation.storage.zikula',
        ];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function load($file, $lazyLoad = true)
    {
        if (class_exists($class = __NAMESPACE__.'\\'.$file, false)) {
            return $class::do($this, $lazyLoad);
        }

        if ('.' === $file[-4]) {
            $class = substr($class, 0, -4);
        } else {
            $file .= '.php';
        }

        $service = require $this->containerDir.\DIRECTORY_SEPARATOR.$file;

        return class_exists($class, false) ? $class::do($this, $lazyLoad) : $service;
    }

    /*
     * Gets the public 'Translation\Bundle\EditInPlace\Activator' shared service.
     *
     * @return \Translation\Bundle\EditInPlace\Activator
     */
    protected function getActivatorService()
    {
        return $this->services['Translation\\Bundle\\EditInPlace\\Activator'] = new \Translation\Bundle\EditInPlace\Activator(($this->services['session'] ?? $this->getSessionService()));
    }

    /*
     * Gets the public 'Zikula\ExtensionsModule\Api\VariableApi' shared autowired service.
     *
     * @return \Zikula\ExtensionsModule\Api\VariableApi
     */
    protected function getVariableApiService()
    {
        return $this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] = new \Zikula\ExtensionsModule\Api\VariableApi($this->getEnv('ZIKULA_INSTALLED'), ($this->privates['Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionVarRepository'] ?? $this->getExtensionVarRepositoryService()), ($this->services['kernel'] ?? $this->get('kernel', 1)), $this->parameters['multisites']);
    }

    /*
     * Gets the public 'Zikula\ExtensionsModule\Entity\Repository\ExtensionRepository' shared autowired service.
     *
     * @return \Zikula\ExtensionsModule\Entity\Repository\ExtensionRepository
     */
    protected function getExtensionRepositoryService()
    {
        return $this->services['Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionRepository'] = new \Zikula\ExtensionsModule\Entity\Repository\ExtensionRepository(($this->services['doctrine'] ?? $this->getDoctrineService()));
    }

    /*
     * Gets the public 'Zikula\RoutesModule\Entity\Factory\EntityFactory' shared autowired service.
     *
     * @return \Zikula\RoutesModule\Entity\Factory\EntityFactory
     */
    protected function getEntityFactoryService()
    {
        return $this->services['Zikula\\RoutesModule\\Entity\\Factory\\EntityFactory'] = new \Zikula\RoutesModule\Entity\Factory\EntityFactory(($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), new \Zikula\RoutesModule\Entity\Factory\EntityInitialiser(($this->privates['Zikula\\RoutesModule\\Helper\\PermissionHelper'] ?? $this->getPermissionHelperService()), ($this->privates['Zikula\\RoutesModule\\Helper\\ListEntriesHelper'] ?? $this->getListEntriesHelperService())), ($this->privates['Zikula\\RoutesModule\\Helper\\CollectionFilterHelper'] ?? $this->getCollectionFilterHelperService()));
    }

    /*
     * Gets the public 'Zikula\ThemeModule\Engine\Asset' shared autowired service.
     *
     * @return \Zikula\ThemeModule\Engine\Asset
     */
    protected function getAssetService()
    {
        return $this->services['Zikula\\ThemeModule\\Engine\\Asset'] = new \Zikula\ThemeModule\Engine\Asset(($this->services['kernel'] ?? $this->get('kernel', 1)), ($this->privates['assets.packages'] ?? $this->getAssets_PackagesService()), ($this->services['router'] ?? $this->getRouterService()), ($this->services['filesystem'] ?? ($this->services['filesystem'] = new \Symfony\Component\Filesystem\Filesystem())), ($this->privates['Zikula\\ThemeModule\\Engine\\Engine'] ?? $this->getEngineService()));
    }

    /*
     * Gets the public 'Zikula\UsersModule\Api\CurrentUserApi' shared autowired service.
     *
     * @return \Zikula\UsersModule\Api\CurrentUserApi
     */
    protected function getCurrentUserApiService()
    {
        return $this->services['Zikula\\UsersModule\\Api\\CurrentUserApi'] = new \Zikula\UsersModule\Api\CurrentUserApi(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['Zikula\\UsersModule\\Entity\\Repository\\UserRepository'] ?? $this->getUserRepositoryService()));
    }

    /*
     * Gets the public 'cache_warmer' shared service.
     *
     * @return \Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerAggregate
     */
    protected function getCacheWarmerService()
    {
        return $this->services['cache_warmer'] = new \Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerAggregate(new RewindableGenerator(function () {
            yield 0 => ($this->privates['doctrine.orm.default_metadata_cache_warmer'] ?? $this->load('getDoctrine_Orm_DefaultMetadataCacheWarmerService'));
            yield 1 => ($this->privates['cache_pool_clearer.cache_warmer'] ?? $this->load('getCachePoolClearer_CacheWarmerService'));
            yield 2 => ($this->privates['validator.mapping.cache_warmer'] ?? $this->load('getValidator_Mapping_CacheWarmerService'));
            yield 3 => ($this->privates['translation.warmer'] ?? $this->load('getTranslation_WarmerService'));
            yield 4 => ($this->privates['router.cache_warmer'] ?? $this->load('getRouter_CacheWarmerService'));
            yield 5 => ($this->privates['annotations.cache_warmer'] ?? $this->load('getAnnotations_CacheWarmerService'));
            yield 6 => ($this->privates['twig.template_cache_warmer'] ?? $this->load('getTwig_TemplateCacheWarmerService'));
            yield 7 => ($this->privates['doctrine.orm.proxy_cache_warmer'] ?? $this->load('getDoctrine_Orm_ProxyCacheWarmerService'));
        }, 8), false, ($this->targetDir.''.'/KernelDevContainerDeprecations.log'));
    }

    /*
     * Gets the public 'data_collector.cache' shared service.
     *
     * @return \Symfony\Component\Cache\DataCollector\CacheDataCollector
     */
    protected function getDataCollector_CacheService()
    {
        return $this->services['data_collector.cache'] = new \Symfony\Component\Cache\DataCollector\CacheDataCollector();
    }

    /*
     * Gets the public 'data_collector.dump' shared service.
     *
     * @return \Symfony\Component\HttpKernel\DataCollector\DumpDataCollector
     */
    protected function getDataCollector_DumpService()
    {
        return $this->services['data_collector.dump'] = new \Symfony\Component\HttpKernel\DataCollector\DumpDataCollector(($this->privates['debug.stopwatch'] ?? ($this->privates['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true))), ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService()), 'UTF-8', NULL, ($this->privates['var_dumper.server_connection'] ?? $this->getVarDumper_ServerConnectionService()));
    }

    /*
     * Gets the public 'doctrine' shared service.
     *
     * @return \Doctrine\Bundle\DoctrineBundle\Registry
     */
    protected function getDoctrineService()
    {
        return $this->services['doctrine'] = new \Doctrine\Bundle\DoctrineBundle\Registry($this, $this->parameters['doctrine.connections'], $this->parameters['doctrine.entity_managers'], 'default', 'default');
    }

    /*
     * Gets the public 'doctrine.dbal.default_connection' shared service.
     *
     * @return \Doctrine\DBAL\Connection
     */
    protected function getDoctrine_Dbal_DefaultConnectionService()
    {
        $a = new \Symfony\Bridge\Doctrine\ContainerAwareEventManager(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'doctrine.orm.default_listeners.attach_entity_listeners' => ['privates', 'doctrine.orm.default_listeners.attach_entity_listeners', 'getDoctrine_Orm_DefaultListeners_AttachEntityListenersService', true],
        ], [
            'doctrine.orm.default_listeners.attach_entity_listeners' => '?',
        ]));

        $b = new \Gedmo\Timestampable\TimestampableListener();

        $c = ($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService());

        $b->setAnnotationReader($c);
        $d = new \Gedmo\Sluggable\SluggableListener();
        $d->setAnnotationReader($c);
        $e = new \Gedmo\Tree\TreeListener();
        $e->setAnnotationReader($c);
        $f = new \Gedmo\Sortable\SortableListener();
        $f->setAnnotationReader($c);
        $g = new \Gedmo\SoftDeleteable\SoftDeleteableListener();
        $g->setAnnotationReader($c);
        $h = new \Gedmo\ReferenceIntegrity\ReferenceIntegrityListener();
        $h->setAnnotationReader($c);

        $a->addEventSubscriber(($this->privates['stof_doctrine_extensions.listener.loggable'] ?? $this->getStofDoctrineExtensions_Listener_LoggableService()));
        $a->addEventSubscriber(new \Symfony\Bridge\Doctrine\SchemaListener\MessengerTransportDoctrineSchemaSubscriber(new RewindableGenerator(function () {
            return new \EmptyIterator();
        }, 0)));
        $a->addEventSubscriber(new \Symfony\Bridge\Doctrine\SchemaListener\PdoCacheAdapterDoctrineSchemaSubscriber([]));
        $a->addEventSubscriber($b);
        $a->addEventSubscriber(($this->privates['stof_doctrine_extensions.listener.blameable'] ?? $this->getStofDoctrineExtensions_Listener_BlameableService()));
        $a->addEventSubscriber($d);
        $a->addEventSubscriber($e);
        $a->addEventSubscriber($f);
        $a->addEventSubscriber($g);
        $a->addEventSubscriber($h);
        $a->addEventSubscriber(new \Zikula\RoutesModule\Listener\EntityLifecycleListener($this, ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService())));
        $a->addEventSubscriber(($this->privates['stof_doctrine_extensions.listener.uploadable'] ?? $this->getStofDoctrineExtensions_Listener_UploadableService()));
        $a->addEventSubscriber(($this->privates['stof_doctrine_extensions.listener.translatable'] ?? $this->getStofDoctrineExtensions_Listener_TranslatableService()));
        $a->addEventListener([0 => 'loadClassMetadata'], 'doctrine.orm.default_listeners.attach_entity_listeners');

        return $this->services['doctrine.dbal.default_connection'] = (new \Doctrine\Bundle\DoctrineBundle\ConnectionFactory($this->parameters['doctrine.dbal.connection_factory.types']))->createConnection(['connection_override_options' => [], 'url' => $this->getEnv('resolve:DATABASE_URL'), 'driver' => 'pdo_mysql', 'host' => 'localhost', 'port' => NULL, 'user' => 'root', 'password' => NULL, 'driverOptions' => [], 'serverVersion' => 5, 'defaultTableOptions' => []], new \Doctrine\DBAL\Configuration(), $a, []);
    }

    /*
     * Gets the public 'doctrine.orm.default_entity_manager' shared service.
     *
     * @return \Doctrine\ORM\EntityManager
     */
    protected function getDoctrine_Orm_DefaultEntityManagerService($lazyLoad = true)
    {
        $a = new \Doctrine\ORM\Configuration();

        $b = new \Doctrine\Persistence\Mapping\Driver\MappingDriverChain();

        $c = ($this->privates['doctrine.orm.default_annotation_metadata_driver'] ?? $this->getDoctrine_Orm_DefaultAnnotationMetadataDriverService());

        $b->addDriver($c, 'Gedmo\\Translatable\\Entity');
        $b->addDriver($c, 'Gedmo\\Translator\\Entity');
        $b->addDriver($c, 'Gedmo\\Loggable\\Entity');
        $b->addDriver($c, 'Gedmo\\Tree\\Entity');
        $b->addDriver($c, 'Zikula\\Bundle\\HookBundle\\Entity');
        $b->addDriver($c, 'Zikula\\AdminModule\\Entity');
        $b->addDriver($c, 'Zikula\\BlocksModule\\Entity');
        $b->addDriver($c, 'Zikula\\CategoriesModule\\Entity');
        $b->addDriver($c, 'Zikula\\ExtensionsModule\\Entity');
        $b->addDriver($c, 'Zikula\\GroupsModule\\Entity');
        $b->addDriver($c, 'Zikula\\MenuModule\\Entity');
        $b->addDriver($c, 'Zikula\\PermissionsModule\\Entity');
        $b->addDriver($c, 'Zikula\\RoutesModule\\Entity');
        $b->addDriver($c, 'Zikula\\SearchModule\\Entity');
        $b->addDriver($c, 'Zikula\\SecurityCenterModule\\Entity');
        $b->addDriver($c, 'Zikula\\UsersModule\\Entity');
        $b->addDriver($c, 'Zikula\\ZAuthModule\\Entity');

        $a->setEntityNamespaces(['GedmoTranslatable' => 'Gedmo\\Translatable\\Entity', 'GedmoTranslator' => 'Gedmo\\Translator\\Entity', 'GedmoLoggable' => 'Gedmo\\Loggable\\Entity', 'GedmoTree' => 'Gedmo\\Tree\\Entity', 'ZikulaHookBundle' => 'Zikula\\Bundle\\HookBundle\\Entity', 'ZikulaAdminModule' => 'Zikula\\AdminModule\\Entity', 'ZikulaBlocksModule' => 'Zikula\\BlocksModule\\Entity', 'ZikulaCategoriesModule' => 'Zikula\\CategoriesModule\\Entity', 'ZikulaExtensionsModule' => 'Zikula\\ExtensionsModule\\Entity', 'ZikulaGroupsModule' => 'Zikula\\GroupsModule\\Entity', 'ZikulaMenuModule' => 'Zikula\\MenuModule\\Entity', 'ZikulaPermissionsModule' => 'Zikula\\PermissionsModule\\Entity', 'ZikulaRoutesModule' => 'Zikula\\RoutesModule\\Entity', 'ZikulaSearchModule' => 'Zikula\\SearchModule\\Entity', 'ZikulaSecurityCenterModule' => 'Zikula\\SecurityCenterModule\\Entity', 'ZikulaUsersModule' => 'Zikula\\UsersModule\\Entity', 'ZikulaZAuthModule' => 'Zikula\\ZAuthModule\\Entity']);
        $a->setMetadataCacheImpl(new \Symfony\Component\Cache\DoctrineProvider(new \Symfony\Component\Cache\Adapter\PhpArrayAdapter(($this->targetDir.''.'/doctrine/orm/default_metadata.php'), new \Symfony\Component\Cache\Adapter\DoctrineAdapter(new \Symfony\Component\Cache\DoctrineProvider(($this->privates['cache.doctrine.orm.default.metadata'] ?? ($this->privates['cache.doctrine.orm.default.metadata'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter())))))));
        $a->setQueryCacheImpl(new \Symfony\Component\Cache\DoctrineProvider(($this->privates['cache.doctrine.orm.default.query'] ?? ($this->privates['cache.doctrine.orm.default.query'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter()))));
        $a->setResultCacheImpl(new \Symfony\Component\Cache\DoctrineProvider(($this->privates['cache.doctrine.orm.default.result'] ?? ($this->privates['cache.doctrine.orm.default.result'] = new \Symfony\Component\Cache\Adapter\ArrayAdapter()))));
        $a->setMetadataDriverImpl($b);
        $a->setProxyDir(($this->targetDir.''.'/doctrine/orm/DoctrineProxy'));
        $a->setProxyNamespace('DoctrineProxy');
        $a->setAutoGenerateProxyClasses(true);
        $a->setClassMetadataFactoryName('Doctrine\\ORM\\Mapping\\ClassMetadataFactory');
        $a->setDefaultRepositoryClassName('Doctrine\\ORM\\EntityRepository');
        $a->setNamingStrategy(new \Doctrine\ORM\Mapping\DefaultNamingStrategy());
        $a->setQuoteStrategy(new \Doctrine\ORM\Mapping\DefaultQuoteStrategy());
        $a->setEntityListenerResolver(new \Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver($this));
        $a->setRepositoryFactory(new \Doctrine\Bundle\DoctrineBundle\Repository\ContainerRepositoryFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'Zikula\\AdminModule\\Entity\\Repository\\AdminCategoryRepository' => ['privates', 'Zikula\\AdminModule\\Entity\\Repository\\AdminCategoryRepository', 'getAdminCategoryRepositoryService', true],
            'Zikula\\AdminModule\\Entity\\Repository\\AdminModuleRepository' => ['privates', 'Zikula\\AdminModule\\Entity\\Repository\\AdminModuleRepository', 'getAdminModuleRepositoryService', true],
            'Zikula\\BlocksModule\\Entity\\Repository\\BlockPositionRepository' => ['privates', 'Zikula\\BlocksModule\\Entity\\Repository\\BlockPositionRepository', 'getBlockPositionRepositoryService', false],
            'Zikula\\BlocksModule\\Entity\\Repository\\BlockRepository' => ['privates', 'Zikula\\BlocksModule\\Entity\\Repository\\BlockRepository', 'getBlockRepositoryService', true],
            'Zikula\\Bundle\\HookBundle\\Repository\\HookBindingRepository' => ['privates', 'Zikula\\Bundle\\HookBundle\\Repository\\HookBindingRepository', 'getHookBindingRepositoryService', false],
            'Zikula\\Bundle\\HookBundle\\Repository\\HookRuntimeRepository' => ['privates', 'Zikula\\Bundle\\HookBundle\\Repository\\HookRuntimeRepository', 'getHookRuntimeRepositoryService', false],
            'Zikula\\CategoriesModule\\Entity\\Repository\\CategoryRegistryRepository' => ['privates', 'Zikula\\CategoriesModule\\Entity\\Repository\\CategoryRegistryRepository', 'getCategoryRegistryRepositoryService', true],
            'Zikula\\CategoriesModule\\Entity\\Repository\\CategoryRepository' => ['privates', 'Zikula\\CategoriesModule\\Entity\\Repository\\CategoryRepository', 'getCategoryRepositoryService', true],
            'Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionDependencyRepository' => ['privates', 'Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionDependencyRepository', 'getExtensionDependencyRepositoryService', true],
            'Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionRepository' => ['services', 'Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionRepository', 'getExtensionRepositoryService', false],
            'Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionVarRepository' => ['privates', 'Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionVarRepository', 'getExtensionVarRepositoryService', false],
            'Zikula\\GroupsModule\\Entity\\Repository\\GroupApplicationRepository' => ['privates', 'Zikula\\GroupsModule\\Entity\\Repository\\GroupApplicationRepository', 'getGroupApplicationRepositoryService', true],
            'Zikula\\GroupsModule\\Entity\\Repository\\GroupRepository' => ['services', 'Zikula\\GroupsModule\\Entity\\Repository\\GroupRepository', 'getGroupRepositoryService', true],
            'Zikula\\MenuModule\\Entity\\Repository\\MenuItemRepository' => ['privates', 'Zikula\\MenuModule\\Entity\\Repository\\MenuItemRepository', 'getMenuItemRepositoryService', true],
            'Zikula\\PermissionsModule\\Entity\\Repository\\PermissionRepository' => ['privates', 'Zikula\\PermissionsModule\\Entity\\Repository\\PermissionRepository', 'getPermissionRepositoryService', false],
            'Zikula\\SearchModule\\Entity\\Repository\\SearchResultRepository' => ['privates', 'Zikula\\SearchModule\\Entity\\Repository\\SearchResultRepository', 'getSearchResultRepositoryService', true],
            'Zikula\\SearchModule\\Entity\\Repository\\SearchStatRepository' => ['privates', 'Zikula\\SearchModule\\Entity\\Repository\\SearchStatRepository', 'getSearchStatRepositoryService', true],
            'Zikula\\SecurityCenterModule\\Entity\\Repository\\IntrusionRepository' => ['privates', 'Zikula\\SecurityCenterModule\\Entity\\Repository\\IntrusionRepository', 'getIntrusionRepositoryService', true],
            'Zikula\\UsersModule\\Entity\\Repository\\UserAttributeRepository' => ['privates', 'Zikula\\UsersModule\\Entity\\Repository\\UserAttributeRepository', 'getUserAttributeRepositoryService', true],
            'Zikula\\UsersModule\\Entity\\Repository\\UserRepository' => ['privates', 'Zikula\\UsersModule\\Entity\\Repository\\UserRepository', 'getUserRepositoryService', false],
            'Zikula\\UsersModule\\Entity\\Repository\\UserSessionRepository' => ['privates', 'Zikula\\UsersModule\\Entity\\Repository\\UserSessionRepository', 'getUserSessionRepositoryService', false],
            'Zikula\\ZAuthModule\\Entity\\Repository\\AuthenticationMappingRepository' => ['privates', 'Zikula\\ZAuthModule\\Entity\\Repository\\AuthenticationMappingRepository', 'getAuthenticationMappingRepositoryService', true],
            'Zikula\\ZAuthModule\\Entity\\Repository\\UserVerificationRepository' => ['privates', 'Zikula\\ZAuthModule\\Entity\\Repository\\UserVerificationRepository', 'getUserVerificationRepositoryService', true],
        ], [
            'Zikula\\AdminModule\\Entity\\Repository\\AdminCategoryRepository' => '?',
            'Zikula\\AdminModule\\Entity\\Repository\\AdminModuleRepository' => '?',
            'Zikula\\BlocksModule\\Entity\\Repository\\BlockPositionRepository' => '?',
            'Zikula\\BlocksModule\\Entity\\Repository\\BlockRepository' => '?',
            'Zikula\\Bundle\\HookBundle\\Repository\\HookBindingRepository' => '?',
            'Zikula\\Bundle\\HookBundle\\Repository\\HookRuntimeRepository' => '?',
            'Zikula\\CategoriesModule\\Entity\\Repository\\CategoryRegistryRepository' => '?',
            'Zikula\\CategoriesModule\\Entity\\Repository\\CategoryRepository' => '?',
            'Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionDependencyRepository' => '?',
            'Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionRepository' => '?',
            'Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionVarRepository' => '?',
            'Zikula\\GroupsModule\\Entity\\Repository\\GroupApplicationRepository' => '?',
            'Zikula\\GroupsModule\\Entity\\Repository\\GroupRepository' => '?',
            'Zikula\\MenuModule\\Entity\\Repository\\MenuItemRepository' => '?',
            'Zikula\\PermissionsModule\\Entity\\Repository\\PermissionRepository' => '?',
            'Zikula\\SearchModule\\Entity\\Repository\\SearchResultRepository' => '?',
            'Zikula\\SearchModule\\Entity\\Repository\\SearchStatRepository' => '?',
            'Zikula\\SecurityCenterModule\\Entity\\Repository\\IntrusionRepository' => '?',
            'Zikula\\UsersModule\\Entity\\Repository\\UserAttributeRepository' => '?',
            'Zikula\\UsersModule\\Entity\\Repository\\UserRepository' => '?',
            'Zikula\\UsersModule\\Entity\\Repository\\UserSessionRepository' => '?',
            'Zikula\\ZAuthModule\\Entity\\Repository\\AuthenticationMappingRepository' => '?',
            'Zikula\\ZAuthModule\\Entity\\Repository\\UserVerificationRepository' => '?',
        ])));

        $this->services['doctrine.orm.default_entity_manager'] = $instance = \Doctrine\ORM\EntityManager::create(($this->services['doctrine.dbal.default_connection'] ?? $this->getDoctrine_Dbal_DefaultConnectionService()), $a);

        (new \Doctrine\Bundle\DoctrineBundle\ManagerConfigurator([], []))->configure($instance);

        return $instance;
    }

    /*
     * Gets the public 'event_dispatcher' shared service.
     *
     * @return \Symfony\Component\EventDispatcher\EventDispatcher
     */
    protected function getEventDispatcherService()
    {
        $this->services['event_dispatcher'] = $instance = new \Symfony\Component\EventDispatcher\EventDispatcher();

        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['data_collector.router'] ?? ($this->privates['data_collector.router'] = new \Symfony\Bundle\FrameworkBundle\DataCollector\RouterDataCollector()));
        }, 1 => 'onKernelController'], 0);
        $instance->addListener('console.command', [0 => function () {
            return ($this->services['matthias_symfony_console_form.handle_form_based_command_event_listener'] ?? $this->load('getMatthiasSymfonyConsoleForm_HandleFormBasedCommandEventListenerService'));
        }, 1 => 'onConsoleCommand'], 200);
        $instance->addListener('console.command', [0 => function () {
            return ($this->services['matthias_symfony_console_form.set_input_definition_of_form_based_command_event_listener'] ?? $this->load('getMatthiasSymfonyConsoleForm_SetInputDefinitionOfFormBasedCommandEventListenerService'));
        }, 1 => 'onConsoleCommand'], 2000);
        $instance->addListener('console.command', [0 => function () {
            return ($this->services['matthias_symfony_console.register_styles_event_listener'] ?? $this->load('getMatthiasSymfonyConsole_RegisterStylesEventListenerService'));
        }, 1 => 'onConsoleCommand'], 1000);
        $instance->addListener('console.command', [0 => function () {
            return ($this->services['matthias_symfony_console_form.register_helpers_event_listener'] ?? $this->load('getMatthiasSymfonyConsoleForm_RegisterHelpersEventListenerService'));
        }, 1 => 'onConsoleCommand'], 1000);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Translation\\Bundle\\EventListener\\EditInPlaceResponseListener'] ?? $this->getEditInPlaceResponseListenerService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['response_listener'] ?? ($this->privates['response_listener'] = new \Symfony\Component\HttpKernel\EventListener\ResponseListener('UTF-8')));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['streamed_response_listener'] ?? ($this->privates['streamed_response_listener'] = new \Symfony\Component\HttpKernel\EventListener\StreamedResponseListener()));
        }, 1 => 'onKernelResponse'], -1024);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListener2Service());
        }, 1 => 'setDefaultLocale'], 100);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListener2Service());
        }, 1 => 'onKernelRequest'], 16);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListener2Service());
        }, 1 => 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['validate_request_listener'] ?? ($this->privates['validate_request_listener'] = new \Symfony\Component\HttpKernel\EventListener\ValidateRequestListener()));
        }, 1 => 'onKernelRequest'], 256);
        $instance->addListener('kernel.controller_arguments', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListener2Service());
        }, 1 => 'onControllerArguments'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListener2Service());
        }, 1 => 'logKernelException'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListener2Service());
        }, 1 => 'onKernelException'], -128);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListener2Service());
        }, 1 => 'removeCspHeader'], -128);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_aware_listener'] ?? $this->getLocaleAwareListenerService());
        }, 1 => 'onKernelRequest'], 15);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['locale_aware_listener'] ?? $this->getLocaleAwareListenerService());
        }, 1 => 'onKernelFinishRequest'], -15);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['console.error_listener'] ?? $this->load('getConsole_ErrorListenerService'));
        }, 1 => 'onConsoleError'], -128);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['console.error_listener'] ?? $this->load('getConsole_ErrorListenerService'));
        }, 1 => 'onConsoleTerminate'], -128);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['console.suggest_missing_package_subscriber'] ?? ($this->privates['console.suggest_missing_package_subscriber'] = new \Symfony\Bundle\FrameworkBundle\EventListener\SuggestMissingPackageSubscriber()));
        }, 1 => 'onConsoleError'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onKernelRequest'], 128);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onKernelResponse'], -1000);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onFinishRequest'], 0);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [0 => function () {
            return ($this->privates['mailer.envelope_listener'] ?? ($this->privates['mailer.envelope_listener'] = new \Symfony\Component\Mailer\EventListener\EnvelopeListener(NULL, NULL)));
        }, 1 => 'onMessage'], -255);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [0 => function () {
            return ($this->privates['mailer.logger_message_listener'] ?? ($this->privates['mailer.logger_message_listener'] = new \Symfony\Component\Mailer\EventListener\MessageLoggerListener()));
        }, 1 => 'onMessage'], -255);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['profiler_listener'] ?? $this->getProfilerListenerService());
        }, 1 => 'onKernelResponse'], -100);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['profiler_listener'] ?? $this->getProfilerListenerService());
        }, 1 => 'onKernelException'], 0);
        $instance->addListener('kernel.terminate', [0 => function () {
            return ($this->privates['profiler_listener'] ?? $this->getProfilerListenerService());
        }, 1 => 'onKernelTerminate'], -1024);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['data_collector.request'] ?? ($this->privates['data_collector.request'] = new \Symfony\Component\HttpKernel\DataCollector\RequestDataCollector()));
        }, 1 => 'onKernelController'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['data_collector.request'] ?? ($this->privates['data_collector.request'] = new \Symfony\Component\HttpKernel\DataCollector\RequestDataCollector()));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['debug.debug_handlers_listener'] ?? $this->getDebug_DebugHandlersListenerService());
        }, 1 => 'configure'], 2048);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['debug.debug_handlers_listener'] ?? $this->getDebug_DebugHandlersListenerService());
        }, 1 => 'configure'], 2048);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['router_listener'] ?? $this->getRouterListenerService());
        }, 1 => 'onKernelRequest'], 32);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['router_listener'] ?? $this->getRouterListenerService());
        }, 1 => 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['router_listener'] ?? $this->getRouterListenerService());
        }, 1 => 'onKernelException'], -64);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['security.firewall'] ?? $this->getSecurity_FirewallService());
        }, 1 => 'configureLogoutUrlGenerator'], 8);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['security.firewall'] ?? $this->getSecurity_FirewallService());
        }, 1 => 'onKernelRequest'], 8);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['security.firewall'] ?? $this->getSecurity_FirewallService());
        }, 1 => 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['security.rememberme.response_listener'] ?? ($this->privates['security.rememberme.response_listener'] = new \Symfony\Component\Security\Http\RememberMe\ResponseListener()));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [0 => function () {
            return ($this->privates['twig.mailer.message_listener'] ?? $this->load('getTwig_Mailer_MessageListenerService'));
        }, 1 => 'onMessage'], 0);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService());
        }, 1 => 'onCommand'], 255);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService());
        }, 1 => 'onTerminate'], -255);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageHandledEvent', [0 => function () {
            return ($this->privates['doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager'] ?? $this->load('getDoctrine_Orm_Messenger_EventSubscriber_DoctrineClearEntityManagerService'));
        }, 1 => 'onWorkerMessageHandled'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [0 => function () {
            return ($this->privates['doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager'] ?? $this->load('getDoctrine_Orm_Messenger_EventSubscriber_DoctrineClearEntityManagerService'));
        }, 1 => 'onWorkerMessageFailed'], 0);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['sensio_framework_extra.controller.listener'] ?? $this->getSensioFrameworkExtra_Controller_ListenerService());
        }, 1 => 'onKernelController'], 0);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['sensio_framework_extra.converter.listener'] ?? $this->getSensioFrameworkExtra_Converter_ListenerService());
        }, 1 => 'onKernelController'], 0);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['sensio_framework_extra.view.listener'] ?? $this->getSensioFrameworkExtra_View_ListenerService());
        }, 1 => 'onKernelController'], -128);
        $instance->addListener('kernel.view', [0 => function () {
            return ($this->privates['sensio_framework_extra.view.listener'] ?? $this->getSensioFrameworkExtra_View_ListenerService());
        }, 1 => 'onKernelView'], 0);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['sensio_framework_extra.cache.listener'] ?? ($this->privates['sensio_framework_extra.cache.listener'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\HttpCacheListener()));
        }, 1 => 'onKernelController'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['sensio_framework_extra.cache.listener'] ?? ($this->privates['sensio_framework_extra.cache.listener'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\HttpCacheListener()));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.controller_arguments', [0 => function () {
            return ($this->privates['sensio_framework_extra.security.listener'] ?? $this->getSensioFrameworkExtra_Security_ListenerService());
        }, 1 => 'onKernelControllerArguments'], 0);
        $instance->addListener('kernel.controller_arguments', [0 => function () {
            return ($this->privates['framework_extra_bundle.event.is_granted'] ?? $this->getFrameworkExtraBundle_Event_IsGrantedService());
        }, 1 => 'onKernelControllerArguments'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['stof_doctrine_extensions.event_listener.locale'] ?? $this->getStofDoctrineExtensions_EventListener_LocaleService());
        }, 1 => 'onKernelRequest'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['stof_doctrine_extensions.event_listener.blame'] ?? $this->getStofDoctrineExtensions_EventListener_BlameService());
        }, 1 => 'onKernelRequest'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['stof_doctrine_extensions.event_listener.logger'] ?? $this->getStofDoctrineExtensions_EventListener_LoggerService());
        }, 1 => 'onKernelRequest'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\BlameListener'] ?? $this->getBlameListenerService());
        }, 1 => 'onKernelRequest'], 0);
        $instance->addListener('kernel.terminate', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\CacheClearListener'] ?? $this->load('getCacheClearListenerService'));
        }, 1 => 'doClearCache'], -1000);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\ClickjackProtectionListener'] ?? ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\ClickjackProtectionListener'] = new \Zikula\Bundle\CoreBundle\EventListener\ClickjackProtectionListener('SAMEORIGIN')));
        }, 1 => 'onKernelResponse'], -99);
        $instance->addListener('Zikula\\Bundle\\CoreInstallerBundle\\Event\\CoreUpgradePreExtensionUpgrade', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\Core3UpgradeListener'] ?? $this->load('getCore3UpgradeListener2Service'));
        }, 1 => 'upgrade'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\DoctrineListener'] ?? $this->getDoctrineListenerService());
        }, 1 => 'setDefaultDriver'], 100);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\OutputCompressionListener'] ?? $this->getOutputCompressionListenerService());
        }, 1 => 'onKernelRequest'], 1023);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\SessionExpireListener'] ?? ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\SessionExpireListener'] = new \Zikula\Bundle\CoreBundle\EventListener\SessionExpireListener($this->getEnv('ZIKULA_INSTALLED'))));
        }, 1 => 'onKernelRequestSessionExpire'], 31);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\SiteOffListener'] ?? $this->getSiteOffListenerService());
        }, 1 => 'onKernelRequestSiteOff'], 110);
        $instance->addListener('Zikula\\UsersModule\\Event\\UserPreLoginSuccessEvent', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\SiteOffVetoLoginListener'] ?? $this->load('getSiteOffVetoLoginListenerService'));
        }, 1 => 'vetoNonAdminsOnSiteOff'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\StaleCacheExceptionListener'] ?? $this->load('getStaleCacheExceptionListenerService'));
        }, 1 => 'handleException'], 1000);
        $instance->addListener('Zikula\\Bundle\\CoreInstallerBundle\\Event\\CoreUpgradePreExtensionUpgrade', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreInstallerBundle\\EventListener\\Core3UpgradeListener'] ?? $this->load('getCore3UpgradeListener3Service'));
        }, 1 => 'resetExtensionVersions'], -10);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\CoreInstallerBundle\\EventListener\\InstallUpgradeCheckListener'] ?? $this->getInstallUpgradeCheckListenerService());
        }, 1 => 'onKernelRequest'], 2000);
        $instance->addListener('Zikula\\Bundle\\CoreInstallerBundle\\Event\\CoreInstallationPreExtensionInstallation', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\HookBundle\\Listener\\CoreInstallerListener'] ?? $this->load('getCoreInstallerListenerService'));
        }, 1 => 'installHookBundle'], 0);
        $instance->addListener('Zikula\\Bundle\\CoreInstallerBundle\\Event\\CoreUpgradePreExtensionUpgrade', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\HookBundle\\Listener\\CoreInstallerListener'] ?? $this->load('getCoreInstallerListenerService'));
        }, 1 => 'upgradeHookBundle'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\HookBundle\\Listener\\HookListenerBuilderListener'] ?? $this->getHookListenerBuilderListenerService());
        }, 1 => 'addListeners'], 1000);
        $instance->addListener('Zikula\\MenuModule\\ExtensionMenu\\ExtensionMenuEvent', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\HookBundle\\Listener\\HooksListener'] ?? $this->load('getHooksListenerService'));
        }, 1 => 'addHookMenu'], -254);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostRemoveEvent', [0 => function () {
            return ($this->privates['Zikula\\Bundle\\HookBundle\\Listener\\ModuleUninstallListener'] ?? $this->load('getModuleUninstallListenerService'));
        }, 1 => 'removeHooks'], 0);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['debug.dump_listener'] ?? $this->load('getDebug_DumpListenerService'));
        }, 1 => 'configure'], 1024);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['maker.console_error_listener'] ?? ($this->privates['maker.console_error_listener'] = new \Symfony\Bundle\MakerBundle\Event\ConsoleErrorSubscriber()));
        }, 1 => 'onConsoleError'], 0);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['maker.console_error_listener'] ?? ($this->privates['maker.console_error_listener'] = new \Symfony\Bundle\MakerBundle\Event\ConsoleErrorSubscriber()));
        }, 1 => 'onConsoleTerminate'], 0);
        $instance->addListener('Zikula\\Bundle\\CoreInstallerBundle\\Event\\CoreUpgradePreExtensionUpgrade', [0 => function () {
            return ($this->privates['Zikula\\AdminModule\\Listener\\Core3UpgradeListener'] ?? $this->load('getCore3UpgradeListenerService'));
        }, 1 => 'upgrade'], 0);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostInstallEvent', [0 => function () {
            return ($this->privates['Zikula\\AdminModule\\Listener\\ModuleEventListener'] ?? $this->load('getModuleEventListenerService'));
        }, 1 => 'moduleInstall'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\BlocksModule\\Listener\\CollapseableBlockListener'] ?? $this->getCollapseableBlockListenerService());
        }, 1 => 'addCollapseableBehavior'], 202);
        $instance->addListener('form.submit', [0 => function () {
            return ($this->privates['Zikula\\CategoriesModule\\Form\\EventListener\\CategoriesMergeCollectionListener'] ?? ($this->privates['Zikula\\CategoriesModule\\Form\\EventListener\\CategoriesMergeCollectionListener'] = new \Zikula\CategoriesModule\Form\EventListener\CategoriesMergeCollectionListener()));
        }, 1 => 'onBindNormData'], 0);
        $instance->addListener('Zikula\\Bundle\\CoreInstallerBundle\\Event\\CoreUpgradePreExtensionUpgrade', [0 => function () {
            return ($this->privates['Zikula\\CategoriesModule\\Listener\\Core3UpgradeListener'] ?? $this->load('getCore3UpgradeListener4Service'));
        }, 1 => 'upgrade'], 0);
        $instance->addListener('Zikula\\Bundle\\CoreInstallerBundle\\Event\\CoreUpgradePreExtensionUpgrade', [0 => function () {
            return ($this->privates['Zikula\\ExtensionsModule\\Listener\\Core3UpgradeListener'] ?? $this->load('getCore3UpgradeListener5Service'));
        }, 1 => 'upgrade'], 0);
        $instance->addListener('Zikula\\MenuModule\\ExtensionMenu\\ExtensionMenuEvent', [0 => function () {
            return ($this->privates['Zikula\\ExtensionsModule\\Listener\\ExtensionConnectionsListener'] ?? $this->load('getExtensionConnectionsListenerService'));
        }, 1 => 'addConnectionsMenu'], -256);
        $instance->addListener('Zikula\\MenuModule\\ExtensionMenu\\ExtensionMenuEvent', [0 => function () {
            return ($this->privates['Zikula\\ExtensionsModule\\Listener\\ExtensionHelpListener'] ?? $this->load('getExtensionHelpListenerService'));
        }, 1 => 'addHelpMenu'], -255);
        $instance->addListener('Zikula\\Bundle\\CoreInstallerBundle\\Event\\CoreUpgradePreExtensionUpgrade', [0 => function () {
            return ($this->privates['Zikula\\GroupsModule\\Listener\\Core3UpgradeListener'] ?? $this->load('getCore3UpgradeListener6Service'));
        }, 1 => 'upgrade'], 0);
        $instance->addListener('Zikula\\GroupsModule\\Event\\GroupApplicationPostProcessedEvent', [0 => function () {
            return ($this->privates['Zikula\\GroupsModule\\Listener\\GroupEventListener'] ?? $this->load('getGroupEventListenerService'));
        }, 1 => 'applicationProcessed'], 0);
        $instance->addListener('Zikula\\GroupsModule\\Event\\GroupApplicationPostCreatedEvent', [0 => function () {
            return ($this->privates['Zikula\\GroupsModule\\Listener\\GroupEventListener'] ?? $this->load('getGroupEventListenerService'));
        }, 1 => 'newApplication'], 0);
        $instance->addListener('form.pre_set_data', [0 => function () {
            return ($this->privates['Zikula\\MenuModule\\Form\\EventListener\\KeyValueFixerListener'] ?? ($this->privates['Zikula\\MenuModule\\Form\\EventListener\\KeyValueFixerListener'] = new \Zikula\MenuModule\Form\EventListener\KeyValueFixerListener()));
        }, 1 => 'onPreSetData'], 1);
        $instance->addListener('form.post_submit', [0 => function () {
            return ($this->privates['Zikula\\MenuModule\\Form\\EventListener\\OptionValidatorListener'] ?? $this->load('getOptionValidatorListenerService'));
        }, 1 => 'onPostSubmit'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['Zikula\\PermissionsModule\\Listener\\AccessDeniedExceptionListener'] ?? $this->load('getAccessDeniedExceptionListenerService'));
        }, 1 => 'onKernelException'], 31);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['Zikula\\PermissionsModule\\Listener\\ControllerPermissionCheckAnnotationReaderListener'] ?? $this->getControllerPermissionCheckAnnotationReaderListenerService());
        }, 1 => 'readControllerAnnotations'], 0);
        $instance->addListener('Zikula\\Bundle\\CoreInstallerBundle\\Event\\CoreUpgradePreExtensionUpgrade', [0 => function () {
            return ($this->privates['Zikula\\PermissionsModule\\Listener\\Core3UpgradeListener'] ?? $this->load('getCore3UpgradeListener7Service'));
        }, 1 => 'upgrade'], 0);
        $instance->addListener('Zikula\\GroupsModule\\Event\\GroupPreDeletedEvent', [0 => function () {
            return ($this->privates['Zikula\\PermissionsModule\\Listener\\GroupDeletionListener'] ?? $this->load('getGroupDeletionListenerService'));
        }, 1 => 'preDelete'], 5);
        $instance->addListener('Zikula\\Bundle\\FormExtensionBundle\\Event\\FormTypeChoiceEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\FormTypeChoicesListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\FormTypeChoicesListener'] = new \Zikula\RoutesModule\Listener\FormTypeChoicesListener()));
        }, 1 => 'formTypeChoices'], 0);
        $instance->addListener('Zikula\\GroupsModule\\Event\\GroupPostCreatedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] = new \Zikula\RoutesModule\Listener\GroupListener()));
        }, 1 => 'create'], 5);
        $instance->addListener('Zikula\\GroupsModule\\Event\\GroupPostUpdatedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] = new \Zikula\RoutesModule\Listener\GroupListener()));
        }, 1 => 'update'], 5);
        $instance->addListener('Zikula\\GroupsModule\\Event\\GroupPreDeletedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] = new \Zikula\RoutesModule\Listener\GroupListener()));
        }, 1 => 'preDelete'], 5);
        $instance->addListener('Zikula\\GroupsModule\\Event\\GroupPostDeletedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] = new \Zikula\RoutesModule\Listener\GroupListener()));
        }, 1 => 'delete'], 5);
        $instance->addListener('Zikula\\GroupsModule\\Event\\GroupPostUserAddedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] = new \Zikula\RoutesModule\Listener\GroupListener()));
        }, 1 => 'addUser'], 5);
        $instance->addListener('Zikula\\GroupsModule\\Event\\GroupPostUserRemovedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] = new \Zikula\RoutesModule\Listener\GroupListener()));
        }, 1 => 'removeUser'], 5);
        $instance->addListener('Zikula\\GroupsModule\\Event\\GroupApplicationPostProcessedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] = new \Zikula\RoutesModule\Listener\GroupListener()));
        }, 1 => 'applicationProcessed'], 5);
        $instance->addListener('Zikula\\GroupsModule\\Event\\GroupApplicationPostCreatedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\GroupListener'] = new \Zikula\RoutesModule\Listener\GroupListener()));
        }, 1 => 'newApplication'], 5);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostCacheRebuildEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\InstallerListener'] ?? $this->load('getInstallerListenerService'));
        }, 1 => 'extensionPostInstalled'], 5);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostUpgradeEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\InstallerListener'] ?? $this->load('getInstallerListenerService'));
        }, 1 => 'extensionUpgraded'], 5);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostRemoveEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\InstallerListener'] ?? $this->load('getInstallerListenerService'));
        }, 1 => 'extensionRemoved'], 5);
        $instance->addListener('Zikula\\RoutesModule\\Event\\RoutesNewlyAvailableEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\InstallerListener'] ?? $this->load('getInstallerListenerService'));
        }, 1 => 'newRoutesAvail'], 5);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] = new \Zikula\RoutesModule\Listener\KernelListener()));
        }, 1 => 'onRequest'], 5);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] = new \Zikula\RoutesModule\Listener\KernelListener()));
        }, 1 => 'onController'], 5);
        $instance->addListener('kernel.view', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] = new \Zikula\RoutesModule\Listener\KernelListener()));
        }, 1 => 'onView'], 5);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] = new \Zikula\RoutesModule\Listener\KernelListener()));
        }, 1 => 'onResponse'], 5);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] = new \Zikula\RoutesModule\Listener\KernelListener()));
        }, 1 => 'onFinishRequest'], 5);
        $instance->addListener('kernel.terminate', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] = new \Zikula\RoutesModule\Listener\KernelListener()));
        }, 1 => 'onTerminate'], 5);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\KernelListener'] = new \Zikula\RoutesModule\Listener\KernelListener()));
        }, 1 => 'onException'], 5);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\MailerListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\MailerListener'] = new \Zikula\RoutesModule\Listener\MailerListener()));
        }, 1 => 'onMessageSend'], 5);
        $instance->addListener('module_dispatch.service_links', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\ModuleDispatchListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\ModuleDispatchListener'] = new \Zikula\RoutesModule\Listener\ModuleDispatchListener()));
        }, 1 => 'serviceLinks'], 5);
        $instance->addListener('Zikula\\ThemeModule\\Bridge\\Event\\TwigPreRenderEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\ThemeListener'] ?? $this->getThemeListenerService());
        }, 1 => 'preRender'], 5);
        $instance->addListener('Zikula\\ThemeModule\\Bridge\\Event\\TwigPostRenderEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\ThemeListener'] ?? $this->getThemeListenerService());
        }, 1 => 'postRender'], 5);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\ThemeListener'] ?? $this->getThemeListenerService());
        }, 1 => 'injectDefaultAssetsIntoRawPage'], 1020);
        $instance->addListener('Zikula\\UsersModule\\Event\\ActiveUserPostCreatedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserListener'] ?? $this->load('getUserListenerService'));
        }, 1 => 'create'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\ActiveUserPostUpdatedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserListener'] ?? $this->load('getUserListenerService'));
        }, 1 => 'update'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\ActiveUserPostDeletedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserListener'] ?? $this->load('getUserListenerService'));
        }, 1 => 'delete'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\UserPreLoginSuccessEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserLoginListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\UserLoginListener'] = new \Zikula\RoutesModule\Listener\UserLoginListener()));
        }, 1 => 'veto'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\UserPostLoginSuccessEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserLoginListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\UserLoginListener'] = new \Zikula\RoutesModule\Listener\UserLoginListener()));
        }, 1 => 'succeeded'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\UserPostLoginFailureEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserLoginListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\UserLoginListener'] = new \Zikula\RoutesModule\Listener\UserLoginListener()));
        }, 1 => 'failed'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\UserPostLogoutSuccessEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserLogoutListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\UserLogoutListener'] = new \Zikula\RoutesModule\Listener\UserLogoutListener()));
        }, 1 => 'succeeded'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\ActiveUserPreCreatedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] = new \Zikula\RoutesModule\Listener\UserRegistrationListener()));
        }, 1 => 'createVeto'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\RegistrationPostSuccessEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] = new \Zikula\RoutesModule\Listener\UserRegistrationListener()));
        }, 1 => 'succeeded'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\RegistrationPostCreatedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] = new \Zikula\RoutesModule\Listener\UserRegistrationListener()));
        }, 1 => 'create'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\RegistrationPostUpdatedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] = new \Zikula\RoutesModule\Listener\UserRegistrationListener()));
        }, 1 => 'update'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\RegistrationPostDeletedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] = new \Zikula\RoutesModule\Listener\UserRegistrationListener()));
        }, 1 => 'delete'], 5);
        $instance->addListener('Zikula\\UsersModule\\Event\\RegistrationPostApprovedEvent', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] ?? ($this->privates['Zikula\\RoutesModule\\Listener\\UserRegistrationListener'] = new \Zikula\RoutesModule\Listener\UserRegistrationListener()));
        }, 1 => 'forceApproval'], 5);
        $instance->addListener('workflow.guard', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\WorkflowEventsListener'] ?? $this->load('getWorkflowEventsListenerService'));
        }, 1 => 'onGuard'], 5);
        $instance->addListener('workflow.leave', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\WorkflowEventsListener'] ?? $this->load('getWorkflowEventsListenerService'));
        }, 1 => 'onLeave'], 5);
        $instance->addListener('workflow.transition', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\WorkflowEventsListener'] ?? $this->load('getWorkflowEventsListenerService'));
        }, 1 => 'onTransition'], 5);
        $instance->addListener('workflow.enter', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\WorkflowEventsListener'] ?? $this->load('getWorkflowEventsListenerService'));
        }, 1 => 'onEnter'], 5);
        $instance->addListener('workflow.entered', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\WorkflowEventsListener'] ?? $this->load('getWorkflowEventsListenerService'));
        }, 1 => 'onEntered'], 5);
        $instance->addListener('workflow.completed', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\WorkflowEventsListener'] ?? $this->load('getWorkflowEventsListenerService'));
        }, 1 => 'onCompleted'], 5);
        $instance->addListener('workflow.announce', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Listener\\WorkflowEventsListener'] ?? $this->load('getWorkflowEventsListenerService'));
        }, 1 => 'onAnnounce'], 5);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['Zikula\\RoutesModule\\Translation\\ConsoleCommandListener'] ?? $this->load('getConsoleCommandListenerService'));
        }, 1 => 'checkBundleForTranslatingRoutes'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\SearchModule\\Listener\\FrontControllerListener'] ?? $this->getFrontControllerListenerService());
        }, 1 => 'pageLoad'], 40);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostInstallEvent', [0 => function () {
            return ($this->privates['Zikula\\SearchModule\\Listener\\ModuleEventListener'] ?? $this->load('getModuleEventListener2Service'));
        }, 1 => 'extensionEnable'], 0);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostEnabledEvent', [0 => function () {
            return ($this->privates['Zikula\\SearchModule\\Listener\\ModuleEventListener'] ?? $this->load('getModuleEventListener2Service'));
        }, 1 => 'extensionEnable'], 0);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostDisabledEvent', [0 => function () {
            return ($this->privates['Zikula\\SearchModule\\Listener\\ModuleEventListener'] ?? $this->load('getModuleEventListener2Service'));
        }, 1 => 'extensionDisable'], 0);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostRemoveEvent', [0 => function () {
            return ($this->privates['Zikula\\SearchModule\\Listener\\ModuleEventListener'] ?? $this->load('getModuleEventListener2Service'));
        }, 1 => 'extensionRemove'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\SecurityCenterModule\\Listener\\FilterListener'] ?? $this->getFilterListenerService());
        }, 1 => 'idsInputFilter'], 100);
        $instance->addListener('Zikula\\SecurityCenterModule\\Event\\FilterHtmlEvent', [0 => function () {
            return ($this->privates['Zikula\\SecurityCenterModule\\Listener\\PurifierListener'] ?? $this->load('getPurifierListenerService'));
        }, 1 => 'purify'], 0);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostCacheRebuildEvent', [0 => function () {
            return ($this->privates['Zikula\\SettingsModule\\Listener\\ExtensionInstallerListener'] ?? $this->load('getExtensionInstallerListenerService'));
        }, 1 => 'updateTranslationConfig'], 5);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostUpgradeEvent', [0 => function () {
            return ($this->privates['Zikula\\SettingsModule\\Listener\\ExtensionInstallerListener'] ?? $this->load('getExtensionInstallerListenerService'));
        }, 1 => 'updateTranslationConfig'], 5);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostEnabledEvent', [0 => function () {
            return ($this->privates['Zikula\\SettingsModule\\Listener\\ExtensionInstallerListener'] ?? $this->load('getExtensionInstallerListenerService'));
        }, 1 => 'updateTranslationConfig'], 5);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostDisabledEvent', [0 => function () {
            return ($this->privates['Zikula\\SettingsModule\\Listener\\ExtensionInstallerListener'] ?? $this->load('getExtensionInstallerListenerService'));
        }, 1 => 'updateTranslationConfig'], 5);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostRemoveEvent', [0 => function () {
            return ($this->privates['Zikula\\SettingsModule\\Listener\\ExtensionInstallerListener'] ?? $this->load('getExtensionInstallerListenerService'));
        }, 1 => 'updateTranslationConfig'], 5);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\SettingsModule\\Listener\\LocaleListener'] ?? $this->getLocaleListenerService());
        }, 1 => 'onKernelRequest'], 15);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\SettingsModule\\Listener\\LocalizedVariableListener'] ?? $this->getLocalizedVariableListenerService());
        }, 1 => 'onKernelRequest'], 14);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostDisabledEvent', [0 => function () {
            return ($this->privates['Zikula\\SettingsModule\\Listener\\ModuleListener'] ?? $this->load('getModuleListenerService'));
        }, 1 => 'extensionDeactivated'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\SettingsModule\\Listener\\TranslationUiListener'] ?? $this->getTranslationUiListenerService());
        }, 1 => 'onKernelRequest'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\SettingsModule\\Listener\\TranslationUiListener'] ?? $this->getTranslationUiListenerService());
        }, 1 => 'addDummyClosingBody'], 5);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\SettingsModule\\Listener\\TranslationUiListener'] ?? $this->getTranslationUiListenerService());
        }, 1 => 'removeDummyClosingBody'], -1);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\AddJSConfigListener'] ?? $this->getAddJSConfigListenerService());
        }, 1 => 'addJSConfig'], -1);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\AddThemePathsToLoaderListener'] ?? $this->getAddThemePathsToLoaderListenerService());
        }, 1 => 'addThemePaths'], 2056);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\ControllerAnnotationReaderListener'] ?? $this->getControllerAnnotationReaderListenerService());
        }, 1 => 'readControllerAnnotations'], 0);
        $instance->addListener('Zikula\\Bundle\\CoreInstallerBundle\\Event\\CoreUpgradePreExtensionUpgrade', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\Core3UpgradeListener'] ?? $this->load('getCore3UpgradeListener8Service'));
        }, 1 => 'upgrade'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\CreateThemedResponseListener'] ?? $this->getCreateThemedResponseListenerService());
        }, 1 => 'createThemedResponse'], -2);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\DefaultPageAssetSetterListener'] ?? $this->getDefaultPageAssetSetterListenerService());
        }, 1 => 'setDefaultPageAssets'], 1028);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\DefaultPageVarSetterListener'] ?? $this->getDefaultPageVarSetterListenerService());
        }, 1 => 'setDefaultPageVars'], 1028);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\ExceptionListener'] ?? $this->load('getExceptionListenerService'));
        }, 1 => 'onKernelException'], 30);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostInstallEvent', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\ExtensionInstallationListener'] ?? $this->load('getExtensionInstallationListenerService'));
        }, 1 => 'clearCombinedAssetCache'], 0);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostInstallEvent', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\ExtensionInstallationListener'] ?? $this->load('getExtensionInstallationListenerService'));
        }, 1 => 'copyAssets'], 0);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostUpgradeEvent', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\ExtensionInstallationListener'] ?? $this->load('getExtensionInstallationListenerService'));
        }, 1 => 'clearCombinedAssetCache'], 0);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostUpgradeEvent', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\ExtensionInstallationListener'] ?? $this->load('getExtensionInstallationListenerService'));
        }, 1 => 'copyAssets'], 0);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostEnabledEvent', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\ExtensionInstallationListener'] ?? $this->load('getExtensionInstallationListenerService'));
        }, 1 => 'clearCombinedAssetCache'], 0);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostDisabledEvent', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\ExtensionInstallationListener'] ?? $this->load('getExtensionInstallationListenerService'));
        }, 1 => 'clearCombinedAssetCache'], 0);
        $instance->addListener('Zikula\\ExtensionsModule\\Event\\ExtensionPostRemoveEvent', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\ExtensionInstallationListener'] ?? $this->load('getExtensionInstallationListenerService'));
        }, 1 => 'clearPublishedAssets'], 0);
        $instance->addListener('Zikula\\Bundle\\HookBundle\\Event\\HookPostChangeEvent', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\HookChangeListener'] ?? $this->load('getHookChangeListenerService'));
        }, 1 => 'clearCombinedAssetCache'], 0);
        $instance->addListener('kernel.controller', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\ModuleStylesheetInsertListener'] ?? ($this->privates['Zikula\\ThemeModule\\EventListener\\ModuleStylesheetInsertListener'] = new \Zikula\ThemeModule\EventListener\ModuleStylesheetInsertListener(($this->services['kernel'] ?? $this->get('kernel', 1)))));
        }, 1 => 'insertModuleStylesheet'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\ThemeModule\\EventListener\\ResponseTransformerListener'] ?? $this->getResponseTransformerListenerService());
        }, 1 => 'transformResponse'], -3);
        $instance->addListener('Zikula\\BlocksModule\\Event\\PendingContentEvent', [0 => function () {
            return ($this->privates['Zikula\\UsersModule\\Listener\\PendingContentListener'] ?? $this->load('getPendingContentListenerService'));
        }, 1 => 'pendingContent'], 0);
        $instance->addListener('Zikula\\UsersModule\\Event\\RegistrationPostSuccessEvent', [0 => function () {
            return ($this->privates['Zikula\\UsersModule\\Listener\\RegistrationEventsListener'] ?? $this->load('getRegistrationEventsListenerService'));
        }, 1 => 'sendRegistrationEmail'], 0);
        $instance->addListener('Zikula\\UsersModule\\Event\\UserPostLogoutSuccessEvent', [0 => function () {
            return ($this->privates['Zikula\\UsersModule\\Listener\\UserEventListener'] ?? $this->load('getUserEventListenerService'));
        }, 1 => 'clearUsersNamespace'], 0);
        $instance->addListener('Zikula\\UsersModule\\Event\\UserPostLoginSuccessEvent', [0 => function () {
            return ($this->privates['Zikula\\UsersModule\\Listener\\UserEventListener'] ?? $this->load('getUserEventListenerService'));
        }, 1 => 'setLocale'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['Zikula\\UsersModule\\Listener\\UserEventListener'] ?? $this->load('getUserEventListenerService'));
        }, 1 => 'clearUsersNamespace'], 0);
        $instance->addListener('Zikula\\UsersModule\\Event\\ActiveUserPostDeletedEvent', [0 => function () {
            return ($this->privates['Zikula\\UsersModule\\Listener\\UserEventListener'] ?? $this->load('getUserEventListenerService'));
        }, 1 => 'updateIllegalNames'], 0);
        $instance->addListener('kernel.terminate', [0 => function () {
            return ($this->privates['Zikula\\ZAuthModule\\Listener\\DeletePendingRegistrationsListener'] ?? $this->load('getDeletePendingRegistrationsListenerService'));
        }, 1 => 'delete'], 0);
        $instance->addListener('Zikula\\UsersModule\\Event\\RegistrationPostDeletedEvent', [0 => function () {
            return ($this->privates['Zikula\\ZAuthModule\\Listener\\DeletePendingRegistrationsListener'] ?? $this->load('getDeletePendingRegistrationsListenerService'));
        }, 1 => 'sendEmail'], 0);
        $instance->addListener('Zikula\\UsersModule\\Event\\ActiveUserPreCreatedEvent', [0 => function () {
            return ($this->privates['Zikula\\ZAuthModule\\Listener\\RegistrationListener'] ?? $this->load('getRegistrationListenerService'));
        }, 1 => 'vetoFullUserCreate'], 0);
        $instance->addListener('Zikula\\UsersModule\\Event\\RegistrationPostSuccessEvent', [0 => function () {
            return ($this->privates['Zikula\\ZAuthModule\\Listener\\RegistrationListener'] ?? $this->load('getRegistrationListenerService'));
        }, 1 => 'sendEmailVerificationEmail'], 0);
        $instance->addListener('Zikula\\UsersModule\\Event\\RegistrationPostApprovedEvent', [0 => function () {
            return ($this->privates['Zikula\\ZAuthModule\\Listener\\RegistrationListener'] ?? $this->load('getRegistrationListenerService'));
        }, 1 => 'forceRegistrationApproval'], 0);
        $instance->addListener('Zikula\\UsersModule\\Event\\ActiveUserPostDeletedEvent', [0 => function () {
            return ($this->privates['Zikula\\ZAuthModule\\Listener\\UserDeleteListener'] ?? $this->load('getUserDeleteListenerService'));
        }, 1 => 'deleteUser'], 0);
        $instance->addListener('Zikula\\UsersModule\\Event\\RegistrationPostDeletedEvent', [0 => function () {
            return ($this->privates['Zikula\\ZAuthModule\\Listener\\UserDeleteListener'] ?? $this->load('getUserDeleteListenerService'));
        }, 1 => 'deleteUser'], 0);
        $instance->addListener('Zikula\\UsersModule\\Event\\UserPreLoginSuccessEvent', [0 => function () {
            return ($this->privates['Zikula\\ZAuthModule\\Listener\\UserEventListener'] ?? $this->load('getUserEventListener2Service'));
        }, 1 => 'forcedPasswordChange'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['Zikula\\BootstrapTheme\\Listener\\BootstrapAssetSetterListener'] ?? $this->getBootstrapAssetSetterListenerService());
        }, 1 => 'setBootstrap'], 300);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [0 => function () {
            return ($this->privates['security.logout.listener.csrf_token_clearing'] ?? $this->load('getSecurity_Logout_Listener_CsrfTokenClearingService'));
        }, 1 => 'onLogout'], 0);

        return $instance;
    }

    /*
     * Gets the public 'filesystem' shared service.
     *
     * @return \Symfony\Component\Filesystem\Filesystem
     */
    protected function getFilesystemService()
    {
        return $this->services['filesystem'] = new \Symfony\Component\Filesystem\Filesystem();
    }

    /*
     * Gets the public 'fos_js_routing.extractor' shared service.
     *
     * @return \FOS\JsRoutingBundle\Extractor\ExposedRoutesExtractor
     */
    protected function getFosJsRouting_ExtractorService()
    {
        return $this->services['fos_js_routing.extractor'] = new \FOS\JsRoutingBundle\Extractor\ExposedRoutesExtractor(($this->services['router'] ?? $this->getRouterService()), [], $this->targetDir.'', $this->parameters['kernel.bundles']);
    }

    /*
     * Gets the public 'http_kernel' shared service.
     *
     * @return \Symfony\Component\HttpKernel\HttpKernel
     */
    protected function getHttpKernelService()
    {
        return $this->services['http_kernel'] = new \Symfony\Component\HttpKernel\HttpKernel(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), new \Symfony\Bundle\FrameworkBundle\Controller\ControllerResolver($this, ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService())), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), new \Symfony\Component\HttpKernel\Controller\ArgumentResolver(($this->privates['argument_metadata_factory'] ?? ($this->privates['argument_metadata_factory'] = new \Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadataFactory())), new RewindableGenerator(function () {
            yield 0 => ($this->privates['argument_resolver.request_attribute'] ?? ($this->privates['argument_resolver.request_attribute'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestAttributeValueResolver()));
            yield 1 => ($this->privates['argument_resolver.request'] ?? ($this->privates['argument_resolver.request'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestValueResolver()));
            yield 2 => ($this->privates['argument_resolver.session'] ?? ($this->privates['argument_resolver.session'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\SessionValueResolver()));
            yield 3 => ($this->privates['security.user_value_resolver'] ?? $this->load('getSecurity_UserValueResolverService'));
            yield 4 => ($this->privates['argument_resolver.service'] ?? $this->load('getArgumentResolver_ServiceService'));
            yield 5 => ($this->privates['argument_resolver.default'] ?? ($this->privates['argument_resolver.default'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\DefaultValueResolver()));
            yield 6 => ($this->privates['argument_resolver.variadic'] ?? ($this->privates['argument_resolver.variadic'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\VariadicValueResolver()));
        }, 7)));
    }

    /*
     * Gets the public 'knp_menu.matcher' shared service.
     *
     * @return \Knp\Menu\Matcher\Matcher
     */
    protected function getKnpMenu_MatcherService()
    {
        return $this->services['knp_menu.matcher'] = new \Knp\Menu\Matcher\Matcher(new RewindableGenerator(function () {
            yield 0 => ($this->privates['knp_menu.voter.router'] ?? $this->load('getKnpMenu_Voter_RouterService'));
            yield 1 => ($this->privates['Zikula\\MenuModule\\Voter\\RequestVoter'] ?? $this->load('getRequestVoterService'));
        }, 2));
    }

    /*
     * Gets the public 'liip_imagine.cache.manager' shared service.
     *
     * @return \Liip\ImagineBundle\Imagine\Cache\CacheManager
     */
    protected function getLiipImagine_Cache_ManagerService()
    {
        $this->services['liip_imagine.cache.manager'] = $instance = new \Liip\ImagineBundle\Imagine\Cache\CacheManager(($this->privates['liip_imagine.filter.configuration'] ?? $this->getLiipImagine_Filter_ConfigurationService()), ($this->services['router'] ?? $this->getRouterService()), ($this->services['liip_imagine.cache.signer'] ?? ($this->services['liip_imagine.cache.signer'] = new \Liip\ImagineBundle\Imagine\Cache\Signer($this->getEnv('APP_SECRET')))), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), 'default', false);

        $instance->addResolver('default', ($this->services['liip_imagine.cache.resolver.default'] ?? $this->getLiipImagine_Cache_Resolver_DefaultService()));
        $instance->addResolver('no_cache', ($this->services['liip_imagine.cache.resolver.no_cache_web_path'] ?? $this->getLiipImagine_Cache_Resolver_NoCacheWebPathService()));

        return $instance;
    }

    /*
     * Gets the public 'liip_imagine.cache.resolver.default' shared service.
     *
     * @return \Liip\ImagineBundle\Imagine\Cache\Resolver\WebPathResolver
     */
    protected function getLiipImagine_Cache_Resolver_DefaultService()
    {
        return $this->services['liip_imagine.cache.resolver.default'] = new \Liip\ImagineBundle\Imagine\Cache\Resolver\WebPathResolver(($this->services['filesystem'] ?? ($this->services['filesystem'] = new \Symfony\Component\Filesystem\Filesystem())), ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService()), (\dirname(__DIR__, 4).'/public'), 'media/cache');
    }

    /*
     * Gets the public 'liip_imagine.cache.resolver.no_cache_web_path' shared service.
     *
     * @return \Liip\ImagineBundle\Imagine\Cache\Resolver\NoCacheWebPathResolver
     */
    protected function getLiipImagine_Cache_Resolver_NoCacheWebPathService()
    {
        return $this->services['liip_imagine.cache.resolver.no_cache_web_path'] = new \Liip\ImagineBundle\Imagine\Cache\Resolver\NoCacheWebPathResolver(($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService()));
    }

    /*
     * Gets the public 'liip_imagine.cache.signer' shared service.
     *
     * @return \Liip\ImagineBundle\Imagine\Cache\Signer
     */
    protected function getLiipImagine_Cache_SignerService()
    {
        return $this->services['liip_imagine.cache.signer'] = new \Liip\ImagineBundle\Imagine\Cache\Signer($this->getEnv('APP_SECRET'));
    }

    /*
     * Gets the public 'monolog.logger.mail' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_Logger_MailService()
    {
        $this->services['monolog.logger.mail'] = $instance = new \Symfony\Bridge\Monolog\Logger('mail');

        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.mail'] ?? $this->getMonolog_Handler_MailService()));

        return $instance;
    }

    /*
     * Gets the public 'monolog.logger.zikula' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_Logger_ZikulaService()
    {
        $this->services['monolog.logger.zikula'] = $instance = new \Symfony\Bridge\Monolog\Logger('zikula');

        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        $instance->pushHandler(($this->privates['monolog.handler.zikula'] ?? $this->getMonolog_Handler_ZikulaService()));

        return $instance;
    }

    /*
     * Gets the public 'profiler' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Profiler\Profiler
     */
    protected function getProfilerService()
    {
        $a = new \Symfony\Bridge\Monolog\Logger('profiler');
        $a->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $a->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));

        $this->services['profiler'] = $instance = new \Symfony\Component\HttpKernel\Profiler\Profiler(new \Symfony\Component\HttpKernel\Profiler\FileProfilerStorage(('file:'.$this->targetDir.''.'/profiler')), $a, true);

        $b = ($this->services['kernel'] ?? $this->get('kernel'));
        $c = ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()));
        $d = ($this->services['translator'] ?? $this->getTranslatorService());
        $e = new \Symfony\Component\HttpKernel\DataCollector\ConfigDataCollector();
        if ($this->has('kernel')) {
            $e->setKernel($b);
        }

        $instance->add(($this->privates['data_collector.request'] ?? ($this->privates['data_collector.request'] = new \Symfony\Component\HttpKernel\DataCollector\RequestDataCollector())));
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\TimeDataCollector($b, ($this->privates['debug.stopwatch'] ?? ($this->privates['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true)))));
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\MemoryDataCollector());
        $instance->add(new \Symfony\Component\Validator\DataCollector\ValidatorDataCollector(($this->services['validator'] ?? $this->getValidatorService())));
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\AjaxDataCollector());
        $instance->add(($this->privates['data_collector.form'] ?? $this->getDataCollector_FormService()));
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\ExceptionDataCollector());
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\LoggerDataCollector($a, ($this->targetDir.''.'/KernelDevContainer'), $c));
        $instance->add(($this->privates['Zikula\\Bundle\\CoreBundle\\DataCollector\\ZikulaVersionDataCollector'] ?? $this->getZikulaVersionDataCollectorService()));
        $instance->add(new \Symfony\Component\HttpKernel\DataCollector\EventDataCollector(NULL, $c));
        $instance->add(($this->privates['data_collector.router'] ?? ($this->privates['data_collector.router'] = new \Symfony\Bundle\FrameworkBundle\DataCollector\RouterDataCollector())));
        $instance->add(($this->services['data_collector.cache'] ?? ($this->services['data_collector.cache'] = new \Symfony\Component\Cache\DataCollector\CacheDataCollector())));
        $instance->add(new \Symfony\Component\Translation\DataCollector\TranslationDataCollector($d));
        $instance->add(new \Symfony\Bundle\SecurityBundle\DataCollector\SecurityDataCollector(($this->privates['security.untracked_token_storage'] ?? ($this->privates['security.untracked_token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage())), ($this->privates['security.role_hierarchy'] ?? $this->getSecurity_RoleHierarchyService()), ($this->privates['security.logout_url_generator'] ?? $this->getSecurity_LogoutUrlGeneratorService()), ($this->privates['security.access.decision_manager'] ?? $this->getSecurity_Access_DecisionManagerService()), ($this->privates['security.firewall.map'] ?? $this->getSecurity_Firewall_MapService()), NULL));
        $instance->add(new \Oro\TwigInspector\DataCollector\TwigInspectorCollector());
        $instance->add(new \Symfony\Bridge\Twig\DataCollector\TwigDataCollector(new \Twig\Profiler\Profile(), ($this->services['twig'] ?? $this->getTwigService())));
        $instance->add(new \Doctrine\Bundle\DoctrineBundle\DataCollector\DoctrineDataCollector(($this->services['doctrine'] ?? $this->getDoctrineService()), true));
        $instance->add(($this->services['data_collector.dump'] ?? $this->getDataCollector_DumpService()));
        $instance->add(new \Symfony\Component\Translation\DataCollector\TranslationDataCollector($d));
        $instance->add(new \Symfony\Component\Mailer\DataCollector\MessageDataCollector(($this->privates['mailer.logger_message_listener'] ?? ($this->privates['mailer.logger_message_listener'] = new \Symfony\Component\Mailer\EventListener\MessageLoggerListener()))));
        $instance->add($e);

        return $instance;
    }

    /*
     * Gets the public 'request_stack' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestStack
     */
    protected function getRequestStackService()
    {
        return $this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack();
    }

    /*
     * Gets the public 'router' shared service.
     *
     * @return \JMS\I18nRoutingBundle\Router\I18nRouter
     */
    protected function getRouterService()
    {
        $a = new \Symfony\Bridge\Monolog\Logger('router');
        $a->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $a->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));

        $this->services['router'] = $instance = new \JMS\I18nRoutingBundle\Router\I18nRouter($this, 'kernel::loadRoutes', ['cache_dir' => $this->targetDir.'', 'debug' => false, 'generator_class' => 'Symfony\\Component\\Routing\\Generator\\CompiledUrlGenerator', 'generator_dumper_class' => 'Symfony\\Component\\Routing\\Generator\\Dumper\\CompiledUrlGeneratorDumper', 'matcher_class' => 'Symfony\\Bundle\\FrameworkBundle\\Routing\\RedirectableCompiledUrlMatcher', 'matcher_dumper_class' => 'Symfony\\Component\\Routing\\Matcher\\Dumper\\CompiledUrlMatcherDumper', 'strict_requirements' => true, 'resource_type' => 'service'], ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService()), ($this->privates['parameter_bag'] ?? ($this->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($this))), $a, 'en');

        $instance->setConfigCacheFactory(($this->privates['config_cache_factory'] ?? ($this->privates['config_cache_factory'] = new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory())));
        $instance->addExpressionLanguageProvider(($this->privates['router.expression_language_provider'] ?? $this->getRouter_ExpressionLanguageProviderService()));
        $instance->setLocaleResolver(new \JMS\I18nRoutingBundle\Router\DefaultLocaleResolver('hl'));
        $instance->setI18nLoaderId('jms_i18n_routing.loader');
        $instance->setDefaultLocale('en');
        $instance->setRedirectToHost(true);

        return $instance;
    }

    /*
     * Gets the public 'security.authorization_checker' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\AuthorizationChecker
     */
    protected function getSecurity_AuthorizationCheckerService()
    {
        return $this->services['security.authorization_checker'] = new \Symfony\Component\Security\Core\Authorization\AuthorizationChecker(($this->services['security.token_storage'] ?? $this->getSecurity_TokenStorageService()), ($this->privates['security.authentication.manager'] ?? $this->getSecurity_Authentication_ManagerService()), ($this->privates['security.access.decision_manager'] ?? $this->getSecurity_Access_DecisionManagerService()), false);
    }

    /*
     * Gets the public 'security.token_storage' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage
     */
    protected function getSecurity_TokenStorageService()
    {
        return $this->services['security.token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage(($this->privates['security.untracked_token_storage'] ?? ($this->privates['security.untracked_token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage())), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'session' => ['services', 'session', 'getSessionService', false],
        ], [
            'session' => '?',
        ]));
    }

    /*
     * Gets the public 'session' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\Session\Session
     */
    protected function getSessionService()
    {
        return $this->services['session'] = new \Symfony\Component\HttpFoundation\Session\Session(($this->privates['zikula_core.bridge.http_foundation.zikula_session_storage_file'] ?? $this->getZikulaCore_Bridge_HttpFoundation_ZikulaSessionStorageFileService()), NULL, NULL, [0 => ($this->privates['session_listener'] ?? $this->getSessionListenerService()), 1 => 'onSessionUsage']);
    }

    /*
     * Gets the public 'state_machine.zikularoutesmodule_none' shared service.
     *
     * @return \Symfony\Component\Workflow\StateMachine
     */
    protected function getStateMachine_ZikularoutesmoduleNoneService()
    {
        return $this->services['state_machine.zikularoutesmodule_none'] = new \Symfony\Component\Workflow\StateMachine(new \Symfony\Component\Workflow\Definition([0 => 'initial', 1 => 'approved', 2 => 'deleted'], [0 => new \Symfony\Component\Workflow\Transition('submit', 'initial', 'approved'), 1 => new \Symfony\Component\Workflow\Transition('update', 'approved', 'approved'), 2 => new \Symfony\Component\Workflow\Transition('delete', 'approved', 'deleted')], [], new \Symfony\Component\Workflow\Metadata\InMemoryMetadataStore([], [], new \SplObjectStorage())), new \Symfony\Component\Workflow\MarkingStore\MethodMarkingStore(true, 'workflowState'), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), 'zikularoutesmodule_none');
    }

    /*
     * Gets the public 'translator' shared service.
     *
     * @return \Symfony\Component\Translation\DataCollectorTranslator
     */
    protected function getTranslatorService()
    {
        return $this->services['translator'] = new \Symfony\Component\Translation\DataCollectorTranslator(($this->privates['translator.default'] ?? $this->getTranslator_DefaultService()));
    }

    /*
     * Gets the public 'twig' shared autowired service.
     *
     * @return \Zikula\ThemeModule\Bridge\Twig\EventEnabledTwigEngine
     */
    protected function getTwigService()
    {
        $this->services['twig'] = $instance = new \Zikula\ThemeModule\Bridge\Twig\EventEnabledTwigEngine(($this->privates['twig.loader.native_filesystem'] ?? $this->getTwig_Loader_NativeFilesystemService()));

        $a = ($this->services['translator'] ?? $this->getTranslatorService());
        $b = ($this->services['Translation\\Bundle\\EditInPlace\\Activator'] ?? $this->getActivatorService());
        $c = ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()));

        $d = new \Symfony\Bridge\Twig\Extension\TranslationExtension(new \Translation\Bundle\Translator\EditInPlaceTranslator($a, $b, $c));
        $e = ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService());
        $f = ($this->services['router'] ?? $this->getRouterService());
        $g = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());
        $h = new \Knp\Menu\Util\MenuManipulator();
        $i = ($this->services['knp_menu.matcher'] ?? $this->getKnpMenu_MatcherService());
        $j = new \Symfony\Component\VarDumper\Dumper\HtmlDumper(NULL, 'UTF-8', 1);
        $j->setDisplayOptions(['maxStringLength' => 4096, 'fileLinkFormat' => $e]);
        $k = ($this->privates['fragment.handler'] ?? $this->getFragment_HandlerService());
        $l = ($this->privates['Zikula\\PermissionsModule\\Api\\PermissionApi'] ?? $this->getPermissionApiService());
        $m = ($this->services['kernel'] ?? $this->get('kernel', 1));
        $n = ($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService());
        $o = new \Zikula\RoutesModule\Twig\TwigExtension($a, $n, ($this->privates['Zikula\\RoutesModule\\Helper\\EntityDisplayHelper'] ?? $this->getEntityDisplayHelperService()), ($this->privates['Zikula\\RoutesModule\\Helper\\WorkflowHelper'] ?? $this->getWorkflowHelperService()), ($this->privates['Zikula\\RoutesModule\\Helper\\ListEntriesHelper'] ?? $this->getListEntriesHelperService()));
        $o->setAdditionalDependencies($this, ($this->privates['Zikula\\SettingsModule\\Api\\LocaleApi'] ?? $this->getLocaleApiService()), ($this->privates['Zikula\\RoutesModule\\Helper\\PathBuilderHelper'] ?? $this->getPathBuilderHelperService()));
        $p = ($this->privates['Zikula\\Bundle\\CoreBundle\\Site\\SiteDefinition'] ?? $this->getSiteDefinitionService());
        $q = ($this->services['Zikula\\ThemeModule\\Engine\\Asset'] ?? $this->getAssetService());
        $r = ($this->privates['zikula_core.common.theme.pagevars'] ?? ($this->privates['zikula_core.common.theme.pagevars'] = new \Zikula\ThemeModule\Engine\ParameterBag()));
        $s = ($this->privates['Zikula\\UsersModule\\Entity\\Repository\\UserRepository'] ?? $this->getUserRepositoryService());
        $t = new \Symfony\Bridge\Twig\AppVariable();
        $t->setEnvironment('dev');
        $t->setDebug(false);
        if ($this->has('security.token_storage')) {
            $t->setTokenStorage(($this->services['security.token_storage'] ?? $this->getSecurity_TokenStorageService()));
        }
        if ($this->has('request_stack')) {
            $t->setRequestStack($c);
        }

        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\CsrfExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\LogoutUrlExtension(($this->privates['security.logout_url_generator'] ?? $this->getSecurity_LogoutUrlGeneratorService())));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\SecurityExtension(($this->services['security.authorization_checker'] ?? $this->getSecurity_AuthorizationCheckerService())));
        $instance->addExtension($d);
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\AssetExtension(($this->privates['assets.packages'] ?? $this->getAssets_PackagesService())));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\CodeExtension($e, \dirname(__DIR__, 4), 'UTF-8'));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\RoutingExtension($f));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\YamlExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\StopwatchExtension(($this->privates['debug.stopwatch'] ?? ($this->privates['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true))), false));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\ExpressionExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\HttpKernelExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\HttpFoundationExtension(new \Symfony\Component\HttpFoundation\UrlHelper($c, ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService()))));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\WorkflowExtension(($this->privates['workflow.registry'] ?? $this->getWorkflow_RegistryService())));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\FormExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\DumpExtension(($this->services['var_dumper.cloner'] ?? $this->getVarDumper_ClonerService()), ($this->privates['var_dumper.html_dumper'] ?? $this->getVarDumper_HtmlDumperService())));
        $instance->addExtension(new \Doctrine\Bundle\DoctrineBundle\Twig\DoctrineExtension());
        $instance->addExtension(new \Twig\Extra\Html\HtmlExtension());
        $instance->addExtension(new \Twig\Extra\Markdown\MarkdownExtension());
        $instance->addExtension(new \Twig\Extra\Intl\IntlExtension());
        $instance->addExtension(new \Twig\Extra\CssInliner\CssInlinerExtension());
        $instance->addExtension(new \Twig\Extra\Inky\InkyExtension());
        $instance->addExtension(new \Twig\Extra\String\StringExtension());
        $instance->addExtension(new \Zikula\Bundle\CoreBundle\Twig\Extension\CoreExtension($a));
        $instance->addExtension(new \Zikula\Bundle\CoreBundle\Twig\Extension\EventDispatcherExtension($g));
        $instance->addExtension(new \Zikula\Bundle\CoreBundle\Twig\Extension\SessionExtension(($this->services['session'] ?? $this->getSessionService()), $a));
        $instance->addExtension(new \Zikula\Bundle\HookBundle\Twig\Extension\HookExtension($c, ($this->privates['Zikula\\Bundle\\HookBundle\\Dispatcher\\HookDispatcher'] ?? $this->getHookDispatcherService())));
        $instance->addExtension(new \Knp\Menu\Twig\MenuExtension(new \Knp\Menu\Twig\Helper(new \Knp\Menu\Renderer\PsrProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'list' => ['privates', 'knp_menu.renderer.list', 'getKnpMenu_Renderer_ListService', true],
            'twig' => ['privates', 'knp_menu.renderer.twig', 'getKnpMenu_Renderer_TwigService', true],
        ], [
            'list' => '?',
            'twig' => '?',
        ]), 'twig', [], false), new \Knp\Menu\Provider\ChainProvider(new RewindableGenerator(function () {
            yield 0 => ($this->privates['knp_menu.menu_provider.lazy'] ?? $this->load('getKnpMenu_MenuProvider_LazyService'));
            yield 1 => ($this->privates['knp_menu.menu_provider.builder_alias'] ?? $this->load('getKnpMenu_MenuProvider_BuilderAliasService'));
            yield 2 => ($this->privates['Zikula\\MenuModule\\Provider\\DoctrineTreeProvider'] ?? $this->load('getDoctrineTreeProviderService'));
        }, 3)), $h, $i), $i, $h));
        $instance->addExtension(new \Liip\ImagineBundle\Templating\FilterExtension(($this->services['liip_imagine.cache.manager'] ?? $this->getLiipImagine_Cache_ManagerService())));
        $instance->addExtension(new \Translation\Bundle\Twig\TranslationExtension($a, false));
        $instance->addExtension(new \Translation\Bundle\Twig\EditInPlaceExtension($d, $c, $b));
        $instance->addExtension(new \Symfony\Bundle\WebProfilerBundle\Twig\WebProfilerExtension($j));
        $instance->addExtension(new \Oro\TwigInspector\Twig\TwigInspectorExtension());
        $instance->addExtension(new \Oro\TwigInspector\Twig\HtmlCommentsExtension($c, $f, new \Oro\TwigInspector\BoxDrawings()));
        $instance->addExtension(new \Zikula\AdminModule\Twig\Extension\AdminExtension($k, $l));
        $instance->addExtension(new \Zikula\BlocksModule\Twig\Extension\BlocksExtension(($this->privates['Zikula\\BlocksModule\\Api\\BlockApi'] ?? $this->getBlockApiService()), ($this->privates['Zikula\\BlocksModule\\Api\\BlockFilterApi'] ?? $this->getBlockFilterApiService()), ($this->privates['Zikula\\ThemeModule\\Engine\\Engine'] ?? $this->getEngineService()), $m));
        $instance->addExtension(new \Zikula\ExtensionsModule\Twig\Extension\DefaultPathExtension(($this->privates['Zikula\\ExtensionsModule\\Api\\CapabilityApi'] ?? $this->getCapabilityApiService()), $f));
        $instance->addExtension(new \Zikula\ExtensionsModule\Twig\Extension\ExtensionsExtension());
        $instance->addExtension(new \Zikula\ExtensionsModule\Twig\Extension\ModVarExtension($a, $n));
        $instance->addExtension(new \Zikula\ExtensionsModule\Twig\Extension\UserInterfaceExtension($k));
        $instance->addExtension(new \Zikula\PermissionsModule\Twig\Extension\PermissionsExtension($a, $l));
        $instance->addExtension($o);
        $instance->addExtension(new \Zikula\SearchModule\Twig\TwigExtension($n, $f));
        $instance->addExtension(new \Zikula\SecurityCenterModule\Twig\TwigExtension(new \Zikula\SecurityCenterModule\Api\HtmlFilterApi($n, $this->getEnv('ZIKULA_INSTALLED'), $g)));
        $instance->addExtension(new \Zikula\ThemeModule\Twig\Extension\BrandingExtension($instance, $p, $q));
        $instance->addExtension(new \Zikula\ThemeModule\Twig\Extension\PageVarExtension($a, $r));
        $instance->addExtension(new \Zikula\ThemeModule\Twig\Extension\ThemeExtension(($this->privates['Zikula\\ThemeModule\\Api\\PageAssetApi'] ?? $this->getPageAssetApiService()), $q));
        $instance->addExtension(new \Zikula\UsersModule\Twig\Extension\MessageExtension($s, ($this->privates['Zikula\\UsersModule\\Collector\\MessageModuleCollector'] ?? $this->getMessageModuleCollectorService()), $a));
        $instance->addExtension(new \Zikula\UsersModule\Twig\Extension\OnlineExtension(($this->privates['Zikula\\UsersModule\\Entity\\Repository\\UserSessionRepository'] ?? $this->getUserSessionRepositoryService()), $n));
        $instance->addExtension(new \Zikula\UsersModule\Twig\Extension\ProfileExtension($s, ($this->privates['Zikula\\UsersModule\\Collector\\ProfileModuleCollector'] ?? $this->getProfileModuleCollectorService()), $a));
        $instance->addExtension(new \Zikula\AtomTheme\Twig\AtomThemeExtension($n, $c, $p));
        $instance->addExtension(new \Zikula\BootstrapTheme\Twig\BootstrapThemeExtension($m));
        $instance->setEventDispatcher($g);
        $instance->addGlobal('app', $t);
        $instance->addGlobal('pagevars', $r);
        $instance->addGlobal('themevars', ($this->services['zikula_core.common.theme.themevars'] ?? ($this->services['zikula_core.common.theme.themevars'] = new \Zikula\ThemeModule\Engine\ParameterBag())));
        $instance->addGlobal('currentUser', ($this->services['Zikula\\UsersModule\\Api\\CurrentUserApi'] ?? $this->getCurrentUserApiService()));
        $instance->addRuntimeLoader(new \Twig\RuntimeLoader\ContainerRuntimeLoader(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'Symfony\\Bridge\\Twig\\Extension\\CsrfRuntime' => ['privates', 'twig.runtime.security_csrf', 'getTwig_Runtime_SecurityCsrfService', true],
            'Symfony\\Bridge\\Twig\\Extension\\HttpKernelRuntime' => ['privates', 'twig.runtime.httpkernel', 'getTwig_Runtime_HttpkernelService', true],
            'Symfony\\Component\\Form\\FormRenderer' => ['privates', 'twig.form.renderer', 'getTwig_Form_RendererService', true],
            'Twig\\Extra\\Markdown\\MarkdownRuntime' => ['privates', 'twig.runtime.markdown', 'getTwig_Runtime_MarkdownService', true],
        ], [
            'Symfony\\Bridge\\Twig\\Extension\\CsrfRuntime' => '?',
            'Symfony\\Bridge\\Twig\\Extension\\HttpKernelRuntime' => '?',
            'Symfony\\Component\\Form\\FormRenderer' => '?',
            'Twig\\Extra\\Markdown\\MarkdownRuntime' => '?',
        ])));
        (new \Symfony\Bundle\TwigBundle\DependencyInjection\Configurator\EnvironmentConfigurator('F j, Y H:i', '%d days', NULL, 0, '.', ','))->configure($instance);

        return $instance;
    }

    /*
     * Gets the public 'validator' shared service.
     *
     * @return \Symfony\Component\Validator\Validator\TraceableValidator
     */
    protected function getValidatorService()
    {
        return $this->services['validator'] = new \Symfony\Component\Validator\Validator\TraceableValidator(($this->privates['validator.builder'] ?? $this->getValidator_BuilderService())->getValidator());
    }

    /*
     * Gets the public 'var_dumper.cloner' shared service.
     *
     * @return \Symfony\Component\VarDumper\Cloner\VarCloner
     */
    protected function getVarDumper_ClonerService()
    {
        $this->services['var_dumper.cloner'] = $instance = new \Symfony\Component\VarDumper\Cloner\VarCloner();

        $instance->setMaxItems(2500);
        $instance->setMinDepth(1);
        $instance->setMaxString(-1);
        $instance->addCasters(['Closure' => 'Symfony\\Component\\VarDumper\\Caster\\ReflectionCaster::unsetClosureFileInfo']);

        return $instance;
    }

    /*
     * Gets the public 'zikula_core.common.theme.assets_css' shared autowired service.
     *
     * @return \Zikula\ThemeModule\Engine\AssetBag
     */
    protected function getZikulaCore_Common_Theme_AssetsCssService()
    {
        return $this->services['zikula_core.common.theme.assets_css'] = new \Zikula\ThemeModule\Engine\AssetBag();
    }

    /*
     * Gets the public 'zikula_core.common.theme.themevars' shared autowired service.
     *
     * @return \Zikula\ThemeModule\Engine\ParameterBag
     */
    protected function getZikulaCore_Common_Theme_ThemevarsService()
    {
        return $this->services['zikula_core.common.theme.themevars'] = new \Zikula\ThemeModule\Engine\ParameterBag();
    }

    /*
     * Gets the private 'Translation\Bundle\EventListener\EditInPlaceResponseListener' shared service.
     *
     * @return \Translation\Bundle\EventListener\EditInPlaceResponseListener
     */
    protected function getEditInPlaceResponseListenerService()
    {
        return $this->privates['Translation\\Bundle\\EventListener\\EditInPlaceResponseListener'] = new \Translation\Bundle\EventListener\EditInPlaceResponseListener(($this->services['Translation\\Bundle\\EditInPlace\\Activator'] ?? $this->getActivatorService()), ($this->services['router'] ?? $this->getRouterService()), ($this->privates['assets.packages'] ?? $this->getAssets_PackagesService()), 'zikula', true);
    }

    /*
     * Gets the private 'Zikula\BlocksModule\Api\BlockApi' shared autowired service.
     *
     * @return \Zikula\BlocksModule\Api\BlockApi
     */
    protected function getBlockApiService()
    {
        return $this->privates['Zikula\\BlocksModule\\Api\\BlockApi'] = new \Zikula\BlocksModule\Api\BlockApi(($this->privates['Zikula\\BlocksModule\\Entity\\Repository\\BlockPositionRepository'] ?? $this->getBlockPositionRepositoryService()), new \Zikula\BlocksModule\Api\BlockFactoryApi($this, ($this->services['translator'] ?? $this->getTranslatorService())), ($this->services['Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionRepository'] ?? $this->getExtensionRepositoryService()), new \Zikula\BlocksModule\Collector\BlockCollector(new RewindableGenerator(function () {
            yield 0 => (isset($this->factories['Zikula\\AdminModule\\Block\\AdminnavBlock']) ? $this->factories['Zikula\\AdminModule\\Block\\AdminnavBlock']() : $this->load('getAdminnavBlockService'));
            yield 1 => (isset($this->factories['Zikula\\BlocksModule\\Block\\FincludeBlock']) ? $this->factories['Zikula\\BlocksModule\\Block\\FincludeBlock']() : $this->load('getFincludeBlockService'));
            yield 2 => (isset($this->factories['Zikula\\BlocksModule\\Block\\HtmlBlock']) ? $this->factories['Zikula\\BlocksModule\\Block\\HtmlBlock']() : $this->load('getHtmlBlockService'));
            yield 3 => (isset($this->factories['Zikula\\BlocksModule\\Block\\PendingContentBlock']) ? $this->factories['Zikula\\BlocksModule\\Block\\PendingContentBlock']() : $this->load('getPendingContentBlockService'));
            yield 4 => (isset($this->factories['Zikula\\BlocksModule\\Block\\TextBlock']) ? $this->factories['Zikula\\BlocksModule\\Block\\TextBlock']() : $this->load('getTextBlockService'));
            yield 5 => (isset($this->factories['Zikula\\BlocksModule\\Block\\XsltBlock']) ? $this->factories['Zikula\\BlocksModule\\Block\\XsltBlock']() : $this->load('getXsltBlockService'));
            yield 6 => (isset($this->factories['Zikula\\MenuModule\\Block\\MenuBlock']) ? $this->factories['Zikula\\MenuModule\\Block\\MenuBlock']() : $this->load('getMenuBlockService'));
            yield 7 => (isset($this->factories['Zikula\\SearchModule\\Block\\SearchBlock']) ? $this->factories['Zikula\\SearchModule\\Block\\SearchBlock']() : $this->load('getSearchBlockService'));
            yield 8 => (isset($this->factories['Zikula\\SettingsModule\\Block\\LocaleBlock']) ? $this->factories['Zikula\\SettingsModule\\Block\\LocaleBlock']() : $this->load('getLocaleBlockService'));
            yield 9 => (isset($this->factories['Zikula\\UsersModule\\Block\\AccountLinksBlock']) ? $this->factories['Zikula\\UsersModule\\Block\\AccountLinksBlock']() : $this->load('getAccountLinksBlockService'));
            yield 10 => (isset($this->factories['Zikula\\UsersModule\\Block\\LoginBlock']) ? $this->factories['Zikula\\UsersModule\\Block\\LoginBlock']() : $this->load('getLoginBlockService'));
            yield 11 => (isset($this->factories['Zikula\\UsersModule\\Block\\OnlineBlock']) ? $this->factories['Zikula\\UsersModule\\Block\\OnlineBlock']() : $this->load('getOnlineBlockService'));
        }, 12)));
    }

    /*
     * Gets the private 'Zikula\BlocksModule\Api\BlockFilterApi' shared autowired service.
     *
     * @return \Zikula\BlocksModule\Api\BlockFilterApi
     */
    protected function getBlockFilterApiService()
    {
        return $this->privates['Zikula\\BlocksModule\\Api\\BlockFilterApi'] = new \Zikula\BlocksModule\Api\BlockFilterApi(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /*
     * Gets the private 'Zikula\BlocksModule\Entity\Repository\BlockPositionRepository' shared autowired service.
     *
     * @return \Zikula\BlocksModule\Entity\Repository\BlockPositionRepository
     */
    protected function getBlockPositionRepositoryService()
    {
        return $this->privates['Zikula\\BlocksModule\\Entity\\Repository\\BlockPositionRepository'] = new \Zikula\BlocksModule\Entity\Repository\BlockPositionRepository(($this->services['doctrine'] ?? $this->getDoctrineService()));
    }

    /*
     * Gets the private 'Zikula\BlocksModule\Listener\CollapseableBlockListener' shared autowired service.
     *
     * @return \Zikula\BlocksModule\Listener\CollapseableBlockListener
     */
    protected function getCollapseableBlockListenerService()
    {
        return $this->privates['Zikula\\BlocksModule\\Listener\\CollapseableBlockListener'] = new \Zikula\BlocksModule\Listener\CollapseableBlockListener(($this->privates['zikula_core.common.theme.assets_js'] ?? ($this->privates['zikula_core.common.theme.assets_js'] = new \Zikula\ThemeModule\Engine\AssetBag())), ($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), ($this->services['Zikula\\ThemeModule\\Engine\\Asset'] ?? $this->getAssetService()), $this->getEnv('ZIKULA_INSTALLED'), (($this->hasParameter("upgrading")) ? ($this->getParameter("upgrading")) : (false)));
    }

    /*
     * Gets the private 'Zikula\BootstrapTheme\Listener\BootstrapAssetSetterListener' shared autowired service.
     *
     * @return \Zikula\BootstrapTheme\Listener\BootstrapAssetSetterListener
     */
    protected function getBootstrapAssetSetterListenerService()
    {
        return $this->privates['Zikula\\BootstrapTheme\\Listener\\BootstrapAssetSetterListener'] = new \Zikula\BootstrapTheme\Listener\BootstrapAssetSetterListener(($this->services['zikula_core.common.theme.assets_css'] ?? ($this->services['zikula_core.common.theme.assets_css'] = new \Zikula\ThemeModule\Engine\AssetBag())), ($this->services['Zikula\\ThemeModule\\Engine\\Asset'] ?? $this->getAssetService()), ($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), ($this->privates['Zikula\\ThemeModule\\Engine\\Engine'] ?? $this->getEngineService()));
    }

    /*
     * Gets the private 'Zikula\Bundle\CoreBundle\CacheClearer' shared autowired service.
     *
     * @return \Zikula\Bundle\CoreBundle\CacheClearer
     */
    protected function getCacheClearer3Service()
    {
        return $this->privates['Zikula\\Bundle\\CoreBundle\\CacheClearer'] = new \Zikula\Bundle\CoreBundle\CacheClearer(($this->services['monolog.logger.zikula'] ?? $this->getMonolog_Logger_ZikulaService()), ($this->services['cache_warmer'] ?? $this->getCacheWarmerService()), ($this->services['fos_js_routing.extractor'] ?? $this->getFosJsRouting_ExtractorService()), $this->targetDir.'', 'KernelDevContainer', $this->getEnv('ZIKULA_INSTALLED'), $this->parameters['jms_i18n_routing.locales']);
    }

    /*
     * Gets the private 'Zikula\Bundle\CoreBundle\DataCollector\ZikulaVersionDataCollector' shared autowired service.
     *
     * @return \Zikula\Bundle\CoreBundle\DataCollector\ZikulaVersionDataCollector
     */
    protected function getZikulaVersionDataCollectorService()
    {
        return $this->privates['Zikula\\Bundle\\CoreBundle\\DataCollector\\ZikulaVersionDataCollector'] = new \Zikula\Bundle\CoreBundle\DataCollector\ZikulaVersionDataCollector(($this->privates['Zikula\\ThemeModule\\Engine\\Engine'] ?? $this->getEngineService()));
    }

    /*
     * Gets the private 'Zikula\Bundle\CoreBundle\DynamicConfigDumper' shared autowired service.
     *
     * @return \Zikula\Bundle\CoreBundle\DynamicConfigDumper
     */
    protected function getDynamicConfigDumperService()
    {
        return $this->privates['Zikula\\Bundle\\CoreBundle\\DynamicConfigDumper'] = new \Zikula\Bundle\CoreBundle\DynamicConfigDumper((\dirname(__DIR__, 4).'/config'), $this->getEnv('APP_ENV'));
    }

    /*
     * Gets the private 'Zikula\Bundle\CoreBundle\EventListener\BlameListener' shared autowired service.
     *
     * @return \Zikula\Bundle\CoreBundle\EventListener\BlameListener
     */
    protected function getBlameListenerService()
    {
        return $this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\BlameListener'] = new \Zikula\Bundle\CoreBundle\EventListener\BlameListener(($this->privates['stof_doctrine_extensions.listener.blameable'] ?? $this->getStofDoctrineExtensions_Listener_BlameableService()), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), ($this->services['session'] ?? $this->getSessionService()), $this->getEnv('ZIKULA_INSTALLED'));
    }

    /*
     * Gets the private 'Zikula\Bundle\CoreBundle\EventListener\DoctrineListener' shared autowired service.
     *
     * @return \Zikula\Bundle\CoreBundle\EventListener\DoctrineListener
     */
    protected function getDoctrineListenerService()
    {
        return $this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\DoctrineListener'] = new \Zikula\Bundle\CoreBundle\EventListener\DoctrineListener(($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), ($this->privates['doctrine.orm.default_annotation_metadata_driver'] ?? $this->getDoctrine_Orm_DefaultAnnotationMetadataDriverService()));
    }

    /*
     * Gets the private 'Zikula\Bundle\CoreBundle\EventListener\OutputCompressionListener' shared autowired service.
     *
     * @return \Zikula\Bundle\CoreBundle\EventListener\OutputCompressionListener
     */
    protected function getOutputCompressionListenerService()
    {
        return $this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\OutputCompressionListener'] = new \Zikula\Bundle\CoreBundle\EventListener\OutputCompressionListener(($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), $this->getEnv('ZIKULA_INSTALLED'));
    }

    /*
     * Gets the private 'Zikula\Bundle\CoreBundle\EventListener\SiteOffListener' shared autowired service.
     *
     * @return \Zikula\Bundle\CoreBundle\EventListener\SiteOffListener
     */
    protected function getSiteOffListenerService()
    {
        return $this->privates['Zikula\\Bundle\\CoreBundle\\EventListener\\SiteOffListener'] = new \Zikula\Bundle\CoreBundle\EventListener\SiteOffListener(($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), ($this->privates['Zikula\\PermissionsModule\\Api\\PermissionApi'] ?? $this->getPermissionApiService()), ($this->services['Zikula\\UsersModule\\Api\\CurrentUserApi'] ?? $this->getCurrentUserApiService()), ($this->services['twig'] ?? $this->getTwigService()), ($this->services['router'] ?? $this->getRouterService()), $this->getEnv('ZIKULA_INSTALLED'));
    }

    /*
     * Gets the private 'Zikula\Bundle\CoreBundle\Site\SiteDefinition' shared autowired service.
     *
     * @return \Zikula\Bundle\CoreBundle\Site\SiteDefinition
     */
    protected function getSiteDefinitionService()
    {
        return $this->privates['Zikula\\Bundle\\CoreBundle\\Site\\SiteDefinition'] = new \Zikula\Bundle\CoreBundle\Site\SiteDefinition(($this->services['translator'] ?? $this->getTranslatorService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), ($this->services['Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionRepository'] ?? $this->getExtensionRepositoryService()), ($this->privates['zikula_core.common.theme.pagevars'] ?? ($this->privates['zikula_core.common.theme.pagevars'] = new \Zikula\ThemeModule\Engine\ParameterBag())));
    }

    /*
     * Gets the private 'Zikula\Bundle\CoreInstallerBundle\EventListener\InstallUpgradeCheckListener' shared autowired service.
     *
     * @return \Zikula\Bundle\CoreInstallerBundle\EventListener\InstallUpgradeCheckListener
     */
    protected function getInstallUpgradeCheckListenerService()
    {
        return $this->privates['Zikula\\Bundle\\CoreInstallerBundle\\EventListener\\InstallUpgradeCheckListener'] = new \Zikula\Bundle\CoreInstallerBundle\EventListener\InstallUpgradeCheckListener($this->getEnv('ZIKULA_INSTALLED'), ($this->services['router'] ?? $this->getRouterService()), ($this->privates['Zikula\\RoutesModule\\Helper\\MultilingualRoutingHelper'] ?? $this->getMultilingualRoutingHelperService()), ($this->privates['parameter_bag'] ?? ($this->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($this))), new \Zikula\Bundle\CoreInstallerBundle\Helper\PreCore3UpgradeHelper(\dirname(__DIR__, 4)));
    }

    /*
     * Gets the private 'Zikula\Bundle\HookBundle\Collector\HookCollector' shared autowired service.
     *
     * @return \Zikula\Bundle\HookBundle\Collector\HookCollector
     */
    protected function getHookCollectorService()
    {
        return $this->privates['Zikula\\Bundle\\HookBundle\\Collector\\HookCollector'] = new \Zikula\Bundle\HookBundle\Collector\HookCollector(new RewindableGenerator(function () {
            return new \EmptyIterator();
        }, 0), new RewindableGenerator(function () {
            yield 0 => ($this->privates['Zikula\\BlocksModule\\HookSubscriber\\UiHooksSubscriber'] ?? $this->load('getUiHooksSubscriberService'));
            yield 1 => ($this->privates['Zikula\\MailerModule\\HookSubscriber\\UiHooksSubscriber'] ?? $this->load('getUiHooksSubscriber2Service'));
            yield 2 => ($this->privates['Zikula\\UsersModule\\HookSubscriber\\LoginUiHooksSubscriber'] ?? $this->load('getLoginUiHooksSubscriberService'));
            yield 3 => ($this->privates['Zikula\\UsersModule\\HookSubscriber\\RegistrationUiHooksSubscriber'] ?? $this->load('getRegistrationUiHooksSubscriberService'));
            yield 4 => ($this->privates['Zikula\\UsersModule\\HookSubscriber\\UserManagementUiHooksSubscriber'] ?? $this->load('getUserManagementUiHooksSubscriberService'));
        }, 5));
    }

    /*
     * Gets the private 'Zikula\Bundle\HookBundle\Dispatcher\HookDispatcher' shared autowired service.
     *
     * @return \Zikula\Bundle\HookBundle\Dispatcher\HookDispatcher
     */
    protected function getHookDispatcherService()
    {
        return $this->privates['Zikula\\Bundle\\HookBundle\\Dispatcher\\HookDispatcher'] = new \Zikula\Bundle\HookBundle\Dispatcher\HookDispatcher(new \Zikula\Bundle\HookBundle\Dispatcher\Storage\Doctrine\DoctrineStorage(($this->services['doctrine'] ?? $this->getDoctrineService()), ($this->privates['Zikula\\Bundle\\HookBundle\\Repository\\HookBindingRepository'] ?? $this->getHookBindingRepositoryService()), ($this->privates['Zikula\\Bundle\\HookBundle\\Repository\\HookRuntimeRepository'] ?? $this->getHookRuntimeRepositoryService()), ($this->privates['Zikula\\Bundle\\HookBundle\\Collector\\HookCollector'] ?? $this->getHookCollectorService())), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /*
     * Gets the private 'Zikula\Bundle\HookBundle\Listener\HookListenerBuilderListener' shared autowired service.
     *
     * @return \Zikula\Bundle\HookBundle\Listener\HookListenerBuilderListener
     */
    protected function getHookListenerBuilderListenerService()
    {
        return $this->privates['Zikula\\Bundle\\HookBundle\\Listener\\HookListenerBuilderListener'] = new \Zikula\Bundle\HookBundle\Listener\HookListenerBuilderListener(($this->services['kernel'] ?? $this->get('kernel', 1)), ($this->privates['Zikula\\Bundle\\HookBundle\\Collector\\HookCollector'] ?? $this->getHookCollectorService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Zikula\\Bundle\\HookBundle\\Repository\\HookRuntimeRepository'] ?? $this->getHookRuntimeRepositoryService()), $this->getEnv('ZIKULA_INSTALLED'));
    }

    /*
     * Gets the private 'Zikula\Bundle\HookBundle\Repository\HookBindingRepository' shared autowired service.
     *
     * @return \Zikula\Bundle\HookBundle\Repository\HookBindingRepository
     */
    protected function getHookBindingRepositoryService()
    {
        return $this->privates['Zikula\\Bundle\\HookBundle\\Repository\\HookBindingRepository'] = new \Zikula\Bundle\HookBundle\Repository\HookBindingRepository(($this->services['doctrine'] ?? $this->getDoctrineService()));
    }

    /*
     * Gets the private 'Zikula\Bundle\HookBundle\Repository\HookRuntimeRepository' shared autowired service.
     *
     * @return \Zikula\Bundle\HookBundle\Repository\HookRuntimeRepository
     */
    protected function getHookRuntimeRepositoryService()
    {
        return $this->privates['Zikula\\Bundle\\HookBundle\\Repository\\HookRuntimeRepository'] = new \Zikula\Bundle\HookBundle\Repository\HookRuntimeRepository(($this->services['doctrine'] ?? $this->getDoctrineService()));
    }

    /*
     * Gets the private 'Zikula\ExtensionsModule\Api\CapabilityApi' shared autowired service.
     *
     * @return \Zikula\ExtensionsModule\Api\CapabilityApi
     */
    protected function getCapabilityApiService()
    {
        return $this->privates['Zikula\\ExtensionsModule\\Api\\CapabilityApi'] = new \Zikula\ExtensionsModule\Api\CapabilityApi(($this->services['Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionRepository'] ?? $this->getExtensionRepositoryService()));
    }

    /*
     * Gets the private 'Zikula\ExtensionsModule\Entity\Repository\ExtensionVarRepository' shared autowired service.
     *
     * @return \Zikula\ExtensionsModule\Entity\Repository\ExtensionVarRepository
     */
    protected function getExtensionVarRepositoryService()
    {
        return $this->privates['Zikula\\ExtensionsModule\\Entity\\Repository\\ExtensionVarRepository'] = new \Zikula\ExtensionsModule\Entity\Repository\ExtensionVarRepository(($this->services['doctrine'] ?? $this->getDoctrineService()));
    }

    /*
     * Gets the private 'Zikula\PermissionsModule\Api\PermissionApi' shared autowired service.
     *
     * @return \Zikula\PermissionsModule\Api\PermissionApi
     */
    protected function getPermissionApiService()
    {
        return $this->privates['Zikula\\PermissionsModule\\Api\\PermissionApi'] = new \Zikula\PermissionsModule\Api\PermissionApi(($this->privates['Zikula\\PermissionsModule\\Entity\\Repository\\PermissionRepository'] ?? $this->getPermissionRepositoryService()), ($this->privates['Zikula\\UsersModule\\Entity\\Repository\\UserRepository'] ?? $this->getUserRepositoryService()), ($this->services['Zikula\\UsersModule\\Api\\CurrentUserApi'] ?? $this->getCurrentUserApiService()), ($this->services['translator'] ?? $this->getTranslatorService()));
    }

    /*
     * Gets the private 'Zikula\PermissionsModule\Entity\Repository\PermissionRepository' shared autowired service.
     *
     * @return \Zikula\PermissionsModule\Entity\Repository\PermissionRepository
     */
    protected function getPermissionRepositoryService()
    {
        return $this->privates['Zikula\\PermissionsModule\\Entity\\Repository\\PermissionRepository'] = new \Zikula\PermissionsModule\Entity\Repository\PermissionRepository(($this->services['doctrine'] ?? $this->getDoctrineService()));
    }

    /*
     * Gets the private 'Zikula\PermissionsModule\Listener\ControllerPermissionCheckAnnotationReaderListener' shared autowired service.
     *
     * @return \Zikula\PermissionsModule\Listener\ControllerPermissionCheckAnnotationReaderListener
     */
    protected function getControllerPermissionCheckAnnotationReaderListenerService()
    {
        return $this->privates['Zikula\\PermissionsModule\\Listener\\ControllerPermissionCheckAnnotationReaderListener'] = new \Zikula\PermissionsModule\Listener\ControllerPermissionCheckAnnotationReaderListener(($this->privates['Zikula\\PermissionsModule\\Api\\PermissionApi'] ?? $this->getPermissionApiService()), ($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()));
    }

    /*
     * Gets the private 'Zikula\RoutesModule\Helper\CollectionFilterHelper' shared autowired service.
     *
     * @return \Zikula\RoutesModule\Helper\CollectionFilterHelper
     */
    protected function getCollectionFilterHelperService($lazyLoad = true)
    {
        return $this->privates['Zikula\\RoutesModule\\Helper\\CollectionFilterHelper'] = new \Zikula\RoutesModule\Helper\CollectionFilterHelper(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['Zikula\\RoutesModule\\Helper\\PermissionHelper'] ?? $this->getPermissionHelperService()), ($this->services['Zikula\\UsersModule\\Api\\CurrentUserApi'] ?? $this->getCurrentUserApiService()), ($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()));
    }

    /*
     * Gets the private 'Zikula\RoutesModule\Helper\EntityDisplayHelper' shared autowired service.
     *
     * @return \Zikula\RoutesModule\Helper\EntityDisplayHelper
     */
    protected function getEntityDisplayHelperService($lazyLoad = true)
    {
        return $this->privates['Zikula\\RoutesModule\\Helper\\EntityDisplayHelper'] = new \Zikula\RoutesModule\Helper\EntityDisplayHelper(($this->services['translator'] ?? $this->getTranslatorService()), ($this->privates['Zikula\\RoutesModule\\Helper\\ListEntriesHelper'] ?? $this->getListEntriesHelperService()));
    }

    /*
     * Gets the private 'Zikula\RoutesModule\Helper\ListEntriesHelper' shared autowired service.
     *
     * @return \Zikula\RoutesModule\Helper\ListEntriesHelper
     */
    protected function getListEntriesHelperService($lazyLoad = true)
    {
        return $this->privates['Zikula\\RoutesModule\\Helper\\ListEntriesHelper'] = new \Zikula\RoutesModule\Helper\ListEntriesHelper(($this->services['translator'] ?? $this->getTranslatorService()));
    }

    /*
     * Gets the private 'Zikula\RoutesModule\Helper\MultilingualRoutingHelper' shared autowired service.
     *
     * @return \Zikula\RoutesModule\Helper\MultilingualRoutingHelper
     */
    protected function getMultilingualRoutingHelperService()
    {
        return $this->privates['Zikula\\RoutesModule\\Helper\\MultilingualRoutingHelper'] = new \Zikula\RoutesModule\Helper\MultilingualRoutingHelper(($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), ($this->privates['Zikula\\Bundle\\CoreBundle\\DynamicConfigDumper'] ?? ($this->privates['Zikula\\Bundle\\CoreBundle\\DynamicConfigDumper'] = new \Zikula\Bundle\CoreBundle\DynamicConfigDumper((\dirname(__DIR__, 4).'/config'), $this->getEnv('APP_ENV')))), ($this->privates['Zikula\\Bundle\\CoreBundle\\CacheClearer'] ?? $this->getCacheClearer3Service()), $this->getEnv('ZIKULA_INSTALLED'));
    }

    /*
     * Gets the private 'Zikula\RoutesModule\Helper\PathBuilderHelper' shared autowired service.
     *
     * @return \Zikula\RoutesModule\Helper\PathBuilderHelper
     */
    protected function getPathBuilderHelperService($lazyLoad = true)
    {
        return $this->privates['Zikula\\RoutesModule\\Helper\\PathBuilderHelper'] = new \Zikula\RoutesModule\Helper\PathBuilderHelper(($this->services['kernel'] ?? $this->get('kernel', 1)));
    }

    /*
     * Gets the private 'Zikula\RoutesModule\Helper\PermissionHelper' shared autowired service.
     *
     * @return \Zikula\RoutesModule\Helper\PermissionHelper
     */
    protected function getPermissionHelperService($lazyLoad = true)
    {
        return $this->privates['Zikula\\RoutesModule\\Helper\\PermissionHelper'] = new \Zikula\RoutesModule\Helper\PermissionHelper(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['Zikula\\PermissionsModule\\Api\\PermissionApi'] ?? $this->getPermissionApiService()), ($this->services['Zikula\\UsersModule\\Api\\CurrentUserApi'] ?? $this->getCurrentUserApiService()), ($this->privates['Zikula\\UsersModule\\Entity\\Repository\\UserRepository'] ?? $this->getUserRepositoryService()));
    }

    /*
     * Gets the private 'Zikula\RoutesModule\Helper\WorkflowHelper' shared autowired service.
     *
     * @return \Zikula\RoutesModule\Helper\WorkflowHelper
     */
    protected function getWorkflowHelperService($lazyLoad = true)
    {
        return $this->privates['Zikula\\RoutesModule\\Helper\\WorkflowHelper'] = new \Zikula\RoutesModule\Helper\WorkflowHelper(($this->services['translator'] ?? $this->getTranslatorService()), ($this->privates['workflow.registry'] ?? $this->getWorkflow_RegistryService()), ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()), ($this->services['Zikula\\UsersModule\\Api\\CurrentUserApi'] ?? $this->getCurrentUserApiService()), ($this->services['Zikula\\RoutesModule\\Entity\\Factory\\EntityFactory'] ?? $this->getEntityFactoryService()), ($this->privates['Zikula\\RoutesModule\\Helper\\ListEntriesHelper'] ?? $this->getListEntriesHelperService()), ($this->privates['Zikula\\RoutesModule\\Helper\\PermissionHelper'] ?? $this->getPermissionHelperService()));
    }

    /*
     * Gets the private 'Zikula\RoutesModule\Listener\ThemeListener' shared autowired service.
     *
     * @return \Zikula\RoutesModule\Listener\ThemeListener
     */
    protected function getThemeListenerService()
    {
        return $this->privates['Zikula\\RoutesModule\\Listener\\ThemeListener'] = new \Zikula\RoutesModule\Listener\ThemeListener(($this->privates['Zikula\\ThemeModule\\Engine\\AssetFilter'] ?? $this->getAssetFilterService()));
    }

    /*
     * Gets the private 'Zikula\SearchModule\Listener\FrontControllerListener' shared autowired service.
     *
     * @return \Zikula\SearchModule\Listener\FrontControllerListener
     */
    protected function getFrontControllerListenerService()
    {
        return $this->privates['Zikula\\SearchModule\\Listener\\FrontControllerListener'] = new \Zikula\SearchModule\Listener\FrontControllerListener(($this->services['router'] ?? $this->getRouterService()), ($this->privates['Zikula\\PermissionsModule\\Api\\PermissionApi'] ?? $this->getPermissionApiService()), ($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), ($this->privates['zikula_core.common.theme.assets_header'] ?? ($this->privates['zikula_core.common.theme.assets_header'] = new \Zikula\ThemeModule\Engine\AssetBag())), ($this->privates['Zikula\\Bundle\\CoreBundle\\Site\\SiteDefinition'] ?? $this->getSiteDefinitionService()), $this->getEnv('ZIKULA_INSTALLED'), (($this->hasParameter("upgrading")) ? ($this->getParameter("upgrading")) : (false)));
    }

    /*
     * Gets the private 'Zikula\SecurityCenterModule\Helper\CacheDirHelper' shared autowired service.
     *
     * @return \Zikula\SecurityCenterModule\Helper\CacheDirHelper
     */
    protected function getCacheDirHelperService($lazyLoad = true)
    {
        return $this->privates['Zikula\\SecurityCenterModule\\Helper\\CacheDirHelper'] = new \Zikula\SecurityCenterModule\Helper\CacheDirHelper(($this->services['filesystem'] ?? ($this->services['filesystem'] = new \Symfony\Component\Filesystem\Filesystem())), ($this->services['session'] ?? $this->getSessionService()), ($this->services['translator'] ?? $this->getTranslatorService()));
    }

    /*
     * Gets the private 'Zikula\SecurityCenterModule\Listener\FilterListener' shared autowired service.
     *
     * @return \Zikula\SecurityCenterModule\Listener\FilterListener
     */
    protected function getFilterListenerService()
    {
        return $this->privates['Zikula\\SecurityCenterModule\\Listener\\FilterListener'] = new \Zikula\SecurityCenterModule\Listener\FilterListener(($this->privates['Zikula\\SecurityCenterModule\\ZikulaSecurityCenterModule'] ?? ($this->privates['Zikula\\SecurityCenterModule\\ZikulaSecurityCenterModule'] = new \Zikula\SecurityCenterModule\ZikulaSecurityCenterModule())), ($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), ($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), ($this->privates['mailer.mailer'] ?? $this->getMailer_MailerService()), ($this->services['monolog.logger.mail'] ?? $this->getMonolog_Logger_MailService()), ($this->services['translator'] ?? $this->getTranslatorService()), \dirname(__DIR__, 4), $this->targetDir.'', ($this->privates['Zikula\\SecurityCenterModule\\Helper\\CacheDirHelper'] ?? $this->getCacheDirHelperService()), $this->getEnv('ZIKULA_INSTALLED'), (($this->hasParameter("upgrading")) ? ($this->getParameter("upgrading")) : (false)));
    }

    /*
     * Gets the private 'Zikula\SecurityCenterModule\ZikulaSecurityCenterModule' shared autowired service.
     *
     * @return \Zikula\SecurityCenterModule\ZikulaSecurityCenterModule
     */
    protected function getZikulaSecurityCenterModuleService()
    {
        return $this->privates['Zikula\\SecurityCenterModule\\ZikulaSecurityCenterModule'] = new \Zikula\SecurityCenterModule\ZikulaSecurityCenterModule();
    }

    /*
     * Gets the private 'Zikula\SettingsModule\Api\LocaleApi' shared autowired service.
     *
     * @return \Zikula\SettingsModule\Api\LocaleApi
     */
    protected function getLocaleApiService()
    {
        $a = ($this->services['kernel'] ?? $this->get('kernel', 1));
        $b = ($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService());

        return $this->privates['Zikula\\SettingsModule\\Api\\LocaleApi'] = new \Zikula\SettingsModule\Api\LocaleApi($a, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $b, new \Zikula\SettingsModule\Helper\LocaleConfigHelper($a, $b, ($this->privates['Zikula\\Bundle\\CoreBundle\\DynamicConfigDumper'] ?? ($this->privates['Zikula\\Bundle\\CoreBundle\\DynamicConfigDumper'] = new \Zikula\Bundle\CoreBundle\DynamicConfigDumper((\dirname(__DIR__, 4).'/config'), $this->getEnv('APP_ENV')))), ($this->privates['Zikula\\Bundle\\CoreBundle\\CacheClearer'] ?? $this->getCacheClearer3Service()), 'en', $this->getEnv('ZIKULA_INSTALLED')), 'en', $this->getEnv('ZIKULA_INSTALLED'));
    }

    /*
     * Gets the private 'Zikula\SettingsModule\Listener\LocaleListener' shared autowired service.
     *
     * @return \Zikula\SettingsModule\Listener\LocaleListener
     */
    protected function getLocaleListenerService()
    {
        return $this->privates['Zikula\\SettingsModule\\Listener\\LocaleListener'] = new \Zikula\SettingsModule\Listener\LocaleListener(($this->services['Zikula\\UsersModule\\Api\\CurrentUserApi'] ?? $this->getCurrentUserApiService()), 'en', $this->getEnv('ZIKULA_INSTALLED'));
    }

    /*
     * Gets the private 'Zikula\SettingsModule\Listener\LocalizedVariableListener' shared autowired service.
     *
     * @return \Zikula\SettingsModule\Listener\LocalizedVariableListener
     */
    protected function getLocalizedVariableListenerService()
    {
        return $this->privates['Zikula\\SettingsModule\\Listener\\LocalizedVariableListener'] = new \Zikula\SettingsModule\Listener\LocalizedVariableListener(($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()));
    }

    /*
     * Gets the private 'Zikula\SettingsModule\Listener\TranslationUiListener' shared autowired service.
     *
     * @return \Zikula\SettingsModule\Listener\TranslationUiListener
     */
    protected function getTranslationUiListenerService()
    {
        return $this->privates['Zikula\\SettingsModule\\Listener\\TranslationUiListener'] = new \Zikula\SettingsModule\Listener\TranslationUiListener(($this->privates['Zikula\\PermissionsModule\\Api\\PermissionApi'] ?? $this->getPermissionApiService()), ($this->privates['Zikula\\SettingsModule\\Api\\LocaleApi'] ?? $this->getLocaleApiService()));
    }

    /*
     * Gets the private 'Zikula\ThemeModule\Api\PageAssetApi' shared autowired service.
     *
     * @return \Zikula\ThemeModule\Api\PageAssetApi
     */
    protected function getPageAssetApiService()
    {
        return $this->privates['Zikula\\ThemeModule\\Api\\PageAssetApi'] = new \Zikula\ThemeModule\Api\PageAssetApi(($this->services['zikula_core.common.theme.assets_css'] ?? ($this->services['zikula_core.common.theme.assets_css'] = new \Zikula\ThemeModule\Engine\AssetBag())), ($this->privates['zikula_core.common.theme.assets_js'] ?? ($this->privates['zikula_core.common.theme.assets_js'] = new \Zikula\ThemeModule\Engine\AssetBag())), ($this->privates['zikula_core.common.theme.assets_header'] ?? ($this->privates['zikula_core.common.theme.assets_header'] = new \Zikula\ThemeModule\Engine\AssetBag())), ($this->privates['zikula_core.common.theme.assets_footer'] ?? ($this->privates['zikula_core.common.theme.assets_footer'] = new \Zikula\ThemeModule\Engine\AssetBag())));
    }

    /*
     * Gets the private 'Zikula\ThemeModule\Engine\AssetFilter' shared autowired service.
     *
     * @return \Zikula\ThemeModule\Engine\AssetFilter
     */
    protected function getAssetFilterService()
    {
        $a = new \Zikula\ThemeModule\Engine\Asset\Merger(($this->services['router'] ?? $this->getRouterService()), ($this->services['kernel'] ?? $this->get('kernel', 1)), '1 day', true, true, [0 => '/jquery/jquery.min.js', 1 => '/bootstrap/css/bootstrap.min.css', 2 => '/font-awesome/css/all.min.css', 3 => '/mmenu/css/mmenu.css', 4 => '/mmenu/js/mmenu.js']);

        return $this->privates['Zikula\\ThemeModule\\Engine\\AssetFilter'] = new \Zikula\ThemeModule\Engine\AssetFilter(($this->privates['zikula_core.common.theme.assets_header'] ?? ($this->privates['zikula_core.common.theme.assets_header'] = new \Zikula\ThemeModule\Engine\AssetBag())), ($this->privates['zikula_core.common.theme.assets_footer'] ?? ($this->privates['zikula_core.common.theme.assets_footer'] = new \Zikula\ThemeModule\Engine\AssetBag())), new \Zikula\ThemeModule\Engine\Asset\JsResolver($this->getEnv('APP_ENV'), ($this->privates['zikula_core.common.theme.assets_js'] ?? ($this->privates['zikula_core.common.theme.assets_js'] = new \Zikula\ThemeModule\Engine\AssetBag())), $a, true), new \Zikula\ThemeModule\Engine\Asset\CssResolver($this->getEnv('APP_ENV'), ($this->services['zikula_core.common.theme.assets_css'] ?? ($this->services['zikula_core.common.theme.assets_css'] = new \Zikula\ThemeModule\Engine\AssetBag())), $a, true), 'foot');
    }

    /*
     * Gets the private 'Zikula\ThemeModule\Engine\Engine' shared autowired service.
     *
     * @return \Zikula\ThemeModule\Engine\Engine
     */
    protected function getEngineService()
    {
        return $this->privates['Zikula\\ThemeModule\\Engine\\Engine'] = new \Zikula\ThemeModule\Engine\Engine(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()), ($this->services['kernel'] ?? $this->get('kernel', 1)), ($this->privates['Zikula\\ThemeModule\\Engine\\AssetFilter'] ?? $this->getAssetFilterService()), ($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()));
    }

    /*
     * Gets the private 'Zikula\ThemeModule\EventListener\AddJSConfigListener' shared autowired service.
     *
     * @return \Zikula\ThemeModule\EventListener\AddJSConfigListener
     */
    protected function getAddJSConfigListenerService()
    {
        return $this->privates['Zikula\\ThemeModule\\EventListener\\AddJSConfigListener'] = new \Zikula\ThemeModule\EventListener\AddJSConfigListener($this->getEnv('ZIKULA_INSTALLED'), ($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), ($this->services['Zikula\\UsersModule\\Api\\CurrentUserApi'] ?? $this->getCurrentUserApiService()), ($this->services['twig'] ?? $this->getTwigService()), ($this->privates['zikula_core.common.theme.assets_footer'] ?? ($this->privates['zikula_core.common.theme.assets_footer'] = new \Zikula\ThemeModule\Engine\AssetBag())));
    }

    /*
     * Gets the private 'Zikula\ThemeModule\EventListener\AddThemePathsToLoaderListener' shared autowired service.
     *
     * @return \Zikula\ThemeModule\EventListener\AddThemePathsToLoaderListener
     */
    protected function getAddThemePathsToLoaderListenerService()
    {
        return $this->privates['Zikula\\ThemeModule\\EventListener\\AddThemePathsToLoaderListener'] = new \Zikula\ThemeModule\EventListener\AddThemePathsToLoaderListener(($this->privates['twig.loader.native_filesystem'] ?? $this->getTwig_Loader_NativeFilesystemService()), ($this->privates['Zikula\\ThemeModule\\Engine\\Engine'] ?? $this->getEngineService()));
    }

    /*
     * Gets the private 'Zikula\ThemeModule\EventListener\ControllerAnnotationReaderListener' shared autowired service.
     *
     * @return \Zikula\ThemeModule\EventListener\ControllerAnnotationReaderListener
     */
    protected function getControllerAnnotationReaderListenerService()
    {
        return $this->privates['Zikula\\ThemeModule\\EventListener\\ControllerAnnotationReaderListener'] = new \Zikula\ThemeModule\EventListener\ControllerAnnotationReaderListener(($this->privates['Zikula\\ThemeModule\\Engine\\Engine'] ?? $this->getEngineService()));
    }

    /*
     * Gets the private 'Zikula\ThemeModule\EventListener\CreateThemedResponseListener' shared autowired service.
     *
     * @return \Zikula\ThemeModule\EventListener\CreateThemedResponseListener
     */
    protected function getCreateThemedResponseListenerService()
    {
        return $this->privates['Zikula\\ThemeModule\\EventListener\\CreateThemedResponseListener'] = new \Zikula\ThemeModule\EventListener\CreateThemedResponseListener($this->getEnv('ZIKULA_INSTALLED'), $this->getEnv('APP_DEBUG'), ($this->privates['Zikula\\ThemeModule\\Engine\\Engine'] ?? $this->getEngineService()));
    }

    /*
     * Gets the private 'Zikula\ThemeModule\EventListener\DefaultPageAssetSetterListener' shared autowired service.
     *
     * @return \Zikula\ThemeModule\EventListener\DefaultPageAssetSetterListener
     */
    protected function getDefaultPageAssetSetterListenerService()
    {
        return $this->privates['Zikula\\ThemeModule\\EventListener\\DefaultPageAssetSetterListener'] = new \Zikula\ThemeModule\EventListener\DefaultPageAssetSetterListener(($this->privates['zikula_core.common.theme.assets_js'] ?? ($this->privates['zikula_core.common.theme.assets_js'] = new \Zikula\ThemeModule\Engine\AssetBag())), ($this->services['zikula_core.common.theme.assets_css'] ?? ($this->services['zikula_core.common.theme.assets_css'] = new \Zikula\ThemeModule\Engine\AssetBag())), ($this->services['router'] ?? $this->getRouterService()), ($this->services['Zikula\\ThemeModule\\Engine\\Asset'] ?? $this->getAssetService()), ($this->privates['Zikula\\ThemeModule\\Engine\\Engine'] ?? $this->getEngineService()), $this->getEnv('ZIKULA_INSTALLED'), '/bootstrap/js/bootstrap.bundle.min.js', '/bootstrap/css/bootstrap.min.css', '/font-awesome/css/all.min.css');
    }

    /*
     * Gets the private 'Zikula\ThemeModule\EventListener\DefaultPageVarSetterListener' shared autowired service.
     *
     * @return \Zikula\ThemeModule\EventListener\DefaultPageVarSetterListener
     */
    protected function getDefaultPageVarSetterListenerService()
    {
        return $this->privates['Zikula\\ThemeModule\\EventListener\\DefaultPageVarSetterListener'] = new \Zikula\ThemeModule\EventListener\DefaultPageVarSetterListener(($this->privates['Zikula\\Bundle\\CoreBundle\\Site\\SiteDefinition'] ?? $this->getSiteDefinitionService()), ($this->privates['zikula_core.common.theme.pagevars'] ?? ($this->privates['zikula_core.common.theme.pagevars'] = new \Zikula\ThemeModule\Engine\ParameterBag())), ($this->services['router'] ?? $this->getRouterService()), ($this->services['kernel'] ?? $this->get('kernel', 1)), $this->getEnv('ZIKULA_INSTALLED'));
    }

    /*
     * Gets the private 'Zikula\ThemeModule\EventListener\ResponseTransformerListener' shared autowired service.
     *
     * @return \Zikula\ThemeModule\EventListener\ResponseTransformerListener
     */
    protected function getResponseTransformerListenerService()
    {
        return $this->privates['Zikula\\ThemeModule\\EventListener\\ResponseTransformerListener'] = new \Zikula\ThemeModule\EventListener\ResponseTransformerListener(($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()));
    }

    /*
     * Gets the private 'Zikula\UsersModule\Collector\MessageModuleCollector' shared autowired service.
     *
     * @return \Zikula\UsersModule\Collector\MessageModuleCollector
     */
    protected function getMessageModuleCollectorService()
    {
        return $this->privates['Zikula\\UsersModule\\Collector\\MessageModuleCollector'] = new \Zikula\UsersModule\Collector\MessageModuleCollector(($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), new RewindableGenerator(function () {
            yield 0 => ($this->privates['Zikula\\UsersModule\\MessageModule\\IdentityMessageModule'] ?? ($this->privates['Zikula\\UsersModule\\MessageModule\\IdentityMessageModule'] = new \Zikula\UsersModule\MessageModule\IdentityMessageModule()));
        }, 1));
    }

    /*
     * Gets the private 'Zikula\UsersModule\Collector\ProfileModuleCollector' shared autowired service.
     *
     * @return \Zikula\UsersModule\Collector\ProfileModuleCollector
     */
    protected function getProfileModuleCollectorService()
    {
        return $this->privates['Zikula\\UsersModule\\Collector\\ProfileModuleCollector'] = new \Zikula\UsersModule\Collector\ProfileModuleCollector(($this->privates['Zikula\\UsersModule\\Entity\\Repository\\UserRepository'] ?? $this->getUserRepositoryService()), ($this->services['Zikula\\UsersModule\\Api\\CurrentUserApi'] ?? $this->getCurrentUserApiService()), ($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), new RewindableGenerator(function () {
            yield 0 => ($this->privates['Zikula\\UsersModule\\ProfileModule\\IdentityProfileModule'] ?? $this->load('getIdentityProfileModuleService'));
        }, 1));
    }

    /*
     * Gets the private 'Zikula\UsersModule\Entity\Repository\UserRepository' shared autowired service.
     *
     * @return \Zikula\UsersModule\Entity\Repository\UserRepository
     */
    protected function getUserRepositoryService()
    {
        return $this->privates['Zikula\\UsersModule\\Entity\\Repository\\UserRepository'] = new \Zikula\UsersModule\Entity\Repository\UserRepository(($this->services['doctrine'] ?? $this->getDoctrineService()));
    }

    /*
     * Gets the private 'Zikula\UsersModule\Entity\Repository\UserSessionRepository' shared autowired service.
     *
     * @return \Zikula\UsersModule\Entity\Repository\UserSessionRepository
     */
    protected function getUserSessionRepositoryService()
    {
        return $this->privates['Zikula\\UsersModule\\Entity\\Repository\\UserSessionRepository'] = new \Zikula\UsersModule\Entity\Repository\UserSessionRepository(($this->services['doctrine'] ?? $this->getDoctrineService()));
    }

    /*
     * Gets the private 'annotations.cached_reader' shared service.
     *
     * @return \Doctrine\Common\Annotations\CachedReader
     */
    protected function getAnnotations_CachedReaderService()
    {
        return $this->privates['annotations.cached_reader'] = new \Doctrine\Common\Annotations\CachedReader(($this->privates['annotations.reader'] ?? $this->getAnnotations_ReaderService()), $this->load('getAnnotations_CacheService'), false);
    }

    /*
     * Gets the private 'annotations.reader' shared service.
     *
     * @return \Doctrine\Common\Annotations\AnnotationReader
     */
    protected function getAnnotations_ReaderService()
    {
        $this->privates['annotations.reader'] = $instance = new \Doctrine\Common\Annotations\AnnotationReader();

        $a = new \Doctrine\Common\Annotations\AnnotationRegistry();
        $a->registerUniqueLoader('class_exists');

        $instance->addGlobalIgnoredName('required', $a);

        return $instance;
    }

    /*
     * Gets the private 'assets.packages' shared service.
     *
     * @return \Symfony\Component\Asset\Packages
     */
    protected function getAssets_PackagesService()
    {
        $a = ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService());

        return $this->privates['assets.packages'] = new \Symfony\Component\Asset\Packages(new \Symfony\Component\Asset\PathPackage('', new \Symfony\Component\Asset\VersionStrategy\EmptyVersionStrategy(), new \Symfony\Component\Asset\Context\RequestStackContext(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $a->getBaseUrl(), $a->isSecure())), []);
    }

    /*
     * Gets the private 'cache.validator' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected function getCache_ValidatorService()
    {
        return $this->privates['cache.validator'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('eQaOW9f6f7', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService()));
    }

    /*
     * Gets the private 'data_collector.form' shared service.
     *
     * @return \Symfony\Component\Form\Extension\DataCollector\FormDataCollector
     */
    protected function getDataCollector_FormService()
    {
        return $this->privates['data_collector.form'] = new \Symfony\Component\Form\Extension\DataCollector\FormDataCollector(new \Symfony\Component\Form\Extension\DataCollector\FormDataExtractor());
    }

    /*
     * Gets the private 'debug.debug_handlers_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener
     */
    protected function getDebug_DebugHandlersListenerService()
    {
        $a = new \Symfony\Bridge\Monolog\Logger('php');
        $a->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $a->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));

        return $this->privates['debug.debug_handlers_listener'] = new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, $a, NULL, 0, false, ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService()), false, NULL);
    }

    /*
     * Gets the private 'debug.file_link_formatter' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Debug\FileLinkFormatter
     */
    protected function getDebug_FileLinkFormatterService()
    {
        return $this->privates['debug.file_link_formatter'] = new \Symfony\Component\HttpKernel\Debug\FileLinkFormatter(NULL, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), \dirname(__DIR__, 4), function () {
            return ($this->privates['debug.file_link_formatter.url_format'] ?? $this->load('getDebug_FileLinkFormatter_UrlFormatService'));
        });
    }

    /*
     * Gets the private 'doctrine.orm.default_annotation_metadata_driver' shared service.
     *
     * @return \Doctrine\ORM\Mapping\Driver\AnnotationDriver
     */
    protected function getDoctrine_Orm_DefaultAnnotationMetadataDriverService()
    {
        return $this->privates['doctrine.orm.default_annotation_metadata_driver'] = new \Doctrine\ORM\Mapping\Driver\AnnotationDriver(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()), [0 => (\dirname(__DIR__, 4).'/vendor/gedmo/doctrine-extensions/lib/Gedmo/Translatable/Entity'), 1 => (\dirname(__DIR__, 4).'/vendor/gedmo/doctrine-extensions/lib/Gedmo/Translator/Entity'), 2 => (\dirname(__DIR__, 4).'/vendor/gedmo/doctrine-extensions/lib/Gedmo/Loggable/Entity'), 3 => (\dirname(__DIR__, 4).'/vendor/gedmo/doctrine-extensions/lib/Gedmo/Tree/Entity'), 4 => (\dirname(__DIR__, 4).'/vendor/zikula/hook-bundle/Entity'), 5 => (\dirname(__DIR__, 4).'/vendor/zikula/admin-module/Entity'), 6 => (\dirname(__DIR__, 4).'/vendor/zikula/blocks-module/Entity'), 7 => (\dirname(__DIR__, 4).'/vendor/zikula/categories-module/Entity'), 8 => (\dirname(__DIR__, 4).'/vendor/zikula/extensions-module/Entity'), 9 => (\dirname(__DIR__, 4).'/vendor/zikula/groups-module/Entity'), 10 => (\dirname(__DIR__, 4).'/vendor/zikula/menu-module/Entity'), 11 => (\dirname(__DIR__, 4).'/vendor/zikula/permissions-module/Entity'), 12 => (\dirname(__DIR__, 4).'/vendor/zikula/routes-module/Entity'), 13 => (\dirname(__DIR__, 4).'/vendor/zikula/search-module/Entity'), 14 => (\dirname(__DIR__, 4).'/vendor/zikula/securitycenter-module/Entity'), 15 => (\dirname(__DIR__, 4).'/vendor/zikula/users-module/Entity'), 16 => (\dirname(__DIR__, 4).'/vendor/zikula/zauth-module/Entity')]);
    }

    /*
     * Gets the private 'exception_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\ErrorListener
     */
    protected function getExceptionListener2Service()
    {
        return $this->privates['exception_listener'] = new \Symfony\Component\HttpKernel\EventListener\ErrorListener('error_controller', ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService()), false);
    }

    /*
     * Gets the private 'fragment.handler' shared service.
     *
     * @return \Symfony\Component\HttpKernel\DependencyInjection\LazyLoadingFragmentHandler
     */
    protected function getFragment_HandlerService()
    {
        return $this->privates['fragment.handler'] = new \Symfony\Component\HttpKernel\DependencyInjection\LazyLoadingFragmentHandler(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'inline' => ['privates', 'fragment.renderer.inline', 'getFragment_Renderer_InlineService', true],
        ], [
            'inline' => '?',
        ]), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), false);
    }

    /*
     * Gets the private 'framework_extra_bundle.argument_name_convertor' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\Request\ArgumentNameConverter
     */
    protected function getFrameworkExtraBundle_ArgumentNameConvertorService()
    {
        return $this->privates['framework_extra_bundle.argument_name_convertor'] = new \Sensio\Bundle\FrameworkExtraBundle\Request\ArgumentNameConverter(($this->privates['argument_metadata_factory'] ?? ($this->privates['argument_metadata_factory'] = new \Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadataFactory())));
    }

    /*
     * Gets the private 'framework_extra_bundle.event.is_granted' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\EventListener\IsGrantedListener
     */
    protected function getFrameworkExtraBundle_Event_IsGrantedService()
    {
        return $this->privates['framework_extra_bundle.event.is_granted'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\IsGrantedListener(($this->privates['framework_extra_bundle.argument_name_convertor'] ?? $this->getFrameworkExtraBundle_ArgumentNameConvertorService()), ($this->services['security.authorization_checker'] ?? $this->getSecurity_AuthorizationCheckerService()));
    }

    /*
     * Gets the private 'liip_imagine.filter.configuration' shared service.
     *
     * @return \Liip\ImagineBundle\Imagine\Filter\FilterConfiguration
     */
    protected function getLiipImagine_Filter_ConfigurationService()
    {
        return $this->privates['liip_imagine.filter.configuration'] = new \Liip\ImagineBundle\Imagine\Filter\FilterConfiguration($this->parameters['liip_imagine.filter_sets']);
    }

    /*
     * Gets the private 'locale_aware_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener
     */
    protected function getLocaleAwareListenerService()
    {
        return $this->privates['locale_aware_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener(new RewindableGenerator(function () {
            yield 0 => ($this->privates['slugger'] ?? ($this->privates['slugger'] = new \Symfony\Component\String\Slugger\AsciiSlugger('en')));
            yield 1 => ($this->privates['translator.default'] ?? $this->getTranslator_DefaultService());
        }, 2), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /*
     * Gets the private 'locale_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleListener
     */
    protected function getLocaleListener2Service()
    {
        return $this->privates['locale_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleListener(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), 'en', ($this->services['router'] ?? $this->getRouterService()));
    }

    /*
     * Gets the private 'mailer.mailer' shared service.
     *
     * @return \Symfony\Component\Mailer\Mailer
     */
    protected function getMailer_MailerService()
    {
        return $this->privates['mailer.mailer'] = new \Symfony\Component\Mailer\Mailer((new \Symfony\Component\Mailer\Transport(new RewindableGenerator(function () {
            yield 0 => $this->load('getMailer_TransportFactory_AmazonService');
            yield 1 => $this->load('getMailer_TransportFactory_GmailService');
            yield 2 => $this->load('getMailer_TransportFactory_MailchimpService');
            yield 3 => $this->load('getMailer_TransportFactory_MailgunService');
            yield 4 => $this->load('getMailer_TransportFactory_PostmarkService');
            yield 5 => $this->load('getMailer_TransportFactory_SendgridService');
            yield 6 => $this->load('getMailer_TransportFactory_NullService');
            yield 7 => $this->load('getMailer_TransportFactory_SendmailService');
            yield 8 => $this->load('getMailer_TransportFactory_SmtpService');
        }, 9)))->fromStrings(['main' => $this->getEnv('MAILER_DSN')]), NULL, ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /*
     * Gets the private 'monolog.handler.console' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Handler\ConsoleHandler
     */
    protected function getMonolog_Handler_ConsoleService()
    {
        return $this->privates['monolog.handler.console'] = new \Symfony\Bridge\Monolog\Handler\ConsoleHandler(NULL, true, [], []);
    }

    /*
     * Gets the private 'monolog.handler.mail' shared service.
     *
     * @return \Monolog\Handler\StreamHandler
     */
    protected function getMonolog_Handler_MailService()
    {
        $this->privates['monolog.handler.mail'] = $instance = new \Monolog\Handler\StreamHandler((\dirname(__DIR__, 3).'/log/dev.mail.log'), 100, true, NULL, false);

        $instance->pushProcessor(($this->privates['monolog.processor.psr_log_message'] ?? ($this->privates['monolog.processor.psr_log_message'] = new \Monolog\Processor\PsrLogMessageProcessor())));

        return $instance;
    }

    /*
     * Gets the private 'monolog.handler.main' shared service.
     *
     * @return \Monolog\Handler\StreamHandler
     */
    protected function getMonolog_Handler_MainService()
    {
        $this->privates['monolog.handler.main'] = $instance = new \Monolog\Handler\StreamHandler((\dirname(__DIR__, 3).'/log/dev.log'), 100, true, NULL, false);

        $instance->pushProcessor(($this->privates['monolog.processor.psr_log_message'] ?? ($this->privates['monolog.processor.psr_log_message'] = new \Monolog\Processor\PsrLogMessageProcessor())));

        return $instance;
    }

    /*
     * Gets the private 'monolog.handler.zikula' shared service.
     *
     * @return \Monolog\Handler\StreamHandler
     */
    protected function getMonolog_Handler_ZikulaService()
    {
        $this->privates['monolog.handler.zikula'] = $instance = new \Monolog\Handler\StreamHandler((\dirname(__DIR__, 3).'/log/dev.zikula.log'), 100, true, NULL, false);

        $instance->pushProcessor(($this->privates['monolog.processor.psr_log_message'] ?? ($this->privates['monolog.processor.psr_log_message'] = new \Monolog\Processor\PsrLogMessageProcessor())));

        return $instance;
    }

    /*
     * Gets the private 'monolog.logger' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_LoggerService()
    {
        $this->privates['monolog.logger'] = $instance = new \Symfony\Bridge\Monolog\Logger('app');

        $instance->useMicrosecondTimestamps(true);
        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));

        return $instance;
    }

    /*
     * Gets the private 'monolog.logger.cache' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_Logger_CacheService()
    {
        $this->privates['monolog.logger.cache'] = $instance = new \Symfony\Bridge\Monolog\Logger('cache');

        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));

        return $instance;
    }

    /*
     * Gets the private 'monolog.logger.request' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_Logger_RequestService()
    {
        $this->privates['monolog.logger.request'] = $instance = new \Symfony\Bridge\Monolog\Logger('request');

        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));

        return $instance;
    }

    /*
     * Gets the private 'parameter_bag' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag
     */
    protected function getParameterBagService()
    {
        return $this->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($this);
    }

    /*
     * Gets the private 'profiler_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\ProfilerListener
     */
    protected function getProfilerListenerService()
    {
        return $this->privates['profiler_listener'] = new \Symfony\Component\HttpKernel\EventListener\ProfilerListener(($this->services['profiler'] ?? $this->getProfilerService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), NULL, false, false);
    }

    /*
     * Gets the private 'router.expression_language_provider' shared service.
     *
     * @return \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider
     */
    protected function getRouter_ExpressionLanguageProviderService()
    {
        return $this->privates['router.expression_language_provider'] = new \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'env' => ['privates', 'container.getenv', 'getContainer_GetenvService', true],
        ], [
            'env' => 'Closure',
        ]));
    }

    /*
     * Gets the private 'router.request_context' shared service.
     *
     * @return \Symfony\Component\Routing\RequestContext
     */
    protected function getRouter_RequestContextService()
    {
        $this->privates['router.request_context'] = $instance = \Symfony\Component\Routing\RequestContext::fromUri('', 'localhost', 'http', 80, 443);

        $instance->setParameter('_functions', ($this->privates['router.expression_language_provider'] ?? $this->getRouter_ExpressionLanguageProviderService()));

        return $instance;
    }

    /*
     * Gets the private 'router_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\RouterListener
     */
    protected function getRouterListenerService()
    {
        return $this->privates['router_listener'] = new \Symfony\Component\HttpKernel\EventListener\RouterListener(($this->services['router'] ?? $this->getRouterService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService()), ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService()), \dirname(__DIR__, 4), false);
    }

    /*
     * Gets the private 'security.access.decision_manager' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\AccessDecisionManager
     */
    protected function getSecurity_Access_DecisionManagerService()
    {
        return $this->privates['security.access.decision_manager'] = new \Symfony\Component\Security\Core\Authorization\AccessDecisionManager(new RewindableGenerator(function () {
            yield 0 => ($this->privates['security.access.authenticated_voter'] ?? $this->load('getSecurity_Access_AuthenticatedVoterService'));
            yield 1 => ($this->privates['security.access.role_hierarchy_voter'] ?? $this->load('getSecurity_Access_RoleHierarchyVoterService'));
            yield 2 => ($this->privates['security.access.expression_voter'] ?? $this->load('getSecurity_Access_ExpressionVoterService'));
        }, 3), 'affirmative', false, true);
    }

    /*
     * Gets the private 'security.authentication.manager' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authentication\AuthenticationProviderManager
     */
    protected function getSecurity_Authentication_ManagerService()
    {
        $this->privates['security.authentication.manager'] = $instance = new \Symfony\Component\Security\Core\Authentication\AuthenticationProviderManager(new RewindableGenerator(function () {
            yield 0 => ($this->privates['security.authentication.provider.dao.secured_area'] ?? $this->load('getSecurity_Authentication_Provider_Dao_SecuredAreaService'));
            yield 1 => ($this->privates['security.authentication.provider.anonymous.main'] ?? ($this->privates['security.authentication.provider.anonymous.main'] = new \Symfony\Component\Security\Core\Authentication\Provider\AnonymousAuthenticationProvider($this->getParameter('container.build_hash'))));
        }, 2), true);

        $instance->setEventDispatcher(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));

        return $instance;
    }

    /*
     * Gets the private 'security.firewall' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\EventListener\FirewallListener
     */
    protected function getSecurity_FirewallService()
    {
        return $this->privates['security.firewall'] = new \Symfony\Bundle\SecurityBundle\EventListener\FirewallListener(($this->privates['security.firewall.map'] ?? $this->getSecurity_Firewall_MapService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['security.logout_url_generator'] ?? $this->getSecurity_LogoutUrlGeneratorService()));
    }

    /*
     * Gets the private 'security.firewall.map' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\Security\FirewallMap
     */
    protected function getSecurity_Firewall_MapService()
    {
        return $this->privates['security.firewall.map'] = new \Symfony\Bundle\SecurityBundle\Security\FirewallMap(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'security.firewall.map.context.dev' => ['privates', 'security.firewall.map.context.dev', 'getSecurity_Firewall_Map_Context_DevService', true],
            'security.firewall.map.context.login' => ['privates', 'security.firewall.map.context.login', 'getSecurity_Firewall_Map_Context_LoginService', true],
            'security.firewall.map.context.main' => ['privates', 'security.firewall.map.context.main', 'getSecurity_Firewall_Map_Context_MainService', true],
            'security.firewall.map.context.secured_area' => ['privates', 'security.firewall.map.context.secured_area', 'getSecurity_Firewall_Map_Context_SecuredAreaService', true],
            'security.firewall.map.context.twig_inspector' => ['privates', 'security.firewall.map.context.twig_inspector', 'getSecurity_Firewall_Map_Context_TwigInspectorService', true],
        ], [
            'security.firewall.map.context.dev' => '?',
            'security.firewall.map.context.login' => '?',
            'security.firewall.map.context.main' => '?',
            'security.firewall.map.context.secured_area' => '?',
            'security.firewall.map.context.twig_inspector' => '?',
        ]), new RewindableGenerator(function () {
            yield 'security.firewall.map.context.dev' => ($this->privates['.security.request_matcher.Iy.T22O'] ?? ($this->privates['.security.request_matcher.Iy.T22O'] = new \Symfony\Component\HttpFoundation\RequestMatcher('^/(_(profiler|wdt)|css|images|js)/')));
            yield 'security.firewall.map.context.login' => ($this->privates['.security.request_matcher.LSAvh7L'] ?? ($this->privates['.security.request_matcher.LSAvh7L'] = new \Symfony\Component\HttpFoundation\RequestMatcher('^/demo/secured/login$')));
            yield 'security.firewall.map.context.secured_area' => ($this->privates['.security.request_matcher.1nJhEMn'] ?? ($this->privates['.security.request_matcher.1nJhEMn'] = new \Symfony\Component\HttpFoundation\RequestMatcher('^/demo/secured/')));
            yield 'security.firewall.map.context.twig_inspector' => ($this->privates['.security.request_matcher.2UcfO3x'] ?? ($this->privates['.security.request_matcher.2UcfO3x'] = new \Symfony\Component\HttpFoundation\RequestMatcher('^/_template/')));
            yield 'security.firewall.map.context.main' => NULL;
        }, 5));
    }

    /*
     * Gets the private 'security.logout_url_generator' shared service.
     *
     * @return \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator
     */
    protected function getSecurity_LogoutUrlGeneratorService()
    {
        $this->privates['security.logout_url_generator'] = $instance = new \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->services['router'] ?? $this->getRouterService()), ($this->services['security.token_storage'] ?? $this->getSecurity_TokenStorageService()));

        $instance->registerListener('secured_area', '_demo_logout', 'logout', '_csrf_token', NULL, NULL);

        return $instance;
    }

    /*
     * Gets the private 'security.role_hierarchy' shared service.
     *
     * @return \Symfony\Component\Security\Core\Role\RoleHierarchy
     */
    protected function getSecurity_RoleHierarchyService()
    {
        return $this->privates['security.role_hierarchy'] = new \Symfony\Component\Security\Core\Role\RoleHierarchy($this->parameters['security.role_hierarchy.roles']);
    }

    /*
     * Gets the private 'sensio_framework_extra.controller.listener' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\EventListener\ControllerListener
     */
    protected function getSensioFrameworkExtra_Controller_ListenerService()
    {
        return $this->privates['sensio_framework_extra.controller.listener'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\ControllerListener(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()));
    }

    /*
     * Gets the private 'sensio_framework_extra.converter.listener' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\EventListener\ParamConverterListener
     */
    protected function getSensioFrameworkExtra_Converter_ListenerService()
    {
        $a = new \Sensio\Bundle\FrameworkExtraBundle\Request\ParamConverter\ParamConverterManager();
        $a->add(new \Sensio\Bundle\FrameworkExtraBundle\Request\ParamConverter\DoctrineParamConverter(($this->services['doctrine'] ?? $this->getDoctrineService()), new \Symfony\Component\ExpressionLanguage\ExpressionLanguage()), 0, 'doctrine.orm');
        $a->add(new \Sensio\Bundle\FrameworkExtraBundle\Request\ParamConverter\DateTimeParamConverter(), 0, 'datetime');

        return $this->privates['sensio_framework_extra.converter.listener'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\ParamConverterListener($a, true);
    }

    /*
     * Gets the private 'sensio_framework_extra.security.listener' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\EventListener\SecurityListener
     */
    protected function getSensioFrameworkExtra_Security_ListenerService()
    {
        return $this->privates['sensio_framework_extra.security.listener'] = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\SecurityListener(($this->privates['framework_extra_bundle.argument_name_convertor'] ?? $this->getFrameworkExtraBundle_ArgumentNameConvertorService()), new \Sensio\Bundle\FrameworkExtraBundle\Security\ExpressionLanguage(), ($this->privates['security.authentication.trust_resolver'] ?? ($this->privates['security.authentication.trust_resolver'] = new \Symfony\Component\Security\Core\Authentication\AuthenticationTrustResolver())), ($this->privates['security.role_hierarchy'] ?? $this->getSecurity_RoleHierarchyService()), ($this->services['security.token_storage'] ?? $this->getSecurity_TokenStorageService()), ($this->services['security.authorization_checker'] ?? $this->getSecurity_AuthorizationCheckerService()), ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()));
    }

    /*
     * Gets the private 'sensio_framework_extra.view.listener' shared service.
     *
     * @return \Sensio\Bundle\FrameworkExtraBundle\EventListener\TemplateListener
     */
    protected function getSensioFrameworkExtra_View_ListenerService()
    {
        $this->privates['sensio_framework_extra.view.listener'] = $instance = new \Sensio\Bundle\FrameworkExtraBundle\EventListener\TemplateListener(new \Sensio\Bundle\FrameworkExtraBundle\Templating\TemplateGuesser(($this->services['kernel'] ?? $this->get('kernel', 1))));

        $instance->setContainer((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'twig' => ['services', 'twig', 'getTwigService', false],
        ], [
            'twig' => 'Twig\\Environment',
        ]))->withContext('sensio_framework_extra.view.listener', $this));

        return $instance;
    }

    /*
     * Gets the private 'session_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\SessionListener
     */
    protected function getSessionListenerService()
    {
        return $this->privates['session_listener'] = new \Symfony\Component\HttpKernel\EventListener\SessionListener(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'initialized_session' => ['services', 'session', NULL, false],
            'logger' => ['privates', 'monolog.logger', 'getMonolog_LoggerService', false],
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
            'session' => ['services', 'session', 'getSessionService', false],
            'session_storage' => ['privates', 'zikula_core.bridge.http_foundation.zikula_session_storage_file', 'getZikulaCore_Bridge_HttpFoundation_ZikulaSessionStorageFileService', false],
        ], [
            'initialized_session' => '?',
            'logger' => '?',
            'request_stack' => '?',
            'session' => '?',
            'session_storage' => '?',
        ]), false);
    }

    /*
     * Gets the private 'stof_doctrine_extensions.event_listener.blame' shared service.
     *
     * @return \Stof\DoctrineExtensionsBundle\EventListener\BlameListener
     */
    protected function getStofDoctrineExtensions_EventListener_BlameService()
    {
        return $this->privates['stof_doctrine_extensions.event_listener.blame'] = new \Stof\DoctrineExtensionsBundle\EventListener\BlameListener(($this->privates['stof_doctrine_extensions.listener.blameable'] ?? $this->getStofDoctrineExtensions_Listener_BlameableService()), ($this->services['security.token_storage'] ?? $this->getSecurity_TokenStorageService()), ($this->services['security.authorization_checker'] ?? $this->getSecurity_AuthorizationCheckerService()));
    }

    /*
     * Gets the private 'stof_doctrine_extensions.event_listener.locale' shared service.
     *
     * @return \Stof\DoctrineExtensionsBundle\EventListener\LocaleListener
     */
    protected function getStofDoctrineExtensions_EventListener_LocaleService()
    {
        return $this->privates['stof_doctrine_extensions.event_listener.locale'] = new \Stof\DoctrineExtensionsBundle\EventListener\LocaleListener(($this->privates['stof_doctrine_extensions.listener.translatable'] ?? $this->getStofDoctrineExtensions_Listener_TranslatableService()));
    }

    /*
     * Gets the private 'stof_doctrine_extensions.event_listener.logger' shared service.
     *
     * @return \Stof\DoctrineExtensionsBundle\EventListener\LoggerListener
     */
    protected function getStofDoctrineExtensions_EventListener_LoggerService()
    {
        return $this->privates['stof_doctrine_extensions.event_listener.logger'] = new \Stof\DoctrineExtensionsBundle\EventListener\LoggerListener(($this->privates['stof_doctrine_extensions.listener.loggable'] ?? $this->getStofDoctrineExtensions_Listener_LoggableService()), ($this->services['security.token_storage'] ?? $this->getSecurity_TokenStorageService()), ($this->services['security.authorization_checker'] ?? $this->getSecurity_AuthorizationCheckerService()));
    }

    /*
     * Gets the private 'stof_doctrine_extensions.listener.blameable' shared service.
     *
     * @return \Gedmo\Blameable\BlameableListener
     */
    protected function getStofDoctrineExtensions_Listener_BlameableService()
    {
        $this->privates['stof_doctrine_extensions.listener.blameable'] = $instance = new \Gedmo\Blameable\BlameableListener();

        $instance->setAnnotationReader(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()));

        return $instance;
    }

    /*
     * Gets the private 'stof_doctrine_extensions.listener.loggable' shared service.
     *
     * @return \Gedmo\Loggable\LoggableListener
     */
    protected function getStofDoctrineExtensions_Listener_LoggableService()
    {
        $this->privates['stof_doctrine_extensions.listener.loggable'] = $instance = new \Gedmo\Loggable\LoggableListener();

        $instance->setAnnotationReader(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()));

        return $instance;
    }

    /*
     * Gets the private 'stof_doctrine_extensions.listener.translatable' shared service.
     *
     * @return \Gedmo\Translatable\TranslatableListener
     */
    protected function getStofDoctrineExtensions_Listener_TranslatableService()
    {
        $this->privates['stof_doctrine_extensions.listener.translatable'] = $instance = new \Gedmo\Translatable\TranslatableListener();

        $instance->setAnnotationReader(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()));
        $instance->setDefaultLocale('en_US');
        $instance->setTranslatableLocale('en_US');
        $instance->setTranslationFallback(true);
        $instance->setPersistDefaultLocaleTranslation(false);
        $instance->setSkipOnLoad(false);

        return $instance;
    }

    /*
     * Gets the private 'stof_doctrine_extensions.listener.uploadable' shared service.
     *
     * @return \Gedmo\Uploadable\UploadableListener
     */
    protected function getStofDoctrineExtensions_Listener_UploadableService()
    {
        $this->privates['stof_doctrine_extensions.listener.uploadable'] = $instance = new \Gedmo\Uploadable\UploadableListener(new \Stof\DoctrineExtensionsBundle\Uploadable\MimeTypeGuesserAdapter());

        $instance->setAnnotationReader(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()));
        $instance->setDefaultFileInfoClass('Stof\\DoctrineExtensionsBundle\\Uploadable\\UploadedFileInfo');
        (new \Stof\DoctrineExtensionsBundle\Uploadable\ValidatorConfigurator(true))->configure($instance);

        return $instance;
    }

    /*
     * Gets the private 'translator.default' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Translation\Translator
     */
    protected function getTranslator_DefaultService()
    {
        $this->privates['translator.default'] = $instance = new \Symfony\Bundle\FrameworkBundle\Translation\Translator(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'translation.loader.csv' => ['privates', 'translation.loader.csv', 'getTranslation_Loader_CsvService', true],
            'translation.loader.dat' => ['privates', 'translation.loader.dat', 'getTranslation_Loader_DatService', true],
            'translation.loader.ini' => ['privates', 'translation.loader.ini', 'getTranslation_Loader_IniService', true],
            'translation.loader.json' => ['privates', 'translation.loader.json', 'getTranslation_Loader_JsonService', true],
            'translation.loader.mo' => ['privates', 'translation.loader.mo', 'getTranslation_Loader_MoService', true],
            'translation.loader.php' => ['privates', 'translation.loader.php', 'getTranslation_Loader_PhpService', true],
            'translation.loader.po' => ['privates', 'translation.loader.po', 'getTranslation_Loader_PoService', true],
            'translation.loader.qt' => ['privates', 'translation.loader.qt', 'getTranslation_Loader_QtService', true],
            'translation.loader.res' => ['privates', 'translation.loader.res', 'getTranslation_Loader_ResService', true],
            'translation.loader.xliff' => ['privates', 'translation.loader.xliff', 'getTranslation_Loader_XliffService', true],
            'translation.loader.yml' => ['privates', 'translation.loader.yml', 'getTranslation_Loader_YmlService', true],
        ], [
            'translation.loader.csv' => '?',
            'translation.loader.dat' => '?',
            'translation.loader.ini' => '?',
            'translation.loader.json' => '?',
            'translation.loader.mo' => '?',
            'translation.loader.php' => '?',
            'translation.loader.po' => '?',
            'translation.loader.qt' => '?',
            'translation.loader.res' => '?',
            'translation.loader.xliff' => '?',
            'translation.loader.yml' => '?',
        ]), new \Symfony\Component\Translation\Formatter\MessageFormatter(new \Symfony\Component\Translation\IdentityTranslator()), 'en', ['translation.loader.php' => [0 => 'php'], 'translation.loader.yml' => [0 => 'yaml', 1 => 'yml'], 'translation.loader.xliff' => [0 => 'xlf', 1 => 'xliff'], 'translation.loader.po' => [0 => 'po'], 'translation.loader.mo' => [0 => 'mo'], 'translation.loader.qt' => [0 => 'ts'], 'translation.loader.csv' => [0 => 'csv'], 'translation.loader.res' => [0 => 'res'], 'translation.loader.dat' => [0 => 'dat'], 'translation.loader.ini' => [0 => 'ini'], 'translation.loader.json' => [0 => 'json']], ['cache_dir' => ($this->targetDir.''.'/translations'), 'debug' => false, 'resource_files' => ['af' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.af.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.af.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.af.xlf')], 'ar' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.ar.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.ar.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.ar.xlf')], 'az' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.az.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.az.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.az.xlf')], 'be' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.be.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.be.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.be.xlf')], 'bg' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.bg.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.bg.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.bg.xlf')], 'bs' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.bs.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.bs.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.bs.xlf')], 'ca' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.ca.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.ca.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.ca.xlf')], 'cs' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.cs.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.cs.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.cs.xlf')], 'cy' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.cy.xlf')], 'da' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.da.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.da.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.da.xlf')], 'de' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.de.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.de.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.de.xlf')], 'el' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.el.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.el.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.el.xlf')], 'en' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.en.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.en.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.en.xlf'), 3 => (\dirname(__DIR__, 4).'/translations/mail.en.yaml'), 4 => (\dirname(__DIR__, 4).'/translations/messages.en.yaml'), 5 => (\dirname(__DIR__, 4).'/translations/routes.en.yaml'), 6 => (\dirname(__DIR__, 4).'/translations/security.en.yaml'), 7 => (\dirname(__DIR__, 4).'/translations/validators.en.yaml')], 'es' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.es.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.es.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.es.xlf')], 'et' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.et.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.et.xlf')], 'eu' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.eu.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.eu.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.eu.xlf')], 'fa' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.fa.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.fa.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.fa.xlf')], 'fi' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.fi.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.fi.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.fi.xlf')], 'fr' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.fr.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.fr.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.fr.xlf')], 'gl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.gl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.gl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.gl.xlf')], 'he' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.he.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.he.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.he.xlf')], 'hr' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.hr.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.hr.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.hr.xlf')], 'hu' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.hu.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.hu.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.hu.xlf')], 'hy' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.hy.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.hy.xlf')], 'id' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.id.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.id.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.id.xlf')], 'it' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.it.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.it.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.it.xlf')], 'ja' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.ja.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.ja.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.ja.xlf')], 'lb' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.lb.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.lb.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.lb.xlf')], 'lt' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.lt.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.lt.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.lt.xlf')], 'lv' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.lv.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.lv.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.lv.xlf')], 'mn' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.mn.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.mn.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.mn.xlf')], 'nb' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.nb.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.nb.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.nb.xlf')], 'nl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.nl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.nl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.nl.xlf')], 'nn' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.nn.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.nn.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.nn.xlf')], 'no' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.no.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.no.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.no.xlf')], 'pl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.pl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.pl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.pl.xlf')], 'pt' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.pt.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.pt.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.pt.xlf')], 'pt_BR' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.pt_BR.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.pt_BR.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.pt_BR.xlf')], 'ro' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.ro.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.ro.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.ro.xlf')], 'ru' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.ru.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.ru.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.ru.xlf')], 'sk' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.sk.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.sk.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.sk.xlf')], 'sl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.sl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.sl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.sl.xlf')], 'sq' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.sq.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.sq.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.sq.xlf')], 'sr_Cyrl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.sr_Cyrl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.sr_Cyrl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.sr_Cyrl.xlf')], 'sr_Latn' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.sr_Latn.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.sr_Latn.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.sr_Latn.xlf')], 'sv' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.sv.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.sv.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.sv.xlf')], 'th' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.th.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.th.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.th.xlf')], 'tl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.tl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.tl.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.tl.xlf')], 'tr' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.tr.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.tr.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.tr.xlf')], 'uk' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.uk.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.uk.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.uk.xlf')], 'vi' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.vi.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.vi.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.vi.xlf')], 'zh_CN' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.zh_CN.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.zh_CN.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.zh_CN.xlf')], 'zh_TW' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations/validators.zh_TW.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations/validators.zh_TW.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations/security.zh_TW.xlf')]], 'scanned_directories' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations'), 1 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations'), 2 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations'), 3 => (\dirname(__DIR__, 4).'/translations'), 4 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/FrameworkBundle/translations'), 5 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/SecurityBundle/translations'), 6 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/TwigBundle/translations'), 7 => (\dirname(__DIR__, 4).'/vendor/symfony/monolog-bundle/translations'), 8 => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/translations'), 9 => (\dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/translations'), 10 => (\dirname(__DIR__, 4).'/vendor/antishov/doctrine-extensions-bundle/translations'), 11 => (\dirname(__DIR__, 4).'/vendor/twig/extra-bundle/translations'), 12 => (\dirname(__DIR__, 4).'/vendor/zikula/core-bundle/translations'), 13 => (\dirname(__DIR__, 4).'/vendor/zikula/coreinstaller-bundle/translations'), 14 => (\dirname(__DIR__, 4).'/vendor/zikula/formextension-bundle/translations'), 15 => (\dirname(__DIR__, 4).'/vendor/zikula/hook-bundle/translations'), 16 => (\dirname(__DIR__, 4).'/vendor/jms/i18n-routing-bundle/JMS/I18nRoutingBundle/translations'), 17 => (\dirname(__DIR__, 4).'/vendor/friendsofsymfony/jsrouting-bundle/translations'), 18 => (\dirname(__DIR__, 4).'/vendor/matthiasnoback/symfony-console-form/src/Bundle/translations'), 19 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-menu-bundle/src/translations'), 20 => (\dirname(__DIR__, 4).'/vendor/liip/imagine-bundle/translations'), 21 => (\dirname(__DIR__, 4).'/vendor/php-translation/symfony-bundle/translations'), 22 => (\dirname(__DIR__, 4).'/vendor/willdurand/js-translation-bundle/translations'), 23 => (\dirname(__DIR__, 4).'/vendor/zikula/workflow-bundle/translations'), 24 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/DebugBundle/translations'), 25 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/WebProfilerBundle/translations'), 26 => (\dirname(__DIR__, 4).'/vendor/symfony/maker-bundle/src/translations'), 27 => (\dirname(__DIR__, 4).'/vendor/oro/twig-inspector/Bundle/translations'), 28 => (\dirname(__DIR__, 4).'/vendor/zikula/admin-module/translations'), 29 => (\dirname(__DIR__, 4).'/vendor/zikula/blocks-module/translations'), 30 => (\dirname(__DIR__, 4).'/vendor/zikula/categories-module/translations'), 31 => (\dirname(__DIR__, 4).'/vendor/zikula/extensions-module/translations'), 32 => (\dirname(__DIR__, 4).'/vendor/zikula/groups-module/translations'), 33 => (\dirname(__DIR__, 4).'/vendor/zikula/mailer-module/translations'), 34 => (\dirname(__DIR__, 4).'/vendor/zikula/menu-module/translations'), 35 => (\dirname(__DIR__, 4).'/vendor/zikula/permissions-module/translations'), 36 => (\dirname(__DIR__, 4).'/vendor/zikula/routes-module/translations'), 37 => (\dirname(__DIR__, 4).'/vendor/zikula/search-module/translations'), 38 => (\dirname(__DIR__, 4).'/vendor/zikula/securitycenter-module/translations'), 39 => (\dirname(__DIR__, 4).'/vendor/zikula/settings-module/translations'), 40 => (\dirname(__DIR__, 4).'/vendor/zikula/theme-module/translations'), 41 => (\dirname(__DIR__, 4).'/vendor/zikula/users-module/translations'), 42 => (\dirname(__DIR__, 4).'/vendor/zikula/zauth-module/translations'), 43 => (\dirname(__DIR__, 4).'/vendor/zikula/atom-theme/translations'), 44 => (\dirname(__DIR__, 4).'/vendor/zikula/bootstrap-theme/translations'), 45 => (\dirname(__DIR__, 4).'/vendor/zikula/printer-theme/translations'), 46 => (\dirname(__DIR__, 4).'/vendor/zikula/rss-theme/translations')], 'cache_vary' => ['scanned_directories' => [0 => 'vendor/symfony/symfony/src/Symfony/Component/Validator/Resources/translations', 1 => 'vendor/symfony/symfony/src/Symfony/Component/Form/Resources/translations', 2 => 'vendor/symfony/symfony/src/Symfony/Component/Security/Core/Resources/translations', 3 => 'translations', 4 => 'vendor/symfony/symfony/src/Symfony/Bundle/FrameworkBundle/translations', 5 => 'vendor/symfony/symfony/src/Symfony/Bundle/SecurityBundle/translations', 6 => 'vendor/symfony/symfony/src/Symfony/Bundle/TwigBundle/translations', 7 => 'vendor/symfony/monolog-bundle/translations', 8 => 'vendor/doctrine/doctrine-bundle/translations', 9 => 'vendor/sensio/framework-extra-bundle/src/translations', 10 => 'vendor/antishov/doctrine-extensions-bundle/translations', 11 => 'vendor/twig/extra-bundle/translations', 12 => 'vendor/zikula/core-bundle/translations', 13 => 'vendor/zikula/coreinstaller-bundle/translations', 14 => 'vendor/zikula/formextension-bundle/translations', 15 => 'vendor/zikula/hook-bundle/translations', 16 => 'vendor/jms/i18n-routing-bundle/JMS/I18nRoutingBundle/translations', 17 => 'vendor/friendsofsymfony/jsrouting-bundle/translations', 18 => 'vendor/matthiasnoback/symfony-console-form/src/Bundle/translations', 19 => 'vendor/knplabs/knp-menu-bundle/src/translations', 20 => 'vendor/liip/imagine-bundle/translations', 21 => 'vendor/php-translation/symfony-bundle/translations', 22 => 'vendor/willdurand/js-translation-bundle/translations', 23 => 'vendor/zikula/workflow-bundle/translations', 24 => 'vendor/symfony/symfony/src/Symfony/Bundle/DebugBundle/translations', 25 => 'vendor/symfony/symfony/src/Symfony/Bundle/WebProfilerBundle/translations', 26 => 'vendor/symfony/maker-bundle/src/translations', 27 => 'vendor/oro/twig-inspector/Bundle/translations', 28 => 'vendor/zikula/admin-module/translations', 29 => 'vendor/zikula/blocks-module/translations', 30 => 'vendor/zikula/categories-module/translations', 31 => 'vendor/zikula/extensions-module/translations', 32 => 'vendor/zikula/groups-module/translations', 33 => 'vendor/zikula/mailer-module/translations', 34 => 'vendor/zikula/menu-module/translations', 35 => 'vendor/zikula/permissions-module/translations', 36 => 'vendor/zikula/routes-module/translations', 37 => 'vendor/zikula/search-module/translations', 38 => 'vendor/zikula/securitycenter-module/translations', 39 => 'vendor/zikula/settings-module/translations', 40 => 'vendor/zikula/theme-module/translations', 41 => 'vendor/zikula/users-module/translations', 42 => 'vendor/zikula/zauth-module/translations', 43 => 'vendor/zikula/atom-theme/translations', 44 => 'vendor/zikula/bootstrap-theme/translations', 45 => 'vendor/zikula/printer-theme/translations', 46 => 'vendor/zikula/rss-theme/translations']]], []);

        $instance->setConfigCacheFactory(($this->privates['config_cache_factory'] ?? ($this->privates['config_cache_factory'] = new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory())));
        $instance->setFallbackLocales($this->parameters['localisation.locales']);

        return $instance;
    }

    /*
     * Gets the private 'twig.loader.native_filesystem' shared service.
     *
     * @return \Twig\Loader\FilesystemLoader
     */
    protected function getTwig_Loader_NativeFilesystemService()
    {
        $this->privates['twig.loader.native_filesystem'] = $instance = new \Twig\Loader\FilesystemLoader([], \dirname(__DIR__, 4));

        $instance->addPath((\dirname(__DIR__, 4).'/vendor/knplabs/knp-menu/src/Knp/Menu/Resources/views'));
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/SecurityBundle/Resources/views'), 'Security');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/SecurityBundle/Resources/views'), '!Security');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/Resources/views'), 'Doctrine');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/Resources/views'), '!Doctrine');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/core-bundle/Resources/views'), 'Core');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/core-bundle/Resources/views'), '!Core');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/coreinstaller-bundle/Resources/views'), 'ZikulaCoreInstaller');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/coreinstaller-bundle/Resources/views'), '!ZikulaCoreInstaller');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/formextension-bundle/Resources/views'), 'ZikulaFormExtension');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/formextension-bundle/Resources/views'), '!ZikulaFormExtension');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/hook-bundle/Resources/views'), 'ZikulaHook');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/hook-bundle/Resources/views'), '!ZikulaHook');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/knplabs/knp-menu-bundle/src/Resources/views'), 'KnpMenu');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/knplabs/knp-menu-bundle/src/Resources/views'), '!KnpMenu');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/liip/imagine-bundle/Resources/views'), 'LiipImagine');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/liip/imagine-bundle/Resources/views'), '!LiipImagine');
        $instance->addPath((\dirname(__DIR__, 4).'/templates/bundles/TranslationBundle'), 'Translation');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/php-translation/symfony-bundle/Resources/views'), 'Translation');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/php-translation/symfony-bundle/Resources/views'), '!Translation');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/willdurand/js-translation-bundle/Resources/views'), 'BazingaJsTranslation');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/willdurand/js-translation-bundle/Resources/views'), '!BazingaJsTranslation');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/workflow-bundle/Resources/views'), 'ZikulaWorkflow');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/workflow-bundle/Resources/views'), '!ZikulaWorkflow');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/DebugBundle/Resources/views'), 'Debug');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/DebugBundle/Resources/views'), '!Debug');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/WebProfilerBundle/Resources/views'), 'WebProfiler');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/WebProfilerBundle/Resources/views'), '!WebProfiler');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/oro/twig-inspector/Bundle/Resources/views'), 'OroTwigInspector');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/oro/twig-inspector/Bundle/Resources/views'), '!OroTwigInspector');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/admin-module/Resources/views'), 'ZikulaAdminModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/admin-module/Resources/views'), '!ZikulaAdminModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/blocks-module/Resources/views'), 'ZikulaBlocksModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/blocks-module/Resources/views'), '!ZikulaBlocksModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/categories-module/Resources/views'), 'ZikulaCategoriesModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/categories-module/Resources/views'), '!ZikulaCategoriesModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/extensions-module/Resources/views'), 'ZikulaExtensionsModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/extensions-module/Resources/views'), '!ZikulaExtensionsModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/groups-module/Resources/views'), 'ZikulaGroupsModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/groups-module/Resources/views'), '!ZikulaGroupsModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/mailer-module/Resources/views'), 'ZikulaMailerModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/mailer-module/Resources/views'), '!ZikulaMailerModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/menu-module/Resources/views'), 'ZikulaMenuModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/menu-module/Resources/views'), '!ZikulaMenuModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/permissions-module/Resources/views'), 'ZikulaPermissionsModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/permissions-module/Resources/views'), '!ZikulaPermissionsModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/routes-module/Resources/views'), 'ZikulaRoutesModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/routes-module/Resources/views'), '!ZikulaRoutesModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/search-module/Resources/views'), 'ZikulaSearchModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/search-module/Resources/views'), '!ZikulaSearchModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/securitycenter-module/Resources/views'), 'ZikulaSecurityCenterModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/securitycenter-module/Resources/views'), '!ZikulaSecurityCenterModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/settings-module/Resources/views'), 'ZikulaSettingsModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/settings-module/Resources/views'), '!ZikulaSettingsModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/theme-module/Resources/views'), 'ZikulaThemeModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/theme-module/Resources/views'), '!ZikulaThemeModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/users-module/Resources/views'), 'ZikulaUsersModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/users-module/Resources/views'), '!ZikulaUsersModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/zauth-module/Resources/views'), 'ZikulaZAuthModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/zauth-module/Resources/views'), '!ZikulaZAuthModule');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/atom-theme/Resources/views'), 'ZikulaAtomTheme');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/atom-theme/Resources/views'), '!ZikulaAtomTheme');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/bootstrap-theme/Resources/views'), 'ZikulaBootstrapTheme');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/bootstrap-theme/Resources/views'), '!ZikulaBootstrapTheme');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/printer-theme/Resources/views'), 'ZikulaPrinterTheme');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/printer-theme/Resources/views'), '!ZikulaPrinterTheme');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/rss-theme/Resources/views'), 'ZikulaRssTheme');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/zikula/rss-theme/Resources/views'), '!ZikulaRssTheme');
        $instance->addPath((\dirname(__DIR__, 4).'/templates'));
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bridge/Twig/Resources/views/Email'), 'email');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bridge/Twig/Resources/views/Email'), '!email');
        $instance->addPath((\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bridge/Twig/Resources/views/Form'));

        return $instance;
    }

    /*
     * Gets the private 'validator.builder' shared service.
     *
     * @return \Symfony\Component\Validator\ValidatorBuilder
     */
    protected function getValidator_BuilderService()
    {
        $this->privates['validator.builder'] = $instance = \Symfony\Component\Validator\Validation::createValidatorBuilder();

        $instance->setConstraintValidatorFactory(new \Symfony\Component\Validator\ContainerConstraintValidatorFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => ['privates', 'validator.email', 'getValidator_EmailService', true],
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => ['privates', 'validator.not_compromised_password', 'getValidator_NotCompromisedPasswordService', true],
            'Zikula\\Bundle\\CoreInstallerBundle\\Validator\\Constraints\\AuthenticateAdminLoginValidator' => ['privates', 'Zikula\\Bundle\\CoreInstallerBundle\\Validator\\Constraints\\AuthenticateAdminLoginValidator', 'getAuthenticateAdminLoginValidatorService', true],
            'Zikula\\Bundle\\CoreInstallerBundle\\Validator\\Constraints\\ValidPdoConnectionValidator' => ['privates', 'Zikula\\Bundle\\CoreInstallerBundle\\Validator\\Constraints\\ValidPdoConnectionValidator', 'getValidPdoConnectionValidatorService', true],
            'Zikula\\CategoriesModule\\Validator\\Constraints\\UniqueNameForPositionValidator' => ['privates', 'Zikula\\CategoriesModule\\Validator\\Constraints\\UniqueNameForPositionValidator', 'getUniqueNameForPositionValidatorService', true],
            'Zikula\\GroupsModule\\Validator\\Constraints\\ValidGroupNameValidator' => ['privates', 'Zikula\\GroupsModule\\Validator\\Constraints\\ValidGroupNameValidator', 'getValidGroupNameValidatorService', true],
            'Zikula\\RoutesModule\\Validator\\Constraints\\ListEntryValidator' => ['privates', 'Zikula\\RoutesModule\\Validator\\Constraints\\ListEntryValidator', 'getListEntryValidatorService', true],
            'Zikula\\UsersModule\\Validator\\Constraints\\ValidEmailValidator' => ['privates', 'Zikula\\UsersModule\\Validator\\Constraints\\ValidEmailValidator', 'getValidEmailValidatorService', true],
            'Zikula\\UsersModule\\Validator\\Constraints\\ValidUnameValidator' => ['privates', 'Zikula\\UsersModule\\Validator\\Constraints\\ValidUnameValidator', 'getValidUnameValidatorService', true],
            'Zikula\\UsersModule\\Validator\\Constraints\\ValidUserFieldsValidator' => ['privates', 'Zikula\\UsersModule\\Validator\\Constraints\\ValidUserFieldsValidator', 'getValidUserFieldsValidatorService', true],
            'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidAntiSpamAnswerValidator' => ['privates', 'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidAntiSpamAnswerValidator', 'getValidAntiSpamAnswerValidatorService', true],
            'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidPasswordChangeValidator' => ['privates', 'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidPasswordChangeValidator', 'getValidPasswordChangeValidatorService', true],
            'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidPasswordValidator' => ['privates', 'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidPasswordValidator', 'getValidPasswordValidatorService', true],
            'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidRegistrationVerificationValidator' => ['privates', 'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidRegistrationVerificationValidator', 'getValidRegistrationVerificationValidatorService', true],
            'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidUserFieldsValidator' => ['privates', 'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidUserFieldsValidator', 'getValidUserFieldsValidator2Service', true],
            'doctrine.orm.validator.unique' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'security.validator.user_password' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
            'validator.expression' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
        ], [
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => '?',
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => '?',
            'Zikula\\Bundle\\CoreInstallerBundle\\Validator\\Constraints\\AuthenticateAdminLoginValidator' => '?',
            'Zikula\\Bundle\\CoreInstallerBundle\\Validator\\Constraints\\ValidPdoConnectionValidator' => '?',
            'Zikula\\CategoriesModule\\Validator\\Constraints\\UniqueNameForPositionValidator' => '?',
            'Zikula\\GroupsModule\\Validator\\Constraints\\ValidGroupNameValidator' => '?',
            'Zikula\\RoutesModule\\Validator\\Constraints\\ListEntryValidator' => '?',
            'Zikula\\UsersModule\\Validator\\Constraints\\ValidEmailValidator' => '?',
            'Zikula\\UsersModule\\Validator\\Constraints\\ValidUnameValidator' => '?',
            'Zikula\\UsersModule\\Validator\\Constraints\\ValidUserFieldsValidator' => '?',
            'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidAntiSpamAnswerValidator' => '?',
            'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidPasswordChangeValidator' => '?',
            'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidPasswordValidator' => '?',
            'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidRegistrationVerificationValidator' => '?',
            'Zikula\\ZAuthModule\\Validator\\Constraints\\ValidUserFieldsValidator' => '?',
            'doctrine.orm.validator.unique' => '?',
            'security.validator.user_password' => '?',
            'validator.expression' => '?',
        ])));
        if ($this->has('translator')) {
            $instance->setTranslator(($this->services['translator'] ?? $this->getTranslatorService()));
        }
        $instance->setTranslationDomain('validators');
        $instance->addXmlMappings([0 => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Component/Form/Resources/config/validation.xml')]);
        $instance->addYamlMappings([0 => (\dirname(__DIR__, 4).'/vendor/php-translation/symfony-bundle/Resources/config/validation.yaml')]);
        $instance->enableAnnotationMapping(($this->privates['annotations.cached_reader'] ?? $this->getAnnotations_CachedReaderService()));
        $instance->addMethodMapping('loadValidatorMetadata');
        $instance->setMappingCache(\Symfony\Component\Cache\Adapter\PhpArrayAdapter::create(($this->targetDir.''.'/validation.php'), ($this->privates['cache.validator'] ?? $this->getCache_ValidatorService())));
        $instance->addObjectInitializers([0 => new \Symfony\Bridge\Doctrine\Validator\DoctrineInitializer(($this->services['doctrine'] ?? $this->getDoctrineService()))]);
        $instance->addLoader(new \Symfony\Bridge\Doctrine\Validator\DoctrineLoader(($this->services['doctrine.orm.default_entity_manager'] ?? $this->getDoctrine_Orm_DefaultEntityManagerService()), NULL));

        return $instance;
    }

    /*
     * Gets the private 'var_dumper.html_dumper' shared service.
     *
     * @return \Symfony\Component\VarDumper\Dumper\HtmlDumper
     */
    protected function getVarDumper_HtmlDumperService()
    {
        $this->privates['var_dumper.html_dumper'] = $instance = new \Symfony\Component\VarDumper\Dumper\HtmlDumper(NULL, 'UTF-8', 0);

        $instance->setDisplayOptions(['fileLinkFormat' => ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService())]);

        return $instance;
    }

    /*
     * Gets the private 'var_dumper.server_connection' shared service.
     *
     * @return \Symfony\Component\VarDumper\Server\Connection
     */
    protected function getVarDumper_ServerConnectionService()
    {
        return $this->privates['var_dumper.server_connection'] = new \Symfony\Component\VarDumper\Server\Connection('tcp://'.$this->getEnv('string:VAR_DUMPER_SERVER'), ['source' => new \Symfony\Component\VarDumper\Dumper\ContextProvider\SourceContextProvider('UTF-8', \dirname(__DIR__, 4), ($this->privates['debug.file_link_formatter'] ?? $this->getDebug_FileLinkFormatterService())), 'request' => new \Symfony\Component\VarDumper\Dumper\ContextProvider\RequestContextProvider(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()))), 'cli' => new \Symfony\Component\VarDumper\Dumper\ContextProvider\CliContextProvider()]);
    }

    /*
     * Gets the private 'workflow.registry' shared service.
     *
     * @return \Symfony\Component\Workflow\Registry
     */
    protected function getWorkflow_RegistryService()
    {
        $this->privates['workflow.registry'] = $instance = new \Symfony\Component\Workflow\Registry();

        $instance->addWorkflow(($this->services['state_machine.zikularoutesmodule_none'] ?? $this->getStateMachine_ZikularoutesmoduleNoneService()), new \Symfony\Component\Workflow\SupportStrategy\InstanceOfSupportStrategy('Zikula\\RoutesModule\\Entity\\RouteEntity'));

        return $instance;
    }

    /*
     * Gets the private 'zikula_core.bridge.http_foundation.zikula_session_storage_file' shared autowired service.
     *
     * @return \Zikula\Bundle\CoreBundle\HttpFoundation\Session\ZikulaSessionStorage
     */
    protected function getZikulaCore_Bridge_HttpFoundation_ZikulaSessionStorageFileService()
    {
        $a = new \Symfony\Component\HttpFoundation\Session\Storage\Handler\StrictSessionHandler(new \Symfony\Component\HttpFoundation\Session\Storage\Handler\NativeFileSessionHandler(($this->targetDir.''.'/sessions')));

        $this->privates['zikula_core.bridge.http_foundation.zikula_session_storage_file'] = $instance = new \Zikula\Bundle\CoreBundle\HttpFoundation\Session\ZikulaSessionStorage(($this->services['Zikula\\ExtensionsModule\\Api\\VariableApi'] ?? $this->getVariableApiService()), $this->parameters['session.storage.options'], $a);

        $instance->setSaveHandler($a);

        return $instance;
    }

    public function getParameter(string $name)
    {
        if (isset($this->buildParameters[$name])) {
            return $this->buildParameters[$name];
        }

        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new InvalidArgumentException(sprintf('The parameter "%s" must be defined.', $name));
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        if (isset($this->buildParameters[$name])) {
            return true;
        }

        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (null === $this->parameterBag) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            foreach ($this->buildParameters as $name => $value) {
                $parameters[$name] = $value;
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [
        'kernel.cache_dir' => false,
        'installed' => false,
        'zikula.session.save_path' => false,
        'kernel.secret' => false,
        'session.save_path' => false,
        'validator.mapping.cache.file' => false,
        'profiler.storage.dsn' => false,
        'doctrine.orm.proxy_dir' => false,
        'matthias_symfony_console_form.cache_directory' => false,
    ];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        switch ($name) {
            case 'kernel.cache_dir': $value = $this->targetDir.''; break;
            case 'installed': $value = $this->getEnv('ZIKULA_INSTALLED'); break;
            case 'zikula.session.save_path': $value = ($this->targetDir.''.'/sessions'); break;
            case 'kernel.secret': $value = $this->getEnv('APP_SECRET'); break;
            case 'session.save_path': $value = ($this->targetDir.''.'/sessions'); break;
            case 'validator.mapping.cache.file': $value = ($this->targetDir.''.'/validation.php'); break;
            case 'profiler.storage.dsn': $value = ('file:'.$this->targetDir.''.'/profiler'); break;
            case 'doctrine.orm.proxy_dir': $value = ($this->targetDir.''.'/doctrine/orm/DoctrineProxy'); break;
            case 'matthias_symfony_console_form.cache_directory': $value = ($this->targetDir.''.'/matthias_symfony_console_form'); break;
            default: throw new InvalidArgumentException(sprintf('The dynamic parameter "%s" must be defined.', $name));
        }
        $this->loadedDynamicParameters[$name] = true;

        return $this->dynamicParameters[$name] = $value;
    }

    protected function getDefaultParameters(): array
    {
        return [
            'kernel.project_dir' => \dirname(__DIR__, 4),
            'kernel.environment' => 'dev',
            'kernel.debug' => false,
            'kernel.logs_dir' => (\dirname(__DIR__, 3).'/log'),
            'kernel.bundles' => [
                'FrameworkBundle' => 'Symfony\\Bundle\\FrameworkBundle\\FrameworkBundle',
                'SecurityBundle' => 'Symfony\\Bundle\\SecurityBundle\\SecurityBundle',
                'TwigBundle' => 'Symfony\\Bundle\\TwigBundle\\TwigBundle',
                'MonologBundle' => 'Symfony\\Bundle\\MonologBundle\\MonologBundle',
                'DoctrineBundle' => 'Doctrine\\Bundle\\DoctrineBundle\\DoctrineBundle',
                'SensioFrameworkExtraBundle' => 'Sensio\\Bundle\\FrameworkExtraBundle\\SensioFrameworkExtraBundle',
                'StofDoctrineExtensionsBundle' => 'Stof\\DoctrineExtensionsBundle\\StofDoctrineExtensionsBundle',
                'TwigExtraBundle' => 'Twig\\Extra\\TwigExtraBundle\\TwigExtraBundle',
                'CoreBundle' => 'Zikula\\Bundle\\CoreBundle\\CoreBundle',
                'ZikulaCoreInstallerBundle' => 'Zikula\\Bundle\\CoreInstallerBundle\\ZikulaCoreInstallerBundle',
                'ZikulaFormExtensionBundle' => 'Zikula\\Bundle\\FormExtensionBundle\\ZikulaFormExtensionBundle',
                'ZikulaHookBundle' => 'Zikula\\Bundle\\HookBundle\\ZikulaHookBundle',
                'JMSI18nRoutingBundle' => 'JMS\\I18nRoutingBundle\\JMSI18nRoutingBundle',
                'FOSJsRoutingBundle' => 'FOS\\JsRoutingBundle\\FOSJsRoutingBundle',
                'SymfonyConsoleFormBundle' => 'Matthias\\SymfonyConsoleForm\\Bundle\\SymfonyConsoleFormBundle',
                'KnpMenuBundle' => 'Knp\\Bundle\\MenuBundle\\KnpMenuBundle',
                'LiipImagineBundle' => 'Liip\\ImagineBundle\\LiipImagineBundle',
                'TranslationBundle' => 'Translation\\Bundle\\TranslationBundle',
                'BazingaJsTranslationBundle' => 'Bazinga\\Bundle\\JsTranslationBundle\\BazingaJsTranslationBundle',
                'ZikulaWorkflowBundle' => 'Zikula\\Bundle\\WorkflowBundle\\ZikulaWorkflowBundle',
                'DebugBundle' => 'Symfony\\Bundle\\DebugBundle\\DebugBundle',
                'WebProfilerBundle' => 'Symfony\\Bundle\\WebProfilerBundle\\WebProfilerBundle',
                'MakerBundle' => 'Symfony\\Bundle\\MakerBundle\\MakerBundle',
                'OroTwigInspectorBundle' => 'Oro\\TwigInspector\\Bundle\\OroTwigInspectorBundle',
                'ZikulaAdminModule' => 'Zikula\\AdminModule\\ZikulaAdminModule',
                'ZikulaBlocksModule' => 'Zikula\\BlocksModule\\ZikulaBlocksModule',
                'ZikulaCategoriesModule' => 'Zikula\\CategoriesModule\\ZikulaCategoriesModule',
                'ZikulaExtensionsModule' => 'Zikula\\ExtensionsModule\\ZikulaExtensionsModule',
                'ZikulaGroupsModule' => 'Zikula\\GroupsModule\\ZikulaGroupsModule',
                'ZikulaMailerModule' => 'Zikula\\MailerModule\\ZikulaMailerModule',
                'ZikulaMenuModule' => 'Zikula\\MenuModule\\ZikulaMenuModule',
                'ZikulaPermissionsModule' => 'Zikula\\PermissionsModule\\ZikulaPermissionsModule',
                'ZikulaRoutesModule' => 'Zikula\\RoutesModule\\ZikulaRoutesModule',
                'ZikulaSearchModule' => 'Zikula\\SearchModule\\ZikulaSearchModule',
                'ZikulaSecurityCenterModule' => 'Zikula\\SecurityCenterModule\\ZikulaSecurityCenterModule',
                'ZikulaSettingsModule' => 'Zikula\\SettingsModule\\ZikulaSettingsModule',
                'ZikulaThemeModule' => 'Zikula\\ThemeModule\\ZikulaThemeModule',
                'ZikulaUsersModule' => 'Zikula\\UsersModule\\ZikulaUsersModule',
                'ZikulaZAuthModule' => 'Zikula\\ZAuthModule\\ZikulaZAuthModule',
                'ZikulaAtomTheme' => 'Zikula\\AtomTheme\\ZikulaAtomTheme',
                'ZikulaBootstrapTheme' => 'Zikula\\BootstrapTheme\\ZikulaBootstrapTheme',
                'ZikulaPrinterTheme' => 'Zikula\\PrinterTheme\\ZikulaPrinterTheme',
                'ZikulaRssTheme' => 'Zikula\\RssTheme\\ZikulaRssTheme',
            ],
            'kernel.bundles_metadata' => [
                'FrameworkBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/FrameworkBundle'),
                    'namespace' => 'Symfony\\Bundle\\FrameworkBundle',
                ],
                'SecurityBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/SecurityBundle'),
                    'namespace' => 'Symfony\\Bundle\\SecurityBundle',
                ],
                'TwigBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/TwigBundle'),
                    'namespace' => 'Symfony\\Bundle\\TwigBundle',
                ],
                'MonologBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/monolog-bundle'),
                    'namespace' => 'Symfony\\Bundle\\MonologBundle',
                ],
                'DoctrineBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\DoctrineBundle',
                ],
                'SensioFrameworkExtraBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src'),
                    'namespace' => 'Sensio\\Bundle\\FrameworkExtraBundle',
                ],
                'StofDoctrineExtensionsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/antishov/doctrine-extensions-bundle'),
                    'namespace' => 'Stof\\DoctrineExtensionsBundle',
                ],
                'TwigExtraBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/twig/extra-bundle'),
                    'namespace' => 'Twig\\Extra\\TwigExtraBundle',
                ],
                'CoreBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/core-bundle'),
                    'namespace' => 'Zikula\\Bundle\\CoreBundle',
                ],
                'ZikulaCoreInstallerBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/coreinstaller-bundle'),
                    'namespace' => 'Zikula\\Bundle\\CoreInstallerBundle',
                ],
                'ZikulaFormExtensionBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/formextension-bundle'),
                    'namespace' => 'Zikula\\Bundle\\FormExtensionBundle',
                ],
                'ZikulaHookBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/hook-bundle'),
                    'namespace' => 'Zikula\\Bundle\\HookBundle',
                ],
                'JMSI18nRoutingBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/jms/i18n-routing-bundle/JMS/I18nRoutingBundle'),
                    'namespace' => 'JMS\\I18nRoutingBundle',
                ],
                'FOSJsRoutingBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/friendsofsymfony/jsrouting-bundle'),
                    'namespace' => 'FOS\\JsRoutingBundle',
                ],
                'SymfonyConsoleFormBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/matthiasnoback/symfony-console-form/src/Bundle'),
                    'namespace' => 'Matthias\\SymfonyConsoleForm\\Bundle',
                ],
                'KnpMenuBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-menu-bundle/src'),
                    'namespace' => 'Knp\\Bundle\\MenuBundle',
                ],
                'LiipImagineBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/liip/imagine-bundle'),
                    'namespace' => 'Liip\\ImagineBundle',
                ],
                'TranslationBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/php-translation/symfony-bundle'),
                    'namespace' => 'Translation\\Bundle',
                ],
                'BazingaJsTranslationBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/willdurand/js-translation-bundle'),
                    'namespace' => 'Bazinga\\Bundle\\JsTranslationBundle',
                ],
                'ZikulaWorkflowBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/workflow-bundle'),
                    'namespace' => 'Zikula\\Bundle\\WorkflowBundle',
                ],
                'DebugBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/DebugBundle'),
                    'namespace' => 'Symfony\\Bundle\\DebugBundle',
                ],
                'WebProfilerBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/symfony/src/Symfony/Bundle/WebProfilerBundle'),
                    'namespace' => 'Symfony\\Bundle\\WebProfilerBundle',
                ],
                'MakerBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/maker-bundle/src'),
                    'namespace' => 'Symfony\\Bundle\\MakerBundle',
                ],
                'OroTwigInspectorBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/oro/twig-inspector/Bundle'),
                    'namespace' => 'Oro\\TwigInspector\\Bundle',
                ],
                'ZikulaAdminModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/admin-module'),
                    'namespace' => 'Zikula\\AdminModule',
                ],
                'ZikulaBlocksModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/blocks-module'),
                    'namespace' => 'Zikula\\BlocksModule',
                ],
                'ZikulaCategoriesModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/categories-module'),
                    'namespace' => 'Zikula\\CategoriesModule',
                ],
                'ZikulaExtensionsModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/extensions-module'),
                    'namespace' => 'Zikula\\ExtensionsModule',
                ],
                'ZikulaGroupsModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/groups-module'),
                    'namespace' => 'Zikula\\GroupsModule',
                ],
                'ZikulaMailerModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/mailer-module'),
                    'namespace' => 'Zikula\\MailerModule',
                ],
                'ZikulaMenuModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/menu-module'),
                    'namespace' => 'Zikula\\MenuModule',
                ],
                'ZikulaPermissionsModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/permissions-module'),
                    'namespace' => 'Zikula\\PermissionsModule',
                ],
                'ZikulaRoutesModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/routes-module'),
                    'namespace' => 'Zikula\\RoutesModule',
                ],
                'ZikulaSearchModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/search-module'),
                    'namespace' => 'Zikula\\SearchModule',
                ],
                'ZikulaSecurityCenterModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/securitycenter-module'),
                    'namespace' => 'Zikula\\SecurityCenterModule',
                ],
                'ZikulaSettingsModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/settings-module'),
                    'namespace' => 'Zikula\\SettingsModule',
                ],
                'ZikulaThemeModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/theme-module'),
                    'namespace' => 'Zikula\\ThemeModule',
                ],
                'ZikulaUsersModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/users-module'),
                    'namespace' => 'Zikula\\UsersModule',
                ],
                'ZikulaZAuthModule' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/zauth-module'),
                    'namespace' => 'Zikula\\ZAuthModule',
                ],
                'ZikulaAtomTheme' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/atom-theme'),
                    'namespace' => 'Zikula\\AtomTheme',
                ],
                'ZikulaBootstrapTheme' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/bootstrap-theme'),
                    'namespace' => 'Zikula\\BootstrapTheme',
                ],
                'ZikulaPrinterTheme' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/printer-theme'),
                    'namespace' => 'Zikula\\PrinterTheme',
                ],
                'ZikulaRssTheme' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/zikula/rss-theme'),
                    'namespace' => 'Zikula\\RssTheme',
                ],
            ],
            'kernel.charset' => 'UTF-8',
            'kernel.container_class' => 'KernelDevContainer',
            'script_position' => 'foot',
            'datadir' => 'public/uploads',
            'locale' => 'en',
            'assets_version' => NULL,
            'zikula_asset_manager.combine' => true,
            'zikula_asset_manager.lifetime' => '1 day',
            'zikula_asset_manager.compress' => true,
            'zikula_asset_manager.minify' => true,
            'security.x_frame_options' => 'SAMEORIGIN',
            'zikula.javascript.bootstrap.min.path' => '/bootstrap/js/bootstrap.bundle.min.js',
            'zikula.stylesheet.bootstrap.min.path' => '/bootstrap/css/bootstrap.min.css',
            'zikula.stylesheet.fontawesome.min.path' => '/font-awesome/css/all.min.css',
            'localisation.locales' => [
                0 => 'en',
            ],
            'zikula.session.name' => '_zsid',
            'zikula.session.handler_id' => 'session.handler.native_file',
            'zikula.session.storage_id' => 'zikula_core.bridge.http_foundation.zikula_session_storage_file',
            'multisites' => [
                'enabled' => false,
                'mainsiteurl' => NULL,
                'based_on_domains' => NULL,
                'protected.systemvars' => [

                ],
            ],
            'event_dispatcher.event_aliases' => [
                'Symfony\\Component\\Console\\Event\\ConsoleCommandEvent' => 'console.command',
                'Symfony\\Component\\Console\\Event\\ConsoleErrorEvent' => 'console.error',
                'Symfony\\Component\\Console\\Event\\ConsoleTerminateEvent' => 'console.terminate',
                'Symfony\\Component\\Form\\Event\\PreSubmitEvent' => 'form.pre_submit',
                'Symfony\\Component\\Form\\Event\\SubmitEvent' => 'form.submit',
                'Symfony\\Component\\Form\\Event\\PostSubmitEvent' => 'form.post_submit',
                'Symfony\\Component\\Form\\Event\\PreSetDataEvent' => 'form.pre_set_data',
                'Symfony\\Component\\Form\\Event\\PostSetDataEvent' => 'form.post_set_data',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerArgumentsEvent' => 'kernel.controller_arguments',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerEvent' => 'kernel.controller',
                'Symfony\\Component\\HttpKernel\\Event\\ResponseEvent' => 'kernel.response',
                'Symfony\\Component\\HttpKernel\\Event\\FinishRequestEvent' => 'kernel.finish_request',
                'Symfony\\Component\\HttpKernel\\Event\\RequestEvent' => 'kernel.request',
                'Symfony\\Component\\HttpKernel\\Event\\ViewEvent' => 'kernel.view',
                'Symfony\\Component\\HttpKernel\\Event\\ExceptionEvent' => 'kernel.exception',
                'Symfony\\Component\\HttpKernel\\Event\\TerminateEvent' => 'kernel.terminate',
                'Symfony\\Component\\Workflow\\Event\\GuardEvent' => 'workflow.guard',
                'Symfony\\Component\\Workflow\\Event\\LeaveEvent' => 'workflow.leave',
                'Symfony\\Component\\Workflow\\Event\\TransitionEvent' => 'workflow.transition',
                'Symfony\\Component\\Workflow\\Event\\EnterEvent' => 'workflow.enter',
                'Symfony\\Component\\Workflow\\Event\\EnteredEvent' => 'workflow.entered',
                'Symfony\\Component\\Workflow\\Event\\CompletedEvent' => 'workflow.completed',
                'Symfony\\Component\\Workflow\\Event\\AnnounceEvent' => 'workflow.announce',
                'Symfony\\Component\\Security\\Core\\Event\\AuthenticationSuccessEvent' => 'security.authentication.success',
                'Symfony\\Component\\Security\\Core\\Event\\AuthenticationFailureEvent' => 'security.authentication.failure',
                'Symfony\\Component\\Security\\Http\\Event\\InteractiveLoginEvent' => 'security.interactive_login',
                'Symfony\\Component\\Security\\Http\\Event\\SwitchUserEvent' => 'security.switch_user',
            ],
            'fragment.renderer.hinclude.global_template' => '',
            'fragment.path' => '/_fragment',
            'kernel.http_method_override' => true,
            'kernel.trusted_hosts' => [

            ],
            'kernel.default_locale' => 'en',
            'kernel.error_controller' => 'error_controller',
            'debug.file_link_format' => NULL,
            'session.metadata.storage_key' => '_sf2_meta',
            'session.storage.options' => [
                'cache_limiter' => '0',
                'name' => '_zsid',
                'cookie_secure' => 'auto',
                'cookie_httponly' => true,
                'cookie_samesite' => 'lax',
                'gc_probability' => 1,
            ],
            'session.metadata.update_threshold' => 0,
            'form.type_extension.csrf.enabled' => true,
            'form.type_extension.csrf.field_name' => '_token',
            'asset.request_context.base_path' => NULL,
            'asset.request_context.secure' => NULL,
            'validator.translation_domain' => 'validators',
            'translator.logging' => false,
            'translator.default_path' => (\dirname(__DIR__, 4).'/translations'),
            'profiler_listener.only_exceptions' => false,
            'profiler_listener.only_master_requests' => false,
            'debug.error_handler.throw_at' => 0,
            'router.request_context.host' => 'localhost',
            'router.request_context.scheme' => 'http',
            'router.request_context.base_url' => '',
            'router.resource' => 'kernel::loadRoutes',
            'request_listener.http_port' => 80,
            'request_listener.https_port' => 443,
            'security.role_hierarchy.roles' => [
                'ROLE_ADMIN' => [
                    0 => 'ROLE_USER',
                ],
                'ROLE_SUPER_ADMIN' => [
                    0 => 'ROLE_USER',
                    1 => 'ROLE_ADMIN',
                    2 => 'ROLE_ALLOWED_TO_SWITCH',
                ],
            ],
            'security.access.denied_url' => NULL,
            'security.authentication.manager.erase_credentials' => true,
            'security.authentication.session_strategy.strategy' => 'migrate',
            'security.access.always_authenticate_before_granting' => false,
            'security.authentication.hide_user_not_found' => true,
            'security.firewalls' => [
                0 => 'dev',
                1 => 'login',
                2 => 'secured_area',
                3 => 'twig_inspector',
                4 => 'main',
            ],
            'twig.form.resources' => [
                0 => 'form_div_layout.html.twig',
                1 => '@LiipImagine/Form/form_div_layout.html.twig',
                2 => '@ZikulaFormExtension/Form/bootstrap_4_zikula_admin_layout.html.twig',
                3 => '@ZikulaFormExtension/Form/form_div_layout.html.twig',
            ],
            'twig.default_path' => (\dirname(__DIR__, 4).'/templates'),
            'monolog.use_microseconds' => true,
            'monolog.swift_mailer.handlers' => [

            ],
            'monolog.handlers_to_channels' => [
                'monolog.handler.console' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'event',
                        1 => 'doctrine',
                        2 => 'console',
                    ],
                ],
                'monolog.handler.main' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'event',
                        1 => 'mail',
                    ],
                ],
                'monolog.handler.mail' => [
                    'type' => 'inclusive',
                    'elements' => [
                        0 => 'mail',
                    ],
                ],
                'monolog.handler.zikula' => [
                    'type' => 'inclusive',
                    'elements' => [
                        0 => 'zikula',
                    ],
                ],
            ],
            'doctrine.dbal.logger.chain.class' => 'Doctrine\\DBAL\\Logging\\LoggerChain',
            'doctrine.dbal.logger.profiling.class' => 'Doctrine\\DBAL\\Logging\\DebugStack',
            'doctrine.dbal.logger.class' => 'Symfony\\Bridge\\Doctrine\\Logger\\DbalLogger',
            'doctrine.dbal.configuration.class' => 'Doctrine\\DBAL\\Configuration',
            'doctrine.data_collector.class' => 'Doctrine\\Bundle\\DoctrineBundle\\DataCollector\\DoctrineDataCollector',
            'doctrine.dbal.connection.event_manager.class' => 'Symfony\\Bridge\\Doctrine\\ContainerAwareEventManager',
            'doctrine.dbal.connection_factory.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ConnectionFactory',
            'doctrine.dbal.events.mysql_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\MysqlSessionInit',
            'doctrine.dbal.events.oracle_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\OracleSessionInit',
            'doctrine.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Registry',
            'doctrine.entity_managers' => [
                'default' => 'doctrine.orm.default_entity_manager',
            ],
            'doctrine.default_entity_manager' => 'default',
            'doctrine.dbal.connection_factory.types' => [
                'utcdatetime' => [
                    'class' => 'Zikula\\Bundle\\CoreBundle\\Doctrine\\DBAL\\Type\\UTCDateTimeType',
                ],
            ],
            'doctrine.connections' => [
                'default' => 'doctrine.dbal.default_connection',
            ],
            'doctrine.default_connection' => 'default',
            'doctrine.orm.configuration.class' => 'Doctrine\\ORM\\Configuration',
            'doctrine.orm.entity_manager.class' => 'Doctrine\\ORM\\EntityManager',
            'doctrine.orm.manager_configurator.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ManagerConfigurator',
            'doctrine.orm.cache.array.class' => 'Doctrine\\Common\\Cache\\ArrayCache',
            'doctrine.orm.cache.apc.class' => 'Doctrine\\Common\\Cache\\ApcCache',
            'doctrine.orm.cache.memcache.class' => 'Doctrine\\Common\\Cache\\MemcacheCache',
            'doctrine.orm.cache.memcache_host' => 'localhost',
            'doctrine.orm.cache.memcache_port' => 11211,
            'doctrine.orm.cache.memcache_instance.class' => 'Memcache',
            'doctrine.orm.cache.memcached.class' => 'Doctrine\\Common\\Cache\\MemcachedCache',
            'doctrine.orm.cache.memcached_host' => 'localhost',
            'doctrine.orm.cache.memcached_port' => 11211,
            'doctrine.orm.cache.memcached_instance.class' => 'Memcached',
            'doctrine.orm.cache.redis.class' => 'Doctrine\\Common\\Cache\\RedisCache',
            'doctrine.orm.cache.redis_host' => 'localhost',
            'doctrine.orm.cache.redis_port' => 6379,
            'doctrine.orm.cache.redis_instance.class' => 'Redis',
            'doctrine.orm.cache.xcache.class' => 'Doctrine\\Common\\Cache\\XcacheCache',
            'doctrine.orm.cache.wincache.class' => 'Doctrine\\Common\\Cache\\WinCacheCache',
            'doctrine.orm.cache.zenddata.class' => 'Doctrine\\Common\\Cache\\ZendDataCache',
            'doctrine.orm.metadata.driver_chain.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\MappingDriverChain',
            'doctrine.orm.metadata.annotation.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AnnotationDriver',
            'doctrine.orm.metadata.xml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedXmlDriver',
            'doctrine.orm.metadata.yml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedYamlDriver',
            'doctrine.orm.metadata.php.class' => 'Doctrine\\ORM\\Mapping\\Driver\\PHPDriver',
            'doctrine.orm.metadata.staticphp.class' => 'Doctrine\\ORM\\Mapping\\Driver\\StaticPHPDriver',
            'doctrine.orm.proxy_cache_warmer.class' => 'Symfony\\Bridge\\Doctrine\\CacheWarmer\\ProxyCacheWarmer',
            'form.type_guesser.doctrine.class' => 'Symfony\\Bridge\\Doctrine\\Form\\DoctrineOrmTypeGuesser',
            'doctrine.orm.validator.unique.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator',
            'doctrine.orm.validator_initializer.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\DoctrineInitializer',
            'doctrine.orm.security.user.provider.class' => 'Symfony\\Bridge\\Doctrine\\Security\\User\\EntityUserProvider',
            'doctrine.orm.listeners.resolve_target_entity.class' => 'Doctrine\\ORM\\Tools\\ResolveTargetEntityListener',
            'doctrine.orm.listeners.attach_entity_listeners.class' => 'Doctrine\\ORM\\Tools\\AttachEntityListenersListener',
            'doctrine.orm.naming_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultNamingStrategy',
            'doctrine.orm.naming_strategy.underscore.class' => 'Doctrine\\ORM\\Mapping\\UnderscoreNamingStrategy',
            'doctrine.orm.quote_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultQuoteStrategy',
            'doctrine.orm.quote_strategy.ansi.class' => 'Doctrine\\ORM\\Mapping\\AnsiQuoteStrategy',
            'doctrine.orm.entity_listener_resolver.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ContainerEntityListenerResolver',
            'doctrine.orm.second_level_cache.default_cache_factory.class' => 'Doctrine\\ORM\\Cache\\DefaultCacheFactory',
            'doctrine.orm.second_level_cache.default_region.class' => 'Doctrine\\ORM\\Cache\\Region\\DefaultRegion',
            'doctrine.orm.second_level_cache.filelock_region.class' => 'Doctrine\\ORM\\Cache\\Region\\FileLockRegion',
            'doctrine.orm.second_level_cache.logger_chain.class' => 'Doctrine\\ORM\\Cache\\Logging\\CacheLoggerChain',
            'doctrine.orm.second_level_cache.logger_statistics.class' => 'Doctrine\\ORM\\Cache\\Logging\\StatisticsCacheLogger',
            'doctrine.orm.second_level_cache.cache_configuration.class' => 'Doctrine\\ORM\\Cache\\CacheConfiguration',
            'doctrine.orm.second_level_cache.regions_configuration.class' => 'Doctrine\\ORM\\Cache\\RegionsConfiguration',
            'doctrine.orm.auto_generate_proxy_classes' => true,
            'doctrine.orm.proxy_namespace' => 'DoctrineProxy',
            'stof_doctrine_extensions.listener.translatable.class' => 'Gedmo\\Translatable\\TranslatableListener',
            'stof_doctrine_extensions.event_listener.locale.class' => 'Stof\\DoctrineExtensionsBundle\\EventListener\\LocaleListener',
            'stof_doctrine_extensions.listener.timestampable.class' => 'Gedmo\\Timestampable\\TimestampableListener',
            'stof_doctrine_extensions.listener.blameable.class' => 'Gedmo\\Blameable\\BlameableListener',
            'stof_doctrine_extensions.event_listener.blame.class' => 'Stof\\DoctrineExtensionsBundle\\EventListener\\BlameListener',
            'stof_doctrine_extensions.listener.sluggable.class' => 'Gedmo\\Sluggable\\SluggableListener',
            'stof_doctrine_extensions.listener.tree.class' => 'Gedmo\\Tree\\TreeListener',
            'stof_doctrine_extensions.listener.loggable.class' => 'Gedmo\\Loggable\\LoggableListener',
            'stof_doctrine_extensions.event_listener.logger.class' => 'Stof\\DoctrineExtensionsBundle\\EventListener\\LoggerListener',
            'stof_doctrine_extensions.listener.sortable.class' => 'Gedmo\\Sortable\\SortableListener',
            'stof_doctrine_extensions.listener.softdeleteable.class' => 'Gedmo\\SoftDeleteable\\SoftDeleteableListener',
            'stof_doctrine_extensions.listener.uploadable.class' => 'Gedmo\\Uploadable\\UploadableListener',
            'stof_doctrine_extensions.uploadable.manager.class' => 'Stof\\DoctrineExtensionsBundle\\Uploadable\\UploadableManager',
            'stof_doctrine_extensions.uploadable.mime_type_guesser.class' => 'Stof\\DoctrineExtensionsBundle\\Uploadable\\MimeTypeGuesserAdapter',
            'stof_doctrine_extensions.uploadable.default_file_info.class' => 'Stof\\DoctrineExtensionsBundle\\Uploadable\\UploadedFileInfo',
            'stof_doctrine_extensions.listener.reference_integrity.class' => 'Gedmo\\ReferenceIntegrity\\ReferenceIntegrityListener',
            'stof_doctrine_extensions.default_locale' => 'en_US',
            'stof_doctrine_extensions.translation_fallback' => true,
            'stof_doctrine_extensions.persist_default_translation' => false,
            'stof_doctrine_extensions.skip_translation_on_load' => false,
            'stof_doctrine_extensions.default_file_path' => NULL,
            'stof_doctrine_extensions.uploadable.validate_writable_directory' => true,
            'jms_i18n_routing.router.class' => 'JMS\\I18nRoutingBundle\\Router\\I18nRouter',
            'jms_i18n_routing.locale_resolver.class' => 'JMS\\I18nRoutingBundle\\Router\\DefaultLocaleResolver',
            'jms_i18n_routing.loader.class' => 'JMS\\I18nRoutingBundle\\Router\\I18nLoader',
            'jms_i18n_routing.route_exclusion_strategy.class' => 'Zikula\\RoutesModule\\Translation\\DefaultRouteExclusionStrategy',
            'jms_i18n_routing.pattern_generation_strategy.class' => 'JMS\\I18nRoutingBundle\\Router\\DefaultPatternGenerationStrategy',
            'jms_i18n_routing.locale_choosing_listener.class' => 'JMS\\I18nRoutingBundle\\EventListener\\LocaleChoosingListener',
            'jms_i18n_routing.cookie_setting_listener.class' => 'JMS\\I18nRoutingBundle\\EventListener\\CookieSettingListener',
            'jms_i18n_routing.route_translation_extractor.class' => 'JMS\\I18nRoutingBundle\\Translation\\RouteTranslationExtractor',
            'jms_i18n_routing.default_locale' => 'en',
            'jms_i18n_routing.locales' => [
                0 => 'en',
            ],
            'jms_i18n_routing.catalogue' => 'routes',
            'jms_i18n_routing.strategy' => 'prefix_except_default',
            'jms_i18n_routing.redirect_to_host' => true,
            'jms_i18n_routing.cookie.name' => 'hl',
            'fos_js_routing.extractor.class' => 'FOS\\JsRoutingBundle\\Extractor\\ExposedRoutesExtractor',
            'fos_js_routing.controller.class' => 'FOS\\JsRoutingBundle\\Controller\\Controller',
            'fos_js_routing.normalizer.route_collection.class' => 'FOS\\JsRoutingBundle\\Serializer\\Normalizer\\RouteCollectionNormalizer',
            'fos_js_routing.normalizer.routes_response.class' => 'FOS\\JsRoutingBundle\\Serializer\\Normalizer\\RoutesResponseNormalizer',
            'fos_js_routing.denormalizer.route_collection.class' => 'FOS\\JsRoutingBundle\\Serializer\\Denormalizer\\RouteCollectionDenormalizer',
            'fos_js_routing.request_context_base_url' => NULL,
            'fos_js_routing.cache_control' => [
                'enabled' => false,
            ],
            'knp_menu.renderer.list.options' => [

            ],
            'knp_menu.twig.extension.class' => 'Knp\\Menu\\Twig\\MenuExtension',
            'knp_menu.renderer.twig.class' => 'Knp\\Menu\\Renderer\\TwigRenderer',
            'knp_menu.renderer.twig.options' => [

            ],
            'knp_menu.renderer.twig.template' => '@KnpMenu/menu.html.twig',
            'knp_menu.default_renderer' => 'twig',
            'liip_imagine.resolvers' => [
                'default' => [
                    'web_path' => [
                        'web_root' => (\dirname(__DIR__, 4).'/public'),
                        'cache_prefix' => 'media/cache',
                    ],
                ],
            ],
            'liip_imagine.loaders' => [
                'zikula_root' => [
                    'filesystem' => [
                        'data_root' => [
                            0 => (\dirname(__DIR__, 4).'/public'),
                        ],
                        'locator' => 'filesystem',
                        'allow_unresolvable_data_roots' => false,
                        'bundle_resources' => [
                            'enabled' => false,
                            'access_control_type' => 'blacklist',
                            'access_control_list' => [

                            ],
                        ],
                    ],
                ],
                'default' => [
                    'filesystem' => [
                        'data_root' => [
                            0 => (\dirname(__DIR__, 4).'/public'),
                        ],
                        'locator' => 'filesystem',
                        'allow_unresolvable_data_roots' => false,
                        'bundle_resources' => [
                            'enabled' => false,
                            'access_control_type' => 'blacklist',
                            'access_control_list' => [

                            ],
                        ],
                    ],
                ],
            ],
            'liip_imagine.jpegoptim.binary' => '/usr/bin/jpegoptim',
            'liip_imagine.jpegoptim.stripAll' => true,
            'liip_imagine.jpegoptim.max' => NULL,
            'liip_imagine.jpegoptim.progressive' => true,
            'liip_imagine.jpegoptim.tempDir' => NULL,
            'liip_imagine.optipng.binary' => '/usr/bin/optipng',
            'liip_imagine.optipng.level' => 7,
            'liip_imagine.optipng.stripAll' => true,
            'liip_imagine.optipng.tempDir' => NULL,
            'liip_imagine.pngquant.binary' => '/usr/bin/pngquant',
            'liip_imagine.mozjpeg.binary' => '/opt/mozjpeg/bin/cjpeg',
            'liip_imagine.driver_service' => 'liip_imagine.gd',
            'liip_imagine.cache.resolver.default' => 'default',
            'liip_imagine.default_image' => NULL,
            'liip_imagine.filter_sets' => [
                'cache' => [
                    'quality' => 100,
                    'jpeg_quality' => NULL,
                    'png_compression_level' => NULL,
                    'png_compression_filter' => NULL,
                    'format' => NULL,
                    'animated' => false,
                    'cache' => NULL,
                    'data_loader' => NULL,
                    'default_image' => NULL,
                    'filters' => [

                    ],
                    'post_processors' => [

                    ],
                ],
                'my_thumb' => [
                    'quality' => 100,
                    'jpeg_quality' => 90,
                    'png_compression_level' => 7,
                    'png_compression_filter' => NULL,
                    'format' => NULL,
                    'animated' => false,
                    'cache' => NULL,
                    'data_loader' => NULL,
                    'default_image' => NULL,
                    'filters' => [
                        'thumbnail' => [
                            'size' => [
                                0 => 120,
                                1 => 90,
                            ],
                            'mode' => 'outbound',
                        ],
                        'background' => [
                            'size' => [
                                0 => 124,
                                1 => 94,
                            ],
                            'position' => 'center',
                            'color' => '#000000',
                        ],
                    ],
                    'post_processors' => [

                    ],
                ],
                'zkroot' => [
                    'quality' => 100,
                    'jpeg_quality' => 90,
                    'png_compression_level' => 7,
                    'png_compression_filter' => NULL,
                    'format' => NULL,
                    'animated' => false,
                    'cache' => NULL,
                    'data_loader' => 'zikula_root',
                    'default_image' => NULL,
                    'filters' => [
                        'thumbnail' => [
                            'size' => [
                                0 => 100,
                                1 => 100,
                            ],
                            'mode' => 'inset',
                        ],
                    ],
                    'post_processors' => [

                    ],
                ],
            ],
            'liip_imagine.binary.loader.default' => 'default',
            'liip_imagine.controller.filter_action' => 'Liip\\ImagineBundle\\Controller\\ImagineController::filterAction',
            'liip_imagine.controller.filter_runtime_action' => 'Liip\\ImagineBundle\\Controller\\ImagineController::filterRuntimeAction',
            'liip_imagine.webp.generate' => false,
            'liip_imagine.webp.options' => [
                'quality' => 100,
                'cache' => NULL,
                'data_loader' => NULL,
                'post_processors' => [

                ],
            ],
            'extractor_vendor_dir' => (\dirname(__DIR__, 4).'/vendor/php-translation/extractor/src'),
            'php_translation.locales' => [
                0 => 'en',
            ],
            'php_translation.default_locale' => 'en',
            'php_translation.webui.enabled' => true,
            'php_translation.webui.allow_create' => true,
            'php_translation.webui.allow_delete' => true,
            'php_translation.webui.file_base_path' => (\dirname(__DIR__, 4).'/'),
            'php_translation.toolbar.allow_edit' => true,
            'bazinga.jstranslation.translation_finder.class' => 'Bazinga\\Bundle\\JsTranslationBundle\\Finder\\TranslationFinder',
            'bazinga.jstranslation.translation_dumper.class' => 'Bazinga\\Bundle\\JsTranslationBundle\\Dumper\\TranslationDumper',
            'bazinga.jstranslation.controller.class' => 'Bazinga\\Bundle\\JsTranslationBundle\\Controller\\Controller',
            'env(VAR_DUMPER_SERVER)' => '127.0.0.1:9912',
            'maker.compatible_check.doctrine.supports_attributes' => false,
            'data_collector.templates' => [
                'data_collector.request' => [
                    0 => 'request',
                    1 => '@WebProfiler/Collector/request.html.twig',
                ],
                'data_collector.time' => [
                    0 => 'time',
                    1 => '@WebProfiler/Collector/time.html.twig',
                ],
                'data_collector.memory' => [
                    0 => 'memory',
                    1 => '@WebProfiler/Collector/memory.html.twig',
                ],
                'data_collector.validator' => [
                    0 => 'validator',
                    1 => '@WebProfiler/Collector/validator.html.twig',
                ],
                'data_collector.ajax' => [
                    0 => 'ajax',
                    1 => '@WebProfiler/Collector/ajax.html.twig',
                ],
                'data_collector.form' => [
                    0 => 'form',
                    1 => '@WebProfiler/Collector/form.html.twig',
                ],
                'data_collector.exception' => [
                    0 => 'exception',
                    1 => '@WebProfiler/Collector/exception.html.twig',
                ],
                'data_collector.logger' => [
                    0 => 'logger',
                    1 => '@WebProfiler/Collector/logger.html.twig',
                ],
                'Zikula\\Bundle\\CoreBundle\\DataCollector\\ZikulaVersionDataCollector' => [
                    0 => 'zikula_version',
                    1 => '@Core/Collector/ZikulaVersion.html.twig',
                ],
                'data_collector.events' => [
                    0 => 'events',
                    1 => '@WebProfiler/Collector/events.html.twig',
                ],
                'data_collector.router' => [
                    0 => 'router',
                    1 => '@WebProfiler/Collector/router.html.twig',
                ],
                'data_collector.cache' => [
                    0 => 'cache',
                    1 => '@WebProfiler/Collector/cache.html.twig',
                ],
                'data_collector.translation' => [
                    0 => 'translation',
                    1 => '@WebProfiler/Collector/translation.html.twig',
                ],
                'data_collector.security' => [
                    0 => 'security',
                    1 => '@Security/Collector/security.html.twig',
                ],
                'oro_twig_inspector.data_collector' => [
                    0 => 'twig_inspector',
                    1 => '@OroTwigInspector/Collector/template.html.twig',
                ],
                'data_collector.twig' => [
                    0 => 'twig',
                    1 => '@WebProfiler/Collector/twig.html.twig',
                ],
                'data_collector.doctrine' => [
                    0 => 'db',
                    1 => '@Doctrine/Collector/db.html.twig',
                ],
                'data_collector.dump' => [
                    0 => 'dump',
                    1 => '@Debug/Profiler/dump.html.twig',
                ],
                'php_translation.data_collector' => [
                    0 => 'translation',
                    1 => '@Translation/SymfonyProfiler/translation.html.twig',
                ],
                'mailer.data_collector' => [
                    0 => 'mailer',
                    1 => '@WebProfiler/Collector/mailer.html.twig',
                ],
                'data_collector.config' => [
                    0 => 'config',
                    1 => '@WebProfiler/Collector/config.html.twig',
                ],
            ],
            'console.command.ids' => [

            ],
        ];
    }

    protected function throw($message)
    {
        throw new RuntimeException($message);
    }
}
