<?php

/**
 * Routes.
 *
 * @copyright Zikula contributors (Zikula)
 * @license http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @author Zikula contributors <info@ziku.la>.
 * @see https://ziku.la
 * @version Generated by ModuleStudio 1.4.0 (https://modulestudio.de).
 */

declare(strict_types=1);

namespace Zikula\RoutesModule\Form\DataTransformer;

use Zikula\RoutesModule\Form\DataTransformer\Base\AbstractArrayFieldTransformer;

/**
 * Array field transformer implementation class.
 */
class ArrayFieldTransformer extends AbstractArrayFieldTransformer
{
    /** @var string */
    private $delimiter = ':';

    public function transform($values)
    {
        if (null === $values) {
            return '';
        }

        if (!is_array($values)) {
            return $values;
        }

        if (!count($values)) {
            return '';
        }

        $values = $this->removeEmptyEntries($values);

        $value = [];
        foreach ($values as $k => $v) {
            $value[] = str_replace($this->delimiter, '', $k) . $this->delimiter . $v;
        }

        return implode("\n", $value);
    }

    public function reverseTransform($value)
    {
        if (!$value) {
            return [];
        }

        $items = parent::reverseTransform($value);
        $result = [];
        foreach ($items as $value) {
            if (false === mb_strpos($value, $this->delimiter)) {
                continue;
            }
            list($k, $v) = explode($this->delimiter, $value);
            $result[trim($k)] = trim($v);
        }

        return $result;
    }
}
