<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('uk', array (
  'validators' => 
  array (
    'This value should be false.' => 'Значення повинно бути Ні.',
    'This value should be true.' => 'Значення повинно бути Так.',
    'This value should be of type {{ type }}.' => 'Тип значення повинен бути {{ type }}.',
    'This value should be blank.' => 'Значення повинно бути пустим.',
    'The value you selected is not a valid choice.' => 'Обране вами значення недопустиме.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Ви повинні обрати хоча б {{ limit }} варіант.|Ви повинні обрати хоча б {{ limit }} варіанти.|Ви повинні обрати хоча б {{ limit }} варіантів.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Ви повинні обрати не більше ніж {{ limit }} варіантів.',
    'One or more of the given values is invalid.' => 'Одне або кілька заданих значень є недопустимі.',
    'This field was not expected.' => 'Це поле не очікується.',
    'This field is missing.' => 'Це поле не вистачає.',
    'This value is not a valid date.' => 'Дане значення не є вірною датою.',
    'This value is not a valid datetime.' => 'Дане значення дати та часу недопустиме.',
    'This value is not a valid email address.' => 'Значення адреси электронної пошти недопустиме.',
    'The file could not be found.' => 'Файл не знайдено.',
    'The file is not readable.' => 'Файл не читається.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Файл занадто великий ({{ size }} {{ suffix }}). Дозволений максимальний розмір {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'MIME-тип файлу недопустимий ({{ type }}). Допустимі MIME-типи файлів {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Значення повинно бути {{ limit }} або менше.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Значення занадто довге. Повинно бути рівне {{ limit }} символу або менше.|Значення занадто довге. Повинно бути рівне {{ limit }} символам або менше.|Значення занадто довге. Повинно бути рівне {{ limit }} символам або менше.',
    'This value should be {{ limit }} or more.' => 'Значення повинно бути {{ limit }} або більше.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Значення занадто коротке. Повинно бути рівне {{ limit }} символу або більше.|Значення занадто коротке. Повинно бути рівне {{ limit }} символам або більше.|Значення занадто коротке. Повинно бути рівне {{ limit }} символам або більше.',
    'This value should not be blank.' => 'Значення не повинно бути пустим.',
    'This value should not be null.' => 'Значення не повинно бути null.',
    'This value should be null.' => 'Значення повинно бути null.',
    'This value is not valid.' => 'Значення недопустиме.',
    'This value is not a valid time.' => 'Значення часу недопустиме.',
    'This value is not a valid URL.' => 'Значення URL недопустиме.',
    'The two values should be equal.' => 'Обидва занчення повинні бути одинаковими.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Файл занадто великий. Максимальний допустимий розмір {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'Файл занадто великий.',
    'The file could not be uploaded.' => 'Файл не можливо завантажити.',
    'This value should be a valid number.' => 'Значення має бути допустимим числом.',
    'This file is not a valid image.' => 'Цей файл не є допустимим форматом зображення.',
    'This is not a valid IP address.' => 'Це некоректна IP адреса.',
    'This value is not a valid language.' => 'Це некоректна мова.',
    'This value is not a valid locale.' => 'Це некоректна локалізація.',
    'This value is not a valid country.' => 'Це некоректна країна.',
    'This value is already used.' => 'Це значення вже використовується.',
    'The size of the image could not be detected.' => 'Не вдалося визначити розмір зображення.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'Ширина зображення занадто велика ({{ width }}px). Максимально допустима ширина {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'Ширина зображення занадто мала ({{ width }}px). Мінімально допустима ширина {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'Висота зображення занадто велика ({{ height }}px). Максимально допустима висота {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'Висота зображення занадто мала ({{ height }}px). Мінімально допустима висота {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Значення має бути поточним паролем користувача.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Значення повиино бути рівним {{ limit }} символу.|Значення повиино бути рівним {{ limit }} символам.|Значення повиино бути рівним {{ limit }} символам.',
    'The file was only partially uploaded.' => 'Файл був завантажений лише частково.',
    'No file was uploaded.' => 'Файл не був завантажений.',
    'No temporary folder was configured in php.ini.' => 'Не налаштована тимчасова директорія в php.ini.',
    'Cannot write temporary file to disk.' => 'Неможливо записати тимчасовий файл на диск.',
    'A PHP extension caused the upload to fail.' => 'Розширення PHP викликало помилку при завантаженні.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Ця колекція повинна містити {{ limit }} елемент чи більше.|Ця колекція повинна містити {{ limit }} елемента чи більше.|Ця колекція повинна містити {{ limit }} елементів чи більше.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Ця колекція повинна містити {{ limit }} елемент чи менше.|Ця колекція повинна містити {{ limit }} елемента чи менше.|Ця колекція повинна містити {{ limit }} елементов чи менше.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Ця колекція повинна містити рівно {{ limit }} елемент.|Ця колекція повинна містити рівно {{ limit }} елемента.|Ця колекція повинна містити рівно {{ limit }} елементів.',
    'Invalid card number.' => 'Невірний номер карти.',
    'Unsupported card type or invalid card number.' => 'Непідтримуваний тип карти або невірний номер карти.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Це не дійсний міжнародний номер банківського рахунку (IBAN).',
    'This value is not a valid ISBN-10.' => 'Значення не у форматі ISBN-10.',
    'This value is not a valid ISBN-13.' => 'Значення не у форматі ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Значення не відповідає форматам ISBN-10 та ISBN-13.',
    'This value is not a valid ISSN.' => 'Значення має невірний формат ISSN.',
    'This value is not a valid currency.' => 'Значення має невірний формат валюти.',
    'This value should be equal to {{ compared_value }}.' => 'Значення повинно дорівнювати {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'Значення має бути більше ніж {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Значення має бути більше або дорівнювати {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Значення має бути ідентичним {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Значення повинно бути менше ніж {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Значення повинно бути менше або дорівнювати {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'Значення не повинно дорівнювати  {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Значення не повинно бути ідентичним {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Співвідношення сторін зображення занадто велике ({{ ratio }}). Максимальне співвідношення сторін {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Співвідношення сторін зображення занадто мало ({{ ratio }}). Мінімальне співвідношення сторін {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'Зображення квадратне ({{ width }}x{{ height }}px). Квадратні зображення не дозволені.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'Зображення альбомної орієнтації ({{ width }}x{{ height }}px). Зображення альбомної орієнтації не дозволені.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'Зображення в портретній орієнтації ({{ width }}x{{ height }}px). Зображення в портретної орієнтації не дозволені.',
    'An empty file is not allowed.' => 'Порожні файли не дозволені.',
    'The host could not be resolved.' => 'Ім\'я хоста не знайдено.',
    'This value does not match the expected {{ charset }} charset.' => 'Значення не збігається з очікуваним {{ charset }} кодуванням.',
    'This is not a valid Business Identifier Code (BIC).' => 'Це не дійсний банківський код (BIC).',
    'Error' => 'Помилка',
    'This is not a valid UUID.' => 'Це не валідне значення UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'Це значення повинне бути кратним {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Банківський код (BIC) не пов’язаний із міжнародним номером банківського рахунку (IBAN) {{ iban }}.',
    'This value should be valid JSON.' => 'Значення має бути корректним JSON.',
    'This collection should contain only unique elements.' => 'Ця колекція повинна мати тільки унікальни значення.',
    'This value should be positive.' => 'Значення має бути позитивним.',
    'This value should be either positive or zero.' => 'Значення має бути позитивним або дорівнювати нулю.',
    'This value should be negative.' => 'Значення має бути негативним.',
    'This value should be either negative or zero.' => 'Значення має бути негативним або дорівнювати нулю.',
    'This value is not a valid timezone.' => 'Значення не є дійсним часовим поясом.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Цей пароль був скомпрометований в результаті витоку даних та не повинен використовуватися. Будь ласка, використовуйте інший пароль.',
    'This value should be between {{ min }} and {{ max }}.' => 'Значення має бути між {{ min }} та {{ max }}.',
    'This value is not a valid hostname.' => 'Значення не є дійсним іменем хоста.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'Кількість елементів у цій колекції повинна бути кратною {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'Значення повинно задовольняти хоча б одному з наступних обмежень:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Кожен елемент цієї колекції повинен задовольняти власному набору обмежень.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Це значення не є дійсним міжнародним ідентифікаційним номером цінних паперів (ISIN).',
    'This form should not contain extra fields.' => 'Ця форма не повинна містити додаткових полів.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Завантажений файл занадто великий. Будь ласка, спробуйте завантажити файл меншого розміру.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'CSRF значення недопустиме. Будь ласка, спробуйте відправити форму знову.',
    'This value is not a valid HTML5 color.' => 'Це значення не є допустимим кольором HTML5.',
    'Please enter a valid birthdate.' => 'Будь ласка, введіть дійсну дату народження.',
    'The selected choice is invalid.' => 'Обраний варіант недійсний.',
    'The collection is invalid.' => 'Колекція недійсна.',
    'Please select a valid color.' => 'Будь ласка, оберіть дійсний колір.',
    'Please select a valid country.' => 'Будь ласка, оберіть дійсну країну.',
    'Please select a valid currency.' => 'Будь ласка, оберіть дійсну валюту.',
    'Please choose a valid date interval.' => 'Будь ласка, оберіть дійсний інтервал дати.',
    'Please enter a valid date and time.' => 'Будь ласка, введіть дійсну дату та час.',
    'Please enter a valid date.' => 'Будь ласка, введіть дійсну дату.',
    'Please select a valid file.' => 'Будь ласка, оберіть дійсний файл.',
    'The hidden field is invalid.' => 'Приховане поле недійсне.',
    'Please enter an integer.' => 'Будь ласка, введіть ціле число.',
    'Please select a valid language.' => 'Будь ласка, оберіть дійсну мову.',
    'Please select a valid locale.' => 'Будь ласка, оберіть дійсну локаль.',
    'Please enter a valid money amount.' => 'Будь ласка, введіть дійсну суму грошей.',
    'Please enter a number.' => 'Будь ласка, введіть число.',
    'The password is invalid.' => 'Пароль недійсний.',
    'Please enter a percentage value.' => 'Будь ласка, введіть процентне значення.',
    'The values do not match.' => 'Значення не збігаються.',
    'Please enter a valid time.' => 'Будь ласка, введіть дійсний час.',
    'Please select a valid timezone.' => 'Будь ласка, оберіть дійсний часовий пояс.',
    'Please enter a valid URL.' => 'Будь ласка, введіть дійсну URL-адресу.',
    'Please enter a valid search term.' => 'Будь ласка, введіть дійсний пошуковий термін.',
    'Please provide a valid phone number.' => 'Будь ласка, введіть дійсний номер телефону.',
    'The checkbox has an invalid value.' => 'Прапорець має недійсне значення.',
    'Please enter a valid email address.' => 'Будь ласка, введіть дійсну адресу електронної пошти.',
    'Please select a valid option.' => 'Будь ласка, оберіть дійсний варіант.',
    'Please select a valid range.' => 'Будь ласка, оберіть дійсний діапазон.',
    'Please enter a valid week.' => 'Будь ласка, введіть дійсний тиждень.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Помилка автентифікації.',
    'Authentication credentials could not be found.' => 'Автентифікаційні дані не знайдено.',
    'Authentication request could not be processed due to a system problem.' => 'Запит на автентифікацію не може бути опрацьовано у зв’язку з проблемою в системі.',
    'Invalid credentials.' => 'Невірні автентифікаційні дані.',
    'Cookie has already been used by someone else.' => 'Хтось інший вже використав цей сookie.',
    'Not privileged to request the resource.' => 'Відсутні права на запит цього ресурсу.',
    'Invalid CSRF token.' => 'Невірний токен CSRF.',
    'No authentication provider found to support the authentication token.' => 'Не знайдено провайдера автентифікації, що підтримує токен автентифікаціії.',
    'No session available, it either timed out or cookies are not enabled.' => 'Сесія недоступна, її час вийшов, або cookies вимкнено.',
    'No token could be found.' => 'Токен не знайдено.',
    'Username could not be found.' => 'Ім’я користувача не знайдено.',
    'Account has expired.' => 'Термін дії облікового запису вичерпано.',
    'Credentials have expired.' => 'Термін дії автентифікаційних даних вичерпано.',
    'Account is disabled.' => 'Обліковий запис відключено.',
    'Account is locked.' => 'Обліковий запис заблоковано.',
    'Too many failed login attempts, please try again later.' => 'Забагато невдалих спроб входу. Будь ласка, спробуйте пізніше.',
    'Invalid or expired login link.' => 'Посилання для входу недійсне, або термін його дії закінчився.',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
    'Category "%name%" must be unique under parent' => 'Category "%name%" must be unique under parent',
    'Could not find user to update.' => 'Could not find user to update.',
    'Could not json_decode the string you entered.' => 'Could not json_decode the string you entered.',
    'Invalid username.' => 'Invalid username.',
    'Old password is incorrect.' => 'Old password is incorrect.',
    'Sorry! The domain of the e-mail address you specified is banned.' => 'Sorry! The domain of the e-mail address you specified is banned.',
    'The code is invalid for this username.' => 'The code is invalid for this username.',
    'The email address you entered (%email%) has already been registered.' => 'The email address you entered (%email%) has already been registered.',
    'The emails must match!' => 'The emails must match!',
    'The group name you entered (%groupName%) does already exist.' => 'The group name you entered (%groupName%) does already exist.',
    'The password cannot be the same as the user name. Please choose a different password.' => 'The password cannot be the same as the user name. Please choose a different password.',
    'The password fields must match.' => 'The password fields must match.',
    'The passwords must match!' => 'The passwords must match!',
    'The selected item does not exist' => 'The selected item does not exist',
    'The user name you entered (%userName%) has already been registered.' => 'The user name you entered (%userName%) has already been registered.',
    'The user name you entered is reserved. It cannot be used.' => 'The user name you entered is reserved. It cannot be used.',
    'The value "%value%" is not allowed for the "%property%" property.' => 'The value "%value%" is not allowed for the "%property%" property.',
    'The value does not appear to be a valid user name. A valid user name consists of lowercase letters, numbers, underscores, periods or dashes.' => 'The value does not appear to be a valid user name. A valid user name consists of lowercase letters, numbers, underscores, periods or dashes.',
    'This email is in use by another authentication method. Please login with that method instead.' => 'This email is in use by another authentication method. Please login with that method instead.',
    'You did not provide the correct answer for the security question. Try %answer%!' => 'You did not provide the correct answer for the security question. Try %answer%!',
    'You must select at least "%limit%" choice.|You must select at least "%limit%" choices.' => 'You must select at least "%limit%" choice.|You must select at least "%limit%" choices.',
    'You must select at most "%limit%" choice.|You must select at most "%limit%" choices.' => 'You must select at most "%limit%" choice.|You must select at most "%limit%" choices.',
    'Your new password cannot match your current password.' => 'Your new password cannot match your current password.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
    '\'Warning! Using the %html_pur_link% will override settings for some HTML tags (such as %examples%).' => '\'Warning! Using the %html_pur_link% will override settings for some HTML tags (such as %examples%).',
    '(Modification not supported.)' => '(Modification not supported.)',
    '(Place each value on a separate line.)' => '(Place each value on a separate line.)',
    '(Separate each key-value pair with a colon (e.g., key:value). Place each key-value pair on a separate line.)' => '(Separate each key-value pair with a colon (e.g., key:value). Place each key-value pair on a separate line.)',
    'About' => 'About',
    'Actions' => 'Actions',
    'All' => 'All',
    'Allowed' => 'Allowed',
    'Allowed HTML settings' => 'Allowed HTML settings',
    'Allowed with attributes' => 'Allowed with attributes',
    'Automatic update settings' => 'Automatic update settings',
    'Automatically log user out after' => 'Automatically log user out after',
    'Block' => 'Block',
    'Block action' => 'Block action',
    'CSV delimiter' => 'CSV delimiter',
    'CSV filename' => 'CSV filename',
    'Cache expiration time' => 'Cache expiration time',
    'Caching method' => 'Caching method',
    'Cancel' => 'Cancel',
    'Check all' => 'Check all',
    'Check for updates' => 'Check for updates',
    'Clear filter' => 'Clear filter',
    'Colon (:)' => 'Colon (:)',
    'Comma (,)' => 'Comma (,)',
    'Confirmation prompt' => 'Confirmation prompt',
    'Daily' => 'Daily',
    'Database (recommended)' => 'Database (recommended)',
    'Date' => 'Date',
    'Default: <code>Resources/config/phpids_zikula_default.xml</code>' => 'Default: <code>Resources/config/phpids_zikula_default.xml</code>',
    'Define which fields contain HTML and need preparation' => 'Define which fields contain HTML and need preparation',
    'Define which fields contain JSON data and should be treated as such' => 'Define which fields contain JSON data and should be treated as such',
    'Define which fields should not be monitored' => 'Define which fields should not be monitored',
    'Delete the entire log.' => 'Delete the entire log.',
    'Description' => 'Description',
    'Do you really want to delete the entire IDS log?' => 'Do you really want to delete the entire IDS log?',
    'Download the entire log to a CSV file' => 'Download the entire log to a CSV file',
    'Expire session after' => 'Expire session after',
    'Export' => 'Export',
    'Export IDS Log' => 'Export IDS Log',
    'Export IDS log' => 'Export IDS log',
    'Export Options' => 'Export Options',
    'Export title row' => 'Export title row',
    'File' => 'File',
    'Filter' => 'Filter',
    'Filtering of allowed HTML occurs when a template string or variable is modified with the \'safeHtml\' filter, or when a module asks for similar processing from within its functions.' => 'Filtering of allowed HTML occurs when a template string or variable is modified with the \'safeHtml\' filter, or when a module asks for similar processing from within its functions.',
    'HTML Purifier output filter' => 'HTML Purifier output filter',
    'HTML entities' => 'HTML entities',
    'HTML tags' => 'HTML tags',
    'HTMLPurifier %s configuration directives' => 'HTMLPurifier %s configuration directives',
    'HTMLPurifier filtering occurs when a template string or variable is modified with the \'safehtml\' modifier, or when a module asks for similar processing from within its functions.' => 'HTMLPurifier filtering occurs when a template string or variable is modified with the \'safehtml\' modifier, or when a module asks for similar processing from within its functions.',
    'HTMLPurifier settings' => 'HTMLPurifier settings',
    'High (user is logged-out after X minutes of inactivity)' => 'High (user is logged-out after X minutes of inactivity)',
    'How often' => 'How often',
    'IDS rule path' => 'IDS rule path',
    'IP' => 'IP',
    'Impact' => 'Impact',
    'Intrusion Detection System' => 'Intrusion Detection System',
    'JSON' => 'JSON',
    'Low (user stays logged-in until he logs-out)' => 'Low (user stays logged-in until he logs-out)',
    'Medium (user is logged-out after X minutes of inactivity, unless \'Remember me\' checkbox is activated during log-in)' => 'Medium (user is logged-out after X minutes of inactivity, unless \'Remember me\' checkbox is activated during log-in)',
    'Memcached' => 'Memcached',
    'Minimum impact to block the request' => 'Minimum impact to block the request',
    'Minimum impact to email the administrator' => 'Minimum impact to email the administrator',
    'Minimum impact to kick the user (destroy the session)' => 'Minimum impact to kick the user (destroy the session)',
    'Minimum impact to log intrusion in the database' => 'Minimum impact to log intrusion in the database',
    'Monthly' => 'Monthly',
    'More information in <a href=\'%url%\' target="_blank">PHP documentation</a>.' => 'More information in <a href=\'%url%\' target="_blank">PHP documentation</a>.',
    'Name' => 'Name',
    'No' => 'No',
    'No logged intrusions found.' => 'No logged intrusions found.',
    'None' => 'None',
    'Not allowed' => 'Not allowed',
    'Notice: If you change \'Where to save sessions\' to \'File\' then you must enter a path in the \'Path for saving session files\' box above. The path must be writeable. Leave value empty for default location \'%kernel.cache_dir%/sessions\'' => 'Notice: If you change \'Where to save sessions\' to \'File\' then you must enter a path in the \'Path for saving session files\' box above. The path must be writeable. Leave value empty for default location \'%kernel.cache_dir%/sessions\'',
    'Notice: If you change the \'Session cookie name\' setting, all registered users who are currently logged-in will then be logged-out automatically, and they will have to log back in again.' => 'Notice: If you change the \'Session cookie name\' setting, all registered users who are currently logged-in will then be logged-out automatically, and they will have to log back in again.',
    'Notice: If you change this setting, you will be logged-out immediately and will have to log back in again.' => 'Notice: If you change this setting, you will be logged-out immediately and will have to log back in again.',
    'Output filter settings' => 'Output filter settings',
    'PHPIDS filter %s' => 'PHPIDS filter %s',
    'PHPIDS filters used' => 'PHPIDS filters used',
    'PHPIDS is a feature of the Security center module that enhances the security of a site, and the Security analyser has detected that it is not enabled. You are recommended to ensure that it is enabled. You will also see this message if the Security center module is not installed or is not activated. For more information about this, please consult the Security center on-line help.' => 'PHPIDS is a feature of the Security center module that enhances the security of a site, and the Security analyser has detected that it is not enabled. You are recommended to ensure that it is enabled. You will also see this message if the Security center module is not installed or is not activated. For more information about this, please consult the Security center on-line help.',
    'PHPIDS is activated, but requests are NOT blocked.' => 'PHPIDS is activated, but requests are NOT blocked.',
    'PHPIDS is enabled and you have set the Block action to \'Warn only\'. Thus requests are not blocked. This is useful only for debugging the PHPIDS ruleset in order to verify correct operation.' => 'PHPIDS is enabled and you have set the Block action to \'Warn only\'. Thus requests are not blocked. This is useful only for debugging the PHPIDS ruleset in order to verify correct operation.',
    'PHPIDS performs many different checks which return an impact value for scoring the treated request. Depending on the sum of all impacts performed actions are selected.' => 'PHPIDS performs many different checks which return an impact value for scoring the treated request. Depending on the sum of all impacts performed actions are selected.',
    'PHPIDS with the Security Center is not activated, but preferably should be.' => 'PHPIDS with the Security Center is not activated, but preferably should be.',
    'Page' => 'Page',
    'Path for saving session files' => 'Path for saving session files',
    'Purge IDS Log' => 'Purge IDS Log',
    'Purge IDS log' => 'Purge IDS log',
    'React on impact per request (uses the values from above)' => 'React on impact per request (uses the values from above)',
    'React on impact sum per session [loose] (uses the values from above * 10)' => 'React on impact sum per session [loose] (uses the values from above * 10)',
    'React on impact sum per session [strict] (uses the values from above * 5)' => 'React on impact sum per session [strict] (uses the values from above * 5)',
    'Read more about this system on the <a href="http://phpids.org" title="PHPIDS homepage" target="_blank">PHPIDS homepage</a>.' => 'Read more about this system on the <a href="http://phpids.org" title="PHPIDS homepage" target="_blank">PHPIDS homepage</a>.',
    'Reset to default values' => 'Reset to default values',
    'Rule' => 'Rule',
    'Save' => 'Save',
    'Security analyser warnings' => 'Security analyser warnings',
    'Security center module is not activated, but preferably should be.' => 'Security center module is not activated, but preferably should be.',
    'Security level' => 'Security level',
    'Security settings' => 'Security settings',
    'Security warnings' => 'Security warnings',
    'Select filter rules to use' => 'Select filter rules to use',
    'Select output filter' => 'Select output filter',
    'Select the way the impact thresholds are used in Zikula' => 'Select the way the impact thresholds are used in Zikula',
    'Semicolon (;)' => 'Semicolon (;)',
    'Send email on block action' => 'Send email on block action',
    'Session' => 'Session',
    'Session cookie name' => 'Session cookie name',
    'Session settings' => 'Session settings',
    'Setting HTMLPurifier configuration directives incorrectly can render your system unstable and inacessible. No validity checking is performed on any user-supplied settings. Ensure you fully understand each directive and its effects on your system. Ensure that all prerequisites are met and that any additional software or libraries required by each directive are properly installed and available to HTMLPurifier.' => 'Setting HTMLPurifier configuration directives incorrectly can render your system unstable and inacessible. No validity checking is performed on any user-supplied settings. Ensure you fully understand each directive and its effects on your system. Ensure that all prerequisites are met and that any additional software or libraries required by each directive are properly installed and available to HTMLPurifier.',
    'Sort by %s' => 'Sort by %s',
    'Store sessions' => 'Store sessions',
    'Tab' => 'Tab',
    'Tag' => 'Tag',
    'Tag usage (from %link%)' => 'Tag usage (from %link%)',
    'The update check is not enabled, but preferably should be.' => 'The update check is not enabled, but preferably should be.',
    'Translate embedded HTML entities into real characters' => 'Translate embedded HTML entities into real characters',
    'Use \'HTML Purifier\' + internal mechanism as output filter' => 'Use \'HTML Purifier\' + internal mechanism as output filter',
    'Use PHPIDS' => 'Use PHPIDS',
    'Use default value (if checked) or override value' => 'Use default value (if checked) or override value',
    'Use internal output filter only' => 'Use internal output filter only',
    'User Name' => 'User Name',
    'Value' => 'Value',
    'Value:' => 'Value:',
    'View IDS log' => 'View IDS log',
    'Warn only' => 'Warn only',
    'Warning' => 'Warning',
    'Warning! Enabling the %taglist% tags increases the opportunity for attacks against your users that might reveal their personal information. Therefore, you are recommended to keep these tags set to \'Not allowed\' unless you are sure that you really understand the consequences of enabling them.' => 'Warning! Enabling the %taglist% tags increases the opportunity for attacks against your users that might reveal their personal information. Therefore, you are recommended to keep these tags set to \'Not allowed\' unless you are sure that you really understand the consequences of enabling them.',
    'Weekly' => 'Weekly',
    'When a site is originally installed, the Security center is installed and activated by default. You will see the above message if the Security center has been deactivated. You are recommended to leave the Security center activated, as it enhances a site\'s security.' => 'When a site is originally installed, the Security center is installed and activated by default. You will see the above message if the Security center has been deactivated. You are recommended to leave the Security center activated, as it enhances a site\'s security.',
    'XML' => 'XML',
    'Yes' => 'Yes',
    'days (if \'Remember me\' is activated)' => 'days (if \'Remember me\' is activated)',
    'minutes of inactivity' => 'minutes of inactivity',
    'seconds' => 'seconds',
    'will be applied after HTMLPurifier processing is completed.' => 'will be applied after HTMLPurifier processing is completed.',
  ),
  'mail' => 
  array (
    '\'%siteName%\' account information' => '\'%siteName%\' account information',
    '(If you cannot click on the link above, you can copy this URL into your browser:' => '(If you cannot click on the link above, you can copy this URL into your browser:',
    '(If you cannot click on the link, you can copy the URL and paste it into your browser.)' => '(If you cannot click on the link, you can copy the URL and paste it into your browser.)',
    '(If you cannot click on the link, you can copy this URL and paste it into your browser: %sub% )' => '(If you cannot click on the link, you can copy this URL and paste it into your browser: %sub% )',
    '(This is the only time you will receive your password. Please keep it in a safe place.)' => '(This is the only time you will receive your password. Please keep it in a safe place.)',
    'A message from %siteName%.' => 'A message from %siteName%.',
    'A message from %sub%...' => 'A message from %sub%...',
    'A new user account has been activated on %sub%.' => 'A new user account has been activated on %sub%.',
    'A new user account has been created but not yet activated on %sub%.' => 'A new user account has been created but not yet activated on %sub%.',
    'Hello!' => 'Hello!',
    'Hello! This e-mail address (\'%email%\') has been used to register an account on \'%site%\' (%url%).' => 'Hello! This e-mail address (\'%email%\') has been used to register an account on \'%site%\' (%url%).',
    'Hello! You requested to change your e-mail address for user account \'%uname%\' at %site% from %email% to %newemail%.' => 'Hello! You requested to change your e-mail address for user account \'%uname%\' at %site% from %email% to %newemail%.',
    'If the request was not made by you then you don\'t need to take any action.' => 'If the request was not made by you then you don\'t need to take any action.',
    'If the request was not made by you then you don\'t need to worry.' => 'If the request was not made by you then you don\'t need to worry.',
    'If you are not able to click on the above link, you can copy it into your browser.' => 'If you are not able to click on the above link, you can copy it into your browser.',
    'If you are not able to click on the above link, you can copy the following URL into your browser:' => 'If you are not able to click on the above link, you can copy the following URL into your browser:',
    'If you did not make this request then you do not need to take any action.' => 'If you did not make this request then you do not need to take any action.',
    'If you did not request a new user account at this web site, please either contact our site administrator, or simply disregard this message.' => 'If you did not request a new user account at this web site, please either contact our site administrator, or simply disregard this message.',
    'If you did request a new user account, then your request is waiting for you to verify your e-mail address with us.' => 'If you did request a new user account, then your request is waiting for you to verify your e-mail address with us.',
    'If you do not confirm this change within the %sub% day(s), the request will be deleted from our system.' => 'If you do not confirm this change within the %sub% day(s), the request will be deleted from our system.',
    'It was created by an administrator or sub-administrator.' => 'It was created by an administrator or sub-administrator.',
    'New registration pending approval' => 'New registration pending approval',
    'New registration pending approval: %userName%' => 'New registration pending approval: %userName%',
    'New registration pending e-mail verification' => 'New registration pending e-mail verification',
    'New registration pending email verification: %userName%' => 'New registration pending email verification: %userName%',
    'New user activated' => 'New user activated',
    'New user activated: %userName%' => 'New user activated: %userName%',
    'Once both this verification step is complete and an administrator has approved your request, you will be able to log in with your user name.' => 'Once both this verification step is complete and an administrator has approved your request, you will be able to log in with your user name.',
    'Once verified and your account has been approved, then you will be able to log in.' => 'Once verified and your account has been approved, then you will be able to log in.',
    'Once verified, you will be able to log in.' => 'Once verified, you will be able to log in.',
    'Password' => 'Password',
    'Password:  %sub%' => 'Password:  %sub%',
    'Password: %sub%' => 'Password: %sub%',
    'Please click on the following link to complete the e-mail address check: ' => 'Please click on the following link to complete the e-mail address check: ',
    'Recently, this e-mail address (\'%email\') was used to request an account on \'%site%\' (%url%).' => 'Recently, this e-mail address (\'%email\') was used to request an account on \'%site%\' (%url%).',
    'Remember: both this verification step and approval from an administrator must be completed before you can log in.' => 'Remember: both this verification step and approval from an administrator must be completed before you can log in.',
    'Reset my password' => 'Reset my password',
    'Reset your password at %siteName%' => 'Reset your password at %siteName%',
    'Someone with the IP address %address% has just requested the account information at %site% associated with this e-mail address.' => 'Someone with the IP address %address% has just requested the account information at %site% associated with this e-mail address.',
    'Someone with the IP address %sub% has just requested your account password to be reset.' => 'Someone with the IP address %sub% has just requested your account password to be reset.',
    'Thank you for your application for a new account. At this time we are unable to approve your application.' => 'Thank you for your application for a new account. At this time we are unable to approve your application.',
    'Thank you for your application for a new account. Your application has been forwarded to the site administrator for review. Please expect a message once the review process is complete.' => 'Thank you for your application for a new account. Your application has been forwarded to the site administrator for review. Please expect a message once the review process is complete.',
    'The account details are as follows:' => 'The account details are as follows:',
    'The administrator at %sub% requested that reset your password.' => 'The administrator at %sub% requested that reset your password.',
    'The administrator at %sub% requested that you receive your user name via e-mail.' => 'The administrator at %sub% requested that you receive your user name via e-mail.',
    'The administrator at %sub% requested that you reset your password.' => 'The administrator at %sub% requested that you reset your password.',
    'The e-mail address will not be changed unless the confirmation code is used, and you are the only recipient of this message. You can just delete this message.' => 'The e-mail address will not be changed unless the confirmation code is used, and you are the only recipient of this message. You can just delete this message.',
    'The information that was registered is as follows:' => 'The information that was registered is as follows:',
    'The password won\'t be changed unless you choose a new one using the link above, and you are the only recipient of this message.' => 'The password won\'t be changed unless you choose a new one using the link above, and you are the only recipient of this message.',
    'The user account \'%username%\' at %sitename% has this e-mail address associated with it.' => 'The user account \'%username%\' at %sitename% has this e-mail address associated with it.',
    'The user name for your account is: %user%' => 'The user name for your account is: %user%',
    'The web site administrator has created this new account for you.' => 'The web site administrator has created this new account for you.',
    'This e-mail address (\'%email%\') has been used to register an account on \'%site%\' (%url%).' => 'This e-mail address (\'%email%\') has been used to register an account on \'%site%\' (%url%).',
    'This link expires in %amountOfDays% days.' => 'This link expires in %amountOfDays% days.',
    'User name' => 'User name',
    'User name: %sub%' => 'User name: %sub%',
    'Verify my e-mail address' => 'Verify my e-mail address',
    'Verify my e-mail address change.' => 'Verify my e-mail address change.',
    'Verify your e-mail address for %siteName%.' => 'Verify your e-mail address for %siteName%.',
    'Verify your request to change your e-mail address at %siteName%' => 'Verify your request to change your e-mail address at %siteName%',
    'Warning! The notification email for the new registration could not be sent.' => 'Warning! The notification email for the new registration could not be sent.',
    'Warning! The notification email for the newly created user could not be sent.' => 'Warning! The notification email for the newly created user could not be sent.',
    'Warning! The welcoming email for the new registration could not be sent.' => 'Warning! The welcoming email for the new registration could not be sent.',
    'Warning! The welcoming email for the newly created user could not be sent.' => 'Warning! The welcoming email for the newly created user could not be sent.',
    'Welcome to %site% (%url%)!' => 'Welcome to %site% (%url%)!',
    'Welcome to %siteName%!' => 'Welcome to %siteName%!',
    'Welcome to %siteName%, %userName%!' => 'Welcome to %siteName%, %userName%!',
    'Welcome to %sub%!' => 'Welcome to %sub%!',
    'You are the only recipient of this message, and your user name has not been sent to any other e-mail address.' => 'You are the only recipient of this message, and your user name has not been sent to any other e-mail address.',
    'You can confirm the e-mail address change by clicking on this link:' => 'You can confirm the e-mail address change by clicking on this link:',
    'You can confirm the e-mail address change by going to this URL with your browser:' => 'You can confirm the e-mail address change by going to this URL with your browser:',
    'You can just delete the message and log-in with your existing password next time you visit the site.' => 'You can just delete the message and log-in with your existing password next time you visit the site.',
    'You can just delete this message.' => 'You can just delete this message.',
    'You can now create a new password by clicking on this link:' => 'You can now create a new password by clicking on this link:',
    'You may now log into the web site.' => 'You may now log into the web site.',
    'You must confirm this change before it will take effect.' => 'You must confirm this change before it will take effect.',
    'You will receive an additional e-mail message once an administrator has reviewed your request.' => 'You will receive an additional e-mail message once an administrator has reviewed your request.',
    'Your account application has been approved by the site administrator. Thank you for your patience during the new account application review process.' => 'Your account application has been approved by the site administrator. Thank you for your patience during the new account application review process.',
    'Your account application has been approved. Thank you for your patience during the new account application review process.' => 'Your account application has been approved. Thank you for your patience during the new account application review process.',
    'Your account application is pending for some reason. Expect additional email(s) with information on finalizing your registration.' => 'Your account application is pending for some reason. Expect additional email(s) with information on finalizing your registration.',
    'Your account details are as follows:' => 'Your account details are as follows:',
    'Your recent request at %siteName%.' => 'Your recent request at %siteName%.',
    'Your request is also waiting for administrator approval.' => 'Your request is also waiting for administrator approval.',
    'Your verification code is:' => 'Your verification code is:',
  ),
  'messages' => 
  array (
    ' (mandatory) - The user email. If the validation method is based on the user email this value must be unique.' => ' (mandatory) - The user email. If the validation method is based on the user email this value must be unique.',
    ' (mandatory) - The user name. This value must be unique.' => ' (mandatory) - The user name. This value must be unique.',
    ' (mandatory) - The user password. It must have %sub% characters or more. Preferentially containing letters and numbers.' => ' (mandatory) - The user password. It must have %sub% characters or more. Preferentially containing letters and numbers.',
    ' - The identities of the groups where the user must belong separated by the character |. If you do not specify any group, the default group is %sub%.  Undefined groups will be ignored.' => ' - The identities of the groups where the user must belong separated by the character |. If you do not specify any group, the default group is %sub%.  Undefined groups will be ignored.',
    ' - Type 0 if user is not active, 1 if the user must be active. The default value is 1.' => ' - Type 0 if user is not active, 1 if the user must be active. The default value is 1.',
    ' - Type 1 if the system must send the password to the user via email and 0 otherwise. The default value is 1. The module Mailer must be active and correctly configured. The email is sent only if user activated value is upper than 0.' => ' - Type 1 if the system must send the password to the user via email and 0 otherwise. The default value is 1. The module Mailer must be active and correctly configured. The email is sent only if user activated value is upper than 0.',
    '!=' => '!=',
    '!in_array' => '!in_array',
    '%' => '%',
    '%action application for %user to %group group' => '%action application for %user to %group group',
    '%amount% pending applications' => '%amount% pending applications',
    '%count% anonymous guest(s)' => '%count% anonymous guest(s)',
    '%count% registered user(s)' => '%count% registered user(s)',
    '%extension% help' => '%extension% help',
    '%key% must be either (string) "%true%" or "%false%").' => '%key% must be either (string) "%true%" or "%false%").',
    '%key% must have a value that can be json_decoded.' => '%key% must have a value that can be json_decoded.',
    '%link% makes it possible for your site\'s users to use your site\'s search function as a search engine.' => '%link% makes it possible for your site\'s users to use your site\'s search function as a search engine.',
    '%module1% module can\'t connect to %module2% module. No connections are supported' => '%module1% module can\'t connect to %module2% module. No connections are supported',
    '%modulename%' => '%modulename%',
    '%name% ready for installation' => '%name% ready for installation',
    '%name% upgraded to new version and activated.' => '%name% upgraded to new version and activated.',
    '%pagetitle%' => '%pagetitle%',
    '%path% (%sort%)' => '%path% (%sort%)',
    '%sitename%' => '%sitename%',
    '%sub% module provides the following connections:' => '%sub% module provides the following connections:',
    '%theme% has no configuration.' => '%theme% has no configuration.',
    '%users% and %guests% online since %time%.' => '%users% and %guests% online since %time%.',
    '(Admin credentials have been encoded to make them json-safe.)' => '(Admin credentials have been encoded to make them json-safe.)',
    '(or approval was not required when the registration was completed)' => '(or approval was not required when the registration was completed)',
    '*** INSTALLING ***' => '*** INSTALLING ***',
    '*** UPGRADING TO ZIKULA CORE %version% ***' => '*** UPGRADING TO ZIKULA CORE %version% ***',
    ',' => ',',
    '/' => '/',
    '/full/path/to/file.txt' => '/full/path/to/file.txt',
    ':' => ':',
    ';' => ';',
    '<' => '<',
    '<=' => '<=',
    '<p><a href="https://ziku.la">Zikula</a> is an Open Source Content Application Framework built on top of Symfony.</p><p>With Zikula you get:</p><ul><li><strong>Power:</strong> You get the all the features of <a href="https://symfony.com">Symfony</a> PLUS: </li><li><strong>User Management:</strong> Built in User and Group management with Rights/Roles control</li><li><strong>Front end control:</strong> You can customise all aspects of the site\'s appearance through themes, with support for <a href="http://jquery.com">jQuery</a>, <a href="http://getbootstrap.com">Bootstrap</a> and many other modern technologies</li><li><strong>Internationalization (i18n):</strong> You can mark content as being suitable for either a single language or for all languages, and can control all aspects of localisation of your site</li><li><strong>Extensibility:</strong> you get a standard application-programming interface (API) that lets you easily extend your site\'s functionality through modules</li><li><strong>More:</strong> Admin UI, global categories, site-wide search, content blocks, menu creation, and more!</li><li><strong>Support:</strong> you can get help and support from the Zikula community of webmasters and developers at <a href="https://ziku.la">ziku.la</a>, <a href="https://github.com/zikula/core">Github</a> and <a href="https://zikula.slack.com/">Slack</a>.</li></ul><p>Enjoy using Zikula!</p><p><strong>The Zikula team</strong></p><p><em>Note: Zikula is Free Open Source Software (FOSS) licensed under the GNU General Public License.</em></p>' => '<p><a href="https://ziku.la">Zikula</a> is an Open Source Content Application Framework built on top of Symfony.</p><p>With Zikula you get:</p><ul><li><strong>Power:</strong> You get the all the features of <a href="https://symfony.com">Symfony</a> PLUS: </li><li><strong>User Management:</strong> Built in User and Group management with Rights/Roles control</li><li><strong>Front end control:</strong> You can customise all aspects of the site\'s appearance through themes, with support for <a href="http://jquery.com">jQuery</a>, <a href="http://getbootstrap.com">Bootstrap</a> and many other modern technologies</li><li><strong>Internationalization (i18n):</strong> You can mark content as being suitable for either a single language or for all languages, and can control all aspects of localisation of your site</li><li><strong>Extensibility:</strong> you get a standard application-programming interface (API) that lets you easily extend your site\'s functionality through modules</li><li><strong>More:</strong> Admin UI, global categories, site-wide search, content blocks, menu creation, and more!</li><li><strong>Support:</strong> you can get help and support from the Zikula community of webmasters and developers at <a href="https://ziku.la">ziku.la</a>, <a href="https://github.com/zikula/core">Github</a> and <a href="https://zikula.slack.com/">Slack</a>.</li></ul><p>Enjoy using Zikula!</p><p><strong>The Zikula team</strong></p><p><em>Note: Zikula is Free Open Source Software (FOSS) licensed under the GNU General Public License.</em></p>',
    '==' => '==',
    '>' => '>',
    '>=' => '>=',
    'A comma-delineated list. either "value, value, value" or "key:value, key:value, key:value"' => 'A comma-delineated list. either "value, value, value" or "key:value, key:value, key:value"',
    'A new application has been created by %userName% to %groupName%. Please attend to this request at %url%' => 'A new application has been created by %userName% to %groupName%. Please attend to this request at %url%',
    'A new version of the Zikula core is available. Please download the new Zikula core.' => 'A new version of the Zikula core is available. Please download the new Zikula core.',
    'A notification is sent to this e-mail address for each registration. Leave blank for no notifications.' => 'A notification is sent to this e-mail address for each registration. Leave blank for no notifications.',
    'A simple name with three letter suffix, e.g. `myfile.csv`' => 'A simple name with three letter suffix, e.g. `myfile.csv`',
    'A user with this %property% does not exist at this site.' => 'A user with this %property% does not exist at this site.',
    'A user with this address does not exist at this site.' => 'A user with this address does not exist at this site.',
    'A,A,A,A,A,a,a,a,a,a,O,O,O,O,O,o,o,o,o,o,E,E,E,E,e,e,e,e,C,c,I,I,I,I,i,i,i,i,U,U,U,u,u,u,y,N,n,ss,ae,Ae,oe,Oe,ue,Ue' => 'A,A,A,A,A,a,a,a,a,a,O,O,O,O,O,o,o,o,o,o,E,E,E,E,e,e,e,e,C,c,I,I,I,I,i,i,i,i,U,U,U,u,u,u,y,N,n,ss,ae,Ae,oe,Oe,ue,Ue',
    'About the CSV file' => 'About the CSV file',
    'Accept %username%' => 'Accept %username%',
    'Access forbidden.' => 'Access forbidden.',
    'Account Information' => 'Account Information',
    'Account Page Settings' => 'Account Page Settings',
    'Account information' => 'Account information',
    'Account information recovery' => 'Account information recovery',
    'Account menu' => 'Account menu',
    'Account verification' => 'Account verification',
    'Action' => 'Action',
    'Action:' => 'Action:',
    'Actions' => 'Actions',
    'Activate compression' => 'Activate compression',
    'Activate extension' => 'Activate extension',
    'Activate multilingual features' => 'Activate multilingual features',
    'Activate system extensions' => 'Activate system extensions',
    'Activating system extensions' => 'Activating system extensions',
    'Active' => 'Active',
    'Active modules' => 'Active modules',
    'Activity status' => 'Activity status',
    'Add Option' => 'Add Option',
    'Add access' => 'Add access',
    'Add attribute' => 'Add attribute',
    'Add filter' => 'Add filter',
    'Add node' => 'Add node',
    'Add user to this group' => 'Add user to this group',
    'Additional options' => 'Additional options',
    'Admin Login' => 'Admin Login',
    'Admin access' => 'Admin access',
    'Admin account created' => 'Admin account created',
    'Admin credentials required when site is disabled.' => 'Admin credentials required when site is disabled.',
    'Admin email address' => 'Admin email address',
    'Admin page' => 'Admin page',
    'Admin password' => 'Admin password',
    'Admin user name' => 'Admin user name',
    'Admin\'s e-mail address' => 'Admin\'s e-mail address',
    'Administrate membership application' => 'Administrate membership application',
    'Administration' => 'Administration',
    'Administration panel' => 'Administration panel',
    'Administration settings' => 'Administration settings',
    'Administrator' => 'Administrator',
    'Administrator approval:' => 'Administrator approval:',
    'Administrator log-in' => 'Administrator log-in',
    'Administrators' => 'Administrators',
    'Advanced setting, see <a href=\'%url%\' target="_blank">Symfony documentation</a>.' => 'Advanced setting, see <a href=\'%url%\' target="_blank">Symfony documentation</a>.',
    'Advanced settings' => 'Advanced settings',
    'Affected parameters: %parameters%' => 'Affected parameters: %parameters%',
    'Affected tags: %tags%' => 'Affected tags: %tags%',
    'After creating this block position, blocks can be assigned to it and the order they are to be displayed can be adjusted.' => 'After creating this block position, blocks can be assigned to it and the order they are to be displayed can be adjusted.',
    'All' => 'All',
    'All blocks placed.' => 'All blocks placed.',
    'All colours' => 'All colours',
    'All components' => 'All components',
    'All except approved' => 'All except approved',
    'All except trashed' => 'All except trashed',
    'All groups' => 'All groups',
    'All instances of LangBlock have been converted to LocaleBlock.' => 'All instances of LangBlock have been converted to LocaleBlock.',
    'All methods cannot be inactive. At least one methods must be enabled (%method% has been enabled).' => 'All methods cannot be inactive. At least one methods must be enabled (%method% has been enabled).',
    'All the dependencies for this extensions are fulfilled. You can safely install!' => 'All the dependencies for this extensions are fulfilled. You can safely install!',
    'All words' => 'All words',
    'Allow a user to authenticate and login via Zikula\'s native user database with their email address.' => 'Allow a user to authenticate and login via Zikula\'s native user database with their email address.',
    'Allow a user to authenticate and login via Zikula\'s native user database with their username or email address.' => 'Allow a user to authenticate and login via Zikula\'s native user database with their username or email address.',
    'Allow a user to authenticate and login via Zikula\'s native user database with their username.' => 'Allow a user to authenticate and login via Zikula\'s native user database with their username.',
    'Allow moderation specific creation date for route:' => 'Allow moderation specific creation date for route:',
    'Allow moderation specific creator for route:' => 'Allow moderation specific creator for route:',
    'Allow new user account registrations' => 'Allow new user account registrations',
    'Allow users to delete themselves (convert to ghost)' => 'Allow users to delete themselves (convert to ghost)',
    'Allowed HTML settings' => 'Allowed HTML settings',
    'Alphabetical' => 'Alphabetical',
    'Always' => 'Always',
    'Amazon SES' => 'Amazon SES',
    'An error has been encountered when attempting to view this page. See below for details!' => 'An error has been encountered when attempting to view this page. See below for details!',
    'An error occured during executing PHPIDS: %message%' => 'An error occured during executing PHPIDS: %message%',
    'An error occurred while creating cache directory at %path%' => 'An error occurred while creating cache directory at %path%',
    'An example of a valid CSV file' => 'An example of a valid CSV file',
    'Android Chrome' => 'Android Chrome',
    'Anonymous users are visitors to your site who have not logged in.' => 'Anonymous users are visitors to your site who have not logged in.',
    'Another example of a valid CSV file' => 'Another example of a valid CSV file',
    'Answer the security question' => 'Answer the security question',
    'Any 3 letter ISO 4217 code. Default: EUR' => 'Any 3 letter ISO 4217 code. Default: EUR',
    'Any group' => 'Any group',
    'Any words' => 'Any words',
    'Apologies!' => 'Apologies!',
    'Apple Touch' => 'Apple Touch',
    'Application cancelled.' => 'Application cancelled.',
    'Application comments' => 'Application comments',
    'Application processed (%action% %user%)' => 'Application processed (%action% %user%)',
    'Applied!' => 'Applied!',
    'Applies to ALL passwords (including admins). See %symfonydocs%' => 'Applies to ALL passwords (including admins). See %symfonydocs%',
    'Apply' => 'Apply',
    'Apply to membership of group' => 'Apply to membership of group',
    'Applying to group' => 'Applying to group',
    'Approve' => 'Approve',
    'Approve %sub%' => 'Approve %sub%',
    'Approve registration' => 'Approve registration',
    'Approve registration of %sub%' => 'Approve registration of %sub%',
    'Approved' => 'Approved',
    'Are you sure you want to delete the user (%un)?' => 'Are you sure you want to delete the user (%un)?',
    'Are you sure you want to delete this menu (%menu%) AND ALL ITS CHILDREN?' => 'Are you sure you want to delete this menu (%menu%) AND ALL ITS CHILDREN?',
    'Array' => 'Array',
    'Art and photography' => 'Art and photography',
    'Ascending' => 'Ascending',
    'Asking this question helps us prevent automated scripts from accessing private areas of the site.' => 'Asking this question helps us prevent automated scripts from accessing private areas of the site.',
    'Assets installed' => 'Assets installed',
    'Attached areas' => 'Attached areas',
    'Attempt to copy files from `userdata` to `public/uploads` failed. You must manually copy the contents.' => 'Attempt to copy files from `userdata` to `public/uploads` failed. You must manually copy the contents.',
    'Attribute' => 'Attribute',
    'Attributes' => 'Attributes',
    'Auth Method' => 'Auth Method',
    'Authentication identifier' => 'Authentication identifier',
    'Authentication methods' => 'Authentication methods',
    'Authentication secret' => 'Authentication secret',
    'Automatically detect language from browser settings' => 'Automatically detect language from browser settings',
    'Available areas' => 'Available areas',
    'Back to default view' => 'Back to default view',
    'Back to paginated view' => 'Back to paginated view',
    'Backend' => 'Backend',
    'Banned e-mail address domains' => 'Banned e-mail address domains',
    'Banned user agents' => 'Banned user agents',
    'Basic properties' => 'Basic properties',
    'Basic settings' => 'Basic settings',
    'Batch password change' => 'Batch password change',
    'Be advised: If your search resulted in more than 250 records, that display has been limited to 250.' => 'Be advised: If your search resulted in more than 250 records, that display has been limited to 250.',
    'Before logging in, the site administrator has asked that you change the password for your account.' => 'Before logging in, the site administrator has asked that you change the password for your account.',
    'Before you will be able to log in, an administrator must approve your registration request. You will receive an e-mail after an administrator has reviewed the information you submit below.' => 'Before you will be able to log in, an administrator must approve your registration request. You will receive an e-mail after an administrator has reviewed the information you submit below.',
    'Before you will be able to log in, you must verify your e-mail address. You will receive an e-mail asking to verify your e-mail address after submitting the information below.' => 'Before you will be able to log in, you must verify your e-mail address. You will receive an e-mail asking to verify your e-mail address after submitting the information below.',
    'Begin Installer' => 'Begin Installer',
    'Begin Migration' => 'Begin Migration',
    'Begin Upgrader' => 'Begin Upgrader',
    'Begin migration' => 'Begin migration',
    'Beginning user migration...' => 'Beginning user migration...',
    'Below you see your current routing configuration (see %link% for reference).' => 'Below you see your current routing configuration (see %link% for reference).',
    'Birthday' => 'Birthday',
    'Block ID' => 'Block ID',
    'Block Type' => 'Block Type',
    'Block View' => 'Block View',
    'Block class %className% does not exist.' => 'Block class %className% does not exist.',
    'Block class %className% not found in container.' => 'Block class %className% not found in container.',
    'Block placements' => 'Block placements',
    'Block positions list' => 'Block positions list',
    'Block settings' => 'Block settings',
    'Block type' => 'Block type',
    'Blocks' => 'Blocks',
    'Blocks list' => 'Blocks list',
    'Blocks not placed in \'%name%\' position' => 'Blocks not placed in \'%name%\' position',
    'Blocks placed in the \'%name%\' position' => 'Blocks placed in the \'%name%\' position',
    'Blogging' => 'Blogging',
    'Bottom navigation block' => 'Bottom navigation block',
    'Branding images' => 'Branding images',
    'Browser' => 'Browser',
    'Bundle' => 'Bundle',
    'Bundle:' => 'Bundle:',
    'Business and work' => 'Business and work',
    'By default, all users are made members of this group.' => 'By default, all users are made members of this group.',
    'CAUTION' => 'CAUTION',
    'CSV delimiter' => 'CSV delimiter',
    'CSV file (Max. %maxSize%)' => 'CSV file (Max. %maxSize%)',
    'CSV filename' => 'CSV filename',
    'Caches cleared' => 'Caches cleared',
    'Cancel' => 'Cancel',
    'Cancel forced password change' => 'Cancel forced password change',
    'Cancel forced password change for %1s' => 'Cancel forced password change for %1s',
    'Cancel install' => 'Cancel install',
    'Cancel required change of password for %sub%' => 'Cancel required change of password for %sub%',
    'Cannot load %extension% because the composer file is invalid.' => 'Cannot load %extension% because the composer file is invalid.',
    'Cannot login yet. Your request to register with this site is pending or awaiting verification.' => 'Cannot login yet. Your request to register with this site is pending or awaiting verification.',
    'Cannot write database DSN to %file% file.' => 'Cannot write database DSN to %file% file.',
    'Cannot write mailer DSN to %file% file.' => 'Cannot write mailer DSN to %file% file.',
    'Cannot write parameters to %fileName% file.' => 'Cannot write parameters to %fileName% file.',
    'Cannot write to %file%.' => 'Cannot write to %file%.',
    'Categories' => 'Categories',
    'Categories list' => 'Categories list',
    'Category' => 'Category',
    'Category "%name%" was successfully made default.' => 'Category "%name%" was successfully made default.',
    'Category attributes' => 'Category attributes',
    'Category is a leaf node' => 'Category is a leaf node',
    'Category is locked' => 'Category is locked',
    'Category registry' => 'Category registry',
    'Category root' => 'Category root',
    'Category tree' => 'Category tree',
    'Caution' => 'Caution',
    'Center blocks' => 'Center blocks',
    'Change e-mail address' => 'Change e-mail address',
    'Change password' => 'Change password',
    'Change style' => 'Change style',
    'Changing this setting will affect all password change requests currently pending verification.' => 'Changing this setting will affect all password change requests currently pending verification.',
    'Changing this setting will affect all requests to change e-mail addresses currently pending verification.' => 'Changing this setting will affect all requests to change e-mail addresses currently pending verification.',
    'Characters allowed: a-z, A-Z, 0-9, dash (-) and underscore (_).' => 'Characters allowed: a-z, A-Z, 0-9, dash (-) and underscore (_).',
    'Check a users permission' => 'Check a users permission',
    'Check interval' => 'Check interval',
    'Check now' => 'Check now',
    'Check permission' => 'Check permission',
    'Check that you spelled all words correctly.' => 'Check that you spelled all words correctly.',
    'Check the methods you wish to activate.' => 'Check the methods you wish to activate.',
    'Checkbox' => 'Checkbox',
    'Checked' => 'Checked',
    'Checking database connection...' => 'Checking database connection...',
    'Children' => 'Children',
    'Choice' => 'Choice',
    'Choice fields' => 'Choice fields',
    'Choices' => 'Choices',
    'Choose' => 'Choose',
    'Choose a block type' => 'Choose a block type',
    'Choose a category' => 'Choose a category',
    'Choose a file' => 'Choose a file',
    'Choose a login authentication method' => 'Choose a login authentication method',
    'Choose a user name' => 'Choose a user name',
    'Choose action' => 'Choose action',
    'Choose categories' => 'Choose categories',
    'Choose language' => 'Choose language',
    'Choose the methods.' => 'Choose the methods.',
    'Choose the schemes.' => 'Choose the schemes.',
    'Classic favicon' => 'Classic favicon',
    'Clear' => 'Clear',
    'Clear caches' => 'Clear caches',
    'Clearing caches' => 'Clearing caches',
    'Click here to visit your homepage' => 'Click here to visit your homepage',
    'Click on a connection to delete it.' => 'Click on a connection to delete it.',
    'Click on the %add_node% button to add new states and transitions.' => 'Click on the %add_node% button to add new states and transitions.',
    'Click on the trash-can icons to delete nodes and their connections.' => 'Click on the trash-can icons to delete nodes and their connections.',
    'Click to activate block' => 'Click to activate block',
    'Click to deactivate block' => 'Click to deactivate block',
    'Click to deactivate this block' => 'Click to deactivate this block',
    'Close' => 'Close',
    'Closed' => 'Closed',
    'Closed: only the core or administrator (ACCESS_EDIT) may add users. closed groups may be hidden by config setting' => 'Closed: only the core or administrator (ACCESS_EDIT) may add users. closed groups may be hidden by config setting',
    'Collapse' => 'Collapse',
    'Colour' => 'Colour',
    'Comment' => 'Comment',
    'Comment access' => 'Comment access',
    'Comment to attach to your application' => 'Comment to attach to your application',
    'Communications and media' => 'Communications and media',
    'Comparator' => 'Comparator',
    'Component' => 'Component',
    'Component to check' => 'Component to check',
    'Condition' => 'Condition',
    'Condition:' => 'Condition:',
    'Configs:' => 'Configs:',
    'Configuration' => 'Configuration',
    'Configuration successful. Please verify your parameters below:' => 'Configuration successful. Please verify your parameters below:',
    'Configuring Zikula installation in %env% environment.' => 'Configuring Zikula installation in %env% environment.',
    'Confirm deletion' => 'Confirm deletion',
    'Confirm sending code' => 'Confirm sending code',
    'Confirm verification code' => 'Confirm verification code',
    'Confirm verification code is to be sent to %sub%' => 'Confirm verification code is to be sent to %sub%',
    'Confirmation prompt' => 'Confirmation prompt',
    'Congratulations! Upgrade Complete.' => 'Congratulations! Upgrade Complete.',
    'Congratulations! Zikula has been successfully installed.' => 'Congratulations! Zikula has been successfully installed.',
    'Connections' => 'Connections',
    'Content' => 'Content',
    'Content has been approved and is available online.' => 'Content has been approved and is available online.',
    'Content has been marked as deleted, but is still persisted in the database.' => 'Content has been marked as deleted, but is still persisted in the database.',
    'Continue install' => 'Continue install',
    'Controller' => 'Controller',
    'Controller:' => 'Controller:',
    'Core' => 'Core',
    'Core compatibility information' => 'Core compatibility information',
    'Core modules at the heart of operation of the site.' => 'Core modules at the heart of operation of the site.',
    'Core: Users can only be added by an administrator (ACCESS_EDIT) - groups are not visible to users in public list' => 'Core: Users can only be added by an administrator (ACCESS_EDIT) - groups are not visible to users in public list',
    'Could not change the setting due to missing session access.' => 'Could not change the setting due to missing session access.',
    'Could not json_decode the string you entered.' => 'Could not json_decode the string you entered.',
    'Could not send mail.' => 'Could not send mail.',
    'Could not set %setting% to the value of %requiredValue%. The install or upgrade process may fail at your current setting of %currentValue%.' => 'Could not set %setting% to the value of %requiredValue%. The install or upgrade process may fail at your current setting of %currentValue%.',
    'Could not use %command% to set the %setting% to the value of %requiredValue%. The install or upgrade process may fail at your current setting of %currentValue%.' => 'Could not use %command% to set the %setting% to the value of %requiredValue%. The install or upgrade process may fail at your current setting of %currentValue%.',
    'Country' => 'Country',
    'Create a new password.' => 'Create a new password.',
    'Create a password' => 'Create a password',
    'Create admin' => 'Create admin',
    'Create admin account' => 'Create admin account',
    'Create administrator\'s account' => 'Create administrator\'s account',
    'Create block' => 'Create block',
    'Create block position' => 'Create block position',
    'Create blocks' => 'Create blocks',
    'Create new account' => 'Create new account',
    'Create new block' => 'Create new block',
    'Create new block position' => 'Create new block position',
    'Create new group' => 'Create new group',
    'Create new module category' => 'Create new module category',
    'Create new password' => 'Create new password',
    'Create new permission rule' => 'Create new permission rule',
    'Create new user' => 'Create new user',
    'Create or Edit Root Node' => 'Create or Edit Root Node',
    'Create or edit root node' => 'Create or edit root node',
    'Create route' => 'Create route',
    'Created by %user%' => 'Created by %user%',
    'Created by %user% on %date%' => 'Created by %user% on %date%',
    'Created on %date%' => 'Created on %date%',
    'Created on %s.' => 'Created on %s.',
    'Creating admin account' => 'Creating admin account',
    'Creating default blocks' => 'Creating default blocks',
    'Creation' => 'Creation',
    'Creation and update' => 'Creation and update',
    'Creation date' => 'Creation date',
    'Creator' => 'Creator',
    'Currency' => 'Currency',
    'Current Core version is %version%' => 'Current Core version is %version%',
    'Currently used version' => 'Currently used version',
    'Custom filters' => 'Custom filters',
    'Custom parameters' => 'Custom parameters',
    'Custom routes list' => 'Custom routes list',
    'DELETE' => 'DELETE',
    'Danger' => 'Danger',
    'Dark' => 'Dark',
    'Data provided was inappropriate.' => 'Data provided was inappropriate.',
    'Database' => 'Database',
    'Database host' => 'Database host',
    'Database information' => 'Database information',
    'Database name' => 'Database name',
    'Database password' => 'Database password',
    'Database port' => 'Database port',
    'Database type' => 'Database type',
    'Database user name' => 'Database user name',
    'Date' => 'Date',
    'Date and time fields' => 'Date and time fields',
    'Date of last search' => 'Date of last search',
    'Date: %date%' => 'Date: %date%',
    'DateTime' => 'DateTime',
    'DateTime object' => 'DateTime object',
    'De-select all' => 'De-select all',
    'Deactivate extension' => 'Deactivate extension',
    'Decrease zoom level' => 'Decrease zoom level',
    'Default' => 'Default',
    'Default blocks created' => 'Default blocks created',
    'Default category for newly-added modules' => 'Default category for newly-added modules',
    'Default language to use for this site' => 'Default language to use for this site',
    'Default meta description' => 'Default meta description',
    'Default page title' => 'Default page title',
    'Default user group. Cannot be deleted.' => 'Default user group. Cannot be deleted.',
    'Default values for HTML Purifier were successfully loaded. Please store them using the "Save" button at the bottom of this page' => 'Default values for HTML Purifier were successfully loaded. Please store them using the "Save" button at the bottom of this page',
    'Default values reloaded. Save to confirm.' => 'Default values reloaded. Save to confirm.',
    'Default: %value%' => 'Default: %value%',
    'Default: \'%value%\'' => 'Default: \'%value%\'',
    'Defaults' => 'Defaults',
    'Defaults:' => 'Defaults:',
    'Delete' => 'Delete',
    'Delete %n' => 'Delete %n',
    'Delete %sub%' => 'Delete %sub%',
    'Delete Root' => 'Delete Root',
    'Delete access' => 'Delete access',
    'Delete all children' => 'Delete all children',
    'Delete all sub-categories' => 'Delete all sub-categories',
    'Delete block' => 'Delete block',
    'Delete block position' => 'Delete block position',
    'Delete category' => 'Delete category',
    'Delete confirmation' => 'Delete confirmation',
    'Delete content permanently.' => 'Delete content permanently.',
    'Delete group' => 'Delete group',
    'Delete module category' => 'Delete module category',
    'Delete my account' => 'Delete my account',
    'Delete registry entry' => 'Delete registry entry',
    'Delete selected users' => 'Delete selected users',
    'Delete this permission rule' => 'Delete this permission rule',
    'Delete user account' => 'Delete user account',
    'Deleted' => 'Deleted',
    'Deleting could \'orphan\' data in the system and cause display errors or other unknown problems.' => 'Deleting could \'orphan\' data in the system and cause display errors or other unknown problems.',
    'Deleting your Account is not recommended.' => 'Deleting your Account is not recommended.',
    'Deletion type' => 'Deletion type',
    'Deny %username%' => 'Deny %username%',
    'Descending' => 'Descending',
    'Description' => 'Description',
    'Description line' => 'Description line',
    'Description:' => 'Description:',
    'Detach' => 'Detach',
    'Details' => 'Details',
    'Development/debug mode (Do not send any email)' => 'Development/debug mode (Do not send any email)',
    'Disable edit in place' => 'Disable edit in place',
    'Disable search plug-ins' => 'Disable search plug-ins',
    'Disable site' => 'Disable site',
    'Disabled plugins' => 'Disabled plugins',
    'Display description' => 'Display description',
    'Display graphics on user\'s account page' => 'Display graphics on user\'s account page',
    'Display icons' => 'Display icons',
    'Display name' => 'Display name',
    'Display settings' => 'Display settings',
    'Do you really want to delete block \'%title%\'?' => 'Do you really want to delete block \'%title%\'?',
    'Do you really want to delete group \'%s\'?' => 'Do you really want to delete group \'%s\'?',
    'Do you really want to delete module category \'%s\'?' => 'Do you really want to delete module category \'%s\'?',
    'Do you really want to delete position \'%name%\'?' => 'Do you really want to delete position \'%name%\'?',
    'Do you really want to delete this category?' => 'Do you really want to delete this category?',
    'Do you really want to delete this item?' => 'Do you really want to delete this item?',
    'Do you really want to delete this permission rule?' => 'Do you really want to delete this permission rule?',
    'Do you really want to delete this registry entry?' => 'Do you really want to delete this registry entry?',
    'Do you really want to remove user "%username" from group "%groupname"?' => 'Do you really want to remove user "%username" from group "%groupname"?',
    'Do you really want to uninstall \'%title%\'?' => 'Do you really want to uninstall \'%title%\'?',
    'Do you want to <a href="%registerLink%">register</a>?' => 'Do you want to <a href="%registerLink%">register</a>?',
    'Do you want to cancel the forced password change for %1s?' => 'Do you want to cancel the forced password change for %1s?',
    'Do you want to force a password change during the next login attempt for %1s?' => 'Do you want to force a password change during the next login attempt for %1s?',
    'Doctrine Exception' => 'Doctrine Exception',
    'Document URL' => 'Document URL',
    'Document contents' => 'Document contents',
    'Done! %count% users imported.' => 'Done! %count% users imported.',
    'Done! %sub% has been approved.' => 'Done! %sub% has been approved.',
    'Done! A password change will be required the next time %userName% logs in.' => 'Done! A password change will be required the next time %userName% logs in.',
    'Done! A password change will no longer be required for %userName%.' => 'Done! A password change will no longer be required for %userName%.',
    'Done! Activated %name%.' => 'Done! Activated %name%.',
    'Done! Block deleted.' => 'Done! Block deleted.',
    'Done! Block saved.' => 'Done! Block saved.',
    'Done! Category deleted.' => 'Done! Category deleted.',
    'Done! Changed your e-mail address.' => 'Done! Changed your e-mail address.',
    'Done! Configuration updated.' => 'Done! Configuration updated.',
    'Done! Created new category.' => 'Done! Created new category.',
    'Done! Created new registration application.' => 'Done! Created new registration application.',
    'Done! Created new user account.' => 'Done! Created new user account.',
    'Done! Created the group.' => 'Done! Created the group.',
    'Done! Deactivated %name%.' => 'Done! Deactivated %name%.',
    'Done! Disabled edit in place translations.' => 'Done! Disabled edit in place translations.',
    'Done! Enabled edit in place translations.' => 'Done! Enabled edit in place translations.',
    'Done! Exposed JS Routes dumped to %path%.' => 'Done! Exposed JS Routes dumped to %path%.',
    'Done! Extension updated.' => 'Done! Extension updated.',
    'Done! Group deleted.' => 'Done! Group deleted.',
    'Done! Installed "%name%".' => 'Done! Installed "%name%".',
    'Done! Item created.' => 'Done! Item created.',
    'Done! Item deleted.' => 'Done! Item deleted.',
    'Done! Item updated.' => 'Done! Item updated.',
    'Done! Localization configuration updated.' => 'Done! Localization configuration updated.',
    'Done! Mail sent.' => 'Done! Mail sent.',
    'Done! Mailer Transport Config updated.' => 'Done! Mailer Transport Config updated.',
    'Done! Menu removed.' => 'Done! Menu removed.',
    'Done! Message sent.' => 'Done! Message sent.',
    'Done! Position deleted.' => 'Done! Position deleted.',
    'Done! Position saved.' => 'Done! Position saved.',
    'Done! Purged IDS log.' => 'Done! Purged IDS log.',
    'Done! Registry entry deleted.' => 'Done! Registry entry deleted.',
    'Done! Registry updated.' => 'Done! Registry updated.',
    'Done! Route created.' => 'Done! Route created.',
    'Done! Route deleted.' => 'Done! Route deleted.',
    'Done! Route updated.' => 'Done! Route updated.',
    'Done! Routes reloaded.' => 'Done! Routes reloaded.',
    'Done! Routing settings renewed.' => 'Done! Routing settings renewed.',
    'Done! Saved HTMLPurifier configuration.' => 'Done! Saved HTMLPurifier configuration.',
    'Done! Saved category.' => 'Done! Saved category.',
    'Done! Saved user\'s account information.' => 'Done! Saved user\'s account information.',
    'Done! The account information for %email% has been sent via e-mail.' => 'Done! The account information for %email% has been sent via e-mail.',
    'Done! The application has been sent. You will be notified by email when the application is processed.' => 'Done! The application has been sent. You will be notified by email when the application is processed.',
    'Done! The confirmation link for %identifier% has been sent via e-mail.' => 'Done! The confirmation link for %identifier% has been sent via e-mail.',
    'Done! The password recovery verification link for %userName% has been sent via e-mail.' => 'Done! The password recovery verification link for %userName% has been sent via e-mail.',
    'Done! The user name for %userName% has been sent via e-mail.' => 'Done! The user name for %userName% has been sent via e-mail.',
    'Done! The user was added to the group.' => 'Done! The user was added to the group.',
    'Done! The user was removed from the group.' => 'Done! The user was removed from the group.',
    'Done! Theme configuration updated to default values.' => 'Done! Theme configuration updated to default values.',
    'Done! Theme configuration updated.' => 'Done! Theme configuration updated.',
    'Done! Uninstalled extension.' => 'Done! Uninstalled extension.',
    'Done! Updated the group.' => 'Done! Updated the group.',
    'Done! Verification code sent to %sub%.' => 'Done! Verification code sent to %sub%.',
    'Done! You will receive an e-mail to your new e-mail address to confirm the change. You must follow the instructions in that message in order to verify your new address.' => 'Done! You will receive an e-mail to your new e-mail address to confirm the change. You must follow the instructions in that message in order to verify your new address.',
    'Done! Your account has been created and you may now log in.' => 'Done! Your account has been created and you may now log in.',
    'Done! Your account has been created.' => 'Done! Your account has been created.',
    'Done! Your account has been verified, and is awaiting administrator approval.' => 'Done! Your account has been verified, and is awaiting administrator approval.',
    'Done! Your account has been verified.' => 'Done! Your account has been verified.',
    'Done! Your account has been verified. You have been logged in.' => 'Done! Your account has been verified. You have been logged in.',
    'Done! Your account has been verified. Your registration request is still pending completion. Please contact the site administrator for more information.' => 'Done! Your account has been verified. Your registration request is still pending completion. Please contact the site administrator for more information.',
    'Done! Your registration request has been saved and is pending. Please check your e-mail periodically for a message from us.' => 'Done! Your registration request has been saved and is pending. Please check your e-mail periodically for a message from us.',
    'Double-click on a node to edit it.' => 'Double-click on a node to edit it.',
    'Download' => 'Download',
    'Drag an area from the right and drop it here to attach it.' => 'Drag an area from the right and drop it here to attach it.',
    'Drag and drop into a new module category' => 'Drag and drop into a new module category',
    'Drag from node exchange icons to other nodes to add new connections.' => 'Drag from node exchange icons to other nodes to add new connections.',
    'Drag items from the right column to the left column to connect the hooks. Only areas with the same category can be connected.' => 'Drag items from the right column to the left column to connect the hooks. Only areas with the same category can be connected.',
    'Drag to reorder' => 'Drag to reorder',
    'Dump exposed js routes to file' => 'Dump exposed js routes to file',
    'During your visits, we recommended that you set your browser to accept cookies from this site. Various features of the site use cookies, and may not function properly (or may not function at all) if cookies are disabled.' => 'During your visits, we recommended that you set your browser to accept cookies from this site. Various features of the site use cookies, and may not function properly (or may not function at all) if cookies are disabled.',
    'E-mail' => 'E-mail',
    'E-mail address to notify of registrations' => 'E-mail address to notify of registrations',
    'E-mail address:' => 'E-mail address:',
    'Edit' => 'Edit',
    'Edit %sub%' => 'Edit %sub%',
    'Edit access' => 'Edit access',
    'Edit block' => 'Edit block',
    'Edit block placements' => 'Edit block placements',
    'Edit block position' => 'Edit block position',
    'Edit category' => 'Edit category',
    'Edit category registry' => 'Edit category registry',
    'Edit children' => 'Edit children',
    'Edit extension' => 'Edit extension',
    'Edit group' => 'Edit group',
    'Edit item' => 'Edit item',
    'Edit menu root' => 'Edit menu root',
    'Edit module category' => 'Edit module category',
    'Edit node' => 'Edit node',
    'Edit route' => 'Edit route',
    'Edit theme vars' => 'Edit theme vars',
    'Edit this permission rule' => 'Edit this permission rule',
    'Edit this route' => 'Edit this route',
    'Edit translations directly in the context of a page' => 'Edit translations directly in the context of a page',
    'Edit user account' => 'Edit user account',
    'Edit user account of %uname' => 'Edit user account of %uname',
    'Edit?' => 'Edit?',
    'Either the Document URL of the Document contents can contain a value, not both.' => 'Either the Document URL of the Document contents can contain a value, not both.',
    'Either the Document URL or the Document contents must contain a value.' => 'Either the Document URL or the Document contents must contain a value.',
    'Either the Style sheet URL or the Style sheet contents can contain a value, not both.' => 'Either the Style sheet URL or the Style sheet contents can contain a value, not both.',
    'Either the Style sheet URL or the Style sheet contents must contain a value.' => 'Either the Style sheet URL or the Style sheet contents must contain a value.',
    'Email' => 'Email',
    'Email address' => 'Email address',
    'Email address manager' => 'Email address manager',
    'Email address verifications expire in' => 'Email address verifications expire in',
    'Email content' => 'Email content',
    'Email settings are not yet configured or incorrectly configured. Please configure them below.' => 'Email settings are not yet configured or incorrectly configured. Please configure them below.',
    'Email verified' => 'Email verified',
    'Empty argument at' => 'Empty argument at',
    'Empty values are allowed for all except Mailer transport.' => 'Empty values are allowed for all except Mailer transport.',
    'Enable OpenSearch' => 'Enable OpenSearch',
    'Enable block collapse icons' => 'Enable block collapse icons',
    'Enable edit in place' => 'Enable edit in place',
    'Enable filtering of group permissions' => 'Enable filtering of group permissions',
    'Enable logging of sent mail' => 'Enable logging of sent mail',
    'English' => 'English',
    'Ensure the database is in UTF-8 format.' => 'Ensure the database is in UTF-8 format.',
    'Enter a part of the user name to search' => 'Enter a part of the user name to search',
    'Enter custom port number or leave empty for default.' => 'Enter custom port number or leave empty for default.',
    'Enter one entry per line, use <code>key:value</code> syntax.' => 'Enter one entry per line, use <code>key:value</code> syntax.',
    'Enter one entry per line.' => 'Enter one entry per line.',
    'Enter the action of the route' => 'Enter the action of the route',
    'Enter the action of the route.' => 'Enter the action of the route.',
    'Enter the bundle of the route' => 'Enter the bundle of the route',
    'Enter the bundle of the route.' => 'Enter the bundle of the route.',
    'Enter the condition of the route' => 'Enter the condition of the route',
    'Enter the condition of the route.' => 'Enter the condition of the route.',
    'Enter the controller of the route' => 'Enter the controller of the route',
    'Enter the controller of the route.' => 'Enter the controller of the route.',
    'Enter the defaults of the route.' => 'Enter the defaults of the route.',
    'Enter the description of the route' => 'Enter the description of the route',
    'Enter the description of the route.' => 'Enter the description of the route.',
    'Enter the host of the route' => 'Enter the host of the route',
    'Enter the host of the route.' => 'Enter the host of the route.',
    'Enter the number of days a registration record should be kept while waiting for e-mail address verification. (Unverified registrations will be deleted the specified number of days after sending an e-mail verification message.) Enter zero (0) for no expiration (no automatic deletion).' => 'Enter the number of days a registration record should be kept while waiting for e-mail address verification. (Unverified registrations will be deleted the specified number of days after sending an e-mail verification message.) Enter zero (0) for no expiration (no automatic deletion).',
    'Enter the number of days a user\'s request to change e-mail addresses should be kept while waiting for verification. Enter zero (0) for no expiration.' => 'Enter the number of days a user\'s request to change e-mail addresses should be kept while waiting for verification. Enter zero (0) for no expiration.',
    'Enter the options of the route.' => 'Enter the options of the route.',
    'Enter the path of the route' => 'Enter the path of the route',
    'Enter the path of the route.' => 'Enter the path of the route.',
    'Enter the requirements of the route.' => 'Enter the requirements of the route.',
    'Enter the route entries per page. Only digits are allowed.' => 'Enter the route entries per page. Only digits are allowed.',
    'Enter the sort of the route. Only digits are allowed.' => 'Enter the sort of the route. Only digits are allowed.',
    'Enter the translation prefix of the route.' => 'Enter the translation prefix of the route.',
    'Enter your e-mail address' => 'Enter your e-mail address',
    'Entity' => 'Entity',
    'Error found in composer file of %component% (%filePath%) in property "%property%": %error%.' => 'Error found in composer file of %component% (%filePath%) in property "%property%": %error%.',
    'Error! %extension% is not compatible with this version of Zikula.' => 'Error! %extension% is not compatible with this version of Zikula.',
    'Error! %extension% is not yet installed, therefore it cannot be uninstalled.' => 'Error! %extension% is not yet installed, therefore it cannot be uninstalled.',
    'Error! %sub% cannot be approved.' => 'Error! %sub% cannot be approved.',
    'Error! A category by this name already exists.' => 'Error! A category by this name already exists.',
    'Error! Activation of %name% not allowed.' => 'Error! Activation of %name% not allowed.',
    'Error! Controller helper needs a request.' => 'Error! Controller helper needs a request.',
    'Error! Could not connect to the database. Please check that you have entered the correct database information and try again. ' => 'Error! Could not connect to the database. Please check that you have entered the correct database information and try again. ',
    'Error! Could not determine workflow actions.' => 'Error! Could not determine workflow actions.',
    'Error! Could not get module name for id %moduleId%.' => 'Error! Could not get module name for id %moduleId%.',
    'Error! Could not load data for %extension%.' => 'Error! Could not load data for %extension%.',
    'Error! Could not login because the user could not be found. Please try again.' => 'Error! Could not login because the user could not be found. Please try again.',
    'Error! Could not login with the provided credentials. Please try again.' => 'Error! Could not login with the provided credentials. Please try again.',
    'Error! Could not make this category default.' => 'Error! Could not make this category default.',
    'Error! Could not resolve %template% template.' => 'Error! Could not resolve %template% template.',
    'Error! Could not save configuration: unknown permission rule ID.' => 'Error! Could not save configuration: unknown permission rule ID.',
    'Error! Creation attempt failed.' => 'Error! Creation attempt failed.',
    'Error! Deletion attempt failed.' => 'Error! Deletion attempt failed.',
    'Error! Determination existing tables failed.' => 'Error! Determination existing tables failed.',
    'Error! In your permalink settings, strings cannot be terminated with a comma.' => 'Error! In your permalink settings, strings cannot be terminated with a comma.',
    'Error! In your permalink settings, the search list and the replacement list for permalink cleansing have a different number of comma-separated elements. If you have 3 elements in the search list then there must be 3 elements in the replacement list.' => 'Error! In your permalink settings, the search list and the replacement list for permalink cleansing have a different number of comma-separated elements. If you have 3 elements in the search list then there must be 3 elements in the replacement list.',
    'Error! Invalid %identifier% received.' => 'Error! Invalid %identifier% received.',
    'Error! Invalid module state transition.' => 'Error! Invalid module state transition.',
    'Error! Invalid object type received.' => 'Error! Invalid object type received.',
    'Error! It has not been possible to read the import file.' => 'Error! It has not been possible to read the import file.',
    'Error! No category name given.' => 'Error! No category name given.',
    'Error! No permission to uninstall %extension%.' => 'Error! No permission to uninstall %extension%.',
    'Error! No such category found.' => 'Error! No such category found.',
    'Error! Not allowed to install %extension%.' => 'Error! Not allowed to install %extension%.',
    'Error! Not allowed to upgrade %extension%.' => 'Error! Not allowed to upgrade %extension%.',
    'Error! PHPIDS rule file %filePath% does not exist or is not readable.' => 'Error! PHPIDS rule file %filePath% does not exist or is not readable.',
    'Error! Please enter your database credentials.' => 'Error! Please enter your database credentials.',
    'Error! Session path not writeable!' => 'Error! Session path not writeable!',
    'Error! The database exists and contains tables. Please delete all tables before proceeding or select a new database.' => 'Error! The database exists and contains tables. Please delete all tables before proceeding or select a new database.',
    'Error! The import file does not have the expected field %s in the first row. Please check your import file.' => 'Error! The import file does not have the expected field %s in the first row. Please check your import file.',
    'Error! The import file does not have values.' => 'Error! The import file does not have values.',
    'Error! The number of parameters in line %s is not correct. Please check your import file.' => 'Error! The number of parameters in line %s is not correct. Please check your import file.',
    'Error! The requested extension cannot be uninstalled because its files are missing!' => 'Error! The requested extension cannot be uninstalled because its files are missing!',
    'Error! There was a problem saving your new e-mail address or sending you a verification message.' => 'Error! There was a problem saving your new e-mail address or sending you a verification message.',
    'Error! There was a problem with the database connection.' => 'Error! There was a problem with the database connection.',
    'Error! There was an error dumping exposed JS Routes: %result%' => 'Error! There was an error dumping exposed JS Routes: %result%',
    'Error! This module category is currently set as the category that is initially displayed when you visit the administration panel. You must first select a different category for initial display. Afterwards, you will be able to delete the category you have just attempted to remove.' => 'Error! This module category is currently set as the category that is initially displayed when you visit the administration panel. You must first select a different category for initial display. Afterwards, you will be able to delete the category you have just attempted to remove.',
    'Error! Update attempt failed.' => 'Error! Update attempt failed.',
    'Error! You can\'t edit the guest account.' => 'Error! You can\'t edit the guest account.',
    'Error! You cannot apply to join the requested group' => 'Error! You cannot apply to join the requested group',
    'Error! You cannot deactivate the %name%. It is required by the system.' => 'Error! You cannot deactivate the %name%. It is required by the system.',
    'Error! You cannot deactivate the %name%. The theme is in use.' => 'Error! You cannot deactivate the %name%. The theme is in use.',
    'Error! You cannot delete the default module category used in the administration panel.' => 'Error! You cannot delete the default module category used in the administration panel.',
    'Error! You cannot delete the default user group.' => 'Error! You cannot delete the default user group.',
    'Error! You cannot delete the primary administration group.' => 'Error! You cannot delete the primary administration group.',
    'Error! You have not been logged out.' => 'Error! You have not been logged out.',
    'Error! You logged in to an account without Admin permissions' => 'Error! You logged in to an account without Admin permissions',
    'Error! You must be logged in before you can leave a group.' => 'Error! You must be logged in before you can leave a group.',
    'Error! You must register for a user account on this site before you can apply for membership of a group.' => 'Error! You must register for a user account on this site before you can apply for membership of a group.',
    'Error! You must register for a user account on this site before you can join a group.' => 'Error! You must register for a user account on this site before you can join a group.',
    'Error! Your e-mail has not been found. After your request you have %days% days to confirm the new e-mail address.' => 'Error! Your e-mail has not been found. After your request you have %days% days to confirm the new e-mail address.',
    'Error: Could not delete "%path%" because %message%.' => 'Error: Could not delete "%path%" because %message%.',
    'Error: Could not uninstall dependent extensions.' => 'Error: Could not uninstall dependent extensions.',
    'Error: invalid input.' => 'Error: invalid input.',
    'Errors creating user!' => 'Errors creating user!',
    'Even if you choose to not send the user\'s password via e-mail, other email messages may be sent to the user as part of the registration process.' => 'Even if you choose to not send the user\'s password via e-mail, other email messages may be sent to the user as part of the registration process.',
    'Exact phrase' => 'Exact phrase',
    'Expand' => 'Expand',
    'Expanded' => 'Expanded',
    'Export IDS log' => 'Export IDS log',
    'Export email address' => 'Export email address',
    'Export group memberships' => 'Export group memberships',
    'Export last login date' => 'Export last login date',
    'Export options' => 'Export options',
    'Export registration date' => 'Export registration date',
    'Export title row' => 'Export title row',
    'Export users' => 'Export users',
    'Extension' => 'Extension',
    'Extension List' => 'Extension List',
    'Extension categorization' => 'Extension categorization',
    'Extension name' => 'Extension name',
    'Extension removal failed! (note: blocks and dependents may have been removed)' => 'Extension removal failed! (note: blocks and dependents may have been removed)',
    'Extension settings' => 'Extension settings',
    'Extension upgrade failed!' => 'Extension upgrade failed!',
    'Extensions' => 'Extensions',
    'Extensions list' => 'Extensions list',
    'Extensions moved to their default categories' => 'Extensions moved to their default categories',
    'Extensions upgraded' => 'Extensions upgraded',
    'Failed login displays approval status' => 'Failed login displays approval status',
    'Failed login displays inactive status' => 'Failed login displays inactive status',
    'Failed login displays verification status' => 'Failed login displays verification status',
    'Failed to install assets' => 'Failed to install assets',
    'Failed to install dependency "%name%"!' => 'Failed to install dependency "%name%"!',
    'Fatal error: Two extensions share the same %field%. [%ext1%] and [%ext2%]' => 'Fatal error: Two extensions share the same %field%. [%ext1%] and [%ext2%]',
    'Field options' => 'Field options',
    'Field type' => 'Field type',
    'File Include' => 'File Include',
    'File options' => 'File options',
    'File path' => 'File path',
    'File type' => 'File type',
    'Files missing' => 'Files missing',
    'Filter' => 'Filter',
    'Filter %active%' => 'Filter %active%',
    'Filter colour' => 'Filter colour',
    'Filter component' => 'Filter component',
    'Filter group' => 'Filter group',
    'Filters' => 'Filters',
    'Finalize parameters' => 'Finalize parameters',
    'Finalizing parameters' => 'Finalizing parameters',
    'Find & Mail|Delete users' => 'Find & Mail|Delete users',
    'Find users' => 'Find users',
    'Finish' => 'Finish',
    'Fire install event' => 'Fire install event',
    'Fire upgrade event' => 'Fire upgrade event',
    'Fired install event' => 'Fired install event',
    'Fired upgrade event' => 'Fired upgrade event',
    'Firing install event' => 'Firing install event',
    'Firing upgrade event' => 'Firing upgrade event',
    'First page' => 'First page',
    'First stage of installation complete. Run `php bin/console zikula:install:finish` to complete the installation.' => 'First stage of installation complete. Run `php bin/console zikula:install:finish` to complete the installation.',
    'Footer block' => 'Footer block',
    'For Android Chrome' => 'For Android Chrome',
    'For Html files please select the Html file type.' => 'For Html files please select the Html file type.',
    'For Safari on Mac OS' => 'For Safari on Mac OS',
    'For Windows 8 / IE11' => 'For Windows 8 / IE11',
    'For iOS home screen' => 'For iOS home screen',
    'For more information, please visit %link%.' => 'For more information, please visit %link%.',
    'Force Password change for users' => 'Force Password change for users',
    'Force a change of password for %1s' => 'Force a change of password for %1s',
    'Force password change' => 'Force password change',
    'Form of display for module names' => 'Form of display for module names',
    'Format' => 'Format',
    'Found more than one user by that criteria. Try a different criteria (uid works best).' => 'Found more than one user by that criteria. Try a different criteria (uid works best).',
    'Found zero users by that criteria. Try a different criteria (uid works best).' => 'Found zero users by that criteria. Try a different criteria (uid works best).',
    'Frontend' => 'Frontend',
    'Full delete' => 'Full delete',
    'Fully deleting a user can have unintended side effects and <em>is not recommended</em>.' => 'Fully deleting a user can have unintended side effects and <em>is not recommended</em>.',
    'Function does not exist or is not callable.' => 'Function does not exist or is not callable.',
    'Functions' => 'Functions',
    'Further information can be found in the %doc_url%.' => 'Further information can be found in the %doc_url%.',
    'GET' => 'GET',
    'GET parameters' => 'GET parameters',
    'General' => 'General',
    'General Settings' => 'General Settings',
    'General settings' => 'General settings',
    'Generate a password for me' => 'Generate a password for me',
    'Generate another' => 'Generate another',
    'Generate password' => 'Generate password',
    'Ghost (soft delete, recommended)' => 'Ghost (soft delete, recommended)',
    'Global' => 'Global',
    'Google Gmail' => 'Google Gmail',
    'Group' => 'Group',
    'Group data' => 'Group data',
    'Group list' => 'Group list',
    'Group membership' => 'Group membership',
    'Group of administrators of this site.' => 'Group of administrators of this site.',
    'Group settings' => 'Group settings',
    'Group to modify' => 'Group to modify',
    'Groups' => 'Groups',
    'Groups admin' => 'Groups admin',
    'Groups list' => 'Groups list',
    'Groups manager' => 'Groups manager',
    'Guest' => 'Guest',
    'HEAD' => 'HEAD',
    'HTML' => 'HTML',
    'HTML Block content hook' => 'HTML Block content hook',
    'HTML block' => 'HTML block',
    'HTML mail hook' => 'HTML mail hook',
    'HTML-formatted message' => 'HTML-formatted message',
    'HTMLPurifier settings' => 'HTMLPurifier settings',
    'Header block' => 'Header block',
    'Help' => 'Help',
    'Help UI Mode' => 'Help UI Mode',
    'Help text' => 'Help text',
    'Here is your generated password' => 'Here is your generated password',
    'Here you can configure parameters for list views.' => 'Here you can configure parameters for list views.',
    'Here you can define moderation-related settings.' => 'Here you can define moderation-related settings.',
    'Hide closed groups' => 'Hide closed groups',
    'Hide private groups' => 'Hide private groups',
    'Home' => 'Home',
    'Hooks' => 'Hooks',
    'Host' => 'Host',
    'Host:' => 'Host:',
    'How help documents for an extension should be displayed.' => 'How help documents for an extension should be displayed.',
    'How mails are sent and delivered. For example, to use a mail account, choose "SMTP server". Alternatively, instead of using your own SMTP server, you can send emails via a 3rd party provider. For further information about the mailer transport setup please refer to the Symfony docs %link1% and %link2%.' => 'How mails are sent and delivered. For example, to use a mail account, choose "SMTP server". Alternatively, instead of using your own SMTP server, you can send emails via a 3rd party provider. For further information about the mailer transport setup please refer to the Symfony docs %link1% and %link2%.',
    'How to use the editor' => 'How to use the editor',
    'However, your user ID will remain valid and be associated to a \'ghost\' username where required.' => 'However, your user ID will remain valid and be associated to a \'ghost\' username where required.',
    'Html' => 'Html',
    'Html5' => 'Html5',
    'Http' => 'Http',
    'Https' => 'Https',
    'ID' => 'ID',
    'ID of main administration permission rule' => 'ID of main administration permission rule',
    'IP' => 'IP',
    'IP Address' => 'IP Address',
    'IP: %ip%' => 'IP: %ip%',
    'Icon' => 'Icon',
    'If checked, the log-in error message will indicate that the registration is pending approval. If not, a generic error message is displayed.' => 'If checked, the log-in error message will indicate that the registration is pending approval. If not, a generic error message is displayed.',
    'If checked, the log-in error message will indicate that the registration is pending verification. If not, a generic error message is displayed.' => 'If checked, the log-in error message will indicate that the registration is pending verification. If not, a generic error message is displayed.',
    'If checked, the log-in error message will indicate that the user account is inactive. If not, a generic error message is displayed.' => 'If checked, the log-in error message will indicate that the user account is inactive. If not, a generic error message is displayed.',
    'If login method is Email, then this value must be unique for the site.' => 'If login method is Email, then this value must be unique for the site.',
    'If registration is moderated and applications must be approved before verification, then registrations will not expire until the specified number of days after approval.' => 'If registration is moderated and applications must be approved before verification, then registrations will not expire until the specified number of days after approval.',
    'If this is checked, Zikula tries to serve the language requested by browser (if that language available and allowed by the multi-lingual settings). If users set their personal language preference, then this setting will be overriden by their personal preference.' => 'If this is checked, Zikula tries to serve the language requested by browser (if that language available and allowed by the multi-lingual settings). If users set their personal language preference, then this setting will be overriden by their personal preference.',
    'If unchecked, the user\'s e-mail address will be verified. The user will create a password at that time.' => 'If unchecked, the user\'s e-mail address will be verified. The user will create a password at that time.',
    'If you choose to proceed, your personal data will be removed from the site.' => 'If you choose to proceed, your personal data will be removed from the site.',
    'If you leave this page without successfully changing your password, then you will not be logged in.' => 'If you leave this page without successfully changing your password, then you will not be logged in.',
    'If you require more action than this, please contact the site administrator.' => 'If you require more action than this, please contact the site administrator.',
    'Ignore check for installer' => 'Ignore check for installer',
    'Impact' => 'Impact',
    'Import users' => 'Import users',
    'In case one or more installed languages are not listed below, %action%.' => 'In case one or more installed languages are not listed below, %action%.',
    'In either case, the username will then be forbidden from future use and the user <em>cannot be reinstated</em>.' => 'In either case, the username will then be forbidden from future use and the user <em>cannot be reinstated</em>.',
    'Inactive' => 'Inactive',
    'Inbox' => 'Inbox',
    'Incompatible' => 'Incompatible',
    'Incompatible version' => 'Incompatible version',
    'Incompatible version with the core' => 'Incompatible version with the core',
    'Incorrect sender email may cause sending failure.' => 'Incorrect sender email may cause sending failure.',
    'Increase zoom level' => 'Increase zoom level',
    'Info' => 'Info',
    'Initial' => 'Initial',
    'Initial user group' => 'Initial user group',
    'Initialization of "%name%" failed!' => 'Initialization of "%name%" failed!',
    'Initially selected category' => 'Initially selected category',
    'Input' => 'Input',
    'Insert a brief description of the route, to explain why you created it. It is only shown in the admin interface.' => 'Insert a brief description of the route, to explain why you created it. It is only shown in the admin interface.',
    'Insert permission rule before this one' => 'Insert permission rule before this one',
    'Insert the name of the action, which was called "func" in earlier versions of Zikula.' => 'Insert the name of the action, which was called "func" in earlier versions of Zikula.',
    'Insert the name of the controller, which was called "type" in earlier versions of Zikula.' => 'Insert the name of the controller, which was called "type" in earlier versions of Zikula.',
    'Install' => 'Install',
    'Install Successful!' => 'Install Successful!',
    'Install Zikula!' => 'Install Zikula!',
    'Install assets' => 'Install assets',
    'Install extension' => 'Install extension',
    'Installation aborted' => 'Installation aborted',
    'Installation guide' => 'Installation guide',
    'Installed dependency "%name%".' => 'Installed dependency "%name%".',
    'Installer script' => 'Installer script',
    'Installing Extensions and Helpers' => 'Installing Extensions and Helpers',
    'Installing Modules and Helpers' => 'Installing Modules and Helpers',
    'Installing Zikula Administration Module' => 'Installing Zikula Administration Module',
    'Installing Zikula Blocks Module' => 'Installing Zikula Blocks Module',
    'Installing Zikula Categories Module' => 'Installing Zikula Categories Module',
    'Installing Zikula Extensions Module' => 'Installing Zikula Extensions Module',
    'Installing Zikula Groups Module' => 'Installing Zikula Groups Module',
    'Installing Zikula Mailer Module' => 'Installing Zikula Mailer Module',
    'Installing Zikula Menu Module' => 'Installing Zikula Menu Module',
    'Installing Zikula Permissions Module' => 'Installing Zikula Permissions Module',
    'Installing Zikula Routes Module' => 'Installing Zikula Routes Module',
    'Installing Zikula Search Module' => 'Installing Zikula Search Module',
    'Installing Zikula Security Module' => 'Installing Zikula Security Module',
    'Installing Zikula Settings Module' => 'Installing Zikula Settings Module',
    'Installing Zikula Theme Module' => 'Installing Zikula Theme Module',
    'Installing Zikula Users Module' => 'Installing Zikula Users Module',
    'Installing Zikula ZAuth Module' => 'Installing Zikula ZAuth Module',
    'Installing assets to /public' => 'Installing assets to /public',
    'Instance' => 'Instance',
    'Instance template' => 'Instance template',
    'Instance to check' => 'Instance to check',
    'Instead, users can be \'ghosted\'. In this case, the private user data is removed, but the internal user ID remains valid.' => 'Instead, users can be \'ghosted\'. In this case, the private user data is removed, but the internal user ID remains valid.',
    'Integer' => 'Integer',
    'Internal ID' => 'Internal ID',
    'Internal name' => 'Internal name',
    'Intrusion attempt detected by PHPIDS' => 'Intrusion attempt detected by PHPIDS',
    'Invalid' => 'Invalid',
    'Invalid %choice%' => 'Invalid %choice%',
    'Invalid Group ID or User ID.' => 'Invalid Group ID or User ID.',
    'Invalid Group ID.' => 'Invalid Group ID.',
    'Invalid User ID.' => 'Invalid User ID.',
    'Invalid authentication method.' => 'Invalid authentication method.',
    'Invalid structure' => 'Invalid structure',
    'Invalid user identifier received.' => 'Invalid user identifier received.',
    'Invalid username.' => 'Invalid username.',
    'Invalid users cannot be migrated unless their data is manually corrected. The errors are posted to the logfile.' => 'Invalid users cannot be migrated unless their data is manually corrected. The errors are posted to the logfile.',
    'It is recommended to force users to verify their email address.' => 'It is recommended to force users to verify their email address.',
    'It looks like you created or updated a route with a path which already exists. This is an error in most cases.' => 'It looks like you created or updated a route with a path which already exists. This is an error in most cases.',
    'Items per page' => 'Items per page',
    'Join group' => 'Join group',
    'Joined the "%groupName%" group' => 'Joined the "%groupName%" group',
    'Keyword settings' => 'Keyword settings',
    'Language' => 'Language',
    'Language changed to %lang%' => 'Language changed to %lang%',
    'Language switcher' => 'Language switcher',
    'Language system' => 'Language system',
    'Last checked' => 'Last checked',
    'Last login' => 'Last login',
    'Last page' => 'Last page',
    'Last update' => 'Last update',
    'Last update by %user%' => 'Last update by %user%',
    'Last update by %user% on %date%' => 'Last update by %user% on %date%',
    'Last update on %date%' => 'Last update on %date%',
    'Latest stable relese' => 'Latest stable relese',
    'Layout' => 'Layout',
    'Layout modules for controlling the site\'s look and feel.' => 'Layout modules for controlling the site\'s look and feel.',
    'Leaf' => 'Leaf',
    'Leave group' => 'Leave group',
    'Leaving an extension in a \'ready\' state will cause unusual behavior. Complete one of these options.' => 'Leaving an extension in a \'ready\' state will cause unusual behavior. Complete one of these options.',
    'Left blocks' => 'Left blocks',
    'Left the "%groupName%" group' => 'Left the "%groupName%" group',
    'Level' => 'Level',
    'Light' => 'Light',
    'Line endings in the file must NOT be the old Macintosh-type' => 'Line endings in the file must NOT be the old Macintosh-type',
    'Links' => 'Links',
    'List to replace with' => 'List to replace with',
    'List to search for' => 'List to search for',
    'List views' => 'List views',
    'Locale' => 'Locale',
    'Localisation' => 'Localisation',
    'Localisation settings' => 'Localisation settings',
    'Localized output' => 'Localized output',
    'Lock main administration permission rule' => 'Lock main administration permission rule',
    'Lock/Unlock editing' => 'Lock/Unlock editing',
    'Locked' => 'Locked',
    'Log in or register' => 'Log in or register',
    'Log in page' => 'Log in page',
    'Log out' => 'Log out',
    'Log-in information' => 'Log-in information',
    'Logged in as admin' => 'Logged in as admin',
    'Logging in as admin' => 'Logging in as admin',
    'Login' => 'Login',
    'Login block' => 'Login block',
    'Login denied!' => 'Login denied!',
    'Login denied: Your account has been disabled and is scheduled for removal. Please contact a site administrator for more information.' => 'Login denied: Your account has been disabled and is scheduled for removal. Please contact a site administrator for more information.',
    'Login denied: Your account has been disabled. Please contact a site administrator for more information.' => 'Login denied: Your account has been disabled. Please contact a site administrator for more information.',
    'Login failed.' => 'Login failed.',
    'Login form and block hooks' => 'Login form and block hooks',
    'Login method' => 'Login method',
    'Logo' => 'Logo',
    'Logo for mobile view' => 'Logo for mobile view',
    'Mail selected users' => 'Mail selected users',
    'Mailchimp Mandrill' => 'Mailchimp Mandrill',
    'Mailer settings' => 'Mailer settings',
    'Mailer transport' => 'Mailer transport',
    'Mailer transport information' => 'Mailer transport information',
    'Mailgun' => 'Mailgun',
    'Main info' => 'Main info',
    'Main menu' => 'Main menu',
    'Main settings' => 'Main settings',
    'Main site icon' => 'Main site icon',
    'Main site logo' => 'Main site logo',
    'Make default category' => 'Make default category',
    'Malicious request code / a hacking attempt was detected. This request has NOT been blocked!' => 'Malicious request code / a hacking attempt was detected. This request has NOT been blocked!',
    'Malicious request code / a hacking attempt was detected. Thus this request has been blocked.' => 'Malicious request code / a hacking attempt was detected. Thus this request has been blocked.',
    'Manage settings for this application' => 'Manage settings for this application',
    'Manage user' => 'Manage user',
    'Marked for deletion' => 'Marked for deletion',
    'Marked positions are not available in the current default theme.' => 'Marked positions are not available in the current default theme.',
    'Marking store' => 'Marking store',
    'Maximum membership' => 'Maximum membership',
    'Member' => 'Member',
    'Members' => 'Members',
    'Membership application' => 'Membership application',
    'Menu' => 'Menu',
    'Menu list' => 'Menu list',
    'Menu name' => 'Menu name',
    'MenuItemName (menuItemId). The id is needed for permissions.' => 'MenuItemName (menuItemId). The id is needed for permissions.',
    'Menus' => 'Menus',
    'Message' => 'Message',
    'Message type' => 'Message type',
    'Messages inbox' => 'Messages inbox',
    'Meta' => 'Meta',
    'Meta tag settings' => 'Meta tag settings',
    'Method' => 'Method',
    'Methods' => 'Methods',
    'Methods:' => 'Methods:',
    'Migrate Users to ZAuth' => 'Migrate Users to ZAuth',
    'Migrating Users...' => 'Migrating Users...',
    'Minimum length for user passwords' => 'Minimum length for user passwords',
    'Minimum password length: %amount% characters.' => 'Minimum password length: %amount% characters.',
    'Minimum password length: %amount% characters. Longer passwords are more secure.' => 'Minimum password length: %amount% characters. Longer passwords are more secure.',
    'Mobile logo' => 'Mobile logo',
    'Modal window' => 'Modal window',
    'Moderate access' => 'Moderate access',
    'Moderation' => 'Moderation',
    'Modify block' => 'Modify block',
    'Modify block position' => 'Modify block position',
    'Module' => 'Module',
    'Module "%name%" is not a valid provider.' => 'Module "%name%" is not a valid provider.',
    'Module "%name%" is not a valid subscriber.' => 'Module "%name%" is not a valid subscriber.',
    'Module categories list' => 'Module categories list',
    'Module category' => 'Module category',
    'Module used for managing user profiles' => 'Module used for managing user profiles',
    'Module used for private messaging' => 'Module used for private messaging',
    'Modules' => 'Modules',
    'Modules categorisation' => 'Modules categorisation',
    'Modules for controlling user membership, access rights and profiles.' => 'Modules for controlling user membership, access rights and profiles.',
    'Modules for managing the site\'s security.' => 'Modules for managing the site\'s security.',
    'Modules for providing content to your users.' => 'Modules for providing content to your users.',
    'Modules per page in module categories list' => 'Modules per page in module categories list',
    'Modules per row in admin panel' => 'Modules per row in admin panel',
    'Money' => 'Money',
    'Move all children' => 'Move all children',
    'Move all sub-categories' => 'Move all sub-categories',
    'Move and delete' => 'Move and delete',
    'Moving extensions to their default categories' => 'Moving extensions to their default categories',
    'Multi-part message' => 'Multi-part message',
    'Multilingual features are deactivated.' => 'Multilingual features are deactivated.',
    'Multiple' => 'Multiple',
    'Music and audio' => 'Music and audio',
    'My Account' => 'My Account',
    'My account' => 'My account',
    'My custom routes' => 'My custom routes',
    'NOTICE: The old type of "anonymous" user has been removed from the Users group. This may require manual adjustment of your permission schema.' => 'NOTICE: The old type of "anonymous" user has been removed from the Users group. This may require manual adjustment of your permission schema.',
    'Name' => 'Name',
    'Name displayed for anonymous user' => 'Name displayed for anonymous user',
    'Native Email' => 'Native Email',
    'Native Uname' => 'Native Uname',
    'Native Uname or Email' => 'Native Uname or Email',
    'Native authorisation settings' => 'Native authorisation settings',
    'New Category' => 'New Category',
    'New account' => 'New account',
    'New account registration' => 'New account registration',
    'New email address' => 'New email address',
    'New group' => 'New group',
    'New group application' => 'New group application',
    'New menu' => 'New menu',
    'New module category' => 'New module category',
    'New parent' => 'New parent',
    'New password' => 'New password',
    'New registration: %userName%' => 'New registration: %userName%',
    'New search' => 'New search',
    'New users' => 'New users',
    'New users must verify their email address on registration.' => 'New users must verify their email address on registration.',
    'New value for %choice%?' => 'New value for %choice%?',
    'New version' => 'New version',
    'Newest first' => 'Newest first',
    'Newly registered users are logged in automatically' => 'Newly registered users are logged in automatically',
    'Newly-installed or uncategorized modules.' => 'Newly-installed or uncategorized modules.',
    'Next' => 'Next',
    'Next page' => 'Next page',
    'No' => 'No',
    'No access' => 'No access',
    'No block ID passed.' => 'No block ID passed.',
    'No blocks placed in this position yet.' => 'No blocks placed in this position yet.',
    'No category name or id set.' => 'No category name or id set.',
    'No custom routes found.' => 'No custom routes found.',
    'No items found.' => 'No items found.',
    'No message module' => 'No message module',
    'No parent' => 'No parent',
    'No permission for this action' => 'No permission for this action',
    'No permission for this action.' => 'No permission for this action.',
    'No possible subscribers found.' => 'No possible subscribers found.',
    'No profile module' => 'No profile module',
    'No provider area passed.' => 'No provider area passed.',
    'No records found.' => 'No records found.',
    'No search results found.' => 'No search results found.',
    'No subscriber area passed.' => 'No subscriber area passed.',
    'No such item found.' => 'No such item found.',
    'No users found.' => 'No users found.',
    'No users selected.' => 'No users selected.',
    'None' => 'None',
    'Not Available in System' => 'Not Available in System',
    'Not allowed' => 'Not allowed',
    'Not installed' => 'Not installed',
    'Not yet approved' => 'Not yet approved',
    'Note: Upon saving, the cache will be rebuilt and this may take several seconds to reload. Please be patient.' => 'Note: Upon saving, the cache will be rebuilt and this may take several seconds to reload. Please be patient.',
    'Notice: Increase this value if mobile appliances experience problems with using the site.' => 'Notice: Increase this value if mobile appliances experience problems with using the site.',
    'Notice: Please enter your new e-mail address, the same address again for verification, and then click save. The site uses this address to send you mail (when you request a new password, for instance). Your currently-recorded e-mail address is %email%.' => 'Notice: Please enter your new e-mail address, the same address again for verification, and then click save. The site uses this address to send you mail (when you request a new password, for instance). Your currently-recorded e-mail address is %email%.',
    'Notice: The PHP Zlib extension is not enabled on your host. This setting will not do anything in this case.' => 'Notice: The PHP Zlib extension is not enabled on your host. This setting will not do anything in this case.',
    'Notice: The following settings will rewrite your permalinks. Sometimes, international characters like \'ñ\' and \'ß\' may be re-encoded by your browser. Although this is technically the correct action, it may not be aesthetically pleasing.  These settings allow you to replace those characters, using a pair of comma-separated lists. The two fields below should resemble the examples provided: The first element of \'List to search for\' will replace the first element in the \'List to replace with\' and so on. In the example below, \'À\' would be replace with \'A\', and \'Á\' with \'A\'. If you do not want to use this feature, leave both fields blank.' => 'Notice: The following settings will rewrite your permalinks. Sometimes, international characters like \'ñ\' and \'ß\' may be re-encoded by your browser. Although this is technically the correct action, it may not be aesthetically pleasing.  These settings allow you to replace those characters, using a pair of comma-separated lists. The two fields below should resemble the examples provided: The first element of \'List to search for\' will replace the first element in the \'List to replace with\' and so on. In the example below, \'À\' would be replace with \'A\', and \'Á\' with \'A\'. If you do not want to use this feature, leave both fields blank.',
    'Notice: This overrides the \'Verify e-mail address during registration\' setting in \'Settings\'.' => 'Notice: This overrides the \'Verify e-mail address during registration\' setting in \'Settings\'.',
    'Notice: Use drag and drop to arrange the blocks in this position into your desired order. The new block order will be saved automatically.' => 'Notice: Use drag and drop to arrange the blocks in this position into your desired order. The new block order will be saved automatically.',
    'Notice: You cannot delete the main administration permission rule.' => 'Notice: You cannot delete the main administration permission rule.',
    'Notification type' => 'Notification type',
    'Notify administrators' => 'Notify administrators',
    'Number' => 'Number',
    'Number of characters to display in item summaries' => 'Number of characters to display in item summaries',
    'Number of hits: %s' => 'Number of hits: %s',
    'Number of searches' => 'Number of searches',
    'Number of users displayed per page' => 'Number of users displayed per page',
    'OK' => 'OK',
    'OPTIONS' => 'OPTIONS',
    'OR' => 'OR',
    'Offline' => 'Offline',
    'Ok' => 'Ok',
    'Old password' => 'Old password',
    'Old passwords are pre-Core3 passwords which are less secure. <strong>The current user will not be affected</strong>.' => 'Old passwords are pre-Core3 passwords which are less secure. <strong>The current user will not be affected</strong>.',
    'Oldest first' => 'Oldest first',
    'On-line' => 'On-line',
    'Once you have successfully changed your password, the log-in process will complete.' => 'Once you have successfully changed your password, the log-in process will complete.',
    'Online' => 'Online',
    'Only ajax access is allowed!' => 'Only ajax access is allowed!',
    'Only core extensions' => 'Only core extensions',
    'Only for non-default languages' => 'Only for non-default languages',
    'Only modules' => 'Only modules',
    'Only non-core extensions' => 'Only non-core extensions',
    'Only themes' => 'Only themes',
    'Open' => 'Open',
    'Open preview' => 'Open preview',
    'Open preview page' => 'Open preview page',
    'Open: Users may apply/add themselves' => 'Open: Users may apply/add themselves',
    'OpenSearch' => 'OpenSearch',
    'Operation cancelled.' => 'Operation cancelled.',
    'Operation complete. %count% user(s) changed.' => 'Operation complete. %count% user(s) changed.',
    'Options' => 'Options',
    'Options with an asterisk (*) must have a value of a json_encoded string of option key-value pairs. Options with a plus (+) must have a boolean value.' => 'Options with an asterisk (*) must have a value of a json_encoded string of option key-value pairs. Options with a plus (+) must have a boolean value.',
    'Options:' => 'Options:',
    'Order of results' => 'Order of results',
    'Other actions for %s' => 'Other actions for %s',
    'Other fields' => 'Other fields',
    'Overview' => 'Overview',
    'Overview access' => 'Overview access',
    'PHP' => 'PHP',
    'PHP configuration' => 'PHP configuration',
    'PHPIDS filters used' => 'PHPIDS filters used',
    'POST' => 'POST',
    'POST parameters' => 'POST parameters',
    'PUT' => 'PUT',
    'Page' => 'Page',
    'Page navigation' => 'Page navigation',
    'Page not found' => 'Page not found',
    'Page size' => 'Page size',
    'Page title structure' => 'Page title structure',
    'Parameter' => 'Parameter',
    'Parameter settings' => 'Parameter settings',
    'Parameters finalized' => 'Parameters finalized',
    'Parent' => 'Parent',
    'Password' => 'Password',
    'Password reset requests expire in' => 'Password reset requests expire in',
    'Password successfully changed.' => 'Password successfully changed.',
    'Path' => 'Path',
    'Path:' => 'Path:',
    'Pending' => 'Pending',
    'Pending Content' => 'Pending Content',
    'Pending applications' => 'Pending applications',
    'Percent' => 'Percent',
    'Permalinks settings' => 'Permalinks settings',
    'Permission' => 'Permission',
    'Permission check result:' => 'Permission check result:',
    'Permission level' => 'Permission level',
    'Permission rule information' => 'Permission rule information',
    'Permission rules information' => 'Permission rules information',
    'Permission rules list' => 'Permission rules list',
    'Permission settings' => 'Permission settings',
    'Permissions' => 'Permissions',
    'Persisting Symfony Bundles' => 'Persisting Symfony Bundles',
    'Phone number' => 'Phone number',
    'Pinned Tab' => 'Pinned Tab',
    'Plain-text message' => 'Plain-text message',
    'Please complete the form below to reset your password.' => 'Please complete the form below to reset your password.',
    'Please enter at least 3 characters' => 'Please enter at least 3 characters',
    'Please enter the scheme of where you install Zikula, can be either "http" or "https"' => 'Please enter the scheme of where you install Zikula, can be either "http" or "https"',
    'Please enter the url path of the directory where you install Zikula, leave empty if you install it at the top level. Example: /my/sub-dir' => 'Please enter the url path of the directory where you install Zikula, leave empty if you install it at the top level. Example: /my/sub-dir',
    'Please enter your e-mail address below and click the submit button. You will be sent an e-mail with your account information.' => 'Please enter your e-mail address below and click the submit button. You will be sent an e-mail with your account information.',
    'Please enter your user name or e-mail address below and click the submit button. You will be sent an e-mail with further instructions.' => 'Please enter your user name or e-mail address below and click the submit button. You will be sent an e-mail with further instructions.',
    'Please follow the instructions to install Zikula %version%.' => 'Please follow the instructions to install Zikula %version%.',
    'Please note that blocks may appear out of place or even missing in a theme preview because position names are not consistent from theme to theme.' => 'Please note that blocks may appear out of place or even missing in a theme preview because position names are not consistent from theme to theme.',
    'Please refer to the %doc_link% during the process.' => 'Please refer to the %doc_link% during the process.',
    'Position' => 'Position',
    'Position not available in current default theme.' => 'Position not available in current default theme.',
    'Positions' => 'Positions',
    'Possible tags: %pagetitle%, %sitename%, %modulename%' => 'Possible tags: %pagetitle%, %sitename%, %modulename%',
    'Postmark' => 'Postmark',
    'Powered by' => 'Powered by',
    'Prepend bundle prefix' => 'Prepend bundle prefix',
    'Prepend bundle prefix:' => 'Prepend bundle prefix:',
    'Prepend language to URL' => 'Prepend language to URL',
    'Preview' => 'Preview',
    'Preview block' => 'Preview block',
    'Preview theme' => 'Preview theme',
    'Previous page' => 'Previous page',
    'Primary' => 'Primary',
    'Primary administrators group. Cannot be deleted.' => 'Primary administrators group. Cannot be deleted.',
    'Private' => 'Private',
    'Private: Users must apply for membership - groups are not visible to users in public list' => 'Private: Users must apply for membership - groups are not visible to users in public list',
    'Profile' => 'Profile',
    'Progress bar' => 'Progress bar',
    'Properties' => 'Properties',
    'Property name' => 'Property name',
    'Proudly powered by Zikula' => 'Proudly powered by Zikula',
    'Provider module "%name%" is not available.' => 'Provider module "%name%" is not available.',
    'Providers\' areas order is not an array.' => 'Providers\' areas order is not an array.',
    'Provision' => 'Provision',
    'Public' => 'Public',
    'Public: Users can add themselves with no moderation - groups are visible in public list' => 'Public: Users can add themselves with no moderation - groups are visible in public list',
    'Publication status (basic)' => 'Publication status (basic)',
    'Publication status (extended)' => 'Publication status (extended)',
    'Purge IDS log' => 'Purge IDS log',
    'Query parameter' => 'Query parameter',
    'Quick navigation' => 'Quick navigation',
    'Quick search' => 'Quick search',
    'Radio' => 'Radio',
    'Range' => 'Range',
    'Read access' => 'Read access',
    'Ready for installation' => 'Ready for installation',
    'Reason' => 'Reason',
    'Reason for disabling site' => 'Reason for disabling site',
    'Receive e-mail alert when there are new applicants' => 'Receive e-mail alert when there are new applicants',
    'Recent searches' => 'Recent searches',
    'Recent searches list' => 'Recent searches list',
    'Recipient\'s e-mail address' => 'Recipient\'s e-mail address',
    'Recipient\'s name' => 'Recipient\'s name',
    'Recommended' => 'Recommended',
    'Recover' => 'Recover',
    'Recover lost password' => 'Recover lost password',
    'Recover lost username' => 'Recover lost username',
    'Regarding your %groupName% group membership application' => 'Regarding your %groupName% group membership application',
    'Regex validation string constraint' => 'Regex validation string constraint',
    'Registered component' => 'Registered component',
    'Registering for a user account is easy. Registration can give you access to content and to features of this site that are not available to unregistered guests.' => 'Registering for a user account is easy. Registration can give you access to content and to features of this site that are not available to unregistered guests.',
    'Registering users will have to provide this response when answering the spam protection question. It is required if a spam protection question is provided.' => 'Registering users will have to provide this response when answering the spam protection question. It is required if a spam protection question is provided.',
    'Registration Settings' => 'Registration Settings',
    'Registration Status' => 'Registration Status',
    'Registration date' => 'Registration date',
    'Registration date before' => 'Registration date before',
    'Registration deleted at %site%' => 'Registration deleted at %site%',
    'Registration management hooks' => 'Registration management hooks',
    'Registrations pending verification expire in' => 'Registrations pending verification expire in',
    'Reinitialize parameters' => 'Reinitialize parameters',
    'Reinitialized parameters' => 'Reinitialized parameters',
    'Reinitializing parameters' => 'Reinitializing parameters',
    'Rejected' => 'Rejected',
    'Releases' => 'Releases',
    'Reload defaults' => 'Reload defaults',
    'Reload multilingual routing settings' => 'Reload multilingual routing settings',
    'Reload routes' => 'Reload routes',
    'Remember me' => 'Remember me',
    'Remove' => 'Remove',
    'Remove extension' => 'Remove extension',
    'Remove user from group' => 'Remove user from group',
    'Rename category' => 'Rename category',
    'Repeat Email' => 'Repeat Email',
    'Repeat email' => 'Repeat email',
    'Repeat new email address' => 'Repeat new email address',
    'Repeat new password' => 'Repeat new password',
    'Repeat password' => 'Repeat password',
    'Replyto email address' => 'Replyto email address',
    'Request URI: %uri%' => 'Request URI: %uri%',
    'Request attributes' => 'Request attributes',
    'Request context' => 'Request context',
    'Request impact: %impact%' => 'Request impact: %impact%',
    'Require %sub% to change password at next login' => 'Require %sub% to change password at next login',
    'Require non compromised passwords' => 'Require non compromised passwords',
    'Required' => 'Required',
    'Requirement: %value%' => 'Requirement: %value%',
    'Requirements' => 'Requirements',
    'Requirements:' => 'Requirements:',
    'Reserved user names' => 'Reserved user names',
    'Reset' => 'Reset',
    'Reset all extensions to default values' => 'Reset all extensions to default values',
    'Reset to empty value' => 'Reset to empty value',
    'Reset zoom level' => 'Reset zoom level',
    'Return to User Administration' => 'Return to User Administration',
    'Reuse' => 'Reuse',
    'Reuse for new route' => 'Reuse for new route',
    'Right blocks' => 'Right blocks',
    'Right click on selected category to open context menu.' => 'Right click on selected category to open context menu.',
    'Right-click on the menu-item for a context menu of actions.' => 'Right-click on the menu-item for a context menu of actions.',
    'Root' => 'Root',
    'Route' => 'Route',
    'Route entries per page:' => 'Route entries per page:',
    'Route list' => 'Route list',
    'Route scope' => 'Route scope',
    'Routes' => 'Routes',
    'Routes list' => 'Routes list',
    'SMTP host server' => 'SMTP host server',
    'SMTP port' => 'SMTP port',
    'SMTP server' => 'SMTP server',
    'SMTP settings' => 'SMTP settings',
    'Save' => 'Save',
    'Save changes' => 'Save changes',
    'Schemes' => 'Schemes',
    'Schemes:' => 'Schemes:',
    'Science and technology' => 'Science and technology',
    'Seach by username' => 'Seach by username',
    'Search' => 'Search',
    'Search Config' => 'Search Config',
    'Search block' => 'Search block',
    'Search box' => 'Search box',
    'Search data copyright %s, all rights reserved.' => 'Search data copyright %s, all rights reserved.',
    'Search keywords' => 'Search keywords',
    'Search now' => 'Search now',
    'Search results' => 'Search results',
    'Search settings' => 'Search settings',
    'Search the site' => 'Search the site',
    'Search user' => 'Search user',
    'Secondary' => 'Secondary',
    'Security' => 'Security',
    'Security Center' => 'Security Center',
    'Select' => 'Select',
    'Select a block type.' => 'Select a block type.',
    'Select a locale:' => 'Select a locale:',
    'Select all' => 'Select all',
    'Select module' => 'Select module',
    'Select the CSV file' => 'Select the CSV file',
    'Select your default language' => 'Select your default language',
    'Self deletion is disabled by the site administrator.' => 'Self deletion is disabled by the site administrator.',
    'Self deletion is not possible for main administrator.' => 'Self deletion is not possible for main administrator.',
    'Send a message to this user' => 'Send a message to this user',
    'Send a new e-mail verification code for %sub%' => 'Send a new e-mail verification code for %sub%',
    'Send an e-mail verification code for %sub%' => 'Send an e-mail verification code for %sub%',
    'Send mail' => 'Send mail',
    'Send mail in batches of' => 'Send mail in batches of',
    'Send password recovery e-mail to %sub%' => 'Send password recovery e-mail to %sub%',
    'Send password via email' => 'Send password via email',
    'Send private message to %userName%' => 'Send private message to %userName%',
    'Send test email' => 'Send test email',
    'Send user name to %sub%' => 'Send user name to %sub%',
    'Send welcome message to user' => 'Send welcome message to user',
    'Sender name' => 'Sender name',
    'Sender\'s email address' => 'Sender\'s email address',
    'Sender\'s name' => 'Sender\'s name',
    'Sendgrid' => 'Sendgrid',
    'Sending a password via email is considered unsafe. It is recommended that you provide the password to the user using a secure method of communication.' => 'Sending a password via email is considered unsafe. It is recommended that you provide the password to the user using a secure method of communication.',
    'Sendmail binary' => 'Sendmail binary',
    'Separate each user agent string with a comma. Each item on this list is a browser user agent identification string. If a user attempts to register a new account using a browser whose user agent string begins with one on this list, then the user is not allowed to begin the registration process.' => 'Separate each user agent string with a comma. Each item on this list is a browser user agent identification string. If a user attempts to register a new account using a browser whose user agent string begins with one on this list, then the user is not allowed to begin the registration process.',
    'Separate with &, for example: <code>foo=2&bar=5</code>' => 'Separate with &, for example: <code>foo=2&bar=5</code>',
    'Server time zone is %tz%' => 'Server time zone is %tz%',
    'Session are currently configured to use the filesystem. It is recommended that you change this to use the database. Click %here% to configure.' => 'Session are currently configured to use the filesystem. It is recommended that you change this to use the database. Click %here% to configure.',
    'Session handling variables have changed. You must log in again.' => 'Session handling variables have changed. You must log in again.',
    'Session impact: %impact%' => 'Session impact: %impact%',
    'Set a password' => 'Set a password',
    'Set as 0 for unlimited.' => 'Set as 0 for unlimited.',
    'Set password now' => 'Set password now',
    'Set to defaults' => 'Set to defaults',
    'Setting a user theme is no longer available.' => 'Setting a user theme is no longer available.',
    'Settings' => 'Settings',
    'Settings test' => 'Settings test',
    'Show \'Search now\' button' => 'Show \'Search now\' button',
    'Show administration panel' => 'Show administration panel',
    'Show all entries' => 'Show all entries',
    'Show also entries from other users' => 'Show also entries from other users',
    'Show both internal name and display name' => 'Show both internal name and display name',
    'Show only own entries' => 'Show only own entries',
    'Show only own entries:' => 'Show only own entries:',
    'Show password strength meter' => 'Show password strength meter',
    'Shows all items except these which are approved' => 'Shows all items except these which are approved',
    'Shows all items except these which are trashed' => 'Shows all items except these which are trashed',
    'Sidebar on left side' => 'Sidebar on left side',
    'Sidebar on right side' => 'Sidebar on right side',
    'Signed in as %username%' => 'Signed in as %username%',
    'Single Text' => 'Single Text',
    'Site Administrator' => 'Site Administrator',
    'Site default' => 'Site default',
    'Site description' => 'Site description',
    'Site name' => 'Site name',
    'Site search' => 'Site search',
    'Site unsearchable' => 'Site unsearchable',
    'Sorry! An active account could not be located with that information. Correct your entry and try again. If you have recently registered a new account with this site, we may be waiting for you to verify your e-mail address, or we might not have approved your registration request yet.' => 'Sorry! An active account could not be located with that information. Correct your entry and try again. If you have recently registered a new account with this site, we may be waiting for you to verify your e-mail address, or we might not have approved your registration request yet.',
    'Sorry! New user registration is currently disabled.' => 'Sorry! New user registration is currently disabled.',
    'Sorry! The user agent you are using (the browser or other software you are using to access this site) is banned from the registration process.' => 'Sorry! The user agent you are using (the browser or other software you are using to access this site) is banned from the registration process.',
    'Sorry! There was a problem sending a verification code to %sub%.' => 'Sorry! There was a problem sending a verification code to %sub%.',
    'Sorry! Your account has not completed the registration process. Please contact a site administrator for more information.' => 'Sorry! Your account has not completed the registration process. Please contact a site administrator for more information.',
    'Sorry! Your account is marked as inactive. Please contact a site administrator for more information.' => 'Sorry! Your account is marked as inactive. Please contact a site administrator for more information.',
    'Sorry, but an error occured during the %action% action.' => 'Sorry, but an error occured during the %action% action.',
    'Sorry, but an error occured during the %action% action. Please apply the changes again!' => 'Sorry, but an error occured during the %action% action. Please apply the changes again!',
    'Sorry, but you can not create the route yet as other items are required which must be created before!' => 'Sorry, but you can not create the route yet as other items are required which must be created before!',
    'Sort' => 'Sort',
    'Sort by' => 'Sort by',
    'Sort by %fieldName%' => 'Sort by %fieldName%',
    'Sort by ID' => 'Sort by ID',
    'Sort by language' => 'Sort by language',
    'Sort by state' => 'Sort by state',
    'Sort by title' => 'Sort by title',
    'Sort by type' => 'Sort by type',
    'Sort direction' => 'Sort direction',
    'Sort:' => 'Sort:',
    'Sorting' => 'Sorting',
    'Spam protection answer' => 'Spam protection answer',
    'Spam protection question' => 'Spam protection question',
    'Sport and activities' => 'Sport and activities',
    'Stable Zikula Core available' => 'Stable Zikula Core available',
    'Start installation?' => 'Start installation?',
    'Start page settings' => 'Start page settings',
    'State' => 'State',
    'State Machine' => 'State Machine',
    'State field' => 'State field',
    'Statement displayed if registration disabled' => 'Statement displayed if registration disabled',
    'States' => 'States',
    'Status' => 'Status',
    'Status unknown' => 'Status unknown',
    'String' => 'String',
    'Style sheet URL' => 'Style sheet URL',
    'Style sheet contents' => 'Style sheet contents',
    'Subject' => 'Subject',
    'Submit' => 'Submit',
    'Submit and repeat' => 'Submit and repeat',
    'Subscriber module "%name%" is not available.' => 'Subscriber module "%name%" is not available.',
    'Subscription' => 'Subscription',
    'Success' => 'Success',
    'Success. Account deleted!' => 'Success. Account deleted!',
    'Support @ Slack' => 'Support @ Slack',
    'Supported entities (one per line)' => 'Supported entities (one per line)',
    'Switch to administration area.' => 'Switch to administration area.',
    'Switch to user area.' => 'Switch to user area.',
    'Switch to users administration' => 'Switch to users administration',
    'Symfony Bundles' => 'Symfony Bundles',
    'Symfony Bundles persisted' => 'Symfony Bundles persisted',
    'System' => 'System',
    'System extensions activated' => 'System extensions activated',
    'System module' => 'System module',
    'System theme' => 'System theme',
    'Tag' => 'Tag',
    'Test current settings' => 'Test current settings',
    'Test mailer settings' => 'Test mailer settings',
    'Testing permission...' => 'Testing permission...',
    'Text' => 'Text',
    'Text fields' => 'Text fields',
    'Textarea' => 'Textarea',
    'That entity does not exist!' => 'That entity does not exist!',
    'The %choice% has been changed.' => 'The %choice% has been changed.',
    'The allow moderation specific creation date for route option' => 'The allow moderation specific creation date for route option',
    'The allow moderation specific creator for route option' => 'The allow moderation specific creator for route option',
    'The amount of routes shown per page' => 'The amount of routes shown per page',
    'The code provided is invalid or this user has never registered or has fully completed registration.' => 'The code provided is invalid or this user has never registered or has fully completed registration.',
    'The create process failed for an unknown reason.' => 'The create process failed for an unknown reason.',
    'The currently installed version of Zikula (%currentVersion%) is too old. You must upgrade to version %minimumVersion% before you can use this upgrade.' => 'The currently installed version of Zikula (%currentVersion%) is too old. You must upgrade to version %minimumVersion% before you can use this upgrade.',
    'The database port can be left empty.' => 'The database port can be left empty.',
    'The directory %directory% could not be removed. Please remove it manually. Error message: %message%' => 'The directory %directory% could not be removed. Please remove it manually. Error message: %message%',
    'The email you are trying to authenticate with is in use by another user. You can only login by username.' => 'The email you are trying to authenticate with is in use by another user. You can only login by username.',
    'The file must be utf8 encoded' => 'The file must be utf8 encoded',
    'The first row of the CSV file must contain the field names. It must be like this:' => 'The first row of the CSV file must contain the field names. It must be like this:',
    'The following attack has been detected by PHPIDS' => 'The following attack has been detected by PHPIDS',
    'The following pathes are used for branding. To customise this please read <a href="https://docs.ziku.la/LayoutDesign/Themes/branding.html" title="Branding docs" target="_blank">the docs</a>.' => 'The following pathes are used for branding. To customise this please read <a href="https://docs.ziku.la/LayoutDesign/Themes/branding.html" title="Branding docs" target="_blank">the docs</a>.',
    'The following paths are used for branding. To customise this please read <a href="https://docs.ziku.la/LayoutDesign/Themes/branding.html" title="Branding docs" target="_blank">the docs</a>.' => 'The following paths are used for branding. To customise this please read <a href="https://docs.ziku.la/LayoutDesign/Themes/branding.html" title="Branding docs" target="_blank">the docs</a>.',
    'The items that are marked with an asterisk (\'*\') are required entries.' => 'The items that are marked with an asterisk (\'*\') are required entries.',
    'The items that are marked with an asterisk (*) are required entries.' => 'The items that are marked with an asterisk (*) are required entries.',
    'The minimum version of the core that this extension supports is %s' => 'The minimum version of the core that this extension supports is %s',
    'The password or secret key for the selected transport. Used for verifying authentication. Not saved to the database, only written to the <code>.env.local</code> file.' => 'The password or secret key for the selected transport. Used for verifying authentication. Not saved to the database, only written to the <code>.env.local</code> file.',
    'The path must start with a "/" and can be a regular expression. Example: "/login"' => 'The path must start with a "/" and can be a regular expression. Example: "/login"',
    'The path of the route you created or updated looks similar to the following already existing path: %errorPath% Are you sure you haven\'t just introduced a conflict?' => 'The path of the route you created or updated looks similar to the following already existing path: %errorPath% Are you sure you haven\'t just introduced a conflict?',
    'The registration process failed.' => 'The registration process failed.',
    'The root domain where you install Zikula, e.g. "example.com". Do not include subdirectories.' => 'The root domain where you install Zikula, e.g. "example.com". Do not include subdirectories.',
    'The selected user is already a member of this group.' => 'The selected user is already a member of this group.',
    'The setting has been successfully changed.' => 'The setting has been successfully changed.',
    'The show only own entries option' => 'The show only own entries option',
    'The site administrator has not configured any data as searchable.' => 'The site administrator has not configured any data as searchable.',
    'The site is currently off-line.' => 'The site is currently off-line.',
    'The start controller for language "%language%" was reset to a static frontpage.' => 'The start controller for language "%language%" was reset to a static frontpage.',
    'The theme in use must implement the block position or the assigned blocks will never be displayed.' => 'The theme in use must implement the block position or the assigned blocks will never be displayed.',
    'The user name, access key or API key for the selected transport. Defines which account should be used for sending.' => 'The user name, access key or API key for the selected transport. Defines which account should be used for sending.',
    'The users will not be emailed.' => 'The users will not be emailed.',
    'The version of this extension is incompatible with the version of the core.' => 'The version of this extension is incompatible with the version of the core.',
    'Theme config' => 'Theme config',
    'Theme configuration' => 'Theme configuration',
    'Theme settings' => 'Theme settings',
    'Theme to use for admin controllers' => 'Theme to use for admin controllers',
    'Theme to use for main site' => 'Theme to use for main site',
    'Themes' => 'Themes',
    'There are %amount% users to try to migrate.' => 'There are %amount% users to try to migrate.',
    'There are %f% users to try to migrate.' => 'There are %f% users to try to migrate.',
    'There are currently no groups that can be joined.' => 'There are currently no groups that can be joined.',
    'There are currently no modules in this category.' => 'There are currently no modules in this category.',
    'There are no active modules to search. Please activate at %link' => 'There are no active modules to search. Please activate at %link',
    'There are no providers available for %sub%.' => 'There are no providers available for %sub%.',
    'There are no subscribers available for %sub%.' => 'There are no subscribers available for %sub%.',
    'There are too many users registered with that address. Please contact a site administrator for assistance.' => 'There are too many users registered with that address. Please contact a site administrator for assistance.',
    'There aren\'t any areas attached here.' => 'There aren\'t any areas attached here.',
    'There is currently no pending content.' => 'There is currently no pending content.',
    'There is no authentication method activated.' => 'There is no authentication method activated.',
    'There was an error activating system extensions' => 'There was an error activating system extensions',
    'There was an error clearing caches' => 'There was an error clearing caches',
    'There was an error creating admin account' => 'There was an error creating admin account',
    'There was an error creating default blocks' => 'There was an error creating default blocks',
    'There was an error finalizing the parameters' => 'There was an error finalizing the parameters',
    'There was an error firing the install event' => 'There was an error firing the install event',
    'There was an error firing the upgrade event' => 'There was an error firing the upgrade event',
    'There was an error installing Zikula Administration Module' => 'There was an error installing Zikula Administration Module',
    'There was an error installing Zikula Blocks Module' => 'There was an error installing Zikula Blocks Module',
    'There was an error installing Zikula Categories Module' => 'There was an error installing Zikula Categories Module',
    'There was an error installing Zikula Extensions Module' => 'There was an error installing Zikula Extensions Module',
    'There was an error installing Zikula Groups Module' => 'There was an error installing Zikula Groups Module',
    'There was an error installing Zikula Mailer Module' => 'There was an error installing Zikula Mailer Module',
    'There was an error installing Zikula Menu Module' => 'There was an error installing Zikula Menu Module',
    'There was an error installing Zikula Permissions Module' => 'There was an error installing Zikula Permissions Module',
    'There was an error installing Zikula Routes Module' => 'There was an error installing Zikula Routes Module',
    'There was an error installing Zikula Search Module' => 'There was an error installing Zikula Search Module',
    'There was an error installing Zikula Security Module' => 'There was an error installing Zikula Security Module',
    'There was an error installing Zikula Settings Module' => 'There was an error installing Zikula Settings Module',
    'There was an error installing Zikula Theme Module' => 'There was an error installing Zikula Theme Module',
    'There was an error installing Zikula Users Module' => 'There was an error installing Zikula Users Module',
    'There was an error installing Zikula ZAuth Module' => 'There was an error installing Zikula ZAuth Module',
    'There was an error logging in as admin' => 'There was an error logging in as admin',
    'There was an error moving extensions to their default categories' => 'There was an error moving extensions to their default categories',
    'There was an error persisting the Symfony Bundles' => 'There was an error persisting the Symfony Bundles',
    'There was an error reinitialize parameters' => 'There was an error reinitialize parameters',
    'There was an error upgrading the extensions' => 'There was an error upgrading the extensions',
    'There was an error upgrading to Core %version%' => 'There was an error upgrading to Core %version%',
    'There was no need to migrate any users.' => 'There was no need to migrate any users.',
    'Third party module' => 'Third party module',
    'Third party modules are responsible to remove their own data tied to your account.' => 'Third party modules are responsible to remove their own data tied to your account.',
    'Third party theme' => 'Third party theme',
    'This action MUST be complete before upgrading to Core-2.0.' => 'This action MUST be complete before upgrading to Core-2.0.',
    'This action cannot be undone.' => 'This action cannot be undone.',
    'This action will force the selected group to change their password on next login.' => 'This action will force the selected group to change their password on next login.',
    'This affects both passwords created during registration, as well as passwords modified by users or administrators. Enter an integer greater than %number%.' => 'This affects both passwords created during registration, as well as passwords modified by users or administrators. Enter an integer greater than %number%.',
    'This block has filters' => 'This block has filters',
    'This could potentially take a long time if there are many users that must be migrated. They will be migrated in batches of 25 to reduce the risk of timeouts.' => 'This could potentially take a long time if there are many users that must be migrated. They will be migrated in batches of 25 to reduce the risk of timeouts.',
    'This function requires JavaScript activated!' => 'This function requires JavaScript activated!',
    'This group is a core-only group' => 'This group is a core-only group',
    'This group is a private group' => 'This group is a private group',
    'This group is closed.' => 'This group is closed.',
    'This group is has reached its membership limit.' => 'This group is has reached its membership limit.',
    'This includes your username, email, profile data and so forth.' => 'This includes your username, email, profile data and so forth.',
    'This is needed to maintain data-integrity on the site.' => 'This is needed to maintain data-integrity on the site.',
    'This is the list of block positions currently existing for your site\'s pages.
You can create a new block position by clicking \'Create block position\' in the menu. To edit the settings for a block position,
click on the \'Edit\' icon beside that particular position. To reorder the blocks within a block position, click on the
\'Edit placements\' (blocks) icon for that position or on the position name in the block list above.
To delete a block position, click on the \'Delete\' icon and confirm the action in the confirmation prompt that will display.' => 'This is the list of block positions currently existing for your site\'s pages.
You can create a new block position by clicking \'Create block position\' in the menu. To edit the settings for a block position,
click on the \'Edit\' icon beside that particular position. To reorder the blocks within a block position, click on the
\'Edit placements\' (blocks) icon for that position or on the position name in the block list above.
To delete a block position, click on the \'Delete\' icon and confirm the action in the confirmation prompt that will display.',
    'This is the list of blocks present in your system, you can use the filter to display only certain blocks.
    The order in which blocks are listed here is not necessarily the order in which they are displayed in site pages.
    To manage the display order of the blocks click the position name in this table or on the \'edit block placements\'
    in the position list table below.' => 'This is the list of blocks present in your system, you can use the filter to display only certain blocks.
    The order in which blocks are listed here is not necessarily the order in which they are displayed in site pages.
    To manage the display order of the blocks click the position name in this table or on the \'edit block placements\'
    in the position list table below.',
    'This makes the possibility of orphaned data much less likely and is therefore the recommended option.' => 'This makes the possibility of orphaned data much less likely and is therefore the recommended option.',
    'This must be a json_encoded string of option key-value pairs.' => 'This must be a json_encoded string of option key-value pairs.',
    'This page contains adult content' => 'This page contains adult content',
    'This permission rule has been locked. If you need to unlock it, go to the Permission rules manager Settings page.' => 'This permission rule has been locked. If you need to unlock it, go to the Permission rules manager Settings page.',
    'This search does not include <em>pending</em> users.' => 'This search does not include <em>pending</em> users.',
    'This setting only affects users who have not established security question responses. Enter the number of days a user\'s request to reset a password should be kept while waiting for verification. Enter zero (0) for no expiration.' => 'This setting only affects users who have not established security question responses. Enter the number of days a user\'s request to reset a password should be kept while waiting for verification. Enter zero (0) for no expiration.',
    'This site is powered by Zikula!' => 'This site is powered by Zikula!',
    'This user cannot be edited. Group memberships can be edited in the groups module. Click here.' => 'This user cannot be edited. Group memberships can be edited in the groups module. Click here.',
    'This will migrate all VALID users from the old Users table to the new ZAuth table.' => 'This will migrate all VALID users from the old Users table to the new ZAuth table.',
    'This will migrate all VALID users from the old Users table to the new ZAuth table. Users are automatically migrated when they login, but this will migrate all users at one time.' => 'This will migrate all VALID users from the old Users table to the new ZAuth table. Users are automatically migrated when they login, but this will migrate all users at one time.',
    'Time' => 'Time',
    'Time zone for anonymous guests' => 'Time zone for anonymous guests',
    'Time-out for ajax connections' => 'Time-out for ajax connections',
    'Timestamp' => 'Timestamp',
    'Timezone' => 'Timezone',
    'Title' => 'Title',
    'Title, Description' => 'Title, Description',
    'To change your password, please enter your current password, and then enter a new password (you must enter the new password twice to ensure that you have typed it correctly).' => 'To change your password, please enter your current password, and then enter a new password (you must enter the new password twice to ensure that you have typed it correctly).',
    'To connect %sub% to one of the modules from the list below, click on the checkbox(es) next to the corresponding area.' => 'To connect %sub% to one of the modules from the list below, click on the checkbox(es) next to the corresponding area.',
    'To version' => 'To version',
    'Toggle dropdown' => 'Toggle dropdown',
    'Toggle navigation' => 'Toggle navigation',
    'Top navigation block' => 'Top navigation block',
    'Transition' => 'Transition',
    'Translatable' => 'Translatable',
    'Translatable:' => 'Translatable:',
    'Translation UI' => 'Translation UI',
    'Translation prefix' => 'Translation prefix',
    'Translation prefix:' => 'Translation prefix:',
    'Trash' => 'Trash',
    'Trashed' => 'Trashed',
    'Travel and culture' => 'Travel and culture',
    'Twig tag' => 'Twig tag',
    'Type' => 'Type',
    'Types' => 'Types',
    'URL' => 'URL',
    'Unable to decode composer file of %component% (%filePath%): %error%. Ensure the composer.json file has a valid syntax.' => 'Unable to decode composer file of %component% (%filePath%): %error%. Ensure the composer.json file has a valid syntax.',
    'Unable to send email to the requested %identifier%. Please try your %otherIdentifier% or contact a site administrator for assistance.' => 'Unable to send email to the requested %identifier%. Please try your %otherIdentifier% or contact a site administrator for assistance.',
    'Unable to send email to the requested address. Please contact a site administrator for assistance.' => 'Unable to send email to the requested address. Please contact a site administrator for assistance.',
    'Uncategorised' => 'Uncategorised',
    'Uninstall extension' => 'Uninstall extension',
    'Unknown' => 'Unknown',
    'Unlimited' => 'Unlimited',
    'Unregistered' => 'Unregistered',
    'Update' => 'Update',
    'Update checker' => 'Update checker',
    'Update checker is enabled' => 'Update checker is enabled',
    'Update configuration' => 'Update configuration',
    'Update date' => 'Update date',
    'Updater' => 'Updater',
    'Upgrade Zikula!' => 'Upgrade Zikula!',
    'Upgrade extension' => 'Upgrade extension',
    'Upgrade extensions' => 'Upgrade extensions',
    'Upgrade from Core %oldVersion% to Core %newVersion%' => 'Upgrade from Core %oldVersion% to Core %newVersion%',
    'Upgrade successful!' => 'Upgrade successful!',
    'Upgraded to Core %version%' => 'Upgraded to Core %version%',
    'Upgrader script' => 'Upgrader script',
    'Upgrading Modules and Helpers' => 'Upgrading Modules and Helpers',
    'Upgrading Zikula in %env% environment.' => 'Upgrading Zikula in %env% environment.',
    'Upgrading extensions' => 'Upgrading extensions',
    'Upgrading to Core %version%' => 'Upgrading to Core %version%',
    'Upload' => 'Upload',
    'Url' => 'Url',
    'Url root' => 'Url root',
    'Usage' => 'Usage',
    'Use different keywords.' => 'Use different keywords.',
    'Use fewer words.' => 'Use fewer words.',
    'Use keywords that are more general.' => 'Use keywords that are more general.',
    'Use query parameters syntax, for example: <code>?param1=value1&amp;param2=value2</code>.' => 'Use query parameters syntax, for example: <code>?param1=value1&amp;param2=value2</code>.',
    'Use site\'s theme' => 'Use site\'s theme',
    'Used by IE' => 'Used by IE',
    'Useful resources' => 'Useful resources',
    'User Credential Settings' => 'User Credential Settings',
    'User ID' => 'User ID',
    'User Login Settings' => 'User Login Settings',
    'User Name' => 'User Name',
    'User log-in' => 'User log-in',
    'User login' => 'User login',
    'User management hooks' => 'User management hooks',
    'User migration complete!' => 'User migration complete!',
    'User must verify email address' => 'User must verify email address',
    'User name' => 'User name',
    'User name or email' => 'User name or email',
    'User name:' => 'User name:',
    'User names can contain letters, numbers, underscores, periods, spaces and/or dashes.' => 'User names can contain letters, numbers, underscores, periods, spaces and/or dashes.',
    'User not found. Please contact a site administrator for assistance.' => 'User not found. Please contact a site administrator for assistance.',
    'User page' => 'User page',
    'User permission check' => 'User permission check',
    'User registration is moderated' => 'User registration is moderated',
    'User settings' => 'User settings',
    'User status' => 'User status',
    'UserID: %userId%' => 'UserID: %userId%',
    'UserName' => 'UserName',
    'Users' => 'Users',
    'Users authenticating off site (re-entrant) are logged in automatically regardless of this setting.' => 'Users authenticating off site (re-entrant) are logged in automatically regardless of this setting.',
    'Users groups' => 'Users groups',
    'Users list' => 'Users list',
    'Users pending approval' => 'Users pending approval',
    'Value' => 'Value',
    'Value to change?' => 'Value to change?',
    'Vector icon for Safari' => 'Vector icon for Safari',
    'Verification code' => 'Verification code',
    'Version' => 'Version',
    'View IDS log' => 'View IDS log',
    'View membership of group' => 'View membership of group',
    'WARNING: %extension% has an invalid composer.json file which could not be decoded.' => 'WARNING: %extension% has an invalid composer.json file which could not be decoded.',
    'WARNING: The "%name%" block position is not available in the current default theme.' => 'WARNING: The "%name%" block position is not available in the current default theme.',
    'WARNING: The PHP Extension %ext% is not loaded. All functions using this will default to %locale%. Seek assistance from your provider to install.' => 'WARNING: The PHP Extension %ext% is not loaded. All functions using this will default to %locale%. Seek assistance from your provider to install.',
    'WARNING: You appear to be editing your OWN account.' => 'WARNING: You appear to be editing your OWN account.',
    'WARNING: You appear to be editing your OWN account. You will not be able to modify active status, some group memberships or delete yourself.' => 'WARNING: You appear to be editing your OWN account. You will not be able to modify active status, some group memberships or delete yourself.',
    'WARNING: changing the url affects SEO by breaking existing indexed search results.' => 'WARNING: changing the url affects SEO by breaking existing indexed search results.',
    'Warning' => 'Warning',
    'Warning! New user information has been saved, however there may have been an issue saving it properly.' => 'Warning! New user information has been saved, however there may have been an issue saving it properly.',
    'Warning! Nothing to do! %sub% is already approved.' => 'Warning! Nothing to do! %sub% is already approved.',
    'Warning! Only enable the above option if this site is isolated from the Internet, otherwise security could be endangered if you omit to remove the Installer script from the site root and are not prompted to do so.' => 'Warning! Only enable the above option if this site is isolated from the Internet, otherwise security could be endangered if you omit to remove the Installer script from the site root and are not prompted to do so.',
    'Warning! Other extensions present in the system require this extension. If you uninstall this extension then these extensions that require it will also be uninstalled.' => 'Warning! Other extensions present in the system require this extension. If you uninstall this extension then these extensions that require it will also be uninstalled.',
    'Warning! Removing this extension will also remove the following blocks' => 'Warning! Removing this extension will also remove the following blocks',
    'Warning! Uninstalling this extension will also permanently remove all data associated with it, including all data held by other extensions that are hooked to this extension.' => 'Warning! Uninstalling this extension will also permanently remove all data associated with it, including all data held by other extensions that are hooked to this extension.',
    'Warning: could not install selected dependency "%name%".' => 'Warning: could not install selected dependency "%name%".',
    'Web application manifest' => 'Web application manifest',
    'Web interface to add, edit and remove translations' => 'Web interface to add, edit and remove translations',
    'Week number' => 'Week number',
    'Welcome to the route section of the Routes application.' => 'Welcome to the route section of the Routes application.',
    'When lists are displayed (for example, lists of users, lists of registrations) this option controls how many items are displayed at one time.' => 'When lists are displayed (for example, lists of users, lists of registrations) this option controls how many items are displayed at one time.',
    'Whether only own entries should be shown on view pages by default or not' => 'Whether only own entries should be shown on view pages by default or not',
    'Whether to allow moderators choosing a custom creation date.' => 'Whether to allow moderators choosing a custom creation date.',
    'Whether to allow moderators choosing a user which will be set as creator.' => 'Whether to allow moderators choosing a user which will be set as creator.',
    'Widget' => 'Widget',
    'With selected routes' => 'With selected routes',
    'Workflow' => 'Workflow',
    'Workflow "%workflow%" not found.' => 'Workflow "%workflow%" not found.',
    'Workflow editor' => 'Workflow editor',
    'Workflow settings' => 'Workflow settings',
    'Writing and thinking' => 'Writing and thinking',
    'XML' => 'XML',
    'YAML' => 'YAML',
    'Yes' => 'Yes',
    'You already have a pending application. Please wait until the administrator notifies you.' => 'You already have a pending application. Please wait until the administrator notifies you.',
    'You are already a member of this group.' => 'You are already a member of this group.',
    'You are an anonymous guest.\', \'zikula' => 'You are an anonymous guest.\', \'zikula',
    'You are currently using an unreleased version of the Zikula Core.' => 'You are currently using an unreleased version of the Zikula Core.',
    'You are in:' => 'You are in:',
    'You are logged-in as %sub%.' => 'You are logged-in as %sub%.',
    'You are not allowed to alter your own active state.' => 'You are not allowed to alter your own active state.',
    'You are not allowed to delete user id %uid%' => 'You are not allowed to delete user id %uid%',
    'You are not allowed to remove yourself from the default group.' => 'You are not allowed to remove yourself from the default group.',
    'You are not allowed to remove yourself from the primary administrator group.' => 'You are not allowed to remove yourself from the primary administrator group.',
    'You are seeing this message because Zikula is not yet installed. You can install Zikula by clicking on the install button, but before doing so please read the %inst%. Further information can be found in the %docs%.' => 'You are seeing this message because Zikula is not yet installed. You can install Zikula by clicking on the install button, but before doing so please read the %inst%. Further information can be found in the %docs%.',
    'You are seeing this message because Zikula requires upgrade. You can upgrade Zikula by clicking
                        on the upgrade button, but before doing so please read the %inst%. Further information can be found in the %docs%.' => 'You are seeing this message because Zikula requires upgrade. You can upgrade Zikula by clicking
                        on the upgrade button, but before doing so please read the %inst%. Further information can be found in the %docs%.',
    'You are seeing this message because Zikula requires upgrade. You can upgrade Zikula by clicking on the upgrade button, but before doing so please read the %inst%. Further information can be found in the %docs%.' => 'You are seeing this message because Zikula requires upgrade. You can upgrade Zikula by clicking on the upgrade button, but before doing so please read the %inst%. Further information can be found in the %docs%.',
    'You are using the latest stable version of the Zikula core.' => 'You are using the latest stable version of the Zikula core.',
    'You can %registerLink%' => 'You can %registerLink%',
    'You can arrange categories list using drag and drop. New order will be saved automatically.' => 'You can arrange categories list using drag and drop. New order will be saved automatically.',
    'You can change your routing configuration in the general settings: %link%.' => 'You can change your routing configuration in the general settings: %link%.',
    'You can set a question to be answered at registration time, to protect the site against spam automated registrations by bots and scripts.' => 'You can set a question to be answered at registration time, to protect the site against spam automated registrations by bots and scripts.',
    'You can try the following:' => 'You can try the following:',
    'You do not have permission for that action.' => 'You do not have permission for that action.',
    'You do not have permission. You must login first.' => 'You do not have permission. You must login first.',
    'You have JavaScript disabled. Please activate it to proceed or use the CLI script instead.' => 'You have JavaScript disabled. Please activate it to proceed or use the CLI script instead.',
    'You will receive an e-mail to your new e-mail address to confirm the change.' => 'You will receive an e-mail to your new e-mail address to confirm the change.',
    'You will use your e-mail address to identify yourself when you log in.' => 'You will use your e-mail address to identify yourself when you log in.',
    'Your change has been successfully saved. You are now logged in with your new password.' => 'Your change has been successfully saved. You are now logged in with your new password.',
    'Your new account is not active yet. Please contact the site administrator for more information.' => 'Your new account is not active yet. Please contact the site administrator for more information.',
    'Your registration at %site% associated with this email (%email%) has been deleted from the site.
This could have happened because you have delayed too long in confirming your email address, or because the administrator manually deleted your registration.
If you have any questions, please contact the site administrator or re-register.' => 'Your registration at %site% associated with this email (%email%) has been deleted from the site.
This could have happened because you have delayed too long in confirming your email address, or because the administrator manually deleted your registration.
If you have any questions, please contact the site administrator or re-register.',
    'Your request could not be processed due to invalid arguments.' => 'Your request could not be processed due to invalid arguments.',
    'Your request could not be processed due to invalid arguments. Maybe your link is expired?' => 'Your request could not be processed due to invalid arguments. Maybe your link is expired?',
    'Your request could not be processed due to missing arguments.' => 'Your request could not be processed due to missing arguments.',
    'Your request could not be processed.' => 'Your request could not be processed.',
    'Your user name is used to identify you to other users on the site. You still need to set one up, even though you will not be using it to log in.' => 'Your user name is used to identify you to other users on the site. You still need to set one up, even though you will not be using it to log in.',
    'Zikula Administration Module' => 'Zikula Administration Module',
    'Zikula Administration Module installed' => 'Zikula Administration Module installed',
    'Zikula Application Framework' => 'Zikula Application Framework',
    'Zikula Blocks Module' => 'Zikula Blocks Module',
    'Zikula Blocks Module installed' => 'Zikula Blocks Module installed',
    'Zikula Categories Module' => 'Zikula Categories Module',
    'Zikula Categories Module installed' => 'Zikula Categories Module installed',
    'Zikula Core' => 'Zikula Core',
    'Zikula Core Installer' => 'Zikula Core Installer',
    'Zikula Core is already installed so the installer has been disabled. If you need to run the installer
                    a second time, you must reset config.php to its original state and clear the database tables before
                    running the installer again.' => 'Zikula Core is already installed so the installer has been disabled. If you need to run the installer
                    a second time, you must reset config.php to its original state and clear the database tables before
                    running the installer again.',
    'Zikula Core is already installed!' => 'Zikula Core is already installed!',
    'Zikula Core is not installed!' => 'Zikula Core is not installed!',
    'Zikula Core requires upgrade!' => 'Zikula Core requires upgrade!',
    'Zikula Extension Module' => 'Zikula Extension Module',
    'Zikula Extensions Module installed' => 'Zikula Extensions Module installed',
    'Zikula Groups Module' => 'Zikula Groups Module',
    'Zikula Groups Module installed' => 'Zikula Groups Module installed',
    'Zikula Installer Script' => 'Zikula Installer Script',
    'Zikula Mailer Module' => 'Zikula Mailer Module',
    'Zikula Mailer Module installed' => 'Zikula Mailer Module installed',
    'Zikula Menu Module' => 'Zikula Menu Module',
    'Zikula Menu Module installed' => 'Zikula Menu Module installed',
    'Zikula Permissions Module' => 'Zikula Permissions Module',
    'Zikula Permissions Module installed' => 'Zikula Permissions Module installed',
    'Zikula Routes Module' => 'Zikula Routes Module',
    'Zikula Routes Module installed' => 'Zikula Routes Module installed',
    'Zikula Search Module' => 'Zikula Search Module',
    'Zikula Search Module installed' => 'Zikula Search Module installed',
    'Zikula Security Module' => 'Zikula Security Module',
    'Zikula Security Module installed' => 'Zikula Security Module installed',
    'Zikula Settings Module' => 'Zikula Settings Module',
    'Zikula Settings Module installed' => 'Zikula Settings Module installed',
    'Zikula Theme Module' => 'Zikula Theme Module',
    'Zikula Theme Module installed' => 'Zikula Theme Module installed',
    'Zikula Upgrader Script' => 'Zikula Upgrader Script',
    'Zikula Users Module' => 'Zikula Users Module',
    'Zikula Users Module installed' => 'Zikula Users Module installed',
    'Zikula ZAuth Module' => 'Zikula ZAuth Module',
    'Zikula ZAuth Module installed' => 'Zikula ZAuth Module installed',
    'Zikula already appears to be installed.' => 'Zikula already appears to be installed.',
    'Zikula documentation' => 'Zikula documentation',
    'Zikula installation completed!' => 'Zikula installation completed!',
    'Zikula is already installed!' => 'Zikula is already installed!',
    'Zikula is free software released under the LGPL license!' => 'Zikula is free software released under the LGPL license!',
    'Zikula is installing!' => 'Zikula is installing!',
    'Zikula is not installed!' => 'Zikula is not installed!',
    'Zikula is not upgraded!' => 'Zikula is not upgraded!',
    'Zikula is upgrading!' => 'Zikula is upgrading!',
    'active' => 'active',
    'albert,12secure09,albert@example.org' => 'albert,12secure09,albert@example.org',
    'albert,12secure09,albert@example.org,1,1,2' => 'albert,12secure09,albert@example.org,1,1,2',
    'alpha.current' => 'alpha.current',
    'authenticationMethodsStatus' => 'authenticationMethodsStatus',
    'bar' => 'bar',
    'bar acct' => 'bar acct',
    'bar admin' => 'bar admin',
    'be patient!' => 'be patient!',
    'categoryAssignments' => 'categoryAssignments',
    'content' => 'content',
    'copy' => 'copy',
    'copy & close' => 'copy & close',
    'days' => 'days',
    'default 5000 = 5 seconds' => 'default 5000 = 5 seconds',
    'dependencies' => 'dependencies',
    'e.g. yyyy-MM-dd' => 'e.g. yyyy-MM-dd',
    'email' => 'email',
    'email address' => 'email address',
    'entity' => 'entity',
    'favicon' => 'favicon',
    'filtered' => 'filtered',
    'foo' => 'foo',
    'george,lesssecure,george@example.org' => 'george,lesssecure,george@example.org',
    'george,lesssecure,george@example.org,1,0,1|5' => 'george,lesssecure,george@example.org,1,0,1|5',
    'group' => 'group',
    'groups' => 'groups',
    'http' => 'http',
    'https' => 'https',
    'in_array' => 'in_array',
    'inactive' => 'inactive',
    'installation guide' => 'installation guide',
    'installation instructions' => 'installation instructions',
    'invalid route' => 'invalid route',
    'items' => 'items',
    'javascript' => 'javascript',
    'key' => 'key',
    'label' => 'label',
    'list' => 'list',
    'marked for deletion' => 'marked for deletion',
    'milliseconds' => 'milliseconds',
    'model_timezone' => 'model_timezone',
    'new' => 'new',
    'no title defined' => 'no title defined',
    'online documentation' => 'online documentation',
    'options' => 'options',
    'paginator.current' => 'paginator.current',
    'parent' => 'parent',
    'pass' => 'pass',
    'password' => 'password',
    'pending' => 'pending',
    'permission granted.' => 'permission granted.',
    'permission not granted.' => 'permission not granted.',
    'plural_n.anonymous.guest' => '{count, plural,
  one   {one anonymous guest}
  other {# anonymous guests}
}',
    'plural_n.direct.child' => '{count, plural,
  one   {one direct child}
  other {# direct children}
}',
    'plural_n.registered.user' => '{count, plural,
  one   {one registered user}
  other {# registered users}
}',
    'plural_n.users.deleted' => '{count, plural,\\n  one   {User deleted!}\\n  other {# users deleted!}\\n}',
    'plural_n.users.processed.' => 'plural_n.users.processed.',
    'prepend bundle prefix ?' => 'prepend bundle prefix ?',
    'register here' => 'register here',
    'registered_after' => 'registered_after',
    'reload installed languages' => 'reload installed languages',
    'robert,hispassword,robert@example.org' => 'robert,hispassword,robert@example.org',
    'robert,hispassword,robert@example.org,,,' => 'robert,hispassword,robert@example.org,,,',
    'root' => 'root',
    'root, webmaster, admin, administrator, nobody, anonymous, username' => 'root, webmaster, admin, administrator, nobody, anonymous, username',
    'tab' => 'tab',
    'translatable ?' => 'translatable ?',
    'unknown user.' => 'unknown user.',
    'unregistered user' => 'unregistered user',
    'upgrade guide' => 'upgrade guide',
    'upgrade instructions' => 'upgrade instructions',
    'user list' => 'user list',
    'username' => 'username',
    'users' => 'users',
    'value' => 'value',
    'when upgrading an existing workflow consider that objects could be in a state which does not exist anymore. You need to update your database to update these objects in order to avoid problems.' => 'when upgrading an existing workflow consider that objects could be in a state which does not exist anymore. You need to update your database to update these objects in order to avoid problems.',
    'where:' => 'where:',
    'À,Á,Â,Ã,Å,à,á,â,ã,å,Ò,Ó,Ô,Õ,Ø,ò,ó,ô,õ,ø,È,É,Ê,Ë,è,é,ê,ë,Ç,ç,Ì,Í,Î,Ï,ì,í,î,ï,Ù,Ú,Û,ù,ú,û,ÿ,Ñ,ñ,ß,ä,Ä,ö,Ö,ü,Ü' => 'À,Á,Â,Ã,Å,à,á,â,ã,å,Ò,Ó,Ô,Õ,Ø,ò,ó,ô,õ,ø,È,É,Ê,Ë,è,é,ê,ë,Ç,ç,Ì,Í,Î,Ï,ì,í,î,ï,Ù,Ú,Û,ù,ú,û,ÿ,Ñ,ñ,ß,ä,Ä,ö,Ö,ü,Ü',
  ),
  'routes' => 
  array (
    'doc' => '/installdoc/{name}',
    'fos_js_routing_js' => '/js/routing.{_format}',
    'home' => '/',
    'install' => '/install/{stage}',
    'liip_imagine_filter' => '/media/cache/resolve/{filter}/{path}',
    'liip_imagine_filter_runtime' => '/media/cache/resolve/{filter}/rc/{hash}/{path}',
    'oro_twig_inspector_template_link' => '/_template/{template}',
    'php_translation_profiler_translation_create_assets' => '/{token}/translation/create_assets',
    'php_translation_profiler_translation_edit' => '/{token}/translation/edit',
    'php_translation_profiler_translation_sync' => '/{token}/translation/sync',
    'php_translation_profiler_translation_sync_all' => '/{token}/translation/sync_all',
    'translation_create' => '/admin/_trans/{configName}/{locale}/{domain}/new',
    'translation_delete' => '/admin/_trans/{configName}/{locale}/{domain}',
    'translation_edit' => '/admin/_trans/{configName}/{locale}/{domain}',
    'translation_edit_in_place_update' => '/admin/_trans_edit_in_place/{configName}/{locale}',
    'translation_index' => '/admin/_trans/{configName}',
    'translation_show' => '/admin/_trans/{configName}/{locale}/{domain}',
    'upgrade' => '/upgrade/{stage}',
    'zikula_hook_hook_changeproviderareaorder' => '/hooks/changeorder',
    'zikula_hook_hook_edit' => '/hooks/{moduleName}',
    'zikula_hook_hook_togglesubscribeareastatus' => '/hooks/togglestatus',
    'zikula_workflow_editor_index' => '/editor/index',
    'zikulaadminmodule_admin_adminpanel' => '/panel/{acid}',
    'zikulaadminmodule_admin_categorymenu' => '/categorymenu/{acid}',
    'zikulaadminmodule_admin_delete' => '/deletecategory/{cid}',
    'zikulaadminmodule_admin_index' => '/',
    'zikulaadminmodule_admin_modify' => '/modifycategory/{cid}',
    'zikulaadminmodule_admin_newcat' => '/newcategory',
    'zikulaadminmodule_admin_view' => '/categories/{page}',
    'zikulaadminmodule_admininterface_breadcrumbs' => '/admininterface/breadcrumbs',
    'zikulaadminmodule_admininterface_footer' => '/admininterface/footer',
    'zikulaadminmodule_admininterface_header' => '/admininterface/header',
    'zikulaadminmodule_admininterface_menu' => '/admininterface/menu',
    'zikulaadminmodule_admininterface_securityanalyzer' => '/admininterface/securityanalyzer',
    'zikulaadminmodule_admininterface_updatecheck' => '/admininterface/updatecheck',
    'zikulaadminmodule_ajax_addcategory' => '/ajax/newcategory',
    'zikulaadminmodule_ajax_changemodulecategory' => '/ajax/assigncategory',
    'zikulaadminmodule_ajax_defaultcategory' => '/ajax/makedefault',
    'zikulaadminmodule_ajax_deletecategory' => '/ajax/deletecategory',
    'zikulaadminmodule_ajax_editcategory' => '/ajax/editcategory',
    'zikulaadminmodule_ajax_sortcategories' => '/ajax/sortcategories',
    'zikulaadminmodule_ajax_sortmodules' => '/ajax/sortmodules',
    'zikulaadminmodule_config_config' => '/config/config',
    'zikulablocksmodule_admin_view' => '/admin/view',
    'zikulablocksmodule_block_delete' => '/admin/block/delete/{bid}',
    'zikulablocksmodule_block_edit' => '/admin/block/edit/{blockEntity}',
    'zikulablocksmodule_block_new' => '/admin/block/new',
    'zikulablocksmodule_block_toggleblock' => '/admin/block/toggle-active',
    'zikulablocksmodule_block_view' => '/admin/block/view/{bid}',
    'zikulablocksmodule_config_config' => '/config/config',
    'zikulablocksmodule_placement_edit' => '/admin/placement/edit/{pid}',
    'zikulablocksmodule_position_delete' => '/admin/position/delete/{pid}',
    'zikulablocksmodule_position_edit' => '/admin/position/edit/{positionEntity}',
    'zikulabootstraptheme_ajax_changeuserstyle' => '/ajax/changeUserStyle',
    'zikulacategoriesmodule_category_list' => '/admin/category/list/{id}',
    'zikulacategoriesmodule_node_contextmenu' => '/admin/category/contextMenu/{action}/{id}',
    'zikulacategoriesmodule_node_move' => '/admin/category/move',
    'zikulacategoriesmodule_registry_delete' => '/registry/delete/{id}',
    'zikulacategoriesmodule_registry_edit' => '/registry/edit/{id}',
    'zikulaextensionsmodule_config_config' => '/config',
    'zikulaextensionsmodule_extension_activate' => '/activate/{id}/{token}',
    'zikulaextensionsmodule_extension_compatibility' => '/compatibility/{id}',
    'zikulaextensionsmodule_extension_deactivate' => '/deactivate/{id}/{token}',
    'zikulaextensionsmodule_extension_install' => '/install/{id}/{token}',
    'zikulaextensionsmodule_extension_list' => '/list/{page}',
    'zikulaextensionsmodule_extension_modify' => '/modify/{id}/{forceDefaults}',
    'zikulaextensionsmodule_extension_postinstall' => '/postinstall/{extensions}',
    'zikulaextensionsmodule_extension_postuninstall' => '/post-uninstall',
    'zikulaextensionsmodule_extension_preview' => '/theme-preview/{themeName}',
    'zikulaextensionsmodule_extension_uninstall' => '/uninstall/{id}/{token}',
    'zikulaextensionsmodule_extension_upgrade' => '/upgrade/{id}/{token}',
    'zikulaextensionsmodule_extensioninstaller_cancelinstall' => '/cancel-install/{id}',
    'zikulaextensionsmodule_extensioninstaller_install' => '/install/{id}',
    'zikulaextensionsmodule_extensioninstaller_postinstall' => '/postinstall/{extensions}',
    'zikulaextensionsmodule_extensioninstaller_preinstall' => '/preinstall/{id}',
    'zikulaextensionsmodule_extensionsinterface_breadcrumbs' => '/extensionsinterface/breadcrumbs',
    'zikulaextensionsmodule_extensionsinterface_footer' => '/extensionsinterface/footer',
    'zikulaextensionsmodule_extensionsinterface_header' => '/extensionsinterface/header',
    'zikulaextensionsmodule_extensionsinterface_links' => '/extensionsinterface/links',
    'zikulaextensionsmodule_help_index' => '/help/{moduleName}',
    'zikulagroupsmodule_application_admin' => '/application/admin/{action}/{app_id}',
    'zikulagroupsmodule_application_create' => '/application/create/{gid}',
    'zikulagroupsmodule_config_config' => '/config/config',
    'zikulagroupsmodule_group_adminlist' => '/admin/list/{page}',
    'zikulagroupsmodule_group_create' => '/admin/create',
    'zikulagroupsmodule_group_edit' => '/admin/edit/{gid}',
    'zikulagroupsmodule_group_list' => '/list/{page}',
    'zikulagroupsmodule_group_remove' => '/admin/remove/{gid}',
    'zikulagroupsmodule_membership_add' => '/membership/admin/add/{uid}/{gid}/{token}',
    'zikulagroupsmodule_membership_adminlist' => '/membership/admin/list/{gid}/{letter}/{page}',
    'zikulagroupsmodule_membership_getusersbyfragmentastable' => '/membership/admin/getusersbyfragmentastable',
    'zikulagroupsmodule_membership_join' => '/membership/join/{gid}',
    'zikulagroupsmodule_membership_leave' => '/membership/leave/{gid}',
    'zikulagroupsmodule_membership_list' => '/membership/list/{gid}/{letter}/{page}',
    'zikulagroupsmodule_membership_remove' => '/membership/admin/remove/{gid}/{uid}',
    'zikulamailermodule_config_config' => '/config/config',
    'zikulamailermodule_config_test' => '/config/test',
    'zikulamenumodule_menu_delete' => '/admin/delete/{id}',
    'zikulamenumodule_menu_edit' => '/admin/edit/{id}',
    'zikulamenumodule_menu_list' => '/admin/list',
    'zikulamenumodule_menu_view' => '/admin/view/{id}',
    'zikulamenumodule_node_move' => '/node/move',
    'zikulapermissionsmodule_config_config' => '/config/config',
    'zikulapermissionsmodule_permission_changeorder' => '/change-order',
    'zikulapermissionsmodule_permission_delete' => '/delete/{pid}',
    'zikulapermissionsmodule_permission_edit' => '/edit/{pid}',
    'zikulapermissionsmodule_permission_list' => '/list',
    'zikulapermissionsmodule_permission_test' => '/test',
    'zikularoutesmodule_ajax_updatesortpositions' => '/ajax/updateSortPositions',
    'zikularoutesmodule_config_config' => '/config/config',
    'zikularoutesmodule_route_admindisplay' => '/admin/route/{id}.{_format}',
    'zikularoutesmodule_route_adminedit' => '/admin/route/edit/{id}.{_format}',
    'zikularoutesmodule_route_adminhandleselectedentries' => '/admin/routes/handleSelectedEntries',
    'zikularoutesmodule_route_adminindex' => '/admin/routes',
    'zikularoutesmodule_route_adminview' => '/admin/routes/view/{sort}/{sortdir}/{page}/{num}.{_format}',
    'zikularoutesmodule_route_display' => '/route/{id}.{_format}',
    'zikularoutesmodule_route_edit' => '/route/edit/{id}.{_format}',
    'zikularoutesmodule_route_handleselectedentries' => '/routes/handleSelectedEntries',
    'zikularoutesmodule_route_index' => '/routes',
    'zikularoutesmodule_route_view' => '/routes/view/{sort}/{sortdir}/{page}/{num}.{_format}',
    'zikularoutesmodule_update_dumpjsroutes' => '/update/dump/{lang}',
    'zikularoutesmodule_update_reload' => '/update/reload',
    'zikularoutesmodule_update_renew' => '/update/renew',
    'zikulascribitemodule_config_allowembeddedmedia' => '/config/allow-embedded-media',
    'zikulascribitemodule_config_settings' => '/config/settings',
    'zikulascribitemodule_editor_configure' => '/configure/{editorId}',
    'zikulascribitemodule_editor_list' => '/editors',
    'zikulascribitemodule_override_module' => '/override/module',
    'zikulascribitemodule_override_textarea' => '/override/textarea',
    'zikulasearchmodule_config_config' => '/config/config',
    'zikulasearchmodule_search_execute' => '/{page}',
    'zikulasearchmodule_search_recent' => '/recent/{page}',
    'zikulasecuritycentermodule_config_allowedhtml' => '/config/allowedhtml',
    'zikulasecuritycentermodule_config_config' => '/config/config',
    'zikulasecuritycentermodule_config_purifierconfig' => '/config/purifierconfig/{reset}',
    'zikulasecuritycentermodule_idslog_deleteentry' => '/idslog/deleteentry',
    'zikulasecuritycentermodule_idslog_export' => '/idslog/export',
    'zikulasecuritycentermodule_idslog_purge' => '/idslog/purge',
    'zikulasecuritycentermodule_idslog_view' => '/idslog/view/{page}',
    'zikulasettingsmodule_settings_main' => '/',
    'zikulasettingsmodule_settings_phpinfo' => '/phpinfo',
    'zikulasettingsmodule_settings_toggleeditinplace' => '/toggleeditinplace',
    'zikulastaticcontentmodule_static_view' => '/p/{name}',
    'zikulathememodule_config_config' => '/config/config',
    'zikulathememodule_var_var' => '/admin/var/{themeName}',
    'zikulausersmodule_access_login' => '/login',
    'zikulausersmodule_access_logout' => '/logout/{returnUrl}',
    'zikulausersmodule_account_changelanguage' => '/account/change-language',
    'zikulausersmodule_account_deletemyaccount' => '/account/delete',
    'zikulausersmodule_account_menu' => '/account',
    'zikulausersmodule_config_authenticationmethods' => '/admin/config/authentication-methods',
    'zikulausersmodule_config_config' => '/admin/config',
    'zikulausersmodule_fileio_export' => '/fileIO/export',
    'zikulausersmodule_livesearch_getusers' => '/livesearch/getUsers',
    'zikulausersmodule_registration_register' => '/register',
    'zikulausersmodule_useradministration_approve' => '/admin/approve/{user}/{force}',
    'zikulausersmodule_useradministration_delete' => '/admin/delete/{user}',
    'zikulausersmodule_useradministration_list' => '/admin/list/{sort}/{sortdir}/{letter}/{page}',
    'zikulausersmodule_useradministration_mailusers' => '/admin/mail',
    'zikulausersmodule_useradministration_modify' => '/admin/user/modify/{user}',
    'zikulausersmodule_useradministration_search' => '/admin/search',
    'zikulazauthmodule_account_changeemail' => '/account/change-email',
    'zikulazauthmodule_account_changepassword' => '/account/change-password',
    'zikulazauthmodule_account_confirmchangedemail' => '/account/change-email-confirm/{code}',
    'zikulazauthmodule_account_lostpassword' => '/account/lost-password',
    'zikulazauthmodule_account_lostpasswordreset' => '/account/lost-password/reset',
    'zikulazauthmodule_account_lostusername' => '/account/lost-user-name',
    'zikulazauthmodule_config_config' => '/admin/config',
    'zikulazauthmodule_fileio_import' => '/fileIO/import',
    'zikulazauthmodule_registration_verify' => '/verify-registration/{uname}/{verifycode}',
    'zikulazauthmodule_useradministration_batchforcepasswordchange' => '/admin/batch-force-password-change',
    'zikulazauthmodule_useradministration_create' => '/admin/user/create',
    'zikulazauthmodule_useradministration_list' => '/admin/list/{sort}/{sortdir}/{letter}/{page}',
    'zikulazauthmodule_useradministration_modify' => '/admin/user/modify/{mapping}',
    'zikulazauthmodule_useradministration_sendconfirmation' => '/admin/send-confirmation/{mapping}',
    'zikulazauthmodule_useradministration_sendusername' => '/admin/send-username/{mapping}',
    'zikulazauthmodule_useradministration_togglepasswordchange' => '/admin/toggle-password-change/{user}',
    'zikulazauthmodule_useradministration_verify' => '/admin/verify/{mapping}',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
