<?php

/**
 * Installation: MySQL Inserts
 *
 * Zenbership Membership Software
 * Copyright (C) 2013-2016 Castlamp, LLC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author      Castlamp
 * @link        http://www.castlamp.com/
 * @link        http://www.zenbership.com/
 * @copyright   (c) 2013-2016 Castlamp
 * @license     http://www.gnu.org/licenses/gpl-3.0.en.html
 * @project     Zenbership Membership Software
 */

$date = date('Y-m-d H:i:s');

$inserts   = array();
$inserts[] = "
	INSERT INTO `ppSD_accounts` (`id`, `name`, `contact_frequency`, `created`, `default`, `master_user`, `owner`, `public`, `last_updated`, `last_updated_by`, `last_action`, `source`, `status`) VALUES
	('GEN_CONTAC', 'General Contacts', '000014000000', '" . $date . "', 1, '', 1, 0, '1920-01-01 00:01:01', 0, '1920-01-01 00:01:01', 0, 0),
	('CASTLAMP', 'Castlamp', '000300000000', '" . $date . "', 0, '', 1, 0, '1920-01-01 00:01:01', 1, '1920-01-01 00:01:01', 0, 0),
	('GEN_MEMBER', 'General Members', '990000000000', '" . $date . "', 3, '', 1, 0, '1920-01-01 00:01:01', 0, '1920-01-01 00:01:01', 0, 0),
	('GEN_CAMPAI', 'Campaign Sign Ups', '990000000000', '" . $date . "', 4, '', 1, 0, '1920-01-01 00:01:01', 0, '1920-01-01 00:01:01', 0, 0),
	('NON_MEMBER', 'Non-Member Cart Purchases', '990000000000', '" . $date . "', 0, '', 1, 1, '1920-01-01 00:01:01', 0, '1920-01-01 00:01:01', 0, 1);
";
$inserts[] = "
	INSERT INTO `ppSD_account_data` (`account_id`, `address_line_1`, `address_line_2`, `city`, `state`, `zip`, `country`, `phone`, `office_phone`, `alt_phone`, `fax`, `company_name`, `url`, `industry`, `account_type`, `email_optout`, `facebook`, `twitter`, `linkedin`) VALUES
	('GEN_CONTAC', '', '', '', '', '', '', '', '', '', '', 'General Contacts', '', '', '', 0, '', '', ''),
	('GEN_MEMBER', '', '', '', '', '', '', '', '', '', '', 'General Members', '', '', '', 0, '', '', ''),
	('GEN_CAMPAI', '', '', '', '', '', '', '', '', '', '', 'Campaign Sign Ups', '', '', '', 0, '', '', ''),
	('CASTLAMP', '', '', 'New York', 'NY', '', 'United States', '', '', '', '', 'Castlamp', 'http://www.castlamp.com/', 'Technology', 'Other', 0, 'https://www.facebook.com/castlamp', 'http://twitter.com/castlamp', 'https://www.linkedin.com/company/castlamp'),
	('NON_MEMBER', '', '', '', '', '', '', '', '',
	 '', '', '', '', '', '', 0, '', '', '');
";

$inserts[] = "
	INSERT INTO `ppSD_activity_methods` (`id`, `icon`, `link`, `link_type`, `text`, `in_feed`, `custom`) VALUES
	('campaign_subscription', 'icon-campaign_sub.png', 'campaign-view', 'slider', 'Campaign %act% subscription.', 1, 0),
	('login', 'icon-login.png', 'member-view', 'slider', '%act% logged in.', 1, 0),
	('logout', 'icon-logout.png', 'member-view', 'slider', '%act% logged out.', 1, 0),
	('status_changed', 'icon-status.png', 'member-view', 'slider', 'Status changed to %act%.', '1', '0'),
	('concurrent', 'icon-concurrent.png', 'member-view', 'slider', 'Concurrent login detected for %act%.', '1', 0),
	('email', 'icon-email-sent.png', 'email-view', 'popup_large', 'E-Mail sent to %act%.', 0, 0),
	('member_access_lost', 'icon-access_lost.png', 'member-view', 'slider', 'Access to content %act% expired.', 1, 0),
	('sms', 'icon-text.png', 'member-view', 'slider', 'SMS sent to %act%.', 1, 0),
	('dependency_submit', 'icon-dependency.png', 'member-view', 'slider', 'Dependency form submitted by %act%.', '1', 0),
	('member_type', 'icon-member_type.png', 'member-view', 'slider', '', 'Member type changed for %act%.', '1'),
	('update', 'icon-update.png', 'member-view', 'slider', '%act% updated his/her account', 1, 0),
	('member_update', 'icon-edit-on.png', 'member-view', 'slider', '%act% updated his/her account', 1, 0),
	('purchase', 'icon-sales.png', 'transaction-view', 'slider', 'Transaction ID %act%', 1, 0),
	('subscription_created', 'icon-subscriptions.png', 'subscription-view', 'slider', 'Subscription No. %act% created.', 1, 0),
	('subscription_renew', 'icon-saved.png', 'subscription-view', 'slider', 'Subscription No. %act% renewed.', 1, 0),
	('subscription_cancel', 'icon-warning.png', 'subscription-view', 'slider', 'Subscription No. %act% Canceled.', 1, 0),
	('subscription_failed', 'icon-sub-failed.png', 'subscription-view', 'slider', 'Subscription No. %act% failed to renew.', 1, 0),
	('subscription_changed', 'icon-subscriptions.png', 'subscription-view', 'slider', 'Subscription No. %act% plan changed.', '1', ''),
	('subscription_downgrade', 'icon-subscriptions-upgrade.png', 'subscription-view', 'slider', 'Subscription No. %act% downgraded.', '1', ''),
	('subscription_upgrade', 'icon-subscriptions-downgrade.png', 'subscription-view', 'slider', 'Subscription No. %act% upgraded.', '1', ''),
	('read_email', 'icon-email-read.png', 'email-view', 'popup_large', 'E-Mail opened by %act%.', 1, 0),
	('link_clicked', 'icon-click.png', 'email-view', 'popup_large', 'E-Mail link clicked by %act%.', 1, 0),
	('event_rsvp', 'icon-calendar.png', 'rsvp_view', 'popup', 'Registration for %act%', 1, 0),
	('invoice_closed', 'icon-save.png', 'invoice-view', 'slider', 'Invoice No. %act% settled.', 1, 0),
	('invoice_payment', 'icon-sales.png', 'invoice-view', 'slider', 'Payment made on Invoice No. %act%.', 1, 0),
	('invoice_requested', 'icon-invoices.png', 'invoice-view', 'slider', 'Invoice No. %act% created.', 1, 0),
	('invoice_created', 'icon-invoices.png', 'invoice-view', 'slider', 'Invoice No. %act% created.', 1, 0),
	('content_access_lost', 'icon-access_lost.png', 'member-view', 'slider', 'Access to content %act% expired.', '1', ''),
	('note', 'icon-note.png', 'note-add', 'popup_large', 'Note posted for %act%.', 0, 0),
	('extended_next_action', 'icon-delay.png', 'contact-view', 'slider', 'Next required action date extended for %act%.', '1', 0),
	('member_staff_update', 'icon-edit-on.png', 'member-view', 'slider', 'Member %act% updated by staff.', 0, 0),
	('member_created', 'icon-member-add.png', 'member-view', 'slider', 'Member %act% created.', 1, 0),
	('contact_staff_update', 'icon-edit.png', 'contact-view', 'slider', 'Contact %act% updated by staff.', 0, 0),
	('account_created', 'icon-account.png', 'account-view', 'slider', 'Account %act% created.', 1, 0),
	('account_updated', 'icon-account.png', 'account-view', 'slider', 'Account %act% updated.', 0, 0),
	('error', 'icon-system-error.png', 'system_alerts', 'alert', '', 1, 0),
	('contact_created', 'icon-contact-add.png', 'contact-view', 'slider', 'Contact %act% created.', 1, 0),
	('contact_assigned', 'icon-attention-on.png', 'contact-view', 'slider', 'Contact %act% assigned.', 0, 0),
	('contact_converted', 'icon-save.png', 'contact-view', 'slider', 'Contact %act% converted.', 1, 0),
	('contact_dead', 'icon-mark-dead.png', 'contact-view', 'slider', 'Contact %act% marked \"dead\".', 1, 0),
	('bounced', 'icon-mail-bounced.png', 'member-view', 'slider', 'User %act% e-mail bounced.', 1, 0),
	('campaign_unsubscription', 'icon-campaign_unsub.png', 'campaign-view', 'slider', 'Campaign %act% unsubscription.', 1, 0),
    ('form_submit', 'icon-form-submitted.png', 'contact-view', 'slider', 'Form submitted by %act%.', 1, 0),
    ('event_checkin', 'icon-checkin.png', 'rsvp_view', 'popup', '%act% has checked in.', 1, 0),
	('contact_reopen', 'icon-mark-alive.png', 'contact-view', 'slider', 'Contact %act% re-opened.', 1, 0);
";
$inserts[] = "
	INSERT INTO `ppSD_account_types` (`type`) VALUES
	('Analyst'),
	('Competitor'),
	('Customer'),
	('Integrator'),
	('Investor'),
	('Partner'),
	('Press'),
	('Prospect'),
	('Reseller'),
	('Other');
";
$inserts[] = "
	INSERT INTO `ppSD_cart_categories` (`id`, `name`, `description`, `meta_title`, `meta_desc`, `meta_keywords`, `subcategory`, `template_id`, `cols`, `search_index`, `public`, `owner`, `created`) VALUES
	(1, 'Shop', '', '', '', '', 0, '', 0, 0, 0, 0, '" . $date . "')
";
$inserts[] = "
	INSERT INTO `ppSD_calendars` (`name`, `template`, `members_only`, `owner`, `public`, `created`, `style`) VALUES
	('Calendar of Events', 0, 0, 0, 0, '" . $date . "', 1);
";
$inserts[] = "
	INSERT INTO `ppSD_data_eav` (`item_id`, `key`, `value`) VALUES
	('options', 'member_print', 'username,profile_pic,joined,last_action,email,last_login,last_renewal,last_updated,url,source,account,owner,first_name,last_name,address_line_1,address_line_2,city,state,zip,country,phone,fax,dob,industry,cell,alt_phone,office_phone,member_type,status'),
	('options', 'contact_print', 'profile_pic,email,type,last_name,first_name,type,url,address_line_1,address_line_2,city,state,zip,country,phone,cell,office_phone,alt_phone,fax,company_name,url,dob,occupation,created,last_action,next_action,last_updated,source,account,owner,converted,expected_value,actual_value'),
	('options', 'rsvp_print', 'date,last_name,first_name,status,type,arrived,arrived_date,order_id,purchased'),
	('options', 'note_print', 'name,date,note,added_by,label,public,deadline,value,for,complete,completed_by,completed_on,priority'),
	('options', 'account_print', 'name,profile_pic,created,owner,url,contact_frequency,last_updated,source,address_line_1,address_line_2,city,state,zip,country,phone,office_phone,alt_phone,fax,company_name,url,industry,account_type'),

	('options', 'member_export', 'username,email,joined,last_renewal,last_action,last_login,last_updated,source,account,owner,url,first_name,last_name,address_line_1,address_line_2,city,state,zip,country,phone,fax,sms_optout,dob,industry,cell,cell_carrier,alt_phone,office_phone,member_type,status'),
	('options', 'contact_export', 'email,type,url,first_name,last_name,address_line_1,address_line_2,city,state,zip,country,phone,cell,cell_carrier,office_phone,alt_phone,fax,company_name,url,facebook,twitter,linkedin,dob,occupation,sms_optout,created,last_action,next_action,last_updated,source,account,owner,converted,expected_value,actual_value'),
	('options', 'rsvp_export', 'date,email,first_name,last_name,address_line_1,address_line_2,city,state,zip,country,phone,cell,cell_carrier,sms_optout,type,status,arrived,arrived_date,checked_in_by,order_id,purchased'),
	('options', 'account_export', 'name,created,owner,contact_frequency,last_updated,source,url,address_line_1,address_line_2,city,state,zip,country,phone,office_phone,alt_phone,fax,company_name,url,industry,account_type'),

	('options', 'transaction_export', 'id,date,date_completed,status,member_id,member_type,code,payment_gateway,gateway_order_id,shipping_rule,shipping_name,total,gateway_fees,subtotal,shipping,tax,tax_rate,savings,refunds,company_name,name,first_name,last_name,address_line_1,address_line_2,city,state,zip,country,phone,email,ship_directions,shipped,ship_date,trackable,shipping_number,shipping_provider,remarks'),
	('options', 'contact_quick_view', 'id,type,account,source,created,status,first_name,last_name,email,phone,company_name'),
	('options', 'member_quick_view', 'id,username,member_type,account,status,source,joined,status,first_name,last_name,email,phone'),
	
	('options', 'transaction_headings', 'id,date,status,date_completed,member_id,member_type,ip,payment_gateway,gateway_order_id,gateway_resp_code,gateway_fees,gateway_msg,card_id,shipping_name,total,shipped,shipping_provider,shipping_number'),
	('options', 'event_headings', 'id,name,tagline,starts,ends,start_registrations,early_bird_end,close_registration,max_rsvps,total_rsvps,allow_guests,max_guests,online,url,location_name,address_line_1,address_line_2,city,state,zip,country,phone'),

	('employee', 'homepage_widgets', 'a:6:{i:0;s:7:\"members\";i:1;s:8:\"contacts\";i:2;s:5:\"rsvps\";i:3;s:12:\"transactions\";i:4;s:18:\"subscriptions_soon\";i:5;s:8:\"invoices\";}'),
	('options', 'gibberish_english', 'a:2:{s:6:\"matrix\";a:27:{i:0;a:27:{i:0;d:-8.56913731293089853124911314807832241058349609375;i:1;d:-3.936933259763186310209448492969386279582977294921875;i:2;d:-3.22067016269739081479883680003695189952850341796875;i:3;d:-3.048247986967610234643188960035331547260284423828125;i:4;d:-6.052279063336296616171239293180406093597412109375;i:5;d:-4.69956099775000968321592154097743332386016845703125;i:6;d:-3.99415859680878160276051858090795576572418212890625;i:7;d:-6.71040721759666070056482567451894283294677734375;i:8;d:-3.24530410606021835207002368406392633914947509765625;i:9;d:-7.0607402550101081573075134656392037868499755859375;i:10;d:-4.5122833596242966081035774550400674343109130859375;i:11;d:-2.49972015296449345811424791463650763034820556640625;i:12;d:-3.642636781640966159301342486287467181682586669921875;i:13;d:-1.5707462805725018739622100838460028171539306640625;i:14;d:-7.9784688016538911625730179366655647754669189453125;i:15;d:-3.89364181022207755944464224739931523799896240234375;i:16;d:-9.8219002814262665879141422919929027557373046875;i:17;d:-2.30252837828013756649170318269170820713043212890625;i:18;d:-2.348366425382398148258289438672363758087158203125;i:19;d:-1.94486514219478134890550791169516742229461669921875;i:20;d:-4.53915812666370133143800558173097670078277587890625;i:21;d:-3.871849760115082972333766520023345947265625;i:22;d:-4.70635912046383086959622232825495302677154541015625;i:23;d:-6.5603133384650167414520183228887617588043212890625;i:24;d:-3.64972532320763320967671461403369903564453125;i:25;d:-6.641954302926283304486787528730928897857666015625;i:26;d:-2.713470174759111674944733749725855886936187744140625;}i:1;a:27:{i:0;d:-2.5528619980784998944045582902617752552032470703125;i:1;d:-5.1392262080557546966019799583591520786285400390625;i:2;d:-6.0497198222455832450350499129854142665863037109375;i:3;d:-6.21940479503502618996435558074153959751129150390625;i:4;d:-1.173596307609444000519260953296907246112823486328125;i:5;d:-8.5639540871281045752994032227434217929840087890625;i:6;d:-8.80511614394499275704220053739845752716064453125;i:7;d:-8.4949612156411529184651953983120620250701904296875;i:8;d:-3.332845470273517296533327680663205683231353759765625;i:9;d:-5.00453270025105467766479705460369586944580078125;i:10;d:-8.80511614394499275704220053739845752716064453125;i:11;d:-2.139085063222716076580809385632164776325225830078125;i:12;d:-6.12160705175889940932165700360201299190521240234375;i:13;d:-6.80856226207092429802969490992836654186248779296875;i:14;d:-2.145938781170397380293479727697558701038360595703125;i:15;d:-8.3126396588471980209078537882305681705474853515625;i:16;d:-8.9004263237493166371905317646451294422149658203125;i:17;d:-2.7193750088559678346200598753057420253753662109375;i:18;d:-3.78843853539277386488492993521504104137420654296875;i:19;d:-4.703224376087508318278196384198963642120361328125;i:20;d:-2.1373500561366238770233394461683928966522216796875;i:21;d:-6.32020949415699195839124513440765440464019775390625;i:22;d:-7.6766508921272009757785781403072178363800048828125;i:23;d:-8.9004263237493166371905317646451294422149658203125;i:24;d:-2.361129427246248635441361329867504537105560302734375;i:25;d:-8.9004263237493166371905317646451294422149658203125;i:26;d:-4.73842311305340135874075713218189775943756103515625;}i:2;a:27:{i:0;d:-2.08946313988476983780628870590589940547943115234375;i:1;d:-9.3982849786401576608341201790608465671539306640625;i:2;d:-3.846618218720845749913905819994397461414337158203125;i:3;d:-7.678499009037192735149801592342555522918701171875;i:4;d:-1.739113610974099888295540949911810457706451416015625;i:5;d:-8.7921491750698432809940641163848340511322021484375;i:6;d:-9.5806065354341125583914617891423404216766357421875;i:7;d:-1.9093388132314668137468061104300431907176971435546875;i:8;d:-2.93317759889390128336117413709871470928192138671875;i:9;d:-9.485296355629788678243130561895668506622314453125;i:10;d:-3.34365003334815913405009268899448215961456298828125;i:11;d:-3.276523430584318052893877393216826021671295166015625;i:12;d:-8.5158957984416847608599709928967058658599853515625;i:13;d:-8.838669190704735001418157480657100677490234375;i:14;d:-1.60003552282787619986947902361862361431121826171875;i:15;d:-9.485296355629788678243130561895668506622314453125;i:16;d:-6.3860234031349563110779854469001293182373046875;i:17;d:-3.37766624187960307068578913458622992038726806640625;i:18;d:-5.8381863143921464143204502761363983154296875;i:19;d:-2.390910634629308528786850729375146329402923583984375;i:20;d:-3.21844087265430633948426475399173796176910400390625;i:21;d:-9.485296355629788678243130561895668506622314453125;i:22;d:-8.838669190704735001418157480657100677490234375;i:23;d:-9.5806065354341125583914617891423404216766357421875;i:24;d:-4.6212645357254071853958521387539803981781005859375;i:25;d:-8.29967268997204854485971736721694469451904296875;i:26;d:-3.86687372992474376331983876298181712627410888671875;}i:3;a:27:{i:0;d:-3.72004759084082348152833219501189887523651123046875;i:1;d:-7.41843455057575607014541674288921058177947998046875;i:2;d:-7.88681348409448990111059174523688852787017822265625;i:3;d:-4.56486547408647513890400659875012934207916259765625;i:4;d:-1.96994653947911313451868409174494445323944091796875;i:5;d:-6.7968969023939340701190303661860525608062744140625;i:6;d:-5.4304488376459740806012632674537599086761474609375;i:7;d:-6.75415535401666300430179035174660384654998779296875;i:8;d:-2.462722007718394223729774239473044872283935546875;i:9;d:-6.277375571660389397266044397838413715362548828125;i:10;d:-7.66627071448033792222531701554544270038604736328125;i:11;d:-4.5583264503194182992729110992513597011566162109375;i:12;d:-5.51887851089199354959191623493097722530364990234375;i:13;d:-5.9464847448773721083625787287019193172454833984375;i:14;d:-3.11700972293176281624482726329006254673004150390625;i:15;d:-8.3804713042381155929660963010974228382110595703125;i:16;d:-8.1362743437260736101279690046794712543487548828125;i:17;d:-3.62431653946016041345501434989273548126220703125;i:18;d:-3.6811521539816407511125362361781299114227294921875;i:19;d:-7.19366630353454450386152529972605407238006591796875;i:20;d:-3.994198378682782379911486714263446629047393798828125;i:21;d:-5.5687641654028627868910916731692850589752197265625;i:22;d:-7.0773273114503947311959564103744924068450927734375;i:23;d:-9.9280338129541281233514382620342075824737548828125;i:24;d:-4.61384309724980123945670129614882171154022216796875;i:25;d:-9.7457122561601732257940966519527137279510498046875;i:26;d:-0.5394468422260205731078031021752394735813140869140625;}i:4;a:27:{i:0;d:-3.0956911156796724782225282979197800159454345703125;i:1;d:-6.3279563530093394518871718901209533214569091796875;i:2;d:-3.71139411752934478272436535917222499847412109375;i:3;d:-2.414309096615009142539065578603185713291168212890625;i:4;d:-3.72801015351070663683685779687948524951934814453125;i:5;d:-4.55509580994932061770441578119061887264251708984375;i:6;d:-4.95823695698366151418667868711054325103759765625;i:7;d:-6.34082417762073280442791656241752207279205322265625;i:8;d:-4.46511588446394380724768780055455863475799560546875;i:9;d:-8.0432622665219515312173825805075466632843017578125;i:10;d:-7.01291794898284504000685046776197850704193115234375;i:11;d:-3.439565246328211589599277431261725723743438720703125;i:12;d:-3.74898562949726166237951474613510072231292724609375;i:13;d:-2.38915359506014279844521297491155564785003662109375;i:14;d:-5.281198278652137645394759601913392543792724609375;i:15;d:-4.426598784036354317095174337737262248992919921875;i:16;d:-6.26513162834950332324979171971790492534637451171875;i:17;d:-1.9762712469186809460808262883801944553852081298828125;i:18;d:-2.51922598754776316809511627070605754852294921875;i:19;d:-3.733110644013185375200691851205192506313323974609375;i:20;d:-6.051293675807169591962519916705787181854248046875;i:21;d:-4.11522602804092230144306086003780364990234375;i:22;d:-4.7192493011961147431065910495817661285400390625;i:23;d:-4.45117886715155730570359082776121795177459716796875;i:24;d:-4.53558824103577595820979695417918264865875244140625;i:25;d:-7.73175461565810184794145243358798325061798095703125;i:26;d:-1.1291364595675441595545862583094276487827301025390625;}i:5;a:27:{i:0;d:-2.76344229114557027315868253936059772968292236328125;i:1;d:-7.9114774546442685476677070255391299724578857421875;i:2;d:-7.529542843946298802393357618711888790130615234375;i:3;d:-8.4946237399898851805346566834487020969390869140625;i:4;d:-2.451100566435660876862812074250541627407073974609375;i:5;d:-2.926120215794327794611717763473279774188995361328125;i:6;d:-7.6122345597914122805605074972845613956451416015625;i:7;d:-8.5371833544086808132078658672980964183807373046875;i:8;d:-2.450507446608071404625661671161651611328125;i:9;d:-9.033620240722573413449936197139322757720947265625;i:10;d:-8.728238591171390226008952595293521881103515625;i:11;d:-3.748243385450270803715966394520364701747894287109375;i:12;d:-8.8394642262816152111781775602139532566070556640625;i:13;d:-7.665344385105360203169766464270651340484619140625;i:14;d:-1.9043799278633868343746371465385891497135162353515625;i:15;d:-8.30538174035135767780957394279539585113525390625;i:16;d:-9.370092477343785475341064739041030406951904296875;i:17;d:-2.35581735498397559780414667329750955104827880859375;i:18;d:-5.9296743825283488860122815822251141071319580078125;i:19;d:-3.315653131074415060908222585567273199558258056640625;i:20;d:-3.505893281281679652039429129217751324176788330078125;i:21;d:-9.370092477343785475341064739041030406951904296875;i:22;d:-7.80147655942994067146400993806309998035430908203125;i:23;d:-9.370092477343785475341064739041030406951904296875;i:24;d:-6.13534330331929478319352710968814790248870849609375;i:25;d:-9.370092477343785475341064739041030406951904296875;i:26;d:-0.99767075505541946700560629324172623455524444580078125;}i:6;a:27:{i:0;d:-2.6811173187426220465567894279956817626953125;i:1;d:-8.5602526808766850052734298515133559703826904296875;i:2;d:-8.0833286087863758240246170316822826862335205078125;i:3;d:-6.88627624730501253225156688131392002105712890625;i:4;d:-1.9631827738890723633602419795352034270763397216796875;i:5;d:-7.9242639141566879601441542035900056362152099609375;i:6;d:-4.61975020412667003455453595961444079875946044921875;i:7;d:-2.221364181944155635761717348941601812839508056640625;i:8;d:-2.86129664959741258911662953323684632778167724609375;i:9;d:-9.1480393457788036215561078279279172420501708984375;i:10;d:-8.5602526808766850052734298515133559703826904296875;i:11;d:-3.35807917488155016627615623292513191699981689453125;i:12;d:-6.07534603108868420662247444852255284786224365234375;i:13;d:-3.739971115271647494893159091589041054248809814453125;i:14;d:-2.831958278425978026149323341087438166141510009765625;i:15;d:-7.95411687730636884907653438858687877655029296875;i:16;d:-9.0527291659744779650509372004307806491851806640625;i:17;d:-2.55266875188881936509233128163032233715057373046875;i:18;d:-4.06291519969180825455623562447726726531982421875;i:19;d:-4.94334672638783700904241413809359073638916015625;i:20;d:-3.49449808755934920867503024055622518062591552734375;i:21;d:-9.1480393457788036215561078279279172420501708984375;i:22;d:-7.5794234278649579295006333268247544765472412109375;i:23;d:-9.1480393457788036215561078279279172420501708984375;i:24;d:-5.8822799350117520589265041053295135498046875;i:25;d:-8.617411094716633357393220649100840091705322265625;i:26;d:-1.0302198528344137518075740445055998861789703369140625;}i:7;a:27:{i:0;d:-1.8949866865832032392091832662117667496204376220703125;i:1;d:-7.38720654177458957434510011808015406131744384765625;i:2;d:-8.053104079887159372219684883020818233489990234375;i:3;d:-7.5422784561211688725279600475914776325225830078125;i:4;d:-0.728635365144754576505192744662053883075714111328125;i:5;d:-7.8583157543280748313918593339622020721435546875;i:6;d:-9.589971299486425238001174875535070896148681640625;i:7;d:-8.7790410832700960241936627426184713840484619140625;i:8;d:-1.99513721534594878903590142726898193359375;i:9;d:-10.1007969232524157376928997109644114971160888671875;i:10;d:-7.88522320724799907765145690063945949077606201171875;i:11;d:-6.63506102045268875144756748341023921966552734375;i:12;d:-6.261344610659104858996215625666081905364990234375;i:13;d:-6.7051705866397153243951834156177937984466552734375;i:14;d:-2.561769867428420610622197273187339305877685546875;i:15;d:-9.2534990628652113997532069333828985691070556640625;i:16;d:-10.1007969232524157376928997109644114971160888671875;i:17;d:-4.57202943020773044935367579455487430095672607421875;i:18;d:-6.222675469499950651197650586254894733428955078125;i:19;d:-3.764561336708525107752620897372253239154815673828125;i:20;d:-4.62224350640144532320618964149616658687591552734375;i:21;d:-9.541181135316993078276937012560665607452392578125;i:22;d:-7.3816968859636205024798982776701450347900390625;i:23;d:-10.2831184800463706352502413210459053516387939453125;i:24;d:-5.024581983510177707330512930639088153839111328125;i:25;d:-10.1878083002420449787450706935487687587738037109375;i:26;d:-2.362308800757769500222593705984763801097869873046875;}i:8;a:27:{i:0;d:-3.712244886548000888382148332311771810054779052734375;i:1;d:-4.7174752821302110561418885481543838977813720703125;i:2;d:-2.783984370515816930691244124318473041057586669921875;i:3;d:-3.221601376806764616134159950888715684413909912109375;i:4;d:-3.1683365236496232597573907696641981601715087890625;i:5;d:-3.903825455861240190102989799925126135349273681640625;i:6;d:-3.68079054705895192256548398290760815143585205078125;i:7;d:-9.1193045441002720252754443208687007427215576171875;i:8;d:-6.42298959921648293658336115186102688312530517578125;i:9;d:-10.3232773484262079222162356018088757991790771484375;i:10;d:-5.24083832220096912379858622443862259387969970703125;i:11;d:-3.07952613671373942594300388009287416934967041015625;i:12;d:-3.173687619686372141103447575005702674388885498046875;i:13;d:-1.3126793991869438738007147549069486558437347412109375;i:14;d:-2.6643811758555511204349386389367282390594482421875;i:15;d:-4.92360748761788347138690369320102035999298095703125;i:16;d:-7.8955291124781563638634906965307891368865966796875;i:17;d:-3.409705684122631197396913194097578525543212890625;i:18;d:-2.0515798328281977802589608472771942615509033203125;i:19;d:-2.101193745290548253734641548362560570240020751953125;i:20;d:-6.51107467828027264289403319708071649074554443359375;i:21;d:-3.816746183294980721001365964184515178203582763671875;i:22;d:-9.672689782285058157640378340147435665130615234375;i:23;d:-6.1683081643876729316389173618517816066741943359375;i:24;d:-10.4102887254158371632684065843932330608367919921875;i:25;d:-5.5117707294402880080497197923250496387481689453125;i:26;d:-3.788398987959083807908200469682924449443817138671875;}i:9;a:27:{i:0;d:-2.342760916057565534487139302655123174190521240234375;i:1;d:-6.10240944105970850586118103819899260997772216796875;i:2;d:-6.03787091992213742486228511552326381206512451171875;i:3;d:-6.50787454916787311276493710465729236602783203125;i:4;d:-1.4153520955994334240557463999721221625804901123046875;i:5;d:-6.2455102847003818311577560962177813053131103515625;i:6;d:-6.17140231254666016269538886263035237789154052734375;i:7;d:-6.325552992373918215207595494575798511505126953125;i:8;d:-5.51462277615758988957850306178443133831024169921875;i:9;d:-6.50787454916787311276493710465729236602783203125;i:10;d:-6.2455102847003818311577560962177813053131103515625;i:11;d:-6.41256436936354834443818617728538811206817626953125;i:12;d:-6.325552992373918215207595494575798511505126953125;i:13;d:-6.50787454916787311276493710465729236602783203125;i:14;d:-1.2783714986201963892398225652868859469890594482421875;i:15;d:-6.41256436936354834443818617728538811206817626953125;i:16;d:-6.325552992373918215207595494575798511505126953125;i:17;d:-6.10240944105970850586118103819899260997772216796875;i:18;d:-6.10240944105970850586118103819899260997772216796875;i:19;d:-6.2455102847003818311577560962177813053131103515625;i:20;d:-1.10025444772938651993854364263825118541717529296875;i:21;d:-6.50787454916787311276493710465729236602783203125;i:22;d:-6.2455102847003818311577560962177813053131103515625;i:23;d:-6.50787454916787311276493710465729236602783203125;i:24;d:-6.50787454916787311276493710465729236602783203125;i:25;d:-6.50787454916787311276493710465729236602783203125;i:26;d:-4.85921592358049192483804290532134473323822021484375;}i:10;a:27:{i:0;d:-3.61949335849451347968397385557182133197784423828125;i:1;d:-7.04770353940273697190832535852678120136260986328125;i:2;d:-6.06241993604163109665705633233301341533660888671875;i:3;d:-7.67185784847573160050160367973148822784423828125;i:4;d:-1.2114318817004574579954123692004941403865814208984375;i:5;d:-6.285563487355840806003470788709819316864013671875;i:6;d:-6.824559988088527262561910902149975299835205078125;i:7;d:-3.631148502086262386256976242293603718280792236328125;i:8;d:-1.7851984157338753878008219544426538050174713134765625;i:9;d:-7.81495869211640492579817873775027692317962646484375;i:10;d:-7.489536291681776702944262069649994373321533203125;i:11;d:-3.8876682145574701365831060684286057949066162109375;i:12;d:-6.03610262772425709698609352926723659038543701171875;i:13;d:-2.35439166308893366164056715206243097782135009765625;i:14;d:-3.841768225810271442099974592565558850765228271484375;i:15;d:-7.5466947055217250550640528672374784946441650390625;i:16;d:-7.98201277677957055090018911869265139102935791015625;i:17;d:-5.482068249627030098736213403753936290740966796875;i:18;d:-3.000899921949636617313217357150278985500335693359375;i:19;d:-6.6910285954640045247288071550428867340087890625;i:20;d:-3.738725879837350163370501832105219364166259765625;i:21;d:-7.24441383364879154527216087444685399532318115234375;i:22;d:-5.43826562696863735624219771125353872776031494140625;i:23;d:-8.077322956583895319226940046064555644989013671875;i:24;d:-4.682814563072536628851594286970794200897216796875;i:25;d:-8.077322956583895319226940046064555644989013671875;i:26;d:-1.4288566755523215423551164349191822111606597900390625;}i:11;a:27:{i:0;d:-2.269183388314388150064360161195509135723114013671875;i:1;d:-6.573297799694781673451871029101312160491943359375;i:2;d:-5.74547936544993120833169086836278438568115234375;i:3;d:-2.8596367214634224040992194204591214656829833984375;i:4;d:-1.7841347050080587077758309533237479627132415771484375;i:5;d:-4.14404790090957231285528905573301017284393310546875;i:6;d:-6.84409165411804121248451338033191859722137451171875;i:7;d:-7.74377464959253547505113601800985634326934814453125;i:8;d:-2.175115871017978097512468593777157366275787353515625;i:9;d:-9.70151925629485134550122893415391445159912109375;i:10;d:-4.95658712793160116660828862222842872142791748046875;i:11;d:-2.065933606191924010175853254622779786586761474609375;i:12;d:-5.0603386327837274194507699576206505298614501953125;i:13;d:-6.49269376728015235045177178108133375644683837890625;i:14;d:-2.45088374439617151523407301283441483974456787109375;i:15;d:-5.604400767190025334230085718445479869842529296875;i:16;d:-9.70151925629485134550122893415391445159912109375;i:17;d:-5.64828608231518192184239524067379534244537353515625;i:18;d:-3.8794600407142780795766157098114490509033203125;i:19;d:-3.8645179378524279201201352407224476337432861328125;i:20;d:-3.820986269894151465820186786004342138767242431640625;i:21;d:-5.0913615287957210142621988779865205287933349609375;i:22;d:-5.4662057509475570071799666038714349269866943359375;i:23;d:-9.883840813088806243058570544235408306121826171875;i:24;d:-2.333600268348952067043455826933495700359344482421875;i:25;d:-8.6029069676267422295268261223100125789642333984375;i:26;d:-2.043409772983191263762137168669141829013824462890625;}i:12;a:27:{i:0;d:-1.753994237524768795566387780127115547657012939453125;i:1;d:-3.684119898084507571667245429125614464282989501953125;i:2;d:-6.5593110988036560371483574272133409976959228515625;i:3;d:-8.4396239653731566221495086210779845714569091796875;i:4;d:-1.365444429657459490812243529944680631160736083984375;i:5;d:-6.407584662587904489328138879500329494476318359375;i:6;d:-9.33756555857911507700919173657894134521484375;i:7;d:-8.2389532699110059610347889247350394725799560546875;i:8;d:-2.4389427631602504931151997880078852176666259765625;i:9;d:-9.1705114739159494519071813556365668773651123046875;i:10;d:-8.90224748732126869299463578499853610992431640625;i:11;d:-6.20603174386606237789010265260003507137298583984375;i:12;d:-3.6410823864045251951893078512512147426605224609375;i:13;d:-5.66241629727708062347346640308387577533721923828125;i:14;d:-2.228057525143769534992088665603660047054290771484375;i:15;d:-2.6972144960398214408314743195660412311553955078125;i:16;d:-9.4328757383834389571575229638256132602691650390625;i:17;d:-5.50105010565911367592661918024532496929168701171875;i:18;d:-3.53819745996314960478912325925193727016448974609375;i:19;d:-6.90714709407518423489591441466473042964935302734375;i:20;d:-3.4685254837670296268470337963663041591644287109375;i:21;d:-9.25055418158948583595702075399458408355712890625;i:22;d:-8.0718991852478385595759391435422003269195556640625;i:23;d:-9.4328757383834389571575229638256132602691650390625;i:24;d:-3.424799925470261019455620044027455151081085205078125;i:25;d:-9.4328757383834389571575229638256132602691650390625;i:26;d:-1.896831851189853868078216692083515226840972900390625;}i:13;a:27:{i:0;d:-3.41157713428474007599788819788955152034759521484375;i:1;d:-6.72828520838997601316577856778167188167572021484375;i:2;d:-3.090942743072009335492111858911812305450439453125;i:3;d:-1.74026482568973506204201839864253997802734375;i:4;d:-2.501519051239830648825090975151397287845611572265625;i:5;d:-4.81737190137175819160120227024890482425689697265625;i:6;d:-2.113210530516430818437356720096431672573089599609375;i:7;d:-6.8077493797442230061278678476810455322265625;i:8;d:-3.2957925490940969126540949218906462192535400390625;i:9;d:-6.25279895106929384240856961696408689022064208984375;i:10;d:-4.9177978843369540840058107278309762477874755859375;i:11;d:-4.63276984187907903134373555076308548450469970703125;i:12;d:-5.98877585293416014877720954245887696743011474609375;i:13;d:-4.666651756641289949811834958381950855255126953125;i:14;d:-2.87675951806729290893827055697329342365264892578125;i:15;d:-7.603753945743875419793766923248767852783203125;i:16;d:-6.8644656091860749569377730949781835079193115234375;i:17;d:-7.18723900144912608567437928286381065845489501953125;i:18;d:-3.05233621575503111245097898063249886035919189453125;i:19;d:-2.264747926898596386280360093223862349987030029296875;i:20;d:-4.900158094991045487631708965636789798736572265625;i:21;d:-5.3489595165861789638483969611115753650665283203125;i:22;d:-7.14773655847287958664537654840387403964996337890625;i:23;d:-7.4543765446692749065960015286691486835479736328125;i:24;d:-4.54635184515679124928055898635648190975189208984375;i:25;d:-8.80772675006981131673455820418894290924072265625;i:26;d:-1.4656789800236864618199206233839504420757293701171875;}i:14;a:27:{i:0;d:-5.0822413891388436013585305772721767425537109375;i:1;d:-5.14239363199360166589713116991333663463592529296875;i:2;d:-4.27659835332892424020201360690407454967498779296875;i:3;d:-4.0852168176898668860985708306543529033660888671875;i:4;d:-5.75996838501091357187533503747545182704925537109375;i:5;d:-2.17477361599536411773669897229410707950592041015625;i:6;d:-5.2886215722187106536011924617923796176910400390625;i:7;d:-6.09017411036031486304409554577432572841644287109375;i:8;d:-4.471572330819423513048604945652186870574951171875;i:9;d:-6.906874683037980133804012439213693141937255859375;i:10;d:-4.432658655412264891992890625260770320892333984375;i:11;d:-3.227743106313963661335719734779559075832366943359375;i:12;d:-2.82129235565138447583422021125443279743194580078125;i:13;d:-1.768108839371391294292834572843275964260101318359375;i:14;d:-3.515622423909222415971953523694537580013275146484375;i:15;d:-3.951801656831616771370363494497723877429962158203125;i:16;d:-8.9863162247178163255512117757461965084075927734375;i:17;d:-2.166459079414195354473804400186054408550262451171875;i:18;d:-3.37121318415194171080884188995696604251861572265625;i:19;d:-3.12244833471454175111148288124240934848785400390625;i:20;d:-2.210189388214115258080028070253320038318634033203125;i:21;d:-3.5450716407123703532988656661473214626312255859375;i:22;d:-3.140479750467313646566935858572833240032196044921875;i:23;d:-6.66311184452103422160007539787329733371734619140625;i:24;d:-5.513444385052640228650489007122814655303955078125;i:25;d:-7.70422564112792773727278472506441175937652587890625;i:26;d:-2.21297367900774855087320247548632323741912841796875;}i:15;a:27:{i:0;d:-2.13626534966714398677822828176431357860565185546875;i:1;d:-7.6487499302755264096731480094604194164276123046875;i:2;d:-6.52216378956501063868245182675309479236602783203125;i:3;d:-8.5031652584315935428094235248863697052001953125;i:4;d:-1.734614577170006999295992500265128910541534423828125;i:5;d:-6.50168525822147014281426891102455556392669677734375;i:6;d:-7.78532546528127777918371066334657371044158935546875;i:7;d:-3.64257796057899785324707409017719328403472900390625;i:8;d:-2.6542728486002840071478203753940761089324951171875;i:9;d:-8.4543750942621631594420250621624290943145751953125;i:10;d:-7.86131137225919918165573108126409351825714111328125;i:11;d:-2.38517819861382829316198694868944585323333740234375;i:12;d:-6.3630990949353236629804086987860500812530517578125;i:13;d:-7.294204912594619116816829773597419261932373046875;i:14;d:-2.11620176752729793889784559723921120166778564453125;i:15;d:-2.790753457077338683944844888173975050449371337890625;i:16;d:-9.1963124389915389400584899703972041606903076171875;i:17;d:-1.78687319416069545496839054976589977741241455078125;i:18;d:-3.848728831140584727421583011164329946041107177734375;i:19;d:-3.2942257030347743551601524814032018184661865234375;i:20;d:-3.19712776886841965051644365303218364715576171875;i:21;d:-9.1963124389915389400584899703972041606903076171875;i:22;d:-7.08005692418898746609556837938725948333740234375;i:23;d:-9.1963124389915389400584899703972041606903076171875;i:24;d:-4.98715220234085787609501494443975389003753662109375;i:25;d:-9.1963124389915389400584899703972041606903076171875;i:26;d:-2.93634863884855068505430608638562262058258056640625;}i:16;a:27:{i:0;d:-6.182291496945648390237693092785775661468505859375;i:1;d:-6.182291496945648390237693092785775661468505859375;i:2;d:-6.182291496945648390237693092785775661468505859375;i:3;d:-6.182291496945648390237693092785775661468505859375;i:4;d:-6.182291496945648390237693092785775661468505859375;i:5;d:-6.182291496945648390237693092785775661468505859375;i:6;d:-6.182291496945648390237693092785775661468505859375;i:7;d:-6.182291496945648390237693092785775661468505859375;i:8;d:-6.182291496945648390237693092785775661468505859375;i:9;d:-6.182291496945648390237693092785775661468505859375;i:10;d:-6.182291496945648390237693092785775661468505859375;i:11;d:-6.182291496945648390237693092785775661468505859375;i:12;d:-6.182291496945648390237693092785775661468505859375;i:13;d:-6.182291496945648390237693092785775661468505859375;i:14;d:-6.182291496945648390237693092785775661468505859375;i:15;d:-6.182291496945648390237693092785775661468505859375;i:16;d:-6.182291496945648390237693092785775661468505859375;i:17;d:-6.182291496945648390237693092785775661468505859375;i:18;d:-6.182291496945648390237693092785775661468505859375;i:19;d:-6.182291496945648390237693092785775661468505859375;i:20;d:-0.05717056502499308356934903940782533027231693267822265625;i:21;d:-6.182291496945648390237693092785775661468505859375;i:22;d:-6.182291496945648390237693092785775661468505859375;i:23;d:-6.182291496945648390237693092785775661468505859375;i:24;d:-6.182291496945648390237693092785775661468505859375;i:25;d:-6.182291496945648390237693092785775661468505859375;i:26;d:-5.54043761077325402908400064916349947452545166015625;}i:17;a:27:{i:0;d:-2.57228079524373942632564649102278053760528564453125;i:1;d:-5.99205725679637968283941518166102468967437744140625;i:2;d:-4.31931676455123891855691908858716487884521484375;i:3;d:-3.7284294070555272782030442613177001476287841796875;i:4;d:-1.42254838175564923830052066477946937084197998046875;i:5;d:-5.35723168667141891319261048920452594757080078125;i:6;d:-4.3317609271287889072254984057508409023284912109375;i:7;d:-6.0337579859953240912773253512568771839141845703125;i:8;d:-2.36454174581913800778920631273649632930755615234375;i:9;d:-9.4051832093238090237719006836414337158203125;i:10;d:-4.8504645668318158158172082039527595043182373046875;i:11;d:-4.67355659938315870505221027997322380542755126953125;i:12;d:-3.745004372149740135000683949328958988189697265625;i:13;d:-3.916576116332640911110729575739242136478424072265625;i:14;d:-2.322164557359624126320341019891202449798583984375;i:15;d:-5.41397940602122229591941504622809588909149169921875;i:16;d:-9.04054009573589922865721746347844600677490234375;i:17;d:-3.63686221353003702461137436330318450927734375;i:18;d:-2.901613856951456238419950750540010631084442138671875;i:19;d:-3.23456879658750739992001399514265358448028564453125;i:20;d:-3.981643878022390392601437270059250295162200927734375;i:21;d:-4.90581808223269444368952463264577090740203857421875;i:22;d:-6.25758858646057181118749213055707514286041259765625;i:23;d:-10.139152384404010120988459675572812557220458984375;i:24;d:-3.258597025348527242982754614786244928836822509765625;i:25;d:-8.0701821425914683771907220943830907344818115234375;i:26;d:-1.7281348556024396234676032690913416445255279541015625;}i:18;a:27:{i:0;d:-3.2090119684802527189049214939586818218231201171875;i:1;d:-6.33489952315430304707888353732414543628692626953125;i:2;d:-4.09329906441737367828181959339417517185211181640625;i:3;d:-7.5920350390622797220885331626050174236297607421875;i:4;d:-2.15863457030355476717886631377041339874267578125;i:5;d:-6.1829951939534186777791546774096786975860595703125;i:6;d:-7.8495033329175640801622648723423480987548828125;i:7;d:-2.9152578145891450134286060347221791744232177734375;i:8;d:-2.775471041990636766882971642189659178256988525390625;i:9;d:-9.5502910239398932645826789666898548603057861328125;i:10;d:-4.55102445745039663194120294065214693546295166015625;i:11;d:-4.7071315107863114235442481003701686859130859375;i:12;d:-4.5892723223674494192891870625317096710205078125;i:13;d:-6.24324507340084355888620848418213427066802978515625;i:14;d:-2.968928515714967186767125895130448043346405029296875;i:15;d:-3.8539273046711368664318797527812421321868896484375;i:16;d:-7.00903143760076030588379580876789987087249755859375;i:17;d:-8.243133983378726270530023612082004547119140625;i:18;d:-2.810851494750975287928440593532286584377288818359375;i:19;d:-2.117755763783303546432534858467988669872283935546875;i:20;d:-3.256550330868064779821224874467588961124420166015625;i:21;d:-7.86550367426400587334001102135516703128814697265625;i:22;d:-5.3805970244760050746890556183643639087677001953125;i:23;d:-10.3832001468749961503590384381823241710662841796875;i:24;d:-5.2014165965829111115681371302343904972076416015625;i:25;d:-9.9131965176292613506348061491735279560089111328125;i:26;d:-0.991130059875320323925507182138971984386444091796875;}i:19;a:27:{i:0;d:-3.1682706209020796705999600817449390888214111328125;i:1;d:-8.217706195099385269031699863262474536895751953125;i:2;d:-5.87889983867102206005483822082169353961944580078125;i:3;d:-9.52521967836616312297337572090327739715576171875;i:4;d:-2.338891874978721308053764005308039486408233642578125;i:5;d:-7.17240245988578362101861785049550235271453857421875;i:6;d:-8.4784324575626381914617013535462319850921630859375;i:7;d:-1.1074718716074005708804861569660715758800506591796875;i:8;d:-2.366234149730215730045301825157366693019866943359375;i:9;d:-10.45677788237110661384576815180480480194091796875;i:10;d:-9.6895227296574386599559147725813090801239013671875;i:11;d:-4.41853985524954406827191633055917918682098388671875;i:12;d:-6.0323919738580826788165722973644733428955078125;i:13;d:-7.219608864455580032881698571145534515380859375;i:14;d:-2.336715396119156462617638680967502295970916748046875;i:15;d:-8.161914835470970075448349234648048877716064453125;i:16;d:-10.719142146838596119096109759993851184844970703125;i:17;d:-3.4624215669877802525888910167850553989410400390625;i:18;d:-3.6797447588047447197823203168809413909912109375;i:19;d:-4.02519909174178547317524134996347129344940185546875;i:20;d:-3.900218081563075589457412206684239208698272705078125;i:21;d:-9.5559913370329159221228110254742205142974853515625;i:22;d:-5.18259559155830995536007321788929402828216552734375;i:23;d:-10.131355481936477502813431783579289913177490234375;i:24;d:-4.2047257961667838799257879145443439483642578125;i:25;d:-7.9847746374190133877846164978109300136566162109375;i:26;d:-1.5835253210583506433550837755319662392139434814453125;}i:20;a:27:{i:0;d:-3.69070634749608128544196006259880959987640380859375;i:1;d:-3.73413364092809985095300362445414066314697265625;i:2;d:-3.245472126214963282109238207340240478515625;i:3;d:-4.02060871262984509399984744959510862827301025390625;i:4;d:-3.281297978688058947227546013891696929931640625;i:5;d:-5.0172437658127595483392724418081343173980712890625;i:6;d:-3.19332718495017342519304293091408908367156982421875;i:7;d:-7.796389888598699968724758946336805820465087890625;i:8;d:-3.7311188662600098808752591139636933803558349609375;i:9;d:-9.3545345066452494364739322918467223644256591796875;i:10;d:-6.20822937461188484320473435218445956707000732421875;i:11;d:-2.25767516857242700467622853466309607028961181640625;i:12;d:-3.411297781850523680446940488764084875583648681640625;i:13;d:-2.089862646254398992340384211274795234203338623046875;i:14;d:-6.09643796862376774470249074511229991912841796875;i:15;d:-3.100705695069776890449020356754772365093231201171875;i:16;d:-8.9490693985370857177485959255136549472808837890625;i:17;d:-1.9053759034329840194033067746204324066638946533203125;i:18;d:-1.9722545836234537386388865343178622424602508544921875;i:19;d:-1.964867614061764466981685473001562058925628662109375;i:20;d:-9.274491798971713052424092893488705158233642578125;i:21;d:-6.78319535108494253705657683894969522953033447265625;i:22;d:-9.3545345066452494364739322918467223644256591796875;i:23;d:-7.31765257938420976557836183928884565830230712890625;i:24;d:-7.37353303777866653234696059371344745159149169921875;i:25;d:-5.2671586137392427673376005259342491626739501953125;i:26;d:-3.270035093570078377211984843597747385501861572265625;}i:21;a:27:{i:0;d:-2.467755132731010547786354436539113521575927734375;i:1;d:-8.4660147229718205608151038177311420440673828125;i:2;d:-8.561324902776146217320274445228278636932373046875;i:3;d:-7.8681777222162008200712079997174441814422607421875;i:4;d:-0.51923632855148660336652710611815564334392547607421875;i:5;d:-8.561324902776146217320274445228278636932373046875;i:6;d:-8.2989606383086549357130934367887675762176513671875;i:7;d:-8.4660147229718205608151038177311420440673828125;i:8;d:-1.742947434945225637648036354221403598785400390625;i:9;d:-8.4660147229718205608151038177311420440673828125;i:10;d:-7.919471016603750967988162301480770111083984375;i:11;d:-5.44337499649790590439124571275897324085235595703125;i:12;d:-8.561324902776146217320274445228278636932373046875;i:13;d:-4.56680067583625604044073043041862547397613525390625;i:14;d:-2.789260920703539259335457245470024645328521728515625;i:15;d:-8.561324902776146217320274445228278636932373046875;i:16;d:-8.561324902776146217320274445228278636932373046875;i:17;d:-6.26879014563560144068787849391810595989227294921875;i:18;d:-4.4071403401980280278849022579379379749298095703125;i:19;d:-7.97353823787402671285917676868848502635955810546875;i:20;d:-6.2891990172668084113638542476110160350799560546875;i:21;d:-8.37900334598219131976293283514678478240966796875;i:22;d:-8.0306966517139759531573872664012014865875244140625;i:23;d:-8.4660147229718205608151038177311420440673828125;i:24;d:-5.2581079294741943641611214843578636646270751953125;i:25;d:-8.561324902776146217320274445228278636932373046875;i:26;d:-3.122810905734825670521104257204569876194000244140625;}i:22;a:27:{i:0;d:-1.59679846095761401869594919844530522823333740234375;i:1;d:-7.60014217059567354084492762922309339046478271484375;i:2;d:-7.640964165115928352634000475518405437469482421875;i:3;d:-5.344648685135478416441401350311934947967529296875;i:4;d:-1.8921021056868312371079809963703155517578125;i:5;d:-6.83933634156191327946316960151307284832000732421875;i:6;d:-8.1109677943616649287150721647776663303375244140625;i:7;d:-1.6228272590921337670266666464158333837985992431640625;i:8;d:-1.76287830456499161613237447454594075679779052734375;i:9;d:-8.8731078464085602064415070344693958759307861328125;i:10;d:-7.00130566950696930916819837875664234161376953125;i:11;d:-5.4671598619878079006184634636156260967254638671875;i:12;d:-8.179960665848614809192440588958561420440673828125;i:13;d:-3.218365567177001285159576582373119890689849853515625;i:14;d:-2.52421863647130084729042209801264107227325439453125;i:15;d:-8.293289351155618049915574374608695507049560546875;i:16;d:-9.209580083029774044689474976621568202972412109375;i:17;d:-4.570008470324349758584503433667123317718505859375;i:18;d:-4.2425484264156505531673246878199279308319091796875;i:19;d:-5.65423202154036008693083203979767858982086181640625;i:20;d:-7.5609214574423919685841610771603882312774658203125;i:21;d:-9.209580083029774044689474976621568202972412109375;i:22;d:-7.30747255663285333326939507969655096530914306640625;i:23;d:-9.209580083029774044689474976621568202972412109375;i:24;d:-6.87743618779418408593073763768188655376434326171875;i:25;d:-9.02725852623581914713213336654007434844970703125;i:26;d:-2.172728230713226960091333239688538014888763427734375;}i:23;a:27:{i:0;d:-2.254780968033423871332843191339634358882904052734375;i:1;d:-6.8982098661386057614208766608498990535736083984375;i:2;d:-2.027603216646053141403172048740088939666748046875;i:3;d:-6.49274475803044115451712059439159929752349853515625;i:4;d:-2.4626424645366942201007987023331224918365478515625;i:5;d:-5.83349912914617707571096616447903215885162353515625;i:6;d:-6.8982098661386057614208766608498990535736083984375;i:7;d:-4.31044583091089794635308862780220806598663330078125;i:8;d:-2.073101259785252725720283706323243677616119384765625;i:9;d:-6.8982098661386057614208766608498990535736083984375;i:10;d:-6.8982098661386057614208766608498990535736083984375;i:11;d:-6.42820623689287007351822467171587049961090087890625;i:12;d:-6.7158883093446508638635350507684051990509033203125;i:13;d:-6.8982098661386057614208766608498990535736083984375;i:14;d:-4.455862830769401483621550141833722591400146484375;i:15;d:-1.4955324842663262341346808170783333480358123779296875;i:16;d:-6.367581615076435497257989482022821903228759765625;i:17;d:-4.63644676766481467211633571423590183258056640625;i:18;d:-5.766807754647505390721562434919178485870361328125;i:19;d:-1.8703897472882491381795944107579998672008514404296875;i:20;d:-4.3724812218303501509808484115637838840484619140625;i:21;d:-4.34876469521303388177102533518336713314056396484375;i:22;d:-6.80289968633428099309412573347799479961395263671875;i:23;d:-4.47340714042031084574091437389142811298370361328125;i:24;d:-5.17544326839750201685319552780129015445709228515625;i:25;d:-6.8982098661386057614208766608498990535736083984375;i:26;d:-2.5557039896270072887318747234530746936798095703125;}i:24;a:27:{i:0;d:-3.872874353532437918801178966532461345195770263671875;i:1;d:-6.0798383375596802835616472293622791767120361328125;i:2;d:-5.60595622898537460088164152693934738636016845703125;i:3;d:-6.1495716755743554671198580763302743434906005859375;i:4;d:-2.91810873520068358999424162902869284152984619140625;i:5;d:-5.8331401898365893288200823008082807064056396484375;i:6;d:-6.99872310461088265043372302898205816745758056640625;i:7;d:-7.31717683572941712810688841273076832294464111328125;i:8;d:-3.8266394412494406651603640057146549224853515625;i:9;d:-8.8576218766765659751172279356978833675384521484375;i:10;d:-7.45070822835393986593999215983785688877105712890625;i:11;d:-4.7453828245779146044469598564319312572479248046875;i:12;d:-4.44785848703108488422230948344804346561431884765625;i:13;d:-5.4481256921997154307746313861571252346038818359375;i:14;d:-2.22551031171975655098549395916052162647247314453125;i:15;d:-4.7372306055163644344929707585833966732025146484375;i:16;d:-9.0399434334705208726745695457793772220611572265625;i:17;d:-5.75154154595370936675635675783269107341766357421875;i:18;d:-3.132676045163294009654464389313943684101104736328125;i:19;d:-4.23020108175365461278261136612854897975921630859375;i:20;d:-7.03846343326039658450099523179233074188232421875;i:21;d:-7.6536490723506300781764366547577083110809326171875;i:22;d:-6.23054073810802311328416180913336575031280517578125;i:23;d:-7.70494236673818022609339095652103424072265625;i:24;d:-8.16447469611662057786816149018704891204833984375;i:25;d:-7.7316106138203419817500616773031651973724365234375;i:26;d:-0.3817890191036423797044108141562901437282562255859375;}i:25;a:27:{i:0;d:-2.5311795993314571973087367950938642024993896484375;i:1;d:-6.00314605188181982242667800164781510829925537109375;i:2;d:-5.907835872077495054099927074275910854339599609375;i:3;d:-4.69481323223164093150217013317160308361053466796875;i:4;d:-0.9292230185496455074911636984325014054775238037109375;i:5;d:-5.907835872077495054099927074275910854339599609375;i:6;d:-6.00314605188181982242667800164781510829925537109375;i:7;d:-3.199785670975284990191767064970917999744415283203125;i:8;d:-2.339584405752173523751480388455092906951904296875;i:9;d:-6.00314605188181982242667800164781510829925537109375;i:10;d:-5.6666738152606068723571297596208751201629638671875;i:11;d:-3.886890537079267904374546560575254261493682861328125;i:12;d:-4.00166605167169553425310368766076862812042236328125;i:13;d:-5.0098942788715365992402439587749540805816650390625;i:14;d:-1.7362497244615695546343658861587755382061004638671875;i:15;d:-6.00314605188181982242667800164781510829925537109375;i:16;d:-6.00314605188181982242667800164781510829925537109375;i:17;d:-6.00314605188181982242667800164781510829925537109375;i:18;d:-5.82082449508786492486933639156632125377655029296875;i:19;d:-5.907835872077495054099927074275910854339599609375;i:20;d:-3.118345339035110352909896391793154180049896240234375;i:21;d:-5.6666738152606068723571297596208751201629638671875;i:22;d:-5.907835872077495054099927074275910854339599609375;i:23;d:-6.00314605188181982242667800164781510829925537109375;i:24;d:-4.56806152659249686820430724765174090862274169921875;i:25;d:-3.7731316517226094475745412637479603290557861328125;i:26;d:-3.1699327078256036571701770299114286899566650390625;}i:26;a:27:{i:0;d:-2.15445631830065398304441259824670851230621337890625;i:1;d:-3.132028909232904112514006556011736392974853515625;i:2;d:-3.204240273221434787132011479116044938564300537109375;i:3;d:-3.5547759660800490877363699837587773799896240234375;i:4;d:-3.8320798875631165714139569899998605251312255859375;i:5;d:-3.2625149066892173976839330862276256084442138671875;i:6;d:-4.13184262373052746397661394439637660980224609375;i:7;d:-2.784712279138497503794269505306147038936614990234375;i:8;d:-2.7534204117779434994872644892893731594085693359375;i:9;d:-5.6860742849137100307643777341581881046295166015625;i:10;d:-5.27151820510429391930529163801111280918121337890625;i:11;d:-3.7797926294683339420998891000635921955108642578125;i:12;d:-3.352468498262207940996404431643895804882049560546875;i:13;d:-3.812385935723568319843934659729711711406707763671875;i:14;d:-2.644532475328424947491612329031340777873992919921875;i:15;d:-3.367605730636743288641810067929327487945556640625;i:16;d:-6.2378725360564377666605651029385626316070556640625;i:17;d:-3.680921843486822719881956800236366689205169677734375;i:18;d:-2.70300749751599855841277530998922884464263916015625;i:19;d:-1.8614238674076200030782501926296390593051910400390625;i:20;d:-4.472388530409542539700851193629205226898193359375;i:21;d:-4.91869683048155170723703122348524630069732666015625;i:22;d:-2.80428504058845273760880445479415357112884521484375;i:23;d:-7.78394952828238384512360426015220582485198974609375;i:24;d:-4.7020395584873408978410225245170295238494873046875;i:25;d:-8.486442571260568001889623701572418212890625;i:26;d:-3.2910629924454486427976007689721882343292236328125;}}s:9:\"threshold\";d:0.027138686673887656153336678244158974848687648773193359375;}');
";
/*
	('options', 'account_scope', 'address_line_1,address_line_2,city,state,zip,country,phone,office_phone,alt_phone,fax,company_name,url,industry,account_type,email_optout,facebook,twitter,linkedin'),
	('options', 'rsvp_scope', 'first_name,last_name,address_line_1,address_line_2,city,state,zip,country,phone	cell,cell_carrier,sms_optout,email'),
	('options', 'contact_scope', 'first_name,last_name,address_line_1,address_line_2,city,state,zip,country,phone,cell,cell_carrier,office_phone,alt_phone,fax,company_name,url,facebook,twitter,linkedin,dob,occupation,sms_optout,email_optout,email'),
	('options', 'member_scope', 'first_name,last_name,address_line_1,address_line_2,city,state,zip,country,phone,fax,sms_optout,email_optout,email,dob,industry,facebook,twitter,linkedin,cell,cell_carrier,alt_phone,office_phone,member_type'),
*/
/**
 * Error Codes and Language Packs
 */
$inserts[] = "
	INSERT INTO `ppSD_error_codes` (`code`, `msg`) VALUES
	
	('C001', 'Event does not exist.'),
	('C002', 'Login to register for this event.'),
	('C003', 'You must be a member to register for this event.'),
	('C004', 'Early bird pricing is no longer available.'),
	('C005', 'You must select a ticket option for your guests.'),
	('C006', 'Doing this would place the event over capacity.'),
	('C007', 'You cannot bring that many guests!'),
	('C008', 'No registrant information to display.'),
	('C009', 'You must select a ticket for this event!'),
	('C010', 'Invalid product selected.'),
	('C011', 'Please only select one ticket product. Additional prople can be registered as guests.'),
	('C012', 'The event that you are trying to view in not available at the moment.'),
	('C013', 'Free Registration'),
	('C014', 'Paid Registration'),
	('C015', 'Registration has not begun.'),
	('C016', 'Registration is closed.'),
	('C017', 'You registered for this event on %date%. We\'re looking forward to meeting you!'),
	('C018', 'It looks like you\'re bringing along %total_guests% guest(s).'),
	('C019', 'The event you are trying to access has been canceled.'),
	 
	('E001', 'Please do not skip ahead in the registration process.'),
	('E002', 'A ticket product must be selected for this event.'),
	('E003', 'Could not find the link you are trying to click.'),
	('E004', 'Unsubscribe'),
	('E005', 'View this email online'),
	('E006', 'Could not find e-mail.'),
	('E007', 'Could not unsubscribe you: campaign not found.'),
	('E008', 'We could not find your unsubscription to that campaign.'),
	
	('F001', 'Field is required.'),
	('F002', 'Incorrect URL format. Please input in http://www.yoursite.com/ format.'),
	('F003', 'Incorrect email format.'),
	('F004', 'The following errors occurred while trying to process your form:'),
	('F005', 'Must be letters and numbers only.'),
	('F006', 'Must be letters only.'),
	('F007', 'Must be numbers only.'),
	('F008', 'Cannot be longer than %max% characters.'),
	('F009', 'Cannot be shorter than %min% characters.'),
	('F010', 'You must be logged in to use this form.'),
	('F011', 'Username is already taken.'),
	('F012', 'Your password is not strong enough.'),
	('F013', 'Registration code has already been used.'),
	('F014', 'Registration code is not valid for this form.'),
	('F015', 'Registration code is invalid.'),
	('F016', 'Your form session is either complete or invalid.'),
	('F017', 'No session submitted with the form.'),
	('F018', 'Please do not skip ahead in the form process.'),
	('F019', 'Invalid characters submitted. Please ensure that only alphanumeric characters are used, as well as dashes, underscores, and spaces.'),
	('F020', 'We apologize, but the information that you have submitted makes you ineligible to complete this form. \r\n\r\nIssue: %field_name% %field_eq% %field_value%\r\n\r\nPlease let us know if you believe this is an error.'),
	('F021', 'must equal'),
	('F022', 'cannot equal'),
	('F023', 'must be similar to'),
	('F024', 'must be above'),
	('F025', 'must be below'),
	('F026', 'must be equal to or above'),
	('F027', 'must be less than or equal to'),
	('F028', 'The form you have selected is not a valid form.'),
	('F029', 'The form you have selected is not currently available.'),
	('F030', 'Membership Option'),
	('F031', 'Preview'),
	('F032', 'Payment'),
	('F033', 'Please go back and select a membership option.'),
	('F034', 'We apologize, but you have met a condition which has forced us to prevent further submission of this form. In this case, \"%field%\" cannot be \"%value%\".'),
	('F035', 'You must be logged in to access this form.'),
	('F036', 'Information received - thank you!'),
	('F037', 'Information received, however more information is required. Please complete the form below to continue.'),
	('F038', 'Information received!'),
	('F039', 'One or more items in your cart requires additional information to complete the order. Please submit this information below.'),
	('F040', 'Incorrect CAPTCHA submitted. Please go back and try again!'),
	('F041', 'Your passwords did not match.'),
	('F042', 'Your username cannot match your password.'),
	('F043', 'You cannot edit your cart while in the process of registering.'),
	
	('G001', 'Add a Card'),
	('G002', 'Delete Card'),
	
	('I001', 'Bill Credit'),
	('I002', 'Savings code %code%'),
	('I003', 'Hourly work.'),
	('I004', 'No shipping required.'),
	('I005', 'Click here to pay this invoice'),
	('I006', 'Could not find invoice.'),
	('I007', 'Could not load invoice.'),
	('I008', 'The amount entered is not a valid amount.'),
	('I009', 'Not all required information was submitted  to make a payment on this invoice.'),
	('I010', 'Unpaid'),
	('I011', 'Paid'),
	('I012', 'Partially Paid'),
	('I013', 'Overdue'),
	('I014', 'Overdue with Unresponsive Client'),
	('I015', 'Dead'),
	('I016', 'You cannot modify the quantity on an invoice payment.'),
	('I017', 'Invoice payment canceled.'),
	
	('L001', 'Please log in to access the member portal.'),
	('L002', 'Your session has ended.'),
	('L003', 'Your session has expired due to inactivity.'),
	('L004', 'You must be logged in to view this calendar.'),
	('L005', 'Login Error'),
	('L006', 'Invalid login credentials.'),
	('L007', 'Your account has been suspended for the following reason: %reason%'),
	('L008', 'Your account has been rejected for the following reason: %reason%'),
	('L009', 'Your account is pending e-mail confirmation. <a href=\"%link%\">Click here</a> to re-send your activation code.'),
	('L010', 'Your account is pending administrative activation. You will be notified when a decision has been made.'),
	('L011', 'Your account is inactive due to inactivitiy. <a href=\"%link%\">Click here</a> to re-activate it.'),
	('L012', 'Your account is locked until %locked_date% due to excessive failed login attempts.'),
	('L013', 'Incorrect CAPTCHA submitted.'),
	('L014', 'Activation code is incorrect or your account is already active.'),
	('L015', 'Please input a username and password to login.'),
	('L016', 'Please log into your account to access this content. If you are logged in already and are seeing this message, please ensure that you have access to the content that you are trying to access.'),
	('L017', 'Invalid session cookie.'),
	('L018', 'Your account has been updated!'),
	('L019', 'Account is pending payment.'),
	('L020', 'Please input your email or member number to reset your password.'),
	('L021', 'The email or member number submitted could not be found.'),
	('L022', 'We have emailed you information on reseting your password. Please check your email.'),
	('L023', 'Your password cannot be reset because you do not have an email associated with your account. Please contact us for help resetting your password.'),
	('L024', 'Your password reset code is invalid.'),
	('L025', 'Please ensure the new passwords match to complete the process.'),
	('L026', 'Your password has been reset.'),
	('L027', 'You are either not logged in, or you are not permitted to view the content you are attempting to access.'),
	('L028', 'Your membership has been inactive for %inactive_days%.'),
	('L029', 'Please log in to complete the requested form.'),
	('L030', 'Concurrent logins to the same account are prohibited.'),
	('L031', 'Your membership has been suspended due to concurrent logins.'),
	('L032', 'Miscellaneous'),
	('L033', 'Your form session is invalid or corrupt. Please try again.'),
	('L034', 'Current password is incorrect.'),
	('L035', 'Please log in to access this post.'),
	
	('N001', 'Could not confirm campaign subscription.'),
	('N002', 'Could not find campaign.'),
	
	('S001', 'We apologize, but there is not enough stock to satisfy your order.'),
	('S002', 'You are only permitted to add %number% unit(s) of this item into your cart.'),
	('S003', 'You must be a member to use the selected promotional code.'),
	('S004', 'The promotional code that you are trying to use has expired.'),
	('S005', 'Promotion is not yet available.'),
	('S006', 'The maximum uses for that promotional code has been reached.'),
	('S007', 'Your personal usage limit for that promotional code has been reached.'),
	('S008', 'Product requirements have not been met for using this code. Code was not applied.'),
	('S009', 'Add items into your cart to checkout.'),
	('S010', 'There are not any products in your cart.'),
	('S011', 'You must agree to the terms and conditions to continue!'),
	('S012', 'Please select a shipping and handling option!'),
	('S013', 'Subscription canceled due to excessive failed transactions.'),
	('S014', 'No payment methods have been selected. This order cannot be completed. Please contact the site owner.'),
	('S015', 'Error Processing Transaction'),
	('S017', 'Cart Error'),
	('S016', 'The following error occurred while attempting to process your transaction: %gateway_message% (Code: %gateway_code%). <a href=\"#\" onclick=\"history.go(-2);return false;\">Click here</a> to go back and try again.'),
	('S018', 'You cart is empty. <a href=\"%pp_url%/cart.php\">Click here</a> to add some products.'),
	('S019', 'An SSL connection is required to use this page.'),
	('S020', 'Please log in to view the cart catalog.'),
	('S021', 'Please log in to view your shopping cart.'),
	('S022', 'Please log in to checkout.'),
	('S023', 'No subcategories'),
	('S024', 'The product that you are trying to access could not be found or is not accessible at this time.'),
	('S025', 'The category that you are trying to access could not be found or is not accessible at this time.'),
	('S026', 'Promotional code does not exist.'),
	('S027', 'This promotional code requires a cart minimum of %minimum%.'),
	('S028', '<fieldset class=\"zen\" style=\"display:block;\"><legend class=\"zen\">Shipping Information</legend>\r\n<p class=\"zen_gray\">No shipping is required for this order.</p>\r\n</fieldset>'),
	('S029', 'Please select a payment method for this order.'),
	('S030', 'The order that you are trying to view could not be found.'),
	('S031', 'Please log into your account to view this order.'),
	('S032', 'Shipped on %ship_date% via %ship_provider%.'),
	('S033', 'Has not shipped.'),
	('S034', 'Tracking number %tracking%.'),
	('S035', 'Tracking unavailable.'),
	('S036', 'Track your package'),
	('S037', 'Tracking link unavailable'),
	('S038', 'Credit card not found.'),
	('S039', 'We could not find a credit card for this subscription.'),
	('S040', 'This subscription has failed to charge %retry% time(s).'),
	('S041', 'Error adding or updating credit card: %gateway_message% (Code %gateway_code%)'),
	('S042', 'Could not load subscription.'),
	('S043', 'You cannot edit that credit card.'),
	('S044', 'Your credit card has been successfully updated.'),
	('S045', 'Credit card has been successfully added.'),
	('S046', 'Invoice for your recently failed subscription renewal.'),
	('S050', 'Canceled'),
	('S051', 'You must be logged into your membership account to purchase this product.'),
	('S052', 'Cancel'),
	('S053', 'Could not cancel subscription: not found or invalid authorization key.'),
	('S054', 'Re-activate'),
	('S055', 'Active'),
	('S056', 'Active (In Trial Period)'),
	('S057', 'Change Plan'),
	('S058', 'All upgrades will be pro-rated, meaning that your renewal date will not change, but you will be charged the difference today.'),
	('S059', 'This subscription cannot be upgraded.'),
	('S060', 'Invalid request.'),
	('S061', 'Your subscription has been canceled.'),
	('S062', 'Your subscription has been changed.'),
	('S063', 'You have selected your existing product: please select a different product.'),
	('S064', 'You must have a credit card on file to upgrade a subscription online. Please contact us for additional options.'),
	('S065', 'By clicking OK below, you confirm that you wish to %type% your plan at the cost of %cost_today% (billed today). Your next regular renewal will be for %next_cost% on %next_renew%.'),
	('S066', 'This product requires a minimum purchase of %minimum% units.'),
	('S067', 'This product is unavailable at this time.'),
	('S068', 'Product has been added to your cart!'),
	('S070', 'No card on file. You will be invoiced unless you add one below.'),
	
	('W001', 'Widget (%id%) does not exist.'),
	('W002', 'Widget (%id%) is not active.'),
	('W003', 'Could not find PHP code widget (%id%).'),
	('W004', 'The page you are trying to access does not exist.'),
	
	('Z001', 'Success'),
	('Z002', 'Pending Payment'),
	('Z003', 'Partially Refunded'),
	('Z004', 'Refunded'),
	('Z005', 'Failed: %reason%');
";
$inserts[] = "
	INSERT INTO `ppSD_fields` (`id`, `display_name`, `type`, `special_type`, `logic`, `logic_dependent`, `desc`, `label_position`, `options`, `styling`, `default_value`, `encrypted`, `sensitive`, `maxlength`, `settings`, `permissions_group`, `primary`, `static`, `data_type`, `min_len`, `scope_member`, `scope_contact`, `scope_rsvp`, `scope_account`) VALUES
	('title', 'Title', 'select', '', 0, 0, '', 'left', 'Mr\nMrs\nMiss\nMs\nMx\nJr\nSr\nMaster\nHon\nSir\nDame\nDr\nProf', 'width: 100px;', '', 0, 0, 10, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('first_name', 'First Name', 'text', '', 0, 0, '', 'left', '', 'width: 225px;', '', 0, 0, 40, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('middle_name', 'Middle Name', 'text', '', 0, 0, '', 'left', '', 'width: 225px;', '', 0, 0, 40, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('last_name', 'Last Name', 'text', '', 0, 0, '', 'left', '', 'width: 225px;', '', 0, 0, 40, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('address_line_1', 'Address Line 1', 'text', '', 0, 0, '', 'left', '', 'width: 250px;', '', 0, 0, 80, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('address_line_2', 'Address Line 2', 'text', '', 0, 0, '', 'left', '', 'width: 250px;', '', 0, 0, 30, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('city', 'City', 'text', '', 0, 0, '', 'left', '', '', '', 0, 0, 40, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('state', 'State', 'select', 'state', 0, 0, '', 'left', '', '', '', 0, 0, 3, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('zip', 'Zip/Postal', 'text', '', 0, 0, '', 'left', '', '', '', 0, 0, 10, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('country', 'Country', 'select', 'country', 0, 0, '', 'left', '', '', '', 0, 0, 35, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('phone', 'Primary Phone', 'text', 'phone', 0, 0, '', 'left', '', 'width:175px;', '', 0, 0, 20, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('cell', 'Cell Phone', 'text', 'phone', 0, 0, '', 'left', '', '', '', 0, 0, 20, '', 0, 0, 1, 0, 0, 1, 1, 1, 0),
	('office_phone', 'Office Phone', 'text', 'phone', 0, 0, '', 'left', '', '', '', 0, 0, 20, '', 0, 0, 1, 0, 0, 1, 1, 0, 1),
	('alt_phone', 'Alternate Phone', 'text', 'phone', 0, 0, '', 'left', '', '', '', 0, 0, 20, '', 0, 0, 1, 0, 0, 1, 1, 0, 1),
	('cell_carrier', 'Cell Carrier', 'select', 'cell_carriers', 0, 0, '', 'left', '', '', '', 0, 0, 25, '', 0, 0, 1, 0, 0, 1, 1, 1, 0),
	('gender', 'Gender', 'select', '', 0, 0, '', 'left', 'Male\nFemale\nOther', 'width: 100px;', '', 0, 0, 10, '', 0, 0, 1, 0, 0, 1, 1, 1, 1),
	('username', 'Username', 'text', '', 0, 0, '', 'left', '', '', '', 0, 0, 100, '', 0, 1, 1, 0, 0, 0, 0, 0, 0),
	('password', 'Password', 'text', 'password', 0, 0, '', 'left', '', '', '', 0, 1, 50, '', 0, 1, 1, 0, 0, 0, 0, 0, 0),
	('repeat_pwd', 'Repeat Password', 'text', 'password', 0, 0, '', 'left', '', '', '', 0, 1, 50, '', 0, 1, 1, 0, 0, 0, 0, 0, 0),
	('email', 'E-Mail', 'text', 'email', 0, 0, '', 'left', '', 'width:250px;', '', 0, 0, 110, '', 0, 1, 1, 0, 0, 0, 0, 0, 0),
	('alt_email1', 'Alternate Email No. 1', 'text', 'email', 0, 0, '', 'left', '', '', '', 0, 0, 110, '', 0, 0, 1, 0, 0, 0, 1, 1, 0),
	('alt_email2', 'Alternate E-Mail No. 2', 'text', 'email', 0, 0, '', 'left', '', '', '', 0, 0, 110, '', 0, 0, 1, 0, 0, 0, 0, 0, 0),
	('alt_email3', 'Alternate E-Mail No. 3', 'text', 'email', 0, 0, '', 'left', '', '', '', 0, 0, 110, '', 0, 0, 1, 0, 0, 0, 0, 0, 0),
	('company_name', 'Company Name', 'text', '', 0, 0, '', 'left', '', '', '', 0, 0, 50, '', 0, 0, 1, 0, 0, 0, 1, 0, 1),
	('url', 'Website', 'text', 'url', 0, 0, '', 'left', '', '', '', 0, 0, 100, '', 0, 0, 1, 0, 0, 0, 1, 0, 1),
	('facebook', 'Facebook Profile', 'text', 'url', 0, 0, 'Enter your full Facebook Profile URL:<br />http://www.facebook.com/<b>username</b>', 'left', '', '', '', 0, 0, 100, '', 0, 0, 1, 0, 0, 1, 1, 0, 1),
	('twitter', 'Twitter Profile', 'text', 'url', 0, 0, 'Enter your full Twitter Profile URL:<br />http://www.twitter.com/<b>username</b>', 'left', '', '', '', 0, 0, 80, '', 0, 0, 1, 0, 0, 1, 1, 0, 1),
	('email_optout', 'E-Mail Opt Out', 'checkbox', '', 0, 0, 'Check the box to opt-out of e-mails.', 'left', '', '', '', 0, 0, 0, '', 0, 0, 1, 0, 0, 1, 1, 0, 1),
	('linkedin', 'Linked In Profile', 'text', 'url', 0, 0, 'Enter your full LinkedIn Profile URL:<br />http://www.linkedin.com/pub/<b>Profile</b>', 'left', '', '', '', 0, 0, 100, '', 0, 0, 1, 0, 0, 1, 1, 0, 1),
	('dob', 'Date of Birth', 'date', 'date', 0, 0, '', 'left', '', '', '', 0, 0, 0, '', 0, 0, 1, 0, 0, 0, 1, 0, 0),
	('occupation', 'Occupation', 'text', '', 0, 0, '', 'left', '', '', '', 0, 0, 0, '', 0, 0, 1, 0, 0, 0, 1, 0, 0),
	('industry', 'Industry', 'select', '', 0, 0, '', 'left', 'Apparel\r\nBanking\r\nBiotechnology\r\nChemicals\r\nCommunication\r\nConstruction\r\nConsulting\r\nEducation\r\nElectronics\r\nEnergy\r\nEngineering\r\nEntertainment\r\nEnvironmental\r\nFinance\r\nGovernment\r\nHealthcare\r\nHospitality\r\nInsurance\r\nMachinery\r\nManufacturing\r\nMedia\r\nNon-Profit\r\nRecreation\r\nRetail\r\nShipping\r\nTechnology\r\nTelecommunications\r\nTransportation\r\nUtilities\r\nOther', '', '', 0, 0, 0, '', 0, 0, 1, 0, 0, 0, 0, 0, 1),
	('account_type', 'Type', 'select', '', 0, 0, '', 'left', 'Analyst\r\nCompetitor\r\nCustomer\r\nIntegrator\r\nInvestor\r\nPartner\r\nPress\r\nProspect\r\nReseller\r\nOther', '', '', 0, 0, 0, '', 0, 0, 1, 0, 0, 0, 0, 0, 1),
	('fax', 'Fax', 'text', 'phone', 0, 0, '', 'left', '', '', '', 0, 0, 0, '', 0, 0, 1, 0, 0, 1, 1, 0, 1),
	('sms_optout', 'SMS Optout', 'checkbox', '', 0, 0, 'Check the box to opt-out of SMS text messages.', 'left', '', '', '', 0, 0, 0, '', 0, 0, 1, 0, 0, 1, 1, 1, 0),
	('cc_number', 'Number', 'text', 'cc', 0, 0, 'Enter without any spaces or dashes.', 'left', '', 'width:250px;', '', 0, 0, 16, '', 0, 1, 1, 3, 15, 0, 0, 0, 0),
	('card_exp', 'Expiration', 'text', 'cc_expiration', 0, 0, 'Enter as MM/YY', 'left', '', 'width:60px;', '', 0, 0, 2, '', 0, 1, 1, 3, 2, 0, 0, 0, 0),
	('cvv', 'CVV Code', 'text', '', 0, 0, 'A three or four digit verification code printed directly on your credit card.', 'left', '', 'width:60px;', '', 0, 0, 4, '', 0, 1, 1, 3, 3, 0, 0, 0, 0),
	('name_on_card', 'Name on Card', 'text', '', 0, 0, '', 'left', '', '', '', 0, 0, 0, '', 0, 1, 1, 0, 0, 0, 0, 0, 0),
	('accttype', 'Account Type', 'select', '', 0, 0, 'What type of account is this?', 'left', 'Personal Checking\r\nBusiness Checking\r\nSavings', '', '', 0, 0, 0, '', 0, 1, 1, 0, 0, 0, 0, 0, 0),
	('bank_name', 'Bank Name', 'text', '', 0, 0, 'Input the name of the bank to which this account belongs.', '', 'width:250px;', '', '', 0, 0, 0, '', 0, 1, 1, 0, 0, 0, 0, 0, 0),
	('bank_routing', 'Routing Number', 'text', '', 0, 0, 'Input the bank''s nine digit routing number. This appears on the check below the memo line.', 'left', '', 'width:250px;', '', 0, 0, 9, '', 0, 1, 1, 3, 9, 0, 0, 0, 0),
	('bank_account_name', 'Account Name', 'text', '', 0, 0, 'Input a name for this account.', 'left', '', 'width:250px;', '', 0, 0, 0, '', 0, 1, 1, 0, 0, 0, 0, 0, 0),
	('bank_account_number', 'Account Number', 'text', '', 0, 0, 'Input the account number. This appears on the check below the memo line, to the right of the routing number.', 'left', '', 'width:250px;', '', 0, 0, 25, '', 0, 1, 1, 3, 0, 0, 0, 0, 0),
	('invoice_memo', 'Memo', 'textarea', '', 0, 0, 'Any special requests or directions.', 'top', '', 'width: 100%;\r\nheight: 125px;', '', 0, 0, 0, '', 0, 1, 1, 0, 0, 0, 0, 0, 0),
	('driver_license_state', 'Driver''s License State', 'select', 'state', 0, 0, '', 'left', '', 'width:80px;', '', 0, 0, 0, '', 0, 1, 1, 0, 0, 0, 0, 0, 0),
	('driver_license_no', 'Driver''s License Number', 'text', '', 0, 0, '', 'left', '', 'width:250px;', '', 0, 0, 0, '', 0, 1, 1, 0, 0, 0, 0, 0, 0),
	('check_no', 'Check Number', 'text', '', 0, 0, '', 'left', '', 'width:100px;', '', 0, 0, 10, '', 0, 1, 1, 3, 0, 0, 0, 0, 0),
	('ship_directions', 'Special Directions', 'textarea', '', 0, 0, '', 'left', '', 'width:100%;height:50px;', '', 0, 0, 0, '', 0, 1, 1, 0, 0, 0, 0, 0, 0);
";

$inserts[] = "
	INSERT INTO `ppSD_fieldsets` (`id`, `name`, `desc`, `order`, `columns`, `logic_dependent`, `static`, `owner`, `billing`) VALUES
	(1, 'Contact Information', '', 1, 1, 0, 1, 0, 0),
	(2, 'Phones', '', 2, 1, 0, 1, 0, 0),
	(3, 'Company Details', '', 3, 1, 0, 1, 0, 0),
	(4, 'Social Media', 'Inputing this data will activate social media features for this user.', 2, 1, 0, 1, 0, 0),
	(5, 'Account Overview', '', 1, 1, 0, 1, 0, 0),
	(6, 'Account Specifics', '', 2, 1, 0, 1, 0, 0),
	(7, 'Cell Phone', 'If a cell phone and cell carrier are provided, SMS features will become available.', 4, 1, 0, 1, 0, 0),
	(8, 'Registration Basics', '', 1, 1, 0, 0, 0, 0),
	(9, 'Credit Card Details', '', 1, 1, 0, 1, 0, 1),
	(11, 'Billing Information', '', 1, 1, 0, 1, 0, 1),
	(12, 'Check Details', '', 1, 1, 0, 1, 0, 1),
	(13, 'Invoice Details', '', 1, 1, 0, 1, 0, 1),
	(14, 'Shipping Information', '', 1, 1, 0, 1, 0, 0),
	(15, 'Password', '', 1, 1, 0, 1, 0, 0),
	(22, 'Password Update', 'Would you like to update your password?', 1, 1, 0, 1, 0, 0),
	(17, 'Username Selection', 'Please select a username and password for your account.', 1, 1, 0, 1, 0, 0),
	(18, 'Miscellaneous Member Fields', '', 999, 1, 0, 1, 0, 0),
	(19, 'Miscellaneous Contact Fields', '', 999, 1, 0, 1, 0, 0),
	(20, 'Miscellaneous Account Fields', '', 999, 1, 0, 1, 0, 0),
	(21, 'Miscellaneous RSVP Fields', '', 999, 1, 0, 1, 0, 0);
";

$inserts[] = "
	INSERT INTO `ppSD_fieldsets_fields` (`fieldset`, `field`, `order`, `req`, `column`, `tabindex`, `autoadd_product`, `autoadd_value`) VALUES
	(1, 'title', 0, 0, 1, 1, '', ''),
	(1, 'first_name', 1, 1, 1, 1, '', ''),
	(1, 'middle_name', 2, 0, 1, 2, '', ''),
	(1, 'last_name', 3, 1, 1, 2, '', ''),
	(1, 'address_line_1', 5, 1, 1, 0, '', ''),
	(1, 'address_line_2', 6, 0, 1, 0, '', ''),
	(1, 'city', 7, 1, 1, 0, '', ''),
	(1, 'state', 8, 1, 1, 0, '', ''),
	(1, 'zip', 9, 1, 1, 0, '', ''),
	(1, 'country', 10, 1, 1, 0, '', ''),
	(1, 'email', 11, 1, 1, 0, '', ''),
	(1, 'phone', 12, 0, 1, 0, '', ''),
	(1, 'gender', 13, 0, 1, 1, '', ''),

	(2, 'phone', 1, 0, 1, 0, '', ''),
	(2, 'office_phone', 2, 0, 1, 0, '', ''),
	(2, 'alt_phone', 3, 0, 1, 0, '', ''),
	(2, 'fax', 4, 0, 1, 0, '', ''),
	(2, 'cell', 5, 0, 1, 0, '', ''),
	(2, 'cell_carrier', 6, 0, 1, 0, '', ''),
	(2, 'sms_optout', 7, 0, 1, 0, '', ''),

	(3, 'company_name', 1, 0, 1, 0, '', ''),
	(3, 'url', 2, 0, 1, 0, '', ''),
	(3, 'occupation', 3, 0, 1, 0, '', ''),

	(4, 'facebook', 1, 0, 1, 0, '', ''),
	(4, 'twitter', 2, 0, 1, 0, '', ''),
	(4, 'linkedin', 3, 0, 1, 0, '', ''),

	(5, 'company_name', 1, 1, 1, 0, '', ''),
	(5, 'url', 9, 0, 1, 0, '', ''),
	(5, 'address_line_1', 3, 0, 1, 0, '', ''),
	(5, 'address_line_2', 4, 0, 1, 0, '', ''),
	(5, 'city', 5, 0, 1, 0, '', ''),
	(5, 'state', 6, 0, 1, 0, '', ''),
	(5, 'zip', 7, 0, 1, 0, '', ''),
	(5, 'country', 8, 0, 1, 0, '', ''),
	(6, 'industry', 2, 0, 1, 0, '', ''),
	(6, 'account_type', 1, 0, 1, 0, '', ''),

	(7, 'cell', 2, 0, 1, 0, '', ''),
	(7, 'cell_carrier', 3, 0, 1, 0, '', ''),
	(7, 'sms_optout', 3, 0, 1, 0, '', ''),

	(8, 'username', 1, 1, 1, 0, '', ''),
	(8, 'password', 2, 1, 1, 0, '', ''),
	(8, 'repeat_pwd', 3, 1, 1, 0, '', ''),
	(8, 'first_name', 4, 1, 1, 0, '', ''),
	(8, 'last_name', 5, 1, 1, 0, '', ''),
	(8, 'email', 6, 1, 1, 0, '', ''),

	(9, 'cc_number', 2, 1, 1, 0, '', ''),
	(9, 'card_exp', 3, 1, 1, 0, '', ''),
	(9, 'cvv', 4, 1, 1, 0, '', ''),

	(11, 'first_name', 1, 1, 1, 0, '', ''),
	(11, 'last_name', 2, 1, 1, 0, '', ''),
	(11, 'address_line_1', 3, 0, 1, 0, '', ''),
	(11, 'address_line_2', 4, 0, 1, 0, '', ''),
	(11, 'city', 5, 0, 1, 0, '', ''),
	(11, 'state', 6, 0, 1, 0, '', ''),
	(11, 'zip', 7, 0, 1, 0, '', ''),
	(11, 'country', 8, 0, 1, 0, '', ''),
	(11, 'email', 9, 1, 1, 0, '', ''),
	(11, 'phone', 10, 0, 1, 0, '', ''),

	(12, 'accttype', 1, 1, 1, 0, '', ''),
	(12, 'bank_name', 2, 1, 1, 0, '', ''),
	(12, 'bank_routing', 4, 1, 1, 0, '', ''),
	(12, 'bank_account_name', 3, 1, 1, 0, '', ''),
	(12, 'bank_account_number', 5, 1, 1, 0, '', ''),
    (12, 'driver_license_no', 6, 1, 1, 0, '', ''),
	(12, 'driver_license_state', 7, 1, 1, 0, '', ''),
	(12, 'check_no', 8, 1, 1, 0, '', ''),

	(13, 'invoice_memo', 1, 0, 1, 0, '', ''),

	(14, 'first_name', 1, 1, 1, 0, '', ''),
	(14, 'last_name', 2, 1, 1, 0, '', ''),
	(14, 'address_line_1', 3, 1, 1, 0, '', ''),
	(14, 'address_line_2', 4, 0, 1, 0, '', ''),
	(14, 'city', 5, 1, 1, 0, '', ''),
	(14, 'state', 6, 1, 1, 0, '', ''),
	(14, 'zip', 7, 1, 1, 0, '', ''),
	(14, 'country', 8, 1, 1, 1, '', ''),
	(14, 'ship_directions', 9, 0, 1, 0, '', ''),

	(15, 'password', 2, 1, 1, 0, '', ''),
	(15, 'repeat_pwd', 3, 1, 1, 0, '', ''),

	(22, 'password', 2, 0, 1, 0, '', ''),
	(22, 'repeat_pwd', 3, 0, 1, 0, '', ''),

	(17, 'username', 1, 1, 1, 0, '', ''),
	(17, 'password', 2, 1, 1, 0, '', ''),
	(17, 'repeat_pwd', 3, 1, 1, 0, '', '');
";
$inserts[] = "
	INSERT INTO `ppSD_fieldsets_locations` (`location`, `order`, `col`, `fieldset_id`) VALUES
	('contact-add', 1, 2, 3),
	('contact-add', 2, 1, 2),
	('contact-add', 3, 1, 1),
	('contact-add', 4, 2, 4),
	('contact-add', 5, 2, 19),
	('contact-edit', 1, 2, 3),
	('contact-edit', 2, 1, 2),
	('contact-edit', 3, 1, 1),
	('contact-edit', 4, 2, 4),
	('contact-edit', 5, 1, 7),
	('contact-edit', 6, 2, 19),
	('contact-add', 3, 1, 7),
	('member-add', 3, 1, 7),
	('member-edit', 3, 1, 7),
	('member-add', 1, 2, 1),
	('member-edit', 1, 2, 1),
	('member-add', 2, 1, 2),
	('member-edit', 2, 1, 2),
	('member-add', 4, 2, 18),
	('member-edit', 4, 2, 18),
	('account-add', 1, 1, 5),
	('account-add', 1, 2, 6),
	('account-add', 2, 1, 2),
	('account-add', 2, 2, 4),
	('account-edit', 1, 1, 5),
	('account-edit', 2, 1, 6),
	('account-edit', 2, 1, 2),
	('account-edit', 2, 2, 4),
	('contact-quickadd', 1, 1, 1),
	('payment_form', 1, 1, 9),
	('billing_form', 1, 1, 11),
	('check_form', 1, 1, 12),
	('invoice_form', 1, 1, 13),
	('shipping_form', 1, 1, 14),
	('update-account', 1, 1, 22),
	('update-account', 2, 1, 1),
	('member-add', 1, 1, 17),
	('employee-add', 1, 1, 1),
	('employee-add', 2, 2, 4),
	('employee-add', 2, 1, 2),
	('employee-add', 1, 2, 17),
	('employee-edit', 1, 1, 1),
	('employee-edit', 1, 2, 2),
	('employee-edit', 2, 2, 4),
	('member-add', '1', '1', '4'),
	('member-edit', '1', '1', '4');	
";
//	('employee-edit', 2, 1, 17),
//	('member-edit', 1, 1, 17),
$inserts[] = "
	INSERT INTO `ppSD_forms` (`id`, `type`, `criteria`, `act_id`, `name`, `description`, `code_required`, `date`, `owner`, `public`, `reg_status`, `pages`, `preview`, `step1_name`, `step2_name`, `step3_name`, `step4_name`, `step5_name`, `public_list`, `static`, `disabled`, `account_create`, `terms_id`, `captcha`) VALUES
	('payment_form', 'payment_form', '', '', 'Basic Payment Form', '', 0, '$date', 1, 0, '', 0, 0, '', '', '', '', '', 0, 0, 0, 0, 0, 0),
	('account-add', 'admin_cp', '', '', 'Add Account', '', 0, '$date', 1, 0, '', 0, 0, '', '', '', '', '', 0, 1, 0, 0, 0, 0),
	('account-edit', 'admin_cp', '', '', 'Edit Account', '', 0, '$date', 1, 0, '', 0, 0, '', '', '', '', '', 0, 1, 0, 0, 0, 0),
	('member-add', 'admin_cp', '', '', 'Add Member', '', 0, '$date', 1, 1, '', 0, 0, '', '', '', '', '', 0, 1, 0, 0, 0, 0),
	('member-edit', 'admin_cp', '', '', 'Edit Member', '', 0, '$date', 1, 1, '', 0, 0, '', '', '', '', '', 0, 1, 0, 0, 0, 0),
	('contact-add', 'admin_cp', '', '', 'Add Contact', '', 0, '$date', 1, 1, '', 0, 0, '', '', '', '', '', 0, 1, 0, 0, 0, 0),
	('contact-edit', 'admin_cp', '', '', 'Edit Contact', '', 0, '$date', 1, 1, '', 0, 0, '', '', '', '', '', 0, 1, 0, 0, 0, 0),
	('employee-add', 'admin_cp', '', '', 'Add Employee', '', 0, '$date', 1, 1, '', 0, 0, '', '', '', '', '', 0, 1, 0, 0, 0, 0),
	('employee-edit', 'admin_cp', '', '', 'Edit Employee', '', 0, '$date', 1, 1, '', 0, 0, '', '', '', '', '', 0, 1, 0, 0, 0, 0),
	('update-account', 'update_account', '', '', 'Basic Account Update', '', 0, '$date', 1, 1, '', 1, 0, '', '', '', '', '', 0, 1, 0, 0, 0, 0),
    ('billing_form',  'admin_cp',  '',  '',  'Billing Form',  '',  '',  '',  '1',  '0',  '',  '',  '',  '',  '',  '',  '',  '',  '',  '',  '1',  '',  '',  '');
";
$inserts[] = "
	INSERT INTO `ppSD_homepage_widgets` (`id`, `options`, `title`, `perms`, `static`, `employee`, `add_fields`, `hide`) VALUES
	('members', 'a:6:{s:5:\"limit\";s:1:\"5\";s:4:\"unit\";s:3:\"day\";s:10:\"increments\";s:1:\"7\";s:5:\"graph\";s:1:\"1\";s:4:\"list\";s:1:\"1\";s:6:\"fields\";a:3:{i:0;s:8:\"username\";i:1;s:6:\"source\";i:2;s:6:\"joined\";}}', 'Recent Members', 'all', 1, 0, '', 0),
	('transactions', 'a:5:{s:5:\"limit\";s:1:\"5\";s:4:\"unit\";s:3:\"day\";s:10:\"increments\";s:1:\"7\";s:5:\"graph\";s:1:\"1\";s:4:\"list\";s:1:\"1\";}', 'Recent Transactions', 'all', 1, 0, '', 0),
	('subscriptions_soon', 'a:5:{s:5:\"limit\";s:1:\"5\";s:4:\"unit\";s:3:\"day\";s:10:\"increments\";s:1:\"7\";s:5:\"graph\";s:1:\"1\";s:4:\"list\";s:1:\"1\";}', 'Upcoming Subscriptions', 'all', 1, 0, '', 0),
	('rsvps', 'a:6:{s:5:\"limit\";s:1:\"5\";s:4:\"unit\";s:3:\"day\";s:10:\"increments\";s:1:\"7\";s:5:\"graph\";s:1:\"1\";s:4:\"list\";s:1:\"1\";s:6:\"fields\";a:4:{i:0;s:9:\"last_name\";i:1;s:10:\"first_name\";i:2;s:8:\"event_id\";i:3;s:6:\"status\";}}', 'Recent Event Registrations', 'all', 1, 0, '', 0),
	('logins', 'a:4:{s:5:\"limit\";s:2:\"10\";s:4:\"unit\";s:3:\"day\";s:10:\"increments\";s:1:\"7\";s:5:\"graph\";s:1:\"1\";}', 'Recent Logins', 'all', 1, 0, '', 0),
	('invoices', 'a:5:{s:5:\"limit\";s:1:\"5\";s:4:\"unit\";s:3:\"day\";s:10:\"increments\";s:1:\"7\";s:5:\"graph\";s:1:\"1\";s:4:\"list\";s:1:\"1\";}', 'Invoice Overview and Overdue Invoices', 'all', 1, 0, '', 0),
	('contacts', 'a:6:{s:5:\"limit\";s:1:\"5\";s:4:\"unit\";s:3:\"day\";s:10:\"increments\";s:1:\"7\";s:5:\"graph\";s:1:\"1\";s:4:\"list\";s:1:\"1\";s:6:\"fields\";a:4:{i:0;s:9:\"last_name\";i:1;s:10:\"first_name\";i:2;s:6:\"source\";i:3;s:5:\"owner\";}}', 'Recent Contacts', 'all', 1, 0, '', 0),
	('notes', 'a:2:{s:5:\"limit\";s:2:\"10\";s:6:\"labels\";a:2:{i:0;s:1:\"2\";i:1;s:1:\"5\";}}', 'Notes', 'all', 1, 0, '', 1),
    ('calendar', 'a:2:{s:7:\"options\";a:0:{}s:7:\"display\";a:5:{i:0;s:5:\"sales\";i:1;s:7:\"revenue\";i:2;s:8:\"contacts\";i:3;s:7:\"members\";i:4;s:5:\"rsvps\";}}', 'Overview Calendar', 'all', 1, 0, '', 0);
";
/*
	('employee_sales', 'a:3:{s:5:\"limit\";s:2:\"10\";s:5:\"range\";s:12:\"000100000000\";s:5:\"graph\";s:1:\"1\";}', 'Employee Conversion Value', 'admin', 1, 0, '', 1),
	('employee_conversions', 'a:3:{s:5:\"limit\";s:2:\"10\";s:5:\"range\";s:12:\"000100000000\";s:5:\"graph\";s:1:\"1\";}', 'Employee Conversions', 'admin', 1, 0, '', 1),
	('emails_opened', 'a:4:{s:5:\"limit\";s:2:\"10\";s:4:\"unit\";s:3:\"day\";s:10:\"increments\";s:1:\"7\";s:5:\"graph\";s:1:\"1\";}', 'E-Mails Opened', 'all', 1, 0, '', 1),
	('overdue_contacts', 'a:2:{s:5:\"limit\";s:2:\"20\";s:5:\"graph\";s:1:\"0\";}', 'Overdue Contacts', 'all', 1, 0, '', 1),
	('registrations', '', 'Registrations', 'all', 1, 0, '', 1),
	('registrations_by_form', '', 'Registration By Form', 'all', 1, 0, '', 1),
	('members_pending_approval', '', 'Members Pending Approval', 'admin', 1, 0, '', 1),
	('campaign_subscriptions', '', 'Campaign Subscriptions', 'all', 1, 0, '', 1),
	('contacts_unassigned', 'a:5:{s:5:\"limit\";s:2:\"10\";s:4:\"unit\";s:3:\"day\";s:10:\"increments\";s:1:\"7\";s:5:\"graph\";s:1:\"1\";s:6:\"fields\";a:3:{i:0;s:9:\"last_name\";i:1;s:10:\"first_name\";i:2;s:6:\"source\";}}', 'Unassigned Contacts', 'admin', 1, 0, '', 1),
	('invoices_upcoming', 'a:5:{s:5:\"limit\";s:1:\"5\";s:4:\"unit\";s:3:\"day\";s:10:\"increments\";s:1:\"7\";s:5:\"graph\";s:1:\"1\";s:4:\"list\";s:1:\"1\";}', 'Upcoming Invoice', 'all', 1, 0, '', 1);
*/
/*
$inserts[] = "
	INSERT INTO `ppSD_plugins` (`id`, `status`, `date`, `path`, `db`, `db_host`, `db_user`, `db_pass`, `login`, `logout`, `table_prefix`, `options_array`) VALUES
	('mybb', 0, '1920-01-01 00:01:01', '', '', '', '', '', 1, 1, '', ''),
	('phpbb3', 0, '1920-01-01 00:01:01', '', '', '', '', '', 1, 1, '', ''),
	('wordpress', 0, '1920-01-01 00:01:01', '', '', '', '', '', 1, 1, '', ''),
	('drupal', 0, '1920-01-01 00:01:01', '', '', '', '', '', 1, 1, '', 'a:1:{s:3:\"rid\";s:1:\"3\";}'),
	('joomla', 0, '1920-01-01 00:01:01', '', '', '', '', '', 1, 1, '', ''),
	('kayako', 0, '1920-01-01 00:01:01', '', '', '', '', '', 1, 1, '', '');
";
*/
$inserts[] = "INSERT INTO `ppSD_pipeline` (`id`,`name`,`position`) VALUES (1, 'Contact', 1);";
$inserts[] = "INSERT INTO `ppSD_pipeline` (`id`,`name`,`position`) VALUES (2, 'Lead', 2);";
$inserts[] = "INSERT INTO `ppSD_pipeline` (`id`,`name`,`position`) VALUES (3, 'Opportunity', 3);";
$inserts[] = "INSERT INTO `ppSD_pipeline` (`id`,`name`,`position`) VALUES (4, 'Customer', 4);";

$inserts[] = "INSERT INTO `ppSD_login_announcement_regions` (`id`, `name`, `tag`, `display`) VALUES
    (1, 'Homepage', 'homepage', 5),
	(2, 'Member Dashboard', 'dashboard', 10),
	(3, 'News Page', 'posts_home', 10);
";

/*
	('modxcms_evolution', 0, '1920-01-01 00:01:01', '', '', '', '', '', 1, 1, '', ''),
	('phpfox', 0, '1920-01-01 00:01:01', '', '', '', '', '', 1, 1, '', ''),
	('salesforce', 0, '1920-01-01 00:01:01', '', '', '', '', '', 0, 0, '', ''),
	('ipboard', 0, '1920-01-01 00:01:01', '', '', '', '', '', 1, 1, '', ''),
	('sugarcrm', 0, '1920-01-01 00:01:01', '', '', '', '', '', 0, 0, '', ''),
	('mailchimp', 0, '1920-01-01 00:01:01', '', '', '', '', '', 0, 0, '', ''),
	('tikiwiki', 0, '1920-01-01 00:01:01', '', '', '', '', '', 1, 1, '', ''),
	('typo3', 0, '1920-01-01 00:01:01', '', '', '', '', '', 1, 1, '', ''),
	('sphider', 0, '1920-01-01 00:01:01', '', '', '', '', '', 0, 0, '', 'a:1:{s:4:\"host\";s:17:\"sphider.host.here\";}');
*/
$inserts[] = "
	INSERT INTO `ppSD_note_labels` (`label`, `color`, `fontcolor`, `static_lookup`) VALUES
	('Miscellaneous', 'F1F1F1', '', 'misc'),
	('Important', 'DD1C1A', '', 'important'),
	('Support', 'FC6C58', '', 'support'),
	('Initial Lead Call', '54A7FF', '', 'initial_lead'),
	('Cold Call', '63DBDB', '', 'cold_call'),
	('Phone Followup', 'F7E188', '', 'phone_followup'),
	('E-Mail Received', 'CCC', '', 'emailin'),
	('E-Mail Sent', 'efd64a', '', 'emailout'),
	('E-Mail Followup', 'CB81F0', '', 'email_followup'),
	('Specifications', '85A2A6', '', 'specs'),
	('Services Requested', '0BBF0B', '', 'services_requested'),
	('Services Rendered', '0BBF0B', '', 'services_rendered'),
	('Appointment', 'DD4E3F', 'fff', 'appointment'),
	('To Do', 'FFBF00', '', 'todo');
";
$inserts[] = "
	INSERT INTO `ppSD_member_types` (`name`,`order`) VALUES ('Standard Member','1');
";
// 'options' format:
// Value A:Display A|Value B:Display B|Value C:Display C|etc.
// 'value'
// Standard replacements: %site% => PP_URL
/*
 * ('additional_search_contacts', '', 'phone,fax', 'Make additional custom fields searchable in the quick ajax search.', 'text', 0, '', 'system', 0, ''),
('additional_search_members', '', 'phone,fax', 'Make additional custom fields searchable in the quick ajax search.', 'text', 0, '', 'system', 0, ''),
 */
$inserts[] = "
	INSERT INTO `ppSD_options` (`id`, `display`, `value`, `description`, `type`, `width`, `options`, `section`, `maxlength`, `class`) VALUES
	('sms_from', 'From Line', 'noreply@$domain', 'What address should SMS messages arrive from. This should be an email address.', 'text', 0, '', 'sms', 0, ''),
	('date_format', 'Date Format', 'm/d/Y', 'What date format would you like to use throughout the program&#63; Uses <a href=\"http://documentation.zenbership.com/Options/Date-Formatting\" target=\"_blank\">PHP Date</a> standards.', 'text', 0, '', 'general', 0, ''),
	('phone_format', 'Phone Separator', '.', 'What should separate numbers in a phone number? Only works for 10 digit numbers.', 'text', '50', '', 'general', '1', ''),
	('time_change', 'Time Adjust', '-1', 'Would you like to adjust your system time&#63;', 'select', 80, '-11|-10|-9|-8|-7|-6|-5|-4|-3|-2|-1|0|1|2|3|4|5|6|7|8|9|10|11', 'general', 0, ''),
	('current_version', '', '$version', '', 'text', 0, '', 'system', 0, ''),
	('currency', 'Currency', 'USD', '', 'select', 80, 'USD|EUR|GBP|AUD|CAD|INR|ZAR|NZD|JPY|SGD|CNY|MYR|CHF|THB|IDR|AED|HKD|PHP|SEK|HUF|MXN|RUB', 'cart', 0, ''),
	('member_id_format', 'Member ID Format', 'LLLL-nnnnn-nnnnn', 'Customize the format of member IDs. Recommended: 15-20 characters. L = Upper case letter. l = Lower case letter. n = Number. random = Random Format', 'text', 150, '', 'members', 20, ''),

	('use_email_as_username', 'Use E-Mail As Username?', '0', 'Would you like to use an email as username?', 'radio', 0, '', 'members', '', ''),

	('startpage', 'Default Start Page?', 'home', 'What should the homepage of your site be? Common pages are home, catalog, calendar, or login.', 'text', '200', '', 'site', '85', ''),
	('welcome_guide', '', '0', '', '', '0', '', 'system', '0', ''),
	('sub_id_format', 'Subscription ID Format', 'LnnnnnnnnnnnLLLnnnn', 'Customize the format of subscription IDs. Recommended: 15-22 characters. L = Upper case letter. l = Lower case letter. n = Number. random = Random Format', 'text', 150, '', 'subscriptions', 22, ''),
	('remove_content_cancel_sub', 'Remove Content Upon Cancel?', '1', 'Would you like to instantly remove access to content granted by a subscription when it expires (YES) or let the content expire naturally on the scheduled expiration date (NO)?', 'radio', '', '', 'subscriptions', '', ''),
	('account_headings', '', 'name,city,state,phone,created', 'Default table sorting headings. Employees can override.', 'text', 0, '', 'system', 0, ''),
	('concurrent_use_system', 'Allow Concurrent Logins?', '0', 'Would you like to allow concurrent logins to the same membership?', 'radio', '0', '', 'members', '', ''),
	('concurrent_logins_suspend', 'Concurrent Login Suspension', '3', 'How many concurrent logins must be detected before a member is suspended?', 'text', '80', '', 'members', '3', ''),
	('member_headings', '', 'username,joined,last_name,first_name,email', 'Default table sorting headings. Employees can override.', 'text', 0, '', 'system', 0, ''),
	('contact_headings', '', 'last_name,first_name,next_action,account,expected_value', 'Default table sorting headings. Employees can override.', 'text', 0, '', 'system', 0, ''),
	('site_name', 'Site Name', '$site_name', 'As displayed throughout the templates.', 'text', 0, '', 'site', 0, ''),
	('company_url', 'Company URL', '$company_url', 'What is your company URL&#63;', 'text', 0, '', 'general', 0, ''),
	('company_email', 'Company E-Mail', '" . $company_email . "', 'A generic company email, often used on outgoing templates.', 'text', '250', '', 'general', '', ''),
	('google_analytics', 'Google Analytics ID', '', 'If you wish to track your website with Google Analytics, input your Id below.', 'text', '250', '', 'general', '', ''),
	('load_jquery', 'Load jQuery?', '1', 'Would you like to automatically load jQuery and jQuery UI on all templates?', 'radio', '', '', 'general', '', ''),
	('session_inactivity_expiration', 'Session Length', '3600', 'How long, in seconds, before a user\'s session expires due to inactivity&#63;', 'text', 100, '', 'members', 6, 'zen_num'),
	('session_admin_inactivity', 'Session Expiration', '7200', '', 'special', 0, '', 'admin', 0, 'zen_num'),

    ('additional_search_contacts', '', 'phone,fax', 'Make additional custom fields searchable in the quick ajax search.', 'text', 0, '', 'system', 0, ''),
    ('additional_search_members', '', 'phone,fax', 'Make additional custom fields searchable in the quick ajax search.', 'text', 0, '', 'system', 0, ''),

    ('cc_expiring_notify', 'Notify Expiring Credit Cards?', '1', 'If set to yes, users will be notified of upcoming expiring credit cards one month before they expire.', 'radio', '0', '', 'cart', '0', ''),

	('price_format', 'Price Format', '1', 'What format should prices be displayed in&#63;', 'select', 150, '1:1,000.00|2:1 000,00|3:1000.00|4:1000', 'cart', 0, ''),

	('language', 'Language', 'en', 'Default language for the program?', 'select', '200', 'ar:Arabic|bn:Bengali|zh:Chinese|de:Deutsch|en:English|es:Espanol|fr:Francais|hi:Hindi|ja:Japanese|pt:Portuguese|pa:Punjabi|ru:Russian', 'general', '', ''),

	('homepage', 'Homepage Location', '/index.php', 'Where should the \"homepage\" link redirect to&#63;', 'text', 0, '', 'site', 0, ''),
	('order_id_format', 'Order Number Format', 'LLL-nnnnnnnnnn', 'L = Upper case letter, l = lower case letter, n = Number', 'text', 200, '', 'cart', 20, ''),
	('extend_type', 'Renewal Extension Type', 'today', 'Should renewals be based on today\'s date or the date the subscription expired?', 'radio', 0, 'today:Today|expires:Previous Next Renewal Date', 'subscriptions', 0, ''),
	('rsvp_ticket_format', 'Confirmation Number Format', 'LLn-nnnnn-nnnnn-nnnnn', 'Customize the format of event registration confirmation numbers. Recommended: between 15 and 21 characters. L = Upper case letter. l = Lower case letter. n = Number. random = Random Format', 'text', 0, '', 'events', 21, ''),
	('use_qcodes', 'Use QR Codes?', '1', 'Would you like to use QCodes throughout the program, like on event registrations&#63;', 'radio', 0, '', 'general', 0, ''),
	('note_headings_admin', '', 'date,name,label,public,deadline,for', '', '', '', '', 'hide', '', ''),
	('cron_alerts', '', '0', '', '', '0', '', 'system', '0', ''),
	('theme', '', 'zoid', '', 'text', 0, '', 'system', 0, ''),
    ('sms_plugin',  'SMS Plugin',  '', 'Enter the plugin ID you want to use for SMS sending.',  'text',  '150',  '', 'sms',  '',  ''),
	('email_plugin',  'E-Mail Plugin',  '', 'Enter the plugin ID you want to use for SMS sending.',  'text',  '150',  '', 'email',  '',  ''),
	('theme_emails', '', 'threefiveten', '', 'text', 0, '', 'system', 0, ''),
	('max_failed_logins', 'Failed Logins Before CAPTCHA?', '5', 'How many failed logins before the user must submit a CAPTCHA?', 'text', '80', '', 'members', '4', ''),
	('paypal_return_text', '', 'CLICK HERE TO COMPLETE YOUR ORDER', '', 'text', 0, '', 'system', 0, ''),
	('tax_scope', 'Taxable Items', 'physical', 'physical,digital,both,none', 'select', 250, 'physical:Physical Only|digital:Digital Only|both: Both|none: None', 'cart', 0, ''),
	('cart_req_terms', '', '1', 'DEPRECATED', 'radio', 0, '', 'system', 0, ''),
	('subscription_retries', 'Maximum Failed Retries', '3', 'How many failed retries would you like to allow before canceling a subscription&#63;', 'text', 80, '', 'subscriptions', 2, ''),
	('subscription_retry_spacing', 'Retry Spacing', '000002000000', 'How far apart should retries be for failed subscriptions&#63;', 'timeframe', 0, '', 'subscriptions', 0, ''),
	('subscription_advanced_notice',  'Upcoming Renewal Reminder',  '7', 'How many days before a subscription renews should users be reminded of the upcoming subscription? Set to \"999\" for never!',  'text',  '80',  '', 'subscriptions',  '',  ''),
	('curl_proxy', 'cURL Proxy', '', 'If you would like to use a cURL proxy, please input the proxy above.', 'text', 0, '', 'general', 0, ''),
	('append_contact', 'Append Existing Contacts?', 'create', 'When a contact form is submitted with an email address that matches a contact already in the database, would you like to append the submission to the existing contact or create a new record?', 'select', '200', 'append:Append To Existing|create:Create New Record', 'contacts', 0, ''),
	('allow_invoicing', 'Allow Invoicing&#63;', '0', 'Would you like to allow users to request an invoice the shopping cart&#63;', 'radio', 0, '', 'invoices', 0, ''),
	('cart_login_req', 'Login Requirement', '0', 'When should a user be required to log in during a shopping session&#63;', 'select', 150, '0:Never|1:To View The Catalog|2:To View His/Her Cart|3:To Checkout', 'cart', 0, ''),
	('crumb_divider', 'Breadcrumb Divider', '/', 'What symbol should be used to separate components in the breabcrumbs&#63;', 'text', 50, '', 'site', 1, ''),
	('new_contact_form_type', 'New Contact Type (Forms)', 'Lead', 'What type of contact should be created when a user submits a contact form?', 'select', '200', 'Contact:General Contact|Lead:Lead|Opportunity:Opportunity|Customer:Customer', 'contacts', 0, ''),
	('opportunity_timeframe', 'Opportunity Contact Frequency', '000004000000', 'Contacts marked as Opportunities have increased contact frequencies. How often should opportunities be contacted? Set to 9 years to not user this feature and instead rely on the account contact frequency settings.', 'timeframe', 0, '', 'contacts', 0, ''),
	('catalog_img_size', 'Image Size', '133', 'How wide, in pixels, should images be in the shop&#63;', 'text', 120, '', 'cart', 4, 'zen_num'),
	('sub_no_card_action',  'Action For Cardless Renewals',  'invoice',  'What would you like to do in the event that a subscription doesn''t have a credit card associated with it&#63;',  'select',  '200', 'invoice:Invoice the user|email:E-Mail card update request.',  'subscriptions',  '',  ''),
	('catalog_cate_cols', 'Shop Columns', '2', 'How many columns should products be displayed in throughout the shop&#63;', 'text', 80, '', 'cart', 1, 'zen_num'),
	('catalog_img_size_lg', 'Shop Large Image Size', '250', 'How large should the bigger version of a catalog item be when viewing a product&#63;', 'text', 0, '', 'cart', 0, 'zen_num'),
	('catalog_img_size_tb', 'Thumbnail Size', '50', 'Width of small thumbnails on the view product page, in pixels.', 'text', 80, '', 'cart', 3, 'zen_num'),

	('update_subs_card_update', 'Update subscription card?', '1', 'Would you like to update all subscriptions for a user when a credit card is updated or added?', 'radio', '', '', 'cart', '', ''),
	('nonmember_cart_buy_acct', '', 'NON_MEMBER', 'Matches ID in ppSD_sources', 'text', 0, '', 'system', 0, ''),
	('max_failed_login_attempts', 'Max Failed Login Attempts', '6', 'Maximum number of failed login attempts before a member is locked for 10 minutes.', 'text', 80, '', 'members', 2, ''),
	('user_update_time', 'Recommended Update Time', '000300000000', 'How often would you like to request that a user update their membership details&#63;', 'timeframe', 0, '', 'members', 0, ''),
	('default_login_redirect', 'Login Redirection', 'content', 'Where would you like to redirect users after login&#63; Input a URL, or type \"manage\" for the management page or \"announcements\" for the login announcements page.', 'text', 0, '', 'members', 0, ''),
	('use_usage_logs', 'Track Usage&#63;', '1', 'Would you like to track usage throughout the admin control panel&#63;', 'radio', 0, '', 'general', 0, ''),
	('user_manage_nav', '', 'index,update_account,announcement,subscriptions,billing_history,credit_cards,newsletters,uploads', 'Order for the navigation menu items.', 'text', 0, '', '', 0, ''),
	('announcement_views_to_seen', 'Mark as Seen', '1', 'How many times an announcement needs to be viewed before it is marked as \"seen\".', 'text', 80, '', 'announcements', 4, ''),
	('uploads_exts', 'Allowed Upload Extensions&#63;', 'jpg,jpeg,png,gif,zip,pdf,doc,docx,odt,xlsx,csv,xltx,xml,xls,ods,txt,rtf', 'Create a CSV of allowed upload extensions.', 'text', 0, '', 'general', 0, ''),
	('uploads_max_size', 'Upload Size Limit', '5242880', 'In bytes, what should the file size limit be for user uploads&#63;', 'text', 120, '', 'general', 8, 'zen_num'),
	('required_password_strength', 'Minimum Password Strength', '-99', 'What would you like the minimum password strength requirement to be&#63;', 'select', 150, '-99:No Standards|1:Weakest|2:Weak|3:Medium|4:Strong|5:Strongest', 'members', 0, ''),
	('invoice_id_format', 'Invoice Number Format', 'LLLLL-nnnnnnnnnn-nnnnnnnnnn', 'Customize the format of invoice numbers. Recommended: 15-35 characters. L = Upper case letter. l = Lower case letter. n = Number. random = Random Format', 'text', 0, '', 'invoices', 35, ''),
	('logout_redirect', 'Logout Redirect', '%site%/login.php', 'Input the full URL to which you would like to redirect users after logging out.', 'text', 0, '', 'members', 0, ''),
	('captcha_type', 'Captcha Settings', 'words', 'What type of CAPTCHA would you like to use with the system&#63;', 'select', 150, 'words:Real Words|random:Random Characters', 'members', 0, ''),
	('sales_headings', '', 'id,date_completed,payment_gateway,total,status', '', 'text', 0, '', 'hide', 0, ''),
	('event_id_format', 'Event ID Format', 'LLLnnnnnn', 'Customize the format of event IDs. Recommended: 9 characters. L = Upper case letter. l = Lower case letter. n = Number. random = Random Format', 'text', 150, '', 'events', 9, ''),
	('departments', '', 'Administration,Sales,Technical', '', 'text', 0, '', 'system', 0, ''),
	('account_inactive_time', 'Time Until Inactive', '000600000000', 'After how long of inactivity should a member be marked as inactive&#63;', 'timeframe', '', '', 'members', '', ''),
	('account_inactive_email', 'E-Mail Inactive Accounts&#63;', '1', 'Would you like to email users when their membership is marked as inactive&#63;', 'radio', '', '', 'members', '', ''),
	('product_id_format', 'Product ID Format', 'random', 'Default format for a product ID. L = Upper case letter. l = Lower case letter. n = Number. random = Random Format', 'text', 0, '', 'cart', 35, ''),
	('invoice_hourly', 'Hourly Rate', '100', 'What you would like your default hourly rate to be for invoices&#63;', 'text', 80, '', 'invoices', 8, 'zen_money'),
	('invoice_due_date', 'Invoice Due', '000014000000', 'How long after an invoice is created before it should be marked as overdue&#63;', 'timeframe', 0, '', 'invoices', 0, ''),
	('invoice_round_up', 'Round Up Hourly Work&#63;', '0', 'Would you like to round up hourly components of invoices&#63; So 15 minutes of work becomes 1 hour&#63;', 'radio', 0, '', 'invoices', 0, ''),
	('company_address', 'Company Address', '$company_address', 'Used on invoices and various other emails and templates.', 'textarea', 0, '', 'general', 0, ''),
	('company_logo', 'Company Logo', '$company_logo', 'Input a URL to your company logo.', 'text', 0, '', 'general', 0, ''),
	('company_name', 'Company Name', '$company_name', 'What is your company''s name&#63;', 'text', 250, '', 'general', 0, ''),
	('company_contact', 'Company Contact Details', '$company_contact', 'For use on various templates and emails, these are your desired contact details for your company.', 'textarea', 0, '', 'general', 0, ''),
	('invoice_allow_partial', 'Allow Partial Payments&#63;', '1', 'Would you like to allow partial payments on invoices&#63;', 'radio', 0, '', 'invoices', 0, ''),
	('invoice_reminder_pre', 'Reminder No. 1', '000005000000', 'How long before an invoice is due would you like to send a friendly reminder out to the client&#63;', 'timeframe', 0, '', 'invoices', 0, ''),
	('invoice_max_reminders', 'Maximum Reminders', '5', 'Maximum number of reminders after an invoice is past due. If an invoice is still overdue after the last reminder, it will be marked as \"Dead\".', 'text', 80, '', 'invoices', 2, ''),
	('invoice_reminder_post', 'Overdue Reminders', '000007000000', 'How often after an invoice is overdue would you like to remind the user of the overdue status&#63; Works together with the maximum reminders option.', 'timeframe', 0, '', 'invoices', 0, ''),
	('email_send_through', 'E-Mail Dispatch Method', 'php_mail', 'Means by which emails should be sent. Options include \"php_mail\", \"php_mailer\", or \"mailgun\"', 'select', 150, 'php_mail:PHP Mail', 'email', 0, ''),
	('smtp_server', '', '', '', 'text', 0, '', 'system', 0, ''),
	('smtp_user', '', '', '', 'text', 0, '', 'system', 0, ''),
	('smtp_pass', '', '', '', 'text', 0, '', 'system', 0, ''),
	('smtp_port', '', '', '', 'text', 0, '', 'system', 0, ''),
	('member_filters', 'Additional Member Filters', '', 'Display additional member filters for all employees? Input as a CSV of field IDs.', 'text', 250, '', 'members', 20, ''),
    ('contact_filters', 'Additional Contact Filters', '', 'Display additional contact filters for all employees? Input as a CSV of field IDs.', 'text', 250, '', 'contacts', 20, ''),
    ('account_filters', 'Additional Account Filters', '', 'Display additional account filters for all employees? Input as a CSV of field IDs.', 'text', 250, '', 'accounts', 20, ''),


	('bounced_email_inbox', 'Bounced E-Mail Inbox', '', 'If you have set up an inbox to detect bounced emails, input the email (IE: bounced@yoursite.com) above as well as your SMTP credentials below.', 'text', '250', '', 'email', '', ''),
	('bounced_smtp_server', 'Bounced SMTP Mail Server', '', 'Mail server for the bounced email account.', 'text', '250', '', 'email', '', ''),
	('bounced_smtp_username', 'Bounced SMTP Username', '', 'Username to connect to the bounced email account.', 'text', '250', '', 'email', '', ''),
	('bounced_smtp_password', 'Bounced SMTP Password', '', 'Password to connect to the bounced email account.', 'text', '250', '', 'email', '', ''),
	('bounced_smpt_port', 'Bounced SMTP Port', '', 'Port to connect to the bounced email account.', 'text', '250', '', 'email', '', ''),
    ('stat_opt_in',  'Anonymous Stat Opt-in',  '$stat_opt_in',  'Allow Castlamp to anonymously collect statistical information on your program?',  'radio',  '',  '',  'general',  '',  ''),

	('cron_time',  'Cron Execution Time',  '',  '',  '',  '',  '',  'system',  '',  ''),
	('preview_contacts', '', 'last_name,first_name,email', '', '', 0, '', '', 0, ''),
	('preview_members', '', 'username,email,last_name,first_name', '', '', 0, '', '', 0, ''),
	('preview_account', '', 'company_name', '', '', 0, '', '', 0, ''),
	('preview_rsvps', '', 'last_name,first_name,email', '', '', 0, '', '', 0, ''),
	('emails_per_hour', 'E-Mail Throttling', '500', 'How many emails would you like to limit the system to per hour&#63;', 'text', 100, '', 'email', 6, 'zen_num'),
	('product_sale_points',  'Popularity Points Per Sale',  '20',  'How many popularity points should be assigned to a product for a sale&#63;',  'text',  '60',  '',  'cart',  '4',  ''),
	('product_view_points',  'View Points Per Sale',  '0.25',  'How many popularity points should be assigned to a product for a view&#63;',  'text',  '60',  '',  'cart',  '4',  ''),
	('event_headings', '', 'name,id,starts,ends,max_rsvps,location_name', 'Default table headings for events', 'text', '', '', 'hide', '', ''),
	('contact_headings_admin', '', 'last_name,first_name,next_action,account,expected_value,owner', '', '', 0, '', 'hide', 0, ''),
	('member_headings_admin', '', 'username,joined,last_name,first_name,email', '', '', 0, '', 'hide', 0, ''),
	('account_headings_admin', '', 'name,city,state,phone,created', '', '', 0, '', 'hide', 0, ''),
	('transaction_headings', '', 'id,date_completed,member_id,payment_gateway,total,status', '', '', 0, '', 'hide', 0, ''),
	('new_contact_public', 'Make New Contacts Public&#63;', '1', 'Make new contacts public to employees&#63;', 'radio', 0, '', 'contacts', 0, ''),
	('contact_assign_type', 'Assignment Type', 'unassigned', 'How would you like to assign new contacts&#63;', 'select', 250, 'random:Random Assignment|next_employee:Next Employee|unassigned:Unassigned', 'contacts', 0, ''),
	('contact_last_assign', '', '', 'Who was the last contact assigned to&#63;', '', 0, '', 'system', 0, ''),
	('site_mode',  'Site Mode',  'live',  'Establish the <a href=\"http://documentation.zenbership.com/Integration/Test-Mode\" target=\"_blank\">mode</a> you wish to operate the program under.',  'select',  '', 'live:Live Mode|test:Test Mode',  'general',  '',  ''),
	('email_queue_last_sent', '', '', '', '', 0, '', 'system', 0, ''),
	('cron_last_run', '', '', '', '', 0, '', 'system', 0, ''),
	('db-backup', '', '', '', '', 0, '', 'system', 0, ''),
	('theme-html-backup', '', '', '', '', 0, '', 'system', 0, ''),
	('theme-email-backup', '', '', '', '', 0, '', 'system', 0, ''),
	('theme-mobile-backup', '', '', '', '', 0, '', 'system', 0, ''),
	('update_info', '', '$update_array', '', '', '', '', 'hide', '', ''),
	('last_rotation', '', '$date', '', '', '', '', 'hide', '', ''),
	('twitter_handle', 'Twitter Handle', '', 'Input your twitter handle without the @ symbol.', 'text', '250', '', 'social_media', '', ''),
	('twitter_consumer_key', 'Twitter Consumer Key', '', '', 'text', '250', '', 'social_media', '', ''),
	('twitter_secret', 'Twitter Consumer Secret', '', '', 'text', '250', '', 'social_media', '', ''),
	('twitter_oauth_token', 'Twitter Access token', '', '', 'text', '250', '', 'social_media', '', ''),
	('twitter_oauth_secret', 'Twitter Access token secret', '', '', 'text', '250', '', 'social_media', '', ''),
	('wg_featured_product_display',  'Display',  '1',  'How many product to display?',  'text',  '80',  '',  'widgets',  '3',  ''),
	('wg_featured_product_featured',  'Featured Products Only?',  '1',  'Display featured product only or all products?',  'radio',  '',  '1:Featured|0:Any',  'widgets',  '',  ''),
	('wg_featured_product_category',  'Category',  '',  'Select products from specific category?',  'special',  '200',  'list:cart_categories',  'widgets',  '',  ''),
	('wg_upcoming_events_display',  'Display',  '5',  'How many events to display?',  'text',  '80',  '',  'widgets',  '3',  ''),
	('wg_upcoming_events_timeframe',  'Range?',  '1',  'Display featured product only or all products?',  'timeframe',  '',  '000300000000',  'widgets',  '',  ''),
	('wg_upcoming_events_calendar',  'Calendar',  '',  'Select events from specific calendar?',  'special',  '200',  'list:calendars',  'widgets',  '',  ''),
	('wg_custom_files_label',  'Label',  'custom_files',  'Only display files with a specific label.',  'special',  '200',  'list:labels',  'widgets',  '',  ''),
	('wg_user_uploads_allow_uploads', 'Allow Uploading?', 'No', 'Would you like to allow users to upload files to this list?', 'radio', 0, 'Yes|No', 'widgets', 0, ''),
	('wg_user_uploads_label', 'Label', '', 'Only display files with a specific label?', 'special', 200, 'list:labels', 'widgets', 0, ''),
	('wg_user_uploads_account_files', 'Include Account Files?', 'No', 'If set to yes, public files uploaded to the account will appear on the list. Otherwise only files uploaded to a specific member will appear in the list.', 'radio', 0, 'Yes|No', 'widgets', 0, ''),
	('wg_user_uploads_public_list', 'Public List?', 'No', 'If set to yes, public files will appear on the list. Otherwise only files uploaded to a specific member will appear in the list.', 'radio', 0, 'Yes|No', 'widgets', 0, '');
";

/*
    ('case_sensitive_username', 'Username Case Sensitivity', '1', 'Would you like to make usernames case sensitive&#63;', 'radio', 0, '', 'members', 0, ''),

	('use_cache', 'Use Caching&#63;', '', 'Would you like to use the caching system&#63; Recommended for larger databases.', 'radio', 0, '', 'general', 0, ''),
	('facebook_app_id', 'Facebook App ID', '', 'Input your Facebook App ID', 'text', '250', '', 'social_media', '', ''),
	('facebook_app_secret', 'Facebook App Secret', '', 'Input your Facebook App Secret.', 'text', '250', '', 'social_media', '', ''),
	('facebook_url', 'Facebook Profile URL', '', 'Input your full Facebook Profile URL.', 'text', '250', '', 'social_media', '', ''),
*/

$inserts[] = "
	INSERT INTO `ppSD_payment_gateways` (`fee_flat`, `fee_percent`, `test_mode`, `active`, `code`, `name`, `online`, `api`, `local_card_storage`, `credential1`, `credential2`, `credential3`, `credential4`, `primary`, `method_cc_visa`, `method_cc_amex`, `method_cc_mc`, `method_cc_discover`, `method_check`, `method_refund`) VALUES
	('0.00', '0.00', 0, 0, 'gw_paypal', 'PayPal', 'http://www.paypal.com/', 0, 0, '', '', '', '', 0, 1, 0, 0, 0, 0, 0),
	('0.30', '2.90', 0, 0, 'gw_paypal_pro', 'PayPal Payments Pro', 'https://www.paypal.com/webapps/mpp/paypal-payments-pro', 1, 1, '', '', '', '', 0, 1, 1, 1, 1, 0, 1),
	('0.10', '2.19', 0, 0, 'gw_authnet_cim', 'Authorize.net CIM', 'http://www.authorize.net/solutions/merchantsolutions/merchantservices/cim/', 1, 0, '', '', '', '', 0, 1, 0, 1, 1, 0, 1),
	('0.00', '0.00', 0, 0, 'gw_first_data', 'First Data', '', 1, 1, '', '', '', '', 0, 1, 0, 1, 1, 0, 1),
	('0.30', '2.90', 0, 0, 'gw_stripe', 'Stripe', 'http://www.stripe.com/', 1, 0, '', '', '', '', 1, 1, 1, 1, 1, 0, 1),
	('0.25', '2.95', 0, 0, 'gw_beanstream', 'Beanstream', 'http://www.beanstream.com/site/ca/index.html', 1, 0, '', '', '', '', 0, 1, 1, 1, 1, 1, 1);
";
/*
    ('0.00', '0.00', 0, 0, 'gw_elavon_vm', 'Elavon Virtual Merchant', 'https://www.myvirtualmerchant.com/VirtualMerchant/', 1, 1, '', '', '', '', 0, 1, 1, 1, 1, 0, 1),
    ('0.10', '2.19', 0, 0, 'gw_authnet_aim', 'Authorize.Net AIM', 'http://www.authorize.net/solutions/merchantsolutions/pricing/', 1, 0, '', '', '', '', 0, 1, 0, 1, 1, 1, 1),
	('0.00', '0.00', 0, 0, 'gw_eway', 'eWay', 'http://www.eway.com.au/', 1, 0, '', '', '', '', 0, 1, 1, 1, 1, 0, 1),
    ('0.00', '0.00', 0, 0, 'gw_moneris', 'Moneris', '', 1, 0, '', '', '', '', 0, 1, 0, 0, 0, 0, 1),
	('0.10', '2.19', 0, 0, 'gw_authnet_aim', 'Authorize.Net AIM', 'http://www.authorize.net/solutions/merchantsolutions/pricing/', 1, 0, '', '', '', '', 0, 1, 0, 1, 1, 1, 1),
	('0.00', '0.00', 0, 0, 'gw_verifi', 'Verifi', '', 1, 0, '', '', '', '', 0, 1, 0, 0, 0, 0, 1),
*/
$inserts[] = "
	INSERT INTO `ppSD_permission_groups` (`id`, `name`, `admin`, `owner`, `start_page`) VALUES
	(1, 'Administrators', 1, 1, ''),
	(2, 'Sales', 0, 1, ''),
	(3, 'Developer/Designer', 0, 0, 'integration'),
	(4, 'Shop Manager', 0, 0, ''),
	(5, 'Member Manager', 0, 0, ''),
	(6, 'Event Coordinator', 0, 0, '');
";

$inserts[] = "
	INSERT INTO `ppSD_permission_group_settings` (`id`, `group_id`, `scope`, `action`, `allowed`) VALUES
	(1, 2, 'transaction', '', 'all'),
	(2, 2, 'invoice', '', 'all'),
	(3, 2, 'subscription', '', 'all'),
	(4, 2, 'promo_code', '', 'all'),
	(5, 2, 'product', '', 'all'),
	(6, 2, 'contact', '', 'all'),
	(7, 2, 'member', 'view', 'all'),
	(8, 2, 'account', 'view', 'all'),
	(9, 2, 'menu-members', '', 'all'),
	(10, 2, 'menu-shop', '', 'all'),
	(11, 2, 'menu-crm', '', 'all'),
	(12, 2, 'menu-connect', '', 'all'),
	(13, 3, 'menu-integration', '', 'all'),
	(14, 3, 'custom_actions', '', 'all'),
	(15, 3, 'field', '', 'all'),
	(16, 3, 'fieldset', '', 'all'),
	(17, 3, 'form', '', 'all'),
	(18, 3, 'integration', '', 'all'),
	(19, 3, 'theme_emails', '', 'all'),
	(20, 3, 'theme', '', 'all'),
	(21, 3, 'content', '', 'all'),
	(22, 3, 'widgets', '', 'all'),
	(23, 4, 'invoice', '', 'all'),
	(24, 4, 'packages', '', 'all'),
	(25, 4, 'product', '', 'all'),
	(26, 4, 'promo_code_usage', '', 'all'),
	(27, 4, 'promo_code', '', 'all'),
	(28, 4, 'shop', '', 'all'),
	(29, 4, 'payment_gateway', '', 'all'),
	(30, 4, 'cart-report', '', 'all'),
	(31, 4, 'shop_shipping', '', 'all'),
	(32, 4, 'shop_tax', '', 'all'),
	(33, 4, 'shop_terms', '', 'all'),
	(34, 4, 'subscription', '', 'all'),
	(35, 4, 'transaction', '', 'all'),
	(36, 5, 'menu-members', '', 'all'),
	(37, 5, 'login_announcements', '', 'all'),
	(38, 5, 'logins', '', 'all'),
	(39, 5, 'member', '', 'all'),
	(40, 5, 'member_types', '', 'all'),
	(41, 5, 'menu-connect', '', 'all'),
	(42, 5, 'connect', '', 'all'),
	(43, 5, 'campaigns', '', 'all'),
	(46, 4, 'cart-estimated-income', '', 'all'),
	(47, 4, 'cart-value_by_source', '', 'all'),
	(48, 5, 'cart-world_distribution', '', 'all'),
	(49, 5, 'cart-state_distribution', '', 'all'),
	(50, 2, 'widget_subscriptions_soon', '', 'all'),
	(51, 2, 'widget_transactions', '', 'all'),
	(52, 2, 'widget_contacts', '', 'all'),
	(53, 4, 'widget_transactions', '', 'all'),
	(54, 4, 'widget_subscriptions_soon', '', 'all'),
	(55, 5, 'widget_members', '', 'all'),
	(56, 6, 'widget_rsvps', '', 'all'),
	(57, 6, 'menu-events', '', 'all'),
	(58, 6, 'calendar', '', 'all'),
	(59, 6, 'event', '', 'all'),
	(60, 2, 'billing_report', '', 'all'),
	(61, 4, 'billing_report', '', 'all'),
	(62, 2, 'menu-shop', '', 'all'),
	(63, 4, 'menu-shop', '', 'all'),
	(64, 2, 'widget_invoices', '', 'all'),
	(65, 4, 'widget_invoices', '', 'all'),
	(66, 2, 'calendar', '', 'all'),
	(67, 4, 'calendar', '', 'all'),
	(68, 5, 'calendar', '', 'all'),
	(69, 6, 'calendar', '', 'all'),
	(70, 2, 'feed', '', 'all'),
	(71, 4, 'feed', '', 'all'),
	(72, 5, 'feed', '', 'all'),
	(73, 6, 'feed', '', 'all'),
	(74, 2, 'notes', '', 'all'),
	(75, 3, 'notes', '', 'all'),
	(76, 4, 'notes', '', 'all'),
	(77, 5, 'notes', '', 'all'),
	(78, 6, 'notes', '', 'all'),
	(79, 3, 'plugins', '', 'all');
";

$inserts[] = "
	INSERT INTO `ppSD_content` ( `id`, `name`, `permalink`, `permalink_clean`, `url`,  `section`, `type`) VALUES
	('1', 'Home', 'Home', 'Home', 'index.php', '', 'section'),
";

$inserts[] = "
	INSERT INTO `ppSD_content` (`permalink`, `permalink_clean`, `name`, `type`, `path`, `url`, `additional_update_fieldsets`, `display_on_usercp`, `owner`, `section`, `secure`, `section_homepage`) VALUES ('Home', 'Home', 'Home', 'section', '', '', '', '', '2', '', '0', '');
";


$inserts[] = "
	INSERT INTO `ppSD_sections` (`name`, `display_title`, `url`, `subsection`, `main_nav`, `secure`) VALUES
	('Home', 'Home', '', '', 0, 0);
";

/*
	('2', 'Event Calendar', 'Calendar', 'Calendar', 'calendar.php', '', 'section'),
	('3', 'Events', 'Events', 'Events', 'event.php', '1', 'section'),
	('4', 'Shopping Cart', 'Cart', 'Cart', 'cart.php', '', 'section'),
	('5', 'Login', 'Login', 'Login', 'login.php', '', 'section'),
	('6', 'Member Dashboard', 'Member Dashboard', 'Account_Management', 'manage/index.php', '', 'section'),
	('7', 'Shop', 'Catalog', 'Catalog', 'catalog.php', '', 'section'),
	('8', 'Membership', 'Register', 'Register', 'register.php', '', 'section'),
	('9', 'Invoice', 'Invoice', 'Invoice', 'invoice.php', '', 'section');
*/
$inserts[] = "
	INSERT INTO `ppSD_sources` (`source`, `type`) VALUES
	('Cold Call', 'custom'),
	('Self Generated', 'custom'),
	('Direct Mail', 'custom'),
	('Online Advertisement', 'custom'),
	('Conference', 'custom'),
	('Trade Show', 'custom'),
	('Word of Mouth', 'custom'),
	('Television', 'custom'),
	('Email', 'custom'),
	('Other', 'custom');
";
$inserts[] = "
	INSERT INTO `ppSD_staff` (`id`, `username`, `password`, `salt`, `permission_group`, `signature`, `email`, `first_name`, `last_name`, `address_line_1`, `address_line_2`, `city`, `state`, `zip`, `country`, `phone`, `fax`, `alt_phone`, `office_phone`, `facebook`, `twitter`, `linkedin`, `department`, `occupation`, `locked`, `locked_ip`, `login_attempts`, `status`, `options`, `created`, `last_updated`, `owner`, `static`) VALUES
	(1, 'system', 'xxx', 'nnn', 1, '', '', 'System Console', '', '', '', '', '', '', '', '', '', '', '', '0', '0', '0', '', '', '1920-01-01 00:01:01', '', 0, 1, '', '$date', '1920-01-01 00:01:01', 0, 1),
	(2, '" . $_POST['admin']['user'] . "', '$admin_pass_encoded', '$admin_pass_salt', 1, '\n\n--\n$emp_name', '', '$emp_first_name', '$emp_last_name', '', '', '', '', '', '', '', '', '', '', '0', '0', '0', 'Administration', '', '1920-01-01 00:01:01', '', 0, 1, '', '$date', '1920-01-01 00:01:01', 0, 1);
";
$inserts[] = "
	INSERT INTO `ppSD_templates` (`id`, `path`, `theme`, `subtemplate`, `title`, `desc`, `caller_tags`, `order`, `custom_header`, `custom_footer`, `custom_template`, `type`, `section`, `content`, `secure`, `static`, `owner`) VALUES
	('calendar', '', 'zoid', '', 'Viewing Calendar', '', '', 0, '0', '0', '', 0, 'Calendar', '', 0, 1, 2),
	('calendar_long', '', 'zoid', '', 'Viewing Event Listings', '', '', 0, '0', '0', '', 0, 'Calendar', '', 0, 1, 2),
	('event', '', 'zoid', '', 'Viewing Event', '', '', 0, '0', '0', '', 0, 'Events', '', 0, 1, 2),
	('error', '', 'zoid', '', 'Error Processing Request', '', '', 0, '0', '0', '', 0, '', '', 0, 1, 2),
	('cart_terms', '', 'zoid', '', 'Terms and Conditions', '', '', 0, '0', '0', '', 0, 'Cart', '', 0, 1, 2),
	('cart_shipping', '', 'zoid', '', 'Shipping and Handling', '', '', 0, '0', '0', '', 0, 'Cart', '', 0, 1, 2),
	('cart_billing', '', 'zoid', '', 'Checkout', '', '', 0, '0', '0', '', 0, 'Cart', '', 0, 1, 2),
	('cart_billing_preview', '', 'zoid', '', 'Preview Order', '', '', 0, '0', '0', '', 0, 'Cart', '', 0, 1, 2),
	('catalog', '', 'zoid', '', 'Catalog', '', '', 0, '0', '0', '', 0, 'Catalog', '', 0, 1, 2),
	('catalog_view_product', '', 'zoid', '', 'Viewing Product', '', '', 0, '0', '0', '', 0, 'Catalog', '', 0, 1, 2),
	('cart_overview', '', 'zoid', '', 'Cart Contents', '', '', 0, '0', '0', '', 0, 'Cart', '', 0, 1, 2),
	('login', '', 'zoid', '', 'Member Login', '', '', 0, '0', '0', '', 0, 'Login', '', 0, 1, 2),
	('activation_code_sent', '', 'zoid', '', 'Activation Code Sent!', '', '', 0, '0', '0', '', 0, 'Login', '', 0, 1, 2),
	('email_confirmed', '', 'zoid', '', 'E-mail Confirmation Complete', '', '', 0, '0', '0', '', 0, 'Login', '', 0, 1, 2),
	('update', '', 'zoid', '', 'Membership Update Form', 'Used for any update form other than the primary update form.', '', '', '', '', '', '0', 'Home', '', '', '1', '2'),
    ('cart_view_order', '', 'zoid', '', 'View Order', '', '', 0, '0', '0', '', 0, 'Cart', '', 0, 1, 2),
	('cart_add_card',  '',  'zoid',  '',  'Add Credit Card',  '',  '',  '',  '',  '',  '',  '0',  'Member Dashboard',  '',  '',  '1',  '2'),
	('cart_manage_subscription', '', 'zoid', '', 'Manage Subscription', '', '', 0, '0', '0', '', 0, 'Cart', '', 0, 1, 2),
	('cart_upsell_checkout', '', 'zoid', '', 'Related Products', '', '', '', '', '', '', '0', 'Cart', '', '', '1', '2'),
	('cart_product_entry_upsell', '', 'zoid', '', 'Cart Upsell Product Entry (Checkout)', '', '', '', '', '', '', '0', 'Cart', '', '', '1', '2'),
	('register_list_entry', '', 'zoid', '', 'Registration Form List Entry', '', '', 0, '0', '0', '', 0, 'Register', '', 0, 1, 2),
	('reg_complete', '', 'zoid', '', 'Registration Complete', '', '', 0, '0', '0', '', 0, 'Register', '', 0, 1, 2),
	('reg_activation_code', '', 'zoid', '', 'E-Mail Confirmation Required', '', '', 0, '0', '0', '', 0, 'Register', '', 0, 1, 2),
	('reg_await_activation', '', 'zoid', '', 'Membership Pending Approval', '', '', 0, '0', '0', '', 0, 'Register', '', 0, 1, 2),
	('register', '', 'zoid', '', 'Member Registration', '', '', 0, '0', '0', '', 0, 'Register', '', 0, 1, 2),
	('reg_awaiting_payment', '', 'zoid', '', 'Account Pending Payment', '', '', 0, '0', '0', '', 0, 'Register', '', 0, 1, 2),
	('password_reset', '', 'zoid', '', 'Password Reset', '', '', 0, '0', '0', '', 0, 'Login', '', 0, 1, 2),
	('invoice_pay', '', 'zoid', '', 'Make a Payment on an Invoice', '', '', 0, '0', '0', '', 0, 'Invoice', '', 0, 1, 2),
	('reset_password', '', 'zoid', '', 'Reset Your Password', '', '', 0, '0', '0', '', 0, 'Login', '', 0, 1, 2),
	('password_recovery', '', 'zoid', '', 'Lost Password Recovery', '', '', 0, '0', '0', '', 0, 'Login', '', 0, 1, 2),
	('invoice_print', '', 'zoid', '', 'Print an Invoice', '', '', 0, '0', '0', '', 0, 'Invoice', '', 0, 1, 2),
	('invoice', '', 'zoid', '', 'Viewing Invoice', '', '', 0, '0', '0', '', 0, 'Invoice', '', 0, 1, 2),
	('header', '', 'zoid', '', 'Header', '', '', 0, '0', '0', '', 1, '', '', 0, 1, 2),
	('footer', '', 'zoid', '', 'Footer', '', '', 0, '0', '0', '', 2, '', '', 0, 1, 2),
	('homepage', '', 'zoid', '', 'Welcome', '', '', 0, '0', '0', '', 0, 'Home', '', 0, 1, 2),
	('featured_product_cell', '', 'zoid', '', 'Featured Product Cell', 'For use in the \"featured product\" widget.', '', 0, '0', '0', '', 3, '', '', 0, 0, 2),
	('cart_overview_empty', '', 'zoid', '', 'Your Cart Is Empty!', '', '', 0, '0', '0', '', 0, 'Cart', '', 0, 1, 2),
	
	('default_page', '', 'zoid', '', 'Default Content Page', '', '', 0, '0', '0', '', 3, '', '', 0, 0, 2),
	('page-2col-5050', '', 'zoid', '', 'Two Column: 50-50', '', '', 0, '0', '0', '', 3, '', '', 0, 0, 2),
	('page-2col-7030', '', 'zoid', '', 'Two Column: 70-30', '', '', 0, '0', '0', '', 3, '', '', 0, 0, 2),
	('page-2col-3070', '', 'zoid', '', 'Two Column: 30-70', '', '', 0, '0', '0', '', 3, '', '', 0, 0, 2),
	('page-3col-333', '', 'zoid', '', 'Three Column: 33-34-33', '', '', 0, '0', '0', '', 3, '', '', 0, 0, 2),

	('manage_home', '', 'zoid', '', 'Manage Home', '', '', 0, '0', '0', '', 0, 'Member Dashboard', '', 1, 1, 2),
	('manage_update_account', '', 'zoid', '', 'Update Account', '', '', 0, '0', '0', '', 0, 'Member Dashboard', '', 1, 1, 2),
	('manage_announcements', '', 'zoid', '', 'Announcements and News', '', '', 0, '0', '0', '', 0, 'Member Dashboard', '', 1, 1, 2),
	('manage_billing_history', '', 'zoid', '', 'Billing History', '', '', 0, '0', '0', '', 0, 'Member Dashboard', '', 1, 1, 2),
	('manage_invoices',  '',  'zoid',  '',  'Invoice Management',  '',  '',  '',  '',  '',  '',  '0',  'Member Dashboard',  '',  '',  '1',  '2'),
	('manage_calendar',  '',  'zoid',  '',  'Your Calendar',  '',  '',  '',  '',  '',  '',  '0',  'Member Dashboard	',  '',  '',  '1',  '2'),
	('cart_receipt', '', 'zoid', '', 'Order Complete', '', '', 0, '0', '0', '', 0, 'Cart', '', 0, 1, 2),
	('manage_event_rsvps', '', 'zoid', '', 'Event Registration History', '', '', 0, '0', '0', '', 0, 'Member Dashboard', '', 1, 1, 2),
	('manage_subscriptions', '', 'zoid', '', 'Subscriptions', '', '', 0, '0', '0', '', 0, 'Member Dashboard', '', 1, 1, 2),
	('manage_credit_cards', '', 'zoid', '', 'Credit Cards on File', '', '', 0, '0', '0', '', 0, 'Member Dashboard', '', 1, 1, 2),
	('manage_uploads', '', 'zoid', '', 'File Manager', '', '', '', '', '', '', '0', 'Member Dashboard', '', '', '1', '2'),



	('reg_preview', '', 'zoid', '', 'Registration Preview', '', '', 0, '', '', '', 0, 'Register', '', 0, 1, 0),
	('register_list', '', 'zoid', '', 'Registration Options', '', '', 0, '', '', '', 0, 'Register', '', 0, 1, 0),
	('popup_cart_added', '', 'zoid', '', 'Cart Popup: Item Added To Cart', '', '', '', '', '', '', '0', 'Cart', '', '', '1', '2'),
	('popup_cart_alter_subscription', '', 'zoid', '', 'Cart Popup: Confirm Subscription Change', '', '', '', '', '', '', '0', 'Cart', '', '', '1', '2'),
	('popup_cart_set_region', '', 'zoid', '', 'Cart Popup: Set Tax Region', '', '', '', '', '', '', '0', 'Cart', '', '', '1', '2'),
	('campaign_subscription', '', 'zoid', '', 'Subscription Confirmed', '', '', 0, '', '', '', 0, 'Home', '', 0, 1, 0),
	('campaign_confirm_needed',  '',  'zoid',  '',  'Subscription Confirmation Required',  '',  '',  '',  '',  '',  '',  '0',  'Home',  '',  '',  '1',  '2'),
	('campaign_unsubscribed', '', 'zoid', '', 'Unsubscribed From Campaign', '', '', 0, '', '', '', 0, 'Home', '', 0, 1, 0),
	('contact', '', 'zoid', '', 'Contact', '', '', 0, '', '', '', 0, 'Home', '', 0, 1, 2),
	('dependency', '', 'zoid', '', 'Additional Information Required', '', '', '', '', '', '', '0', 'Home', '', '', '1', '2'),
	('contact_thankyou', '', 'zoid', '', 'Thank you for contacting us!', '', '', 0, '', '', '', 0, 'Home', '', 0, 1, 0),
	('reg_select_product', '', 'zoid', '', 'Membership Options', '', '', 0, '', '', '', 0, 'Register', '', 0, 1, 2),
	('reg_code_required', '', 'zoid', '', 'Registration Code is Required', '', '', 0, '', '', '', 0, 'Register', '', 0, 1, 1);
";
//	('cart_manage_card', '', 'zoid', '', 'Add a Credit Card', '', '', 0, '0', '0', '', 0, 'Cart', '', 0, 1, 2),


$inserts[] = "
INSERT INTO `ppSD_templates` (`id`, `path`, `theme`, `subtemplate`, `title`, `desc`, `caller_tags`, `order`, `custom_header`, `custom_footer`, `custom_template`, `type`, `section`, `content`, `secure`, `static`, `owner`, `encrypt`, `meta_title`, `lang`) VALUES
	('news', '', 'zoid', '', 'News Homepage', '', '', 0, '0', '0', '', 0, 'News', '', 0, 1, 2, 0, '', 'en'),
	('news_post', '', 'zoid', '', 'News: Standard Post', '', '', 1, '0', '0', '', 0, 'News', '', 0, 1, 2, 0, '', 'en'),
	('news_video', '', 'zoid', '', 'News: Video Post', '', '', 2, '0', '0', '', 0, 'News', '', 0, 1, 2, 0, '', 'en'),
	('news_entry_none', '', 'zoid', '', 'News Entry: No Posts', '', '', 3, '0', '0', '', 0, 'News', '', 0, 1, 2, 0, '', 'en'),
	('news_entry_post', '', 'zoid', '', 'News Entry: Standard Post', '', '', 4, '0', '0', '', 0, 'News', '', 0, 1, 2, 0, '', 'en'),
	('news_entry_video', '', 'zoid', '', 'News Entry: Video Post', '', '', 5, '0', '0', '', 0, 'News', '', 0, 1, 2, 0, '', 'en'),
    ('invoice_quote', '', 'zoid', '', 'Project Quote', '', '', 0, '0', '0', '', 0, 'Invoice', '', 0, 1, 2, 0, '', 'en'),
	('invoice_quote_print', '', 'zoid', '', 'Project Quote (Print)', '', '', 0, '0', '0', '', 0, 'Invoice', '', 0, 1, 2, 0, '', 'en');
";

$inserts[] = "
	INSERT INTO `ppSD_templates` (`id`, `theme`, `title`, `type`, `section`, `static`, `owner`)  VALUES
	('calendar_event_entry', 'zoid', 'Entry: Calendar Event', '0', 'Cart', '1', '2'),
	('cart_cc_option', 'zoid', 'Entry: Cart Billing Method Option', '0', 'Cart', '1', '2'),
	('cart_product_entry', 'zoid', 'Entry: Cart Product No Edit', '0', 'Cart', '1', '2'),
	('cart_product_entry_edit', 'zoid', 'Entry: Cart Product with Edit', '0', 'Cart', '1', '2'),
	('cart_product_entry_none', 'zoid', 'Entry: Cart No Products', '0', 'Cart', '1', '2'),
	('cart_product_entry_small', 'zoid', 'Entry: Cart Product Small', '0', 'Cart', '1', '2'),
	('cart_shipping_entry', 'zoid', 'Entry: Shipping Option', '0', 'Cart', '1', '2'),
	('cart_terms_entry', 'zoid', 'Entry: Cart Terms', '0', 'Cart', '1', '2'),
	('catalog_entry', 'zoid', 'Entry: Catalog Product', '0', 'Catalog', '1', '2'),
	('catalog_entry_none', 'zoid', 'Entry: Catalog No Products', '0', 'Catalog', '1', '2'),
	('event_product_entry', 'zoid', 'Entry: Event Product Option', '0', 'Events', '1', '2'),
	('event_timeline_entry', 'zoid', 'Entry: Event Timeline Entry', '0', 'Events', '1', '2'),
	('event_register', 'zoid', 'Event Registration Form', '0', 'Events', '1', '2'),
	('event_register_confirm', 'zoid', 'Event Confirm Registration', '0', 'Events', '1', '2'),
	('event_register_confirmed', 'zoid', 'Event Registration Confirmed', '0', 'Events', '1', '2'),
	('event_register_guests', 'zoid', 'Event Register Guests Number', '0', 'Events', '1', '2'),
	('event_register_guests_info', 'zoid', 'Event Register Guests Form', '0', 'Events', '1', '2'),
	('event_register_pricing', 'zoid', 'Event Register Pricing Options', '0', 'Events', '1', '2'),
	('event_timeline', 'zoid', 'Event Timeline', '0', 'Events', '1', '2'),
	('event_view', 'zoid', 'Event Details', '0', 'Events', '1', '2'),
	('invoice_credit_entry', 'zoid', 'Entry: Invoice Component: Credit', '0', 'Invoice', '1', '2'),
	('invoice_entry', 'zoid', 'Entry: Invoice Component: Product', '0', 'Invoice', '1', '2'),
	('invoice_payment_entry', 'zoid', 'Entry: Invoice Component: Payment', '0', 'Invoice', '1', '2'),
	('invoice_time_entry', 'zoid', 'Entry: Invoice Component: Hourly', '0', 'Invoice', '1', '2'),
	('manage_announcement_entry', 'zoid', 'Manage: Entry: Announcement', '0', 'Member Dashboard ', '1', '2'),
	('manage_billing_history_entry', 'zoid', 'Manage: Entry: Transaction', '0', 'Member Dashboard ', '1', '2'),
	('manage_credit_cards_entry', 'zoid', 'Manage: Entry: Credit Card', '0', 'Member Dashboard ', '1', '2'),
	('manage_event_rsvps_entry', 'zoid', 'Manage: Entry: Event Registration', '0', 'Member Dashboard ', '1', '2'),
	('manage_home_content_entry', 'zoid', 'Manage: Entry: Content', '0', 'Member Dashboard ', '1', '2'),
	('manage_invoice_entry', 'zoid', 'Manage: Entry: Invoice', '0', 'Member Dashboard ', '1', '2'),
	('manage_subscriptions_entry', 'zoid', 'Manage: Entry: Subscription', '0', 'Member Dashboard ', '1', '2'),
	('manage_uploads_entry', 'zoid', 'Manage: Entry: Upload File', '0', 'Member Dashboard ', '1', '2'),
	('popup_cart_added_withupsell', 'zoid', 'Popup: Post-Add: Upsell List', '0', 'Cart', '1', '2'),
	('popup_cart_upgrade_subscription', 'zoid', 'Popup: Upgrade Subscription', '0', 'Cart', '1', '2'),
	('popup_cart_upsell', 'zoid', 'Popup: Entry: Upsell Option', '0', 'Cart', '1', '2'),
	('reg_select_product_entry', 'zoid', 'Registration: Entry: Product Option', '0', 'Register', '1', '2'),
	('register', 'zoid', 'Form', '0', 'Register', '1', '2'),
	('register_list', 'zoid', 'Registration: List Forms', '0', 'Register', '1', '2'),
	('register_list_entry', 'zoid', 'Registration: Entry: Form Option', '0', 'Register', '1', '2'),
	('register_list_entry_none', 'zoid', 'Registration: No form options', '0', 'Register', '1', '2');
";
// ('popup_login_error', 'zoid', 'Popup: Login Error', '0', 'Cart', '1', '2'),
// CC or BCC staff:
// staff:1  (1 being the ID of the staff member)
// CC or BCC Email:
// john@doe.com
// Combined:
// staff:1,john@doe.com
$inserts[] = "
	INSERT INTO `ppSD_templates_email` (`template`, `title`, `desc`, `subject`, `to`, `from`, `cc`, `bcc`, `content`, `format`, `status`, `save`, `track`, `track_links`, `caller_tags`, `custom`, `owner`, `public`, `created`, `header_id`, `footer_id`, `static`, `default_for`, `theme`, `type`) VALUES
	('html_header', 'Default HTML Header', '', '', '', '', '', '', '', 1, 1, 0, 0, 0, '', 0, 2, 0, '" . $date . "', '0', '0', 1, 0, 'threefiveten', 'header'),
	('text_header', 'Default Text Header', '', '', '', '', '', '', 'HEADER!\r\n--------------------------', 0, 0, 0, 0, 0, '', 0, 2, 0, '" . $date . "', '0', '0', 1, 0, 'threefiveten', 'header'),
	('html_footer', 'Default HTML Footer', '', '', '', '', '', '', '', 1, 0, 0, 0, 0, '', 0, 2, 0, '" . $date . "', '0', '0', 1, 0, 'threefiveten', 'footer'),
	('event_rsvp', 'Event Registration (Primary)', '', 'Registration confirmation for %event:name%', '', '', '', '', '', 1, 1, 1, 1, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('text_footer', 'Default Text Footer', '', '', '', '', '', '', '--------------------------\r\nFOOTER!', 0, 0, 0, 0, 0, '', 0, 2, 0, '" . $date . "', '0', '0', 1, 0, 'threefiveten', 'footer'),

	('event_rsvp_guest', 'Event Registration (Guest)', '', 'Registration confirmation for %event:name%', '', '', '', '', '', 1, 1, 1, 1, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('event_reminder',  'Default Event Reminder',  '',  'Event reminder: %event:name% on %event:starts%',  '',  '',  '',  '',  '',  '1',  '1',  '1',  '1',  '0',  '',  '0',  '2',  '0', '" . $date . "',  '',  '',  '1',  '',  'threefiveten',  'template'),
	('event_followup',  'Default Event Followup',  '',  'Thank you for attending \"%event:name%\"!',  '',  '',  '',  '',  '',  '1',  '1',  '0',  '0',  '0',  '',  '',  '2',  '0',  '" . $date . "',  '',  '',  '1',  '',  'threefiveten',  'template'),
	('event_canceled',  'Event Canceled',  '',  'Event \"%event:name%\" Has Been Canceled',  '',  '',  '',  '',  '',  '1',  '1',  '0',  '0',  '0',  '',  '',  '2',  '0',  '" . $date . "',  '',  '',  '1',  '',  'threefiveten',  'template'),

    ('cart_credit_card_expiring', 'Credit Card Expiring', 'Credit card is expiring soon.', 'Your credit card is expiring soon!', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('cart_receipt', 'Cart Receipt', 'Sent for a successful cart purchase.', 'Receipt for Order No. %order:id%', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('cart_subscription_canceled', 'Subscription Canceled', '', 'Subscription No. %subscription:id% Canceled', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('cart_subscription_failed', 'Subscription renewal failure notice', '', 'Subscription Renewal Has Failed', '', '', '', '', '', 1, 1, 1, 1, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('email_activation_code', 'E-Mail Confirmation Required', '', 'E-mail confirmation required', '', '', '', '', '', 1, 1, 0, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('form_request', 'Form Request', 'Request a form be completed by a member or contact.', 'Information request from %pp_company%', '', '', '', '', '', '1', '1', '0', '1', '0', '', '0', '2', '1', '" . $date . "', '', '', '1', '', 'threefiveten', 'template'),
	('account_activated', 'Account Activated', '', 'Your account has been activated', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('cart_subscription_created', 'Subscription Created', '', 'Subscription Created', '', '', '', '', '', 1, 1, 1, 1, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('cart_subscription_renewed', 'Subscription Renewed', '', 'Your subscription has renewed!', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('cart_subscription_no_card',  'Cart Subscription: No Card Notice',  '',  'Your subscription could not be renewed',  '',  '',  '',  '',  '',  '1',  '1',  '1',  '1',  '1',  '',  '',  '2',  '0', '" . $date . "',  '',  '',  '',  '',  'threefiveten',  'template'),
	('cart_subscription_changed', 'Subscription Plan Change', '', 'Subscription No. %subscription:id% Plan Changed', '', '', '', '', '', '1', '1', '1', '0', '0', '', '0', '2', '1', '" . $date . "', '', '', '1', '', 'threefiveten', 'template'),

	('cart_subscription_advanced_notice', 'Subscription: Upcoming Renewal Notice', '', 'Your subscription will renew within %days_until_renewal% days.', '', '', '', '', '', 1, 1, 1, 1, 0, '', 0, 2, 0, '1920-01-01 00:01:01', '', '', 1, 0, 'threefiveten', 'template'),

	('email_reg_complete', 'Registration Complete', '', 'Registration Complete', '', '', '', '', '', 1, 1, 1, 1, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('email_await_activation', 'Application Awaiting Activation', '', 'Your application has been received', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('reset_password_directions', 'Password Reset Instructions', '', 'Password reset instructions', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('email_membership_created', 'Membership Created (From Admin)', '', 'Membership details at %pp_company%', '', '', '', '', '', '1', '1', '1', '0', '0', '', '', '2', '1', '2013-03-01 00:00:00', '', '', '', '', 'threefiveten', 'template'),
	('order_shipped', 'Order Shipment Notification', 'Sent when an order is marked as shipped.', 'Your order has shipped!', '', '', '', '', '', 1, 1, 1, 1, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('refund_issued', 'Refund Issued', 'Refund has been issued on an order.', 'Refund issued for order no. %order:id%', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('invoice', 'Invoice', '', '%pp_company% Invoice No. %invoice:id%', '', '', '', '', '', 1, 1, 1, 1, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('invoice_updated', 'Invoice Updated', 'Sent when an invoice is updated.', 'Your invoice has been updated.', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('invoice_due', 'Invoice payment reminder', '', 'Your invoice is due in %invoice:time_to_due_date%', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('invoice_overdue', 'Overdue invoice notice', '', 'Overdue invoice notice', '', '', '', '', '', 1, 1, 1, 1, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('employee_note_tagged', 'Employee Tagged In Note', '', '%by:first_name% has tagged you in a note.', '', '', '', '', '', 1, 1, 0, 0, 0, '', 0, 1, 1, '1920-01-01 00:01:01', 'html_header', 'html_footer', 0, 0, '', 'template'),
	('invoice_closed', 'Invoice Settled', '', 'Your Invoice has Been Settled', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('campaign_subscription', 'Campaign Subscription Confirmed', '', 'Subscription to %campaign:name% has been confirmed.', '', '', '', '', '', 1, 1, 1, 1, 0, '', 0, 0, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('campaign_double_optin', 'Campaign Double Opt-In Request', '', 'Please confirm your subscription to %campaign:name%', '', '', '', '', '', 1, 1, 0, 0, 0, '', 0, 0, 0, '" . $date . "', '', '', 0, 0, 'threefiveten', 'template'),
	('campaign_unsubscribed', 'Campaign Unsubscription', '', 'You''ve been unsubscribed from %campaign:name%', '', '', '', '', '', 1, 1, 1, 0, 0, '', 0, 2, 0, '" . $date . "', '', '', 0, 0, 'threefiveten', 'template'),
	('reg_code', 'Registration Code', '', 'You are invited to register!', '', '', '', '', '', 1, 1, 0, 1, 1, '', 0, 2, 1, '" . $date . "', '', '', 0, 0, 'threefiveten', 'template'),
	('contact_thankyou', 'Contact Form Received', '', 'Thank you for contacting us!', '', '', '', '', '', '1', '1', '0', '0', '0', '', '', '2', '1', '" . $date . "', '', '', '1', '', 'threefiveten', 'template'),
	('member_status_changed', 'Member Status Changed', '', 'Membership status change', '', '', '', '', '', 1, 1, 1, 1, 0, '', 0, 0, 0, '" . $date . "', '', '', 1, 0, 'threefiveten', 'template'),
	('def_email', 'Default E-Mail Template', '', '', '', '', '', '', '<center><font face=\"Arial\" size=\"2\">%logo%</font></center>\r\n\r\n<div style=\"margin: 24px auto 24px auto;width: 600px;font-family:arial;font-size:12px;color:#333;\">\r\n<p><font face=\"Arial\" size=\"2\">%first_name%,</font></p><p><font face=\"Arial\" size=\"2\"><br></font></p>\r\n\r\n\r\n<p><font face=\"Arial\" size=\"2\">%signature%</font></p>\r\n</div>', 1, 1, 0, 0, 0, '', 1, 2, 0, '" . $date . "', '', '', 0, 1, '', 'template');
";
$inserts[] = "
	INSERT INTO `ppSD_themes` (`id`, `name`, `description`, `author`, `author_url`, `img_1`, `img_2`, `active`, `type`) VALUES
	('zoid', 'Why Not Zoid?', 'Default theme for Zenbership.', 'Zenbership (Castlamp)', 'http://www.zenbership.com/', '', '', 1, 'html'),
	('threefiveten', 'Three Five Ten', 'Default e-mail theme in the HTML format.', 'Zenbership (Castlamp)', 'http://www.zenbership.com/', '', '', 1, 'email');
";
$inserts[] = "
	INSERT INTO `ppSD_widgets` (`id`, `name`, `type`, `menu_type`, `content`, `active`, `add_class`) VALUES
	('user_manage_menu', 'Member Management Menu', 'menu', 'vertical', '', 1, 'zen_menu_vertical zen_gray_box'),
	('login_box', 'Login Box', 'html', '', '<form action=\"%pp_url%/pp-functions/login.php\" method=\"post\" id=\"zen_login_form\" onsubmit=\"return verifyLogin(\'zen_login_form\');\">\r\n    <h2 class=\"zen_notopmargin\">Member Login</h2>\r\n    <div id=\"zen_login_error\"></div>\r\n    <div class=\"zen_gray_box\">\r\n        <div class=\"zen_pad_topl\">\r\n            <ul id=\"zen_form\">\r\n                <li>\r\n                    <label class=\"zen_top zen_medium\">Username</label>\r\n                    <div class=\"zen_field_entry_top\">\r\n                        <input type=\"text\" name=\"username\" class=\"req\" style=\"width:100%;\" />\r\n                        <div id=\"error_username\" class=\"error\"></div>\r\n                    </div>\r\n                </li>\r\n                <li>\r\n                    <label class=\"zen_top zen_medium\">Password</label>\r\n                    <div class=\"zen_field_entry_top\">\r\n                        <input type=\"password\" name=\"password\" class=\"req\" style=\"width:100%;\" />\r\n                        <div id=\"error_password\" class=\"error\"></div>\r\n                    </div>\r\n                </li>\r\n                <li id=\"captcha_block\" class=\"notice\" style=\"display:none;\">\r\n                    <label class=\"zen_left zen_medium\">&nbsp;</label>\r\n                    <div class=\"zen_field_entry zen_medium\">\r\n                        <img width=\"200\" height=\"50\" id=\"captchaput\" class=\"imageout\" src=\"\" /><input type=\"text\" name=\"captcha\" value=\"\" class=\"home\" style=\"width:200px;\" />\r\n                    </div>\r\n                </li>\r\n                <li class=\"zen_center zen_topmargin_less\">\r\n<div class=\"zen_float_right zen_tiny zen_right zen_topmargin_less\"><a href=\"%pp_url%/lost_password.php\">Lost Password</a><br /><a href=\"%pp_url%/register.php\">Register</a></div>\r\n                    <div class=\"zen_float_left\"><input type=\"submit\" value=\"Login\" /></div>\r\n<div class=\"zen_clear\"></div>\r\n                </li>\r\n            </ul>\r\n        </div>\r\n    </div>\r\n</form>', 1, ''),
	('featured_product', 'Feature Products Box', 'code', '', '', 1, ''),
	('member_spotlight', 'Member Spotlight Box', 'code', '', '', 1, ''),
	('upcoming_events', 'Upcoming Events Long List', 'code', '', '', 1, ''),
	('user_uploads', 'User Uploads', 'upload_list', '', '', '1', ''),
	('site_topbar', 'Website Top Navigation', 'menu', 'horizontal', '', '1', 'zen_menu_horizontal'),
	('site_topbar_logged_in', 'Website Top Navigation (Logged In)', 'menu', 'horizontal', '', '1', 'zen_menu_horizontal');
";

$inserts[] = "
    INSERT INTO `ppSD_widgets` (`id`, `name`, `type`, `menu_type`, `content`, `active`, `add_class`, `author`, `author_url`, `author_twitter`, `version`, `installed`, `original_creator`, `original_creator_url`, `description`) VALUES ('not_a_member_box', 'Not a Member Box', 'html', '', '\n            <h2 class=\"\">Not a Member?</h2>\n            <div class=\"zen_gray_box\">\n                <div class=\"zen_pad_topl\">\n                    <p class=\"zen\">Not a problem! Non-members can use our automated online registration system to join.</p>\n\n                    <p class=\"zen\"><a href=\"%pp_url%/register.php?action=reset\">Click here to join!</a></p>\n                </div>\n            </div>', 1, '', '', '', '', '', '1920-01-01 00:01:01', '', '', '');
";

$inserts[] = "
    INSERT INTO `ppSD_departments` (`name`, `head_employee`) VALUES
    ('Administration', '1'),
    ('Employees', '');
";
$inserts[] = "
    INSERT INTO `ppSD_subscription_reattempts` (`fail_attempt`, `timeframe`, `penalty_percent`, `penalty_fixed`, `cancel`) VALUES
    (1, '', '0.00', '0.00', 0),
    (2, '', '0.00', '0.00', 0),
    (3, '', '0.00', '0.00', 0),
    (4, '', '0.00', '0.00', 0),
    (5, '', '0.00', '0.00', 0);
";

$inserts[] = "
	INSERT INTO `ppSD_widgets_menus` (`widget_id`, `submenu`, `title`, `link`, `link_type`, `link_target`, `position`) VALUES
	('user_manage_menu', 0, 'Your Content','" . $use_url . "/manage', 2, 'same', 1),
	('user_manage_menu', 0, 'Update Account','" . $use_url . "/manage/update_account.php', 2, 'same', 2),
	('user_manage_menu', 0, 'Announcements','" . $use_url . "/manage/announcements.php', 2, 'same', 3),
	('user_manage_menu', 0, 'Billing History','" . $use_url . "/manage/billing_history.php', 2, 'same', 4),
	('user_manage_menu', 0, 'Subscriptions','" . $use_url . "/manage/subscriptions.php', 2, 'same', 5),
	('user_manage_menu', 0, 'Credit Cards','" . $use_url . "/manage/credit_cards.php', 2, 'same', 6),
	('user_manage_menu', 0,  'Invoices','" . $use_url . "/manage/invoices.php',  2,  'same',  7),
	('user_manage_menu', 0, 'Event Registrations','" . $use_url . "/manage/events.php', 2, 'same', 8),
	('user_manage_menu', 0, 'Uploads','" . $use_url . "/manage/uploads.php', 2, 'same', 9),
	('user_manage_menu', 0, 'Logout','" . $use_url . "/logout.php', 2, 'same', 10),
	('site_topbar', 0, 'News','" . $use_url . "/news.php', 2, 'same', 1),
	('site_topbar', 0, 'Members','" . $use_url . "/manage', 2, 'same', 2),
	('site_topbar', 0, 'Events','" . $use_url . "/calendar.php', 2, 'same', 3),
	('site_topbar', 0, 'Shop','" . $use_url . "/catalog.php', 2, 'same', 4),
	('site_topbar', 0, 'Cart','" . $use_url . "/cart.php', 2, 'same', 5),
	('site_topbar_logged_in', 0, 'Welcome %username%', 'manage', 2, 'same', 1),
	('site_topbar_logged_in', 0, 'News', 'manage', 2, '" . $use_url . "/news.php', 2),
	('site_topbar_logged_in', 0, 'Events','" . $use_url . "/calendar.php', 2, 'same', 3),
	('site_topbar_logged_in', 0, 'Shop','" . $use_url . "/catalog.php', 2, 'same', 4),
	('site_topbar_logged_in', 0, 'Cart','" . $use_url . "/cart.php', 2, 'same', 5),
	('site_topbar_logged_in', 0, 'Logout','" . $use_url . "/logout.php', 2, 'same', 6);
";