<?php
if (! empty($_POST['id'])) {
    $news = new news($_POST['id'], true);
    $region = $news->getRegion($_POST['id']);
    // $posts = $news->setDisplay(9999)->getPostsInRegion($region['tag']);
    $cid = $_POST['id'];
    $edit = 1;
} else {
    $cid = 'new';
    $edit = 0;
    $posts = array();
    $region = array(
        'name' => '',
        'display' => '',
        'tag' => '',
        'snippet_length' => '',
        'template_set_prefix' => '',
    );
}
?>

<script type="text/javascript">
    $.ctrl('S', function () {
        return json_add('news_regions-add', '<?php echo $cid; ?>', '<?php echo $edit; ?>', 'popupform');
    });
</script>

<form action="" method="post" id="popupform" onsubmit="return json_add('news_regions-add','<?php echo $cid; ?>','<?php echo $edit; ?>');">

    <div id="popupsave">
        <input type="submit" value="Save" class="save"/>
    </div>

    <h1>News Regions</h1>
    <div class="fullForm popupbody">
        <p class="highlight">
            A "news region" is a grouping of news posts that you can include anywhere on your membership website. Each region can have a unique set of templates based on the template prefix set.
        </p>

        <div class="col50l noBorder">

            <fieldset>
                <legend>Overview</legend>
                <div class="pad24t">

                    <label>Name</label>
                    <?php
                    echo $af
                        ->setDescription('The name of this news feed.')
                        ->string('name', $region['name'], 'req');
                    ?>

                    <label>Posts Per Page</label>
                    <?php
                    echo $af
                        ->setSpecialType('number')
                        ->setDescription('If set, the number of posts displayed per page will be fixed to this number.')
                        ->string('display', $region['display'], '');
                    ?>

                    <label>Snippet Length</label>
                    <?php
                    echo $af
                        ->setSpecialType('number')
                        ->setDescription('Controls how long a snippet will be shortened too.')
                        ->string('snippet_length', $region['snippet_length'], '');
                    ?>

                </div>
            </fieldset>


        </div>
        <div class="col50r noBorder">

            <fieldset>
                <legend>Advanced Settings</legend>
                <div class="pad24t">

                    <label>Inclusion Tag</label>
                    <?php
                    echo $af
                        ->setDescription('You can inject a news feed into any template or content page using the {-news_TAG-} syntax. We do NOT recommend changing this once established.')
                        ->string('tag', $region['tag'], 'req');
                    ?>

                    <label>Template Prefix Set</label>
                    <?php
                    echo $af
                        ->setDescription('If you specify a custom prefix set, you will need to create the appropriate templates manually within the "pp-templates/html.../en" directory. Please see the documentation for details')
                        ->string('template_set_prefix', $region['template_set_prefix'], '');
                    ?>

                </div>
            </fieldset>

            <!--
            <fieldset>
                <legend>Posts In Region</legend>
                <div class="pad24t">

                    <h2>Add Posts to this Region</h2>
                    <input type="text" name="_dud_contacts" id="merge_into" style="width:100%;"
                           autocomplete="off" onkeyup="return autocom('merge_into', 'contact_id', 'contact_id,last_name,first_name', 'ppSD_contact_data', 'first_name,last_name,company_name', '', '1');" value=""/>

                    <h2>Existing Posts in Region</h2>
                    <?php
                    foreach ($posts as $aPost) {
                        echo "<li>" . $aPost['title'];
                    }
                    pa($posts);
                    ?>

                </div>
            </fieldset>
        -->

        </div>

    </div>

</form>