<?php

if (empty($_POST['account'])) {
    $admin->show_popup_error('No account selected.');

} else {
    $account   = new account;
    $data      = $account->get_account($_POST['account']);
    $ownership = new ownership($data['owner'], $data['public']);
    if (!empty($data['error'])) {
        $admin->show_popup_error('Account not found.');

    } else if ($ownership->result != '1') {
        $admin->show_popup_error($ownership->reason);

    } else {
        $list  = '';
        $notes = $db->run_query("

            SELECT

                ppSD_notes.name,

                ppSD_notes.deadline,

                ppSD_notes.note,

                ppSD_notes.user_id,

                ppSD_notes.item_scope,

                ppSD_notes.label,

                ppSD_notes.added_by,

                ppSD_notes.date,

                ppSD_members.id,

                ppSD_contacts.id,

                ppSD_accounts.id,

                ppSD_notes.id

            FROM

                `ppSD_notes`

            LEFT JOIN

                `ppSD_contacts`

                ON ppSD_contacts.account='" . $db->mysql_clean($_POST['account']) . "'

            LEFT JOIN

                `ppSD_members`

                ON ppSD_members.account='" . $db->mysql_clean($_POST['account']) . "'

            LEFT JOIN

                `ppSD_accounts`

                ON ppSD_accounts.id='" . $db->mysql_clean($_POST['account']) . "'

            WHERE

                (

                    ppSD_notes.user_id=ppSD_members.id OR

                    ppSD_notes.user_id=ppSD_contacts.id OR

                    ppSD_notes.user_id=ppSD_accounts.id

                ) AND (

                    ppSD_notes.public='2' OR

                    ppSD_notes.for='" . $db->mysql_clean($employee['id']) . "' OR

                    ppSD_notes.added_by='" . $db->mysql_clean($employee['id']) . "'

                )

            GROUP BY

                ppSD_notes.id

            ORDER BY

                ppSD_notes.date ASC

        ");
        while ($row = $notes->fetch()) {
            $list .= $admin->format_note($row, '1');

        }
        if (empty($list)) {
            $list = '<div class="weak">No notes with a deadline today to display.</div>';

        }

        ?>



        <h1>Note Stream</h1>

        <div class="pad24t popupbody">

            <?php echo $list; ?>

        </div>



    <?php

    }

}

?>