<?php

$cart = new cart();
$card = $cart->get_card($_POST['id']);
if (empty($card['id'])) {
    $admin->show_popup_error('Card not found.');

} else {
    if (!empty($card['gateway'])) {
        $gateway = $cart->get_gateways('', $card['gateway']);
        if ($gateway['0']['local_card_storage'] == '1') {
            $stored = '<a href="' . $gateway['0']['online'] . '" target="_blank">' . $gateway['0']['name'] . ' (Stored Locally)</a>';

        } else {
            $token = '';
            if (!empty($card['gateway_id_1'])) {
                $token .= $card['gateway_id_1'];

            }
            if (!empty($card['gateway_id_2'])) {
                $token .= '/' . $card['gateway_id_2'];

            }
            $stored = '<a href="' . $gateway['0']['online'] . '" target="_blank">' . $gateway['0']['name'] . '</a> (Tokenized: ' . $token . ')';

        }

    } else {
        $stored = 'Locally';

    }



    ?>



    <h1>Credit Card Management</h1>



    <div class="pad24t popupbody">


        <fieldset>

            <legend>Current Credit Card</legend>

            <div class="pad24t">


                <dl>

                    <dt>Card Number</dt>

                    <dd><?php echo $card['full_method'] . $card['img']; ?></dd>

                    <dt>Stored</dt>

                    <dd><?php echo $stored; ?></dd>

                    <dt>Expires</dt>

                    <dd><?php echo $card['card_exp_mm'] . '/' . $card['card_exp_yy']; ?></dd>

                    <dt>Name</dt>

                    <dd><?php echo $card['first_name'] . ' ' . $card['last_name']; ?></dd>

                    <dt>Address</dt>

                    <dd><?php echo $card['address_line_1']; ?></dd>

                    <dt>Address Line 2</dt>

                    <dd><?php echo $card['address_line_2']; ?></dd>

                    <dt>City</dt>

                    <dd><?php echo $card['city']; ?></dd>

                    <dt>State</dt>

                    <dd><?php echo $card['state']; ?></dd>

                    <dt>Zip</dt>

                    <dd><?php echo $card['zip']; ?></dd>

                    <dt>Country</dt>

                    <dd><?php echo $card['country']; ?></dd>

                    <dt>Phone</dt>

                    <dd><?php echo $card['phone']; ?></dd>

                </dl>

                <div class="clear"></div>


            </div>

        </fieldset>


        <fieldset>

            <legend>Options</legend>

            <div class="pad24t">

                <p><a href="null.php"
                      onclick="return delete_item('ppSD_cart_billing','<?php echo $card['id'] ?>','','','1');">Delete
                        this card</a></p>

            </div>

        </fieldset>


    </div>



<?php

}

?>