<?php

function getCollationSetClause() {
		if (hasUtf8mb4Support('utf8mb4_520')) { // MySQL 5.6+ 
			return ' CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci';
		} else if (hasUtf8mb4Support('utf8mb4')) { // MySQL 5.5.3+
			return ' CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci';
		} else {
			return ' CHARACTER SET utf8 COLLATE utf8_unicode_ci';
		}
	}

function hasUtf8mb4Support($which = 'utf8mb4_520') {
		$db_version = getVersion();
		if ($db_version) { // if not set no db functions available
			switch ($which) {
				case 'utf8mb4':
					if (isMariaDB() && version_compare($db_version, '5.5.0', '<')) {
						return false;
					} else if (version_compare($db_version, '5.5.3', '<')) {
						return false;
					}
					$client_version = mysqli_get_client_info();
					/*
					 * libmysql has supported utf8mb4 since 5.5.3, same as the MySQL server.
					 * mysqlnd has supported utf8mb4 since 5.0.9.
					 */
					if (strpos($client_version, 'mysqlnd') !== false) {
						$client_version = preg_replace('/^\D+([\d.]+).*/', '$1', $client_version);
						return version_compare($client_version, '5.0.9', '>=');
					} else {
						return version_compare($client_version, '5.5.3', '>=');
					}
				case 'utf8mb4_520':
					return version_compare($db_version, '5.6', '>=');
				case 'general':
					return (hasUtf8mb4Support('utf8mb4') || hasUtf8mb4Support('utf8mb4_520'));
			}
		}
		return false;
	}
	
function getVersion() {
		$software = getVersionComplete();
		if ($software) {
			if (isMariaDB()) {
				preg_match("/\d+(\.\d+){2,}-MariaDB/", $software, $matches);
				if ($matches) {
					return str_replace('-MariaDB', '', $matches[0]);
				}
				return $software; // just in case…
			} else {
				return $software;
			}
		}
		return '0.0.0';
	}
	
function getVersionComplete() {
	global $connection;
	
	$connection = mysqli_connect("[[softdbhost]]","[[softdbuser]]","[[softdbpass]]","[[softdb]]");

	if ($connection) {
		$query = mysqli_fetch_array(mysqli_query($connection, "SELECT version()"));
		if ($query) {
			return $query['version()'];
		}
	}
	return null;
}
	
function isMariaDB() {
	$db_version = getVersionComplete();
	if ($db_version && stristr($db_version, 'mariadb')) { // version includes note if mariadb
		return true;
	}
	return false;
}
	$charset_value = getCollationSetClause();
	
	if(!empty($charset_value)){
		echo '<charset_value>'.$charset_value.'</charset_value>';
	}

?>