/*
YUI 3.18.1 (build f7e7bcb)
Copyright 2014 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/color-hsl/color-hsl.js']) {
   __coverage__['build/color-hsl/color-hsl.js'] = {"path":"build/color-hsl/color-hsl.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0,"51":0,"52":0,"53":0,"54":0,"55":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0],"14":[0,0],"15":[0,0],"16":[0,0],"17":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":21},"end":{"line":1,"column":40}}},"2":{"name":"(anonymous_2)","line":53,"loc":{"start":{"line":53,"column":11},"end":{"line":53,"column":26}}},"3":{"name":"(anonymous_3)","line":66,"loc":{"start":{"line":66,"column":12},"end":{"line":66,"column":27}}},"4":{"name":"(anonymous_4)","line":81,"loc":{"start":{"line":81,"column":15},"end":{"line":81,"column":39}}},"5":{"name":"(anonymous_5)","line":147,"loc":{"start":{"line":147,"column":15},"end":{"line":147,"column":39}}},"6":{"name":"(anonymous_6)","line":190,"loc":{"start":{"line":190,"column":15},"end":{"line":190,"column":35}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":218,"column":43}},"2":{"start":{"line":16,"column":0},"end":{"line":210,"column":2}},"3":{"start":{"line":54,"column":8},"end":{"line":54,"column":49}},"4":{"start":{"line":55,"column":8},"end":{"line":55,"column":33}},"5":{"start":{"line":67,"column":8},"end":{"line":67,"column":50}},"6":{"start":{"line":68,"column":8},"end":{"line":68,"column":33}},"7":{"start":{"line":82,"column":8},"end":{"line":91,"column":28}},"8":{"start":{"line":94,"column":8},"end":{"line":96,"column":9}},"9":{"start":{"line":95,"column":12},"end":{"line":95,"column":31}},"10":{"start":{"line":99,"column":8},"end":{"line":107,"column":9}},"11":{"start":{"line":100,"column":12},"end":{"line":100,"column":18}},"12":{"start":{"line":101,"column":15},"end":{"line":107,"column":9}},"13":{"start":{"line":102,"column":12},"end":{"line":102,"column":51}},"14":{"start":{"line":103,"column":15},"end":{"line":107,"column":9}},"15":{"start":{"line":104,"column":12},"end":{"line":104,"column":43}},"16":{"start":{"line":106,"column":12},"end":{"line":106,"column":43}},"17":{"start":{"line":110,"column":8},"end":{"line":110,"column":20}},"18":{"start":{"line":113,"column":8},"end":{"line":119,"column":9}},"19":{"start":{"line":114,"column":12},"end":{"line":114,"column":18}},"20":{"start":{"line":115,"column":15},"end":{"line":119,"column":9}},"21":{"start":{"line":116,"column":12},"end":{"line":116,"column":26}},"22":{"start":{"line":118,"column":12},"end":{"line":118,"column":32}},"23":{"start":{"line":121,"column":8},"end":{"line":123,"column":9}},"24":{"start":{"line":122,"column":12},"end":{"line":122,"column":18}},"25":{"start":{"line":126,"column":8},"end":{"line":126,"column":26}},"26":{"start":{"line":127,"column":8},"end":{"line":127,"column":32}},"27":{"start":{"line":128,"column":8},"end":{"line":128,"column":32}},"28":{"start":{"line":130,"column":8},"end":{"line":132,"column":9}},"29":{"start":{"line":131,"column":12},"end":{"line":131,"column":29}},"30":{"start":{"line":134,"column":8},"end":{"line":134,"column":56}},"31":{"start":{"line":150,"column":8},"end":{"line":158,"column":14}},"32":{"start":{"line":160,"column":8},"end":{"line":164,"column":9}},"33":{"start":{"line":161,"column":12},"end":{"line":161,"column":28}},"34":{"start":{"line":163,"column":12},"end":{"line":163,"column":34}},"35":{"start":{"line":166,"column":8},"end":{"line":166,"column":22}},"36":{"start":{"line":168,"column":8},"end":{"line":168,"column":61}},"37":{"start":{"line":169,"column":8},"end":{"line":169,"column":55}},"38":{"start":{"line":170,"column":8},"end":{"line":170,"column":61}},"39":{"start":{"line":172,"column":8},"end":{"line":174,"column":9}},"40":{"start":{"line":173,"column":12},"end":{"line":173,"column":29}},"41":{"start":{"line":176,"column":8},"end":{"line":176,"column":54}},"42":{"start":{"line":192,"column":8},"end":{"line":196,"column":9}},"43":{"start":{"line":193,"column":12},"end":{"line":193,"column":21}},"44":{"start":{"line":194,"column":15},"end":{"line":196,"column":9}},"45":{"start":{"line":195,"column":12},"end":{"line":195,"column":21}},"46":{"start":{"line":198,"column":8},"end":{"line":200,"column":9}},"47":{"start":{"line":199,"column":12},"end":{"line":199,"column":41}},"48":{"start":{"line":201,"column":8},"end":{"line":203,"column":9}},"49":{"start":{"line":202,"column":12},"end":{"line":202,"column":21}},"50":{"start":{"line":204,"column":8},"end":{"line":206,"column":9}},"51":{"start":{"line":205,"column":12},"end":{"line":205,"column":49}},"52":{"start":{"line":207,"column":8},"end":{"line":207,"column":17}},"53":{"start":{"line":212,"column":0},"end":{"line":212,"column":32}},"54":{"start":{"line":214,"column":0},"end":{"line":214,"column":67}},"55":{"start":{"line":215,"column":0},"end":{"line":215,"column":79}}},"branchMap":{"1":{"line":94,"type":"if","locations":[{"start":{"line":94,"column":8},"end":{"line":94,"column":8}},{"start":{"line":94,"column":8},"end":{"line":94,"column":8}}]},"2":{"line":94,"type":"binary-expr","locations":[{"start":{"line":94,"column":12},"end":{"line":94,"column":19}},{"start":{"line":94,"column":23},"end":{"line":94,"column":30}}]},"3":{"line":99,"type":"if","locations":[{"start":{"line":99,"column":8},"end":{"line":99,"column":8}},{"start":{"line":99,"column":8},"end":{"line":99,"column":8}}]},"4":{"line":101,"type":"if","locations":[{"start":{"line":101,"column":15},"end":{"line":101,"column":15}},{"start":{"line":101,"column":15},"end":{"line":101,"column":15}}]},"5":{"line":103,"type":"if","locations":[{"start":{"line":103,"column":15},"end":{"line":103,"column":15}},{"start":{"line":103,"column":15},"end":{"line":103,"column":15}}]},"6":{"line":113,"type":"if","locations":[{"start":{"line":113,"column":8},"end":{"line":113,"column":8}},{"start":{"line":113,"column":8},"end":{"line":113,"column":8}}]},"7":{"line":113,"type":"binary-expr","locations":[{"start":{"line":113,"column":12},"end":{"line":113,"column":19}},{"start":{"line":113,"column":23},"end":{"line":113,"column":30}}]},"8":{"line":115,"type":"if","locations":[{"start":{"line":115,"column":15},"end":{"line":115,"column":15}},{"start":{"line":115,"column":15},"end":{"line":115,"column":15}}]},"9":{"line":121,"type":"if","locations":[{"start":{"line":121,"column":8},"end":{"line":121,"column":8}},{"start":{"line":121,"column":8},"end":{"line":121,"column":8}}]},"10":{"line":130,"type":"if","locations":[{"start":{"line":130,"column":8},"end":{"line":130,"column":8}},{"start":{"line":130,"column":8},"end":{"line":130,"column":8}}]},"11":{"line":160,"type":"if","locations":[{"start":{"line":160,"column":8},"end":{"line":160,"column":8}},{"start":{"line":160,"column":8},"end":{"line":160,"column":8}}]},"12":{"line":172,"type":"if","locations":[{"start":{"line":172,"column":8},"end":{"line":172,"column":8}},{"start":{"line":172,"column":8},"end":{"line":172,"column":8}}]},"13":{"line":192,"type":"if","locations":[{"start":{"line":192,"column":8},"end":{"line":192,"column":8}},{"start":{"line":192,"column":8},"end":{"line":192,"column":8}}]},"14":{"line":194,"type":"if","locations":[{"start":{"line":194,"column":15},"end":{"line":194,"column":15}},{"start":{"line":194,"column":15},"end":{"line":194,"column":15}}]},"15":{"line":198,"type":"if","locations":[{"start":{"line":198,"column":8},"end":{"line":198,"column":8}},{"start":{"line":198,"column":8},"end":{"line":198,"column":8}}]},"16":{"line":201,"type":"if","locations":[{"start":{"line":201,"column":8},"end":{"line":201,"column":8}},{"start":{"line":201,"column":8},"end":{"line":201,"column":8}}]},"17":{"line":204,"type":"if","locations":[{"start":{"line":204,"column":8},"end":{"line":204,"column":8}},{"start":{"line":204,"column":8},"end":{"line":204,"column":8}}]}},"code":["(function () { YUI.add('color-hsl', function (Y, NAME) {","","/**","Color provides static methods for color conversion to hsl values.","","    Y.Color.toHSL('f00'); // hsl(0, 100%, 50%)","","    Y.Color.toHSLA('rgb(255, 255, 0'); // hsla(60, 100%, 50%, 1)","","@module color","@submodule color-hsl","@class HSL","@namespace Color","@since 3.8.0","**/","Color = {","","    /**","    @static","    @property REGEX_HSL","    @type RegExp","    @default /hsla?\\(([.\\d]*), ?([.\\d]*)%, ?([.\\d]*)%,? ?([.\\d]*)?\\)/","    @since 3.8.0","    **/","    REGEX_HSL: /hsla?\\(([.\\d]*), ?([.\\d]*)%, ?([.\\d]*)%,? ?([.\\d]*)?\\)/,","","    /**","    @static","    @property STR_HSL","    @type String","    @default hsl({*}, {*}%, {*}%)","    @since 3.8.0","    **/","    STR_HSL: 'hsl({*}, {*}%, {*}%)',","","    /**","    @static","    @property STR_HSLA","    @type String","    @default hsla({*}, {*}%, {*}%, {*})","    @since 3.8.0","    **/","    STR_HSLA: 'hsla({*}, {*}%, {*}%, {*})',","","    /**","    Converts provided color value to an HSL string.","    @public","    @method toHSL","    @param {String} str","    @return {String}","    @since 3.8.0","    **/","    toHSL: function (str) {","        var clr = Y.Color._convertTo(str, 'hsl');","        return clr.toLowerCase();","    },","","    /**","    Converts provided color value to an HSLA string.","    @public","    @method toHSLA","    @param {String} str","    @return {String}","    @since 3.8.0","    **/","    toHSLA: function (str) {","        var clr = Y.Color._convertTo(str, 'hsla');","        return clr.toLowerCase();","    },","","    /**","    Parses the RGB string into h, s, l values. Will return an Array","        of values or an HSL string.","    @protected","    @method _rgbToHsl","    @param {String} str","    @param {Boolean} [toArray]","    @return {String|Array}","    @since 3.8.0","    **/","    _rgbToHsl: function (str, toArray) {","        var h, s, l,","            rgb = Y.Color.REGEX_RGB.exec(str),","            r = rgb[1] / 255,","            g = rgb[2] / 255,","            b = rgb[3] / 255,","            max = Math.max(r, g, b),","            min = Math.min(r, g, b),","            isGrayScale = false,","            sub = max - min,","            sum = max + min;","","","        if (r === g && g === b) {","            isGrayScale = true;","        }","","        // hue","        if (sub === 0) {","            h = 0;","        } else if (r === max) {","            h = ((60 * (g - b) / sub) + 360) % 360;","        } else if (g === max) {","            h = (60 * (b - r) / sub) + 120;","        } else {","            h = (60 * (r - g) / sub) + 240;","        }","","        // lightness","        l = sum / 2;","","        // saturation","        if (l === 0 || l === 1) {","            s = l;","        } else if (l <= 0.5) {","            s = sub / sum;","        } else {","            s = sub / (2 - sum);","        }","","        if (isGrayScale) {","            s = 0;","        }","","        // clean up hsl","        h = Math.round(h);","        s = Math.round(s * 100);","        l = Math.round(l * 100);","","        if (toArray) {","            return [h, s, l];","        }","","        return 'hsl(' + h + ', ' + s + '%, ' + l + '%)';","    },","","    /**","    Parses the HSL string into r, b, g values. Will return an Array","        of values or an RGB string.","    @protected","    @method _hslToRgb","    @param {String} str","    @param {Boolean} [toArray]","    @return {String|Array}","    @since 3.8.0","    **/","    _hslToRgb: function (str, toArray) {","        // assume input is [h, s, l]","        // TODO: Find legals for use of formula","        var hsl = Y.Color.REGEX_HSL.exec(str),","            h = parseInt(hsl[1], 10) / 360,","            s = parseInt(hsl[2], 10) / 100,","            l = parseInt(hsl[3], 10) / 100,","            r,","            g,","            b,","            p,","            q;","","        if (l <= 0.5) {","            q = l * (s + 1);","        } else {","            q = (l + s) - (l * s);","        }","","        p = 2 * l - q;","","        r = Math.round(Color._hueToRGB(p, q, h + 1/3) * 255);","        g = Math.round(Color._hueToRGB(p, q, h) * 255);","        b = Math.round(Color._hueToRGB(p, q, h - 1/3) * 255);","","        if (toArray) {","            return [r, g, b];","        }","","        return 'rgb(' + r + ', ' + g + ', ' + b + ')';","    },","","    /**","    Converts the HSL hue to the different channels for RGB","","    @protected","    @method _hueToRGB","    @param {Number} p","    @param {Number} q","    @param {Number} hue","    @return {Number} value for requested channel","    @since 3.8.0","    **/","    _hueToRGB: function(p, q, hue) {","        // TODO: Find legals for use of formula","        if (hue < 0) {","            hue += 1;","        } else if (hue > 1) {","            hue -= 1;","        }","","        if (hue * 6 < 1) {","            return p + (q - p) * 6 * hue;","        }","        if (hue * 2 < 1) {","            return q;","        }","        if (hue * 3 < 2) {","            return p + (q - p) * (2/3 - hue) * 6;","        }","        return p;","    }","","};","","Y.Color = Y.mix(Color, Y.Color);","","Y.Color.TYPES = Y.mix(Y.Color.TYPES, {'HSL':'hsl', 'HSLA':'hsla'});","Y.Color.CONVERTS = Y.mix(Y.Color.CONVERTS, {'hsl': 'toHSL', 'hsla': 'toHSLA'});","","","}, '3.18.1', {\"requires\": [\"color-base\"]});","","}());"]};
}
var __cov_ta2aTZ8L7ss7o4ZwXJcOMQ = __coverage__['build/color-hsl/color-hsl.js'];
__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['1']++;YUI.add('color-hsl',function(Y,NAME){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.f['1']++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['2']++;Color={REGEX_HSL:/hsla?\(([.\d]*), ?([.\d]*)%, ?([.\d]*)%,? ?([.\d]*)?\)/,STR_HSL:'hsl({*}, {*}%, {*}%)',STR_HSLA:'hsla({*}, {*}%, {*}%, {*})',toHSL:function(str){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.f['2']++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['3']++;var clr=Y.Color._convertTo(str,'hsl');__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['4']++;return clr.toLowerCase();},toHSLA:function(str){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.f['3']++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['5']++;var clr=Y.Color._convertTo(str,'hsla');__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['6']++;return clr.toLowerCase();},_rgbToHsl:function(str,toArray){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.f['4']++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['7']++;var h,s,l,rgb=Y.Color.REGEX_RGB.exec(str),r=rgb[1]/255,g=rgb[2]/255,b=rgb[3]/255,max=Math.max(r,g,b),min=Math.min(r,g,b),isGrayScale=false,sub=max-min,sum=max+min;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['8']++;if((__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['2'][0]++,r===g)&&(__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['2'][1]++,g===b)){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['1'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['9']++;isGrayScale=true;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['1'][1]++;}__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['10']++;if(sub===0){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['3'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['11']++;h=0;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['3'][1]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['12']++;if(r===max){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['4'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['13']++;h=(60*(g-b)/sub+360)%360;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['4'][1]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['14']++;if(g===max){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['5'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['15']++;h=60*(b-r)/sub+120;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['5'][1]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['16']++;h=60*(r-g)/sub+240;}}}__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['17']++;l=sum/2;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['18']++;if((__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['7'][0]++,l===0)||(__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['7'][1]++,l===1)){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['6'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['19']++;s=l;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['6'][1]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['20']++;if(l<=0.5){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['8'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['21']++;s=sub/sum;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['8'][1]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['22']++;s=sub/(2-sum);}}__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['23']++;if(isGrayScale){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['9'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['24']++;s=0;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['9'][1]++;}__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['25']++;h=Math.round(h);__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['26']++;s=Math.round(s*100);__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['27']++;l=Math.round(l*100);__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['28']++;if(toArray){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['10'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['29']++;return[h,s,l];}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['10'][1]++;}__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['30']++;return'hsl('+h+', '+s+'%, '+l+'%)';},_hslToRgb:function(str,toArray){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.f['5']++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['31']++;var hsl=Y.Color.REGEX_HSL.exec(str),h=parseInt(hsl[1],10)/360,s=parseInt(hsl[2],10)/100,l=parseInt(hsl[3],10)/100,r,g,b,p,q;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['32']++;if(l<=0.5){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['11'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['33']++;q=l*(s+1);}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['11'][1]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['34']++;q=l+s-l*s;}__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['35']++;p=2*l-q;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['36']++;r=Math.round(Color._hueToRGB(p,q,h+1/3)*255);__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['37']++;g=Math.round(Color._hueToRGB(p,q,h)*255);__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['38']++;b=Math.round(Color._hueToRGB(p,q,h-1/3)*255);__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['39']++;if(toArray){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['12'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['40']++;return[r,g,b];}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['12'][1]++;}__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['41']++;return'rgb('+r+', '+g+', '+b+')';},_hueToRGB:function(p,q,hue){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.f['6']++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['42']++;if(hue<0){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['13'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['43']++;hue+=1;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['13'][1]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['44']++;if(hue>1){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['14'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['45']++;hue-=1;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['14'][1]++;}}__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['46']++;if(hue*6<1){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['15'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['47']++;return p+(q-p)*6*hue;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['15'][1]++;}__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['48']++;if(hue*2<1){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['16'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['49']++;return q;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['16'][1]++;}__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['50']++;if(hue*3<2){__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['17'][0]++;__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['51']++;return p+(q-p)*(2/3-hue)*6;}else{__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.b['17'][1]++;}__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['52']++;return p;}};__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['53']++;Y.Color=Y.mix(Color,Y.Color);__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['54']++;Y.Color.TYPES=Y.mix(Y.Color.TYPES,{'HSL':'hsl','HSLA':'hsla'});__cov_ta2aTZ8L7ss7o4ZwXJcOMQ.s['55']++;Y.Color.CONVERTS=Y.mix(Y.Color.CONVERTS,{'hsl':'toHSL','hsla':'toHSLA'});},'3.18.1',{'requires':['color-base']});
