/*
YUI 3.18.1 (build f7e7bcb)
Copyright 2014 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/node-style/node-style.js']) {
   __coverage__['build/node-style/node-style.js'] = {"path":"build/node-style/node-style.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":22},"end":{"line":1,"column":41}}},"2":{"name":"(anonymous_2)","line":3,"loc":{"start":{"line":3,"column":1},"end":{"line":3,"column":13}}},"3":{"name":"(anonymous_3)","line":19,"loc":{"start":{"line":19,"column":14},"end":{"line":19,"column":34}}},"4":{"name":"(anonymous_4)","line":31,"loc":{"start":{"line":31,"column":15},"end":{"line":31,"column":30}}},"5":{"name":"(anonymous_5)","line":45,"loc":{"start":{"line":45,"column":15},"end":{"line":45,"column":30}}},"6":{"name":"(anonymous_6)","line":56,"loc":{"start":{"line":56,"column":23},"end":{"line":56,"column":38}}},"7":{"name":"(anonymous_7)","line":124,"loc":{"start":{"line":124,"column":10},"end":{"line":124,"column":29}}},"8":{"name":"(anonymous_8)","line":137,"loc":{"start":{"line":137,"column":11},"end":{"line":137,"column":22}}},"9":{"name":"(anonymous_9)","line":156,"loc":{"start":{"line":156,"column":15},"end":{"line":156,"column":26}}},"10":{"name":"(anonymous_10)","line":170,"loc":{"start":{"line":170,"column":16},"end":{"line":170,"column":39}}},"11":{"name":"(anonymous_11)","line":175,"loc":{"start":{"line":175,"column":17},"end":{"line":175,"column":40}}},"12":{"name":"(anonymous_12)","line":207,"loc":{"start":{"line":207,"column":10},"end":{"line":207,"column":29}}},"13":{"name":"(anonymous_13)","line":220,"loc":{"start":{"line":220,"column":11},"end":{"line":220,"column":22}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":271,"column":55}},"2":{"start":{"line":3,"column":0},"end":{"line":103,"column":6}},"3":{"start":{"line":10,"column":0},"end":{"line":59,"column":3}},"4":{"start":{"line":20,"column":8},"end":{"line":20,"column":46}},"5":{"start":{"line":21,"column":8},"end":{"line":21,"column":20}},"6":{"start":{"line":32,"column":8},"end":{"line":32,"column":42}},"7":{"start":{"line":33,"column":8},"end":{"line":33,"column":20}},"8":{"start":{"line":46,"column":8},"end":{"line":46,"column":48}},"9":{"start":{"line":57,"column":8},"end":{"line":57,"column":56}},"10":{"start":{"line":102,"column":0},"end":{"line":102,"column":101}},"11":{"start":{"line":109,"column":0},"end":{"line":109,"column":20}},"12":{"start":{"line":111,"column":0},"end":{"line":228,"column":3}},"13":{"start":{"line":125,"column":8},"end":{"line":125,"column":51}},"14":{"start":{"line":126,"column":8},"end":{"line":126,"column":40}},"15":{"start":{"line":127,"column":8},"end":{"line":127,"column":20}},"16":{"start":{"line":138,"column":8},"end":{"line":138,"column":39}},"17":{"start":{"line":143,"column":8},"end":{"line":143,"column":37}},"18":{"start":{"line":157,"column":8},"end":{"line":157,"column":104}},"19":{"start":{"line":171,"column":8},"end":{"line":171,"column":48}},"20":{"start":{"line":172,"column":8},"end":{"line":172,"column":20}},"21":{"start":{"line":176,"column":8},"end":{"line":176,"column":51}},"22":{"start":{"line":179,"column":8},"end":{"line":181,"column":9}},"23":{"start":{"line":180,"column":12},"end":{"line":180,"column":44}},"24":{"start":{"line":183,"column":8},"end":{"line":187,"column":9}},"25":{"start":{"line":184,"column":12},"end":{"line":184,"column":25}},"26":{"start":{"line":186,"column":12},"end":{"line":186,"column":25}},"27":{"start":{"line":189,"column":8},"end":{"line":191,"column":9}},"28":{"start":{"line":190,"column":12},"end":{"line":190,"column":32}},"29":{"start":{"line":193,"column":8},"end":{"line":193,"column":20}},"30":{"start":{"line":208,"column":8},"end":{"line":208,"column":51}},"31":{"start":{"line":209,"column":8},"end":{"line":209,"column":41}},"32":{"start":{"line":210,"column":8},"end":{"line":210,"column":20}},"33":{"start":{"line":221,"column":8},"end":{"line":221,"column":46}},"34":{"start":{"line":226,"column":8},"end":{"line":226,"column":41}},"35":{"start":{"line":230,"column":0},"end":{"line":268,"column":3}}},"branchMap":{"1":{"line":157,"type":"binary-expr","locations":[{"start":{"line":157,"column":16},"end":{"line":157,"column":43}},{"start":{"line":157,"column":47},"end":{"line":157,"column":103}}]},"2":{"line":179,"type":"if","locations":[{"start":{"line":179,"column":8},"end":{"line":179,"column":8}},{"start":{"line":179,"column":8},"end":{"line":179,"column":8}}]},"3":{"line":180,"type":"cond-expr","locations":[{"start":{"line":180,"column":38},"end":{"line":180,"column":39}},{"start":{"line":180,"column":42},"end":{"line":180,"column":43}}]},"4":{"line":183,"type":"if","locations":[{"start":{"line":183,"column":8},"end":{"line":183,"column":8}},{"start":{"line":183,"column":8},"end":{"line":183,"column":8}}]},"5":{"line":189,"type":"if","locations":[{"start":{"line":189,"column":8},"end":{"line":189,"column":8}},{"start":{"line":189,"column":8},"end":{"line":189,"column":8}}]}},"code":["(function () { YUI.add('node-style', function (Y, NAME) {","","(function(Y) {","/**"," * Extended Node interface for managing node styles."," * @module node"," * @submodule node-style"," */","","Y.mix(Y.Node.prototype, {","    /**","     * Sets a style property of the node.","     * Use camelCase (e.g. 'backgroundColor') for multi-word properties.","     * @method setStyle","     * @param {String} attr The style attribute to set.","     * @param {String|Number} val The value.","     * @chainable","     */","    setStyle: function(attr, val) {","        Y.DOM.setStyle(this._node, attr, val);","        return this;","    },","","    /**","     * Sets multiple style properties on the node.","     * Use camelCase (e.g. 'backgroundColor') for multi-word properties.","     * @method setStyles","     * @param {Object} hash An object literal of property:value pairs.","     * @chainable","     */","    setStyles: function(hash) {","        Y.DOM.setStyles(this._node, hash);","        return this;","    },","","    /**","     * Returns the style's current value.","     * Use camelCase (e.g. 'backgroundColor') for multi-word properties.","     * @method getStyle","     * @for Node","     * @param {String} attr The style attribute to retrieve.","     * @return {String} The current value of the style property for the element.","     */","","     getStyle: function(attr) {","        return Y.DOM.getStyle(this._node, attr);","     },","","    /**","     * Returns the computed value for the given style property.","     * Use camelCase (e.g. 'backgroundColor') for multi-word properties.","     * @method getComputedStyle","     * @param {String} attr The style attribute to retrieve.","     * @return {String} The computed value of the style property for the element.","     */","     getComputedStyle: function(attr) {","        return Y.DOM.getComputedStyle(this._node, attr);","     }","});","","/**"," * Returns an array of values for each node."," * Use camelCase (e.g. 'backgroundColor') for multi-word properties."," * @method getStyle"," * @for NodeList"," * @see Node.getStyle"," * @param {String} attr The style attribute to retrieve."," * @return {Array} The current values of the style property for the element."," */","","/**"," * Returns an array of the computed value for each node."," * Use camelCase (e.g. 'backgroundColor') for multi-word properties."," * @method getComputedStyle"," * @see Node.getComputedStyle"," * @param {String} attr The style attribute to retrieve."," * @return {Array} The computed values for each node."," */","","/**"," * Sets a style property on each node."," * Use camelCase (e.g. 'backgroundColor') for multi-word properties."," * @method setStyle"," * @see Node.setStyle"," * @param {String} attr The style attribute to set."," * @param {String|Number} val The value."," * @chainable"," */","","/**"," * Sets multiple style properties on each node."," * Use camelCase (e.g. 'backgroundColor') for multi-word properties."," * @method setStyles"," * @see Node.setStyles"," * @param {Object} hash An object literal of property:value pairs."," * @chainable"," */","","// These are broken out to handle undefined return (avoid false positive for","// chainable)","","Y.NodeList.importMethod(Y.Node.prototype, ['getStyle', 'getComputedStyle', 'setStyle', 'setStyles']);","})(Y);","/**"," * @module node"," * @submodule node-base"," */","","var Y_Node = Y.Node;","","Y.mix(Y_Node.prototype, {","    /**","     * Makes the node visible.","     * If the \"transition\" module is loaded, show optionally","     * animates the showing of the node using either the default","     * transition effect ('fadeIn'), or the given named effect.","     * @method show","     * @for Node","     * @param {String} name A named Transition effect to use as the show effect.","     * @param {Object} config Options to use with the transition.","     * @param {Function} callback An optional function to run after the transition completes.","     * @chainable","     */","    show: function(callback) {","        callback = arguments[arguments.length - 1];","        this.toggleView(true, callback);","        return this;","    },","","    /**","     * The implementation for showing nodes.","     * Default is to remove the hidden attribute and reset the CSS style.display property.","     * @method _show","     * @protected","     * @chainable","     */","    _show: function() {","        this.removeAttribute('hidden');","","        // For back-compat we need to leave this in for browsers that","        // do not visually hide a node via the hidden attribute","        // and for users that check visibility based on style display.","        this.setStyle('display', '');","","    },","","    /**","    Returns whether the node is hidden by YUI or not. The hidden status is","    determined by the 'hidden' attribute and the value of the 'display' CSS","    property.","","    @method _isHidden","    @return {Boolean} `true` if the node is hidden.","    @private","    **/","    _isHidden: function() {","        return  this.hasAttribute('hidden') || Y.DOM.getComputedStyle(this._node, 'display') === 'none';","    },","","    /**","     * Displays or hides the node.","     * If the \"transition\" module is loaded, toggleView optionally","     * animates the toggling of the node using given named effect.","     * @method toggleView","     * @for Node","     * @param {Boolean} [on] An optional boolean value to force the node to be shown or hidden","     * @param {Function} [callback] An optional function to run after the transition completes.","     * @chainable","     */","    toggleView: function(on, callback) {","        this._toggleView.apply(this, arguments);","        return this;","    },","","    _toggleView: function(on, callback) {","        callback = arguments[arguments.length - 1];","","        // base on current state if not forcing","        if (typeof on != 'boolean') {","            on = (this._isHidden()) ? 1 : 0;","        }","","        if (on) {","            this._show();","        }  else {","            this._hide();","        }","","        if (typeof callback == 'function') {","            callback.call(this);","        }","","        return this;","    },","","    /**","     * Hides the node.","     * If the \"transition\" module is loaded, hide optionally","     * animates the hiding of the node using either the default","     * transition effect ('fadeOut'), or the given named effect.","     * @method hide","     * @param {String} name A named Transition effect to use as the show effect.","     * @param {Object} config Options to use with the transition.","     * @param {Function} callback An optional function to run after the transition completes.","     * @chainable","     */","    hide: function(callback) {","        callback = arguments[arguments.length - 1];","        this.toggleView(false, callback);","        return this;","    },","","    /**","     * The implementation for hiding nodes.","     * Default is to set the hidden attribute to true and set the CSS style.display to 'none'.","     * @method _hide","     * @protected","     * @chainable","     */","    _hide: function() {","        this.setAttribute('hidden', 'hidden');","","        // For back-compat we need to leave this in for browsers that","        // do not visually hide a node via the hidden attribute","        // and for users that check visibility based on style display.","        this.setStyle('display', 'none');","    }","});","","Y.NodeList.importMethod(Y.Node.prototype, [","    /**","     * Makes each node visible.","     * If the \"transition\" module is loaded, show optionally","     * animates the showing of the node using either the default","     * transition effect ('fadeIn'), or the given named effect.","     * @method show","     * @param {String} name A named Transition effect to use as the show effect.","     * @param {Object} config Options to use with the transition.","     * @param {Function} callback An optional function to run after the transition completes.","     * @for NodeList","     * @chainable","     */","    'show',","","    /**","     * Hides each node.","     * If the \"transition\" module is loaded, hide optionally","     * animates the hiding of the node using either the default","     * transition effect ('fadeOut'), or the given named effect.","     * @method hide","     * @param {String} name A named Transition effect to use as the show effect.","     * @param {Object} config Options to use with the transition.","     * @param {Function} callback An optional function to run after the transition completes.","     * @chainable","     */","    'hide',","","    /**","     * Displays or hides each node.","     * If the \"transition\" module is loaded, toggleView optionally","     * animates the toggling of the nodes using given named effect.","     * @method toggleView","     * @param {Boolean} [on] An optional boolean value to force the nodes to be shown or hidden","     * @param {Function} [callback] An optional function to run after the transition completes.","     * @chainable","     */","    'toggleView'","]);","","","}, '3.18.1', {\"requires\": [\"dom-style\", \"node-base\"]});","","}());"]};
}
var __cov_DYVP_bG0JqD8NAQnvB9Z$A = __coverage__['build/node-style/node-style.js'];
__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['1']++;YUI.add('node-style',function(Y,NAME){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['1']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['2']++;(function(Y){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['2']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['3']++;Y.mix(Y.Node.prototype,{setStyle:function(attr,val){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['3']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['4']++;Y.DOM.setStyle(this._node,attr,val);__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['5']++;return this;},setStyles:function(hash){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['4']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['6']++;Y.DOM.setStyles(this._node,hash);__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['7']++;return this;},getStyle:function(attr){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['5']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['8']++;return Y.DOM.getStyle(this._node,attr);},getComputedStyle:function(attr){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['6']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['9']++;return Y.DOM.getComputedStyle(this._node,attr);}});__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['10']++;Y.NodeList.importMethod(Y.Node.prototype,['getStyle','getComputedStyle','setStyle','setStyles']);}(Y));__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['11']++;var Y_Node=Y.Node;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['12']++;Y.mix(Y_Node.prototype,{show:function(callback){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['7']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['13']++;callback=arguments[arguments.length-1];__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['14']++;this.toggleView(true,callback);__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['15']++;return this;},_show:function(){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['8']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['16']++;this.removeAttribute('hidden');__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['17']++;this.setStyle('display','');},_isHidden:function(){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['9']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['18']++;return(__cov_DYVP_bG0JqD8NAQnvB9Z$A.b['1'][0]++,this.hasAttribute('hidden'))||(__cov_DYVP_bG0JqD8NAQnvB9Z$A.b['1'][1]++,Y.DOM.getComputedStyle(this._node,'display')==='none');},toggleView:function(on,callback){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['10']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['19']++;this._toggleView.apply(this,arguments);__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['20']++;return this;},_toggleView:function(on,callback){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['11']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['21']++;callback=arguments[arguments.length-1];__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['22']++;if(typeof on!='boolean'){__cov_DYVP_bG0JqD8NAQnvB9Z$A.b['2'][0]++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['23']++;on=this._isHidden()?(__cov_DYVP_bG0JqD8NAQnvB9Z$A.b['3'][0]++,1):(__cov_DYVP_bG0JqD8NAQnvB9Z$A.b['3'][1]++,0);}else{__cov_DYVP_bG0JqD8NAQnvB9Z$A.b['2'][1]++;}__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['24']++;if(on){__cov_DYVP_bG0JqD8NAQnvB9Z$A.b['4'][0]++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['25']++;this._show();}else{__cov_DYVP_bG0JqD8NAQnvB9Z$A.b['4'][1]++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['26']++;this._hide();}__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['27']++;if(typeof callback=='function'){__cov_DYVP_bG0JqD8NAQnvB9Z$A.b['5'][0]++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['28']++;callback.call(this);}else{__cov_DYVP_bG0JqD8NAQnvB9Z$A.b['5'][1]++;}__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['29']++;return this;},hide:function(callback){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['12']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['30']++;callback=arguments[arguments.length-1];__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['31']++;this.toggleView(false,callback);__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['32']++;return this;},_hide:function(){__cov_DYVP_bG0JqD8NAQnvB9Z$A.f['13']++;__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['33']++;this.setAttribute('hidden','hidden');__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['34']++;this.setStyle('display','none');}});__cov_DYVP_bG0JqD8NAQnvB9Z$A.s['35']++;Y.NodeList.importMethod(Y.Node.prototype,['show','hide','toggleView']);},'3.18.1',{'requires':['dom-style','node-base']});
