private rule PHP
{
    strings:
        $magic = "<?php"
        $short_open_tag = "<?"
    condition:
        $short_open_tag at 0 or $magic in (0..4096)
}
private rule PHP_MAGIC
{
    strings:
        $magic = "<?php"
        $short_open_tag = "<?"
    condition:
        $magic at 0 or $short_open_tag at 0
}
rule imh_php_base64_obfuscated
{
    strings:
        $a = "<?php $_F=__FILE__;$_X="
    condition:
        $a at 0
}
rule imh_php_base64d_obfuscated
{
    strings:
        // obfuscated string "4_deco"
        $a = "chr(52).chr(95).chr(100).chr(101).chr(99).chr(111)"
        $b = "edoced_46esab"
        $c = "array('ode', 'e', '_dec', 'bas')"
        $str_rot = "\\163\\164\\x72\\x5f\\162\\x6f\\164"
    condition:
        PHP and any of them
}
rule imh_php_mailer_generic
{
    strings:
        $a = "PRO Mailer V2"
        $b = "title>Ofux Mailer"
        $c = "MaILER Password"
    condition:
        any of them
}
rule imh_php_malware_downloader
{
    meta:
        description = "Malware that pulls and executes data from another server, like pastebin"
    strings:
        $pastebin_1 = /file_get_contents\(['"]https:\/\/pastebin.com\/raw\/.{6,15}include/
    condition:
        any of them
}
rule imh_php_malware_inject
{
    meta:
        description = "Malware injected into otherwise fine files"
    strings:        
        $obfuscated_include = /\n@?include "([^"]{0,10}\\[0-9]{3}){2}/
    condition:
        $obfuscated_include in (0..30)
}
rule imh_php_malware_literal
{    
    strings:
        $generic_a = "D@rk sH@d0w"
        $generic_b = "ln -s /home/$i/public_html/wp-config.php"
        $generic_c = "base'.(32*2)"
        $generic_d = "a5b0f6efa9662ef6acd2a6e6ea88f765"
        $generic_e = "config['botnet_timeout']"
        $generic_f = "substr_count($shellPath"
        $generic_g = "<input type=hidden name=a value='FilesMAn'>"
        $generic_h = "$option(\"/438/e\",$au,438);"
        $generic_i = "system file do not delete"
        $generic_j = "new motherFucker();"
        $generic_k = "bfakeprocb"
        $generic_l = "PHP_OS.chr(49)"
        $generic_m = "%28%0D%0A%66%75%6E%63%74%69%6F%6E%28"
        $generic_n = "Grab Usernames from /home/"
        $generic_o = "die(PHP_OS.chr(49).chr(48).chr(43).md5(0987654321"
        $generic_p = "ZHCtehUnstopable"
        $generic_q = "$v4af189b="
        $generic_r = "$i437e2fb="
        $generic_s = "af5f492a2"
        $generic_t = "$EEkRtL8DY="
        $generic_u = "function _68758598"
        $generic_v = "$O00OO0=urldecode"
        // a similar but not exact rule to the following is also in heuristic
        $generic_w = "@error_reporting(0);@set_time_limit(0)" 
        $generic_x = "return $g.''.$o.''.$i;"
        $generic_y = "$code = iget_data($_REQUEST['o']);\neval(\"?>\".$code);"
        $uploader_1 = "$_FILES[\"\\165\\x70\\154\\x6f\\x61\\x64\\x73\"]"
        $wc_ajax_try_2020 = "md5(md5(md5($_POST['token_admin"
        $generic_z = "substr(md5(time()), 0, 8) . \".php\""
        $fake_log_file = "$filename=Class_UC_key(\"2470617373776F72643D27\").$password."
        $vuln = "<title>Vuln!! patch it Now!</title><?php"
        $uploader_2 = "<?php error_reporting(0); $path = __DIR__; if($_GET[\"rands\"]=="
        $trage_uploader = ");if(move_uploaded_file($_FILES[\"tragefile"
        $foxauto = "FoxAutoV5"
        $dns_spammer = "$wp_t=array"

    condition:
        PHP and any of them
}

rule imh_php_malware_literal_2
{
    strings:
        $backdoor_1 = "eval(TC9A16C47DA8EEE87(\"QAIAPD9waHAgABEkY29s"
        $spammer = "kmbske ($dcokepc, $dyuyue) { return $dcokepc ^ str_repeat"
        $backdoor_2 = "64_decode(\"aWYoIWVtcHR5KCRfR"
        $obfu = "ecode('eNqVWvtTFFfa/lc"
        $widgetmalware_1 = "ecode('JGY9ZGlybmFtZShfX2Zpb"
        $annizod = "9HJ>\nu H/L6: ="
        $ali181091 = "ali181091@yahoo.com"
        $key = ".hyib/;dq4ux9*zjmclp3_r80)t(vakng1s2foe75w6"
        $globals = "${\"\\x47\\x4c\\x4fB\\x41\\x4c\\x53\"}"
        $h4250d5 = "$h4250d5[j5f5dd]"
        $backdoor = "ecode(\"UEsDBBQAAAAIAEMl70ysSqmPSQcAALMTAAAMAAA"
        $wso_shell = "4k5yui1k5yu='5b37Wxs30zD8Zm1d/R/E1mrXQYyx"
        $shadow_mangler = "$b=fopen('/home/'.$user.'/etc/'.$t.'/shadow','ab');fwrit"
        $ubh_shell = "add_object_page(\"UBH\",\"U\\x42\\x48\""
        $k2ll33d_shell = "ecode(\"PD9waHAKLy8gYnkgazJsbDMz"
        $generic_a = "fsockopen(\"udp://$_15\",round(0+13"
        $obfuscated = "$jtvyc[7]($_COOKIE, $_POST) as $whezkpg => $mzjyuh)"
        $act = "<tr><td>>Anonymous Cyber Team<</td></tr>"
        $darkshadow = "<title>darkshadow File Manager"
        $ofux = "title>Ofux Mailer"
        $generic_b = "A='';@eval(base64_decode('QG9iX3N0YXJ0KC"
        $shadowdelete = "unlink('/home/'.$user.'/etc/'.$site.'/shadow')"
        $toolkit = "64_decode(\"UEsDBAoAAAAAALELCU0AAAAAAAAAAAA"
        $uploader_1 = "$f1 = \".ht\"; $f2 = \"acc\"; $f3 = \"ess\";"
        $lestershell = "<title>Lester Hax0r"
        $docdownloader = "77841099('ZXJyb3JfcmVwb3J0aW5"
        $generic_c = "bh4dy2k = \"G%03B%11E%06T%03%5E"
        $generic_d = "cf4050bc('ZXJyb3JfcmVwb3J0aW"
        $downloader = "fn5b7c5e7aaf705('6261736536345f6465636f6465'"
        $passwordreset = "':2083/resetpass?user=' . get_current_user()"
        $generic_e = "$_klgsMO(\"\\x65\\x76\\x61\\x6c\\x28\\x62"
        $docmalware_1 = "fn5b887ea9aabcf('6261736536345f6465636f6465"
        $generic = "$rjiqlbk[31].$rjiqlbk[32].$rjiqlbk"
        $docmalware_2 = "fn5b8667d2b6bc3('6261736536345f6465636f6465"
        $i47_shell = "$lktd = \"eNrsvGmT40iSKPZ5xmz/Q6mszaZH2B0AxEH"
        $bangledeshi = ">#Bangladeshi HackeR<"
        $dx1z1_shell = "title>Mr.DX1Z1<"
        $generic_4 = "$_f2k1cg3 = \"GR%13%1A%16WU_"
        $generic_5 = "vxvxgddrtwrewfdsf($e,$q,$w)"
        $brute_force = "createBrutePass($_GET['wordsList']"
        $cookie_thief = "$GLOBALS['_79565595_']=Array('str_' .'rot13'"
        $shell = "ecode(\"PD9waHANCmhlYWRlcignQ2"
        $malware_unpacker = "new PclZip(\"ytpovuie.zip\")"
        $arbitrary_curl = "$ch, CURLOPT_URL, $_GET['url'])"
        $generic_6 = "$zUaDnOj408.\"'1X1rd9u2suj3rJX/gGjrhFIjyZI"
        $minexmr = "0@pool.minexmr.com"
        $downloader_2 = "$n5b98460961ddd('ZXJyb3JfcmVwb3J0aW5nKDA"
        $generic_1 = "tbz74e1 = \"GP%17M%16P%5C%04%0C%40%0C%07G"
        $backdoor_3 = "base64_decode('PD9waHANCmVjaG8gIlRoaXMgc2hpdCB3b3JrcyEiOw0"
        $stylewpp = "Array('UkVRVUVTVF9VUkk=','P3JlYm9vdD15ZXM='"
        $document_downloader = "$x = ''; for ($i = 0, $n = strlen($s); $i < $n; $i +="
        $generic_2 = "s($q, $d){ for($g=0;$g<strlen($q);) for($u=0;$u<strlen($d);$u++, $g++)"
        $generic_3 = "$xvofz ^ bppyu($zjcpk, $yblei, $zjcpk[8]($xvofz)"
        $fir3hwk_passwd = "/etc/passwd/tmp/passwd.bakfir3hawk"
        $sym = "SYMLINKER BY HO4R KOD3"
        $pwd_protected = /basename\(\$c\)==basename\(\$i\)&&isset\(\$_REQUEST\["q"]\)&&md5\(\$_REQUEST\["q"]\)/
    condition:
        PHP_MAGIC and any of them
}

rule imh_php_malware_literal_3
{
    strings:
        $base64_decode_1 = "\\163\\164\\x72\\x5f\\162\\x6f\\164"
        $uploader_mushtik = "ecode('ZWNobyAiPHRpdGxlPm11aHN0aWs8L"
        $simple_shell = "ecode('rUl6Yts2EP68APkPDHRANk3"
        $symlink_attack = "ecode('7Vf/T9tGFP89Uv6H1yOT7ZHaSRBrReKUrj"
        $b0ff_shell = "gzinflate($D('7X1te9s2suh3/QqY1QZiItGSnHSzkinb"
        $wp_slave = "createBrutePass($wordsList"
        $wp_bruteforce = "AgICBXb3JkUHJlc3MgQnJ1dGVGb3JjZSA"
        $shell_generic = "$fp = fopen($_POST['path']"
        $bloodninja_1 = "64_decode('eNpdUs1u00AQfpWNlYMdrDhO89dEOZTKol"
        $arbitrary_eval_2 = "$a = \"7VdrT+NGFP1eqf9hiCIcKwHFj7ClIQh2B"
        $uploader_2 = "$_eafg5l = \"G%03B%1CE%5D%07T%0B%40%0C%07G%09%16%16"
        $arbitrary_eval_1 = "ecode('fSBpZighZGVmaW5lZCgiUEhQX0VPTCIpKQp7CiAgICBkZW"
        $generic_4 = "\\x63\\x6F\\x64\\x65\\x28'xJ3HzoPQdoXfJZMkYkBvijKg92I66E7ozf"
        $doc_downloader = "$sp58859d = new O(); echo $sp58859d->execute"
        $arbitrary_eval = "ecode(\"PD9waHAgJFpUZUo9Y3JlYX"
        $unpacker_1 = "PclZip(\"zlvkejwe.zip"
        $bloodninja = "ecode('eNq1fflvU2f677/iieaqQDPhbD7HbsWtQqFAy9ZCp6UDNzq2j2M3jp3aDkk"
        $phploot = "http://5.188.86.29:7000"
        $z879 = "targetpthrowinticksEntimeType"
        $uploader_4 = "file_put_contents($_SERVER[\"DOCUMENT_ROOT\"].\"/\".$_POST["
        $spam_script = "$jfnbrsjfq = mail($jewrqwbnlk, $xaouf"
        $tuhan_shell = "title>SH3LL TUHAN"
        $orb_shell_1 = "ecode(YiunIUY76bBhuhNYIO8($XnNhAWEn"
        $indoxploit_shell = "title>IndoXploit"
        $outbound_stealth = "_dt2wacy = \"GS%19%19%19%5C%5DUX%40%0C%07G%09"
        $shell_1 = "if(isset($_REQUEST['clr_htacc']) == true)\n    {\n        CheckSecureValue();\n        ClearHtaccess();\n        exit();"
        $filebrowser = "function ShowPage($sFullPathToFile)\n{\n    $sOutContent = '';\n    $stFileHandle = fopen($sFullPathToFile, 'r');"
        $downloader = "exec(\"\\160\\x6b\\151\\154\\x6c\\x20\\x2d\\x39\\40\\55\\x66\\x20\\163\\x74\\x65\\x61\\x6c\\164\\150\");"
        $downloader_1 = "<?php goto O847931477431386"
        $3xf = "eval(base64_decode(getmal($_getf)));eval(returnmal(getmal($_getf,2),getmal($_getf,1)));__halt_compiler();"
        $htaccess = "$mchwdwfn=\"DQoJCUBlcnJvcl9yZXBvc"
        $orb_shell = ")) . \"\\x27\\x37\\130\\x31\\x72\\145\\71\\x72\\x47\\x45\\x76\\104\\x6e\\x6e\\x4f\\143\\x35\\x2f"
        $cloudswarm = "echo \"\\x61\\x75\\x78\\x36\\124\\x68\\x65\\x69\\157\\107\\150\\165\\x65\\121\\x75\\63\""
        $generic_7 = "ttes = 't-yH#\\'m6vgn41o_8kbs5exr73pfad9l*2ciu"
        $outbound_1 = "_WRITE failed.\n\n$Info: This file is packed with "
        $generic = "fcic = 'g3#of\\'1kc9ubmtHxvls_r6p4e-08idnya*'"
    condition:
        PHP_MAGIC and any of them
}
rule imh_php_mass_mailer_base64
{
    strings:
        $a = "if (mail(stripslashes(base64_decode($fr[0])), stripslashes(base64_decode($fr[1])), base64_decode($fr[2]), stripslashes(base64_decode($fr[3]))))"
    condition:
        PHP and any of them
}

rule imh_php_mass_mailer_leaf
{
    strings:
        $a = "leafmailer.pw"
    condition:
        PHP_MAGIC and $a in (0..100)
}

rule imh_php_mass_mailer_sandy2013
{
    strings:
        $a = "Sandy 2013 - Best Email Marketing Tool"
    condition:
        PHP and any of them
}

rule imh_php_obfuscated_globals
{
    // Match ${"\x47\x4c\x4fB\x41\x4c\x53"}
    strings:
        $re1 = /\${\"(\\x47|G)(\\x4c|L)(\\x4f|O)(\\x42|B)(\\x41|A)(\\x4c|L)(\\x53|S)\"\}/
    condition:
        PHP and $re1
}

rule imh_php_shell_generic
{
    // Generic shells that are kind enough to label themselves.
    // need to add a condition to prevent false positives then move to malware sigs
    strings:
        $a = "[sS]hell by "
        $b = "AnonGhost"
        $c = "Automatic cPanel Finder/Cracker"
        $d = "Config Grabber v1.0"
        $e = "Cpanel Cracker"
        $f = "Mohajer22"
        $h = "Plugin Name: Docs"
        $i = "SpyHackerz"
        $j = "Symlink Based Cpanel Cracker By Team IndiShell"
        $k = "Yuklendi"
        $m = "rednoize.com"
        $n = "wso shell"
        $o = "z0mbie"
        $p = "zeroscience"
        $q = "TC9A16C47DA8EEE87"
        $r = /(r57|c99|Dx|Crystal|SpY|Indi|jampot)[Ss]h[e3]ll/
        $s = "WeB.Sniper"
        $t = "phpshell.sourceforge.net"
        $u = "KaiserMalware"
        $v = "EbRaHiM-VaKeR"
        $w = "Satanic Socks Server"
        $x = "dz48-coders"
        $y = "hashcrack.com"
        $z = "Mr.Alsa3ek"
        $aa = "dz48-coders"
        $indoxploit = "title>IndoXploit"
        $spiritokiller = "<title>spiritokiller</title>"
        $cheetah_shell = "code(\"PD9waHANCiRjb2xvciA9ICIjYTNlOTU2"
        $anonymousfoux = "anonymousfox.com"
        $generic = /\(isset\(\$.....\[\$_POST\['fm_usr']]\) && \$_POST\['fm_pwd'] === \$.....\[\$_POST\['fm_usr']]\)/
        $scp173 = /array\('','}'\.\$[a-z0-9]{1,12}\.'\/\/'\)\);\/\/scp-173\?>$/
        $scp173_2 = /^<\?php ?\x0d\n\/\/scp-173/ // \r\n
        $reseller_finder = "coded by: ~Rizi_haxor" // PHP, but no magic
    condition:
        filesize < 1MB and PHP and any of them
}
