
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `xoops2510`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_avatar`
--

CREATE TABLE `[[dbprefix]]_avatar` (
  `avatar_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `avatar_file` varchar(30) NOT NULL DEFAULT '',
  `avatar_name` varchar(100) NOT NULL DEFAULT '',
  `avatar_mimetype` varchar(30) NOT NULL DEFAULT '',
  `avatar_created` int(10) NOT NULL DEFAULT '0',
  `avatar_display` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `avatar_weight` smallint(5) unsigned NOT NULL DEFAULT '0',
  `avatar_type` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`avatar_id`),
  KEY `avatar_type` (`avatar_type`,`avatar_display`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_avatar_user_link`
--

CREATE TABLE `[[dbprefix]]_avatar_user_link` (
  `avatar_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  KEY `avatar_user_id` (`avatar_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_banner`
--

CREATE TABLE `[[dbprefix]]_banner` (
  `bid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `cid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `imptotal` int(10) unsigned NOT NULL DEFAULT '0',
  `impmade` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `clicks` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `imageurl` varchar(255) NOT NULL DEFAULT '',
  `clickurl` varchar(255) NOT NULL DEFAULT '',
  `date` int(10) NOT NULL DEFAULT '0',
  `htmlbanner` tinyint(1) NOT NULL DEFAULT '0',
  `htmlcode` text,
  PRIMARY KEY (`bid`),
  KEY `idxbannercid` (`cid`),
  KEY `idxbannerbidcid` (`bid`,`cid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]_banner`
--

INSERT INTO `[[dbprefix]]_banner` VALUES
(1, 1, 0, 1, 0, '[[softurl]]/images/banners/xoops_flashbanner2.htm', 'http://www.xoops.org/', 1008813250, 1, ''),
(2, 1, 0, 1, 0, '[[softurl]]/images/banners/xoops_banner_2.gif', 'http://www.xoops.org/', 1008813250, 0, ''),
(3, 1, 0, 1, 0, '[[softurl]]/images/banners/banner.htm', 'http://www.xoops.org/', 1008813250, 1, ''),
(4, 1, 0, 1, 0, '[[softurl]]/images/banners/xoopsifyIt.gif', 'http://www.xoops.org/', 1008813250, 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_bannerclient`
--

CREATE TABLE `[[dbprefix]]_bannerclient` (
  `cid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `contact` varchar(60) NOT NULL DEFAULT '',
  `email` varchar(60) NOT NULL DEFAULT '',
  `login` varchar(10) NOT NULL DEFAULT '',
  `passwd` varchar(10) NOT NULL DEFAULT '',
  `extrainfo` text,
  PRIMARY KEY (`cid`),
  KEY `login` (`login`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_bannerclient`
--

INSERT INTO `[[dbprefix]]_bannerclient` VALUES
(1, 'XOOPS', 'XOOPS Dev Team', 'webmaster@xoops.org', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_bannerfinish`
--

CREATE TABLE `[[dbprefix]]_bannerfinish` (
  `bid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `cid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `impressions` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `clicks` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `datestart` int(10) unsigned NOT NULL DEFAULT '0',
  `dateend` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_block_module_link`
--

CREATE TABLE `[[dbprefix]]_block_module_link` (
  `block_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `module_id` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`module_id`,`block_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_block_module_link`
--

INSERT INTO `[[dbprefix]]_block_module_link` VALUES
(1, 0),
(2, 0),
(3, 0),
(4, 0),
(5, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(11, 0),
(12, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_cache_model`
--

CREATE TABLE `[[dbprefix]]_cache_model` (
  `cache_key` varchar(64) NOT NULL DEFAULT '',
  `cache_expires` int(10) unsigned NOT NULL DEFAULT '0',
  `cache_data` text,
  PRIMARY KEY (`cache_key`),
  KEY `cache_expires` (`cache_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_config`
--

CREATE TABLE `[[dbprefix]]_config` (
  `conf_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `conf_modid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `conf_catid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `conf_name` varchar(25) NOT NULL DEFAULT '',
  `conf_title` varchar(255) NOT NULL DEFAULT '',
  `conf_value` text,
  `conf_desc` varchar(255) NOT NULL DEFAULT '',
  `conf_formtype` varchar(15) NOT NULL DEFAULT '',
  `conf_valuetype` varchar(10) NOT NULL DEFAULT '',
  `conf_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`conf_id`),
  KEY `conf_mod_cat_id` (`conf_modid`,`conf_catid`),
  KEY `conf_order` (`conf_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=135 ;

--
-- Dumping data for table `[[dbprefix]]_config`
--

INSERT INTO `[[dbprefix]]_config` VALUES
(1, 0, 1, 'sitename', '_MD_AM_SITENAME', '[[site_name]]', '_MD_AM_SITENAMEDSC', 'textbox', 'text', 0),
(2, 0, 1, 'slogan', '_MD_AM_SLOGAN', '[[site_desc]]', '_MD_AM_SLOGANDSC', 'textbox', 'text', 2),
(3, 0, 1, 'language', '_MD_AM_LANGUAGE', 'english', '_MD_AM_LANGUAGEDSC', 'language', 'other', 4),
(4, 0, 1, 'startpage', '_MD_AM_STARTPAGE', '--', '_MD_AM_STARTPAGEDSC', 'startpage', 'other', 6),
(5, 0, 1, 'server_TZ', '_MD_AM_SERVERTZ', '0', '_MD_AM_SERVERTZDSC', 'timezone', 'float', 8),
(6, 0, 1, 'default_TZ', '_MD_AM_DEFAULTTZ', '0', '_MD_AM_DEFAULTTZDSC', 'timezone', 'float', 10),
(7, 0, 1, 'theme_set', '_MD_AM_DTHEME', 'xbootstrap', '_MD_AM_DTHEMEDSC', 'theme', 'other', 12),
(8, 0, 1, 'anonymous', '_MD_AM_ANONNAME', 'Anonymous', '_MD_AM_ANONNAMEDSC', 'textbox', 'text', 15),
(9, 0, 1, 'gzip_compression', '_MD_AM_USEGZIP', '0', '_MD_AM_USEGZIPDSC', 'yesno', 'int', 16),
(10, 0, 1, 'usercookie', '_MD_AM_USERCOOKIE', 'xoops_user_[[usercookie]]', '_MD_AM_USERCOOKIEDSC', 'textbox', 'text', 18),
(11, 0, 1, 'session_expire', '_MD_AM_SESSEXPIRE', '15', '_MD_AM_SESSEXPIREDSC', 'textbox', 'int', 22),
(12, 0, 1, 'banners', '_MD_AM_BANNERS', '1', '_MD_AM_BANNERSDSC', 'yesno', 'int', 26),
(13, 0, 1, 'debug_mode', '_MD_AM_DEBUGMODE', '0', '_MD_AM_DEBUGMODEDSC', 'select', 'int', 24),
(14, 0, 1, 'my_ip', '_MD_AM_MYIP', '[[clientip]]', '_MD_AM_MYIPDSC', 'textbox', 'text', 29),
(15, 0, 1, 'use_ssl', '_MD_AM_USESSL', '0', '_MD_AM_USESSLDSC', 'yesno', 'int', 30),
(16, 0, 1, 'session_name', '_MD_AM_SESSNAME', 'xoops_session_[[usercookie]]', '_MD_AM_SESSNAMEDSC', 'textbox', 'text', 20),
(17, 0, 2, 'minpass', '_MD_AM_MINPASS', '5', '_MD_AM_MINPASSDSC', 'textbox', 'int', 1),
(18, 0, 2, 'minuname', '_MD_AM_MINUNAME', '3', '_MD_AM_MINUNAMEDSC', 'textbox', 'int', 2),
(19, 0, 2, 'new_user_notify', '_MD_AM_NEWUNOTIFY', '1', '_MD_AM_NEWUNOTIFYDSC', 'yesno', 'int', 4),
(20, 0, 2, 'new_user_notify_group', '_MD_AM_NOTIFYTO', '1', '_MD_AM_NOTIFYTODSC', 'group', 'int', 6),
(21, 0, 2, 'activation_type', '_MD_AM_ACTVTYPE', '0', '_MD_AM_ACTVTYPEDSC', 'select', 'int', 8),
(22, 0, 2, 'activation_group', '_MD_AM_ACTVGROUP', '1', '_MD_AM_ACTVGROUPDSC', 'group', 'int', 10),
(23, 0, 2, 'uname_test_level', '_MD_AM_UNAMELVL', '0', '_MD_AM_UNAMELVLDSC', 'select', 'int', 12),
(24, 0, 2, 'avatar_allow_upload', '_MD_AM_AVATARALLOW', '0', '_MD_AM_AVATARALWDSC', 'yesno', 'int', 14),
(27, 0, 2, 'avatar_width', '_MD_AM_AVATARW', '128', '_MD_AM_AVATARWDSC', 'textbox', 'int', 16),
(28, 0, 2, 'avatar_height', '_MD_AM_AVATARH', '128', '_MD_AM_AVATARHDSC', 'textbox', 'int', 18),
(29, 0, 2, 'avatar_maxsize', '_MD_AM_AVATARMAX', '35000', '_MD_AM_AVATARMAXDSC', 'textbox', 'int', 20),
(30, 0, 1, 'adminmail', '_MD_AM_ADMINML', '[[admin_email]]', '_MD_AM_ADMINMLDSC', 'textbox', 'text', 3),
(31, 0, 2, 'self_delete', '_MD_AM_SELFDELETE', '0', '_MD_AM_SELFDELETEDSC', 'yesno', 'int', 22),
(32, 0, 1, 'com_mode', '_MD_AM_COMMODE', 'flat', '_MD_AM_COMMODEDSC', 'select', 'text', 34),
(33, 0, 1, 'com_order', '_MD_AM_COMORDER', '0', '_MD_AM_COMORDERDSC', 'select', 'int', 36),
(34, 0, 2, 'bad_unames', '_MD_AM_BADUNAMES', 'a:3:{i:0;s:9:"webmaster";i:1;s:6:"^xoops";i:2;s:6:"^admin";}', '_MD_AM_BADUNAMESDSC', 'textarea', 'array', 24),
(35, 0, 2, 'bad_emails', '_MD_AM_BADEMAILS', 'a:1:{i:0;s:10:"xoops.org$";}', '_MD_AM_BADEMAILSDSC', 'textarea', 'array', 26),
(36, 0, 2, 'maxuname', '_MD_AM_MAXUNAME', '10', '_MD_AM_MAXUNAMEDSC', 'textbox', 'int', 3),
(37, 0, 1, 'bad_ips', '_MD_AM_BADIPS', 'a:1:{i:0;s:9:"127.0.0.1";}', '_MD_AM_BADIPSDSC', 'textarea', 'array', 42),
(38, 0, 3, 'meta_keywords', '_MD_AM_METAKEY', 'xoops, web application framework, cms, content management system', '_MD_AM_METAKEYDSC', 'textarea', 'text', 0),
(39, 0, 3, 'footer', '_MD_AM_FOOTER', 'Powered by XOOPS &#169; 2001-2019 <a href="http://xoops.org" rel="external" title="The XOOPS Project">The XOOPS Project</a>', '_MD_AM_FOOTERDSC', 'textarea', 'text', 20),
(40, 0, 4, 'censor_enable', '_MD_AM_DOCENSOR', '0', '_MD_AM_DOCENSORDSC', 'yesno', 'int', 0),
(41, 0, 4, 'censor_words', '_MD_AM_CENSORWRD', 'a:2:{i:0;s:4:"fuck";i:1;s:4:"shit";}', '_MD_AM_CENSORWRDDSC', 'textarea', 'array', 1),
(42, 0, 4, 'censor_replace', '_MD_AM_CENSORRPLC', '#OOPS#', '_MD_AM_CENSORRPLCDSC', 'textbox', 'text', 2),
(43, 0, 3, 'meta_robots', '_MD_AM_METAROBOTS', 'index,follow', '_MD_AM_METAROBOTSDSC', 'textbox', 'text', 2),
(44, 0, 5, 'enable_search', '_MD_AM_DOSEARCH', '1', '_MD_AM_DOSEARCHDSC', 'yesno', 'int', 0),
(45, 0, 5, 'keyword_min', '_MD_AM_MINSEARCH', '5', '_MD_AM_MINSEARCHDSC', 'textbox', 'int', 1),
(46, 0, 2, 'avatar_minposts', '_MD_AM_AVATARMP', '0', '_MD_AM_AVATARMPDSC', 'textbox', 'int', 15),
(47, 0, 1, 'enable_badips', '_MD_AM_DOBADIPS', '0', '_MD_AM_DOBADIPSDSC', 'yesno', 'int', 40),
(48, 0, 3, 'meta_rating', '_MD_AM_METARATING', 'general', '_MD_AM_METARATINGDSC', 'select', 'text', 4),
(49, 0, 3, 'meta_author', '_MD_AM_METAAUTHOR', 'XOOPS', '_MD_AM_METAAUTHORDSC', 'textbox', 'text', 6),
(50, 0, 3, 'meta_copyright', '_MD_AM_METACOPYR', 'Copyright © 2001-2019', '_MD_AM_METACOPYRDSC', 'textbox', 'text', 8),
(51, 0, 3, 'meta_description', '_MD_AM_METADESC', 'XOOPS is a dynamic Object Oriented based open source portal script written in PHP.', '_MD_AM_METADESCDSC', 'textarea', 'text', 1),
(52, 0, 2, 'allow_chgmail', '_MD_AM_ALLWCHGMAIL', '0', '_MD_AM_ALLWCHGMAILDSC', 'yesno', 'int', 3),
(53, 0, 1, 'use_mysession', '_MD_AM_USEMYSESS', '1', '_MD_AM_USEMYSESSDSC', 'yesno', 'int', 19),
(54, 0, 2, 'reg_dispdsclmr', '_MD_AM_DSPDSCLMR', '1', '_MD_AM_DSPDSCLMRDSC', 'yesno', 'int', 30),
(55, 0, 2, 'reg_disclaimer', '_MD_AM_REGDSCLMR', 'While the administrators and moderators of this site will attempt to remove\nor edit any generally objectionable material as quickly as possible, it is\nimpossible to review every message. Therefore you acknowledge that all posts\nmade to this site express the views and opinions of the author and not the\nadministrators, moderators or webmaster (except for posts by these people)\nand hence will not be held liable.\n\nYou agree not to post any abusive, obscene, vulgar, slanderous, hateful,\nthreatening, sexually-orientated or any other material that may violate any\napplicable laws. Doing so may lead to you being immediately and permanently\nbanned (and your service provider being informed). The IP address of all\nposts is recorded to aid in enforcing these conditions. Creating multiple\naccounts for a single user is not allowed. You agree that the webmaster,\nadministrator and moderators of this site have the right to remove, edit,\nmove or close any topic at any time should they see fit. As a user you agree\nto any information you have entered above being stored in a database. While\nthis information will not be disclosed to any third party without your\nconsent the webmaster, administrator and moderators cannot be held\nresponsible for any hacking attempt that may lead to the data being\ncompromised.\n\nThis site system uses cookies to store information on your local computer.\nThese cookies do not contain any of the information you have entered above,\nthey serve only to improve your viewing pleasure. The email address is used\nonly for confirming your registration details and password (and for sending\nnew passwords should you forget your current one).\n\nBy clicking Register below you agree to be bound by these conditions.', '_MD_AM_REGDSCLMRDSC', 'textarea', 'text', 32),
(56, 0, 2, 'allow_register', '_MD_AM_ALLOWREG', '1', '_MD_AM_ALLOWREGDSC', 'yesno', 'int', 0),
(57, 0, 1, 'theme_fromfile', '_MD_AM_THEMEFILE', '0', '_MD_AM_THEMEFILEDSC', 'yesno', 'int', 13),
(58, 0, 1, 'closesite', '_MD_AM_CLOSESITE', '0', '_MD_AM_CLOSESITEDSC', 'yesno', 'int', 26),
(59, 0, 1, 'closesite_okgrp', '_MD_AM_CLOSESITEOK', 'a:1:{i:0;s:1:"1";}', '_MD_AM_CLOSESITEOKDSC', 'group_multi', 'array', 27),
(60, 0, 1, 'closesite_text', '_MD_AM_CLOSESITETXT', 'The site is currently closed for maintenance. Please come back later.', '_MD_AM_CLOSESITETXTDSC', 'textarea', 'text', 28),
(61, 0, 1, 'sslpost_name', '_MD_AM_SSLPOST', 'xoops_ssl', '_MD_AM_SSLPOSTDSC', 'textbox', 'text', 31),
(62, 0, 1, 'module_cache', '_MD_AM_MODCACHE', '', '_MD_AM_MODCACHEDSC', 'module_cache', 'array', 50),
(63, 0, 1, 'template_set', '_MD_AM_DTPLSET', 'default', '_MD_AM_DTPLSETDSC', 'tplset', 'other', 14),
(64, 0, 6, 'mailmethod', '_MD_AM_MAILERMETHOD', 'mail', '_MD_AM_MAILERMETHODDESC', 'select', 'text', 4),
(65, 0, 6, 'smtphost', '_MD_AM_SMTPHOST', 'a:1:{i:0;s:0:"";}', '_MD_AM_SMTPHOSTDESC', 'textarea', 'array', 6),
(66, 0, 6, 'smtpuser', '_MD_AM_SMTPUSER', '', '_MD_AM_SMTPUSERDESC', 'textbox', 'text', 7),
(67, 0, 6, 'smtppass', '_MD_AM_SMTPPASS', '', '_MD_AM_SMTPPASSDESC', 'password', 'text', 8),
(68, 0, 6, 'sendmailpath', '_MD_AM_SENDMAILPATH', '/usr/sbin/sendmail', '_MD_AM_SENDMAILPATHDESC', 'textbox', 'text', 5),
(69, 0, 6, 'from', '_MD_AM_MAILFROM', '', '_MD_AM_MAILFROMDESC', 'textbox', 'text', 1),
(70, 0, 6, 'fromname', '_MD_AM_MAILFROMNAME', '', '_MD_AM_MAILFROMNAMEDESC', 'textbox', 'text', 2),
(71, 0, 1, 'sslloginlink', '_MD_AM_SSLLINK', 'https://', '_MD_AM_SSLLINKDSC', 'textbox', 'text', 33),
(72, 0, 1, 'theme_set_allowed', '_MD_AM_THEMEOK', 'a:1:{i:0;s:10:"xbootstrap";}', '_MD_AM_THEMEOKDSC', 'theme_multi', 'array', 13),
(73, 0, 6, 'fromuid', '_MD_AM_MAILFROMUID', '1', '_MD_AM_MAILFROMUIDDESC', 'user', 'int', 3),
(74, 0, 7, 'auth_method', '_MD_AM_AUTHMETHOD', 'xoops', '_MD_AM_AUTHMETHODDESC', 'select', 'text', 1),
(75, 0, 7, 'ldap_port', '_MD_AM_LDAP_PORT', '389', '_MD_AM_LDAP_PORT', 'textbox', 'int', 2),
(76, 0, 7, 'ldap_server', '_MD_AM_LDAP_SERVER', 'your directory server', '_MD_AM_LDAP_SERVER_DESC', 'textbox', 'text', 3),
(77, 0, 7, 'ldap_base_dn', '_MD_AM_LDAP_BASE_DN', 'dc=xoops,dc=org', '_MD_AM_LDAP_BASE_DN_DESC', 'textbox', 'text', 4),
(78, 0, 7, 'ldap_manager_dn', '_MD_AM_LDAP_MANAGER_DN', 'manager_dn', '_MD_AM_LDAP_MANAGER_DN_DESC', 'textbox', 'text', 5),
(79, 0, 7, 'ldap_manager_pass', '_MD_AM_LDAP_MANAGER_PASS', 'manager_pass', '_MD_AM_LDAP_MANAGER_PASS_DESC', 'password', 'text', 6),
(80, 0, 7, 'ldap_version', '_MD_AM_LDAP_VERSION', '3', '_MD_AM_LDAP_VERSION_DESC', 'textbox', 'text', 7),
(81, 0, 7, 'ldap_users_bypass', '_MD_AM_LDAP_USERS_BYPASS', 'a:1:{i:0;s:5:"admin";}', '_MD_AM_LDAP_USERS_BYPASS_DESC', 'textarea', 'array', 8),
(82, 0, 7, 'ldap_loginname_asdn', '_MD_AM_LDAP_LOGINNAME_ASDN', 'uid_asdn', '_MD_AM_LDAP_LOGINNAME_ASDN_D', 'yesno', 'int', 9),
(83, 0, 7, 'ldap_loginldap_attr', '_MD_AM_LDAP_LOGINLDAP_ATTR', 'uid', '_MD_AM_LDAP_LOGINLDAP_ATTR_D', 'textbox', 'text', 10),
(84, 0, 7, 'ldap_filter_person', '_MD_AM_LDAP_FILTER_PERSON', '', '_MD_AM_LDAP_FILTER_PERSON_DESC', 'textbox', 'text', 11),
(85, 0, 7, 'ldap_domain_name', '_MD_AM_LDAP_DOMAIN_NAME', 'mydomain', '_MD_AM_LDAP_DOMAIN_NAME_DESC', 'textbox', 'text', 12),
(86, 0, 7, 'ldap_provisionning', '_MD_AM_LDAP_PROVIS', '0', '_MD_AM_LDAP_PROVIS_DESC', 'yesno', 'int', 13),
(87, 0, 7, 'ldap_provisionning_group', '_MD_AM_LDAP_PROVIS_GROUP', 'a:1:{i:0;s:1:"2";}', '_MD_AM_LDAP_PROVIS_GROUP_DSC', 'group_multi', 'array', 14),
(88, 0, 7, 'ldap_mail_attr', '_MD_AM_LDAP_MAIL_ATTR', 'mail', '_MD_AM_LDAP_MAIL_ATTR_DESC', 'textbox', 'text', 15),
(89, 0, 7, 'ldap_givenname_attr', '_MD_AM_LDAP_GIVENNAME_ATTR', 'givenname', '_MD_AM_LDAP_GIVENNAME_ATTR_DSC', 'textbox', 'text', 16),
(90, 0, 7, 'ldap_surname_attr', '_MD_AM_LDAP_SURNAME_ATTR', 'sn', '_MD_AM_LDAP_SURNAME_ATTR_DESC', 'textbox', 'text', 17),
(91, 0, 7, 'ldap_field_mapping', '_MD_AM_LDAP_FIELD_MAPPING_ATTR', 'email=mail|name=displayname', '_MD_AM_LDAP_FIELD_MAPPING_DESC', 'textarea', 'text', 18),
(92, 0, 7, 'ldap_provisionning_upd', '_MD_AM_LDAP_PROVIS_UPD', '1', '_MD_AM_LDAP_PROVIS_UPD_DESC', 'yesno', 'int', 19),
(93, 0, 7, 'ldap_use_TLS', '_MD_AM_LDAP_USETLS', '0', '_MD_AM_LDAP_USETLS_DESC', 'yesno', 'int', 20),
(94, 0, 1, 'cpanel', '_MD_AM_CPANEL', 'transition', '_MD_AM_CPANELDSC', 'cpanel', 'other', 11),
(95, 0, 2, 'welcome_type', '_MD_AM_WELCOMETYPE', '1', '_MD_AM_WELCOMETYPE_DESC', 'select', 'int', 3),
(96, 1, 0, 'break1', '_MI_SYSTEM_PREFERENCE_BREAK_GENERAL', 'head', '', 'line_break', 'textbox', 0),
(97, 1, 0, 'usetips', '_MI_SYSTEM_PREFERENCE_TIPS', '1', '_MI_SYSTEM_PREFERENCE_TIPS_DSC', 'yesno', 'int', 10),
(98, 1, 0, 'typeicons', '_MI_SYSTEM_PREFERENCE_ICONS', 'transition', '', 'select', 'text', 20),
(99, 1, 0, 'typebreadcrumb', '_MI_SYSTEM_PREFERENCE_BREADCRUMB', 'default', '', 'select', 'text', 30),
(100, 1, 0, 'break2', '_MI_SYSTEM_PREFERENCE_BREAK_ACTIVE', 'head', '', 'line_break', 'textbox', 40),
(101, 1, 0, 'active_avatars', '_MI_SYSTEM_PREFERENCE_ACTIVE_AVATARS', '1', '', 'yesno', 'int', 50),
(102, 1, 0, 'active_banners', '_MI_SYSTEM_PREFERENCE_ACTIVE_BANNERS', '1', '', 'yesno', 'int', 60),
(103, 1, 0, 'active_blocksadmin', '_MI_SYSTEM_PREFERENCE_ACTIVE_BLOCKSADMIN', '1', '', 'hidden', 'int', 70),
(104, 1, 0, 'active_comments', '_MI_SYSTEM_PREFERENCE_ACTIVE_COMMENTS', '1', '', 'yesno', 'int', 80),
(105, 1, 0, 'active_filemanager', '_MI_SYSTEM_PREFERENCE_ACTIVE_FILEMANAGER', '1', '', 'yesno', 'int', 90),
(106, 1, 0, 'active_groups', '_MI_SYSTEM_PREFERENCE_ACTIVE_GROUPS', '1', '', 'hidden', 'int', 100),
(107, 1, 0, 'active_images', '_MI_SYSTEM_PREFERENCE_ACTIVE_IMAGES', '1', '', 'yesno', 'int', 110),
(108, 1, 0, 'active_mailusers', '_MI_SYSTEM_PREFERENCE_ACTIVE_MAILUSERS', '1', '', 'yesno', 'int', 120),
(109, 1, 0, 'active_modulesadmin', '_MI_SYSTEM_PREFERENCE_ACTIVE_MODULESADMIN', '1', '', 'hidden', 'int', 130),
(110, 1, 0, 'active_maintenance', '_MI_SYSTEM_PREFERENCE_ACTIVE_MAINTENANCE', '1', '', 'yesno', 'int', 140),
(111, 1, 0, 'active_preferences', '_MI_SYSTEM_PREFERENCE_ACTIVE_PREFERENCES', '1', '', 'hidden', 'int', 150),
(112, 1, 0, 'active_smilies', '_MI_SYSTEM_PREFERENCE_ACTIVE_SMILIES', '1', '', 'yesno', 'int', 160),
(113, 1, 0, 'active_tplsets', '_MI_SYSTEM_PREFERENCE_ACTIVE_TPLSETS', '1', '', 'hidden', 'int', 170),
(114, 1, 0, 'active_userrank', '_MI_SYSTEM_PREFERENCE_ACTIVE_USERRANK', '1', '', 'yesno', 'int', 180),
(115, 1, 0, 'active_users', '_MI_SYSTEM_PREFERENCE_ACTIVE_USERS', '1', '', 'yesno', 'int', 190),
(116, 1, 0, 'break3', '_MI_SYSTEM_PREFERENCE_BREAK_PAGER', 'head', '', 'line_break', 'textbox', 200),
(117, 1, 0, 'avatars_pager', '_MI_SYSTEM_PREFERENCE_AVATARS_PAGER', '10', '', 'textbox', 'int', 210),
(118, 1, 0, 'banners_pager', '_MI_SYSTEM_PREFERENCE_BANNERS_PAGER', '10', '', 'textbox', 'int', 220),
(119, 1, 0, 'comments_pager', '_MI_SYSTEM_PREFERENCE_COMMENTS_PAGER', '20', '', 'textbox', 'int', 230),
(120, 1, 0, 'groups_pager', '_MI_SYSTEM_PREFERENCE_GROUPS_PAGER', '15', '', 'textbox', 'int', 240),
(121, 1, 0, 'images_pager', '_MI_SYSTEM_PREFERENCE_IMAGES_PAGER', '15', '', 'textbox', 'int', 250),
(122, 1, 0, 'smilies_pager', '_MI_SYSTEM_PREFERENCE_SMILIES_PAGER', '20', '', 'textbox', 'int', 260),
(123, 1, 0, 'userranks_pager', '_MI_SYSTEM_PREFERENCE_USERRANKS_PAGER', '20', '', 'textbox', 'int', 270),
(124, 1, 0, 'users_pager', '_MI_SYSTEM_PREFERENCE_USERS_PAGER', '20', '', 'textbox', 'int', 280),
(125, 1, 0, 'break4', '_MI_SYSTEM_PREFERENCE_BREAK_EDITOR', 'head', '', 'line_break', 'textbox', 290),
(126, 1, 0, 'blocks_editor', '_MI_SYSTEM_PREFERENCE_BLOCKS_EDITOR', 'dhtmltextarea', '_MI_SYSTEM_PREFERENCE_BLOCKS_EDITOR_DSC', 'select', 'text', 300),
(127, 1, 0, 'comments_editor', '_MI_SYSTEM_PREFERENCE_COMMENTS_EDITOR', 'dhtmltextarea', '_MI_SYSTEM_PREFERENCE_COMMENTS_EDITOR_DSC', 'select', 'text', 310),
(128, 1, 0, 'general_editor', '_MI_SYSTEM_PREFERENCE_GENERAL_EDITOR', 'dhtmltextarea', '_MI_SYSTEM_PREFERENCE_GENERAL_EDITOR_DSC', 'select', 'text', 320),
(129, 1, 0, 'redirect', '_MI_SYSTEM_PREFERENCE_REDIRECT', 'admin.php?fct=preferences', '', 'hidden', 'text', 330),
(130, 1, 0, 'com_anonpost', '_MI_SYSTEM_PREFERENCE_ANONPOST', '', '', 'hidden', 'text', 340),
(133, 1, 0, 'jquery_theme', '_MI_SYSTEM_PREFERENCE_JQUERY_THEME', 'base', '', 'select', 'text', 35),
(134, 0, 1, 'redirect_message_ajax', '_MD_AM_CUSTOM_REDIRECT', '1', '_MD_AM_CUSTOM_REDIRECT_DESC', 'yesno', 'int', 12);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_configcategory`
--

CREATE TABLE `[[dbprefix]]_configcategory` (
  `confcat_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `confcat_name` varchar(255) NOT NULL DEFAULT '',
  `confcat_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`confcat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]_configcategory`
--

INSERT INTO `[[dbprefix]]_configcategory` VALUES
(1, '_MD_AM_GENERAL', 0),
(2, '_MD_AM_USERSETTINGS', 0),
(3, '_MD_AM_METAFOOTER', 0),
(4, '_MD_AM_CENSOR', 0),
(5, '_MD_AM_SEARCH', 0),
(6, '_MD_AM_MAILER', 0),
(7, '_MD_AM_AUTHENTICATION', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_configoption`
--

CREATE TABLE `[[dbprefix]]_configoption` (
  `confop_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `confop_name` varchar(255) NOT NULL DEFAULT '',
  `confop_value` varchar(255) NOT NULL DEFAULT '',
  `conf_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`confop_id`),
  KEY `conf_id` (`conf_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=54 ;

--
-- Dumping data for table `[[dbprefix]]_configoption`
--

INSERT INTO `[[dbprefix]]_configoption` VALUES
(1, '_MD_AM_DEBUGMODE1', '1', 13),
(2, '_MD_AM_DEBUGMODE2', '2', 13),
(3, '_NESTED', 'nest', 32),
(4, '_FLAT', 'flat', 32),
(5, '_THREADED', 'thread', 32),
(6, '_OLDESTFIRST', '0', 33),
(7, '_NEWESTFIRST', '1', 33),
(8, '_MD_AM_USERACTV', '0', 21),
(9, '_MD_AM_AUTOACTV', '1', 21),
(10, '_MD_AM_ADMINACTV', '2', 21),
(11, '_MD_AM_STRICT', '0', 23),
(12, '_MD_AM_MEDIUM', '1', 23),
(13, '_MD_AM_LIGHT', '2', 23),
(14, '_MD_AM_DEBUGMODE3', '3', 13),
(15, '_MD_AM_INDEXFOLLOW', 'index,follow', 43),
(16, '_MD_AM_NOINDEXFOLLOW', 'noindex,follow', 43),
(17, '_MD_AM_INDEXNOFOLLOW', 'index,nofollow', 43),
(18, '_MD_AM_NOINDEXNOFOLLOW', 'noindex,nofollow', 43),
(19, '_MD_AM_METAOGEN', 'general', 48),
(20, '_MD_AM_METAO14YRS', '14 years', 48),
(21, '_MD_AM_METAOREST', 'restricted', 48),
(22, '_MD_AM_METAOMAT', 'mature', 48),
(23, '_MD_AM_DEBUGMODE0', '0', 13),
(24, 'PHP mail()', 'mail', 64),
(25, 'sendmail', 'sendmail', 64),
(26, 'SMTP', 'smtp', 64),
(27, 'SMTPAuth', 'smtpauth', 64),
(28, '_MD_AM_AUTH_CONFOPTION_XOOPS', 'xoops', 74),
(29, '_MD_AM_AUTH_CONFOPTION_LDAP', 'ldap', 74),
(30, '_MD_AM_AUTH_CONFOPTION_AD', 'ads', 74),
(31, '_NO', '0', 95),
(32, '_MD_AM_WELCOMETYPE_EMAIL', '1', 95),
(33, '_MD_AM_WELCOMETYPE_PM', '2', 95),
(34, '_MD_AM_WELCOMETYPE_BOTH', '3', 95),
(35, 'dhtmltextarea', 'dhtmltextarea', 126),
(36, 'textarea', 'textarea', 126),
(37, 'tinymce', 'tinymce', 126),
(38, 'dhtmltextarea', 'dhtmltextarea', 127),
(39, 'textarea', 'textarea', 127),
(40, 'tinymce', 'tinymce', 127),
(41, 'dhtmltextarea', 'dhtmltextarea', 128),
(42, 'textarea', 'textarea', 128),
(43, 'tinymce', 'tinymce', 128),
(44, 'default', 'default', 98),
(45, 'transition', 'transition', 98),
(46, 'default', 'default', 99),
(47, 'base', 'base', 133),
(48, 'cupertino', 'cupertino', 133),
(49, 'redmond', 'redmond', 133),
(50, 'smoothness', 'smoothness', 133),
(51, 'south-street', 'south-street', 133),
(52, 'ui-darkness', 'ui-darkness', 133),
(53, 'ui-lightness', 'ui-lightness', 133);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_groups`
--

CREATE TABLE `[[dbprefix]]_groups` (
  `groupid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `description` text,
  `group_type` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`groupid`),
  KEY `group_type` (`group_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]_groups`
--

INSERT INTO `[[dbprefix]]_groups` VALUES
(1, 'Webmasters', 'Webmasters of this site', 'Admin'),
(2, 'Registered Users', 'Registered Users Group', 'User'),
(3, 'Anonymous Users', 'Anonymous Users Group', 'Anonymous');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_groups_users_link`
--

CREATE TABLE `[[dbprefix]]_groups_users_link` (
  `linkid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `groupid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`linkid`),
  KEY `groupid_uid` (`groupid`,`uid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]_groups_users_link`
--

INSERT INTO `[[dbprefix]]_groups_users_link` VALUES
(1, 1, 1),
(2, 2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_group_permission`
--

CREATE TABLE `[[dbprefix]]_group_permission` (
  `gperm_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gperm_groupid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `gperm_itemid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `gperm_modid` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `gperm_name` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`gperm_id`),
  KEY `groupid` (`gperm_groupid`),
  KEY `itemid` (`gperm_itemid`),
  KEY `gperm_modid` (`gperm_modid`,`gperm_name`(10))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=58 ;

--
-- Dumping data for table `[[dbprefix]]_group_permission`
--

INSERT INTO `[[dbprefix]]_group_permission` VALUES
(1, 1, 1, 1, 'module_admin'),
(2, 1, 1, 1, 'module_read'),
(3, 2, 1, 1, 'module_read'),
(4, 3, 1, 1, 'module_read'),
(5, 1, 1, 1, 'system_admin'),
(6, 1, 2, 1, 'system_admin'),
(7, 1, 3, 1, 'system_admin'),
(8, 1, 4, 1, 'system_admin'),
(9, 1, 5, 1, 'system_admin'),
(10, 1, 6, 1, 'system_admin'),
(11, 1, 7, 1, 'system_admin'),
(12, 1, 8, 1, 'system_admin'),
(13, 1, 9, 1, 'system_admin'),
(14, 1, 10, 1, 'system_admin'),
(15, 1, 11, 1, 'system_admin'),
(16, 1, 12, 1, 'system_admin'),
(17, 1, 13, 1, 'system_admin'),
(18, 1, 14, 1, 'system_admin'),
(19, 1, 15, 1, 'system_admin'),
(20, 1, 16, 1, 'system_admin'),
(21, 1, 17, 1, 'system_admin'),
(22, 1, 1, 1, 'block_read'),
(23, 2, 1, 1, 'block_read'),
(24, 3, 1, 1, 'block_read'),
(25, 1, 2, 1, 'block_read'),
(26, 2, 2, 1, 'block_read'),
(27, 3, 2, 1, 'block_read'),
(28, 1, 3, 1, 'block_read'),
(29, 2, 3, 1, 'block_read'),
(30, 3, 3, 1, 'block_read'),
(31, 1, 4, 1, 'block_read'),
(32, 2, 4, 1, 'block_read'),
(33, 3, 4, 1, 'block_read'),
(34, 1, 5, 1, 'block_read'),
(35, 2, 5, 1, 'block_read'),
(36, 3, 5, 1, 'block_read'),
(37, 1, 6, 1, 'block_read'),
(38, 2, 6, 1, 'block_read'),
(39, 3, 6, 1, 'block_read'),
(40, 1, 7, 1, 'block_read'),
(41, 2, 7, 1, 'block_read'),
(42, 3, 7, 1, 'block_read'),
(43, 1, 8, 1, 'block_read'),
(44, 2, 8, 1, 'block_read'),
(45, 3, 8, 1, 'block_read'),
(46, 1, 9, 1, 'block_read'),
(47, 2, 9, 1, 'block_read'),
(48, 3, 9, 1, 'block_read'),
(49, 1, 10, 1, 'block_read'),
(50, 2, 10, 1, 'block_read'),
(51, 3, 10, 1, 'block_read'),
(52, 1, 11, 1, 'block_read'),
(53, 2, 11, 1, 'block_read'),
(54, 3, 11, 1, 'block_read'),
(55, 1, 12, 1, 'block_read'),
(56, 2, 12, 1, 'block_read'),
(57, 3, 12, 1, 'block_read');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_image`
--

CREATE TABLE `[[dbprefix]]_image` (
  `image_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `image_name` varchar(30) NOT NULL DEFAULT '',
  `image_nicename` varchar(255) NOT NULL DEFAULT '',
  `image_mimetype` varchar(30) NOT NULL DEFAULT '',
  `image_created` int(10) unsigned NOT NULL DEFAULT '0',
  `image_display` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `image_weight` smallint(5) unsigned NOT NULL DEFAULT '0',
  `imgcat_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`image_id`),
  KEY `imgcat_id` (`imgcat_id`),
  KEY `image_display` (`image_display`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_imagebody`
--

CREATE TABLE `[[dbprefix]]_imagebody` (
  `image_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `image_body` mediumblob,
  KEY `image_id` (`image_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_imagecategory`
--

CREATE TABLE `[[dbprefix]]_imagecategory` (
  `imgcat_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `imgcat_name` varchar(100) NOT NULL DEFAULT '',
  `imgcat_maxsize` int(8) unsigned NOT NULL DEFAULT '0',
  `imgcat_maxwidth` smallint(3) unsigned NOT NULL DEFAULT '0',
  `imgcat_maxheight` smallint(3) unsigned NOT NULL DEFAULT '0',
  `imgcat_display` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `imgcat_weight` smallint(3) unsigned NOT NULL DEFAULT '0',
  `imgcat_type` char(1) NOT NULL DEFAULT '',
  `imgcat_storetype` varchar(5) NOT NULL DEFAULT '',
  PRIMARY KEY (`imgcat_id`),
  KEY `imgcat_display` (`imgcat_display`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_imgset`
--

CREATE TABLE `[[dbprefix]]_imgset` (
  `imgset_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `imgset_name` varchar(50) NOT NULL DEFAULT '',
  `imgset_refid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`imgset_id`),
  KEY `imgset_refid` (`imgset_refid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_imgset`
--

INSERT INTO `[[dbprefix]]_imgset` VALUES
(1, 'default', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_imgsetimg`
--

CREATE TABLE `[[dbprefix]]_imgsetimg` (
  `imgsetimg_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `imgsetimg_file` varchar(50) NOT NULL DEFAULT '',
  `imgsetimg_body` blob,
  `imgsetimg_imgset` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`imgsetimg_id`),
  KEY `imgsetimg_imgset` (`imgsetimg_imgset`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_imgset_tplset_link`
--

CREATE TABLE `[[dbprefix]]_imgset_tplset_link` (
  `imgset_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tplset_name` varchar(50) NOT NULL DEFAULT '',
  KEY `tplset_name` (`tplset_name`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_imgset_tplset_link`
--

INSERT INTO `[[dbprefix]]_imgset_tplset_link` VALUES
(1, 'default');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_modules`
--

CREATE TABLE `[[dbprefix]]_modules` (
  `mid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL DEFAULT '',
  `version` smallint(5) unsigned NOT NULL DEFAULT '100',
  `last_update` int(10) unsigned NOT NULL DEFAULT '0',
  `weight` smallint(3) unsigned NOT NULL DEFAULT '0',
  `isactive` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dirname` varchar(25) NOT NULL DEFAULT '',
  `hasmain` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hasadmin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hassearch` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hasconfig` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hascomments` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hasnotification` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`mid`),
  KEY `hasmain` (`hasmain`),
  KEY `hasadmin` (`hasadmin`),
  KEY `hassearch` (`hassearch`),
  KEY `hasnotification` (`hasnotification`),
  KEY `dirname` (`dirname`),
  KEY `name` (`name`(15)),
  KEY `isactive` (`isactive`),
  KEY `weight` (`weight`),
  KEY `hascomments` (`hascomments`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_modules`
--

INSERT INTO `[[dbprefix]]_modules` VALUES
(1, 'System', 214, [[timestamp]], 0, 1, 'system', 0, 1, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_newblocks`
--

CREATE TABLE `[[dbprefix]]_newblocks` (
  `bid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `mid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `func_num` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `options` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(150) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` text,
  `side` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` smallint(5) unsigned NOT NULL DEFAULT '0',
  `visible` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `block_type` char(1) NOT NULL DEFAULT '',
  `c_type` char(1) NOT NULL DEFAULT '',
  `isactive` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dirname` varchar(50) NOT NULL DEFAULT '',
  `func_file` varchar(50) NOT NULL DEFAULT '',
  `show_func` varchar(50) NOT NULL DEFAULT '',
  `edit_func` varchar(50) NOT NULL DEFAULT '',
  `template` varchar(50) NOT NULL DEFAULT '',
  `bcachetime` int(10) unsigned NOT NULL DEFAULT '0',
  `last_modified` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bid`),
  KEY `mid` (`mid`),
  KEY `visible` (`visible`),
  KEY `isactive_visible_mid` (`isactive`,`visible`,`mid`),
  KEY `mid_funcnum` (`mid`,`func_num`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `[[dbprefix]]_newblocks`
--

INSERT INTO `[[dbprefix]]_newblocks` VALUES
(1, 1, 0, '', 'User Menu', 'User Menu', '', 0, 0, 1, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_user_show', '', 'system_block_user.tpl', 0, [[timestamp]]),
(2, 1, 2, '', 'Login', 'Login', '', 0, 0, 1, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_login_show', '', 'system_block_login.tpl', 0, [[timestamp]]),
(3, 1, 3, '', 'Search', 'Search', '', 0, 0, 0, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_search_show', '', 'system_block_search.tpl', 0, [[timestamp]]),
(4, 1, 4, '', 'Waiting Contents', 'Waiting Contents', '', 0, 0, 0, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_waiting_show', '', 'system_block_waiting.tpl', 0, [[timestamp]]),
(5, 1, 5, '', 'Main Menu', 'Main Menu', '', 0, 0, 1, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_main_show', '', 'system_block_mainmenu.tpl', 0, [[timestamp]]),
(6, 1, 6, '320|190|s_poweredby.png|1', 'Site Info', 'Site Info', '', 0, 0, 0, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_info_show', 'b_system_info_edit', 'system_block_siteinfo.tpl', 0, [[timestamp]]),
(7, 1, 7, '', 'Who is Online', 'Who is Online', '', 0, 0, 0, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_online_show', '', 'system_block_online.tpl', 0, [[timestamp]]),
(8, 1, 8, '10|1', 'Top Posters', 'Top Posters', '', 0, 0, 0, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_topposters_show', 'b_system_topposters_edit', 'system_block_topusers.tpl', 0, [[timestamp]]),
(9, 1, 9, '10|1', 'New Members', 'New Members', '', 0, 0, 0, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_newmembers_show', 'b_system_newmembers_edit', 'system_block_newusers.tpl', 0, [[timestamp]]),
(10, 1, 10, '10', 'Recent Comments', 'Recent Comments', '', 0, 0, 0, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_comments_show', 'b_system_comments_edit', 'system_block_comments.tpl', 0, [[timestamp]]),
(11, 1, 11, '', 'Notification Options', 'Notification Options', '', 0, 0, 0, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_notification_show', '', 'system_block_notification.tpl', 0, [[timestamp]]),
(12, 1, 12, '0|120|3', 'Themes', 'Themes', '', 0, 0, 0, 'S', 'H', 1, 'system', 'system_blocks.php', 'b_system_themes_show', 'b_system_themes_edit', 'system_block_themes.tpl', 0, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_online`
--

CREATE TABLE `[[dbprefix]]_online` (
  `online_uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `online_uname` varchar(25) NOT NULL DEFAULT '',
  `online_updated` int(10) unsigned NOT NULL DEFAULT '0',
  `online_module` smallint(5) unsigned NOT NULL DEFAULT '0',
  `online_ip` varchar(45) NOT NULL DEFAULT '',
  KEY `online_module` (`online_module`),
  KEY `online_updated` (`online_updated`),
  KEY `online_uid` (`online_uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_priv_msgs`
--

CREATE TABLE `[[dbprefix]]_priv_msgs` (
  `msg_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `msg_image` varchar(100) DEFAULT NULL,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `from_userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `to_userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `msg_time` int(10) unsigned NOT NULL DEFAULT '0',
  `msg_text` text,
  `read_msg` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`msg_id`),
  KEY `to_userid` (`to_userid`),
  KEY `touseridreadmsg` (`to_userid`,`read_msg`),
  KEY `msgidfromuserid` (`from_userid`,`msg_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_ranks`
--

CREATE TABLE `[[dbprefix]]_ranks` (
  `rank_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `rank_title` varchar(50) NOT NULL DEFAULT '',
  `rank_min` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `rank_max` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `rank_special` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `rank_image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rank_id`),
  KEY `rank_min` (`rank_min`),
  KEY `rank_max` (`rank_max`),
  KEY `rankminrankmaxranspecial` (`rank_min`,`rank_max`,`rank_special`),
  KEY `rankspecial` (`rank_special`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]_ranks`
--

INSERT INTO `[[dbprefix]]_ranks` VALUES
(1, 'Just popping in', 0, 20, 0, 'ranks/rank3e632f95e81ca.gif'),
(2, 'Not too shy to talk', 21, 40, 0, 'ranks/rank3dbf8e94a6f72.gif'),
(3, 'Quite a regular', 41, 70, 0, 'ranks/rank3dbf8e9e7d88d.gif'),
(4, 'Just can''t stay away', 71, 150, 0, 'ranks/rank3dbf8ea81e642.gif'),
(5, 'Home away from home', 151, 10000, 0, 'ranks/rank3dbf8eb1a72e7.gif'),
(6, 'Moderator', 0, 0, 1, 'ranks/rank3dbf8edf15093.gif'),
(7, 'Webmaster', 0, 0, 1, 'ranks/rank3dbf8ee8681cd.gif');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_session`
--

CREATE TABLE `[[dbprefix]]_session` (
  `sess_id` varchar(256) CHARACTER SET ascii NOT NULL DEFAULT '',
  `sess_updated` int(10) unsigned NOT NULL DEFAULT '0',
  `sess_ip` varchar(45) NOT NULL DEFAULT '',
  `sess_data` text,
  PRIMARY KEY (`sess_id`),
  KEY `updated` (`sess_updated`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_session`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_smiles`
--

CREATE TABLE `[[dbprefix]]_smiles` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL DEFAULT '',
  `smile_url` varchar(100) NOT NULL DEFAULT '',
  `emotion` varchar(75) NOT NULL DEFAULT '',
  `display` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=18 ;

--
-- Dumping data for table `[[dbprefix]]_smiles`
--

INSERT INTO `[[dbprefix]]_smiles` VALUES
(1, ':-D', 'smilies/smil3dbd4d4e4c4f2.gif', 'Very Happy', 1),
(2, ':-)', 'smilies/smil3dbd4d6422f04.gif', 'Smile', 1),
(3, ':-(', 'smilies/smil3dbd4d75edb5e.gif', 'Sad', 1),
(4, ':-o', 'smilies/smil3dbd4d8676346.gif', 'Surprised', 1),
(5, ':-?', 'smilies/smil3dbd4d99c6eaa.gif', 'Confused', 1),
(6, '8-)', 'smilies/smil3dbd4daabd491.gif', 'Cool', 1),
(7, ':lol:', 'smilies/smil3dbd4dbc14f3f.gif', 'Laughing', 1),
(8, ':-x', 'smilies/smil3dbd4dcd7b9f4.gif', 'Mad', 1),
(9, ':-P', 'smilies/smil3dbd4ddd6835f.gif', 'Razz', 1),
(10, ':oops:', 'smilies/smil3dbd4df1944ee.gif', 'Embaressed', 0),
(11, ':cry:', 'smilies/smil3dbd4e02c5440.gif', 'Crying (very sad)', 0),
(12, ':evil:', 'smilies/smil3dbd4e1748cc9.gif', 'Evil or Very Mad', 0),
(13, ':roll:', 'smilies/smil3dbd4e29bbcc7.gif', 'Rolling Eyes', 0),
(14, ';-)', 'smilies/smil3dbd4e398ff7b.gif', 'Wink', 0),
(15, ':pint:', 'smilies/smil3dbd4e4c2e742.gif', 'Another pint of beer', 0),
(16, ':hammer:', 'smilies/smil3dbd4e5e7563a.gif', 'ToolTimes at work', 0),
(17, ':idea:', 'smilies/smil3dbd4e7853679.gif', 'I have an idea', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_tplfile`
--

CREATE TABLE `[[dbprefix]]_tplfile` (
  `tpl_id` mediumint(7) unsigned NOT NULL AUTO_INCREMENT,
  `tpl_refid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tpl_module` varchar(25) NOT NULL DEFAULT '',
  `tpl_tplset` varchar(50) NOT NULL DEFAULT '',
  `tpl_file` varchar(50) NOT NULL DEFAULT '',
  `tpl_desc` varchar(255) NOT NULL DEFAULT '',
  `tpl_lastmodified` int(10) unsigned NOT NULL DEFAULT '0',
  `tpl_lastimported` int(10) unsigned NOT NULL DEFAULT '0',
  `tpl_type` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`tpl_id`),
  UNIQUE KEY `tpl_refid_module_set_file_type` (`tpl_refid`,`tpl_module`,`tpl_tplset`,`tpl_file`,`tpl_type`),
  KEY `tpl_refid` (`tpl_refid`,`tpl_type`),
  KEY `tpl_tplset` (`tpl_tplset`,`tpl_file`(10))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=75 ;

--
-- Dumping data for table `[[dbprefix]]_tplfile`
--

INSERT INTO `[[dbprefix]]_tplfile` VALUES
(1, 1, 'system', 'default', 'system_imagemanager.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(2, 1, 'system', 'default', 'system_imagemanager2.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(3, 1, 'system', 'default', 'system_userinfo.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(4, 1, 'system', 'default', 'system_userform.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(5, 1, 'system', 'default', 'system_rss.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(6, 1, 'system', 'default', 'system_redirect.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(7, 1, 'system', 'default', 'system_comment.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(8, 1, 'system', 'default', 'system_comments_controls.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(9, 1, 'system', 'default', 'system_comments_flat.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(10, 1, 'system', 'default', 'system_comments_thread.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(11, 1, 'system', 'default', 'system_comments_nest.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(12, 1, 'system', 'default', 'system_siteclosed.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(13, 1, 'system', 'default', 'system_dummy.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(14, 1, 'system', 'default', 'system_notification_list.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(15, 1, 'system', 'default', 'system_notification_select.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(16, 1, 'system', 'default', 'system_block_dummy.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(17, 1, 'system', 'default', 'system_homepage.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(18, 1, 'system', 'default', 'system_bannerlogin.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(19, 1, 'system', 'default', 'system_banner.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(20, 1, 'system', 'default', 'system_bannerdisplay.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(21, 1, 'system', 'default', 'system_search.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(22, 1, 'system', 'default', 'system_popup_header.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(23, 1, 'system', 'default', 'system_popup_footer.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(24, 1, 'system', 'default', 'system_trigger_uploads.tpl', '', [[timestamp]], [[timestamp]], 'module'),
(25, 1, 'system', 'default', 'system_imagemanager.html', '', [[timestamp]], [[timestamp]], 'module'),
(26, 1, 'system', 'default', 'system_imagemanager2.html', '', [[timestamp]], [[timestamp]], 'module'),
(27, 1, 'system', 'default', 'system_userinfo.html', '', [[timestamp]], [[timestamp]], 'module'),
(28, 1, 'system', 'default', 'system_userform.html', '', [[timestamp]], [[timestamp]], 'module'),
(29, 1, 'system', 'default', 'system_rss.html', '', [[timestamp]], [[timestamp]], 'module'),
(30, 1, 'system', 'default', 'system_redirect.html', '', [[timestamp]], [[timestamp]], 'module'),
(31, 1, 'system', 'default', 'system_comment.html', '', [[timestamp]], [[timestamp]], 'module'),
(32, 1, 'system', 'default', 'system_comments_flat.html', '', [[timestamp]], [[timestamp]], 'module'),
(33, 1, 'system', 'default', 'system_comments_thread.html', '', [[timestamp]], [[timestamp]], 'module'),
(34, 1, 'system', 'default', 'system_comments_nest.html', '', [[timestamp]], [[timestamp]], 'module'),
(35, 1, 'system', 'default', 'system_siteclosed.html', '', [[timestamp]], [[timestamp]], 'module'),
(36, 1, 'system', 'default', 'system_dummy.html', '', [[timestamp]], [[timestamp]], 'module'),
(37, 1, 'system', 'default', 'system_notification_list.html', '', [[timestamp]], [[timestamp]], 'module'),
(38, 1, 'system', 'default', 'system_notification_select.html', '', [[timestamp]], [[timestamp]], 'module'),
(39, 1, 'system', 'default', 'system_block_dummy.html', '', [[timestamp]], [[timestamp]], 'module'),
(40, 1, 'system', 'default', 'system_homepage.html', '', [[timestamp]], [[timestamp]], 'module'),
(41, 1, 'system', 'default', 'system_bannerlogin.html', '', [[timestamp]], [[timestamp]], 'module'),
(42, 1, 'system', 'default', 'system_banner.html', '', [[timestamp]], [[timestamp]], 'module'),
(43, 1, 'system', 'default', 'system_bannerdisplay.html', '', [[timestamp]], [[timestamp]], 'module'),
(44, 1, 'system', 'default', 'system_header.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(45, 1, 'system', 'default', 'system_banners.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(46, 1, 'system', 'default', 'system_modules.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(47, 1, 'system', 'default', 'system_modules_confirm.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(48, 1, 'system', 'default', 'system_avatars.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(49, 1, 'system', 'default', 'system_smilies.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(50, 1, 'system', 'default', 'system_blocks.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(51, 1, 'system', 'default', 'system_blocks_item.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(52, 1, 'system', 'default', 'system_comments.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(53, 1, 'system', 'default', 'system_userrank.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(54, 1, 'system', 'default', 'system_users.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(55, 1, 'system', 'default', 'system_preferences.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(56, 1, 'system', 'default', 'system_mailusers.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(57, 1, 'system', 'default', 'system_groups.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(58, 1, 'system', 'default', 'system_images.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(59, 1, 'system', 'default', 'system_templates.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(60, 1, 'system', 'default', 'system_index.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(61, 1, 'system', 'default', 'system_maintenance.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(62, 1, 'system', 'default', 'system_help.tpl', '', [[timestamp]], [[timestamp]], 'admin'),
(63, 1, 'system', 'default', 'system_block_user.tpl', 'Shows user block', [[timestamp]], [[timestamp]], 'block'),
(64, 2, 'system', 'default', 'system_block_login.tpl', 'Shows login form', [[timestamp]], [[timestamp]], 'block'),
(65, 3, 'system', 'default', 'system_block_search.tpl', 'Shows search form block', [[timestamp]], [[timestamp]], 'block'),
(66, 4, 'system', 'default', 'system_block_waiting.tpl', 'Shows contents waiting for approval', [[timestamp]], [[timestamp]], 'block'),
(67, 5, 'system', 'default', 'system_block_mainmenu.tpl', 'Shows the main navigation menu of the site', [[timestamp]], [[timestamp]], 'block'),
(68, 6, 'system', 'default', 'system_block_siteinfo.tpl', 'Shows basic info about the site and a link to Recommend Us pop up window', [[timestamp]], [[timestamp]], 'block'),
(69, 7, 'system', 'default', 'system_block_online.tpl', 'Displays users/guests currently online', [[timestamp]], [[timestamp]], 'block'),
(70, 8, 'system', 'default', 'system_block_topusers.tpl', 'Top posters', [[timestamp]], [[timestamp]], 'block'),
(71, 9, 'system', 'default', 'system_block_newusers.tpl', 'Shows most recent users', [[timestamp]], [[timestamp]], 'block'),
(72, 10, 'system', 'default', 'system_block_comments.tpl', 'Shows most recent comments', [[timestamp]], [[timestamp]], 'block'),
(73, 11, 'system', 'default', 'system_block_notification.tpl', 'Shows notification options', [[timestamp]], [[timestamp]], 'block'),
(74, 12, 'system', 'default', 'system_block_themes.tpl', 'Shows theme selection box', [[timestamp]], [[timestamp]], 'block');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_tplset`
--

CREATE TABLE `[[dbprefix]]_tplset` (
  `tplset_id` int(7) unsigned NOT NULL AUTO_INCREMENT,
  `tplset_name` varchar(50) NOT NULL DEFAULT '',
  `tplset_desc` varchar(255) NOT NULL DEFAULT '',
  `tplset_credits` text,
  `tplset_created` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tplset_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_tplset`
--

INSERT INTO `[[dbprefix]]_tplset` VALUES
(1, 'default', 'XOOPS Default Template Set', '', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_tplsource`
--

CREATE TABLE `[[dbprefix]]_tplsource` (
  `tpl_id` mediumint(7) unsigned NOT NULL DEFAULT '0',
  `tpl_source` mediumtext,
  KEY `tpl_id` (`tpl_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_tplsource`
--

INSERT INTO `[[dbprefix]]_tplsource` VALUES
(1, '<!doctype html>\n<html lang="<{$xoops_langcode}>">\n<head>\n    <meta http-equiv="content-type" content="text/html; charset=<{$xoops_charset}>">\n    <meta http-equiv="content-language" content="<{$xoops_langcode}>">\n    <title><{$sitename}> <{$lang_imgmanager}></title>\n    <script type="text/javascript">\n        <!--//\n        function appendCode(addCode) {\n            var targetDom = window.opener.xoopsGetElementById(''<{$target}>'');\n            if (targetDom.createTextRange && targetDom.caretPos) {\n                var caretPos = targetDom.caretPos;\n                caretPos.text = caretPos.text.charAt(caretPos.text.length - 1) == '' '' ? addCode + '' '' : addCode;\n            } else if (targetDom.getSelection && targetDom.caretPos) {\n                var caretPos = targetDom.caretPos;\n                caretPos.text = caretPos.text.charat(caretPos.text.length - 1) == '' '' ? addCode + '' '' : addCode;\n            } else {\n                targetDom.value = targetDom.value + addCode;\n            }\n            window.close();\n//    return;\n        }\n        //-->\n    </script>\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl xoops.css}>">\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl modules/system/css/imagemanager.css}>">\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl media/font-awesome/css/font-awesome.min.css}>">\n\n    <{php}>\n        $language = $GLOBALS[''xoopsConfig''][''language''];\n        if(file_exists(XOOPS_ROOT_PATH.''/language/''.$language.''/style.css'')){\n        echo "\n        <link rel=\\"stylesheet\\" type=\\"text/css\\" media=\\"all\\" href=\\"language/$language/style.css\\">\n        ";\n        }\n    <{/php}>\n\n</head>\n\n<body onload="window.resizeTo(<{$xsize}>, <{$ysize}>);">\n<form action="imagemanager.php" method="get">\n    <table cellspacing="0" id="imagenav">\n        <tr>\n            <td>\n                <select name="cat_id"\n                        onchange="location=''<{$xoops_url}>/imagemanager.php?target=<{$target}>&cat_id=''+this.options[this.selectedIndex].value"><{$cat_options}></select>\n                <input type="hidden" name="target" value="<{$target}>"/>\n                <input type="submit" value="<{$lang_go}>"/>\n            </td>\n\n            <{if $show_cat > 0}>\n                <td id="addimage" class="txtright"><a href="<{$xoops_url}>/imagemanager.php?target=<{$target}>&op=upload&imgcat_id=<{$show_cat}>"\n                                                      title="<{$lang_addimage}>"><{$lang_addimage}></a></td>\n            <{/if}>\n\n        </tr>\n    </table>\n</form>\n<div id="pagenav"><{$pagenav}></div>\n<{if $image_total > 0}>\n    <table cellspacing="0" id="imagemain">\n        <tr>\n            <th><{$lang_imagename}></th>\n            <th><{$lang_image}></th>\n            <th><{$lang_imagemime}></th>\n            <th><{$lang_align}></th>\n        </tr>\n\n        <{section name=i loop=$images}>\n            <tr class="txtcenter">\n                <td><input type="hidden" name="image_id[]" value="<{$images[i].id}>"/><{$images[i].nicename}></td>\n                <td><img style="max-width:200px;" src="<{$images[i].src}>" alt=""/></td>\n                <td><{$images[i].mimetype}></td>\n                <td><button type="button" class="btn btn-default" onclick="appendCode(''<{$images[i].lxcode}>'');" title="<{$smarty.const._LEFT}>" aria-label="Left Align"><span class="fa fa-align-left" aria-hidden="true"></span></button>\n                    <button type="button" class="btn btn-default" onclick="appendCode(''<{$images[i].xcode}>'');" title="<{$smarty.const._CENTER}>" aria-label="Center Align"><span class="fa fa-align-center" aria-hidden="true"></span></button>\n                    <button type="button" class="btn btn-default" onclick="appendCode(''<{$images[i].rxcode}>'');" title="<{$smarty.const._RIGHT}>" aria-label="Right Align"><span class="fa fa-align-right" aria-hidden="true"></span></button>\n            </tr>\n        <{/section}>\n    </table>\n<{else}>\n    <div id="welcomenot"></div>\n<{/if}>\n\n<div id="pagenav"><{$pagenav}></div>\n\n<div id="footer">\n    <input value="<{$lang_close}>" type="button" onclick="window.close();"/>\n</div>\n\n</body>\n</html>\n'),
(2, '<!doctype html>\n<html lang="<{$xoops_langcode}>">\n<head>\n    <meta http-equiv="content-type" content="text/html; charset=<{$xoops_charset}>">\n    <meta http-equiv="content-language" content="<{$xoops_langcode}>">\n    <title><{$xoops_sitename}> <{$lang_imgmanager}></title>\n    <{$image_form.javascript}>\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl xoops.css}>">\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl modules/system/css/imagemanager.css}>">\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl media/font-awesome/css/font-awesome.min.css}>">\n\n    <{php}>\n        $language = $GLOBALS[''xoopsConfig''][''language''];\n        if(file_exists(XOOPS_ROOT_PATH.''/language/''.$language.''/style.css'')){\n        echo "\n        <link rel=\\"stylesheet\\" type=\\"text/css\\" media=\\"all\\" href=\\"language/$language/style.css\\"/>\n        ";\n        }\n    <{/php}>\n    <!-- fine-upload -->\n    <!-- Fine Uploader New/Modern CSS file\n    ====================================================================== -->\n    <link href="<{xoAppUrl media/fine-uploader/fine-uploader-new.css}>" rel="stylesheet">\n    <link href="<{xoAppUrl media/fine-uploader/ManuallyTriggerUploads.css}>" rel="stylesheet">\n\n    <!-- Fine Uploader JS file\n    ====================================================================== -->\n    <script src="<{$xoops_url}>/media/fine-uploader/fine-uploader.js"></script>\n    <{includeq file="db:system_trigger_uploads.tpl"}>\n    <!-- fine-upload -->\n</head>\n\n<body onload="window.resizeTo(<{$xsize|default:800}>, <{$ysize|default:572}>);">\n<table cellspacing="0" id="imagenav">\n    <tr>\n        <td id="addimage" class="txtleft"><a href="<{$xoops_url}>/imagemanager.php?target=<{$target}>&amp;cat_id=<{$show_cat}>"\n                                             title="<{$lang_imgmanager}>"><{$lang_imgmanager}></a></td>\n    </tr>\n</table>\n<h2><{$imgcat_name}></h2>\n<div id="fine-uploader-manual-trigger"></div>\n<div><{$smarty.const._IMGMAXSIZE}> <{$imgcat_maxsize}></div>\n<div><{$smarty.const._IMGMAXWIDTH}> <{$imgcat_maxwidth}></div>\n<div><{$smarty.const._IMGMAXHEIGHT}> <{$imgcat_maxheight}></div>\n\n<div id="footer">\n    <input value="<{$lang_close}>" type="button" onclick="window.close();"/>\n</div>\n<!-- Your code to create an instance of Fine Uploader and bind to the DOM/template\n====================================================================== -->\n<script>\n    var manualUploader = new qq.FineUploader({\n        element: document.getElementById(''fine-uploader-manual-trigger''),\n        template: ''qq-template-manual-trigger'',\n        request: {\n            endpoint: ''<{$xoops_url}>/ajaxfineupload.php'',\n            params: {\n                "Authorization": "<{$jwt}>"\n            }\n        },\n        text: {\n            formatProgress: "<{$smarty.const._FORMATPROGRESS}>",\n            failUpload: "<{$smarty.const._FAILUPLOAD}>",\n            waitingForResponse: "<{$smarty.const._WAITINGFORRESPONSE}>",\n            paused: "<{$smarty.const._PAUSED}>"\n        },\n        messages: {\n            typeError: "<{$smarty.const._TYPEERROR}>",\n            sizeError: "<{$smarty.const._SIZEERROR}>",\n            minSizeError: "<{$smarty.const._MINSIZEERROR}>",\n            emptyError: "<{$smarty.const._EMPTYERROR}>",\n            noFilesError: "<{$smarty.const._NOFILESERROR}>",\n            tooManyItemsError: "<{$smarty.const._TOOMANYITEMSERROR}>",\n            maxHeightImageError: "<{$smarty.const._MAXHEIGHTIMAGEERROR}>",\n            maxWidthImageError: "<{$smarty.const._MAXWIDTHIMAGEERROR}>",\n            minHeightImageError: "<{$smarty.const._MINHEIGHTIMAGEERROR}>",\n            minWidthImageError: "<{$smarty.const.__MINWIDTHIMAGEERROR}>",\n            retryFailTooManyItems: "<{$smarty.const._RETRYFAILTOOMANYITEMS}>",\n            onLeave: "<{$smarty.const._ONLEAVE}>",\n            unsupportedBrowserIos8Safari: "<{$smarty.const._UNSUPPORTEDBROWSERIOS8SAFARI}>"\n        },\n        thumbnails: {\n            placeholders: {\n                waitingPath: ''<{$xoops_url}>/media/fine-uploader/placeholders/waiting-generic.png'',\n                notAvailablePath: ''<{$xoops_url}>/media/fine-uploader/placeholders/not_available-generic.png''\n            }\n        },\n        validation: {\n            acceptFiles: [''image/jpeg'', ''image/gif'', ''image/png''],\n            allowedExtensions: [''jpeg'', ''jpg'', ''png'', ''gif''],\n            image: {\n                maxHeight: <{$imgcat_maxheight}>,\n                maxWidth: <{$imgcat_maxwidth}>\n            },\n            sizeLimit: <{$imgcat_maxsize}>,\n            itemLimit: <{$imgcat_itemlimit|default:2}>\n        },\n        autoUpload: false,\n        callbacks: {\n            onError: function(id, name, errorReason, xhrOrXdr) {\n                console.log(qq.format("Error uploading {}.  Reason: {}", name, errorReason));\n            }\n        },\n        debug: <{$fineup_debug}>\n    });\n\n    qq(document.getElementById("trigger-upload")).attach("click", function() {\n        manualUploader.uploadStoredFiles();\n    });\n</script>\n\n</body>\n</html>\n'),
(3, '<{if $user_ownpage == true}>\n    <form name="usernav" action="user.php" method="post">\n\n        <br><br>\n\n        <table class="width70 aligncenter bnone">\n            <tr class="txtcenter">\n                <td><input type="button" value="<{$lang_editprofile}>" onclick="location=''edituser.php''"/>\n                    <input type="button" value="<{$lang_avatar}>" onclick="location=''edituser.php?op=avatarform''"/>\n                    <input type="button" value="<{$lang_inbox}>" onclick="location=''viewpmsg.php''"/>\n\n                    <{if $user_candelete == true}>\n                        <input type="button" value="<{$lang_deleteaccount}>" onclick="location=''user.php?op=delete''"/>\n                    <{/if}>\n\n                    <input type="button" value="<{$lang_logout}>" onclick="location=''user.php?op=logout''"/></td>\n            </tr>\n        </table>\n    </form>\n    <br>\n    <br>\n<{elseif $xoops_isadmin != false}>\n    <br>\n    <br>\n    <table class="width70 aligncenter bnone">\n        <tr class="txtcenter">\n            <td><input type="button" value="<{$lang_editprofile}>"\n                       onclick="location=''<{$xoops_url}>/modules/system/admin.php?fct=users&amp;uid=<{$user_uid}>&amp;op=modifyUser''"/>\n                <input type="button" value="<{$lang_deleteaccount}>"\n                       onclick="location=''<{$xoops_url}>/modules/system/admin.php?fct=users&amp;op=delUser&amp;uid=<{$user_uid}>''"/>\n        </tr>\n    </table>\n    <br>\n    <br>\n<{/if}>\n\n<table class="width100 bnone" cellspacing="5">\n    <tr class="aligntop">\n        <td class="width50">\n            <table class="outer width100" cellpadding="4" cellspacing="1">\n                <tr>\n                    <th colspan="2" class="txtcenter"><{$lang_allaboutuser}></th>\n                </tr>\n                <{if $user_avatarurl}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_avatar}></td>\n                        <td class="even txt center"><img src="<{$user_avatarurl}>" alt="Avatar"/></td>\n                    </tr>\n                <{/if}>\n                <{if $user_realname}>\n                    <tr>\n                        <td class="head"><{$lang_realname}></td>\n                        <td class="odd center"><{$user_realname}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_websiteurl}>\n                    <tr>\n                        <td class="head"><{$lang_website}></td>\n                        <td class="even"><{$user_websiteurl}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_email}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_email}></td>\n                        <td class="odd"><{$user_email}></td>\n                    </tr>\n                <{/if}>\n                <{if !$user_ownpage == true}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_privmsg}></td>\n                        <td class="even"><{$user_pmlink}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_icq}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_icq}></td>\n                        <td class="odd"><{$user_icq}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_aim}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_aim}></td>\n                        <td class="even"><{$user_aim}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_yim}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_yim}></td>\n                        <td class="odd"><{$user_yim}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_msnm}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_msnm}></td>\n                        <td class="even"><{$user_msnm}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_location}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_location}></td>\n                        <td class="odd"><{$user_location}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_occupation}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_occupation}></td>\n                        <td class="even"><{$user_occupation}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_interest}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_interest}></td>\n                        <td class="odd"><{$user_interest}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_extrainfo}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_extrainfo}></td>\n                        <td class="even"><{$user_extrainfo}></td>\n                    </tr>\n                <{/if}>\n            </table>\n        </td>\n        <td class="width50">\n            <table class="outer width100" cellpadding="4" cellspacing="1">\n                <tr class="aligntop">\n                    <th class="txtcenter" colspan="2"><{$lang_statistics}></th>\n                </tr>\n                <tr class="aligntop">\n                    <td class="head"><{$lang_membersince}></td>\n                    <td class="even txtcenter"><{$user_joindate}></td>\n                </tr>\n                <tr class="aligntop">\n                    <td class="head"><{$lang_rank}></td>\n                    <td class="odd txtcenter"><{$user_rankimage}><br><{$user_ranktitle}></td>\n                </tr>\n                <tr class="aligntop">\n                    <td class="head"><{$lang_posts}></td>\n                    <td class="even txtcenter"><{$user_posts}></td>\n                </tr>\n                <tr class="aligntop">\n                    <td class="head"><{$lang_lastlogin}></td>\n                    <td class="odd center"><{$user_lastlogin}></td>\n                </tr>\n            </table>\n            <{if $user_signature}>\n                <br>\n                <table class="outer width100" cellpadding="4" cellspacing="1">\n                    <tr class="aligntop">\n                        <th colspan="2" class="txtcenter"><{$lang_signature}></th>\n                    </tr>\n                    <tr class="aligntop">\n                        <td class="even"><{$user_signature}></td>\n                    </tr>\n                </table>\n            <{/if}>\n        </td>\n    </tr>\n</table>\n\n<!-- start module search results loop -->\n<{foreach item=module from=$modules}>\n    <br class="clear"/>\n    <h4><{$module.name}></h4>\n    <!-- start results item loop -->\n    <{foreach item=result from=$module.results}>\n        <img src="<{$result.image}>" alt="<{$module.name}>"/>\n        <strong><a href="<{$result.link}>" title="<{$result.title}>"><{$result.title}></a></strong>\n        <br>\n		<span class="x-small">(<{$result.time|default:''''}>)</span>\n		<br>	\n    <{/foreach}>\n    <!-- end results item loop -->\n\n    <{$module.showall_link}>\n\n\n<{/foreach}>\n<!-- end module search results loop -->\n'),
(4, '<fieldset class="pad10">\n    <legend class="bold"><{$lang_login}></legend>\n    <form action="user.php" method="post">\n        <{$lang_username}> <input type="text" name="uname" size="26" maxlength="25" value=""/><br><br>\n        <{$lang_password}> <input type="password" name="pass" size="21" maxlength="32"/><br><br>\n        <{if isset($lang_rememberme)}>\n            <input type="checkbox" name="rememberme" value="On" />\n            <{$lang_rememberme}>\n            <br>\n            <br>\n        <{/if}>\n\n        <input type="hidden" name="op" value="login"/>\n        <input type="hidden" name="xoops_redirect" value="<{$redirect_page}>"/>\n        <input type="submit" value="<{$lang_login}>"/>\n    </form>\n    <br>\n    <a name="lost"></a>\n\n    <div><{$lang_notregister}><br></div>\n</fieldset>\n\n<br>\n\n<fieldset class="pad10">\n    <legend class="bold"><{$lang_lostpassword}></legend>\n    <div><br><{$lang_noproblem}></div>\n    <form action="lostpass.php" method="post">\n        <{$lang_youremail}> <input type="text" name="email" size="26" maxlength="60"/>&nbsp;&nbsp;<input type="hidden" name="op"\n                                                                                                         value="mailpasswd"/><input type="hidden"\n                                                                                                                                    name="t"\n                                                                                                                                    value="<{$mailpasswd_token}>"/><input\n                type="submit" value="<{$lang_sendpassword}>"/>\n    </form>\n</fieldset>\n'),
(5, '<?xml version="1.0" encoding="UTF-8"?>\n<rss version="2.0">\n    <channel>\n        <title><{$channel_title}></title>\n        <link>\n        <{$channel_link}></link>\n        <description><{$channel_desc}></description>\n        <lastBuildDate><{$channel_lastbuild}></lastBuildDate>\n        <docs>http://backend.userland.com/rss/</docs>\n        <generator><{$channel_generator}></generator>\n        <category><{$channel_category}></category>\n        <managingEditor><{$channel_editor}></managingEditor>\n        <webMaster><{$channel_webmaster}></webMaster>\n        <language><{$channel_language}></language>\n        <{if $image_url != ""}>\n            <image>\n                <title><{$channel_title}></title>\n                <url><{$image_url}></url>\n                <link>\n                <{$channel_link}></link>\n                <width><{$image_width}></width>\n                <height><{$image_height}></height>\n            </image>\n        <{/if}>\n        <{foreach item=item from=$items}>\n            <item>\n                <title><{$item.title}></title>\n                <link>\n                <{$item.link}></link>\n                <description><{$item.description}></description>\n                <pubDate><{$item.pubdate}></pubDate>\n                <guid><{$item.guid}></guid>\n            </item>\n        <{/foreach}>\n    </channel>\n</rss>\n'),
(6, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html>\n<head>\n    <meta http-equiv="Content-Type" content="text/html; charset=<{$xoops_charset}>"/>\n    <meta http-equiv="Refresh" content="<{$time}>; url=<{$url}>"/>\n    <meta name="generator" content="XOOPS"/>\n    <link rel="shortcut icon" type="image/ico" href="<{xoAppUrl favicon.ico}>"/>\n    <title><{$xoops_sitename}></title>\n    <link rel="stylesheet" type="text/css" media="all" href="<{$xoops_themecss}>"/>\n</head>\n<body>\n<div class="center bold" style="background-color: #ebebeb; border: 1px solid #fff;border-right-color: #aaa;border-bottom-color: #aaa;">\n    <h4><{$message}></h4>\n\n    <p><{$lang_ifnotreload}></p>\n</div>\n<{if $xoops_logdump != ''''}>\n    <div><{$xoops_logdump}></div>\n<{/if}>\n</body>\n</html>\n'),
(7, '<!-- start comment post -->\n<tr>\n    <td class="head"><a id="comment<{$comment.id}>"></a> <{$comment.poster.uname}></td>\n    <td class="head">\n        <div class="comDate"><span class="comDateCaption"><{$lang_posted}>:</span> <{$comment.date_posted}>&nbsp;&nbsp;\n		<{if $comment.date_posted != $comment.date_modified}>\n			<span class="comDateCaption"><{$lang_updated}>:</span><{$comment.date_modified}>\n		<{/if}>\n        </div>\n    </td>\n</tr>\n<tr>\n\n    <{if $comment.poster.id != 0}>\n        <td class="odd">\n            <div class="comUserRank">\n                <div class="comUserRankText"><{$comment.poster.rank_title}></div>\n                <img class="comUserRankImg" src="<{$xoops_upload_url}>/<{$comment.poster.rank_image}>" alt=""/>\n            </div>\n            <img class="comUserImg" src="<{$xoops_upload_url}>/<{$comment.poster.avatar}>" alt=""/>\n\n            <div class="comUserStat"><span class="comUserStatCaption"><{$lang_joined}>:</span> <{$comment.poster.regdate}></div>\n            <div class="comUserStat"><span class="comUserStatCaption"><{$lang_from}>:</span> <{$comment.poster.from}></div>\n            <div class="comUserStat"><span class="comUserStatCaption"><{$lang_posts}>:</span> <{$comment.poster.postnum}></div>\n            <div class="comUserStatus"><{$comment.poster.status}></div>\n        </td>\n    <{else}>\n        <td class="odd"></td>\n    <{/if}>\n\n    <td class="odd">\n        <div class="comTitle"><{$comment.image}><{$comment.title}></div>\n        <div class="comText"><{$comment.text}></div>\n    </td>\n</tr>\n<tr>\n    <td class="even"></td>\n\n    <{if $xoops_iscommentadmin == true}>\n        <td class="even txtright">\n            <button type="button" class="btn btn-default" onclick="window.location.href = ''<{$editcomment_link}>&amp;com_id=<{$comment.id}>''" title="<{$lang_edit}>"><span class="fa fa-pencil-square-o fa-fw"></span></button>\n            <button type="button" class="btn btn-default" onclick="window.location.href = ''<{$deletecomment_link}>&amp;com_id=<{$comment.id}>''" title="<{$lang_delete}>"><span class="fa fa-remove fa-fw"></span></button>\n            <button type="button" class="btn btn-default" onclick="window.location.href = ''<{$replycomment_link}>&amp;com_id=<{$comment.id}>''" title="<{$lang_reply}>"><span class="fa fa-reply fa-fw"></span></button>\n        </td>\n    <{elseif $xoops_isuser == true && $xoops_userid == $comment.poster.id}>\n        <td class="even txtright">\n            <button type="button" class="btn btn-default" onclick="window.location.href = ''<{$editcomment_link}>&amp;com_id=<{$comment.id}>''" title="<{$lang_edit}>"><span class="fa fa-pencil-square-o fa-fw"></span></button>\n            <button type="button" class="btn btn-default" onclick="window.location.href = ''<{$replycomment_link}>&amp;com_id=<{$comment.id}>''" title="<{$lang_reply}>"><span class="fa fa-reply fa-fw"></span></button>\n        </td>\n    <{elseif $xoops_isuser == true || $anon_canpost == true}>\n        <td class="even txtright">\n            <button type="button" class="btn btn-default" onclick="window.location.href = ''<{$replycomment_link}>&amp;com_id=<{$comment.id}>''" title="<{$lang_reply}>"><span class="fa fa-reply fa-fw"></span></button>\n        </td>\n    <{else}>\n        <td class="even"></td>\n    <{/if}>\n\n</tr>\n<!-- end comment post -->\n'),
(8, '<form method="get" action="<{$pageName}>">\n    <table width="95%" class="outer" cellspacing="1">\n        <tr>\n            <td class="even" align="center">\n                <{$commentModeSelect->render()}>\n                <{$commentOrderSelect->render()}>\n                <{$commentRefreshButton->render()}>\n                <{if ($commentPostButton|default:false) }>\n                <{$commentPostButton->render()}>\n                <{/if}>\n                <{$commentPostHidden}>\n            </td>\n        </tr>\n    </table>\n</form>\n'),
(9, '<table class="outer" cellpadding="5" cellspacing="1">\n    <tr>\n        <th class="width20"><{$lang_poster}></th>\n        <th><{$lang_thread}></th>\n    </tr>\n    <{foreach item=comment from=$comments}>\n        <{include file="db:system_comment.tpl" comment=$comment}>\n    <{/foreach}>\n</table>\n<{if $commentform}>\n    <div class="commentform"><{$commentform}></div><{/if}>\n'),
(10, '<{section name=i loop=$comments}>\n    <br>\n    <table cellspacing="1" class="outer">\n        <tr>\n            <th class="width20"><{$lang_poster}></th>\n            <th><{$lang_thread}></th>\n        </tr>\n        <{include file="db:system_comment.tpl" comment=$comments[i]}>\n    </table>\n    <{if $show_threadnav == true}>\n        <div class="txtleft marg3 pad5">\n            <a href="<{$comment_url}>" title="<{$lang_top}>"><{$lang_top}></a> | <a\n                    href="<{$comment_url}>&amp;com_id=<{$comments[i].pid}>&amp;com_rootid=<{$comments[i].rootid}>#newscomment<{$comments[i].pid}>"><{$lang_parent}></a>\n        </div>\n    <{/if}>\n\n    <{if $comments[i].show_replies == true}>\n        <!-- start comment tree -->\n        <br>\n        <table cellspacing="1" class="outer">\n            <tr>\n                <th class="width50"><{$lang_subject}></th>\n                <th class="width20 txtcenter"><{$lang_poster}></th>\n                <th class="txtright"><{$lang_posted}></th>\n            </tr>\n            <{foreach item=reply from=$comments[i].replies}>\n                <tr>\n                    <td class="even"><{$reply.prefix}> <a href="<{$comment_url}>&amp;com_id=<{$reply.id}>&amp;com_rootid=<{$reply.root_id}>" title=""><{$reply.title}></a>\n                    </td>\n                    <td class="odd txtcenter"><{$reply.poster.uname}></td>\n                    <td class="even right"><{$reply.date_posted}></td>\n                </tr>\n            <{/foreach}>\n        </table>\n        <!-- end comment tree -->\n    <{/if}>\n\n<{/section}>\n<{if $commentform}>\n    <div class="commentform"><{$commentform}></div><{/if}>\n'),
(11, '<{section name=i loop=$comments}>\n    <br>\n    <table cellspacing="1" class="outer">\n        <tr>\n            <th class="width20"><{$lang_poster}></th>\n            <th><{$lang_thread}></th>\n        </tr>\n        <{include file="db:system_comment.tpl" comment=$comments[i]}>\n    </table>\n    <!-- start comment replies -->\n    <{foreach item=reply from=$comments[i].replies}>\n        <br>\n        <table class="bnone collapse">\n            <tr>\n                <td width="<{$reply.prefix}>"></td>\n                <td>\n                    <table class="outer" cellspacing="1">\n                        <tr>\n                            <th class="width20"><{$lang_poster}></th>\n                            <th><{$lang_thread}></th>\n                        </tr>\n                        <{include file="db:system_comment.tpl" comment=$reply}>\n                    </table>\n                </td>\n            </tr>\n        </table>\n    <{/foreach}>\n    <!-- end comment tree -->\n<{/section}>\n<{if $commentform}>\n    <div class="commentform"><{$commentform}></div><{/if}>\n'),
(12, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<{$xoops_langcode}>" lang="<{$xoops_langcode}>">\n<head>\n    <meta http-equiv="content-type" content="text/html; charset=<{$xoops_charset}>"/>\n    <meta http-equiv="content-language" content="<{$xoops_langcode}>"/>\n    <title><{$xoops_sitename}> - <{$xoops_slogan}></title>\n    <meta name="robots" content="<{$xoops_meta_robots}>"/>\n    <meta name="keywords" content="<{$xoops_meta_keywords}>"/>\n    <meta name="description" content="<{$xoops_meta_description}>"/>\n    <meta name="rating" content="<{$xoops_meta_rating}>"/>\n    <meta name="author" content="<{$xoops_meta_author}>"/>\n    <meta name="copyright" content="<{$xoops_meta_copyright}>"/>\n    <meta name="generator" content="XOOPS"/>\n\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl browse.php?xoops.css}>"/>\n    <link rel="shortcut icon" type="image/ico" href="<{xoAppUrl favicon.ico}>"/>\n\n</head>\n<body>\n<table class="collapse">\n    <tr id="header">\n        <td class="alignmiddle txtcenter" style="width: 150px; background-color: #2F5376;"><a href="<{xoAppUrl }>" title=""><img\n                        src="<{xoAppUrl images/logo.gif}>" alt=""/></a></td>\n        <td class="width100 alignmiddle txtcenter" style="background-color: #2F5376;">&nbsp;</td>\n    </tr>\n    <tr>\n        <td style="height: 8px; border-bottom: 1px solid silver; background-color: #ddd;" colspan="2">&nbsp;</td>\n    </tr>\n</table>\n\n<table class="width80 txtcenter bnone" cellspacing="1" cellpadding="10">\n    <tr>\n        <td class="txtcenter">\n            <div class="txtcenter bold"\n                 style="background-color: #DDFFDF; color: #136C99; border: 1px solid #DDDDFF;border-right-color: #aaa;border-bottom-color: #aaa;padding: 10px;">\n                <{$lang_siteclosemsg}>\n            </div>\n        </td>\n    </tr>\n</table>\n\n<form action="<{xoAppUrl user.php}>" method="post">\n    <table class="collapse txtcenter solidsilver" style="width: 200px;">\n        <tr>\n            <th class="alignmiddle pad2 white" style="background-color: #2F5376;" colspan="2"><{$lang_login}></th>\n        </tr>\n        <tr>\n            <td class="pad2"><{$lang_username}></td>\n            <td class="pad2"><input type="text" name="uname" size="12" value=""/></td>\n        </tr>\n        <tr>\n            <td class="pad2"><{$lang_password}></td>\n            <td class="pad2"><input type="password" name="pass" size="12"/></td>\n        </tr>\n        <tr>\n            <td class="pad2">&nbsp;</td>\n            <td class="pad2">\n                <input type="hidden" name="xoops_redirect" value="<{$xoops_requesturi}>"/>\n                <input type="hidden" name="xoops_login" value="1"/>\n                <input type="submit" value="<{$lang_login}>"/></td>\n        </tr>\n    </table>\n</form>\n\n<table class="collapse width100">\n    <tr>\n        <td style="height:8px; border-bottom: 1px solid silver; border-top: 1px solid silver; background-color: #ddd;" colspan="2">&nbsp;</td>\n    </tr>\n</table>\n\n</body>\n</html>\n'),
(13, '<{$dummy_content}>'),
(14, '<h4><{$lang_activenotifications}></h4>\n<form name="notificationlist" action="notifications.php" method="post">\n    <table class="outer">\n        <tr>\n            <th><input name="allbox" id="allbox" onclick="xoopsCheckAll(''notificationlist'', ''allbox'');" type="checkbox" value="<{$lang_checkall}>"/>\n            </th>\n            <th><{$lang_event}></th>\n            <th><{$lang_category}></th>\n            <th><{$lang_itemid}></th>\n            <th><{$lang_itemname}></th>\n        </tr>\n        <{foreach item=module from=$modules}>\n            <tr>\n                <td class="head"><input name="del_mod[<{$module.id}>]" id="del_mod[]"\n                                        onclick="xoopsCheckGroup(''notificationlist'', ''del_mod[<{$module.id}>]'', ''del_not[<{$module.id}>][]'');"\n                                        type="checkbox" value="<{$module.id}>"/></td>\n                <td class="head" colspan="4"><{$lang_module}>: <{$module.name}></td>\n            </tr>\n            <{foreach item=category from=$module.categories}>\n                <{foreach item=item from=$category.items}>\n                    <{foreach item=notification from=$item.notifications}>\n                        <tr>\n                            <{cycle values="odd,even" assign=class}>\n                            <td class="<{$class}>"><input type="checkbox" name="del_not[<{$module.id}>][]" id="del_not[<{$module.id}>]" value="<{$notification.id}>"/>\n                            </td>\n                            <td class="<{$class}>"><{$notification.event_title}></td>\n                            <td class="<{$class}>"><{$notification.category_title}></td>\n                            <td class="<{$class}>"><{if $item.id != 0}><{$item.id}><{/if}></td>\n                            <td class="<{$class}>"><{if $item.id != 0}><{if $item.url != ''''}><a href="<{$item.url}>" title="<{$item.name}>"><{/if}><{$item.name}><{if\n                                $item.url != ''''}></a><{/if}><{/if}>\n                            </td>\n                        </tr>\n                    <{/foreach}>\n                <{/foreach}>\n            <{/foreach}>\n        <{/foreach}>\n        <tr>\n            <td class="foot" colspan="5">\n                <input type="submit" name="delete_cancel" value="<{$lang_cancel}>"/>\n                <input type="reset" name="delete_reset" value="<{$lang_clear}>"/>\n                <input type="submit" name="delete" value="<{$lang_delete}>"/>\n                <input type="hidden" name="XOOPS_TOKEN_REQUEST" value="<{$notification_token}>"/>\n            </td>\n        </tr>\n    </table>\n</form>\n'),
(15, '<{if $xoops_notification.show}>\n    <form name="notification_select" action="<{$xoops_notification.target_page}>" method="post">\n        <h4 class="txtcenter"><{$lang_activenotifications}></h4>\n        <input type="hidden" name="not_redirect" value="<{$xoops_notification.redirect_script}>"/>\n        <input type="hidden" name="XOOPS_TOKEN_REQUEST" value="<{php}>echo $GLOBALS[''xoopsSecurity'']->createToken();<{/php}>"/>\n        <table class="outer">\n            <tr>\n                <th colspan="3"><{$lang_notificationoptions}></th>\n            </tr>\n            <tr>\n                <td class="head"><{$lang_category}></td>\n                <td class="head"><input name="allbox" id="allbox" onclick="xoopsCheckAll(''notification_select'',''allbox'');" type="checkbox"\n                                        value="<{$lang_checkall}>"/></td>\n                <td class="head"><{$lang_events}></td>\n            </tr>\n            <{foreach name=outer item=category from=$xoops_notification.categories}>\n                <{foreach name=inner item=event from=$category.events}>\n                    <tr>\n                        <{if $smarty.foreach.inner.first}>\n                            <td class="even" rowspan="<{$smarty.foreach.inner.total}>"><{$category.title}></td>\n                        <{/if}>\n                        <td class="odd">\n                            <{counter assign=index}>\n                            <input type="hidden" name="not_list[<{$index}>][params]" value="<{$category.name}>,<{$category.itemid}>,<{$event.name}>"/>\n                            <input type="checkbox" id="not_list[]" name="not_list[<{$index}>][status]" value="1" <{if $event.subscribed}>checked<{/if}>\n                            />\n                        </td>\n                        <td class="odd"><{$event.caption}></td>\n                    </tr>\n                <{/foreach}>\n            <{/foreach}>\n            <tr>\n                <td class="foot txtcenter" colspan="3"><input type="submit" name="not_submit" value="<{$lang_updatenow}>"/></td>\n            </tr>\n        </table>\n        <div class="txtcenter">\n            <{$lang_notificationmethodis}>:&nbsp;<{$user_method}>&nbsp;&nbsp;[<a href="<{$editprofile_url}>" title="<{$lang_change}>"><{$lang_change}></a>]\n        </div>\n    </form>\n<{/if}>\n'),
(16, '<{$block.content}>'),
(17, '\n'),
(18, '<div id="login_window">\n    <h2 class=''content_title''><{$smarty.const._BANNERS_LOGIN_TITLE}></h2>\n\n    <form method=''post'' action=''banners.php'' class=''login_form''>\n        <div class=''credentials''>\n            <label for=''login_form-login''><{$smarty.const._BANNERS_LOGIN_LOGIN}></label>\n            <input type=''text'' name=''login'' id=''login_form-login'' value=''''/><br>\n            <label for=''login_form-password''><{$smarty.const._BANNERS_LOGIN_PASS}></label>\n            <input type=''password'' name=''pass'' id=''login_form-password'' value=''''/><br>\n        </div>\n        <div class=''actions''>\n            <input type=''hidden'' name=''op'' value=''list''/>\n            <button type=''submit''><{$smarty.const._BANNERS_LOGIN_OK}></button>\n        </div>\n        <div class=''login_info''><{$smarty.const._BANNERS_LOGIN_INFO}></div>\n        <{$TOKEN}>\n    </form>\n</div>\n'),
(19, '<h1><{$smarty.const._BANNERS_MANAGEMENT}></h1>\n<h5><{$welcomeuser}></h5>\n<div class="txtcenter"><a href="banners.php?op=logout" title="<{$smarty.const._BANNERS_LOGOUT}>"><{$smarty.const._BANNERS_LOGOUT}></a></div>\n<h4 class="content_title"><{$smarty.const._BANNERS_TITLE}></h4>\n<table cellpadding="2" cellspacing="1" summary="" class="outer">\n    <tr class="txtcenter">\n        <th><{$smarty.const._BANNERS_NO}></th>\n        <th><{$smarty.const._BANNERS_IMP_MADE}></th>\n        <th><{$smarty.const._BANNERS_IMP_TOTAL}></th>\n        <th><{$smarty.const._BANNERS_IMP_LEFT}></th>\n        <th><{$smarty.const._BANNERS_CLICKS}></th>\n        <th><{$smarty.const._BANNERS_PER_CLICKS}></th>\n        <th><{$smarty.const._BANNERS_FUNCTIONS}></th>\n    </tr>\n    <{if $bcount}>\n        <{foreach item=banner from=$banners}>\n            <tr class="even txtcenter">\n                <td><{$banner.bid}></td>\n                <td><{$banner.impmade}></td>\n                <td><{$banner.imptotal}></td>\n                <td><{$banner.left}></td>\n                <td><{$banner.clicks}></td>\n                <td><{$banner.percent}>%</td>\n                <td>\n                    <a href="banners.php?op=banner_email&amp;cid=<{$banner.cid}>&amp;bid=<{$banner.bid}>" title="<{$smarty.const._BANNERS_STATS}>"><{$smarty.const._BANNERS_STATS}></a>\n                    <a href="banners.php?op=banner_display&amp;cid=<{$banner.cid}>" title="<{$banner.bid}>"><{$smarty.const._BANNERS_SHOWBANNER}></a>\n                </td>\n            </tr>\n        <{/foreach}>\n    <{else}>\n        <tr>\n            <td class="even txtcenter" colspan="7"><{$smarty.const._BANNERS_NOTHINGFOUND}></td>\n        </tr>\n    <{/if}>\n    <tr>\n        <td class="head" colspan="7">&nbsp;</td>\n    </tr>\n</table><br><br>\n\n<h4 class="content_title"><{$smarty.const._BANNERS_FINISHED}></h4>\n\n<table cellpadding="2" cellspacing="1" summary="" class="outer">\n    <tr class="txtcenter">\n        <th><{$smarty.const._BANNERS_NO}></th>\n        <th><{$smarty.const._BANNERS_IMP_MADE}></th>\n        <th><{$smarty.const._BANNERS_CLICKS}></th>\n        <th><{$smarty.const._BANNERS_PER_CLICKS}></th>\n        <th><{$smarty.const._BANNERS_STARTED}></th>\n        <th><{$smarty.const._BANNERS_ENDED}></th>\n    </tr>\n    <{if $bcount}>\n        <{foreach item=ebanner from=$ebanners}>\n            <tr class="even txtcenter">\n                <td><{$ebanner.bid}></td>\n                <td><{$ebanner.impressions}></td>\n                <td><{$ebanner.clicks}></td>\n                <td><{$ebanner.percent}></td>\n                <td><{$ebanner.datestart}></td>\n                <td><{$ebanner.dateend}>%</td>\n            </tr>\n        <{/foreach}>\n    <{else}>\n        <tr>\n            <td class="even txtcenter" colspan="7"><{$smarty.const._BANNERS_NOTHINGFOUND}></td>\n        </tr>\n    <{/if}>\n    <tr>\n        <td class="head" colspan="7">&nbsp;</td>\n    </tr>\n</table><br>\n'),
(20, '<h1><{$smarty.const._BANNERS_MANAGEMENT}></h1>\n<h5><{$welcomeuser}></h5>\n<div class="txtcenter"><a href="banners.php?op=logout" title="<{$smarty.const._BANNERS_LOGOUT}>"><{$smarty.const._BANNERS_LOGOUT}></a></div>\n<div class="txtcenter"><a href="banners.php?op=list" title="<{$smarty.const._BANNERS_BACK}>"><{$smarty.const._BANNERS_BACK}></a></div>\n<div><{$banneractive}></div><br>\n<{if $count}>\n    <{foreach item=banner from=$banners}>\n        <form action="banners.php" method="post">\n            <table cellspacing="1" class="outer width100">\n                <th colspan="2"><{$smarty.const._BANNERS_ID}> <{$banner.bid}></th>\n                <tr>\n                    <td class="head width50">\n                        <div><{$banner.sendstats}></div>\n                        <div><{$banner.bannerpoints}></div>\n                        <{if !$banner.tplbanner}>\n                            <div></div>\n                            <div><{$smarty.const._BANNERS_URL}>\n                                <input type="text" name="url" size="50" maxlength="200" value="<{$banner.clickurl}>"/>\n                                <input type="hidden" name="bid" value="<{$banner.bid}>"/>\n                                <input type="hidden" name="cid" value="<{$banner.cid}>"/>\n                                <input type="submit" name="op" value="save"/>\n                                <{$TOKEN}>\n                            </div>\n                        <{/if}>\n                    </td>\n                    <td class="even txtcenter"><{$banner.banner_url}></td>\n                </tr>\n                <tr>\n                    <td class="head" colspan="2">&nbsp;</td>\n                </tr>\n            </table>\n            <br>\n        </form>\n    <{/foreach}>\n<{/if}>\n'),
(21, '<{if $results}>	\n	<h3><{$smarty.const._SR_SEARCHRESULTS}></h3>\n	<{$smarty.const._SR_KEYWORDS}>: <strong><{$keywords}></strong>\n	<br>\n	<{if $error_length != ''''}>\n		<{$error_length}> <strong><{$error_keywords}></strong>\n		<br>\n	<{/if}>\n	<{if $nomatch}>	\n		<br>\n		<{$nomatch}>\n		<br>\n	<{/if}>\n	<{foreach item=search from=$search}>\n		<h4><{$search.module_name}></h4>\n		<{foreach item=data from=$search.module_data}>\n			<img src="<{$data.image_link}>" title="<{$data.image_title}>" alt="<{$data.image_title}>"/> <a href="<{$data.link}>"><{$data.link_title}></a>\n			<br>\n			<{if $data.uname}>\n				<span class=''x-small''>\n					<a href="<{$data.uname_link}>"><{$data.uname}></a>\n					<{if $data.time}>\n						(<{$data.time}>)\n					<{/if}>				\n				</span>\n				<br>\n			<{/if}>\n		<{/foreach}>\n		<{if $search.module_show_all}>\n			<p>\n				<a href="<{$search.module_show_all}>"><{$smarty.const._SR_SHOWALLR}></a>\n			</p>\n		<{/if}>\n	<{/foreach}>\n<{/if}>\n<{if $showallbyuser}>	\n	<h3><{$smarty.const._SR_SEARCHRESULTS}></h3>\n	<{if $showall}>\n		<{$smarty.const._SR_KEYWORDS}>: <strong><{$keywords}></strong>\n		<br>\n	<{/if}>\n	<{$showing}>\n	<h4><{$module_name}></h4>\n	<{foreach item=data from=$results_arr}>\n		<img src="<{$data.image_link}>" title="<{$data.image_title}>" alt="<{$data.image_title}>"/> <a href="<{$data.link}>"><{$data.link_title}></a>\n		<br>\n		<{if $data.uname}>\n			<span class=''x-small''>\n				<a href="<{$data.uname_link}>"><{$data.uname}></a>\n				<{if $data.time}>\n					(<{$data.time}>)\n				<{/if}>				\n			</span>\n			<br>\n		<{/if}>\n	<{/foreach}>\n	<{if $nomatch}>\n		<p>\n			<{$smarty.const._SR_NOMATCH}>\n		</p>\n	<{/if}>\n	<{if $previous || next}>\n		<br>\n		<table>\n			<tr>\n			<{if $previous}>\n				<td align="left">\n					<a href="<{$previous}>"><{$smarty.const._SR_PREVIOUS}></a>\n				</td>\n			<{/if}>\n			<{if $next}>\n				<td align="right">\n					<a href="<{$next}>"><{$smarty.const._SR_NEXT}></a>\n				</td>\n			<{/if}>\n			</tr>\n		</table>\n	<{/if}>\n<{/if}>\n<{if $form}>\n	<br>\n	<{$form}>\n<{/if}>\n'),
(22, '<!doctype html>\n<html lang="<{$xoops_langcode}>">\n<head>\n    <meta charset="<{$xoops_charset}>">\n    <meta name="robots" content="noindex, nofollow" />\n    <title><{$xoops_sitename|escape:''html'':''UTF-8''}></title>\n    <{section name=item loop=$headItems}>\n    <{$headItems[item]}>\n    <{/section}>\n<{if $closeHead|default:false}>\n</head>\n<body>\n<{/if}>\n'),
(23, '</body>\n</html>\n'),
(24, '<!-- Fine Uploader Thumbnails template w/ customization\n====================================================================== -->\n<script type="text/template" id="qq-template-manual-trigger">\n    <div class="qq-uploader-selector qq-uploader" qq-drop-area-text="<{$smarty.const._DROPFILESHERE}>">\n        <div class="qq-total-progress-bar-container-selector qq-total-progress-bar-container">\n            <div role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" class="qq-total-progress-bar-selector qq-progress-bar qq-total-progress-bar"></div>\n        </div>\n        <div class="qq-upload-drop-area-selector qq-upload-drop-area" qq-hide-dropzone>\n            <span class="qq-upload-drop-area-text-selector"></span>\n        </div>\n        <div class="buttons">\n            <div class="qq-upload-button-selector qq-upload-button">\n                <div><{$smarty.const._SELECTFILES}></div>\n            </div>\n            <button type="button" id="trigger-upload" class="btn btn-primary" title="Upload">\n                <span class="fa fa-upload"></span> <{$smarty.const._UPLOAD}>\n            </button>\n        </div>\n        <span class="qq-drop-processing-selector qq-drop-processing">\n            <span><{$smarty.const._PROCESSINGDROPPEDFILES}></span>\n            <span class="qq-drop-processing-spinner-selector qq-drop-processing-spinner"></span>\n        </span>\n        <ul class="qq-upload-list-selector qq-upload-list" aria-live="polite" aria-relevant="additions removals">\n            <li>\n                <div class="qq-progress-bar-container-selector">\n                    <div role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" class="qq-progress-bar-selector qq-progress-bar"></div>\n                </div>\n                <span class="qq-upload-spinner-selector qq-upload-spinner"></span>\n                <img class="qq-thumbnail-selector" qq-max-size="100" qq-server-scale>\n                <span class="qq-upload-file-selector qq-upload-file"></span>\n                <span class="qq-edit-filename-icon-selector qq-edit-filename-icon" aria-label="Edit filename"></span>\n                <input class="qq-edit-filename-selector qq-edit-filename" tabindex="0" type="text">\n                <span class="qq-upload-size-selector qq-upload-size"></span>\n                <button type="button" class="qq-btn qq-upload-cancel-selector qq-upload-cancel"><{$smarty.const._CANCEL}></button>\n                <button type="button" class="qq-btn qq-upload-retry-selector qq-upload-retry"><{$smarty.const._RETRY}></button>\n                <button type="button" class="qq-btn qq-upload-delete-selector qq-upload-delete"><{$smarty.const._DELETE}></button>\n                <span role="status" class="qq-upload-status-text-selector qq-upload-status-text"></span>\n            </li>\n        </ul>\n\n        <dialog class="qq-alert-dialog-selector">\n            <div class="qq-dialog-message-selector"></div>\n            <div class="qq-dialog-buttons">\n                <button type="button" class="qq-cancel-button-selector"><{$smarty.const._CLOSE}></button>\n            </div>\n        </dialog>\n\n        <dialog class="qq-confirm-dialog-selector">\n            <div class="qq-dialog-message-selector"></div>\n            <div class="qq-dialog-buttons">\n                <button type="button" class="qq-cancel-button-selector"><{$smarty.const._NO}></button>\n                <button type="button" class="qq-ok-button-selector"><{$smarty.const._YES}></button>\n            </div>\n        </dialog>\n\n        <dialog class="qq-prompt-dialog-selector">\n            <div class="qq-dialog-message-selector"></div>\n            <input type="text">\n            <div class="qq-dialog-buttons">\n                <button type="button" class="qq-cancel-button-selector"><{$smarty.const._CANCEL}></button>\n                <button type="button" class="qq-ok-button-selector"><{$smarty.const._OK}></button>\n            </div>\n        </dialog>\n    </div>\n</script>');
INSERT INTO `[[dbprefix]]_tplsource` VALUES
(25, '<!doctype html>\n<html lang="<{$xoops_langcode}>">\n<head>\n    <meta http-equiv="content-type" content="text/html; charset=<{$xoops_charset}>">\n    <meta http-equiv="content-language" content="<{$xoops_langcode}>">\n    <title><{$sitename}> <{$lang_imgmanager}></title>\n    <script type="text/javascript">\n        <!--//\n        function appendCode(addCode) {\n            var targetDom = window.opener.xoopsGetElementById(''<{$target}>'');\n            if (targetDom.createTextRange && targetDom.caretPos) {\n                var caretPos = targetDom.caretPos;\n                caretPos.text = caretPos.text.charAt(caretPos.text.length - 1) == '' '' ? addCode + '' '' : addCode;\n            } else if (targetDom.getSelection && targetDom.caretPos) {\n                var caretPos = targetDom.caretPos;\n                caretPos.text = caretPos.text.charat(caretPos.text.length - 1) == '' '' ? addCode + '' '' : addCode;\n            } else {\n                targetDom.value = targetDom.value + addCode;\n            }\n            window.close();\n//    return;\n        }\n        //-->\n    </script>\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl xoops.css}>">\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl modules/system/css/imagemanager.css}>">\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl media/font-awesome/css/font-awesome.min.css}>">\n\n    <{php}>\n        $language = $GLOBALS[''xoopsConfig''][''language''];\n        if(file_exists(XOOPS_ROOT_PATH.''/language/''.$language.''/style.css'')){\n        echo "\n        <link rel=\\"stylesheet\\" type=\\"text/css\\" media=\\"all\\" href=\\"language/$language/style.css\\">\n        ";\n        }\n    <{/php}>\n\n</head>\n\n<body onload="window.resizeTo(<{$xsize}>, <{$ysize}>);">\n<form action="imagemanager.php" method="get">\n    <table cellspacing="0" id="imagenav">\n        <tr>\n            <td>\n                <select name="cat_id"\n                        onchange="location=''<{$xoops_url}>/imagemanager.php?target=<{$target}>&cat_id=''+this.options[this.selectedIndex].value"><{$cat_options}></select>\n                <input type="hidden" name="target" value="<{$target}>"/>\n                <input type="submit" value="<{$lang_go}>"/>\n            </td>\n\n            <{if $show_cat > 0}>\n                <td id="addimage" class="txtright"><a href="<{$xoops_url}>/imagemanager.php?target=<{$target}>&op=upload&imgcat_id=<{$show_cat}>"\n                                                      title="<{$lang_addimage}>"><{$lang_addimage}></a></td>\n            <{/if}>\n\n        </tr>\n    </table>\n</form>\n<div id="pagenav"><{$pagenav}></div>\n<{if $image_total > 0}>\n    <table cellspacing="0" id="imagemain">\n        <tr>\n            <th><{$lang_imagename}></th>\n            <th><{$lang_image}></th>\n            <th><{$lang_imagemime}></th>\n            <th><{$lang_align}></th>\n        </tr>\n\n        <{section name=i loop=$images}>\n            <tr class="txtcenter">\n                <td><input type="hidden" name="image_id[]" value="<{$images[i].id}>"/><{$images[i].nicename}></td>\n                <td><img style="max-width:200px;" src="<{$images[i].src}>" alt=""/></td>\n                <td><{$images[i].mimetype}></td>\n                <td><button type="button" class="btn btn-default" onclick="appendCode(''<{$images[i].lxcode}>'');" title="<{$smarty.const._LEFT}>" aria-label="Left Align"><span class="fa fa-align-left" aria-hidden="true"></span></button>\n                    <button type="button" class="btn btn-default" onclick="appendCode(''<{$images[i].xcode}>'');" title="<{$smarty.const._CENTER}>" aria-label="Center Align"><span class="fa fa-align-center" aria-hidden="true"></span></button>\n                    <button type="button" class="btn btn-default" onclick="appendCode(''<{$images[i].rxcode}>'');" title="<{$smarty.const._RIGHT}>" aria-label="Right Align"><span class="fa fa-align-right" aria-hidden="true"></span></button>\n            </tr>\n        <{/section}>\n    </table>\n<{else}>\n    <div id="welcomenot"></div>\n<{/if}>\n\n<div id="pagenav"><{$pagenav}></div>\n\n<div id="footer">\n    <input value="<{$lang_close}>" type="button" onclick="window.close();"/>\n</div>\n\n</body>\n</html>\n'),
(26, '<!doctype html>\n<html lang="<{$xoops_langcode}>">\n<head>\n    <meta http-equiv="content-type" content="text/html; charset=<{$xoops_charset}>">\n    <meta http-equiv="content-language" content="<{$xoops_langcode}>">\n    <title><{$xoops_sitename}> <{$lang_imgmanager}></title>\n    <{$image_form.javascript}>\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl xoops.css}>">\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl modules/system/css/imagemanager.css}>">\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl media/font-awesome/css/font-awesome.min.css}>">\n\n    <{php}>\n        $language = $GLOBALS[''xoopsConfig''][''language''];\n        if(file_exists(XOOPS_ROOT_PATH.''/language/''.$language.''/style.css'')){\n        echo "\n        <link rel=\\"stylesheet\\" type=\\"text/css\\" media=\\"all\\" href=\\"language/$language/style.css\\"/>\n        ";\n        }\n    <{/php}>\n    <!-- fine-upload -->\n    <!-- Fine Uploader New/Modern CSS file\n    ====================================================================== -->\n    <link href="<{xoAppUrl media/fine-uploader/fine-uploader-new.css}>" rel="stylesheet">\n    <link href="<{xoAppUrl media/fine-uploader/ManuallyTriggerUploads.css}>" rel="stylesheet">\n\n    <!-- Fine Uploader JS file\n    ====================================================================== -->\n    <script src="<{$xoops_url}>/media/fine-uploader/fine-uploader.js"></script>\n    <{includeq file="db:system_trigger_uploads.tpl"}>\n    <!-- fine-upload -->\n</head>\n\n<body onload="window.resizeTo(<{$xsize|default:800}>, <{$ysize|default:572}>);">\n<table cellspacing="0" id="imagenav">\n    <tr>\n        <td id="addimage" class="txtleft"><a href="<{$xoops_url}>/imagemanager.php?target=<{$target}>&amp;cat_id=<{$show_cat}>"\n                                             title="<{$lang_imgmanager}>"><{$lang_imgmanager}></a></td>\n    </tr>\n</table>\n<h2><{$imgcat_name}></h2>\n<div id="fine-uploader-manual-trigger"></div>\n<div><{$smarty.const._IMGMAXSIZE}> <{$imgcat_maxsize}></div>\n<div><{$smarty.const._IMGMAXWIDTH}> <{$imgcat_maxwidth}></div>\n<div><{$smarty.const._IMGMAXHEIGHT}> <{$imgcat_maxheight}></div>\n\n<div id="footer">\n    <input value="<{$lang_close}>" type="button" onclick="window.close();"/>\n</div>\n<!-- Your code to create an instance of Fine Uploader and bind to the DOM/template\n====================================================================== -->\n<script>\n    var manualUploader = new qq.FineUploader({\n        element: document.getElementById(''fine-uploader-manual-trigger''),\n        template: ''qq-template-manual-trigger'',\n        request: {\n            endpoint: ''<{$xoops_url}>/ajaxfineupload.php'',\n            params: {\n                "Authorization": "<{$jwt}>"\n            }\n        },\n        text: {\n            formatProgress: "<{$smarty.const._FORMATPROGRESS}>",\n            failUpload: "<{$smarty.const._FAILUPLOAD}>",\n            waitingForResponse: "<{$smarty.const._WAITINGFORRESPONSE}>",\n            paused: "<{$smarty.const._PAUSED}>"\n        },\n        messages: {\n            typeError: "<{$smarty.const._TYPEERROR}>",\n            sizeError: "<{$smarty.const._SIZEERROR}>",\n            minSizeError: "<{$smarty.const._MINSIZEERROR}>",\n            emptyError: "<{$smarty.const._EMPTYERROR}>",\n            noFilesError: "<{$smarty.const._NOFILESERROR}>",\n            tooManyItemsError: "<{$smarty.const._TOOMANYITEMSERROR}>",\n            maxHeightImageError: "<{$smarty.const._MAXHEIGHTIMAGEERROR}>",\n            maxWidthImageError: "<{$smarty.const._MAXWIDTHIMAGEERROR}>",\n            minHeightImageError: "<{$smarty.const._MINHEIGHTIMAGEERROR}>",\n            minWidthImageError: "<{$smarty.const.__MINWIDTHIMAGEERROR}>",\n            retryFailTooManyItems: "<{$smarty.const._RETRYFAILTOOMANYITEMS}>",\n            onLeave: "<{$smarty.const._ONLEAVE}>",\n            unsupportedBrowserIos8Safari: "<{$smarty.const._UNSUPPORTEDBROWSERIOS8SAFARI}>"\n        },\n        thumbnails: {\n            placeholders: {\n                waitingPath: ''<{$xoops_url}>/media/fine-uploader/placeholders/waiting-generic.png'',\n                notAvailablePath: ''<{$xoops_url}>/media/fine-uploader/placeholders/not_available-generic.png''\n            }\n        },\n        validation: {\n            acceptFiles: [''image/jpeg'', ''image/gif'', ''image/png''],\n            allowedExtensions: [''jpeg'', ''jpg'', ''png'', ''gif''],\n            image: {\n                maxHeight: <{$imgcat_maxheight}>,\n                maxWidth: <{$imgcat_maxwidth}>\n            },\n            sizeLimit: <{$imgcat_maxsize}>,\n            itemLimit: <{$imgcat_itemlimit|default:2}>\n        },\n        autoUpload: false,\n        callbacks: {\n            onError: function(id, name, errorReason, xhrOrXdr) {\n                console.log(qq.format("Error uploading {}.  Reason: {}", name, errorReason));\n            }\n        },\n        debug: <{$fineup_debug}>\n    });\n\n    qq(document.getElementById("trigger-upload")).attach("click", function() {\n        manualUploader.uploadStoredFiles();\n    });\n</script>\n\n</body>\n</html>\n'),
(27, '<{if $user_ownpage == true}>\n    <form name="usernav" action="user.php" method="post">\n\n        <br><br>\n\n        <table class="width70 aligncenter bnone">\n            <tr class="txtcenter">\n                <td><input type="button" value="<{$lang_editprofile}>" onclick="location=''edituser.php''"/>\n                    <input type="button" value="<{$lang_avatar}>" onclick="location=''edituser.php?op=avatarform''"/>\n                    <input type="button" value="<{$lang_inbox}>" onclick="location=''viewpmsg.php''"/>\n\n                    <{if $user_candelete == true}>\n                        <input type="button" value="<{$lang_deleteaccount}>" onclick="location=''user.php?op=delete''"/>\n                    <{/if}>\n\n                    <input type="button" value="<{$lang_logout}>" onclick="location=''user.php?op=logout''"/></td>\n            </tr>\n        </table>\n    </form>\n    <br>\n    <br>\n<{elseif $xoops_isadmin != false}>\n    <br>\n    <br>\n    <table class="width70 aligncenter bnone">\n        <tr class="txtcenter">\n            <td><input type="button" value="<{$lang_editprofile}>"\n                       onclick="location=''<{$xoops_url}>/modules/system/admin.php?fct=users&amp;uid=<{$user_uid}>&amp;op=modifyUser''"/>\n                <input type="button" value="<{$lang_deleteaccount}>"\n                       onclick="location=''<{$xoops_url}>/modules/system/admin.php?fct=users&amp;op=delUser&amp;uid=<{$user_uid}>''"/>\n        </tr>\n    </table>\n    <br>\n    <br>\n<{/if}>\n\n<table class="width100 bnone" cellspacing="5">\n    <tr class="aligntop">\n        <td class="width50">\n            <table class="outer width100" cellpadding="4" cellspacing="1">\n                <tr>\n                    <th colspan="2" class="txtcenter"><{$lang_allaboutuser}></th>\n                </tr>\n                <{if $user_avatarurl}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_avatar}></td>\n                        <td class="even txt center"><img src="<{$user_avatarurl}>" alt="Avatar"/></td>\n                    </tr>\n                <{/if}>\n                <{if $user_realname}>\n                    <tr>\n                        <td class="head"><{$lang_realname}></td>\n                        <td class="odd center"><{$user_realname}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_websiteurl}>\n                    <tr>\n                        <td class="head"><{$lang_website}></td>\n                        <td class="even"><{$user_websiteurl}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_email}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_email}></td>\n                        <td class="odd"><{$user_email}></td>\n                    </tr>\n                <{/if}>\n                <{if !$user_ownpage == true}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_privmsg}></td>\n                        <td class="even"><{$user_pmlink}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_icq}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_icq}></td>\n                        <td class="odd"><{$user_icq}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_aim}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_aim}></td>\n                        <td class="even"><{$user_aim}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_yim}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_yim}></td>\n                        <td class="odd"><{$user_yim}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_msnm}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_msnm}></td>\n                        <td class="even"><{$user_msnm}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_location}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_location}></td>\n                        <td class="odd"><{$user_location}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_occupation}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_occupation}></td>\n                        <td class="even"><{$user_occupation}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_interest}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_interest}></td>\n                        <td class="odd"><{$user_interest}></td>\n                    </tr>\n                <{/if}>\n                <{if $user_extrainfo}>\n                    <tr class="aligntop">\n                        <td class="head"><{$lang_extrainfo}></td>\n                        <td class="even"><{$user_extrainfo}></td>\n                    </tr>\n                <{/if}>\n            </table>\n        </td>\n        <td class="width50">\n            <table class="outer width100" cellpadding="4" cellspacing="1">\n                <tr class="aligntop">\n                    <th class="txtcenter" colspan="2"><{$lang_statistics}></th>\n                </tr>\n                <tr class="aligntop">\n                    <td class="head"><{$lang_membersince}></td>\n                    <td class="even txtcenter"><{$user_joindate}></td>\n                </tr>\n                <tr class="aligntop">\n                    <td class="head"><{$lang_rank}></td>\n                    <td class="odd txtcenter"><{$user_rankimage}><br><{$user_ranktitle}></td>\n                </tr>\n                <tr class="aligntop">\n                    <td class="head"><{$lang_posts}></td>\n                    <td class="even txtcenter"><{$user_posts}></td>\n                </tr>\n                <tr class="aligntop">\n                    <td class="head"><{$lang_lastlogin}></td>\n                    <td class="odd center"><{$user_lastlogin}></td>\n                </tr>\n            </table>\n            <{if $user_signature}>\n                <br>\n                <table class="outer width100" cellpadding="4" cellspacing="1">\n                    <tr class="aligntop">\n                        <th colspan="2" class="txtcenter"><{$lang_signature}></th>\n                    </tr>\n                    <tr class="aligntop">\n                        <td class="even"><{$user_signature}></td>\n                    </tr>\n                </table>\n            <{/if}>\n        </td>\n    </tr>\n</table>\n\n<!-- start module search results loop -->\n<{foreach item=module from=$modules}>\n    <br class="clear"/>\n    <h4><{$module.name}></h4>\n    <!-- start results item loop -->\n    <{foreach item=result from=$module.results}>\n        <img src="<{$result.image}>" alt="<{$module.name}>"/>\n        <strong><a href="<{$result.link}>" title="<{$result.title}>"><{$result.title}></a></strong>\n        <br>\n		<span class="x-small">(<{$result.time|default:''''}>)</span>\n		<br>\n    <{/foreach}>\n    <!-- end results item loop -->\n\n    <{$module.showall_link}>\n\n\n<{/foreach}>\n<!-- end module search results loop -->\n'),
(28, '<fieldset class="pad10">\n    <legend class="bold"><{$lang_login}></legend>\n    <form action="user.php" method="post">\n        <{$lang_username}> <input type="text" name="uname" size="26" maxlength="25" value=""/><br><br>\n        <{$lang_password}> <input type="password" name="pass" size="21" maxlength="32"/><br><br>\n        <{if isset($lang_rememberme)}>\n            <input type="checkbox" name="rememberme" value="On" />\n            <{$lang_rememberme}>\n            <br>\n            <br>\n        <{/if}>\n\n        <input type="hidden" name="op" value="login"/>\n        <input type="hidden" name="xoops_redirect" value="<{$redirect_page}>"/>\n        <input type="submit" value="<{$lang_login}>"/>\n    </form>\n    <br>\n    <a name="lost"></a>\n\n    <div><{$lang_notregister}><br></div>\n</fieldset>\n\n<br>\n\n<fieldset class="pad10">\n    <legend class="bold"><{$lang_lostpassword}></legend>\n    <div><br><{$lang_noproblem}></div>\n    <form action="lostpass.php" method="post">\n        <{$lang_youremail}> <input type="text" name="email" size="26" maxlength="60"/>&nbsp;&nbsp;<input type="hidden" name="op"\n                                                                                                         value="mailpasswd"/><input type="hidden"\n                                                                                                                                    name="t"\n                                                                                                                                    value="<{$mailpasswd_token}>"/><input\n                type="submit" value="<{$lang_sendpassword}>"/>\n    </form>\n</fieldset>\n'),
(29, '<?xml version="1.0" encoding="UTF-8"?>\n<rss version="2.0">\n    <channel>\n        <title><{$channel_title}></title>\n        <link>\n        <{$channel_link}></link>\n        <description><{$channel_desc}></description>\n        <lastBuildDate><{$channel_lastbuild}></lastBuildDate>\n        <docs>http://backend.userland.com/rss/</docs>\n        <generator><{$channel_generator}></generator>\n        <category><{$channel_category}></category>\n        <managingEditor><{$channel_editor}></managingEditor>\n        <webMaster><{$channel_webmaster}></webMaster>\n        <language><{$channel_language}></language>\n        <{if $image_url != ""}>\n            <image>\n                <title><{$channel_title}></title>\n                <url><{$image_url}></url>\n                <link>\n                <{$channel_link}></link>\n                <width><{$image_width}></width>\n                <height><{$image_height}></height>\n            </image>\n        <{/if}>\n        <{foreach item=item from=$items}>\n            <item>\n                <title><{$item.title}></title>\n                <link>\n                <{$item.link}></link>\n                <description><{$item.description}></description>\n                <pubDate><{$item.pubdate}></pubDate>\n                <guid><{$item.guid}></guid>\n            </item>\n        <{/foreach}>\n    </channel>\n</rss>\n'),
(30, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html>\n<head>\n    <meta http-equiv="Content-Type" content="text/html; charset=<{$xoops_charset}>"/>\n    <meta http-equiv="Refresh" content="<{$time}>; url=<{$url}>"/>\n    <meta name="generator" content="XOOPS"/>\n    <link rel="shortcut icon" type="image/ico" href="<{xoAppUrl favicon.ico}>"/>\n    <title><{$xoops_sitename}></title>\n    <link rel="stylesheet" type="text/css" media="all" href="<{$xoops_themecss}>"/>\n</head>\n<body>\n<div class="center bold" style="background-color: #ebebeb; border: 1px solid #fff;border-right-color: #aaa;border-bottom-color: #aaa;">\n    <h4><{$message}></h4>\n\n    <p><{$lang_ifnotreload}></p>\n</div>\n<{if $xoops_logdump != ''''}>\n    <div><{$xoops_logdump}></div>\n<{/if}>\n</body>\n</html>\n'),
(31, '<!-- start comment post -->\n<tr>\n    <td class="head"><a id="comment<{$comment.id}>"></a> <{$comment.poster.uname}></td>\n    <td class="head">\n        <div class="comDate"><span class="comDateCaption"><{$lang_posted}>:</span> <{$comment.date_posted}>&nbsp;&nbsp;\n		<{if $comment.date_posted != $comment.date_modified}>\n			<span class="comDateCaption"><{$lang_updated}>:</span><{$comment.date_modified}>\n		<{/if}>\n        </div>\n    </td>\n</tr>\n<tr>\n\n    <{if $comment.poster.id != 0}>\n        <td class="odd">\n            <div class="comUserRank">\n                <div class="comUserRankText"><{$comment.poster.rank_title}></div>\n                <img class="comUserRankImg" src="<{$xoops_upload_url}>/<{$comment.poster.rank_image}>" alt=""/>\n            </div>\n            <img class="comUserImg" src="<{$xoops_upload_url}>/<{$comment.poster.avatar}>" alt=""/>\n\n            <div class="comUserStat"><span class="comUserStatCaption"><{$lang_joined}>:</span> <{$comment.poster.regdate}></div>\n            <div class="comUserStat"><span class="comUserStatCaption"><{$lang_from}>:</span> <{$comment.poster.from}></div>\n            <div class="comUserStat"><span class="comUserStatCaption"><{$lang_posts}>:</span> <{$comment.poster.postnum}></div>\n            <div class="comUserStatus"><{$comment.poster.status}></div>\n        </td>\n    <{else}>\n        <td class="odd"></td>\n    <{/if}>\n\n    <td class="odd">\n        <div class="comTitle"><{$comment.image}><{$comment.title}></div>\n        <div class="comText"><{$comment.text}></div>\n    </td>\n</tr>\n<tr>\n    <td class="even"></td>\n\n    <{if $xoops_iscommentadmin == true}>\n        <td class="even txtright">\n            <a href="<{$editcomment_link}>&amp;com_id=<{$comment.id}>" title="<{$lang_edit}>"><img src="<{$xoops_url}>/images/icons/edit.gif"\n                                                                                                   alt="<{$lang_edit}>"/></a>\n            <a href="<{$deletecomment_link}>&amp;com_id=<{$comment.id}>" title="<{$lang_delete}>"><img src="<{$xoops_url}>/images/icons/delete.gif"\n                                                                                                       alt="<{$lang_delete}>"/></a>\n            <a href="<{$replycomment_link}>&amp;com_id=<{$comment.id}>" title="<{$lang_reply}>"><img src="<{$xoops_url}>/images/icons/reply.gif"\n                                                                                                     alt="<{$lang_reply}>"/></a>\n        </td>\n    <{elseif $xoops_isuser == true && $xoops_userid == $comment.poster.id}>\n        <td class="even txtright">\n            <a href="<{$editcomment_link}>&amp;com_id=<{$comment.id}>" title="<{$lang_edit}>"><img src="<{$xoops_url}>/images/icons/edit.gif"\n                                                                                                   alt="<{$lang_edit}>"/></a>\n            <a href="<{$replycomment_link}>&amp;com_id=<{$comment.id}>" title="<{$lang_reply}>"><img src="<{$xoops_url}>/images/icons/reply.gif"\n                                                                                                     alt="<{$lang_reply}>"/></a>\n        </td>\n    <{elseif $xoops_isuser == true || $anon_canpost == true}>\n        <td class="even txtright">\n            <a href="<{$replycomment_link}>&amp;com_id=<{$comment.id}>"><img src="<{$xoops_url}>/images/icons/reply.gif" alt="<{$lang_reply}>"/></a>\n        </td>\n    <{else}>\n        <td class="even"></td>\n    <{/if}>\n\n</tr>\n<!-- end comment post -->\n'),
(32, '<table class="outer" cellpadding="5" cellspacing="1">\n    <tr>\n        <th class="width20"><{$lang_poster}></th>\n        <th><{$lang_thread}></th>\n    </tr>\n    <{foreach item=comment from=$comments}>\n        <{include file="db:system_comment.tpl" comment=$comment}>\n    <{/foreach}>\n</table>\n<{if $commentform}>\n    <div class="commentform"><{$commentform}></div><{/if}>\n'),
(33, '<{section name=i loop=$comments}>\n    <br>\n    <table cellspacing="1" class="outer">\n        <tr>\n            <th class="width20"><{$lang_poster}></th>\n            <th><{$lang_thread}></th>\n        </tr>\n        <{include file="db:system_comment.tpl" comment=$comments[i]}>\n    </table>\n    <{if $show_threadnav == true}>\n        <div class="txtleft marg3 pad5">\n            <a href="<{$comment_url}>" title="<{$lang_top}>"><{$lang_top}></a> | <a\n                    href="<{$comment_url}>&amp;com_id=<{$comments[i].pid}>&amp;com_rootid=<{$comments[i].rootid}>#newscomment<{$comments[i].pid}>"><{$lang_parent}></a>\n        </div>\n    <{/if}>\n\n    <{if $comments[i].show_replies == true}>\n        <!-- start comment tree -->\n        <br>\n        <table cellspacing="1" class="outer">\n            <tr>\n                <th class="width50"><{$lang_subject}></th>\n                <th class="width20 txtcenter"><{$lang_poster}></th>\n                <th class="txtright"><{$lang_posted}></th>\n            </tr>\n            <{foreach item=reply from=$comments[i].replies}>\n                <tr>\n                    <td class="even"><{$reply.prefix}> <a href="<{$comment_url}>&amp;com_id=<{$reply.id}>&amp;com_rootid=<{$reply.root_id}>" title=""><{$reply.title}></a>\n                    </td>\n                    <td class="odd txtcenter"><{$reply.poster.uname}></td>\n                    <td class="even right"><{$reply.date_posted}></td>\n                </tr>\n            <{/foreach}>\n        </table>\n        <!-- end comment tree -->\n    <{/if}>\n\n<{/section}>\n<{if $commentform}>\n    <div class="commentform"><{$commentform}></div><{/if}>\n'),
(34, '<{section name=i loop=$comments}>\n    <br>\n    <table cellspacing="1" class="outer">\n        <tr>\n            <th class="width20"><{$lang_poster}></th>\n            <th><{$lang_thread}></th>\n        </tr>\n        <{include file="db:system_comment.tpl" comment=$comments[i]}>\n    </table>\n    <!-- start comment replies -->\n    <{foreach item=reply from=$comments[i].replies}>\n        <br>\n        <table class="bnone collapse">\n            <tr>\n                <td width="<{$reply.prefix}>"></td>\n                <td>\n                    <table class="outer" cellspacing="1">\n                        <tr>\n                            <th class="width20"><{$lang_poster}></th>\n                            <th><{$lang_thread}></th>\n                        </tr>\n                        <{include file="db:system_comment.tpl" comment=$reply}>\n                    </table>\n                </td>\n            </tr>\n        </table>\n    <{/foreach}>\n    <!-- end comment tree -->\n<{/section}>\n<{if $commentform}>\n    <div class="commentform"><{$commentform}></div><{/if}>\n'),
(35, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\n<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<{$xoops_langcode}>" lang="<{$xoops_langcode}>">\n<head>\n    <meta http-equiv="content-type" content="text/html; charset=<{$xoops_charset}>"/>\n    <meta http-equiv="content-language" content="<{$xoops_langcode}>"/>\n    <title><{$xoops_sitename}> - <{$xoops_slogan}></title>\n    <meta name="robots" content="<{$xoops_meta_robots}>"/>\n    <meta name="keywords" content="<{$xoops_meta_keywords}>"/>\n    <meta name="description" content="<{$xoops_meta_description}>"/>\n    <meta name="rating" content="<{$xoops_meta_rating}>"/>\n    <meta name="author" content="<{$xoops_meta_author}>"/>\n    <meta name="copyright" content="<{$xoops_meta_copyright}>"/>\n    <meta name="generator" content="XOOPS"/>\n\n    <link rel="stylesheet" type="text/css" media="screen" href="<{xoAppUrl browse.php?xoops.css}>"/>\n    <link rel="shortcut icon" type="image/ico" href="<{xoAppUrl favicon.ico}>"/>\n\n</head>\n<body>\n<table class="collapse">\n    <tr id="header">\n        <td class="alignmiddle txtcenter" style="width: 150px; background-color: #2F5376;"><a href="<{xoAppUrl }>" title=""><img\n                        src="<{xoAppUrl images/logo.gif}>" alt=""/></a></td>\n        <td class="width100 alignmiddle txtcenter" style="background-color: #2F5376;">&nbsp;</td>\n    </tr>\n    <tr>\n        <td style="height: 8px; border-bottom: 1px solid silver; background-color: #ddd;" colspan="2">&nbsp;</td>\n    </tr>\n</table>\n\n<table class="width80 txtcenter bnone" cellspacing="1" cellpadding="10">\n    <tr>\n        <td class="txtcenter">\n            <div class="txtcenter bold"\n                 style="background-color: #DDFFDF; color: #136C99; border: 1px solid #DDDDFF;border-right-color: #aaa;border-bottom-color: #aaa;padding: 10px;">\n                <{$lang_siteclosemsg}>\n            </div>\n        </td>\n    </tr>\n</table>\n\n<form action="<{xoAppUrl user.php}>" method="post">\n    <table class="collapse txtcenter solidsilver" style="width: 200px;">\n        <tr>\n            <th class="alignmiddle pad2 white" style="background-color: #2F5376;" colspan="2"><{$lang_login}></th>\n        </tr>\n        <tr>\n            <td class="pad2"><{$lang_username}></td>\n            <td class="pad2"><input type="text" name="uname" size="12" value=""/></td>\n        </tr>\n        <tr>\n            <td class="pad2"><{$lang_password}></td>\n            <td class="pad2"><input type="password" name="pass" size="12"/></td>\n        </tr>\n        <tr>\n            <td class="pad2">&nbsp;</td>\n            <td class="pad2">\n                <input type="hidden" name="xoops_redirect" value="<{$xoops_requesturi}>"/>\n                <input type="hidden" name="xoops_login" value="1"/>\n                <input type="submit" value="<{$lang_login}>"/></td>\n        </tr>\n    </table>\n</form>\n\n<table class="collapse width100">\n    <tr>\n        <td style="height:8px; border-bottom: 1px solid silver; border-top: 1px solid silver; background-color: #ddd;" colspan="2">&nbsp;</td>\n    </tr>\n</table>\n\n</body>\n</html>\n'),
(36, '<{$dummy_content}>'),
(37, '<h4><{$lang_activenotifications}></h4>\n<form name="notificationlist" action="notifications.php" method="post">\n    <table class="outer">\n        <tr>\n            <th><input name="allbox" id="allbox" onclick="xoopsCheckAll(''notificationlist'', ''allbox'');" type="checkbox" value="<{$lang_checkall}>"/>\n            </th>\n            <th><{$lang_event}></th>\n            <th><{$lang_category}></th>\n            <th><{$lang_itemid}></th>\n            <th><{$lang_itemname}></th>\n        </tr>\n        <{foreach item=module from=$modules}>\n            <tr>\n                <td class="head"><input name="del_mod[<{$module.id}>]" id="del_mod[]"\n                                        onclick="xoopsCheckGroup(''notificationlist'', ''del_mod[<{$module.id}>]'', ''del_not[<{$module.id}>][]'');"\n                                        type="checkbox" value="<{$module.id}>"/></td>\n                <td class="head" colspan="4"><{$lang_module}>: <{$module.name}></td>\n            </tr>\n            <{foreach item=category from=$module.categories}>\n                <{foreach item=item from=$category.items}>\n                    <{foreach item=notification from=$item.notifications}>\n                        <tr>\n                            <{cycle values="odd,even" assign=class}>\n                            <td class="<{$class}>"><input type="checkbox" name="del_not[<{$module.id}>][]" id="del_not[<{$module.id}>]" value="<{$notification.id}>"/>\n                            </td>\n                            <td class="<{$class}>"><{$notification.event_title}></td>\n                            <td class="<{$class}>"><{$notification.category_title}></td>\n                            <td class="<{$class}>"><{if $item.id != 0}><{$item.id}><{/if}></td>\n                            <td class="<{$class}>"><{if $item.id != 0}><{if $item.url != ''''}><a href="<{$item.url}>" title="<{$item.name}>"><{/if}><{$item.name}><{if\n                                $item.url != ''''}></a><{/if}><{/if}>\n                            </td>\n                        </tr>\n                    <{/foreach}>\n                <{/foreach}>\n            <{/foreach}>\n        <{/foreach}>\n        <tr>\n            <td class="foot" colspan="5">\n                <input type="submit" name="delete_cancel" value="<{$lang_cancel}>"/>\n                <input type="reset" name="delete_reset" value="<{$lang_clear}>"/>\n                <input type="submit" name="delete" value="<{$lang_delete}>"/>\n                <input type="hidden" name="XOOPS_TOKEN_REQUEST" value="<{$notification_token}>"/>\n            </td>\n        </tr>\n    </table>\n</form>\n'),
(38, '<{if $xoops_notification.show}>\n    <form name="notification_select" action="<{$xoops_notification.target_page}>" method="post">\n        <h4 class="txtcenter"><{$lang_activenotifications}></h4>\n        <input type="hidden" name="not_redirect" value="<{$xoops_notification.redirect_script}>"/>\n        <input type="hidden" name="XOOPS_TOKEN_REQUEST" value="<{php}>echo $GLOBALS[''xoopsSecurity'']->createToken();<{/php}>"/>\n        <table class="outer">\n            <tr>\n                <th colspan="3"><{$lang_notificationoptions}></th>\n            </tr>\n            <tr>\n                <td class="head"><{$lang_category}></td>\n                <td class="head"><input name="allbox" id="allbox" onclick="xoopsCheckAll(''notification_select'',''allbox'');" type="checkbox"\n                                        value="<{$lang_checkall}>"/></td>\n                <td class="head"><{$lang_events}></td>\n            </tr>\n            <{foreach name=outer item=category from=$xoops_notification.categories}>\n                <{foreach name=inner item=event from=$category.events}>\n                    <tr>\n                        <{if $smarty.foreach.inner.first}>\n                            <td class="even" rowspan="<{$smarty.foreach.inner.total}>"><{$category.title}></td>\n                        <{/if}>\n                        <td class="odd">\n                            <{counter assign=index}>\n                            <input type="hidden" name="not_list[<{$index}>][params]" value="<{$category.name}>,<{$category.itemid}>,<{$event.name}>"/>\n                            <input type="checkbox" id="not_list[]" name="not_list[<{$index}>][status]" value="1" <{if $event.subscribed}>checked<{/if}>\n                            />\n                        </td>\n                        <td class="odd"><{$event.caption}></td>\n                    </tr>\n                <{/foreach}>\n            <{/foreach}>\n            <tr>\n                <td class="foot txtcenter" colspan="3"><input type="submit" name="not_submit" value="<{$lang_updatenow}>"/></td>\n            </tr>\n        </table>\n        <div class="txtcenter">\n            <{$lang_notificationmethodis}>:&nbsp;<{$user_method}>&nbsp;&nbsp;[<a href="<{$editprofile_url}>" title="<{$lang_change}>"><{$lang_change}></a>]\n        </div>\n    </form>\n<{/if}>\n'),
(39, '<{$block.content}>'),
(40, '\n'),
(41, '<div id="login_window">\n    <h2 class=''content_title''><{$smarty.const._BANNERS_LOGIN_TITLE}></h2>\n\n    <form method=''post'' action=''banners.php'' class=''login_form''>\n        <div class=''credentials''>\n            <label for=''login_form-login''><{$smarty.const._BANNERS_LOGIN_LOGIN}></label>\n            <input type=''text'' name=''login'' id=''login_form-login'' value=''''/><br>\n            <label for=''login_form-password''><{$smarty.const._BANNERS_LOGIN_PASS}></label>\n            <input type=''password'' name=''pass'' id=''login_form-password'' value=''''/><br>\n        </div>\n        <div class=''actions''>\n            <input type=''hidden'' name=''op'' value=''list''/>\n            <button type=''submit''><{$smarty.const._BANNERS_LOGIN_OK}></button>\n        </div>\n        <div class=''login_info''><{$smarty.const._BANNERS_LOGIN_INFO}></div>\n        <{$TOKEN}>\n    </form>\n</div>\n'),
(42, '<h1><{$smarty.const._BANNERS_MANAGEMENT}></h1>\n<h5><{$welcomeuser}></h5>\n<div class="txtcenter"><a href="banners.php?op=logout" title="<{$smarty.const._BANNERS_LOGOUT}>"><{$smarty.const._BANNERS_LOGOUT}></a></div>\n<h4 class="content_title"><{$smarty.const._BANNERS_TITLE}></h4>\n<table cellpadding="2" cellspacing="1" summary="" class="outer">\n    <tr class="txtcenter">\n        <th><{$smarty.const._BANNERS_NO}></th>\n        <th><{$smarty.const._BANNERS_IMP_MADE}></th>\n        <th><{$smarty.const._BANNERS_IMP_TOTAL}></th>\n        <th><{$smarty.const._BANNERS_IMP_LEFT}></th>\n        <th><{$smarty.const._BANNERS_CLICKS}></th>\n        <th><{$smarty.const._BANNERS_PER_CLICKS}></th>\n        <th><{$smarty.const._BANNERS_FUNCTIONS}></th>\n    </tr>\n    <{if $bcount}>\n        <{foreach item=banner from=$banners}>\n            <tr class="even txtcenter">\n                <td><{$banner.bid}></td>\n                <td><{$banner.impmade}></td>\n                <td><{$banner.imptotal}></td>\n                <td><{$banner.left}></td>\n                <td><{$banner.clicks}></td>\n                <td><{$banner.percent}>%</td>\n                <td>\n                    <a href="banners.php?op=banner_email&amp;cid=<{$banner.cid}>&amp;bid=<{$banner.bid}>" title="<{$smarty.const._BANNERS_STATS}>"><{$smarty.const._BANNERS_STATS}></a>\n                    <a href="banners.php?op=banner_display&amp;cid=<{$banner.cid}>" title="<{$banner.bid}>"><{$smarty.const._BANNERS_SHOWBANNER}></a>\n                </td>\n            </tr>\n        <{/foreach}>\n    <{else}>\n        <tr>\n            <td class="even txtcenter" colspan="7"><{$smarty.const._BANNERS_NOTHINGFOUND}></td>\n        </tr>\n    <{/if}>\n    <tr>\n        <td class="head" colspan="7">&nbsp;</td>\n    </tr>\n</table><br><br>\n\n<h4 class="content_title"><{$smarty.const._BANNERS_FINISHED}></h4>\n\n<table cellpadding="2" cellspacing="1" summary="" class="outer">\n    <tr class="txtcenter">\n        <th><{$smarty.const._BANNERS_NO}></th>\n        <th><{$smarty.const._BANNERS_IMP_MADE}></th>\n        <th><{$smarty.const._BANNERS_CLICKS}></th>\n        <th><{$smarty.const._BANNERS_PER_CLICKS}></th>\n        <th><{$smarty.const._BANNERS_STARTED}></th>\n        <th><{$smarty.const._BANNERS_ENDED}></th>\n    </tr>\n    <{if $bcount}>\n        <{foreach item=ebanner from=$ebanners}>\n            <tr class="even txtcenter">\n                <td><{$ebanner.bid}></td>\n                <td><{$ebanner.impressions}></td>\n                <td><{$ebanner.clicks}></td>\n                <td><{$ebanner.percent}></td>\n                <td><{$ebanner.datestart}></td>\n                <td><{$ebanner.dateend}>%</td>\n            </tr>\n        <{/foreach}>\n    <{else}>\n        <tr>\n            <td class="even txtcenter" colspan="7"><{$smarty.const._BANNERS_NOTHINGFOUND}></td>\n        </tr>\n    <{/if}>\n    <tr>\n        <td class="head" colspan="7">&nbsp;</td>\n    </tr>\n</table><br>\n'),
(43, '<h1><{$smarty.const._BANNERS_MANAGEMENT}></h1>\n<h5><{$welcomeuser}></h5>\n<div class="txtcenter"><a href="banners.php?op=logout" title="<{$smarty.const._BANNERS_LOGOUT}>"><{$smarty.const._BANNERS_LOGOUT}></a></div>\n<div class="txtcenter"><a href="banners.php?op=list" title="<{$smarty.const._BANNERS_BACK}>"><{$smarty.const._BANNERS_BACK}></a></div>\n<div><{$banneractive}></div><br>\n<{if $count}>\n    <{foreach item=banner from=$banners}>\n        <form action="banners.php" method="post">\n            <table cellspacing="1" class="outer width100">\n                <th colspan="2"><{$smarty.const._BANNERS_ID}> <{$banner.bid}></th>\n                <tr>\n                    <td class="head width50">\n                        <div><{$banner.sendstats}></div>\n                        <div><{$banner.bannerpoints}></div>\n                        <{if !$banner.tplbanner}>\n                            <div></div>\n                            <div><{$smarty.const._BANNERS_URL}>\n                                <input type="text" name="url" size="50" maxlength="200" value="<{$banner.clickurl}>"/>\n                                <input type="hidden" name="bid" value="<{$banner.bid}>"/>\n                                <input type="hidden" name="cid" value="<{$banner.cid}>"/>\n                                <input type="submit" name="op" value="save"/>\n                                <{$TOKEN}>\n                            </div>\n                        <{/if}>\n                    </td>\n                    <td class="even txtcenter"><{$banner.banner_url}></td>\n                </tr>\n                <tr>\n                    <td class="head" colspan="2">&nbsp;</td>\n                </tr>\n            </table>\n            <br>\n        </form>\n    <{/foreach}>\n<{/if}>\n'),
(44, '<ul id="xo-breadcrumb" class="ui-corner-all" style="background-image:url(''<{xoAdminNav bc_bg.png}>''); ">\n    <{foreach item=breadcrumb from=$xo_sys_breadcrumb}>\n        <{if $breadcrumb.home}>\n            <li><a class="tooltip" href="<{$breadcrumb.link}>" title="<{$breadcrumb.title}>" style="background-image:url(''<{xoAdminNav bc_separator.png}>'');"><img\n                            class="home" src="<{xoAdminNav home.png}>" alt="<{$breadcrumb.title}>"/></a></li>\n        <{else}>\n            <{if $breadcrumb.link}>\n                <li><a class="tooltip" href="<{$breadcrumb.link}>" title="<{$breadcrumb.title}>" style="background-image:url(''<{xoAdminNav bc_separator.png}>'');"><{$breadcrumb.title}></a>\n                </li>\n            <{else}>\n                <li><{$breadcrumb.title}></li>\n            <{/if}>\n        <{/if}>\n    <{/foreach}>\n    <{if $xo_sys_help}>\n        <li class="xo-help">\n            <a class="cursorhelp tooltip help_view" title="<{$smarty.const._AM_SYSTEM_HELP_VIEW}>"\n               style="background-image:url(''<{xoAdminNav bc_separator_end.png}>''); display: visible;"><img src="<{xoAdminIcons help.png}>"\n                                                                                                           alt="<{$smarty.const._AM_SYSTEM_HELP_VIEW}>"/></a>\n            <a class="cursorhelp tooltip help_hide" title="<{$smarty.const._AM_SYSTEM_HELP_HIDE}>"\n               style="background-image:url(''<{xoAdminNav bc_separator_end.png}>''); display: none;"><img src="<{xoAdminIcons help.png}>"\n                                                                                                        alt="<{$smarty.const._AM_SYSTEM_HELP_HIDE}>"/></a>\n        </li>\n    <{/if}>\n</ul>\n<{if $help_content}>\n    <div class="hide" id="xo-system-help">\n        <{includeq file="$help_content"}>\n    </div>\n<{/if}>\n<{if $xo_sys_tips}>\n    <div class="tips ui-corner-all">\n        <img class="floatleft tooltip" src="<{xoAdminIcons tips.png}>" alt="<{$smarty.const._AM_SYSTEM_TIPS}>" title="<{$smarty.const._AM_SYSTEM_TIPS}>"/>\n\n        <div class="floatleft"><{$xo_sys_tips}></div>\n        <div class="clear">&nbsp;</div>\n    </div>\n<{else}>\n    <br>\n<{/if}>\n');
INSERT INTO `[[dbprefix]]_tplsource` VALUES
(45, '<{includeq file="db:system_header.tpl"}>\n<!--Banner-->\n<table class=''width100 bnone'' cellspacing=''1''>\n    <tr>\n        <{if $banner_count == true}>\n            <td>\n                <h4><{$smarty.const._AM_SYSTEM_BANNERS_CURACTBNR}></h4>\n            </td>\n        <{/if}>\n        <td>\n            <div class="floatright">\n                <div class="xo-buttons">\n                    <a class="ui-corner-all tooltip" href="admin.php?fct=banners&amp;op=new_banner"\n                       title="<{$smarty.const._AM_SYSTEM_BANNERS_ADDNWBNR}>">\n                        <img src="<{xoAdminIcons attach.png}>" alt="<{$smarty.const._AM_SYSTEM_BANNERS_ADDNWBNR}>"/>\n                        <{$smarty.const._AM_SYSTEM_BANNERS_ADDNWBNR}>\n                    </a>\n                    <a class="ui-corner-all tooltip" href="admin.php?fct=banners&amp;op=new_client"\n                       title="<{$smarty.const._AM_SYSTEM_BANNERS_ADDCLI}>">\n                        <img src="<{xoAdminIcons user_add.png}>" alt="<{$smarty.const._AM_SYSTEM_BANNERS_ADDCLI}>"/>\n                        <{$smarty.const._AM_SYSTEM_BANNERS_ADDCLI}>\n                    </a>\n                </div>\n            </div>\n        </td>\n    </tr>\n</table>\n<{if $banner_count == true}>\n    <table id="xo-bannerslist-sorter" cellspacing="1" class="outer tablesorter">\n        <thead>\n        <tr>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_IMPRESION}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_IMPLEFT}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_CLICKS}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_NCLICKS}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_CLINAME}></th>\n            <th class="txtcenter width10"><{$smarty.const._AM_SYSTEM_BANNERS_FUNCTION}></th>\n        </tr>\n        </thead>\n        <tbody>\n        <{foreach item=banner from=$banner}>\n            <tr class="<{cycle values=''even,odd''}>">\n                <td class="txtcenter"><{$banner.impmade}></td>\n                <td class="txtcenter"><{$banner.left}></td>\n                <td class="txtcenter"><{$banner.clicks}></td>\n                <td class="txtcenter"><{$banner.percent}>%</td>\n                <td class="txtcenter"><{$banner.name}></td>\n                <td class="xo-actions txtcenter">\n                    <img class="tooltip" onclick="display_dialog(<{$banner.bid}>, true, true, ''slide'', ''slide'', 200, 520);" src="<{xoAdminIcons display.png}>"\n                         alt="<{$smarty.const._AM_SYSTEM_BANNERS_VIEW}>" title="<{$smarty.const._AM_SYSTEM_BANNERS_VIEW}>"/>\n                    <a class="tooltip" href="admin.php?fct=banners&amp;op=banner_edit&amp;bid=<{$banner.bid}>"\n                       title="<{$smarty.const._AM_SYSTEM_BANNERS_EDIT}>">\n                        <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._AM_SYSTEM_BANNERS_EDIT}>"/>\n                    </a>\n                    <a class="tooltip" href="admin.php?fct=banners&amp;op=banner_delete&amp;bid=<{$banner.bid}>"\n                       title="<{$smarty.const._AM_SYSTEM_BANNERS_DELETE}>">\n                        <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._AM_SYSTEM_BANNERS_DELETE}>"/>\n                    </a>\n                </td>\n            </tr>\n        <{/foreach}>\n        </tbody>\n    </table>\n    <div class="clear spacer"></div>\n    <{if $nav_menu_banner}>\n        <div class="xo-avatar-pagenav floatright"><{$nav_menu_banner}></div>\n        <div class="clear spacer"></div>\n    <{/if}>\n    <!--Pop-pup-->\n    <{foreach item=banner from=$popup_banner}>\n        <div id="dialog<{$banner.bid}>" title="<{$banner.name}>" style=''display:none;''>\n            <{$banner.imageurl}>\n        </div>\n    <{/foreach}>\n    <!--Pop-pup-->\n<{/if}>\n\n<!--Banner Finish-->\n<{if $banner_finish_count == true}>\n    <h4><{$smarty.const._AM_SYSTEM_BANNERS_FINISHBNR}></h4>\n    <table id="xo-bannersfinish-sorter" cellspacing="1" class="outer tablesorter">\n        <thead>\n        <tr>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_IMPD}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_CLICKS}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_NCLICKS}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_STARTDATE}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_ENDDATE}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_CLINAME}></th>\n            <th class="txtcenter width10"><{$smarty.const._AM_SYSTEM_BANNERS_FUNCTION}></th>\n        </tr>\n        </thead>\n        <tbody>\n        <{foreach item=banner_finish from=$banner_finish}>\n            <tr class="<{cycle values=''even,odd''}>">\n                <td class="txtcenter"><{$banner_finish.impressions}></td>\n                <td class="txtcenter"><{$banner_finish.clicks}></td>\n                <td class="txtcenter"><{$banner_finish.percent}>%</td>\n                <td class="txtcenter"><{$banner_finish.datestart}></td>\n                <td class="txtcenter"><{$banner_finish.dateend}></td>\n                <td class="txtcenter"><{$banner_finish.name}></td>\n                <td class="xo-actions txtcenter">\n                    <a class="tooltip" href="admin.php?fct=banners&amp;op=banner_finish_delete&amp;bid=<{$banner_finish.bid}>"\n                       title="<{$smarty.const._AM_SYSTEM_BANNERS_DELETE}>">\n                        <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._AM_SYSTEM_BANNERS_DELETE}>"/>\n                    </a>\n                </td>\n            </tr>\n        <{/foreach}>\n        </tbody>\n    </table>\n    <div class="clear spacer"></div>\n    <{if $nav_menu_bannerF}>\n        <div class="xo-avatar-pagenav floatright"><{$nav_menu_bannerF}></div>\n        <div class="clear spacer"></div>\n    <{/if}>\n\n<{/if}>\n<!--Banner Client-->\n<{if $banner_client_count == true}>\n    <h4><{$smarty.const._AM_SYSTEM_BANNERS_ADVCLI}></h4>\n    <table id="xo-bannersclient-sorter" cellspacing="1" class="outer tablesorter">\n        <thead>\n        <tr>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_CLINAME}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_ACTIVEBNR}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_CONTNAME}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_BANNERS_CONTMAIL}></th>\n            <th class="txtcenter width10"><{$smarty.const._AM_SYSTEM_BANNERS_FUNCTION}></th>\n        </tr>\n        </thead>\n        <tbody>\n        <{foreach item=banner_client from=$banner_client}>\n            <tr class="<{cycle values=''even,odd''}>">\n                <td class="txtcenter"><{$banner_client.name}></td>\n                <td class="txtcenter"><{$banner_client.banner_active}></td>\n                <td class="txtcenter"><{$banner_client.contact}></td>\n                <td class="txtcenter"><{$banner_client.email}></td>\n                <td class="xo-actions txtcenter">\n                    <a class="tooltip" href="admin.php?fct=banners&amp;op=banner_client_edit&amp;cid=<{$banner_client.cid}>"\n                       title="<{$smarty.const._AM_SYSTEM_BANNERS_EDIT}>">\n                        <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._AM_SYSTEM_BANNERS_EDIT}>"/>\n                    </a>\n                    <a class="tooltip" href="admin.php?fct=banners&amp;op=banner_client_delete&amp;cid=<{$banner_client.cid}>"\n                       title="<{$smarty.const._AM_SYSTEM_BANNERS_DELETE}>">\n                        <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._AM_SYSTEM_BANNERS_DELETE}>"/>\n                    </a>\n                </td>\n            </tr>\n        <{/foreach}>\n        </tbody>\n    </table>\n    <div class="clear spacer"></div>\n    <{if $nav_menu_client}>\n        <div class="xo-avatar-pagenav floatright"><{$nav_menu_client}></div>\n        <div class="clear spacer"></div>\n    <{/if}>\n<{/if}>\n<br>\n<!-- Display Avatar form (add,edit) -->\n<{if $form}>\n    <div class="spacer"><{$form}></div>\n<{/if}>\n'),
(46, '<{includeq file="db:system_header.tpl"}>\n<{if $install_mods}>\n    <script type="text/javascript">\n        IMG_ON = ''<{xoAdminIcons success.png}>'';\n        IMG_OFF = ''<{xoAdminIcons cancel.png}>'';\n    </script>\n    <div class="floatleft">\n        <img class="cursorpointer tooltip" onclick="system_moduleLargeView();" src="<{xoAdminIcons view_large.png}>"\n             alt="<{$smarty.const._AM_SYSTEM_MODULES_VIEWLARGE}>" title="<{$smarty.const._AM_SYSTEM_MODULES_VIEWLARGE}>"/>\n        <img class="cursorpointer tooltip" onclick="system_moduleListView();" src="<{xoAdminIcons view_small.png}>"\n             alt="<{$smarty.const._AM_SYSTEM_MODULES_VIEWLINE}>" title="<{$smarty.const._AM_SYSTEM_MODULES_VIEWLINE}>"/>\n    </div>\n    <div class="floatright">\n        <div class="xo-buttons">\n            <a class="ui-corner-all tooltip" href="admin.php?fct=modulesadmin&amp;op=installlist" title="<{$smarty.const._AM_SYSTEM_MODULES_TOINSTALL}>">\n                <img src="<{xoAdminIcons install.png}>" alt="<{$smarty.const._AM_SYSTEM_MODULES_TOINSTALL}>"/>\n                <{$smarty.const._AM_SYSTEM_MODULES_TOINSTALL}>&nbsp;<span class="red">(<{$toinstall_nb}>)</span>\n            </a>\n        </div>\n    </div>\n    <div class="clear spacer"></div>\n    <form action="admin.php" method="post" name="moduleadmin">\n        <table id="xo-module-sort" class="outer" cellspacing="1">\n            <thead>\n            <tr class="txtcenter">\n                <th><{$smarty.const._AM_SYSTEM_MODULES_MODULE}></th>\n                <th><{$smarty.const._AM_SYSTEM_MODULES_VERSION}></th>\n                <th><{$smarty.const._AM_SYSTEM_MODULES_LASTUP}></th>\n                <th><{$smarty.const._AM_SYSTEM_MODULES_ACTIVE}></th>\n                <th><{$smarty.const._AM_SYSTEM_MODULES_MENU}></th>\n                <th><{$smarty.const._AM_SYSTEM_MODULES_ACTION}></th>\n            </tr>\n            </thead>\n            <tbody>\n            <{foreach item=row from=$install_mods}>\n                <{if $row.dirname == ''system''}>\n                    <tr class="txtcenter foot">\n                        <td>\n                            <a class="xo-logonormal tooltip" href="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.adminindex}>" title="<{$row.name}>">\n                                <img src="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.image}>" alt="<{$row.name}>"/>\n                            </a>\n\n                            <div class="spacer xo-modsimages">\n                                <a class="tooltip" href="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.adminindex}>" title="<{$row.name}>">\n                                    <img class="xo-mods hide" src="<{xoAdminIcons applications.png}>" alt="<{$row.name}>" title="<{$row.name}>"/>\n                                </a>\n                                <input type="text" name="newname[<{$row.mid}>]" value="<{$row.name}>" maxlength="150" size="20"/>\n                                <input type="hidden" name="oldname[<{$row.mid}>]" value="<{$row.name}>"/>\n                            </div>\n                        </td>\n                        <td>\n                            <{if $row.warning_update == 1}>\n                                <strong class="red"><{$row.version}></strong>\n                            <{else}>\n                                <{$row.version}> <{$row.module_status}>\n                            <{/if}>\n                        </td>\n                        <td><{$row.last_update}></td>\n                        <td class="xo-modsimages"></td>\n                        <td class="xo-modsimages"></td>\n                        <td class="xo-modsimages">\n                            <{if $row.isactive == 1}>\n                                <a class="tooltip" href="<{$xoops_url}>/modules/system/admin.php?fct=modulesadmin&amp;op=update&amp;module=<{$row.dirname}>"\n                                   title="<{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>">\n                                    <{if $row.warning_update == 1}>\n                                        <img src="<{xoAdminIcons messagebox_warning.png}>" alt="<{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>"/>\n                                    <{else}>\n                                        <img src="<{xoAdminIcons reload.png}>" alt="<{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>"/>\n                                    <{/if}>\n                                </a>\n                            <{/if}>\n                            <img class="cursorpointer tooltip" onclick="display_dialog(<{$row.mid}>, true, true, ''slide'', ''slide'', 240, 450);"\n                                 src="<{xoAdminIcons info.png}>" alt="<{$smarty.const._INFO}>" title="<{$smarty.const._INFO}>"/>\n                            <input type="hidden" name="module[]" value="<{$row.mid}>"/>\n                        </td>\n                    </tr>\n                <{/if}>\n            <{/foreach}>\n            <tr class="head">\n                <td colspan="6"></td>\n            </tr>\n            </tbody>\n            <tbody class="xo-module">\n            <{foreach item=row from=$install_mods}>\n                <{if $row.dirname != ''system'' && $row.hasmain}>\n                    <tr id="mod_<{$row.mid}>" class="<{if $row.dirname == ''system''}>xo-system <{/if}>txtcenter <{cycle values=''odd, even''}>">\n                        <td>\n                            <{if $row.hasadmin == 1 && $row.isactive == 1}>\n                                <a class="xo-logonormal tooltip" href="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.adminindex}>" title="<{$row.name}>">\n                                    <img src="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.image}>" alt="<{$row.name}>"/>\n                                </a>\n                            <{else}>\n                                <img class="xo-logonormal tooltip" src="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.image}>" alt="<{$row.name}>"\n                                     title="<{$row.name}>"/>\n                            <{/if}>\n                            <div class="spacer xo-modsimages">\n                                <{if $row.hasadmin == 1 && $row.isactive == 1}>\n                                    <a class="tooltip" href="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.adminindex}>" title="<{$row.name}>">\n                                        <img class="xo-mods hide" src="<{xoAdminIcons applications.png}>" alt="<{$row.name}>" title="<{$row.name}>"/>\n                                    </a>\n                                <{else}>\n                                    <img class="xo-mods hide tooltip" src="<{xoAdminIcons applications.png}>" alt="<{$row.name}>" title="<{$row.name}>"/>\n                                <{/if}>\n                                <input type="text" name="newname[<{$row.mid}>]" value="<{$row.name}>" maxlength="150" size="20"/>\n                                <input type="hidden" name="oldname[<{$row.mid}>]" value="<{$row.name}>"/>\n                            </div>\n                        </td>\n                        <td>\n                            <{if $row.warning_update == 1}>\n                                <a class="tooltip maxi" style="color:red;"\n                                   href="<{$xoops_url}>/modules/system/admin.php?fct=modulesadmin&amp;op=update&amp;module=<{$row.dirname}>"\n                                   title="<{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>"><{$row.version}></a>\n                                <br>\n                                <{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>\n                            <{else}>\n                                <{$row.version}> <{$row.module_status}>\n                            <{/if}>\n                        </td>\n                        <td><{$row.last_update}></td>\n                        <td class="xo-modsimages">\n                            <img id="loading_active<{$row.mid}>" src="images/spinner.gif" style="display:none;" alt="<{$smarty.const._AM_SYSTEM_LOADING}>"/>\n                            <img class="cursorpointer tooltip" id="active<{$row.mid}>"\n                                 onclick="system_setStatus( { fct: ''modulesadmin'', op: ''display'', mid: <{$row.mid}> }, ''active<{$row.mid}>'', ''admin.php'' )"\n                                 src="<{if $row.isactive}><{xoAdminIcons success.png}><{else}><{xoAdminIcons cancel.png}><{/if}>"\n                                 alt="<{if $row.isactive}><{$smarty.const._AM_SYSTEM_MODULES_DEACTIVATE}><{else}><{$smarty.const._AM_SYSTEM_MODULES_ACTIVATE}><{/if}>"\n                                 title="<{if $row.isactive}><{$smarty.const._AM_SYSTEM_MODULES_DEACTIVATE}><{else}><{$smarty.const._AM_SYSTEM_MODULES_ACTIVATE}><{/if}>"/>\n                        </td>\n                        <td class="xo-modsimages">\n                            <img id="loading_menu<{$row.mid}>" src="images/spinner.gif" style="display:none;" title="<{$smarty.const._AM_SYSTEM_LOADING}>"\n                                 alt="<{$smarty.const._AM_SYSTEM_LOADING}>"/>\n                            <img class="cursorpointer tooltip" id="menu<{$row.mid}>"\n                                 onclick="system_setStatus( { fct: ''modulesadmin'', op: ''display_in_menu'', mid: <{$row.mid}> }, ''menu<{$row.mid}>'', ''admin.php'' )"\n                                 src="<{if $row.weight != 0}><{xoAdminIcons success.png}><{else}><{xoAdminIcons cancel.png}><{/if}>"\n                                 alt="<{if $row.weight != 0}><{$smarty.const._AM_SYSTEM_MODULES_HIDE}><{else}><{$smarty.const._AM_SYSTEM_MODULES_SHOW}><{/if}>"\n                                 title="<{if $row.weight != 0}><{$smarty.const._AM_SYSTEM_MODULES_HIDE}><{else}><{$smarty.const._AM_SYSTEM_MODULES_SHOW}><{/if}>"/>\n                        </td>\n                        <td class="xo-modsimages">\n                            <{if $row.isactive == 1}>\n                                <a class="tooltip" href="<{$xoops_url}>/modules/system/admin.php?fct=modulesadmin&amp;op=update&amp;module=<{$row.dirname}>"\n                                   title="<{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>">\n                                    <{if $row.warning_update == 1}>\n                                        <img src="<{xoAdminIcons messagebox_warning.png}>" alt="<{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>"/>\n                                    <{else}>\n                                        <img src="<{xoAdminIcons reload.png}>" alt="<{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>"/>\n                                    <{/if}>\n                                </a>\n                            <{/if}>\n                            <a class="tooltip" href="<{$xoops_url}>/modules/system/admin.php?fct=modulesadmin&amp;op=uninstall&amp;module=<{$row.dirname}>"\n                               title="<{$smarty.const._AM_SYSTEM_MODULES_UNINSTALL}>">\n                                <img src="<{xoAdminIcons uninstall.png}>" alt="<{$smarty.const._AM_SYSTEM_MODULES_UNINSTALL}>"/>\n                            </a>\n                            <img class="cursorpointer tooltip" onclick="display_dialog(<{$row.mid}>, true, true, ''slide'', ''slide'', 240, 450);"\n                                 src="<{xoAdminIcons info.png}>" alt="<{$smarty.const._INFO}>" title="<{$smarty.const._INFO}>"/>\n                            <input type="hidden" name="module[]" value="<{$row.mid}>"/>\n                        </td>\n                    </tr>\n                <{/if}>\n            <{/foreach}>\n            </tbody>\n            <tbody>\n            <tr class="head">\n                <td colspan="6"></td>\n            </tr>\n            <{foreach item=row from=$install_mods}>\n                <{if $row.dirname != ''system'' && !$row.hasmain}>\n                    <tr class="txtcenter foot">\n                        <td>\n                            <a class="xo-logonormal tooltip" href="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.adminindex}>" title="<{$row.name}>">\n                                <img src="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.image}>" alt="<{$row.name}>"/>\n                            </a>\n\n                            <div class="spacer xo-modsimages">\n                                <a class="tooltip" href="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.adminindex}>" title="<{$row.name}>">\n                                    <img class="xo-mods hide" src="<{xoAdminIcons applications.png}>" alt="<{$row.name}>" title="<{$row.name}>"/>\n                                </a>\n                                <input type="text" name="newname[<{$row.mid}>]" value="<{$row.name}>" maxlength="150" size="20"/>\n                                <input type="hidden" name="oldname[<{$row.mid}>]" value="<{$row.name}>"/>\n                            </div>\n                        </td>\n                        <td>\n                            <{if $row.warning_update == 1}>\n                                <a class="tooltip maxi" style="color:red;"\n                                   href="<{$xoops_url}>/modules/system/admin.php?fct=modulesadmin&amp;op=update&amp;module=<{$row.dirname}>"\n                                   title="<{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>"><{$row.version}></a>\n                                <br>\n                                <{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>\n                            <{else}>\n                                <{$row.version}> <{$row.module_status}>\n                            <{/if}>\n                        </td>\n                        <td><{$row.last_update}></td>\n                        <td class="xo-modsimages"><img id="loading_mid<{$row.mid}>" src="images/spinner.gif" style="display:none;"\n                                                       title="<{$smarty.const._AM_SYSTEM_LOADING}>" alt="<{$smarty.const._AM_SYSTEM_LOADING}>"/><img\n                                    class="cursorpointer tooltip" id="mid<{$row.mid}>"\n                                    onclick="system_setStatus( { fct: ''modulesadmin'', op: ''display'', mid: <{$row.mid}> }, ''mid<{$row.mid}>'', ''admin.php'' )"\n                                    src="<{if $row.isactive}><{xoAdminIcons success.png}><{else}><{xoAdminIcons cancel.png}><{/if}>"\n                                    alt="<{if $row.isactive}><{$smarty.const._AM_SYSTEM_MODULES_DEACTIVATE}><{else}><{$smarty.const._AM_SYSTEM_MODULES_ACTIVATE}><{/if}>"\n                                    title="<{if $row.isactive}><{$smarty.const._AM_SYSTEM_MODULES_DEACTIVATE}><{else}><{$smarty.const._AM_SYSTEM_MODULES_ACTIVATE}><{/if}>"/>\n                        </td>\n                        <td class="xo-modsimages"></td>\n                        <td class="xo-modsimages">\n                            <{if $row.isactive == 1}>\n                                <a class="tooltip" href="<{$xoops_url}>/modules/system/admin.php?fct=modulesadmin&amp;op=update&amp;module=<{$row.dirname}>"\n                                   title="<{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>">\n                                    <img src="<{xoAdminIcons reload.png}>" alt="<{$smarty.const._AM_SYSTEM_MODULES_UPDATE}>"/>\n                                </a>\n                            <{/if}>\n                            <a class="tooltip" href="<{$xoops_url}>/modules/system/admin.php?fct=modulesadmin&amp;op=uninstall&amp;module=<{$row.dirname}>"\n                               title="<{$smarty.const._AM_SYSTEM_MODULES_UNINSTALL}>">\n                                <img src="<{xoAdminIcons uninstall.png}>" alt="<{$smarty.const._AM_SYSTEM_MODULES_UNINSTALL}>"/>\n                            </a>\n                            <img class="cursorpointer tooltip" onclick="display_dialog(<{$row.mid}>, true, true, ''slide'', ''slide'', 240, 450);"\n                                 src="<{xoAdminIcons info.png}>" alt="<{$smarty.const._INFO}>" title="<{$smarty.const._INFO}>"/>\n                            <input type="hidden" name="module[]" value="<{$row.mid}>"/>\n                        </td>\n                    </tr>\n                <{/if}>\n            <{/foreach}>\n            </tbody>\n            <tfoot>\n            <tr class="txtcenter foot">\n                <td colspan="6">\n                    <input type="hidden" name="fct" value="modulesadmin"/>\n                    <input type="hidden" name="op" value="confirm"/>\n                    <input class="xo-formbuttons" type="submit" name="submit" value="<{$smarty.const._AM_SYSTEM_MODULES_SUBMIT}>"/>\n                </td>\n            </tr>\n            </tfoot>\n        </table>\n        <{php}>echo $GLOBALS[''xoopsSecurity'']->getTokenHTML();<{/php}>\n    </form>\n<{/if}>\n\n<{if $toinstall_mods}>\n    <div class="floatleft">\n        <img class="cursorpointer tooltip" onclick="system_moduleLargeView();" src="<{xoAdminIcons view_large.png}>"\n             alt="<{$smarty.const._AM_SYSTEM_MODULES_VIEWLARGE}>" title="<{$smarty.const._AM_SYSTEM_MODULES_VIEWLARGE}>"/>\n        <img class="cursorpointer tooltip" onclick="system_moduleListView();" src="<{xoAdminIcons view_small.png}>"\n             alt="<{$smarty.const._AM_SYSTEM_MODULES_VIEWLINE}>" title="<{$smarty.const._AM_SYSTEM_MODULES_VIEWLINE}>"/>\n    </div>\n    <div class="clear spacer"></div>\n    <table class="outer" cellspacing="1">\n        <thead>\n        <tr class="txtcenter">\n            <th><{$smarty.const._AM_SYSTEM_MODULES_MODULE}></th>\n            <th><{$smarty.const._AM_SYSTEM_MODULES_VERSION}></th>\n            <th><{$smarty.const._AM_SYSTEM_MODULES_ACTION}></th>\n        </tr>\n        </thead>\n        <tbody>\n        <{foreach item=row from=$toinstall_mods}>\n            <tr class="txtcenter <{cycle values=''odd, even''}>">\n                <td>\n                    <img class="xo-logonormal" src="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.image}>" alt="<{$row.name}>" title="<{$row.name}>"/>\n\n                    <div class="spacer xo-modsimages">\n                        <{if $row.hasadmin == 1 && $row.isactive == 1}>\n                            <a class="tooltip" href="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.adminindex}>" title="<{$row.name}>">\n                                <img class="xo-mods hide" src="<{xoAdminIcons applications.png}>" alt="<{$row.name}>" title="<{$row.name}>"/>\n                            </a>\n                        <{else}>\n                            <img class="xo-mods hide tooltip" src="<{xoAdminIcons applications.png}>" alt="<{$row.name}>" title="<{$row.name}>"/>\n                        <{/if}>\n                        <span class="spacer bold"><{$row.name}></span>\n                    </div>\n                </td>\n                <td><{$row.version}> <{$row.module_status}></td>\n                <td class="xo-modsimages">\n                    <a class="tooltip" href="<{$xoops_url}>/modules/system/admin.php?fct=modulesadmin&amp;op=install&amp;module=<{$row.dirname}>"\n                       title="<{$smarty.const._AM_SYSTEM_MODULES_INSTALL}>">\n                        <img src="<{xoAdminIcons install.png}>" alt="<{$smarty.const._AM_SYSTEM_MODULES_INSTALL}>"/>\n                    </a>\n                    <img class="cursorpointer tooltip" onclick="display_dialog(<{$row.mid}>, true, true, ''slide'', ''slide'', 240, 450);"\n                         src="<{xoAdminIcons info.png}>" alt="<{$smarty.const._INFO}>" title="<{$smarty.const._INFO}>"/>\n                </td>\n            </tr>\n        <{/foreach}>\n        </tbody>\n    </table>\n<{/if}>\n<!--Pop-pup-->\n<{foreach item=row from=$mods_popup}>\n    <div id="dialog<{$row.mid}>" title="<{$row.name}>" style=''display:none;''>\n        <table>\n            <tr>\n                <td class="width10 aligntop">\n                    <img src="<{$xoops_url}>/modules/<{$row.dirname}>/<{$row.image}>" alt="<{$row.name}>" title="<{$row.name}>"/>\n                </td>\n                <td>\n                    <ul class="xo-moduleinfos">\n                        <li><span class="bold"><{$smarty.const._VERSION}></span>&nbsp;:&nbsp;<{$row.version}> <{$row.module_status}></li>\n                        <li><span class="bold"><{$smarty.const._AUTHOR}></span>&nbsp;:&nbsp;<{$row.author}></li>\n                        <li><span class="bold"><{$smarty.const._CREDITS}></span>&nbsp;:&nbsp;<{$row.credits}></li>\n                        <li><span class="bold"><{$smarty.const._LICENCE}></span>&nbsp;:&nbsp;<{$row.license}></li>\n                    </ul>\n                </td>\n            </tr>\n        </table>\n        <p><{$row.description}></p>\n    </div>\n<{/foreach}>\n<!--Pop-pup-->\n'),
(47, '<{includeq file="db:system_header.tpl"}>\n<{if $modifs_mods}>\n    <form action="admin.php" method="post">\n        <table class="outer" cellspacing="1">\n            <thead>\n            <tr class="txtcenter">\n                <th><{$smarty.const._AM_SYSTEM_MODULES_MODULE}></th>\n                <th><{$smarty.const._AM_SYSTEM_MODULES_ACTION}></th>\n                <th><{$smarty.const._AM_SYSTEM_MODULES_ORDER}></th>\n            </tr>\n            </thead>\n            <tbody>\n            <{foreach item=row from=$modifs_mods}>\n                <tr class="txtcenter <{cycle values=''odd, even''}>">\n                    <td>\n                        <{$row.oldname}>\n                        <{if $row.oldname != $row.newname}>\n                            <span class="bold red">&nbsp;&raquo;&nbsp;<{$row.newname}></span>\n                        <{/if}>\n                    </td>\n                    <td>\n                        <{if $row.oldstatus != $row.newstatus}>\n                            <{if $row.newstatus == 1}>\n                                <div class="bold red"><{$smarty.const._AM_SYSTEM_MODULES_ACTIVATE}></div>\n                            <{else}>\n                                <div class="bold red"><{$smarty.const._AM_SYSTEM_MODULES_DEACTIVATE}></div>\n                            <{/if}>\n                        <{else}>\n                            <{$smarty.const._AM_SYSTEM_MODULES_NOCHANGE}>\n                        <{/if}>\n                    </td>\n                    <td>\n                        <{if $row.oldweight != $row.weight}>\n                            <div class="bold red"><{$row.weight}></div>\n                        <{else}>\n                            <{$row.weight}>\n                        <{/if}>\n                        <input type="hidden" name="module[]" value="<{$row.mid}>"/>\n                        <input type="hidden" name="oldname[<{$row.mid}>]" value="<{$row.oldname}>"/>\n                        <input type="hidden" name="newname[<{$row.mid}>]" value="<{$row.newname}>"/>\n                        <input type="hidden" name="oldstatus[<{$row.mid}>]" value="<{$row.oldstatus}>"/>\n                        <input type="hidden" name="newstatus[<{$row.mid}>]" value="<{$row.newstatus}>"/>\n                        <input type="hidden" name="oldweight[<{$row.mid}>]" value="<{$row.oldweight}>"/>\n                        <input type="hidden" name="weight[<{$row.mid}>]" value="<{$row.weight}>"/>\n                    </td>\n                </tr>\n            <{/foreach}>\n            </tbody>\n            <tfoot>\n            <tr class="txtcenter foot">\n                <td colspan="3">\n                    <input class="formButton" type="submit" value="<{$smarty.const._AM_SYSTEM_MODULES_SUBMIT}>"/>&nbsp;\n                    <input class="formButton" type="button" value="<{$smarty.const._AM_SYSTEM_MODULES_CANCEL}>"\n                           onclick="location=''admin.php?fct=modulesadmin''"/>\n                    <input type="hidden" name="fct" value="modulesadmin"/>\n                    <input type="hidden" name="op" value="submit"/>\n                    <{$input_security}>\n                </td>\n            </tr>\n            </tfoot>\n        </table>\n    </form>\n<{else}>\n    <div id="xo-module-log">\n        <{if $result}>\n            <div class="logger">\n                <{foreach item=row from=$result}>\n                    <div class="spacer"><{$row}></div>\n                <{/foreach}>\n            </div>\n        <{/if}>\n        <a href="admin.php?fct=modulesadmin"><{$smarty.const._AM_SYSTEM_MODULES_BTOMADMIN}></a>\n    </div>\n<{/if}>\n'),
(48, '<!-- Header -->\n<{includeq file="db:system_header.tpl"}>\n<script type="text/javascript">\n    IMG_ON = ''<{xoAdminIcons success.png}>'';\n    IMG_OFF = ''<{xoAdminIcons cancel.png}>'';\n</script>\n<!-- Buttons -->\n<{if $type == ''s''}>\n    <div style="height: 30px;">\n        <div class="floatright">\n            <div class="xo-buttons" >\n                <button id="xo-addavatar-btn" class="ui-corner-all tooltip" onclick=''location="admin.php?fct=avatars&amp;op=multiupload"''\n                        title="<{$smarty.const._AM_SYSTEM_AVATAR_MULTIUPLOAD}>">\n                    <img src="<{xoAdminIcons add.png}>" alt="<{$smarty.const._AM_SYSTEM_AVATAR_MULTIUPLOAD}>"/>\n                    <{$smarty.const._AM_SYSTEM_AVATAR_MULTIUPLOAD}>\n                </button>\n            </div>\n        </div>\n    </div>\n<{/if}>\n<{if $view_cat}>\n    <!-- Display Avatar header for switch between system & custom category -->\n    <table class="outer" cellspacing="1">\n        <thead>\n        <tr>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_AVATAR_SYSTEM}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_AVATAR_CUSTOM}></th>\n        </tr>\n        </thead>\n        <tbody>\n        <tr class="odd">\n            <td class="txtcenter">\n                <a class="tooltip" href="admin.php?fct=avatars&amp;op=listavt&amp;type=s" title="<{$smarty.const._AM_SYSTEM_AVATAR_SYSTEM}>">\n                    <img src="<{xoAdminIcons avatar_system.png}>" alt="<{$smarty.const._AM_SYSTEM_AVATAR_SYSTEM}>"/>\n                </a>\n\n                <div class="spacer"><{$smarty.const._AM_SYSTEM_AVATAR_SYSTEM}>&nbsp;:&nbsp;<strong><{$count_system}></strong></div>\n            </td>\n            <td class="txtcenter">\n                <a class="tooltip" href="admin.php?fct=avatars&amp;op=listavt&amp;type=c" title="<{$smarty.const._AM_SYSTEM_AVATAR_CUSTOM}>">\n                    <img src="<{xoAdminIcons avatar_custom.png}>" alt="<{$smarty.const._AM_SYSTEM_AVATAR_CUSTOM}>"/>\n                </a>\n\n                <div class="spacer"><{$smarty.const._AM_SYSTEM_AVATAR_CUSTOM}>&nbsp;:&nbsp;<strong><{$count_custom}></strong></div>\n            </td>\n        </tr>\n        </tbody>\n    </table>\n    <br>\n<{/if}>\n<!-- Display Avatar list for each category -->\n<{if $avatars_list}>\n    <{foreach item=avatar from=$avatars_list}>\n        <div class="floatleft">\n            <div class="ui-corner-all xo-thumb txtcenter">\n                <div class="xo-thumbimg">\n                    <img class="tooltip" src="<{$xoops_url}>/uploads/<{$avatar.avatar_file}>"\n                         alt="<{$avatar.avatar_name}>" title="<{$avatar.avatar_name}>"/>\n                </div>\n                <div class="xo-actions txtcenter">\n                    <div class="spacer bold"><{$avatar.avatar_name}></div>\n                    <img id="loading_avt<{$avatar.avatar_id}>" src="images/spinner.gif" style="display:none;" title="<{$smarty.const._AM_SYSTEM_LOADING}>"\n                         alt="<{$smarty.const._AM_SYSTEM_LOADING}>"/><img class="tooltip" id="avt<{$avatar.avatar_id}>"\n                                                                          onclick="system_setStatus( { fct: ''avatars'', op: ''display'', avatar_id: <{$avatar.avatar_id}> }, ''avt<{$avatar.avatar_id}>'', ''admin.php'' )"\n                                                                          src="<{if $avatar.avatar_display}><{xoAdminIcons success.png}><{else}><{xoAdminIcons cancel.png}><{/if}>"\n                                                                          alt="<{$smarty.const._IMGDISPLAY}>" title="<{$smarty.const._IMGDISPLAY}>"/>\n                    <{if $avatar.type == ''c''}>\n                        <a href="<{$xoops_url}>/modules/profile/userinfo.php?uid=<{$avatar.user}>" title="<{$smarty.const._AM_SYSTEM_AVATAR_USERS}>">\n                            <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._AM_SYSTEM_AVATAR_USERS}>"/>\n                        </a>\n                    <{else}>\n                        <img class="cursorhelp tooltip" src="<{xoAdminIcons forum.png}>" alt="<{$avatar.count}> <{$smarty.const._AM_SYSTEM_AVATAR_USERS}>"\n                             title="<{$avatar.count}> <{$smarty.const._AM_SYSTEM_AVATAR_USERS}>"/>\n                    <{/if}>\n                    <a class="tooltip" href="admin.php?fct=avatars&amp;op=edit&amp;avatar_id=<{$avatar.avatar_id}>" title="<{$smarty.const._EDIT}>">\n                        <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._EDIT}>"/>\n                    </a>\n                    <a class="tooltip" href="admin.php?fct=avatars&amp;op=delfile&amp;avatar_id=<{$avatar.avatar_id}>" title="<{$smarty.const._DELETE}>">\n                        <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._DELETE}>"/>\n                    </a>\n                </div>\n            </div>\n        </div>\n    <{/foreach}>\n    <!-- Display Avatars navigation -->\n    <div class="clear">&nbsp;</div>\n    <{if $nav_menu}>\n        <div class="xo-pagenav floatright"><{$nav_menu}></div>\n        <div class="clear spacer"></div>\n    <{/if}>\n<{/if}>\n\n<{if $multiupload}>\n    <div class="floatright">\n        <div class="xo-buttons">\n            <button id="xo-addavatar-btn" class="ui-corner-all tooltip" onclick=''location="admin.php?fct=avatars&amp;op=listavt&amp;type=s"''\n                    title="<{$smarty.const._AM_SYSTEM_AVATAR_SYSTEM}>">\n                <img src="<{xoAdminIcons view.png}>" alt="<{$smarty.const._AM_SYSTEM_AVATAR_SYSTEM}>"/>\n                <{$smarty.const._AM_SYSTEM_AVATAR_SYSTEM}>\n            </button>\n        </div>\n    </div>\n    <div class="clear">&nbsp;</div>\n    <{includeq file="db:system_trigger_uploads.tpl"}>\n    <h2><{$smarty.const._AM_SYSTEM_AVATAR_SYSTEM}></h2>\n    <div id="fine-uploader-manual-trigger"></div>\n    <div><{$smarty.const._IMGMAXSIZE}> <{$imgcat_maxsize}></div>\n    <div><{$smarty.const._IMGMAXWIDTH}> <{$imgcat_maxwidth}></div>\n    <div><{$smarty.const._IMGMAXHEIGHT}> <{$imgcat_maxheight}></div>\n    <!-- Your code to create an instance of Fine Uploader and bind to the DOM/template\n    ====================================================================== -->\n    <script>\n        var manualUploader = new qq.FineUploader({\n            element: document.getElementById(''fine-uploader-manual-trigger''),\n            template: ''qq-template-manual-trigger'',\n            request: {\n                endpoint: ''<{$xoops_url}>/ajaxfineupload.php'',\n                params: {\n                    "Authorization": "<{$jwt}>"\n                }\n            },\n            text: {\n                formatProgress: "<{$smarty.const._FORMATPROGRESS}>",\n                failUpload: "<{$smarty.const._FAILUPLOAD}>",\n                waitingForResponse: "<{$smarty.const._WAITINGFORRESPONSE}>",\n                paused: "<{$smarty.const._PAUSED}>"\n            },\n            messages: {\n                typeError: "<{$smarty.const._TYPEERROR}>",\n                sizeError: "<{$smarty.const._SIZEERROR}>",\n                minSizeError: "<{$smarty.const._MINSIZEERROR}>",\n                emptyError: "<{$smarty.const._EMPTYERROR}>",\n                noFilesError: "<{$smarty.const._NOFILESERROR}>",\n                tooManyItemsError: "<{$smarty.const._TOOMANYITEMSERROR}>",\n                maxHeightImageError: "<{$smarty.const._MAXHEIGHTIMAGEERROR}>",\n                maxWidthImageError: "<{$smarty.const._MAXWIDTHIMAGEERROR}>",\n                minHeightImageError: "<{$smarty.const._MINHEIGHTIMAGEERROR}>",\n                minWidthImageError: "<{$smarty.const.__MINWIDTHIMAGEERROR}>",\n                retryFailTooManyItems: "<{$smarty.const._RETRYFAILTOOMANYITEMS}>",\n                onLeave: "<{$smarty.const._ONLEAVE}>",\n                unsupportedBrowserIos8Safari: "<{$smarty.const._UNSUPPORTEDBROWSERIOS8SAFARI}>"\n            },\n            thumbnails: {\n                placeholders: {\n                    waitingPath: ''<{$xoops_url}>/media/fine-uploader/placeholders/waiting-generic.png'',\n                    notAvailablePath: ''<{$xoops_url}>/media/fine-uploader/placeholders/not_available-generic.png''\n                }\n            },\n            validation: {\n                acceptFiles: [''image/jpeg'', ''image/gif'', ''image/png''],\n                allowedExtensions: [''jpeg'', ''jpg'', ''png'', ''gif''],\n                image: {\n                    maxHeight: <{$imgcat_maxheight}>,\n                    maxWidth: <{$imgcat_maxwidth}>\n                },\n                sizeLimit: <{$imgcat_maxsize}>\n            },\n            autoUpload: false,\n            callbacks: {\n            onError: function(id, name, errorReason, xhrOrXdr) {\n                 console.log(qq.format("Error uploading {}.  Reason: {}", name, errorReason));\n             }\n         },\n        debug: <{$fineup_debug}>\n        });\n\n        qq(document.getElementById("trigger-upload")).attach("click", function() {\n            manualUploader.uploadStoredFiles();\n        });\n    </script>\n<{/if}>\n\n<!-- Display Avatar form (add,edit) -->\n<{if $form}>\n    <div class="spacer"><{$form}></div>\n<{/if}>\n<!-- Display Avatar images on edit page -->\n'),
(49, '<!--smilies-->\n<{includeq file="db:system_header.tpl"}>\n<script type="text/javascript">\n    IMG_ON = ''<{xoAdminIcons success.png}>'';\n    IMG_OFF = ''<{xoAdminIcons cancel.png}>'';\n</script>\n<{if $smilies_count == true}>\n    <div class="floatright">\n        <div class="xo-buttons">\n            <a class="ui-corner-all tooltip" href="admin.php?fct=smilies&amp;op=new_smilie" title="<{$smarty.const._AM_SYSTEM_SMILIES_ADD}>">\n                <img src="<{xoAdminIcons add.png}>" alt="<{$smarty.const._AM_SYSTEM_SMILIES_ADD}>"/>\n                <{$smarty.const._AM_SYSTEM_SMILIES_ADD}>\n            </a>\n        </div>\n    </div>\n    <table id="xo-smilies-sorter" cellspacing="1" class="outer tablesorter">\n        <thead>\n        <tr>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_SMILIES_CODE}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_SMILIES_SMILIE}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_SMILIES_DESCRIPTION}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_SMILIES_DISPLAY}></th>\n            <th class="txtcenter width10"><{$smarty.const._AM_SYSTEM_SMILIES_ACTION}></th>\n        </tr>\n        </thead>\n        <tbody>\n        <{foreach item=smilies from=$smilies}>\n            <tr class="<{cycle values=''even,odd''}> alignmiddle">\n                <td class="txtcenter width5"><{$smilies.code}></td>\n                <td class="txtcenter width5"><{$smilies.image}></td>\n                <td class="txtcenter width50"><{$smilies.emotion}></td>\n                <td class="xo-actions txtcenter width10">\n                    <img id="loading_sml<{$smilies.smilies_id}>" src="images/spinner.gif" style="display:none;" title="<{$smarty.const._AM_SYSTEM_LOADING}>"\n                         alt="<{$smarty.const._AM_SYSTEM_LOADING}>"/><img class="cursorpointer tooltip" id="sml<{$smilies.smilies_id}>"\n                                                                          onclick="system_setStatus( { fct: ''smilies'', op: ''smilies_update_display'', smilies_id: <{$smilies.smilies_id}> }, ''sml<{$smilies.smilies_id}>'', ''admin.php'' )"\n                                                                          src="<{if $smilies.display}><{xoAdminIcons success.png}><{else}><{xoAdminIcons cancel.png}><{/if}>"\n                                                                          alt="<{if $smilies.display}><{$smarty.const._AM_SYSTEM_SMILIES_OFF}><{else}><{$smarty.const._AM_SYSTEM_SMILIES_ON}><{/if}>"\n                                                                          title="<{if $smilies.display}><{$smarty.const._AM_SYSTEM_SMILIES_OFF}><{else}><{$smarty.const._AM_SYSTEM_SMILIES_ON}><{/if}>"/>\n                </td>\n                <td class="xo-actions txtcenter width10">\n                    <a class="tooltip" href="admin.php?fct=smilies&amp;op=edit_smilie&amp;smilies_id=<{$smilies.smilies_id}>"\n                       title="<{$smarty.const._AM_SYSTEM_SMILIES_EDIT}>">\n                        <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._AM_SYSTEM_SMILIES_EDIT}>"/>\n                    </a>\n                    <a class="tooltip" href="admin.php?fct=smilies&amp;op=smilies_delete&amp;smilies_id=<{$smilies.smilies_id}>"\n                       title="<{$smarty.const._AM_SYSTEM_SMILIES_DELETE}>">\n                        <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._AM_SYSTEM_SMILIES_DELETE}>"/>\n                    </a>\n                </td>\n            </tr>\n        <{/foreach}>\n        </tbody>\n    </table>\n    <!-- Display smilies navigation -->\n    <div class="clear spacer"></div>\n    <{if $nav_menu}>\n        <div class="xo-avatar-pagenav floatright"><{$nav_menu}></div>\n        <div class="clear spacer"></div>\n    <{/if}>\n<{/if}>\n<!-- Display smilies form (add,edit) -->\n<{if $form}>\n    <div class="spacer"><{$form}></div>\n<{/if}>\n');
INSERT INTO `[[dbprefix]]_tplsource` VALUES
(50, '<!-- Breadcrumb Header -->\n<{includeq file="db:system_header.tpl"}>\n<script type="text/javascript">\n    IMG_ON = ''<{xoAdminIcons success.png}>'';\n    IMG_OFF = ''<{xoAdminIcons cancel.png}>'';\n</script>\n<{if $filterform}>\n    <div class="floatright">\n        <div class="xo-buttons">\n            <button id="xo-add-btn" class="ui-corner-all" onclick="self.location.href=''admin.php?fct=blocksadmin&amp;op=add'';">\n                <img src="<{xoAdminIcons add.png}>" alt="<{$smarty.const._AM_SYSTEM_BLOCKS_ADD}>"/>\n                <{$smarty.const._AM_SYSTEM_BLOCKS_ADD}>\n            </button>\n        </div>\n    </div>\n    <div class="clear"></div>\n    <div id="xo-block-dragndrop">\n        <table class="outer">\n            <tr>\n                <th>\n                    <form name="<{$filterform.name}>" id="<{$filterform.name}>" action="<{$filterform.action}>" method="<{$filterform.method}>"\n                            <{$filterform.extra}> >\n                        <div class="xo-blocksfilter">\n                            <{foreach item=element from=$filterform.elements}>\n                                <{if $element.hidden != true}>\n                                    <div class="xo-caption"><{$element.caption}></div>\n                                    <div class="xo-element"><{$element.body}></div>\n                                <{else}>\n                                    <{$element.body}>\n                                <{/if}>\n                            <{/foreach}>\n                        </div>\n                    </form>\n                </th>\n            </tr>\n            <tr>\n                <td>\n                    <table id="xo-block-managment">\n                        <tr>\n                            <td side="0" class="xo-blocksection" rowspan="3" id="xo-leftcolumn">\n                                <div class="xo-title"><{$smarty.const._AM_SYSTEM_BLOCKS_SIDELEFT}></div>\n                                <{includeq file="db:system_blocks_item.tpl" blocks=$blocks side=0}>\n                            </td>\n                            <td side="3" class="xo-blocksection">\n                                <div class="xo-title"><{$smarty.const._AM_SYSTEM_BLOCKS_SIDETOPLEFT}></div>\n                                <{includeq file="db:system_blocks_item.tpl" blocks=$blocks side=3}>\n                            </td>\n                            <td side="5" class="xo-blocksection">\n                                <div class="xo-title"><{$smarty.const._AM_SYSTEM_BLOCKS_SIDETOPCENTER}></div>\n                                <{includeq file="db:system_blocks_item.tpl" blocks=$blocks side=5}>\n                            </td>\n                            <td side="4" class="xo-blocksection">\n                                <div class="xo-title"><{$smarty.const._AM_SYSTEM_BLOCKS_SIDETOPRIGHT}></div>\n                                <{includeq file="db:system_blocks_item.tpl" blocks=$blocks side=4}>\n                            </td>\n                            <td side="1" class="xo-blocksection" rowspan="3" id="xo-rightcolumn">\n                                <div class="xo-title"><{$smarty.const._AM_SYSTEM_BLOCKS_SIDERIGHT}></div>\n                                <{includeq file="db:system_blocks_item.tpl" blocks=$blocks side=1}>\n                            </td>\n                        </tr>\n                        <tr style="height:30px;">\n                            <td colspan="3" class="xo-blockContent width5">&nbsp;</td>\n                        </tr>\n                        <tr>\n                            <td side="7" class="xo-blocksection">\n                                <div class="xo-title"><{$smarty.const._AM_SYSTEM_BLOCKS_SIDEBOTTOMLEFT}></div>\n                                <{includeq file="db:system_blocks_item.tpl" blocks=$blocks side=7}>\n                            </td>\n                            <td side="9" class="xo-blocksection">\n                                <div class="xo-title"><{$smarty.const._AM_SYSTEM_BLOCKS_SIDEBOTTOMCENTER}></div>\n                                <{includeq file="db:system_blocks_item.tpl" blocks=$blocks side=9}>\n                            </td>\n                            <td side="8" class="xo-blocksection">\n                                <div class="xo-title"><{$smarty.const._AM_SYSTEM_BLOCKS_SIDEBOTTOMRIGHT}></div>\n                                <{includeq file="db:system_blocks_item.tpl" blocks=$blocks side=8}>\n                            </td>\n                        </tr>\n                        <tr>\n                            <!-- Start Footer Blocks (By Timgno) -->\n                            <table id="xo-block-footer">\n                                <tr>\n                                    <td side="10" class="xo-blocksection">\n                                        <div class="xo-title"><{$smarty.const._AM_SYSTEM_BLOCKS_SIDEFOOTERLEFT}></div>\n                                        <{includeq file="db:system_blocks_item.tpl" blocks=$blocks side=10}>\n                                    </td>\n                                    <td side="12" class="xo-blocksection">\n                                        <div class="xo-title"><{$smarty.const._AM_SYSTEM_BLOCKS_SIDEFOOTERCENTER}></div>\n                                        <{includeq file="db:system_blocks_item.tpl" blocks=$blocks side=12}>\n                                    </td>\n                                    <td side="11" class="xo-blocksection">\n                                        <div class="xo-title"><{$smarty.const._AM_SYSTEM_BLOCKS_SIDEFOOTERRIGHT}></div>\n                                        <{includeq file="db:system_blocks_item.tpl" blocks=$blocks side=11}>\n                                    </td>\n                                </tr>\n                            </table>\n                            <!-- End Footer Blocks (By Timgno) -->\n                        </tr>\n                    </table>\n                </td>\n            </tr>\n        </table>\n    </div>\n<{/if}>\n<div id="xo-block-add" <{if $filterform}>class="hide"<{/if}>>\n    <{if !$filterform}><br><{/if}>\n    <{$blockform}>\n</div>\n<!-- Preview block -->\n<div id="xo-preview-block" class="hide"></div>\n'),
(51, '<{foreach item=item from=$blocks}>\n    <{if $item.side == $side}>\n        <div id="blk_<{$item.bid}>" bid="<{$item.bid}>" side="<{$item.side}>" order="<{$item.weight}>"\n             class="xo-block ui-widget ui-widget-content ui-corner-all">\n            <div class="xo-blocktitle ui-corner-all">\n        <span class="spacer">\n            <img class="xo-imgmini" src="<{xoAdminIcons block.png}>" alt="<{$smarty.const._AM_SYSTEM_BLOCKS_DRAG}>"\n                 title="<{$smarty.const._AM_SYSTEM_BLOCKS_DRAG}>"/>\n        </span>\n<{$item.title}><{if $item.block_type == ''D''}> (<{$item.bid}>)<{/if}>\n            </div>\n            <div class="xo-blockaction xo-actions"><img id="loading_img<{$item.bid}>" src="./images/mimetypes/spinner.gif" style="display:none;"\n                                                        title="<{$smarty.const._AM_SYSTEM_LOADING}>" alt="<{$smarty.const._AM_SYSTEM_LOADING}>"/><img\n                        class="tooltip" id="img<{$item.bid}>"\n                        onclick="system_setStatus( { fct: ''blocksadmin'', op: ''display'', bid: <{$item.bid}>, visible: <{if $item.visible}>0<{else}>1<{/if}> }, ''img<{$item.bid}>'', ''admin.php'' )"\n                        src="<{if $item.visible}><{xoAdminIcons success.png}><{else}><{xoAdminIcons cancel.png}><{/if}>"\n                        alt="<{if $item.visible}><{$smarty.const._AM_SYSTEM_BLOCKS_HIDE}><{else}><{$smarty.const._AM_SYSTEM_BLOCKS_DISPLAY}><{/if}><{$item.name}>"\n                        title="<{if $item.visible}><{$smarty.const._AM_SYSTEM_BLOCKS_HIDE}><{else}><{$smarty.const._AM_SYSTEM_BLOCKS_DISPLAY}><{/if}><{$item.name}>"/>\n                <a class="tooltip" href="admin.php?fct=blocksadmin&amp;op=edit&amp;bid=<{$item.bid}>" title="<{$smarty.const._EDIT}>">\n                    <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._EDIT}>"/></a>\n                <{if $item.block_type != ''S''}>\n                    <a class="tooltip" href="admin.php?fct=blocksadmin&amp;op=delete&amp;bid=<{$item.bid}>" title="<{$smarty.const._DELETE}>">\n                        <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._DELETE}>"/></a>\n                <{/if}>\n                <a class="tooltip" href="admin.php?fct=blocksadmin&amp;op=clone&amp;bid=<{$item.bid}>" title="<{$smarty.const._AM_SYSTEM_BLOCKS_CLONE}>">\n                    <img src="<{xoAdminIcons clone.png}>" alt="<{$smarty.const._AM_SYSTEM_BLOCKS_CLONE}>"/></a>\n            </div>\n        </div>\n    <{/if}>\n<{/foreach}>\n'),
(52, '<{includeq file="db:system_header.tpl"}>\n<!--Comments-->\n<{if $form}>\n    <div class="spacer"><{$form}></div>\n<{else}>\n    <div class="floatleft"><{$form_sort}></div>\n    <div class="floatright">\n        <div class="xo-buttons">\n            <button class="ui-corner-all" onclick="self.location.href=''admin.php?fct=comments&op=comments_form_purge''">\n                <img src="<{xoAdminIcons clear.png}>" alt="<{$smarty.const._AM_SYSTEM_COMMENTS_FORM_PURGE}>"/>\n                <{$smarty.const._AM_SYSTEM_COMMENTS_FORM_PURGE}>\n            </button>\n        </div>\n    </div>\n    <div class="clear"></div>\n    <table id="xo-comment-sorter" cellspacing="1" class="outer tablesorter">\n        <thead>\n        <tr>\n            <th class="txtcenter width5"><input name=''allbox'' id=''allbox'' onclick=''xoopsCheckAll("commentslist", "allbox");'' type=''checkbox''\n                                                value=''Check All''/></th>\n            <th class="txtcenter width5"></th>\n            <th class="txtleft"><{$smarty.const._AM_SYSTEM_COMMENTS_TITLE}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_COMMENTS_POSTED}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_COMMENTS_IP}></th>\n            <th class="txtcenter"><{$smarty.const._DATE}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_COMMENTS_MODULE}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_COMMENTS_STATUS}></th>\n            <th class="txtcenter width10"><{$smarty.const._AM_SYSTEM_COMMENTS_ACTION}></th>\n        </tr>\n        </thead>\n        <form name=''commentslist'' id=''commentslist'' action=''<{$php_selft}>'' method="post">\n            <tbody>\n            <{foreach item=comments from=$comments}>\n                <tr class="<{cycle values=''even,odd''}> alignmiddle">\n                    <td class="txtcenter"><input type=''checkbox'' name=''commentslist_id[]'' id=''commentslist_id[]'' value=''<{$comments.comments_id}>''/></td>\n                    <td class="txtcenter"><{$comments.comments_icon}></td>\n                    <td>\n                        <a href="admin.php?fct=comments&amp;op=comments_jump&amp;com_id=<{$comments.comments_id}>" title="<{$comments.comments_title}>">\n                            <{$comments.comments_title}>\n                        </a>\n                    </td>\n                    <td class="txtcenter"><{$comments.comments_poster}></td>\n                    <td class="txtcenter"><{$comments.comments_ip}></td>\n                    <td class="txtcenter"><{$comments.comments_date}></td>\n                    <td class="txtcenter"><{$comments.comments_modid}></td>\n                    <td class="txtcenter"><{$comments.comments_status}></td>\n                    <td class="xo-actions txtcenter">\n                        <img class="cursorpointer" onclick="display_dialog(''<{$comments.comments_id}>'', true, true, ''slide'', ''slide'', 300, 500);"\n                             src="<{xoAdminIcons display.png}>" alt="<{$smarty.const._AM_SYSTEM_COMMENTS_VIEW}>"\n                             title="<{$smarty.const._AM_SYSTEM_COMMENTS_VIEW}>"/>\n                        <a href="admin/comments/comment_edit.php?com_id=<{$comments.comments_id}>" title="<{$smarty.const._EDIT}>">\n                            <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._EDIT}>">\n                        </a>\n                        <a href="admin/comments/comment_delete.php?com_id=<{$comments.comments_id}>" title="<{$smarty.const._DELETE}>">\n                            <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._DELETE}>">\n                        </a>\n                    </td>\n                </tr>\n            <{/foreach}>\n            </tbody>\n            <tr>\n                <td><input type=''submit'' name=''<{$smarty.const._DELETE}>'' value=''<{$smarty.const._DELETE}>''/></td>\n                <td colspan="7">&nbsp;</td>\n            </tr>\n        </form>\n    </table>\n    <{foreach item=comments from=$comments_popup}>\n        <!--Pop-pup-->\n        <div id=''dialog<{$comments.comments_id}>'' title=''<{$comments.comments_title}>'' style=''display:none;''>\n            <img src="<{xoAdminIcons comment.png}>" alt="comments" title="comments" class="xo-commentsimg"/>\n\n            <p><{$comments.comments_text}></p>\n        </div>\n    <{/foreach}>\n    <!--Pop-pup-->\n    <div class="txtright"><{$nav}></div>\n<{/if}>\n'),
(53, '<{includeq file="db:system_header.tpl"}>\n<script type="text/javascript">\n    IMG_ON = ''<{xoAdminIcons success.png}>'';\n    IMG_OFF = ''<{xoAdminIcons cancel.png}>'';\n</script>\n<!--User rank-->\n<{if $userrank_count == true}>\n    <div class="floatright">\n        <div class="xo-buttons">\n            <a class="ui-corner-all tooltip" href="admin.php?fct=userrank&amp;op=userrank_new" title="<{$smarty.const._AM_SYSTEM_USERRANK_ADD}>">\n                <img src="<{xoAdminIcons add.png}>" alt="<{$smarty.const._AM_SYSTEM_USERRANK_ADD}>"/>\n                <{$smarty.const._AM_SYSTEM_USERRANK_ADD}>\n            </a>\n        </div>\n    </div>\n    <table id="xo-rank-sorter" cellspacing="1" class="outer tablesorter">\n        <thead>\n        <tr>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_USERRANK_IMAGE}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_USERRANK_TITLE}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_USERRANK_MINPOST}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_USERRANK_MAXPOST}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_USERRANK_SPECIAL}></th>\n            <th class="txtcenter width10"><{$smarty.const._AM_SYSTEM_USERRANK_ACTION}></th>\n        </tr>\n        </thead>\n        <tbody>\n        <{foreach item=userrank from=$userrank}>\n            <tr class="<{cycle values=''even,odd''}> alignmiddle">\n                <td class="txtcenter"><{$userrank.rank_image}></td>\n                <td class="txtcenter"><{$userrank.rank_title}></td>\n                <td class="txtcenter"><{$userrank.rank_min}></td>\n                <td class="txtcenter"><{$userrank.rank_max}></td>\n                <td class="xo-actions txtcenter"><img id="loading_sml<{$userrank.rank_id}>" src="images/spinner.gif" style="display:none;"\n                                                      alt="<{$smarty.const._AM_SYSTEM_LOADING}>"/><img class="cursorpointer tooltip"\n                                                                                                       id="sml<{$userrank.rank_id}>"\n                                                                                                       onclick="system_setStatus( { fct: ''userrank'', op: ''userrank_update_special'', rank_id: <{$userrank.rank_id}> }, ''sml<{$userrank.rank_id}>'', ''admin.php'' )"\n                                                                                                       src="<{if $userrank.rank_special}><{xoAdminIcons success.png}><{else}><{xoAdminIcons cancel.png}><{/if}>"\n                                                                                                       alt="<{if $userrank.rank_special}><{$smarty.const._AM_SYSTEM_USERRANK_OFF}><{else}><{$smarty.const._AM_SYSTEM_USERRANK_ON}><{/if}>"\n                                                                                                       title="<{if $userrank.rank_special}><{$smarty.const._AM_SYSTEM_USERRANK_OFF}><{else}><{$smarty.const._AM_SYSTEM_USERRANK_ON}><{/if}>"/>\n                </td>\n                <td class="xo-actions txtcenter">\n                    <a class="tooltip" href="admin.php?fct=userrank&amp;op=userrank_edit&amp;rank_id=<{$userrank.rank_id}>"\n                       title="<{$smarty.const._AM_SYSTEM_USERRANK_EDIT}>">\n                        <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._AM_SYSTEM_USERRANK_EDIT}>"/>\n                    </a>\n                    <a class="tooltip" href="admin.php?fct=userrank&amp;op=userrank_delete&amp;rank_id=<{$userrank.rank_id}>"\n                       title="<{$smarty.const._AM_SYSTEM_USERRANK_DELETE}>">\n                        <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._AM_SYSTEM_USERRANK_DELETE}>"/>\n                    </a>\n                </td>\n            </tr>\n        <{/foreach}>\n        </tbody>\n    </table>\n    <!-- Display rank navigation -->\n    <div class="clear spacer"></div>\n    <{if $nav_menu}>\n        <div class="xo-avatar-pagenav floatright"><{$nav_menu}></div>\n        <div class="clear spacer"></div>\n    <{/if}>\n<{/if}>\n<!--Display rank form (add,edit)-->\n<{if $form}>\n    <div class="spacer"><{$form}></div>\n<{/if}>\n\n'),
(54, '<{includeq file="db:system_header.tpl"}>\n\n<{if $users_display == true}>\n    <!--Display form sort-->\n    <div class="xo-headercontent">\n        <div class="floatleft"><{$form_sort}></div>\n        <div class="floatright">\n            <div class="xo-buttons">\n                <a class="ui-corner-all tooltip" href="admin.php?fct=users&amp;op=users_synchronize&amp;status=2"\n                   title="<{$smarty.const._AM_SYSTEM_USERS_SYNCHRONIZE}>">\n                    <img src="<{xoAdminIcons reload.png}>" alt="<{$smarty.const._AM_SYSTEM_USERS_SYNCHRONIZE}>"/>\n                    <{$smarty.const._AM_SYSTEM_USERS_SYNCHRONIZE}>\n                </a>\n                <a class="ui-corner-all tooltip" href="admin.php?fct=users&amp;op=users_add" title="<{$smarty.const._AM_SYSTEM_USERS_ADDUSER}>">\n                    <img src="<{xoAdminIcons user_add.png}>" alt="<{$smarty.const._AM_SYSTEM_USERS_ADDUSER}>"/>\n                    <{$smarty.const._AM_SYSTEM_USERS_ADDUSER}>\n                </a>\n            </div>\n        </div>\n    </div>\n    <div class="clear">&nbsp;</div>\n    <table id="xo-users-sorter" cellspacing="1" class="outer tablesorter">\n        <thead>\n        <tr>\n            <th class="txtcenter width3"><input name=''allbox'' id=''allbox'' onclick=''xoopsCheckAll("memberslist", "allbox");'' type=''checkbox''\n                                                value=''Check All''/></th>\n            <th class="txtcenter width5"><{$smarty.const._AM_SYSTEM_USERS_STATUS}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_USERS_UNAME}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_USERS_EMAIL}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_USERS_REG_DATE}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_USERS_LAST_LOGIN}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_USERS_POSTS}></th>\n            <th class="txtcenter" width=''11%''><{$smarty.const._AM_SYSTEM_USERS_ACTION}></th>\n        </tr>\n        </thead>\n        <!--Display data-->\n        <{if $users_count == true}>\n            <form name=''memberslist'' id=''memberslist'' action=''<{xoAppUrl modules/system/admin.php?fct=users}>'' method=''POST''>\n                <tbody>\n                <{foreach item=users from=$users}>\n                    <tr class="<{cycle values=''even,odd''}> alignmiddle">\n                        <td class="txtcenter"><{if $users.checkbox_user}><input type=''checkbox'' name=''memberslist_id[]'' id=''memberslist_id[]''\n                                                                                value=''<{$users.uid}>''/><{/if}>\n                        </td>\n                        <td class="txtcenter"><img class="xo-imgmini" src="<{$users.group}>" alt=""/></td>\n                        <td class="txtcenter"><a title="<{$users.uname}>" href="<{$xoops_url}>/userinfo.php?uid=<{$users.uid}>"><{$users.uname}></a></td>\n                        <td class="txtcenter"><{$users.email}></td>\n                        <td class="txtcenter"><{$users.reg_date}></td>\n                        <td class="txtcenter"><{$users.last_login}></td>\n                        <td class="txtcenter">\n                            <div id="display_post_<{$users.uid}>"><{$users.posts}></div>\n                            <div id=''loading_<{$users.uid}>'' class="txtcenter" style="display:none;"><img src="./images/mimetypes/spinner.gif" title="Loading"\n                                                                                                          alt="Loading" width="12px"/></div>\n                        </td>\n                        <td class="xo-actions txtcenter">\n                            <{if $users.user_level > 0}>\n                                <img class="tooltip" onclick="display_post(''<{$users.uid}>'');" src="<{xoAdminIcons reload.png}>"\n                                     alt="<{$smarty.const._AM_SYSTEM_USERS_SYNCHRONIZE}>" title="<{$smarty.const._AM_SYSTEM_USERS_SYNCHRONIZE}>"/>\n                                <img class="tooltip" onclick="display_dialog(''<{$users.uid}>'', true, true, ''slide'', ''slide'', 300, 400);"\n                                     src="<{xoAdminIcons display.png}>" alt="<{$smarty.const._AM_SYSTEM_USERS_VIEW}>"\n                                     title="<{$smarty.const._AM_SYSTEM_USERS_VIEW}>"/>\n                                <a class="tooltip" href="admin.php?fct=users&amp;op=users_edit&amp;uid=<{$users.uid}>"\n                                   title="<{$smarty.const._AM_SYSTEM_USERS_EDIT}>">\n                                    <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._AM_SYSTEM_USERS_EDIT}>"/>\n                                </a>\n                                <a class="tooltip" href="admin.php?fct=users&amp;op=users_delete&amp;uid=<{$users.uid}>"\n                                   title="<{$smarty.const._AM_SYSTEM_USERS_DEL}>">\n                                    <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._AM_SYSTEM_USERS_DEL}>"/>\n                                </a>\n                            <{else}>\n                                <a class="tooltip" href="admin.php?fct=users&amp;op=users_active&amp;uid=<{$users.uid}>"\n                                   title="<{$smarty.const._AM_SYSTEM_USERS_ACTIVE}>">\n                                    <img src="<{xoAdminIcons xoops/active_user.png}>" alt="<{$smarty.const._AM_SYSTEM_USERS_ACTIVE}>"/>\n                                </a>\n                                <img class="tooltip" onclick="display_dialog(''<{$users.uid}>'', true, true, ''slide'', ''slide'', 300, 400);"\n                                     src="<{xoAdminIcons display.png}>" alt="<{$smarty.const._AM_SYSTEM_USERS_VIEW}>"\n                                     title="<{$smarty.const._AM_SYSTEM_USERS_VIEW}>"/>\n                                <a class="tooltip" href="admin.php?fct=users&amp;op=users_edit&amp;uid=<{$users.uid}>"\n                                   title="<{$smarty.const._AM_SYSTEM_USERS_EDIT}>">\n                                    <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._AM_SYSTEM_USERS_EDIT}>"/>\n                                </a>\n                                <a class="tooltip" href="admin.php?fct=users&amp;op=users_delete&amp;uid=<{$users.uid}>"\n                                   title="<{$smarty.const._AM_SYSTEM_USERS_DEL}>">\n                                    <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._AM_SYSTEM_USERS_DEL}>"/>\n                                </a>\n                            <{/if}>\n                        </td>\n                    </tr>\n                <{/foreach}>\n                </tbody>\n                <tr>\n                    <td class=''txtleft'' colspan=''6''>\n                        <select name=''fct'' onChange=''changeDisplay (this.value, "groups", "edit_group")''>\n                            <option value=''''>---------</option>\n                            <option value=''mailusers''><{$smarty.const._AM_SYSTEM_USERS_SENDMAIL}></option>\n                            <option value=''groups''><{$smarty.const._AM_SYSTEM_USERS_EDIT_GROUPS}></option>\n                            <option value=''users''><{$smarty.const._AM_SYSTEM_USERS_DELETE}></option>\n                        </select>&nbsp;\n                        <select name=''edit_group'' id=''edit_group'' onChange=''changeDisplay (this.value, this.value, "selgroups")'' style="display:none;">\n                            <option value=''''>---------</option>\n                            <option value=''add_group''><{$smarty.const._AM_SYSTEM_USERS_ADD_GROUPS}></option>\n                            <option value=''delete_group''><{$smarty.const._AM_SYSTEM_USERS_DELETE_GROUPS}></option>\n                        </select>\n                        <{$form_select_groups}>\n                        <{$form_token}>\n                        <input type="hidden" name="op" value="action_group">\n                        <input type=''submit'' name=''Submit''/>\n                    </td>\n                </tr>\n            </form>\n        <{/if}>\n        <!--No found-->\n        <{if $users_no_found == true}>\n            <tr class="<{cycle values=''even,odd''}> alignmiddle">\n                <td colspan=''8'' class="txtcenter"><{$smarty.const._AM_SYSTEM_USERS_NO_FOUND}></td>\n            </tr>\n        <{/if}>\n    </table>\n    <!--Pop-pup-->\n    <{if $users_count == true}>\n        <{foreach item=users from=$users_popup}>\n            <div id="dialog<{$users.uid}>" title="<{$users.uname}>" style=''display:none;''>\n                <table>\n                    <tr>\n                        <td class="txtcenter">\n                            <img src="<{$users.user_avatar}>" alt="<{$users.uname}>" title="<{$users.uname}>"/>\n                        </td>\n                        <td class="txtcenter">\n                            <a href=''mailto:<{$users.email}>''><img src="<{xoAdminIcons mail_send.png}>" alt="" title=<{$smarty.const._AM_SYSTEM_USERS_EMAIL}>\n                                /></a>\n                            <a href=''javascript:openWithSelfMain("<{$xoops_url}>/pmlite.php?send2=1&amp;to_userid=<{$users.uid}>","pmlite",565,500);''><img\n                                        src="<{xoAdminIcons pm.png}>" alt="" title=<{$smarty.const._AM_SYSTEM_USERS_PM}>/></a>\n                            <a href=''<{$users.url}>'' rel=''external''><img src="<{xoAdminIcons url.png}>" alt="" title=<{$smarty.const._AM_SYSTEM_USERS_URL}>></a>\n                        </td>\n                    </tr>\n                    <tr>\n                        <td colspan="2">\n                            <ul style="border: 1px solid #666; padding: 8px;">\n                                <{if $users.user_name}>\n                                    <li><span class="bold"><{$smarty.const._AM_SYSTEM_USERS_NAME}></span>&nbsp;:&nbsp;<{$users.name}></li>\n                                <{/if}>\n                                <li><span class="bold"><{$smarty.const._AM_SYSTEM_USERS_UNAME}></span>&nbsp;:&nbsp;<{$users.uname}></li>\n                                <li><span class="bold"><{$smarty.const._AM_SYSTEM_USERS_EMAIL}></span>&nbsp;:&nbsp;<{$users.email}></li>\n                                <{if $users.user_url}>\n                                    <li><span class="bold"><{$smarty.const._AM_SYSTEM_USERS_URL}></span>&nbsp;:&nbsp;<{$users.url}></li>\n                                <{/if}>\n                                <{if $users.user_icq}>\n                                    <li><span class="bold"><{$smarty.const._AM_SYSTEM_USERS_ICQ}></span>&nbsp;:&nbsp;<{$users.user_icq}></li>\n                                <{/if}>\n                                <{if $users.user_aim}>\n                                    <li><span class="bold"><{$smarty.const._AM_SYSTEM_USERS_AIM}></span>&nbsp;:&nbsp;<{$users.user_aim}></li>\n                                <{/if}>\n                                <{if $users.user_yim}>\n                                    <li><span class="bold"><{$smarty.const._AM_SYSTEM_USERS_YIM}></span>&nbsp;:&nbsp;<{$users.user_yim}></li>\n                                <{/if}>\n                                <{if $users.user_msnm}>\n                                    <li><span class="bold"><{$smarty.const._AM_SYSTEM_USERS_MSNM}></span>&nbsp;:&nbsp;<{$users.user_msnm}></li>\n                                <{/if}>\n                            </ul>\n                        </td>\n                    </tr>\n                </table>\n            </div>\n        <{/foreach}>\n    <{/if}>\n    <!--Pop-pup-->\n    <div class=''txtright''><{$nav}></div>\n<{/if}>\n<br>\n<!-- Display Avatar form (add,edit) -->\n<{if $form}>\n    <div class="spacer"><{$form}></div>\n<{/if}>\n'),
(55, '<{if $breadcrumb}>\n    <{includeq file="db:system_header.tpl"}>\n<{/if}>\n<!--Preferences-->\n<{if $menu}>\n    <div class="xo-catsetting">\n        <{foreach item=preferences from=$preferences}>\n            <a class="tooltip" href="admin.php?fct=preferences&amp;op=show&amp;confcat_id=<{$preferences.id}>" title="<{$preferences.name}>">\n                <img src="<{$preferences.image}>" alt="<{$preferences.name}>"/>\n                <span><{$preferences.name}></span>\n            </a>\n        <{/foreach}>\n        <a class="tooltip" href="admin.php?fct=preferences&amp;op=showmod&amp;mod=1" title="<{$smarty.const._AM_SYSTEM_PREFERENCES_SETTINGS}>">\n            <img src="<{xoAdminIcons xoops/system_mods.png}>" alt="<{$smarty.const._AM_SYSTEM_PREFERENCES_SETTINGS}>"/>\n            <span><{$smarty.const._AM_SYSTEM_PREFERENCES_SETTINGS}></span>\n        </a>\n    </div>\n<{/if}>\n<div class="clear">&nbsp;</div>\n<br>\n\n\n'),
(56, '<!--smilies-->\n<{includeq file="db:system_header.tpl"}>\n<!-- Display mailusers form  -->\n<br>\n<{if $form}>\n    <div class="spacer"><{$form}></div>\n<{/if}>\n<{$Sucess}>\n<{$Errors}>\n'),
(57, '<!--groups-->\n<{includeq file="db:system_header.tpl"}>\n<{if $groups_count == true}>\n    <div class="floatright">\n        <div class="xo-buttons">\n            <button class="ui-corner-all" onclick="self.location.href=''admin.php?fct=groups&amp;op=groups_add''">\n                <img src="<{xoAdminIcons add.png}>" alt="<{$smarty.const._AM_SYSTEM_GROUPS_ADD}>"/>\n                <{$smarty.const._AM_SYSTEM_GROUPS_ADD}>\n            </button>\n        </div>\n    </div>\n    <table id="xo-group-sorter" cellspacing="1" class="outer tablesorter">\n        <thead>\n        <tr>\n            <th class="txtcenter width5"><{$smarty.const._AM_SYSTEM_GROUPS_ID}></th>\n            <th class="txtcenter width20"><{$smarty.const._AM_SYSTEM_GROUPS_NAME}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_GROUPS_DESCRIPTION}></th>\n            <th class="txtcenter"><{$smarty.const._AM_SYSTEM_GROUPS_NB_USERS_BY_GROUPS}></th>\n            <th class="txtcenter width10"><{$smarty.const._AM_SYSTEM_GROUPS_ACTION}></th>\n        </tr>\n        </thead>\n        <tbody>\n        <{foreach item=groups from=$groups}>\n            <tr class="<{cycle values=''odd, even''}> alignmiddle">\n                <td class="txtcenter"><{$groups.groups_id}></td>\n                <td class="txtleft">\n                    <a class="tooltip" href="admin.php?fct=groups&amp;op=groups_edit&amp;groups_id=<{$groups.groups_id}>"\n                       title="<{$smarty.const._AM_SYSTEM_GROUPS_EDIT}>">\n                        <{$groups.name}>\n                    </a>\n                </td>\n                <td class="txtleft"><{$groups.description}></td>\n                <td class="txtcenter width25">\n                    <a href="./admin.php?fct=users&amp;selgroups=<{$groups.groups_id}>"><{$groups.nb_users_by_groups}></a>\n                </td>\n                <td class="xo-actions txtcenter">\n                    <a class="tooltip" href="admin.php?fct=groups&amp;op=groups_edit&amp;groups_id=<{$groups.groups_id}>"\n                       title="<{$smarty.const._AM_SYSTEM_GROUPS_EDIT}>">\n                        <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._AM_SYSTEM_GROUPS_EDIT}>"/>\n                    </a>\n                    <{if $groups.delete}>\n                        <a class="tooltip" href="admin.php?fct=groups&amp;op=groups_delete&amp;groups_id=<{$groups.groups_id}>"\n                           title="<{$smarty.const._AM_SYSTEM_GROUPS_DELETE}>">\n                            <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._AM_SYSTEM_GROUPS_DELETE}>"/>\n                        </a>\n                    <{/if}>\n                </td>\n            </tr>\n        <{/foreach}>\n        </tbody>\n    </table>\n    <!-- Display groups navigation -->\n    <div class="clear spacer"></div>\n    <{if $nav_menu}>\n        <div class="xo-avatar-pagenav floatright"><{$nav_menu}></div>\n        <div class="clear spacer"></div>\n    <{/if}>\n<{/if}>\n<!-- Display groups form (add,edit) -->\n<{if $form}>\n    <div class="spacer"><{$form}></div>\n<{/if}>\n');
INSERT INTO `[[dbprefix]]_tplsource` VALUES
(58, '<!-- Header -->\n<{includeq file="db:system_header.tpl"}>\n<!-- Buttons -->\n<div style="height: 30px;">\n    <div class="floatright">\n        <div class="xo-buttons">\n            <{if !$edit_form && !$listimg && !$multiupload}>\n                <button id="xo-addcat-btn" class="ui-corner-all tooltip" onclick="xo_toggle(''div#xo-category-add'');"\n                        title="<{$smarty.const._AM_SYSTEM_IMAGES_ADDCAT}>">\n                    <img src="<{xoAdminIcons add.png}>" alt="<{$smarty.const._AM_SYSTEM_IMAGES_ADDCAT}>"/>\n                    <{$smarty.const._AM_SYSTEM_IMAGES_ADDCAT}>\n                </button>\n            <{/if}>\n            <{if $cat_img || $listimg}>\n                <button id="xo-addimg-btn" class="ui-corner-all tooltip" onclick="xo_toggle(''div#xo-images-add'');"\n                        title="<{$smarty.const._AM_SYSTEM_IMAGES_ADDIMG}>">\n                    <img src="<{xoAdminIcons add.png}>" alt="<{$smarty.const._AM_SYSTEM_IMAGES_ADDIMG}>"/>\n                    <{$smarty.const._AM_SYSTEM_IMAGES_ADDIMG}>\n                </button>\n            <{/if}>\n            <{if $listimg}>\n                <button id="xo-addavatar-btn" class="ui-corner-all tooltip" onclick=''location="admin.php?fct=images&amp;op=multiupload&amp;imgcat_id=<{$imgcat_id}>"''\n                        title="<{$smarty.const._AM_SYSTEM_IMAGES_MULTIUPLOAD}>">\n                    <img src="<{xoAdminIcons add.png}>" alt="<{$smarty.const._AM_SYSTEM_IMAGES_MULTIUPLOAD}>"/>\n                    <{$smarty.const._AM_SYSTEM_IMAGES_MULTIUPLOAD}>\n                </button>\n            <{/if}>\n        </div>\n    </div>\n</div>\n<!-- Category List -->\n<{if !$edit_form && !$listimg && !$multiupload}>\n    <table class="outer" cellspacing="1">\n        <thead>\n        <tr>\n            <th><{$smarty.const._AM_SYSTEM_IMAGES_NAME}></th>\n            <th><{$smarty.const._AM_SYSTEM_IMAGES_NBIMAGES}></th>\n            <th><{$smarty.const._AM_SYSTEM_IMAGES_MAXSIZE}></th>\n            <th><{$smarty.const._AM_SYSTEM_IMAGES_MAXWIDTH}></th>\n            <th><{$smarty.const._AM_SYSTEM_IMAGES_MAXHEIGHT}></th>\n            <th><{$smarty.const._AM_SYSTEM_IMAGES_DISPLAY}></th>\n            <th><{$smarty.const._AM_SYSTEM_IMAGES_ACTIONS}></th>\n        </tr>\n        </thead>\n        <tbody>\n        <{foreach item=cat from=$cat_img}>\n            <tr class="<{cycle values=''odd, even''}> txtcenter">\n                <td>\n                    <a class="tooltip" href="admin.php?fct=images&amp;op=listimg&amp;imgcat_id=<{$cat.id}>" title="<{$smarty.const._AM_SYSTEM_IMAGES_VIEW}>">\n                        <{$cat.name}>\n                    </a>\n                </td>\n                <td><{$cat.count}></td>\n                <td><{$cat.maxsize}></td>\n                <td><{$cat.maxwidth}></td>\n                <td><{$cat.maxheight}></td>\n                <td class="xo-actions"><img id="loading_cat<{$cat.id}>" src="./images/spinner.gif" style="display:none;"\n                                            alt="<{$smarty.const._AM_SYSTEM_LOADING}>"/><img class="cursorpointer tooltip" id="cat<{$cat.id}>"\n                                                                                             onclick="system_setStatus( { fct: ''images'', op: ''display_cat'', imgcat_id: <{$cat.id}> }, ''cat<{$cat.id}>'', ''admin.php'' )"\n                                                                                             src="<{if $cat.display}><{xoAdminIcons success.png}><{else}><{xoAdminIcons cancel.png}><{/if}>"\n                                                                                             alt=""\n                                                                                             title="<{if $cat.display}><{$smarty.const._AM_SYSTEM_IMAGES_OFF}><{else}><{$smarty.const._AM_SYSTEM_IMAGES_ON}><{/if}>"/>\n                </td>\n                <td class="xo-actions txtcenter">\n                    <a class="tooltip" href="admin.php?fct=images&amp;op=listimg&amp;imgcat_id=<{$cat.id}>" title="<{$smarty.const._AM_SYSTEM_IMAGES_VIEW}>">\n                        <img src="<{xoAdminIcons display.png}>" alt="<{$smarty.const._AM_SYSTEM_IMAGES_VIEW}>"/>\n                    </a>\n                    <{if $xoops_isadmin}>\n                        <a class="tooltip" href="admin.php?fct=images&amp;op=editcat&amp;imgcat_id=<{$cat.id}>" title="<{$smarty.const._EDIT}>">\n                            <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._EDIT}>"/>\n                        </a>\n                        <a class="tooltip" href="admin.php?fct=images&amp;op=delcat&amp;imgcat_id=<{$cat.id}>" title="<{$smarty.const._EDIT}>">\n                            <img src="<{xoAdminIcons delete.png}>" alt=""/>\n                        </a>\n                    <{/if}>\n                </td>\n            </tr>\n        <{/foreach}>\n        <{if !$cat_img}>\n            <tr>\n                <td class="txtcenter bold odd" colspan="7"><{$smarty.const._AM_SYSTEM_IMAGES_NOCAT}></td>\n            </tr>\n        <{/if}>\n        </tbody>\n    </table>\n    <!-- Nav menu -->\n    <{if $nav_menu}>\n        <div class="xo-avatar-pagenav floatright"><{$nav_menu}></div>\n        <div class="clear spacer"></div>\n    <{/if}>\n<{/if}>\n<{if $images}>\n    <!-- Image list -->\n    <div id="xo-category-add" class="">\n        <{foreach item=img from=$images}>\n            <div class="floatleft">\n                <div class="ui-corner-all xo-thumb txtcenter">\n                    <div class="xo-thumbimg">\n                        <img class="tooltip" src="<{$xoops_url}>/image.php?id=<{$img.image_id}>&amp;width=120&amp;height=120" alt="<{$img.image_nicename}>"\n                             title="<{$img.image_nicename}>" style="max-width:120px; max-height:120px;"/>\n                    </div>\n                    <div class="xo-actions txtcenter">\n                        <div class="spacer bold"><{$img.image_nicename}></div>\n                        <img id="loading_img<{$img.image_id}>" src="./images/spinner.gif" style="display:none;"\n                             alt="<{$smarty.const._AM_SYSTEM_LOADING}>"/><img class="cursorpointer tooltip" id="img<{$img.image_id}>"\n                                                                              onclick="system_setStatus( { fct: ''images'', op: ''display_img'', image_id: <{$img.image_id}> }, ''img<{$img.image_id}>'', ''admin.php'' )"\n                                                                              src="<{if $img.image_display}><{xoAdminIcons success.png}><{else}><{xoAdminIcons cancel.png}><{/if}>"\n                                                                              alt="<{$smarty.const._IMGDISPLAY}>" title="<{$smarty.const._IMGDISPLAY}>"/>\n                        <{if !$db_store}>\n                        <a class="lightbox tooltip" href="<{$xoops_upload_url}>/<{$img.image_name}>" title="<{$smarty.const._PREVIEW}>">\n                            <{else}>\n                            <a class="lightbox tooltip" href="<{$xoops_url}>/image.php?id=<{$img.image_id}>" title="<{$smarty.const._PREVIEW}>">\n                                <{/if}>\n                                <img src="<{xoAdminIcons display.png}>" alt="<{$smarty.const._AM_SYSTEM_IMAGES_VIEW}>"/>\n                            </a>\n                            <a class="tooltip" href="admin.php?fct=images&amp;op=editimg&amp;image_id=<{$img.image_id}>" title="<{$smarty.const._EDIT}>">\n                                <img src="<{xoAdminIcons edit.png}>" alt="<{$smarty.const._EDIT}>"/>\n                            </a>\n                            <a class="tooltip" href="admin.php?fct=images&amp;op=delfile&amp;image_id=<{$img.image_id}>" title="<{$smarty.const._DELETE}>">\n                                <img src="<{xoAdminIcons delete.png}>" alt="<{$smarty.const._DELETE}>"/>\n                            </a>\n                            <img class="tooltip" onclick="display_dialog(<{$img.image_id}>, true, true, ''slide'', ''slide'', 120, 350);"\n                                 src="<{xoAdminIcons url.png}>" alt="<{$smarty.const._AM_SYSTEM_IMAGES_URL}>"\n                                 title="<{$smarty.const._AM_SYSTEM_IMAGES_URL}>"/>\n                    </div>\n                </div>\n            </div>\n            <div id="dialog<{$img.image_id}>" title="<{$img.image_nicename}>" style=''display:none;''>\n                <div class="center">\n                    <{if !$db_store}>\n                        <{$xoops_upload_url}>/<{$img.image_name}>\n                    <{else}>\n                        <{$xoops_url}>/image.php?id=<{$img.image_id}>\n                    <{/if}>\n                </div>\n            </div>\n        <{/foreach}>\n        <div class="clear"></div>\n    </div>\n    <{if $nav_menu}>\n        <div class="xo-avatar-pagenav floatright"><{$nav_menu}></div>\n        <div class="clear spacer"></div>\n    <{/if}>\n<{else}>\n    <div id="xo-category-add" class="">\n        <div class="clear"></div>\n    </div>\n<{/if}>\n\n<!-- Add Image form -->\n<div id="xo-images-add" class="hide">\n    <br>\n    <{$image_form.javascript}>\n    <form name="<{$image_form.name}>" id="<{$image_form.name}>" action="<{$image_form.action}>" method="<{$image_form.method}>"\n            <{$image_form.extra}> >\n        <table class="outer">\n            <tr>\n                <th colspan="2"><{$image_form.title}></th>\n            </tr>\n            <{foreach item=element from=$image_form.elements}>\n                <{if $element.hidden != true && $element.body != ''''}>\n                    <tr>\n                        <td class="odd aligntop">\n                            <div class="spacer bold"><{$element.caption}><{if $element.required}><span class="red">&nbsp;*</span><{/if}></div>\n                            <div class="spacer"><{$element.description}></div>\n                        </td>\n                        <td class="even"><{$element.body}></td>\n                    </tr>\n                <{else}>\n                    <{$element.body}>\n                <{/if}>\n            <{/foreach}>\n        </table>\n    </form>\n</div>\n<!-- Add Category form -->\n<div id="xo-category-add" class="hide">\n    <br>\n    <{$imagecat_form.javascript}>\n    <form name="<{$imagecat_form.name}>" id="<{$imagecat_form.name}>" action="<{$imagecat_form.action}>" method="<{$imagecat_form.method}>"\n            <{$imagecat_form.extra}> >\n        <table class="outer">\n            <tr>\n                <th colspan="2"><{$imagecat_form.title}></th>\n            </tr>\n            <{foreach item=element from=$imagecat_form.elements}>\n                <{if $element.hidden != true && $element.body != ''''}>\n                    <tr>\n                        <td class="odd aligntop">\n                            <div class="spacer bold"><{$element.caption}><{if $element.required}><span class="red">&nbsp;*</span><{/if}></div>\n                            <div class="spacer"><{$element.description}></div>\n                        </td>\n                        <td class="even"><{$element.body}></td>\n                    </tr>\n                <{else}>\n                    <{$element.body}>\n                <{/if}>\n            <{/foreach}>\n        </table>\n    </form>\n</div>\n<{if $multiupload}>\n    <div class="clear">&nbsp;</div>\n    <{includeq file="db:system_trigger_uploads.tpl"}>\n    <h2><{$imgcat_name}></h2>\n    <div id="fine-uploader-manual-trigger"></div>\n    <div><{$smarty.const._IMGMAXSIZE}> <{$imgcat_maxsize}></div>\n    <div><{$smarty.const._IMGMAXWIDTH}> <{$imgcat_maxwidth}></div>\n    <div><{$smarty.const._IMGMAXHEIGHT}> <{$imgcat_maxheight}></div>\n    <!-- Your code to create an instance of Fine Uploader and bind to the DOM/template\n    ====================================================================== -->\n    <script>\n        var manualUploader = new qq.FineUploader({\n            element: document.getElementById(''fine-uploader-manual-trigger''),\n            template: ''qq-template-manual-trigger'',\n            request: {\n                endpoint: ''<{$xoops_url}>/ajaxfineupload.php'',\n                params: {\n                    "Authorization": "<{$jwt}>"\n                }\n            },\n            text: {\n                formatProgress: "<{$smarty.const._FORMATPROGRESS}>",\n                failUpload: "<{$smarty.const._FAILUPLOAD}>",\n                waitingForResponse: "<{$smarty.const._WAITINGFORRESPONSE}>",\n                paused: "<{$smarty.const._PAUSED}>"\n            },\n            messages: {\n                typeError: "<{$smarty.const._TYPEERROR}>",\n                sizeError: "<{$smarty.const._SIZEERROR}>",\n                minSizeError: "<{$smarty.const._MINSIZEERROR}>",\n                emptyError: "<{$smarty.const._EMPTYERROR}>",\n                noFilesError: "<{$smarty.const._NOFILESERROR}>",\n                tooManyItemsError: "<{$smarty.const._TOOMANYITEMSERROR}>",\n                maxHeightImageError: "<{$smarty.const._MAXHEIGHTIMAGEERROR}>",\n                maxWidthImageError: "<{$smarty.const._MAXWIDTHIMAGEERROR}>",\n                minHeightImageError: "<{$smarty.const._MINHEIGHTIMAGEERROR}>",\n                minWidthImageError: "<{$smarty.const.__MINWIDTHIMAGEERROR}>",\n                retryFailTooManyItems: "<{$smarty.const._RETRYFAILTOOMANYITEMS}>",\n                onLeave: "<{$smarty.const._ONLEAVE}>",\n                unsupportedBrowserIos8Safari: "<{$smarty.const._UNSUPPORTEDBROWSERIOS8SAFARI}>"\n            },\n            thumbnails: {\n                placeholders: {\n                    waitingPath: ''<{$xoops_url}>/media/fine-uploader/placeholders/waiting-generic.png'',\n                    notAvailablePath: ''<{$xoops_url}>/media/fine-uploader/placeholders/not_available-generic.png''\n                }\n            },\n            validation: {\n                acceptFiles: [''image/jpeg'', ''image/gif'', ''image/png''],\n                allowedExtensions: [''jpeg'', ''jpg'', ''png'', ''gif''],\n                image: {\n                    maxHeight: <{$imgcat_maxheight}>,\n                    maxWidth: <{$imgcat_maxwidth}>\n                },\n                sizeLimit: <{$imgcat_maxsize}>\n            },\n            autoUpload: false,\n            callbacks: {\n            onError: function(id, name, errorReason, xhrOrXdr) {\n                 console.log(qq.format("Error uploading {}.  Reason: {}", name, errorReason));\n             }\n         },\n        debug: <{$fineup_debug}>\n        });\n        qq(document.getElementById("trigger-upload")).attach("click", function() {\n            manualUploader.uploadStoredFiles();\n        });\n    </script>\n<{/if}>\n<!-- Edit form image -->\n<{if $edit_form}>\n    <div id="xo-images-add" class="">\n        <{$edit_thumbs}>\n        <br>\n        <{$edit_form.javascript}>\n        <form name="<{$edit_form.name}>" id="<{$edit_form.name}>" action="<{$edit_form.action}>" method="<{$edit_form.method}>"\n                <{$edit_form.extra}> >\n            <table class="outer">\n                <tr>\n                    <th colspan="2"><{$edit_form.title}></th>\n                </tr>\n                <{foreach item=element from=$edit_form.elements}>\n                    <{if $element.hidden != true && $element.body != ''''}>\n                        <tr>\n                            <td class="odd aligntop">\n                                <div class="spacer bold"><{$element.caption}><{if $element.required}><span class="red">&nbsp;*</span><{/if}></div>\n                                <div class="spacer"><{$element.description}></div>\n                            </td>\n                            <td class="even"><{$element.body}></td>\n                        </tr>\n                    <{else}>\n                        <{$element.body}>\n                    <{/if}>\n                <{/foreach}>\n            </table>\n        </form>\n    </div>\n<{/if}>\n<script type="text/javascript">\n    IMG_ON = ''<{xoAdminIcons success.png}>'';\n    IMG_OFF = ''<{xoAdminIcons cancel.png}>'';\n\n    $(''.lightbox'').lightBox({\n        imageLoading: ''language/<{$xoops_language}>/images/lightbox-ico-loading.gif'',\n        imageBtnClose: ''language/<{$xoops_language}>/images/lightbox-btn-close.gif'',\n        imageBtnNext: ''language/<{$xoops_language}>/images/lightbox-btn-next.gif'',\n        imageBtnPrev: ''language/<{$xoops_language}>/images/lightbox-btn-prev.gif'',\n        imageBlank: ''language/<{$xoops_language}>/images/lightbox-blank.gif''\n    });\n\n\n</script>\n'),
(59, '<{includeq file="db:system_header.tpl"}>\n\n<{if $index}>\n    <br class="clear"/>\n    <div class="spacer">\n        <table class="outer ui-corner-all" cellspacing="1">\n            <tr>\n                <th><{$smarty.const._AM_SYSTEM_TEMPLATES_YOUR_THEMES}></th>\n                <th>&nbsp;</th>\n            </tr>\n            <tr>\n                <td class="aligntop width10">\n                    <div id="fileTree" class="display_folder"></div>\n                </td>\n                <td class="aligntop">\n                    <div id="display_form"><{$form}></div>\n                    <div id="display_contenu"></div>\n                    <div id=''display_message'' class="txtcenter" style="display:none;"></div>\n                    <div id=''loading'' class="txtcenter" style="display:none;"><br><br><img src="images/loading.gif" title="Loading" alt="Loading"/>\n                    </div>\n                </td>\n            </tr>\n        </table>\n\n        <br class="clear"/>\n    </div>\n<{else}>\n    <br>\n    <{if $verif}>\n        <{$infos}>\n    <{else}>\n        <div class="txtcenter"><{$smarty.const._AM_SYSTEM_TEMPLATES_NOT_CREATED}></div>\n    <{/if}>\n<{/if}>\n'),
(60, '<{includeq file="db:system_header.tpl"}>\n<script type="text/javascript">\n    IMG_ON = ''<{xoAdminIcons success.png}>'';\n    IMG_OFF = ''<{xoAdminIcons cancel.png}>'';\n</script>\n<table cellspacing="1" class="outer">\n    <thead>\n    <tr>\n        <th class="txtcenter"><{$smarty.const._AM_SYSTEM_SECTION}></th>\n        <th class="txtcenter"><{$smarty.const._AM_SYSTEM_DESC}></th>\n        <th class="txtcenter"><{$smarty.const._AM_SYSTEM_USAGE}></th>\n        <th class="txtcenter"><{$smarty.const._AM_SYSTEM_ACTIVE}></th>\n    </tr>\n    </thead>\n\n    <tbody>\n    <{foreach item=menu from=$menu}>\n        <{if $menu.title}>\n            <tr class="<{cycle values=''even,odd''}>">\n                <td class="bold width15">\n                    <a class="tooltip" href="admin.php?fct=<{$menu.file}>" title="<{$smarty.const._AM_SYSTEM_GO}>: <{$menu.title}>">\n                        <img class="xo-imgmini" src=''<{$theme_icons}>/<{$menu.icon}>'' alt="<{$menu.title}>"/>\n                        <{$menu.title}>\n                    </a>\n                </td>\n                <td class=""><{$menu.desc}></td>\n                <td class="width15"><{$menu.infos}></td>\n                <td class="xo-actions width2">\n                    <{if $menu.used}>\n                        <img id="loading_<{$menu.file}>" src="images/spinner.gif" style="display:none;" alt="<{$smarty.const._AM_SYSTEM_LOADING}>"/>\n                        <img class="tooltip" id="<{$menu.file}>"\n                             onclick="system_setStatus( { op: ''system_activate'', type: ''<{$menu.file}>'' }, ''<{$menu.file}>'', ''admin.php'' )"\n                             src="<{if $menu.status}><{xoAdminIcons success.png}><{else}><{xoAdminIcons cancel.png}><{/if}>"\n                             alt="<{$smarty.const._AM_SYSTEM_STATUS}>" title="<{$smarty.const._AM_SYSTEM_STATUS}>"/>\n                    <{/if}>\n                </td>\n            </tr>\n        <{/if}>\n    <{/foreach}>\n    </tbody>\n</table>\n'),
(61, '<!--maintenance-->\n<{includeq file="db:system_header.tpl"}>\n<!-- Display mailusers form  -->\n<br>\n<{if $form_maintenance}>\n    <div class="spacer"><{$form_maintenance}></div>\n    <br>\n    <div class="spacer"><{$form_dump}></div>\n<{elseif $maintenance}>\n    <{if $verif_cache || $verif_session || $verif_avatar}>\n        <table class="outer ui-corner-all" cellspacing="1">\n            <tr>\n                <th><{$smarty.const._AM_SYSTEM_MAINTENANCE}></th>\n                <th><{$smarty.const._AM_SYSTEM_MAINTENANCE_RESULT}></th>\n            </tr>\n            <{if $verif_cache}>\n                <tr>\n                    <td class="aligntop txtcenter"><{$smarty.const._AM_SYSTEM_MAINTENANCE_RESULT_CACHE}></td>\n                    <td class="aligntop txtcenter"><{if $result_cache}><img width="16" src="<{xoAdminIcons success.png}>"/><{else}><img style="width:16px;"\n                                                                                                                                        src="<{xoAdminIcons cancel.png}>"\n                                                                                                                                        alt="Cancel"/><{/if}>\n                    </td>\n                </tr>\n            <{/if}>\n\n            <{if $verif_session}>\n                <tr>\n                    <td class="aligntop" align="center"><{$smarty.const._AM_SYSTEM_MAINTENANCE_RESULT_SESSION}></td>\n                    <td class="aligntop" align="center"><{if $result_session}><img style="width:16px;" src="<{xoAdminIcons success.png}>"\n                                                                                   alt="Success"/><{else}><img style="width:16px;"\n                                                                                                               src="<{xoAdminIcons cancel.png}>" alt="Cancel"/><{/if}>\n                    </td>\n                </tr>\n            <{/if}>\n\n            <{if $verif_avatar}>\n                <tr>\n                    <td class="aligntop" align="center"><{$smarty.const._AM_SYSTEM_MAINTENANCE_RESULT_AVATAR}></td>\n                    <td class="aligntop" align="center"><{if $result_avatar}><img style="width:16px;" src="<{xoAdminIcons success.png}>"\n                                                                                  alt="Success"/><{else}><img style="width:16px;"\n                                                                                                              src="<{xoAdminIcons cancel.png}>" alt="Cancel"/><{/if}>\n                    </td>\n                </tr>\n            <{/if}>\n        </table>\n        <br>\n    <{/if}>\n    <{if $verif_maintenance}>\n        <{$result_maintenance}>\n    <{/if}>\n<{else}>\n    <{$result_dump}>\n<{/if}>\n'),
(62, '<{includeq file="db:system_header.tpl"}>\n<table id="help-system">\n    <tr>\n        <td class="width20">\n            <{if $help}>\n                <div class="xo-help-menu">\n                    <h2 class="head"><{$modname}></h2>\n                    <{foreach item=help from=$help}>\n                        <div class="<{cycle values=''odd, even''}>"><a href="<{$help.link}>"><{$help.name}></a></div>\n                    <{/foreach}>\n                </div>\n            <{/if}>\n            <{if $list_mods}>\n                <div class="xo-help-menu">\n                    <{foreach item=row from=$list_mods}>\n                        <h2 class="head"><{$row.name}></h2>\n                        <{foreach item=list from=$row.help_page}>\n                            <div class="<{cycle values=''odd, even''}>" title="<{$list.name}>"><a href="<{$list.link}>"><{$list.name}></a></div>\n                        <{/foreach}>\n                    <{/foreach}>\n                </div>\n            <{/if}>\n        </td>\n        <td>\n            <div id="help-content">\n                <{$helpcontent}>\n            </div>\n        </td>\n    </tr>\n</table>\n'),
(63, '<div id="usermenu">\n    <{if $xoops_isadmin}>\n        <a class="menuTop" href="<{xoAppUrl admin.php}>" title="<{$block.lang_adminmenu}>"><{$block.lang_adminmenu}></a>\n        <a href="<{xoAppUrl user.php}>" title="<{$block.lang_youraccount}>"><{$block.lang_youraccount}></a>\n    <{else}>\n        <a class="menuTop" href="<{xoAppUrl user.php}>" title="<{$block.lang_youraccount}>"><{$block.lang_youraccount}></a>\n    <{/if}>\n    <a href="<{xoAppUrl edituser.php}>" title="<{$block.lang_editaccount}>"><{$block.lang_editaccount}></a>\n    <a href="<{xoAppUrl notifications.php}>" title="<{$block.lang_notifications}>"><{$block.lang_notifications}></a>\n    <{if $block.new_messages > 0}>\n        <a class="highlight" href="<{xoAppUrl viewpmsg.php}>" title="<{$block.lang_inbox}>"><{$block.lang_inbox}>\n            (<strong><{$block.new_messages}></strong>)</a>\n    <{else}>\n        <a href="<{xoAppUrl viewpmsg.php}>" title="<{$block.lang_inbox}>"><{$block.lang_inbox}></a>\n    <{/if}>\n    <a href="<{xoAppUrl user.php?op=logout}>" title="<{$block.lang_logout}>"><{$block.lang_logout}></a>\n</div>\n'),
(64, '<div class="txtcenter">\n    <form style="margin-top: 0;" action="<{xoAppUrl user.php}>" method="post">\n        <{$block.lang_username}><br>\n        <input type="text" name="uname" size="12" value="<{$block.unamevalue}>" maxlength="25"/><br>\n        <{$block.lang_password}><br>\n        <input type="password" name="pass" size="12" maxlength="32"/><br>\n        <{if isset($block.lang_rememberme)}>\n            <input type="checkbox" name="rememberme" value="On" class="formButton"/>\n            <{$block.lang_rememberme}>\n            <br>\n        <{/if}>\n        <br>\n        <input type="hidden" name="xoops_redirect" value="<{$xoops_requesturi}>"/>\n        <input type="hidden" name="op" value="login"/>\n        <input type="submit" value="<{$block.lang_login}>"/><br>\n        <{$block.sslloginlink}>\n    </form>\n    <br>\n    <a href="<{xoAppUrl user.php#lost}>" title="<{$block.lang_lostpass}>"><{$block.lang_lostpass}></a>\n    <br><br>\n    <a href="<{xoAppUrl register.php}>" title="<{$block.lang_registernow}>"><{$block.lang_registernow}></a>\n</div>\n'),
(65, '<div class="txtcenter">\n    <form style="margin-top: 0;" action="<{xoAppUrl search.php}>" method="get">\n        <input type="text" name="query" size="14"/>\n        <input type="hidden" name="action" value="results"/><br>\n        <input type="submit" value="<{$block.lang_search}>"/>\n    </form>\n    <a href="<{xoAppUrl search.php}>" title="<{$block.lang_advsearch}>"><{$block.lang_advsearch}></a>\n</div>\n'),
(66, '<ul>\n    <{foreach item=module from=$block.modules}>\n        <li><a href="<{$module.adminlink}>" title="<{$module.lang_linkname}>"><{$module.lang_linkname}></a>: <{$module.pendingnum}></li>\n    <{/foreach}>\n</ul>\n'),
(67, '<div id="mainmenu">\n    <a class="menuTop <{if !$block.nothome}>maincurrent<{/if}>" href="<{xoAppUrl }>" title="<{$block.lang_home}>"><{$block.lang_home}></a>\n    <!-- start module menu loop -->\n    <{foreach item=module from=$block.modules}>\n        <a class="menuMain <{if $module.highlight}>maincurrent<{/if}>" href="<{$xoops_url}>/modules/<{$module.directory}>/" title="<{$module.name}>"><{$module.name}></a>\n        <{foreach item=sublink from=$module.sublinks}>\n            <a class="menuSub" href="<{$sublink.url}>" title="<{$sublink.name}>"><{$sublink.name}></a>\n        <{/foreach}>\n    <{/foreach}>\n    <!-- end module menu loop -->\n</div>\n'),
(68, '<table class="outer collapse">\n\n    <{if $block.showgroups == true}>\n\n        <!-- start group loop -->\n        <{foreach item=group from=$block.groups}>\n            <tr>\n                <th colspan="2"><{$group.name}></th>\n            </tr>\n            <!-- start group member loop -->\n            <{foreach item=user from=$group.users}>\n                <tr>\n                    <td class="even txtcenter alignmiddle">\n                        <img style="width:32px;" src="<{$user.avatar}>" alt="<{$user.name}>"/><br>\n                        <a href="<{$xoops_url}>/userinfo.php?uid=<{$user.id}>" title="<{$user.name}>"><{$user.name}></a>\n                    </td>\n                    <td class="odd width20 txtright alignmiddle">\n                        <{$user.msglink}>\n                    </td>\n                </tr>\n            <{/foreach}>\n            <!-- end group member loop -->\n\n        <{/foreach}>\n        <!-- end group loop -->\n    <{/if}>\n</table>\n\n<br>\n\n<div class="txtcenter marg3">\n    <img src="<{$block.logourl}>" alt=""/><br><{$block.recommendlink}>\n</div>\n'),
(69, '<{$block.online_total}>\n<br><br>\n<{$block.lang_members}>: <{$block.online_members}>\n<br>\n<{$block.lang_guests}>: <{$block.online_guests}>\n<br><br>\n<{$block.online_names}>\n<a href="javascript:openWithSelfMain(''<{$xoops_url}>/misc.php?action=showpopups&amp;type=online'',''Online'',420,350);" title="<{$block.lang_more}>">\n    <{$block.lang_more}>\n</a>\n'),
(70, '<table cellspacing="1" class="outer">\n    <{foreach item=user from=$block.users}>\n        <tr class="<{cycle values=''even,odd''}> alignmiddle">\n            <td><{$user.rank}></td>\n            <td class="txtcenter">\n                <{if $user.avatar != ""}>\n                    <img style="width:32px;" src="<{$user.avatar}>" alt="<{$user.name}>"/>\n                    <br>\n                <{/if}>\n                <a href="<{$xoops_url}>/userinfo.php?uid=<{$user.id}>" title="<{$user.name}>"><{$user.name}></a>\n            </td>\n            <td class="txtcenter"><{$user.posts}></td>\n        </tr>\n    <{/foreach}>\n</table>\n'),
(71, '<table cellspacing="1" class="outer">\n    <{foreach item=user from=$block.users}>\n        <tr class="<{cycle values=''even,odd''}> alignmiddle">\n            <td class="txtcenter">\n                <{if $user.avatar != ""}>\n                    <img style="width:32px;" src="<{$user.avatar}>" alt="<{$user.name}>"/>\n                    <br>\n                <{/if}>\n                <a href="<{$xoops_url}>/userinfo.php?uid=<{$user.id}>" title="<{$user.name}>"><{$user.name}></a>\n            </td>\n            <td class="txtcenter"><{$user.joindate}></td>\n        </tr>\n    <{/foreach}>\n</table>\n'),
(72, '<table cellspacing="1" class="outer width100">\n    <{foreach item=comment from=$block.comments}>\n        <tr class="<{cycle values=''even,odd''}>">\n            <td class="txtcenter"><img src="<{$xoops_url}>/images/subject/<{$comment.icon}>" alt=""/></td>\n            <td><{$comment.title}></td>\n            <td class="txtcenter"><{$comment.module}></td>\n            <td class="txtcenter"><{$comment.poster}></td>\n            <td class="txtright"><{$comment.time}></td>\n        </tr>\n    <{/foreach}>\n</table>\n'),
(73, '<form action="<{$block.target_page}>" method="post">\n    <table class="outer">\n        <{foreach item=category from=$block.categories}>\n            <{foreach name=inner item=event from=$category.events}>\n                <{if $smarty.foreach.inner.first}>\n                    <tr>\n                        <td class="head" colspan="2"><{$category.title}></td>\n                    </tr>\n                <{/if}>\n                <tr>\n                    <td class="odd">\n                        <{counter assign=index}>\n                        <input type="hidden" name="not_list[<{$index}>][params]" value="<{$category.name}>,<{$category.itemid}>,<{$event.name}>"/>\n                        <input type="checkbox" name="not_list[<{$index}>][status]" value="1" <{if $event.subscribed}>checked<{/if}> />\n                    </td>\n                    <td class="odd"><{$event.caption}></td>\n                </tr>\n            <{/foreach}>\n        <{/foreach}>\n        <tr>\n            <td class="foot" colspan="2">\n                <input type="hidden" name="not_redirect" value="<{$block.redirect_script}>">\n                <input type="hidden" value="<{$block.notification_token}>" name="XOOPS_TOKEN_REQUEST"/>\n                <input type="submit" name="not_submit" value="<{$block.submit_button}>"/>\n            </td>\n        </tr>\n    </table>\n</form>\n'),
(74, '<div class="txtcenter">\n    <form action="<{xoAppUrl index.php}>" method="post">\n        <{$block.theme_select}>\n    </form>\n</div>\n');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_users`
--

CREATE TABLE `[[dbprefix]]_users` (
  `uid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `uname` varchar(25) NOT NULL DEFAULT '',
  `email` varchar(60) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `user_avatar` varchar(30) NOT NULL DEFAULT 'blank.gif',
  `user_regdate` int(10) unsigned NOT NULL DEFAULT '0',
  `user_icq` varchar(15) NOT NULL DEFAULT '',
  `user_from` varchar(100) NOT NULL DEFAULT '',
  `user_sig` tinytext,
  `user_viewemail` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `actkey` varchar(8) NOT NULL DEFAULT '',
  `user_aim` varchar(18) NOT NULL DEFAULT '',
  `user_yim` varchar(25) NOT NULL DEFAULT '',
  `user_msnm` varchar(100) NOT NULL DEFAULT '',
  `pass` varchar(255) NOT NULL DEFAULT '',
  `posts` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `attachsig` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `rank` smallint(5) unsigned NOT NULL DEFAULT '0',
  `level` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `theme` varchar(100) NOT NULL DEFAULT '',
  `timezone_offset` float(3,1) NOT NULL DEFAULT '0.0',
  `last_login` int(10) unsigned NOT NULL DEFAULT '0',
  `umode` varchar(10) NOT NULL DEFAULT '',
  `uorder` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `notify_method` tinyint(1) NOT NULL DEFAULT '1',
  `notify_mode` tinyint(1) NOT NULL DEFAULT '0',
  `user_occ` varchar(100) NOT NULL DEFAULT '',
  `bio` tinytext,
  `user_intrest` varchar(150) NOT NULL DEFAULT '',
  `user_mailok` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`uid`),
  KEY `uname` (`uname`),
  KEY `email` (`email`),
  KEY `uiduname` (`uid`,`uname`),
  KEY `level` (`level`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_users`
--

INSERT INTO `[[dbprefix]]_users` VALUES
(1, '', '[[admin_username]]', '[[admin_email]]', '[[softurl]]/', 'avatars/blank.gif', [[timestamp]], '', '', '', 1, '', '', '', '', '[[admin_pass]]', 0, 0, 7, 5, 'xbootstrap', 0.0, [[timestamp]], 'flat', 0, 1, 0, '', '', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_xoopscomments`
--

CREATE TABLE `[[dbprefix]]_xoopscomments` (
  `com_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `com_pid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `com_rootid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `com_modid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `com_itemid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `com_icon` varchar(25) NOT NULL DEFAULT '',
  `com_created` int(10) unsigned NOT NULL DEFAULT '0',
  `com_modified` int(10) unsigned NOT NULL DEFAULT '0',
  `com_uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `com_user` varchar(60) NOT NULL DEFAULT '',
  `com_email` varchar(60) NOT NULL DEFAULT '',
  `com_url` varchar(60) NOT NULL DEFAULT '',
  `com_ip` varchar(45) NOT NULL DEFAULT '',
  `com_title` varchar(255) NOT NULL DEFAULT '',
  `com_text` text,
  `com_sig` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `com_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `com_exparams` varchar(255) NOT NULL DEFAULT '',
  `dohtml` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dosmiley` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `doxcode` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `doimage` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dobr` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`com_id`),
  KEY `com_pid` (`com_pid`),
  KEY `com_itemid` (`com_itemid`),
  KEY `com_uid` (`com_uid`),
  KEY `com_title` (`com_title`(40)),
  KEY `com_status` (`com_status`),
  KEY `com_user` (`com_user`),
  KEY `com_email` (`com_email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_xoopsnotifications`
--

CREATE TABLE `[[dbprefix]]_xoopsnotifications` (
  `not_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `not_modid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `not_itemid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `not_category` varchar(30) NOT NULL DEFAULT '',
  `not_event` varchar(30) NOT NULL DEFAULT '',
  `not_uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `not_mode` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`not_id`),
  KEY `not_modid` (`not_modid`),
  KEY `not_itemid` (`not_itemid`),
  KEY `not_class` (`not_category`),
  KEY `not_uid` (`not_uid`),
  KEY `not_event` (`not_event`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
