-- MySQL dump 10.13  Distrib 5.7.32, for Linux (x86_64)
--
-- Host: localhost    Database: xcart54117
-- ------------------------------------------------------
-- Server version	5.7.32

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `[[dbprefix]]access_control_cells`
--

DROP TABLE IF EXISTS `[[dbprefix]]access_control_cells`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]access_control_cells` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `returnData` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `resendMethod` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int(11) NOT NULL,
  `resendDate` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]access_control_cells`
--

LOCK TABLES `[[dbprefix]]access_control_cells` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]access_control_cells` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]access_control_cells` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]access_control_entities`
--

DROP TABLE IF EXISTS `[[dbprefix]]access_control_entities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]access_control_entities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(10) unsigned DEFAULT NULL,
  `cell_id` int(10) unsigned DEFAULT NULL,
  `uid` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9A98BAB59C54C8C93` (`type_id`),
  KEY `IDX_9A98BAB59CB39D93A` (`cell_id`),
  CONSTRAINT `FK_9A98BAB59C54C8C93` FOREIGN KEY (`type_id`) REFERENCES `[[dbprefix]]access_control_entity_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9A98BAB59CB39D93A` FOREIGN KEY (`cell_id`) REFERENCES `[[dbprefix]]access_control_cells` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]access_control_entities`
--

LOCK TABLES `[[dbprefix]]access_control_entities` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]access_control_entities` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]access_control_entities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]access_control_entity_types`
--

DROP TABLE IF EXISTS `[[dbprefix]]access_control_entity_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]access_control_entity_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]access_control_entity_types`
--

LOCK TABLES `[[dbprefix]]access_control_entity_types` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]access_control_entity_types` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]access_control_entity_types` VALUES (1,'\\XLite\\Model\\Order');
/*!40000 ALTER TABLE `[[dbprefix]]access_control_entity_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]access_control_zone_types`
--

DROP TABLE IF EXISTS `[[dbprefix]]access_control_zone_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]access_control_zone_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]access_control_zone_types`
--

LOCK TABLES `[[dbprefix]]access_control_zone_types` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]access_control_zone_types` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]access_control_zone_types` VALUES (1,'order');
/*!40000 ALTER TABLE `[[dbprefix]]access_control_zone_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]access_control_zones`
--

DROP TABLE IF EXISTS `[[dbprefix]]access_control_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]access_control_zones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cell_id` int(10) unsigned DEFAULT NULL,
  `type_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cz` (`cell_id`,`type_id`),
  KEY `IDX_919AE0547CB39D93A` (`cell_id`),
  KEY `IDX_919AE0547C54C8C93` (`type_id`),
  CONSTRAINT `FK_919AE0547C54C8C93` FOREIGN KEY (`type_id`) REFERENCES `[[dbprefix]]access_control_zone_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_919AE0547CB39D93A` FOREIGN KEY (`cell_id`) REFERENCES `[[dbprefix]]access_control_cells` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]access_control_zones`
--

LOCK TABLES `[[dbprefix]]access_control_zones` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]access_control_zones` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]access_control_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]address_field`
--

DROP TABLE IF EXISTS `[[dbprefix]]address_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]address_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serviceName` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `viewGetterName` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `schemaClass` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `additional` tinyint(1) NOT NULL,
  `required` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_2A531832912ABBB5` (`serviceName`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]address_field`
--

LOCK TABLES `[[dbprefix]]address_field` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]address_field` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]address_field` VALUES (1,'title','','\\XLite\\View\\FormField\\Select\\Title',0,0,0,0),(2,'firstname','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(3,'lastname','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(4,'street','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(5,'city','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(6,'country_code','country_name','\\XLite\\View\\FormField\\Select\\Country',0,1,1,0),(7,'state_id','state_name','\\XLite\\View\\FormField\\Select\\State',0,1,1,0),(8,'custom_state','state_name','\\XLite\\View\\FormField\\Input\\Text',0,0,1,0),(9,'zipcode','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(10,'phone','','\\XLite\\View\\FormField\\Input\\Text',0,0,1,0),(11,'type','type_name','\\XLite\\View\\FormField\\Select\\AddressType',0,0,0,0);
/*!40000 ALTER TABLE `[[dbprefix]]address_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]address_field_translation`
--

DROP TABLE IF EXISTS `[[dbprefix]]address_field_translation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]address_field_translation` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_9430F4FF2BF396750` (`id`),
  CONSTRAINT `FK_9430F4FF2BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]address_field` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]address_field_translation`
--

LOCK TABLES `[[dbprefix]]address_field_translation` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]address_field_translation` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]address_field_translation` VALUES (1,1,'Title','en'),(2,2,'First name','en'),(3,3,'Last name','en'),(4,4,'Address','en'),(5,5,'City','en'),(6,6,'Country','en'),(7,7,'State','en'),(8,8,'State','en'),(9,9,'Zip code','en'),(10,10,'Phone','en'),(11,11,'Address type','en');
/*!40000 ALTER TABLE `[[dbprefix]]address_field_translation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]address_field_value`
--

DROP TABLE IF EXISTS `[[dbprefix]]address_field_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]address_field_value` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `address_field_id` int(11) DEFAULT NULL,
  `address_id` int(11) DEFAULT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9620FAD37BAB8F931` (`address_field_id`),
  KEY `IDX_9620FAD37F5B7AF75` (`address_id`),
  CONSTRAINT `FK_9620FAD37BAB8F931` FOREIGN KEY (`address_field_id`) REFERENCES `[[dbprefix]]address_field` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9620FAD37F5B7AF75` FOREIGN KEY (`address_id`) REFERENCES `[[dbprefix]]profile_addresses` (`address_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]address_field_value`
--

LOCK TABLES `[[dbprefix]]address_field_value` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]address_field_value` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]address_field_value` VALUES (1,1,1,'Mr.'),(2,7,1,'595'),(3,8,1,'Oklahoma'),(4,6,1,'US'),(5,2,1,'Guest'),(6,3,1,'Guest'),(7,10,1,'0123456789'),(8,4,1,'51 apt, 87 street'),(9,5,1,'Edmond'),(10,7,1,'595'),(11,6,1,'US'),(12,9,1,'73003'),(13,1,2,'Mr.'),(14,7,2,'595'),(15,8,2,'Oklahoma'),(16,6,2,'US'),(17,2,2,'Guest'),(18,3,2,'Guest'),(19,10,2,'0123456789'),(20,4,2,'51 apt, 87 street'),(21,5,2,'Edmond'),(22,7,2,'595'),(23,6,2,'US'),(24,9,2,'73003'),(25,1,3,'Mr.'),(26,7,3,'595'),(27,8,3,'Oklahoma'),(28,6,3,'US'),(29,2,3,'Guest'),(30,3,3,'Guest'),(31,10,3,'0123456789'),(32,4,3,'51 apt, 87 street'),(33,5,3,'Edmond'),(34,7,3,'595'),(35,6,3,'US'),(36,9,3,'73003'),(37,1,4,'Mr.'),(38,7,4,'595'),(39,8,4,'Oklahoma'),(40,6,4,'US'),(41,2,4,'Guest'),(42,3,4,'Guest'),(43,10,4,'0123456789'),(44,4,4,'51 apt, 87 street'),(45,5,4,'Edmond'),(46,7,4,'595'),(47,6,4,'US'),(48,9,4,'73003'),(49,1,5,'Mr.'),(50,7,5,'595'),(51,8,5,'Oklahoma'),(52,6,5,'US'),(53,2,5,'Guest'),(54,3,5,'Guest'),(55,10,5,'0123456789'),(56,4,5,'51 apt, 87 street'),(57,5,5,'Edmond'),(58,7,5,'595'),(59,6,5,'US'),(60,9,5,'73003'),(61,1,6,'Mr.'),(62,7,6,'595'),(63,8,6,'Oklahoma'),(64,6,6,'US'),(65,2,6,'Guest'),(66,3,6,'Guest'),(67,10,6,'0123456789'),(68,4,6,'51 apt, 87 street'),(69,5,6,'Edmond'),(70,7,6,'595'),(71,6,6,'US'),(72,9,6,'73003');
/*!40000 ALTER TABLE `[[dbprefix]]address_field_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_group_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_group_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_group_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_98C43909EBF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]attribute_groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_group_translations`
--

LOCK TABLES `[[dbprefix]]attribute_group_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_group_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]attribute_group_translations` VALUES (1,1,'Display','en'),(2,2,'Cellular and Wireless','en'),(3,3,'Power and Battery','en'),(4,1,'Дисплей','ru'),(5,2,'Сотовая и беспроводняа связь','ru'),(6,3,'Батарея','ru');
/*!40000 ALTER TABLE `[[dbprefix]]attribute_group_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_groups`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_class_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_959E382E821B06187` (`product_class_id`),
  CONSTRAINT `FK_959E382E821B06187` FOREIGN KEY (`product_class_id`) REFERENCES `[[dbprefix]]product_classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_groups`
--

LOCK TABLES `[[dbprefix]]attribute_groups` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_groups` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]attribute_groups` VALUES (1,2,10),(2,2,20),(3,2,30);
/*!40000 ALTER TABLE `[[dbprefix]]attribute_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_option_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_option_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_option_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_931550B83BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]attribute_options` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3312 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_option_translations`
--

LOCK TABLES `[[dbprefix]]attribute_option_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_option_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]attribute_option_translations` VALUES (1,1,'S','en'),(2,2,'M','en'),(3,3,'L','en'),(4,4,'XL','en'),(5,5,'XXL','en'),(8,8,'XXXL','en'),(109,109,'IndependentApparel','en'),(110,110,'YourStyle','en'),(111,111,'MyBestDress','en'),(112,112,'Toyty','en'),(113,113,'FunnyChildren','en'),(114,114,'MindSet','en'),(115,115,'GoodyBrand','en'),(116,116,'iBoutique','en'),(1001,1,'S','ru'),(1002,2,'M','ru'),(1003,3,'L','ru'),(1004,4,'XL','ru'),(1005,5,'XXL','ru'),(1008,8,'XXXL','ru'),(1109,109,'IndependentApparel','ru'),(1110,110,'YourStyle','ru'),(1111,111,'MyBestDress','ru'),(1112,112,'Toyty','ru'),(1113,113,'FunnyChildren','ru'),(1114,114,'MindSet','ru'),(1115,115,'GoodyBrand','ru'),(1116,116,'iBoutique','ru'),(2001,1,'S','ru'),(2002,2,'M','ru'),(2003,3,'L','ru'),(2004,4,'XL','ru'),(2005,5,'XXL','ru'),(2008,8,'XXXL','ru'),(2109,109,'IndependentApparel','ru'),(2110,110,'YourStyle','ru'),(2111,111,'MyBestDress','ru'),(2112,112,'Toyty','ru'),(2113,113,'FunnyChildren','ru'),(2114,114,'MindSet','ru'),(2115,115,'GoodyBrand','ru'),(2116,116,'iBoutique','ru'),(3001,1,'S','ru'),(3002,2,'M','ru'),(3003,3,'L','ru'),(3004,4,'XL','ru'),(3005,5,'XXL','ru'),(3008,8,'XXXL','ru'),(3109,109,'IndependentApparel','ru'),(3110,110,'YourStyle','ru'),(3111,111,'MyBestDress','ru'),(3112,112,'Toyty','ru'),(3113,113,'FunnyChildren','ru'),(3114,114,'MindSet','ru'),(3115,115,'GoodyBrand','ru'),(3116,116,'iBoutique','ru'),(3165,165,'16','en'),(3166,166,'64','en'),(3167,167,'128','en'),(3168,168,'Silver','en'),(3169,169,'Space Gray','en'),(3170,170,'Gold','en'),(3171,171,'A8 chip with 64‑bit architecture','en'),(3173,173,'Retina HD display','en'),(3181,181,'GSM/EDGE/LTE','en'),(3183,183,'Bluetooth 4.2','en'),(3186,186,'32','en'),(3187,187,'A7 chip with 64-bit architecture','en'),(3188,188,'White','en'),(3189,189,'Black','en'),(3196,196,'GSM/EDGE','en'),(3200,200,'A9 chip with 64‑bit architecture','en'),(3209,205,'Rose Gold','en'),(3210,168,'Серебристый','ru'),(3211,169,'Серый космос','ru'),(3212,170,'Золотой','ru'),(3213,188,'Белый','ru'),(3214,189,'Черный','ru'),(3215,205,'Розовое золото','ru'),(3216,165,'16','ru'),(3217,166,'64','ru'),(3218,167,'128','ru'),(3219,186,'32','ru'),(3221,207,'Nano-SIM','ru'),(3223,209,'4','ru'),(3224,210,'1136x640','ru'),(3225,211,'Built-in rechargeable lithium-ion battery','ru'),(3226,212,'Up to 14 hours on 3G','ru'),(3227,213,'Up to 10 days (250 hours)','ru'),(3228,214,'Up to 10 hours','ru'),(3229,215,'Up to 40 hours','ru'),(3231,217,'802.11a/b/g/n/ac','ru'),(3232,218,'One size','en'),(3233,218,'','ru'),(3234,219,'XS','en'),(3262,227,'US 6','en'),(3263,228,'US 7','en'),(3264,229,'US 8','en'),(3265,230,'US 9','en'),(3266,231,'Gray','en'),(3267,232,'Red','en'),(3268,233,'Black','en'),(3269,234,'UK 8','en'),(3270,235,'UK 10','en'),(3271,236,'UK 12','en'),(3272,237,'UK 14','en'),(3273,238,'UK 16','en'),(3280,245,'S','en'),(3281,246,'M','en'),(3282,247,'L','en'),(3283,248,'XL','en'),(3284,249,'256','en'),(3285,250,'Apple A11 Bionic','en'),(3286,251,'Super Retina HD (OLED)','en'),(3287,252,'5.8','en'),(3288,253,'2436x1125','en'),(3289,254,'Bluetooth 5.0','en'),(3290,255,'A11 Bionic + M11','en'),(3291,256,'UK 6','en'),(3292,257,'Uk 8','en'),(3293,258,'Uk 10','en'),(3294,259,'Uk 12','en'),(3295,260,'Uk 14','en'),(3296,261,'Uk 16','en'),(3297,227,'38','ru'),(3298,228,'39','ru'),(3299,229,'40','ru'),(3300,230,'41','ru'),(3301,171,'A8 64‑bit','ru'),(3302,187,'A7 64-bit','ru'),(3303,200,'A9 64‑bit','ru'),(3304,250,'Apple A11 Bionic','ru'),(3305,255,'A11 Bionic + M11','ru'),(3306,173,'Retina HD display','ru'),(3307,251,'Super Retina HD (OLED)','ru'),(3308,252,'5.8','ru'),(3309,253,'2436x1125','ru'),(3310,181,'GSM/EDGE/LTE','ru'),(3311,196,'GSM/EDGE','ru');
/*!40000 ALTER TABLE `[[dbprefix]]attribute_option_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_options`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `addToNew` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_92E486F4AB6E62EFA` (`attribute_id`),
  CONSTRAINT `FK_92E486F4AB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=262 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_options`
--

LOCK TABLES `[[dbprefix]]attribute_options` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_options` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]attribute_options` VALUES (1,1,1,0),(2,1,1,0),(3,1,1,0),(4,1,1,0),(5,1,1,0),(8,1,1,0),(109,50,0,0),(110,50,0,0),(111,50,0,0),(112,50,0,0),(113,50,0,0),(114,50,0,0),(115,50,0,0),(116,50,0,0),(165,71,1,0),(166,71,1,0),(167,71,0,0),(168,73,0,0),(169,73,0,0),(170,73,0,0),(171,72,0,0),(173,75,0,0),(181,83,0,0),(183,85,0,0),(186,71,0,0),(187,72,0,0),(188,73,0,0),(189,73,0,0),(196,83,0,0),(200,72,0,0),(205,73,0,0),(207,74,0,0),(209,76,0,0),(210,77,0,0),(211,78,0,0),(212,79,0,0),(213,80,0,0),(214,81,0,0),(215,82,0,0),(217,84,0,0),(218,1,0,0),(219,1,0,0),(227,94,1,0),(228,94,1,0),(229,94,1,0),(230,94,1,0),(231,95,0,0),(232,95,0,0),(233,95,0,0),(234,96,0,0),(235,96,0,0),(236,96,0,0),(237,96,0,0),(238,96,0,0),(245,98,0,0),(246,98,0,0),(247,98,0,0),(248,98,0,0),(249,71,0,0),(250,72,0,0),(251,75,0,0),(252,76,0,0),(253,77,0,0),(254,85,0,0),(255,72,0,0),(256,99,0,0),(257,99,0,0),(258,99,0,0),(259,99,0,0),(260,99,0,0),(261,99,0,0);
/*!40000 ALTER TABLE `[[dbprefix]]attribute_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_properties`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  `displayMode` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_93C3647F44584665A` (`product_id`),
  KEY `IDX_93C3647F4B6E62EFA` (`attribute_id`),
  CONSTRAINT `FK_93C3647F44584665A` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_93C3647F4B6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_properties`
--

LOCK TABLES `[[dbprefix]]attribute_properties` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_properties` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_98BBAD04BBF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=188 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_translations`
--

LOCK TABLES `[[dbprefix]]attribute_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]attribute_translations` VALUES (1,1,'Size','','en'),(50,50,'Manufacturer','','en'),(51,1,'Размер','','ru'),(100,50,'Производитель','','ru'),(141,71,'Capacity, GB','','en'),(142,72,'Chip','','en'),(143,73,'Color','','en'),(144,74,'Sim card','','en'),(145,75,'Display type','','en'),(146,76,'Dimension, inches','','en'),(147,77,'Resolution','','en'),(148,78,'Battery type','','en'),(149,79,'Talk time','','en'),(150,80,'Standby time','','en'),(151,81,'Video playback','','en'),(152,82,'Audio playback','','en'),(153,83,'GSM model','','en'),(154,84,'Wi-Fi','','en'),(155,85,'Bluetooth','','en'),(156,86,'GPS','','en'),(159,73,'Цвет','','ru'),(160,71,'Объем памяти, Гб','','ru'),(161,72,'Процессор','','ru'),(162,74,'Тип Sim-карты','','ru'),(163,75,'Тип дисплея','','ru'),(164,76,'Диагональ в дюймах','','ru'),(165,77,'Разрешение','','ru'),(166,78,'Тип аккумулятора','','ru'),(167,79,'Работа в режиме разговора','','ru'),(168,80,'Работа в режиме ожидания','','ru'),(169,81,'Работа в режиме проигрывания видео','','ru'),(170,82,'Работа в режиме проигрывания аудио','','ru'),(171,83,'Тип GSM','','ru'),(172,84,'Тип Wi-Fi','','ru'),(173,85,'Bluetooth','','ru'),(174,86,'GPS','','ru'),(181,94,'Size','','en'),(182,95,'Color','','en'),(183,96,'Size','','en'),(186,99,'Size','','en'),(187,94,'Размер','','ru');
/*!40000 ALTER TABLE `[[dbprefix]]attribute_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_values_checkbox`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_values_checkbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_values_checkbox` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `value` tinyint(1) NOT NULL,
  `xpaymentsSubscriptionFeeModifier` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `xpaymentsSubscriptionFeeModifierType` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'p',
  `priceModifier` decimal(14,4) NOT NULL,
  `priceModifierType` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weightModifier` decimal(14,4) NOT NULL,
  `weightModifierType` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `defaultValue` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `value` (`value`),
  CONSTRAINT `FK_93CA3503B4584665A` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_93CA3503BB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_values_checkbox`
--

LOCK TABLES `[[dbprefix]]attribute_values_checkbox` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_checkbox` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]attribute_values_checkbox` VALUES (21,29,86,1,0.0000,'p',0.0000,'p',0.0000,'p',0),(22,28,86,1,0.0000,'p',0.0000,'p',0.0000,'p',0);
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_checkbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_values_checkbox_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_values_checkbox_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_values_checkbox_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_95A770E51BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]attribute_values_checkbox` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_values_checkbox_translations`
--

LOCK TABLES `[[dbprefix]]attribute_values_checkbox_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_checkbox_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_checkbox_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_values_hidden`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_values_hidden`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_values_hidden` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_option_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `attribute_option_id` (`attribute_option_id`),
  CONSTRAINT `FK_9A68A8FD61AE56DE9` FOREIGN KEY (`attribute_option_id`) REFERENCES `[[dbprefix]]attribute_options` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9A68A8FD64584665A` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9A68A8FD6B6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_values_hidden`
--

LOCK TABLES `[[dbprefix]]attribute_values_hidden` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_hidden` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_hidden` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_values_hidden_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_values_hidden_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_values_hidden_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9B6B29289BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]attribute_values_hidden` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_values_hidden_translations`
--

LOCK TABLES `[[dbprefix]]attribute_values_hidden_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_hidden_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_hidden_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_values_select`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_values_select`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_values_select` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_option_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  `xpaymentsSubscriptionFeeModifier` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `xpaymentsSubscriptionFeeModifierType` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'p',
  `priceModifier` decimal(14,4) NOT NULL,
  `priceModifierType` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weightModifier` decimal(14,4) NOT NULL,
  `weightModifierType` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `defaultValue` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `attribute_option_id` (`attribute_option_id`),
  CONSTRAINT `FK_965258CAB1AE56DE9` FOREIGN KEY (`attribute_option_id`) REFERENCES `[[dbprefix]]attribute_options` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_965258CAB4584665A` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_965258CABB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=537 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_values_select`
--

LOCK TABLES `[[dbprefix]]attribute_values_select` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_select` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]attribute_values_select` VALUES (462,227,2,94,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(463,228,2,94,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(464,229,2,94,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(465,230,2,94,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(466,228,4,94,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(467,229,4,94,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(468,230,4,94,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(470,231,31,95,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(471,232,31,95,20,0.0000,'p',20.0000,'a',0.0000,'a',0),(472,233,31,95,30,0.0000,'p',5.0000,'p',0.0000,'a',0),(473,234,16,96,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(474,235,16,96,20,0.0000,'p',0.0000,'a',0.0000,'a',0),(475,236,16,96,30,0.0000,'p',0.0000,'a',0.0000,'a',0),(476,237,16,96,40,0.0000,'p',0.0000,'a',0.0000,'a',0),(477,238,16,96,50,0.0000,'p',0.0000,'a',0.0000,'a',0),(484,116,14,50,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(485,1,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(486,2,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(487,3,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(488,4,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(489,5,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(490,8,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(491,2,17,1,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(493,3,17,1,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(494,4,17,1,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(495,5,17,1,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(496,8,17,1,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(497,109,17,50,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(502,166,29,71,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(504,167,29,71,10,0.0000,'p',100.0000,'a',0.0000,'a',0),(505,249,29,71,20,0.0000,'p',200.0000,'a',0.0000,'a',0),(506,250,29,72,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(507,189,29,73,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(509,251,29,75,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(510,252,29,76,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(511,253,29,77,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(513,181,29,83,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(515,254,29,85,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(516,166,28,71,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(517,249,28,71,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(518,255,28,72,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(519,168,28,73,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(520,170,28,73,20,0.0000,'p',0.0000,'a',0.0000,'a',0),(521,169,28,73,30,0.0000,'p',0.0000,'a',0.0000,'a',0),(523,173,28,75,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(527,181,28,83,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(529,254,28,85,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(530,111,15,50,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(531,256,15,99,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(532,257,15,99,20,0.0000,'p',0.0000,'a',0.0000,'a',0),(533,258,15,99,30,0.0000,'p',0.0000,'a',0.0000,'a',0),(534,259,15,99,40,0.0000,'p',0.0000,'a',0.0000,'a',0),(535,260,15,99,50,0.0000,'p',0.0000,'a',0.0000,'a',0),(536,261,15,99,60,0.0000,'p',0.0000,'a',0.0000,'a',0);
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_select` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_values_select_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_values_select_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_values_select_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9CDF9A7AFBF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]attribute_values_select` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_values_select_translations`
--

LOCK TABLES `[[dbprefix]]attribute_values_select_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_select_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_select_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_values_text`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_values_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_values_text` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `editable` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  CONSTRAINT `FK_9560D03DA4584665A` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9560D03DAB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_values_text`
--

LOCK TABLES `[[dbprefix]]attribute_values_text` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_text` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attribute_values_text_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]attribute_values_text_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attribute_values_text_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9753A596BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]attribute_values_text` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attribute_values_text_translations`
--

LOCK TABLES `[[dbprefix]]attribute_values_text_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_text_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]attribute_values_text_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]attributes`
--

DROP TABLE IF EXISTS `[[dbprefix]]attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]attributes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_class_id` int(10) unsigned DEFAULT NULL,
  `attribute_group_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `googleShoppingGroup` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `position` int(11) NOT NULL,
  `decimals` int(11) NOT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `displayMode` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `addToNew` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_99665298321B06187` (`product_class_id`),
  KEY `IDX_99665298362D643B7` (`attribute_group_id`),
  KEY `IDX_9966529834584665A` (`product_id`),
  CONSTRAINT `FK_99665298321B06187` FOREIGN KEY (`product_class_id`) REFERENCES `[[dbprefix]]product_classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9966529834584665A` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_99665298362D643B7` FOREIGN KEY (`attribute_group_id`) REFERENCES `[[dbprefix]]attribute_groups` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]attributes`
--

LOCK TABLES `[[dbprefix]]attributes` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]attributes` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]attributes` VALUES (1,1,NULL,NULL,NULL,1,0,0,'S','S',''),(50,NULL,NULL,NULL,NULL,1,0,0,'S','S',''),(71,2,NULL,NULL,NULL,1,0,0,'S','S',''),(72,2,NULL,NULL,NULL,1,0,0,'S','S',''),(73,2,NULL,NULL,NULL,1,0,0,'S','S',''),(74,2,NULL,NULL,NULL,0,0,0,'S','S',''),(75,2,1,NULL,NULL,1,0,0,'S','S',''),(76,2,1,NULL,NULL,1,0,0,'S','S',''),(77,2,1,NULL,NULL,1,0,0,'S','S',''),(78,2,3,NULL,NULL,0,0,0,'S','S',''),(79,2,3,NULL,NULL,0,0,0,'S','S',''),(80,2,3,NULL,NULL,0,0,0,'S','S',''),(81,2,3,NULL,NULL,0,0,0,'S','S',''),(82,2,3,NULL,NULL,0,0,0,'S','S',''),(83,2,2,NULL,NULL,1,0,0,'S','S',''),(84,2,2,NULL,NULL,1,0,0,'S','S',''),(85,2,2,NULL,NULL,0,0,0,'S','S',''),(86,2,2,NULL,NULL,1,0,0,'C','',''),(94,3,NULL,NULL,NULL,1,0,0,'S','S',''),(95,NULL,NULL,31,NULL,1,0,0,'S','S',''),(96,NULL,NULL,16,NULL,1,0,0,'S','S',''),(99,NULL,NULL,15,NULL,1,0,0,'S','S','');
/*!40000 ALTER TABLE `[[dbprefix]]attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]banner_rotation_image`
--

DROP TABLE IF EXISTS `[[dbprefix]]banner_rotation_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]banner_rotation_image` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `banner_rotation_slide_id` int(10) unsigned DEFAULT NULL,
  `alt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_BDC50932217A8232` (`banner_rotation_slide_id`),
  CONSTRAINT `FK_9BDC50932217A8232` FOREIGN KEY (`banner_rotation_slide_id`) REFERENCES `[[dbprefix]]banner_rotation_slide` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]banner_rotation_image`
--

LOCK TABLES `[[dbprefix]]banner_rotation_image` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]banner_rotation_image` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]banner_rotation_image` VALUES (1,1,'',3840,884,NULL,1,'1_2cosmentic_big.jpg','','image/jpeg','r',328874,1560755009),(2,2,'',3840,884,NULL,1,'1_1food_big_1.jpg','','image/jpeg','r',122740,1560757732),(3,3,'',3840,884,NULL,1,'1_4smart_big.jpg','','image/jpeg','r',122740,1560950874),(4,4,'',3840,884,NULL,1,'1_5fashion_1.jpg','','image/jpeg`','r',324727,1560865514);
/*!40000 ALTER TABLE `[[dbprefix]]banner_rotation_image` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]banner_rotation_slide`
--

DROP TABLE IF EXISTS `[[dbprefix]]banner_rotation_slide`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]banner_rotation_slide` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]banner_rotation_slide`
--

LOCK TABLES `[[dbprefix]]banner_rotation_slide` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]banner_rotation_slide` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]banner_rotation_slide` VALUES (1,0,'cart.php?target=category&category_id=6',50),(2,1,'cart.php?target=category&category_id=8',30),(3,1,'cart.php?target=category&category_id=9',40),(4,1,'cart.php?target=category&category_id=2',20);
/*!40000 ALTER TABLE `[[dbprefix]]banner_rotation_slide` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]capost_delivery_service_options`
--

DROP TABLE IF EXISTS `[[dbprefix]]capost_delivery_service_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]capost_delivery_service_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mandatory` tinyint(1) NOT NULL,
  `qualifierRequired` tinyint(1) NOT NULL,
  `qualifierMax` decimal(14,4) DEFAULT NULL,
  `serviceId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_985C93F5589697FA8` (`serviceId`),
  CONSTRAINT `FK_985C93F5589697FA8` FOREIGN KEY (`serviceId`) REFERENCES `[[dbprefix]]capost_delivery_services` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]capost_delivery_service_options`
--

LOCK TABLES `[[dbprefix]]capost_delivery_service_options` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]capost_delivery_service_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]capost_delivery_service_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]capost_delivery_services`
--

DROP TABLE IF EXISTS `[[dbprefix]]capost_delivery_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]capost_delivery_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countryCode` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry` int(10) unsigned NOT NULL,
  `maxWeight` int(11) NOT NULL,
  `minWeight` int(11) NOT NULL,
  `maxLength` decimal(11,1) NOT NULL,
  `minLength` decimal(11,1) NOT NULL,
  `maxWidth` decimal(11,1) NOT NULL,
  `minWidth` decimal(11,1) NOT NULL,
  `maxHeight` decimal(11,1) NOT NULL,
  `minHeight` decimal(11,1) NOT NULL,
  `lengthPlusGirthMax` decimal(11,1) DEFAULT NULL,
  `lengthHeightWidthSumMax` decimal(11,1) DEFAULT NULL,
  `oversizeLimit` decimal(11,1) DEFAULT NULL,
  `densityFactor` int(11) DEFAULT NULL,
  `canShipInMailingTube` tinyint(1) NOT NULL,
  `canShipUnpackaged` tinyint(1) NOT NULL,
  `allowedAsReturnService` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code_country` (`code`,`countryCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]capost_delivery_services`
--

LOCK TABLES `[[dbprefix]]capost_delivery_services` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]capost_delivery_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]capost_delivery_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]capost_return_items`
--

DROP TABLE IF EXISTS `[[dbprefix]]capost_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]capost_return_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` int(10) unsigned NOT NULL,
  `returnId` int(10) unsigned DEFAULT NULL,
  `orderItemId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_932022371B43D59E` (`returnId`),
  KEY `IDX_93202237BBF22A26` (`orderItemId`),
  CONSTRAINT `FK_932022371B43D59E` FOREIGN KEY (`returnId`) REFERENCES `[[dbprefix]]capost_returns` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_93202237BBF22A26` FOREIGN KEY (`orderItemId`) REFERENCES `[[dbprefix]]order_items` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]capost_return_items`
--

LOCK TABLES `[[dbprefix]]capost_return_items` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]capost_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]capost_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]capost_return_link_storage`
--

DROP TABLE IF EXISTS `[[dbprefix]]capost_return_link_storage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]capost_return_link_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `linkId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_784CAF87AEC98E42` (`linkId`),
  CONSTRAINT `FK_9784CAF87AEC98E42` FOREIGN KEY (`linkId`) REFERENCES `[[dbprefix]]capost_return_links` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]capost_return_link_storage`
--

LOCK TABLES `[[dbprefix]]capost_return_link_storage` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]capost_return_link_storage` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]capost_return_link_storage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]capost_return_links`
--

DROP TABLE IF EXISTS `[[dbprefix]]capost_return_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]capost_return_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `href` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idx` int(11) DEFAULT NULL,
  `mediaType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `returnId` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_933BC6A621B43D59E` (`returnId`),
  CONSTRAINT `FK_933BC6A621B43D59E` FOREIGN KEY (`returnId`) REFERENCES `[[dbprefix]]capost_returns` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]capost_return_links`
--

LOCK TABLES `[[dbprefix]]capost_return_links` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]capost_return_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]capost_return_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]capost_returns`
--

DROP TABLE IF EXISTS `[[dbprefix]]capost_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]capost_returns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `lastRenewDate` int(11) NOT NULL,
  `notes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `adminNotes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `trackingPin` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `orderId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9A90646B3FA237437` (`orderId`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  CONSTRAINT `FK_9A90646B3FA237437` FOREIGN KEY (`orderId`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]capost_returns`
--

LOCK TABLES `[[dbprefix]]capost_returns` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]capost_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]capost_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]categories`
--

DROP TABLE IF EXISTS `[[dbprefix]]categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `ogMeta` longtext COLLATE utf8mb4_unicode_ci,
  `useCustomOG` tinyint(1) NOT NULL,
  `csLastUpdate` int(11) NOT NULL,
  `demo` tinyint(1) NOT NULL,
  `useClasses` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lpos` int(11) NOT NULL,
  `rpos` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `show_title` tinyint(1) NOT NULL,
  `depth` int(11) NOT NULL,
  `pos` int(11) NOT NULL,
  `root_category_look` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metaDescType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `xcPendingExport` tinyint(1) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `IDX_99D0DF19B727ACA70` (`parent_id`),
  KEY `lpos` (`lpos`),
  KEY `rpos` (`rpos`),
  KEY `enabled` (`enabled`),
  KEY `csLastUpdate` (`csLastUpdate`),
  CONSTRAINT `FK_99D0DF19B727ACA70` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]categories`
--

LOCK TABLES `[[dbprefix]]categories` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]categories` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]categories` VALUES (1,NULL,'',0,0,0,'A',1,24,1,0,-1,0,'icons','A',0),(2,1,'',0,0,1,'A',2,9,1,1,0,10,NULL,'A',0),(3,2,'',0,0,1,'A',3,4,1,1,1,10,NULL,'A',0),(4,2,'',0,0,1,'A',5,6,1,1,1,20,NULL,'A',0),(5,2,'',0,0,1,'A',7,8,1,1,1,30,NULL,'A',0),(6,1,'',0,0,1,'A',10,15,1,1,0,20,NULL,'A',0),(7,6,'',0,0,1,'A',11,12,1,1,1,10,NULL,'A',0),(8,6,'',0,0,1,'A',13,14,1,1,1,10,NULL,'A',0),(9,1,'',0,0,1,'A',16,23,1,1,0,30,NULL,'A',0),(10,9,'',0,0,1,'A',17,18,1,1,1,10,NULL,'A',0),(11,9,'',0,0,1,'A',19,20,1,1,1,20,NULL,'A',0),(12,9,'',0,0,1,'A',21,22,1,1,1,30,NULL,'A',0);
/*!40000 ALTER TABLE `[[dbprefix]]categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]category_banners`
--

DROP TABLE IF EXISTS `[[dbprefix]]category_banners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]category_banners` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `alt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_69B8F0D412469DE2` (`category_id`),
  CONSTRAINT `FK_969B8F0D412469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]category_banners`
--

LOCK TABLES `[[dbprefix]]category_banners` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]category_banners` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]category_banners` VALUES (1,2,'',2996,520,NULL,1,'fashion_6.jpeg','','image/jpeg','r',331715,1560863809),(2,6,'',2996,520,NULL,1,'beauty_banner5.jpg','','image/jpeg','r',340745,1559911154),(3,9,'',2996,520,NULL,1,'9_electronic.jpeg','','image/jpeg','r',334750,1560943954);
/*!40000 ALTER TABLE `[[dbprefix]]category_banners` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]category_class_links`
--

DROP TABLE IF EXISTS `[[dbprefix]]category_class_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]category_class_links` (
  `category_id` int(10) unsigned NOT NULL,
  `class_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`category_id`,`class_id`),
  KEY `IDX_93F5DB31312469DE2` (`category_id`),
  KEY `IDX_93F5DB313EA000B10` (`class_id`),
  CONSTRAINT `FK_93F5DB31312469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_93F5DB313EA000B10` FOREIGN KEY (`class_id`) REFERENCES `[[dbprefix]]product_classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]category_class_links`
--

LOCK TABLES `[[dbprefix]]category_class_links` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]category_class_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]category_class_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]category_images`
--

DROP TABLE IF EXISTS `[[dbprefix]]category_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]category_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `alt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_3EDA5C4B12469DE2` (`category_id`),
  CONSTRAINT `FK_93EDA5C4B12469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]category_images`
--

LOCK TABLES `[[dbprefix]]category_images` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]category_images` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]category_images` VALUES (1,2,'',732,880,NULL,1,'clo_7_1.jpg','','image/jpeg','r',111237,1559324094),(2,3,'',732,880,NULL,1,'clo_5.jpg','','image/jpeg','r',199790,1559317753),(3,4,'',732,880,NULL,1,'shoes_6_2.jpg','','image/jpeg','r',80257,1559317794),(4,5,'',732,880,NULL,1,'bag_1.jpg','','image/jpeg','r',154680,1559320882),(5,6,'',732,880,NULL,1,'beauty_1.jpg','','image/jpeg','r',46495,1559892754),(6,7,'',732,880,NULL,1,'beauty_2.jpg','','image/jpeg','r',102218,1559894538),(7,8,'',732,880,NULL,1,'food_11.jpg','','image/jpeg','r',84336,1559898037),(8,9,'',732,880,NULL,1,'elec_2.jpg','','image/jpeg','r',132698,1559820383),(9,10,'',732,880,NULL,1,'elec_5.jpg','','image/jpeg','r',51859,1559822955),(10,11,'',732,880,NULL,1,'elec_4.jpg','','image/jpeg','r',125842,1559821038),(11,12,'',732,880,NULL,1,'elec_14.jpg','','image/jpeg','r',16200,1559828507);
/*!40000 ALTER TABLE `[[dbprefix]]category_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]category_membership_links`
--

DROP TABLE IF EXISTS `[[dbprefix]]category_membership_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]category_membership_links` (
  `category_id` int(10) unsigned NOT NULL,
  `membership_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`category_id`,`membership_id`),
  KEY `IDX_9A0AA75DD12469DE2` (`category_id`),
  KEY `IDX_9A0AA75DD1FB354CD` (`membership_id`),
  CONSTRAINT `FK_9A0AA75DD12469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9A0AA75DD1FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `[[dbprefix]]memberships` (`membership_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]category_membership_links`
--

LOCK TABLES `[[dbprefix]]category_membership_links` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]category_membership_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]category_membership_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]category_products`
--

DROP TABLE IF EXISTS `[[dbprefix]]category_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]category_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `orderby` int(11) NOT NULL,
  `orderbyInProduct` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pair` (`category_id`,`product_id`),
  KEY `IDX_97121122812469DE2` (`category_id`),
  KEY `IDX_9712112284584665A` (`product_id`),
  KEY `orderby` (`orderby`),
  KEY `orderbyInProduct` (`orderbyInProduct`),
  CONSTRAINT `FK_97121122812469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9712112284584665A` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]category_products`
--

LOCK TABLES `[[dbprefix]]category_products` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]category_products` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]category_products` VALUES (1,3,7,0,0),(2,3,12,0,0),(3,3,13,0,0),(4,3,14,0,0),(5,3,15,0,0),(6,3,16,0,0),(7,3,17,0,0),(8,3,18,0,0),(9,3,19,0,0),(10,3,20,0,0),(11,4,2,0,0),(12,4,3,0,0),(13,4,4,0,0),(14,4,5,0,0),(15,4,6,0,0),(16,4,8,0,0),(17,4,9,0,0),(18,4,10,0,0),(19,4,11,0,0),(20,5,21,0,0),(21,5,22,0,0),(22,5,23,0,0),(23,5,24,0,0),(24,5,25,0,0),(25,5,26,0,0),(26,7,36,0,0),(27,7,37,0,0),(28,7,38,0,0),(29,7,39,0,0),(30,7,40,0,0),(31,7,41,0,0),(32,8,50,0,0),(33,8,47,0,0),(34,8,43,0,0),(35,8,49,0,0),(36,8,48,0,0),(37,8,42,0,0),(38,8,45,0,0),(39,8,44,0,0),(40,8,46,0,0),(41,6,36,0,0),(42,6,37,0,0),(43,6,38,0,0),(44,6,39,0,0),(45,6,42,0,0),(46,6,44,0,0),(47,6,45,0,0),(48,6,46,0,0),(49,6,47,0,0),(50,6,48,0,0),(51,6,49,0,0),(52,6,50,0,0),(53,10,33,0,0),(54,10,32,0,0),(55,10,30,0,0),(56,11,27,0,0),(57,11,28,0,0),(58,11,29,0,0),(59,12,31,0,0),(60,12,34,0,0),(61,12,35,0,0),(62,9,28,0,0),(63,9,30,0,0),(64,9,31,0,0),(65,9,33,0,0),(66,9,34,0,0),(67,9,35,0,0);
/*!40000 ALTER TABLE `[[dbprefix]]category_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]category_quick_flags`
--

DROP TABLE IF EXISTS `[[dbprefix]]category_quick_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]category_quick_flags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `subcategories_count_all` int(11) NOT NULL,
  `subcategories_count_enabled` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_5BA9C50312469DE2` (`category_id`),
  CONSTRAINT `FK_95BA9C50312469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]category_quick_flags`
--

LOCK TABLES `[[dbprefix]]category_quick_flags` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]category_quick_flags` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]category_quick_flags` VALUES (1,1,3,3),(2,2,3,3),(3,3,0,0),(4,4,0,0),(5,5,0,0),(6,6,2,2),(7,7,0,0),(8,8,0,0),(9,9,3,3),(10,10,0,0),(11,11,0,0),(12,12,0,0);
/*!40000 ALTER TABLE `[[dbprefix]]category_quick_flags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]category_sale_discounts`
--

DROP TABLE IF EXISTS `[[dbprefix]]category_sale_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]category_sale_discounts` (
  `sale_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`sale_id`,`category_id`),
  KEY `IDX_91C49A76B4A7E4868` (`sale_id`),
  KEY `IDX_91C49A76B12469DE2` (`category_id`),
  CONSTRAINT `FK_91C49A76B12469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_91C49A76B4A7E4868` FOREIGN KEY (`sale_id`) REFERENCES `[[dbprefix]]sale_discounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]category_sale_discounts`
--

LOCK TABLES `[[dbprefix]]category_sale_discounts` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]category_sale_discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]category_sale_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]category_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]category_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]category_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `ogMeta` longtext COLLATE utf8mb4_unicode_ci,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metaTags` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metaDesc` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metaTitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_99ED79EA5BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]category_translations`
--

LOCK TABLES `[[dbprefix]]category_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]category_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]category_translations` VALUES (1,1,'','Catalog','<h1>Welcome to X-Cart Demo Store!</h1><p>It illustrates operation and features of X-Cart - all-in-one eCommerce solution for swift and easy launch of a professional online store. Orders placed here cannot be fulfilled as all the sample products listed in this store are for demonstration and testing purposes only.</p>','','','','en'),(2,2,'','Fashion','','','','','en'),(3,3,'','Clothing','','','','','en'),(4,4,'','Shoes','','','','','en'),(5,5,'','Accessories','','','','','en'),(6,6,'','Beauty & Health','','','','','en'),(7,7,'','Cosmetics','','','','','en'),(8,8,'','Healthy Food & Snacks','','','','','en'),(9,9,'','Electronics','','','','','en'),(10,10,'','Smart watches','','','','','en'),(11,11,'','Mobile phones','','','','','en'),(12,12,'','Other','','','','','en');
/*!40000 ALTER TABLE `[[dbprefix]]category_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]clean_urls`
--

DROP TABLE IF EXISTS `[[dbprefix]]clean_urls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]clean_urls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sale_discount_id` int(10) unsigned DEFAULT NULL,
  `page_id` int(10) unsigned DEFAULT NULL,
  `news_message_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `cleanURL` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9F25425453D30B072` (`sale_discount_id`),
  KEY `IDX_9F2542545C4663E4` (`page_id`),
  KEY `IDX_9F2542545BF05C450` (`news_message_id`),
  KEY `IDX_9F25425454584665A` (`product_id`),
  KEY `IDX_9F254254512469DE2` (`category_id`),
  KEY `cleanURL` (`cleanURL`),
  CONSTRAINT `FK_9F254254512469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9F25425453D30B072` FOREIGN KEY (`sale_discount_id`) REFERENCES `[[dbprefix]]sale_discounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9F25425454584665A` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9F2542545BF05C450` FOREIGN KEY (`news_message_id`) REFERENCES `[[dbprefix]]news` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9F2542545C4663E4` FOREIGN KEY (`page_id`) REFERENCES `[[dbprefix]]pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]clean_urls`
--

LOCK TABLES `[[dbprefix]]clean_urls` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]clean_urls` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]clean_urls` VALUES (1,NULL,1,NULL,NULL,NULL,'terms-and-conditions'),(2,NULL,2,NULL,NULL,NULL,'shipping'),(3,NULL,NULL,NULL,1,NULL,'timberland-45th-anniversary'),(4,NULL,NULL,NULL,2,NULL,'high-top-trainers-in-red-black-and-white'),(5,NULL,NULL,NULL,3,NULL,'beige-sneakers'),(6,NULL,NULL,NULL,4,NULL,'platform-brogue-trim-leather-oxfords-in-white'),(7,NULL,NULL,NULL,5,NULL,'grey-knitted-trainers'),(8,NULL,NULL,NULL,6,NULL,'lace-up-boots-in-light-brown'),(9,NULL,NULL,NULL,7,NULL,'boyfriend-t-shirt-with-chest-logo'),(10,NULL,NULL,NULL,8,NULL,'pink-sneakers-with-white-soles'),(11,NULL,NULL,NULL,9,NULL,'white-lace-up-mesh-trainers'),(12,NULL,NULL,NULL,10,NULL,'caged-cutout-sandals-in-gold'),(13,NULL,NULL,NULL,11,NULL,'green-flat-slingback-sandals'),(14,NULL,NULL,NULL,12,NULL,'waist-tie-dress-in-blue-and-white-stripe'),(15,NULL,NULL,NULL,13,NULL,'ultimate-t-shirt-with-crew-neck-in-red'),(16,NULL,NULL,NULL,14,NULL,'multicolored-dress-with-balloon-sleeves'),(17,NULL,NULL,NULL,15,NULL,'tall-pleated-midi-skirt-in-check'),(18,NULL,NULL,NULL,16,NULL,'sleeved-mini-dress-in-color-block'),(19,NULL,NULL,NULL,17,NULL,'tall-slim-fit-t-shirt-in-white'),(20,NULL,NULL,NULL,18,NULL,'skinny-western-denim-jacket-in-light-blue-wash'),(21,NULL,NULL,NULL,19,NULL,'oversized-hoodie-in-grey'),(22,NULL,NULL,NULL,20,NULL,'hooded-anorak-jacket-in-black'),(23,NULL,NULL,NULL,21,NULL,'leather-mini-tote-bag-with-rose-and-girl-print-in-red'),(24,NULL,NULL,NULL,22,NULL,'mesh-strap-watch-in-gold'),(25,NULL,NULL,NULL,23,NULL,'square-glasses-in-black-with-clear-lens'),(26,NULL,NULL,NULL,24,NULL,'chain-drop-earrings-in-gold-tone'),(27,NULL,NULL,NULL,25,NULL,'rooster-mug-in-white'),(28,NULL,NULL,NULL,26,NULL,'festival-braslet-pack-in-gold-tone'),(29,NULL,NULL,NULL,27,NULL,'samsung-galaxy-s6-edge-plus-4g-lte-with-32gb-memory-cell-phone'),(30,NULL,NULL,NULL,28,NULL,'apple-iphone-8-plus-64gb'),(31,NULL,NULL,NULL,29,NULL,'apple-iphone-x'),(32,NULL,NULL,NULL,30,NULL,'apple-watch-series-3-gps-38mm'),(33,NULL,NULL,NULL,31,NULL,'google-home-mini'),(34,NULL,NULL,NULL,32,NULL,'fitness-tracker-smart-watch'),(35,NULL,NULL,NULL,33,NULL,'bluetooth-smartwatch-with-touch-screen-and-fitness-tracker'),(36,NULL,NULL,NULL,34,NULL,'aster-i39-headphones-with-microphone'),(37,NULL,NULL,NULL,35,NULL,'apple-airpods'),(38,NULL,NULL,NULL,36,NULL,'cocooil-body-oil'),(39,NULL,NULL,NULL,37,NULL,'maui-moisture'),(40,NULL,NULL,NULL,38,NULL,'barth-body-oil'),(41,NULL,NULL,NULL,39,NULL,'facial-spray'),(42,NULL,NULL,NULL,40,NULL,'red-dior'),(43,NULL,NULL,NULL,41,NULL,'pink-unicorn-makeup-brushes'),(44,NULL,NULL,NULL,42,NULL,'perfect-snacks'),(45,NULL,NULL,NULL,43,NULL,'blue-and-green-matcha'),(46,NULL,NULL,NULL,44,NULL,'chia-seed'),(47,NULL,NULL,NULL,45,NULL,'probiotic-and-omega-3-6-9-supplement'),(48,NULL,NULL,NULL,46,NULL,'tea-infused-sparkling-water'),(49,NULL,NULL,NULL,47,NULL,'cinnamon-sticks'),(50,NULL,NULL,NULL,48,NULL,'peanut-butter'),(51,NULL,NULL,NULL,49,NULL,'sweet-hazelnut-and-chocolate-natural-flavouring'),(52,NULL,NULL,NULL,50,NULL,'dose-juice'),(53,NULL,NULL,NULL,NULL,2,'fashion'),(54,NULL,NULL,NULL,NULL,3,'clothing'),(55,NULL,NULL,NULL,NULL,4,'shoes'),(56,NULL,NULL,NULL,NULL,5,'accessories'),(57,NULL,NULL,NULL,NULL,6,'beauty-and-health'),(58,NULL,NULL,NULL,NULL,7,'cosmetics'),(59,NULL,NULL,NULL,NULL,8,'healthy-food-and-snacks'),(60,NULL,NULL,NULL,NULL,9,'electronics'),(61,NULL,NULL,NULL,NULL,10,'smart-watches'),(62,NULL,NULL,NULL,NULL,11,'mobile-phones'),(63,NULL,NULL,NULL,NULL,12,'other');
/*!40000 ALTER TABLE `[[dbprefix]]clean_urls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]config`
--

DROP TABLE IF EXISTS `[[dbprefix]]config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]config` (
  `config_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `orderby` int(11) NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `widgetParameters` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `nc` (`name`,`category`),
  KEY `orderby` (`orderby`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=457 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]config`
--

LOCK TABLES `[[dbprefix]]config` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]config` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]config` VALUES (1,'admin_security','Security','checkbox',1000,'N','N;'),(2,'anonymous','Shipping','separator',3000,'','N;'),(3,'anonymous_address','Shipping','text',4000,'','N;'),(4,'anonymous_country','Shipping','country',5000,'US','N;'),(5,'anonymous_state','Shipping','state',6000,'562','a:1:{s:9:\"selectOne\";b:1;}'),(6,'anonymous_custom_state','Shipping','text',7000,'','N;'),(7,'anonymous_city','Shipping','text',8000,'Los Angeles','N;'),(8,'anonymous_zipcode','Shipping','text',9000,'90001','N;'),(9,'anonymous_address_type','Shipping','\\XLite\\View\\FormField\\Select\\AddressType',10000,'R','N;'),(10,'aggregate_css','Performance','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',2000,'Y','N;'),(11,'aggregate_js','Performance','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',3000,'Y','N;'),(12,'use_view_cache','Performance','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',4000,'Y','N;'),(13,'use_dynamic_image_resizing','Performance','hidden',5000,'','N;'),(14,'use_lazy_load','Performance','hidden',5200,'','N;'),(15,'unsharp_mask_filter_on_resize','Performance','hidden',5100,'','N;'),(16,'layout_type','Layout','XLite\\View\\FormField\\Select\\LayoutType',1000,'left','N;'),(17,'layout_type_home','Layout','XLite\\View\\FormField\\Select\\LayoutType',1010,'one','N;'),(18,'cli_key','Security','',11000,'','N;'),(19,'company_address','Company','separator',38500,'','N;'),(20,'company_contacts','Company','separator',45500,'','N;'),(21,'company_fax','Company','XLite\\View\\FormField\\Input\\Text\\Phone',42000,'','N;'),(22,'company_identity','Company','separator',35000,'','N;'),(23,'company_name','Company','text',36000,'*Your company name*','N;'),(24,'company_website','Company','text',37000,'','N;'),(25,'terms_url','General','text',38000,'terms-and-conditions','N;'),(26,'customer_presentation','General','separator',20000,'','N;'),(27,'customer_security','Security','checkbox',100,'N','N;'),(28,'date_format','Units','XLite\\View\\FormField\\Select\\DateFormat',66000,'%b %e, %Y','N;'),(29,'week_start','Units','XLite\\View\\FormField\\Select\\DayOfWeek',67000,'sun','N;'),(30,'csv_delim','Units','XLite\\View\\FormField\\Select\\CSVDelimiter',70000,',','N;'),(31,'export_import_charset','Units','XLite\\View\\FormField\\Select\\IconvCharset',72500,'UTF-8','N;'),(32,'export_product_attrs','Units','XLite\\View\\FormField\\Select\\ExportAttrs',75000,'global','N;'),(33,'default_language','General','',33000,'en','N;'),(34,'default_admin_language','General','',33500,'en','N;'),(35,'default_offline_payment','Payments','text',0,'','N;'),(36,'default_purchase_limit','General','XLite\\View\\FormField\\Input\\Text\\Integer',29300,'9999','a:1:{s:3:\"min\";i:1;}'),(37,'default_select_payment','Payments','text',0,'','N;'),(38,'display_check_number','General','checkbox',21500,'Y','N;'),(39,'show_out_of_stock_products','General','XLite\\View\\FormField\\Select\\ShowOutOfStockProducts',20000,'directLink','N;'),(40,'default_prod_display_mode','General','XLite\\View\\FormField\\Select\\DefaultDisplayModeForProductsList',25000,'grid','N;'),(41,'license','License','text',0,'','N;'),(42,'location_address','Company','text',39000,'*Your company address*','N;'),(43,'location_country','Company','country',40000,'US','a:2:{s:9:\"selectOne\";b:0;s:3:\"all\";b:1;}'),(44,'location_state','Company','state',41000,'591','N;'),(45,'location_custom_state','Company','text',41500,'','N;'),(46,'location_city','Company','text',42000,'New York','N;'),(47,'location_zipcode','Company','text',43000,'10001','N;'),(48,'origin_use_company','Company','checkbox',38000,'1','N;'),(49,'origin_address','Company','text',39000,'','N;'),(50,'origin_country','Company','country',40000,'US','a:2:{s:9:\"selectOne\";b:0;s:3:\"all\";b:1;}'),(51,'origin_state','Company','state',41000,'','N;'),(52,'origin_custom_state','Company','text',41500,'','N;'),(53,'origin_city','Company','text',42000,'','N;'),(54,'origin_zipcode','Company','text',43000,'','N;'),(55,'company_phone','Company','text',44000,'(555) 555-5555','N;'),(56,'login_lifetime','General','XLite\\View\\FormField\\Input\\Text\\Integer',45000,'3','a:1:{s:3:\"min\";i:1;}'),(57,'maximal_order_amount','General','XLite\\View\\FormField\\Input\\Text\\FloatInput',29000,'99999','a:1:{s:3:\"min\";i:1;}'),(58,'minimal_order_amount','General','XLite\\View\\FormField\\Input\\Text\\FloatInput',28000,'0','a:1:{s:3:\"min\";i:0;}'),(59,'order_number_counter','General','XLite\\View\\FormField\\Input\\Text\\Integer',39000,'6','N;'),(60,'cart_ttl','General','XLite\\View\\FormField\\Input\\Text\\Integer',39500,'7','N;'),(61,'internal_cron_enabled','General','checkbox',39800,'Y','N;'),(62,'orders_department','Company','XLite\\View\\FormField\\Select\\MultipleEmails',48000,'a:1:{i:0;s:[[email_length]]:\"[[admin_email]]\";}','N;'),(63,'products_per_page','General','XLite\\View\\FormField\\Input\\Text\\Integer',25000,'12','a:1:{s:3:\"min\";i:1;}'),(64,'products_per_page_max','General','XLite\\View\\FormField\\Input\\Text\\Integer',25000,'100','a:1:{s:3:\"min\";i:1;}'),(65,'force_choose_product_options','General','XLite\\View\\FormField\\Select\\ForceProductOptions',29900,'','N;'),(66,'redirect_to_cart','General','checkbox',30000,'N','N;'),(67,'shop_closed','Internal','checkbox',11000,'N','N;'),(68,'shop_currency','General','',60500,'840','N;'),(69,'trailing_zeroes','General','',60500,'0','N;'),(70,'site_administrator','Company','XLite\\View\\FormField\\Select\\MultipleEmails',46000,'a:1:{i:0;s:[[email_length]]:\"[[admin_email]]\";}','N;'),(71,'smtp_password','Email','XLite\\View\\FormField\\Input\\PasswordWithValue',16000,'','N;'),(72,'smtp_security','Email','XLite\\View\\FormField\\Select\\SMTPSecurity',17000,'no','N;'),(73,'smtp_server_port','Email','XLite\\View\\FormField\\Input\\Text\\Integer',13000,'25','a:2:{s:3:\"min\";i:0;s:3:\"max\";i:65535;}'),(74,'smtp_server_url','Email','text',12000,'','N;'),(75,'smtp_username','Email','text',15000,'','N;'),(76,'start_year','Company','XLite\\View\\FormField\\Input\\Text\\PastYear',38000,'2020','N;'),(77,'subcategories_look','General','XLite\\View\\FormField\\Select\\SubcategoriesLook',22000,'icons','N;'),(78,'default_products_sort_order','General','XLite\\View\\FormField\\Select\\DefaultProductSortOrder',22500,'default','N;'),(79,'default_search_sort_order','General','XLite\\View\\FormField\\Select\\DefaultProductSortOrder',22501,'default','N;'),(80,'support_department','Company','XLite\\View\\FormField\\Select\\MultipleEmails',49000,'a:1:{i:0;s:[[email_length]]:\"[[admin_email]]\";}','N;'),(81,'time_format','Units','XLite\\View\\FormField\\Select\\TimeFormat',67000,'%H:%M','N;'),(82,'time_zone','Units','XLite\\View\\FormField\\Select\\TimeZone',68000,'America/New_York','N;'),(83,'users_department','Company','XLite\\View\\FormField\\Select\\MultipleEmails',47000,'a:1:{i:0;s:[[email_length]]:\"[[admin_email]]\";}','N;'),(84,'mail_from_type','Email','XLite\\View\\FormField\\Select\\EmailFrom',10500,'contact','N;'),(85,'mail_from_manual','Email','\\XLite\\View\\FormField\\Input\\Text\\EmailFromManual',10600,'','a:1:{s:8:\"required\";b:1;}'),(86,'use_smtp','Email','\\XLite\\View\\FormField\\Input\\Checkbox\\UseSmtp',11000,'','N;'),(87,'use_smtp_auth','Email','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',14000,'','N;'),(88,'version','Version','',0,'5.4.1.17','N;'),(89,'weight_symbol','Units','text',62000,'lbs','N;'),(90,'weight_unit','Units','XLite\\View\\FormField\\Select\\WeightUnit',61000,'lbs','N;'),(91,'weight_trailing_zeroes','Units','checkbox',62100,'Y','N;'),(92,'weight_format','Units','XLite\\View\\FormField\\Select\\FloatFormat',62200,'|.','N;'),(93,'percent_format','Units','XLite\\View\\FormField\\Select\\PercentFormat',62300,'%s%%','N;'),(94,'dim_symbol','Units','text',62500,'in','N;'),(95,'dim_unit','Units','XLite\\View\\FormField\\Select\\DimUnit',62300,'in','N;'),(96,'curl_sep','Environment','separator',10000,'','N;'),(97,'curl_cainfo','Environment','text',11000,'','N;'),(98,'curl_capath','Environment','text',12000,'','N;'),(99,'force_login_before_checkout','General','checkbox',30500,'Y','N;'),(100,'enable_add2cart_button_grid','General','checkbox',30100,'Y','N;'),(101,'requires_shipping_default','General','',0,'1','N;'),(102,'clean_url_flag','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\CleanUrl',1000,'1','N;'),(103,'general_options','CleanURL','separator',10000,'','N;'),(104,'default_site_title','CleanURL','XLite\\View\\FormField\\Label\\TranslationLabel',11000,'default-site-title','N;'),(105,'default_site_meta_description','CleanURL','XLite\\View\\FormField\\Label\\TranslationLabel',12000,'default-meta-description','N;'),(106,'default_site_meta_keywords','CleanURL','XLite\\View\\FormField\\Label\\TranslationLabel',13000,'default-meta-keywords','N;'),(107,'home_page_title_and_meta','CleanURL','XLite\\View\\FormField\\CleanUrls\\FrontPage',14000,'','N;'),(108,'page_404','CleanURL','XLite\\View\\FormField\\CleanUrls\\Page404',14500,'','N;'),(109,'regular_text_404','CleanURL','XLite\\View\\FormField\\Label\\TranslationLabelWithHtmlCode',14501,'default-404-text','N;'),(110,'show_email_404','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',14502,'1','N;'),(111,'page_title_format','CleanURL','XLite\\View\\FormField\\CleanUrls\\PageTitleFormat',15000,'','N;'),(112,'company_name','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',15100,'1','N;'),(113,'parent_category_path','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',15200,'1','N;'),(114,'object_name','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\OnOffReadOnly',15300,'1','N;'),(115,'object_name_in_page_title_order','CleanURL','XLite\\View\\FormField\\Input\\Checkbox\\FirstLast',16000,'0','N;'),(116,'clean_urls_about','CleanURL','separator',20000,'','N;'),(117,'about_widget','CleanURL','XLite\\View\\FormField\\CleanUrls\\AboutCleanUrls',21000,'','N;'),(118,'allow_membership_request','General','checkbox',39900,'N','N;'),(119,'upgrade_wave_sep','Environment','separator',20000,'','N;'),(120,'upgrade_wave','Environment','XLite\\View\\FormField\\Select\\UpgradeWave',21000,'','N;'),(121,'fields_settings_section','Email','separator',1000,'','N;'),(122,'reply_to_customer','Email','\\XLite\\View\\FormField\\Label\\ReplyToCustomer',10700,'','N;'),(123,'reply_to_admin','Email','\\XLite\\View\\FormField\\Label\\ReplyToAdmin',10800,'','N;'),(124,'smtp_section','Email','\\XLite\\View\\FormField\\Separator\\Regular',10950,'','N;'),(125,'enabled','BannerRotation','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',10000,'1','N;'),(126,'interval','BannerRotation','XLite\\View\\FormField\\Input\\Text\\FloatInput',30000,'5','N;'),(127,'attach_pdf_invoices','NotificationAttachments','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',10000,'0','N;'),(128,'contact_us_comment','Company','XLite\\View\\FormField\\ContactUsComment',49500,'','N;'),(129,'deliverability_check','Company','XLite\\View\\FormField\\DeliverabilityCheck',49400,'','N;'),(130,'livechat_ad','Company','XLite\\View\\FormField\\LiveChatAd',49300,'','N;'),(131,'cloud_domain','Company','XLite\\View\\FormField\\CloudDomain',36900,'','N;'),(132,'test_mode','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',10,'1','N;'),(133,'api_key','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Text',20,'','N;'),(134,'packageSettingsSeparator','CDev\\AustraliaPost','separator',100,'','N;'),(135,'package_type','CDev\\AustraliaPost','',0,'Parcel','N;'),(136,'package_box_type','CDev\\AustraliaPost','XLite\\Module\\CDev\\AustraliaPost\\View\\FormField\\PackageBoxType',110,'AUS_PARCEL_TYPE_BOXED_OTH','N;'),(137,'dimensions','CDev\\AustraliaPost','serialized',120,'a:3:{i:0;i:10;i:1;i:10;i:2;i:10;}','N;'),(138,'additionalSettingsSeparator','CDev\\AustraliaPost','separator',200,'','N;'),(139,'service_option','CDev\\AustraliaPost','XLite\\Module\\CDev\\AustraliaPost\\View\\FormField\\ServiceOption',210,'AUS_SERVICE_OPTION_STANDARD','N;'),(140,'extra_cover','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',220,'','N;'),(141,'extra_cover_value','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Text\\Price',230,'0','N;'),(142,'currency_rate','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',240,'1','N;'),(143,'enable_new_methods','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',250,'1','N;'),(144,'debug_enabled','CDev\\AustraliaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',260,'1','N;'),(145,'max_weight','CDev\\AustraliaPost','',0,'20','N;'),(146,'number_of_bestsellers','CDev\\Bestsellers','XLite\\View\\FormField\\Input\\Text\\Integer',115,'4','a:1:{s:3:\"min\";i:1;}'),(147,'enable_form','CDev\\ContactUs','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',100,'1','N;'),(148,'email','CDev\\ContactUs','XLite\\View\\FormField\\Input\\Text\\Email',200,'','N;'),(149,'showEmail','CDev\\ContactUs','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',300,'1','N;'),(150,'contact_us_sep_1','CDev\\ContactUs','separator',1000,'','N;'),(151,'recaptcha_version','CDev\\ContactUs','\\XLite\\Module\\CDev\\ContactUs\\View\\FormField\\VersionSwitch',1050,'2','N;'),(152,'recaptcha_public_key','CDev\\ContactUs','text',1100,'','N;'),(153,'recaptcha_private_key','CDev\\ContactUs','text',1200,'','N;'),(154,'ttl','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text\\Integer',100,'3','a:1:{s:3:\"min\";i:0;}'),(155,'attempts_limit','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text\\Integer',200,'3','a:1:{s:3:\"min\";i:0;}'),(156,'enable_history','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',300,'1','N;'),(157,'esd_fullfilment','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',400,'','N;'),(158,'approve_before_download','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',500,'','N;'),(159,'sendfile_info','CDev\\Egoods','XLite\\Module\\CDev\\Egoods\\View\\FormField\\Label\\Sendfile',600,'','N;'),(160,'amazon_separator','CDev\\Egoods','separator',1000,'0','N;'),(161,'enable_signed_urls','CDev\\Egoods','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',1100,'0','N;'),(162,'storage_type','CDev\\Egoods','XLite\\Module\\CDev\\Egoods\\View\\FormField\\StorageType',1200,'as3','N;'),(163,'amazon_access','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text',1300,'','N;'),(164,'amazon_secret','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text',1400,'','N;'),(165,'bucket','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text',1500,'','N;'),(166,'bucket_region','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text',1600,'us-east-1','N;'),(167,'do_endpoint','CDev\\Egoods','XLite\\View\\FormField\\Input\\Text',1700,'','N;'),(168,'featured_products_look','CDev\\FeaturedProducts','XLite\\Module\\CDev\\FeaturedProducts\\View\\FormField\\FeaturedProductsLook',10,'grid','N;'),(169,'key','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(170,'password','CDev\\FedEx','XLite\\View\\FormField\\Input\\PasswordWithValue',20,'','N;'),(171,'account_number','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text',30,'','N;'),(172,'meter_number','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text',40,'','N;'),(173,'test_mode','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',50,'','N;'),(174,'debug_enabled','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',60,'','N;'),(175,'additionalSettingsSeparator','CDev\\FedEx','separator',100,'','N;'),(176,'carrierTypesSeparator','CDev\\FedEx','separator',200,'','N;'),(177,'fdxe','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',210,'','N;'),(178,'fdxg','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',220,'','N;'),(179,'fxsp','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',230,'','N;'),(180,'fxsp_hub_id','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\HubId',235,'','N;'),(181,'fxsp_indicia','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\Indicia',240,'','N;'),(182,'rate_request_type','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\RateRequestType',300,'NONE','N;'),(183,'packaging','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\Packaging',310,'','N;'),(184,'dropoff_type','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\DropOffType',320,'','N;'),(185,'ship_date','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\ShipDate',330,'0','N;'),(186,'currency_code','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\CurrencyCode',340,'0','N;'),(187,'currency_rate','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text\\FloatInput',350,'1','N;'),(188,'dimensions','CDev\\FedEx','serialized',360,'a:3:{i:0;i:10;i:1;i:10;i:2;i:10;}','N;'),(189,'max_weight','CDev\\FedEx','XLite\\View\\FormField\\Input\\Text\\FloatInput',370,'70','N;'),(190,'specialServicesSeparator','CDev\\FedEx','separator',400,'','N;'),(191,'dg_accessibility','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\DangerousGoodsAccessibility',410,'','N;'),(192,'signature','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\Signature',420,'','N;'),(193,'shippingRefundsSeparator','CDev\\FedEx','separator',450,'','N;'),(194,'lbs71Info','CDev\\FedEx','XLite\\View\\FormField\\Label',460,'As a FedEx user, you are entitled to receive shipping refunds usually left unclaimed with default FedEx service ($2B/year globally)','a:1:{s:9:\"fieldOnly\";b:1;}'),(195,'cacheOnDeliverySeparator','CDev\\FedEx','separator',500,'','N;'),(196,'cod_type','CDev\\FedEx','XLite\\Module\\CDev\\FedEx\\View\\FormField\\Select\\CODType',510,'ANY','N;'),(197,'advancedOptionsSeparator','CDev\\FedEx','separator',600,'','N;'),(198,'opt_saturday_pickup','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',610,'','N;'),(199,'opt_residential_delivery','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',620,'','N;'),(200,'send_insured_value','CDev\\FedEx','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',630,'1','N;'),(201,'gosocial_sep_1','CDev\\GoSocial','separator',5000,'','N;'),(202,'fb_app_id','CDev\\GoSocial','text',5100,'','N;'),(203,'fb_app_namespace','CDev\\GoSocial','text',5200,'','N;'),(204,'fb_admins','CDev\\GoSocial','text',5300,'','N;'),(205,'gosocial_sep_6','CDev\\GoSocial','separator',1000,'','N;'),(206,'fb_share_use','CDev\\GoSocial','checkbox',1050,'1','N;'),(207,'gosocial_sep_2','CDev\\GoSocial','separator',1300,'','N;'),(208,'like_settings_warning','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Label\\LikeSettingsWarning',1325,'1','N;'),(209,'fb_like_use','CDev\\GoSocial','checkbox',1350,'','N;'),(210,'fb_like_layout','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBLayoutStyle',1400,'button_count','N;'),(211,'fb_like_show_faces','CDev\\GoSocial','checkbox',1420,'1','N;'),(212,'fb_like_verb','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBVerbDisplay',1440,'like','N;'),(213,'fb_like_colorscheme','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBLikeColorScheme',1460,'light','N;'),(214,'gosocial_sep_21','CDev\\GoSocial','separator',1500,'','N;'),(215,'fb_comments_use','CDev\\GoSocial','checkbox',1600,'1','N;'),(216,'fb_comments_num_posts','CDev\\GoSocial','XLite\\View\\FormField\\Input\\Text\\Integer',1700,'8','a:1:{s:3:\"min\";i:1;}'),(217,'fb_comments_colorscheme','CDev\\GoSocial','XLite\\Module\\CDev\\GoSocial\\View\\FormField\\Select\\FBCommentsColorScheme',1750,'light','N;'),(218,'gosocial_sep_3','CDev\\GoSocial','separator',2000,'','N;'),(219,'tweet_use','CDev\\GoSocial','checkbox',2050,'1','N;'),(220,'tweet_show_count','CDev\\GoSocial','checkbox',2100,'1','N;'),(221,'tweet_via','CDev\\GoSocial','text',2200,'','N;'),(222,'tweet_recommend','CDev\\GoSocial','text',2300,'','N;'),(223,'tweet_hashtag','CDev\\GoSocial','text',2300,'','N;'),(224,'gosocial_sep_5','CDev\\GoSocial','separator',4000,'','N;'),(225,'pinterest_use','CDev\\GoSocial','checkbox',4050,'1','N;'),(226,'ga_account','CDev\\GoogleAnalytics','text',100,'','N;'),(227,'ga_tracking_type','CDev\\GoogleAnalytics','XLite\\Module\\CDev\\GoogleAnalytics\\View\\FormField\\Select\\TrackingType',200,'1','N;'),(228,'ga_code_version','CDev\\GoogleAnalytics','XLite\\Module\\CDev\\GoogleAnalytics\\View\\FormField\\Select\\CodeVersion',300,'U','N;'),(229,'ecommerce_enabled','CDev\\GoogleAnalytics','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',400,'1','N;'),(230,'purchase_only_on_paid','CDev\\GoogleAnalytics','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',450,'1','N;'),(231,'debug_mode','CDev\\GoogleAnalytics','XLite\\View\\FormField\\Input\\Checkbox\\OnOff',500,'','N;'),(232,'esd_fullfilment','CDev\\PINCodes','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',400,'','N;'),(233,'approve_before_download','CDev\\PINCodes','XLite\\View\\FormField\\Input\\Checkbox\\YesNo',500,'','N;'),(234,'show_admin_welcome','CDev\\Paypal','checkbox',100,'Y','N;'),(235,'paypalLoginOptions','CDev\\Paypal','\\XLite\\Module\\CDev\\Paypal\\View\\FormField\\Instructions',200,'','N;'),(236,'loginRedirectURLProtocol','CDev\\Paypal','XLite\\Module\\CDev\\Paypal\\View\\FormField\\Select\\Protocol',300,'http','N;'),(237,'loginClientId','CDev\\Paypal','text',400,'','N;'),(238,'loginClientSecret','CDev\\Paypal','text',500,'','N;'),(239,'loginMode','CDev\\Paypal','XLite\\View\\FormField\\Select\\TestLiveMode',600,'test','N;'),(240,'loginScopes','CDev\\Paypal','XLite\\Module\\CDev\\Paypal\\View\\FormField\\Select\\Scopes',700,'a:4:{s:6:\"openid\";s:6:\"openid\";s:5:\"email\";s:5:\"email\";s:7:\"profile\";s:7:\"profile\";s:7:\"address\";s:7:\"address\";}','N;'),(241,'sep_product_advisor_na','CDev\\ProductAdvisor','separator',10,'','N;'),(242,'na_enabled','CDev\\ProductAdvisor','checkbox',20,'Y','N;'),(243,'na_max_days','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',30,'30','a:1:{s:3:\"min\";i:0;}'),(244,'na_max_count_in_full_list','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',40,'72','a:1:{s:3:\"min\";i:0;}'),(245,'na_mark_with_label','CDev\\ProductAdvisor','XLite\\Module\\CDev\\ProductAdvisor\\View\\FormField\\Select\\MarkProducts',50,'C','N;'),(246,'na_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',80,'4','a:1:{s:3:\"min\";i:0;}'),(247,'na_from_current_category','CDev\\ProductAdvisor','checkbox',90,'N','N;'),(248,'sep_product_advisor_cs','CDev\\ProductAdvisor','separator',1000,'','N;'),(249,'cs_enabled','CDev\\ProductAdvisor','checkbox',1010,'Y','N;'),(250,'cs_mark_with_label','CDev\\ProductAdvisor','XLite\\Module\\CDev\\ProductAdvisor\\View\\FormField\\Select\\MarkProducts',1020,'CP','N;'),(251,'cs_from_current_category','CDev\\ProductAdvisor','checkbox',1050,'N','N;'),(252,'cs_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',1080,'4','a:1:{s:3:\"min\";i:0;}'),(253,'sep_product_advisor_rv','CDev\\ProductAdvisor','separator',2000,'','N;'),(254,'rv_enabled','CDev\\ProductAdvisor','checkbox',2010,'Y','N;'),(255,'rv_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',2020,'10','a:1:{s:3:\"min\";i:0;}'),(256,'sep_product_advisor_cbb','CDev\\ProductAdvisor','separator',3000,'','N;'),(257,'cbb_enabled','CDev\\ProductAdvisor','checkbox',3010,'Y','N;'),(258,'cbb_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',3020,'5','a:1:{s:3:\"min\";i:0;}'),(259,'sep_product_advisor_cvb','CDev\\ProductAdvisor','separator',4000,'','N;'),(260,'cvb_enabled','CDev\\ProductAdvisor','checkbox',4010,'Y','N;'),(261,'cvb_max_count_in_block','CDev\\ProductAdvisor','XLite\\View\\FormField\\Input\\Text\\Integer',4020,'5','a:1:{s:3:\"min\";i:0;}'),(262,'sale_enabled','CDev\\Sale','checkbox',20,'Y','N;'),(263,'sale_in_current_category','CDev\\Sale','checkbox',30,'Y','N;'),(264,'sale_max_count_in_block','CDev\\Sale','text',80,'4','N;'),(265,'way_to_combine_discounts','CDev\\Sale','\\XLite\\Module\\CDev\\Sale\\View\\FormField\\Select\\CombineDiscounts',100,'apply_max','N;'),(266,'show_links_in_category_menu','CDev\\Sale','\\XLite\\Module\\CDev\\Sale\\View\\FormField\\Select\\ShowLinksInCategoryMenu',110,'under_categories','N;'),(267,'allow_vendors_edit_discounts','CDev\\Sale','checkbox',120,'Y','N;'),(268,'ignore_memberships','CDev\\SalesTax','checkbox',150,'Y','N;'),(269,'addressType','CDev\\SalesTax','\\XLite\\Module\\CDev\\SalesTax\\View\\FormField\\AddressType',160,'shipping','N;'),(270,'taxableBase','CDev\\SalesTax','\\XLite\\Module\\CDev\\SalesTax\\View\\FormField\\TaxableBase',170,'DST+SH','N;'),(271,'logo','CDev\\SimpleCMS','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Input\\Logo',100,'','N;'),(272,'favicon','CDev\\SimpleCMS','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Input\\Favicon',200,'','N;'),(273,'appleIcon','CDev\\SimpleCMS','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Input\\AppleIcon',250,'','N;'),(274,'page_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\SimpleCMS\\View\\FormField\\Select\\ChangeFrequency',400,'daily','N;'),(275,'page_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',800,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(276,'show_default_menu','CDev\\SimpleCMS','checkbox',300,'Y','N;'),(277,'logo_alt','CDev\\SimpleCMS','hidden',0,'','N;'),(278,'dataProvider','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\DataProvider',2,'pitneyBowes','N;'),(279,'pbEmailId','CDev\\USPS','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(280,'pbShipperId','CDev\\USPS','',10,'','N;'),(281,'userid','CDev\\USPS','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(282,'server_url','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\URL',20,'https://stg-secure.shippingapis.com/ShippingApi.dll','N;'),(283,'additionalSettingsSeparator','CDev\\USPS','separator',100,'','N;'),(284,'commonOptionsSeparator','CDev\\USPS','separator',200,'','N;'),(285,'dimensions','CDev\\USPS','serialized',210,'a:3:{i:0;i:10;i:1;i:7;i:2;i:9;}','N;'),(286,'girth','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',220,'0','N;'),(287,'max_weight','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',230,'70','N;'),(288,'machinable','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',235,'1','N;'),(289,'currency_rate','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',240,'1','N;'),(290,'domesticUSPSSeparator','CDev\\USPS','separator',300,'','N;'),(291,'container','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\Container',310,'VARIABLE','N;'),(292,'first_class_mail_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\FirstClassMailType',330,'PARCEL','N;'),(293,'use_rate_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\UseRateType',350,'Rate','N;'),(294,'pb_domestic_parcel_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\PBDomesticParcelType',360,'PKG','N;'),(295,'domestic_all_services_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\AllServicesType',370,'online','N;'),(296,'internationalUSPSSeparator','CDev\\USPS','separator',400,'','N;'),(297,'mail_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\MailType',410,'Package','N;'),(298,'commercial','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',430,'','N;'),(299,'gxg','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',440,'','N;'),(300,'gxg_pobox','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',450,'','N;'),(301,'gxg_gift','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',460,'','N;'),(302,'pb_international_parcel_type','CDev\\USPS','XLite\\Module\\CDev\\USPS\\View\\FormField\\Select\\PBInternationalParcelType',470,'PKG','N;'),(303,'cacheOnDeliverySeparator','CDev\\USPS','separator',500,'','N;'),(304,'use_cod_price','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',510,'1','N;'),(305,'cod_price','CDev\\USPS','XLite\\View\\FormField\\Input\\Text\\Price',520,'6.95','N;'),(306,'additionalOptionsSeparator','CDev\\USPS','separator',600,'','N;'),(307,'debug_enabled','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',610,'','N;'),(308,'pbSandbox','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',605,'','N;'),(309,'autoenable_new_methods','CDev\\USPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',620,'1','N;'),(310,'welcome_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',100,'daily','N;'),(311,'category_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',200,'daily','N;'),(312,'product_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',300,'daily','N;'),(313,'welcome_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',500,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(314,'category_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',600,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(315,'product_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',700,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(316,'account_id','Kliken\\GoogleAds','XLite\\View\\FormField\\Input\\Text\\Integer',100,'','N;'),(317,'app_token','Kliken\\GoogleAds','text',200,'','N;'),(318,'google_verification_token','Kliken\\GoogleAds','text',300,'','N;'),(319,'api_key','QSL\\CloudSearch','hidden',0,'','N;'),(320,'secret_key','QSL\\CloudSearch','hidden',0,'','N;'),(321,'dashboard','QSL\\CloudSearch','\\XLite\\Module\\QSL\\CloudSearch\\View\\FormField\\Dashboard',0,'','N;'),(322,'isCloudFiltersEnabled','QSL\\CloudSearch','hidden',20,'','N;'),(323,'isAdminSearchEnabled','QSL\\CloudSearch','hidden',30,'','N;'),(324,'planFeatures','QSL\\CloudSearch','hidden',0,'','N;'),(325,'fcm_show_product_num','QSL\\FlyoutCategoriesMenu','checkbox',10,'N','N;'),(326,'fcm_word_wrap','QSL\\FlyoutCategoriesMenu','checkbox',20,'Y','N;'),(327,'fcm_show_triangle','QSL\\FlyoutCategoriesMenu','checkbox',30,'Y','N;'),(328,'wizard_enabled','XC\\CanadaPost','',0,'1','N;'),(329,'wizard_hash','XC\\CanadaPost','',0,'','N;'),(330,'user','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(331,'password','XC\\CanadaPost','XLite\\View\\FormField\\Input\\PasswordWithValue',20,'','N;'),(332,'developer_mode','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',30,'','N;'),(333,'debug_enabled','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',40,'','N;'),(334,'additionalSettingsSeparator','XC\\CanadaPost','separator',100,'','N;'),(335,'quote_type','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\QuoteType',110,'C','N;'),(336,'customer_number','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',120,'','N;'),(337,'currency_rate','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',130,'1','N;'),(338,'contractShippingSeparator','XC\\CanadaPost','separator',200,'','N;'),(339,'contract_id','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',210,'','N;'),(340,'pick_up_type','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\PickUpType',220,'','N;'),(341,'deposit_site_num','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Input\\Text\\DepositSiteNum',230,'','N;'),(342,'detailed_manifests','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',240,'1','N;'),(343,'manifest_name','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text',250,'','N;'),(344,'deliverToPostOfficeSeparator','XC\\CanadaPost','separator',300,'','N;'),(345,'deliver_to_po_enabled','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',310,'','N;'),(346,'max_post_offices','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\Integer',320,'5','N;'),(347,'parcelCharacteristicsSeparator','XC\\CanadaPost','separator',400,'','N;'),(348,'length','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',410,'10','N;'),(349,'width','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',420,'9','N;'),(350,'height','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',430,'7','N;'),(351,'max_weight','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',440,'30','N;'),(352,'document','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',450,'','N;'),(353,'unpackaged','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',460,'','N;'),(354,'mailing_tube','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',470,'','N;'),(355,'oversized','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',480,'','N;'),(356,'parcelSeparator','XC\\CanadaPost','separator',500,'','N;'),(357,'way_to_deliver','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\DeliveryWayType',510,'','N;'),(358,'signature','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',520,'','N;'),(359,'age_proof','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\AgeProofType',530,'','N;'),(360,'coverage','XC\\CanadaPost','XLite\\View\\FormField\\Input\\Text\\FloatInput',540,'0','N;'),(361,'non_delivery','XC\\CanadaPost','XLite\\Module\\XC\\CanadaPost\\View\\FormField\\Select\\NonDeliveryType',550,'','N;'),(362,'write_key','XC\\Concierge','hidden',100,'','N;'),(363,'user_id','XC\\Concierge','hidden',300,'[[admin_email]]','N;'),(364,'additional_config_loaded','XC\\Concierge','hidden',400,'','N;'),(365,'quantity','XC\\CustomerAttachments','\\XLite\\Module\\XC\\CustomerAttachments\\View\\FormField\\Input\\Text\\FileCountInteger',0,'10','a:1:{s:3:\"min\";i:0;}'),(366,'extensions','XC\\CustomerAttachments','text',0,'','a:1:{s:7:\"comment\";s:68:\"Enter file extensions separated by comma; for example, \"jpg,txt,svg\"\";}'),(367,'file_size','XC\\CustomerAttachments','\\XLite\\Module\\XC\\CustomerAttachments\\View\\FormField\\Input\\Text\\FileSizeInteger',0,'0','a:1:{s:3:\"min\";i:0;}'),(368,'pixel_id','XC\\FacebookMarketing','hidden',0,'','N;'),(369,'include_out_of_stock','XC\\FacebookMarketing','hidden',0,'Y','N;'),(370,'renewal_frequency','XC\\FacebookMarketing','hidden',0,'86400','N;'),(371,'add_to_cart_value','XC\\FacebookMarketing','hidden',0,'30','N;'),(372,'view_content_value','XC\\FacebookMarketing','hidden',0,'10','N;'),(373,'init_checkout_value','XC\\FacebookMarketing','hidden',0,'40','N;'),(374,'advanced_matching','XC\\FacebookMarketing','hidden',0,'1','N;'),(375,'checkout_type','General','XLite\\Module\\XC\\FastLaneCheckout\\View\\FormField\\Select\\CheckoutType',200,'fast-lane','N;'),(376,'freight_shipping_calc_mode','XC\\FreeShipping','XLite\\Module\\XC\\FreeShipping\\View\\FormField\\FreightMode',10,'F','N;'),(377,'use_custom_colors','XC\\FroalaEditor','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',10,'','N;'),(378,'custom_colors','XC\\FroalaEditor','XLite\\Module\\XC\\FroalaEditor\\View\\FormField\\ColorPalettePicker',20,'','N;'),(379,'use_as_email_editor','XC\\FroalaEditor','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',30,'1','N;'),(380,'default_provider','XC\\Geolocation','XLite\\Module\\XC\\Geolocation\\View\\FormField\\Select\\DefaultProvider',10,'0','N;'),(381,'display_location_popup','XC\\Geolocation','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',20,'1','N;'),(382,'extended_database','XC\\Geolocation','XLite\\View\\FormField\\FileUploader\\ChunkUpload',30,'','a:2:{s:13:\"successAction\";s:11:\"geolocation\";s:10:\"extensions\";s:5:\".mmdb\";}'),(383,'current_database','XC\\Geolocation','XLite\\Module\\XC\\Geolocation\\View\\FormField\\Label\\CurrentDatabase',40,'','N;'),(384,'renewal_frequency','XC\\GoogleFeed','XLite\\Module\\XC\\GoogleFeed\\View\\FormField\\Select\\RenewalFrequency',0,'86400','N;'),(385,'duplicate_policy','XC\\GoogleFeed','XLite\\Module\\XC\\GoogleFeed\\View\\FormField\\Select\\DuplicatePolicy',0,'export_as_separate','N;'),(386,'settings_page_heading','XC\\MailChimp','hidden',50,'','N;'),(387,'mailChimpSeparator','XC\\MailChimp','separator',100,'','N;'),(388,'mailChimpAPIKey','XC\\MailChimp','text',200,'','N;'),(389,'analytics360enabled','XC\\MailChimp','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',300,'1','N;'),(390,'abandonedCartEnabled','XC\\MailChimp','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',350,'','N;'),(391,'defaultAutomationListId','XC\\MailChimp','\\XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\Lists',375,'','N;'),(392,'doubleOptinDisabled','XC\\MailChimp','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',400,'','N;'),(393,'subscriptionElementType','XC\\MailChimp','XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\ElementType',500,'checkbox','N;'),(394,'updateInterval','XC\\MailChimp','XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\UpdateInterval',600,'never','N;'),(395,'send_coupons','XC\\MailChimp','XLite\\Module\\XC\\MailChimp\\View\\FormField\\Select\\SendCoupons',700,'all','N;'),(396,'mcjs','XC\\MailChimp','textarea',800,'','N;'),(397,'top_news_length','XC\\News','XLite\\View\\FormField\\Input\\Text\\Integer',100,'5','a:1:{s:3:\"min\";i:1;}'),(398,'items_per_page','XC\\News','XLite\\View\\FormField\\Input\\Text\\Integer',200,'50','a:1:{s:3:\"min\";i:1;}'),(399,'news_changefreq','CDev\\XMLSitemap','XLite\\Module\\CDev\\XMLSitemap\\View\\FormField\\Select\\ChangeFrequency',400,'daily','N;'),(400,'news_priority','CDev\\XMLSitemap','XLite\\View\\FormField\\Input\\Text\\FloatInput',800,'0.5','a:3:{s:3:\"min\";i:0;s:3:\"max\";i:1;s:1:\"e\";i:1;}'),(401,'create_nfo_mode','XC\\NotFinishedOrders','XLite\\Module\\XC\\NotFinishedOrders\\View\\FormField\\Select\\CreateNFOMode',5,'onFailure','N;'),(402,'clear_cart_on_order_change','XC\\NotFinishedOrders','XLite\\View\\FormField\\Select\\YesNo',10,'Y','N;'),(403,'limit_nf_order_ttl','XC\\NotFinishedOrders','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',20,'1','N;'),(404,'nf_order_ttl','XC\\NotFinishedOrders','XLite\\View\\FormField\\Input\\Text\\Integer',30,'30','N;'),(405,'wizard_state','XC\\Onboarding','hidden',0,'visible','N;'),(406,'enable_in_stock_only_filter','XC\\ProductFilter','checkbox',100,'1','N;'),(407,'enable_price_range_filter','XC\\ProductFilter','checkbox',200,'1','N;'),(408,'enable_attributes_filter','XC\\ProductFilter','checkbox',300,'1','N;'),(409,'attributes_filter_by_category','XC\\ProductFilter','checkbox',400,'1','N;'),(410,'attributes_filter_cache_mode','XC\\ProductFilter','XLite\\Module\\XC\\ProductFilter\\View\\FormField\\Select\\CacheResetMode',500,'1','N;'),(411,'attributes_sorting_type','XC\\ProductFilter','XLite\\Module\\XC\\ProductFilter\\View\\FormField\\Select\\AttributesSortingType',600,'A','N;'),(412,'url_part_type','XC\\ProductFilter','XLite\\Module\\XC\\ProductFilter\\View\\FormField\\Select\\UrlPartType',700,'G','N;'),(413,'show_tags_sidebar','XC\\ProductTags','checkbox',100,'','N;'),(414,'enable_tags_filter','XC\\ProductFilter','checkbox',350,'1','N;'),(415,'key','XC\\RESTAPI','text',100,'xtTsd9WshYgs1uOlAxZGzec5Ed3PlThv','N;'),(416,'key_read','XC\\RESTAPI','text',200,'flNF5qLdnhfzY1lrHZQ3QOOoIPwynwHl','N;'),(417,'whoCanLeaveFeedback','XC\\Reviews','\\XLite\\Module\\XC\\Reviews\\View\\FormField\\Select\\WhoCanLeaveFeedback',10,'R','N;'),(418,'disablePendingReviews','XC\\Reviews','checkbox',20,'1','N;'),(419,'reviewsCountPerTab','XC\\Reviews','\\XLite\\View\\FormField\\Input\\Text\\Integer',30,'5','a:1:{s:3:\"min\";i:1;}'),(420,'enableCustomersFollowup','XC\\Reviews','\\XLite\\View\\FormField\\Input\\Checkbox\\OnOff',50,'','N;'),(421,'followupTimeout','XC\\Reviews','\\XLite\\View\\FormField\\Input\\Text\\Integer',60,'15','a:1:{s:3:\"min\";i:0;}'),(422,'use_custom_css','XC\\ThemeTweaker','checkbox',10,'','N;'),(423,'use_custom_js','XC\\ThemeTweaker','checkbox',20,'','N;'),(424,'tour_shown','XC\\ThemeTweaker','',0,'','N;'),(425,'userID','XC\\UPS','XLite\\View\\FormField\\Input\\Text',10,'','N;'),(426,'password','XC\\UPS','XLite\\View\\FormField\\Input\\PasswordWithValue',20,'','N;'),(427,'accessKey','XC\\UPS','XLite\\View\\FormField\\Input\\Text',30,'','N;'),(428,'shipper_number','XC\\UPS','XLite\\View\\FormField\\Input\\Text',40,'','N;'),(429,'test_mode','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',50,'1','N;'),(430,'additionalSettingsSeparator','XC\\UPS','separator',100,'','N;'),(431,'packageSettingsSeparator','XC\\UPS','separator',200,'','N;'),(432,'packaging_type','XC\\UPS','XLite\\Module\\XC\\UPS\\View\\FormField\\Select\\PackagingType',210,'00','N;'),(433,'dimensions','XC\\UPS','serialized',220,'a:3:{i:0;i:10;i:1;i:10;i:2;i:10;}','N;'),(434,'max_weight','XC\\UPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',230,'150','N;'),(435,'serviceOptionsSeparator','XC\\UPS','separator',300,'','N;'),(436,'pickup_type','XC\\UPS','XLite\\Module\\XC\\UPS\\View\\FormField\\Select\\PickupType',310,'01','N;'),(437,'saturday_pickup','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',320,'','N;'),(438,'additional_handling','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',330,'','N;'),(439,'saturday_delivery','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',340,'','N;'),(440,'negotiated_rates','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',350,'','N;'),(441,'delivery_conf','XC\\UPS','XLite\\Module\\XC\\UPS\\View\\FormField\\Select\\DeliveryConfirmation',360,'0','N;'),(442,'extra_cover','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',370,'','N;'),(443,'extra_cover_value','XC\\UPS','XLite\\View\\FormField\\Input\\Text\\Price',380,'0','N;'),(444,'shippingRefundsSeparator','XC\\UPS','separator',390,'','N;'),(445,'lbs71Info','XC\\UPS','XLite\\View\\FormField\\Label',395,'As a UPS user, you are entitled to receive shipping refunds usually left unclaimed with default UPS service ($2B/year globally)','a:1:{s:9:\"fieldOnly\";b:1;}'),(446,'cacheOnDeliverySeparator','XC\\UPS','separator',400,'','N;'),(447,'currencyConversionSeparator','XC\\UPS','separator',500,'','N;'),(448,'currency_code','XC\\UPS','XLite\\View\\FormField\\Input\\Text',510,'','N;'),(449,'currency_rate','XC\\UPS','XLite\\View\\FormField\\Input\\Text\\FloatInput',520,'1','N;'),(450,'additionalOptionsSeparator','XC\\UPS','separator',600,'','N;'),(451,'debug_enabled','XC\\UPS','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',610,'1','N;'),(452,'allow_vendor_communication','XC\\VendorMessages','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',200,'0','N;'),(453,'use_xp_cloud_for_subscriptions','XPay\\XPaymentsCloud','XLite\\View\\FormField\\Input\\Checkbox\\OnOffWithoutOffLabel',50,'0','N;'),(454,'time_zone','General','',0,'Europe/Moscow','N;'),(455,'is_user_id_correct','XC\\Concierge','0',0,'true','N;'),(456,'timestamp','Version','0',0,'[[timestamp]]','N;');
/*!40000 ALTER TABLE `[[dbprefix]]config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]config_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]config_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]config_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `option_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `option_comment` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_956A33BC3BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]config` (`config_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=517 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]config_translations`
--

LOCK TABLES `[[dbprefix]]config_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]config_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]config_translations` VALUES (1,1,'Use HTTPS in the Administrator Zone','','en'),(2,2,'Default customer address','','en'),(3,3,'Address line','','en'),(4,4,'Country','','en'),(5,5,'State','','en'),(6,6,'State','','en'),(7,7,'City','','en'),(8,8,'Zip/postal code','','en'),(9,9,'Address type','','en'),(10,10,'Aggregate CSS files (enable for better performance)','','en'),(11,11,'Aggregate JS files (enable for better performance)','','en'),(12,12,'Use widget cache (enable for better performance)','','en'),(13,16,'Default layout','','en'),(14,17,'Home page layout','','en'),(15,18,'CLI mode key','','en'),(16,19,'Company address','','en'),(17,20,'Contacts','','en'),(18,21,'Fax','','en'),(19,22,'Identity','','en'),(20,23,'Company name','Changing the value of this or any other fields on this page will not affect the signature in your store\'s email notifications. The signature for notifications can be edited on the <a href=\"admin.php?target=notification_common\">Header, greeting & signature</a> page.','en'),(21,24,'Company website','','en'),(22,25,'Terms and conditions relative URL','','en'),(23,26,'Customer Zone settings','','en'),(24,27,'Use HTTPS in the Customer Zone (for login, Checkout and profile pages)','','en'),(25,28,'Date format','','en'),(26,29,'First day of week','','en'),(27,30,'CSV column delimiter','','en'),(28,31,'Import/export charset','','en'),(29,32,'Export product data with','','en'),(30,35,'Payment method to be assumed in case of zero order totals','','en'),(31,36,'Maximum order quantity (per product)','','en'),(32,37,'Default payment method','','en'),(33,38,'Display check number for eCheck payment method','','en'),(34,39,'How to show out of stock products','','en'),(35,40,'Default products display mode for category listing','','en'),(36,42,'Street address','','en'),(37,43,'Country','','en'),(38,44,'State','','en'),(39,45,'State','','en'),(40,46,'City','','en'),(41,47,'Zip/postal code','','en'),(42,48,'Use your company address as your ship-from address','See <a href=\"admin.php?target=settings&page=Company#company-address\">company address</a>','en'),(43,49,'Street address','','en'),(44,50,'Country','','en'),(45,51,'State','','en'),(46,52,'State','','en'),(47,53,'City','','en'),(48,54,'Zip/postal code','','en'),(49,55,'Phone','','en'),(50,56,'Number of days to store the last login data','','en'),(51,57,'Maximum allowed order subtotal','','en'),(52,58,'Minimum allowed order subtotal','','en'),(53,59,'Next order #','You can change the number that will be assigned on the next order. The new order number should be greater than the current one.','en'),(54,60,'Cart TTL (days)','Specify the number of days after which a stored shopping cart should be considered old and should be removed. Leave empty if old carts should never be removed (not recommended)','en'),(55,61,'Enable internal cron service','This setting allows you to enable/disable the use of your store\'s internal cron service. This service schedules the run of certain maintenance tasks for your store - like removing customers\' expired shopping carts - at the periodicity of once per 100 user sessions.','en'),(56,62,'Sales department e-mails','The first email in this field (the one marked dark blue) will be used as the \"Reply-To:\" address for low limit warning messages.<br/><br/>All addresses in this field will be used as the \"TO:\" address for notifications about orders (creation of new orders, changes of order status, etc).','en'),(57,63,'Products per category listing page','','en'),(58,64,'Maximum products per category listing page','','en'),(59,65,'Force customer to choose product options before the product can be added to cart','','en'),(60,66,'Redirect customer to the cart page after a product is added to cart','','en'),(61,67,'Close the shop temporarily (not available in Demo store)','','en'),(62,68,'Shop currency','','en'),(63,69,'Hide trailing zeros in fractional part','','en'),(64,70,'Site administrator e-mails','The first email in this field (the one marked dark blue) will be used as the \"Reply-To:\" address for most notifications about user profiles.<br/><br/>All addresses in this field will be used as the \"TO:\" address for information on access to your store in safe mode (Hard and Soft reset links), notifications about failed administrator login attempts, low limit warnings, etc.','en'),(65,71,'Password','','en'),(66,72,'Secure connection','','en'),(67,73,'SMTP port','By default, SMTP uses TCP port 25. However, if you are going to use secure SSL/TLS encrypted SMTP, you need to specify the correct TCP port number for your system here. Typically, port number for secure SMTP is 465.','en'),(68,74,'SMTP server','','en'),(69,75,'Username','','en'),(70,76,'Year when store started its operation','','en'),(71,77,'Subcategory listings format','','en'),(72,78,'Default order to sort products within a category','','en'),(73,79,'Default order to sort products within a search result','','en'),(74,80,'HelpDesk/Support service e-mails','Addresses for messages sent by store visitors via the Contact us form.','en'),(75,81,'Time format','','en'),(76,82,'Time zone','','en'),(77,83,'Customer relations e-mails','The first email in this field (the one marked dark blue) will be used as the \"Reply-To:\" address for password reset messages.<br/><br/>All addresses in this field will be used as the \"TO:\" address for notifications about user profile related events (creation of a new user profile, deletion of a user profile, etc).','en'),(78,84,'Email to use for the FROM field','Please do not confuse this with Reply-to. Reply-to addresses for your emails will be selected from the Contact information section automatically according to the type of email message.','en'),(79,86,'Use SMTP server','','en'),(80,87,'Use authentication','','en'),(81,89,'Weight symbol','','en'),(82,90,'Weight unit','','en'),(83,91,'Hide trailing zeros in fractional part','','en'),(84,92,'Weight format','','en'),(85,93,'Percent format','','en'),(86,94,'Dimensional symbol','','en'),(87,95,'Dimensional unit','','en'),(88,96,'Curl options','','en'),(89,97,'Path to Certificate Authority (CA) bundle','','en'),(90,98,'Directory holding CA certificates','','en'),(91,99,'Ask anonymous users to sign in before checkout','','en'),(92,100,'Display \"Add to cart\" buttons for products in grid view','','en'),(93,103,'General options','','en'),(94,104,'Default site title','','en'),(95,105,'Default site meta description','','en'),(96,106,'Default site meta keywords','','en'),(97,107,'Home page title and meta','','en'),(98,108,'404 page','','en'),(99,109,'Regular text for 404 page','','en'),(100,110,'Show сustomer relations e-mails on 404 page','','en'),(101,111,'Page title format','','en'),(102,112,'Company name','','en'),(103,113,'Parent category path','','en'),(104,114,'Object name (category, product, etc)','','en'),(105,115,'Show object name in page title','','en'),(106,116,'About clean urls','','en'),(107,118,'Allow customers to sign up for membership','','en'),(108,119,'Upgrade options','','en'),(109,120,'Upgrade access level','','en'),(110,121,'FROM/REPLY-TO settings','','en'),(111,121,'Настройки FROM/REPLY-TO','','ru'),(112,122,'Email to use for the REPLY-to field in customer emails','','en'),(113,123,'Email to use for the REPLY-to field in admin emails','','en'),(114,124,'SMTP','','en'),(115,125,'Enabled','','en'),(116,126,'Banner interval (in seconds)','Set to \"0\" to disable automatic rotation','en'),(117,127,'Send the PDF version of invoices in the attachments','','en'),(118,132,'Test mode','','en'),(119,133,'API key','A unique 32 character API key is used to authorise inbound requests to the APIs. To obtain an API key please visit <a href=\"http://auspost.com.au/devcentre\">http://auspost.com.au/devcentre</a> and follow the link to create your Australia Post ID. After registration has been successfully completed you will be emailed an API key.','en'),(120,134,'Package settings','','en'),(121,136,'Package box type','','en'),(122,137,'Package dimensions (mm)','','en'),(123,138,'Additional settings','','en'),(124,139,'Service option','','en'),(125,140,'Extra cover type','','en'),(126,141,'Extra cover value','The specified value (if not empty) will be used as an extra cover value. Otherwise an order total will be used.','en'),(127,142,'Currency rate','Specify rate X, where 1 AUD = X in shop currency.','en'),(128,143,'Enable new methods','When AustraliaPost return shipping methods which does not exists in the available methods list, these methods will be created in the list automatically. You can specify should these methods be created as enabled and accessible customers just after they created, or these methods must be hidden from customer until you manually validate them.','en'),(129,144,'Enable debugging','This option enables logging of all communication between the shopping cart and AustraliaPost server.','en'),(130,146,'Number of products in the bestsellers list','','en'),(131,147,'Enable form','','en'),(132,148,'E-mail address of the message recipient','If the field is blank, then administration email is used','en'),(133,149,'Show email as text','','en'),(134,150,'reCAPTCHA','','en'),(135,151,'Version','','en'),(136,152,'Site key','To use reCAPTCHA you should get Site and Secret keys from <a href=\"https://www.google.com/recaptcha/admin/create\">https://www.google.com/recaptcha/admin/create</a>','en'),(137,153,'Secret key','','en'),(138,154,'Download link TTL (days)','Set zero for unlimited access. If you are using Cloud storage Signed URLs, TTL is limited to 7 days.','en'),(139,154,'Время действия ссылки на скачку (в днях)','При значении 0 - неограниченный доступ. Для ссылок хранилища, подписанных ключом, время ограничено 7 днями.','ru'),(140,155,'Downloads limit (per 1 ordered item)','Set zero for unlimited access. If you are using Cloud storage Signed URLs, this settings controls the limit of link renewal, because it is impossible to control downloads on the Signed URL.','en'),(141,155,'Лимит скачек (на 1 позицию заказа)','При значении 0 - безлимитный доступ. Для ссылок хранилища, подписанных ключом, эта настройка контролирует количество доступов к ссылке, так как невозможно ограничить количество скачек по такой ссылке.','ru'),(142,156,'Keep a history of downloads','Cloud storage Signed URLs are counted per link access (not download), because X-Cart can not track downloads on the Cloud Storage.','en'),(143,156,'Сохранять историю загрузок','Для ссылок хранилища, подписанных ключом, учитывается количество доступов, а не скачек, так как X-Cart не имеет доступа к истории скачек облачного хранилища.','ru'),(144,157,'Show only ESD related fulfillment statuses','With this option enabled, only 3 statuses will be available: New, Delivered and Will Not Deliver. You can rename the statuses as you require using the \"Custom Order Statuses\" module','en'),(145,157,'Отображать только статусы для цифровой дистрибуции','При включении данной настройки будет доступны только 3 статуса доставки: Новый, Доставлен и Доставка отменена. Переименовать их можно при помощи модуля Custom Order Statuses','ru'),(146,158,'Approve before providing access to download','','en'),(147,158,'Одобрение перед предоставлением доступа на скачивание','','ru'),(148,160,'Cloud storage Signed URLs','','en'),(149,161,'Enable usage of Presigned URLs for Cloud storage links','Use Cloud storage to host your digital files on Amazon S3 or Digital Ocean space and control access to your e-goods by presigned URLs. Learn more at <a href=\"https://kb.x-cart.com/en/modules/egoods/\" target=\"_blank\">E-goods module</a> article at X-Cart Knowledge Base.','en'),(150,161,'Включить ссылки, подписанные ключом, для файлов на хранилище','С помощью хранилища можно экономить серверное дисковое пространство и контролировать доступ к скачиваемым товарам. Подробнее о конфигурации можно узнать на странице <a href=\"https://kb.x-cart.ru/modules/egoods/\" target=\"_blank\">Цифровые товары</a> в базе знаний X-Cart.','ru'),(151,162,'Storage','','en'),(152,163,'Access Key','','en'),(153,164,'Secret Key','','en'),(154,165,'Bucket name','','en'),(155,165,'Bucket','','ru'),(156,166,'Bucket region','If not specified, the bucket region will be detected based on the URL. If the region cannot be detected, the default region us-east-1 will be used.','en'),(157,167,'Digital Ocean Endpoint','','en'),(158,168,'Featured products look and feel','','en'),(159,169,'FedEx authentication key','','en'),(160,170,'FedEx authentication password','','en'),(161,171,'FedEx account number','','en'),(162,172,'FedEx meter number','','en'),(163,173,'Test mode','','en'),(164,174,'Enable debugging','','en'),(165,175,'Additional settings','','en'),(166,176,'Carrier type(s)','','en'),(167,177,'FedEx Express (FDXE)','','en'),(168,178,'FedEx Ground (FDXG)','','en'),(169,179,'FedEx SmartPost (FXSP)','','en'),(170,180,'Hub ID','','en'),(171,181,'Indicia','','en'),(172,182,'Rate request type','','en'),(173,183,'Packaging','','en'),(174,184,'Dropoff type','','en'),(175,185,'Ship date (days)','','en'),(176,186,'Currency code','','en'),(177,187,'Currency rate','If the currency specified above differs from the currency the store uses for payments, specify a conversion rate to convert the shipping cost returned by FedEx into your store\'s currency. If the currencies are the same, leave this set to 1.','en'),(178,188,'Package dimensions (inches)','','en'),(179,189,'Maximum package weight','','en'),(180,190,'Special services','','en'),(181,191,'Dangerous Goods/Accessibility','','en'),(182,192,'Signature option','','en'),(183,193,'Shipping refunds settings','','en'),(184,195,'Cash on delivery','','en'),(185,196,'COD type','','en'),(186,197,'Advanced options','','en'),(187,198,'Shipment is scheduled for Saturday pickup (the option will be used if ship date is Saturday)','','en'),(188,199,'Shipment from residential address','','en'),(189,200,'Send package cost to calculate insurance','','en'),(190,169,'Ключ идентификации FedEx','','ru'),(191,170,'Пароль FedEx','','ru'),(192,171,'Номер счета FedEx','','ru'),(193,172,'FedEx meter number','','ru'),(194,173,'Режим тестирования','','ru'),(195,174,'Включить отладку','','ru'),(196,175,'Дополнительные настройки','','ru'),(197,176,'Тип(ы) перевозчика(ов)','','ru'),(198,177,'FedEx Express (FDXE)','','ru'),(199,178,'FedEx Ground (FDXG)','','ru'),(200,179,'FedEx SmartPost (FXSP)','','ru'),(201,183,'Упаковка','','ru'),(202,184,'Возврат тары','','ru'),(203,185,'Дата отгрузки (дни)','','ru'),(204,186,'Код валюты','','ru'),(205,187,'Коэффициент пересчета валюты','Если валюта выше отличается от валюты, используемой для оплаты в магазине, укажите коэффициент пересчёта для перевода стоимости доставки, предоставленной FedEx, в валюту магазина. Если валюты совпадают, оставьте значение 1.','ru'),(206,188,'Размеры упаковки (в дюймах)','','ru'),(207,189,'Максимальный вес упаковки','','ru'),(208,190,'Специальные услуги','','ru'),(209,191,'Опасные Товары/Доступность','','ru'),(210,192,'Показать все сохраненные кредитные карты','','ru'),(211,195,'Оплата при получении','','ru'),(212,196,'Тип наложного платежа','','ru'),(213,197,'Расширенные опции','','ru'),(214,198,'Погрузка назначена на Субботу (эта опция используется, если день отгрузки - Суббота)','','ru'),(215,199,'Доставка с адреса расположения','','ru'),(216,200,'Рассчитывать размер страховки по стоимости посылки','','ru'),(217,201,'Facebook application settings','','en'),(218,202,'Facebook Application ID','Facebook Platform application ID that administers your site pages. You can get this ID by visiting the page at <a href=\"https://developers.facebook.com/apps/\">https://developers.facebook.com/apps/</a><br /><br />You should specify this field:<ul><li>to make your site statistics appear in the Facebook Insights dashboard</li><li>to enable a moderator interface on Facebook where comments from all product pages can be easily moderated together</li></ul>','en'),(219,203,'Facebook Application Namespace','Specify the same app namespace that you entered when configured your Facebook Platform application.','en'),(220,204,'Facebook Admins','Comma-separated list of the Facebook User IDs of page administrators. Include at least your own Facebook User ID.','en'),(221,205,'Facebook Share Button settings','','en'),(222,206,'Display the Share button on product pages','The Share button lets a customer share your product pages with friends on Facebook.','en'),(223,207,'Facebook Like Button settings','','en'),(224,208,'We recommend using the Share button instead of Like.','','en'),(225,209,'Display the Like button on product pages','The Like button lets a customer share your product pages with friends on Facebook. The button will not be displayed if Facebook application id is not set.','en'),(226,210,'Layout style','There are three options:<ul><li>\"standard\" - displays social text to the right of the button and friends\' profile photos below</li><li>\"button\" - displays the total number of likes to the right of the button</li><li>\"box\" - displays the total number of likes above the button.</li></ul>','en'),(227,211,'Show profile pictures below the Like button','Profile pictures appear in the \"standard\" layout style only.','en'),(228,212,'The verb to display in the Like button','','en'),(229,213,'The color scheme for the like button','','en'),(230,214,'Facebook comments settings','','en'),(231,215,'Display the Facebook Comments tab on product pages','To moderate comments, specify your Facebook User ID in the \"Facebook Admins\" field below.<br />To enable the moderator interface on Facebook where comments from all product pages can be easily moderated together, specify your Facebook App ID in the \"Facebook Application ID\" field below.','en'),(232,216,'Number of posts to show on the tab by default','','en'),(233,217,'The color scheme for the comments','','en'),(234,218,'Tweet button settings','','en'),(235,219,'Display the Tweet button on product pages','The Tweet button allows customers to easily share your product pages with their Twitter followers.','en'),(236,220,'Show the count box along with the Tweet button','The count box shows how many times the product page has been Tweeted.','en'),(237,221,'Account name of the user to attribute the Tweet to (optional)','Also used as username of website in Twitter Card Tags','en'),(238,222,'Account name of the user to follow after sending a Tweet (optional)','Twitter will suggest that customers follow this user once they have sent a Tweet using the Tweet button.','en'),(239,223,'Hashtag to show within the Tweet button and in the text of the tweet status (optional)','','en'),(240,224,'Pinterest button settings','','en'),(241,225,'Display the Pinterest button on product pages','','en'),(242,221,'Имя учетной записи пользователя, автора Tweet (опционально)','Также используется как твиттер сайта в Twitter Card Tags','ru'),(243,226,'Web Property ID','','en'),(244,227,'What are you tracking','','en'),(245,228,'Google Analytics code version','','en'),(246,229,'Enable eCommerce Google Analytics','','en'),(247,230,'Register purchase only on Paid status change','','en'),(248,231,'Debug mode','','en'),(249,226,'Web Property ID','','ru'),(250,227,'Что отслеживается','','ru'),(251,228,'Версия кода Google Analytics','','ru'),(252,229,'Включить eCommerce Google Analytics','','ru'),(253,230,'Регистрировать покупку только после смены статуса на \"Оплачен\"','','ru'),(254,231,'Режим отладки','','ru'),(255,232,'Show only ESD related fulfillment statuses','This option leave only 3 method: New, Delivered and Will Not Deliver. You can rename it with \"Custom Order Statuses\" module','en'),(256,232,'Отображать только статусы для цифровой дистрибуции','Данная настройка оставит только 3 статуса доставки: Новый, Доставлен и Доставка отменена. Переименовать их можно при помощи модуля Custom Order Statuses','ru'),(257,233,'Approve before providing access','','en'),(258,233,'Одобрение перед предоставлением доступа','','ru'),(259,234,'Show \"Admin welcome\" block','','en'),(260,235,'Connect with PayPal','<p>To enable Connect with PayPal, you need to create a PayPal application for your website. The recommended procedure is to go to the My Apps page and create an app for testing, then to go live with this app. For detailed instructions on creating the app, see PayPal documentation at <a href=\"https://developer.paypal.com/docs/integration/admin/manage-apps/\">https://developer.paypal.com/docs/integration/admin/manage-apps/</a>. Be sure to specify your \"App return URL\" as the value of \"Redirect URL\" field below.</p><p>Once the app has been created, be sure to copy your Client Id and Client Secret from the app details and credentials and have them stored in the fields below.</p>','en'),(261,236,'Redirect URL','','en'),(262,237,'Client Id','','en'),(263,238,'Client Secret','','en'),(264,239,'Test/Live mode','','en'),(265,240,'Login scopes','','en'),(266,241,'\"New arrivals\" block settings','','en'),(267,242,'Enable \"New arrivals\" feature in catalog','','en'),(268,243,'Number of days to keep products marked as new arrivals','Specify a non-zero value; otherwise, 30 days will be used by default.','en'),(269,244,'Maximum number of products to display in complete new arrivals list','Limits the total number of products that can be displayed when user clicks the \"All new arrivals\" link in the \"New arrivals\" block. Leave 0 for no limit.','en'),(270,245,'Label new products','','en'),(271,246,'Maximum number of products to display in \"New arrivals\" block','Defines the maximum number of products that can be displayed in the \"New arrivals\" block. Specify a non-zero value; otherwise, 3 products will be displayed by default. If the specified value is more than the total amount of products on complete new arrivals list, that value will be used instead.','en'),(272,247,'Show new products only from category being viewed by customer','','en'),(273,248,'\"Coming soon\" block settings','','en'),(274,249,'Enable \"Coming soon\" feature in catalog','','en'),(275,250,'Label upcoming products','','en'),(276,251,'Show \"coming soon\" products only from category being viewed by customer','','en'),(277,252,'Maximum number of products to display in \"Coming soon\" block','Defines a maximum number of products that can be displayed in the \"Coming soon\" block. Specify a non-zero value; otherwise, 3 products will be displayed by default.','en'),(278,253,'\"Recently viewed\" block settings','','en'),(279,254,'Display \"Recently viewed\" block in catalog','','en'),(280,255,'Maximum number of products to display in \"Recently viewed\" block','Defines the maximum amount of products that can be displayed in the \"Recently viewed\" block. Leave 0 for no limit.','en'),(281,256,'\"Customers who bought this product also bought\" block settings','','en'),(282,257,'Display block in catalog','','en'),(283,258,'Maximum number of products to display in block','Defines the maximum number of products that can be displayed in the \"Customers who bought this product also bought\" block. Specify a non-zero value; otherwise, 3 products will be displayed by default.','en'),(284,259,'\"Customers who viewed this product bought\" block settings','','en'),(285,260,'Display block in catalog','','en'),(286,261,'Maximum number of products to display in block','Defines the maximum number of products that can be displayed in the \"Customers who viewed this product bought\" block. Specify a non-zero value; otherwise, 3 products will be displayed by default.','en'),(287,262,'Display the \"Products on sale\" block in the storefront','','en'),(288,263,'Display only the products on sale which are in the category being viewed (or its subcategories)','','en'),(289,264,'The maximum number of products to be displayed in the \"Products on sale\" block','The maximum number of products to be displayed in the \"Products on sale\" block. Set zero to display all products in the block. Drupal block settings can override this option (when the DrupalConnector module is enabled).','en'),(290,265,'How to handle multiple sale discounts','','en'),(291,266,'How to display links to sale offers in the category menu','','en'),(292,267,'Allow vendors to manage sale discounts for their own products','','en'),(293,268,'Use the same tax rates for all user membership levels','','en'),(294,269,'Address for sales tax calculation','','en'),(295,270,'Taxable base','','en'),(296,271,'Company logo','','en'),(297,272,'Favicon','For the icon to be displayed properly in all web browsers, we recommend using the icon size of 32x32 px','en'),(298,273,'Apple icon','Image must be a .png file with the resolution of 192x192px','en'),(299,274,'Frequency of content renewal for Static page','','en'),(300,275,'Priority for Static page','The value should range from 0 to 1.','en'),(301,276,'Show the default menu along with the custom one','','en'),(302,278,'Data provider','','en'),(303,279,'PitneyBowes merchant emailId','','en'),(304,280,'PitneyBowes merchant shipperId','','en'),(305,281,'User ID','','en'),(306,282,'U.S.P.S. API server URL','Enter the URL provided to you by U.S.P.S. in the notification about your successful registration for the U. S. Postal Service\'s Web Tools Application Program Interfaces. For example: <ul><li>https://stg-secure.shippingapis.com/ShippingApi.dll</li><li>https://secure.shippingapis.com/ShippingAPI.dll</li></ul>','en'),(307,283,'Additional settings','','en'),(308,284,'Common options','','en'),(309,285,'Package dimensions (inches)','If dimensions are not provided, Web Tools will assume package is regular in size and all dimensions are less than or equal to 12 inches.','en'),(310,286,'Girth','If Girth is provided with a non-zero value, the package will be considered \"NONRECTANGULAR\"','en'),(311,287,'Maximum package weight','','en'),(312,288,'Machinable','','en'),(313,289,'Currency conversion rate','Specify rate X, where 1 USD = X in shop currency.<br/>The shipping cost is always returned in US Dollars. So if the store uses a different currency for payments, you need to specify a conversion rate to convert the shipping cost returned by the shipping service into your store\'s currency. If the same currency is used, leave this set to 1.','en'),(314,290,'Domestic U.S.P.S.','','en'),(315,291,'Container','','en'),(316,292,'First-Class mail type','','en'),(317,293,'Pricing type to be used','','en'),(318,294,'Parcel type','','en'),(319,295,'Request rates for','','en'),(320,296,'International U.S.P.S.','','en'),(321,297,'Mail type','','en'),(322,298,'Get commercial base postage','','en'),(323,299,'Global Express Guarantee (GXG)','','en'),(324,300,'GXG destination is a post office box','','en'),(325,301,'GXG package contains a gift','','en'),(326,302,'Parcel type','','en'),(327,303,'Cash on delivery','','en'),(328,304,'Use a fixed amount Collect on Delivery fee','If you are planning to allow your customers to use the COD payment method for orders shipped with USPS shipping methods, you can make the calculation of shipping costs faster by setting a fixed extra fee for using the COD payment method.<br /><br />If a fixed amount COD fee is not set on the store\'s end, it will be calculated on the USPS end, and to get information about the COD fee amount the store will need to send several requests to the USPS API (one for each USPS service type), which may take up to 14 seconds. When using a fixed amount COD fee, the store will only send a single request to the USPS API, which will take under one second.<br /><br />Using a <b>fixed amount COD fee</b> allows the store to calculate the shipping cost much faster and is the <b>recommended option</b>.','en'),(329,305,'Fixed COD price','If you have selected to use a fixed COD fee, specify the fee amount here. The COD fee will be used for all shipping methods returned by the USPS server.<br /><br />You can find the current price for the USPS Collect on Delivery (COD) extra service on this page: <a href=\"https://www.usps.com/business/add-extra-services.htm\" target=\"_blank\">https://www.usps.com/business/add-extra-services.htm</a>','en'),(330,306,'Additional options','','en'),(331,307,'Log all communication between shopping cart and USPS server','','en'),(332,308,'Sandbox mode','','en'),(333,309,'Auto enable new USPS shipping methods','','en'),(334,310,'Frequency of content renewal for Welcome page','','en'),(335,311,'Frequency of content renewal for Category page','','en'),(336,312,'Frequency of content renewal for Product page','','en'),(337,313,'Priority for Welcome page','The value should range from 0 to 1.','en'),(338,314,'Priority for Category page','The value should range from 0 to 1.','en'),(339,315,'Priority for Product page','The value should range from 0 to 1.','en'),(340,316,'Account Id','','en'),(341,316,'Analyse-Account-ID','','de'),(342,316,'ID de la cuenta','','es'),(343,316,'Identifiant du compte','','fr'),(344,316,'Account ID','','nl'),(345,317,'Application Token','','en'),(346,317,'Anwendungstoken','','de'),(347,317,'Identificador de la aplicación','','es'),(348,317,'Jeton d\'application','','fr'),(349,317,'Applicatietoken','','nl'),(350,318,'Google Verification Token','','en'),(351,318,'Google-Verifizierungstoken','','de'),(352,318,'Identificador de verificación de Google','','es'),(353,318,'Jeton de vérification de Google','','fr'),(354,318,'Google verificatietoken','','nl'),(355,322,'Enable CloudFilters','','en'),(356,322,'Включить CloudFilters','','ru'),(357,323,'Enable products search in X-Cart Admin using CloudSearch','','en'),(358,323,'Включить поиск продуктов в админке X-Cart используя CloudSearch','','ru'),(359,325,'Show number of products in category','Select to show the number of products in a category next to the category\'s name','en'),(360,326,'Wrap long category names','Enable word wrapping for long category names','en'),(361,327,'Show category triangles','Select to display a tiny triangle next the names of categories that include subcategories. Categories that do not contain subcategories will not be furnished with a triangle. Having this option activated would help your store visitors to navigate through your category tree better','en'),(362,330,'User','','en'),(363,331,'Password','','en'),(364,332,'Developer mode','','en'),(365,333,'Log all communications between shopping cart and CanadaPost server','','en'),(366,334,'Additional settings','','en'),(367,335,'Quote type','','en'),(368,336,'Customer number','','en'),(369,337,'Currency rate','(specify rate X, where 1 CAD = X in shop currency)','en'),(370,338,'Contract shipping options','','en'),(371,339,'Contract ID','','en'),(372,340,'Shipments pick up type','','en'),(373,341,'Site number of the deposit location','Look up the site number using <a href=\"https://www.canadapost.ca/cpotools/apps/fdl/business/findDepositLocation?execution=e1s1\">Find a Deposit Location</a>','en'),(374,342,'Render detailed manifest','','en'),(375,343,'Contact name for the manifest address','','en'),(376,344,'Deliver to Post Office options','','en'),(377,345,'Enable \"Deliver to Post Office\" feature','','en'),(378,346,'Maximum Post Offices that will be displayed','','en'),(379,347,'Parcel characteristics','','en'),(380,348,'Package length (cm)','Longest dimension. (3.1 digits e.g. 999.9 pattern)','en'),(381,349,'Package width (cm)','Second longest dimension. (3.1 digits e.g. 999.9 pattern)','en'),(382,350,'Package height (cm)','Shortest dimension. (3.1 digits e.g. 999.9 pattern)','en'),(383,351,'Package maximum weight (kg)','This value will be used to separate ordered products into several packages by weight','en'),(384,352,'Document','Indicates whether the shipment is a document or not.','en'),(385,353,'Unpackaged','Indicates whether a shipment is unpackaged or not. For example, auto tires may be an example of an unpackaged shipment.','en'),(386,354,'Mailing tube','Indicates whether a shipment is contained in a mailing tube. (e.g. a poster tube)','en'),(387,355,'Oversized','Indicates whether the parcel is oversized or not.','en'),(388,356,'Parcel options','','en'),(389,357,'Way to deliver','','en'),(390,358,'Signature','','en'),(391,359,'Proof of age','','en'),(392,360,'Coverage','In percent of the order subtotal (0 - do not use coverage)','en'),(393,361,'Non-delivery instructions','','en'),(394,362,'Write key','','en'),(395,363,'User Id','','en'),(396,364,'Additional config loaded','','en'),(397,365,'Max number of files that can be attached','','en'),(398,365,'Максимальное количество файлов, которые можно присоединить','','ru'),(399,366,'Allowed file extensions','','en'),(400,366,'Допустимые расширения','','ru'),(401,367,'Max file size (MB). Set to \"0\" (zero) for unlimited','','en'),(402,367,'Максимальный размер файла (МБ). Используйте \"0\" (ноль) при отсутствии ограничений размера','','ru'),(403,375,'Checkout type','','en'),(404,376,'Shipping cost for products with a defined shipping freight value should be calculated as','','en'),(405,376,'Стоимость доставки для товаров с заданным значением поля \"Фиксированная стоимость доставки\" должна быть равна','','ru'),(406,377,'Use custom colors','','en'),(407,377,'Использовать пользовательские цвета','','ru'),(408,378,'Custom colors','','en'),(409,378,'Пользовательские цвета','','ru'),(410,379,'Use Froala as a text editor for e-mail notifications','','en'),(411,379,'Использовать Froala для редактирования текста e-mail уведомлений','','ru'),(412,380,'Default geolocation provider','','en'),(413,380,'Приоритетный источник данных о местоположении','','ru'),(414,381,'Display location select widget','','en'),(415,381,'Отображать виджет смены местоположения','','ru'),(416,382,'Upload extended database','You can upload an extended .mmdb database to get user location by IP more accurately','en'),(417,382,'Загрузить расширенную базу данных','Вы можете загрузить расширенную базу данных в формате .mmdb для более точного определения местоположения','ru'),(418,383,'Database file in use','','en'),(419,383,'Текущая база данных','','ru'),(420,384,'Frequency of Product Feed renewal','You should configure X-Cart to run <a href=\"https://kb.x-cart.com/general_setup/configuring_your_server_to_run_scheduled_x-cart_tasks.html\" target=\"_blank\">scheduled cron tasks</a> to enable periodic feed updates.','en'),(421,384,'Частота обновления выгрузки товаров','Чтобы автоматизировать обновление списка товаров, необходимо настроить <a href=\"https://kb.x-cart.ru/general_setup/configuring_your_server_to_run_scheduled_x-cart_tasks.html\" target=\"_blank\">выполнение запланированных задач</a> на сервере.','ru'),(422,385,'In case of duplicate product variants','The variants with duplicate attributes will get a title with a suffix, containing the attribute option values as string. Google will do it\'s best to handle such products properly.','en'),(423,385,'При наличии дублирующихся вариантов товара','Вариантам с дублирующимися атрибутами будет присвоен суффикс в наименовании, содержащий прочие значения атрибутов в строковом виде. При загрузке списка товаров Google попытается определить связь вариантов через наименование.','ru'),(424,386,'Mailchimp Lists','','en'),(425,387,'Mailchimp settings','','en'),(426,388,'Mailchimp API key','','en'),(427,389,'Enable E-commerce analytics','','en'),(428,390,'Enable Abandoned Carts','','en'),(429,391,'Default list for automatic campaigns','','en'),(430,392,'Enable single opt-in for customers','When this option is enabled customers are not prompted to confirm the subscription by email (contrary to double opt-in). Abusing this option might get your account banned by Mailchimp.','en'),(431,393,'Subscription select element type','This option controls the way your customers select a subscription. Select box allows subscription to only one mail list while check box allows subscription to multiple lists. For Checkout page always stays checkbox.','en'),(432,394,'Update Mailchimp lists every','Select the time interval for the periodical list updates.','en'),(433,395,'Type of discount coupons that should be uploaded to Mailchimp','The Mailchimp promo rules are:<br> - Code<br> - Discount amount<br> - Active from<br> - Active till <br>Discount coupons configured using any rules outside this rule set will be treated as not matching the Mailchimp rules.','en'),(434,395,'Тип купонов на скидку, который следует загружать в Mailchimp','Промо-правила Mailchimp: <br> - Код<br> - Сумма скидки<br> - Активен с<br> - Активен по <br>Купоны, настроенные с использованием каких-либо правил сверх этого набора, будут считаться не соответствующим промо-правилам Mailchimp.','ru'),(435,396,'Site connection code','The connection code will appear here automatically once you upload store data to MailChimp. Alternatively, you can connect MailChimp subscription popup via Custom Website integration code. Add your site to the MailChimp account and paste here the connection code.','en'),(436,396,'Код подключения сайта','Код появится автоматически после загрузки данных магазина в MailChimp. Также вы можете самостоятельно присоединить магазин, скопировав код подключения в это поле.','ru'),(437,387,'Настройки Mailchimp','','ru'),(438,388,'API ключ Mailchimp','','ru'),(439,389,'Включить аналитику Ecommerce','','ru'),(440,390,'Включить Abandoned Carts','','ru'),(441,391,'Список рассылок для автоматических кампаний','','ru'),(442,392,'Включить режим подписки \"single opt-in\"','Когда этоа опция включена клиенты не будут получать запрос на подтверждение подписки (в отличие от метода \"double opt-in\"). Злоупотребление данной опцией может привести к блокировке вашей учетной записи Mailchimp!','ru'),(443,393,'Тип элемента выбора подписки','Эта опция управляет тем, как ваши клиенты выбирают подписку на рассылку. Список позволяет подписаться только на одну рассылку из списка за раз, когда как галочка позволяет подписаться на несколько рассылок сразу. Для страницы оплаты всегда остаётся галочка.','ru'),(444,394,'Обновлять список рассылок Mailchimp каждые','Выберите временной интервал для обновления информации о списках рассылок.','ru'),(445,397,'Number of news messages in the Top news list','','en'),(446,397,'Количество новостей в списке Последних новостей','','ru'),(447,398,'News messages per page','','en'),(448,398,'Количество новостей на странице','','ru'),(449,399,'Frequency of content renewal for News Message page','','en'),(450,400,'Priority for News Message page','The value should range from 0 to 1.','en'),(451,401,'Not finished order will be created','','en'),(452,401,'Создавать незавершенный заказ','','ru'),(453,402,'Clear cart if administrator changes order','','en'),(454,402,'Очищать корзину при изменении заказа администратором','','ru'),(455,403,'Limit lifetime of not finished order','','en'),(456,403,'Ограничить срок действия незавершенного заказа','','ru'),(457,404,'Time to use the order for future attempts (days)','0 means that every failed attempt will be recorded as individual not finished order and its data will not be used in the next attempts.','en'),(458,404,'Срок действия незавершенного заказа (в днях)','Если задать срок равным 0 (нулю), то каждая неудачная попытка оплаты будет создавать отдельный незавершенный заказ, и данные этого заказа не будут внесены в будущие попытки.','ru'),(459,406,'Enable \"In stock only\" filter','','en'),(460,407,'Enable \"Price range\" filter','','en'),(461,408,'Enable \"Attributes\" filter','','en'),(462,409,'Show only available attributes and tags for products in category','If the setting is disabled, the filter shows all the attribute values and tags used in your store. If the setting is enabled, X-Cart generates a data cache that is used to display in the filter only the attribute values and tags that are actually used for the products in the category being viewed. Please be aware that the availability of the products for specific user membership levels is not taken into account during cache generation.','en'),(463,410,'Cache reset mode','Cache is first generated when a category page is opened. When attribute, tag or product data is changed, the generated cache is removed. It is then generated again when any category is opened.','en'),(464,411,'Sort order for class attributes','This setting affects only the attributes themselves, not their values. The values are sorted alphabetically.','en'),(465,412,'Generate the URL query string for filter with','This setting defines how the URL query string should be assembled when selecting the parameters that will be used to filter products.','en'),(466,406,'Включить фильтр \"Только товары в наличии\"','','ru'),(467,407,'Включить фильтр \"Цена\"','','ru'),(468,408,'Включить фильтр \"Атрибуты\"','','ru'),(469,409,'Отображать только атрибуты и теги, реально используемые для товаров в категории','Если данная настройка выключена, в фильтре показываются все значения атрибутов и все теги, используемые в магазине. Если настройка включена, X-Cart генерирует кеш данных, позволяющий отображать в фильтре только те значения атрибутов и теги, которые реально используются для товаров в просматриваемой категории. Обратите внимание, что доступность товаров для отдельных групп пользователей при генерации кеша не учитывается.','ru'),(470,410,'Режим обновления кэша','Кеш впервые генерируется при открытии страницы категории. При внесении изменений в данные атрибутов, тегов или товаров, кеш сбрасывается. Затем он генерируется заново, когда происходит открытие любой категории.','ru'),(471,411,'Порядок сортировки классовых атрибутов','Эта настройка влияет только на сами атрибуты, а не их значения. Значения сортируются в алфавитном порядке.','ru'),(472,412,'Строить строку запроса в URL для фильтра используя','Данная настройка позволяет выбрать, каким образом должен собираться URL страницы при наборе параметров, по которым будет осуществляться фильтрация товаров.','ru'),(473,413,'Show tags list in the sidebar','','en'),(474,414,'Enable \"Tags\" filter','','en'),(475,413,'Показывать список тегов в боковой колонке','','ru'),(476,414,'Включить фильтр \"Теги\"','','ru'),(477,415,'API key (read/write)','','en'),(478,416,'API key (only read)','','en'),(479,417,'Who can leave feedback','','en'),(480,418,'Admin moderates all reviews before showing them to customers','','en'),(481,419,'The quantity of reviews for tabs product reviews','','en'),(482,420,'Request customers to review the purchased products after successful orders','A successful order means an order that has been paid for and delivered.','en'),(483,420,'Отправлять покупателям приглашение оставить отзыв о купленных товарах после успешного заказа','Успешным заказом считается заказ, оплаченный и доставленный покупателю.','ru'),(484,421,'How many days later to send a review request','','en'),(485,421,'Через сколько дней отправлять приглашение оставить отзыв','','ru'),(486,422,'Use custom css','','en'),(487,423,'Use custom javascript','','en'),(488,425,'User ID','','en'),(489,426,'Password','','en'),(490,427,'Access key','','en'),(491,428,'UPS Account number','A shipper\'s UPS account number is required when requesting to receive the negotiated rates.','en'),(492,429,'Test mode','','en'),(493,430,'Additional settings','','en'),(494,431,'Package settings','','en'),(495,432,'Package box type','','en'),(496,433,'Package dimensions','','en'),(497,434,'Maximum package weight','','en'),(498,435,'Service options','','en'),(499,436,'Pickup type','','en'),(500,437,'Saturday pickup','','en'),(501,438,'Additional handling','','en'),(502,439,'Saturday delivery','','en'),(503,440,'Use negotiated rates','','en'),(504,441,'Delivery confirmation','','en'),(505,442,'Add insured value','','en'),(506,443,'Insured value','','en'),(507,444,'Shipping refunds settings','','en'),(508,446,'Cash on delivery','','en'),(509,447,'Currency conversion options','','en'),(510,448,'Shipping cost currency','','en'),(511,449,'Currency rate','If the UPS returns rates in currency which is differ from the currency the store uses for payments you need to specify the conversion rate to convert the shipping cost returned by UPS into the necessary currency. Otherwise leave 1.','en'),(512,450,'Additional options','','en'),(513,451,'Enable debugging','This option enables logging of all communication between shopping cart and UPS server.','en'),(514,452,'Allow direct communication between vendor and buyer in the \"Warehouse\" multivendor mode','','en'),(515,452,'Разрешить обмен сообщениями между продавцом и покупателем в режиме \"Общий склад\"','','ru'),(516,453,'Use X-Payments Cloud for creating new subscriptions','Already existing subscriptions will still be processed by X-Payments Subscriptions module. New subscriptions will be created and processed by X-Payments Cloud module','en');
/*!40000 ALTER TABLE `[[dbprefix]]config_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]content_images`
--

DROP TABLE IF EXISTS `[[dbprefix]]content_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]content_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]content_images`
--

LOCK TABLES `[[dbprefix]]content_images` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]content_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]content_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]content_videos`
--

DROP TABLE IF EXISTS `[[dbprefix]]content_videos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]content_videos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]content_videos`
--

LOCK TABLES `[[dbprefix]]content_videos` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]content_videos` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]content_videos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]conversation_members`
--

DROP TABLE IF EXISTS `[[dbprefix]]conversation_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]conversation_members` (
  `conversation_id` int(10) unsigned NOT NULL,
  `profile_id` int(11) NOT NULL,
  PRIMARY KEY (`conversation_id`,`profile_id`),
  KEY `IDX_96165ADA39AC0396` (`conversation_id`),
  KEY `IDX_96165ADA3CCFA12B8` (`profile_id`),
  CONSTRAINT `FK_96165ADA39AC0396` FOREIGN KEY (`conversation_id`) REFERENCES `[[dbprefix]]conversations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_96165ADA3CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `[[dbprefix]]profiles` (`profile_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]conversation_members`
--

LOCK TABLES `[[dbprefix]]conversation_members` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]conversation_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]conversation_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]conversations`
--

DROP TABLE IF EXISTS `[[dbprefix]]conversations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]conversations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_845131BB8D9F6D38` (`order_id`),
  CONSTRAINT `FK_9845131BB8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]conversations`
--

LOCK TABLES `[[dbprefix]]conversations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]conversations` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]conversations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]countries`
--

DROP TABLE IF EXISTS `[[dbprefix]]countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]countries` (
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `lng_id` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL,
  `code3` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `IDX_9C4F7794938248176` (`currency_id`),
  KEY `IDX_9C4F77949D7077436` (`lng_id`),
  KEY `enabled` (`enabled`),
  CONSTRAINT `FK_9C4F7794938248176` FOREIGN KEY (`currency_id`) REFERENCES `[[dbprefix]]currencies` (`currency_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9C4F77949D7077436` FOREIGN KEY (`lng_id`) REFERENCES `[[dbprefix]]languages` (`lng_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]countries`
--

LOCK TABLES `[[dbprefix]]countries` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]countries` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]countries` VALUES ('AD',978,NULL,20,'AND',1),('AE',784,NULL,784,'ARE',1),('AF',971,NULL,4,'AFG',1),('AG',951,NULL,28,'ATG',1),('AI',951,NULL,660,'AIA',1),('AL',8,NULL,8,'ALB',1),('AM',51,NULL,51,'ARM',1),('AO',973,NULL,24,'AGO',1),('AQ',NULL,NULL,10,'ATA',1),('AR',32,NULL,32,'ARG',1),('AS',840,NULL,16,'ASM',1),('AT',978,NULL,40,'AUT',1),('AU',36,NULL,36,'AUS',1),('AW',533,NULL,533,'ABW',1),('AX',978,NULL,248,'ALA',1),('AZ',944,NULL,31,'AZE',1),('BA',977,NULL,70,'BIH',1),('BB',52,NULL,52,'BRB',1),('BD',50,NULL,50,'BGD',1),('BE',978,NULL,56,'BEL',1),('BF',952,NULL,854,'BFA',1),('BG',975,NULL,100,'BGR',1),('BH',48,NULL,48,'BHR',1),('BI',108,NULL,108,'BDI',1),('BJ',952,NULL,204,'BEN',1),('BL',978,NULL,652,'BLM',1),('BM',60,NULL,60,'BMU',1),('BN',96,NULL,96,'BRN',1),('BO',68,NULL,68,'BOL',1),('BQ',840,NULL,535,'BES',1),('BR',986,NULL,76,'BRA',1),('BS',44,NULL,44,'BHS',1),('BT',356,NULL,64,'BTN',1),('BV',578,NULL,74,'BVT',1),('BW',72,NULL,72,'BWA',1),('BY',974,NULL,112,'BLR',1),('BZ',84,NULL,84,'BLZ',1),('CA',124,41,124,'CAN',1),('CC',36,NULL,166,'CCK',1),('CD',976,NULL,180,'COD',1),('CF',950,NULL,140,'CAF',1),('CG',950,NULL,178,'COG',1),('CH',756,NULL,756,'CHE',1),('CI',950,NULL,384,'CIV',1),('CK',554,NULL,184,'COK',1),('CL',152,NULL,152,'CHL',1),('CM',950,NULL,120,'CMR',1),('CN',156,30,156,'CHN',1),('CO',170,NULL,170,'COL',1),('CR',188,NULL,188,'CRI',1),('CU',192,NULL,192,'CUB',1),('CV',132,NULL,132,'CPV',1),('CW',532,NULL,531,'CUW',1),('CX',36,NULL,162,'CXR',1),('CY',978,NULL,196,'CYP',1),('CZ',203,NULL,203,'CZE',1),('DE',978,52,276,'DEU',1),('DJ',262,NULL,262,'DJI',1),('DK',208,NULL,208,'DNK',1),('DM',951,NULL,212,'DMA',1),('DO',214,NULL,214,'DOM',1),('DZ',12,NULL,12,'DZA',1),('EC',840,NULL,218,'ECU',1),('EE',978,NULL,233,'EST',1),('EG',818,NULL,818,'EGY',1),('EH',504,NULL,732,'ESH',1),('ER',232,NULL,232,'ERI',1),('ES',978,NULL,724,'ESP',1),('ET',230,NULL,231,'ETH',1),('FI',978,NULL,246,'FIN',1),('FJ',242,NULL,242,'FJI',1),('FK',238,NULL,238,'FLK',1),('FM',840,NULL,583,'FSM',1),('FO',208,NULL,234,'FRO',1),('FR',978,NULL,250,'FRA',1),('GA',950,NULL,266,'GAB',1),('GB',826,24,826,'GBR',1),('GD',951,NULL,308,'GRD',1),('GE',981,NULL,268,'GEO',1),('GF',978,NULL,254,'GUF',1),('GG',826,NULL,831,'GGY',1),('GH',936,NULL,288,'GHA',1),('GI',292,NULL,292,'GIB',1),('GL',208,NULL,304,'GRL',1),('GM',270,NULL,270,'GMB',1),('GN',324,NULL,324,'GIN',1),('GP',978,NULL,312,'GLP',1),('GQ',950,NULL,226,'GNQ',1),('GR',978,NULL,300,'GRC',1),('GS',826,NULL,239,'SGS',1),('GT',320,NULL,320,'GTM',1),('GU',840,NULL,316,'GUM',1),('GW',952,NULL,624,'GNB',1),('GY',328,NULL,328,'GUY',1),('HK',344,NULL,344,'HKG',1),('HM',36,NULL,334,'HMD',1),('HN',340,NULL,340,'HND',1),('HR',191,NULL,191,'HRV',1),('HT',332,NULL,332,'HTI',1),('HU',348,NULL,348,'HUN',1),('ID',360,NULL,360,'IDN',1),('IE',978,NULL,372,'IRL',1),('IL',376,NULL,376,'ISR',1),('IM',826,NULL,833,'IMN',1),('IN',356,NULL,356,'IND',1),('IO',840,NULL,86,'IOT',1),('IQ',368,NULL,368,'IRQ',1),('IR',364,NULL,364,'IRN',1),('IS',352,NULL,352,'ISL',1),('IT',978,NULL,380,'ITA',1),('JE',826,NULL,832,'JEY',1),('JM',388,NULL,388,'JAM',1),('JO',400,NULL,400,'JOR',1),('JP',392,NULL,392,'JPN',1),('KE',404,NULL,404,'KEN',1),('KG',417,NULL,417,'KGZ',1),('KH',116,NULL,116,'KHM',1),('KI',36,NULL,296,'KIR',1),('KM',174,NULL,174,'COM',1),('KN',951,NULL,659,'KNA',1),('KP',408,NULL,408,'PRK',1),('KR',410,NULL,410,'KOR',1),('KW',414,NULL,414,'KWT',1),('KY',136,NULL,136,'CYM',1),('KZ',398,NULL,398,'KAZ',1),('LA',418,NULL,418,'LAO',1),('LB',422,NULL,422,'LBN',1),('LC',951,NULL,662,'LCA',1),('LI',756,NULL,438,'LIE',1),('LK',144,NULL,144,'LKA',1),('LR',430,NULL,430,'LBR',1),('LS',426,NULL,426,'LSO',1),('LT',440,NULL,440,'LTU',1),('LU',978,NULL,442,'LUX',1),('LV',428,NULL,428,'LVA',1),('LY',434,NULL,434,'LBY',1),('MA',504,NULL,504,'MAR',1),('MC',978,NULL,492,'MCO',1),('MD',498,NULL,498,'MDA',1),('ME',978,NULL,499,'MNE',1),('MF',978,NULL,663,'MAF',1),('MG',969,NULL,450,'MDG',1),('MH',840,NULL,584,'MHL',1),('MK',807,NULL,807,'MKD',1),('ML',952,NULL,466,'MLI',1),('MM',64,NULL,104,'MMR',1),('MN',496,NULL,496,'MNG',1),('MO',446,NULL,446,'MAC',1),('MP',840,NULL,580,'MNP',1),('MQ',978,NULL,474,'MTQ',1),('MR',478,NULL,478,'MRT',1),('MS',951,NULL,500,'MSR',1),('MT',978,NULL,470,'MLT',1),('MU',480,NULL,480,'MUS',1),('MV',462,NULL,462,'MDV',1),('MW',454,NULL,454,'MWI',1),('MX',484,NULL,484,'MEX',1),('MY',458,NULL,458,'MYS',1),('MZ',943,NULL,508,'MOZ',1),('NA',516,NULL,516,'NAM',1),('NC',953,NULL,540,'NCL',1),('NE',952,NULL,562,'NER',1),('NF',36,NULL,574,'NFK',1),('NG',566,NULL,566,'NGA',1),('NI',558,NULL,558,'NIC',1),('NL',978,NULL,528,'NLD',1),('NO',578,NULL,578,'NOR',1),('NP',524,NULL,524,'NPL',1),('NR',36,NULL,520,'NRU',1),('NU',554,NULL,570,'NIU',1),('NZ',554,NULL,554,'NZL',1),('OM',512,NULL,512,'OMN',1),('PA',590,NULL,591,'PAN',1),('PE',604,NULL,604,'PER',1),('PF',953,NULL,258,'PYF',1),('PG',598,NULL,598,'PNG',1),('PH',608,NULL,608,'PHL',1),('PK',586,NULL,586,'PAK',1),('PL',985,NULL,616,'POL',1),('PM',978,NULL,666,'SPM',1),('PN',554,NULL,612,'PCN',1),('PR',840,NULL,630,'PRI',1),('PS',400,NULL,275,'PSE',1),('PT',978,NULL,620,'PRT',1),('PW',840,NULL,585,'PLW',1),('PY',600,NULL,600,'PRY',1),('QA',634,NULL,634,'QAT',1),('RE',978,NULL,638,'REU',1),('RO',946,NULL,642,'ROU',1),('RS',941,NULL,688,'SRB',1),('RU',643,135,643,'RUS',1),('RW',646,NULL,646,'RWA',1),('SA',682,NULL,682,'SAU',1),('SB',90,NULL,90,'SLB',1),('SC',690,NULL,690,'SYC',1),('SD',938,NULL,729,'SDN',1),('SE',752,NULL,752,'SWE',1),('SG',702,NULL,702,'SGP',1),('SH',654,NULL,654,'SHN',1),('SI',978,NULL,705,'SVN',1),('SJ',978,NULL,744,'SJM',1),('SK',978,NULL,703,'SVK',1),('SL',694,NULL,694,'SLE',1),('SM',978,NULL,674,'SMR',1),('SN',952,NULL,686,'SEN',1),('SO',706,NULL,706,'SOM',1),('SR',968,NULL,740,'SUR',1),('SS',728,NULL,728,'SSD',1),('ST',678,NULL,678,'STP',1),('SV',222,NULL,222,'SLV',1),('SX',532,NULL,534,'SXM',1),('SY',760,NULL,760,'SYR',1),('SZ',748,NULL,748,'SWZ',1),('TC',840,NULL,796,'TCA',1),('TD',950,NULL,148,'TCD',1),('TF',978,NULL,260,'ATF',1),('TG',952,NULL,768,'TGO',1),('TH',764,NULL,764,'THA',1),('TJ',972,NULL,762,'TJK',1),('TK',554,NULL,772,'TKL',1),('TL',840,NULL,626,'TLS',1),('TM',934,NULL,795,'TKM',1),('TN',788,NULL,788,'TUN',1),('TO',776,NULL,776,'TON',1),('TR',949,NULL,792,'TUR',1),('TT',780,NULL,780,'TTO',1),('TV',36,NULL,798,'TUV',1),('TW',901,NULL,158,'TWN',1),('TZ',834,NULL,834,'TZA',1),('UA',980,NULL,804,'UKR',1),('UG',800,NULL,800,'UGA',1),('UM',840,NULL,581,'UMI',1),('US',840,41,840,'USA',1),('UY',858,NULL,858,'URY',1),('UZ',860,NULL,860,'UZB',1),('VA',978,NULL,336,'VAT',1),('VC',951,NULL,670,'VCT',1),('VE',937,NULL,862,'VEN',1),('VG',840,NULL,92,'VGB',1),('VI',840,NULL,850,'VIR',1),('VN',704,NULL,704,'VNM',1),('VU',548,NULL,548,'VUT',1),('WF',953,NULL,876,'WLF',1),('WS',882,NULL,882,'WSM',1),('YE',886,NULL,887,'YEM',1),('YT',978,NULL,175,'MYT',1),('ZA',710,NULL,710,'ZAF',1),('ZM',894,NULL,894,'ZMB',1),('ZW',932,NULL,716,'ZWE',1);
/*!40000 ALTER TABLE `[[dbprefix]]countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]country_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]country_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]country_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` char(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `country` (`country`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9758727C3BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]countries` (`code`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=250 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]country_translations`
--

LOCK TABLES `[[dbprefix]]country_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]country_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]country_translations` VALUES (1,'AF','Afghanistan','en'),(2,'AX','Åland Islands','en'),(3,'AL','Albania','en'),(4,'DZ','Algeria','en'),(5,'AS','American Samoa','en'),(6,'AD','Andorra','en'),(7,'AO','Angola','en'),(8,'AI','Anguilla','en'),(9,'AQ','Antarctica','en'),(10,'AG','Antigua and Barbuda','en'),(11,'AR','Argentina','en'),(12,'AM','Armenia','en'),(13,'AW','Aruba','en'),(14,'AT','Austria','en'),(15,'AZ','Azerbaijan','en'),(16,'BS','Bahamas','en'),(17,'BH','Bahrain','en'),(18,'BD','Bangladesh','en'),(19,'BB','Barbados','en'),(20,'BY','Belarus','en'),(21,'BE','Belgium','en'),(22,'BZ','Belize','en'),(23,'BJ','Benin','en'),(24,'BM','Bermuda','en'),(25,'BT','Bhutan','en'),(26,'BO','Bolivia, Plurinational State of','en'),(27,'BQ','Bonaire, Sint Eustatius and Saba','en'),(28,'BA','Bosnia and Herzegowina','en'),(29,'BW','Botswana','en'),(30,'BV','Bouvet Island','en'),(31,'BR','Brazil','en'),(32,'IO','British Indian Ocean Territory','en'),(33,'BN','Brunei Darussalam','en'),(34,'BG','Bulgaria','en'),(35,'BF','Burkina Faso','en'),(36,'BI','Burundi','en'),(37,'KH','Cambodia','en'),(38,'CM','Cameroon','en'),(39,'CA','Canada','en'),(40,'CV','Cape Verde','en'),(41,'KY','Cayman Islands','en'),(42,'CF','Central African Republic','en'),(43,'TD','Chad','en'),(44,'CL','Chile','en'),(45,'CN','China','en'),(46,'CX','Christmas Island','en'),(47,'CC','Cocos (Keeling) Islands','en'),(48,'CO','Colombia','en'),(49,'KM','Comoros','en'),(50,'CG','Congo','en'),(51,'CD','Congo, the Democratic Republic of the','en'),(52,'CK','Cook Islands','en'),(53,'CR','Costa Rica','en'),(54,'CI','Côte d\'Ivoire','en'),(55,'HR','Croatia','en'),(56,'CU','Cuba','en'),(57,'CW','Curaçao','en'),(58,'CY','Cyprus','en'),(59,'CZ','Czech Republic','en'),(60,'DK','Denmark','en'),(61,'DJ','Djibouti','en'),(62,'DM','Dominica','en'),(63,'DO','Dominican Republic','en'),(64,'EC','Ecuador','en'),(65,'EG','Egypt','en'),(66,'SV','El Salvador','en'),(67,'GQ','Equatorial Guinea','en'),(68,'ER','Eritrea','en'),(69,'EE','Estonia','en'),(70,'ET','Ethiopia','en'),(71,'FK','Falkland Islands (Malvinas)','en'),(72,'FO','Faroe Islands','en'),(73,'FJ','Fiji','en'),(74,'FI','Finland','en'),(75,'FR','France','en'),(76,'GF','French Guiana','en'),(77,'PF','French Polynesia','en'),(78,'TF','French Southern Territories','en'),(79,'GA','Gabon','en'),(80,'GM','Gambia','en'),(81,'GE','Georgia','en'),(82,'DE','Germany','en'),(83,'GH','Ghana','en'),(84,'GI','Gibraltar','en'),(85,'GR','Greece','en'),(86,'GL','Greenland','en'),(87,'GD','Grenada','en'),(88,'GP','Guadeloupe','en'),(89,'GU','Guam','en'),(90,'GT','Guatemala','en'),(91,'GG','Guernsey','en'),(92,'GN','Guinea','en'),(93,'GW','Guinea-Bissau','en'),(94,'GY','Guyana','en'),(95,'HT','Haiti','en'),(96,'HM','Heard and McDonald Islands','en'),(97,'VA','Holy See (Vatican City State)','en'),(98,'HN','Honduras','en'),(99,'HK','Hong Kong','en'),(100,'HU','Hungary','en'),(101,'IS','Iceland','en'),(102,'IN','India','en'),(103,'ID','Indonesia','en'),(104,'IR','Iran, Islamic Republic of','en'),(105,'IQ','Iraq','en'),(106,'IE','Ireland','en'),(107,'IM','Isle of Man','en'),(108,'IL','Israel','en'),(109,'IT','Italy','en'),(110,'JM','Jamaica','en'),(111,'JP','Japan','en'),(112,'JE','Jersey','en'),(113,'JO','Jordan','en'),(114,'KZ','Kazakhstan','en'),(115,'KE','Kenya','en'),(116,'KI','Kiribati','en'),(117,'KP','Korea, Democratic People\'s Republic of','en'),(118,'KR','Korea, Republic of','en'),(119,'KW','Kuwait','en'),(120,'KG','Kyrgyzstan','en'),(121,'LA','Lao People\'s Democratic Republic','en'),(122,'LV','Latvia','en'),(123,'LB','Lebanon','en'),(124,'LS','Lesotho','en'),(125,'LR','Liberia','en'),(126,'LY','Libya','en'),(127,'LI','Liechtenstein','en'),(128,'LT','Lithuania','en'),(129,'LU','Luxembourg','en'),(130,'MO','Macao','en'),(131,'MK','North Macedonia','en'),(132,'MG','Madagascar','en'),(133,'MW','Malawi','en'),(134,'MY','Malaysia','en'),(135,'MV','Maldives','en'),(136,'ML','Mali','en'),(137,'MT','Malta','en'),(138,'MH','Marshall Islands','en'),(139,'MQ','Martinique','en'),(140,'MR','Mauritania','en'),(141,'MU','Mauritius','en'),(142,'YT','Mayotte','en'),(143,'MX','Mexico','en'),(144,'FM','Micronesia, Federated States of','en'),(145,'MD','Moldova, Republic of','en'),(146,'MC','Monaco','en'),(147,'MN','Mongolia','en'),(148,'ME','Montenegro','en'),(149,'MS','Montserrat','en'),(150,'MA','Morocco','en'),(151,'MZ','Mozambique','en'),(152,'MM','Myanmar','en'),(153,'NA','Namibia','en'),(154,'NR','Nauru','en'),(155,'NP','Nepal','en'),(156,'NL','Netherlands','en'),(157,'NC','New Caledonia','en'),(158,'NZ','New Zealand','en'),(159,'NI','Nicaragua','en'),(160,'NE','Niger','en'),(161,'NG','Nigeria','en'),(162,'NU','Niue','en'),(163,'NF','Norfolk Island','en'),(164,'MP','Northern Mariana Islands','en'),(165,'NO','Norway','en'),(166,'OM','Oman','en'),(167,'PK','Pakistan','en'),(168,'PW','Palau','en'),(169,'PS','Palestinian Territory, Occupied','en'),(170,'PA','Panama','en'),(171,'PG','Papua New Guinea','en'),(172,'PY','Paraguay','en'),(173,'PE','Peru','en'),(174,'PH','Philippines','en'),(175,'PN','Pitcairn','en'),(176,'PL','Poland','en'),(177,'PT','Portugal','en'),(178,'PR','Puerto Rico','en'),(179,'QA','Qatar','en'),(180,'RE','Réunion','en'),(181,'RO','Romania','en'),(182,'RU','Russian Federation','en'),(183,'RW','Rwanda','en'),(184,'BL','Saint Barthélemy','en'),(185,'SH','Saint Helena, Ascension and Tristan da Cunha','en'),(186,'KN','Saint Kitts and Nevis','en'),(187,'LC','Saint Lucia','en'),(188,'MF','Saint Martin','en'),(189,'PM','Saint Pierre and Miquelon','en'),(190,'VC','Saint Vincent and the Grenadines','en'),(191,'WS','Samoa','en'),(192,'SM','San Marino','en'),(193,'ST','Sao Tome and Principe','en'),(194,'SA','Saudi Arabia','en'),(195,'SN','Senegal','en'),(196,'RS','Serbia','en'),(197,'SC','Seychelles','en'),(198,'SL','Sierra Leone','en'),(199,'SG','Singapore','en'),(200,'SX','Sint Maarten','en'),(201,'SK','Slovakia','en'),(202,'SI','Slovenia','en'),(203,'SB','Solomon Islands','en'),(204,'SO','Somalia','en'),(205,'ZA','South Africa','en'),(206,'GS','South Georgia and the South Sandwich Islands','en'),(207,'SS','South Sudan','en'),(208,'ES','Spain','en'),(209,'LK','Sri Lanka','en'),(210,'SD','Sudan','en'),(211,'SR','Suriname','en'),(212,'SJ','Svalbard and Jan Mayen','en'),(213,'SZ','Swaziland','en'),(214,'SE','Sweden','en'),(215,'CH','Switzerland','en'),(216,'SY','Syrian Arab Republic','en'),(217,'TW','Taiwan, Province of China','en'),(218,'TJ','Tajikistan','en'),(219,'TZ','Tanzania, United Republic of','en'),(220,'TH','Thailand','en'),(221,'TL','Timor-Leste','en'),(222,'TG','Togo','en'),(223,'TK','Tokelau','en'),(224,'TO','Tonga','en'),(225,'TT','Trinidad and Tobago','en'),(226,'TN','Tunisia','en'),(227,'TR','Turkey','en'),(228,'TM','Turkmenistan','en'),(229,'TC','Turks and Caicos Islands','en'),(230,'TV','Tuvalu','en'),(231,'UG','Uganda','en'),(232,'UA','Ukraine','en'),(233,'AE','United Arab Emirates','en'),(234,'GB','United Kingdom','en'),(235,'US','United States','en'),(236,'UM','United States Minor Outlying Islands','en'),(237,'UY','Uruguay','en'),(238,'UZ','Uzbekistan','en'),(239,'VU','Vanuatu','en'),(240,'VE','Venezuela, Bolivarian Republic of','en'),(241,'VN','Viet Nam','en'),(242,'VG','Virgin Islands, British','en'),(243,'VI','Virgin Islands, U.S.','en'),(244,'WF','Wallis And Futuna Islands','en'),(245,'EH','Western Sahara','en'),(246,'YE','Yemen','en'),(247,'ZM','Zambia','en'),(248,'ZW','Zimbabwe','en'),(249,'AU','Australia','en');
/*!40000 ALTER TABLE `[[dbprefix]]country_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]coupon_categories`
--

DROP TABLE IF EXISTS `[[dbprefix]]coupon_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]coupon_categories` (
  `coupon_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`coupon_id`,`category_id`),
  KEY `IDX_92EB1BB6066C5951B` (`coupon_id`),
  KEY `IDX_92EB1BB6012469DE2` (`category_id`),
  CONSTRAINT `FK_92EB1BB6012469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_92EB1BB6066C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `[[dbprefix]]coupons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]coupon_categories`
--

LOCK TABLES `[[dbprefix]]coupon_categories` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]coupon_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]coupon_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]coupon_products`
--

DROP TABLE IF EXISTS `[[dbprefix]]coupon_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]coupon_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pair` (`coupon_id`,`product_id`),
  KEY `IDX_97B142C3266C5951B` (`coupon_id`),
  KEY `IDX_97B142C324584665A` (`product_id`),
  CONSTRAINT `FK_97B142C324584665A` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_97B142C3266C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `[[dbprefix]]coupons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]coupon_products`
--

LOCK TABLES `[[dbprefix]]coupon_products` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]coupon_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]coupon_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]coupons`
--

DROP TABLE IF EXISTS `[[dbprefix]]coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]coupons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uses` int(10) unsigned NOT NULL,
  `dateRangeBegin` int(10) unsigned NOT NULL,
  `dateRangeEnd` int(10) unsigned NOT NULL,
  `totalRangeBegin` decimal(14,4) NOT NULL,
  `totalRangeEnd` decimal(14,4) NOT NULL,
  `usesLimit` int(10) unsigned NOT NULL,
  `usesLimitPerUser` int(10) unsigned NOT NULL,
  `singleUse` tinyint(1) NOT NULL,
  `specificProducts` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ce` (`code`,`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]coupons`
--

LOCK TABLES `[[dbprefix]]coupons` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]currencies`
--

DROP TABLE IF EXISTS `[[dbprefix]]currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]currencies` (
  `currency_id` int(10) unsigned NOT NULL,
  `code` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `suffix` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `e` smallint(6) NOT NULL,
  `decimalDelimiter` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousandDelimiter` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `roundUp` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`currency_id`),
  UNIQUE KEY `UNIQ_903AF16077153098` (`code`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]currencies`
--

LOCK TABLES `[[dbprefix]]currencies` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]currencies` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]currencies` VALUES (8,'ALL','L','L','',2,'.','','N'),(12,'DZD','د.ج','د.ج','',2,'.','','N'),(32,'ARS','$','$','',2,'.','','N'),(36,'AUD','$','$','',2,'.','','N'),(44,'BSD','$','$','',2,'.','','N'),(48,'BHD','.د.ب','.د.ب','',3,'.','','N'),(50,'BDT','৳','৳','',2,'.','','N'),(51,'AMD','դր.','դր.','',2,'.','','N'),(52,'BBD','$','$','',2,'.','','N'),(60,'BMD','$','$','',2,'.','','N'),(64,'BTN','Nu','Nu','',2,'.','','N'),(68,'BOB','$','$','',2,'.','','N'),(72,'BWP','P','P','',2,'.','','N'),(84,'BZD','$','$','',2,'.','','N'),(90,'SBD','$','$','',2,'.','','N'),(96,'BND','$','$','',2,'.','','N'),(104,'MMK','K','K','',2,'.','','N'),(108,'BIF','₣','₣','',0,'.','','N'),(116,'KHR','$','$','',2,'.','','N'),(124,'CAD','$','$','',2,'.','','N'),(132,'CVE','$','$','',2,'.','','N'),(136,'KYD','$','$','',2,'.','','N'),(144,'LKR','Re','Re','',2,'.','','N'),(152,'CLP','$','$','',0,'.','','N'),(156,'CNY','¥','¥','',2,'.','','N'),(170,'COP','$','$','',2,'.','','N'),(174,'KMF','₣','₣','',0,'.','','N'),(188,'CRC','₡','₡','',2,'.','','N'),(191,'HRK','Kn','Kn','',2,'.','','N'),(192,'CUP','$','$','',2,'.','','N'),(203,'CZK','Kč','Kč','',2,'.','','N'),(208,'DKK','kr','kr','',2,'.','','N'),(214,'DOP','$','$','',2,'.','','N'),(222,'SVC','₡','₡','',2,'.','','N'),(230,'ETB','Br','Br','',2,'.','','N'),(232,'ERN','Nfk','Nfk','',2,'.','','N'),(238,'FKP','£','£','',2,'.','','N'),(242,'FJD','$','$','',2,'.','','N'),(262,'DJF','₣','₣','',0,'.','','N'),(270,'GMD','D','D','',2,'.','','N'),(292,'GIP','£','£','',2,'.','','N'),(320,'GTQ','Q','Q','',2,'.','','N'),(324,'GNF','₣','₣','',0,'.','','N'),(328,'GYD','$','$','',2,'.','','N'),(332,'HTG','G','G','',2,'.','','N'),(340,'HNL','L','L','',2,'.','','N'),(344,'HKD','$','$','',2,'.','','N'),(348,'HUF','ƒ','ƒ','',2,'.','','N'),(352,'ISK','kr','kr','',0,'.','','N'),(356,'INR','₹','₹','',2,'.','','N'),(360,'IDR','Rp','Rp','',0,'.','','N'),(364,'IRR','﷼','﷼','',2,'.','','N'),(368,'IQD','ع.د','ع.د','',3,'.','','N'),(376,'ILS','₪','₪','',2,'.','','N'),(388,'JMD','$','$','',2,'.','','N'),(392,'JPY','¥','¥','',0,'.','','N'),(398,'KZT','₸','₸','',2,'.','','N'),(400,'JOD','د.ا','د.ا','',3,'.','','N'),(404,'KES','KSh','KSh','',2,'.','','N'),(408,'KPW','₩','₩','',2,'.','','N'),(410,'KRW','₩','₩','',0,'.','','N'),(414,'KWD','د.ك','د.ك','',3,'.','','N'),(417,'KGS','C','C','',2,'.','','N'),(418,'LAK','₭','₭','',2,'.','','N'),(422,'LBP','.ل.ل','.ل.ل','',2,'.','','N'),(426,'LSL','L','L','',2,'.','','N'),(428,'LVL','Ls','Ls','',2,'.','','N'),(430,'LRD','$','$','',2,'.','','N'),(434,'LYD','ل.د','ل.د','',3,'.','','N'),(440,'LTL','Lt','Lt','',2,'.','','N'),(446,'MOP','$','$','',2,'.','','N'),(454,'MWK','K','K','',2,'.','','N'),(458,'MYR','RM','RM','',2,'.','','N'),(462,'MVR','Rf','Rf','',2,'.','','N'),(478,'MRO','UM','UM','',0,'.','','N'),(480,'MUR','Re','Re','',2,'.','','N'),(484,'MXN','$','$','',2,'.','','N'),(496,'MNT','₮','₮','',2,'.','','N'),(498,'MDL','L','L','',2,'.','','N'),(504,'MAD','د. م.','د. م.','',2,'.','','N'),(512,'OMR','ر.ع.','ر.ع.','',3,'.','','N'),(516,'NAD','N$','N$','',2,'.','','N'),(524,'NPR','Re','Re','',2,'.','','N'),(532,'ANG','ƒ','ƒ','',2,'.','','N'),(533,'AWG','ƒ','ƒ','',2,'.','','N'),(548,'VUV','Vt','Vt','',0,'.','','N'),(554,'NZD','$','$','',2,'.','','N'),(558,'NIO','$','$','',2,'.','','N'),(566,'NGN','₦','₦','',2,'.','','N'),(578,'NOK','kr','kr','',2,'.','','N'),(586,'PKR','Re','Re','',2,'.','','N'),(590,'PAB','B/.','B/.','',2,'.','','N'),(598,'PGK','K','K','',2,'.','','N'),(600,'PYG','₲','₲','',0,'.','','N'),(604,'PEN','S/.','S/.','',2,'.','','N'),(608,'PHP','₱','₱','',2,'.','','N'),(634,'QAR','ر.ق','ر.ق','',2,'.','','N'),(643,'RUB','₽','','₽',2,'.','','N'),(646,'RWF','₣','₣','',0,'.','','N'),(654,'SHP','£','£','',2,'.','','N'),(678,'STD','Db','Db','',2,'.','','N'),(682,'SAR','ر.س','ر.س','',2,'.','','N'),(690,'SCR','Re','Re','',2,'.','','N'),(694,'SLL','Le','Le','',2,'.','','N'),(702,'SGD','$','$','',2,'.','','N'),(704,'VND','₫','₫','',0,'.','','N'),(706,'SOS','S','S','',2,'.','','N'),(710,'ZAR','R','R','',2,'.','','N'),(728,'SSP','SSP','SSP','',2,'.','','N'),(748,'SZL','L','L','',2,'.','','N'),(752,'SEK','kr','kr','',2,'.','','N'),(756,'CHF','₣','₣','',2,'.','','N'),(760,'SYP','S£','S£','',2,'.','','N'),(764,'THB','฿','฿','',2,'.','','N'),(776,'TOP','$','$','',2,'.','','N'),(780,'TTD','$','$','',2,'.','','N'),(784,'AED','د.إ','د.إ','',2,'.','','N'),(788,'TND','د.ت','د.ت','',3,'.','','N'),(800,'UGX','USh','USh','',2,'.','','N'),(807,'MKD','ден.','ден.','',2,'.','','N'),(818,'EGP','LE','LE','',2,'.','','N'),(826,'GBP','£','£','',2,'.','','N'),(834,'TZS','TSh','TSh','',2,'.','','N'),(840,'USD','$','$','',2,'.','','N'),(858,'UYU','$','$','',2,'.','','N'),(860,'UZS','сўм','сўм','',2,'.','','N'),(882,'WST','$','$','',2,'.','','N'),(886,'YER','﷼','﷼','',2,'.','','N'),(894,'ZMK','K','K','',2,'.','','N'),(901,'TWD','NT$','NT$','',2,'.','','N'),(932,'ZWL','Z$','Z$','',2,'.','','N'),(934,'TMT','m','m','',2,'.','','N'),(936,'GHS','₵','₵','',2,'.','','N'),(937,'VEF','Bs','Bs','',2,'.','','N'),(938,'SDG','£','£','',2,'.','','N'),(941,'RSD','дин.','дин.','',2,'.','','N'),(943,'MZN','MT','MT','',2,'.','','N'),(944,'AZN','m','m','',2,'.','','N'),(946,'RON','L','L','',2,'.','','N'),(949,'TRY','₤','₤','',2,'.','','N'),(950,'XAF','₣','₣','',0,'.','','N'),(951,'XCD','$','$','',2,'.','','N'),(952,'XOF','₣','₣','',0,'.','','N'),(953,'XPF','₣','₣','',0,'.','','N'),(968,'SRD','$','$','',2,'.','','N'),(969,'MGA','Ar.','Ar.','',0,'.','','N'),(971,'AFN','؋','؋','',2,'.','','N'),(972,'TJS','с.','с.','',2,'.','','N'),(973,'AOA','Kz','Kz','',2,'.','','N'),(974,'BYR','Br','','Br',0,'.','','N'),(975,'BGN','лв','лв','',2,'.','','N'),(976,'CDF','₣','₣','',2,'.','','N'),(977,'BAM','KM','KM','',2,'.','','N'),(978,'EUR','€','€','',2,'.','','N'),(980,'UAH','₴','₴','',2,'.','','N'),(981,'GEL','ლ.','ლ.','',2,'.','','N'),(985,'PLN','zł','zł','',2,'.','','N'),(986,'BRL','$','$','',2,'.','','N');
/*!40000 ALTER TABLE `[[dbprefix]]currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]currency_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]currency_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]currency_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9E560C647BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]currencies` (`currency_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=159 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]currency_translations`
--

LOCK TABLES `[[dbprefix]]currency_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]currency_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]currency_translations` VALUES (1,784,'UAE Dirham','en'),(2,971,'Afghani','en'),(3,8,'Lek','en'),(4,51,'Armenian Dram','en'),(5,532,'Netherlands Antillian Guilder','en'),(6,973,'Kwanza','en'),(7,32,'Argentine Peso','en'),(8,36,'Australian Dollar','en'),(9,533,'Aruban Guilder','en'),(10,944,'Azerbaijanian Manat','en'),(11,977,'Convertible Marks','en'),(12,52,'Barbados Dollar','en'),(13,50,'Bangladesh Taka','en'),(14,975,'Bulgarian Lev','en'),(15,48,'Bahraini dinar','en'),(16,108,'Burundi Franc','en'),(17,60,'Bermudian Dollar','en'),(18,96,'Brunei Dollar','en'),(19,68,'Boliviano','en'),(20,986,'Brazilian Real','en'),(21,44,'Bahamian dollar','en'),(22,64,'Ngultrum','en'),(23,72,'Botswana Pula','en'),(24,974,'Belarussian Rouble','en'),(25,84,'Belize Dollar','en'),(26,124,'Canadian Dollar','en'),(27,976,'Franc Congolais','en'),(28,756,'Swiss Franc','en'),(29,152,'Chilean Peso','en'),(30,156,'Chinese Renminbi Yuan','en'),(31,170,'Colombian Peso','en'),(32,188,'Cost Rican Colon','en'),(33,192,'Cuban Peso','en'),(34,132,'Cape Verde Escudo','en'),(35,203,'Czech Koruna','en'),(36,262,'Djibouti Franc','en'),(37,208,'Danish Krone','en'),(38,214,'Dominican Peso','en'),(39,12,'Algerian Dinar','en'),(40,818,'Egyptian Pound','en'),(41,232,'Nakfa','en'),(42,230,'Ethiopian Birr','en'),(43,978,'Euro','en'),(44,242,'Fiji Dollar','en'),(45,238,'Falkland Islands Pound','en'),(46,826,'Pound Sterling','en'),(47,981,'Lari','en'),(48,936,'Ghana Cedi','en'),(49,292,'Gilbraltar Pound','en'),(50,270,'Dalasi','en'),(51,324,'Guinea Franc','en'),(52,320,'Quetzal','en'),(53,328,'Guyana Dollar','en'),(54,344,'Hong Kong Dollar','en'),(55,340,'Lempira','en'),(56,191,'Croatian Kuna','en'),(57,332,'Gourde','en'),(58,348,'Hungary Forint','en'),(59,360,'Indonesian Rupiah','en'),(60,376,'New Israeli Sheqel','en'),(61,356,'Indian Rupee','en'),(62,368,'Iraqi Dinar','en'),(63,364,'Iranian Rial','en'),(64,352,'Iceland Krona','en'),(65,388,'Jamaican Dollar','en'),(66,400,'Jordanian Dinar','en'),(67,392,'Japanese Yen','en'),(68,404,'Kenyan Shilling','en'),(69,417,'Son','en'),(70,116,'Cambodian riel','en'),(71,174,'Comoro Franc','en'),(72,408,'North Korean Won','en'),(73,410,'South Korean Won','en'),(74,414,'Kuwaiti Dinar','en'),(75,136,'Cayman Islands Dollar','en'),(76,398,'Tenge','en'),(77,418,'Kip','en'),(78,422,'Lebanese Pound','en'),(79,144,'Sri Lanka Rupee','en'),(80,430,'Liberian Dollar','en'),(81,426,'Loti','en'),(82,440,'Lithuanian Litus','en'),(83,428,'Latvian Lats','en'),(84,434,'Libyan Dinar','en'),(85,504,'Moroccan Dirham','en'),(86,498,'Moldovan Leu','en'),(87,969,'Malagasy Ariary','en'),(88,807,'Denar','en'),(89,104,'Kyat','en'),(90,496,'Tugrik','en'),(91,446,'Pataca','en'),(92,478,'Ouguiya','en'),(93,480,'Mauritius Rupee','en'),(94,462,'Rufiyaa','en'),(95,454,'Malawian kwacha','en'),(96,484,'Mexican Peso','en'),(97,458,'Ringgit Malaysia','en'),(98,943,'Mozambique Metical','en'),(99,516,'Namibia Dollar','en'),(100,566,'Naira','en'),(101,558,'Cordoba Oro','en'),(102,578,'Norwegian Krone','en'),(103,524,'Nepalese Rupee','en'),(104,554,'New Zealand Dollar','en'),(105,512,'Rial Omani','en'),(106,590,'Balboa','en'),(107,604,'Nuevo Sol','en'),(108,598,'Kina','en'),(109,608,'Philippine Peso','en'),(110,586,'Pakistan Rupee','en'),(111,985,'Polish Zloty','en'),(112,600,'Guarani','en'),(113,634,'Qatari Rial','en'),(114,946,'Romanian Leu','en'),(115,941,'Serbian Dinar','en'),(116,643,'Russian Ruble','en'),(117,646,'Rwanda Franc','en'),(118,682,'Saudi Riyal','en'),(119,90,'Solomon Islands Dollar','en'),(120,690,'Seychelles Rupee','en'),(121,938,'Sudanese Pound','en'),(122,752,'Swedish Krona','en'),(123,702,'Singapore Dollar','en'),(124,654,'Saint Helena Pound','en'),(125,694,'Leone','en'),(126,706,'Somali Shilling','en'),(127,968,'Surinam Dollar','en'),(128,728,'South Sudanese Pound','en'),(129,678,'Dobra','en'),(130,222,'El Salvador Colon','en'),(131,760,'Syrian Pound','en'),(132,748,'Lilangeni','en'),(133,764,'Thailand Baht','en'),(134,972,'Somoni','en'),(135,934,'Turkmenistan New Manat','en'),(136,788,'Tunisian Dinar','en'),(137,776,'Pa\'anga','en'),(138,949,'Turkish Lira','en'),(139,780,'Trinidad and Tobago Dollar','en'),(140,901,'New Taiwan Dollar','en'),(141,834,'Tanzanian Shilling','en'),(142,980,'Hryvnia','en'),(143,800,'Uganda Shilling','en'),(144,840,'US Dollar','en'),(145,858,'Peso Uruguayo','en'),(146,860,'Uzbekistan som','en'),(147,937,'Bolivar Fuerte','en'),(148,704,'Vietnamese Dong','en'),(149,548,'Vatu','en'),(150,882,'Tala','en'),(151,950,'CFA Franc BEAC','en'),(152,951,'East Caribbean Dollar','en'),(153,952,'CFA Franc BCEAO','en'),(154,953,'CFP Franc','en'),(155,886,'Yemeni Rial','en'),(156,710,'South Africa Rand','en'),(157,894,'Zambian kwacha','en'),(158,932,'Zimbabwe Dollar','en');
/*!40000 ALTER TABLE `[[dbprefix]]currency_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]custom_global_tab_translation`
--

DROP TABLE IF EXISTS `[[dbprefix]]custom_global_tab_translation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]custom_global_tab_translation` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brief_info` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_9A95B1F3CBF396750` (`id`),
  CONSTRAINT `FK_9A95B1F3CBF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]custom_global_tabs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]custom_global_tab_translation`
--

LOCK TABLES `[[dbprefix]]custom_global_tab_translation` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]custom_global_tab_translation` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]custom_global_tab_translation` VALUES (1,1,'Shipping info','We deliver worldwide','To replace this text with your store\'s actual shipping info, go to \"Catalog -> Product tabs\" and edit the Shipping info page.','en'),(2,1,'Доставка','Мы доставляем по всему миру','Для замены данного текста на настоящий текст информации о доставке товаров из вашего магазина, перейдите в секцию \"Каталог -> Вкладки страницы товара\" и редактируйте страницу \"Доставка\".','ru'),(3,2,'Payment methods','<p><img class=\"fr-draggable fr-dii fr-fil\" src=\"skins/customer/images/demo/tabs/logos-payments-tab.svg\" alt=\"Accepted payment methods\" style=\"width:300px;\" /></p>','<p>We accept the following payment methods:</p><p><img class=\"fr-draggable fr-dii\" src=\"skins/customer/images/demo/tabs/logos-payments-tab.svg\" alt=\"Accepted payment methods\" style=\"width:400px;\" /></p><p>To replace this text with your store\'s actual info on payment methods, go to \"Catalog -&gt; Product tabs\" and edit the Payment methods page.</p>','en'),(4,2,'Способы оплаты','<p><img class=\"fr-draggable fr-dii fr-fil\" src=\"skins/customer/images/demo/tabs/logos-payments-tab.svg\" alt=\"Методы оплаты\" style=\"width:300px;\" /></p>','<p>Мы принимаем следующие способы оплаты:</p><p><img class=\"fr-draggable fr-dii\" src=\"skins/customer/images/demo/tabs/logos-payments-tab.svg\" alt=\"Методы оплаты\" style=\"width:400px;\" /></p><p>Для замены данного текста на настоящий текст информации о способах оплаты для вашего магазина, перейдите в секцию \"Каталог -> Вкладки страницы товара\" и редактируйте страницу \"Способы оплаты\".</p>','ru'),(5,3,'Return Policy','We accept returns','This page is intended for your policy regarding returns and refunds.<br/><br/> Here you can provide information as to what products can be returned, how many days your customers have to return their purchase, whether they will receive a refund in the original form of payment, a replacement or a store credit, who pays for the shipping of the previously purchased products to the store, and so on.<br/><br/> To replace this text with your store\'s actual return policy, go to \"Catalog -> Product tabs\" and edit the Return Policy page.','en'),(6,3,'Правила обмена и возврата','Мы принимаем возвраты','Данная страница предназначена для размещения информации о правилах обмена и возврата товаров.<br/><br/> Здесь вы можете указать, возврат каких товаров может быть осуществлен, в пределах какого срока ваши покупатели могут вернуть приобретенный товар, будет ли осуществлен возврат средств на исходный метод оплаты, либо же будет осуществлена замена товара или возврат средств в форме товарного кредита, кто оплачивает доставку ранее купленного товара обратно в магазин, и так далее.<br/><br/> Для замены данного текста на настоящий текст правил обмена и возврата товаров для вашего магазина, перейдите в секцию \"Каталог -> Вкладки страницы товара\" и редактируйте страницу \"Правила обмена и возврата\".','ru');
/*!40000 ALTER TABLE `[[dbprefix]]custom_global_tab_translation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]custom_global_tabs`
--

DROP TABLE IF EXISTS `[[dbprefix]]custom_global_tabs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]custom_global_tabs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `global_tab_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_5C09BCAD629D8673` (`global_tab_id`),
  CONSTRAINT `FK_95C09BCAD629D8673` FOREIGN KEY (`global_tab_id`) REFERENCES `[[dbprefix]]global_product_tabs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]custom_global_tabs`
--

LOCK TABLES `[[dbprefix]]custom_global_tabs` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]custom_global_tabs` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]custom_global_tabs` VALUES (1,5),(2,6),(3,7);
/*!40000 ALTER TABLE `[[dbprefix]]custom_global_tabs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]customer_attachments_storage`
--

DROP TABLE IF EXISTS `[[dbprefix]]customer_attachments_storage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]customer_attachments_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9ACB714E4126F525E` (`item_id`),
  CONSTRAINT `FK_9ACB714E4126F525E` FOREIGN KEY (`item_id`) REFERENCES `[[dbprefix]]order_items` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]customer_attachments_storage`
--

LOCK TABLES `[[dbprefix]]customer_attachments_storage` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]customer_attachments_storage` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]customer_attachments_storage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]data_source_parameters`
--

DROP TABLE IF EXISTS `[[dbprefix]]data_source_parameters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]data_source_parameters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_source_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_96D9196CA1A935C57` (`data_source_id`),
  CONSTRAINT `FK_96D9196CA1A935C57` FOREIGN KEY (`data_source_id`) REFERENCES `[[dbprefix]]data_sources` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]data_source_parameters`
--

LOCK TABLES `[[dbprefix]]data_source_parameters` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]data_source_parameters` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]data_source_parameters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]data_sources`
--

DROP TABLE IF EXISTS `[[dbprefix]]data_sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]data_sources` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]data_sources`
--

LOCK TABLES `[[dbprefix]]data_sources` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]data_sources` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]data_sources` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]entity_type_versions`
--

DROP TABLE IF EXISTS `[[dbprefix]]entity_type_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]entity_type_versions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entityType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_4A1BBA741F08814A` (`entityType`)
) ENGINE=InnoDB AUTO_INCREMENT=965 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]entity_type_versions`
--

LOCK TABLES `[[dbprefix]]entity_type_versions` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]entity_type_versions` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]entity_type_versions` VALUES (1,'XLite\\Model\\Config','0aeaa1a2-0e06-49e7-aedb-ef8010314a94'),(2,'XLite\\Model\\ConfigTranslation','c1bae04a-759c-441f-916b-1280314b6743'),(3,'XLite\\Model\\Category','cb273714-4afa-4196-9066-8e0368042ead'),(4,'XLite\\Model\\CategoryTranslation','1f1c5cd0-aaa7-43e1-95db-1bd7b48be2b9'),(5,'XLite\\Model\\Category\\QuickFlags','bce6e5e7-9ae0-47c4-9973-987f3966d11a'),(6,'XLite\\Model\\Currency','fbb0e084-f6c6-4f8a-a62c-ecfb6e6f22be'),(7,'XLite\\Model\\CurrencyTranslation','8a3ca2ef-a6e9-4830-aaa0-d5eb6bd1e85f'),(8,'XLite\\Model\\Membership','64d15024-29ca-4076-b0bb-397a9fc1c67e'),(9,'XLite\\Model\\MembershipTranslation','73454698-881e-4b13-8008-639fdb735704'),(10,'XLite\\Model\\Language','1926a57f-8f8d-4f5a-ba4e-19db69a58fb0'),(11,'XLite\\Model\\LanguageTranslation','47cc53dd-96d0-45c7-be0a-7ac3a1a6ec80'),(12,'XLite\\Model\\Payment\\Method','32fded55-d3e1-4718-97ee-c26eec9b2bf9'),(13,'XLite\\Model\\Payment\\MethodTranslation','a58765f3-b6b9-4996-bf87-e3de0610a15e'),(14,'XLite\\Model\\Region','283c8a4f-1847-4b3e-b0ed-9899ebad8a17'),(15,'XLite\\Model\\Country','b695fec8-788f-46bf-91de-2b30c8d71ca6'),(16,'XLite\\Model\\CountryTranslation','07ca7c21-4311-42a5-b155-6857c10298a8'),(17,'XLite\\Model\\State','b7688174-a1f4-4a0d-b71b-436202f64828'),(19,'XLite\\Model\\Order\\Modifier','bdd243fa-3e60-46ed-abf4-c43c6f221097'),(20,'XLite\\Model\\Task','8e61981d-3b11-4b0d-989c-61c10c16affa'),(21,'XLite\\Model\\Role','29b66621-b08e-45c5-aac1-d2bd143a6d1f'),(22,'XLite\\Model\\RoleTranslation','95368bb6-17f3-49e4-91ef-8f17cd38e60c'),(23,'XLite\\Model\\Role\\Permission','77de2584-7fdb-4451-a8b3-6bbb4ca3f7ab'),(24,'XLite\\Model\\Role\\PermissionTranslation','c06d0d94-08e9-46cc-8142-a5b3bfa54bb4'),(27,'XLite\\Model\\AddressField','9c28cfa0-d3cb-41d4-9fd5-bdae940d4dc2'),(28,'XLite\\Model\\AddressFieldTranslation','a16d26b7-b472-4404-97f2-c3beca109ff3'),(29,'XLite\\Model\\MoneyModificator','db7d3596-d8ea-4195-b430-893c993b9445'),(30,'XLite\\Model\\Order\\Status\\Payment','cba4da2d-21b7-449a-a46b-40f2cebf38ce'),(31,'XLite\\Model\\Order\\Status\\PaymentTranslation','f38910a7-78d5-4964-ba51-661bbd37e410'),(32,'XLite\\Model\\Order\\Status\\Shipping','6ecf6edb-ca1c-49e6-aa31-a96bf274f6ab'),(33,'XLite\\Model\\Order\\Status\\ShippingTranslation','f34be983-4e27-417e-9f47-19076ebe2ee5'),(34,'XLite\\Model\\Order\\Status\\Property','fe025f0e-f1a6-4a2f-b4b4-ce2e6fb3dfac'),(35,'XLite\\Model\\Notification','1d2b242b-65f9-417b-be6b-48d96ed5d0a2'),(36,'XLite\\Model\\NotificationTranslation','5c17399f-ac11-4cf3-ab85-7757ac9449f1'),(37,'XLite\\Model\\ImageSettings','aae80502-bb95-42df-aabd-62c6ff08988e'),(38,'XLite\\Model\\SearchFilter','36dd4e12-5fd8-4af9-ab43-6d68c64bea8a'),(39,'XLite\\Model\\SearchFilterTranslation','3b27bb41-8a89-4079-8edd-65cb2a0bae39'),(40,'XLite\\Model\\AccessControlEntityType','0e5dcf21-8dba-4d75-93c3-c2ea68ff332d'),(41,'XLite\\Model\\AccessControlZoneType','1ac897b9-c4b8-434a-9468-c8e2496f53e0'),(42,'XLite\\Model\\Product\\GlobalTab','18797f29-491a-4579-8c63-003bcdc7a7eb'),(43,'XLite\\Model\\Product\\GlobalTabProvider','1c1cbb7e-effa-47d0-be27-714d186cf65f'),(46,'XLite\\Model\\LanguageLabel','bebe6366-f99d-418f-ad88-02e263d03423'),(47,'XLite\\Model\\LanguageLabelTranslation','9e61d19a-24cd-432b-8d69-0bbaf9c3724a'),(50,'XLite\\Model\\Payment\\MethodSetting','10698151-be32-4ef1-800e-1bb4a87a8213'),(55,'XLite\\Model\\Shipping\\Method','8b221799-e22f-4c37-9986-2d04272baea5'),(56,'XLite\\Model\\Shipping\\MethodTranslation','9b1e5167-aea4-4890-a7eb-e7e149623e12'),(164,'XLite\\Module\\CDev\\SimpleCMS\\Model\\Page','7146df3a-e8a5-4d79-a50e-5ae99be7e708'),(165,'XLite\\Model\\CleanURL','b7c64c5d-9e79-47c4-bf40-26203f0e5995'),(166,'XLite\\Module\\CDev\\SimpleCMS\\Model\\PageTranslation','6a6774b4-ff14-4cd3-8107-ccdce9817618'),(167,'XLite\\Module\\CDev\\SimpleCMS\\Model\\Menu','83f0d7e4-7ae5-44cf-861b-303b46bf9050'),(169,'XLite\\Module\\CDev\\SimpleCMS\\Model\\MenuTranslation','b3d59d3e-bd68-4f7a-b24b-c525e2082e11'),(171,'XLite\\Module\\CDev\\SimpleCMS\\Model\\Menu\\QuickFlags','46cc4b1b-49ac-4ebf-9a49-fc7ff740d647'),(395,'XLite\\Model\\Product','a02ba755-c6c1-47c8-8e8d-211a4c9bb107'),(396,'XLite\\Model\\QuickData','2035447c-e187-4c30-9b9d-61271df25326'),(398,'XLite\\Model\\Image\\Product\\Image','380d5ccd-cb53-42b1-9b14-59b6ab12cccf'),(399,'XLite\\Model\\ProductTranslation','f0499dbc-675d-4bf3-a351-93605fbaa4fd'),(650,'XLite\\Model\\Image\\Category\\Image','b6a91ae7-f0e3-4a39-b8b3-ab407addb0f6'),(651,'XLite\\Model\\Image\\Category\\Banner','3e5f536d-a45b-46fc-b34c-d8d4a715f1da'),(658,'XLite\\Model\\CategoryProducts','79d62d83-f399-4638-a452-89623a428d71'),(776,'XLite\\Model\\BannerRotationSlide','77cad8e6-2613-474a-9684-ea516b81febd'),(777,'XLite\\Model\\Image\\BannerRotationImage','1df97855-e595-46d3-a1cf-2e86cd9da496'),(778,'XLite\\Module\\XC\\CustomProductTabs\\Model\\Product\\CustomGlobalTab','8fe9818f-1d8a-41b8-bf8c-bc7cf8607482'),(781,'XLite\\Module\\XC\\CustomProductTabs\\Model\\Product\\CustomGlobalTabTranslation','53808f0c-d6dc-4bc0-87b8-eb06e1972b52'),(791,'XLite\\Module\\CDev\\FeaturedProducts\\Model\\FeaturedProduct','68191413-6d20-4121-bc84-7a24ba19ac0c'),(875,'XLite\\Model\\Order','17dd85e4-0607-4434-91c7-673f232253f8'),(876,'XLite\\Model\\Zone','c9437bab-94bd-4370-aa15-78264cc52d60'),(877,'XLite\\Model\\ZoneElement','962c702d-a541-4850-a5fb-82345eaef7f2'),(880,'XLite\\Model\\Shipping\\Markup','ce72b568-db35-4837-b5d1-9065f0a32067'),(881,'XLite\\Model\\Profile','c515c4bf-64d6-4392-86d7-37aa7d746679'),(882,'XLite\\Model\\Address','a8f9480b-8ff9-4cd9-9f73-724b77350fbe'),(883,'XLite\\Model\\AddressFieldValue','1b5c28bd-97e4-41ea-ab3e-48e8ce533b54'),(887,'XLite\\Model\\Payment\\Transaction','c97086bf-bc96-45c9-8600-820273a9cb98'),(888,'XLite\\Model\\OrderItem','96ead802-3289-4e2d-83b7-b61b61252409'),(890,'XLite\\Model\\Order\\Surcharge','7f989d81-84a9-4a51-86c3-4358a9553406'),(891,'XLite\\Model\\OrderHistoryEvents','9f0a6313-24c4-48fa-9454-c7a8e2349915'),(914,'XLite\\Model\\Payment\\TransactionData','aba2764a-6705-4abc-87d5-1a20e4475a3b'),(952,'XLite\\Model\\ViewList','a1ec967a-133a-42c1-bab7-8dd57072715f');
/*!40000 ALTER TABLE `[[dbprefix]]entity_type_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]event_tasks`
--

DROP TABLE IF EXISTS `[[dbprefix]]event_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]event_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `arguments` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]event_tasks`
--

LOCK TABLES `[[dbprefix]]event_tasks` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]event_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]event_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]featured_products`
--

DROP TABLE IF EXISTS `[[dbprefix]]featured_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]featured_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `orderBy` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pair` (`category_id`,`product_id`),
  KEY `IDX_9CE976A6E4584665A` (`product_id`),
  KEY `IDX_9CE976A6E12469DE2` (`category_id`),
  CONSTRAINT `FK_9CE976A6E12469DE2` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9CE976A6E4584665A` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]featured_products`
--

LOCK TABLES `[[dbprefix]]featured_products` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]featured_products` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]featured_products` VALUES (1,14,1,10),(2,29,1,20),(3,42,1,30),(4,31,1,40),(5,35,1,50),(6,25,1,60),(7,21,1,70),(8,2,1,80);
/*!40000 ALTER TABLE `[[dbprefix]]featured_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]form_ids`
--

DROP TABLE IF EXISTS `[[dbprefix]]form_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]form_ids` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `form_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fs` (`form_id`,`session_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `FK_9AD266A12613FECDF` FOREIGN KEY (`session_id`) REFERENCES `[[dbprefix]]sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]form_ids`
--

LOCK TABLES `[[dbprefix]]form_ids` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]form_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]form_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]global_product_tab_provider`
--

DROP TABLE IF EXISTS `[[dbprefix]]global_product_tab_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]global_product_tab_provider` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tab_id` int(10) unsigned DEFAULT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_95120A7CB8D0C9323` (`tab_id`),
  CONSTRAINT `FK_95120A7CB8D0C9323` FOREIGN KEY (`tab_id`) REFERENCES `[[dbprefix]]global_product_tabs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]global_product_tab_provider`
--

LOCK TABLES `[[dbprefix]]global_product_tab_provider` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]global_product_tab_provider` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]global_product_tab_provider` VALUES (1,1,'Core'),(2,2,'Core'),(3,3,'CDev-GoSocial'),(4,4,'XC-Reviews'),(5,5,'Core'),(6,6,'Core'),(7,7,'Core');
/*!40000 ALTER TABLE `[[dbprefix]]global_product_tab_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]global_product_tabs`
--

DROP TABLE IF EXISTS `[[dbprefix]]global_product_tabs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]global_product_tabs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int(11) NOT NULL,
  `service_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `service_name` (`service_name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]global_product_tabs`
--

LOCK TABLES `[[dbprefix]]global_product_tabs` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]global_product_tabs` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]global_product_tabs` VALUES (1,1,NULL,10,'Description'),(2,1,NULL,20,'Specification'),(3,1,NULL,30,'Comments'),(4,1,NULL,60,'Reviews'),(5,1,'Shipping_info',60,NULL),(6,1,'Payment_methods',70,NULL),(7,1,'Return_Policy',80,NULL);
/*!40000 ALTER TABLE `[[dbprefix]]global_product_tabs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]iframe_contents`
--

DROP TABLE IF EXISTS `[[dbprefix]]iframe_contents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]iframe_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]iframe_contents`
--

LOCK TABLES `[[dbprefix]]iframe_contents` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]iframe_contents` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]iframe_contents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]images_settings`
--

DROP TABLE IF EXISTS `[[dbprefix]]images_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]images_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `moduleName` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code_model_module` (`code`,`model`,`moduleName`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]images_settings`
--

LOCK TABLES `[[dbprefix]]images_settings` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]images_settings` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]images_settings` VALUES (1,'Default','XLite\\Model\\Image\\Product\\Image','standard',300,300),(2,'LGThumbnailList','XLite\\Model\\Image\\Product\\Image','standard',160,160),(3,'LGThumbnailGrid','XLite\\Model\\Image\\Product\\Image','standard',160,160),(4,'Default','XLite\\Model\\Image\\Category\\Image','standard',160,160),(5,'Default','XLite\\Model\\Image\\Common\\Logo','standard',180,66),(6,'Default','XLite\\Model\\Image\\Category\\Image','XC-CrispWhiteSkin',120,120),(7,'LGThumbnailGrid','XLite\\Model\\Image\\Product\\Image','XC-CrispWhiteSkin',240,240),(8,'LGThumbnailList','XLite\\Model\\Image\\Product\\Image','XC-CrispWhiteSkin',240,240),(9,'Default','XLite\\Model\\Image\\Product\\Image','XC-CrispWhiteSkin',366,366),(10,'Default','XLite\\Model\\Image\\Common\\Logo','XC-CrispWhiteSkin',221,40);
/*!40000 ALTER TABLE `[[dbprefix]]images_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]import_logs`
--

DROP TABLE IF EXISTS `[[dbprefix]]import_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]import_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` int(11) NOT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `arguments` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `row` int(10) unsigned NOT NULL,
  `processor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]import_logs`
--

LOCK TABLES `[[dbprefix]]import_logs` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]import_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]import_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]job_states`
--

DROP TABLE IF EXISTS `[[dbprefix]]job_states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]job_states` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `progress` int(11) NOT NULL,
  `startedAt` decimal(10,0) NOT NULL,
  `cancelled` tinyint(1) NOT NULL,
  `finished` tinyint(1) NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]job_states`
--

LOCK TABLES `[[dbprefix]]job_states` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]job_states` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]job_states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]language_label_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]language_label_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]language_label_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `label` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9D36B6764BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]language_labels` (`label_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5953 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]language_label_translations`
--

LOCK TABLES `[[dbprefix]]language_label_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]language_label_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]language_label_translations` VALUES (1,1,'%','en'),(2,2,'Most popular','en'),(3,3,'Newest','en'),(4,4,'Alphabetically','en'),(5,5,'Tags','en'),(6,6,'Before editing attributes specific for the chosen type you should save the changes. <br /><br />Changing the type of a product attribute after having defined values for this attribute for some products will result in losing the defined attribute values.','en'),(7,7,'For details refer to <a href=\"{{licenseAgreementURL}}\" target=\"_blank\">X-Cart license agreement</a>.','en'),(8,8,'We are sorry, the Marketplace server is currently unavailable. Your license could not be registered. Please try again later.','en'),(9,9,'<a href=\"{{contactURL}}\" target=\"_blank\">Contact us</a> if you have any questions','en'),(10,10,'Activate your license key','en'),(11,11,'To activate your X-Cart license, enter your secret key into the field below and click Activate.','en'),(12,12,'To activate your X-Cart or commercial module license, enter your license key into the field below and click Activate.','en'),(13,13,'To set up Tax Rates, find and install appropriate add-on modules from the <a href=\"{{url}}\">Marketplace</a>','en'),(14,14,'Purchase premium license','en'),(15,15,'Activate free license','en'),(16,16,'activate existing key','en'),(17,17,'Enter your license key here','en'),(18,18,'Activate','en'),(19,19,'Need a license key?','en'),(20,20,'You must register your installation before you can use it for real sales. Registration can be accomplished by activating a free license with limited features or by purchasing a premium license.','en'),(21,21,'Removal of this message is allowed only through activation of a free or premium license.','en'),(22,22,'Free Edition has a limited set of features, so all the modules of the Business package will be removed in your store. However, you will be able to <a href=\'{{purchaseURL}}\'>upgrade</a> your Free version to Premium at any time and install addons from the Premium package.<br /><br /><strong>Here\'s a list of modules that are not available under free license. After the activation of a free license key all these modules will be removed from your installation.</strong>','en'),(23,23,'Evaluation notice','en'),(24,24,'Don\'t have an account yet?','en'),(25,25,'Go to checkout as a New customer','en'),(26,26,'Weight','en'),(27,27,'Weight ({{symbol}})','en'),(28,28,'Add to cart','en'),(29,29,'Description','en'),(30,30,'SKU','en'),(31,31,'Previous product','en'),(32,32,'Next product','en'),(33,33,'Clear cart','en'),(34,34,'Continue shopping','en'),(35,35,'Submit','en'),(36,36,'Submit','en'),(37,37,'Delivery','en'),(38,38,'(!) This product is out of stock or not available','en'),(39,39,'Update','en'),(40,40,'Grand total','en'),(41,41,'Shipping cost','en'),(42,42,'Free','en'),(43,43,'Subtotal','en'),(44,44,'Tax','en'),(45,45,'n/a','en'),(46,46,'Delete item','en'),(47,47,'Continue...','en'),(48,48,'The text was copied to your clipboard','en'),(49,49,'When X-Cart aggregates CSS and JS files, the result is cached. If you change your JS/CSS files directly in the file system after they have been included into the cache, you will not see the functionality or style changes you have made. To make your changes visible, clear the aggregation cache.','en'),(50,50,'When X-Cart uses widgets cache, the static content of product lists is stored into a temporary cache. After editing the content (modifying the product descriptions, titles or photos), you should clear the widgets cache to make these changes visible in the front end right away. If you do not clear it, the changes will be updated anyway, but it may require more time','en'),(51,51,'The language you want to add has not been found','en'),(52,52,'This language already exists','en'),(53,53,'The {{language}} language has been added successfully','en'),(54,54,'The language you want to delete has not been found','en'),(55,55,'The {{language}} language has been deleted successfully','en'),(56,56,'Language not found','en'),(57,57,'The default interface language cannot be disabled','en'),(58,58,'The {{language}} language has been disabled','en'),(59,59,'The {{language}} language has been enabled','en'),(60,60,'The text labels have been updated','en'),(61,61,'Couldn\'t update the text labels: the translation language is not specified','en'),(62,62,'Couldn\'t update the text labels: the default language is set as the translation language','en'),(63,63,'Couldn\'t update the text labels: the translation language has not been found','en'),(64,64,'The text labels have been deleted','en'),(65,65,'Couldn\'t delete the text labels: text labels not found or not specified','en'),(66,66,'The text label has been deleted','en'),(67,67,'Couldn\'t delete the text label: text label not found or not specified','en'),(68,68,'Couldn\'t add the text label: name not specified.','en'),(69,69,'Couldn\'t add the text label: text label already exists.','en'),(70,70,'The text label has been added successfully','en'),(71,71,'The text label has been updated successfully','en'),(72,72,'The language you are trying to edit has not been found','en'),(73,73,'The language data has been saved','en'),(74,74,'The maximum upload file size is {{upload_max_filesize}}','en'),(75,75,'Search','en'),(76,76,'Next','en'),(77,77,'Custom HTML title','en'),(78,78,'Show category title','en'),(79,79,'Category icon','en'),(80,80,'Top banner','en'),(81,81,'<a href=\"https://devs.x-cart.com/en/how-to_articles/how_to_change_the_height_of_the_top_category_banner.html\">Learn more about the top banner and how it shows in the page layout</a>','en'),(82,82,'Meta tags','en'),(83,83,'Meta desc','en'),(84,84,'View image','en'),(85,85,'From computer','en'),(86,86,'Via URL','en'),(87,87,'Upload via URL','en'),(88,88,'Copy to file system','en'),(89,89,'Alt','en'),(90,90,'Copy','en'),(91,91,'Copy to clipboard','en'),(92,92,'Select file','en'),(93,93,'Undelete','en'),(94,94,'Show all labels','en'),(95,95,'{{n}} items found','en'),(96,96,'No modules found for \"<em>{{search_string}}</em>\"','en'),(97,97,'Language options','en'),(98,98,'{{language}} labels','en'),(99,99,'Select language','en'),(100,100,'No other languages defined','en'),(101,101,'Languages','en'),(102,102,'Help','en'),(103,103,'Knowledge Base','en'),(104,104,'Report a bug','en'),(105,105,'Translations','en'),(106,106,'X-Cart News','en'),(107,107,'Our Blog','en'),(108,108,'Clear fields','en'),(109,109,'New membership','en'),(110,110,'Any availability status','en'),(111,111,'Only enabled','en'),(112,112,'Only disabled','en'),(113,113,'Any class','en'),(114,114,'Default tax class','en'),(115,115,'Images','en'),(116,116,'Images Settings & Uploading','en'),(117,117,'Attributes','en'),(118,118,'Cloned products','en'),(119,119,'New category','en'),(120,120,'Subcat','en'),(121,121,'Main categories','en'),(122,122,'Add new label','en'),(123,123,'Add language','en'),(124,124,'{{n}} items total','en'),(125,125,'{{count}} item(s)','en'),(126,126,'Add new language','en'),(127,127,'Save','en'),(128,128,'Provide a translation of the text label into each of the languages used at your store. If the text label does not have a translation for a specific language, the translation of the label into the default language will be used instead. If the default language translation is also not available, the Label Name will be used.','en'),(129,129,'Purchase {{list}} license to install this add-on or','en'),(130,130,'Purchase {{list}} license to enable this add-on or','en'),(131,131,'The following modules will be disabled','en'),(132,132,'You can install these updates after <a href=\"{{URL}}\" target=\"_blank\">purchasing</a> and activating your X-Cart license key.','en'),(133,133,'Label name','en'),(134,134,'required','en'),(135,135,'Confirm deletion','en'),(136,136,'You are about to delete the {{language}} language. This operation is irreversible. Are you sure you want to continue?','en'),(137,137,'Delete','en'),(138,138,'Cancel','en'),(139,139,'{{language}} Language (Code: {{code}})','en'),(140,140,'Language name in {{language}}','en'),(141,141,'Native language name','en'),(142,142,'Disable','en'),(143,143,'Enable','en'),(144,144,'Set this language as default for the Customer area','en'),(145,145,'A disabled language cannot be set as default for the Customer area','en'),(146,146,'Delete Language','en'),(147,147,'Edit label','en'),(148,148,'Edit labels','en'),(149,149,'Please specify a pattern to find the required labels','en'),(150,150,'Module not found. Cannot uninstall.','en'),(151,151,'The module has been uninstalled successfully','en'),(152,152,'The {{module}} module has been uninstalled successfully','en'),(153,153,'The {{module}} module was installed with errors: the database was not updated correctly','en'),(154,154,'The {{module}} module was installed incorrectly. Please see logs for more information.','en'),(155,155,'The {{module}} module has been installed; however, the module has a wrong module control class','en'),(156,156,'The modules have been updated','en'),(157,157,'Congratulations! Your order has been placed.<br />You will receive your order confirmation shortly.','en'),(158,158,'{{count}} item in cart','en'),(159,159,'{{count}} items in cart','en'),(160,160,'Items in <a href=\"cart.php?target=cart\">your cart</a>: {{count}}','en'),(161,161,'See all {{count}} items','en'),(162,162,'Last added items','en'),(163,163,'Other items','en'),(164,164,'The selected shipping method has been deleted successfully','en'),(165,165,'The shipping methods have been updated','en'),(166,166,'The selected zones have been deleted successfully','en'),(167,167,'Zone details have been updated successfully','en'),(168,168,'The new zone has been created successfully','en'),(169,169,'This product is in <a href=\"{{href}}\">your cart</a>','en'),(170,170,'Your shopping cart - {{count}} item','en'),(171,171,'Your shopping cart - {{count}} items','en'),(172,172,'Greetings, {{name}}','en'),(173,173,'{{count}} items','en'),(174,174,'<div class=\"minicart-items-number\">{{count}}</div> <div class=\"minicart-items-text\">item</div>','en'),(175,175,'<div class=\"minicart-items-number\">{{count}}</div> <div class=\"minicart-items-text\">items</div>','en'),(176,176,'The email you provided is already in use. You can continue as guest or <a href=\"{{URL}}\" class=\"sign-in log-in\">Sign in</a>','en'),(177,177,'This user name is already taken. Please choose a different user name or <a href=\"{{URL}}\" class=\"log-in\">sign in</a>','en'),(178,178,'I accept the <a href=\"{{URL}}\" target=\"_blank\">Terms &amp; Conditions</a>','en'),(179,179,'By clicking the button above you confirm that you accept the <a href=\"{{URL}}\">Terms &amp; Conditions</a>','en'),(180,180,'Place order: {{total}}','en'),(181,181,'Proceed to payment: {{total}}','en'),(182,182,'Enter a correct email','en'),(183,183,'Enter an integer','en'),(184,184,'Enter a number','en'),(185,185,'Zero cannot be used','en'),(186,186,'Enter a positive number','en'),(187,187,'Enter a negative number','en'),(188,188,'This field is required','en'),(189,189,'\'{{field}}\' field is required','en'),(190,190,'Image #{{index}}','en'),(191,191,'Top {{count}} products','en'),(192,192,'\"{{name}}\" addon settings','en'),(193,193,'The benchmark evaluates server environment, namely:<br />1. File subsystem - read and write speed.<br />2. Database server - computing speed, DB data read and write speed.<br />3. Computing power - speed of computing and exchanging data in the memory.<br /><span>The total test time is the sum of the times taken by each of these tests.</span>','en'),(194,194,'Thank you for using {{company}} services','en'),(195,195,'The confirmation URL link was sent to {{email}}','en'),(196,196,'The confirmation URL link was sent','en'),(197,197,'An email with your account information was sent to {{email}}. Please make sure you can log in using the received data.','en'),(198,198,'Show filter options','en'),(199,199,'Customer note','en'),(200,200,'Customer','en'),(201,201,'Anonymous Customer','en'),(202,202,'Anonymous Customer, <a href=\"{{URL}}\">Registered User with the same email</a>','en'),(203,203,'Registered Customer','en'),(204,204,'Registered Customer, <a href=\"{{URL}}\">Anonymous Customer with the same email</a>','en'),(205,205,'The user will be registered; a password will be sent to the user via email','en'),(206,206,'Merge with Registered','en'),(207,207,'Invoice #{{id}}','en'),(208,208,'Welcome to X-Cart','en'),(209,209,'Quantity','en'),(210,210,'Total','en'),(211,211,'Cart is empty','en'),(212,212,'{{count}} item','en'),(213,213,'Items','en'),(214,214,'items','en'),(215,215,'Checkout','en'),(216,216,'Secure Checkout','en'),(217,217,'View cart','en'),(218,218,'Email address','en'),(219,219,'Password','en'),(220,220,'Recover password','en'),(221,221,'Your cart','en'),(222,222,'This is a demo store powered by X-Cart, using PHP5 templates technology and MySQL database.','en'),(223,223,'Price','en'),(224,224,'Product name','en'),(225,225,'Please clarify your search request or search in the <a href=\"{{marketplace}}\">Marketplace</a>','en'),(226,226,'Select one...','en'),(227,227,'Other','en'),(228,228,'Hello, {{name}}','en'),(229,229,'All','en'),(230,230,'None','en'),(231,231,'[Root level]','en'),(232,232,'-- No categories --','en'),(233,233,'Sort by','en'),(234,234,'Pending membership','en'),(235,235,'{{count}} result(s) found','en'),(236,236,'per page','en'),(237,237,'<span>{{count}}</span> order','en'),(238,238,'<span>{{count}}</span> orders','en'),(239,239,'Logged in!','en'),(240,240,'Log off','en'),(241,241,'Account settings','en'),(242,242,'User <strong>{{login}}</strong> is logged in.','en'),(243,243,'{{count}} products found','en'),(244,244,'Thank you for registering a customer account.<br />As a registered customer you can enjoy a simplified checkout process and review your order history.<br /><br />A registration confirmation message with your account details has been sent to your email <b>{profile.login}</b>.<br />Please use your registration email and password every time you place orders at our store.<br /><br />You are now logged in and welcome to continue shopping.','en'),(245,245,'<span class=\"begin-record-number\">{{begin}}</span>&ndash;<span class=\"end-record-number\">{{end}}</span> of <span class=\"records-count\">{{total}}</span>','en'),(246,246,'{{value}} bytes','en'),(247,247,'{{value}} kB','en'),(248,248,'{{value}} MB','en'),(249,249,'{{value}} GB','en'),(250,250,'Including {{name}}','en'),(251,251,'{{years}} year(s)','en'),(252,252,'{{months}} month(s)','en'),(253,253,'{{days}} day(s)','en'),(254,254,'{{hours}} hour(s)','en'),(255,255,'{{minutes}} minute(s)','en'),(256,256,'{{seconds}} second(s)','en'),(257,257,'Import will overwrite the existing product information. This operation cannot be undone.','en'),(258,258,'To find out the data format for import, you can create a sample data file <a href=\"{{url}}\">by exporting your existing products</a>. Then you can prepare your import file using the same format.','en'),(259,259,'Note that data import time will depend on the size of the file being imported.','en'),(260,260,'Cannot import the field \'{{name}}\': unknown field','en'),(261,261,'String is inconsistent with the title: the number of columns is {{wrong}} instead of {{right}}','en'),(262,262,'The required field \'{{name}}\' is not defined or empty. The product has not been created','en'),(263,263,'{{url}} image unable to load','en'),(264,264,'During import {{count}} errors were generated. For details, <a href=\"{{url}}\">download</a> the log files.','en'),(265,265,'Some products might have been imported incorrectly. Please check your catalog. Find the IDs of such products in the import log file above.','en'),(266,266,'Order #{{id}}, {{date}}','en'),(267,267,'Order #{{id}}','en'),(268,268,'The {{name}} field is empty','en'),(269,269,'The value of the {{name}} field must be greater than {{min}}','en'),(270,270,'The value of the {{name}} field must be less than {{max}}','en'),(271,271,'Incorrect value format in {{name}} field.','en'),(272,272,'The value of the {{name}} field must not be longer than {{max}}','en'),(273,273,'To boost your sales, try the \"<a href=\"{{discountCoupons}}\">Coupons</a>\", \"<a href=\"{{sale}}\">Sale</a>\", \"<a href=\"{{productAdvisor}}\">Product Advisor</a>\" and \"<a href=\"{{volumeDiscounts}}\">Volume Discounts</a>\" addons. You may also be interested in other <a href=\"{{marketingTag}}\">Marketing</a> extensions from our Marketplace','en'),(274,274,'Trying to access the shop at <a href=\"{{url}}\">{{url}}</a> ...','en'),(275,275,'To fix this problem take the following steps: <ul><li>make sure the HTTPS protocol is enabled by your hosting service provider;</li><li>check your HTTPS settings (the \'https_host\' parameter in the \'etc/config.php\' file must be valid);</li><li>reload this page.</li></ul>','en'),(276,276,'To upload the database data directly from your local computer, click \"Browse\", choose an SQL dump file and click \"Upload and restore\". This method is more convenient; however, it has a file size limitation of {{N}}.','en'),(277,277,'You may upload a file named sqldump.sql.php to the var/backup/ directory of your X-Cart installation on the web server and click \"Restore from server\".','en'),(278,278,'Maximum upload file size is {{N}}.','en'),(279,279,'Unable to install the module \"{{X}}\":  required modules have not been installed or activated.','en'),(280,280,'cannot set {{X}} permissions','en'),(281,281,'Incorrect owner of {{X}} directory','en'),(282,282,'Cannot set {{X}} permissions for subdirectories:','en'),(283,283,'Incorrect owner of {{X}} file','en'),(284,284,'File size exceeds the maximum size of ({{size}})','en'),(285,285,'File was not loaded due to a server side failure.','en'),(286,286,'{{count}} item available','en'),(287,287,'{{count}} items available','en'),(288,288,'{{count}} product(s) removed','en'),(289,289,'{{count}} product(s) created','en'),(290,290,'{{count}} entities  removed','en'),(291,291,'{{count}} entities created','en'),(292,292,'Select a country or a state from the list, specify the zone where the country or state should be listed and click \"Apply\". To select more than one country/state, hold down the CTRL key while selecting the items. A zone must contain either countries or states. You cannot include both states and countries into the same zone.','en'),(293,293,'If you store product images in the database, they are included in the SQL dump file. If the product images are located on the file system, they are not included in the SQL dump file. To back up such images you need to download them directly from the server.','en'),(294,294,'You can choose one of the following options:<ol class=\"styled\"><li>Download the database data (SQL dump) directly to your local computer - please click the \'Download SQL file\' button.</li><li>Save the database data as a file on the web server (\'var/backup/sqldump.sql.php\') - please click the \'Create SQL file\' button.</li></ol>','en'),(295,295,'Dear {{name}}!','en'),(296,296,'Thank you for your business. Please come back soon!','en'),(297,297,'{{percent}} off','en'),(298,298,'Placed on <span class=\"date\">{{date}}</span> by <span class=\"name\">{{name}}</span>','en'),(299,299,'Placed on <span class=\"date\">{{date}}</span> by <a href=\"{{url}}\" class=\"name\">{{name}}</a>','en'),(300,300,'Order Total: <span>{{total}}</span>','en'),(301,301,'Oops! Our payment system has not informed us whether your last order was paid for, or not. Is there a payment form that you have not completed yet? If so, please complete and submit it. Or you can quickly <a href=\"{{url}}\">re-order the products</a> from your last incomplete order.','en'),(302,302,'Payment transaction [method: {{trx_method}}, type: {{trx_type}}, amount: {{trx_value}}, status: {{trx_status}}]','en'),(303,303,'Back end payment transaction [method: {{trx_method}}, type: {{trx_type}}, amount: {{trx_value}}, status: {{trx_status}}]','en'),(304,304,'Trial period &mdash; {{X}} day(s) left','en'),(305,305,'Editing attribute groups on this page will not affect other product classes that use these groups. Removing a group does not delete attributes from the group, but makes them show up among other attributes having no associated groups.','en'),(306,306,'What\'s new','en'),(307,307,'Your account email is {{email}}','en'),(308,308,'Your account password is {{password}}','en'),(309,309,'Watch this short video and learn the basics of how online payment processing works. You will also find out what to look for when choosing the best payment processing solution for your business.','en'),(310,310,'{{count}} methods available','en'),(311,311,'The payment method has been enabled','en'),(312,312,'The payment method has been disabled','en'),(313,313,'The payment method has been removed','en'),(314,314,'The payment method has not been configured properly','en'),(315,315,'Duplicated clean URL: {{value}}','en'),(316,316,'Attributes for \"{{class}}\" product class','en'),(317,317,'{{count}} attributes in group','en'),(318,318,'Order {{order_number}} has been placed','en'),(319,319,'This module is available for X-Cart hosted stores only. <a href=\"{{url}}\">Click here for more information.</a>','en'),(320,320,'Low inventory products ({{count}})','en'),(321,321,'{{value}} orders yesterday','en'),(322,322,'{{value}} orders last week','en'),(323,323,'{{value}} orders last month','en'),(324,324,'{{value}} yesterday','en'),(325,325,'{{value}} last week','en'),(326,326,'{{value}} last month','en'),(327,327,'No orders yesterday','en'),(328,328,'No orders last week','en'),(329,329,'No orders last month','en'),(330,330,'No orders yet','en'),(331,331,'No orders','en'),(332,332,'To use the secure protocol you need an SSL certificate purchased for the \"<span>{{domain}}</span>\" domain and installed on your server.','en'),(333,333,'To enable the secure protocol for your website pages you need a valid SSL certificate purchased for the \"<span>{{domain}}</span>\" website domain and installed on your server.','en'),(334,334,'Pre-launch checklist:','en'),(335,335,'{{size}}','en'),(336,336,'Exported on {{date}}','en'),(337,337,'No write permissions to directory {{path}}. Please set the necessary permissions to directory {{path}}.','en'),(338,338,'Failed write to file {{path}}. There may not be enough disk space. Please check if there is enough disk space.','en'),(339,339,'Export is complete. <a href=\"{{url}}\">Check results and download</a>.','en'),(340,340,'This will increase the shipping cost by {{XX}}','en'),(341,341,'{{count}} products','en'),(342,342,'Subcategories: {{count}}','en'),(343,343,'Manage category: {{category_name}}','en'),(344,344,'Subcategories for','en'),(345,345,'OrderID or email, ID1-ID2 for range','en'),(346,346,'All Order Statuses','en'),(347,347,'Enter date range','en'),(348,348,'Authorized','en'),(349,349,'Shipped','en'),(350,350,'Cancelled','en'),(351,351,'Expired','en'),(352,352,'Refund requested','en'),(353,353,'Refunded','en'),(354,354,'Partially refunded','en'),(355,355,'Selected:','en'),(356,356,'Days','en'),(357,357,'Close','en'),(358,358,'MO','en'),(359,359,'TU','en'),(360,360,'WE','en'),(361,361,'TH','en'),(362,362,'FR','en'),(363,363,'SA','en'),(364,364,'SU','en'),(365,365,'JANUARY','en'),(366,366,'FEBRUARY','en'),(367,367,'MARCH','en'),(368,368,'APRIL','en'),(369,369,'MAY','en'),(370,370,'JUNE','en'),(371,371,'JULY','en'),(372,372,'AUGUST','en'),(373,373,'SEPTEMBER','en'),(374,374,'OCTOBER','en'),(375,375,'NOVEMBER','en'),(376,376,'DECEMBER','en'),(377,377,'Shortcuts','en'),(378,378,'Past','en'),(379,379,'7days','en'),(380,380,'14days','en'),(381,381,'30days','en'),(382,382,'Previous','en'),(383,383,'Week','en'),(384,384,'Month','en'),(385,385,'Quarter','en'),(386,386,'Year','en'),(387,387,'Date range should be longer than %d days','en'),(388,388,'Date range should be less than %d days','en'),(389,389,'Please select a date range longer than %d days','en'),(390,390,'Please select a date range shorter than %d days','en'),(391,391,'Please select a date range between %d and %d days','en'),(392,392,'Please select a date range','en'),(393,393,'Enter keyword','en'),(394,394,'All membership levels','en'),(395,395,'No membership','en'),(396,396,'All User Types','en'),(397,397,'Please select one ...','en'),(398,398,'Please select an option','en'),(399,399,'Search keywords','en'),(400,400,'Search payment method','en'),(401,401,'Any category','en'),(402,402,'Any status','en'),(403,403,'Search in','en'),(404,404,'{{count}} label(s)','en'),(405,405,'This language was added by the module {{module}} and cannot be removed.','en'),(406,406,'{{count}} language(s) removed','en'),(407,407,'{{count}} language label(s) removed','en'),(408,408,'No payment methods available. Please contact the <a href=\"mailto:{{email}}\">store administrator</a>.','en'),(409,409,'Edit states ({{count}})','en'),(410,410,'{{count}} state(s) removed','en'),(411,411,'{{count}} state(s) created','en'),(412,412,'{{count}} zone(s) removed','en'),(413,413,'{{count}} zone(s) created','en'),(414,414,'This is the default zone which matches all possible addresses.<br />The default zone can be edited but cannot be removed.','en'),(415,415,'Examples:<br /><br />2204%<br />38?45<br />23%<br /><br /><b>?</b> - any character<br /><b>%</b> - any character sequence, even empty','en'),(416,416,'Examples:<br /><br />New York<br />New%<br />%Y?rk<br /><br /><b>?</b> - any character<br /><b>%</b> - any character sequence, even empty','en'),(417,417,'Examples:<br /><br />%Water St%<br />%Coney Is?and%<br /><br /><b>?</b> - any character<br /><b>%</b> - any character sequence, even empty','en'),(418,418,'{{count}} shipping method(s) created','en'),(419,419,'{{count}} shipping method(s) removed','en'),(420,420,'Edit rates ({{count}})','en'),(421,421,'Your first name','en'),(422,422,'Your last name','en'),(423,423,'1000 Example street','en'),(424,424,'Example city','en'),(425,425,'California','en'),(426,426,'','en'),(427,427,'+12130000000','en'),(428,428,'','en'),(429,429,'Specification','en'),(430,430,'Not all the upgrade packs have been downloaded. This may have been caused by one of the following:<ul class=\'marked-list\'><li>slow Internet connection;</li><li>an internal problem on the Marketplace server;</li><li>a problem with your X-Cart license (expired license key, license key not matching the module license, etc.)</li></ul>','en'),(431,431,'A new customer? Enter your email','en'),(432,432,'ABA routing number','en'),(433,433,'Absolute','en'),(434,434,'Accept','en'),(435,435,'Orders','en'),(436,436,'Online methods','en'),(437,437,'Access denied!','en'),(438,438,'Access information','en'),(439,439,'Access is locked out','en'),(440,440,'Access level','en'),(441,441,'Account','en'),(442,442,'Account details','en'),(443,443,'Account status','en'),(444,444,'Account summary','en'),(445,445,'Activate license key','en'),(446,446,'Activate your paid module license','en'),(447,447,'Active','en'),(448,448,'Active from','en'),(449,449,'Active from','en'),(450,450,'Active till','en'),(451,451,'Active till','en'),(452,452,'Add','en'),(453,453,'Add Product','en'),(454,454,'Add alternative payment method','en'),(455,455,'Add category','en'),(456,456,'Add child','en'),(457,457,'Add discount','en'),(458,458,'Add featured products','en'),(459,459,'Add file','en'),(460,460,'Add image','en'),(461,461,'Add rate','en'),(462,462,'Add new','en'),(463,463,'Add new address','en'),(464,464,'Add new country','en'),(465,465,'Add new exception','en'),(466,466,'Add new membership level','en'),(467,467,'Add new option','en'),(468,468,'Add new option group','en'),(469,469,'Add new state','en'),(470,470,'Add offline payment method','en'),(471,471,'Add payment method','en'),(472,472,'Add shipping method','en'),(473,473,'Add subcategory','en'),(474,474,'Add user','en'),(475,475,'Add your <a href=\"{{URL}}\">products</a>','en'),(476,476,'Add zone','en'),(477,477,'Add-ons','en'),(478,478,'Add/update options','en'),(479,479,'Added','en'),(480,480,'Joined','en'),(481,481,'Added to cart','en'),(482,482,'Address','en'),(483,483,'Address book','en'),(484,484,'Address details','en'),(485,485,'Address field','en'),(486,486,'Address fields','en'),(487,487,'Address pattern','en'),(488,488,'Admin','en'),(489,489,'Administrator area','en'),(490,490,'Administrator','en'),(491,491,'All add-ons','en'),(492,492,'All customers','en'),(493,493,'All memberships','en'),(494,494,'All the necessary adaptation will be done by the developer (covered by extended warranty).','en'),(495,495,'All products on sale','en'),(496,496,'All shipping methods','en'),(497,497,'All address zones','en'),(498,498,'All the products are in sufficient quantities','en'),(499,499,'All time','en'),(500,500,'No merchant account required. Simple onboarding for you and easy checkout for your customers.','en'),(501,501,'Alphabetically','en'),(502,502,'Already have an account?','en'),(503,503,'Alternative payment methods','en'),(504,504,'Alternative text','en'),(505,505,'Amount','en'),(506,506,'Amount: high to low','en'),(507,507,'Amount: low to high','en'),(508,508,'An upgrade is a dangerous process that may result in a crashed website. It is strongly recommended to create a full backup of your store (the code and the database) and download it to a local computer before proceeding to the next step.','en'),(509,509,'Another state','en'),(510,510,'Any membership level','en'),(511,511,'Any product class','en'),(512,512,'Any zone','en'),(513,513,'Appearance','en'),(514,514,'Apply destination','en'),(515,515,'Apply price','en'),(516,516,'Are you sure you want to continue?','en'),(517,517,'Are you sure you want to delete the selected user?','en'),(518,518,'Are you sure you want to disable this add-on?','en'),(519,519,'Are you sure you want to enable this add-on?','en'),(520,520,'Are you sure you want to uninstall this add-on?','en'),(521,521,'Are you sure you want to delete the selected payment method?','en'),(522,522,'Are you sure you wish to delete the selected zones?','en'),(523,523,'Are you sure?','en'),(524,524,'Arrival date','en'),(525,525,'Asynchronous','en'),(526,526,'Ask.com','en'),(527,527,'Assigned classes','en'),(528,528,'Attachment has not been deleted','en'),(529,529,'Attachments','en'),(530,530,'Attachments have been updated successfully','en'),(531,531,'Australia Post settings','en'),(532,532,'Authentication','en'),(533,533,'Authentication code','en'),(534,534,'Author','en'),(535,535,'Authorization then capture','en'),(536,536,'Auto','en'),(537,537,'Availability','en'),(538,538,'Available for sale','en'),(539,539,'B','en'),(540,540,'Back to file select','en'),(541,541,'Back to layout settings','en'),(542,542,'Back to methods','en'),(543,543,'Back to orders list','en'),(544,544,'Back to top','en'),(545,545,'Backup','en'),(546,546,'Backup database','en'),(547,547,'Bank Account Number','en'),(548,548,'Benchmark completed in ','en'),(549,549,'Benchmark result under 3000ms is considered good','en'),(550,550,'Bestsellers','en'),(551,551,'Billing address','en'),(552,552,'Billing address is not defined yet','en'),(553,553,'Bing','en'),(554,554,'Brief description','en'),(555,555,'Brief description','en'),(556,556,'Browse server','en'),(557,557,'Buy more','en'),(558,558,'CLOSE','en'),(559,559,'CSS & JavaScript','en'),(560,560,'Cache rebuild is already started, please wait','en'),(561,561,'Calculate rates','en'),(562,562,'Cannot be disabled. The module is required by:','en'),(563,563,'Can\'t connect to the App Store server','en'),(564,564,'Capture status','en'),(565,565,'Cart & checkout','en'),(566,566,'Catalog','en'),(567,567,'Categories','en'),(568,568,'Category','en'),(569,569,'Category info','en'),(570,570,'Category name','en'),(571,571,'Category name contains invalid UTF-8 characters or 4-byte UTF-8 characters which are not supported. Please correct and try again.','en'),(572,572,'Category page title','en'),(573,573,'Category path contains invalid UTF-8 characters or 4-byte UTF-8 characters which are not supported. Please correct and try again.','en'),(574,574,'Change','en'),(575,575,'Change address','en'),(576,576,'Change method','en'),(577,577,'Change options','en'),(578,578,'Change payment info','en'),(579,579,'Change shipping info','en'),(580,580,'Change shipping info','en'),(581,581,'Check all','en'),(582,582,'Check number','en'),(583,583,'Checking','en'),(584,584,'Checking integrity, please wait...','en'),(585,585,'Choose','en'),(586,586,'Choose <a href=\"{{URL}}\">payment methods</a>','en'),(587,587,'Choose file','en'),(588,588,'Choose from a variety of bundled payment solutions to accept credit cards and other methods of payment on your website','en'),(589,589,'Choose method','en'),(590,590,'Choose shipping method','en'),(591,591,'City','en'),(592,592,'Clean URL','en'),(593,593,'Enable clean URL','en'),(594,594,'Error code explanation:','en'),(595,595,'Internal server error','en'),(596,596,'More information about clean urls in X-Cart is available in <a href=\"{{url}}\" target=\"blank\">{{url}}</a>','en'),(597,597,'We made a test request to <a href=\"{{url}}\">{{url}}</a> URL and got the following result (It means that your SEO-friendly URLs may not work properly after enabling).','en'),(598,598,'Clear aggregation cache','en'),(599,599,'Clear widgets cache','en'),(600,600,'CleanURL','en'),(601,601,'Empty your cart','en'),(602,602,'Click here to access/add subcategories','en'),(603,603,'Click here to view states of country','en'),(604,604,'Click to unblock','en'),(605,605,'Close storefront','en'),(606,606,'Code','en'),(607,607,'Comment','en'),(608,608,'Comments','en'),(609,609,'Company','en'),(610,610,'Company name','en'),(611,611,'Completed','en'),(612,612,'Component','en'),(613,613,'Configuration','en'),(614,614,'Configure <a href=\"{{URL}}\">shipping methods</a>','en'),(615,615,'Configure your store','en'),(616,616,'Confirm password','en'),(617,617,'Contacts','en'),(618,618,'Content','en'),(619,619,'Continue','en'),(620,620,'Copy file to local server','en'),(621,621,'Core version: ','en'),(622,622,'Countries','en'),(623,623,'Countries, states & zones','en'),(624,624,'Country','en'),(625,625,'Country is not selected','en'),(626,626,'Coupon code','en'),(627,627,'Coupons','en'),(628,628,'Create','en'),(629,629,'Create profile','en'),(630,630,'Create SQL file','en'),(631,631,'Create a backup','en'),(632,632,'Create account','en'),(633,633,'Create an account for later use','en'),(634,634,'Create category','en'),(635,635,'Create new account','en'),(636,636,'Created','en'),(637,637,'Currency','en'),(638,638,'Custom add-ons','en'),(639,639,'Custom CSS','en'),(640,640,'Custom JavaScript','en'),(641,641,'Custom images','en'),(642,642,'Custom translation','en'),(643,643,'Customer zip/postal code','en'),(644,644,'Clean URLs are disabled. <a target=\'_blank\' href=\'{{more_info_url}}\'>More info</a>','en'),(645,645,'Clean URLs are enabled','en'),(646,646,'Clean URLs are disabled','en'),(647,647,'Enable clean URLs','en'),(648,648,'Clean URLs functionality may not be enabled. <a target=\'_blank\' href=\'{{article_url}}\'>More info<i class=\'icon fa fa-external-link\'></i></a>','en'),(649,649,'More information on Clean URL problems on your system','en'),(650,650,'The data has been deleted successfully','en'),(651,651,'The data has been saved successfully','en'),(652,652,'Database backup has been created successfully','en'),(653,653,'Date','en'),(654,654,'Day','en'),(655,655,'Dear','en'),(656,656,'Dear customer!','en'),(657,657,'Decline','en'),(658,658,'Declined','en'),(659,659,'Default','en'),(660,660,'Default customer address','en'),(661,661,'Default for Customer area and cannot be disabled or deleted','en'),(662,662,'Default for Customer area and cannot be disabled or deleted','en'),(663,663,'Default images settings','en'),(664,664,'The powerful shopping cart software for web stores and e-commerce enabled stores is based on PHP5 with SQL database with highly configurable implementation based on templates','en'),(665,665,'All Addresses (default zone)','en'),(666,666,'Define classes','en'),(667,667,'Delete SQL file','en'),(668,668,'Delete all','en'),(669,669,'Delete profile','en'),(670,670,'Delete selected','en'),(671,671,'Delete selected profile','en'),(672,672,'Delete the image','en'),(673,673,'Delete this address?','en'),(674,674,'Delivery methods','en'),(675,675,'Destination zone','en'),(676,676,'Details','en'),(677,677,'Directory and file permissions','en'),(678,678,'Disable all modules in the system','en'),(679,679,'Disable suspicious modules','en'),(680,680,'Disabled','en'),(681,681,'A disabled language cannot be set as default for Customer area','en'),(682,682,'Discount','en'),(683,683,'Discount amount','en'),(684,684,'Discount type','en'),(685,685,'Display \'inc/ex VAT\' labels next to prices','en'),(686,686,'Display type','en'),(687,687,'Do not close this page!','en'),(688,688,'Do not show at startup anymore','en'),(689,689,'Do you really want to delete the selected items?','en'),(690,690,'Dont have account yet?','en'),(691,691,'Download SQL file','en'),(692,692,'Downloaded components','en'),(693,693,'Downloading updates','en'),(694,694,'Downloading updates, please wait...','en'),(695,695,'Drag and drop me to the cart','en'),(696,696,'Drop items here to shop','en'),(697,697,'Drupal front end','en'),(698,698,'Email','en'),(699,699,'Email is not defined yet','en'),(700,700,'Edit charges for:','en'),(701,701,'Edit payment method data','en'),(702,702,'Edit page','en'),(703,703,'Edit profile','en'),(704,704,'Email','en'),(705,705,'Email &amp; password','en'),(706,706,'Email body','en'),(707,707,'Email settings','en'),(708,708,'Enable HTTPS','en'),(709,709,'Enabled','en'),(710,710,'Enter coupon code','en'),(711,711,'Enter keywords','en'),(712,712,'Enter license key','en'),(713,713,'Enter shipping address','en'),(714,714,'Enter {{X}} more characters to start search','en'),(715,715,'Environment','en'),(716,716,'Environment info','en'),(717,717,'Error','en'),(718,718,'Estimate shipping cost','en'),(719,719,'Estimate your server performance','en'),(720,720,'Estimated for','en'),(721,721,'Everything you need','en'),(722,722,'Example','en'),(723,723,'Examples','en'),(724,724,'Exception','en'),(725,725,'Extend the functionality of your store by installing and using add-on modules','en'),(726,726,'Export','en'),(727,727,'Export products','en'),(728,728,'Extensions','en'),(729,729,'Facebook','en'),(730,730,'Failed','en'),(731,731,'Failed to add the detailed image','en'),(732,732,'Failed to add the attachment','en'),(733,733,'Failed to add the attachment. The file download is forbidden','en'),(734,734,'Failed/Declined','en'),(735,735,'Featured products','en'),(736,736,'Field is required!','en'),(737,737,'File title','en'),(738,738,'Find us on','en'),(739,739,'Find us on Facebook','en'),(740,740,'First name','en'),(741,741,'Flat rate','en'),(742,742,'Footer menu','en'),(743,743,'For the period','en'),(744,744,'Forgot password?','en'),(745,745,'Format','en'),(746,746,'Free add-ons','en'),(747,747,'From','en'),(748,748,'from','en'),(749,749,'Selected countries:','en'),(750,750,'Selected countries','en'),(751,751,'All states','en'),(752,752,'Selected states','en'),(753,753,'Back to Zones list','en'),(754,754,'Attributes block','en'),(755,755,'From email','en'),(756,756,'Full description','en'),(757,757,'Full name','en'),(758,758,'General','en'),(759,759,'General Settings','en'),(760,760,'General info','en'),(761,761,'General settings','en'),(762,762,'Give buyers a way to pay by adding an alternative payment method.','en'),(763,763,'Give buyers another way to pay by adding an alternative payment method','en'),(764,764,'Go to Marketplace','en'),(765,765,'Go to checkout','en'),(766,766,'Grid','en'),(767,767,'Group options','en'),(768,768,'Here\'s a new link for access to your information: <a href=\"{{link}}\">{{link}}</a>','en'),(769,769,'HTML title (\'title\' tag)','en'),(770,770,'HTTPS check','en'),(771,771,'HTTPS settings','en'),(772,772,'Restores to current state of active addons (use in case of emergency)','en'),(773,773,'Disables all addons except ones that are provided by X-Cart Team (hard reset)','en'),(774,774,'Disables all addons except ones that are provided by X-Cart Team & Qualiteam (soft reset)','en'),(775,775,'Disables all addons (core reset)','en'),(776,776,'Have a discount coupon?','en'),(777,777,'Height (px)','en'),(778,778,'Help zone','en'),(779,779,'The list below shows only the methods enabled on the configuration page','en'),(780,780,'Here you can define how your payment methods will look in the Customer area','en'),(781,781,'Hide','en'),(782,782,'Hide trailing zeros in fractional part','en'),(783,783,'History','en'),(784,784,'Home','en'),(785,785,'How to','en'),(786,786,'How to back up your store database','en'),(787,787,'How to define address zones','en'),(788,788,'I understand that these add-ons may require an adaptation.','en'),(789,789,'Icons','en'),(790,790,'Identity','en'),(791,791,'If any critical errors have occurred, you can do the following','en'),(792,792,'If you choose the second option, you can download the file from the server later on and delete it from the server by clicking on the \'Delete SQL file\' button.','en'),(793,793,'If you do not have an account, you can easily','en'),(794,794,'If you don\'t have a moneybookers account yet, please sign up for a free moneybookers account at: http://www.skrill.com','en'),(795,795,'If you have a license key for a commercial module, you can enter it here to register the purchase of the module.','en'),(796,796,'If you have a plugin in the .tar format, you can install it by uploading it here','en'),(797,797,'Image','en'),(798,798,'Image border will not be displayed in the storefront','en'),(799,799,'Image has been identified as a duplicate and has not been imported: {{value}}','en'),(800,800,'Import','en'),(801,801,'Import / Export','en'),(802,802,'Import from file','en'),(803,803,'Import/Export','en'),(804,804,'Important','en'),(805,805,'In category','en'),(806,806,'In stock','en'),(807,807,'Inactive','en'),(808,808,'Incl. X','en'),(809,809,'Incomplete','en'),(810,810,'InnoDB engine support enabled','en'),(811,811,'Install','en'),(812,812,'Install add-on','en'),(813,813,'Install updates','en'),(814,814,'Installation directory','en'),(815,815,'Installed','en'),(816,816,'Installed Modules','en'),(817,817,'Installed modules','en'),(818,818,'Installing updates, please wait...','en'),(819,819,'Invalid login or password','en'),(820,820,'Invalid login or password. <br/><span class=\"common-text\">You can use the \'Forgot password?\' link to reset your password.</span>','en'),(821,821,'Inventory status','en'),(822,822,'Inventory tracking','en'),(823,823,'Inventory tracking','en'),(824,824,'Invoice','en'),(825,825,'It is not possible to delete or create user accounts because your store currently works as an integration with Drupal and shares users with Drupal. Deleting/creating user accounts is possible via Drupal administrator interface.','en'),(826,826,'It is not possible to edit some user profile fields because your store currently works as an integration with Drupal and shares users with Drupal. Modifying these fields is possible via Drupal administrator interface.','en'),(827,827,'Item description','en'),(828,828,'Item(s) deleted from your cart','en'),(829,829,'Item name','en'),(830,830,'Items per page','en'),(831,831,'Join forces with your bank','en'),(832,832,'K','en'),(833,833,'Language','en'),(834,834,'Language labels','en'),(835,835,'Last logged in','en'),(836,836,'Last login','en'),(837,837,'Last name','en'),(838,838,'License key has been successfully verified for the \"{{name}}\" module by \"{{author}}\" ','en'),(839,839,'Lifetime','en'),(840,840,'Limit the number of uses','en'),(841,841,'Link','en'),(842,842,'List','en'),(843,843,'List of states','en'),(844,844,'Loading...','en'),(845,845,'Localization','en'),(846,846,'Log in','en'),(847,847,'Log out','en'),(848,848,'Logged as','en'),(849,849,'Login','en'),(850,850,'Log in here','en'),(851,851,'Login history','en'),(852,852,'Look & Feel','en'),(853,853,'Low stock notification for this product is','en'),(854,854,'Low stock threshold','en'),(855,855,'Low stock','en'),(856,856,'M','en'),(857,857,'Maintenance','en'),(858,858,'Maintenance and operation','en'),(859,859,'Back up your store\'s database','en'),(860,860,'Manage catalog','en'),(861,861,'Manage categories','en'),(862,862,'Manage customer and administrator accounts','en'),(863,863,'Manage layout','en'),(864,864,'Manage orders','en'),(865,865,'Manage orders placed at your store','en'),(866,866,'Manage users','en'),(867,867,'Manage administrators','en'),(868,868,'Manage your product inventory','en'),(869,869,'Required fields are marked with an asterisk','en'),(870,870,'Manually defined shipping methods','en'),(871,871,'Mark the search engines you want to inform of the structure of your site using the site map','en'),(872,872,'Market price','en'),(873,873,'App Store','en'),(874,874,'Marketplace [check_addon_key]: the \"{{url}}\" URL requested','en'),(875,875,'Marketplace [check_for_updates]: the \"{{url}}\" URL requested','en'),(876,876,'Marketplace [check_for_updates]: valid response received','en'),(877,877,'Marketplace [get_hosting_score]: response has an invalid format','en'),(878,878,'Marketplace [get_hosting_score]: the \"{{url}}\" URL requested','en'),(879,879,'Rate per item','en'),(880,880,'Rate per weight unit','en'),(881,881,'Membership','en'),(882,882,'Membership access','en'),(883,883,'Membership levels','en'),(884,884,'Membership name','en'),(885,885,'Memberships','en'),(886,886,'Menus','en'),(887,887,'Message','en'),(888,888,'Meta description','en'),(889,889,'Meta keywords','en'),(890,890,'Methods','en'),(891,891,'Modify','en'),(892,892,'Modify \"{{name}}\" option group','en'),(893,893,'Modify category','en'),(894,894,'Modify option group exceptions','en'),(895,895,'Modify root category (the store\'s front page)','en'),(896,896,'The module has been successfully installed','en'),(897,897,'Addons Marketplace','en'),(898,898,'More add-ons','en'),(899,899,'More details','en'),(900,900,'Most Popular','en'),(901,901,'Most Rated','en'),(902,902,'Move','en'),(903,903,'My account','en'),(904,904,'MySQL server','en'),(905,905,'Name','en'),(906,906,'Name of address field','en'),(907,907,'Name of purchaser','en'),(908,908,'Bank name','en'),(909,909,'Name of account holder','en'),(910,910,'Never','en'),(911,911,'New access link','en'),(912,912,'New access key will also be sent to the Site administrator\'s email address','en'),(913,913,'New address field','en'),(914,914,'New discount coupon','en'),(915,915,'New image','en'),(916,916,'New item','en'),(917,917,'New page','en'),(918,918,'New product class','en'),(919,919,'The new product has been added successfully','en'),(920,920,'New rate','en'),(921,921,'New role','en'),(922,922,'Newest','en'),(923,923,'Newest first','en'),(924,924,'Next','en'),(925,925,'Next page','en'),(926,926,'No','en'),(927,927,'No countries found','en'),(928,928,'No products are featured in this category','en'),(929,929,'No image','en'),(930,930,'No images uploaded','en'),(931,931,'No items found.','en'),(932,932,'No merchant account required','en'),(933,933,'No orders have been placed yet','en'),(934,934,'No orders have been placed yet','en'),(935,935,'No payment modules installed','en'),(936,936,'No products sold yet','en'),(937,937,'No states found','en'),(938,938,'No tax rates defined','en'),(939,939,'Non-administrator','en'),(940,940,'Not finished','en'),(941,941,'Not a numeric value','en'),(942,942,'Note','en'),(943,943,'Notes','en'),(944,944,'This setting is inactive because \"Low stock warning\" notifications are disabled. You can enable them <a href=\"{{link}}\">here</a>.','en'),(945,945,'Off','en'),(946,946,'Official website','en'),(947,947,'Offline methods','en'),(948,948,'Old price','en'),(949,949,'On','en'),(950,950,'On all catalog pages','en'),(951,951,'On product details pages only','en'),(952,952,'Online catalog structure setup','en'),(953,953,'Only lowercase letters, digits and undescore character are allowed','en'),(954,954,'Open Graph meta tags','en'),(955,955,'Open graph tags','en'),(956,956,'Open storefront','en'),(957,957,'Operating system','en'),(958,958,'Option group','en'),(959,959,'The options have been successfully updated','en'),(960,960,'Order','en'),(961,961,'Order #','en'),(962,962,'Order ID','en'),(963,963,'Order Total','en'),(964,964,'Order date from','en'),(965,965,'Order date through','en'),(966,966,'Order details','en'),(967,967,'Order id','en'),(968,968,'Order items','en'),(969,969,'Order note','en'),(970,970,'Order page','en'),(971,971,'Order review','en'),(972,972,'Order statistics','en'),(973,973,'Order status','en'),(974,974,'Orders','en'),(975,975,'Orders count','en'),(976,976,'Orders placed','en'),(977,977,'Out of stock','en'),(978,978,'Pack it','en'),(979,979,'Page','en'),(980,980,'Page URL','en'),(981,981,'Page name','en'),(982,982,'Page not found','en'),(983,983,'Pages','en'),(984,984,'Paid','en'),(985,985,'Parent category','en'),(986,986,'Password and its confirmation do not match','en'),(987,987,'Pattern search','en'),(988,988,'All payment methods','en'),(989,989,'Payment info','en'),(990,990,'Payment instructions','en'),(991,991,'Payment method','en'),(992,992,'Payment methods','en'),(993,993,'Payment method data','en'),(994,994,'Payment data ({{method}})','en'),(995,995,'Payment settings','en'),(996,996,'Payment transaction ID','en'),(997,997,'Payment transactions','en'),(998,998,'Payment methods','en'),(999,999,'Pending','en'),(1000,1000,'Pending memberships','en'),(1001,1001,'Per item rate','en'),(1002,1002,'Per weight unit rate','en'),(1003,1003,'Percent','en'),(1004,1004,'Percent rate','en'),(1005,1005,'Percent off','en'),(1006,1006,'Perform order search','en'),(1007,1007,'Performance','en'),(1008,1008,'Permissions','en'),(1009,1009,'Not enough permissions to run the process. Make sure the following permissions are set (UNIX-like systems only).<br />Such permissions are required for a seamless automated installation or upgrade of X-Cart on your server. They do not take into account the specific configuration of your server or any security requirements. Once the process is completed, make sure you change the permissions to a more restrictive setting. <a target=\'_blank\' href=\'https://kb.x-cart.com/en/setting_up_x-cart_5_environment/secure_configuration.html#why-x-cart-asks-for-666777-permissions\'>Read more</a>','en'),(1010,1010,'Personal info','en'),(1011,1011,'Phone','en'),(1012,1012,'Pick address from address book','en'),(1013,1013,'Place order','en'),(1014,1014,'Please accept the Terms and Conditions to continue','en'),(1015,1015,'Please choose the appropriate action','en'),(1016,1016,'Please enable JavaScript in your web browser.','en'),(1017,1017,'Please identify yourself','en'),(1018,1018,'Please note that some of these modules are incompatible with the upcoming upgrade and will be disabled in order to prevent a system crash','en'),(1019,1019,'Run benchmark to estimate your server performance','en'),(1020,1020,'Please save the soft reset and hard reset links so you can use them later in case your website crashes','en'),(1021,1021,'Please select one','en'),(1022,1022,'Pos','en'),(1023,1023,'Pos.','en'),(1024,1024,'Pos.:','en'),(1025,1025,'Position','en'),(1026,1026,'Prefix','en'),(1027,1027,'Pre-upgrade action required','en'),(1028,1028,'Some of the modules used by your store contain code that must be executed before the upgrade process begins. For the code to be executed successfully, the modules must be enabled. However, some of the modules containing such code are now disabled. This will prevent the pre-upgrade code from execution and is highly likely to cause problems, like a fatal error.<br /><br />Listed below are the modules that contain pre-upgrade code and are disabled. Here you can specify the modules for which you want the pre-upgrade code to be executed:','en'),(1029,1029,'Execute','en'),(1030,1030,'Do not execute','en'),(1031,1031,'Please note that we may not be held responsible for any upgrade problems caused by failure to execute the required pre-upgrade code.','en'),(1032,1032,'Prev','en'),(1033,1033,'Previous page','en'),(1034,1034,'Price modifier','en'),(1035,1035,'Price: Not a numeric value','en'),(1036,1036,'Price','en'),(1037,1037,'Name','en'),(1038,1038,'Primary menu','en'),(1039,1039,'Print invoice','en'),(1040,1040,'Processed','en'),(1041,1041,'Processed/Completed','en'),(1042,1042,'Product Name','en'),(1043,1043,'Product SKU','en'),(1044,1044,'Product Title','en'),(1045,1045,'Product has been added to your cart','en'),(1046,1046,'Product class','en'),(1047,1047,'Product classes','en'),(1048,1048,'Product has been created','en'),(1049,1049,'Product has been updated','en'),(1050,1050,'Product has been added to your cart','en'),(1051,1051,'Product images','en'),(1052,1052,'Product info','en'),(1053,1053,'Product info has been updated successfully','en'),(1054,1054,'Product is out of stock','en'),(1055,1055,'Product on sale','en'),(1056,1056,'Product options','en'),(1057,1057,'Product page title','en'),(1058,1058,'Product prices are defined including this tax calculated for','en'),(1059,1059,'Products','en'),(1060,1060,'Products in cart','en'),(1061,1061,'Product information has been successfully updated','en'),(1062,1062,'Products with low inventory','en'),(1063,1063,'Profile','en'),(1064,1064,'The profile has been created successfully','en'),(1065,1065,'The profile has been deleted successfully','en'),(1066,1066,'The profile has been updated successfully','en'),(1067,1067,'Profile settings','en'),(1068,1068,'Promotions','en'),(1069,1069,'Properties','en'),(1070,1070,'Purchase','en'),(1071,1071,'Purchase SSL certificate','en'),(1072,1072,'PO number','en'),(1073,1073,'Put up selected for sale','en'),(1074,1074,'Qty','en'),(1075,1075,'Qty.','en'),(1076,1076,'Quantity: high to low','en'),(1077,1077,'Quantity: low to high','en'),(1078,1078,'Queued','en'),(1079,1079,'Quick and easy setup','en'),(1080,1080,'Rate','en'),(1081,1081,'Rates','en'),(1082,1082,'Rates / Conditions','en'),(1083,1083,'Raw online rate (on-line rate)','en'),(1084,1084,'Re-build cache','en'),(1085,1085,'Re-generate access key','en'),(1086,1086,'Re-order','en'),(1087,1087,'Redirect customers to HTTPS','en'),(1088,1088,'Recommended','en'),(1089,1089,'Referer','en'),(1090,1090,'Register','en'),(1091,1091,'Registered','en'),(1092,1092,'Remove','en'),(1093,1093,'Required','en'),(1094,1094,'Required PHP extensions are missing: {{extensions}}','en'),(1095,1095,'Some of them require a registered merchant account','en'),(1096,1096,'Re-run benchmark','en'),(1097,1097,'Resend the secret link to renew access','en'),(1098,1098,'Response from Marketplace not received','en'),(1099,1099,'Response from Marketplace: ','en'),(1100,1100,'Restore','en'),(1101,1101,'Restore database','en'),(1102,1102,'Restore from server','en'),(1103,1103,'Restore last backup','en'),(1104,1104,'Restore links','en'),(1105,1105,'Return to Drupal','en'),(1106,1106,'Revenue','en'),(1107,1107,'Review statistics on the various aspects of your store\'s operation','en'),(1108,1108,'Role','en'),(1109,1109,'Roles','en'),(1110,1110,'Root Level','en'),(1111,1111,'Root access','en'),(1112,1112,'Root category','en'),(1113,1113,'Run Benchmark again','en'),(1114,1114,'Run benchmark','en'),(1115,1115,'SKU: a-z','en'),(1116,1116,'SKU: z-a','en'),(1117,1117,'SMTP server','en'),(1118,1118,'STORE SETUP','en'),(1119,1119,'SYSTEM SETTINGS','en'),(1120,1120,'Safe mode','en'),(1121,1121,'Safe mode access key','en'),(1122,1122,'Sale','en'),(1123,1123,'Sale price','en'),(1124,1124,'Sale statistics since the opening of the store','en'),(1125,1125,'Sales','en'),(1126,1126,'Sales tax','en'),(1127,1127,'Save as new','en'),(1128,1128,'Save changes','en'),(1129,1129,'Save zone details','en'),(1130,1130,'Savings','en'),(1131,1131,'Search for modules','en'),(1132,1132,'Search for orders','en'),(1133,1133,'Search for users','en'),(1134,1134,'Search for users that are','en'),(1135,1135,'Search in subcategories','en'),(1136,1136,'Search product','en'),(1137,1137,'Search profiles','en'),(1138,1138,'Search result','en'),(1139,1139,'Search results','en'),(1140,1140,'Secure connection cannot be established.','en'),(1141,1141,'Security','en'),(1142,1142,'Security settings','en'),(1143,1143,'Select country','en'),(1144,1144,'Select options','en'),(1145,1145,'Select status','en'),(1146,1146,'Send','en'),(1147,1147,'Send test email','en'),(1148,1148,'Send to {{email}}','en'),(1149,1149,'SEO settings','en'),(1150,1150,'Service name','en'),(1151,1151,'Service name of address field','en'),(1152,1152,'Set','en'),(1153,1153,'Set the sale price','en'),(1154,1154,'Settings','en'),(1155,1155,'Set up <a href=\"{{URL1}}\">address zones</a> and <a href=\"{{URL2}}\">taxes</a>','en'),(1156,1156,'Shipping & Taxes','en'),(1157,1157,'Shipping address','en'),(1158,1158,'Shipping address is not completly defined yet','en'),(1159,1159,'Shipping address is not defined','en'),(1160,1160,'Shipping address is not defined yet','en'),(1161,1161,'Shipping info','en'),(1162,1162,'The shipping rate has been created successfully','en'),(1163,1163,'The shipping rates have been updated','en'),(1164,1164,'Shipping method','en'),(1165,1165,'The shipping method has been added','en'),(1166,1166,'Shipping methods','en'),(1167,1167,'Shipping methods are not available','en'),(1168,1168,'Shipping rates','en'),(1169,1169,'Shipping settings','en'),(1170,1170,'Address zones','en'),(1171,1171,'There\'s a minimum purchase limit of {{minQuantity}}. The number of units of the product \'{{productName}}\' in cart has been adjusted to reach this limit.','en'),(1172,1172,'There\'s a maximum purchase limit of {{maxQuantity}}. The number of units of the product \'{{productName}}\' in cart has been adjusted to reach this limit.','en'),(1173,1173,'Carrier','en'),(1174,1174,'Order tracking information','en'),(1175,1175,'Track package','en'),(1176,1176,'Send tracking info','en'),(1177,1177,'Tracking numbers are not added yet','en'),(1178,1178,'Tracking numbers','en'),(1179,1179,'\"{{number}}\" tracking number has been added','en'),(1180,1180,'\"{{number}}\" tracking number has been removed','en'),(1181,1181,'Tracking number has been changed from \"{{old_number}}\" to \"{{new_number}}\"','en'),(1182,1182,'Add tracking number','en'),(1183,1183,'Tracking information has been sent','en'),(1184,1184,'Shopping cart','en'),(1185,1185,'Show social buttons','en'),(1186,1186,'Sign in','en'),(1187,1187,'Sign out','en'),(1188,1188,'Size','en'),(1189,1189,'Common tax settings','en'),(1190,1190,'Hide settings','en'),(1191,1191,'Display settings','en'),(1192,1192,'Rename label','en'),(1193,1193,'<strong>Disables all modules except for the ones that were downloaded from the Marketplace</strong>(soft reset)','en'),(1194,1194,'Specify your <a href=\"{{URL}}\">store information</a>','en'),(1195,1195,'Speed up your store','en'),(1196,1196,'Start selling!','en'),(1197,1197,'State','en'),(1198,1198,'States','en'),(1199,1199,'The states have been deleted successfully','en'),(1200,1200,'The states have been updated successfully','en'),(1201,1201,'Statistics','en'),(1202,1202,'Status','en'),(1203,1203,'Store Maintenance','en'),(1204,1204,'Store currency','en'),(1205,1205,'Store profile','en'),(1206,1206,'Store is closed','en'),(1207,1207,'Store is open','en'),(1208,1208,'Store setup','en'),(1209,1209,'Storefront','en'),(1210,1210,'Subcategories','en'),(1211,1211,'Subject','en'),(1212,1212,'Substring','en'),(1213,1213,'Subtotal range (begin)','en'),(1214,1214,'Subtotal range (end)','en'),(1215,1215,'Successfully imported X new products','en'),(1216,1216,'Successfully imported X new products and updated Y existing products','en'),(1217,1217,'Successfully updated Y products','en'),(1218,1218,'Suffix','en'),(1219,1219,'Synchronous','en'),(1220,1220,'System settings','en'),(1221,1221,'Table','en'),(1222,1222,'Tax disabled','en'),(1223,1223,'Tax enabled','en'),(1224,1224,'The tax has been disabled successfully','en'),(1225,1225,'The tax has been enabled successfully','en'),(1226,1226,'The tax rates have been updated successfully','en'),(1227,1227,'Tax rate has been deleted successfully','en'),(1228,1228,'Tax rate has not been deleted','en'),(1229,1229,'Tax title','en'),(1230,1230,'Taxes','en'),(1231,1231,'Teaser','en'),(1232,1232,'Test email configuration','en'),(1233,1233,'Test shipping rates','en'),(1234,1234,'Tester','en'),(1235,1235,'Text','en'),(1236,1236,'Thank you for your order','en'),(1237,1237,'The SSL certificate installed for your custom website domain is not valid.','en'),(1238,1238,'The SSL certificate installed on your server is not valid. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.','en'),(1239,1239,'The X language has been added and enabled successfully','en'),(1240,1240,'The attachment has been added successfully','en'),(1241,1241,'The changes will be applied to all selected products','en'),(1242,1242,'The detailed image has been added successfully','en'),(1243,1243,'The detailed image has been deleted','en'),(1244,1244,'The detailed images have been updated successfully','en'),(1245,1245,'The exceptions have been updated successfully','en'),(1246,1246,'To enable this add-on, the following add-on(s) must be enabled','en'),(1247,1247,'To enable this add-on, the following add-on(s) must be disabled','en'),(1248,1248,'The following categories were selected to be removed','en'),(1249,1249,'The following dependent add-ons will be disabled automatically','en'),(1250,1250,'The image has been updated','en'),(1251,1251,'The HTTPS protocol is enabled for your website','en'),(1252,1252,'The import is in progress','en'),(1253,1253,'The import will start immediately upon selecting the data file. No additional confirmation prompts will appear.','en'),(1254,1254,'The language you want to delete is the default application language and cannot be deleted','en'),(1255,1255,'The language you want to delete is the default interface language and cannot be deleted','en'),(1256,1256,'The maximum number of uses','en'),(1257,1257,'The module has been partially uninstalled','en'),(1258,1258,'The module is not compatible with your X-Cart version','en'),(1259,1259,'The page has been added','en'),(1260,1260,'The product option group has been added successfully','en'),(1261,1261,'The product option group has been updated successfully','en'),(1262,1262,'The product option groups have been updated successfully','en'),(1263,1263,'Failed to update the product option groups','en'),(1264,1264,'The requested page could not be found.','en'),(1265,1265,'Sorry, this page is no longer available.','en'),(1266,1266,'Sorry, this product is no longer available.','en'),(1267,1267,'Sorry, this category is no longer available.','en'),(1268,1268,'If you continue having trouble finding what you are looking for please contact our customer service department.','en'),(1269,1269,'Go to home page','en'),(1270,1270,'The restoration procedure is irreversible and erases all existing data tables from your store\'s database. It is highly recommended that you back up the data currently stored in the database before restoring a past version of your database from backup.','en'),(1271,1271,'The same as shipping','en'),(1272,1272,'The selected shipping rates have been deleted successfully','en'),(1273,1273,'The state has been added successfully','en'),(1274,1274,'The text label has not been added because its translation into the default application language has not been specified','en'),(1275,1275,'The text label has not been added because its translation into the default interface language has not been specified','en'),(1276,1276,'The text label has not been modified because its translation into the default application language has not been specified','en'),(1277,1277,'The text label has not been modified because its translation into the default interface language has not been specified','en'),(1278,1278,'The upgrade is completed. Please do not close this page until you check your web site and make sure that everything works properly','en'),(1279,1279,'There are no categories','en'),(1280,1280,'There are no rates selected','en'),(1281,1281,'There are no rates available for the specified source/destination and/or package measurements/weight.','en'),(1282,1282,'Find language in the marketplace','en'),(1283,1283,'There is no user with the specified email address','en'),(1284,1284,'There were no orders placed','en'),(1285,1285,'These components require your attention','en'),(1286,1286,'These components will be updated','en'),(1287,1287,'These instructions will appear below the order invoice on the page that customers see after they confirm their order.','en'),(1288,1288,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process','en'),(1289,1289,'Please contact the module developers to make sure that these modules are compatible with the upcoming upgrade. We do not guarantee that the store will operate correctly if the modules remain enabled. Consider disabling the modules before you proceed to the next step.','en'),(1290,1290,'This address was used as a billing address during a recent purchase','en'),(1291,1291,'This address was used as a shipping address during a recent purchase','en'),(1292,1292,'This component is automatically calculated by a shipping add-on module and cannot be edited','en'),(1293,1293,'This email address is already in use by another user.','en'),(1294,1294,'This email address is used for an existing account. Enter another email address or sign in','en'),(1295,1295,'This is the default zone which covers all addresses. It is not possible to edit this zone\'s countries, states, etc.','en'),(1296,1296,'This month','en'),(1297,1297,'Once the links are regenerated, they will be sent to the store administrator email.','en'),(1298,1298,'After clicking this button, your hard/soft reset links will be regenerated. You may need this if your old links were compromised.','en'),(1299,1299,'This section displays order placement statistics','en'),(1300,1300,'This site requires JavaScript to function properly.','en'),(1301,1301,'This week','en'),(1302,1302,'This quarter','en'),(1303,1303,'This year','en'),(1304,1304,'Through','en'),(1305,1305,'Thumbnail','en'),(1306,1306,'Title','en'),(1307,1307,'New tax class','en'),(1308,1308,'Create zone','en'),(1309,1309,'Shipping / Payment info','en'),(1310,1310,'To contact us please use the form below','en'),(1311,1311,'To email','en'),(1312,1312,'To place the order please accept the Terms and Conditions','en'),(1313,1313,'To place the order please complete the previous steps first','en'),(1314,1314,'To reset your password, please enter the email address associated with your user account','en'),(1315,1315,'Today','en'),(1316,1316,'Best sellers','en'),(1317,1317,'Best sellers','en'),(1318,1318,'Translation driver','en'),(1319,1319,'Twitter','en'),(1320,1320,'Type','en'),(1321,1321,'Type of Account','en'),(1322,1322,'Admin has requested a change of password for your account. Please change the password before you proceed.','en'),(1323,1323,'The new password must not coincide with the current password for your account.','en'),(1324,1324,'Uncheck all','en'),(1325,1325,'Understanding Online Payments','en'),(1326,1326,'Error: Version value was not passed','en'),(1327,1327,'Uninstall','en'),(1328,1328,'Units & Formats','en'),(1329,1329,'Units of measurement','en'),(1330,1330,'Unknown','en'),(1331,1331,'Unpacking archives, please wait...','en'),(1332,1332,'Unset','en'),(1333,1333,'Update exceptions','en'),(1334,1334,'Update module','en'),(1335,1335,'Update product','en'),(1336,1336,'Update profile','en'),(1337,1337,'Updated components','en'),(1338,1338,'Updates are available','en'),(1339,1339,'App Store update is available','en'),(1340,1340,'Updates for the X-Cart core and/or installed modules are available','en'),(1341,1341,'Updates for your version ({{version}})','en'),(1342,1342,'Upgrade','en'),(1343,1343,'Upgrade is available','en'),(1344,1344,'Upgrade core','en'),(1345,1345,'Upgrade module','en'),(1346,1346,'Upgrade to version {{version}}','en'),(1347,1347,'Upload','en'),(1348,1348,'Upload add-on','en'),(1349,1349,'Upload and restore','en'),(1350,1350,'Upload file','en'),(1351,1351,'Use a merchant account from your financial institution or choose a bundled payment solution to accept credit cards and other methods of payment on your website.','en'),(1352,1352,'Use a merchant account from your financial institution to accept online payments','en'),(1353,1353,'Use custom js','en'),(1354,1354,'Use lazy loading','en'),(1355,1355,'Use default logo','en'),(1356,1356,'Use dynamic image resizing','en'),(1357,1357,'This setting determines what happens if X-Cart cannot find a previously generated resized version of an image it needs to display. If this setting is enabled, an appropriately sized version of the image is generated on the fly. If this setting is disabled, the original (non-resized) image is used.','en'),(1358,1358,'Use the category name','en'),(1359,1359,'Use the navigation bar above this dialog to navigate through the catalog categories','en'),(1360,1360,'Use this section to back up the database of your online store. Please note that the database backup procedure can take up to several minutes.','en'),(1361,1361,'Use this section to define address zones.','en'),(1362,1362,'Use this section to configure your store\'s shipping methods.','en'),(1363,1363,'Use this section to manage the list of existing countries. This list is used in the shipping settings and calculations, as well as in the registration form in the Customer area.','en'),(1364,1364,'Use this section to manage the lists of counties, provinces, regions and states of different countries. The lists are used in shipping settings and calculations, as well as in the registration form in the Customer area.','en'),(1365,1365,'Use this section to restore the database of your online store. Please note that the database restoration procedure can take up to several minutes','en'),(1366,1366,'Use this section to review the list of existing membership levels and add new ones','en'),(1367,1367,'User membership','en'),(1368,1368,'User type','en'),(1369,1369,'Username or email','en'),(1370,1370,'Users','en'),(1371,1371,'Uses count','en'),(1372,1372,'Uses left','en'),(1373,1373,'VAT','en'),(1374,1374,'Validate key','en'),(1375,1375,'Value','en'),(1376,1376,'Version','en'),(1377,1377,'Version change','en'),(1378,1378,'View all open orders','en'),(1379,1379,'View logs','en'),(1380,1380,'View profile','en'),(1381,1381,'View system logs','en'),(1382,1382,'View update log','en'),(1383,1383,'Visit module details page','en'),(1384,1384,'Visit storefront','en'),(1385,1385,'Volume discounts','en'),(1386,1386,'Volume discount','en'),(1387,1387,'Warning','en'),(1388,1388,'Warning! Not enough items in stock for the order to be processed','en'),(1389,1389,'Warning: this operation cannot be reverted!','en'),(1390,1390,'Watch video','en'),(1391,1391,'Web server','en'),(1392,1392,'Weight modifier','en'),(1393,1393,'What is benchmark?','en'),(1394,1394,'After the export process has been completed, you will be prompted to download the product data file','en'),(1395,1395,'Width (px)','en'),(1396,1396,'Wrong method_id specifed','en'),(1397,1397,'Wrong value is specified for arrival date field. The field was not updated.','en'),(1398,1398,'X-Cart','en'),(1399,1399,'X-Cart online store builder','en'),(1400,1400,'X-Cart shopping cart software','en'),(1401,1401,'XML parser','en'),(1402,1402,'XML sitemap','en'),(1403,1403,'Yahoo!','en'),(1404,1404,'Yandex','en'),(1405,1405,'Yes','en'),(1406,1406,'Yes, I accept the License agreement','en'),(1407,1407,'You are not allowed to access this resource!','en'),(1408,1408,'Your access link has expired.','en'),(1409,1409,'It seems that your custom add-ons were developed for a specific version of X-Cart core. As a result, some adaptation of these add-ons may be required for the upcoming upgrade. Please contact your module developer to assist you with the adaptation.','en'),(1410,1410,'Unfortunately, you don\'t have permissions to access this page.','en'),(1411,1411,'To continue, please {{singin}}','en'),(1412,1412,'sign in','en'),(1413,1413,'Please <a href=\"{{contact_link}}\">contact the administrator</a>','en'),(1414,1414,'You have selected to delete your profile. Please confirm that you want to proceed','en'),(1415,1415,'PHP <a href=\'//php.net/phar\' target=\'_blank\'>.phar</b> extension is not enabled on your server. Here is a <a href=\'https://kb.x-cart.com/en/setting_up_x-cart_5_environment/setting_up_.phar.html\' target=\'_blank\'>manual</a> for setting up the extension.','en'),(1416,1416,'PHP cURL extension is not enabled on your server. Here is a <a href=\'https://kb.x-cart.com/en/setting_up_x-cart_5_environment/setting_up_curl.html\' target=\'_blank\'>manual</a> for setting up the extension.','en'),(1417,1417,'PHP openSSL extension is not enabled on your server. Here is a <a href=\'https://kb.x-cart.com/en/setting_up_x-cart_5_environment/setting_up_openssl.html\' target=\'_blank\'>manual</a> for setting up the extension.','en'),(1418,1418,'Your server does not have an SSL certificate. Ask your hosting team to install an SSL certificate or create a self-signed one according to this <a href=\'https://kb.x-cart.com/en/setting_up_x-cart_5_environment/creating_self-signed_ssl_certificate.html\' target=\'_blank\'>guide</a>.','en'),(1419,1419,'Previous attempt to connect to the Marketplace server failed.','en'),(1420,1420,'cURL returned an error while establishing a connection: {{error code}} {{error message}}','en'),(1421,1421,'After the problem has been fixed, try to <a href=\'{{clear_cache}}\'>connect</a> again.','en'),(1422,1422,'Require to change password on next log in','en'),(1423,1423,'Change password','en'),(1424,1424,'Your account information will be emailed to you shortly','en'),(1425,1425,'Your account information will be emailed to you shortly.','en'),(1426,1426,'Your email','en'),(1427,1427,'Your name','en'),(1428,1428,'Your products will be exported as a CSV file.','en'),(1429,1429,'Your cart is empty','en'),(1430,1430,'Your state','en'),(1431,1431,'Your storefront','en'),(1432,1432,'Your store is currently unable to calculate taxes','en'),(1433,1433,'Zip code','en'),(1434,1434,'Zip/postal code masks','en'),(1435,1435,'City masks','en'),(1436,1436,'Zone','en'),(1437,1437,'Zone name','en'),(1438,1438,'Zones','en'),(1439,1439,'and','en'),(1440,1440,'by','en'),(1441,1441,'details','en'),(1442,1442,'disabled','en'),(1443,1443,'downloads','en'),(1444,1444,'enabled','en'),(1445,1445,'from URL','en'),(1446,1446,'from local computer','en'),(1447,1447,'from local server','en'),(1448,1448,'hard reset','en'),(1449,1449,'in description','en'),(1450,1450,'in title','en'),(1451,1451,'is available','en'),(1452,1452,'items available','en'),(1453,1453,'less','en'),(1454,1454,'modules','en'),(1455,1455,'ms','en'),(1456,1456,'never','en'),(1457,1457,'none','en'),(1458,1458,'The following archives could not be unpacked: {{list}}','en'),(1459,1459,'Try to unpack them manually, then click on <a href=\'{{link}}\'>this link</a>.','en'),(1460,1460,'not available for sale','en'),(1461,1461,'not installed','en'),(1462,1462,'not ready to download packs. Please, try again','en'),(1463,1463,'of','en'),(1464,1464,'options','en'),(1465,1465,'or','en'),(1466,1466,'proxy','en'),(1467,1467,'sale','en'),(1468,1468,'should be performed manually','en'),(1469,1469,'soft reset','en'),(1470,1470,'trying to install a non-marketplace module: \"{{name}}\"','en'),(1471,1471,'trying to unpack non-downloaded archives','en'),(1472,1472,'Unable to install: The following archives could not be unpacked: {{list}}','en'),(1473,1473,'Unable to test files: The following archives could not be unpacked: {{list}}','en'),(1474,1474,'unknown','en'),(1475,1475,'you save','en'),(1476,1476,'Action \"{{class}}::{{action}}\", {{message}}','en'),(1477,1477,'The key has been validated, but the module {{module}} has not been found','en'),(1478,1478,'Response from Marketplace: {{response}}','en'),(1479,1479,'Please specify a non-empty key','en'),(1480,1480,'A DB error occurred while uninstalling the module \"{{name}}\"','en'),(1481,1481,'The module \"{{name}}\" has been uninstalled successfully','en'),(1482,1482,'Unable to delete the module \"{{name}}\" files: some dirs do not have write permissions: {{dirs}}','en'),(1483,1483,'License not received','en'),(1484,1484,'invalid module ID passed: \"{{moduleId}}\"','en'),(1485,1485,'unable to add module entry to the installation list: \"{{path}}\"','en'),(1486,1486,'module version \"{{module_version}}\" does not match the core version (\"{{core_version}}\")','en'),(1487,1487,'unable to upload the module','en'),(1488,1488,'The modules have been successfully installed','en'),(1489,1489,'{{ext}} file type','en'),(1490,1490,'Zone not found ({{zoneId}})','en'),(1491,1491,'The profiles have been merged','en'),(1492,1492,'The profile has been registered. The password has been sent to the user\'s email address','en'),(1493,1493,'<a href=\"terms-and-conditions.html\">Terms and conditions details</a><br /><br />Edit the \"Terms and conditions text\" label via the Admin area','en'),(1494,1494,'<span class=\"modules-amount\">{{count}}</span> addon(s) selected','en'),(1495,1495,'State cannot be created with an unknown country code ({{code}})','en'),(1496,1496,'There are no labels translated to {{language}}','en'),(1497,1497,'Module with ID \"{{id}}\" not found','en'),(1498,1498,'We are already aware of this problem and are working on it. If you would like to get in touch, feel free to contact us via our Help center at <a href=\"{{url}}\" target=\"_blank\">{{url}}</a>.','en'),(1499,1499,'The following expected input data has a wrong format or is empty: {{fields}}','en'),(1500,1500,'Unknown language: {{code}}','en'),(1501,1501,'deleted','en'),(1502,1502,'It is impossible to detect valid SSL certificate availability on your server because curl extension is not installed.','en'),(1503,1503,'Your store is configured to use the secure protocol for both the store’s back end and customer area.','en'),(1504,1504,'We have found a valid SSL certificate installed on the server. Now you can switch the store to use the secure protocol for the store\'s back end, checkout, sign-in and profile pages.','en'),(1505,1505,'Support','en'),(1506,1506,'After the upgrade is completed, please check your website. If you find that the site is not operating properly, please try the following','en'),(1507,1507,'Start Import','en'),(1508,1508,'New import','en'),(1509,1509,'Critical errors have been detected in the files you are trying to import. Check the manual to correct the errors and try again.','en'),(1510,1510,'Data has not been found','en'),(1511,1511,'Clear the item\'s data before importing this item','en'),(1512,1512,'Do not verify images to run the process faster','en'),(1513,1513,'Delete temporary files after the import is completed','en'),(1514,1514,'Import settings','en'),(1515,1515,'Upload files','en'),(1516,1516,'Samples of the file structures','en'),(1517,1517,'Continue import','en'),(1518,1518,'Re-upload files','en'),(1519,1519,'The import process may take a while to complete. You may close the page; the process will continue in the background. If the process takes long enough, we will send you a notification when it is completed.','en'),(1520,1520,'The import process may take a while to complete. Please do not close this page until the process is fully completed. If you have closed the page, please re-open it to complete the import process as it is in progress only when the page is open.','en'),(1521,1521,'Verification results','en'),(1522,1522,'Import by CSV','en'),(1523,1523,'Order by','en'),(1524,1524,'Query','en'),(1525,1525,'Count','en'),(1526,1526,'Products found','en'),(1527,1527,'Cleanup queries','en'),(1528,1528,'requested only once','en'),(1529,1529,'requested once or twice','en'),(1530,1530,'Cleanup','en'),(1531,1531,'The shipping rate has been added successfully','en'),(1532,1532,'The shipping rate cannot be added','en'),(1533,1533,'Please make sure that <b>\"min weight\", \"min total\", \"min items\", \"shipping zone\" and \"shipping method\"</b> fields do not overlap with those of any other shipping rates.','en'),(1534,1534,'Administrator area','en'),(1535,1535,'This section displays order processing statistics','en'),(1536,1536,'Compare your result with other servers','en'),(1537,1537,'The values are average','en'),(1538,1538,'Customer area is closed for maintenance.','en'),(1539,1539,'This page allows you to configure shipping methods, address zones and shipping charges.','en'),(1540,1540,'Shipping charges','en'),(1541,1541,'New address','en'),(1542,1542,'Forgot your password?','en'),(1543,1543,'No such user','en'),(1544,1544,'Edit attributes','en'),(1545,1545,'To set up attributes specific for product classes, define the product classes first.','en'),(1546,1546,'Here you can define attributes for all of your products and sets of attributes for different classes of your products.','en'),(1547,1547,'Here you can define how your payment methods will look in the Customer area.','en'),(1548,1548,'More payment methods can be added by installing appropriate payment modules. Check out the Marketplace to find and install the payment modules you require.','en'),(1549,1549,'Need more payment methods?','en'),(1550,1550,'Upload from server','en'),(1551,1551,'Upload from your computer','en'),(1552,1552,'Warning: The restoration procedure is irreversible and erases all existing data tables from the store\'s database. It is highly recommended that you back up the data currently stored in your database before restoring a past version of your database from backup.','en'),(1553,1553,'Also, if you want to upload the backup of <b>another</b> X-Cart installation, ensure that you have completed the steps described <a href=\'{{url}}\'>here</a>','en'),(1554,1554,'Use this section to back up the database of your online store. Please note that the database backup procedure can take up to several minutes.','en'),(1555,1555,'If you choose to create an SQL file, you will be able to download the file from the server later and, after that, delete it from the server using the \"Delete SQL file\" button.','en'),(1556,1556,'You cannot save database data to a file on the web server (\'var/backup/sqldump.sql.php\').','en'),(1557,1557,'The directory \'var/backup/\' does not exist or is not writable.','en'),(1558,1558,'Ship in a separate box','en'),(1559,1559,'You will be able to provide additional product info (images, attributes, etc.) after you submit this form.','en'),(1560,1560,'Clone this product','en'),(1561,1561,'Clone','en'),(1562,1562,'Preview product page','en'),(1563,1563,'Tax class','en'),(1564,1564,'There are no images loaded for this product','en'),(1565,1565,'No product class assigned','en'),(1566,1566,'Name, e.g. Apparel','en'),(1567,1567,'Manage product classes','en'),(1568,1568,'If you have multiple products sharing the same set of attributes, it makes sence to set up a common product type for these products and create the attributes on the product type level.','en'),(1569,1569,'Attribute option','en'),(1570,1570,'Modifiers','en'),(1571,1571,'Default option','en'),(1572,1572,'Length x Width x Height','en'),(1573,1573,'Maximum number of items per box','en'),(1574,1574,'Attribute name','en'),(1575,1575,'Attribute values','en'),(1576,1576,'Re-generate links','en'),(1577,1577,'Attribute group','en'),(1578,1578,'Attribute groups','en'),(1579,1579,'Attribute','en'),(1580,1580,'No group','en'),(1581,1581,'No attributes','en'),(1582,1582,'No attributes assigned','en'),(1583,1583,'Including subcategories','en'),(1584,1584,'The provided file contains the following language labels:','en'),(1585,1585,'The language labels have been successfully imported:','en'),(1586,1586,'Language:','en'),(1587,1587,'labels count:','en'),(1588,1588,'Number of ignored rows:','en'),(1589,1589,'Please confirm that you want to proceed with the import or cancel the operation.','en'),(1590,1590,'Failure: Wrong file format.','en'),(1591,1591,'The language CSV file should be a text file containing three columns per row (the columns must be separated by a comma:','en'),(1592,1592,'language code,','en'),(1593,1593,'label name,','en'),(1594,1594,'label translation.','en'),(1595,1595,'Please make sure your file format is as described.','en'),(1596,1596,'default','en'),(1597,1597,'Get CSV','en'),(1598,1598,'Not selected','en'),(1599,1599,'To change your roles, contact the store administrator','en'),(1600,1600,'You have the following roles:','en'),(1601,1601,'Welcome','en'),(1602,1602,'Edit attribute values','en'),(1603,1603,'Click if you do not want to add this value to new products or class assigns automatically','en'),(1604,1604,'Click if you want to add this value to new products or class assigns automatically','en'),(1605,1605,'Enabled in catalog','en'),(1606,1606,'Disabled in catalog','en'),(1607,1607,'What to export','en'),(1608,1608,'editable','en'),(1609,1609,'multi value','en'),(1610,1610,'Removing this attribute will affect all the products. Leave this blank to hide this option for the product.','en'),(1611,1611,'Delete all files','en'),(1612,1612,'Before editing attributes specific for the chosen type you should save the changes','en'),(1613,1613,'Default value','en'),(1614,1614,'Default attribute value','en'),(1615,1615,'Buyers can select an option','en'),(1616,1616,'No pre-defined value','en'),(1617,1617,'Whether customers should be able to select an option they require when ordering the product, or the information is provided purely as part of product specification. <br/>Default setting for new products. Does not change the configuration of products created previously.','en'),(1618,1618,'This value will be added to new products or class assigns automatically','en'),(1619,1619,'New value','en'),(1620,1620,'New group','en'),(1621,1621,'New Export','en'),(1622,1622,'The following files are too large to be included in the archive','en'),(1623,1623,'Start Export','en'),(1624,1624,'Export settings','en'),(1625,1625,'Export public files as','en'),(1626,1626,'URLs','en'),(1627,1627,'local files','en'),(1628,1628,'Choosing \"URLs\" will link the exported data to your public files (product and category images, downloadable files shown on product pages, and so on) through direct URLs. Public files won\'t be included into the archive with exported files; however, private files (for example, digitally distributed products) will go into the archive anyway.<br /><br />Choosing \"local files\" will provide file paths to your files, relative to your X-Cart installation.','en'),(1629,1629,'Download all files','en'),(1630,1630,'Exported files','en'),(1631,1631,'Export completed','en'),(1632,1632,'Exporting data...','en'),(1633,1633,'The export process may take a while to complete. You may close the page, the process will continue in the background. If the process takes long enough, we will send you a notification when it is completed.','en'),(1634,1634,'The export process may take a while to complete. Please do not close this page until the process is fully completed. If you have closed the page, please re-open it to complete the export process as it is in progress only when the page is open.','en'),(1635,1635,'Export failed','en'),(1636,1636,'Export was not started','en'),(1637,1637,'Export cannot be started because it is disabled or there is another running export process. Try again later.','en'),(1638,1638,'Export in CSV','en'),(1639,1639,'Please make sure the following modules are installed and enabled:','en'),(1640,1640,'You have no payment methods enabled at your store','en'),(1641,1641,'This method does not support the current store currency and is not available to customers','en'),(1642,1642,'This method is in test mode','en'),(1643,1643,'Configure','en'),(1644,1644,'This payment method cannot be enabled until you configure it','en'),(1645,1645,'Edit product','en'),(1646,1646,'There are no shipping methods defined for this carrier','en'),(1647,1647,'Click to edit rates','en'),(1648,1648,'Click to add rates','en'),(1649,1649,'Add rates','en'),(1650,1650,'Edit','en'),(1651,1651,'Click to edit states','en'),(1652,1652,'Click to add states','en'),(1653,1653,'Add states','en'),(1654,1654,'Add state','en'),(1655,1655,'Click to edit all the translations for this label','en'),(1656,1656,'Warning! Installing this module will overwrite any existing label translations for this language.','en'),(1657,1657,'Please','en'),(1658,1658,'upgrade core','en'),(1659,1659,'No modules found','en'),(1660,1660,'No users found','en'),(1661,1661,'No products found','en'),(1662,1662,'No profiles found','en'),(1663,1663,'Installed version','en'),(1664,1664,'outdated','en'),(1665,1665,'Purchased','en'),(1666,1666,'View in list','en'),(1667,1667,'Popularity','en'),(1668,1668,'Module\'s page','en'),(1669,1669,'Activate key','en'),(1670,1670,'if you have any questions','en'),(1671,1671,'Success','en'),(1672,1672,'Fax','en'),(1673,1673,'The shipping cost has been calculated based on the following combination of products into packages:','en'),(1674,1674,'Package','en'),(1675,1675,'weight','en'),(1676,1676,'dimensions','en'),(1677,1677,'item(s)','en'),(1678,1678,'Placed on','en'),(1679,1679,'OR','en'),(1680,1680,'Root categories','en'),(1681,1681,'WARNING! There are no more available administrator profiles. You will not be able to manage your store after you delete this profile.','en'),(1682,1682,'Are you sure you want to delete this profile?','en'),(1683,1683,'Autogenerate Clean URL','en'),(1684,1684,'products','en'),(1685,1685,'Already added','en'),(1686,1686,'Edit attribute','en'),(1687,1687,'New attribute','en'),(1688,1688,'Manage groups','en'),(1689,1689,'No attributes are defined for the product class yet.','en'),(1690,1690,'Need a license key?','en'),(1691,1691,'Your X-Cart installation is licensed for evaluation purposes only.','en'),(1692,1692,'You can build your website during FREE evaluation, but you cannot use this installation for real sales without buying a license.','en'),(1693,1693,'For details refer to','en'),(1694,1694,'Removing this message without buying a Full license is prohibited and will result in legal proceedings.','en'),(1695,1695,'Core version','en'),(1696,1696,'verified version','en'),(1697,1697,'Loopback test','en'),(1698,1698,'Warning! InnoDB engine is not supported. It is required for software operation','en'),(1699,1699,'Not detected','en'),(1700,1700,'Warning!','en'),(1701,1701,'PHP \'gd\' extension is not installed.','en'),(1702,1702,'Curl version','en'),(1703,1703,'Curl options','en'),(1704,1704,'cannot create directory','en'),(1705,1705,'subdirectories problems','en'),(1706,1706,'file does not exist','en'),(1707,1707,'Directory is empty','en'),(1708,1708,'Comma','en'),(1709,1709,'Semicolon','en'),(1710,1710,'Tab','en'),(1711,1711,'A membership name cannot contain such symbols as \\, \' and \". Also, it cannot exceed 32 characters.','en'),(1712,1712,'Please enter a unique membership name','en'),(1713,1713,'Required field','en'),(1714,1714,'The value must be in the range of','en'),(1715,1715,'Click to open','en'),(1716,1716,'Click to close','en'),(1717,1717,'Double quote','en'),(1718,1718,'Single quote','en'),(1719,1719,'empty','en'),(1720,1720,'Warning! CSV file was not specified.','en'),(1721,1721,'Warning! The file you have specified in the \'File (CSV) local\' field does not exist or cannot be read.','en'),(1722,1722,'Please enter the correct file location or set correct file permissions.','en'),(1723,1723,'Warning! The file you have specified in the \'File (CSV) for upload\' field has not been uploaded to the server.','en'),(1724,1724,'Already exists','en'),(1725,1725,'Confirmation does not match','en'),(1726,1726,'Incomplete','en'),(1727,1727,'Complete','en'),(1728,1728,'Please, enter a valid email address','en'),(1729,1729,'Please, enter a valid IP address','en'),(1730,1730,'Result pages','en'),(1731,1731,'User activity','en'),(1732,1732,'now disabled','en'),(1733,1733,'Upgrade for X-Cart core is available','en'),(1734,1734,'Now disabled','en'),(1735,1735,'Will be installed','en'),(1736,1736,'The module is incompatible with the new core version that is going to be installed','en'),(1737,1737,'Check again','en'),(1738,1738,'Failure','en'),(1739,1739,'An upgrade is a dangerous process that may result in a crashed website. It is strongly recommended to create a full back up of your store (the code and the database) and download it to a local computer before you proceed to the next step.','en'),(1740,1740,'Some files are modified','en'),(1741,1741,'The system has detected that some custom modifications were made by editing core and module files, not by writing new modules. In order to proceed with the upgrade you should decide what to do with the modifications','en'),(1742,1742,'Replace all modified files with the unmodified newer versions','en'),(1743,1743,'the custom modifications will be lost','en'),(1744,1744,'Do not replace selected files and ignore their newer versions','en'),(1745,1745,'your web site may crash','en'),(1746,1746,'Select all','en'),(1747,1747,'Unselect all','en'),(1748,1748,'New user registered','en'),(1749,1749,'Website','en'),(1750,1750,'Last 24 hours','en'),(1751,1751,'Last 7 days','en'),(1752,1752,'Last month','en'),(1753,1753,'Store lifetime','en'),(1754,1754,'View all','en'),(1755,1755,'Changes of attribute values will affect only this product. Changes of attribute names and of the attribute list will affect all the products of the corresponding class.','en'),(1756,1756,'Changes of attribute values will affect only this product. Changes of attribute names and of the attribute list will affect all the products','en'),(1757,1757,'Apply value changes locally','en'),(1758,1758,'Apply value changes globally','en'),(1759,1759,'The password is the one you specified during checkout.','en'),(1760,1760,'The password is the one you specified.','en'),(1761,1761,'Register user','en'),(1762,1762,'Test email notification','en'),(1763,1763,'Test email notification:','en'),(1764,1764,'Your new password','en'),(1765,1765,'You can now use the following credentials to access your account','en'),(1766,1766,'To change the password, log into your company account and use the \'My account\' link','en'),(1767,1767,'New safe mode access key has been generated','en'),(1768,1768,'Use the following key to access safe mode','en'),(1769,1769,'Hard reset (disables all the installed modules and runs the X-Cart application)','en'),(1770,1770,'Soft reset (disables all the modules except for the ones that were downloaded from X-Cart\'s Marketplace and runs the X-Cart application)','en'),(1771,1771,'The export is complete.','en'),(1772,1772,'Totals','en'),(1773,1773,'Your profile was modified','en'),(1774,1774,'A user has submitted the Contact Us form','en'),(1775,1775,'Product ID','en'),(1776,1776,'item(s) in stock','en'),(1777,1777,'Are you sure you want to clear your cart?','en'),(1778,1778,'attributes','en'),(1779,1779,'All rights reserved.','en'),(1780,1780,'Addresses list is empty','en'),(1781,1781,'Order payment','en'),(1782,1782,'Forgot password','en'),(1783,1783,'Max','en'),(1784,1784,'Exact phrase','en'),(1785,1785,'All words','en'),(1786,1786,'Any word','en'),(1787,1787,'Fewer search options','en'),(1788,1788,'More search options','en'),(1789,1789,'Back to Login form','en'),(1790,1790,'Back to modules','en'),(1791,1791,'Try the search-as-you-type feature...','en'),(1792,1792,'Choose the product options first','en'),(1793,1793,'This operation is irreversible. Are you sure you want to proceed?','en'),(1794,1794,'Order number','en'),(1795,1795,'Date range','en'),(1796,1796,'Clear all fields','en'),(1797,1797,'There are no shipping methods available','en'),(1798,1798,'Enter the shipping address to see delivery methods available to you','en'),(1799,1799,'C.O.D. fee included','en'),(1800,1800,'Existing Customer?','en'),(1801,1801,'Login Here','en'),(1802,1802,'Sorry, your order payment was cancelled.','en'),(1803,1803,'Sorry, your order payment failed.','en'),(1804,1804,'Failure reason:','en'),(1805,1805,'Cardholder name','en'),(1806,1806,'Credit card number','en'),(1807,1807,'Start date','en'),(1808,1808,'Expiration date','en'),(1809,1809,'Issue no','en'),(1810,1810,'CVV2','en'),(1811,1811,'Change attributes','en'),(1812,1812,'Call us: ','en'),(1813,1813,'Compare products','en'),(1814,1814,'Email','en'),(1815,1815,'This address was used as a','en'),(1816,1816,'billing','en'),(1817,1817,'shipping','en'),(1818,1818,'address during the recent purchase','en'),(1819,1819,'Out of Stock','en'),(1820,1820,'Cart','en'),(1821,1821,'More','en'),(1822,1822,'Back','en'),(1823,1823,'Your Account','en'),(1824,1824,'See comparison chart','en'),(1825,1825,'Billing address is the same as Shipping','en'),(1826,1826,'Complete billing address','en'),(1827,1827,'Continue as guest','en'),(1828,1828,'Enter your email','en'),(1829,1829,'Order cannot be placed because not all of the required fields are completed. Please check the form and try again.','en'),(1830,1830,'The \"{{file}}\" file was not uploaded','en'),(1831,1831,'Front page','en'),(1832,1832,'Please select the products first','en'),(1833,1833,'Aggregation cache has been cleared','en'),(1834,1834,'Authorized amount','en'),(1835,1835,'Captured amount','en'),(1836,1836,'Refunded amount','en'),(1837,1837,'The method is not configured and cannot be used','en'),(1838,1838,'The only remaining active administrator profile cannot be deleted.','en'),(1839,1839,'Shipping address is invalid','en'),(1840,1840,'Invoice #{{orderId}}, {{time}}','en'),(1841,1841,'Address type has a wrong value','en'),(1842,1842,'Address not selected','en'),(1843,1843,'Address not found','en'),(1844,1844,'\"{{product}} product\" attributes','en'),(1845,1845,'The attributes have been successfully updated','en'),(1846,1846,'Please select a different attribute','en'),(1847,1847,'The address has been deleted','en'),(1848,1848,'You tried to buy more items of \"{{product}}\" product {{description}} than are in stock. We have {{amount}} item(s) only. Please adjust the product quantity.','en'),(1849,1849,'The product has not been added to cart','en'),(1850,1850,'The item has not been removed from cart','en'),(1851,1851,'You have an unpaid order #{{ORDER}}','en'),(1852,1852,'Order not found','en'),(1853,1853,'No payment method selected','en'),(1854,1854,'No payment methods found for criteria: \'{{substring}}\' / {{country}}.','en'),(1855,1855,'All countries','en'),(1856,1856,'System will download and install this module from marketplace. Continue?','en'),(1857,1857,'Try to change the search criteria or find the needed solution in <a href=\"{{URL}}\" class=\"no-payments-marketplace-link\">marketplace</a>','en'),(1858,1858,'Please let us know if you want to <a target=\"_blank\" href=\"{{URL}}\">suggest an idea</a> or <a target=\"_blank\" href=\"{{URL}}\">contact us</a> for a free quote for custom development service.','en'),(1859,1859,'The selected payment method is obsolete or invalid. Select another payment method','en'),(1860,1860,'The form has expired and has been blocked. It seems that the page with the form may have been opened in more than one tab or remained unused for too long. Do not worry, such application behavior is used for security reasons to keep your business safe.','en'),(1861,1861,'Select products from the list','en'),(1862,1862,'Classes & attributes','en'),(1863,1863,'No category defined','en'),(1864,1864,'Safe mode access key has been re-generated','en'),(1865,1865,'{{paymentMethod}} settings','en'),(1866,1866,'An attempt to update settings of unknown payment method','en'),(1867,1867,'The payment method settings have been successfully updated','en'),(1868,1868,'The \"{{file}}\" is not CSV or archive','en'),(1869,1869,'Unable to delete file','en'),(1870,1870,'SQL file was deleted successfully','en'),(1871,1871,'File not found','en'),(1872,1872,'Only enabled modules can be packed','en'),(1873,1873,'Module packing is available in the DEVELOPER mode only. Check etc/config.php file','en'),(1874,1874,'The countries list for the zone is empty. Please specify the countries that belong in this zone.','en'),(1875,1875,'unknown error','en'),(1876,1876,'The payment method has been added successfully','en'),(1877,1877,'Manage attribute groups','en'),(1878,1878,'Measuring performance in manual mode failed.','en'),(1879,1879,'File uploading error.','en'),(1880,1880,'Making a backup of the current database state ... ','en'),(1881,1881,'done','en'),(1882,1882,'Loading the database from file .','en'),(1883,1883,'Database restored successfully!','en'),(1884,1884,'The database has not been restored because of errors','en'),(1885,1885,'Restoring database from backup .','en'),(1886,1886,'Return to Admin interface','en'),(1887,1887,'Global attributes','en'),(1888,1888,'Global','en'),(1889,1889,'Widgets cache has been cleared','en'),(1890,1890,'Widgets cache has not been cleaned completely','en'),(1891,1891,'Failed to update category image','en'),(1892,1892,'The file was not loaded due to a server-side failure.','en'),(1893,1893,'Tax classes','en'),(1894,1894,'The detailed image has not been deleted','en'),(1895,1895,'Attributes have been updated successfully','en'),(1896,1896,'Product class have been updated successfully','en'),(1897,1897,'Product class name is empty','en'),(1898,1898,'Product-Specific','en'),(1899,1899,'Product-Specific attributes','en'),(1900,1900,'A disabled language cannot be default.','en'),(1901,1901,'Cannot autogenerate a clean URL for the product name \"{{name}}\". Please specify it manually.','en'),(1902,1902,'HTTPS option has been successfully enabled','en'),(1903,1903,'HTTPS option has been disabled','en'),(1904,1904,'Inventory has been successfully updated','en'),(1905,1905,'Modules license agreements','en'),(1906,1906,'{{module}} license agreement','en'),(1907,1907,'Customers','en'),(1908,1908,'Customers imported','en'),(1909,1909,'Products imported','en'),(1910,1910,'Attributes imported','en'),(1911,1911,'Categories imported','en'),(1912,1912,'Failed write to file','en'),(1913,1913,'No write permissions to directory','en'),(1914,1914,'Add attribute','en'),(1915,1915,'Default for customers','en'),(1916,1916,'Default for admins','en'),(1917,1917,'Labels','en'),(1918,1918,'Custom','en'),(1919,1919,'Recommended','en'),(1920,1920,'By Price - cheapest first','en'),(1921,1921,'By Price - cheapest last','en'),(1922,1922,'By Name - A-Z','en'),(1923,1923,'By Name - Z-A','en'),(1924,1924,'Displays the number of labels translated into the language','en'),(1925,1925,'Label','en'),(1926,1926,'Plain field','en'),(1927,1927,'Hidden attributes','en'),(1928,1928,'Hidden field','en'),(1929,1929,'-- empty --','en'),(1930,1930,'Textarea','en'),(1931,1931,'Order history','en'),(1932,1932,'Compact view','en'),(1933,1933,'Expanded view','en'),(1934,1934,'Item','en'),(1935,1935,'Yes/No','en'),(1936,1936,'In stock','en'),(1937,1937,'Login/Email','en'),(1938,1938,'Anonymous','en'),(1939,1939,'requested for','en'),(1940,1940,'<p>The order subtotal exceeds the maximum allowed value ({{max_order_amount}})</p>','en'),(1941,1941,'<p>The order subtotal is less than the minimum allowed value ({{min_order_amount}})</p>','en'),(1942,1942,'View all addons','en'),(1943,1943,'Storefront is closed','en'),(1944,1944,'Open','en'),(1945,1945,'Storefront is open','en'),(1946,1946,'Closed','en'),(1947,1947,'The category has been updated','en'),(1948,1948,'The category has been added','en'),(1949,1949,'The address field has been updated','en'),(1950,1950,'The address field has been added','en'),(1951,1951,'The attribute has been updated','en'),(1952,1952,'The attribute has been added','en'),(1953,1953,'The product selection has been updated','en'),(1954,1954,'The product selection has been added','en'),(1955,1955,'Front page updated','en'),(1956,1956,'The profile has been modified successfully','en'),(1957,1957,'The tax class has been updated','en'),(1958,1958,'The tax class has been added','en'),(1959,1959,'Order #{{id}}','en'),(1960,1960,'Enter pattern here','en'),(1961,1961,'Find countries','en'),(1962,1962,'Find states','en'),(1963,1963,'Enter search pattern','en'),(1964,1964,'Import language from CSV file','en'),(1965,1965,'Requested zone does not exist','en'),(1966,1966,'Install addons','en'),(1967,1967,'Add products','en'),(1968,1968,'More actions for selected','en'),(1969,1969,'Order #{{id}} details','en'),(1970,1970,'Your order details will be sent to your email address','en'),(1971,1971,'{{count}} created','en'),(1972,1972,'{{count}} updated','en'),(1973,1973,'The script found {{number}} problem(s) during verification','en'),(1974,1974,'The script found {{number}} problem(s) during import','en'),(1975,1975,'Row {{number}}','en'),(1976,1976,'Row(s) {{numbers}}','en'),(1977,1977,'Critical error','en'),(1978,1978,'Import mode','en'),(1979,1979,'Create new items and update existing items','en'),(1980,1980,'Update existing items, but skip new items','en'),(1981,1981,'During import in the <strong>\'Create new items and update existing items\'</strong> mode, if your import file contains items that do not already exist in the store\'s database, these items will be created as a result of import. New items can be created based on the following master IDs:<ul>{{keys}}</ul>If you only want to update the existing items without creating any new ones, switch to the mode <strong>\'Update existing items, but skip new items\'</strong>.<br /><br />Note that any missing items that are dependent on existing items will be created in both the modes. For example, if an existing product being updated through import does not have a category specified, the category will be created.','en'),(1982,1982,'CSV or ZIP files, total max size: {{size}}','en'),(1983,1983,'Download CSV files','en'),(1984,1984,'<p>The order subtotal exceeds the maximum allowed value ({{max_order_amount}}). Please remove some items from the cart.</p>','en'),(1985,1985,'<p>The order subtotal is less than the minimum allowed value ({{min_order_amount}}). Please add some items to the cart.</p>','en'),(1986,1986,'{{name}} attributes','en'),(1987,1987,'Custom attributes','en'),(1988,1988,'These attributes can be applied to the \"{{name}}\" product class.','en'),(1989,1989,'These attributes can only be applied to this particular product.','en'),(1990,1990,'These attributes can be applied to all the products in the store.','en'),(1991,1991,'Your trial period has expired','en'),(1992,1992,'Your trial period expires today','en'),(1993,1993,'Live','en'),(1994,1994,'Print','en'),(1995,1995,'Print selected','en'),(1996,1996,'Test','en'),(1997,1997,'Residential','en'),(1998,1998,'Commercial','en'),(1999,1999,'No delimiter','en'),(2000,2000,'Space','en'),(2001,2001,'MM','en'),(2002,2002,'CM','en'),(2003,2003,'DM','en'),(2004,2004,'IN','en'),(2005,2005,'mm','en'),(2006,2006,'cm','en'),(2007,2007,'dm','en'),(2008,2008,'inches','en'),(2009,2009,'Mr.','en'),(2010,2010,'Ms.','en'),(2011,2011,'Mrs.','en'),(2012,2012,'# selected','en'),(2013,2013,'LB','en'),(2014,2014,'OZ','en'),(2015,2015,'KG','en'),(2016,2016,'G','en'),(2017,2017,'lbs','en'),(2018,2018,'oz','en'),(2019,2019,'kg','en'),(2020,2020,'g','en'),(2021,2021,'Registered Customers','en'),(2022,2022,'Anonymous Customers','en'),(2023,2023,'Show','en'),(2024,2024,'Email again','en'),(2025,2025,'Safe mode links were emailed','en'),(2026,2026,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process.','en'),(2027,2027,'For any emergency you can use the hard, soft and restore-state links. Pay attention, that these links just disable certain modules in your store, but not make any backups.','en'),(2028,2028,'Not enough disk space. Required: {{req}} (+{{reserve}} reserve). Available: {{avail}}','en'),(2029,2029,'Empty \"class\" parameter is passed to the {{method}}','en'),(2030,2030,'You need hard and soft reset links in case some 3rd party addon <a href=\"{{article}}\" target=\"_blank\">crashes your web store</a>','en'),(2031,2031,'We strongly recommend <b>to make a full backup</b> of your live store before starting the upgrade process. If your store crashes as a result of a failed upgrade, you will be able to <a href=\"{{article}}\" target=\"_blank\">restore it</a> from backup.','en'),(2032,2032,'Don’t forget to create a backup!','en'),(2033,2033,'Backup your store with Backup Master','en'),(2034,2034,'Yes, I\'ve made the full backup of my store files and database','en'),(2035,2035,'We are doing our best to make your upgrade process not only easy to do, but safe.','en'),(2036,2036,'Use our new nifty module to automatically backup your store and be able to restore it if anything crops up.','en'),(2037,2037,'We will email you with <b>emergency links</b> to disable custom modules and stay only with original add-ons.<br/> Pay attention, these links do not create backups.','en'),(2038,2038,'More info is available in X-Cart\'s Knowledge Base article <a href=\"{{article}}\" target=\"_blank\">What to do if you cannot access your store...</a>','en'),(2039,2039,'Couldn\'t move image {{path}}','en'),(2040,2040,'Couldn\'t move {{count}} images. See log for details.','en'),(2041,2041,'This module uses PHP\'s cURL functions which are disabled on your web server','en'),(2042,2042,'Package weight','en'),(2043,2043,'Package weight ({{units}})','en'),(2044,2044,'Package subtotal','en'),(2045,2045,'Package subtotal ({{units}})','en'),(2046,2046,'Source address','en'),(2047,2047,'Postal Code','en'),(2048,2048,'Destination address','en'),(2049,2049,'Note: a new window will be opened','en'),(2050,2050,'Length','en'),(2051,2051,'Width','en'),(2052,2052,'Height','en'),(2053,2053,'Postal/ZIP Code','en'),(2054,2054,'Transaction type','en'),(2055,2055,'Authorization and Capture','en'),(2056,2056,'Authorization only','en'),(2057,2057,'Invoice number prefix','en'),(2058,2058,'a side box','en'),(2059,2059,'the main column','en'),(2060,2060,'expired','en'),(2061,2061,'expired','en'),(2062,2062,'\"{{product}}\" options','en'),(2063,2063,'Private','en'),(2064,2064,'Unavailable','en'),(2065,2065,'Blocked','en'),(2066,2066,'The product SKU#\"{{SKU}}\" is already set as featured for the category','en'),(2067,2067,'Add featured products for \"{{category}}\"','en'),(2068,2068,'Package properties','en'),(2069,2069,'Shipment options','en'),(2070,2070,'Cash on delivery','en'),(2071,2071,'Test mode','en'),(2072,2072,'Packaging','en'),(2073,2073,'Package dimensions (inches)','en'),(2074,2074,'Autogenerated','en'),(2075,2075,'Custom','en'),(2076,2076,'After activation Skrill will give you access to a new section in your Skrill account called \"Merchant tools\". Please choose a secret word (do not use your password for this) and enter it into the Merchant tools section and the form below.','en'),(2077,2077,'(optional)','en'),(2078,2078,'Request type must be POST','en'),(2079,2079,'\'status\' request argument not found','en'),(2080,2080,'Test/Live mode','en'),(2081,2081,'Purchase description','en'),(2082,2082,'Live mode','en'),(2083,2083,'User','en'),(2084,2084,'\'RESULT\' argument not found','en'),(2085,2085,'Transaction amount mismatch','en'),(2086,2086,'Compare','en'),(2087,2087,'Billing address is not defined','en'),(2088,2088,'Menu','en'),(2089,2089,'Unlimited','en'),(2090,2090,'Locked','en'),(2091,2091,'Secret word','en'),(2092,2092,'units','en'),(2093,2093,'each','en'),(2094,2094,'save','en'),(2095,2095,'always','en'),(2096,2096,'hourly','en'),(2097,2097,'daily','en'),(2098,2098,'weekly','en'),(2099,2099,'monthly','en'),(2100,2100,'yearly','en'),(2101,2101,'Auth','en'),(2102,2102,'Capture','en'),(2103,2103,'Void','en'),(2104,2104,'Refund','en'),(2105,2105,'Deploy','en'),(2106,2106,'Secret key','en'),(2107,2107,'Order status changed from {{oldStatus}} to {{newStatus}}','en'),(2108,2108,'Year in which the store opened','en'),(2109,2109,'Force customer to choose product options before adding a product to cart','en'),(2110,2110,'The English language cannot be removed as it is primary language for all texts.','en'),(2111,2111,'Priority','en'),(2112,2112,'Either enable or uninstall the modules below.','en'),(2113,2113,'For the modules named below, an upgrade is available. These modules are now disabled. For the upgrade to be applied successfully to these modules, the modules need to be enabled. You can enable the modules <a href=\'{{link}}\'>here</a>. If you choose not to enable the modules, they will be uninstalled and removed from your store during the upgrade.','en'),(2114,2114,'I understand that <a href=\'#modules_to_uninstall\'>the following disabled modules</a> will be removed.','en'),(2115,2115,'The module version is incompatible with your core version and cannot be installed. The minimum core version required for this module is {{version}}.','en'),(2116,2116,'The module version is incompatible with your core version and cannot be enabled. The minimum core version required for this module is {{version}}.','en'),(2117,2117,'New module version available for core versions {{versions}}.','en'),(2118,2118,'Payment status','en'),(2119,2119,'Fulfillment status','en'),(2120,2120,'All payment statuses','en'),(2121,2121,'All fulfillment statuses','en'),(2122,2122,'Order payment status changed from {{oldStatus}} to {{newStatus}}','en'),(2123,2123,'Order fulfillment status changed from {{oldStatus}} to {{newStatus}}','en'),(2124,2124,'Communication log','en'),(2125,2125,'Input data','en'),(2126,2126,'Please create a new password','en'),(2127,2127,'The confirmation URL link will be emailed to you shortly','en'),(2128,2128,'Your \"Password reset key\" has expired. Please enter the email address associated with your user account to get a new \"Password reset key\".','en'),(2129,2129,'Profile is not defined','en'),(2130,2130,'Customer access level','en'),(2131,2131,'All levels','en'),(2132,2132,'Anonymous','en'),(2133,2133,'Registered','en'),(2134,2134,'Search total','en'),(2135,2135,'All orders','en'),(2136,2136,'Online orders','en'),(2137,2137,'POS orders','en'),(2138,2138,'Do not see your payment method? Find it in our <a href=\"{{url}}\">Marketplace</a>','en'),(2139,2139,'Find in Marketplace','en'),(2140,2140,'Search items...','en'),(2141,2141,'Root category listings format','en'),(2142,2142,'View all ordered items','en'),(2143,2143,'Lines checked: {{X}} out of {{Y}}','en'),(2144,2144,'Lines imported: {{X}} out of {{Y}}','en'),(2145,2145,'Products processed: {{X}} out of {{Y}}','en'),(2146,2146,'Image resized: {{X}} out of {{Y}}','en'),(2147,2147,'Lines verified: {{X}} out of {{Y}} (errors: {{errors}}, warnings: {{warns}})','en'),(2148,2148,'Lines imported: {{X}} out of {{Y}} (errors: {{errors}}, warnings: {{warns}})','en'),(2149,2149,'Products processed: {{X}} out of {{Y}} (errors: {{errors}}, warnings: {{warns}})','en'),(2150,2150,'Image resized: {{X}} out of {{Y}} (errors: {{errors}}, warnings: {{warns}})','en'),(2151,2151,'Import has been cancelled.','en'),(2152,2152,'Export product data with','en'),(2153,2153,'Global & Classes attributes','en'),(2154,2154,'All attributes','en'),(2155,2155,'Classes & Attributes','en'),(2156,2156,'Product attribute values','en'),(2157,2157,'Product attribute values (Yes/No) have been imported','en'),(2158,2158,'Product attribute values (Plain text) have been imported','en'),(2159,2159,'Product attribute values (Textarea) have been imported','en'),(2160,2160,'Product attribute values (Hidden field) have been imported','en'),(2161,2161,'CSV file has a wrong filename format.','en'),(2162,2162,'Possible file names are: {{files}}','en'),(2163,2163,'X-Cart could not find data in your file.','en'),(2164,2164,'Possible reasons are:<br /><ul><li>file is empty</li><li>you specified CSV delimiter other than defined in settings ({{separator}}). In this case, define the correct delimiter in the <strong>CSV column delimiter</strong> on the <a href=\"{{configURL}}\">Localization settings page</a>.</li><li>encoding of your file is not {{encoding}}. In this case, you need to open your CSV file in the spreadsheet editor (MS Excel, Openoffice Calc, etc) and save it using UTF-8 charset.</li><li>your CSV file has an incorrect format. <a href=\"{{kbURL}}\" target=\"blank\">Check our Knowledge base</a> for proper import formats.</li></ul>','en'),(2165,2165,'Your store has some modules available only to Premium license owners. To continue with the upgrade, you must either <a href=\'{{purchaseURL}}\' target=\'_blank\'>purchase</a> a Premium license, or <a href=\'{{installedModulesURL}}\'>remove</a> the following modules from your store:','en'),(2166,2166,'No class','en'),(2167,2167,'See log file for details','en'),(2168,2168,'The product has been updated','en'),(2169,2169,'Free license has been activated successfully','en'),(2170,2170,'Unknown payment. If you see this message after returning from the payment page, please contact the store administrator for information about the status of your payment.','en'),(2171,2171,'{{count}} expired shopping cart(s) have been successfully removed','en'),(2172,2172,'States information has been successfully deleted','en'),(2173,2173,'Please select the states first','en'),(2174,2174,'<p>Cart contains products with a wrong quantity. Please correct this to proceed</p>','en'),(2175,2175,'<p>Cart contains products with a wrong quantity</p>','en'),(2176,2176,'Inventory tracking options','en'),(2177,2177,'Do not select anything if you want to make the product visible to all customers. Otherwise it will be visible to the users assigned to selected membership only.','en'),(2178,2178,'Any stock status','en'),(2179,2179,'Test','en'),(2180,2180,'Live','en'),(2181,2181,'The service name \'{{value}}\' is reserved and cannot be used for an address field.','en'),(2182,2182,'Placed on <span class=\"date\">{{date}}</span>','en'),(2183,2183,'by <a class=\"name\" href=\"{{url}}\">{{name}}</a>','en'),(2184,2184,'by <span class=\"name\">{{name}}</span>','en'),(2185,2185,'Setup store price: {{price}}','en'),(2186,2186,'The button is inactive either because no changes have been detected on the current page or because the order totals need to be recalculated before the order can be updated.','en'),(2187,2187,'Product with selected properties cannot be purchased','en'),(2188,2188,'The specified amount of the product ({{value}}) exceeds the amount of the product in stock ({{max}})','en'),(2189,2189,'Old staff note','en'),(2190,2190,'New staff note','en'),(2191,2191,'Current price for the selected configuration and quantity: {{price}}','en'),(2192,2192,'Cannot create temporary order for modification','en'),(2193,2193,'Customer information','en'),(2194,2194,'no comments','en'),(2195,2195,'All items cannot be removed from the order.','en'),(2196,2196,'Changed items','en'),(2197,2197,'Changed options','en'),(2198,2198,'Added items','en'),(2199,2199,'Removed items','en'),(2200,2200,'Order item attributes are out-of-date and cannot be edited','en'),(2201,2201,'Order will be delivered to the billing address.','en'),(2202,2202,'Staff note','en'),(2203,2203,'The value will be recalculated automatically. Press it if you want to \'freeze\' the current value.','en'),(2204,2204,'The current value is \'frozen\' and won\'t be recalculated. Press it if you want it to be updated when the totals are recalculated.','en'),(2205,2205,'Don’t notify customer','en'),(2206,2206,'Order changes cannot be saved due to negative total value','en'),(2207,2207,'Remove data','en'),(2208,2208,'Buy','en'),(2209,2209,'Click the link to increase product amount','en'),(2210,2210,'Charset','en'),(2211,2211,'You can change the charset for all subsequent imports and exports using <a href=\"{{url}}\">this link</a>.','en'),(2212,2212,'You can change the CSV delimiter for all subsequent imports and exports using <a href=\"{{url}}\">this link</a>.','en'),(2213,2213,'Layout','en'),(2214,2214,'Two columns with right sidebar','en'),(2215,2215,'Two columns with left sidebar','en'),(2216,2216,'Three columns','en'),(2217,2217,'One column','en'),(2218,2218,'The product with SKU \"{{value}}\" does not exist. The \"{{name}}\" attribute will be imported as global','en'),(2219,2219,'The \"{{value}}\" membership does not exist','en'),(2220,2220,'The \"{{value}}\" product class does not exist','en'),(2221,2221,'The \"{{value}}\" tax class does not exist','en'),(2222,2222,'The \"{{value}}\" image does not exist','en'),(2223,2223,'Variant attribute \"{{column}}\" cannot be empty','en'),(2224,2224,'The \"{{value}}\" category does not exist','en'),(2225,2225,'Item not found ({{keys}})','en'),(2226,2226,'The number of values in the row does not match the number of column headers for this CSV file','en'),(2227,2227,'Tags are not allowed in the column \"{{column}}\" and will be stripped','en'),(2228,2228,'The value in the column \"{{column}}\" will be adjusted according to HTML specification to prevent potential XSS attack','en'),(2229,2229,'The value in the column \"{{column}}\" will be cut because its length exceeds the allowed character length for the respective field','en'),(2230,2230,'New product will be created','en'),(2231,2231,'New membership will be created','en'),(2232,2232,'New product class will be created','en'),(2233,2233,'New tax class will be created','en'),(2234,2234,'New category will be created','en'),(2235,2235,'Wrong price format. Positive floating-point number expected','en'),(2236,2236,'Wrong enabled format. This should be \"Yes\" or \"No\"','en'),(2237,2237,'Wrong metaDescType format. This should be \"A\" or \"C\"','en'),(2238,2238,'Wrong format of weight value. Positive floating-point number expected','en'),(2239,2239,'Wrong format of low stock notification value. This should be \"Yes\" or \"No\"','en'),(2240,2240,'Wrong format of use separate box value. This should be \"Yes\" or \"No\"','en'),(2241,2241,'Wrong arrival date format. Correct example: Thu, 21 Dec 2000 16:01:07','en'),(2242,2242,'Wrong date format. Correct example: Thu, 21 Dec 2000 16:01:07','en'),(2243,2243,'Wrong update date format. Correct example: Thu, 21 Dec 2000 16:01:07','en'),(2244,2244,'Wrong format of inventory tracking value. This should be \"Yes\" or \"No\"','en'),(2245,2245,'Wrong format of stock level value. Positive integer expected','en'),(2246,2246,'Wrong format of low stock notification value. This should be \"Yes\" or \"No\"','en'),(2247,2247,'Wrong format of low limit level value. Positive integer expected','en'),(2248,2248,'The name is empty','en'),(2249,2249,'Wrong format of box width value. Positive integer expected','en'),(2250,2250,'Wrong format of box length value. Positive integer expected','en'),(2251,2251,'Wrong format of box height value. Positive integer expected','en'),(2252,2252,'Wrong format of items per box value. Positive integer expected','en'),(2253,2253,'Wrong format of Clean URL value (only alphanumeric, dash (\"-\") and underscore (\"_\") chars are allowed)','en'),(2254,2254,'Error of image loading. Make sure the \"images\" directory has write permissions.','en'),(2255,2255,'Couldn\'t load the image \"{{value}}\", the file does not exist.','en'),(2256,2256,'Couldn\'t load the banner \"{{value}}\", the file does not exist.','en'),(2257,2257,'Wrong position format','en'),(2258,2258,'The group \"{{value}}\" does not exist. A new group will be created','en'),(2259,2259,'New attribute group will be created','en'),(2260,2260,'Wrong format of \"type\" value ({{value}}). This should be \"C\" - checkbox, \"S\" - selector, or \"T\" - textarea','en'),(2261,2261,'Wrong format of \"display mode\" value ({{value}}) for selector. This should be \"B\" - blocks, \"S\" - selectbox','en'),(2262,2262,'Wrong format of \"display mode\" value ({{value}}) for checkbox and textarea. This should be empty','en'),(2263,2263,'Product SKU is empty','en'),(2264,2264,'There is no product with SKU \"{{value}}\" to assign the attribute option value to','en'),(2265,2265,'Wrong format of \"type\" value ({{value}}). This should be \"C\" - checkbox, \"S\" - selector, \"H\" - hidden field or \"T\" - textarea','en'),(2266,2266,'Wrong format of \"owner\" value ({{value}}). This should be \"Yes\" for product-specific attributes or \"No\" for global attributes','en'),(2267,2267,'Wrong format of \"default\" value ({{value}}). This should be \"Yes\" for product-specific attributes or \"No\" for global attributes','en'),(2268,2268,'Wrong \"priceModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%','en'),(2269,2269,'Wrong \"weightModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%','en'),(2270,2270,'Product class {{value}} does not exists and will be created','en'),(2271,2271,'Group {{value}} does not exists and will be created','en'),(2272,2272,'Wrong format of show title value. This should be \"Yes\" or \"No\"','en'),(2273,2273,'Wrong login format. Email as login is expected','en'),(2274,2274,'Wrong date format. Correct example: Thu, 21 Dec 2000 16:01:07','en'),(2275,2275,'Wrong date format. Correct example: Thu, 21 Dec 2000 16:01:07','en'),(2276,2276,'Wrong last login date format. Example: Thu, 21 Dec 2000 16:01:07','en'),(2277,2277,'Wrong status format. This should be \"E\" - enabled, or \"D\" - disabled','en'),(2278,2278,'Wrong referer format. URL expected. Correct example: http://x-cart.com','en'),(2279,2279,'Wrong format of language value. Correct examples: EN, DE, RU: http://en.wikipedia.org/wiki/ISO_639-1','en'),(2280,2280,'Wrong format. This should be \"Yes\" or \"No\". Use \"Yes\" if it is the shipping address.','en'),(2281,2281,'Wrong format. This should be \"Yes\" or \"No\". Use \"Yes\" if it is the billing address.','en'),(2282,2282,'Wrong format of country code value. Correct examples: CA, US, RU: http://en.wikipedia.org/wiki/ISO_3166-1_alpha-2','en'),(2283,2283,'Wrong format of state id value.','en'),(2284,2284,'In advanced mode you can choose specific modules for upgrade.','en'),(2285,2285,'Before installing a paid addon for this installation, you need to <a href=\"#\" class=\"open-license-key-form\">activate your X-Cart license.</a>','en'),(2286,2286,'Use the form below to provide your license information.','en'),(2287,2287,'Activate your X-Cart installation','en'),(2288,2288,'Activate your X-Cart installation first','en'),(2289,2289,'Activate key','en'),(2290,2290,'Vendor','en'),(2291,2291,'All','en'),(2292,2292,'Paid','en'),(2293,2293,'Free','en'),(2294,2294,'I confirm that I have <strong>created backups</strong> of my store\'s files and database before upgrading the store','en'),(2295,2295,'Secure credit card payment','en'),(2296,2296,'Card type','en'),(2297,2297,'Chose credit card type','en'),(2298,2298,'Choose card type','en'),(2299,2299,'Card number','en'),(2300,2300,'MONTH','en'),(2301,2301,'VALID THRU','en'),(2302,2302,'YEAR','en'),(2303,2303,'Security code','en'),(2304,2304,'Last three numbers on the back side of your card','en'),(2305,2305,'Four-digit number on the front side of your card','en'),(2306,2306,'Credit card security code (if present)','en'),(2307,2307,'Countries information has been successfully updated','en'),(2308,2308,'Please select the countries first','en'),(2309,2309,'This payment method is <strong>Active</strong>.','en'),(2310,2310,'This payment method is <strong>Inactive</strong>.','en'),(2311,2311,'Active','en'),(2312,2312,'Inactive','en'),(2313,2313,'Learn More','en'),(2314,2314,'Learn more.','en'),(2315,2315,'Sign Up','en'),(2316,2316,'<div id=\"logo\" style=\"max-width: 250px;\">%logo%</div>','en'),(2317,2317,'<h3>Hey %recipient_name%,</h3>','en'),(2318,2318,'Your friends at %company_link%.','en'),(2319,2319,'<div id=\"logo\" style=\"max-width: 250px;\">%logo%</div>','en'),(2320,2320,'<h3>Hey there,</h3>','en'),(2321,2321,'Your virtual assistant at %company_link%.','en'),(2322,2322,'Market your products to relevant audience on Google Shopping. Start advertising in minutes with the new Google Shopping app. <a href=\"{{url}}\">Learn more</a>.','en'),(2323,2323,'Tip from X-Cart','en'),(2324,2324,'Email notifications','en'),(2325,2325,'This content (if it exists) will be shown below the notification text; alternatively, it may be inserted in another location within the notification via the variable <b>%dynamic_message%</b>.','en'),(2326,2326,'Content of this notification based on the body.twig template','en'),(2327,2327,'Enabled for administrator','en'),(2328,2328,'Enabled for customer','en'),(2329,2329,'Customer header','en'),(2330,2330,'Customer signature','en'),(2331,2331,'Administrator header','en'),(2332,2332,'Administrator signature','en'),(2333,2333,'Customer subject','en'),(2334,2334,'Customer text','en'),(2335,2335,'Administrator subject','en'),(2336,2336,'Administrator text','en'),(2337,2337,'This page allows you to adjust the types of email notifications your store sends to users. Use the On/Off widget to enable/disable specific notifications. Click on the name of a notification to edit the notification text.','en'),(2338,2338,'Notification','en'),(2339,2339,'Back to notifications list','en'),(2340,2340,'On','en'),(2341,2341,'Off','en'),(2342,2342,'First','en'),(2343,2343,'Last','en'),(2344,2344,'The Free license key cannot be activated as it is impossible to get information about the available addons from the Marketplace at the moment. Please try again later.','en'),(2345,2345,'No discount modules installed','en'),(2346,2346,'Names, descriptions & sorting','en'),(2347,2347,'Payment method is enabled','en'),(2348,2348,'Payment method is disabled','en'),(2349,2349,'You should confirm that you have created a backup before upgrading the store.','en'),(2350,2350,'Upgrade note','en'),(2351,2351,'The following modules currently do not have a version compatible with the X-Cart version to which you are upgrading. If you want to keep using these modules after the upgrade, use the \"Request for upgrade\" button to send a request to the module developers so they provide an updated version for their module and make it available via the X-Cart\'s Marketplace. Once the updated module versions are available, you should be able to complete upgrading your store without losing any of the features you currently use.','en'),(2352,2352,'{{count}} module will be disabled','en'),(2353,2353,'{{count}} modules will be disabled','en'),(2354,2354,'{{count}} module will be upgraded','en'),(2355,2355,'{{count}} modules will be upgraded','en'),(2356,2356,'Request for upgrade','en'),(2357,2357,'Your request has been sent successfully','en'),(2358,2358,'An error occurred while sending the request','en'),(2359,2359,'view list','en'),(2360,2360,'hide list','en'),(2361,2361,'Your version ({{version}}) can be upgraded to','en'),(2362,2362,'Imported','en'),(2363,2363,'Importing data...','en'),(2364,2364,'Verified','en'),(2365,2365,'Verifying data before importing...','en'),(2366,2366,'Products processed','en'),(2367,2367,'Processing products...','en'),(2368,2368,'Images resized','en'),(2369,2369,'Resizing images...','en'),(2370,2370,'Generate resized images','en'),(2371,2371,'Clicking the \"Generate resized images\" button launches the image resizing routine to generate copies of existing images in all the sizes needed to display the images in your store\'s customer area. Having a separate image file in each of the sizes provides a way to speed up your site\'s performance by reducing page load times for pages containing graphics.','en'),(2372,2372,'The generation of resized images has been completed successfully.','en'),(2373,2373,'The generation of resized images has been stopped.','en'),(2374,2374,'The image resizing process may take a while to complete. Please do not close this page until the process is fully completed. If the page has been closed, please re-open it to complete the process (The image resizing routine is executed only while the page stays open).','en'),(2375,2375,'Variables for this notification','en'),(2376,2376,'Developers docs','en'),(2377,2377,'The following selected modules cannot be disabled or uninstalled as they have dependent modules: {{list}}','en'),(2378,2378,'The following selected modules cannot be enabled as they depend on disabled modules which cannot be enabled: {{list}}','en'),(2379,2379,'The module may not be disabled due to the limitations of the module architecture.','en'),(2380,2380,'The following selected modules cannot be disabled due to architecture limitations: {{list}}','en'),(2381,2381,'Please note that the following modules will also be enabled:','en'),(2382,2382,'New account','en'),(2383,2383,'Products processed: {{count}}','en'),(2384,2384,'Images resized: {{count}}','en'),(2385,2385,'Orders list','en'),(2386,2386,'Coming soon','en'),(2387,2387,'View storefront','en'),(2388,2388,'Payment is not required','en'),(2389,2389,'Zoom image','en'),(2390,2390,'CSV delimiter','en'),(2391,2391,'Module Marketplace. Terms of use','en'),(2392,2392,'Import/Export guide','en'),(2393,2393,'Yes, I agree with License agreements','en'),(2394,2394,'The system has detected that some updates are available for enabled modules. It is strongly recommended to have all the enabled modules updated to the latest version for better compatibility before installing new ones from the Marketplace.','en'),(2395,2395,'Action','en'),(2396,2396,'Will be updated if core update is selected','en'),(2397,2397,'Options:','en'),(2398,2398,'RSS feed','en'),(2399,2399,'Will be deleted:','en'),(2400,2400,'Are you sure you want to uninstall the selected add-ons?','en'),(2401,2401,'Module page','en'),(2402,2402,'Add to bag','en'),(2403,2403,'New access codes were generated.','en'),(2404,2404,'show list','en'),(2405,2405,'All statuses','en'),(2406,2406,'Product attribute values have been imported','en'),(2407,2407,'No items found','en'),(2408,2408,'No model selected','en'),(2409,2409,'Profile is not selected','en'),(2410,2410,'SKU is not selected','en'),(2411,2411,'Status is not defined','en'),(2412,2412,'All user types','en'),(2413,2413,'Advanced Order Management','en'),(2414,2414,'Public ID','en'),(2415,2415,'Public id','en'),(2416,2416,'Method name','en'),(2417,2417,'Tracking number','en'),(2418,2418,'Enter tracking number','en'),(2419,2419,'The common notification fields have been updated','en'),(2420,2420,'The notification has been updated','en'),(2421,2421,'The product has been added','en'),(2422,2422,'Add-on does not exist.','en'),(2423,2423,'Transaction','en'),(2424,2424,'Log files not found','en'),(2425,2425,'Payment method settings','en'),(2426,2426,'Recently installed modules','en'),(2427,2427,'Login dates','en'),(2428,2428,'File is not an image','en'),(2429,2429,'File is not uploaded','en'),(2430,2430,'Create label','en'),(2431,2431,'Product information has been deleted successfully','en'),(2432,2432,'Import language','en'),(2433,2433,'License: trial version','en'),(2434,2434,'Installation date','en'),(2435,2435,'Order failed','en'),(2436,2436,'Delete account','en'),(2437,2437,'Administrator account cannot be deleted via customer interface.','en'),(2438,2438,'X-Cart license key has been successfully verified and activated.','en'),(2439,2439,'X-Cart license key has been activated. However, this key is expired and does not allow getting upgrade packs from the Marketplace.','en'),(2440,2440,'The license key for the module \"{{name}}\" by \"{{author}}\" has been successfully verified and activated.','en'),(2441,2441,'The key does not allow getting new features and upgrades. <a href=\"{{renewalUrl}}\" target=\"_blank\">Renew your key now</a>','en'),(2442,2442,'Some of these updates are not available for you at the moment. Please renew your access to upgrades to get new superior features from the latest releases.','en'),(2443,2443,'Please renew your access to upgrades to get new superior features from the latest releases.','en'),(2444,2444,'License key','en'),(2445,2445,'Exp. date','en'),(2446,2446,'Prolongate license','en'),(2447,2447,'Renew your access to new features','en'),(2448,2448,'Re-validate license keys','en'),(2449,2449,'Wrong format: Field contains unallowed characters','en'),(2450,2450,'The Clean URL entered is already <a href=\"{{entityURL}}\" target=\"_blank\">in use</a>. Check the \"Resolve the conflict\" tooltip.','en'),(2451,2451,'The Clean URL entered is a redirect to <a href=\"{{entityURL}}\" target=\"_blank\">another object</a>.','en'),(2452,2452,'The clean URL will be generated automatically.','en'),(2453,2453,'Result','en'),(2454,2454,'Change the Clean URL value for this page (Enter a different Clean URL value manually or use the Autogenerate Clean URL feature)','en'),(2455,2455,'Enable the option \"Assign entered Clean URL to this page anyway\" to dissociate the entered Clean URL from the page it is currently used for and assign it to the page of the object being edited.','en'),(2456,2456,'Resolve the conflict','en'),(2457,2457,'Assign entered Clean URL to this page anyway','en'),(2458,2458,'Human readable and SEO friendly web address for the page.','en'),(2459,2459,'This feature is available only for paid (non-free) <a href=\"{{pricingUrl}}\" target=\"_blank\">X-Cart license plans</a>.','en'),(2460,2460,'In this section you can review the recent payment transactions that have taken place at your store, both successful and failed. You can easily identify orders with payment problems and increase your sales by following up on abandoned carts.','en'),(2461,2461,'Hash file for installed entry \"{{entry}}\" doesn\'t exist or is not readable','en'),(2462,2462,'Sale statistics','en'),(2463,2463,'Yesterday','en'),(2464,2464,'Last week','en'),(2465,2465,'Low stock info','en'),(2466,2466,'Last year','en'),(2467,2467,'Security issue','en'),(2468,2468,'New addons','en'),(2469,2469,'View more addons in Marketplace','en'),(2470,2470,'Upgrade access level has been successfully assigned to your license keys','en'),(2471,2471,'<ul><li><b>Developer</b> level assumes the earliest access to upgrade, but the build can be unstable.</li><li><b>Merchant</b> level assumes the latest access to upgrade, but the build will be the most stable.</li></ul>','en'),(2472,2472,'Could not assign upgrade access level to your license keys','en'),(2473,2473,'There are no activated license keys','en'),(2474,2474,'Upgrade access level cannot be changed for default free license','en'),(2475,2475,'An error occurred, please try again. If the problem persists, contact the administrator.','en'),(2476,2476,'An error occurred, please try again. If the problem persists, contact the administrator.<ul><li>{{txnNote}}</li></ul>','en'),(2477,2477,'Cache management','en'),(2478,2478,'Re-deploy the store','en'),(2479,2479,'Re-deployment may take a while to complete. Please do not close this page until the process is fully completed. If the page has been closed, please re-open it to complete the process (The store re-deployment is executed only while the page stays open).','en'),(2480,2480,'Calculate quick data','en'),(2481,2481,'Calculated quick data enhances your store\'s performance by allowing quick product sorting. The process of quick data calculation may take a while to complete. Please do not close this page until the process is fully completed. If the page has been closed, please re-open it to complete the process (The calculation is performed only while the page stays open).','en'),(2482,2482,'About {{time}} remaining','en'),(2483,2483,'Calculating quick data...','en'),(2484,2484,'The process of quick data calculation may take a while to complete. Please do not close this page until the process is fully completed. If the page has been closed, please re-open it to complete the process (The calculation is performed only while the page stays open).','en'),(2485,2485,'The calculation of quick data has been completed successfully.','en'),(2486,2486,'The calculation of quick data has been stopped.','en'),(2487,2487,'There is no data to process','en'),(2488,2488,'Find transactions <b>by ID</b>','en'),(2489,2489,'Search for transactions <b>by date</b>','en'),(2490,2490,'Filter transactions <b>by status</b>','en'),(2491,2491,'Choose the right plan','en'),(2492,2492,'Buy Business Edition','en'),(2493,2493,'unavailable','en'),(2494,2494,'{{count}} modules have been selected','en'),(2495,2495,'This tool allows you to get rid of any content that might have been created in your store for testing purposes and which you no longer need. To use the tool, mark for deletion the types of content data you want to be removed, then click the <strong>Save Changes</strong> button. Removal of content data will not affect the store\'s existing configuration settings.','en'),(2496,2496,'<strong>Warning!</strong> The selected types of content data will be deleted permanently. We strongly recommend you back up your store before you proceed.<br />Please enter the administrator password to confirm you understand the consequences of your choice.','en'),(2497,2497,'Incorrect password. Please try again.','en'),(2498,2498,'Confirmation','en'),(2499,2499,'Leave blank to use product name as Page Title.','en'),(2500,2500,'This page is intended for the creation and management of discount coupons. Different types of coupons are supported, including <strong>$ off, % off and free shipping</strong>. For each coupon the following information can be specified:','en'),(2501,2501,'the <strong>dates</strong> the coupon should be valid for;','en'),(2502,2502,'the <strong>order subtotal range</strong> for which the coupon can be used;','en'),(2503,2503,'the <strong>categories and product classes</strong> to which the coupon may be applied;','en'),(2504,2504,'whether the coupon may be used by everyone or only by users with <strong>specific memberships</strong>.','en'),(2505,2505,'This page is intended for the management of volume discounts based on the order subtotal.','en'),(2506,2506,'Set <strong>absolute or %-based</strong> discount rates;','en'),(2507,2507,'Make a discount available to <strong>all customers</strong> or only to specific <strong>membership levels</strong>;','en'),(2508,2508,'Set a single discount or add <strong>multiple volume discounts</strong>.','en'),(2509,2509,'The system has been restored to the selected snapshot of {{date}}','en'),(2510,2510,'The system has failed to restore because there was no snapshot of {{date}}','en'),(2511,2511,'Leave blank to use category name as Page Title.','en'),(2512,2512,'Current template','en'),(2513,2513,'Standard','en'),(2514,2514,'Layout type','en'),(2515,2515,'Edit custom options','en'),(2516,2516,'Visit the template store','en'),(2517,2517,'Activate purchased skin','en'),(2518,2518,'If you purchased a template but do not see it here, activate the license key that was provided to you.','en'),(2519,2519,'Choose a new template','en'),(2520,2520,'<strong>Need custom design?</strong> We can modify this template or create a completely unique design for you','en'),(2521,2521,'FREE quote','en'),(2522,2522,'Layout has been changed. <a href=\"{{storefront}}\" target=\"_blank\">Review the updated storefront</a>.','en'),(2523,2523,'To make your changes visible in the customer area, cache rebuild is required. It will take several seconds. You don’t need to close the storefront, the operation is executed in the background.','en'),(2524,2524,'Product details image','en'),(2525,2525,'Products list image (<span class=\"preview\" data-img=\"preview_grid.png\">grid view</span>)','en'),(2526,2526,'Products list image (<span class=\"preview\" data-img=\"preview_list.png\">list view</span>)','en'),(2527,2527,'Category image','en'),(2528,2528,'There are unsaved changes on the page. If you choose to continue, these changes will be lost. Do you want to proceed?','en'),(2529,2529,'X-Cart found some issues with installed SSL certificate. You can get more information using this service: <a href=\'{{url}}\'>{{url}}</a>','en'),(2530,2530,'The secure protocol is enabled for your website. But X-Cart hasn\'t found the valid SSL certificate on your server.','en'),(2531,2531,'How do I move X-Cart?','en'),(2532,2532,'No region','en'),(2533,2533,'Check for available free disk space has failed','en'),(2534,2534,'You should check available free disk space yourself before continuing upgrade','en'),(2535,2535,'You should check available free disk space yourself before continuing installation','en'),(2536,2536,'Payment method has been added','en'),(2537,2537,'Payment method was not added','en'),(2538,2538,'Installation warnings','en'),(2539,2539,'You can get more information using this service: <a href=\"{{url}}\">{{url}}</a>','en'),(2540,2540,'X-Cart could not find a valid SSL certificate on your server. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.','en'),(2541,2541,'X-Cart could not find a valid SSL certificate on your server.','en'),(2542,2542,'X-Cart could not find a valid SSL certificate on your server (<span>{{domain}}</span>).','en'),(2543,2543,'Before enabling HTTPS protocol read this article: <a href=\"{{articleUrl}}\">Inaccessible Admin area after enabling HTTPS</a>','en'),(2544,2544,'You are operating as:','en'),(2545,2545,'Operate as this customer','en'),(2546,2546,'Quit','en'),(2547,2547,'You are operating as: {{user}}','en'),(2548,2548,'You are logged in as: {{user}}','en'),(2549,2549,'Finished operating as customer','en'),(2550,2550,'Avalara provides our mutual customers with everything you need to calculate, file and remit sales tax for your business effortlessly by providing an integrated, end-to-end solution for every step of the tax compliance process.','en'),(2551,2551,'New to Avalara? <a href=\"http://www.avalara.com/integrations/x-cart/\" target=\"_blank\">Sign up here!</a>','en'),(2552,2552,'<a href=\"https://www.avalara.com/us/en/products/integrations/x-cart.html?partnersource=0010b00001sr5BH&CampaignID=7010b0000013aD9&lsmr=Direct%20Partner%20Referral&lso=Direct%20Partner%20Referral\" target=\"_blank\">60 Day Free Trial</a>','en'),(2553,2553,'Existing Avalara Customer? <a href=\"{{moduleSettings}}\">Turn AvaTax on now!</a>','en'),(2554,2554,'Any profile','en'),(2555,2555,'Shipping method is not configured.','en'),(2556,2556,'Delivery time','en'),(2557,2557,'Shipping method information that your customers will be able to see when choosing a shipping method for their order during checkout. Can be provided only for offline shipping methods.','en'),(2558,2558,'Choose a parameter (or parameters) based on which custom rates will be defined. When calculating shipping costs, the system takes into account only the custom rates defined based on the parameter(s) selected in this field.','en'),(2559,2559,'Can be provided only for offline shipping methods.','en'),(2560,2560,'Handling fee','en'),(2561,2561,'Can be provided only for online shipping methods.','en'),(2562,2562,'What type of shipping rates would you like to use?','en'),(2563,2563,'Carrier-calculated rates','en'),(2564,2564,'Custom table rates','en'),(2565,2565,'Get shipping rates from major shipping carrier companies. No need to enter shipping rates manualy: the rates are obtained from the shipping carrier in real time so you get the most accurate shipping cost estimation.','en'),(2566,2566,'Method name','en'),(2567,2567,'Table based on','en'),(2568,2568,'Subtotal','en'),(2569,2569,'Discounted subtotal','en'),(2570,2570,'Weight','en'),(2571,2571,'Items','en'),(2572,2572,'Subtotal, weight, items','en'),(2573,2573,'Address zone','en'),(2574,2574,'Subtotal range','en'),(2575,2575,'Discounted subtotal range','en'),(2576,2576,'Weight range','en'),(2577,2577,'Items range','en'),(2578,2578,'flat rate','en'),(2579,2579,'per item','en'),(2580,2580,'per weight unit','en'),(2581,2581,'Shipping','en'),(2582,2582,'Items','en'),(2583,2583,'Subtotal','en'),(2584,2584,'Discounted subtotal','en'),(2585,2585,'Weight','en'),(2586,2586,'Free','en'),(2587,2587,'Here you can provide general information about the shipping method and configure a table defining how shipping rates for this method should be calculated.','en'),(2588,2588,'Learn how to define shipping rates','en'),(2589,2589,'You can set up different shipping rates depending on the weight, price or quantity of items in the order. For this purpose in the field \"Table based on\" you need to specify the quality of an order that should determine the choice of a shipping rate (order subtotal, order weight, quantity of items in the order, or \"Subtotal, weight, items\" - if multiple factors need to be taken into account at the same time). Then in the table below you need to specify the subtotal, weight and/or quantity range that make an order eligible for this rate, and specify the values that need to be taken into account when calculating the shipping rate. If rates for more than one ranges need to be specified, it is necessary to add more rows to the rates table. The ranges for the different rates in the table may not overlap.','en'),(2590,2590,'Shipping rates are calculated by the following formula:','en'),(2591,2591,'You can define the following values:','en'),(2592,2592,'Flat shipping charge. This value will be added to the shipping rate regardless of the weight, price and number of items ordered.','en'),(2593,2593,'Flat shipping charge per item ordered.','en'),(2594,2594,'Shipping charge based on a percentage of the order subtotal.','en'),(2595,2595,'Flat shipping charge per weight unit ordered (for example, per pound or per kilogram - depending on the weight units used by your store).','en'),(2596,2596,'SHIPPING = flat + ITEMS*per_item + SUBTOTAL*(% of subtotal)/100 + WEIGHT*per_{{X}};','en'),(2597,2597,'Carrier services','en'),(2598,2598,'Carrier service','en'),(2599,2599,'Carrier service name','en'),(2600,2600,'Test rates','en'),(2601,2601,'Back to shipping methods','en'),(2602,2602,'This shipping method is','en'),(2603,2603,'This shipping method is <strong>not configured</strong>.','en'),(2604,2604,'on','en'),(2605,2605,'off','en'),(2606,2606,'Pre-upgrade hooks cannot be run','en'),(2607,2607,'Files cannot be updated','en'),(2608,2608,'Trying to run pre-upgrade hooks while not all archives were unpacked','en'),(2609,2609,'...Invoke {{type}} hook for {{entry}}...','en'),(2610,2610,'...Hooks {{hooksCount}}, Items {{itemsCount}}...','en'),(2611,2611,'...Hooks {{hooksCount}}','en'),(2612,2612,'...Unpacking {{entry}}...{{status}}','en'),(2613,2613,'...Downloading {{entry}}...{{status}}','en'),(2614,2614,'<span class=\"value\">{{X}}</span> items','en'),(2615,2615,'More attributes','en'),(2616,2616,'Do you really want to close storefront?','en'),(2617,2617,'The product for which you attempted to upload an attachment has not been found','en'),(2618,2618,'The file extension is forbidden','en'),(2619,2619,'Accounting','en'),(2620,2620,'Export orders','en'),(2621,2621,'Not seeing your accounting software here? <a href=\"{{href}}\" target=\"_blank\">Let us know</a>','en'),(2622,2622,'Want to change or add another accounting system? Choose the accounting system you require below and configure it.','en'),(2623,2623,'No accounting system has been selected yet. Choose your accounting system below and configure it.','en'),(2624,2624,'Automate shipping','en'),(2625,2625,'Integration with','en'),(2626,2626,'Automate your shipping process with the services of our partners: print shipping labels, grab shipping orders info from eBay, ETSY, Amazon and other marketplaces; integrate with several shipping carriers in one spot and more.','en'),(2627,2627,'Haven\'t found what you\'re looking for? View more <a href=\'{{href}}\'>shipping modules</a>','en'),(2628,2628,'Print Shipping labels','en'),(2629,2629,'FREE trial','en'),(2630,2630,'Refunds','en'),(2631,2631,'App type','en'),(2632,2632,'Cloud Service','en'),(2633,2633,'Cloud Zoom','en'),(2634,2634,'Cloud Zoom mode','en'),(2635,2635,'Inside','en'),(2636,2636,'Outside','en'),(2637,2637,'Win app','en'),(2638,2638,'Amazon','en'),(2639,2639,'DHL','en'),(2640,2640,'ETSY','en'),(2641,2641,'FedEx','en'),(2642,2642,'Stamps.com','en'),(2643,2643,'UPS','en'),(2644,2644,'U.S.P.S.','en'),(2645,2645,'eBay','en'),(2646,2646,'Ship-From address','en'),(2647,2647,'Automate Shipping Refunds','en'),(2648,2648,'Shipping solutions','en'),(2649,2649,'More shipping solutions','en'),(2650,2650,'Transaction details','en'),(2651,2651,'You can find the failed transaction <a href=\"{{url}}\">here</a>','en'),(2652,2652,'Save filter','en'),(2653,2653,'Enter filter name','en'),(2654,2654,'Delete filter','en'),(2655,2655,'Are you sure you want to delete this filter?','en'),(2656,2656,'Filter has been successfully saved','en'),(2657,2657,'Filter has been removed','en'),(2658,2658,'The download should start automatically. Click the link if does not start.','en'),(2659,2659,'Sorry, your order cannot be placed as there are no shipping methods available.','en'),(2660,2660,'Packing slip','en'),(2661,2661,'Print packing slip','en'),(2662,2662,'Packing date','en'),(2663,2663,'Order date','en'),(2664,2664,'Bill to','en'),(2665,2665,'Ship to','en'),(2666,2666,'Order QTY','en'),(2667,2667,'Ship QTY','en'),(2668,2668,'Please select the orders first','en'),(2669,2669,'Orders has been successfully deleted','en'),(2670,2670,'Purchase license','en'),(2671,2671,'License warning','en'),(2672,2672,'Inactive license key ({{key}})','en'),(2673,2673,'Does not match license type (requires {{list}} edition)','en'),(2674,2674,'Requires {{list}} edition license','en'),(2675,2675,'License key is missing','en'),(2676,2676,'The system has detected one or more problems with some of the modules at your store:','en'),(2677,2677,'inactive license key(s);','en'),(2678,2678,'installed module(s) not allowed by the type of X-Cart license activated at your store.','en'),(2679,2679,'Using the modules with this type of license violation is illegal.<br />To resolve the problem, please remove the affected modules from your store, or activate a valid license allowing the use of these modules.','en'),(2680,2680,'Also the system has detected problems with the following modules:','en'),(2681,2681,'You can also <a href=\"{{url}}\" target=\"_blank\">contact our CR department</a> for help with this issue','en'),(2682,2682,'WARNING! Any attempt to access further pages in the administrator interface will result in the <strong>automatic disabling</strong> of all the unallowed modules. To prevent this from happening, please activate a valid license key by clicking the button below.','en'),(2683,2683,'Remove unlicensed modules','en'),(2684,2684,'The system has detected that the license key that was activated for your store is invalid.<br />Using the store with an invalid license key is illegal.<br />To resolve the problem, please activate a valid license key for your store, or revert to Trial mode.','en'),(2685,2685,'Back to Trial mode','en'),(2686,2686,'Re-check','en'),(2687,2687,'Tools','en'),(2688,2688,'All payment transaction statuses','en'),(2689,2689,'Default image settings','en'),(2690,2690,'In progress','en'),(2691,2691,'Initialized','en'),(2692,2692,'Success','en'),(2693,2693,'Pending','en'),(2694,2694,'Failed','en'),(2695,2695,'Canceled','en'),(2696,2696,'Void','en'),(2697,2697,'The calculation failed','en'),(2698,2698,'The calculation completed','en'),(2699,2699,'The process of sales calculation may take a while to complete. Please do not close this page until the process is fully completed.','en'),(2700,2700,'Sales calculation','en'),(2701,2701,'This method is displayed because you are logged in as admin and operating as another user','en'),(2702,2702,'Old customer note','en'),(2703,2703,'New customer note','en'),(2704,2704,'Add comment here','en'),(2705,2705,'more','en'),(2706,2706,'View order history','en'),(2707,2707,'Banner rotation','en'),(2708,2708,'Add banner','en'),(2709,2709,'Review & Submit order','en'),(2710,2710,'Products search','en'),(2711,2711,'Requires shipping','en'),(2712,2712,'Learn how to convert failed transactions into real orders','en'),(2713,2713,'Customer','en'),(2714,2714,'Couldn\'t download the image \"{{value}}\"','en'),(2715,2715,'Error of image verification ({{value}}). Make sure you have specified the correct image file or URL.','en'),(2716,2716,'Show low stock warning on product page','en'),(2717,2717,'Notify administrator if the stock quantity of this product goes below a certain limit','en'),(2718,2718,'Only {{X}} left in stock','en'),(2719,2719,'Show all warnings/errors','en'),(2720,2720,'Hide all warnings/errors','en'),(2721,2721,'Errors','en'),(2722,2722,'Warnings','en'),(2723,2723,'Download error file','en'),(2724,2724,'The value must be greater than the current maximum order number in the order list','en'),(2725,2725,'Authorize','en'),(2726,2726,'Sale','en'),(2727,2727,'Capture','en'),(2728,2728,'Capture partially','en'),(2729,2729,'Capture multiple','en'),(2730,2730,'Void','en'),(2731,2731,'Void partially','en'),(2732,2732,'Void multiple','en'),(2733,2733,'Refund','en'),(2734,2734,'Refund partially','en'),(2735,2735,'Refund multiple','en'),(2736,2736,'Get information','en'),(2737,2737,'Accept','en'),(2738,2738,'Decline','en'),(2739,2739,'Test','en'),(2740,2740,'Need a more powerful banner system for your store? <a href=\"{{url}}\">Get it now!</a>','en'),(2741,2741,'Administrator','en'),(2742,2742,'Log in as this admin','en'),(2743,2743,'Need a more customizeable PDF invoice solution for your store? <a href=\"{{url}}\">Get it now!</a>','en'),(2744,2744,'File can not be uploaded','en'),(2745,2745,'{{file}} file could not be copied to a new location {{newPath}}','en'),(2746,2746,'Unable to write data to file {{file}}','en'),(2747,2747,'Unable to download the content of {{url}}','en'),(2748,2748,'File {{file}} does not exist','en'),(2749,2749,'Unable to get the content from {{url}}','en'),(2750,2750,'The file extension is forbidden ({{file}}','en'),(2751,2751,'Incorrect permissions','en'),(2752,2752,'Incorrect amount','en'),(2753,2753,'Not enough permissions to import user access level','en'),(2754,2754,'Wrong access level format ({{value}})','en'),(2755,2755,'Not enough permissions to import user roles','en'),(2756,2756,'Wrong role name ({{value}})','en'),(2757,2757,'Roles cannot be changed for your profile via import. Row will be skipped','en'),(2758,2758,'Access level cannot be changed (from {{prevValue}} to {{value}}) for existing profile ({{login}})','en'),(2759,2759,'You cannot update administrator profile ({{value}}). Row will be skipped','en'),(2760,2760,'You cannot update administrator profile ({{value}}). Row has been skipped','en'),(2761,2761,'The count of categories specified for a product and the count of orderBy position numbers describing the position of the product within these categories must be the same.','en'),(2762,2762,'OrderBy position number must be specified as a non-negative integer.','en'),(2763,2763,'Category name should not be empty','en'),(2764,2764,'After the problem has been fixed, try to connect again.\', {\'clear_cache\': url(\'addons_list_marketplace','en'),(2765,2765,'All items','en'),(2766,2766,'Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.','en'),(2767,2767,'Autogenerate','en'),(2768,2768,'Background export is in progress','en'),(2769,2769,'Clean URLs are disabled. More info\', {\'more_info_url\': url(\'settings\', \'','en'),(2770,2770,'Clean URLs','en'),(2771,2771,'The Clean URL entered is already in use by another page. To resolve the conflict, edit the \"clean_urls_aliases\" section in the file etc/config.php.','en'),(2772,2772,'The Clean URL you have specified matches the name of a folder on your server. Please use a different URL.','en'),(2773,2773,'First','en'),(2774,2774,'Last','en'),(2775,2775,' > ','en'),(2776,2776,'X-Cart','en'),(2777,2777,'','en'),(2778,2778,'Title','en'),(2779,2779,'[Edit]','en'),(2780,2780,'Parent category path','en'),(2781,2781,'Object name (category, product, etc)','en'),(2782,2782,'General options','en'),(2783,2783,'404 page','en'),(2784,2784,'Regular text for 404 page','en'),(2785,2785,'Show сustomer relations e-mails on 404 page','en'),(2786,2786,'<div><a href=\'{home}\'>Go to home page</a> | <a href=\'{contact us}\'>Contact us</a></div><div>If you continue having trouble finding what you are looking for please contact our customer service department.</div>','en'),(2787,2787,'Default site title','en'),(2788,2788,'Default site meta description','en'),(2789,2789,'Default site meta keywords','en'),(2790,2790,'Home page title and meta','en'),(2791,2791,'Page title format','en'),(2792,2792,'Show object name in page title','en'),(2793,2793,'About clean urls','en'),(2794,2794,'Page title consists of the following elements separated by the delimiter \"{{delimiter}}\"; you can change the delimiter by editing the <a href=\"{{modify_url}}\">title-delimiter</a> label','en'),(2795,2795,'Every object stores a history of up to 8 clean urls that were used for the object previously. X-Cart sets 301 redirects for these URLs automatically.','en'),(2796,2796,'Also, you can adjust your 301 redirects in the .htaccess file (See <a href=\"https://kb.x-cart.com/en/general_setup/setting_up_seo-friendly_urls.html\" target=\"blank\">Setting up seo-friendly URLs</a> for Nginx or IIS configuration), or use a special extension by 3d party module developers (<a href=\"https://market.x-cart.com/addons/redirects-by-Nova-Horizon.html\"  target=\"blank\">Redirects module</a>)','en'),(2797,2797,'Connecting to the marketplace...','en'),(2798,2798,'Do not see your payment method? Find it on our Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing','en'),(2799,2799,'Enter product name or SKU','en'),(2800,2800,'Export all','en'),(2801,2801,'Export selected','en'),(2802,2802,'File was successfully uploaded','en'),(2803,2803,'Hide and make them available only via a direct link','en'),(2804,2804,'Ignore membership','en'),(2805,2805,'Import results','en'),(2806,2806,'Info','en'),(2807,2807,'Initializing...','en'),(2808,2808,'Inventory tracking is','en'),(2809,2809,'Login is locked out','en'),(2810,2810,'Manage zones','en'),(2811,2811,'Marketing','en'),(2812,2812,'Minimum value is {{value}}','en'),(2813,2813,'Modules','en'),(2814,2814,'Options','en'),(2815,2815,'Order cannot be placed because there is no shipping methods available.','en'),(2816,2816,'Order number or email','en'),(2817,2817,'Please wait','en'),(2818,2818,'Prices & Inventory','en'),(2819,2819,'Recalculate totals','en'),(2820,2820,'Recent orders only','en'),(2821,2821,'SKU length must be less than {{length}}','en'),(2822,2822,'{{field}} length must be less than {{length}}','en'),(2823,2823,'SKU or SKU1, SKU2','en'),(2824,2824,'Select language to edit','en'),(2825,2825,'Separate box','en'),(2826,2826,'Shipping method / cost','en'),(2827,2827,'Show in all the sections','en'),(2828,2828,'Show only in categories and search listings','en'),(2829,2829,'Show only in search listing','en'),(2830,2830,'Show:','en'),(2831,2831,'Soft and Hard reset links for your store','en'),(2832,2832,'Sort by:','en'),(2833,2833,'Sort settings','en'),(2834,2834,'Specify your _store information_\', {\'URL\': url(\'settings\', \'','en'),(2835,2835,'The secure protocol for your website is disabled.','en'),(2836,2836,'The secure protocol for your website is enabled.','en'),(2837,2837,'This payment method is not configured.','en'),(2838,2838,'Time left','en'),(2839,2839,'To setup Tax Rates, find and install the appropriate addons from Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Taxes','en'),(2840,2840,'Transaction ID','en'),(2841,2841,'Try to change the search criteria or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing','en'),(2842,2842,'Try to search worldwide or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing','en'),(2843,2843,'Updating data from the marketplace...','en'),(2844,2844,'You can purchase AntiFraud Service subscription','en'),(2845,2845,'You need these links in case you want to recover your store','en'),(2846,2846,'or use the form below','en'),(2847,2847,'the same as billing','en'),(2848,2848,'Add product','en'),(2849,2849,'Are you sure you want to enable https anyway?','en'),(2850,2850,'Check for updates','en'),(2851,2851,'Install anyway','en'),(2852,2852,'Update modules','en'),(2853,2853,'The \"{{file}}\" file is not allowed and was not uploaded. Allowed extensions are: {{extensions}}','en'),(2854,2854,'Couldn\'t download the banner \"{{value}}\"','en'),(2855,2855,'Error of banner loading. Make sure the \"images\" directory has write permissions.','en'),(2856,2856,'Searching','en'),(2857,2857,'No results found.','en'),(2858,2858,'Enter a keyword to search.','en'),(2859,2859,'Loading more results','en'),(2860,2860,'Please enter 3 or more characters','en'),(2861,2861,'Item list','en'),(2862,2862,'Minor update','en'),(2863,2863,'Major upgrade','en'),(2864,2864,'Major improvements and new features','en'),(2865,2865,'Minor improvements','en'),(2866,2866,'{{count}} items selected','en'),(2867,2867,'Maximum items in box','en'),(2868,2868,'Upgrade not allowed','en'),(2869,2869,'X-Cart v5.3 requires PHP version 5.4 or better. Please update the PHP version installed on your server before you proceed.','en'),(2870,2870,'X-Cart v5.4 requires PHP version 7.2 or better. Please update the PHP version installed on your server before you proceed.','en'),(2871,2871,'X-Cart v5.4 requires MariaDB version 10.2.4 or better. Please update the MariaDB version installed on your server before you proceed.','en'),(2872,2872,'X-Cart v5.4 requires MySQL version 5.7.7 or better. Please update the MySQL version installed on your server before you proceed.','en'),(2873,2873,'Header, greeting & signature','en'),(2874,2874,'Greeting','en'),(2875,2875,'Header','en'),(2876,2876,'Signature','en'),(2877,2877,'State','en'),(2878,2878,'Scheme','en'),(2879,2879,'Body','en'),(2880,2880,'Dynamic message','en'),(2881,2881,'Customer email notification','en'),(2882,2882,'Admin email notification','en'),(2883,2883,'Customer','en'),(2884,2884,'Administrator','en'),(2885,2885,'Customer','en'),(2886,2886,'Administrator','en'),(2887,2887,'Add countries','en'),(2888,2888,'Subscribe','en'),(2889,2889,'Sign in / sign up','en'),(2890,2890,'Quick view','en'),(2891,2891,'Billing','en'),(2892,2892,'Enable this if you would like us to use your shipping address as your billing address','en'),(2893,2893,'Proceed to payment','en'),(2894,2894,'Shipping to','en'),(2895,2895,'Billing to','en'),(2896,2896,'same as shipping','en'),(2897,2897,'Choose shipping','en'),(2898,2898,'Payment','en'),(2899,2899,'There is already state with code {{code}} in {{country}}','en'),(2900,2900,'Last time re-deployed at','en'),(2901,2901,'YES','en'),(2902,2902,'NO','en'),(2903,2903,'E-mail will also be updated in all the related orders.','en'),(2904,2904,'The countries to which the selected states belong will be added to the zone automatically.','en'),(2905,2905,'Hi,<br/><br/>X-Cart Team have done their best to make your upgrade process as enjoyable as possible. If that didn’t work out well for you, please follow these quick steps to get it right:','en'),(2906,2906,'First, restore your website from the created backup - this is the fastest way to get your store back online.','en'),(2907,2907,'Second, try to disable all non-X-Cart modules by using the links below:','en'),(2908,2908,'Soft reset. Turn off all addons except those provided by X-Cart Team & Qualiteam','en'),(2909,2909,'Hard reset. Disable all addons except those provided by X-Cart Team','en'),(2910,2910,'If you still need help, please, feel free to contact X-Cart Help Desk at <a href=”mailto:helpdesk@x-cart.com”>helpdesk@x-cart.com</a>. Remember to attach the log files (from “xcart_directory/var/log”) to your email, so that their tech engineers could instantly spot the problem and help you to fix it in the most effective way possible.','en'),(2911,2911,'Performing task...','en'),(2912,2912,'This process may take a while to complete. Please do not close this page until the process is fully completed. If you have closed the page, please re-open it to complete the process as it is in progress only when the page is open.','en'),(2913,2913,'Recalculate view lists','en'),(2914,2914,'This action reloads each @ListChild annotation and updates view list records in database.','en'),(2915,2915,'Clear data and widget cache','en'),(2916,2916,'Cache clearing might be helpful if there are some widgets with outdated information. Clicking this will remove data from cache driver.','en'),(2917,2917,'Start','en'),(2918,2918,'Orders awaiting processing','en'),(2919,2919,'Awaiting processing','en'),(2920,2920,'Only orders awaiting processing','en'),(2921,2921,'On category listing','en'),(2922,2922,'On category and product details page','en'),(2923,2923,'Column \"{{value}}\" is required','en'),(2924,2924,'Wrong format of \"order number\" field','en'),(2925,2925,'Wrong format of \"anonymous\" field','en'),(2926,2926,'Wrong format of \"address same\" field','en'),(2927,2927,'Wrong format of \"subtotal\" field','en'),(2928,2928,'Wrong format of \"total\" field','en'),(2929,2929,'Wrong format of \"currency\" field','en'),(2930,2930,'Fulfillment status not found, \"New\" will be used for order','en'),(2931,2931,'Payment status not found, \"Awaiting payment\" will be used for order','en'),(2932,2932,'Stock status not found','en'),(2933,2933,'Order modifier \"{{value}}\" not found','en'),(2934,2934,'Wrong format of \"order modifier\" field','en'),(2935,2935,'Wrong format of \"order item\", required fields \"{{value}}\" are missing','en'),(2936,2936,'Wrong format of \"order item sku\" field','en'),(2937,2937,'Wrong format of \"order item name\" field','en'),(2938,2938,'Wrong format of \"order item price\" field','en'),(2939,2939,'Wrong format of \"order item subtotal\" field','en'),(2940,2940,'Wrong format of \"order item total\" field','en'),(2941,2941,'Wrong format of \"order item quantity\" field','en'),(2942,2942,'Wrong order item backordered quantity format','en'),(2943,2943,'Order item modifier not found','en'),(2944,2944,'Wrong format of \"order item modifier\" field','en'),(2945,2945,'Wrong format of \"order transaction\", required fields \"{{value}}\" are missing','en'),(2946,2946,'Wrong format of \"order transaction method\" field','en'),(2947,2947,'Order transaction status not found','en'),(2948,2948,'Wrong format of \"order transaction value\" field','en'),(2949,2949,'Order transaction type not found','en'),(2950,2950,'Wrong format of \"order transaction id\" field','en'),(2951,2951,'Wrong format of \"order transaction currency\" field','en'),(2952,2952,'No account yet?','en'),(2953,2953,'No problem! Enter your email address','en'),(2954,2954,'Log in to your account','en'),(2955,2955,'to enjoy faster & easier checkout','en'),(2956,2956,'or proceed with','en'),(2957,2957,'You can continue as guest or <a href=\"{{URL}}\" class=\"sign-in register\">create an account</a>','en'),(2958,2958,'Apply sorting globally','en'),(2959,2959,'Integrity check','en'),(2960,2960,'Unknown core version','en'),(2961,2961,'The core may be checked only if a valid license key is present.','en'),(2962,2962,'The module may be checked only if a valid license key is present.','en'),(2963,2963,'Cannot check the files for this module','en'),(2964,2964,'Refresh integrity status','en'),(2965,2965,'Added','en'),(2966,2966,'Modified','en'),(2967,2967,'Removed','en'),(2968,2968,'Errors','en'),(2969,2969,'Integrity has not yet been checked. Initiate an integrity check by clicking the button \"Refresh integrity status\".','en'),(2970,2970,'Integrity check has been completed successfully.','en'),(2971,2971,'Integrity check has been stopped.','en'),(2972,2972,'Switch to <a href=\"javascript: void(0)\">Category tree</a>','en'),(2973,2973,'Switch to <a href=\"javascript: void(0)\">Category search</a>','en'),(2974,2974,'Parent category name','en'),(2975,2975,'All addons','en'),(2976,2976,'Disabled only','en'),(2977,2977,'Enabled only','en'),(2978,2978,'Please be warned that proper operation of the site after an upgrade is not guaranteed if you choose to upgrade only some of the components listed below. Please use the selective upgrade feature at your own risk and only if you know exactly what you are doing.','en'),(2979,2979,'Enable selected','en'),(2980,2980,'Disable selected','en'),(2981,2981,'Enable all','en'),(2982,2982,'Disable all','en'),(2983,2983,'Clone selected','en'),(2984,2984,'This field will be required if the selected country has states, and will not be required if the selected country does not have states.','en'),(2985,2985,'Will be available if core update is selected','en'),(2986,2986,'No category assigned','en'),(2987,2987,'Not assigned','en'),(2988,2988,'Developer wave','en'),(2989,2989,'Your license key is set up to get upgrades in the  {{wave_name}} wave. Therefore, upgrading may require some technical assistance on your part. If you are not prepared to deal with upgrade issues that may arise when upgrading in the developer wave, please, wait for the merchant wave. You can switch to the merchant wave <a  href=\"{{link_to_waves}}\" target=\"_blank\">on this page</a>','en'),(2990,2990,'Products in this class: {{X}}','en'),(2991,2991,'Canceling','en'),(2992,2992,'Installing native <a target=\'_blank\' href=\'http://php.net/manual/en/mbstring.installation.php\'><b>mbstring extension</b></a> is highly recommended due to the major speedup of PDF generation and general string processing.','en'),(2993,2993,'<a href=\"http://php.net/manual/en/dom.installation.php\" target=\"_blank\"><b>DOM extension</b></a> must be enabled to ensure that email notifications work correctly.','en'),(2994,2994,'<p>There are currently no orders in the store. Once your store has orders, this is where you’ll process and track them. Get accustomed with the order workflow at <a target=\'_blank\' href=\'https://kb.x-cart.com/en/orders/understanding_x-cart_order_statuses.html\'>X-Cart Knowledge Base</a>.</p>','en'),(2995,2995,'There are currently no orders in the store.','en'),(2996,2996,'<p>No payment transactions have been made yet. Once a customer will place an order, this is where you can track payment status and transaction details.</p>','en'),(2997,2997,'<p>Products catalog is empty. Start your sales by adding products using the <b>\"Add product\"</b> button or via import. Learn how to configure a product at <a target=\'_blank\' href=\'https://kb.x-cart.com/en/products/adding_products.html#adding-a-new-product\'>X-Cart Knowledge Base</a>.</p>','en'),(2998,2998,'Products catalog is empty.','en'),(2999,2999,'<p>There are no categories in the store. Group your products by adding categories using the <b>\"New category\"</b> button or via import.</p>','en'),(3000,3000,' <p>There are no memberships in the store. Memberships allow you to group your customers and give them different privileges. You can add them by clicking the <b>\"New membership\"</b> button, Learn more at <a target=\'_blank\' href=\'https://kb.x-cart.com/en/users/adding_user_membership_levels.html\'>X-Cart Knowledge Base</a>.</p>','en'),(3001,3001,'Categories processed','en'),(3002,3002,'Processing categories...','en'),(3003,3003,'Categories processed: {{X}} out of {{Y}} (errors: {{errors}}, warnings: {{warns}})','en'),(3004,3004,'Categories processed: {{X}} out of {{Y}}','en'),(3005,3005,'Categories processed: {{count}}','en'),(3006,3006,'Order {{order_number}} has been confirmed as delivered to the customer.','en'),(3007,3007,'Products with no assigned categories','en'),(3008,3008,'The selected categories have been deleted. As a result, there are products with no assigned category. You can re-arrange the location of these products by using bulk edit.','en'),(3009,3009,'Show products with no assigned category','en'),(3010,3010,'The import process has been canceled','en'),(3011,3011,'Logout this user','en'),(3012,3012,'Profile actions','en'),(3013,3013,' <p>There are no subcategories in the category.</p>','en'),(3014,3014,'The product you are trying to add to cart is unavailable.','en'),(3015,3015,'Current password','en'),(3016,3016,'<a href=\"{{url}}\">Send reset link</a>','en'),(3017,3017,'Installation script','en'),(3018,3018,'The root folder of your installed X-Cart store still contains the file install.php that is used to launch X-Cart installation. Keeping this file in the said location \'as is\' is not secure. We strongly recommend that this file should be deleted or renamed to prevent unauthorized access to the store installation tools.','en'),(3019,3019,'Config file','en'),(3020,3020,'Config file does not exist and cannot be copied from the default config file. It is required for the installation.<br /><br />Please, follow these steps: <br /><br />1. Go to directory {{configPath}}<br />2. Copy <i>{{defaultConfigFileName}}</i> to <i>{{configFileName}}</i><br />3. Set writeable permissions on <i>{{configFileName}}</i><br /><br />Then try again.','en'),(3021,3021,'Config file does not exist and cannot be copied from the default config file. It is required for the installation.<br /><br />Please, follow these steps: <br /><br />1. Go to directory {{configPath}}<br />2. Copy <i>{{defaultConfigFileName}}</i> to <i>{{configFileName}}</i><br />3. Set writeable permissions on <i>{{configFileName}}</i><br /><br />Then try again.','en'),(3022,3022,'PHP version','en'),(3023,3023,'PHP Version must be at least {{minPhpVersion}}.','en'),(3024,3024,'PHP Version must be not greater than {{maxPhpVersion}}.','en'),(3025,3025,'Unsupported PHP version detected.','en'),(3026,3026,'PHP versions <b>7.2.0+</b> are currently supported.','en'),(3027,3027,'Disabled functions','en'),(3028,3028,'The following functions are disabled:<br/>{{missedFunctions}}<br/>These functions may be used by the software in some cases and should be enabled.','en'),(3029,3029,'Some functions, used by X-Cart, are found disabled. Make sure that these functions are not listed in \"disable_functions\" option and all php extensions required for these functions availability are enabled in the php.ini file. Please correct this and try again.','en'),(3030,3030,'Check our <a href=\"https://kb.x-cart.com/en/general_setup/installation_guide.html#disabled-functions\" target=\"_blank\">Knowledge Base</a> in order to find out how to solve the problem with disabled PHP functions.','en'),(3031,3031,'Memory limit','en'),(3032,3032,'PHP memory_limit option must be at least {{memoryLimitMin}}.','en'),(3033,3033,'PHP memory_limit option must be at least {{memoryLimitMin}}.','en'),(3034,3034,'File uploads','en'),(3035,3035,'PHP file_uploads option must be set to On.','en'),(3036,3036,'The configuration of the server where X-Cart will be installed meets the Server requirements; however, some server software issues, which can impair X-Cart operation, have been identified on the server.<br /><br />For proper operation of X-Cart the value of the upload_max_filesize variable in the php.ini file should indicate the maximum file size allowed for upload.','en'),(3037,3037,'PDO extension','en'),(3038,3038,'PDO extension with MySQL support must be installed.','en'),(3039,3039,'PDO extension with enabled MySQL support is used by X-Cart for connecting to the database. Please make sure this extension is loaded in your php.ini file and try again.','en'),(3040,3040,'Check our <a href=\"https://kb.x-cart.com/en/general_setup/installation_guide.html#disabled-php-extensions\" target=\"_blank\">Knowledge Base</a> in order to find out how to solve the problem with PDO extension.','en'),(3041,3041,'Upload file size limit','en'),(3042,3042,'PHP option upload_max_filesize must contain a value. It is currently empty.','en'),(3043,3043,'For proper operation of X-Cart the value of the upload_max_filesize option in the php.ini file should indicate the maximum file size allowed for upload. Please correct this option or contact your hosting provider\'s support to have the parameter adjusted.','en'),(3044,3044,'File permissions','en'),(3045,3045,'Not enough permissions to run the process. Please make sure the following files are writable:<br /><div class=\"permissions-list\">{{pathsList}}</div>','en'),(3046,3046,'Not enough permissions to run the process. Make sure the following permissions are set (UNIX-like systems only):<br /><div class=\"permissions-list\">{{pathsList}}</div>Such permissions are required for a seamless automated installation or upgrade of X-Cart on your server. They do not take into account the specific configuration of your server or any security requirements. Once the process is completed, make sure you change the permissions to a more restrictive setting. <a target=\"_blank\" href=\"https://kb.x-cart.com/en/setting_up_x-cart_5_environment/secure_configuration.html#why-x-cart-asks-for-666777-permissions\">Read more</a>','en'),(3047,3047,'Check our <a href=\"https://kb.x-cart.com/en/general_setup/installation_guide.html#permissionchecking-failed\" target=\"_blank\">Knowledge Base</a> in order to find out how to solve the problem with incorrect permissions.','en'),(3048,3048,'MySQL version','en'),(3049,3049,'MySQL version must be at least {{minMysqlVersion}}.','en'),(3050,3050,'InnoDB engine is not supported by MySQL server. InnoDB is required for X-Cart operation.','en'),(3051,3051,'Cannot get MySQL server version ({{error}}).','en'),(3052,3052,'MySQL cache','en'),(3053,3053,'MySQL query cache is not enabled. See <a href=\"https://dev.mysql.com/doc/refman/5.7/en/query-cache-configuration.html\" target=\"_blank\">https://dev.mysql.com/doc/refman/5.7/en/query-cache-configuration.html</a> for how to enable it.','en'),(3054,3054,'GDlib extension','en'),(3055,3055,'GDlib extension v.2.0 or later is required for some modules.','en'),(3056,3056,'GDlib extension does not have the JPEG plugin.','en'),(3057,3057,'Phar extension','en'),(3058,3058,'Phar extension must be installed.','en'),(3059,3059,'Phar extension is required for installation of external X-Cart addons and upgrades from the Marketplace. Please contact your hosting provider\'s support to have this parameter adjusted.','en'),(3060,3060,'HTTPS bouncers','en'),(3061,3061,'libcurl extension is found but does not support secure protocols.','en'),(3062,3062,'libcurl extension not found.','en'),(3063,3063,'The libCURL module with HTTPS protocol support and a valid SSL certificate is required for credit cards processing via Authorize.NET, PayPal or other payment gateways and using real-time shipping calculation services (these services require your website to accept secure connections via HTTPS/SSL). Please contact your hosting provider\'s support to have these parameters adjusted.','en'),(3064,3064,'Check our <a href=\"https://kb.x-cart.com/en/general_setup/installation_guide.html#https-bouncer-is-not-installed\" target=\"_blank\">Knowledge Base</a> in order to find out how to solve the problem with libCurl library.','en'),(3065,3065,'XML extensions support','en'),(3066,3066,'XML/Expat and DOM extensions are required for some modules.','en'),(3067,3067,'Xml/EXPAT and DOMDocument extensions for PHP are required for using real-time shipping modules and payment modules. Please contact your hosting provider\'s support to have these parameters adjusted.','en'),(3068,3068,'DocBlocks support','en'),(3069,3069,'The DocBlock feature is not supported by your PHP. This feature is required for X-Cart operation.','en'),(3070,3070,'The DocBlock feature is not supported by your PHP. This feature is required for X-Cart operation. The cause of DocBlock feature being blocked may be the eAccelerator extension. Disable this extension and try again.','en'),(3071,3071,'Check our <a href=\"https://kb.x-cart.com/en/general_setup/installation_guide.html#permissionchecking-failed\" target=\"_blank\">Knowledge Base</a> in order to find out how to solve the problem with incorrect permissions.','en'),(3072,3072,'Loopback request','en'),(3073,3073,'My Addons (service.php) is not available, please <a href=\"{{url}}\">contact us</a>','en'),(3074,3074,'','en'),(3075,3075,'','en'),(3076,3076,'Category id or path is required','en'),(3077,3077,'Last element of category path should be same as name if no category id is presented','en'),(3078,3078,'Category with id \"{{value}}\" not found, new category with different id will be created','en'),(3079,3079,'CSV format tables','en'),(3080,3080,'Need to set up free shipping? <a href=\"{{url}}\" target=\"_blank\">Learn how</a>.','en'),(3081,3081,'Show states for selected countries only','en'),(3082,3082,'Profile details','en'),(3083,3083,'Attention!','en'),(3084,3084,'Ok, Got it','en'),(3085,3085,'To install modules and get X-Cart upgrades, PHP\'s <a href=\"http://php.net/manual/en/book.phar.php\" target=\"_blank\">Phar extension</a> needs to be enabled on your server. Please contact your hosting provider.','en'),(3086,3086,'Also, you can review X-Cart recommended hosting providers <a href=\"https://market.x-cart.com/experts-and-services#filter[tags]=Hosters\" target=\"_blank\">in our marketplace</a>.','en'),(3087,3087,'Your X-Cart Business trial has expired!','en'),(3088,3088,'You must register your X-Cart installation before using it for real sales. Activate your existing license key or purchase a <strong>premium license to skyrocket your business</strong>.','en'),(3089,3089,'This message can be removed only through activation of a free or premium license.','en'),(3090,3090,'Refer to <a href=\"{{licenseAgreementURL}}\" target=\"_blank\" rel=\"nofollow\">X-Cart license agreement</a> for further details.','en'),(3091,3091,'Remind me on next sign-in','en'),(3092,3092,'Purchase a premium license key','en'),(3093,3093,'I have a license key','en'),(3094,3094,'Enter your premium license key','en'),(3095,3095,'<a href=\"{{url}}\">Activate free X-Cart license & remove premium features.</a>','en'),(3096,3096,'<a href=\"{{url}}\" target=\"_blank\" rel=\"nofollow\">Contact X-Cart</a> if you have any questions.','en'),(3097,3097,'License key registration','en'),(3098,3098,'X-Cart Business trial will expire in {{count}} day','en'),(3099,3099,'X-Cart Business trial will expire in {{count}} days','en'),(3100,3100,'X-Cart Business trial will expire in {{count}} days','en'),(3101,3101,'Please register your license key now or purchase a <strong>premium license to skyrocket your business</strong>.','en'),(3102,3102,'{{count}} day left','en'),(3103,3103,'{{count}} days left','en'),(3104,3104,'{{count}} days left','en'),(3105,3105,'Trial has expired!','en'),(3106,3106,'Register license key','en'),(3107,3107,'Warning! The image cannot be resized to reduce capacity for better site performance.','en'),(3108,3108,'Previous order','en'),(3109,3109,'Next order','en'),(3110,3110,'Click to expand menu','en'),(3111,3111,'<span>Need a way to set multicurrency prices?</span> <a href=\"{{url}}\" target=\"_blank\">Install the addon</a>','en'),(3112,3112,'<span>Need a way to set up product variants?</span> <a href=\"{{url}}\" target=\"_blank\">Install the addon</a>','en'),(3113,3113,'<span>Need a way to set wholesale prices?</span> <a href=\"{{url}}\" target=\"_blank\">Install the addon</a>','en'),(3114,3114,'Image quality after resize','en'),(3115,3115,'Apply unsharp mask filter on resize','en'),(3116,3116,'Clearing this field hides the option for this product only. To remove the attribute for all the products, use the <a href=\"{{link}}\" target=\"_blank\">\"Classes & Attributes\" page</a>.','en'),(3117,3117,'Apply attribute value changes for all the products','en'),(3118,3118,'Will be added globally','en'),(3119,3119,'Will be added to the product class','en'),(3120,3120,'The name will be changed globally','en'),(3121,3121,'The totals have been recalculated. Press \"Save changes\" to adjust the order','en'),(3122,3122,'Your access to <a href=\"{{url}}\">X-Cart Business features</a> expires in {{count}} day','en'),(3123,3123,'Your access to <a href=\"{{url}}\">X-Cart Business features</a> expires in {{count}} days','en'),(3124,3124,'Your access to <a href=\"{{url}}\">X-Cart Business features</a> expires in {{count}} days','en'),(3125,3125,'Discounts','en'),(3126,3126,'Marketing','en'),(3127,3127,'My addons','en'),(3128,3128,'Custom CSS & JS','en'),(3129,3129,'System tools','en'),(3130,3130,'System logs','en'),(3131,3131,'My profile','en'),(3132,3132,'Quick menu','en'),(3133,3133,'Add sales channel','en'),(3134,3134,'Saving','en'),(3135,3135,'Users list','en'),(3136,3136,'Image resizing requires GDLib 2.0 or ImageMagick','en'),(3137,3137,'Your payment has been processed; now the addon can be installed.','en'),(3138,3138,'Your payment is being processed. The addon license key will be sent to your email address as soon as the processing has been completed. You will be able to use this key to install the addon at any time.','en'),(3139,3139,'Purchased addons','en'),(3140,3140,'My purchases','en'),(3141,3141,'new core','en'),(3142,3142,'{{count}} addon','en'),(3143,3143,'{{count}} addons','en'),(3144,3144,'{{count}} addons','en'),(3145,3145,'new core and {{count}} addon','en'),(3146,3146,'new core and {{count}} addons','en'),(3147,3147,'new core and {{count}} addons','en'),(3148,3148,'<a href=\"{{url}}\">Or add a video review powered by Shopper Approved</a>','en'),(3149,3149,'Want to customize review surveys and display video testimonials? <a href=\"{{url}}\">Try Shopper Approved and collect up to 70x more ratings and reviews</a>','en'),(3150,3150,'Consistency check','en'),(3151,3151,'Surcharges','en'),(3152,3152,'There are {{model}} without valid {{another_model}} relation','en'),(3153,3153,'There are {{model}} with missing {{another_model}}','en'),(3154,3154,'Attribute value ID {{valueId}}','en'),(3155,3155,'Attribute values (select)','en'),(3156,3156,'We couldn\'t find one correct root category','en'),(3157,3157,'We couldn\'t find one correct root category, however there are possible candidates','en'),(3158,3158,'There is one valid root category, however there are multiple root category candidates','en'),(3159,3159,'Consistency has not yet been checked. Initiate an consistency check by clicking the button \"Refresh consistency status\".','en'),(3160,3160,'Refresh consistency status','en'),(3161,3161,'There are no inconsistencies found','en'),(3162,3162,'RoundUp','en'),(3163,3163,'No roundup','en'),(3164,3164,'up to 2 decimals','en'),(3165,3165,'up to 1 decimal','en'),(3166,3166,'up to integer','en'),(3167,3167,'up to 10','en'),(3168,3168,'up to 100','en'),(3169,3169,'<span>Need a customizable contact us form with location map?</span> <a href=\"{{url}}\" target=\"_blank\">Get it now!</a>','en'),(3170,3170,'Order staff notes changed','en'),(3171,3171,'Order customer notes changed','en'),(3172,3172,'Order has been edited','en'),(3173,3173,'Let TaxJar automate your sales tax calculations, reporting, and filings in minutes.','en'),(3174,3174,'TaxJar enabled','en'),(3175,3175,'Sign up for TaxJar','en'),(3176,3176,'Install TaxJar integration','en'),(3177,3177,'TaxJar Dashboard','en'),(3178,3178,'TaxJar Category','en'),(3179,3179,'We recommend to configure the background job processing on your server to send emails asynchronously, improving the website performance. <a href=\"{{url}}\" target=\"_blank\">Learn how to do this</a>.','en'),(3180,3180,'Change payment status for selected','en'),(3181,3181,'Change fulfillment status for selected','en'),(3182,3182,'Installing addons','en'),(3183,3183,'Attention! You are creating an account with full access. If necessary, you can set a lower level of access by choosing an appropriate role. <a href=\"{{roles_link}}\" target=\"_blank\">Manage roles</a>. <a href=\"{{kb_link}}\" target=\"_blank\">Learn more</a> about permissions and roles.','en'),(3184,3184,'Contact Us page settings','en'),(3185,3185,'Date and time on the server','en'),(3186,3186,'Date and time in the store','en'),(3187,3187,'The file you are trying to upload is too large. Try using a smaller one.','en'),(3188,3188,'The file you are trying to upload is too large. Try using a smaller one.','en'),(3189,3189,'For some reason, the file upload has not been completed. Please try again or use a different file.','en'),(3190,3190,'For some reason, the file upload has not been completed. Please try again or use a different file.','en'),(3191,3191,'Server-side problem with image upload. Contact your server administrator.','en'),(3192,3192,'Server-side problem with image upload. Contact your server administrator.','en'),(3193,3193,'Server-side problem with image upload. Contact your server administrator.','en'),(3194,3194,'No file was uploaded','en'),(3195,3195,'Your PHP {{version}} is outdated','en'),(3196,3196,'Your PHP {{version}} is outdated and no longer supported (<a href=\"http://php.net/eol.php\" target=\"_blank\">http://php.net/eol.php</a>). We recommend updating PHP to the latest stable version to improve your store performance. To update your PHP version, contact your hosting provider.','en'),(3197,3197,'Failed to download image from URL. Make sure the URL is correct and the file referenced by the URL is a PNG/JPG/JPEG','en'),(3198,3198,'Transaction is in progress, please wait...','en'),(3199,3199,'to be uninstalled','en'),(3200,3200,'Review modules','en'),(3201,3201,'Logo image','en'),(3202,3202,'Manage logo dimensions','en'),(3203,3203,'E-Mail transfer settings','en'),(3204,3204,'Email from the Contact information section','en'),(3205,3205,'Sender email as identified by the server','en'),(3206,3206,'Email address specified below','en'),(3207,3207,'Specify email address','en'),(3208,3208,'Go to <a href=\'https://www.mail-tester.com/\' target=\'_blank\'>https://www.mail-tester.com/</a> and copy the email address provided on that page to clipboard. ','en'),(3209,3209,'Paste the email address you have copied into the form below (the \"To email\" field) and try sending a test email.','en'),(3210,3210,'Go back to <a href=\'https://www.mail-tester.com/\' target=\'_blank\'>https://www.mail-tester.com/</a> and press the button to check your score. Allow a few seconds for the mail tester system to check the inbox and calculate your score. The highest score would be 10/10.','en'),(3211,3211,'Share the results with your hosting provider or administrators and, if necessary, ask them to improve your score. ','en'),(3212,3212,'Learn how to test your email transfer settings with mail-tester.com.','en'),(3213,3213,'body of the test email','en'),(3214,3214,'Test your emails','en'),(3215,3215,'If a category has subcategories, the value in brackets shows the overall number of products in both that category and all its subcategories.','en'),(3216,3216,'Please select','en'),(3217,3217,'Recently installed addons','en'),(3218,3218,'Installed Addons','en'),(3219,3219,'Free & paid','en'),(3220,3220,'You don’t have any notifications right now.','en'),(3221,3221,'Status comment (reason)','en'),(3222,3222,'Import and Export','en'),(3223,3223,'Setting up tax','en'),(3224,3224,'Setting up Canadian taxes','en'),(3225,3225,'Setting up tax classes','en'),(3226,3226,'Setting up European / UK Taxes','en'),(3227,3227,'Setting up US Taxes','en'),(3228,3228,'https://kb.x-cart.com/','en'),(3229,3229,'https://kb.x-cart.com/general_setup/what_to_do_if_your_store_says_we_are_deploying_new_changes_and_you_cannot_access_it.html','en'),(3230,3230,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html#transfering-database','en'),(3231,3231,'https://kb.x-cart.com/seo_and_promotion/setting_up_seo-friendly_urls.html','en'),(3232,3232,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html','en'),(3233,3233,'https://kb.x-cart.com/import-export/','en'),(3234,3234,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_classes_&_attributes.html','en'),(3235,3235,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_product_attribute_values.html','en'),(3236,3236,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_categories.html','en'),(3237,3237,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_customers.html','en'),(3238,3238,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_products.html','en'),(3239,3239,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_orders.html','en'),(3240,3240,'https://kb.x-cart.com/setting_up_x-cart_5_environment/configuring_attachments_sending.html','en'),(3241,3241,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_express_checkout.html','en'),(3242,3242,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payflow_link.html','en'),(3243,3243,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_advanced.html','en'),(3244,3244,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_standard.html','en'),(3245,3245,'https://kb.x-cart.com/integrating_your_store_with_other_web-sites/sell_your_products_with_buy_button.html','en'),(3246,3246,'https://kb.x-cart.com/shipping/custom_table_rates.html','en'),(3247,3247,'https://kb.x-cart.com/general_setup/inaccessible_admin_area_after_enabling_https.html','en'),(3248,3248,'https://kb.x-cart.com/users/user_roles.html','en'),(3249,3249,'https://kb.x-cart.com/shipping/free_shipping.html','en'),(3250,3250,'https://kb.x-cart.com/taxes/tax_guide.html','en'),(3251,3251,'https://kb.x-cart.com/taxes/UK_EU_taxes/','en'),(3252,3252,'https://kb.x-cart.com/taxes/us_taxes/','en'),(3253,3253,'https://kb.x-cart.com/taxes/canadian_taxes/','en'),(3254,3254,'https://kb.x-cart.com/taxes/setting_up_tax_classes.html','en'),(3255,3255,'Email from the <a href=\"{{url}}\">contact information</a> section according to the type of email message','en'),(3256,3256,'Customer email (if exists)','en'),(3257,3257,'Wonder why it may have happened? It’s likely that your customer entered a wrong card number, password or CVC, had no money on his card, closed his browser by mistake or just fleeted away.<br><br>It may be a good idea to contact him and offer your help.','en'),(3258,3258,'Transaction was failed','en'),(3259,3259,'{{ field }} year must be between 1970 and 2038','en'),(3260,3260,'If the product is not available for sale, the system will return 404 response (page not found).','en'),(3261,3261,'If the product is not available for sale, the system will return <a href=\"{{productLink}}\" target=\"_blank\">404 not found page</a> with related products list as alternatives.','en'),(3262,3262,'If the category is disabled, the system will return <a href=\"{{categoryLink}}\" target=\"_blank\">404 not found page</a> with featured products list as alternatives.','en'),(3263,3263,'{{count}} day','en'),(3264,3264,'{{count}} days','en'),(3265,3265,'Access denied','en'),(3266,3266,'Access link has been sent','en'),(3267,3267,'Add addons','en'),(3268,3268,'Add address','en'),(3269,3269,'Address masks','en'),(3270,3270,'Address type','en'),(3271,3271,'Another bulk change in progress, please try again later','en'),(3272,3272,'Apply to billing address','en'),(3273,3273,'Business premium features','en'),(3274,3274,'CVV / CVC','en'),(3275,3275,'Change template','en'),(3276,3276,'Clear cache help text','en'),(3277,3277,'Critical','en'),(3278,3278,'Data removal has been completed successfully.','en'),(3279,3279,'Data removal has been stopped.','en'),(3280,3280,'Database','en'),(3281,3281,'Date and time in the shop','en'),(3282,3282,'Developer','en'),(3283,3283,'Disable HTTPS','en'),(3284,3284,'Download','en'),(3285,3285,'Enable module','en'),(3286,3286,'Error sending link','en'),(3287,3287,'File uploading','en'),(3288,3288,'Finish','en'),(3289,3289,'Hot addons','en'),(3290,3290,'Installation requirements','en'),(3291,3291,'License warnings','en'),(3292,3292,'Module name','en'),(3293,3293,'Monday','en'),(3294,3294,'Non-critical','en'),(3295,3295,'Not available','en'),(3296,3296,'Passed','en'),(3297,3297,'Payment order status','en'),(3298,3298,'Please select the entities first','en'),(3299,3299,'Private and custom modules:','en'),(3300,3300,'Private link','en'),(3301,3301,'Proceed','en'),(3302,3302,'Public installed modules:','en'),(3303,3303,'Rebuild view lists help text','en'),(3304,3304,'Remove expired sessions','en'),(3305,3305,'Remove expired shopping carts','en'),(3306,3306,'Remove module','en'),(3307,3307,'Removing expired datacache','en'),(3308,3308,'SKU must be unique','en'),(3309,3309,'Select type','en'),(3310,3310,'Shipping method is disabled','en'),(3311,3311,'Shipping method is enabled','en'),(3312,3312,'Shipping order status','en'),(3313,3313,'Skipped','en'),(3314,3314,'Soft and hard reset links for your store','en'),(3315,3315,'Sort','en'),(3316,3316,'Store ID','en'),(3317,3317,'Sunday','en'),(3318,3318,'Test e-mail have been successfully sent','en'),(3319,3319,'The Clean URL entered has unallowed chars.','en'),(3320,3320,'This payment method is','en'),(3321,3321,'Unknown error','en'),(3322,3322,'View in my addons','en'),(3323,3323,'Dashboard','en'),(3324,3324,'Dimensions','en'),(3325,3325,'<p>Oops, no products have been added to this category yet.</p><p><a href=\"{{homePageUrl}}\">Go back to the Home page</a></p>','en'),(3326,3326,'While editing, the initial product quantity has changed. Please check the product quantity field and correct the value correspondingly.','en'),(3327,3327,'Backordered','en'),(3328,3328,'Backordered (qty: {{qty}})','en'),(3329,3329,'This order was placed at the same time as {{orders}}; as a result, some items were out of stock at the time of order placement. <a href=\"{{kb_link}}\" target=\"_blank\">Learn more</a>','en'),(3330,3330,'Some items were out of stock at the time of order placement. <a href=\"{{kb_link}}\" target=\"_blank\">Learn more</a>','en'),(3331,3331,'Discard','en'),(3332,3332,'The Backorder status will be reset for the items. <br>The stock quantity of the backorder items will not change. Adjust it manually if necessary.','en'),(3333,3333,'Left in stock: {{quantity}}','en'),(3334,3334,'Enter alt text','en'),(3335,3335,'Select a date','en'),(3336,3336,'Start typing a category name','en'),(3337,3337,'<h6>Category is not accessible</h6><p>Your products are still accessible through the search and by direct link</p>','en'),(3338,3338,'Weak','en'),(3339,3339,'Good','en'),(3340,3340,'Strong','en'),(3341,3341,'Customer area','en'),(3342,3342,'Admin panel','en'),(3343,3343,'Default: {{code}}','en'),(3344,3344,'Original name','en'),(3345,3345,'Title for customers','en'),(3346,3346,'Description for customers','en'),(3347,3347,'Last exported','en'),(3348,3348,'Insight: Boost your sales with Google Ads addon','en'),(3349,3349,'Don’t lose any more sales that are coming to your website. LiveChat gives you an opportunity to engage in real-time conversations and convert more visitors before they leave.<br/> <a href=\"https://www.livechatinc.com/help/integrating-live-chat-with-your-x-cart-store/?a=x-cart&utm_campaign=pp_x-cart-inapp&utm_source=x-cart.com\" target=\"_blank\">Create a LiveChat account here</a>.','en'),(3350,3350,'Order placed','en'),(3351,3351,'{{ip}} IP address used','en'),(3352,3352,'[Inventory] Return back to stock: \"{{product}}\" product amount in stock changes from \"{{oldInStock}}\" to \"{{newInStock}}\" ({{qty}} items)','en'),(3353,3353,'[Inventory] Removed from stock: \"{{product}}\" product amount in stock changes from \"{{oldInStock}}\" to \"{{newInStock}}\" ({{qty}} items)','en'),(3354,3354,'[Inventory] Unable to reduce stock for product: \"{{product}}\", amount: \"{{qty}}\" items','en'),(3355,3355,'[Tracking] Tracking information was updated','en'),(3356,3356,'Email sent to the customer','en'),(3357,3357,'Failure sending email to the customer','en'),(3358,3358,'Email sent to the admin','en'),(3359,3359,'Failure sending email to the admin','en'),(3360,3360,'Transaction made','en'),(3361,3361,'Products have been split into parcels in order to estimate the shipping cost','en'),(3362,3362,'If anything crops up, just <a href=\"{{rollback_url}}\">rollback</a> or contact our support team - they know how to fix it right away.','en'),(3363,3363,'Discount cannot be more than 100%','en'),(3364,3364,'Period start date must be earlier than period end date','en'),(3365,3365,'Period end date must be later than period start date','en'),(3366,3366,'Cannot be disabled. The template is required by: {{moduleName}}','en'),(3367,3367,'Home','en'),(3368,3368,'Login with','en'),(3369,3369,'The directory selected as a parent directory has already been specified as a child directory','en'),(3370,3370,'Blocks','en'),(3371,3371,'Selectbox','en'),(3372,3372,'Display as','en'),(3373,3373,'This option applies only to attributes with multiple values','en'),(3374,3374,'Please select an option','en'),(3375,3375,'Please, re-generate the product catalog images to apply the new template settings. You can do it on the <a href=\"{{images_page_url}}\">\"Images\"</a> page by clicking the \"Generate resized images\" button.','en'),(3376,3376,'Your request has been sent, our manager will contact you shortly.','en'),(3377,3377,'Something went wrong, please try again or contact us at <a href=\"mailto:{{email}}\">{{email}}</a>','en'),(3378,3378,'Activated! Your current domain is <strong>{{domain}}</strong>','en'),(3379,3379,'Domain name','en'),(3380,3380,'Domain name transfer','en'),(3381,3381,'Please note that during the domain name transferring your store will be temporarily blocked. This process may take several minutes.','en'),(3382,3382,'Send anyway','en'),(3383,3383,'The domain are you looking for is available for registration:','en'),(3384,3384,'{{domain}} is on sale!','en'),(3385,3385,'If you are planning to use an email hosting service for this domain, please send us your MX and TXT records to <a href=\"mailto:helpdesk@x-cart.com\">helpdesk@x-cart.com</a> so that we could add the necessary DNS entries.','en'),(3386,3386,'Your domain name has been changed. It may take a few days for your domain name provider to make all the necessary changes and a few more days for the changes to propagate throughout the internet.','en'),(3387,3387,'An error occurred while transferring your store. Our engineers are already working on fixing it. You can continue to configure your store, all changes will be saved and transferred later. If you have any questions just drop us a line to <a href=\"mailto:helpdesk@x-cart.com\">helpdesk@x-cart.com</a>.','en'),(3388,3388,'Manage subscriptions','en'),(3389,3389,'Trial Plan\'','en'),(3390,3390,'{{currentEdition}} Plan','en'),(3391,3391,'Cancellation request','en'),(3392,3392,'The nameservers for your domain may have been entered incorrectly.</br>','en'),(3393,3393,'You can check your nameservers settings by following the instructions here: <a href=\"{{helpUrl}}\" target=\"_blank\">{{helpUrl}}</a>.</br>','en'),(3394,3394,'Please check the nameservers settings in your account on the registrar\'s website.</br>','en'),(3395,3395,'If you need help with the nameservers settings just drop us a line to <a href=\"mailto:helpdesk@x-cart.com\">helpdesk@x-cart.com</a>, we\'ll help you fix it.','en'),(3396,3396,'Entered domain name is already used by another store.','en'),(3397,3397,'An error occurred while validating the domain name. Error code: {{errCode}}.</br>Please, contact us by <a href=\"mailto:helpdesk@x-cart.com\">helpdesk@x-cart.com</a> to resolve this issue.','en'),(3398,3398,'Applying changes to global attributes','en'),(3399,3399,'The global attributes have been successfully changed.','en'),(3400,3400,'The global attributes changing process has been canceled.','en'),(3401,3401,'An error occurred during the global attributes changing.','en'),(3402,3402,'The \"Amazon Pay\" feature is not configured and cannot be used.','en'),(3403,3403,'The \"Amazon Pay\" feature requires https to be <a href=\"{{url}}\">properly set up</a> for your store.','en'),(3404,3404,'Amazon Seller ID','en'),(3405,3405,'If you do not have seller account, you can register here:<br /><a href=\"https://payments.amazon.com/signup?LD=SPEXUSAPA_XCart_core\" target=\"_blank\">USA</a>,&nbsp;<a href=\"https://payments.amazon.co.uk/preregistration/lpa?LD=SPEXUKAPA_XCart_core\" target=\"_blank\">UK</a>,&nbsp;<a href=\"https://payments.amazon.de/preregistration/lpa?LD=SPEXDEAPA_XCart_core\" target=\"_blank\">Germany</a>','en'),(3406,3406,'Operation mode','en'),(3407,3407,'Access Key ID','en'),(3408,3408,'Secret Access Key','en'),(3409,3409,'Client ID','en'),(3410,3410,'Register your website as an application on the <a href=\"http://login.amazon.com/manageApps\" trget=\"_blank\">Login with Amazon App Console</a>. For more information, see the <a href=\"https://images-na.ssl-images-amazon.com/images/G/01/lwa/dev/docs/website-gsg._TTH_.pdf\" target=\"_blank\">Login with Amazon Getting Started Guide</a>. A client identifier (Client ID) is set when you register your website. You will need this identifier for your integration.','en'),(3411,3411,'Country of Merchant account','en'),(3412,3412,'Capture mode','en'),(3413,3413,'Type of authorization request','en'),(3414,3414,'OrderId prefix','en'),(3415,3415,'Amazon Pay','en'),(3416,3416,'Refresh','en'),(3417,3417,'Refund refresh','en'),(3418,3418,'Authorization status: {{status}}','en'),(3419,3419,'Refund status: {{status}}','en'),(3420,3420,'Payment has been captured successfully.','en'),(3421,3421,'Payment capture error: {{error}}','en'),(3422,3422,'Payment have been voided successfully.','en'),(3423,3423,'Payment void error: {{error}}','en'),(3424,3424,'Payment has been refunded successfully.','en'),(3425,3425,'Refund is in progress...','en'),(3426,3426,'Payment refund error: {{error}}','en'),(3427,3427,'Payment has been authorized successfully.','en'),(3428,3428,'Payment has been declined.','en'),(3429,3429,'Payment transaction is in progress...','en'),(3430,3430,'That payment method was not accepted for this transaction. Please choose another.','en'),(3431,3431,'Amazon has rejected the authorisation.','en'),(3432,3432,'Amazon could not process the transaction due to an internal processing error.','en'),(3433,3433,'To ensure that the status of payments in your store is updated automatically after Amazon processes the respective payment requests, you need to set up the endpoints.<br/><br/>Log in to Seller Central and select \'Integration Settings\' from the Settings drop-down box.<br/>Click Edit under the \'Instant Notifications Settings\' section and enter the Callback URL provided here into the \'Merchant URL\' field.','en'),(3434,3434,'Amazon Order Ref ID','en'),(3435,3435,'Callback URL','en'),(3436,3436,'Immediate Charge','en'),(3437,3437,'PayWithAmazon available actions','en'),(3438,3438,'Payment refresh error: {{error}}','en'),(3439,3439,'Refresh status','en'),(3440,3440,'Refund status','en'),(3441,3441,'This operation will cancel order. Payment authorization will be voided. Please confirm to proceed.','en'),(3442,3442,'This operation will capture funds from customer. Please confirm to proceed.','en'),(3443,3443,'This operation will refund funds to customer. Please confirm to proceed.','en'),(3444,3444,'Use existing Amazon account','en'),(3445,3445,'Your payment could not be processed. Please try to place the order again using another payment method.','en'),(3446,3446,'Your payment could not be processed, please follow the instructions in the payment method box.','en'),(3447,3447,'Amazon Pay was not able to process your payment.<br/> Please go to <a href=\"{{amazon_link}}\" target=\"_blank\">this page</a> and update the payment information for your order. Afterwards we will automatically request payment again from Amazon Pay and you will receive a confirmation email.','en'),(3448,3448,'Please update your payment information','en'),(3449,3449,'Unfortunately, we cannot ship to the specified country','en'),(3450,3450,'Make Amazon’s customers your customers with Amazon Pay.','en'),(3451,3451,'Launch','en'),(3452,3452,'The email you tried to use is already registered in our store. Please sign in the classic way!','en'),(3453,3453,'If AustraliaPost returns shipping methods that do not exist in the available methods list, these methods will be created in the list automatically. You can specify whether these methods should be created as enabled and available to customers right away, or should be hidden from customers until you manually enable them on <a href=\"{{URL}}\">the shipping methods list page</a>.','en'),(3454,3454,'Before you can start configuring the Australia Post module, you must receive the available options for the configuration settings from Australia Post. Please click the button below.','en'),(3455,3455,'The option values have been successfully updated.','en'),(3456,3456,'API Login ID','en'),(3457,3457,'Transaction key','en'),(3458,3458,'Signature  key','en'),(3459,3459,'<p>To obtain the transaction key from the Merchant Interface, do the following:</p><ul class=\'custom-disc\'><li>Log into the Merchant Interface</li><li>Select Settings from the Main Menu</li><li>Click on Obtain Transaction Key in the Security section</li><li>Type in the answer to the secret question configured on setup</li><li>Click Submit</li></ul>','en'),(3460,3460,'It\'s recommended to limit the length of invoice prefix to 9 characters. Larger prefixes will be cut prior to transaction initialization.','en'),(3461,3461,'Add this URL as the default Relay Response URL to the <b>Account</b> -> <b>Response/Receipt URLs</b> section in the <a href=\'https://account.authorize.net\'>Merchant Interface</a>.','en'),(3462,3462,'Relay Response URL is used to return the customer to invoice page after successful payment. Authorize.Net may issue the <b>Error 14</b> (The Referrer or Relay Response URL is invalid) in case this URL is not present in the <b>Merchant Interface</b>. <br/> Read more at the <a href=\'https://support.authorize.net/authkb/index?page=content&id=A601\' target=\'_blank\'>Authorize.Net Support Center</a>','en'),(3463,3463,'Don\'t have an account? <a href=\'{{link}}\' target=\'_blank\'>Sign Up Now</a>','en'),(3464,3464,'Required for SHA512 hash protection.','en'),(3465,3465,'Signature key','en'),(3466,3466,'Sales','en'),(3467,3467,'By Sales - 0-9','en'),(3468,3468,'By Sales - 9-0','en'),(3469,3469,'This field is required.','en'),(3470,3470,'Sorry, we can\'t verify you are not a robot','en'),(3471,3471,'The message has been sent','en'),(3472,3472,'Your Message','en'),(3473,3473,'Email Address','en'),(3474,3474,'Full Name','en'),(3475,3475,'We are always glad to help you.','en'),(3476,3476,'Send a message','en'),(3477,3477,'Our location','en'),(3478,3478,'This site is protected by reCAPTCHA and the Google <a href=\"https://policies.google.com/privacy\" target=\"_blank\">Privacy Policy</a> and <a href=\"https://policies.google.com/terms\" target=\"_blank\">Terms of Service</a> apply.','en'),(3479,3475,'Мы всегда рады вам помочь.','ru'),(3480,3476,'Отправить сообщение','ru'),(3481,3479,'Текстовое отображение адреса эл. почты','ru'),(3482,3480,'The length of the {{name}} field must be greater than {{min}}','en'),(3483,3481,'The length of the {{name}} field must be less than {{max}}','en'),(3484,3482,'Have more coupons?','en'),(3485,3483,'Applied discount coupon','en'),(3486,3484,'{{count}} coupon(s) removed','en'),(3487,3485,'{{count}} coupon(s) created','en'),(3488,3486,'The code \"{{code}}\" is already used for another coupon. Please choose a different code.','en'),(3489,3487,'Invalid coupon code, please check the spelling: \"{{code}}\"','en'),(3490,3488,'The coupon has already been used','en'),(3491,3489,'The coupon has been applied to your order','en'),(3492,3490,'Coupon discount','en'),(3493,3491,'Minimum order subtotal must be less than maximum order subtotal','en'),(3494,3492,'Maximum order subtotal must be greater than minimum order subtotal','en'),(3495,3493,'Coupon added','en'),(3496,3494,'Coupon updated','en'),(3497,3495,'Limit number of uses','en'),(3498,3496,'Maximum number of uses','en'),(3499,3497,'This coupon can be applied only to orders with a subtotal amount between {{min}} and {{max}}','en'),(3500,3498,'This coupon can be applied only to orders with a subtotal amount of at least {{min}}','en'),(3501,3499,'This coupon can be applied only to orders with a subtotal amount not exceeding {{max}}','en'),(3502,3500,'Date when customers can start using the coupon','en'),(3503,3501,'Date when the coupon expires','en'),(3504,3502,'Minimum order subtotal to which the coupon can be applied','en'),(3505,3503,'Maximum order subtotal to which the coupon can be applied','en'),(3506,3504,'Coupon discount can be limited to these product classes','en'),(3507,3505,'Coupon discount can be limited to customers with these membership levels','en'),(3508,3506,'This comment is visible to shop administrators only','en'),(3509,3507,'Add new coupon','en'),(3510,3508,'Enter code','en'),(3511,3509,'Coupon','en'),(3512,3510,'Redeem','en'),(3513,3511,'{{currency}} off','en'),(3514,3512,'Removed coupons','en'),(3515,3513,'Added coupons','en'),(3516,3514,'Add coupon','en'),(3517,3515,'This coupon cannot be combined with other coupons','en'),(3518,3516,'Sorry, this coupon cannot be combined with the coupon already applied. Remove the previously applied coupon and try again.','en'),(3519,3517,'Coupon cannot be combined with other coupons','en'),(3520,3518,'If you want the coupon discount to be applied only to products from specific categories, specify these categories here.','en'),(3521,3519,'Sorry, the coupon you entered is invalid. Make sure the coupon code is spelled correctly','en'),(3522,3520,'Sorry, the coupon has expired','en'),(3523,3521,'Sorry, the coupon use limit has been reached','en'),(3524,3522,'Sorry, the coupon you entered cannot be applied to the items in your cart','en'),(3525,3523,'Sorry, the coupon you entered is not valid for your membership level. Contact the administrator','en'),(3526,3524,'The maximum number of uses per user','en'),(3527,3525,'<p>There are currently no coupons. Information on the use of coupons is available <a target=\"_blank\" href=\"https://kb.x-cart.com/en/seo_and_promotion/setting_up_discount_coupons.html\">here</a>.</p>','en'),(3528,3525,'<p>В настоящее время купонов нет. Об использовании купонов можно прочесть <a target=\"_blank\" href=\"https://kb.x-cart.ru/seo_and_promotion/setting_up_discount_coupons.html\">здесь</a>.</p>','ru'),(3529,3526,'The selected date is outside the allowed date range','en'),(3530,3526,'Выбранная дата находится вне допустимого диапазона значений','ru'),(3531,3527,'Sorry, the coupon code you entered cannot be applied if shipping the order to the currently specified delivery address','en'),(3532,3527,'К сожалению, данный купон не может быть применен при доставке заказа на указанный адрес','ru'),(3533,3528,'The discount is valid for the selected delivery area','en'),(3534,3528,'Данная скидка действует для следующей области доставки','ru'),(3535,3529,'Address zones','en'),(3536,3529,'Зоны доставки','ru'),(3537,3530,'Products ({{count}})','en'),(3538,3530,'Товары ({{count}})','ru'),(3539,3531,'{{count}} product(s) added','en'),(3540,3531,'Добавлено товаров: {{count}}','ru'),(3541,3532,'Valid only for specific products','en'),(3542,3532,'Действует только для определенных товаров','ru'),(3543,3533,'The \"{{code}}\" coupon does not exist','en'),(3544,3533,'Купон \"{{code}}\" не найден','ru'),(3545,3534,'Product removed','en'),(3546,3535,'Attachment removed','en'),(3547,3536,'Order has not yet been processed','en'),(3548,3537,'Expired: Downloads limit has been reached','en'),(3549,3538,'Downloads left','en'),(3550,3539,'Download TTL has expired','en'),(3551,3540,'Expires in','en'),(3552,3541,'Blocked by administrator','en'),(3553,3542,'Available for download','en'),(3554,3543,'Can be downloaded only after buying the product','en'),(3555,3544,'Global eGoods settings','en'),(3556,3545,'Download link is blocked','en'),(3557,3545,'Ссылка для скачивания заблокирована','ru'),(3558,3546,'Download links is blocked','en'),(3559,3546,'Ссылки для скачивания заблокирована','ru'),(3560,3547,'Download link has not been found','en'),(3561,3548,'Download link is not active','en'),(3562,3549,'Download link has been renewed','en'),(3563,3549,'Ссылка для скачивания обновлена','ru'),(3564,3550,'Download links has been renewed','en'),(3565,3550,'Ссылки для скачивания обновлены','ru'),(3566,3551,'less than one hour','en'),(3567,3552,'E-goods','en'),(3568,3553,'Ordered files','en'),(3569,3554,'Paid','en'),(3570,3554,'Платный','ru'),(3571,3555,'Free','en'),(3572,3555,'Бесплатный','ru'),(3573,3556,'Your payment module to accept payments for digital items. <a href=\"{{url}}\" target=\"_blank\">Get it now</a>!','en'),(3574,3556,'Продаёшь цифровые товары? Устрой тест-драйв нашему <a href=\"{{url}}\" target=\"_blank\">новому модулю</a> и начни принимать платежи прямо сейчас.','ru'),(3575,3557,'Available after purchase','en'),(3576,3557,'Доступен после покупки','ru'),(3577,3558,'Re-upload file','en'),(3578,3558,'Повторно загрузить','ru'),(3579,3559,'History of downloads','en'),(3580,3559,'История загрузок','ru'),(3581,3560,'The product\'s history of downloads is empty','en'),(3582,3560,'История загрузок для этого товара пуста','ru'),(3583,3561,'The history of downloads feature for this product is disabled. You can enable it <a href=\'{{link}}\'>here</a>','en'),(3584,3561,'Сохранение истории загрузок для данного товара отключено. Вы можете включить его <a href=\"{{link}}\">здесь</a>','ru'),(3585,3562,'File is available by public URL','en'),(3586,3562,'Файл доступен по публичной ссылке','ru'),(3587,3563,'Order fulfillment status changed from {{oldStatus}} to {{newStatus}} due to the file having been downloaded by the user.','en'),(3588,3563,'Статус доставки изменился с {{oldStatus}} на {{newStatus}} в связи с загрузкой файла пользователем','ru'),(3589,3564,'Use X-Sendfile to facilitate the download of large file attachments (100 Mb and larger) by customers:','en'),(3590,3564,'Используйте X-Sendfile для улучшения производительности при скачивании покупателями объемных прикрепляемых файлов (100 и более Мбайт):','ru'),(3591,3565,'Contact your hosting provider to make sure X-Sendfile is installed on the server.','en'),(3592,3565,'Уточните у своего хостинг провайдера, доступен ли для использования X-Sendfile.','ru'),(3593,3566,'Configure your X-Cart installation to support large file downloads.','en'),(3594,3566,'Настройте поддержку скачивания больших файлов для вашей инсталляции X-Cart.','ru'),(3595,3567,'Order #{{value}} doesn’t contain any e-goods. Choose an order that contains e-goods.','en'),(3596,3567,'С заказом {{value}} не связано никаких электронных товаров. Выберите заказ, содержащий электронные товары.','ru'),(3597,3568,'The endpoint field value must contain the full path with the domain name without \"https://\"','en'),(3598,3569,'Block','en'),(3599,3570,'Ip','en'),(3600,3571,'Renew','en'),(3601,3572,'Unblock and renew','en'),(3602,3573,'Related products you may be interested in','en'),(3603,3574,'Although you may find related products below.','en'),(3604,3575,'Add featured products for the front page','en'),(3605,3576,'Featured','en'),(3606,3577,'FedEx module allows you to use online shipping rates calculation via FedEx.','en'),(3607,3578,'\"Cash on delivery\" status','en'),(3608,3579,'Note: To enable/disable the \"Cash on delivery\" payment option, you should enable/disable the payment method \"Cash on delivery (FedEx)\" on the <a href=\"{{URL}}\">Payment methods page</a>.','en'),(3609,3580,'As a FedEx user, you are entitled to receive shipping refunds usually left unclaimed with default FedEx service ($2B/year globally). <a href=\"https://71lbs.com/xcart\" target=\"_blank\">Get My FedEx Refunds</a>','en'),(3610,3577,'Модуль FedEx позволяет рассчитывать онлайн стоимость доставки через FedEx.','ru'),(3611,3578,'Состояние варианта оплаты \"Наложенный платеж\"','ru'),(3612,3579,'Важно: Чтобы включить/отключить вариант оплаты \"Наложенный платеж\", необходимо включить/отключить способ оплаты \"Наложеный платеж (FedEx)\" на <a href=\"{{URL}}\">странице Способов оплаты</a>.','ru'),(3613,3581,'The same file cannot be assigned to a product more than once','en'),(3614,3582,'The attachment has been successfully re-uploaded','en'),(3615,3583,'Failed to re-upload attachment','en'),(3616,3584,'Attachment has been deleted successfully','en'),(3617,3585,'File description','en'),(3618,3585,'Описание файла','ru'),(3619,3586,'Click to edit','en'),(3620,3586,'Нажмите для редактирования','ru'),(3621,3587,'Tweet','en'),(3622,3588,'We recommend using the Share button instead of Like.','en'),(3623,3589,'These Open Graph meta tags were generated automatically based on general product information.','en'),(3624,3590,'Pin It','en'),(3625,3591,'Pin','en'),(3626,3592,'Share','en'),(3627,3593,'Advanced statistics with','en'),(3628,3594,'Google Analytics','en'),(3629,3595,'Configure the Google Analytics module','en'),(3630,3596,'to view the advanced statistics','en'),(3631,3597,'A single domain','en'),(3632,3598,'One domain with multiple subdomains','en'),(3633,3599,'Multiple top-level domains','en'),(3634,3600,'Traditional','en'),(3635,3601,'Universal Analytics','en'),(3636,3602,'Want help with SEO? <a href=\"{{url}}\" target=\"_blank\">Ask X-Cart Guru</a>','en'),(3637,3593,'Расширенная статистика с','ru'),(3638,3594,'Google Analytics','ru'),(3639,3595,'Настроить модуль Google Analytics','ru'),(3640,3596,'для получения расширенной статистики','ru'),(3641,3597,'Одиночный домен','ru'),(3642,3598,'Один домен с несколькими поддоменами','ru'),(3643,3599,'Несколько доменов верхнего уровня','ru'),(3644,3600,'Traditional','ru'),(3645,3601,'Universal Analytics','ru'),(3646,3602,'Нужна помощь с поисковой оптимизацией? <a href=\"{{url}}\" target=\"_blank\">Спросите гуру X-Cart</a>','ru'),(3647,3603,'Quantity in stock','en'),(3648,3604,'Sold','en'),(3649,3605,'{{count}} PIN code duplicates ignored.','en'),(3650,3606,'{{count}} PIN codes created successfully.','en'),(3651,3607,'{{count}} PIN codes longer than {{max}} characters ignored.','en'),(3652,3608,'Could not assign {{count}} PIN codes to order #{{orderId}}. <a href=\"{{link}}\">Create new ones right now</a>','en'),(3653,3608,'Не удалось применить ПИН-коды в количестве {{count}} к заказу #{{orderId}}. <a href=\"{{link}}\">Создайте новые</a>','ru'),(3654,3609,'No valid code found.','en'),(3655,3610,'PIN','en'),(3656,3611,'Cannot be disabled for products with manually defined PIN codes','en'),(3657,3612,'PIN codes enabled','en'),(3658,3613,'Cannot remove a sold PIN code','en'),(3659,3614,'Sold PINs','en'),(3660,3615,'Remaining PINs','en'),(3661,3616,'Order deleted','en'),(3662,3617,'Please type in the new PIN codes one per line. PIN codes max length is 64 characters.','en'),(3663,3618,'Quantity in stock is determined by the amount of the remaining PIN codes defined on the PIN codes management page.','en'),(3664,3619,'You will be able to add pin codes after saving changes.','en'),(3665,3620,'No PIN codes found.','en'),(3666,3621,'Quantity in stock is determined by the amount of the remaining PIN codes','en'),(3667,3622,'{{count}} PIN Codes were not assigned.','en'),(3668,3623,'No pin codes have been bought yet','en'),(3669,3624,'PIN codes data has been successfully updated','en'),(3670,3625,'PIN code','en'),(3671,3626,'PIN codes','en'),(3672,3627,'Add PIN codes','en'),(3673,3628,'Inventory tracking for product {{value}} will not be imported','en'),(3674,3629,'PIN codes generation method','en'),(3675,3629,'Способ создания ПИН-кодов','ru'),(3676,3630,'Automatically','en'),(3677,3630,'Автоматически','ru'),(3678,3631,'Manually','en'),(3679,3631,'Вручную','ru'),(3680,3632,'Товар не найден','ru'),(3681,3633,'Order #{{value}} doesn’t have any pin codes associated with it. Choose an order that contains pin codes.','en'),(3682,3633,'С заказом {{value}} не связано никаких пин-кодов. Выберите заказ, содержащий пин-коды.','ru'),(3683,3634,'Add pin codes','en'),(3684,3635,'Import from CSV file','en'),(3685,3636,'Unknown error occurred','en'),(3686,3637,'The order also contains items with missing PIN codes; you will be prompted to enter the PIN codes under item names.','en'),(3687,3637,'Заказ также содержит товары с отсутствующими ПИН кодами; вам будет предоставлена возможность ввести ПИН коды под названиями соответствующих товаров.','ru'),(3688,3638,'The following PIN codes have already been sold: {{codes}}','en'),(3689,3638,'Следующие ПИН коды уже были проданы ранее: {{codes}}','ru'),(3690,3639,'PayPal ID / Email','en'),(3691,3640,'Enter the email address associated with your PayPal account.','en'),(3692,3641,'Enter a description of the purchase that will be displayed on the PayPal payment page.','en'),(3693,3642,'You can set an order id prefix that will be added to each order number in your shop to make it unique (each transaction id must be unique for a PayPal account). This option is relevant only if you share your PayPal account with other online shops','en'),(3694,3643,'Your account settings','en'),(3695,3644,'Partner name','en'),(3696,3645,'Your partner name is PayPal','en'),(3697,3646,'Merchant login','en'),(3698,3647,'This is the login name you created when you signed up for PayPal Payments Advanced / Payflow Link.','en'),(3699,3648,'PayPal recommends entering a User Login here instead of your Merchant Login. You can set up a User profile in <a href=\"https://manager.paypal.com\">PayPal Manager</a>. This will enhance security and prevent service interruption should you change your Merchant Login password.','en'),(3700,3649,'This is the password you created when you signed up for PayPal Payments Advanced or the password you created for API calls.','en'),(3701,3650,'Additional settings','en'),(3702,3651,'Auth and Capture','en'),(3703,3652,'Auth only','en'),(3704,3653,'This should be the partner name you use when logging into your PayPal Payflow account.','en'),(3705,3654,'This is the login name you created when you signed up for Payflow.','en'),(3706,3655,'This is the password you created when you signed up for PayPal Payflow or the password you created for API calls.','en'),(3707,3656,'IPN verification failed','en'),(3708,3657,'IPN HTTP error','en'),(3709,3658,'Order id prefix','en'),(3710,3659,'Email address to receive PayPal payment','en'),(3711,3660,'Start accepting Express Checkout payments immediately by simply plugging in the email address where you would like to receive payments. You can create your PayPal account later after you have received a real transaction from your customers!','en'),(3712,3661,'API credentials for payments and post-checkout operations','en'),(3713,3662,'Can be set up later','en'),(3714,3663,'PayPal Publisher ID','en'),(3715,3664,'PayPal API','en'),(3716,3665,'Payflow API','en'),(3717,3666,'API access username','en'),(3718,3667,'API access password','en'),(3719,3668,'Use PayPal authentication method','en'),(3720,3669,'API signature','en'),(3721,3670,'API certificate filename','en'),(3722,3671,'API certificate','en'),(3723,3672,'Display the \"Buy Now with PayPal\" button','en'),(3724,3673,'Display \"Now Accepting PayPal\" badge','en'),(3725,3674,'This setting determines whether or not the \"Buy Now with PayPal\" button should be displayed on product list pages (in list view) and product details pages.','en'),(3726,3675,'<b>PayPal Express Checkout</b> is configured to work in SandBox mode for the email <b>{{email}}</b>.<br />To use it in Live mode, click the Launch PayPal button below. You will be taken to the PayPal payment method configuration page where you will be able to specify the appropriate configuration settings.','en'),(3727,3676,'Launch PayPal','en'),(3728,3677,'PayPal Credit is','en'),(3729,3678,'I agree with PayPal terms & conditions','en'),(3730,3679,'PayPal account e-mail','en'),(3731,3680,'Banner on Home page','en'),(3732,3681,'Banner on Category pages','en'),(3733,3682,'Banner on Product details pages','en'),(3734,3683,'Banner on Cart page','en'),(3735,3684,'Show above products','en'),(3736,3685,'Show below products','en'),(3737,3686,'Near \"Add to cart\" button','en'),(3738,3687,'Near \"Checkout\" button','en'),(3739,3688,'PayPal API (Merchant API) will work for most merchants; however, some merchants may have access only to Payflow API. If you are sure you need to use Payflow API, select the respective value from this field.<br />Your choice of API solution in this field determines the type of API credentials that you will be able to enter in the fields below.','en'),(3740,3689,'Payment has been refunded successfully','en'),(3741,3690,'Payment has been voided successfully','en'),(3742,3691,'Payment has been captured successfully','en'),(3743,3692,'Your API credentials have been successfully obtained from your PayPal account and saved for use by your X-Cart store.','en'),(3744,3693,'Unfortunately, your API credentials could not be obtained from your PayPal account automatically. Please request your API credentials in your PayPal account and submit them here manually.','en'),(3745,3694,'Don\'t have an account yet?','en'),(3746,3695,'Sign Up Now','en'),(3747,3696,'Register with {{paypal}} <br /> or go to checkout as a New customer','en'),(3748,3697,'Or sign in the classic way','en'),(3749,3698,'Or register with','en'),(3750,3699,'Register with','en'),(3751,3700,'or go to checkout as a New customer','en'),(3752,3701,'Or use your social account','en'),(3753,3702,'Use existing account from','en'),(3754,3703,'PayPal','en'),(3755,3704,'Use existing PayPal account','en'),(3756,3705,'The authorized amount ({{authorized}}) differs from the current order total ({{total}}). A request to capture {{total}} will be issued on click on \"Capture\" button.','en'),(3757,3706,'Wrong token of Express Checkout. Please try again. If the problem persists, contact the administrator.','en'),(3758,3707,'PayerID value was not returned by PayPal. Please try again. If the problem persists, contact the administrator.','en'),(3759,3708,'Your address data was not received from PayPal. Please try again. If the problem persists, contact the administrator.','en'),(3760,3709,'To enable this payment method, you need Multi-vendor module installed.','en'),(3761,3710,'To enable this payment method, you need <a href=\"{{link}}\" target=\"_blank\">Multi-Vendor</a> module installed.','en'),(3762,3711,'EACHRECEIVER','en'),(3763,3712,'Obtaining your live PayPal credentials','en'),(3764,3713,'PRIMARYRECEIVER','en'),(3765,3714,'PayPal Credit','en'),(3766,3715,'Registering your application with PayPal','en'),(3767,3716,'SECONDARYONLY','en'),(3768,3717,'SENDER','en'),(3769,3718,'Additional criteria to match for PayPal account verification','en'),(3770,3719,'<div>Determines the type of criteria that should be matched for account verification (in addition to vendor PayPal account identifier).<div><ul class=\"unstyled\"><li>NAME - Default; should be good in most cases.</li><li>NONE - Is available only to certain financial institutions (Contact Paypal for approval prior to selection!)</li><li>Disable - Deactivates account verification.</li></ul>','en'),(3771,3720,'NAME','en'),(3772,3721,'NONE','en'),(3773,3722,'Disable','en'),(3774,3723,'Refund status:','en'),(3775,3724,'In progress','en'),(3776,3725,'Payment processing with PayPal Standard involves using PayPal\'s IPN service. If your merchant account is set to use <a href=\"{{link}}\" target=\"_blank\">Payment Data Transfer (PDT)</a>, be sure to disable it in your account settings and enable IPN instead.','en'),(3777,3726,'Use of the unsupported Payment Data Transfer (PDT) method has been detected','en'),(3778,3726,'Обнаружено использование неподдерживаемого метода Payment Data Transfer (PDT)','ru'),(3779,3727,'Communication problem','en'),(3780,3728,'PayPal Merchant ID','en'),(3781,3729,'Connected to PayPal; Merchant ID: {{merchantId}}','en'),(3782,3730,'Reconnect to PayPal','en'),(3783,3731,'Connect to PayPal','en'),(3784,3732,'PayPal For Marketplaces account email','en'),(3785,3733,'PayPal API Client ID','en'),(3786,3734,'PayPal API Secret','en'),(3787,3735,'PayPal Partner ID','en'),(3788,3736,'PayPal BN Code','en'),(3789,3737,'Additional PayPal Business Account','en'),(3790,3737,'Дополнительный бизнес-аккаунт PayPal','ru'),(3791,3738,'Click this to access the PayPal sign-in page and sign in using your PayPal account different from the account specified above. This account will be used to receive the shipping cost (if you are going to ship out goods on behalf of vendors), the earnings on your own products (if you are going to be one of the sellers), and the earnings on the sales of the vendors who have not set up a PayPal account of their own for some reason.','en'),(3792,3738,'Используйте для перехода на сайт PayPal и войдите на сайт, используя аккаунт PayPal, отличный от аккаунта, указанного выше. Данный аккаунт будет использоваться для получения стоимости доставки (если вы собираетесь заниматься отправкой товаров от лица продавцов), поступлений от продажи ваших собственных товаров (если вы будете выступать в качестве одного из продавцов), а также для получения средств от продажи товаров тех продавцов, которые по какой-либо причине не настроили собственный аккаунт PayPal.','ru'),(3793,3739,'Customize the PayPal button','en'),(3794,3739,'Отображение кнопки PayPal','ru'),(3795,3740,'Color','en'),(3796,3740,'Цвет','ru'),(3797,3741,'Shape','en'),(3798,3741,'Форма','ru'),(3799,3742,'Show payment card icons','en'),(3800,3742,'Значки платежных карт','ru'),(3801,3743,'Product page','en'),(3802,3743,'Страница продукта','ru'),(3803,3744,'Product list','en'),(3804,3744,'Список продуктов','ru'),(3805,3745,'Cart','en'),(3806,3745,'Корзина','ru'),(3807,3746,'Minicart','en'),(3808,3746,'Меню корзины','ru'),(3809,3747,'Checkout','en'),(3810,3747,'Оформиление заказа','ru'),(3811,3748,'Checkout (PayPal Credit)','en'),(3812,3748,'Оформиление заказа (PayPal Credit)','ru'),(3813,3749,'Add2Cart popup','en'),(3814,3749,'Всплывающее окно корзины','ru'),(3815,3750,'Payments with this payment method are not allowed because <a href=\"{{url}}\">HTTPS is not configured or there is a problem with the security certificate</a>.','en'),(3816,3751,'Webhook listener error: could not subscribe to event(s). Check the settings and make sure your site is accessible via the Web.','en'),(3817,3752,'Delayed','en'),(3818,3753,'Immediate','en'),(3819,3754,'We are experiencing a problem with the \"{{payment_method_name}}\" payment method. Please choose a different method, or contact the store administrator to resolve the problem.','en'),(3820,3755,'Funding methods (checkout page)','en'),(3821,3756,'When multiple funding sources are available to the buyer, PayPal automatically determines which additional buttons are appropriate to display. However, you can choose to opt-in or out-of displaying specific funding sources.','en'),(3822,3757,'Credit or debit card (Visa, MasterCard, American Express, Discover, and so on)','en'),(3823,3758,'ELV/SEPA','en'),(3824,3759,'Venmo','en'),(3825,3760,'Express Checkout process stopped.','en'),(3826,3761,'Fees payer','en'),(3827,3762,'PayPal Express Checkout (legacy)','en'),(3828,3763,'Payment has bes refunded successfully','en'),(3829,3764,'Paypal login (email)','en'),(3830,3765,'Payment have been voided successfully','en'),(3831,3766,'Try to reconnect','en'),(3832,3767,'Setup quickly and offer the convenience and trusted security of PayPal.','en'),(3833,3768,'The email you tried to use is already registered in our store. Please try logging in using your {{provider}} account.','en'),(3834,3769,'Your PayPal account is not fully configured, please check that:','en'),(3835,3770,'you have permission to receive payments','en'),(3836,3771,'email is confirmed','en'),(3837,3772,'permission granted for X-Cart app','en'),(3838,3773,'Merchant Id','en'),(3839,3774,'Client Id','en'),(3840,3775,'Client Secret','en'),(3841,3776,'3D Secure','en'),(3842,3777,'Authentication bypassed / unavailable liability shift','en'),(3843,3778,'Want to use another account?','en'),(3844,3779,'Your payment could not be processed at this time. Please make sure the card information was entered correctly and resubmit. If the problem persists, please contact your credit card company to authorize the purchase.','en'),(3845,3780,'Unexpected error','en'),(3846,3781,'Please, use another card or payment method.','en'),(3847,3782,'Now Accepting','en'),(3848,3783,'<b>PayPal Checkout</b> is currently in SANDBOX MODE.<br/>To complete your payment method setup, please click “Launch PayPal” below.','en'),(3849,3784,'<b>PayPal Checkout</b> is currently in SANDBOX MODE.<br/>To complete your payment method setup, please click “PayPal Settings” below','en'),(3850,3785,'PayPal Settings','en'),(3851,3786,'PayPal checkout and PayPal express checkout (legacy) / PayPal Payments Advanced are not able to work together.','en'),(3852,3787,'Have a PayPal account?','en'),(3853,3788,'Connect with PayPal','en'),(3854,3789,'Connecting to PayPal with X-Cart installed on the local server is supported in manual mode only. Please fill in the fields below with the required data, or move your installation to an externally accessible URL to connect your live PayPal account automatically.','en'),(3855,3790,'PayPal Credit Messaging','en'),(3856,3791,'Banner on product pages','en'),(3857,3792,'Banner on the cart page','en'),(3858,3793,'Banner at checkout','en'),(3859,3794,'Banner type','en'),(3860,3795,'Choose text if you need a lightweight contextual message. Choose flex if you need a responsive banner','en'),(3861,3796,'Stacked','en'),(3862,3797,'Single line logo','en'),(3863,3798,'Inline logo','en'),(3864,3799,'No logo','en'),(3865,3800,'Logo type','en'),(3866,3801,'Logo position','en'),(3867,3802,'Applicable to stacked and single line logos only','en'),(3868,3803,'Text','en'),(3869,3804,'Flex','en'),(3870,3805,'Left','en'),(3871,3806,'Right','en'),(3872,3807,'Top','en'),(3873,3808,'Small','en'),(3874,3809,'Medium','en'),(3875,3810,'Large','en'),(3876,3811,'Black','en'),(3877,3812,'White','en'),(3878,3813,'Monochrome','en'),(3879,3814,'Grayscale','en'),(3880,3815,'Text size','en'),(3881,3816,'Text color','en'),(3882,3817,'Blue','en'),(3883,3818,'White (no border)','en'),(3884,3819,'Gray','en'),(3885,3820,'Regular','en'),(3886,3821,'Slim','en'),(3887,3822,'Color scheme','en'),(3888,3823,'Layout','en'),(3889,3824,'All newest products','en'),(3890,3825,'All upcoming products','en'),(3891,3826,'Coming soon','en'),(3892,3827,'Customers who bought this product also bought','en'),(3893,3828,'Customers who viewed this product bought','en'),(3894,3829,'Date: newest first','en'),(3895,3830,'Date: oldest first','en'),(3896,3831,'New arrivals','en'),(3897,3832,'New!','en'),(3898,3833,'Recently viewed','en'),(3899,3834,'This product will be shown in New arrivals','en'),(3900,3835,'This product will be shown in the Coming soon section','en'),(3901,3836,'Expected on','en'),(3902,3837,'Coming soon...','en'),(3903,3838,'Customers who bought this product also bought (Product Advisor module)','en'),(3904,3839,'Don\'t label','en'),(3905,3840,'In catalog only','en'),(3906,3841,'On catalog and product pages','en'),(3907,3842,'Text links','en'),(3908,3843,'Expected on <span>{{date}}</span>','en'),(3909,3842,'Текстовые ссылки','ru'),(3910,3836,'Ожидается','ru'),(3911,3843,'Ожидается <span>{{date}}</span>','ru'),(3912,3844,'MD5 hash value','en'),(3913,3845,'Use of Restriction key must be disabled in your Quantum Gateway merchant center account at all times. Please log in to your account, go to the Processing Settings section and make sure the setting \"Use restriction key\" is disabled.','en'),(3914,3846,'Include response in hash','en'),(3915,3847,'This value must be set in exactly the same way as it is set on the payment gateway end.','en'),(3916,3848,'Put up for sale','en'),(3917,3849,'Cancel sale','en'),(3918,3850,'On sale','en'),(3919,3851,'Put all for sale','en'),(3920,3852,'Cancel sale for all','en'),(3921,3853,'There are currently no sale discounts','en'),(3922,3854,'Sale name','en'),(3923,3855,'{{count}} discount(s) has been created','en'),(3924,3856,'{{count}} discount(s) has been removed','en'),(3925,3857,'New sale','en'),(3926,3858,'List sale products in a separate section','en'),(3927,3859,'Apply sale discount to wholesale prices','en'),(3928,3860,'Sale discounts','en'),(3929,3861,'If you want the sale discount to be applied only to products from specific categories, specify these categories here.','en'),(3930,3862,'The sale discount will be limited to product classes specified here','en'),(3931,3863,'The sale discount will be limited to customers with membership levels specified here','en'),(3932,3864,'The sale discount will be limited to the delivery area specified here','en'),(3933,3865,'The sale discount has been updated','en'),(3934,3866,'The sale discount has been added','en'),(3935,3867,'Apply maximum discount','en'),(3936,3868,'Apply minimum discount','en'),(3937,3869,'Combine discounts','en'),(3938,3870,'Do not display','en'),(3939,3871,'Display under categories list','en'),(3940,3872,'Display above categories list','en'),(3941,3873,'The following sale discounts apply to this product: {{sales}}','en'),(3942,3874,'<p>Sorry, no products have been added to this discount offer.</p><p><a href=\"{{homePageUrl}}\">Go back to the Home page</a></p>','en'),(3943,3875,'<p>Sorry, no products of {{vendor}} have been added to this discount offer.</p><p><a href=\"{{homePageUrl}}\">Go back to the Home page</a></p>','en'),(3944,3876,'Re-calculate quick data','en'),(3945,3877,'To ensure that products sorting and the addon Product Filter works correctly, after changing or adding sale offers, launch <a href=\"{{link}}\" target=\"_blank\">the re-calculation of quick data</a>.','en'),(3946,3878,'The \"{{saleDiscount}}\" discount does not exist','en'),(3947,3879,'Wholesale prices for this product are disabled because its sale price is set as an absolute value ({{price}}). To enable wholesale prices, use the relative value in % for the Sale field.','en'),(3948,3880,'Wholesale prices for this product variant are disabled because its sale price is set as an absolute value ({{price}}). To enable wholesale prices, use the relative value in % for the Sale field.','en'),(3949,3851,'Выставить все на распродажу','ru'),(3950,3852,'Отменить распродажу для всех','ru'),(3951,3881,'Address for sales tax calculation','en'),(3952,3882,'Click here to specify tax rates that will apply only to shipping charges','en'),(3953,3883,'Discounted subtotal','en'),(3954,3884,'Discounted subtotal + Shipping cost','en'),(3955,3885,'General tax rates','en'),(3956,3886,'Individual settings for every rate','en'),(3957,3887,'New rate','en'),(3958,3888,'Subtotal + Shipping cost','en'),(3959,3889,'Taxable base','en'),(3960,3890,'Tax rates for shipping charges have not yet been created.','en'),(3961,3891,'Tax rates have not yet been created.','en'),(3962,3892,'Tax rates on shipping cost','en'),(3963,3893,'Use the same tax rates for all user membership levels','en'),(3964,3881,'Адрес для расчета налога с продаж','ru'),(3965,3882,'Нажмите здесь, чтобы задать ставки налогов на стоимость доставки','ru'),(3966,3883,'Сумма заказа с учетом скидки','ru'),(3967,3884,'Сумма заказа с учетом скидки + стоимость доставки','ru'),(3968,3885,'Основные ставки налогов','ru'),(3969,3886,'Индивидуальные настройки для каждой ставки налога','ru'),(3970,3887,'Новая ставка','ru'),(3971,3888,'Сумма заказа + стоимость доставки','ru'),(3972,1227,'Сумма налога успешно удалена','ru'),(3973,1228,'Сумма налога не удалена','ru'),(3974,3889,'Налогооблагаемая база','ru'),(3975,3890,'Ставки налога на стоимость доставки пока не созданы.','ru'),(3976,3891,'Ставки налога пока не созданы.','ru'),(3977,3892,'Ставки налогов на стоимость доставки','ru'),(3978,3893,'Использовать одни и те же ставки налога для всех групп покупателей','ru'),(3979,1126,'Налог с продаж','ru'),(3980,3894,'Contact us','en'),(3981,3895,'Logo','en'),(3982,3896,'Favicon','en'),(3983,3896,'Фавикон','ru'),(3984,3897,'Shipping','en'),(3985,3898,'If you want to add an external link, you should specify it with the <strong>http://</strong> prefix, e.g. <strong>http://www.example.com/</strong>.<br /><br />If you want to add a link to a page within your store (e.g. the checkout page), you can specify it as <strong>cart.php?target=checkout</strong> (relative path) or as <strong>{{URL}}cart.php?target=checkout</strong> (absolute path).<br /><br />Also the \'{home}\' shortcut value will lead to Home page','en'),(3986,3899,'Failed to update the page image','en'),(3987,3900,'Visible for','en'),(3988,3901,'The menu has been updated','en'),(3989,3902,'The menu has been added','en'),(3990,3903,'The page has been updated','en'),(3991,3904,'Any visitors','en'),(3992,3905,'Anonymous users only','en'),(3993,3906,'Logged in users only','en'),(3994,3907,'Save & Close','en'),(3995,3908,'Logo & Favicon','en'),(3996,3909,'Terms and conditions','en'),(3997,3910,'Open graph image','en'),(3998,3911,'The \"{{file}}\" file is not allowed image and was not uploaded. Allowed images are: {{extensions}}','en'),(3999,3912,'Submenu','en'),(4000,3912,'Подменю','ru'),(4001,3913,'Content page title','en'),(4002,3913,'Заголовок страницы','ru'),(4003,3914,'Leave blank to use page name as Page Title.','en'),(4004,3914,'Оставьте поле незаполненным чтобы использовать имя страницы в качестве заголовка.','ru'),(4005,3915,'The AppleIcon image could not be uploaded (Unallowed image type. Must be a .png image with the resolution of 192x192 px)','en'),(4006,3916,' <p>The store doesn\'t have any static pages yet. Static pages can be created to tell customers about your products or policies, guide them through the order process etc. Once the page is created, it will become accessible via certain URL. Start writing by clicking the <b>\"New page\"</b> button.</p>','en'),(4007,3916,' <p>Список страниц пуст. С помощью страниц вы сможете рассказать клиентам о ваших товарах и условиях заказа, предоставить им помощь и полезную информацию. Такие страницы будут доступны по определенным адресам после того, как будут опубликованы.</p>','ru'),(4008,3917,'<p>There are no menus in the store. Header and footer menus provide customers with useful navigation. They can contain any link or label, and can be nested. Generally, the primary menu is shown on the top of the page, and the footer menu is on the bottom of the page.</p>','en'),(4009,3917,'<p>Меню не заполнены. Меню - удобный инструмент навигации для ваших клиентов. Элементы меню могут содержать любой текст или ссылку, а также могут иметь подменю. Обычно, есть главное меню (оно расположено в вернхней части страницы) и нижнее меню (отображаемое в подвале страницы).</p>','ru'),(4010,3918,'Show default menu along with the custom one','en'),(4011,3919,'Current logo sizes: {{X}}х{{Y}} px','en'),(4012,3920,'2Checkout.com account number','en'),(4013,3921,'Order prefix','en'),(4014,3922,'Pricing currency','en'),(4015,3923,'To set up the integration, go to the ','en'),(4016,3924,'\"Site management\"','en'),(4017,3925,' page on the 2Checkout site and make sure of the following:','en'),(4018,3926,'The \"Pricing currency\" value here in X-Cart must be exactly the same as on 2Checkout\'s Site management page.','en'),(4019,3927,'The \"Approved URL\" value on 2Checkout\'s Site management page must be set to this','en'),(4020,3928,'<strong>U.S.P.S.</strong> module allows you to use online shipping rates calculation via <a href=\"http://www.usps.com/webtools\" target=\"_blank\">USPS Web Tools Ecommerce API</a>.','en'),(4021,3929,'Note: To enable/disable the \"Cash on delivery\" payment option, you should enable/disable the payment method \"Cash on delivery (U.S.P.S.)\" on the <a href=\"{{URL}}\">Payment methods page</a>.','en'),(4022,3930,'Refresh list of available methods','en'),(4023,3931,'Wrong container type selected: {{value}}. For large package size only the following types are allowed: RECTANGULAR, NONRECTANGULAR, VARIABLE','en'),(4024,3932,'{{value}} is an invalid container type for a REGULAR package. Valid Container is: VARIABLE','en'),(4025,3933,'USPS Shipments','en'),(4026,3934,'Tracking information was updated successfully','en'),(4027,3935,'The shipment has been voided successfully','en'),(4028,3936,'The shipment has been created successfully','en'),(4029,3937,'Shipment Id','en'),(4030,3938,'Delivery cost','en'),(4031,3939,'Shipping label','en'),(4032,3940,'Parcel type','en'),(4033,3941,'Parcel weight','en'),(4034,3942,'Parcel dimensions','en'),(4035,3943,'Irregular parcel girth','en'),(4036,3944,'Special services','en'),(4037,3945,'COD value','en'),(4038,3946,'Insurance value','en'),(4039,3947,'Label format','en'),(4040,3948,'Label size','en'),(4041,3949,'Hide total carrier charge','en'),(4042,3950,'Hide the carrier shipping charge on the label','en'),(4043,3951,'Non delivery option','en'),(4044,3952,'Use this field for instructions in case the package is not delivered.','en'),(4045,3953,'Print custom message 1','en'),(4046,3954,'This is a user specified message that gets printed on the face of the label. A string of up to 50 characters can be printed on the label.','en'),(4047,3955,'Print custom message 2','en'),(4048,3956,'This is a user specified message that gets printed on the bottom of the label. A string of up to 50 characters can be printed on the label.','en'),(4049,3957,'Shipping label sender signature','en'),(4050,3958,'Adds the sender’s signature and the date on CN22 and CP72 shipping labels. Enter the signature as a string. The Sender’s signature date is automatically populated.','en'),(4051,3959,'Create shipment','en'),(4052,3960,'Please note: the USPS Web tools APIs print labels without postage.','en'),(4053,3961,'<strong>Savings</strong> - Up to 49% off retail USPS postage rates','en'),(4054,3962,'<strong>Convenience</strong> - Verify addresses and buy & print compliant USPS labels directly from the X-Cart application','en'),(4055,3963,'<strong>Easy payment options</strong> - Ship Now Pay Later with a Pitney Bowes Line of Credit or use a credit card.','en'),(4056,3964,'Get started Now! Click here to create your <a href=\"{{url}}\" class=\"external\" target=\"_blank\">PITNEY BOWES Postage Account</a>','en'),(4057,3965,'Delivery date','en'),(4058,3966,'Estimate delivery date','en'),(4059,3967,'Girth','en'),(4060,3968,'PitneyBowes','en'),(4061,3969,'Ship date','en'),(4062,3970,'Unable to get merchant info','en'),(4063,3971,'Update date','en'),(4064,3972,'Update tracking info','en'),(4065,3973,'All dimensions must be greater than 0','en'),(4066,3974,'The role has been updated','en'),(4067,3975,'The role has been added','en'),(4068,3976,'(disabled)','en'),(4069,3976,'(выкл)','ru'),(4070,3977,'Get {{X}} off for order amount over {{Y}}','en'),(4071,3978,'Could not add the discount because another discount already exists for the specified subtotal range, membership level, date range and shipping zones','en'),(4072,3979,'Could not update the discount because another discount already exists for the specified subtotal range, membership level, date range and shipping zones','en'),(4073,3980,'Percent discount value cannot exceed 100%','en'),(4074,3981,'Too large value for absolute discount','en'),(4075,3982,'<p>No discounts have been set yet. Set up automatic discounts for your customers based on subtotal or membership level. Add the discount using <b>\"Add discount\"</b> button.</p>','en'),(4076,3982,'<p>Нет настроенных скидок. Вы можете настроить автоматическое применение оптовых скидок в зависимости от суммы заказа и группы пользователя с помощью кнопки <b>\"Создать скидку\"</b>.</p>','ru'),(4077,3983,'Minimum order subtotal to which the volume discount can be applied','en'),(4078,3984,'Volume discount can be limited to customers with this membership level','en'),(4079,3985,'Volume discount can be limited to customers with these address zones','en'),(4080,3986,'Date when customers can start using the volume discount','en'),(4081,3987,'Date when the volume discount expires','en'),(4082,3988,'The volume discount has been added','en'),(4083,3989,'The volume discount has been updated','en'),(4084,3990,'Site map failed to register in {{engine}}.','en'),(4085,3991,'Site map successfully registered in {{engine}}.','en'),(4086,3992,'XML sitemap URL: <a href=\"{{url}}\">{{url}}</a>','en'),(4087,3993,'Generate sitemap','en'),(4088,3994,'Generate XML Sitemap','en'),(4089,3995,'Sitemap generation...','en'),(4090,3996,'Sitemap generation has been completed successfully.','en'),(4091,3997,'Sitemap generation has been stopped.','en'),(4092,3998,'The process of sitemap generation may take a while to complete. Please do not close this page until the process is fully completed.','en'),(4093,3999,'Sitemap settings','en'),(4094,4000,'X-Cart Google Ads by Kliken','en'),(4095,4000,'X-Cart-Google-Werbung von Kliken','de'),(4096,4000,'X-Cart Google Ads por Kliken','es'),(4097,4000,'Annonces Google X-Cart par Kliken','fr'),(4098,4000,'X-Cart Google Ads door Kliken','nl'),(4099,4001,'Module Kliken\\GoogleAds was unable to access your store\'s catalog . Please make sure the correct Account Id and Application Token are saved, or contact Kliken for support.','en'),(4100,4001,'Das Modul Kliken\\GoogleAds konnte nicht auf den Katalog Ihres Shops zugreifen. Bitte stellen Sie sicher, dass die korrekte Konto-ID und der richtige Anwendungstoken gespeichert sind oder wenden Sie sich für Unterstützung an Kliken.','de'),(4101,4001,'El módulo Kliken\\GoogleAds no ha podido acceder al catálogo de su tienda. Asegúrese de que se han guardado el identificador de la cuenta y el token de aplicación correctos, o póngase en contacto con Kliken para obtener ayuda.','es'),(4102,4001,'Module Kliken\\GoogleAds n\'a pas pu accéder au catalogue de votre boutique. Veuillez vous assurer que l\'identifiant de compte et le jeton d\'application appropriés sont enregistrés, ou contactez Kliken pour obtenir de l\'aide.','fr'),(4103,4001,'Module Kliken\\GoogleAds kon geen toegang krijgen tot de catalogus van uw winkel. Zorg ervoor dat de juiste Account-ID en Applicatie-token zijn opgeslagen of neem voor ondersteuning contact op met Kliken.','nl'),(4104,4002,'Google Ads','en'),(4105,4002,'Google-Werbung','de'),(4106,4002,'Google Ads','es'),(4107,4002,'Publicités Google','fr'),(4108,4002,'Google Ads','nl'),(4109,4003,'Get your products found on Google in a few steps. Click the \"%s\" button to get started!','en'),(4110,4003,'Sorgen Sie mit wenigen Schritten dafür, dass Ihre Produkte bei Google gefunden werden. Klicken Sie den \"%s\"-Button an, um zu beginnen!','de'),(4111,4003,'Consiga que encuentren sus productos en Google en unos pocos pasos. ¡Haga clic en el botón \"%s\" para empezar!','es'),(4112,4003,'Rendez vos produits visibles sur Google en quelques étapes. Cliquez sur le bouton « %s » pour commencer !','fr'),(4113,4003,'Zorg er in een paar stappen voor dat uw producten vindbaar zijn in Google. Klik op de \"%s\"-toets om aan de slag te gaan!','nl'),(4114,4004,'Increase sales and revenue with Google Shopping Ads.','en'),(4115,4004,'Steigern Sie Ihren Umsatz und Ihre Einnahmen mit Google Shopping Anzeigen.','de'),(4116,4004,'Aumenta tus ventas e ingresos con Google Shopping Ads.','es'),(4117,4004,'Augmentez vos ventes et votre chiffre d\'affaire grâce à Google Shopping Ads.','fr'),(4118,4004,'Vergroot de verkoop en omzet met Google Shopping Ads.','nl'),(4119,4005,'Use this X-Cart and Google Ads integration to:','en'),(4120,4005,'Verwenden Sie diese X-Cart- und Google Ads-Integration und:','de'),(4121,4005,'Utiliza esta integración de X-Cart y Google para:','es'),(4122,4005,'Utilisez cette intégration de X-Cart et Google Ads pour :','fr'),(4123,4005,'Gebruik deze X-Cart- en Google Ads-integratie om:','nl'),(4124,4006,'Find more customers on Google','en'),(4125,4006,'Finden Sie mehr Kunden auf Google','de'),(4126,4006,'Encontrar más clientes en Google','es'),(4127,4006,'Trouver plus de clients sur Google','fr'),(4128,4006,'Meer klanten via Google te vinden','nl'),(4129,4007,'Automate bidding to maximize sales for your marketing budget','en'),(4130,4007,'Automatisieren Sie die Gebotsabgabe, um den Umsatz mit Ihrem Marketingbudget zu maximieren','de'),(4131,4007,'Automatizar pujas y maximizar las ventas con tu presupuesto para marketing.','es'),(4132,4007,'Automatiser les enchères afin de maximiser les ventes pour votre budget marketing','fr'),(4133,4007,'Het bieden te automatiseren om de verkoop, afgestemd op uw marketingbudget, te maximaliseren ','nl'),(4134,4008,'Keep your marketing and store in sync','en'),(4135,4008,'Stimmen Sie Ihr Marketing und Ihren Shop immer aufeinander ab','de'),(4136,4008,'Mantener tu estrategia de marketing y tu tienda sincronizadas.','es'),(4137,4008,'Synchroniser votre marketing et votre boutique','fr'),(4138,4008,'Uw marketing en winkel synchroon te houden','nl'),(4139,4009,'Create perfect shopping campaigns in minutes','en'),(4140,4009,'Erstellen Sie perfekte Shoppingkampagnen in wenigen Minuten','de'),(4141,4009,'Crear campañas de Shopping perfectas en minutos.','es'),(4142,4009,'Créer des campagnes de shopping parfaites en quelques minutes','fr'),(4143,4009,'Binnen enkele minuten perfecte winkelcampagnes op te zetten','nl'),(4144,4010,'Get Started','en'),(4145,4010,'Anfangen','de'),(4146,4010,'Empezar','es'),(4147,4010,'Commencer','fr'),(4148,4010,'Beginnen','nl'),(4149,4011,'Launch Google Shopping ads and get your products found online easily.','en'),(4150,4011,'Veröffentlichen Sie Google-Shopping-Anzeigen, damit Ihre Produkte online leicht zu finden sind.','de'),(4151,4011,'Lance los anuncios de Google Shopping Ads para conseguir que sus productos se puedan encontrar en línea fácilmente.','es'),(4152,4011,'Lancez les Campagnes Shopping Google pour qu\'on trouve facilement vos produits en ligne.','fr'),(4153,4011,'Start Google Shopping Ads en vind uw producten eenvoudig online.','nl'),(4154,4012,'Your store is connected.','en'),(4155,4012,'Ihr Shop ist verbunden.','de'),(4156,4012,'Tu tienda está conectada.','es'),(4157,4012,'Votre boutique est connectée.','fr'),(4158,4012,'Uw winkel is gekoppeld.','nl'),(4159,4013,'Your X-Cart store is connected to your Kliken account.','en'),(4160,4013,'Ihr X-Cart-Shop ist mit Ihrem Kliken-Konto verbunden.','de'),(4161,4013,'Tu tienda X-Cart está conectada a tu cuenta de Kliken.','es'),(4162,4013,'Votre boutique X-Cart est connectée à votre compte Kliken.','fr'),(4163,4013,'Uw X-Cart-winkel is gekoppeld aan uw Kliken-account.','nl'),(4164,4014,'Campaign Dashboard','en'),(4165,4014,'Kampagnen-Dashboard','de'),(4166,4014,'Panel de control de la campaña','es'),(4167,4014,'Tableau de bord des campagnes','fr'),(4168,4014,'Campagne Dashboard','nl'),(4169,4015,'Open your dashboard to review your campaign\'s performance','en'),(4170,4015,'Öffnen Sie Ihr Dashboard, um festzustellen, wie Ihre Kampagne abschneidet','de'),(4171,4015,'Abra su cuadro de mando para revisar el comportamiento de su campaña','es'),(4172,4015,'Ouvrez votre tableau de bord pour vérifier les performances de votre campagne','fr'),(4173,4015,'Open uw dashboard om de prestatie van uw actie te bekijken','nl'),(4174,4016,'Create a New Google Shopping Campaign','en'),(4175,4016,'Erstellen Sie eine neue Google-Shopping-Kampagne','de'),(4176,4016,'Cree una nueva campaña de Google Shopping','es'),(4177,4016,'Créer une nouvelle campagne Shopping Google','fr'),(4178,4016,'Creëer een nieuwe Google Shopping-actie','nl'),(4179,4017,'Build a campaign in a few minutes, and sell to customers as they search for your products on Google.','en'),(4180,4017,'Stellen Sie in Minutenschnelle eine Kampagne zusammen und verkaufen Sie an Kunden, die von Ihnen angebotene Produkte auf Google suchen.','de'),(4181,4017,'Cree una campaña en unos pocos minutos y empiece a vender a los clientes cuando busquen sus productos en Google.','es'),(4182,4017,'Élaborez une campagne en quelques minutes et vendez à des clients qui cherchent vos produits sur Google.','fr'),(4183,4017,'Maak een actie in enkele minuten en verkoop aan klanten als ze op uw producten zoeken op Google.','nl'),(4184,4018,'Manage Campaigns','en'),(4185,4018,'Kampagnen verwalten','de'),(4186,4018,'Gestionar campañas','es'),(4187,4018,'Gérer les campagnes','fr'),(4188,4018,'Campagnes Beheren','nl'),(4189,4019,'Make changes to your active campaigns, purchase one you built, or reinstate your cancelled campaigns.','en'),(4190,4019,'Bearbeiten Sie aktive, buchen Sie erstellte oder starten Sie abgebrochene Kampagnen neu.','de'),(4191,4019,'Haga cambios en sus campañas activas, compre una creada por usted o reactive las campañas canceladas.','es'),(4192,4019,'Apportez des modifications à vos campagnes actives, achetez-en une que vous allez élaborer ou relancez vos campagnes annulées.','fr'),(4193,4019,'Wijzig uw actieve acties, koop er een die u gemaakt heeft of herstel uw geannuleerde acties.','nl'),(4194,4020,'Advanced Options','en'),(4195,4020,'Erweiterte Optionen','de'),(4196,4020,'Opciones avanzadas','es'),(4197,4020,'Options avancées','fr'),(4198,4020,'Geavanceerde opties','nl'),(4199,4021,'Public key','en'),(4200,4022,'Payment processed with errors. Please, try again or ask administrator','en'),(4201,4023,'<ol>\n<li>Sign in to your <a href=\"https://account.authorize.net/\">authorize.net</a> account.</li>\n<li>Go to \"Account\"; in the \"Security Settings\" section, select \"API Credentials & Keys\" link.</li>\n<li>Copy the  API Login ID value.</li>\n<li>Go to X-Cart and paste the API Login ID value you have copied into the \"API Login ID\" field on the payment method settings page.</li>\n<li>If you haven\'t yet created a Transaction key, do so. Copy the value of your Transaction key and paste it into the \"Transaction key\" field on the payment method settings page in X-Cart.</li>\n<li>Again, go to \"Account\"; in the \"Security Settings\" section, select \"Manage Public Client Key\".</li>\n<li>If the Client key has not yet been created, choose to create a Client key. Copy the Client key value and paste it into the \"Public key\" field on the payment method settings page in X-Cart.</li>\n</ol>','en'),(4202,4024,'Setup instruction','en'),(4203,4025,'Sign up for Authorize.net','en'),(4204,4026,'While merchant account ID and merchant ID sound similar, they are different values with distinct purposes.<br/><br/>Your <strong>merchant ID</strong> is a unique identifier for your entire gateway account.<br/><br/>Your <strong>merchant account ID</strong> is a unique identifier for a specific merchant account. Within your Braintree gateway, you can have multiple merchant accounts to process transactions for different businesses or currencies. If you have a single merchant account, it is not necessary to specify a merchant account ID in your API requests. If you have multiple merchant accounts and choose not to specify the merchant account ID, all requests will process through your default merchant account','en'),(4205,4027,'Select <strong>Yes</strong> if you want to pass a shipping address from X-Cart checkout into the PayPal payment flow','en'),(4206,4028,'<strong>Default</strong>: A Google-selected default value. Currently black but it may change over time (default).<br><strong>Black</strong>: A black button suitable for use on white or light backgrounds.<br><strong>White</strong>: A white button suitable for use on colorful backgrounds.','en'),(4207,4029,'<strong>Long</strong>: \"Buy with Google Pay\" button (default). A translated button label may appear if a language specified in the viewer\'s browser matches an available language.<br><strong>Short</strong>: Google Pay payment button without the \"Buy with\" text.','en'),(4208,4030,'Showing results for','en'),(4209,4030,'Показаны результаты для','ru'),(4210,4031,'See details','en'),(4211,4031,'Подробнее','ru'),(4212,4032,'See more results for','en'),(4213,4032,'Показать больше результатов для','ru'),(4214,4033,'Suggestions','en'),(4215,4033,'Предложения','ru'),(4216,4034,'Products','en'),(4217,4034,'Товары','ru'),(4218,4035,'Categories','en'),(4219,4035,'Категории','ru'),(4220,4036,'Pages','en'),(4221,4036,'Страницы','ru'),(4222,4037,'Manufacturers','en'),(4223,4037,'Производители','ru'),(4224,4038,'Did you mean','en'),(4225,4038,'Возможно, вы имели в виду','ru'),(4226,4039,'Filters','en'),(4227,4039,'Фильтры','ru'),(4228,4040,'Reset all filters','en'),(4229,4040,'Сбросить все фильтры','ru'),(4230,4041,'Try clearing filters or different search terms.','en'),(4231,4041,'Попробуйте сбросить фильтры или ввести другое условие поиска.','ru'),(4232,4042,'No products matching the current filtering criteria were found. Try clearing filters.','en'),(4233,4042,'Товары, удовлетворяющие условиям фильтрации, не найдены. Попробуйте сбросить фильтры.','ru'),(4234,4043,'<i class=\"fa fa-exclamation-triangle\"></i> <a href=\"{{url}}\">CloudSearch</a> sets default sort order to relevance.','en'),(4235,4043,'<i class=\"fa fa-exclamation-triangle\"></i> Модуль <a href=\"{{url}}\">CloudSearch</a> по умолчанию сортирует товары по релевантности.','ru'),(4236,4044,'Search & Filter','en'),(4237,4044,'Поиск и фильтры','ru'),(4238,4045,'Search & Filter Dashboard','en'),(4239,4045,'Поиск и фильтры','ru'),(4240,4046,'Bulk edit','en'),(4241,4047,'Click to specify','en'),(4242,4048,'Bulk edit all','en'),(4243,4049,'Inventory','en'),(4244,4050,'Price and membership','en'),(4245,4051,'Bulk edit has been processed successfully.','en'),(4246,4052,'Bulk edit processing has been interrupted.','en'),(4247,4053,'Bulk edit processing may take a while to complete. Please do not close this page until the process is fully completed. If the page has been closed, please re-open it to complete the process (The Bulk edit processing routine is executed only while the page stays open).','en'),(4248,4054,'Bulk Edit processing in progress...','en'),(4249,4055,'Replace with','en'),(4250,4056,'Back to products','en'),(4251,4057,'Bulk edit selected','en'),(4252,4058,'Product list','en'),(4253,4059,'Move to','en'),(4254,4060,'Not set','en'),(4255,4061,'Low stock warning on product page','en'),(4256,4062,'Low stock notification to admin','en'),(4257,4063,'Coming Soon','en'),(4258,4064,'This feature is not yet available. You will be redirected to the feature request page where you can vote to have this feature implemented in one of the upcoming versions.','en'),(4259,4065,'Tax Class','en'),(4260,4047,'Щелкните, чтобы указать значение','ru'),(4261,4049,'Остатки на складе','ru'),(4262,4050,'Цена и доступность для групп','ru'),(4263,1161,'Информация о доставке','ru'),(4264,4051,'Групповое редактирование завершено успешно.','ru'),(4265,4052,'Групповое редактирование было прервано.','ru'),(4266,4053,'Процесс группового редактирования может занять продолжительное время. Пожалуйста, не закрывайте эту страницу до полного завершения процесса. Если страница оказалась закрыта, откройте ее снова, чтобы завершить процесс (Процедура группового редактирования выполняется только пока страница остается открытой).','ru'),(4267,4054,'Идет групповое редактирование...','ru'),(4268,4056,'Назад к списку товаров','ru'),(4269,2866,'Выбрано {{count}} товаров','ru'),(4270,4048,'Редактировать все','ru'),(4271,4057,'Редактировать выбранные','ru'),(4272,4058,'К списку товаров','ru'),(4273,4046,'Групповое редактирование:','ru'),(4274,4059,'Переместить в','ru'),(4275,4055,'Заменить на','ru'),(4276,4060,'Не заданы','ru'),(4277,4061,'Предупреждение о низком остатке на странице товара','ru'),(4278,4062,'Уведомление администратору о низком остатке','ru'),(4279,4063,'Скоро','ru'),(4280,4064,'Данный пункт пока не доступен. Вы будете перенаправлены на страницу голосования за его реализацию в одной из ближайших версий X-Cart.','ru'),(4281,4066,'<b>Canada Post</b> module allows you to use online shipping rates calculation via <a href=\"https://www.canadapost.ca\">Canada Post</a>.','en'),(4282,4067,'Products return {{return_number}}','en'),(4283,4068,'To request a return please complete the form below','en'),(4284,4069,'Return quantity','en'),(4285,4070,'Create return','en'),(4286,4071,'Deliver to Post Office','en'),(4287,4072,'There are no post offices available','en'),(4288,4073,'Tracking pins','en'),(4289,4074,'Delivery to Post Office','en'),(4290,4075,'No events found','en'),(4291,4076,'Attached files','en'),(4292,4077,'Created on','en'),(4293,4078,'Documents','en'),(4294,4079,'Parcel options','en'),(4295,4080,'In store currency (0 - do not use coverage)','en'),(4296,4081,'Parcel','en'),(4297,4082,'Shipment info','en'),(4298,4083,'Shipment ID','en'),(4299,4084,'Shipment status','en'),(4300,4085,'Tracking pin','en'),(4301,4086,'Return tracking pin','en'),(4302,4087,'PO Number','en'),(4303,4088,'Manifests','en'),(4304,4089,'Manifest ID','en'),(4305,4090,'Parcel characteristics','en'),(4306,4091,'Total items weight','en'),(4307,4092,'warning: parcel is overweight','en'),(4308,4093,'Box maximum weight','en'),(4309,4094,'Dimensions (cm)','en'),(4310,4095,'Document','en'),(4311,4096,'Unpackaged','en'),(4312,4097,'Mailing tube','en'),(4313,4098,'Oversized','en'),(4314,4099,'On shipment','en'),(4315,4100,'On exception','en'),(4316,4101,'On delivery','en'),(4317,4102,'Test Canada Post rates calculation','en'),(4318,4103,'Please note that rates are calculated for shipping from Canadian locations only.','en'),(4319,4104,'Canada Post settings','en'),(4320,4105,'Merchant registration wizard','en'),(4321,4106,'To start the registration process for a Canada Post merchant account click on the \"Register\" button.','en'),(4322,4107,'If you want to enable merchant registration wizard once again, please click on the following link','en'),(4323,4108,'enable merchant wizard','en'),(4324,4109,'Administrator notes','en'),(4325,4110,'Not specified','en'),(4326,4111,'18 years','en'),(4327,4112,'19 years','en'),(4328,4113,'shipments are picked up by Canada Post','en'),(4329,4114,'deposit your items at a Post Office','en'),(4330,4115,'Counter - will return the regular price paid by retail consumers','en'),(4331,4116,'Commercial - will return the contracted price between Canada Post and the contract holder','en'),(4332,4117,'Card (hold) for pick up','en'),(4333,4118,'Leave at door','en'),(4334,4119,'Do not safe drop','en'),(4335,4120,'Parcel cannot be voided or transmitted - wrong quote type','en'),(4336,4121,'Parcel cannot be transmitted - wrong quote type','en'),(4337,4122,'Enter Return # or Order #','en'),(4338,4123,'Return products','en'),(4339,4124,'Void shipment','en'),(4340,4125,'Are you sure you want to void this shipment?','en'),(4341,4126,'Transmit shipment','en'),(4342,4127,'Are you sure you want to transmit this shipment?','en'),(4343,4128,'Ordered qty','en'),(4344,4129,'Return qty','en'),(4345,4130,'Total weight','en'),(4346,4131,'Move item','en'),(4347,4132,'New parcel','en'),(4348,4133,'Return #','en'),(4349,4134,'CanadaPost settings','en'),(4350,4135,'Tracking details','en'),(4351,4136,'Search for returns','en'),(4352,4137,'The parcels have been successfully updated','en'),(4353,4138,'The shipment has been created with errors','en'),(4354,4139,'The shipment cannot be created','en'),(4355,4140,'The shipment has been voided with errors','en'),(4356,4141,'The shipment cannot be voided','en'),(4357,4142,'The shipment has been transmitted with errors','en'),(4358,4143,'The shipment has been transmitted successfully','en'),(4359,4144,'The shipment cannot be transmitted','en'),(4360,4145,'Shipments','en'),(4361,4146,'Return','en'),(4362,4147,'The products return has been registered.','en'),(4363,4148,'No items have been selected for return.','en'),(4364,4149,'Directory \"{{path}}\" is not writable or cannot be created','en'),(4365,4150,'Configure manually','en'),(4366,4151,'Authentication options','en'),(4367,4152,'Common options','en'),(4368,4153,'Contact name for the manifest address','en'),(4369,4154,'Contract ID','en'),(4370,4155,'Contract shipping options','en'),(4371,4156,'Coverage','en'),(4372,4157,'Currency rate','en'),(4373,4158,'Customer number','en'),(4374,4159,'Deliver to Post Office options','en'),(4375,4160,'Developer mode','en'),(4376,4161,'Enable \"Deliver to Post Office\" feature','en'),(4377,4162,'Failure to finish registration process.','en'),(4378,4163,'Failure to get token ID.','en'),(4379,4164,'Log all communications between shopping cart and Canada Post server','en'),(4380,4165,'Maximum Post Offices that will be displayed','en'),(4381,4166,'Non-delivery instructions','en'),(4382,4167,'Package height (cm)','en'),(4383,4168,'Package length (cm)','en'),(4384,4169,'Package maximum weight (kg)','en'),(4385,4170,'Package width (cm)','en'),(4386,4171,'Proof of age','en'),(4387,4172,'Quote type','en'),(4388,4173,'Registration process has been canceled.','en'),(4389,4174,'Registration process has been completed successfully.','en'),(4390,4175,'Render detailed manifest','en'),(4391,4176,'Shipments pick up type','en'),(4392,4177,'Site number of the deposit location','en'),(4393,4178,'Way to deliver','en'),(4394,4179,'As a result of your latest order edit, previously created shipments for the order were dropped. Transmitted shipments (if any) remained unchanged. Visit the page <a href=\"{{shipmentsUrl}}\">{{shipmentsUrl}}</a> to manage shipments.','en'),(4395,4180,'Some of the items in the parcel were removed. To view all the items, including the removed ones, see the <a href=\"{{docUrl}}\">{{docTitle}}</a>.','en'),(4396,4181,'You have just added','en'),(4397,4181,'Вы добавили в корзину','ru'),(4398,4182,'Open comparison table','en'),(4399,4182,'Открыть таблицу сравнения','ru'),(4400,4183,'Please add another product to comparison','en'),(4401,4183,'Выберите еще один товар для сравнения','ru'),(4402,4184,'High - Low','en'),(4403,4184,'по убыванию','ru'),(4404,4185,'Low - High','en'),(4405,4185,'по возрастанию','ru'),(4406,4186,'A - Z','en'),(4407,4186,'А - Я','ru'),(4408,4187,'Z - A','en'),(4409,4187,'Я - А','ru'),(4410,4188,'Added to comparison table','en'),(4411,4188,'Добавлено в таблицу сравнения','ru'),(4412,4189,'','en'),(4413,4190,'Street number and street, unit number, etc','en'),(4414,4190,'Улица, номер дома, номер квартиры, и т.д.','ru'),(4415,4191,'','en'),(4416,4192,'','en'),(4417,4193,'','en'),(4418,4194,'','en'),(4419,4195,'Payment statuses','en'),(4420,4195,'Статусы оплаты','ru'),(4421,4196,'Fulfillment statuses','en'),(4422,4196,'Статусы доставки','ru'),(4423,4197,'Order statuses','en'),(4424,4197,'Статусы ордера','ru'),(4425,4198,'Add status','en'),(4426,4198,'Добавить статус','ru'),(4427,4199,'To remove this status, you need to set the status of all the orders currently in this status to a different value','en'),(4428,4199,'Чтобы удалить данный статус надо у всех ордеров с этим статусом сменить статус на другой','ru'),(4429,4200,'System status: <b>{{code}}</b>. Cannot be deleted','en'),(4430,4200,'Системный статус: <b>{{code}}</b>. Не может быть удален','ru'),(4431,4201,'Payment status not found, new status will be created','en'),(4432,4201,'Статус оплаты заказа не найден, будет создан новый статус','ru'),(4433,4202,'Fulfillment status not found, new status will be created','en'),(4434,4202,'Статус доставки заказа не найден, будет создан новый статус','ru'),(4435,4203,'Tabs','en'),(4436,4203,'Вкладки','ru'),(4437,4204,'New tab','en'),(4438,4204,'Новая вкладка','ru'),(4439,4205,'New Tab','en'),(4440,4205,'Новая вкладка','ru'),(4441,4206,'The product tab has been updated','en'),(4442,4206,'Вкладка обновлена','ru'),(4443,4207,'The product tab has been added','en'),(4444,4207,'Вкладка добавлена','ru'),(4445,4208,'Product tabs','en'),(4446,4208,'Информационные вкладки на карточке товара','ru'),(4447,4209,'Tabs imported','en'),(4448,4209,'Импорт вкладок завершен','ru'),(4449,4210,'Brief info','en'),(4450,4210,'Краткая информация','ru'),(4451,4211,'Manage global tabs','en'),(4452,4211,'Управление глобальными вкладками','ru'),(4453,4212,'Edit Globally','en'),(4454,4212,'Редактировать глобально','ru'),(4455,4213,'Global product tabs','en'),(4456,4213,'Глобальные вкладки страницы товара','ru'),(4457,4214,'Learn more','en'),(4458,4214,'Подробнее...','ru'),(4459,4215,'Apply sort and view settings for all products','en'),(4460,4215,'Применить сортировку и настройки видимости ко всем товарам','ru'),(4461,4216,'The text entered here will be displayed on the product details page on the storefront and will be followed by a \"learn more\" link pointing to the respective product tab.','en'),(4462,4216,'Данный текст будет отображаться в карточке товара на стороне витрины магазина и сопровождаться ссылкой вида \"Подробнее...\", ведущей на соответствующую вкладку страницы товара.','ru'),(4463,4217,'Global tab \"{{value}}\" not found','en'),(4464,4217,'Глобальная вкладка товара \"{{value}}\" не найдена','ru'),(4465,4218,'Field \"link\" value \"{{value}}\" is already being used for the global tab \"{{globalTab}}\"','en'),(4466,4218,'Значение поля \"link\" - \"{{value}}\" - уже используется для глобальной вкладки \"{{globalTab}}\"','ru'),(4467,4219,'Global','en'),(4468,4219,'Глобальная','ru'),(4469,4220,'Tab displaying the product\'s detailed description. Added by the X-Cart core','en'),(4470,4220,'Вкладка для отображения детального описания товара. Добавляется ядром X-Cart','ru'),(4471,4221,'Tab displaying the product\'s attributes and other details. Added by the X-Cart core','en'),(4472,4221,'Вкладка для отображения атрибутов товара и другой информации о товаре. Добавляется ядром X-Cart','ru'),(4473,4222,'Tab displaying comments about the product. Added by the addons {{modules}}','en'),(4474,4222,'Вкладка для отображения комментариев о товаре. Добавляется модулями {{modules}}','ru'),(4475,4223,'The product with SKU \"{{value}}\" does not exist. The tab \"{{tab_name}}\" will not be imported','en'),(4476,4223,'Товар с артикулом \"{{value}}\" не найден. Вкладка \"{{tab_name}}\" не будет импортирована.','ru'),(4477,4224,'Added by {{modules}}','en'),(4478,4225,'Enter file extensions separated by comma; for example, \"jpg,txt,svg\"','en'),(4479,4225,'Введите расширения файлов, разделяя запятой; например, \"jpg,txt,svg\"','ru'),(4480,4226,'Web server max upload file size limit is {{size}}','en'),(4481,4226,'Максимальный размер загружаемого файла, разрешенный Вашим веб-сервером - {{size}}','ru'),(4482,4227,'Web server max number of files limit is {{count}}','en'),(4483,4228,'You can attach {{quantity}} more file(s)','en'),(4484,4228,'Вы можете добавить еще {{quantity}} файл(ов)','ru'),(4485,4229,'You can attach <span class=\"files-count\">{{quantity}}</span> file(s)','en'),(4486,4229,'Вы можете добавить <span class=\"files-count\">{{quantity}}</span> файл(ов)','ru'),(4487,4230,'Max allowed file size is {{size}}','en'),(4488,4230,'Максимально допустимый размер файла - {{size}}','ru'),(4489,4231,'Allowed file extensions: {{extensions}}','en'),(4490,4231,'Допустимые расширения: {{extensions}}','ru'),(4491,4232,'Attached files:','en'),(4492,4232,'Присоединенные файлы:','ru'),(4493,1350,'Загрузить файл','ru'),(4494,4233,'Delete attachment','en'),(4495,4233,'Удалить файл','ru'),(4496,4234,'Attach files','en'),(4497,4234,'Присоединить файлы','ru'),(4498,4235,'<span class=\"files-count\">{{quantity}}</span> file(s) attached','en'),(4499,4235,'<span class=\"files-count\">{{quantity}}</span> файлов загружено','ru'),(4500,4236,'Allow buyers to attach files to this product','en'),(4501,4236,'Разрешить покупателям прикреплять файлы к этому товару','ru'),(4502,4237,'The files have been attached successfully','en'),(4503,4237,'Файлы загружены','ru'),(4504,4238,'Unsupported file extension','en'),(4505,4238,'Неподдерживаемый тип файла','ru'),(4506,4239,'Cannot attach the file. The number of attached files may not exceed {{quantity}}','en'),(4507,4239,'Количество файлов не может превышать {{quantity}}','ru'),(4508,4240,'Cannot attach the file. The maximum attached file size may not exceed {{size}} MB','en'),(4509,4240,'Максимальный размер файла не должен превышать {{size}} МБ','ru'),(4510,4241,'Cannot attach the files. Total size of attached files may not exceed {{postSizeLimit}} MB','en'),(4511,4242,'File attachments are not allowed for this product','en'),(4512,4242,'Привязка файлов к этому товару недоступна','ru'),(4513,4243,'File uploads forbidden by web server','en'),(4514,4243,'Загрузка файлов запрещена веб-сервером','ru'),(4515,4244,'Attachment {{filename}} is deleted','en'),(4516,4244,'Присоединенный файл {{filename}} удален','ru'),(4517,4245,'Customer attachments were changed','en'),(4518,4245,'Прикрепленные покупателем файлы были изменены','ru'),(4519,4246,'File Attaching is mandatory for this product','en'),(4520,4246,'Загрузка файла необходима для добавления товара в корзину','ru'),(4521,4247,'You must attach a file to the product','en'),(4522,4247,'Вам необходимо присоединить файл для товара','ru'),(4523,4248,'You must attach a file','en'),(4524,4248,'Вам необходимо присоединить файл','ru'),(4525,4249,'Attach file','en'),(4526,4249,'Присоединить файл','ru'),(4527,4250,'Some files have not been attached','en'),(4528,4250,'Некоторые файлы не были загружены','ru'),(4529,4251,'The maximum size of the uploaded file is limited by the following parameters in your server settings: <ul class=\'custom-disc\'><li><b>post_max_size = {{post_max_size}}</b> - the max total size of the attached files per once and Y</li><li><b>upload_max_filesize = {{upload_max_filesize}}</b> - the max size of each uploaded file</li></ul>','en'),(4530,4252,'The total size of the attached files should not exceed {{post_max_size}} per once','en'),(4531,4253,'Note: In order to setup ePDQ essential payment gateway, you have to complete these steps: <ul><li>Log in to your ePDQ backoffice</li> <li>Open the \"Configuration\" -> \"Technical information\" page -> \"Global security parameters\" tab -> \"Hashing method\" section and select SHA-512 and UTF-8 options.</li> <li>Open the \"Configuration\" -> \"Technical information\" page -> \"Data and origin verification\" tab -> \"Checks for e-Commerce\" section and in the URL field enter this URL: <em>{{URL}}</em></li> <li>Define SHA-IN pass phrase in the corresponding section and further enter it here in X-Cart in the \"SHA-IN pass phrase\" field.</li> <li>Open the \"Configuration\" -> \"Technical information\" page -> \"Transaction feedback\" tab -> \"e-Commerce\" section and enable <em>I would like to receive transaction feedback parameters on the redirection URLs</em> option.</li> <li>Scroll down to the \"All transaction submission modes\" section and define SHA-OUT pass phrase and further enter it here in X-Cart in the \"SHA-OUT pass phrase\" field.</li></ul>','en'),(4532,4254,'PSPID','en'),(4533,4255,'SHA-IN pass phrase','en'),(4534,4256,'SHA-OUT pass phrase','en'),(4535,4257,'Currency','en'),(4536,4258,'Invoice number prefix','en'),(4537,4259,'Enable logging of ePDQ transactions','en'),(4538,4260,'Response from ePDQ is not trusted (SHA checking is failed)','en'),(4539,4261,'Unexpected result was received from ePDQ (transaction status is not set)','en'),(4540,4262,'PS Store ID','en'),(4541,4263,'HPP Key','en'),(4542,4264,'To set up the integration, go to the <a href=\"https://www3.moneris.com/mpg/\" target=\"_blank\">\"Site management\"</a> page on the eSelect site and make sure of the following:','en'),(4543,4265,'The \"PS Store ID\" and \"HPP Key\" value must be exactly the same as on it.','en'),(4544,4266,'The \"Approved URL\" value must be exactly as this:','en'),(4545,4267,'URL is copied','en'),(4546,4268,'The \"Declined URL\" value must be exactly as this:','en'),(4547,4269,'Set the \"Response Method\" setting to \"Sent to your server as a POST\".','en'),(4548,4270,'Enable the \'Use \"Enhanced Cancel\"\' option.','en'),(4549,4271,'Approved URL','en'),(4550,4272,'Declined URL','en'),(4551,4273,'Facebook & Instagram Ads','en'),(4552,4274,'Product feed generation has been completed successfully.','en'),(4553,4275,'Product feed generation has been stopped.','en'),(4554,4276,'Generate Product Feed','en'),(4555,4277,'Product feed','en'),(4556,4278,'Facebook Pixel ID','en'),(4557,4279,'Product Feed URL','en'),(4558,4280,'Frequency of Product Feed renewal','en'),(4559,4281,'No products have been selected for feed generation','en'),(4560,4282,'Add to product feed','en'),(4561,4283,'Remove from product feed','en'),(4562,4284,'Add to Facebook product feed','en'),(4563,4285,'Wrong \"Facebook marketing enabled\" format','en'),(4564,4286,'Use the addon Google Product Feed for advanced flexibility generating a data feed for Facebook based on the product attributes and variants from your store catalog','en'),(4565,4287,'Generate product feed','en'),(4566,4288,'Include out of stock products into feed','en'),(4567,4289,'Value for the \"Add to cart\" event is calculated as: product price multiplied by','en'),(4568,4290,'Enable Advanced Matching','en'),(4569,4291,'Specify the percentage of users who complete the transaction. To find this value, go to Activity > Funnels and create a Funnel with the events Add to Cart and Purchases. The value you require will be shown on a Grey arrow.','en'),(4570,4292,'Value for the \"ViewContent\" event on a product page is calculated as: product price multiplied by','en'),(4571,4293,'Value for the \"InitiateCheckout\" event is calculated as: cart subtotal multiplied by','en'),(4572,4294,'Specify the percentage of users who complete the transaction. To find this value, go to Activity > Funnels and create a Funnel with the events Content View and Purchases. The value you require will be shown on a Grey arrow.','en'),(4573,4295,'Specify the percentage of users who complete the transaction. To find this value, go to Activity > Funnels and create a Funnel with the events Initiated Checkout and Purchases. The value you require will be shown on a Grey arrow.','en'),(4574,4273,'Facebook Ads & Instagram Ads','ru'),(4575,4274,'Подготовка ленты товаров была успешно завершена.','ru'),(4576,4275,'Подготовка ленты товаров была остановлена.','ru'),(4577,4276,'Создать ленту товаров','ru'),(4578,4277,'Лента товаров','ru'),(4579,4278,'Идентификатор пикселя','ru'),(4580,4279,'URL Ленты товаров','ru'),(4581,4280,'Частота обновления ленты товаров','ru'),(4582,4281,'Для создания ленты товаров не выбрано ни одного товара','ru'),(4583,4282,'Включить в ленту товаров','ru'),(4584,4283,'Убрать из ленты товаров','ru'),(4585,4284,'Включить в ленту товаров Facebook','ru'),(4586,4285,'Неправильный формат значения поля \"Facebook marketing enabled\"','ru'),(4587,4286,'Используйте модуль Google Product Feed для большей гибкости при создании фида данных для Facebook на основе атрибутов и вариантов товаров в вашем каталоге','ru'),(4588,4288,'Включать в фид товары, отсутствующие на складе','ru'),(4589,4289,'Значение для события \"Добавление в козину\" рассчитывается как: цена товара, умноженная на','ru'),(4590,4290,'Включить Advanced Matching','ru'),(4591,4291,'Укажите процент пользователей, которые завершают покупку. Чтобы найти данное значение, перейдите в секцию Activity > Funnels и создайте Funnel с событиями Add to Cart и Purchases. Нужное вам значение отображается на серой стрелке.','ru'),(4592,4292,'Значение для события \"Просмотр контента\" на странице товара рассчитывается как: цена товара, умноженная на','ru'),(4593,4293,'Значение для события \"Начало оформления покупки\" рассчитывается как: стоимость товаров в корзине, умноженная на','ru'),(4594,4294,'Укажите процент пользователей, которые завершают покупку. Чтобы найти данное значение, перейдите в секцию Activity > Funnels и создайте Funnel с событиями Content View и Purchases. Нужное вам значение отображается на серой стрелке.','ru'),(4595,4295,'Укажите процент пользователей, которые завершают покупку. Чтобы найти данное значение, перейдите в секцию Activity > Funnels и создайте Funnel с событиями Initiated Checkout и Purchases. Нужное вам значение отображается на серой стрелке.','ru'),(4596,4296,'Any special needs?','en'),(4597,4296,'Укажите информацию для продавца','ru'),(4598,2897,'Выберите метод доставки','ru'),(4599,4297,'Fast Lane checkout','en'),(4600,4297,'Пошаговый','ru'),(4601,4298,'Checkout type','en'),(4602,4298,'Тип страницы оплаты','ru'),(4603,4299,'Firstname','en'),(4604,4299,'Имя','ru'),(4605,4300,'Lastname','en'),(4606,4300,'Фамилия','ru'),(4607,4301,'Return to cart','en'),(4608,4301,'Вернуться к корзине','ru'),(4609,4302,'Edit address','en'),(4610,4302,'Редактировать','ru'),(4611,4303,'Edit email','en'),(4612,4303,'Редактировать','ru'),(4613,4304,'One Page checkout','en'),(4614,4304,'Одностраничный','ru'),(4615,4305,'Order note. Any special needs?','en'),(4616,4305,'Укажите информацию для продавца','ru'),(4617,2893,'Перейти к оплате','ru'),(4618,4306,'Street address','en'),(4619,4306,'Адрес','ru'),(4620,4307,'Zipcode','en'),(4621,4307,'Индекс','ru'),(4622,4308,'Click to finish your order','en'),(4623,4308,'Нажмите для завершения заказа','ru'),(4624,4309,'Order cannot be placed because some steps are not completed','en'),(4625,4309,'Заказ не может быть завершен, пока есть незаполненные поля','ru'),(4626,4310,'Click to proceed to the next step','en'),(4627,4310,'Нажмите для перехода на следующий шаг','ru'),(4628,4311,'Check shipping info','en'),(4629,4311,'Доставка','ru'),(4630,4312,'Choose another address','en'),(4631,4312,'Выбрать другой адрес','ru'),(4632,4313,'Delivery method','en'),(4633,4313,'Способ доставки','ru'),(4634,4314,'Addresses','en'),(4635,4314,'Адреса','ru'),(4636,4315,'Your order details will be sent to your email address','en'),(4637,4315,'Детали ордера будут отправлены на данный адрес','ru'),(4638,4316,'Edit billing address','en'),(4639,4317,'Edit shipping address','en'),(4640,4318,'Next step','en'),(4641,4319,'Free','en'),(4642,4319,'БЕСПЛАТНО','ru'),(4643,4320,'Free shipping','en'),(4644,4320,'Бесплатная доставка','ru'),(4645,4321,'FREE SHIPPING','en'),(4646,4321,'БЕСПЛАТНАЯ ДОСТАВКА','ru'),(4647,4322,'Wrong shipping freight value format','en'),(4648,4322,'Неправильный формат значения поля \"freightFixedFee\"','ru'),(4649,4323,'Special shipping method. Shows during checkout only if <ul class=\"custom-disc\"><li>all the products in the cart are marked \"Free shipping\";</li><li>there are no other shipping methods available.</li></ul><a href=\"https://kb.x-cart.com/en/shipping/free_shipping_on_orders_that_meet_certain_conditions.html\" target=\"_blank\">Learn how to set up free shipping on orders that meet certain conditions</a>','en'),(4650,4323,'Специальный способ доставки. Отображается при оформлении заказа только если <ul><li>для всех товаров в корзине включена настройка \"Бесплатная доставка\";</li><li>нет других доступных способов доставки.</li></ul><a href=\"https://kb.x-cart.ru/shipping/free_shipping_on_orders_that_meet_certain_conditions.html\" target=\"_blank\">Узнайте, как настроить бесплатную доставку для заказов, соответствующих определенным условиям</a>','ru'),(4651,4324,'Shipping freight','en'),(4652,4324,'Фиксированная стоимость доставки','ru'),(4653,4325,'This field can be used to set a fixed shipping fee for the product. Make sure the field value is a positive number (greater than zero).','en'),(4654,4325,'В данном поле можно задать фиксированную стоимость доставки для редактируемого товара. Убедитесь, что используемое значение является положительным числом (больше нуля).','ru'),(4655,4326,'Shipping freight only','en'),(4656,4326,'указанному значению фиксированной стоимости доставки','ru'),(4657,4327,'Shipping freight + regular shipping rate','en'),(4658,4327,'сумме фиксированной стоимости доставки и стоимости доставки, рассчитанной стандартным способом','ru'),(4659,4328,'Special shipping method. Shows during checkout only if <ul class=\"custom-disc\"><li>all the products in the cart have a shipping freight value defined;</li><li>there are no other shipping methods available.</li></ul>','en'),(4660,4328,'Специальный способ доставки. Отображается при оформлении заказа только если<ul><li>для всех товаров в корзине задана фиксированная стоимость доставки;</li><li>нет других доступных способов доставки.</li></ul>','ru'),(4661,4329,'Freight','en'),(4662,4329,'Фиксированная стоимость доставки','ru'),(4663,4330,'Exclude from shipping cost calculation','en'),(4664,4330,'Исключить из расчета стоимости доставки','ru'),(4665,4331,'Wrong \"exclude from shipping cost calculation\" (freeShipping) format','en'),(4666,4331,'Неправильный формат значения поля  \"Исключить из расчета стоимости доставки\" (freeShipping)','ru'),(4667,4332,'Wrong free shipping (shipForFree) format','en'),(4668,4332,'Неправильный формат значения поля \"Бесплатная доставка\"','ru'),(4669,4333,'Important info on the Free shipping add-on update','en'),(4670,4333,'Важная информация об обновлении модуля Free shipping','ru'),(4671,4334,'Your store now provides two free shipping options for individual products:<br>- Exclude from shipping calculation;<br> - Free shipping.<br>If a product is marked \'Exclude from shipping calculation\', this product is excluded from the shipping cost calculation for the order for any available shipping methods.<br>If a product is marked \'Free shipping\', it is treated as eligible for shipping using the method \'Free shipping\'. This method becomes available at checkout if all the products in the shopping cart are either eligible for free shipping or excluded from shipping calculation.','en'),(4672,4334,'В вашем магазине сейчас доступно два варианта бесплатной доставки для отдельных товаров:<br>- Исключение из расчета стоимости доставки;<br>- Бесплатная доставка.<br>Если в свойствах какого-либо товара отмечена опция \'Исключить из расчета стоимости доставки\', данный товар исключается из расчета стоимости доставки заказа для любых доступных способов доставки.<br>Если же в свойствах товара отмечена опция \'Бесплатная доставка\', то это означает, что данный товар может быть отправлен способом доставки \'Бесплатная доставка\'. Данный способ становится доступным при оформлении заказа, если все товары в корзине являются товарами с бесплатной доставкой, либо должны быть исключены из расчета стоимости доставки в соответствии с их настройками.','ru'),(4673,4335,'Warning! Your store now supports two free shipping options for individual products:<br>- Exclude from shipping calculation;<br>- Free shipping.<br>Information on whether a product should be excluded from shipping cost calculation must be submitted via the column shipForFree.<br>Information on whether a product should be eligible for free shipping must be submitted via the column freeShipping.','en'),(4674,4335,'Предупреждение: В вашем магазине сейчас доступно два варианта бесплатной доставки для отдельных товаров:<br>- Исключение из расчета стоимости доставки;<br>- Бесплатная доставка.<br>Информация о том, должен ли товар исключаться из расчета стоимости доставки, должна передаваться в колонке shipForFree.<br>Информация о том, является ли товар товаром с бесплатной доставкой, должна передаваться в колонке freeShipping.','ru'),(4675,4336,'Content has script or style tags. Click the Code View button to edit them.','en'),(4676,4336,'В текстовом поле присутствуют тэги скриптов или стилей. Нажмите на кнопку \"Просмотр HTML-кода\", чтобы отредактировать эти тэги.','ru'),(4677,4337,'Froala Editor settings','en'),(4678,4337,'Настройки редактора Froala','ru'),(4679,4338,'My location','en'),(4680,4339,'Specify your location','en'),(4681,4340,'Save location','en'),(4682,4341,'Location was successfully set','en'),(4683,4342,'Revert to default database','en'),(4684,4343,'X-Cart uses free \"GeoLite2 Country\" database by <a href=\"https://www.maxmind.com/en/geoip2-databases?%refID=xcart\" target=\"_blank\">MaxMind</a>. You can upload the more accurate database to determine the country, subdivisions, city, and postal code. <a href=\"https://www.maxmind.com/en/geoip2-databases?%refID=xcart%\" target=\"_blank\">Learn more</a>','en'),(4685,4344,'Location is invalid','en'),(4686,4345,'Your store uses the addon Geolocation for customer location tracking. The address provided through Geolocation will overwrite the values below. If a higher level of geolocation accuracy is required, you can upload an extended database via the <a href=\'{{geoip-settings-link}}\'>Geolocation addon settings page</a> so your store can estimate a user\'s location to a country, subdivision, city, and postal code.','en'),(4687,4338,'Страна','ru'),(4688,4339,'Укажите ваш адрес','ru'),(4689,4340,'Сохранить адрес','ru'),(4690,4341,'Адрес был сохранен','ru'),(4691,4346,'Вернуться к базе данных по умолчанию','ru'),(4692,4343,'X-Cart использует бесплатную базу данных \"GeoLite2 Country\" от <a href=\"https://www.maxmind.com/en/geoip2-databases?%refID=xcart\" target=\"_blank\">MaxMind</a>. Вы можете загрузить более точную базу данных для определения страны, территориального подразделения, города и почтового кода. <a href=\"https://www.maxmind.com/en/geoip2-databases?%refID=xcart\" target=\"_blank\">Подробнее</a>','ru'),(4693,4345,'Ваш магазин использует модуль Geolocation для определения местоположения покупателя. Нижеследующие данные будут перезаписаны с использованием адреса, предоставленного модулем Geolocation. При необходимости более высокой точности определения местоположения пользователя вы можете загрузить расширенную базу данных через <a href=\'{{geoip-settings-link}}\'>страницу настроек модуля Geolocation</a> - так, чтобы ваш магазин мог осуществлять оценку местоположения пользователя до уровня страны, области, города и индекса.','ru'),(4694,4347,'Google Feed URL: <a href=\"{{url}}\">{{url}}</a>','en'),(4695,4347,'Ссылка на список товаров: <a href=\"{{url}}\">{{url}}</a>','ru'),(4696,4348,'Generate feed','en'),(4697,4348,'Создать выгрузку','ru'),(4698,4349,'Search attribute name','en'),(4699,4349,'Искать по имени атрибута','ru'),(4700,4350,'Product count','en'),(4701,4350,'Количество товаров','ru'),(4702,4351,'Attribute type','en'),(4703,4351,'Тип атрибута','ru'),(4704,4352,'Any google group','en'),(4705,4352,'Любая группа Google','ru'),(4706,4353,'Google shopping group','en'),(4707,4353,'Группа в Google','ru'),(4708,4354,'Click on the \"Generate feed\" button to get the feed link.','en'),(4709,4354,'Нажмите на кнопку «Выгрузить список товаров», чтобы получить ссылку со выгрузкой товаров.','ru'),(4710,4355,'Generate feed','en'),(4711,4355,'Выгрузить список товаров','ru'),(4712,4356,'Feed generation...','en'),(4713,4356,'Идет создание выгрузки...','ru'),(4714,4357,'Feed generation & settings','en'),(4715,4357,'Настройки выгрузки товаров','ru'),(4716,4358,'Google Shopping Group','en'),(4717,4358,'Группы Google','ru'),(4718,4359,'Assign your attributes to Google groups to import your variants.','en'),(4719,4359,'На этой странице можно сопоставить атрибуты товаров с соответствующими категориями Google для более точного определения вариантов товара.','ru'),(4720,4360,'Feed generation has been completed successfully.','en'),(4721,4360,'Создание выгрузки было успешно завершено.','ru'),(4722,4361,'Feed generation has been stopped.','en'),(4723,4361,'Создание выгрузки было остановлено.','ru'),(4724,4362,'Export duplicates as separate products','en'),(4725,4362,'Выгружать дубликаты как отдельные товары','ru'),(4726,4363,'Export only the original product','en'),(4727,4363,'Выгружать только основной товар','ru'),(4728,4364,'The process of feed generation may take a while to complete. Please do not close this page until the process is fully completed.','en'),(4729,4364,'Процесс займет некоторое время. Пожалуйста, не закрывайте эту страницу до его окончания.','ru'),(4730,4365,'Google product feed','en'),(4731,4365,'Выгрузка товаров в Google','ru'),(4732,4366,'Remove from product feed','en'),(4733,4366,'Исключить из выгрузки','ru'),(4734,4367,'Add to product feed','en'),(4735,4367,'Включить в выгрузку','ru'),(4736,4368,'Assign shopping group','en'),(4737,4368,'Назначить группу','ru'),(4738,4369,'Attribute information has been successfully updated','en'),(4739,4369,'Информация по атрибутам успешно обновлена','ru'),(4740,4370,'Generate Google Product feed','en'),(4741,4370,'Создание списка товаров для Google','ru'),(4742,4371,'Google feed','en'),(4743,4371,'Выгрузка товаров в Google','ru'),(4744,4372,'Please select the attributes first','en'),(4745,4372,'Пожалуйста выберите атрибут','ru'),(4746,4373,'Product-specific','en'),(4747,4373,'Специальный для товара','ru'),(4748,4374,'Class \"{{class}}\"','en'),(4749,4374,'Класс \"{{class}}\"','ru'),(4750,4375,'Global Plain field','en'),(4751,4375,'Глобальное строчное поле','ru'),(4752,4376,'Global Hidden field','en'),(4753,4376,'Глобальное скрытое поле','ru'),(4754,4377,'Global Textarea','en'),(4755,4377,'Глобальное многострочное поле','ru'),(4756,4378,'Global Yes/No','en'),(4757,4378,'Глобальное Да/Нет поле','ru'),(4758,4379,'Merchant ID','en'),(4759,4380,'SubID','en'),(4760,4381,'Public Certificate File','en'),(4761,4382,'Public Key','en'),(4762,4383,'Private Key','en'),(4763,4384,'Private Key Password','en'),(4764,4385,'Currency','en'),(4765,4386,'Invoice number prefix','en'),(4766,4387,'Enable logging of iDEAL transactions','en'),(4767,4388,'Something is wrong with the iDEAL payment module settings. Please try later or use a different payment option.','en'),(4768,4389,'Unexpected result was received from iDEAL (transaction status is not set)','en'),(4769,4390,'Payment return page requested without expected parameters','en'),(4770,4391,'Warning! This payment method requires OpenSSL extension. Please install and enable this extension in your PHP configuration.','en'),(4771,4392,'Warning! Please re-check public and private key values and private key password!','en'),(4772,4393,'Select issuer','en'),(4773,4394,'Unknown payment transaction','en'),(4774,4395,'The file with the certificate needs to be located in the directory {{certsDir}}','en'),(4775,4396,'Mailchimp','en'),(4776,4397,'Mailchimp Integration with E-commerce support','en'),(4777,4398,'Type: select box','en'),(4778,4399,'Type: checkbox','en'),(4779,4400,'Mailchimp is an email marketing service with powerful tools to manage your email campaigns and subscribers while gathering advanced analytics information on your campaign performance.','en'),(4780,4401,'Update Mailchimp Lists','en'),(4781,4402,'Mailchimp Lists','en'),(4782,4403,'Mailchimp \"{{list_name}}\" list segments','en'),(4783,4404,'Mailchimp segment settings','en'),(4784,4405,'Subscription','en'),(4785,4406,'Subscribe to our news list and be in touch with our latest offers.','en'),(4786,4407,'News list subscriptions','en'),(4787,4408,'Select box','en'),(4788,4409,'Filter by order frequency','en'),(4789,4410,'Orders last month','en'),(4790,4411,'Filter by order amount','en'),(4791,4412,'Total amount of orders','en'),(4792,4413,'Filter by profile membership','en'),(4793,4414,'Filter by specific products','en'),(4794,4415,'Segment condition','en'),(4795,4416,'here','en'),(4796,4417,'Static','en'),(4797,4418,'Auto-Updated','en'),(4798,4419,'No subscription','en'),(4799,4420,'Web ID','en'),(4800,4421,'List rating','en'),(4801,4422,'Members count','en'),(4802,4423,'Open rate','en'),(4803,4424,'Click rate','en'),(4804,4425,'Selected by default','en'),(4805,4426,'Allow this product to be used as a Mailchimp segment condition','en'),(4806,4427,'1 minute','en'),(4807,4428,'10 minutes','en'),(4808,4429,'15 minutes','en'),(4809,4430,'30 minutes','en'),(4810,4431,'1 hour','en'),(4811,4432,'2 hours','en'),(4812,4433,'4 hours','en'),(4813,4434,'6 hours','en'),(4814,4435,'12 hours','en'),(4815,4436,'1 day','en'),(4816,4437,'2 days','en'),(4817,4438,'5 days','en'),(4818,4439,'1 week','en'),(4819,4440,'Mailchimp lists update','en'),(4820,4441,'First name or last name are empty. Please add a new address to your address book or modify existing and fill in those fields in order to subscribe to this list.','en'),(4821,4442,'Back to segments list','en'),(4822,4443,'Subscribe by default','en'),(4823,4444,'Groups of Mailchimp news list \"{{list_name}}\"','en'),(4824,4445,'Group names of Mailchimp group \"{{group_name}}\"','en'),(4825,4446,'Sign up for news and updates from your favorite store. Be the first to know about exclusive sales, offers and deals.','en'),(4826,4447,'Sign up for {{company_name}} news, sales and deals','en'),(4827,4448,'Here you can view and manage the Mailchimp news lists and groups of the user.','en'),(4828,4449,'Groups','en'),(4829,4450,'E-Commerce features setup','en'),(4830,4451,'Upload store data to Mailchimp','en'),(4831,4452,'Upload store data to Mailchimp to promote more efficient Mailchimp Product Recommendations and Abandoned Carts. Before clicking the button, select the lists for which you want Mailchimp \"stores\" to be created. A \"store\" is a collection of products, orders, carts and customers. Mailchimp will create the \"stores\" and will connect them with the lists you have specified. Store data from X-Cart will be uploaded for these specific stores.<br><a href=\"{{url}}\" target=\"_blank\">Learn more about Mailchimp e-Commerce features</a>','en'),(4832,4453,'Whether you need to draw attention to certain products, share some big news, or tell a story, our campaign builder makes it easy to create email campaigns that best suit your message.','en'),(4833,4454,'Connect with your Mailchimp account','en'),(4834,4455,'Reset Mailchimp connection','en'),(4835,4456,'Install Mailchimp addon','en'),(4836,4457,'Enter your Mailchimp API key manually','en'),(4837,4458,'The e-Commerce Analytics feature is the core component of the integration functionality.','en'),(4838,4459,'All discount coupons','en'),(4839,4460,'Only the discount coupons that match the Mailchimp promo rules','en'),(4840,4461,'Cannot authenticate','en'),(4841,4462,'ID','en'),(4842,4463,'Mailchimp lists','en'),(4843,4464,'Mailchimp settings','en'),(4844,4465,'Manage segments','en'),(4845,4466,'No groups defined','en'),(4846,4467,'No segments','en'),(4847,4468,'Successfully authenticated','en'),(4848,4469,'Update store data','en'),(4849,4470,'Uploading data has been completed successfully.','en'),(4850,4471,'Uploading data has been stopped.','en'),(4851,4396,'Mailchimp','ru'),(4852,4397,'Интеграция сервиса Mailchimp с поддержкой Ecommerce','ru'),(4853,4398,'Тип: список','ru'),(4854,4399,'Тип: галочка','ru'),(4855,4400,'Mailchimp это маркетиногвай сервис по отправке почтовых сообщений с мощными средствами управления рассылками и подписчиками, позволяющими собирать и обрабатывать информацию эффективности маркетинговых кампаний.','ru'),(4856,4401,'Обновить список рассылок Mailchimp','ru'),(4857,4402,'Список рассылок Mailchimp','ru'),(4858,4403,'Сегменты списка рассылок \"{{list_name}}\" Mailchimp','ru'),(4859,4404,'Настройки сегмента Mailchimp','ru'),(4860,4405,'Подписка','ru'),(4861,4406,'Подпишитесь на наши новостные рассылки и будьте в курсе наших специальных предложений и акций.','ru'),(4862,4407,'Подписки на новости','ru'),(4863,4408,'Список','ru'),(4864,4409,'Фильтровать по частоте заказов','ru'),(4865,4410,'Заказов за последний месяц','ru'),(4866,4411,'Фильтровать по общей сумме заказов','ru'),(4867,4412,'Общая сумма заказов','ru'),(4868,4413,'Фильтровать по пользовательским группам','ru'),(4869,885,'Пользовательские группы','ru'),(4870,4414,'Фильтровать по определенным товарам','ru'),(4871,1059,'товары','ru'),(4872,4415,'Условия попадания подписчика в сегмент','ru'),(4873,4416,'здесь','ru'),(4874,384,'Месяц','ru'),(4875,4417,'Статический','ru'),(4876,4418,'Авто обновляемый','ru'),(4877,4419,'Без подписки','ru'),(4878,4420,'Web ID','ru'),(4879,4421,'Рейтинг рассылки','ru'),(4880,4422,'Кол-во подписчиков','ru'),(4881,4423,'Процент открытия','ru'),(4882,4424,'Процент переходов','ru'),(4883,4425,'Выбран по умолчанию','ru'),(4884,4426,'Позволяэт данному товару быть использованним как условие для сегмента Mailchimp','ru'),(4885,910,'Никогда','ru'),(4886,4427,'1 минута','ru'),(4887,4428,'10 минут','ru'),(4888,4429,'15 минут','ru'),(4889,4430,'30 минут','ru'),(4890,4431,'1 час','ru'),(4891,4432,'2 часа','ru'),(4892,4433,'4 часа','ru'),(4893,4434,'6 часов','ru'),(4894,4435,'12 часов','ru'),(4895,4436,'1 день','ru'),(4896,4437,'2 деня','ru'),(4897,4438,'5 деня','ru'),(4898,4439,'1 неделя','ru'),(4899,4440,'Обновление списков Mailchimp','ru'),(4900,4441,'Имя или фамилия пусты. Пожалуйста, добавьте новый адрес в адресную книгу или дополните существующий заполнив соответствующие поля для того, чтобы подписаться на данную рассылку.','ru'),(4901,4442,'Назад к списку сегментов','ru'),(4902,4443,'Подписка по умолчанию','ru'),(4903,4444,'Группы листа \"{{list_name}}\"','ru'),(4904,4445,'Значения группы \"{{group_name}}\"','ru'),(4905,4446,'Подпишитесь на новости и обновления любимого магазина. Узнавайте об эксклюзивных скидках, акциях и предложениях первым!','ru'),(4906,4447,'Подпишитесь на рассылку о новостях, акциях и скидках','ru'),(4907,4448,'Данная секция позволяет просматривать и управлять новостными подписками и группами пользователя (Mailchimp).','ru'),(4908,4449,'Группы','ru'),(4909,4452,'Загрузите данные магазина в Mailchimp для более эффективной работы рекомендаций товаров и поддержки оставленных корзин от Mailchimp. Перед тем как нажать на кнопку, выберите списки, для которых требуется создать \"магазины\" в Mailchimp. \"Магазин\" - это набор товаров, заказов, корзин и покупателей. Mailchimp создаст \"магазины\" и привяжет их к спискам, которые вы указали. Данные из X-Cart будут выгружаться именно в эти магазины.<br><a href=\"{{url}}\" target=\"_blank\">Подробнее об опциях e-Commerce в Mailchimp</a>','ru'),(4910,4451,'Выгрузить данные в Mailchimp','ru'),(4911,4450,'Настройка опций e-Commerce','ru'),(4912,4453,'Хотите ли вы прорекламировать какой-то товар, поделиться важными новостями или рассказать историю - наш конфигуратор рассылок поможет вам с легкостью создать новостную рассылку, наилучшим образом соответствующую посланию, которое вы пытаетесь донести.','ru'),(4913,4454,'Подключить аккаунт Mailchimp','ru'),(4914,4455,'Переподключить аккаунт Mailchimp','ru'),(4915,4456,'Установить модуль Mailchimp','ru'),(4916,4457,'Введите API ключ Mailchimp вручную','ru'),(4917,4458,'Функция e-Commerce Analytics является ключевым компонентом функциональности данной интеграции.','ru'),(4918,4459,'Все купоны','ru'),(4919,4460,'Только купоны, которые соответствуют промо-правилам Mailchimp','ru'),(4920,4472,'News messages','en'),(4921,4472,'Новости','ru'),(4922,4473,'News message','en'),(4923,4473,'Новость','ru'),(4924,4474,'Add news message','en'),(4925,4474,'Добавить новость','ru'),(4926,4475,'News','en'),(4927,4475,'Новости','ru'),(4928,4476,'Top News','en'),(4929,4476,'Последние новости','ru'),(4930,4477,'All news','en'),(4931,4477,'Все новости','ru'),(4932,4478,'Previous','en'),(4933,4478,'Предыдущая новость','ru'),(4934,4479,'Next','en'),(4935,4479,'Следующая новость','ru'),(4936,4480,'The news message has been updated','en'),(4937,4480,'Новость обновлена','ru'),(4938,4481,'The news message has been added','en'),(4939,4481,'Новость добавлена','ru'),(4940,4482,'Add news message','en'),(4941,4482,'Добавление новости','ru'),(4942,4483,'News page title','en'),(4943,4483,'Заголовок страницы новости','ru'),(4944,4484,'News title','en'),(4945,4484,'Заголовок новости','ru'),(4946,4485,'Leave blank to use news title as Page Title.','en'),(4947,4485,'Оставьте поле незаполненным чтобы использовать заголовок новости в качестве заголовка страницы.','ru'),(4948,4486,'<p>There are no news messages in your store. News messages are a great way to build a community around your products and notify clients about recent updates. Start by clicking <b>\"Add news message\"</b>.</p>','en'),(4949,4486,'<p>Пока нет ни одной новости. С помощью новостей можно привлекать новых клиентов и уведомлять о различных изменениях. Начните с нажатия на кнопку <b>\"Добавить новость\"</b>.</p>','ru'),(4950,4487,'Sign up for {{companyName}} news','en'),(4951,4487,'Подписаться на новости {{companyName}}','ru'),(4952,4488,'Thank you for subscribing to the newsletter! We hope you enjoy shopping at {{companyName}}','en'),(4953,4488,'Спасибо за подписку на наши новости. Мы рады, что вы - наш читатель!','ru'),(4954,4489,'Subscribers','en'),(4955,4489,'Подписчики','ru'),(4956,4490,'Email or login','en'),(4957,4490,'Email или логин','ru'),(4958,4491,'Enter email address','en'),(4959,4491,'Введите email','ru'),(4960,4492,'Subscribers imported','en'),(4961,4492,'Подписчики импортированы','ru'),(4962,4493,'Subscriber with email {{email}} already subscribed','en'),(4963,4493,'Подписчик с email {{email}} уже в существует','ru'),(4964,4494,'<p>No one has subscribed on your newsletter yet.</p><p>You can manage newsletter subscribers on this page.</p>','en'),(4965,4494,'<p>Пока никто не подписался на новости вашего магазина.</p><p class=\'text-center\'>На этой странице вы сможете управлять действующими подписками на новости.</p>','ru'),(4966,4495,'Newsletters','en'),(4967,4495,'Рассылка','ru'),(4968,4496,'Can\'t subscribe you right now. Try later','en'),(4969,4497,'Not finished order','en'),(4970,4497,'Незавершенный заказ','ru'),(4971,4498,'not finished','en'),(4972,4498,'не завершен','ru'),(4973,4499,'in case of failed or cancelled payment','en'),(4974,4499,'В случае неудачной оплаты','ru'),(4975,4500,'before payment','en'),(4976,4500,'до оплаты','ru'),(4977,4501,'Export of Not Finished orders is not supported. To export the orders which are now in this state, change their fulfillment status from Not Finished to any other.','en'),(4978,4501,'Экспорт незавершённых заказов не поддерживается. Для экспорта имеющихся заказов в данном статусе необходимо изменить их статус доставки с \'Не завершен\' на любой другой.','ru'),(4979,4502,'Not Finished orders were skipped during the export process. If you wish to export the orders which are now in this state, change their fulfillment status from Not Finished to any other.','en'),(4980,4502,'Незавершенные заказы были пропущены в процессе экспорта. Для экспорта заказов данного типа измените их статус доставки c \'Не завершен\' на любой другой.','ru'),(4981,4503,'You can find the failed order <a href=\"{{url}}\">here</a>','en'),(4982,4503,'Вы можете найти незавершенный заказ <a href=\"{{url}}\">здесь</a>','ru'),(4983,4504,'Not finished orders are skipped during the export process. Change the fulfillment status of these orders to make it exported.','en'),(4984,4505,'Add first product','en'),(4985,4505,'Добавьте товар','ru'),(4986,4506,'Upload company logo','en'),(4987,4506,'Загрузите логотип','ru'),(4988,4507,'Verify geo settings','en'),(4989,4507,'Проверьте геонастройки','ru'),(4990,4508,'Set up shipping methods','en'),(4991,4508,'Настройте доставку','ru'),(4992,4509,'Set up payment gateways','en'),(4993,4509,'Настройте прием платежей','ru'),(4994,4510,'Save and go to the next step','en'),(4995,4510,'Сохранить и перейти к следующему шагу','ru'),(4996,4511,'Proceed to the next step','en'),(4997,4511,'Перейти к следующему шагу','ru'),(4998,4512,'Close wizard','en'),(4999,4512,'Закрыть помощник','ru'),(5000,4513,'Skip this step','en'),(5001,4513,'Пропустить шаг','ru'),(5002,4514,'The uploaded image is too large. Please resize this image and try again.','en'),(5003,4514,'Слишком большое изображение. Пожалуйсте, уменьшите его и повторите попытку.','ru'),(5004,4515,'Your store is {{X}}% ready to accept the first order.','en'),(5005,4515,'Основные настройки магазина выполнены на {{X}}%','ru'),(5006,4516,'Let’s set up your store.','en'),(5007,4516,'Приступим к настройке магазина','ru'),(5008,4517,'Welcome to X-Cart!','en'),(5009,4517,'Поздравляем! Ваш магазин установлен.','ru'),(5010,4518,'Let’s set up your online store in a few easy steps. Track your progress at the top.<br/>As soon as you hit 100%, you’re all set to accept the first order.','en'),(5011,4518,'Этот мастер настройки поможет пошагово выполнить основные настройки магазина.<br/>Пройдя его до конца, вы сможете принять свой первый заказ.','ru'),(5012,4519,'Let’s set up your online store in a few easy steps. Track your progress at the top.<br/>When all the icons turn green, you will be all set to accept the first order.','en'),(5013,4520,'Let\'s set up your store','en'),(5014,4520,'Приступить к настройке магазина','ru'),(5015,4521,'Skip and remind me later','en'),(5016,4521,'Закрыть и напомнить позднее','ru'),(5017,4522,'Close and don’t show again','en'),(5018,4522,'Закрыть и больше не показывать','ru'),(5019,4523,'Add your first product','en'),(5020,4523,'Добавим первый товар?','ru'),(5021,4524,'Here it is, the best place to show your items to the world. Get started by adding a product name, picture and price.','en'),(5022,4524,'Укажите название товара, загрузите его изображение и задайте цену','ru'),(5023,4525,'Learn how to import products from .CSV file','en'),(5024,4525,'Как импортировать товары с помощью .CSV файла','ru'),(5025,4526,'Add other options','en'),(5026,4526,'Задать дополнительные настройки','ru'),(5027,4527,'Enter product name','en'),(5028,4527,'Введите название товара','ru'),(5029,4528,'Click here to upload product image','en'),(5030,4528,'Загрузить картинку товара','ru'),(5031,4529,'(weight, description, sale price)','en'),(5032,4529,'(вес товара, описание, цена со скидкой)','ru'),(5033,4530,'Good going! You\'ve added 1 product','en'),(5034,4530,'Прекрасно! Ваш товар добавлен.','ru'),(5035,4531,'The newly created product is already in your storefront. <a href=\'{{storefront}}\' target=\'_blank\' :href=\'productUrl\'>Have a look!</a><br>Ready to delete demo products?','en'),(5036,4531,'Посмотрите, как он будет выглядеть <a href=\'{{storefront}}\' target=\'_blank\' :href=\'productUrl\'>на витрине магазина</a><br>. А теперь давайте удалим демо-товары.','ru'),(5037,4532,'I\'ll do it later','en'),(5038,4532,'Я удалю их позднее','ru'),(5039,4533,'Delete demo products','en'),(5040,4533,'Удалить демо-товары','ru'),(5041,4534,'Ready to delete demo products?','en'),(5042,4534,'Удалим демо-товары?','ru'),(5043,4535,'Done! We\'ve just deleted all your demo products','en'),(5044,4535,'Готово! Демо-товары удалены.','ru'),(5045,4536,'Add a few <a href=\'{{more}}\' target=\'_blank\'>more products</a> to your catalog or proceed to the next step — whatever makes you happy.','en'),(5046,4536,'Теперь можно <a href=\'{{more}}\' target=\'_blank\'>добавить еще один товар</a> в каталог.  А можно перейти к следующим настройкам.','ru'),(5047,4537,'You can view the newly created product in your <a href=\'{{storefront}}\' target=\'_blank\' :href=\'productUrl\'>storefront</a> or add a few <a href=\'{{more}}\' target=\'_blank\'>more products</a> to your catalog.','en'),(5048,4537,'Посмотрите, как выглядит новый товар <a href=\'{{storefront}}\' target=\'_blank\' :href=\'productUrl\'>на витрине</a> или <a href=\'{{more}}\' target=\'_blank\'>добавьте еще один товар</a> в каталог.','ru'),(5049,4538,'Upload your company logo','en'),(5050,4538,'Давайте добавим логотип компании','ru'),(5051,4539,'Design your online store to fit your brand','en'),(5052,4539,'и тут сразу станет уютнее ;)','ru'),(5053,4540,'<p>Click here to upload your logo. Recommended 221x40px (PNG, JPG, GIF)</p><button class=\'btn regular-button\'>Upload & save new logo</button>','en'),(5054,4541,'Go to the next step','en'),(5055,4542,'Here is the way it looks like on desktop & mobile devices. Do you like it?','en'),(5056,4542,'Вот как он будет выглядеть на экранах. Нравится?','ru'),(5057,4543,'<a href=\'{{shopUrl}}\' target=\'_blank\' >Open the storefront</a> and check how it looks like on desktop.','en'),(5058,4544,'100% mobile-friendly eCommerce website templates, fully customizable, affordable, and open source.','en'),(5059,4545,'Upload a new logo','en'),(5060,4545,'Загрузить другой логотип','ru'),(5061,4546,'Learn how to customize your store with Layout Editor option','en'),(5062,4546,'Как еще я могу изменить внешний вид своего магазина?','ru'),(5063,4547,'(without writing a single line of code) - 2 min','en'),(5064,4547,'(за 2 минуты, и ни одной строчки кода!)','ru'),(5065,4548,'Configure your geographic settings to connect with local customers','en'),(5066,4548,'Давайте проверим географические и локализационные настройки','ru'),(5067,4549,'We\'ve tried to guess your country, currency and weight. Verify, please.','en'),(5068,4549,'Мы попытались угадать страну, валюту и единицу измерения веса. Все верно?','ru'),(5069,4550,'Ex.','en'),(5070,4550,'Например,','ru'),(5071,4551,'More localisation settings','en'),(5072,4551,'Более детальные настройки','ru'),(5073,4552,'Set your company info','en'),(5074,4552,'Добавьте информацию о компании','ru'),(5075,4553,'We will use this info to create invoices, send emails and calculate shipping rates for your customers.','en'),(5076,4553,'Эти данные будут отображаться в email-нотификациях, печататься на счете и использоваться для расчета стоимости доставки','ru'),(5077,4554,'Geo settings & company info are all set. Congrats!','en'),(5078,4554,'Прекрасно, локализацинные настройки и данные о компании обновлены','ru'),(5079,4555,'Do you need to ship your products?','en'),(5080,4555,'Ваши товары требуют доставки?','ru'),(5081,4556,'Yes, I sell tangible goods that need to be shipped','en'),(5082,4556,'Да, я продаю физические товары','ru'),(5083,4557,'Set up shipping','en'),(5084,4557,'Настроить доставку','ru'),(5085,4558,'I sell digital goods or services and do not need to set up shipping','en'),(5086,4558,'Я продаю цифровые товары или сервисы, поэтому доставка не требуется','ru'),(5087,4559,'Mark all products as non-shippable','en'),(5088,4559,'Отключить доставку товаров','ru'),(5089,4560,'Configure shipping rates for your store','en'),(5090,4560,'Давайте настроим стоимость доставки','ru'),(5091,4561,'Besides, you can manually define your shipping rates.','en'),(5092,4561,'Также, вы можете задать стоимость доставки вручную.','ru'),(5093,2588,'Прочитайте, как это сделать','ru'),(5094,4562,'My shipping','en'),(5095,4562,'Моя доставка','ru'),(5096,4563,'Module settings','en'),(5097,4563,'Настройки модуля','ru'),(5098,4564,'Here you can add a flat-rate shipping method','en'),(5099,4565,'More shipping methods','en'),(5100,4566,'Create shipping rate','en'),(5101,4566,'Сохранить новый тариф','ru'),(5102,4567,'Bingo! You\'ve added {{carrier}} as a shipping carrier','en'),(5103,4567,'Готово! {{carrier}} будет использоваться в магазине для расчета стоимости доставки','ru'),(5104,4568,'You\'ve successfully set up shipping areas and rates for your store','en'),(5105,4568,'Зоны доставки и тарифы настроены','ru'),(5106,4569,'Now you can define how shipping rates should be calculated based on delivery time, weight and other parameters.','en'),(5107,4569,'Теперь вы можете настроить, как стоимость доставки будет изменяться в зависимости от времени доставки, веса и других параметров.','ru'),(5108,4570,'Advanced shipping settings','en'),(5109,4570,'Расширенные настройки стоимости доставки','ru'),(5110,4571,'Manage your payment options','en'),(5111,4571,'Настроим способы оплаты','ru'),(5112,4572,'120+ supported payment gateways, such as PayPal, Authorize.net and Opayo, will let you accept payments from all over the world in multiple currencies and languages, offline & online.','en'),(5113,4572,'Выберите из более чем 120 интеграций с платежными системами, включая Yandex.Кассу, Web-money и PayPal. Мы моддерживаем множество валют и языков, поэтому ваш магазин может работать для клиентов со всего мира.','ru'),(5114,4573,'Offline method','en'),(5115,4573,'Оффлайн метод','ru'),(5116,4574,'Online method','en'),(5117,4574,'Онлайн метод','ru'),(5118,4575,'Some people simply prefer to place their orders by phone — let them do that.','en'),(5119,4575,'Некоторые покупатели предпочитают оформить заказ по телефону - почему бы и нет?','ru'),(5120,4576,'View all payment methods','en'),(5121,4577,'Launch','en'),(5122,4577,'Подключить','ru'),(5123,4578,'Excellent! Storefront is ready to get orders!','en'),(5124,4579,'Time to check how it works for your customers. Open the storefront to place a test order.','en'),(5125,4579,'Пора проверить, как все работает для покупателя. Перейдите к витрине, чтобы оформить тестовый заказ.','ru'),(5126,4580,'Contact our expert','en'),(5127,4580,'Свяжитесь с нами','ru'),(5128,4581,'X-Cart professionals will easily materialize just about any idea you’ve got.','en'),(5129,4581,'Наши профессионалы помогут претворить в жизнь любые ваши идеи, даже самые смелые.','ru'),(5130,4582,'User manuals, release notes, modules, videos and more.','en'),(5131,4582,'Руководство по эксплуатации X-Cart и модулей, обучающие видео, описания новых версий и др.','ru'),(5132,4583,'Knowledge base','en'),(5133,4583,'Инструкции пользователя','ru'),(5134,4584,'Developer docs','en'),(5135,4584,'Документация для разработчиков','ru'),(5136,4585,'See the tutorials and documentation about X-Cart store customization.','en'),(5137,4585,'Все о модификациях дизайна и функционала магазинов на X-Cart','ru'),(5138,4586,'Sales & Customer Service:','en'),(5139,4586,'Позвоните нам','ru'),(5140,4587,'International: {{phone}}','en'),(5141,4587,'Международная линия: {{phone}}','ru'),(5142,4588,'Sales & Customer Service: {{phone}}','en'),(5143,4588,'Позвоните нам: {{phone}}','ru'),(5144,4589,'Find your payment method','en'),(5145,4590,'We support 120+ payment gateways','en'),(5146,4591,'What about adding some marketing magic to your sales process?','en'),(5147,4592,'Browse Top Trending Tools','en'),(5148,4593,'Could not save logo image','en'),(5149,4594,'My Shipping','en'),(5150,4595,'Onboarding Wizard','en'),(5151,4596,'Name length must be less then {{length}}','en'),(5152,4597,'OK, now let’s get your store ready for sales','en'),(5153,4598,'Your current domain is <strong>{{domain}}</strong>.','en'),(5154,4599,'Payment Processing','en'),(5155,4600,'Choose the best way for customers to pay you.','en'),(5156,4601,'Change domain name','en'),(5157,4602,'Set it up','en'),(5158,4603,'Get shipping rates from major shipping carrier companies.','en'),(5159,4604,'{{count}} products selected','en'),(5160,4604,'Выбрано {{count}} товар(ов)','ru'),(5161,4605,'Comparison table - {{count}} items','en'),(5162,4605,'Таблица для сравнения — {{count}} товар(ов)','ru'),(5163,4606,'Add a different product to compare','en'),(5164,4606,'Добавьте для сравнения другие товары','ru'),(5165,4607,'Clear list','en'),(5166,4607,'Очистить список','ru'),(5167,4608,'Differences only','en'),(5168,4608,'Оставить только отличия','ru'),(5169,4609,'Add to compare','en'),(5170,4609,'Сравнить','ru'),(5171,4610,'No products have been selected for comparison.','en'),(5172,4610,'Товары для сравнения не выбраны.','ru'),(5173,4611,'The product has been removed from the <a href=\"{{url}}\">comparison table</a>','en'),(5174,4611,'Товар удален из <a href=\"{{url}}\">таблицы сравнения</a>.','ru'),(5175,4612,'The product has been added to the <a href=\"{{url}}\">comparison table</a>','en'),(5176,4612,'Товар добавлен в <a href=\"{{url}}\">таблицу сравнения</a>','ru'),(5177,4613,'The comparison table has been cleared.','en'),(5178,4613,'Таблица сравнения очищена.','ru'),(5179,4614,'Shopping options','en'),(5180,4615,'Show products','en'),(5181,4616,'Reset filter','en'),(5182,4617,'No products matching your criteria found. Please try again with different parameters.','en'),(5183,4618,'Show all products in this category','en'),(5184,4619,'Price range','en'),(5185,4620,'In stock only','en'),(5186,4621,'Generate cache on the fly','en'),(5187,4622,'Remove cache when attribute, tag or product data is changed','en'),(5188,4623,'Click the button to remove the data cache used by your product filter. After removing the cache, open any category in the storefront area to have the cache generated anew.','en'),(5189,4624,'Remove product filter cache','en'),(5190,4625,'Hidden from products filter','en'),(5191,4626,'Visible in products filter','en'),(5192,4627,'Classes for product filter','en'),(5193,4628,'All classes from this category','en'),(5194,4629,'Do not show the filter','en'),(5195,4630,'Choose classes...','en'),(5196,4631,'Alphabetical','en'),(5197,4632,'Manual','en'),(5198,4633,'Wrong useClasses format. This should be \'A\', \'N\' or \'D\'','en'),(5199,4634,'Hash','en'),(5200,4635,'GET params','en'),(5201,4636,'The product filter cache has been removed successfully.','en'),(5202,4614,'Поиск','ru'),(5203,4615,'Показать','ru'),(5204,4616,'Сбросить','ru'),(5205,4617,'Нет товаров удовлетворяющих выбранным условиям.','ru'),(5206,4618,'Показать все товары в категории','ru'),(5207,4619,'Цена','ru'),(5208,4620,'Только в наличии','ru'),(5209,4621,'Генерировать кеш в процессе работы','ru'),(5210,4622,'Сбрасывать кеш при изменении данных атрибутов, тегов или товаров','ru'),(5211,4623,'Кнопка служит для удаления кеша данных, используемого фильтром товаров. После удаления кеша откройте витрину и выберите любую категорию, чтобы кеш был сгенерирован заново','ru'),(5212,4624,'Удалить кеш фильтра товаров','ru'),(5213,4625,'Скрыт из фильтра товаров','ru'),(5214,4626,'Отображается в фильтре товаров','ru'),(5215,4627,'Классы для фильтра товаров','ru'),(5216,4628,'Все классы из этой категории','ru'),(5217,4629,'Не отображать фильтр','ru'),(5218,4630,'Выбрать классы...','ru'),(5219,4631,'По алфавиту','ru'),(5220,4632,'Вручную','ru'),(5221,4633,'Неправильный формат значения useClasses. Возможные значения: \'A\', \'N\' or \'D\'','ru'),(5222,4634,'Хеш','ru'),(5223,4635,'GET параметры','ru'),(5224,4637,'Tag','en'),(5225,4638,'New tag','en'),(5226,4639,'Product tags','en'),(5227,4640,'Please select the tags first','en'),(5228,4641,'Selected tags have been deleted','en'),(5229,4642,'Categories and tags','en'),(5230,4643,'<p>Tags list is empty. Tags help your customers to find products with the specific feature. You can add tags using the <b>\"New tag\"</b> button and then assign them to the product on its edit page.</p>','en'),(5231,4644,'{{count}} tag duplicates ignored','en'),(5232,4637,'Тег','ru'),(5233,4638,'Новый тег','ru'),(5234,5,'Теги','ru'),(5235,4639,'Теги товаров','ru'),(5236,4640,'Пожалуйста, сначала выберите тег','ru'),(5237,4641,'Выбранные теги были удалены','ru'),(5238,4642,'Категории и теги','ru'),(5239,4643,'<p>Список тегов пуст. Теги помогут вашим покупателям быстрее найти нужный товар. Вы можете добавить тег с помощью кнопки <b>\"Новый тег\"</b>. После этого его можно будет назначить товару на странице редактирования товара.</p>','ru'),(5240,4644,'Неучтенные дубликаты тегов {{count}}','ru'),(5241,4645,'API key is a secret key that allows to access REST API functionality. If this key is not specified, the request will not be processed.','en'),(5242,4646,'IMPORTANT:','en'),(5243,4647,'REST API allows to get or change any information in your store (including profiles, orders, payment transactions, inner store configuration, products, categories and so on), so your API key must be as complex as possible and kept private.','en'),(5244,4648,'{{count}} stars','en'),(5245,4649,'{{count}} stars','en'),(5246,4650,'{{count}} stars','en'),(5247,4651,'{{count}} stars','en'),(5248,4652,'{{count}} star','en'),(5249,4653,'Any rating','en'),(5250,4654,'{{product}} reviews','en'),(5251,4655,'Product','en'),(5252,4656,'Product reviews','en'),(5253,4657,'Products reviews','en'),(5254,4658,'Add review','en'),(5255,4659,'Edit review','en'),(5256,4660,'Approve review','en'),(5257,4661,'The review has been created','en'),(5258,4662,'The review has been deleted','en'),(5259,4663,'The review has not been created since the product {{product}} has not been found','en'),(5260,4664,'The review has not been updated since the product {{product}} has not been found','en'),(5261,4665,'Reviewer','en'),(5262,4666,'Rating','en'),(5263,4667,'Reviews imported','en'),(5264,4668,'Product, SKU or customer info','en'),(5265,4669,'Approve','en'),(5266,4670,'Start typing product name or SKU','en'),(5267,4671,'Customer name','en'),(5268,4672,'Start typing customer email or name','en'),(5269,4673,'Text of review','en'),(5270,4674,'Published','en'),(5271,4675,'Please sign in to add review','en'),(5272,4676,'You have already reviewed this product','en'),(5273,4677,'Edit your review','en'),(5274,4678,'Add your own review','en'),(5275,4679,'Thank you for sharing your opinion with us!','en'),(5276,4680,'Your product rating is saved. Thank you!','en'),(5277,4681,'Your review has been updated. Thank your for sharing your opinion with us!','en'),(5278,4682,'Rating of votes','en'),(5279,4683,'Your email','en'),(5280,4684,'customers','en'),(5281,4685,'Average rating','en'),(5282,4686,'out of','en'),(5283,4687,'Based on','en'),(5284,4688,'votes','en'),(5285,4689,'Reviews','en'),(5286,4690,'Reviews: {{count}}','en'),(5287,4691,'We may use this email if we need additional information on your review. We will not use it for any kind of mailing lists or spam subscriptions','en'),(5288,4692,'How do you rate this item?','en'),(5289,4693,'Write your review','en'),(5290,4694,'Your review','en'),(5291,4695,'Back to product details','en'),(5292,4696,'Customer reviews','en'),(5293,4697,'On moderation','en'),(5294,4698,'Read all reviews for the product','en'),(5295,4699,'Rates','en'),(5296,4700,'By Rate - 0-9','en'),(5297,4701,'By Rate - 9-0','en'),(5298,4702,'Only registered customers who purchased this product can leave feedback','en'),(5299,4703,'Registered users who purchased the product','en'),(5300,4704,'Score: {{score}} (votes: {{votes}})','en'),(5301,4705,'Votes: {{votes}}','en'),(5302,4706,'No reviews.','en'),(5303,4707,'Not rated yet','en'),(5304,4708,'Be the first and leave feedback','en'),(5305,4709,'All users','en'),(5306,4710,'Registered users only','en'),(5307,4711,'Reviews and ratings','en'),(5308,4712,'Ratings only','en'),(5309,4713,'Reviews only','en'),(5310,4714,'Review','en'),(5311,4715,'Selected reviews have been deleted','en'),(5312,4716,'Please select the reviews first','en'),(5313,4717,'Selected reviews have been updated','en'),(5314,4718,'Reviews about product','en'),(5315,4719,'New product reviews','en'),(5316,4720,'Ratings and Reviews of {{product}}','en'),(5317,4721,'Rating: {{rating}} out of {{maxRating}}. Review by {{reviewerName}}: {{review}}','en'),(5318,4722,'SEO','en'),(5319,4723,'Select the review that should be included into the rich snippet shown for the page of this product when the page appears in search results by Google and other major search engines. More info: <a href=\"https://support.google.com/webmasters/answer/146750\" target=\"_blank\">https://support.google.com/webmasters/answer/146750</a>','en'),(5320,4724,'Anonymous reviewer','en'),(5321,4725,'Reject','en'),(5322,4726,'There are no comments yet. Be the first to leave a comment','en'),(5323,4727,'A new review has been submitted for the product \"{{name}}\".','en'),(5324,4728,'Go to see the review <a href=\"{{link}}\">in the Admin area</a>','en'),(5325,4729,'<p>No one has rated your products yet. Once someone reviews your product (or you add a review manually), this is the place to track, moderate and remove reviews.</p>','en'),(5326,4729,'<p>Никто пока не оценил ваши товары. Как только появятся отзывы о ваших товарах, вы сможете управлять ими на этой странице.</p>','ru'),(5327,4730,'Please review the product {{product}}','en'),(5328,4730,'Пожалуйств, оставьте отзыв на товар {{product}}','ru'),(5329,4731,'<p>Thank you for your recent purchase from {{company}} – Order #{{orderNumber}} ({{orderDate}}):</p>','en'),(5330,4731,'<p>Благодарим Вас за недавнюю покупку у {{company}} – Заказ #{{orderNumber}} ({{orderDate}}):</p>','ru'),(5331,4732,'<p>Would you be willing to rate these products and write a review? Your opinion is important us.</p><p>To write a review:</p><p>1) Click on the product name to open the Customer reviews section for the product<br />2) Click Add review<br />3) Rate the product and write your feedback.</p><p>Thank you so much for taking the time to let us know what you think. It is truly appreciated.</p>','en'),(5332,4732,'<p>Готовы ли вы оценить эти товары и написать отзыв? Ваше мнение очень важно для нас!</p><p>Чтобы написать отзыв:</p><p>1) Нажмите на название товара, чтобы открыть раздел Отзывы для этого товара<br />2) Нажмите кнопку Добавить отзыв<br />3) Оцените товар и напишите свой отзыв.</p><p>Спасибо, что нашли время сообщить нам свое мнение. Мы очень ценим это.</p>','ru'),(5333,4733,'Excellent','en'),(5334,4733,'Отлично','ru'),(5335,4734,'Good','en'),(5336,4734,'Хорошо','ru'),(5337,4735,'Average','en'),(5338,4735,'Нормально','ru'),(5339,4736,'Fair','en'),(5340,4736,'Посредственно','ru'),(5341,4737,'Poor','en'),(5342,4737,'Плохо','ru'),(5343,4738,'Text of response','en'),(5344,4738,'Ответ','ru'),(5345,4739,'Response date is in wrong format','en'),(5346,4739,'Неверный формат поля \"responseDate\"','ru'),(5347,4740,'Add response','en'),(5348,4740,'Добавить ответ','ru'),(5349,4741,'SKU or Product name','en'),(5350,4741,'Артикул или название товара','ru'),(5351,4742,'First name, Last name or E-mail','en'),(5352,4742,'Имя, фамилия или e-mail','ru'),(5353,4743,'Enter a name to be published with the review','en'),(5354,4743,'Введите имя для отображения в отзыве','ru'),(5355,4744,'Tab displaying product reviews. Added by the addon <a href=\"{{url}}\">Product Reviews</a>','en'),(5356,4744,'Вкладка для отображения отзывов о товаре. Добавляется модулем <a href=\"{{url}}\">Product Reviews</a>','ru'),(5357,4745,'No email','en'),(5358,4746,'Reviewer name','en'),(5359,4747,'Shopper approved promo','en'),(5360,4748,'Vendor name','en'),(5361,4749,'Processing mode','en'),(5362,4750,'Encryption Password','en'),(5363,4751,'Invoice number prefix','en'),(5364,4752,'Pricing currency','en'),(5365,4753,'Don\'t have an account yet? <a href=\"https://applications.sagepay.com/apply/653E8C42-AD93-4654-BB91-C645678FA97B\">Sign up</a> for Opayo now!','en'),(5366,4754,'Opayo is UK\'s leading independent payment service provider (PSP) and is one of the most trusted payment brands. Every year Opayo processes billions of pounds worth of secure payments for its 50,000+ customers and makes the process of accepting payments online, over the phone, or in person simpler, faster, safer and more profitable for businesses.<br /><br />Opayo is a subsidiary of FTSE 100 business management software and services company The Sage Group plc.','en'),(5367,4755,'Please enter your encryption password (This is different from your merchant password). More info on encryption passwords is available <a href=\'{{link}}\'  target=\'_blank\'>here</a>','en'),(5368,4756,'Sitemap','en'),(5369,4757,'Information','en'),(5370,4757,'Информация','ru'),(5371,4756,'Карта сайта','ru'),(5372,4758,'The \"Stripe\" feature is not configured and cannot be used.','en'),(5373,4759,'The \"Stripe\" feature requires https to be <a href=\"{{url}}\">properly set up</a> for your store.','en'),(5374,4760,'{{count}} items ({{total}})','en'),(5375,4760,'{{count}} товаров ({{total}})','ru'),(5376,4761,'CVC verification: {{state}}','en'),(5377,4761,'Проверка подлинности кредитной карты (CVC): {{state}}','ru'),(5378,4762,'Address line verification: {{state}}','en'),(5379,4762,'Проверка адреса: {{state}}','ru'),(5380,4763,'Address zipcode verification: {{state}}','en'),(5381,4763,'Проверка почтового индекса: {{state}}','ru'),(5382,4764,'Requested transaction type: {{actual}}; real transaction type: {{real}}','en'),(5383,4764,'Запрашивалася транзакция типа {{actual}}, а реально была выполнена типа {{real}}','ru'),(5384,4765,'Requested amount: {{actual}}; real amount: {{real}}','en'),(5385,4765,'Запрашивалось к оплате {{actual}}, а реально было оплачено {{real}}','ru'),(5386,4766,'Requested currency: {{actual}}; real currency: {{real}}','en'),(5387,4766,'Запрашивалось к оплате сумма в валюте {{actual}}, а реально было оплачено в валюте {{real}}','ru'),(5388,4767,'Copy \"Webhook URL\" and go to <a href=\"https://dashboard.stripe.com/account/webhooks\" target=\"_blank\">Account settings</a>','en'),(5389,4767,'Скопируйте \"Webhook URL\" и перейдите в <a href=\"https://dashboard.stripe.com/account/webhooks\" target=\"_blank\">Account settings</a>','ru'),(5390,4768,'Open the page <strong>\"Webhooks\"</strong> in the <strong>\"Developers\"</strong> section of dashboard.stripe.com: <a href=\"https://dashboard.stripe.com/account/webhooks\" target=\"_blank\">https://dashboard.stripe.com/account/webhooks</a>','en'),(5391,4768,'Откройте страницу <strong>\"Webhooks\"</strong> раздела </strong>\"Developers\"<strong> на dashboard.stripe.com: <a href=\"https://dashboard.stripe.com/account/webhooks\" target=\"_blank\">https://dashboard.stripe.com/account/webhooks</a>','ru'),(5392,4769,'In the section <strong>\"Endpoints receiving events from your account\"</strong>, click <strong>\"+ Add endpoint\"</strong>.','en'),(5393,4769,'В разделе <strong>\"Endpoints receiving events from your account\"</strong> выберите <strong>\"+ Add endpoint\"</strong>.','ru'),(5394,4770,'In the form that opens, paste the <strong>\"Webhook URL\"</strong> value into the field <strong>\"URL to be called\"</strong> and click <strong>\"Add endpoint\"</strong>.','en'),(5395,4770,'В открывшейся форме вставьте значение <strong>\"Webhook URL\"</strong> в поле <strong>\"URL to be called\"</strong> и выберите <strong>\"Add endpoint\"</strong>','ru'),(5396,4771,'More information on the setup of webhooks is available here: <a href=\"https://stripe.com/docs/webhooks#configuring-your-webhook-settings\" target=\"_blank\">https://stripe.com/docs/webhooks#configuring-your-webhook-settings</a>','en'),(5397,4771,'Больше информации по настройке вебхуков доступно здесь: <a href=\"https://stripe.com/docs/webhooks#configuring-your-webhook-settings\" target=\"_blank\">https://stripe.com/docs/webhooks#configuring-your-webhook-settings</a>','ru'),(5398,4772,'Disconnect','en'),(5399,4772,'Разъеденить','ru'),(5400,4773,'Status: <span>Connected</span> ({{mode}})','en'),(5401,4773,'Статус: <span>Соединено</span> ({{mode}})','ru'),(5402,4774,'Click \"Connect with Stripe\" to be redirected to Stripe.com','en'),(5403,4774,'Нажмите \"Connect with Stripe\" чтобы перейти на Stripe.com','ru'),(5404,4775,'<strong>Complete the form</strong> with your Company info to setup your account and start processing payments immedately.','en'),(5405,4775,'<strong>Заполняйте форму</strong>, имея на руках данные о Вашей компании. После регистрации Вы сможете сразу начать принимать платежи.','ru'),(5406,4776,'Refresh token','en'),(5407,4776,'Обновить токен','ru'),(5408,4777,'Your Stripe account is no longer accessible. Please connect with Stripe once again.','en'),(5409,4777,'Ваш Stripe аккаунт более недоступен. Пожалуста, пройдите соединение со Stripe еще раз.','ru'),(5410,4778,'Webhook URL is your store\'s URL through which Stripe informs your store about any changes in the order. For example, if you refund a payment transaction for a certain amount via Stripe backend, Stripe will send information about this refund to the store using a special request to the Webhook URL, and the store will update the order status to refunded. If Webhook URL is not specified, the store will not know that the order was updated in Stripe backend and the order status in the store will not be updated automatically.','en'),(5411,4778,'Webhook URL это URL Вашего магазина, через который Stripe оповещает магазин о изменениях в заказе. Например, если вы черезе Stripe backend сделаете refund плоатежной транзакции на некую сумму, то Stripe сообщит об этом магазину при помощи специального запроса к Webhook URL и магазин изменит состояние заказа на refunded. Иначе, если Webhook URL не указан, магазин об этом не узнает и закза не изменит свое состояние автоматически.','ru'),(5412,4267,'URL скопирован','ru'),(5413,4779,'Show \"How to use\" instruction','en'),(5414,4779,'Показать инструкцию','ru'),(5415,4780,'Hide \"How to use\" instruction','en'),(5416,4780,'Спрятать инструкцию','ru'),(5417,4781,'Don\'t have an account?','en'),(5418,4782,'Publishable key','en'),(5419,4783,'Publishable key (test mode)','en'),(5420,4784,'Secret key (test mode)','en'),(5421,4785,'The specified amount is less than the minimum amount allowed. Use a higher amount and try again.','en'),(5422,4785,'Сумма заказа меньше минимально возможной. Увеличьте сумму заказа и попробуйте опять.','ru'),(5423,4786,'The specified amount is greater than the maximum amount allowed. Use a lower amount and try again.','en'),(5424,4786,'Сумма заказа больше максимально возможной. Уменьшите сумму заказа и попробуйте опять.','ru'),(5425,4787,'The payment requires authentication to proceed.','en'),(5426,4787,'Платеж требует дополгительной аутентификации.','ru'),(5427,4788,'The card has been declined.','en'),(5428,4788,'Платежная карта отклонена.','ru'),(5429,4789,'The email address is invalid.','en'),(5430,4789,'Неверный электронный адрес.','ru'),(5431,4790,'The card has expired. Check the expiration date or use a different card.','en'),(5432,4790,'Срок действия платежной карты истек, проверьте срок действия или попробуйте другую карту','ru'),(5433,4791,'The card address is incorrect. Check the card address or use a different card.','en'),(5434,4791,'Неверный адрес платежной карты, проверьте адрес или попробуйте другую карту.','ru'),(5435,4792,'The card security code is incorrect. Check the card security code or use a different card.  ','en'),(5436,4792,'Неверный секретный код платежной карты, проверьте секретный код или попробуйте другую карту.','ru'),(5437,4793,'The card number is incorrect. Check the card number or use a different card.  ','en'),(5438,4793,'Неверный номер платежной карты, проверьте номер или попробуйте другую карту.','ru'),(5439,4794,'The card ZIP code is incorrect. Check the card ZIP code or use a different card.  ','en'),(5440,4794,'Неверный почтовый индекс платежной карты, проверьте почтовый индекс или попробуйте другую карту.','ru'),(5441,4795,'The card security code is invalid. Check the card security code or use a different card.  ','en'),(5442,4795,'Неверный секретный код платежной карты, проверьте секретный код или попробуйте другую карту.','ru'),(5443,4796,'The card expiration year is incorrect. Check the card expiration year or use a different card.  ','en'),(5444,4796,'Неверный год срока действия платежной карты, проверьте год срока действия или попробуйте другую карту.','ru'),(5445,4797,'The card expiration month is incorrect. Check the card expiration month or use a different card.  ','en'),(5446,4797,'Неверный месяц срока действия платежной карты, проверьте месяц срока действия или попробуйте другую карту.','ru'),(5447,4798,'The card number is invalid. Check the card number or use a different card.  ','en'),(5448,4798,'Неверный номер платежной карты, проверьте номер или попробуйте другую карту.','ru'),(5449,4799,'The card ZIP code is invalid. Check the card ZIP code or use a different card.  ','en'),(5450,4799,'Неверный почтовый индекс платежной карты, проверьте почтовый индекс или попробуйте другую карту.','ru'),(5451,4800,'Payment method is not available','en'),(5452,4800,'Извините, метод оплаты не доступен.','ru'),(5453,4801,'Firstly, you have to connect to Stripe <a href=\"{{admin_link}}\" target=\"_blank\">here</a> and fill in the respective pair of keys for the current \"Test/Live mode\"','en'),(5454,4801,'Сначала вы должны установить соединение со Stripe <a href=\"{{admin_link}}\" target=\"_blank\">здесь</a>','ru'),(5455,4802,'To setup the payment method in your online store, follow the steps below:<ol style=\"padding-left: 20px; list-style-type: decimal;\"><li>Make sure you have filled the Secret key	/Publishable key fields	for the <a target=\"_blank\" href=\"{{admin_link}}\">Stripe</a> method.</li><li><a target=\"_blank\" href=\"https://stripe.com/docs/stripe-js/elements/payment-request-button#verifying-your-domain-with-apple-pay\">Verifying</a> your domain with Apple Pay.</li></ol>','en'),(5456,4802,'Для настройки платежного метода:<ol style=\"padding-left: 20px; list-style-type: decimal;\"><li>Убедитесь, что вы заполнили поля \"Secret key /Publishable key\" для <a target=\"_blank\" href=\"{{admin_link}}\">Stripe метода</a>.</li><li><a target=\"_blank\" href=\"https://stripe.com/docs/stripe-js/elements/payment-request-button#verifying-your-domain-with-apple-pay\">Верифицировали</a> ваш домен для Apple Pay.</li></ol>','ru'),(5457,4803,'Use custom css','en'),(5458,4803,'Использовать свой CSS','ru'),(5459,1353,'Использовать свой JavaScript','ru'),(5460,4804,'The database stores different version of the custom changes.','en'),(5461,4804,'В базе данных хранится другая версия пользовательского кода.','ru'),(5462,4805,'Review it.','en'),(5463,4805,'Просмотреть её.','ru'),(5464,4806,'Restore this version','en'),(5465,4806,'Восстановить эту версию','ru'),(5466,4807,'Your custom file has been saved successfully','en'),(5467,4807,'Файл успешно сохранен','ru'),(5468,4808,'Theme tweaker','en'),(5469,4808,'Theme tweaker','ru'),(5470,4809,'Pick template from page element','en'),(5471,4809,'Выбор шаблона на основе элемента страницы','ru'),(5472,4810,'Edited templates','en'),(5473,4810,'Измененные шаблоны','ru'),(5474,4811,'Webmaster mode','en'),(5475,4811,'Режим веб-мастера','ru'),(5476,4812,'Template','en'),(5477,4812,'Шаблон','ru'),(5478,4813,'Back to templates list','en'),(5479,4813,'Вернуться к списку шаблонов','ru'),(5480,4814,'Webmaster Mode allows you to change the storefront design in click-and-edit mode.<br /><br />If the design of your store\'s customer area has been messed up by a template change, try restoring the original template in the Edited Templates section. More information about design changes in X-Cart is available in <a href=\"https://devs.x-cart.com/en/design_changes/basic_guide_to_theme_creation.html\">X-Cart\'s Knowledge Base</a>.','en'),(5481,4814,'Режим веб-мастера позволяет редактировать внешний вид сайта по месту.<br /><br />Если после внесения изменений клиентская зона выглядит неправильно, попробуйте откатить изменения в секции \"Измененные шаблоны\". Больше информации об изменении дизайна сайта на X-Cart - в <a href=\"https://devs.x-cart.com/en/design_changes/basic_guide_to_theme_creation.html\">Базе знаний X-Cart</a>.','ru'),(5482,4815,'Webmaster mode is enabled','en'),(5483,4815,'Режим веб-мастера включен','ru'),(5484,4816,'Webmaster mode is disabled','en'),(5485,4816,'Режим веб-мастера отключен','ru'),(5486,4817,'The template has been updated','en'),(5487,4817,'Шаблон обновлён','ru'),(5488,4818,'The template has been added','en'),(5489,4818,'Шаблон добавлен','ru'),(5490,4819,'Enabled','en'),(5491,4819,'Вкл','ru'),(5492,4820,'Disabled','en'),(5493,4820,'Выкл','ru'),(5494,4821,'Path for use in custom CSS','en'),(5495,4821,'Путь для использования в пользовательском CSS','ru'),(5496,4822,'URL','en'),(5497,4823,'The file {{file}} does not exist or is not writable.','en'),(5498,4824,'The directory {{dir}} does not exist or is not writable.','en'),(5499,4825,'Upload image','en'),(5500,4825,'Загрузить картинку','ru'),(5501,4826,'<b>Drag & drop blocks</b> to rearrange them.','en'),(5502,4826,'Здесь можно <b>перетаскивать блоки</b>, меняя их порядок.','ru'),(5503,4827,'Click on the description to <b>edit</b>.','en'),(5504,4827,'Режим предпросмотра продукта. Здесь можно <b>редактировать описание</b> продукта.','ru'),(5505,4828,'Exit product preview','en'),(5506,4828,'Вернуться','ru'),(5507,4829,'You have unsaved changes. Are you really sure to exit the preview?','en'),(5508,4829,'У вас есть несохраненные изменения. Вы точно хотите выйти из режима предпросмотра?','ru'),(5509,4830,'<i class=\"fa fa-exclamation-triangle inline-editor-message_icon\"></i>Click on the description to <b>edit</b>. Your changes may be <span style=\"font-weight: bold; color: orange;\">incompatible</span> with TinyMCE.','en'),(5510,4830,'<i class=\"fa fa-exclamation-triangle inline-editor-message_icon\"></i>Здесь можно <b>редактировать описание</b> продукта. Изменения могут быть <span style=\"font-weight: bold; color: orange;\">несовместимы</span> с редактором TinyMCE.','ru'),(5511,4831,'Changes may be incompatible with TinyMCE. Are you sure to proceed?','en'),(5512,4831,'Изменения могут быть несовместимы с редактором TinyMCE. Вы точно хотите их сохранить?','ru'),(5513,4832,'Layout editor','en'),(5514,4832,'Режим разметки','ru'),(5515,4833,'Dynamic message editor','en'),(5516,4833,'Редактор динамического сообщения уведомления','ru'),(5517,4834,'Labels editor','en'),(5518,4834,'Редактор меток','ru'),(5519,4835,'Discard changes','en'),(5520,4835,'Отказаться','ru'),(5521,4836,'Layout editor is','en'),(5522,4836,'Режим разметки','ru'),(5523,4837,'disabled blocks','en'),(5524,4837,'блоков отключено','ru'),(5525,4838,'Some','en'),(5526,4838,'Несколько','ru'),(5527,4839,'Block is enabled','en'),(5528,4839,'Блок включен','ru'),(5529,4840,'Block is disabled','en'),(5530,4840,'Блок отключен','ru'),(5531,4841,'Exit editor','en'),(5532,4841,'Выйти','ru'),(5533,4842,'Layout editor is enabled','en'),(5534,4842,'Режим разметки включен','ru'),(5535,4843,'Layout editor is disabled','en'),(5536,4843,'Режим разметки отключен','ru'),(5537,4844,'Layout editor allows you to change the position of the blocks in drag-n-drop fashion','en'),(5538,4844,'Режим редактирования разметки позволяет менять положение и порядок блоков путем перетаскивания','ru'),(5539,4845,'There are some custom CSS styles in your store. These styles may affect the look of the installed template. <a href=\"{{url}}\">Review the custom styles</a> and disable them if necessary.','en'),(5540,4845,'Для сайта заданы пользовательские CSS стили. Эти стили могут оказывать влияние на внешний вид интерфейса покупателя. <a href=\"{{url}}\">Просмотрите пользовательские стили</a> и выключите их в случае необходимости.','ru'),(5541,4846,'There are some custom templates in your store that may contain skin dependent code. This may cause your store to crash after switching to a different skin. <a href=\"{{templates_url}}\">Review the custom templates</a> and disable them if necessary.','en'),(5542,4846,'Магазин использует модифицированные шаблоны, которые, возможно, содержат код, работа которого зависит от используемого скина. Это может привести к нарушению корректной работы магазина после переключения на другой скин. <a href=\"{{templates_url}}\">Проверьте модифицированные шаблоны</a> и отключите их в случае необходимости. ','ru'),(5543,4847,'Entity was successfully saved','en'),(5544,4848,'Error on saving image','en'),(5545,4849,'Error on saving video','en'),(5546,4850,'Unable to save edited content. Errors: ','en'),(5547,4851,'Unknown temporary file','en'),(5548,4852,'Show all','en'),(5549,4853,'Flexy to twig converter','en'),(5550,4853,'Flexy to twig конвертор','ru'),(5551,4854,'Flexy template','en'),(5552,4854,'Flexy-шаблон','ru'),(5553,4855,'Twig template path','en'),(5554,4855,'Путь к Twig-шаблону','ru'),(5555,4856,'Converted','en'),(5556,4856,'Сконвертирован','ru'),(5557,4857,'Search flexy templates','en'),(5558,4857,'Найти flexy-шаблоны','ru'),(5559,4858,'Convert','en'),(5560,4858,'Конвертировать','ru'),(5561,4859,'Remove flexy templates','en'),(5562,4859,'Удалить flexy-шаблоны','ru'),(5563,4860,'No flexy templates have been found.','en'),(5564,4860,'Flexy-шаблоны не найдены.','ru'),(5565,4861,'The flexy templates have been removed','en'),(5566,4861,'Flexy-шаблоны были удалены','ru'),(5567,4862,'Some flexy templates cannot be removed. Please correct the file permissions or remove the templates manually:<br />{{list}}','en'),(5568,4862,'Некоторые flexy-шаблоны не могут быть удалены. Скорректируйте права на файлы или удалите их самостоятельно:<br />{{list}}','ru'),(5569,4863,'Check directory permissions','en'),(5570,4863,'Проверьте права на директорию','ru'),(5571,4864,'This action will remove all the flexy templates. Are you sure you want to proceed?','en'),(5572,4864,'Это действие удалит все Flexy-шаблоны. Вы уверены, что хотите продолжить?','ru'),(5573,4865,'Cannot get flexy content','en'),(5574,4865,'Не удалось получить содержимое Flexy-шаблона','ru'),(5575,4866,'Flexy template conversion failure. Check for syntax errors','en'),(5576,4866,'Не удалось сконвертировать Flexy-шаблон. Проверьте его содержание на предмет синтаксических ошибок','ru'),(5577,4867,'Back to Webmaster mode','en'),(5578,4867,'Вернуться на страницу \"Режим веб-мастера\"','ru'),(5579,4868,'Converted files may not always work correctly because not all the changes can be handled automatically by conversion. Be sure to check your converted files manually to ensure that all the required changes have been implemented properly. More info about Flexy and Twig key differences is available at <a href=\"https://xcart.github.io/flexy-to-twig/\" target=\"_blank\">https://xcart.github.io/flexy-to-twig</a>','en'),(5580,4868,'Сконвертированные файлы не всегда могут работать корректно поскольку не все изменения могут быть правильно выполнены при автоматической конвертации. Проверьте ваши сконвертированные файлы вручную, чтобы убедиться, что все изменения перенесены верно. Больше информации о Flexy-to-Twig конверторе доступно здесь: <a href=\"https://xcart.github.io/flexy-to-twig/\" target=\"_blank\">https://xcart.github.io/flexy-to-twig</a>','ru'),(5581,4869,'Preview full email','en'),(5582,4869,'Предпросмотр email','ru'),(5583,4870,'No orders available. Please create at least one order.','en'),(5584,4870,'Нет ни одного заказа. Пожалуйста, создайте по крайней мере один заказ.','ru'),(5585,4871,'Back to notification settings','en'),(5586,4871,'Назад к настройкам уведомлений','ru'),(5587,4872,'Edit template based on','en'),(5588,4872,'Редактировать шаблон на основе','ru'),(5589,4873,'The test email notification has been sent to {{email}}','en'),(5590,4873,'Тестовое уведомление было послано на адрес {{email}}','ru'),(5591,4874,'Failure sending test email to {{email}}','en'),(5592,4874,'Ошибка отправки тестового уведомления на адрес {{email}}','ru'),(5593,4875,'Enter Order number','en'),(5594,4875,'Введите номер заказа','ru'),(5595,4876,'Text parts in curly braces {} are variables and filled dynamically. Do not remove them.','en'),(5596,4876,'Текст в фигурных скобках означает переменную. Не удаляйте такой текст.','ru'),(5597,4877,'<p>You haven\'t changed any templates yet. Here you can track the templates changed with Template editor and revert any changes you\'ve done. Changes to the templates can be done by opening the storefront and switching to the «Template editor» of the panel below.</p>','en'),(5598,4877,'<p>Нет отредактированных шаблонов. На данной странице вы можете узнать об отредактированных шаблонах в режиме Редактор шаблонов. Также здесь вы сможете вернуть шаблоны к первоначальному состоянию. Чтобы изменить какой-либо шаблон, перейдите в клиентскую зону и выберите «Редактор шаблонов» в панели управления сайтом внизу.</p>','ru'),(5599,4878,'Pick templates from page','en'),(5600,4878,'Выбирать шаблоны на странице','ru'),(5601,4879,'Drag-n-drop blocks','en'),(5602,4879,'Перетаскивание блоков','ru'),(5603,4880,'Highlight labels','en'),(5604,4880,'Выделение меток','ru'),(5605,4881,'Layout block','en'),(5606,4881,'Блок разметки','ru'),(5607,4882,'Description editor','en'),(5608,4882,'Контент','ru'),(5609,4883,'Proceed to the product page to edit the description','en'),(5610,4883,'Нет редактируемого контента. Данный режим работает на странице любого продукта','ru'),(5611,4884,'Open home or category page for more opportunities to adjust the website structure.','en'),(5612,4884,'На главной и странице категории есть много различных блоков разметки.','ru'),(5613,4885,'Shortcut: Ctrl+/, ⌘+/','en'),(5614,4885,'Горячая клавиша: Ctrl+/, ⌘+/','ru'),(5615,4886,'Shortcut: Ctrl+S, ⌘+S','en'),(5616,4886,'Горячая клавиша: Ctrl+S, ⌘+S','ru'),(5617,4887,'You have unsaved changes. Are you really sure to exit?','en'),(5618,4887,'Обнаружены несохраненные изменения. Вы точно хотите отказаться от них и уйти?','ru'),(5619,4888,'<a href=\"{{url}}\" target=\"_blank\">Open the storefront</a> while logged in as administrator and use the Webmaster panel <span class=\"cog-icon\">{{cog}}</span> to change the look & feel of the store.','en'),(5620,4888,'<a href=\"{{url}}\" target=\"_blank\">Откройте клиентскую часть магазина</a> из-под администраторского аккаунта и используйте Панель вебмастера <span class=\"cog-icon\">{{cog}}</span> для изменения внешнего вида магазина.','ru'),(5621,4889,'Use the Google Tag Manager addon for more flexibility when adding JS code to your web pages.','en'),(5622,4889,'Используйте модуль Google Tag Manager для получения большей гибкости при добавлении JS кода на веб-страницы.','ru'),(5623,4890,'Learn more about Google Tag Manager','en'),(5624,4890,'Узнать больше о Диспетчере тегов Google','ru'),(5625,4891,'Tag Manager Dashboard','en'),(5626,4891,'Панель управления Диспетчера тегов','ru'),(5627,4892,'Configure Tag Manager','en'),(5628,4892,'Настроить Диспетчер тегов','ru'),(5629,4893,'Install Google Tag Manager','en'),(5630,4893,'Установить Google Tag Manager','ru'),(5631,4894,'Layout was successfully reset','en'),(5632,4894,'Настройки разметки были восстановлены','ru'),(5633,4895,'Unable to reset layout','en'),(5634,4895,'Ошибка при восстановлении настроек разметки','ru'),(5635,4896,'Changes were successfully saved','en'),(5636,4896,'Изменения были успешно применены','ru'),(5637,4897,'Unable to save changes','en'),(5638,4897,'Ошибка при сохранении изменений','ru'),(5639,4898,'Customize storefront','en'),(5640,4898,'Настроить магазин','ru'),(5641,4899,'Storefront layout','en'),(5642,4899,'Тип разметки','ru'),(5643,4900,'Reset layout','en'),(5644,4900,'Сбросить изменения','ru'),(5645,4901,'Home page','en'),(5646,4901,'Главная','ru'),(5647,4902,'Other pages','en'),(5648,4902,'Прочие','ru'),(5649,3908,'Логотипы','ru'),(5650,4903,'logo','en'),(5651,4903,'логотип','ru'),(5652,4904,'favicon','en'),(5653,4904,'фавиконка','ru'),(5654,4905,'app icon','en'),(5655,4905,'закладка','ru'),(5656,4906,'Delete custom file','en'),(5657,4906,'Выключить шаблон','ru'),(5658,4907,'new template','en'),(5659,4907,'добавить шаблон','ru'),(5660,4908,'type filename and press Enter','en'),(5661,4908,'введите имя файла и нажмите Enter','ru'),(5662,4909,'weight','en'),(5663,4909,'вес','ru'),(5664,4910,'Several edited templates were selected to be restored to a default version. You can still find and enable them on the <b>Edited templates</b> page in the Admin area.','en'),(5665,4910,'Отключенные шаблоны можно включить обратно на странице <b>Отредактированные шаблоны</b> в панели администратора.','ru'),(5666,4911,'Restore the default file','en'),(5667,4911,'Вернуть стандартный шаблон','ru'),(5668,4912,'Enable','en'),(5669,4912,'Показать','ru'),(5670,4913,'Are you sure you want to reset the current layout? Custom layout settings will be lost.','en'),(5671,4913,'Вы точно хотите сбросить настройки текущего вида разметки к первоначальному варианту? Измененные настройки положения и отображения блоков будут утеряны.','ru'),(5672,4914,'<p>You can customize the look & feel of the store by configuring the layout and adding the custom CSS or HTML code.</p><p>Just click on the button below or open the storefront while logged in as administrator, and look for the panel at the bottom.</p>','en'),(5673,4914,'<p>Вы можете самостоятельно настроить вид вашего магазина и отдельных элементов, добавить CSS код и изменить код шаблонов.</p><p>Нажмите на кнопку \"Настроить магазин\" или откройте витрину в режиме администратора, чтобы активировать панель веб-мастера.</p>','ru'),(5674,4915,'Display all templates','en'),(5675,4915,'Показать все шаблоны','ru'),(5676,4916,'Скрыть конвертированные шаблоны','en'),(5677,4917,'Not enough permissions to update the template file in \"<X-Cart root>/skins/theme_tweaker\" directory.','en'),(5678,4917,'Произошла ошибка при сохранении файла. Проверьте права на запись в папку \"<X-Cart root>/skins/theme_tweaker\".','ru'),(5679,4918,'File path is too long, it should be less than 255 characters','en'),(5680,4918,'Слишком длинный путь сохраняемого файла, сократите до 255 символов.','ru'),(5681,4919,'Category description','en'),(5682,4919,'Описание категории','ru'),(5683,4920,'OK','en'),(5684,4921,'Edit notification body','en'),(5685,4921,'Редактировать тело нотификации','ru'),(5686,4922,'There is no special code for this notification.\nIf you need to use specific TWIG code put it here.\nFor the plain text, we recommend using WYSIWYG editor on the edit notification page.','en'),(5687,4922,'Для этой нотификации нет специального кода.\nЕсли нужно использовать специфичный TWIG-код, поместите его сюда.\nЕсли нужен только текст, рекомендуем использовать WYSIWYG редактор на странице\nредактирования нотификации.','ru'),(5688,4923,'The dynamic message is empty for this notification. If you need to use specific TWIG code, use the template tree on the left-hand side of the screen to choose the TWIG file you require. For plain text we recommend using the WYSIWYG editor on the Edit notification page.','en'),(5689,4923,'Динамическое сообщение для этого уведомления не задано. Если необходимо использовать специальный TWIG-код, используйте дерево шаблонов слева, чтобы выбрать TWIG-файл для редактирования. Если нужен только текст, рекомендуем использовать WYSIWYG редактор на странице редактирования уведомления.','ru'),(5690,4924,'Add TWIG code','en'),(5691,4924,'Добавить TWIG-код','ru'),(5692,4925,'Disable block','en'),(5693,4925,'Отключить блок','ru'),(5694,4926,'Personalize Logos','en'),(5695,4927,'Upload your brand logos to include in the store header and browser tab.','en'),(5696,4928,'Edit Text','en'),(5697,4929,'Use the Description Editor toolbar below to select and edit text on your store pages.','en'),(5698,4930,'Store Configuration Mode','en'),(5699,4931,'Expand the toolbar below to personalize store layout and style. Click the icon below to exit Store Configuration Mode at any time.','en'),(5700,4932,'Style Your Banners','en'),(5701,4933,'Upload images and setup your banners to showcase top products or promote new sales.','en'),(5702,4934,'Setup banners','en'),(5703,4935,'<b>UPS</b> module allows you to use online shipping rates calculation via <a href=\"http://www.ups.com\" target=\"_new\">UPS service</a>.<br/>To use UPS Rating API you need to register on <a href=\"http://www.ups.com/\" target=\"_new\">UPS.com</a> with a User ID and Password. Once you have registered you would need to obtain an Access Key from UPS.com that provides access to the Rating API. To obtain an Access Key an account number needs to be added or created in your UPS.com profile.','en'),(5704,4936,'UPS module supports \'Cash on delivery\' feature for shipments within European Union, within United States and Puerto Rico, within Canada and from Canada to the United States.<br/>To enable \'Cash on delivery\' payment option you should enable payment method \'Cash on delivery (UPS)\' at the <a href=\"{{URL}}\">Payment methods page</a>.','en'),(5705,4937,'Air service center','en'),(5706,4938,'Customer counter','en'),(5707,4939,'Daily Pickup','en'),(5708,4940,'Delivery confirmation - adult signature required','en'),(5709,4941,'Delivery confirmation - no signature','en'),(5710,4942,'Delivery confirmation - signature required','en'),(5711,4943,'Letter center','en'),(5712,4944,'No confirmation','en'),(5713,4945,'On call air','en'),(5714,4946,'One time pickup','en'),(5715,4947,'Suggested retail rates','en'),(5716,4948,'As a UPS user, you are entitled to receive shipping refunds usually left unclaimed with default UPS service ($2B/year globally). <a href=\"https://71lbs.com/xcart\" target=\"_blank\">Get My UPS Refunds</a>','en'),(5717,4949,'Update quantity','en'),(5718,4949,'Обновление количества','ru'),(5719,4950,'Products updated','en'),(5720,4950,'Обновлено товаров','ru'),(5721,4951,'The script found {{number}} problem(s) during update inventory','en'),(5722,4951,'В процессе обновления были обнаружены ошибки ({{number}})','ru'),(5723,4952,'Product with SKU \"{{value}}\" not found','en'),(5724,4952,'Товар с артикулом \"{{value}}\" не найден','ru'),(5725,4953,'Wrong product quantity value format (\"{{value}}\")','en'),(5726,4953,'Некорректный формат в поле qty (\"{{value}}\")','ru'),(5727,4954,'Products and product variants updated','en'),(5728,4954,'Обновлено товаров и вариантов товаров','ru'),(5729,4955,'Product or product variant with SKU \"{{value}}\" not found','en'),(5730,4955,'Товар или вариант товара с артикулом \"{{value}}\" не найдены','ru'),(5731,4956,'Update quantity import guide','en'),(5732,4956,'Руководство по обновлению количества','ru'),(5733,4957,'https://kb.x-cart.com/modules/update_inventory.html','en'),(5734,4957,'https://kb.x-cart.ru/modules/update_inventory.html','ru'),(5735,4958,'Related products','en'),(5736,4959,'Alternative products you may be interested in','en'),(5737,4960,'This product is no longer available although you may find similar or newer version below.','en'),(5738,4961,'Bidirectional link','en'),(5739,4961,'Двунаправленная связь','ru'),(5740,4962,'Related products page','en'),(5741,4963,'You cannot choose this product','en'),(5742,4964,'The product SKU#{{SKU}} is already set as related for the product','en'),(5743,4965,'Add related products','en'),(5744,4966,'Related products (Related Products module)','en'),(5745,4967,'The product SKU#\"X\" is already set as Related for the product','en'),(5746,4968,'Enable bidirectional links','en'),(5747,4968,'Включить двунаправленная связь','ru'),(5748,4969,'Disable bidirectional links','en'),(5749,4969,'Отключить двунаправленная связь','ru'),(5750,4970,'Do you really want to delete all relations from this product?','en'),(5751,4970,'Вы действительно хотите удалить все связи из этого товара?','ru'),(5752,4971,'\"Bidirectional link\" means that the related product is not only linked to from the product on view, but also provides a link to that product. With the \"Bidirectional link\" option enabled, removing the link from one of the products will not remove the link in the opposite direction. To remove the relationship between the products completely, disable the \"Bidirectional link\" option first, then remove the link.','en'),(5753,4971,'\"Двунаправленная связь\" значит, что не только просматриваемый товар ссылается на связанный, но и связанный ссылается на него. При включенной настройке \"Двунаправленная связь\", удаление ссылки с одного из товаров не приведет к удалению ссылки в противоположном направлении. Для полного удаления связи между товарами, вначале отключите настройку \"Двунаправленная связь\", затем удалите ссылку на связанный товар.','ru'),(5754,4972,'Edit all','en'),(5755,4972,'Редактировать все','ru'),(5756,4973,'Make bidirectional relations','en'),(5757,4973,'Добавлять двунаправленную связь','ru'),(5758,4974,'Read','en'),(5759,4974,'Прочитано','ru'),(5760,4975,'Unread','en'),(5761,4975,'Не прочитано','ru'),(5762,4976,'Messages','en'),(5763,4976,'Сообщения','ru'),(5764,887,'Сообщение','ru'),(5765,4977,'Message not found','en'),(5766,4977,'Сообщение не найдено','ru'),(5767,2135,'Все заказы','ru'),(5768,4978,'Orders with unread messages','en'),(5769,4978,'Все заказы с непрочитанными сообщениями','ru'),(5770,4979,'Orders with any messages','en'),(5771,4979,'Все заказы с сообщениями','ru'),(5772,4980,'The field Body may not be blank','en'),(5773,4980,'Поле \'Сообщение\' не может быть пустым','ru'),(5774,4981,'Contact seller','en'),(5775,4981,'Связаться с продавцом','ru'),(5776,4982,'{{count}} unread messages','en'),(5777,4982,'{{count}} непрочитанных сообщений','ru'),(5778,4983,'Hidden messages ({{count}})','en'),(5779,4983,'Скрытые сообщения ({{count}})','ru'),(5780,4984,'Hide message history','en'),(5781,4984,'Скрыть историю общения','ru'),(5782,4985,'New message for order','en'),(5783,4985,'Новое сообщение по заказу','ru'),(5784,4986,'{{count}} new messages for order','en'),(5785,4986,'{{count}} новых сообщений  по заказу','ru'),(5786,4987,'You Have No Messages','en'),(5787,4987,'Нет сообщений','ru'),(5788,4988,'Dispute opened by {{name}}','en'),(5789,4988,'Диспут открыт {{name}}','ru'),(5790,4989,'Dispute closed by {{name}}','en'),(5791,4989,'Диспут закрыт {{name}}','ru'),(5792,4990,'Open dispute','en'),(5793,4990,'Открыть диспут','ru'),(5794,4991,'Close dispute','en'),(5795,4991,'Закрыть диспут','ru'),(5796,4992,'A dispute has been opened successfully.','en'),(5797,4992,'Диспут открыт','ru'),(5798,4993,'The dispute has been closed.','en'),(5799,4993,'Диспут закрыт','ru'),(5800,4994,'Monitoring of communication related to oder #{{order_number}} has been enabled.','en'),(5801,4994,'Подписка на получение сообщений по заказу №{{order_number}} включена','ru'),(5802,4995,'Monitoring of communication related to oder #{{order_number}} has been disabled.','en'),(5803,4995,'Подписка на получение сообщений по заказу №{{order_number}} выключена','ru'),(5804,4996,'All communication threads','en'),(5805,4996,'Все цепочки сообщений','ru'),(5806,4997,'Communication threads with unread messages','en'),(5807,4997,'Цепочки с непрочитанными сообщениями','ru'),(5808,4998,'Communication threads with open disputes','en'),(5809,4998,'Цепочки с открытыми диспутами','ru'),(5810,4999,'Dispute opened on {{date}}, by {{name}}','en'),(5811,4999,'Диспут открыт {{date}}, {{name}}','ru'),(5812,5000,'Write your message here','en'),(5813,5000,'Текст вашего сообщения','ru'),(5814,5001,'Open a dispute','en'),(5815,5001,'Открыть диспут','ru'),(5816,5002,'Dispute','en'),(5817,5002,'Диспут','ru'),(5818,5003,'Reason','en'),(5819,5003,'Причина','ru'),(5820,5004,'New messages','en'),(5821,5004,'Новые сообщения','ru'),(5822,5005,'Show vendor’s products in the order','en'),(5823,5005,'Показать товары продавца','ru'),(5824,5006,'Hide vendor’s products in the order','en'),(5825,5006,'Скрыть товары продавца','ru'),(5826,5007,'Disputes','en'),(5827,5008,'Conversation','en'),(5828,5008,'Разговор','ru'),(5829,5009,'Conversations','en'),(5830,5009,'Разговоры','ru'),(5831,5010,'Conversation: {{members}}','en'),(5832,5010,'Разговор: {{members}}','ru'),(5833,5011,'{{count}} new messages','en'),(5834,5011,'{{count}} новых сообщений','ru'),(5835,5012,'New message','en'),(5836,5012,'Новое сообщение','ru'),(5837,5013,'Mark all','en'),(5838,5013,'Пометить все','ru'),(5839,5014,'Mark selected','en'),(5840,5014,'Пометить выбранные','ru'),(5841,5015,'Subscription plan','en'),(5842,5015,'План подписки','ru'),(5843,5016,'This is subscription product','en'),(5844,5016,'Это подписка','ru'),(5845,5017,'ID подписки','ru'),(5846,5018,'Setup fee','en'),(5847,5018,'Стоимость подключения','ru'),(5848,5019,'Subscription fee','en'),(5849,5019,'Абонентская плата','ru'),(5850,5020,'Plan','en'),(5851,5020,'План','ru'),(5852,5021,'Each','en'),(5853,5021,'Каждый','ru'),(5854,5022,'Every','en'),(5855,5022,'Через каждые','ru'),(5856,5023,'Count days from the end','en'),(5857,5023,'Считать дни с конца периода','ru'),(5858,5024,'Daily','en'),(5859,5024,'Ежедневно','ru'),(5860,5025,'{{count}} subscription(s)','en'),(5861,5025,'Подписок: {{count}}','ru'),(5862,5026,'Подписок нет','ru'),(5863,5027,'Дата старта:','ru'),(5864,5028,'Следующий платёж','ru'),(5865,5029,'Пропущенный платёж','ru'),(5866,5030,'следующая попытка','ru'),(5867,5031,'Остановлена','ru'),(5868,5032,'Перезапущена','ru'),(5869,5033,'Завершена','ru'),(5870,5034,'-{{to|st|nd|rd|th|number}} day of','en'),(5871,5034,'-{{to|ый|ой|ий|number}} день','ru'),(5872,5035,'Every {{number}} day|Every {{number}} days','en'),(5873,5035,'Каждый {{number}} день|Каждые {{number}} дня|Каждые {{number}} дней','ru'),(5874,5036,'Weekly','en'),(5875,5036,'Еженедельно','ru'),(5876,5037,'Weekly|Every {{number}} weeks','en'),(5877,5037,'Каждую {{number}} неделю|Каждые {{number}} недели|Каждые {{number}} недель','ru'),(5878,5038,'Monthly','en'),(5879,5038,'Ежемесячно','ru'),(5880,5039,'Monthly|Every {{number}} months','en'),(5881,5039,'Каждый {{number}} месяц|Каждые {{number}} месяца|Каждые {{number}} месяцев','ru'),(5882,5040,'Annually','en'),(5883,5040,'Ежегодно','ru'),(5884,5041,'Annually|Every {{number}} years','en'),(5885,5041,'Каждый {{number}} год|Каждые {{number}} года|Каждые {{number}} лет','ru'),(5886,5042,'Each Monday','en'),(5887,5042,'Каждый понедельник','ru'),(5888,5043,'Each Tuesday','en'),(5889,5043,'Каждый вторник','ru'),(5890,5044,'Each Wednesday','en'),(5891,5044,'Каждую среду','ru'),(5892,5045,'Each Thursday','en'),(5893,5045,'Каждый четверг','ru'),(5894,5046,'Each Friday','en'),(5895,5046,'Каждую пятницу','ru'),(5896,5047,'Each Saturday','en'),(5897,5047,'Каждую субботу','ru'),(5898,5048,'Each Sunday','en'),(5899,5048,'Каждое воскресенье','ru'),(5900,5049,'{{number}}-{{to|st|nd|rd|th|number}} day of each month','en'),(5901,5049,'{{number}}-{{to|ый|ой|ий|number}} день каждого месяца','ru'),(5902,5050,'One day till the end of each month|{{number}} days till the end of each month','en'),(5903,5050,'За {{number}} день до конца каждого месяца|За {{number}} дня до конца каждого месяца|За {{number}} дней до конца каждого месяца','ru'),(5904,5051,'{{number}}-{{to|st|nd|rd|th|number}} day of each year','en'),(5905,5051,'{{number}}-{{to|ый|ой|ий|number}} день каждого года','ru'),(5906,5052,'One day till the end of each year|{{number}} days till the end of each year','en'),(5907,5052,'За {{number}} день до конца каждого года|За {{number}} дня до конца каждого года|За {{number}} дней до конца каждого года','ru'),(5908,5053,'Week','en'),(5909,5053,'Недели','ru'),(5910,5054,'Month','en'),(5911,5054,'Месяца','ru'),(5912,5055,'Year','en'),(5913,5055,'Года','ru'),(5914,5056,'Days','en'),(5915,5056,'День','ru'),(5916,5057,'Weeks','en'),(5917,5057,'Неделя','ru'),(5918,5058,'Months','en'),(5919,5058,'Месяц','ru'),(5920,5059,'Years','en'),(5921,5059,'Год','ru'),(5922,5060,'Only one extra payment|Total of {{number}} payments','en'),(5923,5060,'Всего {{number}} платёж|Всего {{number}} платежа|Всего {{number}} платежей','ru'),(5924,5061,'Order #{{order_number}} has been created for the next scheduled payment on subscription #{{subscription_id}}','en'),(5925,5061,'Создан заказ #{{order_number}} для осуществления очередного платежа по подписке #{{subscription_id}}','ru'),(5926,5062,'It will be charged on {{actualDate}}','en'),(5927,5062,'Снятие средств по нему будет произведено {{actualDate}}','ru'),(5928,5063,'Payment error. We will attempt to charge this payment again on {{actualDate}}.','en'),(5929,5063,'Платёж не прошел. Следующая попытка снятия средств будет осуществлена {{actualDate}}.','ru'),(5930,5064,'Payment transaction on order #{{order_number}} has failed','en'),(5931,5064,'Платёж по заказу #{{order_number}} не прошел','ru'),(5932,5065,'{{payment}}-{{to|st|nd|rd|th|payment}} payment out of {{payments}}','en'),(5933,5065,'{{payment}}-{{to|ый|ой|ий|payment}} платёж из {{payments}}','ru'),(5934,5066,'Subscription #{{subscription_id}} has been stopped due to failed payment attempts.','en'),(5935,5066,'Подписка #{{subscription_id}} остановлена из-за сбоя платежей.','ru'),(5936,5067,'Пожалуйста, попробуйте использовать другую карту для оплаты или свяжитесь с администратором магазина','ru'),(5937,5068,'Date of next subscription payment','en'),(5938,5068,'Дата следующего платежа по подписке','ru'),(5939,5069,'Ваша подписка активирована','ru'),(5940,5070,'Your subscription \"{{subscription_name}}\" has been activated','en'),(5941,5070,'Ваша подписка \"{{subscription_name}}\" активирована','ru'),(5942,5071,'Subscription #{{subscription_id}} has been activated','en'),(5943,5071,'Подписка #{{subscription_id}} активирована','ru'),(5944,5072,'Ваша подписка остановлена','ru'),(5945,5073,'Your subscription \"{{subscription_name}}\" has been stopped','en'),(5946,5073,'Ваша подписка \"{{subscription_name}}\" остановлена','ru'),(5947,5074,'Subscription #{{subscription_id}} has been stopped','en'),(5948,5074,'Подписка #{{subscription_id}} остановлена','ru'),(5949,5075,'You can manage your subscriptions <a href=\"{{url}}\">here</a>','en'),(5950,5075,'Вы можете настроить Ваши подписки <a href=\"{{url}}\">здесь</a>','ru'),(5951,5076,'Payment for subscription #{{subscription_id}} has been succesfully charged','en'),(5952,5076,'Платёж по подписке #{{subscription_id}} прошёл успешно','ru');
/*!40000 ALTER TABLE `[[dbprefix]]language_label_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]language_labels`
--

DROP TABLE IF EXISTS `[[dbprefix]]language_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]language_labels` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`label_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5077 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]language_labels`
--

LOCK TABLES `[[dbprefix]]language_labels` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]language_labels` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]language_labels` VALUES (3925,' page and make sure that:'),(3578,'\"Cash on delivery\" status'),(3924,'\"Site management\"'),(2062,'\"X product\" options'),(1179,'\"{{number}}\" tracking number is added'),(1180,'\"{{number}}\" tracking number is removed'),(1844,'\"{{product}} product\" attributes'),(2012,'# selected'),(1,'%'),(2084,'\'RESULT\' argument not found'),(2079,'\'status\' request argument can not found'),(3976,'(disabled role)'),(4529,'(like categories, weight, description, color)'),(2077,'(optional)'),(4547,'(without writing a single line of code) - 2 min'),(427,'+12130000000'),(4189,'+15550000000'),(232,'-- No categories --'),(1929,'-- empty --'),(2613,'...Downloading {{entry}}...{{status}}'),(2611,'...Hooks {{hooksCount}}'),(2610,'...Hooks {{hooksCount}}, Items {{itemsCount}}...'),(2609,'...Invoke {{type}} hook for {{entry}}...'),(2612,'...Unpacking {{entry}}...{{status}}'),(4436,'1 day'),(4431,'1 hour'),(4427,'1 minute'),(4439,'1 week'),(4428,'10 minutes'),(4544,'100% mobile-friendly eCommerce website templates, fully customizable, affordable, and open source.'),(423,'1000 Example street'),(4190,'1000 Main Street'),(4435,'12 hours'),(4572,'120+ supported payment gateways, such as PayPal, Authorize.net and etc.'),(380,'14days'),(4429,'15 minutes'),(4111,'18 years'),(4112,'19 years'),(4437,'2 days'),(4432,'2 hours'),(3920,'2Checkout.com account number'),(4430,'30 minutes'),(381,'30days'),(3776,'3D Secure'),(4433,'4 hours'),(2783,'404 page'),(4438,'5 days'),(4434,'6 hours'),(379,'7days'),(426,'90001'),(2614,'<span>X</span> items'),(4186,'A - Z'),(1480,'A DB error occurred while uninstalling the module X'),(4992,'A dispute has been opened successfully'),(2234,'A new category will be created'),(431,'A new customer? Enter your e-mail'),(2231,'A new membership will be created'),(2232,'A new product class will be created'),(2230,'A new product will be created'),(4727,'A new review has been submitted for the product \"{{name}}\".'),(2233,'A new tax class will be created'),(3597,'A single domain'),(432,'ABA routing number'),(3456,'API Login ID'),(3667,'API access password'),(3666,'API access username'),(3671,'API certificate'),(3670,'API certificate filename'),(3661,'API credentials for payments and post-checkout operations'),(4645,'API key is a secret key that allows to access REST API functionality. If this key is not specified in a request will not be executed.'),(3669,'API signature'),(368,'APRIL'),(372,'AUGUST'),(2482,'About X remaining'),(2793,'About clean urls'),(433,'Absolute'),(434,'Accept'),(2737,'Accept[TT]'),(435,'Accepted orders'),(3407,'Access Key ID'),(3265,'Access denied'),(437,'Access denied!'),(438,'Access information'),(439,'Access is locked out'),(440,'Access level'),(2758,'Access level cannot be changed (from {{prevValue}} to {{value}}) for existing profile ({{login}})'),(3266,'Access link has been successfully sent'),(441,'Account'),(442,'Account details'),(241,'Account settings'),(443,'Account status'),(444,'Account summary'),(2619,'Accounting'),(2395,'Action'),(1476,'Action X::Y, M'),(18,'Activate'),(16,'Activate existing key'),(15,'Activate free license'),(3095,'Activate free license & remove premium features.'),(22,'Activate free license description'),(1669,'Activate key'),(445,'Activate license key'),(2517,'Activate purchased skin'),(2289,'Activate your X-Cart'),(2287,'Activate your X-Cart installation'),(2288,'Activate your X-Cart installation first'),(10,'Activate your license key'),(446,'Activate your paid module license'),(3378,'Activated! Your current domain is X'),(447,'Active'),(448,'Active from'),(449,'Active fromF'),(450,'Active till'),(451,'Active tillF'),(452,'Add'),(3627,'Add PIN codes'),(453,'Add Product'),(4924,'Add TWIG code'),(4536,'Add a few [more products] to your catalog or proceed to the next step - whatever makes you happy.'),(3267,'Add addons'),(3268,'Add address'),(454,'Add alternative payment method'),(1914,'Add attribute'),(2708,'Add banner'),(455,'Add category'),(456,'Add child'),(2704,'Add comment here'),(2887,'Add countries'),(3514,'Add coupon'),(457,'Add discount'),(458,'Add featured products'),(2067,'Add featured products for \"X\"'),(3575,'Add featured products for the front page'),(459,'Add file'),(4505,'Add first product'),(460,'Add image'),(123,'Add language'),(461,'Add markup'),(462,'Add new'),(463,'Add new address'),(464,'Add new country'),(3507,'Add new coupon'),(465,'Add new exception'),(122,'Add new label'),(126,'Add new language'),(466,'Add new membership level'),(467,'Add new option'),(468,'Add new option group'),(469,'Add new state'),(470,'Add offline payment method'),(4526,'Add other options'),(4606,'Add other products to compare'),(471,'Add payment method'),(3634,'Add pin codes'),(2848,'Add product'),(1967,'Add products'),(1649,'Add rates'),(4965,'Add related products'),(4740,'Add response'),(4658,'Add review'),(3133,'Add sales channel'),(472,'Add shipping method'),(1654,'Add state'),(1653,'Add states'),(4198,'Add status'),(473,'Add subcategory'),(2402,'Add to bag'),(28,'Add to cart'),(4609,'Add to compare'),(4367,'Add to google product feed'),(1182,'Add tracking number'),(474,'Add user'),(475,'Add your _products_'),(4678,'Add your own review'),(476,'Add zone'),(2422,'Add-on does not exist.'),(477,'Add-ons'),(478,'Add/update options'),(479,'Added'),(4224,'Added by modules'),(3513,'Added coupons'),(2965,'Added files'),(2198,'Added items'),(481,'Added to cart'),(4188,'Added to comparison table'),(3737,'Additional PayPal Business Account'),(3718,'Additional criteria to match for PayPal account verification'),(3650,'Additional settings'),(897,'Addons Marketplace'),(482,'Address'),(483,'Address book'),(484,'Address details'),(485,'Address field'),(486,'Address fields'),(3881,'Address for sales tax calculation'),(1847,'Address has been deleted'),(1842,'Address is not selected'),(4762,'Address line verification: X'),(3269,'Address masks'),(1843,'Address not found'),(487,'Address pattern'),(3270,'Address type'),(1841,'Address type has wrong value'),(4763,'Address zipcode verification: X'),(2573,'Address zone'),(3529,'Address zones (coupons)'),(4314,'Addresses'),(1780,'Addresses list is empty'),(3958,'Adds the sender’s signature and the date on CN22 and CP72 shipping labels. Enter the signature as a string. The Sender’s signature date is automatically populated.'),(488,'Admin'),(1322,'Admin has requested a change of password for your account. Please change the password before you proceed.'),(3342,'Admin panel'),(489,'Administration Zone'),(490,'Administrator'),(1534,'Administrator Zone'),(2437,'Administrator account cannot be deleted via customer interface.'),(2331,'Administrator header'),(4109,'Administrator notes'),(2332,'Administrator signature'),(2335,'Administrator subject'),(2336,'Administrator text'),(4020,'Advanced Options'),(2413,'Advanced Order Management'),(4570,'Advanced shipping settings'),(3593,'Advanced statistics with'),(2076,'After activation Skrill will give you access to a new section in your Skrill account called \"Merchant tools\". Please choose a secret word (do not use your password for this) and enter it into the merchant tools section and below.'),(1298,'After clicking this button, your hard/soft reset links will be regenerated. You need it in case old links were compromised.'),(1421,'After the problem has been fixed, try to connect again.'),(2764,'After the problem has been fixed, try to connect again.\', {\'clear_cache\': url(\'addons_list_marketplace'),(1506,'After the upgrade is completed please check your website. If you find that the site is inoperative, please try to do the following'),(1833,'Aggregation cache has been cleaned'),(4937,'Air service center'),(229,'All'),(665,'All Addresses (default zone)'),(346,'All Order Statuses'),(396,'All User Types'),(491,'All add-ons'),(2975,'All addons'),(2154,'All attributes'),(4628,'All classes from this category'),(4996,'All communication threads'),(1855,'All countries'),(492,'All customers'),(3973,'All dimensions must be greater than 0'),(2765,'All items'),(2195,'All items cannot be removed from the order.'),(2131,'All levels'),(394,'All membership levels'),(493,'All memberships'),(3824,'All newest products'),(4477,'All news'),(2135,'All orders'),(2120,'All payment statuses'),(2688,'All payment transaction statuses'),(495,'All products on sale'),(1779,'All rights reserved.'),(496,'All shipping methods'),(2121,'All shipping statuses'),(497,'All shipping zones'),(751,'All states'),(2405,'All statuses'),(494,'All the necessary adaptation will be done by the developer.'),(498,'All the products are in sufficient quantities'),(499,'All time'),(3825,'All upcoming products'),(2412,'All user types'),(4709,'All users'),(1785,'All words'),(4236,'Allow buyers to attach files to this product'),(4426,'Allow this product to be used as a MailChimp segment condition'),(4231,'Allowed file extensions: X'),(4631,'Alphabetical'),(501,'Alphabetically'),(1685,'Already added'),(1724,'Already exists'),(502,'Already have an account?'),(2680,'Also the system has detected problems with the following modules'),(2796,'Also, to manage your redirects you can define 301 redirects in .htaccess file.'),(3086,'Also, you can review X-Cart recommended hosting providers'),(89,'Alt'),(503,'Alternative payment methods'),(504,'Alternative text'),(277,'Alternatively, upload file sqldump.sql.php to the var/backup/ sub-directory click on the \"Restore from server\" button'),(4959,'Alternatives products you may be interested in'),(2766,'Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(3574,'Although you may find related products below.'),(2638,'Amazon'),(3434,'Amazon Order Ref ID'),(3447,'Amazon Pay was not able to process your payment.'),(3404,'Amazon Seller ID'),(3433,'Amazon callback URL help'),(3432,'Amazon could not process the transaction due to an internal processing error.'),(3431,'Amazon has rejected the authorisation.'),(3416,'AmazonRefresh'),(3417,'AmazonRefundRefresh'),(505,'Amount'),(506,'Amount: high to low'),(507,'Amount: low to high'),(1866,'An attempt to update settings of unknown payment method'),(3401,'An error occurred during the global attributes changing.'),(2358,'An error occurred while sending the request'),(3387,'An error occurred while transferring your store. Our engineers are already working on fixing it.'),(3397,'An error occurred while validating the domain name'),(2475,'An error occurred, please try again. If the problem persists, contact the administrator.'),(2476,'An error occurred, please try again. If the problem persists, contact the administrator. (txnNote)'),(1739,'An upgrade is a dangerous process that may result in a crashed website.'),(508,'An upgrade is a dangerous process that may result in a crashed website. It is strongly recommended to create a full back up of your shop (the code and the database) and download it to a local computer before proceeding to the next step.'),(5040,'Annually'),(1938,'Anonymous'),(2132,'Anonymous (access level)'),(201,'Anonymous Customer'),(202,'Anonymous Customer, _Registered User with the same email_'),(2022,'Anonymous Customers'),(4724,'Anonymous reviewer'),(3905,'Anonymous users only'),(3271,'Another bulk change in progress, please try again later'),(509,'Another state'),(110,'Any availability status'),(401,'Any category'),(113,'Any class'),(4352,'Any google group'),(510,'Any membership level'),(511,'Any product class'),(2554,'Any profile'),(4653,'Any rating'),(4296,'Any special needs?'),(402,'Any status'),(2178,'Any stock status'),(3904,'Any visitors'),(1786,'Any word'),(512,'Any zone'),(4191,'Anyland'),(4192,'Anytown'),(1339,'App Store update is available'),(2631,'App type'),(513,'Appearance'),(3802,'Applicable to stacked and single line logos only'),(3483,'Applied discount coupon'),(3117,'Apply attribute value changes for all the products'),(514,'Apply destination'),(3867,'Apply maximum discount'),(3868,'Apply minimum discount'),(515,'Apply price'),(3859,'Apply sale discount to wholesale prices'),(4215,'Apply sort and view settings for all products'),(2958,'Apply sorting globally'),(3272,'Apply to billing address'),(3115,'Apply unsharp mask filter on resize'),(1758,'Apply value changes globally'),(1757,'Apply value changes locally'),(3398,'Applying changes to global attributes'),(4669,'Approve'),(4660,'Approve review'),(4271,'Approved URL'),(516,'Are you sure you want to continue?'),(521,'Are you sure you want to delete the selected payment method?'),(517,'Are you sure you want to delete the selected user?'),(2655,'Are you sure you want to delete this filter?'),(1682,'Are you sure you want to delete this profile?'),(518,'Are you sure you want to disable this add-on?'),(2849,'Are you sure you want to enable https anyway?'),(519,'Are you sure you want to enable this add-on?'),(4913,'Are you sure you want to reset current layout? Custom layout settings will be lost.'),(4127,'Are you sure you want to transmit this shipment?'),(2400,'Are you sure you want to uninstall selected add-ons?'),(520,'Are you sure you want to uninstall this add-on?'),(4125,'Are you sure you want to void this shipment?'),(522,'Are you sure you wish to delete the selected zones?'),(523,'Are you sure?'),(524,'Arrival date'),(3580,'As a FedEx user, you are entitled to receive shipping refunds usually left unclaimed with default FedEx service ($2B/year globally)'),(4948,'As a UPS user, you are entitled to receive shipping refunds usually left unclaimed with default UPS service ($2B/year globally)'),(4179,'As a result of your latest order edit, previously created shipments for the order were dropped. Transmitted shipments (if any) remained unchanged. Visit the page X to manage shipments.'),(526,'Ask.com'),(2457,'Assign entered Clean URL to this page anyway'),(4368,'Assign shopping group'),(4359,'Assign your attributes to Google groups to import your variants.'),(527,'Assigned classes'),(525,'Asynchronous'),(4249,'Attach file'),(4234,'Attach files'),(4076,'Attached files'),(4232,'Attached files:'),(4244,'Attachment X is deleted'),(3584,'Attachment has been deleted successfully'),(528,'Attachment is not deleted'),(3535,'Attachment removed'),(529,'Attachments'),(530,'Attachments have been updated successfully'),(3083,'Attention!'),(3183,'Attention! You are creating an account with full access. Roles warning'),(1579,'Attribute'),(6,'Attribute data will be lost. warning text'),(1577,'Attribute group'),(1578,'Attribute groups'),(4369,'Attribute information has been successfully updated'),(1574,'Attribute name'),(1569,'Attribute option'),(4351,'Attribute type'),(3154,'Attribute value ID'),(1575,'Attribute values'),(3155,'Attribute values (select)'),(117,'Attributes'),(754,'Attributes block'),(316,'Attributes for X product class'),(1845,'Attributes have been successfully changed'),(1895,'Attributes have been updated successfully'),(1910,'Attributes imported'),(531,'Australia Post settings'),(2101,'Auth'),(3651,'Auth and Capture'),(3652,'Auth only'),(532,'Authentication'),(3777,'Authentication bypassed / unavailable liability shift'),(533,'Authentication code'),(4151,'Authentication options'),(534,'Author'),(2055,'Authorization and Capture'),(2056,'Authorization only'),(3418,'Authorization status: {{status}}'),(535,'Authorization then capture'),(4023,'AuthorizeNet accept.js instruction text'),(2725,'Authorize[TT]'),(348,'Authorized'),(1834,'Authorized amount'),(536,'Auto'),(4418,'Auto-Updated'),(2767,'Autogenerate'),(1683,'Autogenerate Clean URL'),(2074,'Autogenerated'),(2647,'Automate Shipping Refunds'),(4007,'Automate bidding to maximize sales for your marketing budget'),(2624,'Automate shipping'),(2626,'Automate your shipping process with the services of our partners: print shipping labels, grab shipping orders info from eBay, ETSY, Amazon and other marketplaces; integrate with several shipping carriers in one spot and more.'),(3630,'Automatically'),(537,'Availability'),(3557,'Available after purchase'),(3542,'Available for download'),(538,'Available for sale'),(2550,'Avalara provides our mutual customers with everything you need to calculate, file and remit sales tax for your business effortlessly by providing an integrated, end-to-end solution for every step of the tax compliance process.'),(2552,'Avalara.60 Day Free Trial'),(4685,'Average rating'),(2919,'Awaiting processing'),(539,'B'),(245,'BEGIN - END of TOTAL'),(1822,'Back'),(1789,'Back to Login form'),(2685,'Back to Trial mode'),(4867,'Back to Webmaster mode'),(753,'Back to Zones list'),(540,'Back to file select'),(541,'Back to layout settings'),(542,'Back to methods'),(1790,'Back to modules'),(4871,'Back to notification settings'),(2339,'Back to notifications list'),(543,'Back to order list'),(4695,'Back to product details'),(4056,'Back to products'),(4442,'Back to segments list'),(2601,'Back to shipping methods'),(4813,'Back to templates list'),(544,'Back to top'),(303,'Backend payment transaction X issued'),(2768,'Background export is in progress'),(3327,'Backordered'),(3328,'Backordered (qty: {{qty}})'),(545,'Backup'),(546,'Backup database'),(2033,'Backup your store with Backup Master'),(547,'Bank Account Number'),(908,'Bank name'),(3683,'Banner on Cart page'),(3681,'Banner on Category pages'),(3680,'Banner on Home page'),(3682,'Banner on Product details pages'),(3791,'Banner on product pages'),(3792,'Banner on the cart page'),(3793,'Banner on the checkout page'),(2707,'Banner rotation'),(3794,'Banner type'),(4687,'Based on'),(4708,'Be the first and leave a feedback.'),(1612,'Before editing attributes specific for the chosen type you should save the changes'),(2543,'Before enabling HTTPS protocol read this article:'),(2285,'Before installing a paid addon for this installation, you need to activate your X-Cart license.'),(3454,'Before you can start configure Australia Post module you should update available options from Australia Post. Please click button below.'),(548,'Benchmark completed in '),(549,'Benchmark result under 3000ms is considered good'),(550,'Bestsellers'),(2664,'Bill to'),(2891,'Billing'),(551,'Billing address'),(2087,'Billing address is not defined'),(552,'Billing address is not defined yet'),(1825,'Billing address is the same as Shipping'),(2895,'Billing to'),(553,'Bing'),(4567,'Bingo! You\'ve added carrier as a shipping carrier'),(3811,'Black (ppcm)'),(3569,'Block'),(4840,'Block is disabled'),(4839,'Block is enabled'),(2065,'Blocked'),(3541,'Blocked by administrator'),(3370,'Blocks'),(3817,'Blue (ppcm)'),(2879,'Body'),(4093,'Box maximum weight'),(554,'Brief description'),(555,'Brief descrption'),(4210,'Brief info'),(4216,'Brief info help'),(4592,'Browse Top Trending Tools'),(556,'Browse server'),(4017,'Build a campaign in a few minutes, and sell to customers as they search for your products on Google.'),(4054,'Bulk Edit processing in progress...'),(4046,'Bulk edit'),(4048,'Bulk edit all'),(4051,'Bulk edit has been processed successfully.'),(4052,'Bulk edit processing has been interrupted.'),(4053,'Bulk edit processing may take a while to complete. Please do not close this page until the process is fully completed.'),(4057,'Bulk edit selected'),(3273,'Business premium features'),(2208,'Buy'),(2492,'Buy Business Edition'),(557,'Buy more'),(2446,'Buy prolongation'),(1615,'Buyers can select an option'),(1799,'C.O.D. fee included'),(558,'CLOSE'),(2002,'CM'),(3945,'COD value'),(559,'CSS & JavaScript'),(2390,'CSV delimiter'),(2161,'CSV file has the wrong filename format.'),(3079,'CSV format tables'),(1982,'CSV or ZIP files, total max size: {{size}}'),(4761,'CVC verification: X'),(3274,'CVV / CVC'),(1810,'CVV2'),(2477,'Cache management'),(560,'Cache rebuild is already started, please wait'),(2480,'Calculate quick data'),(2481,'Calculate quick data help text'),(561,'Calculate rates'),(2483,'Calculating quick data...'),(425,'California'),(1812,'Call us: '),(3435,'Callback URL'),(4014,'Campaign Dashboard'),(3543,'Can be downloaded only after buying the product'),(2559,'Can be provided only for offline shipping methods.'),(2561,'Can be provided only for online shipping methods.'),(3662,'Can be set up later'),(3611,'Can not be disabled for products with manually defined PIN codes'),(562,'Can\'t be disabled. The module is required by:'),(563,'Can\'t connect to the Addons Marketplace server'),(4496,'Can\'t subscribe you right now. Try later'),(4066,'Canada Post module allows to use online shipping rates calculation via Canada Post'),(4104,'Canada Post settings'),(4134,'CanadaPost settings'),(138,'Cancel'),(3849,'Cancel sale'),(3852,'Cancel sale for all'),(350,'Canceled'),(2695,'Canceled[S]'),(2991,'Canceling'),(3391,'Cancellation request'),(4240,'Cannot attach the file. The maximum attached file size may not exceed X MB'),(4239,'Cannot attach the file. The number of attached files may not exceed X'),(4241,'Cannot attach the files. Total size of attached files may not exceed X MB'),(4461,'Cannot authenticate'),(1901,'Cannot autogenerate clean URL for the product name \"{{name}}\". Please specify it manually.'),(3366,'Cannot be disabled. The template is required by: {{moduleName}}'),(2963,'Cannot check the files for this module'),(2192,'Cannot create temporary order for modification'),(2344,'Cannot gather modules from the marketplace. Please try later.'),(4865,'Cannot get flexy content'),(3613,'Cannot remove a sold PIN code'),(282,'Cannot set X permissions for subdirectories:'),(2102,'Capture'),(3412,'Capture mode'),(2729,'Capture multiple[TT]'),(2728,'Capture partially[TT]'),(564,'Capture status'),(2727,'Capture[TT]'),(1835,'Captured amount'),(4117,'Card (hold) for pick up'),(2299,'Card number'),(2296,'Card type'),(1805,'Cardholder name'),(1173,'Carrier'),(2598,'Carrier service'),(2599,'Carrier service name'),(2597,'Carrier services'),(2563,'Carrier-calculated rates'),(1820,'Cart'),(565,'Cart & checkout'),(2175,'Cart contains products with wrong quantity'),(2174,'Cart contains products with wrong quantity. Please correct this to proceed'),(211,'Cart is empty'),(2070,'Cash on delivery'),(566,'Catalog'),(567,'Categories'),(4642,'Categories and tags'),(1911,'Categories imported'),(3001,'Categories processed'),(3004,'Categories processed: X out of Y'),(3003,'Categories processed: X out of Y with errors'),(3005,'Categories processed: {{count}}'),(568,'Category'),(4919,'Category description'),(79,'Category icon'),(3076,'Category id or path is required'),(569,'Category info'),(3337,'Category is not accessible'),(570,'Category name'),(571,'Category name contains invalid symbols'),(2763,'Category name should not be empty'),(572,'Category page title'),(573,'Category path contains invalid symbols'),(3078,'Category with id X not found, new category will be created'),(574,'Change'),(575,'Change address'),(1811,'Change attributes'),(4601,'Change domain name'),(3181,'Change fulfillment status for selected'),(576,'Change method'),(577,'Change options'),(1423,'Change password'),(578,'Change payment info'),(3180,'Change payment status for selected'),(580,'Change shipping'),(579,'Change shipping info'),(3275,'Change template'),(2196,'Changed items'),(2197,'Changed options'),(4831,'Changes may be incompatible with TinyMCE. Are you sure to proceed?'),(1755,'Changes of attributes globally'),(1756,'Changes of attributes locally'),(4896,'Changes were successfully saved'),(2210,'Character set'),(1737,'Check again'),(581,'Check all'),(4863,'Check directory permissions'),(2533,'Check for available free disk space has failed'),(2850,'Check for updates'),(582,'Check number'),(4311,'Check shipping info'),(3212,'Check the article how to check your emails'),(3214,'Check your email deliverability'),(583,'Checking'),(584,'Checking integrity, please wait...'),(215,'Checkout'),(4298,'Checkout type'),(585,'Choose'),(586,'Choose _payment methods_'),(2519,'Choose a new template'),(4312,'Choose another address'),(2298,'Choose card type'),(4630,'Choose classes...'),(587,'Choose file'),(588,'Choose from a variety of bundled payment solutions to accept credit cards and other methods of payment on your website'),(589,'Choose method'),(2897,'Choose shipping'),(590,'Choose shipping method'),(3795,'Choose text if you need a lightweight contextual message. Choose flex if you need a responsive banner'),(4600,'Choose the best way for customers to pay you.'),(1792,'Choose the product options first'),(2491,'Choose the right plan'),(4339,'Choose your location'),(1628,'Choosing \"URLs\" will link the exported data to your public files (product and category images, downloadable files shown on product pages, and so on) through direct URLs'),(2297,'Chose credit card type'),(591,'City'),(1435,'City masks'),(4374,'Class X'),(2155,'Classes & Attributes'),(1862,'Classes & attributes'),(4627,'Classes for product filter'),(592,'Clean URL'),(2770,'Clean URLs'),(646,'Clean URLs are disabled'),(644,'Clean URLs are disabled. More info'),(2769,'Clean URLs are disabled. More info\', {\'more_info_url\': url(\'settings\', \''),(645,'Clean URLs are enabled'),(648,'Clean URLs functionality may not be enabled. More info'),(598,'Clean aggregation cache'),(49,'Clean aggregation cache help text'),(599,'Clean widgets cache'),(50,'Clean widgets cache help text'),(600,'CleanURL'),(597,'Clean_urls_error_message'),(1530,'Cleanup'),(1527,'Cleanup queries'),(2915,'Clear all caches'),(2916,'Clear all caches text'),(1796,'Clear all fields'),(601,'Clear bag'),(3276,'Clear cache help text'),(33,'Clear cart'),(4607,'Clear list'),(108,'Clear search'),(4774,'Click Connect with Stripe to be redirected to Stripe.com'),(602,'Click here to access/add subcategories'),(3882,'Click here to specify tax rates that will apply only to shipping charges'),(4528,'Click here to upload product image'),(4540,'Click here to upload your logo. Recommended 221x40px (PNG, JPG or SVG)'),(603,'Click here to view states of country'),(1603,'Click if you do not want to add this value to new products or class’s assigns automatically'),(1604,'Click if you want to add this value to new products or class’s assigns automatically'),(4424,'Click rate'),(2209,'Click the link to increase product amount'),(3738,'Click this to access the PayPal sign-in page and sign in using your PayPal account different from the account specified above.'),(1648,'Click to add rates'),(1652,'Click to add states'),(1716,'Click to close'),(3586,'Click to edit'),(1655,'Click to edit all this label translations'),(1647,'Click to edit rates'),(1651,'Click to edit states'),(3110,'Click to expand menu'),(4308,'Click to finish your order'),(1715,'Click to open'),(4310,'Click to proceed to the next step'),(3335,'Click to select the date'),(4047,'Click to specify'),(604,'Click to unblock'),(179,'Clicking the Place order button you accept: Terms and Conditions'),(3409,'Client ID'),(3774,'Client Id'),(3775,'Client Secret'),(1561,'Clone'),(2983,'Clone selected'),(1560,'Clone this product'),(118,'Cloned products'),(357,'Close'),(4991,'Close dispute'),(605,'Close storefront'),(4512,'Close wizard'),(1946,'Closed'),(2632,'Cloud Service'),(2633,'Cloud Zoom'),(2634,'Cloud Zoom mode'),(2635,'Cloud Zoom mode Inside'),(2636,'Cloud Zoom mode Outside'),(4043,'CloudSearch sets default sort order to relevance'),(606,'Code'),(3740,'Color'),(3822,'Color scheme (ppcm)'),(2923,'Column X is required'),(3869,'Combine discounts'),(3826,'Coming soon'),(2386,'Coming soon (title)'),(3837,'Coming soon...'),(1708,'Comma'),(607,'Comment'),(608,'Comments'),(1998,'Commercial'),(4116,'Commercial - will return the contracted price between Canada Post and the contract holder'),(4152,'Common options'),(1189,'Common tax settings'),(2124,'Communication log'),(3727,'Communication problem'),(4998,'Communication threads with open disputes'),(4997,'Communication threads with unread messages'),(1932,'Compact view'),(609,'Company'),(610,'Company name'),(2086,'Compare'),(1813,'Compare products'),(1536,'Compare your result with other servers'),(4605,'Comparison table - X items'),(1727,'Complete'),(1826,'Complete billing address'),(611,'Completed'),(612,'Component'),(3019,'Config file'),(613,'Configuration'),(1643,'Configure'),(4892,'Configure Tag Manager'),(614,'Configure _shipping methods_'),(4150,'Configure manually'),(3595,'Configure the Google Analytics module'),(3566,'Configure your X-Cart installation to support large file downloads.'),(4548,'Configure your geographic settings to connect with local customers'),(615,'Configure your store'),(135,'Confirm deletion'),(616,'Confirm password'),(2498,'Confirmation'),(1725,'Confirmation does not match'),(157,'Congratulations! Your order has been placed successfully'),(3731,'Connect to PayPal'),(3788,'Connect with PayPal'),(4454,'Connect with your MailChimp account'),(3729,'Connected to PayPal; Merchant ID: {{merchantId}}'),(3789,'Connecting to PayPal with X-Cart installed on the local server is supported in manual mode only.'),(2797,'Connecting to the marketplace...'),(3150,'Consistency check'),(3159,'Consistency has not yet been checked. Initiate an consistency check by clicking the button \"Refresh consistency status\".'),(3184,'Contact Us page settings'),(4153,'Contact name for the manifest address'),(4580,'Contact our expert'),(4981,'Contact seller'),(3894,'Contact us'),(3096,'Contact us if you have any questions.'),(9,'Contact us trial notice'),(3565,'Contact your hosting provider to make sure X-Sendfile is installed on the server.'),(617,'Contacts'),(618,'Content'),(4336,'Content has script tags (Froala)'),(2326,'Content of this notification based on the body.twig template'),(3913,'Content page title'),(619,'Continue'),(1827,'Continue as guest'),(34,'Continue shopping'),(47,'Continue...'),(4154,'Contract ID'),(4155,'Contract shipping options'),(3962,'Convenience - Verify addresses and buy & print compliant USPS labels directly from the X-Cart application'),(5008,'Conversation'),(5010,'Conversation: X'),(5009,'Conversations'),(2712,'Convert failed transactions into real orders'),(4858,'Convert templates'),(90,'Copy'),(4767,'Copy Webhook URL and go to Account settings'),(620,'Copy file to local server'),(91,'Copy to clipboard'),(88,'Copy to file system'),(1695,'Core version'),(621,'Core version: '),(3978,'Could not add the discount because another discount already exists for the specified subtotal range, membership level, date range and shipping zones'),(3608,'Could not assign X PIN codes to order #Y.'),(2472,'Could not assign upgrade access level to your license keys'),(4593,'Could not save logo image'),(3979,'Could not update the discount because another discount already exists for the specified subtotal range, membership level, date range and shipping zones'),(2854,'Couldn\'t download the banner {{value}} from URL'),(2714,'Couldn\'t download the image {{value}} from URL'),(2040,'Couldn\'t move X images. See log for details.'),(2039,'Couldn\'t move image X'),(1525,'Count'),(5023,'Count days from the end'),(4115,'Counter - will return the regular price paid by retail consumers'),(622,'Countries'),(2307,'Countries information has been successfully updated'),(623,'Countries, states and zones'),(624,'Country'),(625,'Country is not selected'),(3411,'Country of Merchant account'),(3509,'Coupon'),(3517,'Coupon cannot be combined with other coupons'),(626,'Coupon code'),(3490,'Coupon discount'),(3505,'Coupon discount can be limited to customers with these membership levels'),(3504,'Coupon discount can be limited to these product classes'),(627,'Coupons'),(4156,'Coverage'),(628,'Create'),(630,'Create SQL file'),(4016,'Create a New Google Shopping Campaign'),(631,'Create a backup'),(632,'Create account'),(633,'Create an account for later use'),(634,'Create category'),(2430,'Create label'),(635,'Create new account'),(1979,'Create new items and update existing items'),(4482,'Create news message'),(4009,'Create perfect shopping campaigns in minutes'),(629,'Create profile'),(4070,'Create return'),(3959,'Create shipment'),(4566,'Create shipping rate'),(1308,'Create zone'),(636,'Created'),(4077,'Created on'),(1806,'Credit card number'),(2306,'Credit card security code (if present)'),(3757,'Credit or debit card (Visa, MasterCard, American Express, Discover, and so on)'),(3277,'Critical'),(1977,'Critical error'),(1509,'Critical errors have been detected in the files you are trying to import. Check the manual to correct the errors and try again.'),(1703,'Curl options'),(1702,'Curl version'),(637,'Currency'),(4157,'Currency rate'),(3919,'Current logo sizes: XхY px'),(3015,'Current password'),(2191,'Current price for the selected configuration and quantity: X'),(2512,'Current template'),(2075,'Custom'),(639,'Custom CSS'),(3128,'Custom CSS & JS'),(77,'Custom HTML title'),(640,'Custom JavaScript'),(638,'Custom addons'),(1987,'Custom attributes'),(641,'Custom images'),(1918,'Custom offline shipping'),(2564,'Custom table rates'),(642,'Custom translation'),(200,'Customer'),(2130,'Customer access level'),(3341,'Customer area'),(4938,'Customer counter'),(3256,'Customer email (if exist)'),(2329,'Customer header'),(2193,'Customer information'),(4671,'Customer name'),(199,'Customer note'),(4158,'Customer number'),(4696,'Customer reviews'),(2330,'Customer signature'),(2333,'Customer subject'),(2334,'Customer text'),(643,'Customer zip/postal code'),(1538,'Customer zone is closed for maintenance.'),(4245,'Customer`s attachments were changed'),(1907,'Customers'),(1908,'Customers imported'),(3827,'Customers who bought this product also bought'),(3828,'Customers who viewed this product bought'),(4898,'Customize storefront'),(3739,'Customize the PayPal button'),(4546,'Customize your store with Layout Editor option'),(376,'DECEMBER'),(2639,'DHL'),(2003,'DM'),(5024,'Daily'),(4939,'Daily Pickup'),(3323,'Dashboard'),(1510,'Data has not been found'),(650,'Data have been deleted successfully'),(651,'Data have been saved successfully'),(3278,'Data removal has been completed successfully.'),(3279,'Data removal has been stopped.'),(3280,'Database'),(652,'Database backup created successfully'),(1883,'Database restored successfully!'),(653,'Date'),(3281,'Date and time in the shop'),(3186,'Date and time in the store'),(3185,'Date and time on the server'),(1795,'Date range'),(388,'Date range should less than %d days'),(387,'Date range should longer than %d days'),(3500,'Date when customers can start using the coupon'),(3986,'Date when customers can start using the volume discount'),(3501,'Date when the coupon expires'),(3987,'Date when the volume discount expires'),(3829,'Date: newest first'),(3830,'Date: oldest first'),(654,'Day'),(356,'Days'),(655,'Dear'),(295,'Dear X'),(656,'Dear customer'),(657,'Decline'),(2738,'Decline[TT]'),(658,'Declined'),(4272,'Declined URL'),(659,'Default'),(1614,'Default attribute value'),(660,'Default customer address'),(1916,'Default for admins'),(661,'Default for customer zone and can not disabled or deleted'),(662,'Default for customer zone and cannot be disabled or deleted'),(1915,'Default for customers'),(2689,'Default image settings'),(663,'Default images settings'),(1571,'Default option'),(2788,'Default site meta description'),(2789,'Default site meta keywords'),(2787,'Default site title'),(114,'Default tax class'),(1613,'Default value'),(414,'Default zone tooltip text'),(1088,'Default-sort-option'),(3343,'Default: {{code}}'),(666,'Define classes'),(3752,'Delayed'),(137,'Delete'),(4533,'Delete Demo products'),(146,'Delete Language'),(667,'Delete SQL file'),(2436,'Delete account'),(668,'Delete all'),(1611,'Delete all files'),(4233,'Delete attachment'),(4906,'Delete custom file'),(2654,'Delete filter option'),(46,'Delete item'),(669,'Delete profile'),(670,'Delete selected'),(671,'Delete selected profile'),(1513,'Delete temporary files after the import is completed'),(672,'Delete the image'),(673,'Delete this address?'),(4071,'Deliver to Post Office'),(4159,'Deliver to Post Office options'),(37,'Delivery'),(4940,'Delivery confirmation - adult signature required'),(4941,'Delivery confirmation - no signature'),(4942,'Delivery confirmation - signature required'),(3938,'Delivery cost'),(3965,'Delivery date'),(4313,'Delivery method'),(674,'Delivery methods'),(2556,'Delivery time'),(4074,'Delivery to Post Office'),(259,'Depending on the size of your data file, importing may take some time.'),(2105,'Deploy'),(29,'Description'),(3346,'Description for customers'),(4539,'Design your online store to fit your brand'),(2048,'Destination address'),(675,'Destination zone'),(676,'Details'),(3282,'Developer'),(4584,'Developer docs'),(4160,'Developer mode'),(2988,'Developer wave'),(2376,'Developers docs'),(4608,'Differences only'),(3324,'Dimensions'),(4094,'Dimensions (cm)'),(677,'Directories and files permissions'),(337,'Directory X does not have permissions to write. Please set necessary permissions to directory X.'),(4149,'Directory X is not writable'),(1913,'Directory does not have permissions to write'),(1707,'Directory is empty'),(142,'Disable'),(3283,'Disable HTTPS'),(2982,'Disable all'),(678,'Disable all modules in the system'),(4925,'Disable block'),(4283,'Disable facebook product feed'),(4969,'Disable mutual links'),(2980,'Disable selected'),(679,'Disable suspicious modules'),(680,'Disabled'),(3027,'Disabled functions'),(1606,'Disabled in catalog'),(145,'Disabled language can not be set as default for customer zone'),(1900,'Disabled language cannot be default.'),(681,'Disabled language cannot be set as default for customer zone'),(2113,'Disabled modules hooks message body'),(2112,'Disabled modules hooks message head'),(2976,'Disabled only'),(775,'Disables all addons (core reset)'),(774,'Disables all addons except ones that are provided by X-Cart Team & Qualiteam (soft reset)'),(773,'Disables all addons except ones that are provided by X-Cart Team (hard reset)'),(1193,'Disables all modules except ones that were downloaded from marketplace (soft reset)'),(3331,'Discard'),(4835,'Discard changes'),(4772,'Disconnect'),(682,'Discount'),(683,'Discount amount'),(3363,'Discount cannot be more than 100%'),(684,'Discount type'),(3883,'Discounted subtotal'),(3884,'Discounted subtotal + Shipping cost'),(2575,'Discounted subtotal range'),(3125,'Discounts'),(3673,'Display \"Now Accepting PayPal\" badge'),(685,'Display \'inc/ex VAT\' labels next to prices'),(3872,'Display above categories list'),(4915,'Display all templates'),(3372,'Display as'),(1191,'Display common settings'),(3672,'Display the \"Buy Now with PayPal\" button'),(686,'Display type'),(3871,'Display under categories list'),(1924,'Displays the number of labels translated to the language'),(5002,'Dispute'),(4989,'Dispute closed by X'),(4999,'Dispute is open X by Y'),(4988,'Dispute opened by X'),(5007,'Disputes'),(687,'Do not close this page!'),(3870,'Do not display'),(1744,'Do not replace selected files and ignore their newer versions'),(4119,'Do not safe drop'),(2138,'Do not see your payment method? Find it on our Marketplace'),(2798,'Do not see your payment method? Find it on our Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(2177,'Do not select anything if you want to make the product visible to all customers.'),(688,'Do not show at startup anymore'),(4629,'Do not show the filter'),(1512,'Do not verify images to increase speed of the process'),(4555,'Do you need to ship your products?'),(2616,'Do you really want to close storefront?'),(4970,'Do you really want to delete all relations from this product?'),(689,'Do you really want to delete selected items?'),(3068,'DocBlocks support'),(4095,'Document'),(4078,'Documents'),(2673,'Does not match license type (requires {{list}} edition)'),(3379,'Domain name'),(3380,'Domain name transfer'),(3694,'Don\'t have account yet?'),(4753,'Don\'t have account yet? Sign up for SagePay now!'),(4781,'Don\'t have an account?'),(3839,'Don\'t label'),(4535,'Done! We ve just deleted all your demo products'),(690,'Dont have account yet?'),(3463,'Dont have an account? Sign Up Now'),(2032,'Don’t forget to create a backup!'),(3349,'Don’t lose any more sales that are coming to your website. LiveChat gives you an opportunity to engage in real-time conversations and convert more visitors before they leave. Create a LiveChat account here.'),(2205,'Don’t notify customer'),(1717,'Double quote'),(3284,'Download'),(1983,'Download CSV files'),(691,'Download SQL file'),(1629,'Download all files'),(2723,'Download error file'),(3547,'Download link did not found'),(3545,'Download link is blocked'),(3548,'Download link is not active'),(3549,'Download link is renew'),(3546,'Download links is blocked'),(3550,'Download links is renew'),(692,'Downloaded components'),(693,'Downloading updates'),(694,'Downloading updates, please wait...'),(3538,'Downloads left'),(695,'Drag and drop me to the bag'),(4879,'Drag-n-drop blocks'),(1511,'Drop existing items before import'),(696,'Drop items here to shop'),(697,'Drupal frontend'),(315,'Duplicated clean URL: X'),(4218,'Duplicated link'),(264,'During the import was recorded X errors. You can get them by downloading the log files.'),(2880,'Dynamic message'),(4833,'Dynamic message editor'),(4450,'E-Commerce features setup'),(1814,'E-Mail'),(3659,'E-Mail address to receive PayPal payment'),(3552,'E-goods'),(698,'E-mail'),(699,'E-mail is not defined yet'),(2903,'E-mail will also be updated in all the related orders.'),(3711,'EACHRECEIVER'),(3758,'ELV/SEPA'),(2640,'ETSY'),(5021,'Each'),(3963,'Easy payment options - Ship Now Pay Later with a Pitney Bowes Line of Credit or use a credit card.'),(1650,'Edit'),(4212,'Edit Globally'),(4928,'Edit Text'),(4302,'Edit address'),(4972,'Edit all'),(1686,'Edit attribute'),(1602,'Edit attribute values'),(1544,'Edit attributes'),(4316,'Edit billing address'),(700,'Edit charges for:'),(2515,'Edit custom options'),(4303,'Edit email'),(147,'Edit label'),(148,'Edit labels'),(404,'Edit labels (X)'),(4921,'Edit notification body'),(702,'Edit page'),(701,'Edit payment method data'),(1645,'Edit product'),(703,'Edit profile'),(420,'Edit rates (X)'),(4659,'Edit review'),(4317,'Edit shipping address'),(409,'Edit states (X)'),(342,'Edit subcategories (X)'),(4872,'Edit template based on'),(4677,'Edit your review'),(4810,'Edited templates'),(305,'Editing attribute groups on this page won\'t affect other product classes which use these groups'),(3555,'Egoods free'),(3554,'Egoods paid'),(704,'Email'),(705,'Email &amp; password'),(3473,'Email Address'),(218,'Email address'),(2024,'Email again'),(706,'Email body'),(3255,'Email from the contact information section according to the type of email message'),(2324,'Email notifications'),(4490,'Email or login'),(3358,'Email sent to the admin'),(3356,'Email sent to the customer'),(707,'Email settings'),(3203,'Email transfer settings'),(2029,'Empty \"class\" parameter is passed to the {{method}}'),(143,'Enable'),(4161,'Enable \"Deliver to Post Office\" feature'),(4290,'Enable Advanced Matching'),(708,'Enable HTTPS'),(2981,'Enable all'),(593,'Enable clean URL'),(647,'Enable clean URLs'),(4282,'Enable facebook product feed'),(4912,'Enable hidden block'),(3285,'Enable module'),(4968,'Enable mutual links'),(2979,'Enable selected'),(4270,'Enable the Use Enhanced Cancel option.'),(2455,'Enable the option \"Assign entered Clean URL to this page anyway\" to dissociate the entered Clean URL from the page it is currently used for and assign it to the page of the object being edited.'),(2892,'Enable this if you would like us to use your shipping address as your billing address'),(709,'Enabled'),(2327,'Enabled for administrator'),(2328,'Enabled for customer'),(1605,'Enabled in catalog'),(2977,'Enabled only'),(4875,'Enter Order number'),(4122,'Enter Return # or Order #'),(714,'Enter X more characters to start search'),(182,'Enter a correct email'),(2454,'Enter a different Clean URL value for this page'),(2858,'Enter a keyword to search.'),(4743,'Enter a name to be published with the review'),(187,'Enter a negative number'),(184,'Enter a number'),(186,'Enter a positive number'),(3334,'Enter alt text'),(183,'Enter an integer'),(3508,'Enter code'),(710,'Enter coupon code'),(347,'Enter date range'),(3641,'Enter description of the purchase that will be displayed on PayPal payment page.'),(4491,'Enter email address'),(4225,'Enter file extensions separated by comma; for example, \"jpg,txt,svg\"'),(2653,'Enter filter name'),(393,'Enter keyword'),(711,'Enter keywords'),(712,'Enter license key'),(1960,'Enter pattern here'),(4527,'Enter product name'),(2799,'Enter product name or SKU'),(1963,'Enter search pattern'),(713,'Enter shipping address'),(3640,'Enter the email address associated with your PayPal account.'),(1798,'Enter the shipping address to see delivery methods available to you'),(2418,'Enter tracking number'),(4457,'Enter your MailChimp API key manually'),(1828,'Enter your e-mail'),(17,'Enter your license key here'),(3094,'Enter your premium license key'),(4847,'Entity was successfully saved'),(715,'Environment'),(716,'Environment info'),(717,'Error'),(594,'Error code explanation:'),(2855,'Error of banner loading. Make sure the \"images\" directory has write permissions.'),(2254,'Error of image loading. Make sure the \"images\" directory has write permissions.'),(2715,'Error of image verification ({{value}}). Make sure you have specified the correct image file or URL.'),(1879,'Error of uploading file.'),(4848,'Error on saving image'),(4849,'Error on saving video'),(3286,'Error sending link'),(2721,'Errors'),(2968,'Errors files'),(3966,'Estimate delivery date'),(718,'Estimate shipping cost'),(719,'Estimate your server performance'),(720,'Estimated for'),(23,'Evaluation notice'),(5022,'Every'),(2795,'Every object stores history with 8 clean urls which were previously used for this object.'),(721,'Everything you need'),(4550,'Ex.'),(1784,'Exact phrase'),(722,'Example'),(424,'Example city'),(723,'Examples'),(4578,'Excellent! Storefront is ready to get orders!'),(724,'Exception'),(4330,'Exclude from shipping cost calculation'),(2553,'Existing Avalara Customer?'),(1800,'Existing Customer?'),(4841,'Exit editor'),(4828,'Exit product preview'),(2445,'Exp. date'),(725,'Expand the functionality of your store by installing and using add-on modules'),(4931,'Expand the toolbar below to personalize store layout and style. Click the icon below to exit Store Configuration Mode at any time.'),(1933,'Expanded view'),(3836,'Expected on'),(3843,'Expected on X'),(1808,'Expiration date'),(351,'Expired'),(3539,'Expired by TTL'),(3537,'Expired by limit'),(3540,'Expires in'),(726,'Export'),(2800,'Export all'),(1637,'Export cannot be started because it is disabled or there is another running export process'),(1631,'Export completed'),(4362,'Export duplicates as separate products'),(1635,'Export failed'),(1638,'Export in CSV'),(1636,'Export not started'),(4501,'Export of Not Finished orders is not supported. To export the orders which are now in this state, change their fulfillment status from Not Finished to any other.'),(4363,'Export only the original product'),(2620,'Export orders'),(2152,'Export product data with'),(727,'Export products'),(1625,'Export public files as'),(2801,'Export selected'),(1624,'Export settings'),(1630,'Exported files'),(336,'Exported in X'),(1632,'Exporting data...'),(3760,'Express Checkout process stopped.'),(728,'Extensions'),(366,'FEBRUARY'),(362,'FR'),(4319,'FREE'),(4321,'FREE SHIPPING'),(2521,'FREE quote'),(2629,'FREE trial'),(729,'Facebook'),(4273,'Facebook Ads & Instagram Ads'),(4278,'Facebook Pixel Id'),(4284,'Facebook product feed enabled'),(730,'Failed'),(731,'Failed to add detailed image'),(732,'Failed to add the attachment'),(733,'Failed to add the attachment. The file download is forbidden'),(2256,'Failed to load the banner {{value}} because it does not exist'),(2255,'Failed to load the file {{value}} because it does not exist'),(3583,'Failed to re-upload attachment'),(1891,'Failed to update category image'),(3899,'Failed to update page image'),(1912,'Failed write to file'),(338,'Failed write to file X. There may not be enough disc-space. Please check if there is enough disc-space.'),(734,'Failed/Declined'),(2694,'Failed[S]'),(1738,'Failure'),(1804,'Failure reason:'),(3359,'Failure sending email to the admin'),(3357,'Failure sending email to the customer'),(4874,'Failure sending test email to X'),(4866,'Failure to convert flexy-template. Check for syntax errors'),(4162,'Failure to finish registration process.'),(4163,'Failure to get token ID.'),(1590,'Failure: File has the wrong format.'),(4297,'Fast Lane checkout'),(3896,'Favicon'),(1672,'Fax'),(3576,'Featured'),(735,'Featured products'),(2641,'FedEx'),(3577,'FedEx module allows to use online shipping rates calculation via FedEx.'),(4357,'Feed generation & settings'),(4360,'Feed generation has been completed successfully.'),(4361,'Feed generation has been stopped.'),(4356,'Feed generation...'),(3761,'Fees payer'),(736,'Field is required!'),(4246,'File Attaching is mandatory for this product'),(4242,'File attachments are not allowed for this product'),(2744,'File can not be uploaded'),(3585,'File description'),(3562,'File is available by public URL'),(2428,'File is not an image'),(2429,'File is not uploaded'),(4918,'File name is too long, it should be less than 255 characters'),(1871,'File not found'),(3044,'File permissions'),(284,'File size exceeds the maximum size'),(737,'File title'),(3287,'File uploading'),(3187,'File uploading error 1'),(3188,'File uploading error 2'),(3189,'File uploading error 3'),(3190,'File uploading error 4'),(3191,'File uploading error 6'),(3192,'File uploading error 7'),(3193,'File uploading error 8'),(3034,'File uploads'),(4243,'File uploads forbidden by web server'),(2802,'File was successfully uploaded'),(4395,'File with certificate should be located in the directory {{certsDir}}'),(2607,'Files cannot be updated'),(4775,'Fill out the form with your Company info to setup your account and start processing payments immedately'),(4411,'Filter by order amount'),(4409,'Filter by order frequency'),(4413,'Filter by profile membership'),(4414,'Filter by specific products'),(2657,'Filter has been removed'),(2656,'Filter has been successfully saved'),(2490,'Filter transactions by status'),(4039,'Filters'),(1961,'Find countries'),(2139,'Find in Marketplace'),(1282,'Find language in marketplace'),(4006,'Find more customers on Google'),(1962,'Find states'),(2488,'Find transactions by ID'),(738,'Find us on'),(739,'Find us on Facebook'),(4589,'Find your payment method'),(3288,'Finish'),(5033,'Finished'),(2549,'Finished operating as user'),(740,'First name'),(4441,'First name or last name are empty. Please add a new address to your address book or modify existing and fill in those fields in order to subscribe to this list.'),(4742,'First name, Last name or E-mail'),(2906,'First, restore your website from the created backup - this is the fastest way to get your store back online.'),(4801,'Firstly, you have to connect to Stripe <a href=\"{{admin_link}}\" target=\"_blank\">here</a>'),(4299,'Firstname'),(741,'Flat markup'),(2593,'Flat shipping charge per item ordered.'),(2595,'Flat shipping charge per weight unit ordered (for example, per pound or per kilogram - depending on the weight units used by your store).'),(2592,'Flat shipping charge. This value will be added to the shipping rate regardless of the weight, price and number of items ordered.'),(3804,'Flex (ppcm)'),(4861,'Flexy templates have been removed'),(4853,'Flexy to twig converter'),(4854,'Flexy-template'),(4868,'Flexy-to-twig converter warning'),(742,'Footer menu'),(2027,'For any emergency you can use the hard, soft and restore-state links'),(1693,'For details refer to'),(7,'For details refer to X-Cart license'),(743,'For the period'),(2109,'Force customer to choose product options before the product can be added to cart'),(1782,'Forgot password'),(744,'Forgot password?'),(1542,'Forgot your password?'),(745,'Format'),(2305,'Four-digit number on the front side of your card'),(42,'Free'),(3219,'Free & paid'),(746,'Free add-ons'),(2169,'Free license is activated successfully'),(4320,'Free shipping'),(4323,'Free shipping tooltip text'),(4335,'Free shipping update import text'),(4334,'Free shipping update text'),(4329,'Freight'),(4280,'Frequency of Product Feed renewal'),(4337,'Froala Editor settings'),(747,'From'),(85,'From computer'),(755,'From email'),(1831,'Front page'),(2778,'Front page title'),(3474,'Full Name'),(756,'Full description'),(757,'Full name'),(3755,'Funding methods (checkout page)'),(2016,'G'),(3054,'GDlib extension'),(758,'General'),(759,'General Settings'),(760,'General info'),(2782,'General options'),(761,'General settings'),(3885,'General tax rates'),(4355,'Generate Google Feed'),(4370,'Generate Google Product feed'),(4276,'Generate Product Feed'),(3994,'Generate XML-Sitemap'),(4621,'Generate cache on the fly'),(4348,'Generate feed'),(4287,'Generate product feed'),(2370,'Generate resized images'),(2371,'Generate resized images help text'),(3993,'Generate sitemap'),(4554,'Geo settings & company info are all set. Congrats!'),(4343,'Geolocation header promo'),(1597,'Get CSV'),(4010,'Get Started'),(3977,'Get X off for order amount over Y'),(2743,'Get a more customizeable PDF invoice solution for your store'),(2740,'Get a more powerful banner system for your store'),(2736,'Get information[TT]'),(4635,'Get params'),(2565,'Get shipping rates from major shipping carrier companies.'),(3964,'Get started Now! Click here to create your PITNEY BOWES Postage Account'),(4003,'Get your products found on Google in a few steps. Click the \"%s\" button to get started!'),(3967,'Girth'),(762,'Give buyers a way to pay by adding an alternative payment method.'),(763,'Give buyers another way to pay by adding an alternative payment method'),(1888,'Global'),(2153,'Global & Classes attributes'),(4376,'Global Hidden field'),(4375,'Global Plain field'),(4377,'Global Textarea'),(4378,'Global Yes/No'),(1887,'Global attributes'),(3544,'Global eGood settings'),(4213,'Global product tabs'),(4219,'Global tab label'),(4217,'Global tab not found'),(4579,'Go on, make your first sale.'),(764,'Go to Marketplace'),(765,'Go to checkout'),(25,'Go to checkout as a New customer'),(4182,'Go to comparison table'),(4883,'Go to different page to edit the content'),(1269,'Go to home page'),(4728,'Go to see the review [in the Admin area]'),(4541,'Go to the next step'),(3339,'Good password'),(4002,'Google Ads'),(3594,'Google Analytics'),(4347,'Google Feed URL: X'),(4354,'Google Feed has not been generated yet'),(4358,'Google Shopping Group'),(4371,'Google feed'),(4365,'Google product feed'),(4353,'Google shopping group'),(40,'Grand total'),(3819,'Gray (ppcm)'),(3814,'Grayscale (ppcm)'),(2874,'Greeting'),(172,'Greetings, X'),(766,'Grid'),(767,'Group options'),(2271,'Group {{value}} does not exists and will be created'),(4449,'Groups'),(4263,'HPP Key'),(769,'HTML title (\'title\' tag)'),(3060,'HTTPS bouncers'),(770,'HTTPS check'),(1903,'HTTPS option has been disabled'),(1902,'HTTPS option has been successfully enabled'),(771,'HTTPS settings'),(2560,'Handling fee'),(1769,'Hard reset (disables all modules and runs application)'),(2909,'Hard reset. Disable all addons except those provided by X-Cart Team'),(4634,'Hash'),(2461,'Hash file for installed entry \"{{entry}}\" doesn\'t exist or is not readable'),(3787,'Have a PayPal account?'),(776,'Have a discount coupon?'),(3482,'Have more coupons?'),(2627,'Haven\'t found what you\'re looking for? View more shipping modules'),(2875,'Header'),(2873,'Header, greeting & signature'),(2052,'Height'),(777,'Height (px)'),(228,'Hello, user'),(102,'Help'),(778,'Help zone'),(779,'Here are shown only the methods enabled on the configuration page'),(768,'Here is a new link for access to your information: X'),(4542,'Here is the way it looks like on desktop & mobile devices. Do you like it?'),(4564,'Here you can add a flat-rate shipping method'),(780,'Here you can define how your payment methods will look in customer area'),(1547,'Here you can define how your payment methods will look in customer area.'),(4561,'Here you can manually define your shipping rates and etc.'),(2587,'Here you can provide general information about the shipping method and configure a table defining how shipping rates for this method should be calculated.'),(4448,'Here you can view and manage the MailChimp news lists and groups of the user.'),(4983,'Hidden X messages'),(1927,'Hidden attributes'),(1928,'Hidden field'),(4625,'Hidden from products filter'),(781,'Hide'),(4780,'Hide \"How to use\" instruction'),(2720,'Hide all warnings/errors'),(2803,'Hide and make them available only via a direct link'),(1190,'Hide common settings'),(4916,'Hide converted templates'),(4984,'Hide message history'),(3950,'Hide the carrier shipping charge on the label'),(3949,'Hide total carrier charge'),(782,'Hide trailing zeros in fractional part'),(5006,'Hide vendor’s products in the order'),(4184,'High - Low'),(4880,'Highlight labels'),(783,'History'),(3559,'History of downloads'),(784,'Home'),(4901,'Home page'),(2790,'Home page title and meta'),(3289,'Hot addons'),(2531,'How do I move X-Cart?'),(4692,'How do you rate this item?'),(785,'How to'),(786,'How to back up your store database'),(2588,'How to define shipping rates'),(787,'How to define shipping zones'),(3080,'How to set up free shipping help'),(2458,'Human readable and SEO friendly web address for the page.'),(178,'I accept Terms and Conditions'),(788,'I agree that these addons may require an adaptation.'),(3678,'I agree with PayPal terms & conditions'),(2294,'I confirm that I have created backups of my store\'s files and database before upgrading the store'),(3093,'I have a license key'),(4558,'I sell digital goods or services and do not need to set up shipping'),(2114,'I understand that the following disabled modules will be removed.'),(4532,'I\'ll do it later'),(4462,'ID'),(4646,'IMPORTANT:'),(2004,'IN'),(3657,'IPN HTTP error'),(3656,'IPN verification failed'),(789,'Icons'),(790,'Identity'),(3215,'If a category has subcategories, the value in brackets shows the overall number of products in both that category and all its subcategories.'),(3362,'If anything crops up, just rollback or contact our support team - they know how to fix it right away.'),(3262,'If the category is disabled, the system will return 404.'),(3260,'If the product is not available for sale, the system will return 404 response.'),(3261,'If the product is not available for sale, the system will return 404.'),(791,'If there are some critical errors occurred you can do the following'),(3385,'If you are planning to use an email hosting service for this domain, please send us your MX and TXT records to helpdesk@x-cart.com so that we could add the necessary DNS entries.'),(792,'If you choose the second option, you can download the file from the server later on and delete it from the server by clicking on the \'Delete SQL file\' button.'),(1555,'If you choose to create SQL file, you will be able to download the file from the server later and after that delete it from the server by clicking on the \"Delete SQL file\" button.'),(1268,'If you continue having trouble finding what you are looking for please contact our customer service department.'),(793,'If you do not have an account, you can easily'),(3405,'If you do not have seller account, you can register here: USA UK Germany'),(794,'If you don\'t have a moneybookers account yet, please sign up for a free moneybookers account at: http://www.skrill.com'),(795,'If you have a license key for a commercial module, you can enter it here to register the purchase of the appropriate module.'),(796,'If you have a plugin in the .tar format, you can install it by uploading it here'),(1568,'If you have multiple products sharing the same set of attributes, it makes sence to make them to be of the same product type and create the attributes on the product type level.'),(3395,'If you need help with the nameservers settings just drop us a line to helpdesk@x-cart.com, we\'ll help you fix it.'),(2518,'If you purchased a template but do not see it here, activate the license key that was provided to you.'),(2910,'If you still need help, please, feel free to contact X-Cart Help Desk at helpdesk@x-cart.com.'),(293,'If you store product images in the database, they are included in the SQL dump file'),(3518,'If you want the coupon discount to be applied only to products from specific categories, specify these categories here.'),(3861,'If you want the sale discount to be applied only to products from specific categories, specify these categories here.'),(4107,'If you want to enable merchant registration wizard once again, please click on the following link'),(1553,'If you want to upload the backup of another X-Cart installation, ensure that you have completed the steps described here'),(2031,'If your store is crashed after upgrade, you can recover it'),(2804,'Ignore membership'),(797,'Image'),(190,'Image X'),(798,'Image border will not be displayed in customer\'s frontend'),(799,'Image has been identified as a duplicate and has not been imported'),(3114,'Image quality after resize'),(2146,'Image resized: X out of Y'),(2150,'Image resized: X out of Y with errors'),(3136,'Image resizing requires libraries'),(115,'Images'),(116,'Images Settings & Uploading'),(2368,'Images resized'),(2384,'Images resized: {{count}}'),(3753,'Immediate'),(3436,'Immediate Charge'),(800,'Import'),(801,'Import / Export'),(3222,'Import and Export'),(1522,'Import by CSV'),(3635,'Import from CSV file'),(802,'Import from file'),(2151,'Import has been cancelled.'),(2432,'Import language'),(1964,'Import language from CSV file'),(260,'Import mechanism does not know the field of X and it can not be imported'),(1978,'Import mode'),(1981,'Import mode comment'),(2805,'Import results'),(1514,'Import settings'),(803,'Import/Export'),(2392,'Import/Export guide'),(804,'Important'),(4333,'Important info on the Free shipping addon update'),(2362,'Imported'),(2363,'Importing data...'),(257,'Importing will overwrite the existing product information. This operation cannot be undone.'),(2284,'In advanced mode you can choose specific modules for upgrade.'),(3840,'In catalog only'),(805,'In category'),(1548,'In order to accept credit cards payments you should install the necessary payment module from our Marketplace.'),(2690,'In progress[S]'),(806,'In stock'),(4620,'In stock only'),(4080,'In store currency (0 - do not use coverage)'),(4770,'In the form that opens, paste the \"Webhook URL\" value into the field \"URL to be called\" and click \"Add endpoint\".'),(4769,'In the section \"Endpoints receiving events from your account\", click \"+ Add endpoint\".'),(2460,'In this section you can review the recent payment transactions that have taken place at your store'),(807,'Inactive'),(2672,'Inactive license key ({{key}})'),(808,'Incl. X'),(4288,'Include out of stock products into feed'),(3846,'Include response in hash'),(250,'Including X'),(1583,'Including subcategories'),(1726,'Incomplete'),(809,'Incompleted'),(2752,'Incorrect amount'),(281,'Incorrect owner of X directory'),(283,'Incorrect owner of X file'),(2497,'Incorrect password. Please try again.'),(2751,'Incorrect permissions'),(4004,'Increase sales and revenue with Google Shopping Ads.'),(3886,'Individual settings for every rate'),(2806,'Info'),(4757,'Information'),(2691,'Initialized[S]'),(2807,'Initializing...'),(4882,'Inline editor'),(4830,'Inline editor is unavailable due to TinyMCE'),(3798,'Inline logo'),(810,'InnoDB engine support enabled'),(2125,'Input data'),(3348,'Insight: Boost your sales with Google Ads addon'),(811,'Install'),(4893,'Install Google Tag Manager'),(4456,'Install Mailchimp addon'),(3176,'Install TaxJar integration'),(812,'Install add-on'),(1966,'Install addons'),(2851,'Install anyway'),(813,'Install updates'),(2434,'Installation date'),(814,'Installation directory'),(3290,'Installation requirements'),(3017,'Installation script'),(2538,'Installation warnings'),(815,'Installed'),(3218,'Installed Addons'),(816,'Installed Modules'),(817,'Installed modules'),(1663,'Installed version'),(3182,'Installing addons'),(818,'Installing updates, please wait...'),(3946,'Insurance value'),(2625,'Integration with'),(2959,'Integrity check'),(2970,'Integrity check has been completed successfully.'),(2971,'Integrity check has been stopped.'),(2969,'Integrity has not yet been checked. Initiate an integrity check by clicking the button \"Refresh integrity status\".'),(595,'Internal server error'),(4587,'International: phone'),(819,'Invalid login or password'),(820,'Invalid login or password. You can use forgot password form to create a new password.'),(4049,'Inventory'),(1904,'Inventory has been successfully updated'),(821,'Inventory status'),(822,'Inventory tracking'),(3628,'Inventory tracking for product X will not be imported'),(823,'Inventory tracking for this product is'),(2808,'Inventory tracking is'),(2176,'Inventory tracking options'),(824,'Invoice'),(1840,'Invoice #{{orderId}}, {{time}}'),(207,'Invoice X'),(2057,'Invoice number prefix'),(3570,'Ip'),(3943,'Irregular parcel girth'),(1809,'Issue no'),(825,'It is impossible to delete or create user accounts because your store currently works as an integration with Drupal and shares users with Drupal. Deleting/creating user accounts is possible via Drupal administrator interface.'),(826,'It is impossible to edit some user profile fields because your store currently works as an integration with Drupal and shares users with Drupal. Modifying these fields is possible via Drupal administrator interface.'),(5062,'It will be charged on X'),(1502,'It\'s impossible to detect valid SSL certificate availability on your server because curl extension is not installed.'),(3460,'It\'s recommended to limit the length of invoice prefix to 9 characters'),(1934,'Item'),(827,'Item description'),(828,'Item has been deleted from cart'),(1850,'Item has not been deleted from cart'),(2861,'Item list'),(829,'Item name'),(2225,'Item not found ({{keys}})'),(213,'Items'),(160,'Items in your cart: X'),(830,'Items per page'),(2577,'Items range'),(365,'JANUARY'),(371,'JULY'),(370,'JUNE'),(4193,'Joe'),(831,'Join forces with your bank'),(480,'Joined'),(2953,'Just enter email address'),(832,'K'),(2015,'KG'),(4008,'Keep your marketing and store in sync'),(1477,'Key is validated, but the module X was not found'),(103,'Knowledge Base'),(4583,'Knowledge base'),(2013,'LB'),(1925,'Label'),(3947,'Label format'),(133,'Label name'),(3948,'Label size'),(1917,'Labels'),(4834,'Labels editor'),(833,'Language'),(834,'Language labels'),(140,'Language name in X'),(97,'Language options'),(1586,'Language:'),(101,'Languages'),(3810,'Large (ppcm)'),(1750,'Last 24 hours'),(1751,'Last 7 days'),(162,'Last added items'),(3077,'Last element of category path should be same as name'),(3347,'Last exported'),(835,'Last logged in'),(836,'Last login'),(1752,'Last month'),(837,'Last name'),(2304,'Last three numbers on the back side of your card'),(2900,'Last time re-deployed at'),(2464,'Last week'),(2466,'Last year'),(4300,'Lastname'),(3451,'Launch'),(4577,'Launch (Paypal Onboarding)'),(4011,'Launch Google Shopping ads and get your products found online easily.'),(3676,'Launch PayPal'),(2213,'Layout'),(3823,'Layout (ppcm)'),(4881,'Layout block'),(4832,'Layout editor'),(4844,'Layout editor allows you to change the position of the blocks in drag-n-drop fashion'),(4836,'Layout editor is'),(4843,'Layout editor is disabled'),(4842,'Layout editor is enabled'),(2522,'Layout has been changed. Review the updated storefront.'),(2514,'Layout type'),(4894,'Layout was successfully reset'),(2313,'Learn More'),(4890,'Learn more about Google Tag Manager'),(81,'Learn more about the top banner and how it shows in the page layout'),(2314,'Learn more.'),(4118,'Leave at door'),(2511,'Leave blank to use category name as Page Title.'),(4485,'Leave blank to use news title as Page Title.'),(3914,'Leave blank to use page name as Page Title.'),(2499,'Leave blank to use product name as Page Title.'),(3805,'Left (ppcm)'),(3333,'Left in stock: {{quantity}}'),(2050,'Length'),(1572,'Length x Width x Height'),(1787,'Less search options'),(3173,'Let TaxJar automate your sales tax calculations, reporting, and filings in minutes.'),(4943,'Letter center'),(4516,'Let’s set up your store'),(8,'License activation is not available'),(1483,'License is not received'),(2444,'License key'),(2440,'License key has been successfully verified and activated for \"{{name}}\" module by \"{{author}}\" author.'),(838,'License key has been successfully verified for \"{{name}}\" module by \"{{author}}\" author'),(2675,'License key is missing'),(3097,'License key registration'),(2671,'License warning'),(3291,'License warnings'),(2433,'License: trial version'),(839,'Lifetime'),(3495,'Limit number of uses'),(840,'Limit the number of uses'),(2143,'Lines checked: X out of Y'),(2144,'Lines imported: X out of Y'),(2148,'Lines imported: X out of Y with errors'),(2147,'Lines verified: X out of Y with errors'),(841,'Link'),(842,'List'),(843,'List of states'),(4421,'List rating'),(3858,'List sale products in a separate section'),(1993,'Live'),(2082,'Live mode'),(2859,'Loading more results...'),(1882,'Loading the database from file .'),(844,'Loading...'),(845,'Localization'),(4344,'Location is invalid'),(4341,'Location was successfully set'),(2090,'Locked'),(4164,'Log all communications between shopping cart and Canada Post server'),(2424,'Log files not found'),(846,'Log in'),(2742,'Log in as this admin'),(240,'Log off'),(847,'Log out'),(848,'Logged as'),(3906,'Logged in users only'),(239,'Logged in!'),(849,'Login'),(1801,'Login Here'),(2427,'Login dates'),(850,'Login here'),(851,'Login history'),(2809,'Login is locked out'),(2954,'Login to your account'),(3368,'Login with'),(1937,'Login/E-mail'),(3895,'Logo'),(3908,'Logo & Favicon'),(3367,'Logo alt'),(3801,'Logo position'),(3800,'Logo type'),(3011,'Logout this user'),(852,'Look & Feel'),(3072,'Loopback request'),(1697,'Loopback test'),(4185,'Low - High'),(320,'Low inventory products'),(853,'Low limit notification for this product is'),(854,'Low limit quantity'),(855,'Low stock'),(2465,'Low stock info'),(4062,'Low stock notification to admin'),(4061,'Low stock warning on product page'),(856,'M'),(367,'MARCH'),(3722,'MATCH_CRITERIA_DISABLED'),(3719,'MATCH_CRITERIA_HELP'),(3720,'MATCH_CRITERIA_NAME'),(3721,'MATCH_CRITERIA_NONE'),(369,'MAY'),(3844,'MD5 hash value'),(2001,'MM'),(358,'MO'),(2300,'MONTH'),(4396,'MailChimp'),(4397,'MailChimp Integration with E-commerce support'),(4402,'MailChimp Lists'),(4400,'MailChimp is an email marketing service with powerful tools to manage your email campaigns and subscribers while gathering advanced analytics information on your campaign performance.'),(4445,'MailChimp list group names'),(4444,'MailChimp list groups'),(4403,'MailChimp list segments'),(4463,'MailChimp lists'),(4440,'MailChimp lists update'),(4404,'MailChimp segment settings'),(4464,'MailChimp settings'),(4097,'Mailing tube'),(121,'Main categories'),(857,'Maintenance'),(858,'Maintenance and operation'),(2864,'Major improvements and new features'),(2863,'Major upgrade'),(3450,'Make Amazon’s customers your customers with Amazon Pay.'),(2507,'Make a discount available to all customers or only to specific membership levels;'),(859,'Make back-up of your store database'),(4019,'Make changes to your active campaigns, purchase one you built, or reinstate your cancelled campaigns.'),(4973,'Make mutual relations'),(3197,'Make sure the URL is correct and the file referenced by the URL is a PNG/JPG/JPEG'),(1880,'Making backup of the current database state ... '),(4018,'Manage Campaigns'),(867,'Manage admins'),(1877,'Manage attribute groups'),(860,'Manage catalog'),(861,'Manage categories'),(343,'Manage category (X)'),(862,'Manage customer and administrator accounts'),(4211,'Manage global tabs'),(1688,'Manage groups'),(863,'Manage layout'),(3202,'Manage logo dimensions'),(864,'Manage orders'),(865,'Manage orders placed at your store'),(1567,'Manage product classes'),(4465,'Manage segments'),(3388,'Manage subscriptions'),(866,'Manage users'),(4571,'Manage your payment options'),(868,'Manage your product inventory'),(2810,'Manage zones'),(869,'Mandatory fields are marked with an asterisk'),(4089,'Manifest ID'),(4088,'Manifests'),(4632,'Manual'),(3631,'Manually'),(870,'Manually defined shipping methods'),(5013,'Mark all'),(5014,'Mark selected'),(871,'Mark, the search engines you want to inform of the structure of your site using the site map'),(872,'Market price'),(2811,'Marketing'),(873,'Marketplace'),(874,'Marketplace [check_addon_key]: the \"{{url}}\" URL requested'),(875,'Marketplace [check_for_updates]: the \"{{url}}\" URL requested'),(876,'Marketplace [check_for_updates]: valid response received'),(877,'Marketplace [get_hosting_score]: response has an invalid format'),(878,'Marketplace [get_hosting_score]: the \"{{url}}\" URL requested'),(2290,'Marketplace-Vendor'),(879,'Markup per item'),(880,'Markup per weight unit'),(1783,'Max'),(4230,'Max allowed file size is X'),(4165,'Maximum Post Offices that will be displayed'),(2867,'Maximum items in box'),(1573,'Maximum number of items per box'),(3496,'Maximum number of uses'),(3492,'Maximum order subtotal must be greater than minimum order subtotal'),(3503,'Maximum order subtotal the coupon can be applied to'),(278,'Maximum size of the file to upload is N'),(1878,'Measuring productivity in manual mode failed.'),(3809,'Medium (ppcm)'),(4422,'Members count'),(881,'Membership'),(882,'Membership access'),(883,'Membership levels'),(884,'Membership name'),(885,'Memberships'),(3031,'Memory limit'),(2088,'Menu'),(3898,'Menu links help text'),(886,'Menus'),(3773,'Merchant Id'),(3646,'Merchant login'),(4105,'Merchant registration wizard'),(206,'Merge with Registered'),(887,'Message'),(3471,'Message has been sent'),(4977,'Message not found'),(4976,'Messages'),(83,'Meta desc'),(888,'Meta description'),(889,'Meta keywords'),(82,'Meta tags'),(2416,'Method name'),(890,'Methods'),(3491,'Minimum order subtotal must be less than maximum order subtotal'),(3502,'Minimum order subtotal the coupon can be applied to'),(3983,'Minimum order subtotal to which the volume discount can be applied'),(2812,'Minimum value is X'),(2865,'Minor improvements'),(2862,'Minor update'),(5029,'Missed payment'),(2966,'Modified files'),(1570,'Modifiers'),(891,'Modify'),(892,'Modify \"{{name}}\" option group'),(893,'Modify category'),(894,'Modify option groups exceptions'),(895,'Modify root category (the front shop page)'),(4001,'Module Kliken\\GoogleAds was unable to access your store\'s catalog . Please make sure the correct Account Id and Application Token are saved, or contact Kliken for support.'),(2391,'Module Marketplace. Terms of use'),(129,'Module available editions 3'),(130,'Module available editions 4'),(896,'Module has been successfully installed'),(3292,'Module name'),(1873,'Module packing is available in the DEVELOPER mode only. Check etc/config.php file'),(2401,'Module page'),(4563,'Module settings (shipping_rates)'),(1497,'Module with ID X is not found'),(1668,'Module\'s page'),(2813,'Modules'),(1488,'Modules have been successfully installed'),(1905,'Modules license agreements'),(3293,'Monday'),(4995,'Monitoring of communication related to oder #X has been disabled'),(4994,'Monitoring of communication related to oder #X has been enabled'),(3813,'Monochrome (ppcm)'),(384,'Month'),(5038,'Monthly'),(1821,'More'),(1968,'More actions for selected'),(898,'More add-ons'),(2615,'More attributes'),(899,'More details'),(2038,'More info is available in X-Cart\'s Knowledge Base article \'What to do if you cannot access your store...\''),(596,'More information about clean urls in X-Cart is available in '),(649,'More information on Clean URL problems on your system'),(4771,'More information on the setup of webhooks is available here: https://stripe.com/docs/webhooks#configuring-your-webhook-settings'),(4551,'More localisation settings'),(1788,'More search options'),(4565,'More shipping methods'),(2649,'More shipping solutions'),(900,'Most Popular'),(901,'Most Rated'),(902,'Move'),(4131,'Move item'),(4059,'Move to'),(2009,'Mr.'),(2011,'Mrs.'),(2010,'Ms.'),(3599,'Multiple top-level domains'),(4961,'Mutual link'),(4971,'Mutual link head help'),(4594,'My Shipping'),(903,'My account'),(3127,'My addons'),(4338,'My location'),(3131,'My profile'),(3140,'My purchases'),(4562,'My shipping'),(3052,'MySQL cache'),(904,'MySQL server'),(3048,'MySQL version'),(125,'N it.'),(95,'N items found'),(124,'N items total'),(375,'NOVEMBER'),(905,'Name'),(1922,'Name asc'),(1923,'Name desc'),(4596,'Name length must be less then {{length}}'),(909,'Name of account holder'),(906,'Name of address field'),(907,'Name of purchaser'),(1566,'Name, e.g. Apparel'),(1037,'Name-sort-option'),(2346,'Names, descriptions & sorting'),(141,'Native language name'),(3686,'Near \"Add to cart\" button'),(3687,'Near \"Checkout\" button'),(3169,'Need a customizable contact us form with location map? [Get it now!]'),(19,'Need a license key?'),(3111,'Need a way to set multicurrency prices? [Install the addon]'),(3112,'Need a way to set up product variants? [Install the addon]'),(3113,'Need a way to set wholesale prices? [Install the addon]'),(2520,'Need custom design? We can modify this template or create a completely unique design for you'),(1690,'Need license key?'),(1549,'Need more payment methods?'),(910,'Never'),(1621,'New Export'),(4205,'New Tab'),(2403,'New access codes were generated.'),(912,'New access key will also be sent to the Site administrator\'s email address'),(911,'New access link'),(2382,'New account'),(1541,'New address'),(913,'New address field'),(3831,'New arrivals'),(1687,'New attribute'),(2259,'New attribute group will be created'),(119,'New category'),(2703,'New customer note'),(914,'New discount coupon'),(1620,'New group'),(915,'New image'),(1508,'New import'),(916,'New item'),(109,'New membership'),(5012,'New message'),(4985,'New message for order'),(5004,'New messages'),(2117,'New module version available for core versions X'),(2468,'New modules'),(4474,'New news message'),(917,'New page'),(4132,'New parcel'),(918,'New product class'),(919,'New product has been added successfully'),(4719,'New product reviews'),(920,'New rate'),(921,'New role'),(1767,'New safe mode access key has been generated'),(3857,'New sale'),(3887,'New sale tax rate'),(2190,'New staff note'),(4204,'New tab'),(4638,'New tag'),(1307,'New tax class'),(2551,'New to Avalara?'),(24,'New to our store?'),(1748,'New user registered'),(1619,'New value'),(168,'New zone has been created successfully'),(3832,'New!'),(922,'Newest'),(923,'Newest first'),(4475,'News'),(4407,'News list subscriptions'),(4473,'News message'),(4472,'News messages'),(4483,'News page title'),(4484,'News title'),(4495,'Newsletters'),(924,'Next'),(4479,'Next news'),(3109,'Next order'),(925,'Next page'),(5028,'Next payment'),(32,'Next product'),(4318,'Next step'),(76,'Next wizard'),(926,'No'),(1416,'No Curl extension for PHP error'),(1417,'No OpenSSL extension for PHP error'),(3620,'No PIN codes found.'),(1415,'No Phar extension for PHP error'),(2952,'No account yet?'),(2623,'No accounting system has been selected yet. Choose your accounting system below and configure it.'),(1581,'No attributes'),(1689,'No attributes are defined for the product class yet.'),(1582,'No attributes assigned'),(2986,'No category assigned'),(1863,'No category defined'),(2166,'No class'),(4944,'No confirmation'),(927,'No countries found'),(1999,'No delimiter'),(2345,'No discount modules installed'),(4745,'No email'),(4075,'No events found'),(928,'No featured products defined for this category'),(3194,'No file was uploaded'),(4860,'No flexy-templates found.'),(1580,'No group'),(4466,'No groups defined'),(929,'No image'),(930,'No images uploaded'),(2407,'No items found'),(931,'No items found.'),(4148,'No items have been selected for return.'),(3799,'No logo'),(395,'No membership'),(932,'No merchant account required'),(500,'No merchant account required. Simple onboarding for you and easy checkout for your customers.'),(2408,'No model selected'),(1659,'No modules found'),(96,'No modules found for search_string'),(933,'No order have been placed yet'),(327,'No order on last day'),(330,'No order on last lifetime'),(329,'No order on last month'),(328,'No order on last week'),(331,'No orders'),(4870,'No orders available. Please create at least one order.'),(934,'No orders have been placed yet'),(100,'No other languages defined'),(1853,'No payment method selected'),(1854,'No payment methods found based on the selected criteria'),(935,'No payment modules installed'),(3623,'No pin codes are bought yet'),(1616,'No pre-defined value'),(1565,'No product class assigned'),(1661,'No products found'),(4610,'No products have been selected for comparison.'),(4042,'No products matching the current filtering criteria were found. Try clearing filters.'),(4617,'No products matching your criteria found. Please try again with different parameters.'),(936,'No products sold yet'),(1662,'No profiles found'),(2532,'No region'),(2857,'No results found.'),(4706,'No reviews.'),(3163,'No roundup'),(4467,'No segments'),(937,'No states found'),(4419,'No subscription'),(5026,'No subscriptions'),(1543,'No such user'),(938,'No tax rate defined'),(1177,'No tracking numbers are defined'),(1660,'No users found'),(3609,'No valid code found.'),(3951,'Non delivery option'),(939,'Non-administrator'),(3294,'Non-critical'),(4166,'Non-delivery instructions'),(230,'None'),(4502,'Not Finished orders were skipped during the export process. If you wish to export the orders which are now in this state, change their fulfillment status from Not Finished to any other.'),(2987,'Not assigned'),(3295,'Not available'),(1699,'Not detected'),(2028,'Not enough disk space. Required: {{req}} (+{{reserve}} reserve). Available: {{avail}}'),(4917,'Not enough permissions to update the template file'),(940,'Not finished'),(4497,'Not finished order'),(4504,'Not finished orders are skipped during the export process. Change the fulfillment status of these orders to make it exported.'),(941,'Not numeric'),(4707,'Not rated yet'),(2621,'Not seeing your accounting software here? Let us know'),(1598,'Not selected'),(4060,'Not set'),(4110,'Not specified'),(942,'Note'),(2049,'Note: a new window will be opened'),(943,'Notes'),(2338,'Notification'),(2877,'Notification state'),(2717,'Notify administrator if the stock quantity of this product goes below a certain limit'),(944,'Notify administrator inactivity help'),(3782,'Now Accepting'),(1734,'Now disabled'),(4569,'Now you can define how shipping rates should be calculated based on  delivery time, weight and other parameters.'),(1588,'Number of ignored rows:'),(374,'OCTOBER'),(4920,'OK'),(4597,'OK, now let’s get your store ready for sales'),(1679,'OR'),(2014,'OZ'),(2781,'Object name (category, product, etc)'),(2773,'Object name order first'),(2774,'Object name order last'),(3712,'Obtaining your live PayPal credentials'),(945,'Off'),(946,'Official website'),(4573,'Offline method'),(947,'Offline methods'),(3084,'Ok, Got it'),(2702,'Old customer note'),(948,'Old price'),(2189,'Old staff note'),(949,'On'),(950,'On all catalog pages'),(4945,'On call air'),(3841,'On catalog and product pages'),(2922,'On category and product details page'),(2921,'On category listing'),(4101,'On delivery'),(4100,'On exception'),(4697,'On moderation'),(951,'On product details only'),(3850,'On sale'),(4099,'On shipment'),(4595,'Onboarding Wizard'),(4603,'Onboarding: Get shipping rates from major shipping carrier companies.'),(1297,'Once links are regenerated, they will be sent to store administrator email.'),(4304,'One Page checkout'),(2217,'One column'),(3598,'One domain with multiple subdomains'),(4946,'One time pickup'),(952,'Online catalog structure setup'),(4574,'Online method'),(436,'Online methods'),(2136,'Online orders'),(2718,'Only X left in stock'),(4702,'Only customers who purchased this product can leave feedback on this product'),(112,'Only disabled'),(111,'Only enabled'),(1872,'Only enabled modules can be packed'),(2920,'Only orders awaiting processing'),(953,'Only small letter, digits and undescore sign are allowed'),(3325,'Oops, no products have been added to this category yet.'),(1944,'Open'),(954,'Open Graph meta tags'),(5001,'Open a dispute'),(4990,'Open dispute'),(3910,'Open graph image'),(955,'Open graph tags'),(4884,'Open home or category pages for more opportunities to adjust the website structure'),(4423,'Open rate'),(956,'Open storefront'),(4768,'Open the page \"Webhooks\" in the \"Developers\" section of dashboard.stripe.com: https://dashboard.stripe.com/account/webhooks'),(4543,'Open the storefront and check how it looks like on desktop.'),(4888,'Open the storefront while logged in as administrator to change the look & feel of the store.'),(4015,'Open your dashboard to review your campaign\'s performance'),(2545,'Operate as user'),(957,'Operating system'),(3406,'Operation mode'),(958,'Option group'),(3455,'Option values has been successfully updated.'),(2814,'Options'),(959,'Options have been successfully changed'),(2397,'Options:'),(3148,'Or add a video review powered by ShopperApproved'),(3698,'Or register with'),(3697,'Or sign in the classic way'),(3701,'Or use your social account'),(960,'Order'),(961,'Order #'),(266,'Order #X, Y'),(1959,'Order #{{id}}'),(1969,'Order #{{id}} details'),(3567,'Order #{{value}} doesn\'t contain any e-goods'),(3633,'Order #{{value}} doesn\'t have any associated pin codes'),(962,'Order ID'),(2666,'Order QTY'),(963,'Order Total'),(300,'Order Total X'),(267,'Order X'),(5061,'Order X created for next payment on subscription X'),(3006,'Order X has been confirmed as delivered to the customer'),(1523,'Order by'),(1829,'Order can not be placed because not all required fields are completed. Please check the form and try again.'),(4309,'Order cannot be placed because some steps are not completed'),(2815,'Order cannot be placed because there is no shipping methods available.'),(2206,'Order changes cannot be saved due to negative total value'),(3171,'Order customer notes changed'),(2663,'Order date'),(964,'Order date from'),(965,'Order date through'),(3616,'Order deleted'),(966,'Order details'),(2435,'Order failed'),(3563,'Order fulfilment status changed from {{oldStatus}} to {{newStatus}} by file download'),(3172,'Order has been edited'),(1931,'Order history'),(967,'Order id'),(3658,'Order id prefix'),(3536,'Order is not processed'),(318,'Order is placed'),(2200,'Order item attributes are out-of-date and cannot be edited'),(2943,'Order item modifier not found'),(968,'Order items'),(2933,'Order modifier not found'),(1852,'Order not found'),(969,'Order note'),(4305,'Order note. Any special needs?'),(1794,'Order number'),(2816,'Order number or email'),(970,'Order page'),(1781,'Order payment'),(2122,'Order payment status changed from {{oldStatus}} to {{newStatus}}'),(3350,'Order placed'),(3921,'Order prefix'),(971,'Order review'),(2123,'Order shipping status changed from {{oldStatus}} to {{newStatus}}'),(3170,'Order staff notes changed'),(972,'Order statistics'),(973,'Order status'),(2107,'Order status changed from {{oldStatus}} to {{newStatus}}'),(4197,'Order statuses'),(1174,'Order tracking information'),(2947,'Order transaction status not found'),(2949,'Order transaction type not found'),(2201,'Order will be delivered to the billing address.'),(2762,'OrderBy position number must be specified as a non-negative integer.'),(345,'OrderID or email, ID1-ID2 for range'),(3414,'OrderId prefix'),(3553,'Ordered files'),(4128,'Ordered qty'),(974,'Orders'),(2918,'Orders awaiting processing'),(975,'Orders count'),(2669,'Orders has been deleted successfully'),(4199,'Orders have this status tooltip'),(4410,'Orders last month'),(2385,'Orders list'),(976,'Orders placed'),(4979,'Orders with any messages'),(4978,'Orders with unread messages'),(2646,'Origin address'),(3344,'Original name'),(227,'Other'),(163,'Other items'),(4902,'Other pages'),(107,'Our Blog'),(3477,'Our location'),(1819,'Out of Stock'),(977,'Out of stock'),(4098,'Oversized'),(3037,'PDO extension'),(1701,'PHP \'gd\' extension is not installed.'),(3022,'PHP version'),(3610,'PIN'),(3625,'PIN code'),(3626,'PIN codes'),(3624,'PIN codes data have been successfully updated'),(3612,'PIN codes enabled'),(3629,'PIN codes generation method'),(4087,'PO Number'),(1072,'PO number'),(2137,'POS orders'),(3713,'PRIMARYRECEIVER'),(4262,'PS Store ID'),(978,'Pack it'),(1674,'Package'),(2073,'Package dimensions (inches)'),(4167,'Package height (cm)'),(4168,'Package length (cm)'),(4169,'Package maximum weight (kg)'),(2068,'Package properties'),(2044,'Package subtotal'),(2045,'Package subtotal (X)'),(2042,'Package weight'),(2043,'Package weight (X)'),(4170,'Package width (cm)'),(2072,'Packaging'),(2662,'Packing date'),(2660,'Packing slip'),(979,'Page'),(980,'Page URL'),(981,'Page name'),(982,'Page not found'),(2791,'Page title format'),(983,'Pages'),(984,'Paid'),(4081,'Parcel'),(4090,'Parcel characteristics'),(3942,'Parcel dimensions'),(4121,'Parcel is cannot be transmitted - wrong quote type'),(4120,'Parcel is cannot be voided or transmitted - wrong quote type'),(4079,'Parcel options'),(3940,'Parcel type'),(3941,'Parcel weight'),(4137,'Parcels have been successfully updated'),(985,'Parent category'),(2974,'Parent category name'),(2780,'Parent category path'),(354,'Partially refunded'),(3644,'Partner name'),(3296,'Passed'),(219,'Password'),(986,'Password and its confirmation do not match'),(378,'Past'),(4821,'Path for using in custom CSS'),(987,'Pattern search'),(3415,'Pay with Amazon'),(3703,'PayPal'),(3664,'PayPal API'),(3688,'PayPal API (Merchant API) will work for most merchants; however, some merchants may have access only to Payflow API.'),(3733,'PayPal API Client ID'),(3734,'PayPal API Secret'),(3736,'PayPal BN Code'),(3714,'PayPal Credit'),(3790,'PayPal Credit Messaging'),(3677,'PayPal Credit is'),(3762,'PayPal Express Checkout (legacy)'),(3732,'PayPal For Marketplaces account email'),(3639,'PayPal ID / Email'),(3728,'PayPal Merchant ID'),(3735,'PayPal Partner ID'),(3663,'PayPal Publisher ID'),(3785,'PayPal Settings'),(3679,'PayPal account email'),(3786,'PayPal checkout and PayPal express checkout (legacy) / PayPal Payments Advanced are not able to work together.'),(3648,'PayPal recommends entering a User Login here instead of your Merchant Login'),(3437,'PayWithAmazon available actions'),(3707,'PayerID value was not returned by PayPal. Please try again. If the problem persists, contact the administrator.'),(3665,'Payflow API'),(2898,'Payment'),(4599,'Payment Processing'),(3421,'Payment capture error: {{error}}'),(994,'Payment data ({{method}})'),(988,'Payment gateways'),(3427,'Payment has been authorized successfully.'),(3691,'Payment has been captured successfully'),(3420,'Payment has been captured successfully.'),(3428,'Payment has been declined.'),(3689,'Payment has been refunded successfully'),(3424,'Payment has been refunded successfully.'),(3690,'Payment has been voided successfully'),(3763,'Payment has bes refunded successfully'),(3765,'Payment have been voided successfully'),(3422,'Payment have been voided successfully.'),(989,'Payment info'),(990,'Payment instructions'),(2388,'Payment is not required'),(991,'Payment method'),(993,'Payment method data'),(2536,'Payment method has been added'),(1876,'Payment method has been added successfully'),(312,'Payment method has been disabled successfully'),(311,'Payment method has been enabled successfully'),(313,'Payment method has been removed successfully'),(314,'Payment method has not been configured properly'),(2348,'Payment method is disabled'),(2347,'Payment method is enabled'),(4800,'Payment method is not available'),(2425,'Payment method settings'),(2537,'Payment method was not added'),(992,'Payment methods'),(3297,'Payment order status'),(4022,'Payment processed with errors. Please, try again or ask administrator'),(3438,'Payment refresh error: {{error}}'),(3426,'Payment refund error: {{error}}'),(4390,'Payment return page requested without expected parameters'),(995,'Payment settings'),(2118,'Payment status'),(2931,'Payment status not found, \"Awaiting payment\" will be used for order'),(4201,'Payment status not found, new status will be created'),(4195,'Payment statuses'),(996,'Payment transaction ID'),(302,'Payment transaction X issued'),(3429,'Payment transaction is in progress...'),(997,'Payment transactions'),(3423,'Payment void error: {{error}}'),(301,'Payment was not finished'),(998,'Payments'),(3750,'Payments with this payment method are not allowed because HTTPS is not configured'),(3705,'Paypal capture warning message'),(3764,'Paypal login (email)'),(999,'Pending'),(234,'Pending membership'),(1000,'Pending memberships'),(2693,'Pending[S]'),(1001,'Per item markup'),(1002,'Per weight unit markup'),(1003,'Percent'),(3980,'Percent discount value cannot exceed 100%'),(1004,'Percent markup'),(1005,'Percent off'),(1006,'Perform order search'),(1007,'Performance'),(2911,'Performing task...'),(3365,'Period end date must be later than period start date'),(3364,'Period start date must be sooner than period end date'),(1008,'Permissions'),(1009,'Permissions checking failed'),(1010,'Personal info'),(1323,'Personal info: The new password must not coincide with the current password for your account.'),(4926,'Personalize Logos'),(3057,'Phar extension'),(1011,'Phone'),(1012,'Pick address from address book'),(4809,'Pick template from page element'),(4878,'Pick templates from page'),(3591,'Pin'),(3590,'Pin It'),(3968,'PitneyBowes'),(1013,'Place order'),(180,'Place order X'),(2184,'Placed by NAME'),(2183,'Placed by _NAME_'),(1678,'Placed on'),(2182,'Placed on DATE'),(298,'Placed on X by Y'),(299,'Placed on X by Y link'),(1926,'Plain field'),(5020,'Plan'),(5068,'Planned date of the next payment'),(1657,'Please'),(1014,'Please accept the Terms and Conditions to continue'),(4183,'Please add another product to comparison'),(2978,'Please be warned that proper operation of the site after an upgrade is not guaranteed if you choose to upgrade only some of the components listed below.'),(3394,'Please check the nameservers settings in your account on the registrar\'s website.'),(1015,'Please choose the appropriate action'),(1589,'Please confirm if you want proceed with the import otherwise cancel the operation.'),(1289,'Please contact the module developers to make sure that these modules are compatible with the upcoming upgrade'),(2126,'Please create a new password'),(1016,'Please enable JavaScript in your web browser.'),(2860,'Please enter 3 or more characters'),(3470,'Please enter the correct captcha'),(1722,'Please enter the correct file location or set correct file permissions.'),(4755,'Please enter your encryption password (This is different from your merchant password). More info on encryption passwords is available <here>'),(1017,'Please identify yourself'),(1533,'Please make sure that \"min weight\", \"min total\", \"min items\", \"shipping zone\", \"shipping method\" fields do not overlap with other shipping rates.'),(1595,'Please make sure your file format is as described.'),(3381,'Please note that during the domain name transferring your store will be temporarily blocked. This process may take several minutes.'),(4103,'Please note that rates are calculated for shipping from Canadian locations only.'),(1018,'Please note that some of these modules are definitely incompatible with the upcoming upgrade and will be disabled in order to prevent the system crash'),(2381,'Please note that the following modules will also be enabled'),(3960,'Please note: the USPS Web tools APIs print labels without postage.'),(3101,'Please register your license key now or purchase a premium license to skyrocket your business.'),(2443,'Please renew your access to upgrades to get new superior features from the latest releases.'),(4730,'Please review purchased product {{product}}'),(4732,'Please review purchased products'),(1019,'Please run the benchmark test in order to estimate your server performance'),(1020,'Please save the soft reset and hard reset links so that you can use them later in case the website crash happens'),(3216,'Please select'),(392,'Please select a date range'),(391,'Please select a date range between %d and %d days'),(390,'Please select a date range less than %d days'),(389,'Please select a date range longer than %d days'),(3374,'Please select an option'),(1021,'Please select one'),(397,'Please select one ...'),(398,'Please select option'),(1846,'Please select other attribute'),(4372,'Please select the attributes first'),(2308,'Please select the countries first'),(3298,'Please select the entities first'),(2668,'Please select the orders first'),(1832,'Please select the products first'),(4716,'Please select the reviews first'),(2173,'Please select the states first'),(4640,'Please select the tags first'),(4675,'Please sign in to add review'),(149,'Please specify a pattern to find the required labels'),(1479,'Please specify non-empty key'),(128,'Please specify text labels for each language'),(5067,'Please try to use another payment card or contact the store administrator'),(3448,'Please update your payment information'),(2817,'Please wait'),(225,'Please, clarify your search request or search in Marketplace'),(1413,'Please, contact administrator'),(1729,'Please, enter a valid IP address'),(1728,'Please, enter a valid e-mail address'),(1712,'Please, enter unique membership name'),(1639,'Please, make sure that the following modules are installed and enabled:'),(3375,'Please, re-generate the product catalog images to apply the new template settings.'),(3617,'Please, type in the new PIN codes one per line.'),(3781,'Please, use another card or payment method.'),(1667,'Popularity'),(1022,'Pos'),(1023,'Pos.'),(1024,'Pos.:'),(1025,'Position'),(2162,'Possible import file names are:'),(2164,'Possible reasons of data not found in import file'),(2047,'Postal Code'),(2053,'Postal/ZIP Code'),(1028,'Pre upgrade disabled modules hooks message body'),(1031,'Pre upgrade disabled modules hooks message footer'),(1027,'Pre upgrade disabled modules hooks message head'),(2606,'Pre-upgrade hooks cannot be run'),(1030,'Pre-upgrade off'),(1029,'Pre-upgrade on'),(1026,'Prefix'),(2165,'Premium license modules warning'),(1032,'Prev'),(4869,'Preview full email'),(1562,'Preview product page'),(382,'Previous'),(4478,'Previous news'),(3108,'Previous order'),(1033,'Previous page'),(31,'Previous product'),(223,'Price'),(4050,'Price and membership'),(1920,'Price asc'),(1921,'Price desc'),(1034,'Price modifier'),(4619,'Price range'),(1036,'Price-sort-option'),(1035,'Price: Not a numeric'),(2818,'Prices & Inventory'),(3922,'Pricing currency'),(1038,'Primary menu'),(1994,'Print'),(2628,'Print Shipping labels'),(3953,'Print custom message 1'),(3955,'Print custom message 2'),(1039,'Print invoice'),(2661,'Print packing slip'),(1995,'Print selected'),(2111,'Priority'),(2063,'Private'),(3299,'Private and custom modules:'),(3300,'Private link'),(3301,'Proceed'),(1517,'Proceed import'),(2893,'Proceed to payment'),(181,'Proceed to payment X'),(4511,'Proceed to the next step'),(1040,'Processed'),(1041,'Processed/Completed'),(3002,'Processing categories...'),(2367,'Processing products...'),(4655,'Product'),(4279,'Product Feed URL'),(1775,'Product ID'),(1042,'Product Name'),(1043,'Product SKU'),(1044,'Product Title'),(1045,'Product added to bag'),(2156,'Product attributes values'),(2160,'Product attributes values (Hidden field) has been imported'),(2158,'Product attributes values (Plain text) has been imported'),(2159,'Product attributes values (Textarea) has been imported'),(2157,'Product attributes values (Yes/No) has been imported'),(2406,'Product attributes values has been imported'),(1046,'Product class'),(1896,'Product class have been updated successfully'),(1897,'Product class name is empty'),(2270,'Product class {{value}} does not exists and will be created'),(1047,'Product classes'),(4350,'Product count'),(4277,'Product feed'),(4274,'Product feed generation has been completed successfully'),(4275,'Product feed generation has been stopped'),(1050,'Product has been added to cart'),(1048,'Product has been created'),(1049,'Product has been updated'),(1849,'Product has not been added to cart'),(1051,'Product images'),(1052,'Product info'),(1053,'Product info has been updated successfully'),(1054,'Product is out of stock'),(4058,'Product list'),(224,'Product name'),(3632,'Product not found'),(1055,'Product on sale'),(1056,'Product options'),(4955,'Product or product variant with SKU \"{{value}}\" not found'),(1057,'Product page title'),(1058,'Product prices are defined including this tax calculated for'),(3326,'Product quantity has changed'),(3534,'Product removed'),(4656,'Product reviews'),(4208,'Product tabs'),(4639,'Product tags'),(2264,'Product with SKU \"{{value}}\" does not exists'),(4952,'Product with SKU \"{{value}}\" not found'),(2187,'Product with selected properties cannot be purchased'),(4668,'Product, SKU or customer info'),(1898,'Product-Specific'),(1899,'Product-Specific attributes'),(4373,'Product-specific'),(2263,'ProductSKU is empty'),(1059,'Products'),(3530,'Products (X)'),(4954,'Products and product variants updated'),(1526,'Products found'),(3361,'Products have been split into parcels in order to estimate the shipping cost'),(1909,'Products imported'),(1060,'Products in bag'),(2990,'Products in this class: {{X}}'),(2431,'Products information has been successfully deleted'),(1061,'Products information has been successfully updated'),(2366,'Products processed'),(2145,'Products processed: X out of Y'),(2149,'Products processed: X out of Y with errors'),(2383,'Products processed: {{count}}'),(4067,'Products return X'),(4657,'Products reviews'),(2710,'Products search'),(4950,'Products updated'),(1062,'Products with low inventory'),(3007,'Products with no assigned categories'),(1063,'Profile'),(3012,'Profile actions'),(3082,'Profile details'),(1064,'Profile has been created successfully'),(1065,'Profile has been deleted successfully'),(1956,'Profile has been modified successfully'),(1066,'Profile has been updated successfully'),(2129,'Profile is not defined'),(2409,'Profile is not selected'),(1067,'Profile settings'),(1068,'Promotions'),(4171,'Proof of age'),(1069,'Properties'),(4194,'Public'),(2414,'Public ID'),(2415,'Public id'),(3302,'Public installed modules:'),(4021,'Public key'),(4782,'Publishable key'),(4783,'Publishable key (test mode)'),(4674,'Published'),(1070,'Purchase'),(1071,'Purchase SSL certificate'),(3092,'Purchase a premium license key'),(2081,'Purchase description'),(2670,'Purchase license'),(14,'Purchase premium license'),(1665,'Purchased'),(3139,'Purchased addons'),(3851,'Put all for sale'),(3848,'Put up for sale'),(1073,'Put up selected for sale'),(1074,'Qty'),(1075,'Qty.'),(209,'Quantity'),(3603,'Quantity in stock'),(3621,'Quantity in stock is determined by the amount of the remaining PIN codes'),(3618,'Quantity in stock is determined by the amount of the remaining PIN codes.'),(1076,'Quantity: high to low'),(1077,'Quantity: low to high'),(385,'Quarter'),(1524,'Query'),(1078,'Queued'),(1079,'Quick and easy setup'),(3132,'Quick menu'),(2890,'Quick view'),(2546,'Quit'),(4172,'Quote type'),(4647,'REST API allows to get or change any information in your store (including profiles, orders, payment transactions, inner store configuration, products, categories and so on), so your API key must be as complex as possible and kept private.'),(2398,'RSS feed'),(1080,'Rate'),(4700,'Rate asc'),(4701,'Rate desc'),(4699,'Rate sort'),(1081,'Rates'),(1082,'Rates / Conditions'),(4666,'Rating'),(4682,'Rating of votes'),(4720,'Ratings and Reviews of X'),(4712,'Ratings only'),(1083,'Raw online rate (on-line rate)'),(1084,'Re-build cache'),(3876,'Re-calculate quick data'),(2686,'Re-check'),(2478,'Re-deploy the store'),(2479,'Re-deploy the store help text'),(1085,'Re-generate access key'),(1576,'Re-generate links'),(1086,'Re-order'),(3558,'Re-upload file'),(2448,'Re-validate license keys'),(4974,'Read'),(4698,'Read all reviews about the product'),(4534,'Ready to delete demo products?'),(5003,'Reason'),(3303,'Rebuild view lists help text'),(2913,'Recalculate ViewLists'),(2914,'Recalculate ViewLists text'),(2203,'Recalculate this value automatically'),(2819,'Recalculate totals'),(2820,'Recent orders only'),(3217,'Recently installed addons'),(2426,'Recently installed modules'),(3833,'Recently viewed'),(4731,'Recently, you have made a purchase from our company:'),(1919,'Recommended'),(3730,'Reconnect to PayPal'),(4455,'Reconnect with your MailChimp account'),(220,'Recover password'),(3510,'Redeem'),(1087,'Redirect customers to HTTPS'),(3090,'Refer to X-Cart license agreement for further details.'),(1089,'Referer'),(3160,'Refresh consistency status'),(2964,'Refresh integrity status'),(3930,'Refresh list of available methods'),(3439,'Refresh status'),(4776,'Refresh token'),(2104,'Refund'),(3425,'Refund is in progress...'),(2735,'Refund multiple[TT]'),(2734,'Refund partially[TT]'),(352,'Refund requested'),(3440,'Refund status'),(3723,'Refund status:'),(3419,'Refund status: {{status}}'),(2733,'Refund[TT]'),(353,'Refunded'),(1836,'Refunded amount'),(2630,'Refunds'),(1090,'Register'),(3106,'Register license key'),(1761,'Register user'),(3699,'Register with'),(3696,'Register with PayPal or go to checkout as a New customer'),(3410,'Register your website as an application on the Login with Amazon App Console.'),(1091,'Registered'),(2133,'Registered (access level)'),(203,'Registered Customer'),(204,'Registered Customer, _Anonymous Customer with the same email_'),(2021,'Registered Customers'),(4710,'Registered users only'),(4703,'Registered users who purchased product'),(3715,'Registering your application with PayPal'),(4173,'Registration process has been canceled.'),(4174,'Registration process has been completed successfully.'),(3820,'Regular (ppcm)'),(2784,'Regular text for 404 page'),(4725,'Reject'),(4958,'Related products'),(4962,'Related products page'),(3573,'Related products you may be interested in'),(3461,'Relay Response URL note'),(3615,'Remaining PINs'),(3091,'Remind me on next sign-in'),(21,'Removal of this message is allowed only through activation of a free or premium license.'),(1092,'Remove'),(4622,'Remove cache when attribute, tag or product data is changed'),(2207,'Remove data'),(3304,'Remove expired sessions'),(3305,'Remove expired shopping carts'),(4859,'Remove flexy-templates'),(4366,'Remove from google product feed'),(3306,'Remove module'),(4624,'Remove product filter cache'),(4623,'Remove product filter cache tooltip'),(2683,'Remove unlicensed modules'),(3512,'Removed coupons'),(2967,'Removed files'),(2199,'Removed items'),(3307,'Removing expired datacache'),(1610,'Removing this attribute will affect all the products. Leave this blank to hide this option for the product.'),(1694,'Removing this message without buying a Full license is prohibited and will result in legal proceedings.'),(1192,'Rename label'),(4175,'Render detailed manifest'),(3571,'Renew'),(2447,'Renew your access to new features'),(1742,'Replace all modified files with the unmodified newer versions'),(4055,'Replace with'),(104,'Report a bug'),(2356,'Request for upgrade'),(2078,'Request type must be POST'),(4765,'Requested amount: X; real amount: Y'),(4766,'Requested currency: X; real currency: Y'),(4764,'Requested transaction type: X; real transaction type: Y'),(1965,'Requested zone does not exists'),(1422,'Require to change password on next log in'),(1093,'Required'),(1713,'Required field'),(262,'Required field X is not defined or empty'),(3464,'Required for SHA512 hash protection.'),(1094,'Required php extensions is not loaded: X'),(2984,'Required state_id checkbox help text'),(1095,'Requires registered merchant account'),(2711,'Requires shipping'),(2674,'Requires {{list}} edition'),(1096,'Rerun benchmark'),(1097,'Resend secret link to renew the access'),(4040,'Reset all filters'),(4616,'Reset filter'),(4900,'Reset layout'),(1997,'Residential'),(2369,'Resizing images...'),(2456,'Resolve the conflict'),(4739,'Response date is in wrong format'),(4260,'Response from ePDQ is not trusted (SHA checking is failed)'),(1098,'Response from marketplace is not received'),(1099,'Response from marketplace: '),(1478,'Response from marketplace: X'),(5032,'Restarted'),(1100,'Restore'),(1101,'Restore database'),(1102,'Restore from server'),(1103,'Restore last backup'),(1104,'Restore links'),(4806,'Restore this version'),(772,'Restores to current state of active addons (use in case of emergency)'),(1885,'Restoring database from the backup .'),(2453,'Result'),(1730,'Result pages'),(4146,'Return'),(4133,'Return #'),(4123,'Return products'),(4129,'Return qty'),(4069,'Return quantity'),(1105,'Return to Drupal'),(1886,'Return to admin interface'),(4301,'Return to cart'),(4346,'Return to default database'),(4086,'Return tracking pin'),(1518,'Reupload files'),(1106,'Revenue'),(4911,'Revert to default'),(4342,'Revert to default database'),(4714,'Review'),(2709,'Review & Submit order'),(4661,'Review has been created'),(4662,'Review has been deleted'),(4663,'Review has not been created since product is not found'),(4664,'Review has not been updated since product is not found'),(4805,'Review it.'),(3200,'Review modules'),(1107,'Review statistics on various aspects of your store\'s operation'),(4665,'Reviewer'),(4746,'Reviewer name'),(4689,'Reviews'),(4718,'Reviews about product'),(4711,'Reviews and ratings'),(4654,'Reviews for product'),(4667,'Reviews imported'),(4713,'Reviews only'),(4690,'Reviews: X'),(3806,'Right (ppcm)'),(1108,'Role'),(1109,'Roles'),(2757,'Roles cannot be changed for your profile via import'),(1110,'Root Level'),(1111,'Root access'),(1680,'Root categories'),(1112,'Root category'),(2141,'Root category listings format'),(231,'Root level'),(3162,'RoundUp'),(1975,'Row {{number}}'),(1976,'Row(s) {{numbers}}'),(1113,'Run Benchmark again'),(1114,'Run benchmark'),(363,'SA'),(3716,'SECONDARYONLY'),(3717,'SENDER'),(4722,'SEO'),(1149,'SEO settings'),(373,'SEPTEMBER'),(2596,'SHIPPING = flat + ITEMS*per_item + SUBTOTAL*(% of subtotal)/100 + WEIGHT*per_weight;'),(30,'SKU'),(2410,'SKU is not selected'),(2821,'SKU length must be less then {{length}}'),(3308,'SKU must be unique'),(4741,'SKU or Product name'),(2823,'SKU or SKU1, SKU2'),(1115,'SKU: a-z'),(1116,'SKU: z-a'),(1117,'SMTP server'),(1870,'SQL file was deleted successfully'),(1418,'SSL Error'),(1118,'STORE SETUP'),(364,'SU'),(1119,'SYSTEM SETTINGS'),(1120,'Safe mode'),(1121,'Safe mode access key'),(1864,'Safe mode access key has been re-generated'),(2025,'Safe mode links were emailed'),(4750,'Sage Pay password'),(4752,'Sage Pay pricing currency'),(4749,'Sage Pay processing mode'),(4748,'Sage Pay vendor name'),(4751,'Sage pay invoice number prefix'),(4754,'SagePay Form admin description'),(1122,'Sale'),(3860,'Sale discounts'),(3854,'Sale name'),(1123,'Sale price'),(2462,'Sale statistics'),(1124,'Sale statistics from the opening of the store'),(2726,'Sale[TT]'),(1125,'Sales'),(4586,'Sales & Customer Service:'),(4588,'Sales & Customer Service: [phone]'),(3467,'Sales asc'),(2700,'Sales calculation'),(3126,'Sales channels'),(3468,'Sales desc'),(3466,'Sales sort'),(1126,'Sales tax'),(1516,'Samples of the file structures'),(127,'Save'),(3907,'Save & Close'),(4510,'Save and go to the next step'),(1127,'Save as new'),(1128,'Save changes'),(2652,'Save filter'),(4340,'Save location'),(2204,'Save the existing value without re-calculating'),(1129,'Save zone details'),(3134,'Saving'),(1130,'Savings'),(3961,'Savings - Up to 49% off retail USPS postage rates'),(2878,'Scheme'),(4704,'Score: X. Votes: Y'),(75,'Search'),(4044,'Search & Filter'),(4045,'Search & Filter Dashboard'),(4349,'Search attribute name'),(4857,'Search flexy-templates'),(1131,'Search for modules'),(1132,'Search for orders'),(4136,'Search for returns'),(2489,'Search for transactions by date'),(1133,'Search for users'),(1134,'Search for users that are'),(403,'Search in'),(1135,'Search in subcategories'),(2140,'Search items...(customer header search form)'),(399,'Search keywords'),(400,'Search payment method'),(1136,'Search product'),(1137,'Search profiles'),(1138,'Search result'),(1139,'Search results'),(2134,'Search total'),(2856,'Searching...'),(2907,'Second, try to disable all non-X-Cart modules by using the links below:'),(3408,'Secret Access Key'),(2106,'Secret key'),(4784,'Secret key (test mode)'),(2091,'Secret word'),(216,'Secure Checkout'),(1140,'Secure connection cannot be established.'),(2295,'Secure credit card payment'),(1141,'Security'),(2303,'Security code'),(2467,'Security issue'),(1142,'Security settings'),(161,'See all items in the cart'),(1824,'See comparison chart'),(2167,'See log file for details'),(4585,'See the tutorials and documentation about X-Cart store customization.'),(4415,'Segment condition'),(292,'Select a country or a state from a list, specify the zone'),(1746,'Select all'),(4408,'Select box'),(1143,'Select country'),(92,'Select file'),(4393,'Select issuer'),(99,'Select language'),(2824,'Select language to edit'),(226,'Select one'),(1144,'Select options'),(1861,'Select products from the list'),(1145,'Select status'),(4723,'Select the review that should be included into the rich snippet shown for the page of this product when the page appears in search results by Google and other major search engines'),(3309,'Select type'),(3371,'Selectbox'),(4425,'Selected by default'),(750,'Selected countries'),(749,'Selected countries:'),(4715,'Selected reviews have been deleted'),(4717,'Selected reviews have been updated'),(752,'Selected states'),(4641,'Selected tags have been deleted'),(355,'Selected:'),(1709,'Semicolon'),(1146,'Send'),(3476,'Send a message'),(3382,'Send anyway'),(3016,'Send reset link'),(1147,'Send test email'),(1148,'Send to {{email}}'),(1176,'Send tracking info'),(2825,'Separate box'),(1150,'Service name'),(1151,'Service name of address field'),(1152,'Set'),(2508,'Set a single discount or add multiple volume discounts.'),(2506,'Set absolute or %-based discount rates;'),(4560,'Set flat shipping rates for your store'),(4602,'Set it up'),(4269,'Set the Response Method setting to Sent to your server as a POST.'),(1153,'Set the sale price'),(144,'Set this language as default for customer zone'),(4509,'Set up payment gateways'),(4557,'Set up shipping'),(4508,'Set up shipping methods'),(4552,'Set your company info'),(3224,'Setting up Canadian taxes'),(3226,'Setting up European / UK Taxes'),(3227,'Setting up US Taxes'),(3223,'Setting up tax'),(3225,'Setting up tax classes'),(1154,'Settings'),(1155,'Setup _address zones_ and _taxes_'),(4934,'Setup banners'),(5018,'Setup fee'),(4024,'Setup instruction'),(3767,'Setup quickly and offer the convenience and trusted security of PayPal.'),(2185,'Setup store price: X'),(3741,'Shape'),(3592,'Share'),(2667,'Ship QTY'),(3969,'Ship date'),(1558,'Ship in a separate box'),(2665,'Ship to'),(4083,'Shipment ID'),(3937,'Shipment Id'),(4139,'Shipment cannot be created'),(4144,'Shipment cannot be transmitted'),(4141,'Shipment cannot be voided'),(3936,'Shipment has been created successfully'),(4138,'Shipment has been created with errors'),(4142,'Shipment has been tranmitted with errors'),(4143,'Shipment has been transmitted successfully'),(3935,'Shipment has been voided successfully'),(4140,'Shipment has been voided with errors'),(4082,'Shipment info'),(2069,'Shipment options'),(4084,'Shipment status'),(4145,'Shipments'),(4176,'Shipments pick up type'),(349,'Shipped'),(3897,'Shipping'),(1156,'Shipping & Taxes'),(1309,'Shipping / Payment info'),(1157,'Shipping address'),(1839,'Shipping address is invalid'),(1158,'Shipping address is not completly defined yet'),(1159,'Shipping address is not defined'),(1160,'Shipping address is not defined yet'),(2594,'Shipping charge based on a percentage of the order subtotal.'),(1540,'Shipping charges'),(41,'Shipping cost'),(4324,'Shipping freight'),(4327,'Shipping freight + regular shipping rate'),(4326,'Shipping freight only'),(4328,'Shipping freight tooltip text'),(1673,'Shipping has been calculated based on the following split of the products into packages:'),(1161,'Shipping info'),(3939,'Shipping label'),(3957,'Shipping label sender signature'),(1162,'Shipping markup has been created successfully'),(1163,'Shipping markups have been updated'),(1164,'Shipping method'),(2826,'Shipping method / cost'),(1165,'Shipping method has been added'),(3310,'Shipping method is disabled'),(3311,'Shipping method is enabled'),(2555,'Shipping method is not configured.'),(2566,'Shipping method name'),(1166,'Shipping methods'),(1167,'Shipping methods are not available'),(165,'Shipping methods have been updated'),(3312,'Shipping order status'),(1532,'Shipping rate cannot be added'),(1531,'Shipping rate has been added successfully'),(1168,'Shipping rates'),(2590,'Shipping rates are calculated by the following formula:'),(1169,'Shipping settings'),(2648,'Shipping solutions'),(2119,'Shipping status'),(2930,'Shipping status not found, \"New\" will be used for order'),(4202,'Shipping status not found, new status will be created'),(4196,'Shipping statuses'),(2894,'Shipping to'),(1170,'Shipping zones'),(4747,'Shopper approved promo'),(1184,'Shopping bag'),(4614,'Shopping options'),(377,'Shortcuts'),(2023,'Show'),(4779,'Show \"How to use\" instruction'),(78,'Show Category title'),(3684,'Show above products'),(4852,'Show all'),(94,'Show all labels'),(4618,'Show all products in this category'),(2719,'Show all warnings/errors'),(3685,'Show below products'),(3918,'Show default menu along with the custom one'),(3479,'Show email as text'),(198,'Show filter options'),(2827,'Show in all the sections'),(2716,'Show low stock warning on product page'),(2792,'Show object name in page title'),(2828,'Show only in categories and search listings'),(2829,'Show only in search listing'),(3742,'Show payment card icons'),(4615,'Show products'),(3009,'Show products with no assigned category'),(1185,'Show social buttons'),(3081,'Show states for selected countries only'),(5005,'Show vendor’s products in the order'),(2785,'Show сustomer relations e-mails on 404 page'),(2830,'Show:'),(2315,'Sign Up'),(3695,'Sign Up Now'),(1186,'Sign in'),(2889,'Sign in / sign up'),(1187,'Sign out'),(4447,'Sign up for <Company name> news, sales and deals'),(4025,'Sign up for Authorize.net'),(3175,'Sign up for TaxJar'),(4446,'Sign up for news and updates from your favorite store. Be the first to know about exclusive sales, offers and deals.'),(4487,'Sign up for {{companyName}} news'),(2876,'Signature'),(3458,'Signature  key'),(3465,'Signature key'),(3797,'Single line logo'),(1718,'Single quote'),(3990,'Site map has not been registred in X'),(3991,'Site map successfully registred on X'),(4177,'Site number of the deposit location'),(4756,'Sitemap'),(3996,'Sitemap generation has been completed successfully.'),(3997,'Sitemap generation has been stopped.'),(3995,'Sitemap generation...'),(3999,'Sitemap settings'),(1188,'Size'),(4559,'Skip Shipping Step'),(4513,'Skip this step'),(3313,'Skipped'),(3821,'Slim (ppcm)'),(3808,'Small (ppcm)'),(2831,'Soft and Hard reset links for your store'),(3314,'Soft and hard reset links for your store'),(1770,'Soft reset (disables all modules except ones that were downloaded from marketplace)'),(2908,'Soft reset. Turn off all addons except those provided by X-Cart Team & Qualiteam'),(3604,'Sold'),(3614,'Sold PINs'),(4838,'Some'),(4910,'Some edited templates were selected to be disabled. You can enable them on the Edited templates page in the Admin area.'),(1740,'Some files are modified'),(4250,'Some files haven`t been attached'),(4862,'Some flexy-templates cannot be removed. Please correct file permissions or remove them manually'),(3330,'Some items were out of stock at the time of order placement.'),(4180,'Some of the items in the parcel were removed. To view all the items, including the removed ones, see the document.'),(2442,'Some of these updates are not available for you at the moment.'),(4575,'Some people simply prefer to place their orders by phone — let them do that.'),(265,'Some products could have been imported incorrectly'),(3377,'Something went wrong, please try again or contact us at X'),(4388,'Something wrong in the iDEAL payment module settings. Please try later or use other payment option.'),(3874,'Sorry, no products have been added to this discount offer.'),(3875,'Sorry, no products of {{vendor}} have been added to this discount offer.'),(3520,'Sorry, the coupon has expired'),(3521,'Sorry, the coupon use limit has been reached'),(3522,'Sorry, the coupon you entered cannot be applied to the items in your cart'),(3527,'Sorry, the coupon you entered cannot be applied to this delivery address'),(3519,'Sorry, the coupon you entered is invalid. Make sure the coupon code is spelled correctly'),(3523,'Sorry, the coupon you entered is not valid for your membership level. Contact the administrator'),(1267,'Sorry, this category is no longer available.'),(3516,'Sorry, this coupon cannot be combined with the coupon already applied. Revome the previously applied coupon and try again.'),(1265,'Sorry, this page is no longer available.'),(1266,'Sorry, this product is no longer available.'),(2659,'Sorry, your order cannot be placed as there are no shipping methods available.'),(1802,'Sorry, your order payment is canceled.'),(1803,'Sorry, your order payment is failed.'),(3315,'Sort'),(233,'Sort by'),(2832,'Sort by:'),(2833,'Sort settings'),(2046,'Source address'),(2000,'Space'),(3944,'Special services'),(429,'Specification'),(3207,'Specify email address'),(4291,'Specify the percentage of users who complete the transaction (Add to cart)'),(4295,'Specify the percentage of users who complete the transaction (Initiate checkout)'),(4294,'Specify the percentage of users who complete the transaction (View content)'),(1194,'Specify your _store information_'),(2834,'Specify your _store information_\', {\'URL\': url(\'settings\', \''),(1195,'Speed up your store'),(3796,'Stacked'),(2202,'Staff note'),(2642,'Stamps.com'),(2513,'Standard'),(2917,'Start'),(1623,'Start Export'),(1507,'Start Import'),(3660,'Start accepting Express Checkout payments immediately by simply plugging in the email address where you would like to receive payments.'),(1807,'Start date'),(1196,'Start selling!'),(3336,'Start typing a category name'),(4672,'Start typing customer email or name'),(4670,'Start typing product name or SKU'),(5027,'Started on'),(1197,'State'),(1495,'State cannot be created with unknown country code X'),(1198,'States'),(1199,'States have been deleted successfully'),(1200,'States have been updated successfully'),(2172,'States information has been successfully deleted'),(4417,'Static'),(1201,'Statistics'),(1202,'Status'),(3221,'Status comment (reason)'),(2411,'Status is not defined'),(4773,'Status: Connected'),(334,'Steps to complete your store for real sales'),(1936,'Stock'),(2932,'Stock status not found'),(5031,'Stopped'),(4930,'Store Configuration Mode'),(3316,'Store ID'),(1203,'Store Maintenance'),(1204,'Store currency'),(1205,'Store info'),(1206,'Store is closed'),(1207,'Store is open'),(1753,'Store lifetime'),(1208,'Store setup'),(1209,'Storefront'),(1943,'Storefront is closed'),(1945,'Storefront is open'),(4899,'Storefront layout'),(4306,'Street address'),(4786,'StripeJSerror amount_too_large'),(4785,'StripeJSerror amount_too_small'),(4787,'StripeJSerror authentication_required'),(4788,'StripeJSerror card_declined'),(4789,'StripeJSerror email_invalid'),(4790,'StripeJSerror expired_card'),(4791,'StripeJSerror incorrect_address'),(4792,'StripeJSerror incorrect_cvc'),(4793,'StripeJSerror incorrect_number'),(4794,'StripeJSerror incorrect_zip'),(4795,'StripeJSerror invalid_cvc'),(4797,'StripeJSerror invalid_expiry_month'),(4796,'StripeJSerror invalid_expiry_year'),(4798,'StripeJSerror invalid_number'),(4799,'StripeJSerror postal_code_invalid'),(3340,'Strong password'),(4932,'Style Your Banners'),(120,'Subcat'),(1210,'Subcategories'),(344,'Subcategories for'),(1211,'Subject'),(3912,'Submenu'),(35,'Submit'),(2888,'Subscribe'),(4443,'Subscribe by default'),(4406,'Subscribe to our news list and be in touch with our latest offers.'),(4493,'Subscriber with email {{email}} already subscribed'),(4489,'Subscribers'),(4492,'Subscribers imported'),(4405,'Subscription'),(5017,'Subscription ID'),(5071,'Subscription X has been activated'),(5066,'Subscription X has been failed'),(5074,'Subscription X has been stopped'),(5076,'Subscription X payment successfully charged'),(5019,'Subscription fee'),(5015,'Subscription plan'),(1212,'Substring'),(43,'Subtotal'),(3888,'Subtotal + Shipping cost'),(2574,'Subtotal range'),(1213,'Subtotal range (begin)'),(1214,'Subtotal range (end)'),(1671,'Success'),(2692,'Success[S]'),(4468,'Successfully authenticated'),(1215,'Successfully imported X new products'),(1216,'Successfully imported X new products and upgraded Y old products'),(1217,'Successfully upgraded Y old products'),(1218,'Suffix'),(4947,'Suggested retail rates'),(3317,'Sunday'),(1505,'Support'),(3151,'Surcharges'),(2973,'Switch to Category search'),(2972,'Switch to Category tree'),(2902,'Switcher NO'),(2901,'Switcher YES'),(1219,'Synchronous'),(3130,'System logs'),(1220,'System settings'),(4200,'System status tooltip'),(3129,'System tools'),(1856,'System will download and install this module from marketplace. Continue?'),(361,'TH'),(359,'TU'),(1710,'Tab'),(4222,'Tab displaying comments about the product. Added by the addons VK/GoSocial/Disqus'),(4744,'Tab displaying product reviews. Added by the addon Product Reviews'),(4221,'Tab displaying the product\'s attributes and other details. Added by the X-Cart core'),(4220,'Tab displaying the product\'s detailed description. Added by the X-Cart core'),(1221,'Table'),(2567,'Table based on'),(4203,'Tabs'),(4209,'Tabs imported'),(4637,'Tag'),(4891,'Tag Manager Dashboard'),(5,'Tags'),(2227,'Tags are not allowed in the column \"{{column}}\" and will be stripped'),(44,'Tax'),(4065,'Tax Class'),(1563,'Tax class'),(1893,'Tax classes'),(1222,'Tax disabled'),(1223,'Tax enabled'),(1224,'Tax has been disabled successfully'),(1225,'Tax has been enabled successfully'),(1227,'Tax rate has been deleted successfully'),(1228,'Tax rate has not been deleted successfully'),(3890,'Tax rates for shipping charges have not yet been created.'),(1226,'Tax rates have been updated successfully'),(3891,'Tax rates have not yet been created.'),(3892,'Tax rates on shipping cost'),(1229,'Tax title'),(3178,'TaxJar Category'),(3177,'TaxJar Dashboard'),(3174,'TaxJar enabled'),(3889,'Taxable base'),(1230,'Taxes'),(1231,'Teaser'),(4812,'Template'),(4856,'Template is converted'),(3909,'Terms and conditions'),(1493,'Terms and conditions text'),(1996,'Test'),(4102,'Test Canada Post rates calculation'),(3318,'Test e-mail have been successfully sent'),(1232,'Test email configuration'),(1762,'Test email notification'),(1763,'Test email notification:'),(2071,'Test mode'),(2180,'Test mode: Live'),(2179,'Test mode: Test'),(2600,'Test rates'),(1233,'Test shipping rates'),(2080,'Test/Live mode'),(2739,'Test[TT]'),(1234,'Tester'),(1235,'Text'),(3803,'Text (ppcm)'),(3816,'Text color (ppcm)'),(64,'Text labels have been deleted'),(60,'Text labels have been updated successfully'),(65,'Text labels have not been deleted: no text labels have been found or specified'),(62,'Text labels have not been updated successfully: the default application language has been set as the translation language'),(63,'Text labels have not been updated successfully: the translation language has not been found'),(61,'Text labels have not been updated successfully: the translation language has not been specified'),(3842,'Text links'),(4738,'Text of response'),(4673,'Text of review'),(3815,'Text size (ppcm)'),(1930,'Textarea'),(244,'Thank you for registering a customer account, your profile has been created successfully'),(4488,'Thank you for subscribing to the newsletter! We hope you enjoy shopping at {{companyName}}'),(194,'Thank you for using company services'),(1236,'Thank you for your order'),(296,'Thank you for your order FOOTER'),(4679,'Thank your for sharing your opinion with us!'),(3430,'That payment method was not accepted for this transaction. Please choose another.'),(3927,'The \"Approved URL\" value must be exact as this'),(3402,'The \"Pay With Amazon\" feature is not configured and cannot be used.'),(3403,'The \"Pay with Amazon\" feature requires https to be properly set up for your store.'),(3926,'The \"Pricing currency\" value must be exactly the same as on it.'),(4758,'The \"Stripe\" feature is not configured and cannot be used.'),(4759,'The \"Stripe\" feature requires https to be properly set up for your store.'),(3533,'The \"{{code}}\" coupon does not exist'),(2853,'The \"{{file}}\" file is not allowed and was not uploaded. Allowed extensions are: {{extensions}}'),(3911,'The \"{{file}}\" file is not allowed image and was not uploaded. Allowed images are: {{extensions}}'),(1830,'The \"{{file}}\" file was not uploaded'),(1868,'The \"{{file}}\" is not CSV or archive'),(3878,'The \"{{saleDiscount}}\" discount does not exist'),(2224,'The \"{{value}}\" category does not exist'),(2258,'The \"{{value}}\" group is not created'),(2222,'The \"{{value}}\" image does not exist'),(2219,'The \"{{value}}\" membership does not exist'),(2220,'The \"{{value}}\" product class does not exist'),(2221,'The \"{{value}}\" tax class does not exist'),(3915,'The AppleIcon image could not be uploaded (Unallowed image type. Must be a .png image with the resolution of 192x192 px)'),(4266,'The Approved URL value must be exact as this:'),(3332,'The Backorder status will be reset for the items. The stock quantity of the backorder items will not change. Adjust it manually if necessary.'),(3319,'The Clean URL entered has unallowed chars.'),(2451,'The Clean URL entered is a redirect to object.'),(2771,'The Clean URL entered is already in use by target alias.'),(2450,'The Clean URL entered is already in use.'),(2772,'The Clean URL you have specified matches the name of a folder on your server.'),(4268,'The Declined URL value must be exact as this:'),(2110,'The English language cannot be removed as it is primary language for all texts.'),(1251,'The HTTPS protocol is enabled for your website'),(1237,'The SSL certificate installed for your custom website domain is not valid.'),(1238,'The SSL certificate installed on your server is not valid. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(4265,'The Store ID and HPP Key value must be exactly the same as on it.'),(268,'The X field is empty'),(1239,'The X language has been added and enabled successfully'),(53,'The X language has been added successfully'),(55,'The X language has been deleted successfully'),(58,'The X language has been disabled successfully'),(59,'The X language has been enabled successfully'),(154,'The X module has been installed incorrectly. Please see the logs for more information'),(152,'The X module has been installed successfully'),(153,'The X module has been installed with errors: the DB has not been modified correctly'),(155,'The X module has been installed, but the module has a wrong module control class'),(1950,'The address field has been added'),(1949,'The address field has been updated'),(1240,'The attachment has been added successfully'),(3582,'The attachment has been successfully re-upload'),(1952,'The attribute has been added'),(1951,'The attribute has been updated'),(193,'The benchmark evaluates server environment'),(2186,'The button is inactive either because no changes have been detected on the current page or because the order totals need to be recalculated before the order can be updated.'),(2698,'The calculation completed'),(2697,'The calculation failed'),(2485,'The calculation of quick data has been completed successfully.'),(2486,'The calculation of quick data has been stopped.'),(1948,'The category has been added'),(1947,'The category has been updated'),(1241,'The changes will be applied to all selected products'),(2452,'The clean URL will be generated automatically.'),(2419,'The common notification fields has been updated'),(4613,'The comparison table has been cleared.'),(195,'The confirmation URL link was mailed to email'),(196,'The confirmation URL link was sent'),(2127,'The confirmation URL link will be emailed to you shortly'),(2961,'The core may be checked only if a valid license key is present.'),(2761,'The count of categories specified for a product and the count of orderBy position numbers describing the position of the product within these categories must be the same.'),(1874,'The countries list for zone is empty. Please specify it.'),(2904,'The countries to which the selected states belong will be added to the zone automatically.'),(3493,'The coupon has been added'),(3489,'The coupon has been applied to your order'),(3494,'The coupon has been updated'),(1884,'The database has not been restored because of the errors'),(4804,'The database stores different version of the custom changes.'),(57,'The default interface language cannot be disabled'),(1242,'The detailed image has been added successfully'),(1243,'The detailed image has been deleted'),(1894,'The detailed image has not been deleted'),(1244,'The detailed images have been updated successfully'),(1557,'The directory \'var/backup/\' does not exist or is not writable.'),(3369,'The directory selected as a parent directory has already been specified as a child directory'),(4824,'The directory {{dir}} does not exist or is not writable.'),(3528,'The discount is valid for the selected delivery area'),(4993,'The dispute has been closed'),(3383,'The domain are you looking for is available for registration:'),(2658,'The download should start automatically. Click the link if does not start.'),(4923,'The dynamic message is empty for this notification.'),(72,'The edited language has not been found'),(197,'The email with your account information was mailed to email'),(3452,'The email you tried to use is already registered in our store. Please sign in the classic way.'),(3768,'The email you tried to use is already registered in our store. Please try logging in using your X account.'),(3568,'The endpoint field value must contain the full path'),(1245,'The exceptions have been updated successfully'),(1771,'The export is complete.'),(4980,'The field Body may not be blank'),(2618,'The file extension is forbidden'),(2750,'The file extension is forbidden ({{file}}'),(285,'The file was not loaded because of a failure on the server'),(1892,'The file was not loaded because of a failure on the server.'),(4823,'The file {{file}} does not exist or is not writable.'),(4237,'The files have been attached successfully'),(3638,'The following PIN codes have already been sold: {{codes}}'),(1247,'The following add-on(s) must be disabled'),(1246,'The following add-on(s) must be enabled'),(1248,'The following categories were selected to be removed'),(1249,'The following dependent add-ons will be disabled  automatically'),(1499,'The following expected input data have wrong format or empty: X'),(1622,'The following files are too large to be included in the archive'),(2351,'The following modules currently do not have a version compatible with the X-Cart version to which you are upgrading'),(131,'The following modules will be disabled'),(3873,'The following sale discounts apply to this product: X'),(2380,'The following selected modules cannot be disabled due to architecture limitations'),(2377,'The following selected modules cannot be disabled or uninstalled as they have dependent modules'),(2378,'The following selected modules cannot be enabled as they depend on disabled modules which cannot be enabled'),(1860,'The form could not be identified as a form generated by X-Cart'),(1955,'The front page has been updated'),(2372,'The generation of resized images has been completed successfully.'),(2373,'The generation of resized images has been stopped.'),(3400,'The global attributes changing process has been canceled.'),(3399,'The global attributes have been successfully changed.'),(3561,'The history of downloads feature for this product is disabled. You can enable it here'),(1250,'The image has been updated'),(2374,'The image resizing process may take a while to complete. Please do not close this page until the process is fully completed.'),(1252,'The import is in progress'),(3010,'The import process has been canceled'),(1253,'The importing starts immediately upon selecting the data file. No additional confirmation prompts will appear.'),(2441,'The key does not allow getting new features and upgrades.'),(1591,'The language CSV file should be a text file which contains 3 columns per row (columns are separated by comma:'),(73,'The language data has been saved'),(56,'The language has not been found'),(1585,'The language labels have been successfully imported:'),(52,'The language you want to add has already been added'),(51,'The language you want to add has not been found'),(54,'The language you want to delete has not been found'),(1254,'The language you want to delete is the default application language and cannot be deleted'),(1255,'The language you want to delete is the default interface language and cannot be deleted'),(3480,'The length of X field must be greater than Y'),(3481,'The length of X field must be less than Y'),(2229,'The length of value for the column \"{{column}}\" exceeds length of field and will be cut'),(48,'The link was copied to your clipboard'),(74,'The maximum file size that can be uploaded: X'),(1256,'The maximum number of uses'),(3524,'The maximum number of uses per user'),(4251,'The maximum size of the uploaded file is limited by the following parameters in your server settings: X and Y'),(1711,'The membership name cannot contain such symbols as \\, \' and \". Also, it cannot exceed 32 characters.'),(3902,'The menu has been added'),(3901,'The menu has been updated'),(1837,'The method is not configured and cannot be used'),(1481,'The module X has been uninstalled successfully'),(1257,'The module has been partially uninstalled'),(151,'The module has been uninstalled successfully'),(1736,'The module is incompatible with the new core version going to be installed'),(1258,'The module is not released for your X-Cart version'),(2962,'The module may be checked only if a valid license key is present.'),(2379,'The module may not be disabled due to the limitations of the module architecture.'),(150,'The module to uninstall has not been found'),(2116,'The module version is incompatible with your core version and cannot be enabled. Minimum core version required for this module is X.'),(2115,'The module version is incompatible with your core version and cannot be installed. Minimum core version required for this module is X.'),(156,'The modules have been updated'),(2248,'The name is empty'),(3120,'The name will be changed globally'),(3392,'The nameservers for your domain may have been entered incorrectly.'),(4531,'The newly created product is already in your [storefront]. Have a look! Ready to delete demo products?'),(4481,'The news message has been added'),(4480,'The news message has been updated'),(2420,'The notification has been updated'),(2226,'The number of values in the row does not match the number of column headers for this CSV file'),(1838,'The only remaining active administrator profile cannot be deleted.'),(3637,'The order also contains items with missing PIN codes; you will be prompted to enter the PIN codes under item names.'),(1940,'The order subtotal exceeds the maximum allowed value ({{max_order_amount}})'),(1984,'The order subtotal exceeds the maximum allowed value ({{max_order_amount}}), please remove some items from the cart.'),(1941,'The order subtotal less than the minimum allowed value ({{min_order_amount}})'),(1985,'The order subtotal less than the minimum allowed value ({{min_order_amount}}), please add some items to the cart.'),(1259,'The page has been added'),(3903,'The page has been updated'),(1759,'The password is the one you specified during checkout.'),(1760,'The password is the one you specified.'),(339,'The process of export is complete. You can follow this_link to check the results and download the files containing data.'),(1634,'The process of export may take much time. Please do not close this page until the export is complete'),(1633,'The process of export may take much time. You may close the page, the operation will be in progress as background. If the operation takes long enough, we will send you a notification when it is complete.'),(4364,'The process of feed generation may take a while to complete. Please do not close this page until the process is fully completed.'),(1520,'The process of import may take much time. Please do not close this page until the import is complete'),(1519,'The process of import may take much time. You may close the page, the operation will be in progress as background. If the operation takes long enough, we will send you a notification when it is complete.'),(2484,'The process of quick data calculation may take a while to complete. Please do not close this page until the process is fully completed.'),(2699,'The process of sales calculation may take a while to complete. Please do not close this page until the process is fully completed.'),(3998,'The process of sitemap generation may take a while to complete. Please do not close this page until the process is fully completed.'),(4967,'The product SKU#\"X\" is already set as Related for the product'),(2066,'The product SKU#\"X\" is already set as featured for the category'),(4964,'The product SKU#\"X\" is already set as related for the product'),(4636,'The product filter cache has been removed successfully.'),(2617,'The product for which you attempted to upload an attachment has not been found'),(2421,'The product has been added'),(4612,'The product has been added to the comparison table'),(4611,'The product has been removed from comparison table'),(2168,'The product has been updated'),(1260,'The product option group has been added successfully'),(1261,'The product option group has been updated successfully'),(1262,'The product option groups have been updated successfully'),(1263,'The product option groups have not been successfully updated'),(1954,'The product selection has been added'),(1953,'The product selection has been updated'),(4207,'The product tab has been added'),(4206,'The product tab has been updated'),(2218,'The product with \"{{value}}\" SKU does not exist'),(4223,'The product with SKU \"{{value}}\" does not exist. The tab \"{{tab_name}}\" will not be imported'),(3014,'The product you are trying to add to cart is unavailable'),(3560,'The product\'s history of downloads is empty'),(4147,'The products return has been registered.'),(1492,'The profile has been registered. The password has been sent to the user\'s email address'),(1491,'The profiles have been merged'),(1584,'The provided file contains the following language labels:'),(1264,'The requested page could not be found.'),(1270,'The restoration procedure is irreversible and erases all data tables from your store database. It is highly recommended that you back your present database data up before restoring one of the previous states from a back-up.'),(3975,'The role has been added'),(3974,'The role has been updated'),(3866,'The sale discount has been added'),(3865,'The sale discount has been updated'),(3863,'The sale discount will be limited to customers with membership levels specified here'),(3862,'The sale discount will be limited to product classes specified here'),(3864,'The sale discount will be limited to the delivery area specified here'),(1271,'The same as shipping'),(3581,'The same file can not be assigned to one product'),(1974,'The script found {{number}} errors during import'),(4951,'The script found {{number}} errors during update inventory'),(1973,'The script found {{number}} errors during verification'),(2835,'The secure protocol for your website is disabled.'),(2836,'The secure protocol for your website is enabled.'),(2530,'The secure protocol is enabled for your website. But X-Cart hasn\'t found the valid SSL certificate on your server.'),(3008,'The selected categories have been deleted. There are products with no assigned category.'),(3526,'The selected date is outside the allowed date range'),(1859,'The selected payment method is obsolete or invalid. Select another payment method'),(1272,'The selected shipping markups have been deleted successfully'),(164,'The selected shipping method has been deleted successfully'),(166,'The selected zones have been deleted successfully'),(2181,'The service name X is reserved and cannot be used for an address field.'),(1867,'The settings of payment method successfully updated'),(2188,'The specified amount of product exceeds maximum amount of product in stock'),(1273,'The state has been added successfully'),(261,'The string is different from that of the title number of columns - X instead of Y'),(2394,'The system detects that some updates are available for enabled modules. It is strongly recommended to have all enabled modules updated to latest version for better compatibility before the install new ones from Marketplace.'),(2509,'The system has been restored to the selected snapshot of X'),(2676,'The system has detected one or more problems with some of the modules at your store:'),(1741,'The system has detected that some custom modifications were made by editing core and module files, not by writing new modules. In order to proceed with the upgrade you should decide what to do with the modifications'),(2684,'The system has detected that the license key that was activated for your store is invalid.'),(2510,'The system has failed to restore because there was no snapshot of X'),(1958,'The tax class has been added'),(1957,'The tax class has been updated'),(4818,'The template has been added'),(4817,'The template has been updated'),(4873,'The test email notification has been sent to X'),(70,'The text label has been added successfully'),(66,'The text label has been deleted'),(71,'The text label has been modified successfully'),(68,'The text label has not been added, because its name has not been specified'),(1274,'The text label has not been added, because its translation to the default application language has not been specified'),(1275,'The text label has not been added, because its translation to the default interface language has not been specified'),(69,'The text label has not been added, because such a text label already exists'),(67,'The text label has not been deleted: it has been either not found or not specified'),(1276,'The text label has not been modified, because its translation to the default application language has not been specified'),(1277,'The text label has not been modified, because its translation to the default interface language has not been specified'),(4252,'The total size of the attached files should not exceed X per once'),(3121,'The totals have been recalculated. Press \"Save changes\" to adjust the order'),(1278,'The upgrade is completed. Please, do not close this page until you check your web site and check that everything works properly'),(4514,'The uploaded image is too large.'),(205,'The user will be registered; a password will be sent to the user via email'),(2228,'The value in the column \"{{column}}\" will be adjusted according to HTML specification to prevent potential XSS attack'),(2724,'The value must be greater than the current maximum order number in the order list'),(1714,'The value must be in range'),(271,'The value of the X field has an incorrect format'),(269,'The value of the X field must be greater than Y'),(270,'The value of the X field must be less than Y'),(272,'The value of the X field should not be longer than Y'),(1537,'The values are average'),(3988,'The volume discount has been added'),(3989,'The volume discount has been updated'),(4808,'Theme tweaker'),(3153,'There are %model% with missing %another_model%'),(3152,'There are %model% without valid %another_model% relation'),(2473,'There are no activated license keys'),(1279,'There are no categories'),(4726,'There are no comments yet. Be the first to leave a comment'),(1564,'There are no images loaded for this product'),(3161,'There are no inconsistencies found'),(1496,'There are no labels translated to X'),(1280,'There are no markups selected'),(2753,'There are no permissions to import user access level'),(2755,'There are no permissions to import user roles'),(1281,'There are no rates available for specified source/destination and/or package measurements/weight.'),(1797,'There are no shipping methods available'),(1646,'There are no shipping methods defined for this carrier'),(4845,'There are some custom CSS styles in your store. These styles may affect the look of the installed template. Review the custom styles and disable them if necessary.'),(4846,'There are some custom templates in your store that may contain skin dependent code.'),(2528,'There are unsaved changes on the page. If you choose to continue, these changes will be lost. Do you want to proceed?'),(1172,'There is a maximum purchase limit of MaxQuantity'),(1171,'There is a minimum purchase limit of MinQuantity'),(176,'There is already an account with your email address. You can sign in or continue as guest'),(2899,'There is already state with code {{code}} in {{country}}'),(2487,'There is no data to process.'),(4281,'There is no products for facebook product feed generation'),(4922,'There is no special code for this notification'),(3487,'There is no such a coupon, please check the spelling: X'),(1283,'There is no user with specified email address'),(3158,'There is one valid root category, however there are multiple root category candidates'),(1284,'There were no orders placed'),(408,'There\'s no payment method available'),(4072,'There\'s no post offices available'),(3589,'These Open Graph meta tags were generated automatically based on general product information.'),(1990,'These attributes can be applied to all the products in the store.'),(1988,'These attributes can be applied to the \"{{name}}\" product class.'),(1989,'These attributes can only be applied to this particular product.'),(1285,'These components require your attention'),(1286,'These components will be updated'),(1287,'These instructions will appear below the order invoice on the page which customers see after they confirm their order.'),(1288,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process'),(2026,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process.'),(2794,'These options separated by X, you can change it by modify X label'),(4864,'This action will remove all flexy-templates. Are you sure to proceed?'),(1815,'This address was used as a'),(1290,'This address was used as a billing address during the recent purchase'),(1291,'This address was used as a shipping address during the recent purchase'),(3506,'This comment will be visible to shop administrators only'),(1292,'This component is automatically calculated by shipping add-on module and cannot be edited'),(2325,'This content shows via %dynamic_message% variable. Do not use this variable to put content (if it exists) below the main message'),(3515,'This coupon cannot be combined with other coupons'),(1293,'This e-mail address is already in use by another user.'),(1294,'This email address is used for an existing account. Enter another email address or sign in'),(2459,'This feature is available only for paid (non-free) X-Cart license plans'),(4064,'This feature is not yet available. You will be redirected to the feature request page where you can vote to have this feature implemented in one of the upcoming versions.'),(4325,'This field can be used to set a fixed shipping fee for the product. Make sure the field value is a positive number (greater than zero).'),(188,'This field is required'),(3469,'This field is required.'),(1295,'This is a default zone which covers all addresses. It\'s impossible to edit this zone\'s countries, states etc'),(222,'This is a demo store with powerful X-Cart engine inside'),(3956,'This is a user specified message that gets printed on the bottom of the label. A string of up to 50 characters can be printed on the label.'),(3954,'This is a user specified message that gets printed on the face of the label. A string of up to 50 characters can be printed on the label.'),(5016,'This is subscription product'),(3647,'This is the login name you created when signing up for PayPal Payments Advanced.'),(3654,'This is the login name you created when signing up for Payflow.'),(3655,'This is the password you created when signing up for PayPal Payflow or the password you created for API calls.'),(3649,'This is the password you created when signing up for PayPal Payments Advanced or the password you created for API calls.'),(405,'This language is added by module and cannot be removed.'),(3089,'This message can be removed only through activation of a free or premium license.'),(1641,'This method does not support the current store currency and is not available for customers'),(2701,'This method is displayed because you are logged in as admin and operating as another user'),(1642,'This method is in test mode'),(319,'This module is available for X-Cart hosted stores only.'),(2041,'This module uses PHP\'s cURL functions which are disabled on your web server'),(1296,'This month'),(1793,'This operation is irreversible. Are you sure you want to proceed?'),(3441,'This operation will cancel order. Payment authorization will be voided. Please confirm to proceed.'),(3442,'This operation will capture funds from customer. Please confirm to proceed.'),(3443,'This operation will refund funds to customer. Please confirm to proceed.'),(3373,'This option applies only to attributes with multiple values'),(3329,'This order was placed at the same time as {{orders}}; as a result, some items were out of stock at the time of order placement.'),(2337,'This page allows you to adjust the types of email notifications your store sends to users'),(1539,'This page allows you to configure Shipping methods, zones and charges.'),(1546,'This page allows you to edit global attributes, which are available for all products in your store, and attributes specific for classes of your products.'),(2500,'This page is intended for the creation and management of discount coupons.'),(2505,'This page is intended for the management of volume discounts based on the order subtotal.'),(1644,'This payment method cannot be enabled until you configure it'),(3320,'This payment method is'),(2309,'This payment method is Active.'),(2310,'This payment method is Inactive.'),(2837,'This payment method is not configured.'),(2912,'This process may take much time. Please do not close this page until the task is complete'),(169,'This product has been added to your bag'),(4960,'This product is no longer available although you may find similar or newer version below.'),(38,'This product is out of stock or it has been disabled for sale'),(3835,'This product will be shown in coming soon section'),(3834,'This product will be shown in new arrivals'),(1302,'This quarter'),(1299,'This section displays order placement statistics'),(1535,'This section displays order processing statistics'),(3674,'This setting determines whether or not the \"Buy Now with PayPal\" button should be displayed on product list pages (in list view) and product details pages.'),(2602,'This shipping method is'),(2603,'This shipping method is not configured.'),(3653,'This should be the same partner name that is used when logging into your PayPal Payflow account.'),(1300,'This site requires JavaScript to function properly.'),(2495,'This tool allows you to get rid of any content that might have been created in your store for testing purposes and which you no longer need.'),(177,'This user name is used for an existing account. Enter another user name or sign in'),(3847,'This value must be set in exactly the same way as it is set on the payment gateway end.'),(1618,'This value will be added to new products or class assigns automatically'),(1301,'This week'),(340,'This will increase the shipping cost by XX'),(1303,'This year'),(2216,'Three columns'),(1304,'Through'),(1305,'Thumbnail'),(2838,'Time left'),(1419,'Timeout error'),(2323,'Tip from X-Cart'),(1306,'Title'),(3345,'Title for customers'),(11,'To activate your X-Cart license, enter your secret key into the field below and click Activate.'),(12,'To activate your X-Cart or commercial module license, enter your license key into the field below and click Activate.'),(273,'To boost your sales try to use Discounts coupons, Sale, Product Advisor, Volume discounts addons. Also you may be interested in all Marketing extensions from our Marketplace'),(1766,'To change the password, log into your company account and use the \'Modify profile\' link'),(1599,'To change the roles of your profile, contact the store administrator'),(4802,'To complete the StripeApplePay configuration'),(1310,'To contact us please fill the form below'),(1411,'To continue, please, sign in'),(1311,'To email'),(333,'To enable secure protocol for your website pages you need a valid SSL certificate purchased for the website domain and installed on your server.'),(3710,'To enable this payment method, you need <Multi-vendor> module installed.'),(3709,'To enable this payment method, you need Multi-vendor module installed.'),(3877,'To ensure that products sorting and the addon Product Filter works correctly, after changing or adding sale offers, launch the re-calculation of quick data.'),(275,'To fix this problem, do the following: 3 points'),(258,'To get the format of the import data you can export your products to a file'),(1545,'To have attributes specific for product classes, define product classes first.'),(332,'To make the online store use the secure protocol you need an SSL certificate purchased for the website domain and installed on your server.'),(2523,'To make your changes visible in the customer area, cache rebuild is required. It will take several seconds. You don’t need to close the storefront, the operation is executed in the background.'),(1312,'To place the order please accept Terms and Conditions'),(1313,'To place the order please complete the previous steps first'),(1314,'To recover your password, please type in the valid e-mail address you use as a login'),(4068,'To request a return please fill the form below'),(3179,'To send email asynchronously and improve website performance we recommend to set up queues in on your server. [Learn how to do it].'),(3923,'To set up the integration you should follow '),(4264,'To set up the integration, go to the _Site management_'),(13,'To setup Tax Rates, find and install the appropriate addons from Marketplace'),(2839,'To setup Tax Rates, find and install the appropriate addons from Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Taxes'),(4106,'To start registration process for Canada Post merchant account click on the \"Register\" button.'),(3498,'To use the coupon, your order subtotal must be at least X'),(3497,'To use the coupon, your order subtotal must be between X and Y'),(3499,'To use the coupon, your order subtotal must not exceed Y'),(1315,'Today'),(3981,'Too large value for absolute discount'),(2687,'Tools'),(3807,'Top (ppcm)'),(4476,'Top News'),(191,'Top X products'),(80,'Top banner'),(1316,'Top sellers'),(1317,'Top selling products'),(210,'Total'),(4412,'Total amount of orders'),(4091,'Total items weight'),(4130,'Total weight'),(1772,'Totals'),(1175,'Track package'),(4135,'Tracking details'),(1183,'Tracking information has been sent'),(3934,'Tracking information was updated successfully'),(2417,'Tracking number'),(1181,'Tracking number is changed from \"{{old_number}}\" to \"{{new_number}}\"'),(1178,'Tracking numbers'),(4085,'Tracking pin'),(4073,'Tracking pins'),(3600,'Traditional'),(2423,'Transaction'),(2840,'Transaction ID'),(2085,'Transaction amount mismatch'),(5064,'Transaction for order has failed'),(5063,'Transaction for this order has failed. Next charge attempt will be at'),(3198,'Transaction is in progress'),(3457,'Transaction key'),(3360,'Transaction made'),(2054,'Transaction type'),(3258,'Transaction was failed'),(2650,'Transactions details'),(1318,'Translation driver'),(105,'Translations'),(4126,'Transmit shipment'),(3389,'Trial Plan'),(3105,'Trial has expired!'),(304,'Trial period X days'),(1992,'Trial period expires today'),(1991,'Trial period is expired'),(4041,'Try clearing filters or different search terms.'),(1791,'Try search-as-you-type feature...'),(1857,'Try to change the search criteria or find the needed solution in marketplace'),(2841,'Try to change the search criteria or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(3766,'Try to reconnect'),(1858,'Try to search worldwide or find the needed solution in marketplace'),(2842,'Try to search worldwide or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(1459,'Try to unpack them manually'),(274,'Trying to access the shop at X'),(2608,'Trying to run pre-upgrade hooks while not all archives were unpacked'),(3587,'Tweet'),(4855,'Twig-template path'),(1319,'Twitter'),(2215,'Two columns with left sidebar'),(2214,'Two columns with right sidebar'),(1320,'Type'),(1321,'Type of Account'),(3413,'Type of authorization request'),(4399,'Type: checkbox'),(4398,'Type: select box'),(3928,'U.S.P.S. module allows you to use online shipping rates calculation via USPS Web Tools Ecommerce API.'),(2643,'UPS'),(4935,'UPS module allows to use online shipping rates calculation via UPS service.'),(4822,'URL'),(4267,'URL is copied'),(1626,'URLs'),(2644,'USPS'),(3933,'USPS Shipments'),(1869,'Unable to delete file'),(1482,'Unable to delete module X files: some dirs have no writable permissions: Y'),(2747,'Unable to download the contents of {{url}}'),(2749,'Unable to get at the contents of {{url}}'),(3970,'Unable to get merchant info'),(279,'Unable to install module X because some modules, which it depends on, have not been installed or activated yet'),(4895,'Unable to reset layout'),(4897,'Unable to save changes'),(4850,'Unable to save edited content. Errors: '),(2746,'Unable to write data to file {{file}}'),(2682,'Unallowed modules will be disabled automatically on the next visit any page in the administrator interface.'),(2064,'Unavailable'),(3572,'Unblock and renew'),(1324,'Uncheck all'),(93,'Undelete'),(1325,'Understanding Online Payments'),(3780,'Unexpected error'),(1326,'Unexpected error: version value is not passed'),(4261,'Unexpected result was received from ePDQ (transaction status is not set)'),(4389,'Unexpected result was received from iDEAL (transaction status is not set)'),(3449,'Unfortunately, we cannot ship to the specified country'),(1410,'Unfortunately, you don\'t have permissions to access this page.'),(3693,'Unfortunately, your API credentials could not be obtained from your PayPal account automatically.'),(1327,'Uninstall'),(1328,'Units & Formats'),(1329,'Units of measurement'),(3601,'Universal Analytics'),(1330,'Unknown'),(2960,'Unknown core version'),(3321,'Unknown error'),(3636,'Unknown error occurred'),(1500,'Unknown language: X'),(4394,'Unknown payment transaction'),(2170,'Unknown payment. If you see this message after returning from the payment page, please contact the store administrator for information about the status of your payment.'),(4851,'Unknown temporary file'),(2089,'Unlimited'),(4096,'Unpackaged'),(1331,'Unpacking archives, please wait...'),(4975,'Unread'),(1747,'Unselect all'),(1332,'Unset'),(4238,'Unsupported file extension'),(39,'Update'),(4401,'Update MailChimp Lists'),(3971,'Update date'),(1333,'Update exceptions'),(1980,'Update existing items, but skip new items'),(1334,'Update module'),(2852,'Update modules'),(1335,'Update product'),(1336,'Update profile'),(4949,'Update quantity'),(4956,'Update quantity import guide'),(4469,'Update store data'),(3972,'Update tracking info'),(1337,'Updated components'),(1338,'Updates are available'),(1340,'Updates for the X-Cart core and/or installed modules are available'),(1341,'Updates for your version ({{version}})'),(2843,'Updating data from the marketplace...'),(1342,'Upgrade'),(2474,'Upgrade access level cannot be changed for default free license'),(2470,'Upgrade access level has been successfully assigned to your license keys'),(2471,'Upgrade access level tooltip message'),(1343,'Upgrade available'),(1344,'Upgrade core'),(1733,'Upgrade for X-Cart core is available'),(1345,'Upgrade module'),(2868,'Upgrade not allowed'),(2350,'Upgrade note'),(3085,'Upgrade phar warning'),(1346,'Upgrade to version {{version}}'),(1347,'Upload'),(4545,'Upload a new logo'),(1348,'Upload add-on'),(1349,'Upload and restore'),(4506,'Upload company logo'),(1350,'Upload file'),(3041,'Upload file size limit'),(1515,'Upload files'),(1550,'Upload from server'),(1551,'Upload from your computer'),(4825,'Upload image'),(4933,'Upload images and setup your banners to showcase top products or promote new sales.'),(4451,'Upload store data to MailChimp'),(87,'Upload via URL'),(4927,'Upload your brand logos to include in the store header and browser tab.'),(4538,'Upload your company logo'),(4470,'Uploading data has been completed successfully.'),(4471,'Uploading data has been stopped.'),(3668,'Use PayPal authentication method'),(3564,'Use X-Sendfile to facilitate the download of large file attachments (100 Mb and larger) by customers:'),(1351,'Use a merchant account from your financial institution or choose a bundled payment solution to accept credit cards and other methods of payment on your website.'),(1352,'Use a merchant account from your financial institution to accept online payments'),(4803,'Use custom css'),(1353,'Use custom js'),(1355,'Use default logo'),(1357,'Use dynamic image help'),(1356,'Use dynamic image resizing'),(3444,'Use existing Amazon account'),(3704,'Use existing PayPal account'),(3702,'Use existing account from'),(1354,'Use lazy loading'),(3845,'Use of Restriction key must be disabled in your Quantum Gateway merchant center account at all times.'),(3726,'Use of the unsupported Payment Data Transfer (PDT) method has been detected'),(2036,'Use our new nifty module to automatically backup your store and be able to restore it if anything crops up.'),(4929,'Use the Description Editor toolbar below to select and edit text on your store pages.'),(4889,'Use the Google Tag Manager addon for more flexibility when adding JS code to your web pages.'),(4286,'Use the addon Google Product Feed for advanced flexibility generating a data feed for Facebook based on the product attributes and variants from your store catalog'),(1358,'Use the category name'),(1768,'Use the following key to access safe mode'),(2286,'Use the form below to provide your license information.'),(1359,'Use the navigation bar above this dialog to navigate through the catalog categories'),(3893,'Use the same tax rates for all user membership levels'),(4005,'Use this X-Cart and Google Ads integration to:'),(3952,'Use this field for instructions in case the package is not delivered.'),(1360,'Use this section to back the database of your online store up. Please note that the database backup procedure can take up to several minutes.'),(1554,'Use this section to back up the database of your online store. Please note that the database backup procedure can take up to several minutes.'),(1361,'Use this section to define shipping zones.'),(1362,'Use this section to define your store\'s shipping methods.'),(1363,'Use this section to manage the list of existing countries. This list is used in the shipping settings and calculations, and in the registration form at the Customer Front-end.'),(1364,'Use this section to manage the lists of counties, provinces, regions and states of different countries. The lists are used in shipping settings and calculations, and in the registration form at the Customer Front-end.'),(1365,'Use this section to restore the database of your online store. Please note that the database restoration procedure can take up to several minutes'),(1366,'Use this section to review the list of existing membership levels and add new ones'),(2083,'User'),(242,'User X is logged in'),(1731,'User activity'),(1774,'User filled in Contact Us form'),(4582,'User manuals, release notes, modules, videos and more.'),(1367,'User membership'),(1368,'User type'),(1369,'Username or e-mail'),(1370,'Users'),(3135,'Users list'),(1371,'Uses count'),(1372,'Uses left'),(2679,'Using the modules with this type of license violation is illegal'),(2301,'VALID THRU'),(1373,'VAT'),(3532,'Valid only for specific products'),(1374,'Validate key'),(1375,'Value'),(4289,'Value for the \"Add to cart\" event is calculated as'),(4293,'Value for the \"InitiateCheckout\" event is calculated as'),(4292,'Value for the \"ViewContent\" event on a product page is calculated as'),(2375,'Variables for this notification'),(2223,'Variant attribute \"{{column}}\" cannot be empty'),(3759,'Venmo'),(1521,'Verification results'),(2364,'Verified'),(4507,'Verify geo settings'),(2365,'Verifying data before importing...'),(1376,'Version'),(1377,'Version change'),(86,'Via URL'),(1942,'View all addons'),(1754,'View all low inventory products'),(1378,'View all open orders'),(2142,'View all ordered items'),(4576,'View all payment methods'),(217,'View cart'),(84,'View image'),(1666,'View in list'),(3322,'View in my addons'),(1379,'View logs'),(2469,'View more addons in Marketplace'),(2706,'View order history'),(1380,'View profile'),(2387,'View storefront'),(1381,'View system logs'),(1382,'View update log'),(3900,'Visible for'),(4626,'Visible in products filter'),(1383,'Visit module details page'),(1384,'Visit storefront'),(2516,'Visit the template store'),(2103,'Void'),(2732,'Void multiple[TT]'),(2731,'Void partially[TT]'),(4124,'Void shipment'),(2696,'Void[S]'),(2730,'Void[TT]'),(1386,'Volume discount'),(3985,'Volume discount can be limited to customers with these address zones'),(3984,'Volume discount can be limited to customers with this membership level'),(1385,'Volume discounts'),(4705,'Votes: X'),(1681,'WARNING! There are no more available administrators\' profiles. You will not be able to manage your store after you delete this profile.'),(360,'WE'),(3602,'Want help with SEO? Ask X-Cart Guru'),(2622,'Want to change or add another accounting system? Choose the accounting system you require below and configure it.'),(3149,'Want to customize review surveys and display video testimonials? Try Shopper Approved and collect up to 70x more ratings and reviews'),(3778,'Want to use another account?'),(1387,'Warning'),(1700,'Warning!'),(1720,'Warning! CSV file was not specified.'),(1698,'Warning! InnoDB engine is not supported. It is required for software operation'),(1656,'Warning! Installing this module will overwrite all language labels translated to the appropriate language.'),(4392,'Warning! Please re-check public and private key values!'),(1723,'Warning! The file you have specified in the \'File (CSV) for upload\' field has not been uploaded to the server.'),(1721,'Warning! The file you have specified in the \'File (CSV) local\' field does not exist or cannot be read.'),(3107,'Warning! The image cannot be resized to reduce capacity for better site performance.'),(2496,'Warning! The selected types of content data will be deleted permanently.'),(1388,'Warning! There is not enough product items in stock to process the order'),(4391,'Warning! This payment method requires OpenSSL extension. Please install and enable this extension in your PHP configuration.'),(1552,'Warning: The restoration procedure is irreversible and erases all the data tables from the store database. It is highly recommended that you back up your current database before restoring one of the previous states from a back-up.'),(1389,'Warning: this operation can not be reverted!'),(2722,'Warnings'),(309,'Watch this short video and learn the basics of how online payment processing works'),(1390,'Watch video'),(4178,'Way to deliver'),(1498,'We are already aware of this problem and working on it. If you would like to get in touch, feel free to contact us via our Help center at _URL_'),(3475,'We are always glad to help you.'),(2035,'We are doing our best to make your upgrade process not only easy to do, but safe.'),(3754,'We are experiencing a problem with the \"PayPal For Marketplaces\" payment method.'),(3156,'We couldn\'t find one correct root category'),(3157,'We couldn\'t find one correct root category, however there are possible candidates'),(1504,'We have found a valid SSL certificate installed on the server. Now you can switch the store to use the secure protocol for the store back-end and checkout, sign-in and profile pages.'),(3588,'We recommend to use share button instead of like'),(4590,'We support 120+ payment gateways'),(4691,'We use this email in case we need additional information on your review. We do not use it for any kind of mailing lists or spam subscriptions'),(2037,'We will email you with emergency links to disable custom modules and stay only with original add-ons.'),(4553,'We will use this info to create invoices, send emails and calculate shipping rates for your customers.'),(4549,'We\'ve tried to guess your country, currency and weight. Verify, please.'),(3338,'Weak password'),(4420,'Web ID'),(1391,'Web server'),(4227,'Web server max number of files limit is X'),(4226,'Web server max upload file size limit is X'),(4778,'Webhook URL is your store\'s URL through which Stripe informs your store about any changes in the order'),(3751,'Webhook listener error: could not subscribe to event(s).'),(4814,'Webmaster Mode allows you to change the storefront design in click-and-edit mode'),(4811,'Webmaster mode'),(4816,'Webmaster mode is disabled'),(4815,'Webmaster mode is enabled'),(1749,'Website'),(383,'Week'),(5036,'Weekly'),(26,'Weight'),(27,'Weight X'),(1392,'Weight modifier'),(2576,'Weight range'),(1601,'Welcome'),(208,'Welcome to X-Cart'),(4591,'What about adding some marketing magic to your sales process?'),(1393,'What is benchmark?'),(1607,'What to export'),(2562,'What type of shipping rates would you like to use?'),(306,'What\'s new'),(3453,'When AustraliaPost returns shipping methods which does not exists in the available methods list, these methods will be created in the list automatically'),(3756,'When multiple funding sources are available to the buyer, PayPal automatically determines which additional buttons are appropriate to display. However, you can choose to opt-in or out-of displaying specific funding sources.'),(1394,'When the export is completed, you will be prompted to download the product data file'),(1617,'Whether customers should be able to select an option they require when ordering the product, or the information is provided purely as part of product specification'),(3818,'White (no border) (ppcm)'),(3812,'White (ppcm)'),(3879,'Wholesale prices for this product are disabled because its sale price is set as an absolute value (X). To enable wholesale prices, use the relative value in % for the Sale field.'),(3880,'Wholesale prices for this product variant are disabled because its sale price is set as an absolute value (X). To enable wholesale prices, use the relative value in % for the Sale field.'),(1889,'Widgets cache has been cleaned'),(1890,'Widgets cache has not been cleaned completely'),(2051,'Width'),(1395,'Width (px)'),(3118,'Will be added globally'),(3119,'Will be added to the product class'),(2985,'Will be available if core update is selected'),(2399,'Will be deleted:'),(1735,'Will be installed'),(2396,'Will be updated if core update is selected'),(2637,'Win app'),(3257,'Wonder why it may have happened? It’s likely that your customer entered a wrong card number, password or CVC'),(5000,'Write your message'),(4693,'Write your review'),(2267,'Wrong \"default\" format ({{value}}). Value should be one of \"Yes\" or \"No\"'),(4285,'Wrong \"facebook marketing enabled\" format'),(2266,'Wrong \"owner\" format ({{value}}). Value should be one of \"Yes\" or \"No\"'),(2268,'Wrong \"priceModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%'),(2265,'Wrong \"type\" value ({{value}}). This should be \"C\", \"S\", \"H\" or \"T\"'),(2269,'Wrong \"weightModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%'),(2754,'Wrong access level format'),(2274,'Wrong added format'),(2926,'Wrong address same format'),(2925,'Wrong anonymous format'),(2241,'Wrong arrival date format'),(2281,'Wrong billing address format'),(2251,'Wrong box height format'),(2250,'Wrong box length format'),(2249,'Wrong box width format'),(3931,'Wrong container type selected: {{value}}. For large package size only the following types are allowed: RECTANGULAR, NONRECTANGULAR, VARIABLE'),(2282,'Wrong country code format'),(2929,'Wrong currency format'),(2242,'Wrong date format'),(2262,'Wrong display mode format for not selector'),(2261,'Wrong display mode format for selector'),(2236,'Wrong enabled format'),(4331,'Wrong exclude from shipping cost format'),(2275,'Wrong first login date format'),(2253,'Wrong format of Clean URL value (allowed alpha-numeric, \"_\" and \"-\" chars)'),(2449,'Wrong format: Field contains unallowed characters'),(4332,'Wrong free shipping format'),(4322,'Wrong freight fixed fee format'),(2244,'Wrong inventory tracking format'),(2944,'Wrong item order modifier format'),(2252,'Wrong items per box format'),(2279,'Wrong language format'),(2276,'Wrong last login date format'),(2273,'Wrong login format'),(2247,'Wrong low limit level format'),(2246,'Wrong low stock notification format'),(2237,'Wrong meta desc type format'),(1396,'Wrong method_id specifed'),(2942,'Wrong order item backordered quantity format'),(2935,'Wrong order item format'),(2937,'Wrong order item name format'),(2938,'Wrong order item price format'),(2941,'Wrong order item quantity format'),(2936,'Wrong order item sku format'),(2939,'Wrong order item subtotal format'),(2940,'Wrong order item total format'),(2934,'Wrong order modifier format'),(2924,'Wrong order number format'),(2951,'Wrong order transaction currency format'),(2945,'Wrong order transaction format'),(2950,'Wrong order transaction id format'),(2946,'Wrong order transaction method format'),(2948,'Wrong order transaction value format'),(2257,'Wrong position format'),(2235,'Wrong price format'),(4953,'Wrong product quantity value format (\"{{value}}\")'),(2278,'Wrong referer format'),(2756,'Wrong role format'),(2239,'Wrong shippable format'),(2280,'Wrong shipping address format'),(2272,'Wrong show title format'),(2283,'Wrong state id format'),(2277,'Wrong status format'),(2245,'Wrong stock level format'),(2927,'Wrong subtotal format'),(3706,'Wrong token of Express Checkout. Please try again. If the problem persists, contact the administrator.'),(2928,'Wrong total format'),(2260,'Wrong type format'),(2243,'Wrong update date format'),(2240,'Wrong use separate box format'),(4633,'Wrong useClasses format'),(1397,'Wrong value is specified for arrival date field. The field was not updated.'),(2238,'Wrong weight format'),(249,'X GB'),(139,'X Language (Code: Y)'),(248,'X MB'),(3622,'X PIN Codes were not assigned.'),(3605,'X PIN code duplicates ignored.'),(3606,'X PIN codes created successfully.'),(3607,'X PIN codes longer than Y characters ignored.'),(3142,'X addon'),(1494,'X addon(s) selected'),(3143,'X addons'),(3144,'X addons (5)'),(317,'X attributes in group'),(246,'X bytes'),(3486,'X code is already used for other coupon, please specify a different code'),(3485,'X coupon(s) has been created'),(3484,'X coupon(s) has been removed'),(3102,'X day left'),(253,'X days'),(3103,'X days left'),(3104,'X days left (5)'),(3855,'X discount(s) has been created'),(3856,'X discount(s) has been removed'),(291,'X entities has been created'),(290,'X entities has been removed'),(2171,'X expired shopping cart(s) have been successfully removed'),(189,'X field is required'),(1489,'X file type'),(4235,'X file(s) attached'),(254,'X hours'),(263,'X image unable to load'),(212,'X item'),(286,'X item available'),(158,'X item in bag'),(173,'X items'),(4760,'X items ($)'),(287,'X items available'),(159,'X items in bag'),(2866,'X items selected'),(247,'X kB'),(98,'X labels'),(407,'X language labels have been removed'),(406,'X languages have been removed'),(310,'X methods available'),(255,'X minutes'),(192,'X module settings'),(2352,'X module will be disabled'),(2354,'X module will be upgraded'),(2494,'X modules selected'),(2353,'X modules will be disabled'),(2355,'X modules will be upgraded'),(252,'X months'),(4986,'X new message for order'),(5011,'X new messages'),(3511,'X off'),(237,'X order'),(238,'X orders'),(321,'X orders on last day'),(323,'X orders on last month'),(322,'X orders on last week'),(5065,'X payment total of X'),(3531,'X product(s) added'),(289,'X product(s) has been created'),(288,'X product(s) has been removed'),(341,'X products'),(243,'X products found'),(4604,'X products selected'),(235,'X results found'),(324,'X revenue on last day'),(326,'X revenue on last month'),(325,'X revenue on last week'),(256,'X seconds'),(418,'X shipping methods have been created'),(419,'X shipping methods have been removed'),(4652,'X star_1'),(4651,'X stars_2'),(4650,'X stars_3'),(4649,'X stars_4'),(4648,'X stars_5'),(410,'X states have been removed'),(411,'X states have been successfully created'),(5025,'X subscriptions'),(4982,'X unread messages'),(251,'X years'),(412,'X zones have been removed'),(413,'X zones have been successfully created'),(4515,'X% Wizard completion'),(335,'X, including images and file attachments'),(1398,'X-Cart'),(3098,'X-Cart Business trial will expire in X day'),(3099,'X-Cart Business trial will expire in X days'),(3100,'X-Cart Business trial will expire in X days (5)'),(4000,'X-Cart Google Ads by Kliken'),(106,'X-Cart News'),(2905,'X-Cart Team have done their best to make your upgrade process as enjoyable as possible.'),(2542,'X-Cart could not find a valid SSL certificate on your server X.'),(2541,'X-Cart could not find a valid SSL certificate on your server.'),(2540,'X-Cart could not find a valid SSL certificate on your server. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(2163,'X-Cart could not find data in your file.'),(2529,'X-Cart found some issues with installed SSL certificate'),(2438,'X-Cart license key has been successfully verified'),(2439,'X-Cart license key has been successfully verified and activated. But this key has expired and do not allow upgrade store.'),(1399,'X-Cart online store builder'),(4581,'X-Cart professionals will easily materialize just about any idea you’ve got.'),(1400,'X-Cart shopping cart software'),(2869,'X-Cart v5.3 requires PHP version 5.4 or better. Please update the PHP version installed on your server before you proceed.'),(2871,'X-Cart v5.4 requires MariaDB version 10.2.4 or better. Please update the MariaDB version installed on your server before you proceed.'),(2872,'X-Cart v5.4 requires MySQL version 5.7.7 or better. Please update the MySQL version installed on your server before you proceed.'),(2870,'X-Cart v5.4 requires PHP version 7.2 or better. Please update the PHP version installed on your server before you proceed.'),(3065,'XML extensions support'),(1401,'XML parser'),(1402,'XML sitemap'),(3992,'XML sitemap URL: X'),(2302,'YEAR'),(1403,'Yahoo!'),(1404,'Yandex'),(386,'Year'),(2108,'Year when store started its operation'),(1405,'Yes'),(1406,'Yes, I agree with License agreement'),(2393,'Yes, I agree with License agreements'),(2034,'Yes, I have made the full backup of my store files and database'),(4556,'Yes, I sell tangible goods that needed to be shipped'),(1935,'Yes/No'),(2463,'Yesterday'),(4987,'You Have No Messages'),(136,'You are going to delete the X language'),(2548,'You are logged in as: user'),(1407,'You are not allowed to access this resource!'),(4826,'You are now in layout editing mode'),(4827,'You are now in preview mode'),(2544,'You are operating as:'),(2547,'You are operating as: user'),(1777,'You are sure to clear your cart?'),(2681,'You can also contact our CR department for help with this issue'),(4229,'You can attach X file(s)'),(4228,'You can attach X more file(s)'),(1692,'You can build your web-site during FREE evaluation, but you cannot use this installation for real sales without buying a license.'),(2212,'You can change the CSV delimiter for all subsequent imports and exports using this link'),(2211,'You can change the charset for all subsequent imports and exports using this link'),(3393,'You can check your nameservers settings by following the instructions here: {{helpUrl}}.'),(294,'You can choose if to download your database data'),(2957,'You can continue as guest or create an account'),(4914,'You can customize the look & feel of the store by configuring the layout and adding the custom CSS or HTML code.'),(3642,'You can define an order id prefix, which would precede each order number in your shop, to make it unique'),(2591,'You can define the following values:'),(4503,'You can find the failed order here'),(2651,'You can find the failed transaction here'),(2539,'You can get more information using this service: '),(132,'You can install these updates after purchasing and activating your X-Cart license key'),(5075,'You can manage your subscriptions here'),(1765,'You can now use the following credentials to access your account'),(2844,'You can purchase AntiFraud Service subscription'),(2589,'You can set up different shipping rates depending on the weight, price or quantity of items in the order.'),(276,'You can upload the database data directly from your local computer'),(4537,'You can view the newly created product in your [storefront] or add a few [more products] to your catalog.'),(4963,'You cannot choose this product'),(1556,'You cannot save database data to a file on the web server (\'var/backup/sqldump.sql.php\').'),(2760,'You cannot update administrator profile ({{value}}). Row is skipped'),(2759,'You cannot update administrator profile ({{value}}). Row will be skipped'),(3220,'You don’t have any notifications right now.'),(4530,'You have added 1 product'),(4676,'You have already reviewed this product'),(3488,'You have already used the coupon'),(1851,'You have an unpaid order #{{ORDER}}'),(1640,'You have no payment methods enabled in your shop'),(1414,'You have selected to delete your profile. Please, confirm you want to proceed'),(1600,'You have the following roles:'),(4248,'You have to attach file'),(4247,'You have to attach file to product'),(4829,'You have unsaved changes. Are you really sure to exit the preview?'),(4887,'You have unsaved changes. Are you really sure to exit?'),(4181,'You just added'),(3088,'You must register your X-Cart installation before using it for real sales. Activate your existing license key or purchase a premium license to skyrocket your business.'),(20,'You must register your installation before you can use it for real sales'),(2030,'You need hard and soft reset links in case some 3rd party module crashes your web-store'),(2845,'You need these links in case you want to recover your store'),(2535,'You should check available free disk space yourself before continuing installation'),(2534,'You should check available free disk space yourself before continuing upgrade'),(2349,'You should confirm that you have created backup before upgrading the store.'),(1848,'You tried to buy more items of \"{{product}}\" product {{description}} than are in stock. We have {{amount}} item(s) only. Please adjust the product quantity.'),(3619,'You will be able to add pin codes after saving changes.'),(1559,'You will be able to provide additional product info (images, attributes, etc.) after you submit this form.'),(4568,'You\'ve successfully set up shipping areas and rates for your store'),(2128,'Your \"Password reset key\" has expired. Please enter the email address associated with your user account to get a new \"Password reset key\".'),(3692,'Your API credentials have been successfully obtained from your PayPal account and saved for use by your X-Cart store.'),(1823,'Your Account'),(3472,'Your Message'),(3195,'Your PHP version is outdated'),(3196,'Your PHP version is outdated and no longer supported'),(3769,'Your PayPal account is not fully configured, please check that:'),(4777,'Your Stripe account is no longer accessible. Please connect with Stripe once again.'),(3087,'Your X-Cart Business trial has expired!'),(1691,'Your X-Cart installation is licensed for evaluation purposes only.'),(4013,'Your X-Cart store is connected to your Kliken account.'),(1408,'Your access link has been expired'),(3122,'Your access to X-Cart Business features expires in X day'),(3123,'Your access to X-Cart Business features expires in X days'),(3124,'Your access to X-Cart Business features expires in X days (5)'),(307,'Your account email is X'),(1424,'Your account information will be e-mailed to you shortly'),(1425,'Your account information will be e-mailed to you shortly.'),(308,'Your account password is X'),(3643,'Your account settings'),(3708,'Your address data was not received from PayPal. Please try again. If the problem persists, contact the administrator.'),(221,'Your cart'),(4598,'Your current domain is X'),(1409,'Your custom addons were prepared for certain core version'),(4807,'Your custom file is successfully saved'),(3386,'Your domain name has been changed. It may take a few days for your domain name provider to make all the necessary changes and a few more days for the changes to propagate throughout the internet.'),(1426,'Your e-mail'),(4683,'Your email'),(421,'Your first name'),(422,'Your last name'),(1427,'Your name'),(1764,'Your new password'),(1970,'Your order details will be sent to your e-mail address'),(4315,'Your order details will be sent to your email address'),(3645,'Your partner name is PayPal'),(3779,'Your payment could not be processed at this time. Please make sure the card information was entered correctly and resubmit. If the problem persists, please contact your credit card company to authorize the purchase.'),(3446,'Your payment could not be processed, please follow the instructions in the payment method box.'),(3445,'Your payment could not be processed. Please try to place the order again using another payment method.'),(3137,'Your payment has been processed; now the addon can be installed.'),(3138,'Your payment is being processed. The addon license key will be sent to your email address as soon as the processing has been completed. You will be able to use this key to install the addon at any time. '),(3556,'Your payment module to accept payments for digital items. [Get it now]!'),(4680,'Your product rating is saved. Thank you!'),(1428,'Your products will be exported as a CSV file.'),(1773,'Your profile modified'),(2357,'Your request has been sent successfully'),(3376,'Your request has been sent, our manager will contact you shortly.'),(4694,'Your review'),(4681,'Your review has been updated. Thank your for sharing your opinion with us!'),(170,'Your shopping bag - X item'),(171,'Your shopping bag - X items'),(1429,'Your shopping bag is empty'),(1430,'Your state'),(1431,'Your store'),(1503,'Your store is configured to use the secure protocol for the store back-end and checkout, sign-in and profile pages.'),(4012,'Your store is connected.'),(1432,'Your store is currently unable to calculate taxes'),(4345,'Your store uses the addon Geolocation'),(5070,'Your subscription X has been activated'),(5073,'Your subscription X has been stopped'),(5069,'Your subscription has been activated'),(5072,'Your subscription has been stopped'),(2361,'Your version (X) can be upgraded to'),(4187,'Z - A'),(185,'Zero cannot be used'),(1433,'Zip code'),(1434,'Zip/postal code masks'),(4307,'Zipcode'),(1436,'Zone'),(417,'Zone address masks help'),(416,'Zone city masks help'),(167,'Zone details have been updated successfully'),(1437,'Zone name'),(1490,'Zone not found (X)'),(415,'Zone zipcode masks help'),(1438,'Zones'),(2389,'Zoom image'),(3724,'[BT] In progress'),(2779,'[Edit]'),(3353,'[Inventory] Removed from stock: \"{{product}}\" product amount in stock changes from \"{{oldInStock}}\" to \"{{newInStock}}\" ({{qty}} items)'),(3352,'[Inventory] Return back to stock: \"{{product}}\" product amount in stock changes from \"{{oldInStock}}\" to \"{{newInStock}}\" ({{qty}} items)'),(3354,'[Inventory] Unable to reduce stock for product: \"{{product}}\", amount: \"{{qty}}\" items'),(3355,'[Tracking] Tracking information was updated'),(3259,'[field] year must be between 1970 and 2038'),(4452,'_MailChimp ecommerce info text_'),(174,'_X_ item'),(175,'_X_ items'),(3725,'__pdt-paypal-warning__'),(2058,'a side box'),(3838,'a2cp-source-code-PAB'),(4966,'a2cp-source-code-REL'),(1818,'address during the recent purchase'),(2095,'always'),(1439,'and'),(4905,'app icon uploader'),(1778,'attributes'),(3116,'attributes_popover_text'),(3459,'authorize_key_help'),(1816,'billing'),(3213,'body of the test email'),(4026,'braintree_merchant_account_id_help'),(4027,'braintree_paypal_shipping_override_help'),(4028,'braintree_settings_google_payment_button_color_help'),(4029,'braintree_settings_google_payment_button_type_help'),(1440,'by'),(4499,'by payment callback (Failed + Cancel)'),(4500,'by pressing Place order button'),(1420,'cURL error'),(1704,'cannot create directory'),(280,'cannot set X permissions'),(2343,'checkbox.firstlast.off'),(2342,'checkbox.firstlast.on'),(2341,'checkbox.onoff.off'),(2340,'checkbox.onoff.on'),(3396,'cloud_domain_name.error.domain_in_use'),(2006,'cm'),(3020,'config_file.error_message_1'),(3021,'config_file.label_message'),(4035,'cs_categories'),(4038,'cs_did_you_mean'),(4037,'cs_manufacturers'),(4036,'cs_pages'),(4034,'cs_products'),(4031,'cs_see_details'),(4032,'cs_see_more_results_for'),(4030,'cs_showing_results_for'),(4033,'cs_suggestions'),(4684,'customers'),(2097,'daily'),(1596,'default'),(2786,'default-404-text'),(664,'default-meta-description'),(2777,'default-meta-keywords'),(2776,'default-site-title'),(1501,'deleted'),(2557,'deliveryTime.help'),(4114,'deposit your items at a Post Office'),(1441,'details'),(1676,'dimensions'),(1442,'disabled'),(4837,'disabled blocks'),(2007,'dm'),(3069,'doc_blocks_support.error_message_1'),(3070,'doc_blocks_support.error_message_2'),(3071,'doc_blocks_support.label_message'),(2993,'dom.extension.alert'),(3384,'domain is on sale'),(1881,'done'),(1443,'downloads'),(4458,'e-Commerce Analytics disable warning'),(2645,'eBay'),(4257,'ePDQ Currency'),(4259,'ePDQ Enable logging of ePDQ transactions'),(4258,'ePDQ Invoice number prefix'),(4254,'ePDQ PSPID'),(4255,'ePDQ SHA-IN pass phrase'),(4256,'ePDQ SHA-OUT pass phrase'),(4253,'ePDQ settings note'),(2093,'each'),(1608,'editable'),(3204,'email from Contact information section'),(3771,'email is confirmed'),(428,'email@example.com'),(2320,'emailNotificationAdminGreeting'),(2319,'emailNotificationAdminHeader'),(2321,'emailNotificationAdminSignature'),(2317,'emailNotificationCustomerGreeting'),(2316,'emailNotificationCustomerHeader'),(2318,'emailNotificationCustomerSignature'),(2322,'emailNotificationTipGoogleADS'),(1719,'empty'),(4108,'enable merchant wizard'),(1444,'enabled'),(2060,'expired'),(2061,'expiredF'),(4904,'favicon uploader'),(3579,'fedex.CODStatusOptionComment'),(1706,'file does not exist'),(3045,'file_permissions.error_message_1'),(3046,'file_permissions.error_message_2'),(3047,'file_permissions.kb_message'),(2578,'flat rate'),(748,'from'),(1445,'from URL'),(1446,'from local computer'),(1447,'from local server'),(2020,'g'),(1448,'hard reset'),(4416,'here'),(2360,'hide list'),(2096,'hourly'),(3228,'https://kb.x-cart.com/'),(3247,'https://kb.x-cart.com/general_setup/inaccessible_admin_area_after_enabling_https.html'),(3232,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html'),(3230,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html#transfering-database'),(3229,'https://kb.x-cart.com/general_setup/what_to_do_if_your_store_says_we_are_deploying_new_changes_and_you_cannot_access_it.html'),(3233,'https://kb.x-cart.com/import-export/'),(3236,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_categories.html'),(3234,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_classes_&_attributes.html'),(3237,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_customers.html'),(3239,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_orders.html'),(3235,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_product_attribute_values.html'),(3238,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_products.html'),(3245,'https://kb.x-cart.com/integrating_your_store_with_other_web-sites/sell_your_products_with_buy_button.html'),(4957,'https://kb.x-cart.com/modules/update_inventory.html'),(3241,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_express_checkout.html'),(3242,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payflow_link.html'),(3243,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_advanced.html'),(3244,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_standard.html'),(3231,'https://kb.x-cart.com/seo_and_promotion/setting_up_seo-friendly_urls.html'),(3240,'https://kb.x-cart.com/setting_up_x-cart_5_environment/configuring_attachments_sending.html'),(3246,'https://kb.x-cart.com/shipping/custom_table_rates.html'),(3249,'https://kb.x-cart.com/shipping/free_shipping.html'),(3251,'https://kb.x-cart.com/taxes/UK_EU_taxes/'),(3253,'https://kb.x-cart.com/taxes/canadian_taxes/'),(3254,'https://kb.x-cart.com/taxes/setting_up_tax_classes.html'),(3250,'https://kb.x-cart.com/taxes/tax_guide.html'),(3252,'https://kb.x-cart.com/taxes/us_taxes/'),(3248,'https://kb.x-cart.com/users/user_roles.html'),(3061,'https_bouncer.error_message_1'),(3062,'https_bouncer.error_message_2'),(3064,'https_bouncer.kb_message'),(3063,'https_bouncer.label_message'),(4385,'iDEAL Currency'),(4387,'iDEAL Enable logging of iDEAL transactions'),(4386,'iDEAL Invoice number prefix'),(4379,'iDEAL Merchant ID'),(4383,'iDEAL Private Key'),(4384,'iDEAL Private Key Password'),(4381,'iDEAL Public Certificate File'),(4382,'iDEAL Public Key'),(4380,'iDEAL SubID'),(1670,'if you have any questions'),(3201,'imgsize-XLite\\Model\\Image\\Common\\Logo-Default'),(2527,'imgsize-category-Default'),(2524,'imgsize-product-Default'),(2525,'imgsize-product-LGThumbnailGrid'),(2526,'imgsize-product-LGThumbnailList'),(1449,'in description'),(1450,'in title'),(2677,'inactive license key(s);'),(2008,'inches'),(3018,'install_script.error_message_1'),(2678,'installed module(s) not allowed by the type of X-Cart license activated at your store.'),(1484,'invalid module ID passed: X'),(1451,'is available'),(1677,'item(s)'),(1776,'item(s) in stock'),(214,'items'),(1452,'items available'),(2999,'itemslist.admin.category.blank'),(3525,'itemslist.admin.coupon.blank'),(3000,'itemslist.admin.membership.blank'),(3917,'itemslist.admin.menu.blank'),(4486,'itemslist.admin.news_message.blank'),(2995,'itemslist.admin.order.blank'),(2994,'itemslist.admin.order.search.blank'),(3916,'itemslist.admin.page.blank'),(2998,'itemslist.admin.product.blank'),(2997,'itemslist.admin.product.search.blank'),(4729,'itemslist.admin.review.blank'),(3853,'itemslist.admin.sale_discounts.blank'),(3013,'itemslist.admin.subcategory.blank'),(4494,'itemslist.admin.subscribers.blank'),(4643,'itemslist.admin.tag.blank'),(4877,'itemslist.admin.template.blank'),(2996,'itemslist.admin.transaction.blank'),(3982,'itemslist.admin.volume_discounts.blank'),(2019,'kg'),(1593,'label name,'),(1594,'label translation.'),(4063,'label.coming_soon'),(1587,'labels count:'),(1592,'language code,'),(2017,'lbs'),(4214,'learn more'),(1453,'less'),(3551,'less one hour'),(1627,'local files'),(4903,'logo uploader'),(3073,'loopback_request.error_message_1'),(3075,'loopback_request.kb_message'),(3074,'loopback_request.label_message'),(3208,'mail tester line 1'),(3209,'mail tester line 2'),(3210,'mail tester line 3'),(3211,'mail tester line 4'),(4453,'mailchimp_settings_promo_text'),(2992,'mbstring.extension.alert'),(2005,'mm'),(1486,'module version X is not equal to the core one (Y)'),(4,'module-sort-Alphabetically'),(2,'module-sort-Most popular'),(3,'module-sort-Newest'),(1454,'modules'),(2099,'monthly'),(2705,'more'),(1455,'ms'),(1609,'multi value'),(3053,'mysql_cache.error_message_1'),(3049,'mysql_version.error_message_1'),(3050,'mysql_version.error_message_2'),(3051,'mysql_version.error_message_3'),(45,'n/a'),(2741,'na_admin'),(2713,'na_customer'),(1456,'never'),(3141,'new core'),(3145,'new core and X addon'),(3146,'new core and X addons'),(3147,'new core and X addons (5)'),(4907,'new template'),(5030,'next attempt on'),(2194,'no comments'),(1457,'none'),(1458,'not all archives were unpacked'),(430,'not all upgrade packs were downloaded'),(1460,'not available for sale'),(4498,'not finished'),(1461,'not installed'),(1462,'not ready to download packs. Please, try again'),(2886,'notification.column.administrator'),(2885,'notification.column.customer'),(2882,'notification.section.administrator'),(2881,'notification.section.customer'),(2884,'notification.tab.administrator'),(2883,'notification.tab.customer'),(1732,'now disabled'),(1463,'of'),(4523,'onboarding.add_product.heading'),(4525,'onboarding.add_product.import'),(4524,'onboarding.add_product.text'),(4519,'onboarding.cloud.intro.text'),(4522,'onboarding.intro.disable_button'),(4517,'onboarding.intro.heading'),(4521,'onboarding.intro.later_button'),(4520,'onboarding.intro.next_button'),(4518,'onboarding.intro.text'),(1464,'options'),(1465,'or'),(3700,'or go to checkout as a New customer'),(2956,'or proceed with'),(2846,'or use the form below'),(4686,'out of'),(1664,'outdated'),(2018,'oz'),(2311,'paymentStatus.Active'),(2312,'paymentStatus.Inactive'),(3783,'paypal_commerce_platform_welcome_text'),(3784,'paypal_commerce_platform_welcome_text_configured'),(3675,'paypal_welcome_text'),(2579,'per item'),(236,'per page'),(2580,'per weight unit'),(297,'percent X off'),(3772,'permission granted for X-Cart app'),(3028,'php_disabled_functions.error_message_1'),(3030,'php_disabled_functions.kb_message'),(3029,'php_disabled_functions.label_message'),(3035,'php_file_uploads.error_message_1'),(3036,'php_file_uploads.label_message'),(3055,'php_gdlib.error_message_1'),(3056,'php_gdlib.error_message_2'),(3032,'php_memory_limit.error_message_1'),(3033,'php_memory_limit.label_message'),(3038,'php_pdo_mysql.error_message_1'),(3040,'php_pdo_mysql.kb_message'),(3039,'php_pdo_mysql.label_message'),(3058,'php_phar.error_message_1'),(3059,'php_phar.label_message'),(3042,'php_upload_max_file_size.error_message_1'),(3043,'php_upload_max_file_size.label_message'),(3023,'php_version.error_message_1'),(3024,'php_version.error_message_2'),(3025,'php_version.error_message_3'),(3026,'php_version.label_message'),(1412,'please sign in'),(3749,'pp-button-location:Add2Cart popup'),(3745,'pp-button-location:Cart'),(3747,'pp-button-location:Checkout'),(3748,'pp-button-location:Checkout (credit)'),(3746,'pp-button-location:Minicart'),(3744,'pp-button-location:Product list'),(3743,'pp-button-location:Product page'),(2291,'price-All'),(2293,'price-Free'),(2292,'price-Paid'),(1684,'products'),(1466,'proxy'),(3478,'recaptcha_terms_of_service'),(3462,'relay_response_help'),(1939,'requested for'),(1529,'requested once or twice'),(1528,'requested only once'),(134,'required'),(4721,'reviewMetaDescription'),(1467,'sale'),(2896,'same as shipping'),(2094,'save'),(4459,'send all discount coupons'),(4460,'send only discount coupons with matched rules'),(3205,'sender identified by server'),(4113,'shipments are picked up by Canada Post'),(1817,'shipping'),(2584,'shippingFormula.DiscountedSubtotal'),(2586,'shippingFormula.Free'),(2582,'shippingFormula.Items'),(2581,'shippingFormula.Shipping'),(2583,'shippingFormula.Subtotal'),(2585,'shippingFormula.Weight'),(2604,'shippingStatus.Active'),(2605,'shippingStatus.Inactive'),(2572,'shippingTableType.All'),(2569,'shippingTableType.DiscountedSubtotal'),(2571,'shippingTableType.Items'),(2568,'shippingTableType.Subtotal'),(2570,'shippingTableType.Weight'),(1468,'should be performed manually'),(2404,'show list'),(1469,'soft reset'),(3206,'specific email address (set up below)'),(4733,'star_tooltip_1'),(4734,'star_tooltip_2'),(4735,'star_tooltip_3'),(4736,'star_tooltip_4'),(4737,'star_tooltip_5'),(1705,'subdirectories problems'),(36,'submit_restore_pass'),(2558,'tableType.help'),(4909,'template weight'),(2503,'the categories and product classes to which the coupon may be applied;'),(1743,'the custom modifications will be lost'),(2501,'the dates the coupon should be valid for;'),(2059,'the main column'),(2502,'the order subtotal range for which the coupon can be used;'),(2847,'the same as billing'),(4886,'themetweaker.shortcut.save'),(4885,'themetweaker.shortcut.switcher'),(2775,'title-delimiter'),(3199,'to be uninstalled'),(2955,'to enjoy checkout'),(3596,'to view the advanced statistics'),(1470,'trying to install a non-marketplace module: X'),(1471,'trying to unpack non-downloaded archives'),(4908,'type filename and press Enter'),(1485,'unable to add module entry to the installation list: X'),(1472,'unable to install: not all archives were unpacked. Please, try again'),(1473,'unable to test files: not all archives were unpacked'),(1487,'unable to upload module'),(2493,'unavailable'),(2092,'units'),(1474,'unknown'),(1875,'unknown error'),(3165,'up to 1 decimal'),(3167,'up to 10'),(3168,'up to 100'),(3164,'up to 2 decimals'),(3166,'up to integer'),(1658,'upgrade core'),(2989,'upgrade_warning_text'),(4936,'ups.CODStatusOptionComment'),(3929,'usps.CODStatusOptionComment'),(1696,'verified version'),(2359,'view list'),(4688,'votes'),(4092,'warning: parcel is overweight'),(4820,'webmasterMode.Disabled'),(4819,'webmasterMode.Enabled'),(2098,'weekly'),(1675,'weight'),(2504,'whether the coupon may be used by everyone or only by users with specific memberships.'),(4876,'xlite-translation-popover.help'),(3066,'xml_support.error_message_1'),(3067,'xml_support.label_message'),(5056,'xps.days'),(5049,'xps.each__monthDay'),(5050,'xps.each__monthDay_reverse'),(5051,'xps.each__yearDay'),(5052,'xps.each__yearDay_reverse'),(5046,'xps.each_friday'),(5042,'xps.each_monday'),(5047,'xps.each_saturday'),(5048,'xps.each_sunday'),(5045,'xps.each_thursday'),(5043,'xps.each_tuesday'),(5044,'xps.each_wednesday'),(5035,'xps.every__days'),(5039,'xps.every__months'),(5037,'xps.every__weeks'),(5041,'xps.every__years'),(5054,'xps.month'),(5058,'xps.months'),(5034,'xps.number_suffix'),(5060,'xps.total_of__payments'),(5053,'xps.week'),(5057,'xps.weeks'),(5055,'xps.year'),(5059,'xps.years'),(2100,'yearly'),(3770,'you have permission to receive payments'),(1475,'you save'),(1745,'your web site may crash'),(4644,'{{count}} Tag duplicates ignored'),(1971,'{{count}} created'),(3263,'{{count}} day'),(3264,'{{count}} days'),(1972,'{{count}} updated'),(3390,'{{currentEdition}} Plan'),(2822,'{{field}} length must be less then {{length}}'),(2748,'{{file}} does not exist on the filesystem'),(2745,'{{file}} file could not be copied to a new location {{newPath}}'),(3351,'{{ip}} IP address used'),(1906,'{{module}} license agreement'),(1986,'{{name}} attributes'),(1865,'{{paymentMethod}} settings'),(3932,'{{value}} is an invalid container type for a REGULAR package. Valid Container is: VARIABLE');
/*!40000 ALTER TABLE `[[dbprefix]]language_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]language_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]language_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]language_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_9610C29E2BF396750` (`id`),
  KEY `ci` (`code`,`id`),
  CONSTRAINT `FK_9610C29E2BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]languages` (`lng_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]language_translations`
--

LOCK TABLES `[[dbprefix]]language_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]language_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]language_translations` VALUES (1,1,'Afar','en'),(2,2,'Abkhazian','en'),(3,3,'Afrikaans','en'),(4,4,'Akan','en'),(5,5,'Albanian','en'),(6,6,'Amharic','en'),(7,7,'Arabic','en'),(8,8,'Aragonese','en'),(9,9,'Armenian','en'),(10,10,'Assamese','en'),(11,11,'Avaric','en'),(12,12,'Avestan','en'),(13,13,'Aymara','en'),(14,14,'Azerbaijani','en'),(15,15,'Bashkir','en'),(16,16,'Bambara','en'),(17,17,'Basque','en'),(18,18,'Belarusian','en'),(19,19,'Bengali','en'),(20,20,'Bihari','en'),(21,21,'Bislama','en'),(22,22,'Bosnian','en'),(23,23,'Brazilian Portuguese','en'),(24,24,'British','en'),(25,25,'Bulgarian','en'),(26,26,'Burmese','en'),(27,27,'Catalan','en'),(28,28,'Chamorro','en'),(29,29,'Chechen','en'),(30,30,'Chinese','en'),(31,31,'Church Slavic','en'),(32,32,'Chuvash','en'),(33,33,'Cornish','en'),(34,34,'Corsican','en'),(35,35,'Cree','en'),(36,36,'Czech','en'),(37,37,'Danish','en'),(38,38,'Divehi','en'),(39,39,'Dutch','en'),(40,40,'Dzongkha','en'),(41,41,'English','en'),(42,42,'Esperanto','en'),(43,43,'Estonian','en'),(44,44,'Ewe','en'),(45,45,'Faroese','en'),(46,46,'Fijian','en'),(47,47,'Finnish','en'),(48,48,'French','en'),(49,49,'Western Frisian','en'),(50,50,'Fulah','en'),(51,51,'Georgian','en'),(52,52,'German','en'),(53,53,'Gaelic','en'),(54,54,'Irish','en'),(55,55,'Galician','en'),(56,56,'Manx','en'),(57,57,'Greek','en'),(58,58,'Guarani','en'),(59,59,'Gujarati','en'),(60,60,'Haitian','en'),(61,61,'Hausa','en'),(62,62,'Hebrew','en'),(63,63,'Herero','en'),(64,64,'Hindi','en'),(65,65,'Hiri Motu','en'),(66,66,'Croatian','en'),(67,67,'Hungarian','en'),(68,68,'Igbo','en'),(69,69,'Icelandic','en'),(70,70,'Ido','en'),(71,71,'Sichuan Yi','en'),(72,72,'Inuktitut','en'),(73,73,'Interlingue','en'),(74,74,'Interlingua','en'),(75,75,'Indonesian','en'),(76,76,'Inupiaq','en'),(77,77,'Italian','en'),(78,78,'Javanese','en'),(79,79,'Japanese','en'),(80,80,'Kalaallisut','en'),(81,81,'Kannada','en'),(82,82,'Kashmiri','en'),(83,83,'Kanuri','en'),(84,84,'Kazakh','en'),(85,85,'Khmer or Cambodian','en'),(86,86,'Kikuyu','en'),(87,87,'Kinyarwanda','en'),(88,88,'Kirghiz','en'),(89,89,'Komi','en'),(90,90,'Kongo','en'),(91,91,'Korean','en'),(92,92,'Kuanyama','en'),(93,93,'Kurdish','en'),(94,94,'Lao','en'),(95,95,'Latin','en'),(96,96,'Latvian','en'),(97,97,'Limburgan','en'),(98,98,'Lingala','en'),(99,99,'Lithuanian','en'),(100,100,'Luxembourgish','en'),(101,101,'Luba-Katanga','en'),(102,102,'Ganda','en'),(103,103,'Macedonian','en'),(104,104,'Marshallese','en'),(105,105,'Malayalam','en'),(106,106,'Maori','en'),(107,107,'Marathi','en'),(108,108,'Malay','en'),(109,109,'Malagasy','en'),(110,110,'Maltese','en'),(111,111,'Mongolian','en'),(112,112,'Nauru','en'),(113,113,'Navajo','en'),(114,114,'Ndebel','en'),(115,115,'Ndebel','en'),(116,116,'Ndonga','en'),(117,117,'Nepali','en'),(118,118,'Norwegian','en'),(119,119,'Chichewa','en'),(120,120,'Occitan','en'),(121,121,'Ojibwa','en'),(122,122,'Oriya','en'),(123,123,'Oromo','en'),(124,124,'Ossetian','en'),(125,125,'Panjabi','en'),(126,126,'Persian','en'),(127,127,'Pali','en'),(128,128,'Polish','en'),(129,129,'Portuguese','en'),(130,130,'Pushto','en'),(131,131,'Quechua','en'),(132,132,'Romansh','en'),(133,133,'Romanian','en'),(134,134,'Rundi','en'),(135,135,'Russian','en'),(136,136,'Sango','en'),(137,137,'Sanskrit','en'),(138,138,'Sinhala','en'),(139,139,'Slovak','en'),(140,140,'Slovenian','en'),(141,141,'Northern Sami','en'),(142,142,'Samoan','en'),(143,143,'Shona','en'),(144,144,'Sindhi','en'),(145,145,'Somali','en'),(146,146,'Soth','en'),(147,147,'Spanish','en'),(148,148,'Sardinian','en'),(149,149,'Serbian','en'),(150,150,'Swati','en'),(151,151,'Sundanese','en'),(152,152,'Swahili','en'),(153,153,'Swedish','en'),(154,154,'Tahitian','en'),(155,155,'Tamil','en'),(156,156,'Tatar','en'),(157,157,'Telugu','en'),(158,158,'Tajik','en'),(159,159,'Tagalog','en'),(160,160,'Thai','en'),(161,161,'Tibetan','en'),(162,162,'Tigrinya','en'),(163,163,'Tonga','en'),(164,164,'Tswana','en'),(165,165,'Tsonga','en'),(166,166,'Turkmen','en'),(167,167,'Turkish','en'),(168,168,'Twi','en'),(169,169,'Uighur','en'),(170,170,'Ukrainian','en'),(171,171,'Urdu','en'),(172,172,'Uzbek','en'),(173,173,'Venda','en'),(174,174,'Vietnamese','en'),(175,175,'Welsh','en'),(176,176,'Walloon','en'),(177,177,'Wolof','en'),(178,178,'Xhosa','en'),(179,179,'Yiddish','en'),(180,180,'Yoruba','en'),(181,181,'Zhuang','en'),(182,182,'Zulu','en');
/*!40000 ALTER TABLE `[[dbprefix]]language_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]languages`
--

DROP TABLE IF EXISTS `[[dbprefix]]languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]languages` (
  `lng_id` int(11) NOT NULL AUTO_INCREMENT,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code3` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `r2l` tinyint(1) NOT NULL,
  `added` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `module` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lng_id`),
  UNIQUE KEY `code3` (`code3`),
  UNIQUE KEY `code2` (`code`),
  KEY `added` (`added`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]languages`
--

LOCK TABLES `[[dbprefix]]languages` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]languages` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]languages` VALUES (1,'aa','aar',0,0,0,NULL),(2,'ab','abk',0,0,0,NULL),(3,'af','afr',0,0,0,NULL),(4,'ak','aka',0,0,0,NULL),(5,'sq','alb',0,0,0,NULL),(6,'am','amh',0,0,0,NULL),(7,'ar','ara',0,0,0,NULL),(8,'an','arg',0,0,0,NULL),(9,'hy','arm',0,0,0,NULL),(10,'as','asm',0,0,0,NULL),(11,'av','ava',0,0,0,NULL),(12,'ae','ave',0,0,0,NULL),(13,'ay','aym',0,0,0,NULL),(14,'az','aze',0,0,0,NULL),(15,'ba','bak',0,0,0,NULL),(16,'bm','bam',0,0,0,NULL),(17,'eu','baq',0,0,0,NULL),(18,'be','bel',0,0,0,NULL),(19,'bn','ben',0,0,0,NULL),(20,'bh','bih',0,0,0,NULL),(21,'bi','bis',0,0,0,NULL),(22,'bs','bos',0,0,0,NULL),(23,'br','bre',0,0,0,NULL),(24,'gb','gbr',0,0,0,'XC\\GbTranslation'),(25,'bg','bul',0,0,0,NULL),(26,'my','bur',0,0,0,NULL),(27,'ca','cat',0,0,0,NULL),(28,'ch','cha',0,0,0,NULL),(29,'ce','che',0,0,0,NULL),(30,'zh','chi',0,0,0,NULL),(31,'cu','chu',0,0,0,NULL),(32,'cv','chv',0,0,0,NULL),(33,'kw','cor',0,0,0,NULL),(34,'co','cos',0,0,0,NULL),(35,'cr','cre',0,0,0,NULL),(36,'cs','cze',0,0,0,NULL),(37,'da','dan',0,0,0,NULL),(38,'dv','div',0,0,0,NULL),(39,'nl','dut',0,0,0,NULL),(40,'dz','dzo',0,0,0,NULL),(41,'en','eng',0,1,1,NULL),(42,'eo','epo',0,0,0,NULL),(43,'et','est',0,0,0,NULL),(44,'ee','ewe',0,0,0,NULL),(45,'fo','fao',0,0,0,NULL),(46,'fj','fij',0,0,0,NULL),(47,'fi','fin',0,0,0,NULL),(48,'fr','fre',0,0,0,'CDev\\FrTranslation'),(49,'fy','fry',0,0,0,NULL),(50,'ff','ful',0,0,0,NULL),(51,'ka','geo',0,0,0,NULL),(52,'de','ger',0,0,0,'CDev\\DeTranslation'),(53,'gd','gla',0,0,0,NULL),(54,'ga','gle',0,0,0,NULL),(55,'gl','glg',0,0,0,NULL),(56,'gv','glv',0,0,0,NULL),(57,'el','gre',0,0,0,NULL),(58,'gn','grn',0,0,0,NULL),(59,'gu','guj',0,0,0,NULL),(60,'ht','hat',0,0,0,NULL),(61,'ha','hau',0,0,0,NULL),(62,'he','heb',0,0,0,NULL),(63,'hz','her',0,0,0,NULL),(64,'hi','hin',0,0,0,NULL),(65,'ho','hmo',0,0,0,NULL),(66,'hr','hrv',0,0,0,NULL),(67,'hu','hun',0,0,0,NULL),(68,'ig','ibo',0,0,0,NULL),(69,'is','ice',0,0,0,NULL),(70,'io','ido',0,0,0,NULL),(71,'ii','iii',0,0,0,NULL),(72,'iu','iku',0,0,0,NULL),(73,'ie','ile',0,0,0,NULL),(74,'ia','ina',0,0,0,NULL),(75,'id','ind',0,0,0,NULL),(76,'ik','ipk',0,0,0,NULL),(77,'it','ita',0,0,0,NULL),(78,'jv','jav',0,0,0,NULL),(79,'ja','jpn',0,0,0,NULL),(80,'kl','kal',0,0,0,NULL),(81,'kn','kan',0,0,0,NULL),(82,'ks','kas',0,0,0,NULL),(83,'kr','kau',0,0,0,NULL),(84,'kk','kaz',0,0,0,NULL),(85,'km','khm',0,0,0,NULL),(86,'ki','kik',0,0,0,NULL),(87,'rw','kin',0,0,0,NULL),(88,'ky','kir',0,0,0,NULL),(89,'kv','kom',0,0,0,NULL),(90,'kg','kon',0,0,0,NULL),(91,'ko','kor',0,0,0,NULL),(92,'kj','kua',0,0,0,NULL),(93,'ku','kur',0,0,0,NULL),(94,'lo','lao',0,0,0,NULL),(95,'la','lat',0,0,0,NULL),(96,'lv','lav',0,0,0,NULL),(97,'li','lim',0,0,0,NULL),(98,'ln','lin',0,0,0,NULL),(99,'lt','lit',0,0,0,NULL),(100,'lb','ltz',0,0,0,NULL),(101,'lu','lub',0,0,0,NULL),(102,'lg','lug',0,0,0,NULL),(103,'mk','mac',0,0,0,NULL),(104,'mh','mah',0,0,0,NULL),(105,'ml','mal',0,0,0,NULL),(106,'mi','mao',0,0,0,NULL),(107,'mr','mar',0,0,0,NULL),(108,'ms','may',0,0,0,NULL),(109,'mg','mlg',0,0,0,NULL),(110,'mt','mlt',0,0,0,NULL),(111,'mn','mon',0,0,0,NULL),(112,'na','nau',0,0,0,NULL),(113,'nv','nav',0,0,0,NULL),(114,'nr','nbl',0,0,0,NULL),(115,'nd','nde',0,0,0,NULL),(116,'ng','ndo',0,0,0,NULL),(117,'ne','nep',0,0,0,NULL),(118,'no','nor',0,0,0,NULL),(119,'ny','nya',0,0,0,NULL),(120,'oc','oci',0,0,0,NULL),(121,'oj','oji',0,0,0,NULL),(122,'or','ori',0,0,0,NULL),(123,'om','orm',0,0,0,NULL),(124,'os','oss',0,0,0,NULL),(125,'pa','pan',0,0,0,NULL),(126,'fa','per',0,0,0,NULL),(127,'pi','pli',0,0,0,NULL),(128,'pl','pol',0,0,0,NULL),(129,'pt','por',0,0,0,NULL),(130,'ps','pus',0,0,0,NULL),(131,'qu','que',0,0,0,NULL),(132,'rm','roh',0,0,0,NULL),(133,'ro','rum',0,0,0,NULL),(134,'rn','run',0,0,0,NULL),(135,'ru','rus',0,0,0,'CDev\\RuTranslation'),(136,'sg','sag',0,0,0,NULL),(137,'sa','san',0,0,0,NULL),(138,'si','sin',0,0,0,NULL),(139,'sk','slo',0,0,0,NULL),(140,'sl','slv',0,0,0,NULL),(141,'se','sme',0,0,0,NULL),(142,'sm','smo',0,0,0,NULL),(143,'sn','sna',0,0,0,NULL),(144,'sd','snd',0,0,0,NULL),(145,'so','som',0,0,0,NULL),(146,'st','sot',0,0,0,NULL),(147,'es','spa',0,0,0,NULL),(148,'sc','srd',0,0,0,NULL),(149,'sr','srp',0,0,0,NULL),(150,'ss','ssw',0,0,0,NULL),(151,'su','sun',0,0,0,NULL),(152,'sw','swa',0,0,0,NULL),(153,'sv','swe',0,0,0,NULL),(154,'ty','tah',0,0,0,NULL),(155,'ta','tam',0,0,0,NULL),(156,'tt','tat',0,0,0,NULL),(157,'te','tel',0,0,0,NULL),(158,'tg','tgk',0,0,0,NULL),(159,'tl','tgl',0,0,0,NULL),(160,'th','tha',0,0,0,NULL),(161,'bo','tib',0,0,0,NULL),(162,'ti','tir',0,0,0,NULL),(163,'to','ton',0,0,0,NULL),(164,'tn','tsn',0,0,0,NULL),(165,'ts','tso',0,0,0,NULL),(166,'tk','tuk',0,0,0,NULL),(167,'tr','tur',0,0,0,NULL),(168,'tw','twi',0,0,0,NULL),(169,'ug','uig',0,0,0,NULL),(170,'uk','ukr',0,0,0,NULL),(171,'ur','urd',0,0,0,NULL),(172,'uz','uzb',0,0,0,NULL),(173,'ve','ven',0,0,0,NULL),(174,'vi','vie',0,0,0,NULL),(175,'cy','wel',0,0,0,NULL),(176,'wa','wln',0,0,0,NULL),(177,'wo','wol',0,0,0,NULL),(178,'xh','xho',0,0,0,NULL),(179,'yi','yid',0,0,0,NULL),(180,'yo','yor',0,0,0,NULL),(181,'za','zha',0,0,0,NULL),(182,'zu','zul',0,0,0,NULL);
/*!40000 ALTER TABLE `[[dbprefix]]languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]logo_images`
--

DROP TABLE IF EXISTS `[[dbprefix]]logo_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]logo_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]logo_images`
--

LOCK TABLES `[[dbprefix]]logo_images` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]logo_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]logo_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]mailchimp_list_group`
--

DROP TABLE IF EXISTS `[[dbprefix]]mailchimp_list_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]mailchimp_list_group` (
  `id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `list_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_92F783133DAE168B` (`list_id`),
  CONSTRAINT `FK_92F783133DAE168B` FOREIGN KEY (`list_id`) REFERENCES `[[dbprefix]]mailchimp_lists` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]mailchimp_list_group`
--

LOCK TABLES `[[dbprefix]]mailchimp_list_group` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_list_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_list_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]mailchimp_list_group_name`
--

DROP TABLE IF EXISTS `[[dbprefix]]mailchimp_list_group_name`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]mailchimp_list_group_name` (
  `id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subscriberCount` int(10) unsigned NOT NULL,
  `subscribeByDefault` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_95917FD4DFE54D947` (`group_id`),
  CONSTRAINT `FK_95917FD4DFE54D947` FOREIGN KEY (`group_id`) REFERENCES `[[dbprefix]]mailchimp_list_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]mailchimp_list_group_name`
--

LOCK TABLES `[[dbprefix]]mailchimp_list_group_name` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_list_group_name` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_list_group_name` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]mailchimp_list_segments`
--

DROP TABLE IF EXISTS `[[dbprefix]]mailchimp_list_segments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]mailchimp_list_segments` (
  `id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `list_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_date` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `static` tinyint(1) NOT NULL,
  `useOrdersLastMonth` tinyint(1) NOT NULL,
  `ordersLastMonth` int(11) NOT NULL,
  `useOrderAmount` tinyint(1) NOT NULL,
  `orderAmount` decimal(14,4) NOT NULL,
  `useMemberships` tinyint(1) NOT NULL,
  `useProducts` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_993CC76423DAE168B` (`list_id`),
  CONSTRAINT `FK_993CC76423DAE168B` FOREIGN KEY (`list_id`) REFERENCES `[[dbprefix]]mailchimp_lists` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]mailchimp_list_segments`
--

LOCK TABLES `[[dbprefix]]mailchimp_list_segments` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_list_segments` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_list_segments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]mailchimp_lists`
--

DROP TABLE IF EXISTS `[[dbprefix]]mailchimp_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]mailchimp_lists` (
  `id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_updated` int(11) NOT NULL,
  `list_rating` decimal(3,2) NOT NULL,
  `subscribe_url_short` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subscribe_url_long` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `member_count` int(11) NOT NULL,
  `open_rate` decimal(5,2) NOT NULL,
  `click_rate` decimal(5,2) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `subscribeByDefault` tinyint(1) NOT NULL,
  `isRemoved` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]mailchimp_lists`
--

LOCK TABLES `[[dbprefix]]mailchimp_lists` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]mailchimp_profile_interests`
--

DROP TABLE IF EXISTS `[[dbprefix]]mailchimp_profile_interests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]mailchimp_profile_interests` (
  `group_name_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_id` int(11) NOT NULL,
  PRIMARY KEY (`group_name_id`,`profile_id`),
  KEY `IDX_9BA74923AF717C8DA` (`group_name_id`),
  KEY `IDX_9BA74923ACCFA12B8` (`profile_id`),
  CONSTRAINT `FK_9BA74923ACCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `[[dbprefix]]profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9BA74923AF717C8DA` FOREIGN KEY (`group_name_id`) REFERENCES `[[dbprefix]]mailchimp_list_group_name` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]mailchimp_profile_interests`
--

LOCK TABLES `[[dbprefix]]mailchimp_profile_interests` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_profile_interests` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_profile_interests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]mailchimp_segment_subscriptions`
--

DROP TABLE IF EXISTS `[[dbprefix]]mailchimp_segment_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]mailchimp_segment_subscriptions` (
  `segment_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_id` int(11) NOT NULL,
  PRIMARY KEY (`segment_id`,`profile_id`),
  KEY `IDX_9CE45B298DB296AAD` (`segment_id`),
  KEY `IDX_9CE45B298CCFA12B8` (`profile_id`),
  CONSTRAINT `FK_9CE45B298CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `[[dbprefix]]profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9CE45B298DB296AAD` FOREIGN KEY (`segment_id`) REFERENCES `[[dbprefix]]mailchimp_list_segments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]mailchimp_segment_subscriptions`
--

LOCK TABLES `[[dbprefix]]mailchimp_segment_subscriptions` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_segment_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_segment_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]mailchimp_store`
--

DROP TABLE IF EXISTS `[[dbprefix]]mailchimp_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]mailchimp_store` (
  `id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `list_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `main` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_95CF70793DAE168B` (`list_id`),
  CONSTRAINT `FK_995CF70793DAE168B` FOREIGN KEY (`list_id`) REFERENCES `[[dbprefix]]mailchimp_lists` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]mailchimp_store`
--

LOCK TABLES `[[dbprefix]]mailchimp_store` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]mailchimp_subscriptions`
--

DROP TABLE IF EXISTS `[[dbprefix]]mailchimp_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]mailchimp_subscriptions` (
  `list_id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_id` int(11) NOT NULL,
  PRIMARY KEY (`list_id`,`profile_id`),
  KEY `IDX_9CF18140A3DAE168B` (`list_id`),
  KEY `IDX_9CF18140ACCFA12B8` (`profile_id`),
  CONSTRAINT `FK_9CF18140A3DAE168B` FOREIGN KEY (`list_id`) REFERENCES `[[dbprefix]]mailchimp_lists` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9CF18140ACCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `[[dbprefix]]profiles` (`profile_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]mailchimp_subscriptions`
--

LOCK TABLES `[[dbprefix]]mailchimp_subscriptions` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]mailchimp_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]measure_dumps`
--

DROP TABLE IF EXISTS `[[dbprefix]]measure_dumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]measure_dumps` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]measure_dumps`
--

LOCK TABLES `[[dbprefix]]measure_dumps` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]measure_dumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]measure_dumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]measures`
--

DROP TABLE IF EXISTS `[[dbprefix]]measures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]measures` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` int(10) unsigned NOT NULL,
  `fsTime` int(10) unsigned NOT NULL,
  `dbTime` int(10) unsigned NOT NULL,
  `cpuTime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]measures`
--

LOCK TABLES `[[dbprefix]]measures` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]measures` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]measures` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]membership_coupons`
--

DROP TABLE IF EXISTS `[[dbprefix]]membership_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]membership_coupons` (
  `coupon_id` int(10) unsigned NOT NULL,
  `membership_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`coupon_id`,`membership_id`),
  KEY `IDX_9560DE2166C5951B` (`coupon_id`),
  KEY `IDX_9560DE211FB354CD` (`membership_id`),
  CONSTRAINT `FK_9560DE211FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `[[dbprefix]]memberships` (`membership_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9560DE2166C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `[[dbprefix]]coupons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]membership_coupons`
--

LOCK TABLES `[[dbprefix]]membership_coupons` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]membership_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]membership_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]membership_sale_discounts`
--

DROP TABLE IF EXISTS `[[dbprefix]]membership_sale_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]membership_sale_discounts` (
  `sale_id` int(10) unsigned NOT NULL,
  `membership_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`sale_id`,`membership_id`),
  KEY `IDX_964E9C0254A7E4868` (`sale_id`),
  KEY `IDX_964E9C0251FB354CD` (`membership_id`),
  CONSTRAINT `FK_964E9C0251FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `[[dbprefix]]memberships` (`membership_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_964E9C0254A7E4868` FOREIGN KEY (`sale_id`) REFERENCES `[[dbprefix]]sale_discounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]membership_sale_discounts`
--

LOCK TABLES `[[dbprefix]]membership_sale_discounts` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]membership_sale_discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]membership_sale_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]membership_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]membership_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]membership_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9571DB741BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]memberships` (`membership_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]membership_translations`
--

LOCK TABLES `[[dbprefix]]membership_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]membership_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]membership_translations` VALUES (1,1,'Wholesaler','en'),(2,1,'Оптовый покупатель','ru');
/*!40000 ALTER TABLE `[[dbprefix]]membership_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]memberships`
--

DROP TABLE IF EXISTS `[[dbprefix]]memberships`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]memberships` (
  `membership_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`membership_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]memberships`
--

LOCK TABLES `[[dbprefix]]memberships` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]memberships` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]memberships` VALUES (1,10,1);
/*!40000 ALTER TABLE `[[dbprefix]]memberships` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]menu_quick_flags`
--

DROP TABLE IF EXISTS `[[dbprefix]]menu_quick_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]menu_quick_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(10) unsigned DEFAULT NULL,
  `submenus_count_all` int(11) NOT NULL,
  `submenus_count_enabled` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_B0327DB0CCD7E912` (`menu_id`),
  CONSTRAINT `FK_9B0327DB0CCD7E912` FOREIGN KEY (`menu_id`) REFERENCES `[[dbprefix]]menus` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]menu_quick_flags`
--

LOCK TABLES `[[dbprefix]]menu_quick_flags` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]menu_quick_flags` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]menu_quick_flags` VALUES (1,3,2,2),(3,1,0,0),(4,2,11,11),(5,4,0,0),(6,5,0,0),(8,6,0,0),(9,7,0,0),(10,8,0,0),(11,9,3,2),(12,10,0,0),(13,11,0,0),(14,12,0,0),(15,14,3,3),(16,13,0,0),(17,15,0,0),(18,16,0,0),(19,17,0,0),(20,18,3,3),(21,19,0,0),(22,20,0,0),(23,21,0,0),(24,22,2,2),(25,23,0,0),(26,24,0,0),(27,25,3,3),(28,26,0,0),(29,27,0,0),(30,28,0,0);
/*!40000 ALTER TABLE `[[dbprefix]]menu_quick_flags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]menu_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]menu_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]menu_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9CC54E72BBF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]menus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]menu_translations`
--

LOCK TABLES `[[dbprefix]]menu_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]menu_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]menu_translations` VALUES (1,1,'Home','en'),(2,1,'Главная','ru'),(3,1,'主页','zh'),(4,3,'My Account','en'),(5,3,'Мой профиль','ru'),(6,3,'我的账户','zh'),(7,4,'My orders','en'),(8,4,'Мои заказы','ru'),(9,4,'订单（复数）','zh'),(10,5,'My address book','en'),(11,5,'Мои адреса','ru'),(12,5,'地址簿','zh'),(13,6,'Shipping','en'),(14,6,'Доставка','ru'),(15,7,'New!','en'),(16,7,'Новинки','ru'),(17,8,'Coming soon','en'),(18,8,'Скоро в продаже','ru'),(19,9,'Hot deals','en'),(20,9,'Акции','ru'),(21,10,'Sale','en'),(22,10,'Распродажа','ru'),(23,11,'Bestsellers','en'),(24,11,'Бестселлеры','ru'),(25,12,'Special offers','en'),(26,12,'Специальные предложения','ru'),(27,13,'Contact us','en'),(28,13,'Напишите нам','ru'),(29,14,'Offers','en'),(30,14,'Акции','ru'),(31,15,'Sale','en'),(32,15,'Распродажа','ru'),(33,16,'Coming soon','en'),(34,16,'Скоро в продаже','ru'),(35,17,'New!','en'),(36,17,'Новинки','ru'),(37,18,'Info links','en'),(38,18,'Информация','ru'),(39,19,'Shipping','en'),(40,19,'Правила доставки','ru'),(41,20,'Sitemap','en'),(42,20,'Карта сайта','ru'),(43,21,'Terms & Conditions','en'),(44,21,'Условия использования','ru'),(45,22,'Services','en'),(46,22,'Сервисы','ru'),(47,23,'Shipping info','en'),(48,23,'Доставка','ru'),(49,24,'Contact us','en'),(50,24,'Напишите нам','ru'),(51,25,'My X-Cart','en'),(52,25,'Мой X-Cart','ru'),(53,26,'Address book','en'),(54,26,'Мои адреса','ru'),(55,27,'Order list','en'),(56,27,'Мои заказы','ru'),(57,28,'Account details','en'),(58,28,'Личный кабинет','ru');
/*!40000 ALTER TABLE `[[dbprefix]]menu_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]menus`
--

DROP TABLE IF EXISTS `[[dbprefix]]menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]menus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lpos` int(11) NOT NULL,
  `rpos` int(11) NOT NULL,
  `depth` int(11) NOT NULL,
  `type` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `visibleFor` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9AC666883727ACA70` (`parent_id`),
  KEY `enabled` (`enabled`,`type`),
  KEY `position` (`position`),
  CONSTRAINT `FK_9AC666883727ACA70` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]menus` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]menus`
--

LOCK TABLES `[[dbprefix]]menus` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]menus` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]menus` VALUES (1,2,'{home}',2,3,0,'P',100,1,'AL'),(2,NULL,'link',1,56,-1,'P',0,1,'AL'),(3,2,'{my account}',4,9,0,'P',600,1,'L'),(4,3,'?target=order_list',5,6,1,'P',100,1,'L'),(5,3,'?target=address_book',7,8,1,'P',200,1,'L'),(6,2,'shipping',10,11,0,'P',200,1,'AL'),(7,2,'{new arrivals}',12,13,0,'P',400,1,'AL'),(8,2,'{coming soon}',14,15,0,'P',500,1,'AL'),(9,2,NULL,16,23,0,'P',150,1,'AL'),(10,9,'{sale}',17,18,1,'P',100,1,'AL'),(11,9,'{bestsellers}',19,20,1,'P',200,1,'AL'),(12,9,'?target=special_offers',21,22,1,'P',300,0,'AL'),(13,2,'{contact us}',24,25,0,'P',700,1,'AL'),(14,2,NULL,26,33,0,'F',200,1,'AL'),(15,14,'{sale}',27,28,1,'F',100,1,'AL'),(16,14,'{coming soon}',29,30,1,'F',200,1,'AL'),(17,14,'{new arrivals}',31,32,1,'F',300,1,'AL'),(18,2,NULL,34,41,0,'F',300,1,'AL'),(19,18,'shipping',35,36,1,'F',100,1,'AL'),(20,18,'?target=map',37,38,1,'F',200,1,'AL'),(21,18,'terms-and-conditions',39,40,1,'F',300,1,'AL'),(22,2,NULL,42,47,0,'F',400,1,'AL'),(23,22,'shipping',43,44,1,'F',100,1,'AL'),(24,22,'{contact us}',45,46,1,'F',200,1,'AL'),(25,2,NULL,48,55,0,'F',500,1,'L'),(26,25,'?target=address_book',49,50,1,'F',100,1,'L'),(27,25,'?target=order_list',51,52,1,'F',200,1,'L'),(28,25,'?target=profile',53,54,1,'F',300,1,'L');
/*!40000 ALTER TABLE `[[dbprefix]]menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]money_modificators`
--

DROP TABLE IF EXISTS `[[dbprefix]]money_modificators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]money_modificators` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `modificator` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `validator` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  `behavior` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `purpose` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]money_modificators`
--

LOCK TABLES `[[dbprefix]]money_modificators` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]money_modificators` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]money_modificators` VALUES (1,'XLite\\Logic\\AttributeSurcharge','modifyMoney','isApply',10,'','net'),(2,'XLite\\Module\\CDev\\Sale\\Logic\\SalePrice','modifyMoney','isApply',5,'','net'),(3,'XLite\\Module\\CDev\\Sale\\Logic\\PercentOff','modifyMoney','isApply',500,'','net'),(4,'XLite\\Module\\CDev\\Sale\\Logic\\SaleDiscount','modifyMoney','isApply',600,'','net'),(5,'XLite\\Module\\XPay\\XPaymentsCloud\\Logic\\IncludedVAT','modifyMoney','isApply',2000,'','xpaymentsNetFee'),(6,'XLite\\Module\\XPay\\XPaymentsCloud\\Logic\\ExcludedVAT','modifyMoney','isApply',2000,'','xpaymentsDisplayFee'),(7,'XLite\\Module\\XPay\\XPaymentsCloud\\Logic\\SubscriptionFeeModifier','modifyMoney','isApply',50,'','xpaymentsNetFee'),(8,'XLite\\Module\\XPay\\XPaymentsCloud\\Logic\\SubscriptionFee','modifyMoney','isApply',100000,'','net');
/*!40000 ALTER TABLE `[[dbprefix]]money_modificators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]news`
--

DROP TABLE IF EXISTS `[[dbprefix]]news`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  `date` int(11) NOT NULL,
  `metaDescType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]news`
--

LOCK TABLES `[[dbprefix]]news` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]news` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]news` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]news_message_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]news_message_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]news_message_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `brief_description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metaTags` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metaDesc` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metaTitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_931246BD0BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]news` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]news_message_translations`
--

LOCK TABLES `[[dbprefix]]news_message_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]news_message_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]news_message_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]newsletter_subscriptions_subscribers`
--

DROP TABLE IF EXISTS `[[dbprefix]]newsletter_subscriptions_subscribers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]newsletter_subscriptions_subscribers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profile_id` int(11) DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `IDX_9D0911E5FCCFA12B8` (`profile_id`),
  CONSTRAINT `FK_9D0911E5FCCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `[[dbprefix]]profiles` (`profile_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]newsletter_subscriptions_subscribers`
--

LOCK TABLES `[[dbprefix]]newsletter_subscriptions_subscribers` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]newsletter_subscriptions_subscribers` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]newsletter_subscriptions_subscribers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]notification_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]notification_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]notification_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `customerSubject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customerText` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `adminSubject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `adminText` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_93F6179FEBF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]notifications` (`templatesDirectory`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]notification_translations`
--

LOCK TABLES `[[dbprefix]]notification_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]notification_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]notification_translations` VALUES (1,'failed_admin_login','Failed admin login','The notification is sent to the email address of the admin user for whose account failed login attempts have been detected several times in a row.','','','Password issue detected','<h3 dir=\"ltr\">Hey there,</h3><p dir=\"ltr\">Someone (hopefully you) is trying to log into your account. If it is indeed you, cool, but it looks like you forgot your password. If so, you can retrieve and reset it <a href=\"%reset_link%\">here</a>.</p><p dir=\"ltr\">If these login attempts have not been made by you, you should reset your password immediately using a strong password. Also, to stay safe, make sure you don&rsquo;t share your login creds with anyone.</p>','en'),(2,'failed_transaction','Payment declined','This notification is sent to the administrator if payment on the checkout failed','','','Payment was declined','<p dir=\"ltr\">Hmmm . . . let&rsquo;s solve this one together:</p><p dir=\"ltr\">One of your customers was trying to make a purchase, but the payment was declined..</p><p dir=\"ltr\">%dynamic_message%</p><p dir=\"ltr\">This can happen for lots of reasons: your customer entered a wrong card number, password, or CVC; maxed out the credit limit, failed to activate the card initially, closed the browser by mistake . . .</p><p dir=\"ltr\">Whatever the cause and the case, it may be a good idea to contact the customer and offer your help.</p>','en'),(3,'low_limit_warning','Low limit warning','This message is used to notify the administrator when the stock level of a product reaches the low stock limit as specified in the product details.','','','You are running out of %product_name%','<h3 dir=\"ltr\">Heads-up!</h3><p dir=\"ltr\">You&rsquo;re about to stock out! According to our stats, you&rsquo;ll likely sell the last item of this product by %latest_sale_date%. Since you can&rsquo;t sell what you don&rsquo;t have, consider replenishing the product ASAP.</p><p dir=\"ltr\">%dynamic_message%</p>','en'),(4,'backorder_created','Backordered item in the order','This notification is sent to the administrator if one or more products in a customer\'s order are out of stock at the time of order placement.','','','A new backorder %backordered_item_names%','<p dir=\"ltr\">A customer has just bought one or more items that are out of stock at the moment. It is time to replenish your supplies.&nbsp;</p><p dir=\"ltr\"><a href=\"%order_link%\">Check the order #%order_number%</a></p>','en'),(5,'order_changed','Order changed','This notification is sent to both the administrator and customer when the status of an order is updated - in the event that no other type of notification is sent.','Order #%order_number% is updated','<p dir=\"ltr\">As promised, here&rsquo;s an update to your order. Here&rsquo;s the updated status as reflected on your invoice. Please check it to make sure that everything looks good.</p>','Order #%order_number% is changed','<p dir=\"ltr\">Here are the order changes just in case you need to refer to them in the future. Please review the order history and make sure that everything looks correct.</p>','en'),(6,'order_canceled','Order canceled','This notification is sent to both the administrator and customer when an order gets the status Canceled.','Order #%order_number% is canceled','<p dir=\"ltr\">Your order has been canceled. If you initiated the cancellation, please tell us why so we can continually improve our selection and service. To let us know, or for any questions, just hit reply.</p>','Order #%order_number% is canceled','<p dir=\"ltr\">Just a note to confirm that this order has been canceled. Please make any adjustments necessary.</p>','en'),(7,'order_created','Order created','This notification is sent to both the administrator and customer when a new order is created from scratch and gets Awaiting Payment or Authorized statuses.','Order #%order_number% is received','<p dir=\"ltr\">Thank you for shopping with us!</p><p dir=\"ltr\">This is just a quick note to let you know that we&rsquo;ve received your order and it&rsquo;s in process!. We&rsquo;ll keep you updated on the status of your order.</p>','You’ve got a new order! #%order_number% for %order_total%','<p dir=\"ltr\">Commerce is happening! There’s a new order for you. Go ahead and process it ASAP so your customer enjoys quick service and delivery.</p>','en'),(8,'order_failed','Order declined','This notification is sent to both the administrator and customer when an order gets the status Declined.','Order #%order_number% is declined','<h3 dir=\"ltr\">Hi %recipient_name%,</h3><p dir=\"ltr\">We&rsquo;ve hit a snag. %payment_method_name% declined your payment. Perhaps your credit card is expired or you need to update some other details.</p><p dir=\"ltr\">If everything seems alright on your side and you are eager to proceed with the purchase, please reply. We&rsquo;ll try to find out what&rsquo;s up and rectify the issue.</p>','Order #%order_number% is declined','<p dir=\"ltr\">It looks like an order payment was declined by %payment_method_name%. Help the customer (and save the sale) by contacting your customer and offering your help.</p>','en'),(9,'order_processed','Order processed','This notification is sent to both the administrator and customer when an order gets the status Paid.','Order #%order_number% is paid (yay!)','<h2 dir=\"ltr\" style=\"text-align: center;\">Your order was paid successfully, %recipient_name%!</h2><h3 dir=\"ltr\" style=\"text-align: center;\">And we&rsquo;re just as excited as you are!</h3><p dir=\"ltr\">Payment for your order has been received and processed. We&rsquo;ll let you know when the order ships or is ready for pickup.</p>','Order #%order_number% is paid','<h3 dir=\"ltr\">Great news!</h3><p dir=\"ltr\">This order has been processed and paid for. Keep on selling!</p>','en'),(10,'order_shipped','Order shipped','This notification is sent to the customer when an order gets the status Shipped.','Order #%order_number% is shipped','<h2 dir=\"ltr\" style=\"text-align: center;\">Bingo, %recipient_name%!</h2><h3 dir=\"ltr\" style=\"text-align: center;\">Your item is on its way to your doorstep!</h3><p dir=\"ltr\"><br>Woohoo! Your order is en route to you and should be delivered to you soon!</p><p dir=\"ltr\">%dynamic_message%</p><p dir=\"ltr\">If you have any questions, feel free to get in touch. We&rsquo;re always here and happy to help you.</p>','','','en'),(11,'order_tracking_information','Order tracking information','This notification is sent to the customer when an administrator clicks the \"Send tracking information to customer\" button.','Order #%order_number% tracking information','<p dir=\"ltr\">Your order is en route via %shipping_method_name%.&nbsp;</p><p dir=\"ltr\">Below you&rsquo;ll find shipping details and a handy tracking link you can use to follow your order&rsquo;s trip to your door.</p><p dir=\"ltr\">%dynamic_message%</p><p dir=\"ltr\">Don&#39;t worry if order tracking isn&rsquo;t available right away. It may take some time for the tracking number to enter the system.</p>','','','en'),(12,'order_waiting_for_approve','Order awaiting for approval','This notification is sent to the customer when an order gets the status Waiting for approve.','Order #%order_number% is pending','<p dir=\"ltr\">Thank you for shopping on %company_name%!&nbsp;</p><p dir=\"ltr\">Your order is currently pending and we&rsquo;ll let you know when it reaches the next phase. In the meantime, you don&rsquo;t need to do anything. Just keep an eye on your inbox.</p>','','','en'),(13,'profile_created','User profile created','This notification is sent to both the administrator and customer when a new customer profile is created.','Welcome to %company_name%!','<h3 dir=\"ltr\" style=\"text-align: center;\">Welcome to %company_name%!</h3><p dir=\"ltr\">Your account is active and ready! You&rsquo;re ready to shop and manage your profile. In addition to finding all of the products you need, you&rsquo;ll also be able to access:</p><ul><li dir=\"ltr\">your order history</li><li dir=\"ltr\">your address book so you can ship to multiple locations</li><li dir=\"ltr\">security features where you can edit your login and password</li><li dir=\"ltr\">communications between you and our helpful employees</li></ul><p>Sign in to <a href=\"%sign_in_url%\">your account</a> to start using all these features. And if you have any questions, just reply.&nbsp;</p>','Great news: You\'ve got a new customer!','<h3 dir=\"ltr\">Hello and congratulations!</h3><p dir=\"ltr\">One more customer has just created a profile on your online store: %customer_email%. Looks like your business is growing :)</p>','en'),(14,'profile_deleted','User profile deleted','This notification is sent to the administrator when a customer profile is deleted.','','','Bummer, one customer fewer','<p dir=\"ltr\">One of your customers has just deleted his or her profile: %deleted_profile%</p><p dir=\"ltr\">Be cool and respect privacy guidelines by making sure that you no longer keep account-related personal data anywhere in your database.</p>','en'),(15,'recover_password_request','Password reset request','This notification is sent to the user when a password reset is requested for their account.','Password reset request','<p dir=\"ltr\">We&rsquo;ve received a request to reset your forgotten password.</p><p dir=\"ltr\">If you didn&rsquo;t make the request (or you remembered the password on your own), cool, there&rsquo;s nothing else you need to do. Just safely ignore this message.&nbsp;</p><p>Otherwise, please <a href=\"%recover_url%\">click here to change your password</a> right away.</p>','Password reset request','<p dir=\"ltr\">I&rsquo;ve received a request to reset your password.</p><p dir=\"ltr\">If you didn&rsquo;t make this request, simply do . . . nothing. It&rsquo;s all good.</p><p dir=\"ltr\">Otherwise, please proceed and <a href=\"%recover_url%\">click here to change your password</a>.</p>','en'),(16,'register_anonymous','User account created for guest buyer based on order info','This notification is sent to the customer when a customer profile is created for them by the store administrator based on a previously created order.','Welcome to %company_name%!','<h2 dir=\"ltr\" style=\"text-align: center;\">Thank you for shopping with us, %recipient_name%!&nbsp;</h2><p dir=\"ltr\">We noticed that you&rsquo;ve made a purchase using our guest checkout. To save you time on future orders, we&rsquo;ve created an account for you. Simply log in with the following credentials.</p><p dir=\"ltr\">Email: <strong>%customer_email%</strong><br>Password: <strong>%customer_password%</strong></p><p dir=\"ltr\">There you&rsquo;ill find all of your orders, addresses, messages, and profile details.&nbsp;</p><p dir=\"ltr\">Enjoy expedited checkout and don&rsquo;t forget to change your password for extra security.</p><p dir=\"ltr\">If you need any help, just reply.&nbsp;</p>','','','en'),(17,'access_link','Access link re-sent','This notification is sent to the guest buyer when they request a new link for access to information about their order after an access link issued to them previously has expired.','New access link','','','','en'),(18,'modules/CDev/ContactUs/message','Contact us form submitted (Contact us module)','This notification is sent to the administrator when someone submits a request via the \"Contact us\" form.','','','New message: %message_subject%','<p dir=\"ltr\">%message_author% has sent you a message through the “Contact us” form and is waiting for your reply. Bust out the killer customer care and get in touch with him or her in a timely manner.</p><blockquote><p dir=\"ltr\">%message%</p></blockquote>','en'),(19,'modules/CDev/Egoods/egoods_links','E-goods download links (E-goods module)','This notification is sent to the customer when their order containing egoods gets the status Paid.','Download your digital purchase','<h2 dir=\"ltr\" style=\"text-align: center;\">Your order is ready, %recipient_name%!</h2><h3 dir=\"ltr\" style=\"text-align: center;\">And we are just as excited as you are<br><br></h3><p dir=\"ltr\">The items listed below have been paid for and are ready for download!</p><p dir=\"ltr\">%dynamic_message%</p><p dir=\"ltr\">If you encounter any difficulty downloading, feel free to contact us.</p>','','','en'),(20,'modules/XC/CanadaPost/return_approved','Return request approved (Canada Post module)','This notification is sent to the customer if their request to return a product via Canada Post is approved by the administrator.','Order #%order_number%: Return request approved','<p dir=\"ltr\">We&rsquo;re sorry to hear that your order didn&rsquo;t work out as hoped.</p><p dir=\"ltr\">%dynamic_message%</p><p dir=\"ltr\">We&rsquo;re happy to take the items back for a full refund and we hope we can better meet your needs in the future. Please, <a href=\"https://www.canadapost.ca/web/en/kb/details.page?article=how_do_i_return_a_re&cattype=kb&cat=atthepostoffice&subcat=services\">ship the package back to our office</a> using the parcel service that best meets your needs.&nbsp;</p><p dir=\"ltr\">Feel free to contact us if you have any questions.</p>','','','en'),(21,'modules/XC/CanadaPost/return_approved','Запрос на возврат товара одобрен (модуль Canada Post)','Данное сообщение отправляется покупателю в случае, если его запрос на возврат товара с пересылкой службой Canada Post получает одобрение администратора.','Ваш запрос на возврат товара одобрен','Ваш запрос на возврат товара одобрен','','','ru'),(22,'modules/XC/CanadaPost/return_rejected','Return request rejected (Canada Post module)','This notification is sent to the customer if their request to return a product via Canada Post is rejected by the administrator.','Order #%order_number%: Return request rejected','<h3 dir=\"ltr\">Hello %recipient_name%,</h3><p dir=\"ltr\">Unfortunately, we cannot take your products or issue a refund according to our stated policy.</p><p dir=\"ltr\">%dynamic_message%</p><p dir=\"ltr\">Please contact us if you have any questions.</p>','','','en'),(23,'modules/XC/CanadaPost/return_rejected','Запрос на возврат товара отклонен (модуль Canada Post)','Данное сообщение отправляется покупателю в случае, если его запрос на возврат товара с пересылкой службой Canada Post отклоняется администратором.','Ваш запрос на возврат товара отклонен','Ваш запрос на возврат товара отклонен','','','ru'),(24,'modules/XC/Reviews/new_review','New product review submitted (Product Reviews module)','This message is used to notify the administrator when a customer submits a new product review.','','','New review for ‘%product_name%’','<p dir=\"ltr\">%author_name% has just rated your &quot;%product_name%&quot; and left a review for you.</p><p dir=\"ltr\">%dynamic_message%</p><blockquote><p dir=\"ltr\">%review%</p></blockquote><p dir=\"ltr\">Follow <a href=\"%product_link%\">this link</a> to approve or remove this review. And don&rsquo;t forget to reply to the customer. If there&rsquo;s a problem, now&rsquo;s your chance to make it right and be a customer-service hero. If you&rsquo;ve gotten a rave review, reach out, thank the reviewer, and ask if there&rsquo;s anything else you can help with. Both scenarios are great opportunities to build strong relationships and an excellent reputation.</p>','en'),(25,'modules/XC/Reviews/review_key','Request to review purchased products - (Product Reviews module)','This message is used to invite customers to leave feedback on the products they have purchased.','Order #%order_number%: Please, review','<p>Thank you for purchasing our products! We hope you love them.</p><p>%dynamic_message%</p><p>Please take a minute to review your order to let others know that you&rsquo;ve found a gem and want to share the goodness!</p>','','','en'),(26,'modules/XC/Reviews/review_key','Приглашение оставить отзыв на купленные товары - (модуль Product Reviews)','Данное сообщение используется для отправки покупателю приглашения оставить отзыв о купленных им товарах.','Пожалуйста, оставьте отзыв о купленных товарах','','','','ru'),(27,'modules/XC/VendorMessages/notification','Order message (Order messages module)','This message will be sent to the customer when a new message appears in the communication thread regarding an order','Order #%order_number%: new message from seller','<p dir=\"ltr\">You have a new message about order <a href=\"%order_link%\">#%order_number%</a>. Please review the message and take any necessary action.</p><blockquote><p dir=\"ltr\">%message%</p></blockquote>','','','en'),(28,'modules/XC/VendorMessages/notification','Новое сообщение по заказу (модуль Order messages)','Это уведомление будет отправлено покупателю, когда в контексте сделанного им заказа появится новое сообщение','Новое сообщение по заказу №%order_number%','%company_link%\n<p>\nВы получили новое сообщение по заказу %order_messages_link%:\n</p>\n<p>\n%message%\n</p>\n','','','ru'),(29,'modules/XC/VendorMessages/new_message_notification','New message (Order messages module)','This message will be sent to customer when a new message appears in the conversation','New message in conversation','<p>You&#39;ve got a new message in %conversation_link%</p><blockquote><p>%message%</p></blockquote>','','','en'),(30,'modules/XC/VendorMessages/new_message_notification','Новое сообщение (модуль Order messages)','Это уведомление будет отправлено покупателю, когда в разговоре появится новое сообщение','Новое сообщение в разговоре','%company_link%\n<p>\nВы получили новое сообщение в %conversation_link%\n</p>\n<p>\n%message%\n</p>\n','','','ru'),(31,'modules/XPay/XPaymentsCloud/subscription_status_A','Subscription activated (X-Payments Cloud module)','This notification is sent after first order of subscription and also when it\'s status is changed from Stopped/Failed/Restarted to Active','Your subscription has been activated','<p>Your subscription %subscriptionName% has been activated.</p><p>Subscription ID: #%subscriptionId%<br>Setup fee: %setupFee%<br>Subscription fee: %subscriptionFee%<br>Plan: %planDescription%<br>Planned date of the next payment: %plannedDate%</p><p>You can manage your subscriptions here: %pageUrl%.</p>','Subscription #%subscriptionId% has been activated','<p>Subscription #%subscriptionId% has been activated.</p><p>Setup fee: %setupFee%<br>Subscription fee: %subscriptionFee%<br>Plan: %planDescription%<br>Planned date of the next payment: %plannedDate%</p>','en'),(32,'modules/XPay/XPaymentsCloud/subscription_status_A','Подписка активирована (модуль X-Payments Cloud)','Данное сообщение отправляется после покупки подписки, а также в случае смены её статуса на Active','','','','','ru'),(33,'modules/XPay/XPaymentsCloud/subscription_status_S','Subscription stopped (X-Payments Cloud module)','This notification is sent after first order of subscription and also when it\'s status is changed from Active/Restarted to Stopped','Your subscription #%subscriptionId% has been stopped','<p>Your subscription %subscriptionName% has been stopped.</p><p>Subscription ID: #%subscriptionId%</p><p>You can manage your subscriptions here: %pageUrl%.</p>','Subscription %subscriptionId% has been stopped','<p>Subscription #%subscriptionId% %subscriptionName% has been stopped.</p>','en'),(34,'modules/XPay/XPaymentsCloud/subscription_status_S','Подписка остановлена (модуль X-Payments Cloud)','Данное сообщение отправляется после смены её статуса на Stopped','','','','','ru'),(35,'modules/XPay/XPaymentsCloud/order_created','Upcoming subscription payment (X-Payments Cloud module)','This notification is sent few days before next scheduled payment on subscription','Upcoming subscription #%subscriptionId% payment notification','<p>Order #%orderNumber% created for next payment on subscription #%subscriptionId% %pendingPaymentNumber%</p><p>It will be charged on %actualDate%</p>','Order %orderNumber% created for next payment on subscription #%subscriptionId%','<p>Order #%orderNumber% created for next payment on subscription #%subscriptionId% %pendingPaymentNumber%</p><p>It will be charged on %actualDate%</p>','en'),(36,'modules/XPay/XPaymentsCloud/order_created','Предстоящий платёж по подписке (модуль X-Payments Cloud)','Данное сообщение отправляется за несколько дней до следующего платежа по подписке','','','','','ru'),(37,'modules/XPay/XPaymentsCloud/payment_successful','Subscription payment successful (X-Payments Cloud module)','This notification is sent when scheduled payment on subscriptions is succesfully charged','Subscription #%subscriptionId% payment successfully charged','<p>Subscription #%subscriptionId% payment successfully charged.</p><p>Planned date of the next payment: %plannedDate%</p><p>You can manage your subscriptions here: %pageUrl%.</p>','Subscription %subscriptionId% payment successfully charged','<p>Subscription #%subscriptionId% payment successfully charged.</p><p>Planned date of the next payment: %plannedDate%</p>','en'),(38,'modules/XPay/XPaymentsCloud/payment_successful','Платёж по подписке прошёл успешно (модуль X-Payments Cloud)','Данное сообщение отправляется если платеж по подписке прошёл успешно','','','','','ru'),(39,'modules/XPay/XPaymentsCloud/payment_failed','Subscription payment failed (X-Payments Cloud module)','This notification is sent when scheduled payment on subscription fails','Transaction for order #%orderNumber% has failed','<p>Transaction for this order has failed. Next charge attempt will be at %actualDate%</p><p>You can manage your subscriptions here: %pageUrl%.</p>','%companyName%: Transaction for order #%orderNumber% has failed','<p>Transaction for this order has failed. Next charge attempt will be at %actualDate%</p>','en'),(40,'modules/XPay/XPaymentsCloud/payment_failed','Платёж по подписке не прошёл из-за ошибки (модуль X-Payments Cloud)','Данное сообщение отправляется если платеж по подписке не прошёл из-за ошибки','','','','','ru'),(41,'modules/XPay/XPaymentsCloud/subscription_failed','Subscription stopped after failed payments (X-Payments Cloud module)','This notification is sent when it\'s status is changed to Failed after multiple failed payment','Your subscription #%subscriptionId% has been failed','<p>Subscription #%subscriptionId% has been failed. Please try to use another payment card or contact the store administrator.</p><p>%reason%</p><p>You can manage your subscriptions here: %pageUrl%.</p>','Subscription %subscriptionId% has been failed','<p>Subscription %subscriptionId% has been failed</p><p>%reason%</p>','en'),(42,'modules/XPay/XPaymentsCloud/subscription_failed','Подписка остановлена из-за неуспешных платежей (модуль X-Payments Cloud)','Данное сообщение отправляется после смены её статуса на Failed после нескольких неуспешных платежей','','','','','ru');
/*!40000 ALTER TABLE `[[dbprefix]]notification_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]notifications`
--

DROP TABLE IF EXISTS `[[dbprefix]]notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]notifications` (
  `templatesDirectory` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `availableForAdmin` tinyint(1) NOT NULL,
  `availableForCustomer` tinyint(1) NOT NULL,
  `enabledForAdmin` tinyint(1) NOT NULL,
  `enabledForCustomer` tinyint(1) NOT NULL,
  `adminHeaderEnabled` tinyint(1) NOT NULL,
  `adminGreetingEnabled` tinyint(1) NOT NULL,
  `adminSignatureEnabled` tinyint(1) NOT NULL,
  `customerHeaderEnabled` tinyint(1) NOT NULL,
  `customerGreetingEnabled` tinyint(1) NOT NULL,
  `customerSignatureEnabled` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL DEFAULT '0',
  `editable` tinyint(1) NOT NULL,
  PRIMARY KEY (`templatesDirectory`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]notifications`
--

LOCK TABLES `[[dbprefix]]notifications` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]notifications` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]notifications` VALUES ('access_link',0,0,0,1,0,0,1,1,0,1,2700,1),('backorder_created',1,0,1,0,1,1,1,1,1,1,700,1),('failed_admin_login',1,0,1,0,1,0,1,1,1,1,100,1),('failed_transaction',1,0,1,0,1,0,1,1,1,1,200,1),('low_limit_warning',1,0,1,0,1,0,1,1,1,1,300,1),('modules/CDev/ContactUs/message',0,0,1,0,1,1,1,1,1,1,500,1),('modules/CDev/Egoods/egoods_links',0,1,0,1,1,0,1,1,0,1,600,1),('modules/XC/CanadaPost/return_approved',0,1,0,1,1,0,1,1,1,1,800,1),('modules/XC/CanadaPost/return_rejected',0,1,0,1,1,0,1,1,0,1,900,1),('modules/XC/Reviews/new_review',1,0,1,0,1,1,1,0,0,0,1000,1),('modules/XC/Reviews/review_key',0,1,0,0,0,0,0,1,1,1,0,1),('modules/XC/VendorMessages/new_message_notification',0,1,0,1,1,0,1,1,1,1,1200,1),('modules/XC/VendorMessages/notification',0,1,0,1,1,0,1,1,1,1,1100,1),('modules/XPay/XPaymentsCloud/order_created',1,1,1,1,1,0,1,1,1,1,3200,1),('modules/XPay/XPaymentsCloud/payment_failed',1,1,1,1,1,0,1,1,1,1,3400,1),('modules/XPay/XPaymentsCloud/payment_successful',1,1,1,1,1,0,1,1,1,1,3300,1),('modules/XPay/XPaymentsCloud/subscription_failed',1,1,1,1,1,0,1,1,1,1,3500,1),('modules/XPay/XPaymentsCloud/subscription_status_A',1,1,1,1,1,0,1,1,1,1,3000,1),('modules/XPay/XPaymentsCloud/subscription_status_S',1,1,1,1,1,0,1,1,1,1,3100,1),('order_canceled',1,1,1,1,0,1,1,0,1,1,1500,1),('order_changed',1,1,1,1,1,1,1,0,1,1,1400,1),('order_created',1,1,1,1,0,1,1,0,1,1,1600,1),('order_failed',1,1,1,1,1,1,1,1,0,1,1700,1),('order_processed',1,1,1,1,0,0,1,0,0,1,1800,1),('order_shipped',0,1,0,1,0,0,1,0,0,1,1900,1),('order_tracking_information',0,0,0,1,0,0,1,1,1,1,2000,1),('order_waiting_for_approve',0,1,0,1,0,0,1,1,1,1,2100,1),('profile_created',1,1,0,1,1,0,1,1,0,1,2200,1),('profile_deleted',1,0,0,0,1,1,1,1,1,1,2300,1),('recover_password_request',0,0,1,1,1,1,1,1,1,1,2500,1),('register_anonymous',0,1,0,1,1,0,1,1,0,1,2600,1);
/*!40000 ALTER TABLE `[[dbprefix]]notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_backorder_competitors`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_backorder_competitors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_backorder_competitors` (
  `id` int(11) NOT NULL,
  `competitor_id` int(11) NOT NULL,
  PRIMARY KEY (`id`,`competitor_id`),
  KEY `IDX_9C73B739BBF396750` (`id`),
  KEY `IDX_9C73B739B78A5D405` (`competitor_id`),
  CONSTRAINT `FK_9C73B739B78A5D405` FOREIGN KEY (`competitor_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9C73B739BBF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_backorder_competitors`
--

LOCK TABLES `[[dbprefix]]order_backorder_competitors` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_backorder_competitors` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_backorder_competitors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_office`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_office`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_office` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `officeId` char(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `distance` decimal(12,2) NOT NULL,
  `bilingualDesignation` tinyint(1) NOT NULL,
  `city` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `latitude` decimal(15,5) NOT NULL,
  `longitude` decimal(15,5) NOT NULL,
  `postalCode` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `province` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `officeAddress` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `workingHours` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `orderId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CE3DE61FFA237437` (`orderId`),
  CONSTRAINT `FK_9CE3DE61FFA237437` FOREIGN KEY (`orderId`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_office`
--

LOCK TABLES `[[dbprefix]]order_capost_office` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_office` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_office` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_items`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` int(11) NOT NULL,
  `parcelId` int(11) DEFAULT NULL,
  `orderItemId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_918699C805A9ACC87` (`parcelId`),
  KEY `IDX_918699C80BBF22A26` (`orderItemId`),
  CONSTRAINT `FK_918699C805A9ACC87` FOREIGN KEY (`parcelId`) REFERENCES `[[dbprefix]]order_capost_parcels` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_918699C80BBF22A26` FOREIGN KEY (`orderItemId`) REFERENCES `[[dbprefix]]order_items` (`item_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_items`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_items` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_manifest_link_storage`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_manifest_link_storage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_manifest_link_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `linkId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_73059AC5AEC98E42` (`linkId`),
  CONSTRAINT `FK_973059AC5AEC98E42` FOREIGN KEY (`linkId`) REFERENCES `[[dbprefix]]order_capost_parcel_manifest_links` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_manifest_link_storage`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_manifest_link_storage` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_manifest_link_storage` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_manifest_link_storage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_manifest_links`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_manifest_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_manifest_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `href` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idx` int(11) DEFAULT NULL,
  `mediaType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `manifestId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_97FE471EA99AD4367` (`manifestId`),
  CONSTRAINT `FK_97FE471EA99AD4367` FOREIGN KEY (`manifestId`) REFERENCES `[[dbprefix]]order_capost_parcel_manifests` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_manifest_links`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_manifest_links` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_manifest_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_manifest_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_manifests`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_manifests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_manifests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `poNumber` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `href` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idx` int(11) DEFAULT NULL,
  `mediaType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_manifests`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_manifests` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_manifests` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_manifests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_shipment`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_shipment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_shipment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shipmentId` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipmentStatus` varchar(14) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trackingPin` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `returnTrackingPin` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `poNumber` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parcelId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_7954C1A5A9ACC87` (`parcelId`),
  CONSTRAINT `FK_97954C1A5A9ACC87` FOREIGN KEY (`parcelId`) REFERENCES `[[dbprefix]]order_capost_parcels` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_shipment`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_shipment` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_shipment_link_storage`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_shipment_link_storage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_shipment_link_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `linkId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_82EA5F8AAEC98E42` (`linkId`),
  CONSTRAINT `FK_982EA5F8AAEC98E42` FOREIGN KEY (`linkId`) REFERENCES `[[dbprefix]]order_capost_parcel_shipment_links` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_shipment_link_storage`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_shipment_link_storage` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_link_storage` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_link_storage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_shipment_links`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_shipment_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_shipment_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `href` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idx` int(11) DEFAULT NULL,
  `mediaType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipmentId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9EB25DE223C5EEBE2` (`shipmentId`),
  CONSTRAINT `FK_9EB25DE223C5EEBE2` FOREIGN KEY (`shipmentId`) REFERENCES `[[dbprefix]]order_capost_parcel_shipment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_shipment_links`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_shipment_links` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_shipment_tracking`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_shipment_tracking`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `expiry` int(10) unsigned NOT NULL,
  `pin` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activeExists` tinyint(1) NOT NULL,
  `archiveExists` tinyint(1) NOT NULL,
  `destinationPostalId` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expectedDeliveryDate` int(10) unsigned DEFAULT NULL,
  `changedExpectedDate` int(10) unsigned DEFAULT NULL,
  `changedExpectedDeliveryReason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mailedByCustomerNumber` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mailedOnBehalfOfCustomerNumber` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `originalPin` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serviceName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serviceName_2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customerRef_1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customerRef_2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `returnPin` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `signatureImageExists` tinyint(1) NOT NULL,
  `suppressSignature` tinyint(1) NOT NULL,
  `shipmentId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_619551123C5EEBE2` (`shipmentId`),
  CONSTRAINT `FK_9619551123C5EEBE2` FOREIGN KEY (`shipmentId`) REFERENCES `[[dbprefix]]order_capost_parcel_shipment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_shipment_tracking`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_shipment_tracking` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_shipment_tracking_events`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_shipment_tracking_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` char(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` char(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timeZone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `signatoryName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `site` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `province` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `retailLocationId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `retailName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trackingId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_975BDE7A6F76B6A7` (`trackingId`),
  CONSTRAINT `FK_975BDE7A6F76B6A7` FOREIGN KEY (`trackingId`) REFERENCES `[[dbprefix]]order_capost_parcel_shipment_tracking` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_shipment_tracking_events`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_shipment_tracking_events` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking_events` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_shipment_tracking_files`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_shipment_tracking_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `docType` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `trackingId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_94EB59AF6F76B6A7` (`trackingId`),
  CONSTRAINT `FK_94EB59AF6F76B6A7` FOREIGN KEY (`trackingId`) REFERENCES `[[dbprefix]]order_capost_parcel_shipment_tracking` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_shipment_tracking_files`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_shipment_tracking_files` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_shipment_tracking_options`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_shipment_tracking_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trackingId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9F6B816A26F76B6A7` (`trackingId`),
  CONSTRAINT `FK_9F6B816A26F76B6A7` FOREIGN KEY (`trackingId`) REFERENCES `[[dbprefix]]order_capost_parcel_shipment_tracking` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_shipment_tracking_options`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_shipment_tracking_options` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipment_tracking_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcel_shipments_manifests`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcel_shipments_manifests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcel_shipments_manifests` (
  `manifest_id` int(11) NOT NULL,
  `shipment_id` int(11) NOT NULL,
  PRIMARY KEY (`manifest_id`,`shipment_id`),
  KEY `IDX_98D3D4D8FE697B2FB` (`manifest_id`),
  KEY `IDX_98D3D4D8F7BE036FC` (`shipment_id`),
  CONSTRAINT `FK_98D3D4D8F7BE036FC` FOREIGN KEY (`shipment_id`) REFERENCES `[[dbprefix]]order_capost_parcel_shipment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_98D3D4D8FE697B2FB` FOREIGN KEY (`manifest_id`) REFERENCES `[[dbprefix]]order_capost_parcel_manifests` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcel_shipments_manifests`
--

LOCK TABLES `[[dbprefix]]order_capost_parcel_shipments_manifests` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipments_manifests` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcel_shipments_manifests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_capost_parcels`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_capost_parcels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_capost_parcels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `number` int(11) NOT NULL,
  `status` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quoteType` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `boxWeight` decimal(14,4) NOT NULL,
  `boxWidth` decimal(14,4) NOT NULL,
  `boxLength` decimal(14,4) NOT NULL,
  `boxHeight` decimal(14,4) NOT NULL,
  `isDocument` tinyint(1) NOT NULL,
  `isUnpackaged` tinyint(1) NOT NULL,
  `isMailingTube` tinyint(1) NOT NULL,
  `isOversized` tinyint(1) NOT NULL,
  `notifyOnShipment` tinyint(1) NOT NULL,
  `notifyOnException` tinyint(1) NOT NULL,
  `notifyOnDelivery` tinyint(1) NOT NULL,
  `optSignature` tinyint(1) NOT NULL,
  `optCoverage` decimal(14,4) NOT NULL,
  `optAgeProof` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL,
  `optWayToDeliver` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `optNonDelivery` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hasRemovedItems` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_935C9355A8D9F6D38` (`order_id`),
  KEY `status` (`status`),
  KEY `number` (`number`),
  CONSTRAINT `FK_935C9355A8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_capost_parcels`
--

LOCK TABLES `[[dbprefix]]order_capost_parcels` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcels` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_capost_parcels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_coupons`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_coupons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `coupon_id` int(10) unsigned DEFAULT NULL,
  `code` char(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9451D92198D9F6D38` (`order_id`),
  KEY `IDX_9451D921966C5951B` (`coupon_id`),
  CONSTRAINT `FK_9451D921966C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `[[dbprefix]]coupons` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9451D92198D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_coupons`
--

LOCK TABLES `[[dbprefix]]order_coupons` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_details`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_details` (
  `detail_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`detail_id`),
  KEY `IDX_9C25F888B8D9F6D38` (`order_id`),
  KEY `oname` (`order_id`,`name`),
  CONSTRAINT `FK_9C25F888B8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_details`
--

LOCK TABLES `[[dbprefix]]order_details` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_history_event_data`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_history_event_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_history_event_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9BAE0BB2471F7E88B` (`event_id`),
  KEY `en` (`event_id`,`name`),
  CONSTRAINT `FK_9BAE0BB2471F7E88B` FOREIGN KEY (`event_id`) REFERENCES `[[dbprefix]]order_history_events` (`event_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_history_event_data`
--

LOCK TABLES `[[dbprefix]]order_history_event_data` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_history_event_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_history_event_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_history_events`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_history_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_history_events` (
  `event_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `author_id` int(11) DEFAULT NULL,
  `date` int(11) NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `comment` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `authorName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorIp` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `IDX_957EBBA5F8D9F6D38` (`order_id`),
  KEY `IDX_957EBBA5FF675F31B` (`author_id`),
  CONSTRAINT `FK_957EBBA5F8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_957EBBA5FF675F31B` FOREIGN KEY (`author_id`) REFERENCES `[[dbprefix]]profiles` (`profile_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_history_events`
--

LOCK TABLES `[[dbprefix]]order_history_events` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_history_events` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]order_history_events` VALUES (1,1,1,1551771900,'PLACE ORDER','Order placed','N;','',NULL,''),(2,1,1,1551771900,'TRANSACTION','Payment transaction [method: Phone Ordering, type: sale, amount: 18.49, status: Pending]','N;','',NULL,''),(3,1,1,1551771900,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:1;}','Order is initially created',NULL,''),(4,2,1,1553772240,'PLACE ORDER','Order placed','N;','',NULL,''),(5,2,1,1553772240,'TRANSACTION','Payment transaction [method: Phone Ordering, type: sale, amount: 88.67, status: Pending]','N;','',NULL,''),(6,2,1,1553772240,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:2;}','Order is initially created',NULL,''),(7,3,1,1564729080,'PLACE ORDER','Order placed','N;','',NULL,''),(8,3,1,1564729080,'TRANSACTION','Payment transaction [method: Phone Ordering, type: sale, amount: 158.94, status: Pending]','N;','',NULL,''),(9,3,1,1564729080,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:3;}','Order is initially created',NULL,''),(10,4,1,1575162780,'PLACE ORDER','Order placed','a:1:{s:7:\"orderId\";i:4;}','',NULL,''),(11,4,1,1575172780,'TRANSACTION','Back end payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed] [initial request]','N;','',NULL,''),(12,4,1,1575172780,'TRANSACTION','Payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed]','N;','',NULL,''),(13,4,1,1575172780,'CHANGE PAYMENT STATUS ORDER','Order payment status changed from {{oldStatus}} to {{newStatus}}','a:3:{s:7:\"orderId\";i:4;s:9:\"newStatus\";s:8:\"Declined\";s:9:\"oldStatus\";s:16:\"Awaiting payment\";}','',NULL,''),(14,4,1,1575175780,'CHANGE PAYMENT STATUS ORDER','Order payment status changed from {{oldStatus}} to {{newStatus}}','a:3:{s:7:\"orderId\";i:4;s:9:\"newStatus\";s:16:\"Awaiting payment\";s:9:\"oldStatus\";s:8:\"Declined\";}','',NULL,''),(15,4,1,1575475780,'TRANSACTION','Back end payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed] [initial request]','N;','',NULL,''),(16,4,1,1575475780,'TRANSACTION','Payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed]','N;','',NULL,''),(17,4,1,1575485780,'CHANGE PAYMENT STATUS ORDER','Order payment status changed from {{oldStatus}} to {{newStatus}}','a:3:{s:7:\"orderId\";i:4;s:9:\"newStatus\";s:8:\"Declined\";s:9:\"oldStatus\";s:16:\"Awaiting payment\";}','',NULL,''),(18,5,1,1575163080,'PLACE ORDER','Order placed','N;','',NULL,''),(19,5,1,1575163080,'TRANSACTION','Payment transaction [method: Money Ordering, type: sale, amount: 352.81, status: Pending]','N;','',NULL,''),(20,5,1,1575163080,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:5;}','Order is initially created',NULL,'');
/*!40000 ALTER TABLE `[[dbprefix]]order_history_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_item_attribute_values`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_item_attribute_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_item_attribute_values` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `attribute_value_checkbox_id` int(10) unsigned DEFAULT NULL,
  `attribute_value_select_id` int(10) unsigned DEFAULT NULL,
  `attribute_value_text_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attributeId` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_946E30CEA126F525E` (`item_id`),
  KEY `IDX_946E30CEA571B5A02` (`attribute_value_checkbox_id`),
  KEY `IDX_946E30CEAA16D6CC9` (`attribute_value_select_id`),
  KEY `IDX_946E30CEA27A31B4D` (`attribute_value_text_id`),
  CONSTRAINT `FK_946E30CEA126F525E` FOREIGN KEY (`item_id`) REFERENCES `[[dbprefix]]order_items` (`item_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_946E30CEA27A31B4D` FOREIGN KEY (`attribute_value_text_id`) REFERENCES `[[dbprefix]]attribute_values_text` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_946E30CEA571B5A02` FOREIGN KEY (`attribute_value_checkbox_id`) REFERENCES `[[dbprefix]]attribute_values_checkbox` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_946E30CEAA16D6CC9` FOREIGN KEY (`attribute_value_select_id`) REFERENCES `[[dbprefix]]attribute_values_select` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_item_attribute_values`
--

LOCK TABLES `[[dbprefix]]order_item_attribute_values` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_item_attribute_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_item_attribute_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_item_private_attachments`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_item_private_attachments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_item_private_attachments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `attachment_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `downloadKey` char(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  `attempt` int(10) unsigned NOT NULL,
  `attemptLimit` int(10) unsigned NOT NULL,
  `blocked` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9BC5B98F1126F525E` (`item_id`),
  KEY `IDX_9BC5B98F1464E68B` (`attachment_id`),
  CONSTRAINT `FK_9BC5B98F1126F525E` FOREIGN KEY (`item_id`) REFERENCES `[[dbprefix]]order_items` (`item_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9BC5B98F1464E68B` FOREIGN KEY (`attachment_id`) REFERENCES `[[dbprefix]]product_attachments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_item_private_attachments`
--

LOCK TABLES `[[dbprefix]]order_item_private_attachments` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_item_private_attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_item_private_attachments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_item_surcharges`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_item_surcharges`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_item_surcharges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `type` char(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `include` tinyint(1) NOT NULL,
  `available` tinyint(1) NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weight` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9F9394518126F525E` (`item_id`),
  CONSTRAINT `FK_9F9394518126F525E` FOREIGN KEY (`item_id`) REFERENCES `[[dbprefix]]order_items` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_item_surcharges`
--

LOCK TABLES `[[dbprefix]]order_item_surcharges` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_item_surcharges` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_item_surcharges` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_items`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(10) unsigned DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `categoryAdded` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `xpaymentsEmulated` tinyint(1) NOT NULL,
  `xpaymentsUniqueId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sku` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(14,4) NOT NULL COMMENT '(DC2Type:money)',
  `itemNetPrice` decimal(14,4) NOT NULL,
  `discountedSubtotal` decimal(14,4) NOT NULL,
  `amount` int(11) NOT NULL,
  `backorderedAmount` int(11) NOT NULL,
  `total` decimal(14,4) NOT NULL,
  `subtotal` decimal(14,4) NOT NULL,
  `subscriptionId` int(10) unsigned DEFAULT NULL COMMENT 'Unique id',
  `object_type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `IDX_94693C0A1CA77D3A9` (`subscriptionId`),
  KEY `IDX_94693C0A18D9F6D38` (`order_id`),
  KEY `ooo` (`order_id`,`object_type`,`object_id`),
  KEY `object_id` (`object_id`),
  KEY `price` (`price`),
  KEY `amount` (`amount`),
  CONSTRAINT `FK_94693C0A1232D562B` FOREIGN KEY (`object_id`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_94693C0A18D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_94693C0A1CA77D3A9` FOREIGN KEY (`subscriptionId`) REFERENCES `[[dbprefix]]xpayments_subscriptions` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_items`
--

LOCK TABLES `[[dbprefix]]order_items` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_items` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]order_items` VALUES (1,42,1,'',0,'','Perfect Snacks','10000000118',19.9900,19.9900,16.9900,1,0,19.9900,19.9900,NULL,'product'),(2,3,2,'',0,'','Beige Sneakers','10000000069',19.9900,19.9900,39.9800,2,0,39.9800,39.9800,NULL,'product'),(3,8,2,'',0,'','Pink Sneakers with White Soles','10000000081',19.9900,14.9900,44.9700,3,0,44.9700,44.9700,NULL,'product'),(4,12,3,'',0,'','Waist Tie Dress in Blue and White Stripe','10000000085',9.9900,9.9900,59.9400,6,0,59.9400,59.9400,NULL,'product'),(5,16,3,'',0,'','Sleeved Mini Dress in Color Block','10000000089',99.0000,99.0000,99.9900,1,0,99.0000,99.0000,NULL,'product'),(6,10,4,'',0,'','Caged Cutout Sandals in Gold','10000000083',34.9900,34.9900,34.9900,1,0,34.9900,34.9900,NULL,'product'),(7,14,5,'',0,'','Multicolored Dress with Balloon Sleeves [Options & Attributes]','10000000087',29.9900,25.4900,305.8800,12,0,305.8800,305.8800,NULL,'product'),(8,26,5,'',0,'','Festival Braslet Pack in Gold Tone','10000000101',12.9900,6.4900,45.4300,7,0,45.4300,45.4300,NULL,'product');
/*!40000 ALTER TABLE `[[dbprefix]]order_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_modifiers`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_modifiers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_modifiers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weight` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_modifiers`
--

LOCK TABLES `[[dbprefix]]order_modifiers` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_modifiers` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]order_modifiers` VALUES (1,'XLite\\Logic\\Order\\Modifier\\Shipping',100),(2,'XLite\\Module\\CDev\\Coupons\\Logic\\Order\\Modifier\\Discount',50),(3,'XLite\\Module\\CDev\\SalesTax\\Logic\\Order\\Modifier\\Tax',1100),(4,'XLite\\Module\\CDev\\VolumeDiscounts\\Logic\\Order\\Modifier\\Discount',50);
/*!40000 ALTER TABLE `[[dbprefix]]order_modifiers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_payment_status_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_payment_status_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_payment_status_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customerName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9702453C2BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]order_payment_statuses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_payment_status_translations`
--

LOCK TABLES `[[dbprefix]]order_payment_status_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_payment_status_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]order_payment_status_translations` VALUES (1,1,'Awaiting payment','Awaiting payment','en'),(2,2,'Authorized','Authorization hold','en'),(3,3,'Partially Paid','Partially Paid','en'),(4,4,'Paid','Paid','en'),(5,5,'Declined','Declined','en'),(6,6,'Cancelled','Cancelled','en'),(7,7,'Refunded','Refunded','en');
/*!40000 ALTER TABLE `[[dbprefix]]order_payment_status_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_payment_statuses`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_payment_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_payment_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_A2C34C8E77153098` (`code`),
  KEY `code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_payment_statuses`
--

LOCK TABLES `[[dbprefix]]order_payment_statuses` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_payment_statuses` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]order_payment_statuses` VALUES (1,'Q',10),(2,'A',20),(3,'PP',30),(4,'P',40),(5,'D',50),(6,'C',60),(7,'R',70);
/*!40000 ALTER TABLE `[[dbprefix]]order_payment_statuses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_review_keys`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_review_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_review_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `keyValue` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `addedDate` int(11) NOT NULL,
  `sentDate` int(11) NOT NULL,
  `firstClickDate` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_3869BA7B8D9F6D38` (`order_id`),
  KEY `keyValue` (`keyValue`),
  KEY `addedDate` (`addedDate`),
  KEY `sentDate` (`sentDate`),
  CONSTRAINT `FK_93869BA7B8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_review_keys`
--

LOCK TABLES `[[dbprefix]]order_review_keys` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_review_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_review_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_shipping_status_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_shipping_status_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_shipping_status_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customerName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_953DEE45BBF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]order_shipping_statuses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_shipping_status_translations`
--

LOCK TABLES `[[dbprefix]]order_shipping_status_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_shipping_status_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]order_shipping_status_translations` VALUES (1,1,'New','New','en'),(2,2,'Processing','Processing','en'),(3,3,'Shipped','Shipped','en'),(4,4,'Delivered','Delivered','en'),(5,5,'Will Not Deliver','Will Not Deliver','en'),(6,6,'Returned','Returned','en'),(7,7,'Waiting for approve','Waiting for approve','en'),(8,8,'New/Backorder','New','en'),(9,9,'Not Finished','Not finished','en'),(10,9,'Не завершен','Не завершен','ru');
/*!40000 ALTER TABLE `[[dbprefix]]order_shipping_status_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_shipping_statuses`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_shipping_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_shipping_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_F46FC21177153098` (`code`),
  KEY `code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_shipping_statuses`
--

LOCK TABLES `[[dbprefix]]order_shipping_statuses` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_shipping_statuses` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]order_shipping_statuses` VALUES (1,'N',10),(2,'P',20),(3,'S',30),(4,'D',40),(5,'WND',50),(6,'R',60),(7,'WFA',70),(8,'NBA',80),(9,'NF',100);
/*!40000 ALTER TABLE `[[dbprefix]]order_shipping_statuses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_status_properties`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_status_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_status_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_status_id` int(10) unsigned DEFAULT NULL,
  `shipping_status_id` int(10) unsigned DEFAULT NULL,
  `incStock` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_status` (`payment_status_id`),
  KEY `shipping_status` (`shipping_status_id`),
  CONSTRAINT `FK_9A5E047EE28DE2F95` FOREIGN KEY (`payment_status_id`) REFERENCES `[[dbprefix]]order_payment_statuses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9A5E047EE2D02518A` FOREIGN KEY (`shipping_status_id`) REFERENCES `[[dbprefix]]order_shipping_statuses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_status_properties`
--

LOCK TABLES `[[dbprefix]]order_status_properties` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_status_properties` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]order_status_properties` VALUES (1,2,1,0),(2,2,2,0),(3,2,3,0),(4,2,4,0),(5,2,5,0),(6,2,6,0),(7,2,7,0),(8,2,8,0),(9,3,1,0),(10,3,2,0),(11,3,3,0),(12,3,4,0),(13,3,5,0),(14,3,6,0),(15,3,7,0),(16,3,8,0),(17,4,1,0),(18,4,2,0),(19,4,3,0),(20,4,4,0),(21,4,5,0),(22,4,6,0),(23,4,7,0),(24,4,8,0),(25,5,1,1),(26,5,2,1),(27,5,3,1),(28,5,4,1),(29,5,5,1),(30,5,6,1),(31,5,7,1),(32,5,8,1),(33,6,1,1),(34,6,2,1),(35,6,3,1),(36,6,4,1),(37,6,5,1),(38,6,6,1),(39,6,7,1),(40,6,8,1),(41,1,1,0),(42,1,2,0),(43,1,3,0),(44,1,4,0),(45,1,5,0),(46,1,6,0),(47,1,7,0),(48,1,8,0),(49,7,1,1),(50,7,2,1),(51,7,3,0),(52,7,4,0),(53,7,5,1),(54,7,6,1),(55,7,7,1),(56,7,8,1),(57,2,9,1),(58,3,9,1),(59,4,9,1),(60,5,9,1),(61,6,9,1),(62,1,9,1),(63,7,9,1);
/*!40000 ALTER TABLE `[[dbprefix]]order_status_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_surcharges`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_surcharges`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_surcharges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `type` char(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `include` tinyint(1) NOT NULL,
  `available` tinyint(1) NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weight` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_93583A1698D9F6D38` (`order_id`),
  CONSTRAINT `FK_93583A1698D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_surcharges`
--

LOCK TABLES `[[dbprefix]]order_surcharges` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_surcharges` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]order_surcharges` VALUES (1,1,'shipping','SHIPPING','\\XLite\\Logic\\Order\\Modifier\\Shipping',0,1,1.5000,'Shipping cost',0),(2,1,'discount','DISCOUNT','\\XLite\\Module\\CDev\\VolumeDiscounts\\Logic\\Order\\Modifier\\Discount',0,1,-3.0000,'Discount',0),(3,2,'shipping','SHIPPING','\\XLite\\Logic\\Order\\Modifier\\Shipping',0,1,3.7200,'Shipping cost',0),(4,3,'shipping','SHIPPING','\\XLite\\Logic\\Order\\Modifier\\Shipping',0,1,0.0000,'Shipping cost',0),(5,4,'shipping','SHIPPING','\\XLite\\Logic\\Order\\Modifier\\Shipping',0,1,3.0200,'Shipping cost',0),(6,5,'shipping','SHIPPING','\\XLite\\Logic\\Order\\Modifier\\Shipping',0,1,1.5000,'Shipping cost',0);
/*!40000 ALTER TABLE `[[dbprefix]]order_surcharges` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]order_tracking_number`
--

DROP TABLE IF EXISTS `[[dbprefix]]order_tracking_number`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]order_tracking_number` (
  `tracking_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `creationDate` int(11) NOT NULL,
  PRIMARY KEY (`tracking_id`),
  KEY `IDX_977A238F48D9F6D38` (`order_id`),
  CONSTRAINT `FK_977A238F48D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]order_tracking_number`
--

LOCK TABLES `[[dbprefix]]order_tracking_number` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]order_tracking_number` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]order_tracking_number` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]orders`
--

DROP TABLE IF EXISTS `[[dbprefix]]orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]orders` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `not_finished_order_id` int(11) DEFAULT NULL,
  `profile_id` int(11) DEFAULT NULL,
  `orig_profile_id` int(11) DEFAULT NULL,
  `payment_status_id` int(10) unsigned DEFAULT NULL,
  `shipping_status_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `mailchimpStoreId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `demo` tinyint(1) NOT NULL,
  `xpaymentsFraudStatus` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `xpaymentsFraudType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `xpaymentsFraudCheckTransactionId` int(11) NOT NULL,
  `shipping_id` int(11) NOT NULL,
  `shipping_method_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` int(11) NOT NULL,
  `lastRenewDate` int(11) NOT NULL,
  `notes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `adminNotes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `orderNumber` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recent` tinyint(1) NOT NULL,
  `stockStatus` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `xcPendingExport` tinyint(1) NOT NULL,
  `total` decimal(14,4) NOT NULL,
  `subtotal` decimal(14,4) NOT NULL,
  `is_order` int(11) NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `IDX_99A9BE335791AE370` (`not_finished_order_id`),
  KEY `IDX_99A9BE335CCFA12B8` (`profile_id`),
  KEY `IDX_99A9BE335DBFEF46C` (`orig_profile_id`),
  KEY `IDX_99A9BE33538248176` (`currency_id`),
  KEY `date` (`date`),
  KEY `total` (`total`),
  KEY `subtotal` (`subtotal`),
  KEY `tracking` (`tracking`),
  KEY `payment_status` (`payment_status_id`),
  KEY `shipping_status` (`shipping_status_id`),
  KEY `shipping_id` (`shipping_id`),
  KEY `lastRenewDate` (`lastRenewDate`),
  KEY `orderNumber` (`orderNumber`),
  KEY `is_order` (`is_order`),
  KEY `xcPendingExport` (`xcPendingExport`),
  CONSTRAINT `FK_99A9BE33528DE2F95` FOREIGN KEY (`payment_status_id`) REFERENCES `[[dbprefix]]order_payment_statuses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_99A9BE3352D02518A` FOREIGN KEY (`shipping_status_id`) REFERENCES `[[dbprefix]]order_shipping_statuses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_99A9BE33538248176` FOREIGN KEY (`currency_id`) REFERENCES `[[dbprefix]]currencies` (`currency_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_99A9BE335791AE370` FOREIGN KEY (`not_finished_order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_99A9BE335CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `[[dbprefix]]profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_99A9BE335DBFEF46C` FOREIGN KEY (`orig_profile_id`) REFERENCES `[[dbprefix]]profiles` (`profile_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]orders`
--

LOCK TABLES `[[dbprefix]]orders` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]orders` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]orders` VALUES (1,NULL,2,1,4,4,840,'',1,'','',0,91,'Courier','','',1551771900,1603972208,'','','1',0,'',0,18.4900,19.9900,1),(2,NULL,3,1,4,4,840,'',1,'','',0,91,'Courier','','',1553772240,1603972208,'','','2',1,'',0,88.6700,84.9500,1),(3,NULL,4,1,4,4,840,'',1,'','',0,91,'Courier','','',1564729080,1603972208,'','','3',1,'',0,158.9400,158.9400,1),(4,NULL,5,1,5,5,840,'',1,'','',0,91,'Courier','Simplify Commerce Hosted Payments','',1575162780,1603972208,'','','4',1,'',0,38.0100,34.9900,1),(5,NULL,6,1,4,4,840,'',1,'','',0,91,'Courier','','',1575163080,1603972208,'','','5',0,'',0,352.8100,351.3100,1);
/*!40000 ALTER TABLE `[[dbprefix]]orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]page_images`
--

DROP TABLE IF EXISTS `[[dbprefix]]page_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]page_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(10) unsigned DEFAULT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ABDA1565C4663E4` (`page_id`),
  CONSTRAINT `FK_9ABDA1565C4663E4` FOREIGN KEY (`page_id`) REFERENCES `[[dbprefix]]pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]page_images`
--

LOCK TABLES `[[dbprefix]]page_images` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]page_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]page_images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]page_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]page_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]page_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `ogMeta` longtext COLLATE utf8mb4_unicode_ci,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `teaser` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metaKeywords` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metaTitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9D4ABAC0BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]page_translations`
--

LOCK TABLES `[[dbprefix]]page_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]page_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]page_translations` VALUES (1,1,'','Terms and conditions','Terms and conditions','<p>Terms and conditions text</p><p>To replace this text with the actual Terms and conditions, go to the \"Content -> Pages\" section, open the \"Terms &amp; Conditions\" page and edit the \"Content\" field.</p>','','','en'),(2,1,'','Условия использования','Условия использования','<p>Чтобы разместить на этой странице Ваш собственный текст \"Условия использования\", перейдите в раздел \"Содержание -> Страницы\", откройте для редактирования страницу \"Условия использования\" и добавьте требуемый текст в поле \"Содержание\".</p>','','','ru'),(3,1,'','条款约定','条款约定','<p>内容描述</p><p>要替代该条款内的内容，请到&ldquo;内容-网页&ldquo;中进行设置，打开页面编辑并在这里编辑内容栏目。</p>','','','zh'),(4,2,'','Shipping','Shipping teaser','<p>This page is intended for your store\'s shipping policy.</p><p>Here you can provide general information about the available shipping options and rates, shipping turn-around times, size and weight limits for shipping, shipping restrictions, order tracking, and so on.</p><p></p><p>To replace this text with the actual delivery information, go to the \"Content -> Pages\" section, open the \"Shipping\" page and edit the \"Content\" field.</p>','','','en'),(5,2,'','Доставка','Доставка','<p>Чтобы разместить на этой странице Ваш собственный текст \"Доставка\", перейдите в раздел \"Содержание -> Страницы\", откройте для редактирования страницу \"Доставка\" и добавьте требуемый текст в поле \"Содержание\".</p>','','','ru'),(6,2,'','关于运输','关于运输','<p>关于运输的内容</p><p>要设置该页面的运输项目内容，请到&rdquo;内容-页面&rdquo;中打开关于运输页面进行修改。</p>','','','zh');
/*!40000 ALTER TABLE `[[dbprefix]]page_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]pages`
--

DROP TABLE IF EXISTS `[[dbprefix]]pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `useCustomOG` tinyint(1) NOT NULL,
  `ogMeta` longtext COLLATE utf8mb4_unicode_ci,
  `showSocialButtons` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `metaDescType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]pages`
--

LOCK TABLES `[[dbprefix]]pages` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]pages` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]pages` VALUES (1,0,'',0,1,'A',0),(2,0,'',0,1,'A',0);
/*!40000 ALTER TABLE `[[dbprefix]]pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]payment_backend_transaction_data`
--

DROP TABLE IF EXISTS `[[dbprefix]]payment_backend_transaction_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]payment_backend_transaction_data` (
  `data_id` int(11) NOT NULL AUTO_INCREMENT,
  `backend_transaction_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_level` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`data_id`),
  KEY `IDX_9BE43AC028167CC5C` (`backend_transaction_id`),
  KEY `tn` (`backend_transaction_id`,`name`),
  CONSTRAINT `FK_9BE43AC028167CC5C` FOREIGN KEY (`backend_transaction_id`) REFERENCES `[[dbprefix]]payment_backend_transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]payment_backend_transaction_data`
--

LOCK TABLES `[[dbprefix]]payment_backend_transaction_data` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]payment_backend_transaction_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]payment_backend_transaction_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]payment_backend_transactions`
--

DROP TABLE IF EXISTS `[[dbprefix]]payment_backend_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]payment_backend_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) DEFAULT NULL,
  `date` int(11) NOT NULL,
  `status` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9808A7FC32FC0CB0F` (`transaction_id`),
  KEY `td` (`transaction_id`,`date`),
  CONSTRAINT `FK_9808A7FC32FC0CB0F` FOREIGN KEY (`transaction_id`) REFERENCES `[[dbprefix]]payment_transactions` (`transaction_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]payment_backend_transactions`
--

LOCK TABLES `[[dbprefix]]payment_backend_transactions` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]payment_backend_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]payment_backend_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]payment_method_country_position`
--

DROP TABLE IF EXISTS `[[dbprefix]]payment_method_country_position`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]payment_method_country_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `method_id` int(11) DEFAULT NULL,
  `countryCode` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `adminPosition` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `method_country` (`method_id`,`countryCode`),
  KEY `IDX_96B5D20E519883967` (`method_id`),
  KEY `adminPosition` (`adminPosition`),
  CONSTRAINT `FK_96B5D20E519883967` FOREIGN KEY (`method_id`) REFERENCES `[[dbprefix]]payment_methods` (`method_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]payment_method_country_position`
--

LOCK TABLES `[[dbprefix]]payment_method_country_position` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]payment_method_country_position` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]payment_method_country_position` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]payment_method_settings`
--

DROP TABLE IF EXISTS `[[dbprefix]]payment_method_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]payment_method_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `method_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`setting_id`),
  UNIQUE KEY `mn` (`method_id`,`name`),
  KEY `IDX_933B9DA0019883967` (`method_id`),
  CONSTRAINT `FK_933B9DA0019883967` FOREIGN KEY (`method_id`) REFERENCES `[[dbprefix]]payment_methods` (`method_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=197 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]payment_method_settings`
--

LOCK TABLES `[[dbprefix]]payment_method_settings` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]payment_method_settings` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]payment_method_settings` VALUES (1,7,'merchant_id',''),(2,7,'mode',''),(3,7,'access_key',''),(4,7,'secret_key',''),(5,7,'client_id',''),(6,7,'region','USD'),(7,7,'capture_mode','C'),(8,7,'sync_mode','S'),(9,7,'order_id_prefix',''),(10,8,'login',''),(11,8,'key',''),(12,8,'signature',''),(13,8,'type','sale'),(14,8,'test','1'),(15,8,'prefix','xcart'),(16,10,'vendor',''),(17,10,'user',''),(18,10,'pwd',''),(19,10,'partner','PayPal'),(20,10,'prefix','mystore_'),(21,10,'transaction_type','S'),(22,10,'mode','test'),(23,10,'buyNowEnabled','1'),(24,10,'headIconEnabled','1'),(25,11,'vendor',''),(26,11,'user',''),(27,11,'pwd',''),(28,11,'partner','PayPal'),(29,11,'prefix','mystore_'),(30,11,'transaction_type','S'),(31,11,'mode','test'),(32,12,'vendor',''),(33,12,'user',''),(34,12,'pwd',''),(35,12,'partner','PayPal'),(36,12,'prefix','mystore_'),(37,12,'transaction_type','S'),(38,12,'mode','test'),(39,12,'buyNowEnabled','1'),(40,12,'headIconEnabled','1'),(41,13,'account',''),(42,13,'description',''),(43,13,'prefix','mystore_'),(44,13,'mode','test'),(45,14,'api_type','email'),(46,14,'email',''),(47,14,'api_solution','paypal'),(48,14,'vendor',''),(49,14,'user',''),(50,14,'pwd',''),(51,14,'partner','PayPal'),(52,14,'api_username',''),(53,14,'api_password',''),(54,14,'auth_method','signature'),(55,14,'signature',''),(56,14,'certificate',''),(57,14,'prefix','mystore_'),(58,14,'transaction_type','S'),(59,14,'mode','test'),(60,14,'merchantId',''),(61,14,'buyNowEnabled','1'),(62,14,'headIconEnabled','1'),(63,15,'enabled','1'),(64,15,'agreement','N'),(65,15,'publisherId',''),(66,15,'bannerOnHomePage','D'),(67,15,'bannerOnCategoryPages','D'),(68,15,'bannerOnProductDetailsPages','A'),(69,15,'bannerOnCartPage','C'),(70,15,'ppcm_enabled','1'),(71,15,'ppcm_product_page','1'),(72,15,'ppcm_cart_page','1'),(73,15,'ppcm_checkout_page','1'),(74,15,'ppcm_banner_type','flex'),(75,15,'ppcm_text_logo_type','primary'),(76,15,'ppcm_text_logo_position','left'),(77,15,'ppcm_text_size','12'),(78,15,'ppcm_text_color','black'),(79,15,'ppcm_flex_color_scheme','blue'),(80,15,'ppcm_flex_layout','8x1'),(81,16,'app_id',''),(82,16,'api_username',''),(83,16,'api_password',''),(84,16,'signature',''),(85,16,'paypal_login',''),(86,16,'partner','PayPal'),(87,16,'feesPayer','PRIMARYRECEIVER'),(88,16,'matchCriteria','name'),(89,16,'prefix','mystore_'),(90,16,'transaction_type','S'),(91,16,'mode','test'),(92,16,'buyNowEnabled','1'),(93,16,'headIconEnabled','1'),(94,17,'email',''),(95,17,'client_id',''),(96,17,'secret',''),(97,17,'partner_id',''),(98,17,'bn_code',''),(99,17,'additional_partner_referral_id',''),(100,17,'additional_merchant_id',''),(101,17,'payment_descriptor',''),(102,17,'prefix','mystore_'),(103,17,'transaction_type','S'),(104,17,'mode','test'),(105,17,'disburse_funds','INSTANT'),(106,18,'authCode',''),(107,18,'merchant_id',''),(108,18,'sellerNonce',''),(109,18,'client_id',''),(110,18,'client_secret',''),(111,18,'transaction_type','S'),(112,18,'3d_secure',''),(113,18,'3d_secure_soft_exception',''),(114,18,'mode','test'),(115,18,'buyNowEnabled','1'),(116,18,'headIconEnabled','1'),(117,19,'login',''),(118,19,'prefix','xcart'),(119,19,'hash',''),(120,19,'include_response','N'),(121,20,'account',''),(122,20,'secret',''),(123,20,'language','en'),(124,20,'mode','test'),(125,20,'prefix','xcart'),(126,20,'currency','USD'),(127,22,'api_login_id',''),(128,22,'transaction_key',''),(129,22,'public_key',''),(130,22,'type','sale'),(131,22,'mode','test'),(132,22,'prefix','xcart'),(133,23,'prefix',''),(134,23,'merchantId',''),(135,23,'accessToken',''),(136,23,'refreshToken',''),(137,23,'merchantAccountId',''),(138,23,'kountMerchantId',''),(139,23,'isAutoSettle','0'),(140,23,'testMode','1'),(141,23,'isPayPal','0'),(142,23,'paypalButtonColor','gold'),(143,23,'paypalButtonShape','pill'),(144,23,'paypalShippingAddressOverride','1'),(145,23,'is3dSecure','0'),(146,23,'isAcceptNo3dSecure','0'),(147,23,'is3dSecureForVault','0'),(148,23,'isUseVault','1'),(149,23,'isShowSaveCardBox','1'),(150,23,'isApplePay','0'),(151,23,'isGooglePay','0'),(152,23,'googleMerchantId',''),(153,23,'googlePaymentButtonColor','default'),(154,23,'googlePaymentButtonType','long'),(155,24,'pspid',''),(156,24,'sha_in',''),(157,24,'sha_out',''),(158,24,'currency','GBP'),(159,24,'test','1'),(160,24,'prefix','xcart_'),(161,24,'debug_enabled','0'),(162,25,'store_id',''),(163,25,'hpp_key',''),(164,25,'mode','test'),(165,25,'prefix','xcart'),(166,25,'currency','USD'),(167,26,'merchant_id',''),(168,26,'subid','0'),(169,26,'pub_cert','rabobank.cer'),(170,26,'pub_key',''),(171,26,'private_key',''),(172,26,'private_key_pass',''),(173,26,'currency','EUR'),(174,26,'test','Y'),(175,26,'prefix','xcart_'),(176,26,'debug_enabled','0'),(177,27,'vendorName',''),(178,27,'password',''),(179,27,'type','sale'),(180,27,'test','1'),(181,27,'prefix','xcart'),(182,28,'publishKey',''),(183,28,'accessToken',''),(184,28,'publishKeyTest',''),(185,28,'accessTokenTest',''),(186,28,'mode','live'),(187,28,'type','sale'),(188,28,'prefix','xcart'),(189,28,'userId',''),(190,28,'refreshToken',''),(191,29,'prefix','xc_apple'),(192,32,'account',''),(193,32,'api_key',''),(194,32,'secret_key',''),(195,32,'widget_key',''),(196,32,'quickaccess_key','');
/*!40000 ALTER TABLE `[[dbprefix]]payment_method_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]payment_method_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]payment_method_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]payment_method_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `adminDescription` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `altAdminDescription` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `instruction` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_99FBF065BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]payment_methods` (`method_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]payment_method_translations`
--

LOCK TABLES `[[dbprefix]]payment_method_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]payment_method_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]payment_method_translations` VALUES (1,1,'Purchase Order','','','','','','en'),(2,1,'Заказ-наряд','','Оформить заказ на поставку товара','','','','ru'),(3,2,'Phone Ordering','','Phone: (555) 555-5555','','','','en'),(4,2,'Заказ по телефону','','Тел. (555) 555-5555','','','','ru'),(5,3,'Fax Ordering','','Fax: (555) 555-5555','','','','en'),(6,3,'Заказ по факсу','','','','','','ru'),(7,4,'Money Order','','US Banks Only','','','','en'),(8,4,'Денежный перевод','','Оплата через отделение банка','','','','ru'),(9,5,'Check','','Check payment','','','','en'),(10,5,'Чек','','Оплата банковским чеком','','','','ru'),(11,6,'COD','','Cash On Delivery','','','','en'),(12,6,'Наложенный платеж','','Оплата товара при получении','','','','ru'),(13,7,'Amazon Pay','','','','','','en'),(14,8,'Authorize.Net SIM','','','','','','en'),(15,9,'Cash on Delivery (FedEx)','','','','','','en'),(16,10,'PayPal Payflow Link','Credit/Debit card or PayPal','','','Accept Visa, MasterCard®, American Express, Discover and PayPal payments on your site by connecting a PayPal-hosted checkout page with your own internet merchant account. Customize the page to look like the rest of your site and make sure customer transactions are secure.','','en'),(17,11,'PayPal Partner Hosted with PCI Compliance','Credit/Debit card','','','PCI compliant payments on your site with Visa, MasterCard, American Express and Discover - without PayPal-hosted pages. Maintain full control over your customers\' checkout experience by providing a credit card form that will post your customers\' payment details from your site\'s native checkout page directly to the Gateway server.','','en'),(18,12,'PayPal Payments Advanced','Credit/Debit card or PayPal','','','Accept Visa, MasterCard®, American Express, Discover and PayPal payments securely. With this all-in-one option, customers stay on your site for the entire checkout process. It simplifies PCI compliance and opens the door to more than 100 million active PayPal customers. Requires credit approval (2-3 business days).','','en'),(19,13,'PayPal Payments Standard','PayPal','','','Add a PayPal payment button to your site to accept Visa, MasterCard®, American Express, Discover and PayPal payments securely. When your customers check out, they are redirected to PayPal to pay, then return to your site after they are finished.','','en'),(20,14,'PayPal Express Checkout (legacy)','PayPal','','','Create a seamless checkout experience and increase your conversion rate by opening the door to over 100 million active PayPal customers who look for and use this fast, easy, and secure way to pay.','','en'),(21,15,'PayPal Credit','PayPal Credit','','','','','en'),(22,16,'PayPal Adaptive payments (legacy)','PayPal','','','This method provides automatic transfer of payments to vendor users (the type of users enabled by the Multi-vendor module). The method may not be activated unless the module <a href=\'admin.php?target=addons_list_marketplace&moduleName=XC\\MultiVendor\' target=\'_blank\'>Multi-vendor</a> is installed and enabled. To use this method, store administrator is required to have an Application ID for PayPal Adaptive Payments API.','','en'),(23,17,'PayPal for Marketplaces','PayPal','','','PayPal for Marketplaces is a comprehensive payments solution for marketplaces, crowdfunding platforms, and other environments where people buy and sell goods and services or raise money. The solution is ideal if you run a multi-party commerce platform and want a flexible, end-to-end solution for processing payments.','','en'),(24,17,'PayPal for Marketplaces','PayPal','','','PayPal for Marketplaces - это комплексное решение по приёму платежей для торговых площадок, платформ для сбора средств под проект (\"краудфандинг\") и других сфер, где осуществляется продажа и покупка товаров и услуг, либо сбор средств. Данное решение идеально подойдет для платформ, осуществляющих коммерческую деятельность от лица нескольких участников, и представляет собой комплексное и гибкое решение для обработки платежей на всех этапах этой деятельности.','','ru'),(25,18,'PayPal Checkout','PayPal','','','PayPal Checkout can be set up quickly and offers a convenient way for customers to complete online purchases. Configure PayPal on your product pages and cart to increase conversion.','','en'),(26,19,'QuantumGateway','','','','','','en'),(27,20,'2Checkout.com','','','','','','en'),(28,21,'Cash on Delivery (USPS)','','','','','','en'),(29,22,'Authorize.Net Accept.js','','','','','','en'),(30,23,'PayPal powered by Braintree','','','Supported countries: US, UK, France, Italy & Spain.','','','en'),(31,24,'Barclaycard ePDQ e-Commerce','','','','','','en'),(32,25,'Moneris (eSELECTplus- Hosted Pay Page)','','','','','','en'),(33,26,'iDEAL Professional (Rabobank)','','','','','','en'),(34,27,'Opayo form protocol','','','','','','en'),(35,28,'Stripe','','','','','','en'),(36,29,'Stripe (Apple / Google / Microsoft Pay)','','','','','','en'),(37,30,'Cash on Delivery (UPS)','','','','','','en'),(38,31,'Apple Pay','Apple Pay','','','Enable Apple Pay in your checkout via X-Payments Cloud','','en'),(39,32,'X-Payments Cloud','Credit or Debit card by X-Payments','','','','','en');
/*!40000 ALTER TABLE `[[dbprefix]]payment_method_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]payment_methods`
--

DROP TABLE IF EXISTS `[[dbprefix]]payment_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]payment_methods` (
  `method_id` int(11) NOT NULL AUTO_INCREMENT,
  `service_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `moduleName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `orderby` int(11) NOT NULL,
  `adminOrderby` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `added` tinyint(1) NOT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fromMarketplace` tinyint(1) NOT NULL,
  `iconURL` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `countries` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  `exCountries` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:array)',
  PRIMARY KEY (`method_id`),
  KEY `orderby` (`orderby`),
  KEY `class` (`class`,`enabled`),
  KEY `enabled` (`enabled`),
  KEY `serviceName` (`service_name`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]payment_methods`
--

LOCK TABLES `[[dbprefix]]payment_methods` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]payment_methods` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]payment_methods` VALUES (1,'PurchaseOrder','Model\\Payment\\Processor\\PurchaseOrder','',20,0,0,1,'O',0,NULL,'N;','N;'),(2,'PhoneOrdering','Model\\Payment\\Processor\\PhoneOrdering','',30,0,1,1,'O',0,NULL,'N;','N;'),(3,'FaxOrdering','Model\\Payment\\Processor\\Offline','',40,0,1,1,'O',0,NULL,'N;','N;'),(4,'MoneyOrdering','Model\\Payment\\Processor\\Offline','',50,0,1,1,'O',0,NULL,'N;','N;'),(5,'Echeck','Model\\Payment\\Processor\\Check','',60,0,0,1,'O',0,NULL,'N;','N;'),(6,'COD','Model\\Payment\\Processor\\Offline','',70,0,1,1,'O',0,NULL,'N;','N;'),(7,'PayWithAmazon','Module\\Amazon\\PayWithAmazon\\Model\\Payment\\Processor\\PayWithAmazon','Amazon_PayWithAmazon',-101600,-101600,0,0,'C',0,NULL,'a:35:{i:0;s:2:\"US\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"BG\";i:4;s:2:\"CH\";i:5;s:2:\"CY\";i:6;s:2:\"CZ\";i:7;s:2:\"DE\";i:8;s:2:\"DK\";i:9;s:2:\"EE\";i:10;s:2:\"ES\";i:11;s:2:\"FI\";i:12;s:2:\"FR\";i:13;s:2:\"GB\";i:14;s:2:\"GR\";i:15;s:2:\"HR\";i:16;s:2:\"HU\";i:17;s:2:\"IE\";i:18;s:2:\"IS\";i:19;s:2:\"IT\";i:20;s:2:\"LI\";i:21;s:2:\"LT\";i:22;s:2:\"LU\";i:23;s:2:\"LV\";i:24;s:2:\"MC\";i:25;s:2:\"MT\";i:26;s:2:\"NL\";i:27;s:2:\"NO\";i:28;s:2:\"PL\";i:29;s:2:\"PT\";i:30;s:2:\"RO\";i:31;s:2:\"SE\";i:32;s:2:\"SI\";i:33;s:2:\"SK\";i:34;s:2:\"SM\";}','N;'),(8,'AuthorizeNet SIM','Module\\CDev\\AuthorizeNet\\Model\\Payment\\Processor\\AuthorizeNetSIM','CDev_AuthorizeNet',-101000,0,0,0,'C',0,NULL,'a:36:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";i:3;s:2:\"GB\";i:4;s:2:\"AD\";i:5;s:2:\"AT\";i:6;s:2:\"BE\";i:7;s:2:\"BG\";i:8;s:2:\"CY\";i:9;s:2:\"CZ\";i:10;s:2:\"DK\";i:11;s:2:\"FI\";i:12;s:2:\"FR\";i:13;s:2:\"DE\";i:14;s:2:\"GI\";i:15;s:2:\"GR\";i:16;s:2:\"HU\";i:17;s:2:\"IE\";i:18;s:2:\"IT\";i:19;s:2:\"LI\";i:20;s:2:\"LU\";i:21;s:2:\"MT\";i:22;s:2:\"MC\";i:23;s:2:\"NL\";i:24;s:2:\"NO\";i:25;s:2:\"PL\";i:26;s:2:\"PT\";i:27;s:2:\"RO\";i:28;s:2:\"SE\";i:29;s:2:\"SI\";i:30;s:2:\"SK\";i:31;s:2:\"SM\";i:32;s:2:\"CH\";i:33;s:2:\"ES\";i:34;s:2:\"VA\";i:35;s:2:\"TR\";}','N;'),(9,'COD_FEDEX','Module\\CDev\\FedEx\\Model\\Payment\\Processor\\COD','CDev_FedEx',0,0,0,1,'O',0,NULL,'a:2:{i:0;s:2:\"CA\";i:1;s:2:\"US\";}','N;'),(10,'PayflowLink','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PayflowLink','CDev_Paypal',-10600,0,0,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";i:3;s:2:\"NZ\";}','N;'),(11,'PayflowTransparentRedirect','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PayflowTransparentRedirect','CDev_Paypal',-10650,0,0,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";i:3;s:2:\"NZ\";}','N;'),(12,'PaypalAdvanced','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalAdvanced','CDev_Paypal',-10700,0,0,0,'C',0,NULL,'a:2:{i:0;s:2:\"US\";i:1;s:2:\"CA\";}','N;'),(13,'PaypalWPS','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalWPS','CDev_Paypal',-10800,0,0,0,'A',0,NULL,'a:200:{i:0;s:2:\"AD\";i:1;s:2:\"AE\";i:2;s:2:\"AG\";i:3;s:2:\"AI\";i:4;s:2:\"AL\";i:5;s:2:\"AM\";i:6;s:2:\"AO\";i:7;s:2:\"AR\";i:8;s:2:\"AT\";i:9;s:2:\"AU\";i:10;s:2:\"AW\";i:11;s:2:\"AZ\";i:12;s:2:\"BA\";i:13;s:2:\"BB\";i:14;s:2:\"BE\";i:15;s:2:\"BF\";i:16;s:2:\"BG\";i:17;s:2:\"BH\";i:18;s:2:\"BI\";i:19;s:2:\"BJ\";i:20;s:2:\"BM\";i:21;s:2:\"BN\";i:22;s:2:\"BO\";i:23;s:2:\"BR\";i:24;s:2:\"BS\";i:25;s:2:\"BT\";i:26;s:2:\"BW\";i:27;s:2:\"BY\";i:28;s:2:\"BZ\";i:29;s:2:\"CA\";i:30;s:2:\"CD\";i:31;s:2:\"CH\";i:32;s:2:\"CI\";i:33;s:2:\"CK\";i:34;s:2:\"CL\";i:35;s:2:\"CM\";i:36;s:2:\"CN\";i:37;s:2:\"CO\";i:38;s:2:\"CR\";i:39;s:2:\"CV\";i:40;s:2:\"CY\";i:41;s:2:\"CZ\";i:42;s:2:\"DE\";i:43;s:2:\"DJ\";i:44;s:2:\"DK\";i:45;s:2:\"DM\";i:46;s:2:\"DO\";i:47;s:2:\"DZ\";i:48;s:2:\"EC\";i:49;s:2:\"EE\";i:50;s:2:\"EG\";i:51;s:2:\"ER\";i:52;s:2:\"ES\";i:53;s:2:\"ET\";i:54;s:2:\"FI\";i:55;s:2:\"FJ\";i:56;s:2:\"FK\";i:57;s:2:\"FM\";i:58;s:2:\"FO\";i:59;s:2:\"FR\";i:60;s:2:\"GA\";i:61;s:2:\"GB\";i:62;s:2:\"GD\";i:63;s:2:\"GE\";i:64;s:2:\"GF\";i:65;s:2:\"GI\";i:66;s:2:\"GL\";i:67;s:2:\"GM\";i:68;s:2:\"GN\";i:69;s:2:\"GP\";i:70;s:2:\"GR\";i:71;s:2:\"GT\";i:72;s:2:\"GW\";i:73;s:2:\"GY\";i:74;s:2:\"HK\";i:75;s:2:\"HN\";i:76;s:2:\"HR\";i:77;s:2:\"HU\";i:78;s:2:\"ID\";i:79;s:2:\"IE\";i:80;s:2:\"IL\";i:81;s:2:\"IN\";i:82;s:2:\"IS\";i:83;s:2:\"IT\";i:84;s:2:\"JM\";i:85;s:2:\"JO\";i:86;s:2:\"JP\";i:87;s:2:\"KE\";i:88;s:2:\"KG\";i:89;s:2:\"KH\";i:90;s:2:\"KI\";i:91;s:2:\"KM\";i:92;s:2:\"KN\";i:93;s:2:\"KR\";i:94;s:2:\"KW\";i:95;s:2:\"KY\";i:96;s:2:\"KZ\";i:97;s:2:\"LA\";i:98;s:2:\"LC\";i:99;s:2:\"LI\";i:100;s:2:\"LK\";i:101;s:2:\"LS\";i:102;s:2:\"LT\";i:103;s:2:\"LU\";i:104;s:2:\"LV\";i:105;s:2:\"MA\";i:106;s:2:\"MC\";i:107;s:2:\"MD\";i:108;s:2:\"ME\";i:109;s:2:\"MG\";i:110;s:2:\"MH\";i:111;s:2:\"MK\";i:112;s:2:\"ML\";i:113;s:2:\"MN\";i:114;s:2:\"MQ\";i:115;s:2:\"MR\";i:116;s:2:\"MS\";i:117;s:2:\"MT\";i:118;s:2:\"MU\";i:119;s:2:\"MV\";i:120;s:2:\"MW\";i:121;s:2:\"MX\";i:122;s:2:\"MY\";i:123;s:2:\"MZ\";i:124;s:2:\"NA\";i:125;s:2:\"NC\";i:126;s:2:\"NE\";i:127;s:2:\"NF\";i:128;s:2:\"NG\";i:129;s:2:\"NI\";i:130;s:2:\"NL\";i:131;s:2:\"NO\";i:132;s:2:\"NP\";i:133;s:2:\"NR\";i:134;s:2:\"NU\";i:135;s:2:\"NZ\";i:136;s:2:\"OM\";i:137;s:2:\"PA\";i:138;s:2:\"PE\";i:139;s:2:\"PF\";i:140;s:2:\"PG\";i:141;s:2:\"PH\";i:142;s:2:\"PL\";i:143;s:2:\"PM\";i:144;s:2:\"PN\";i:145;s:2:\"PT\";i:146;s:2:\"PW\";i:147;s:2:\"PY\";i:148;s:2:\"QA\";i:149;s:2:\"RE\";i:150;s:2:\"RO\";i:151;s:2:\"RS\";i:152;s:2:\"RU\";i:153;s:2:\"RW\";i:154;s:2:\"SA\";i:155;s:2:\"SB\";i:156;s:2:\"SC\";i:157;s:2:\"SE\";i:158;s:2:\"SG\";i:159;s:2:\"SH\";i:160;s:2:\"SI\";i:161;s:2:\"SJ\";i:162;s:2:\"SK\";i:163;s:2:\"SL\";i:164;s:2:\"SM\";i:165;s:2:\"SN\";i:166;s:2:\"SO\";i:167;s:2:\"SR\";i:168;s:2:\"ST\";i:169;s:2:\"SV\";i:170;s:2:\"SZ\";i:171;s:2:\"TC\";i:172;s:2:\"TD\";i:173;s:2:\"TG\";i:174;s:2:\"TH\";i:175;s:2:\"TJ\";i:176;s:2:\"TM\";i:177;s:2:\"TN\";i:178;s:2:\"TO\";i:179;s:2:\"TT\";i:180;s:2:\"TV\";i:181;s:2:\"TW\";i:182;s:2:\"TZ\";i:183;s:2:\"UA\";i:184;s:2:\"UG\";i:185;s:2:\"US\";i:186;s:2:\"UY\";i:187;s:2:\"VA\";i:188;s:2:\"VC\";i:189;s:2:\"VE\";i:190;s:2:\"VG\";i:191;s:2:\"VN\";i:192;s:2:\"VU\";i:193;s:2:\"WF\";i:194;s:2:\"WS\";i:195;s:2:\"YE\";i:196;s:2:\"YT\";i:197;s:2:\"ZA\";i:198;s:2:\"ZM\";i:199;s:2:\"ZW\";}','N;'),(14,'ExpressCheckout','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\ExpressCheckout','CDev_Paypal',-102000,0,0,0,'C',0,NULL,'a:23:{i:0;s:2:\"US\";i:1;s:2:\"MX\";i:2;s:2:\"BE\";i:3;s:2:\"DK\";i:4;s:2:\"FR\";i:5;s:2:\"DE\";i:6;s:2:\"IE\";i:7;s:2:\"IT\";i:8;s:2:\"LU\";i:9;s:2:\"NL\";i:10;s:2:\"NO\";i:11;s:2:\"PL\";i:12;s:2:\"RU\";i:13;s:2:\"ES\";i:14;s:2:\"NZ\";i:15;s:2:\"SE\";i:16;s:2:\"GB\";i:17;s:2:\"AU\";i:18;s:2:\"CN\";i:19;s:2:\"IL\";i:20;s:2:\"SG\";i:21;s:2:\"BR\";i:22;s:2:\"JP\";}','N;'),(15,'PaypalCredit','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalCredit','CDev_Paypal',-11000,0,0,1,'C',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(16,'PaypalAdaptive','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalAdaptive','CDev_Paypal',-11100,0,0,0,'C',0,NULL,'N;','N;'),(17,'PaypalForMarketplaces','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalForMarketplaces','CDev_Paypal',-11100,0,0,0,'C',0,NULL,'a:27:{i:0;s:2:\"AT\";i:1;s:2:\"AU\";i:2;s:2:\"BE\";i:3;s:2:\"CA\";i:4;s:2:\"CH\";i:5;s:2:\"CZ\";i:6;s:2:\"DE\";i:7;s:2:\"DK\";i:8;s:2:\"ES\";i:9;s:2:\"FI\";i:10;s:2:\"FR\";i:11;s:2:\"GB\";i:12;s:2:\"GB\";i:13;s:2:\"GR\";i:14;s:2:\"HU\";i:15;s:2:\"IE\";i:16;s:2:\"IL\";i:17;s:2:\"IN\";i:18;s:2:\"IT\";i:19;s:2:\"NL\";i:20;s:2:\"NO\";i:21;s:2:\"PL\";i:22;s:2:\"PT\";i:23;s:2:\"RU\";i:24;s:2:\"SE\";i:25;s:2:\"SK\";i:26;s:2:\"US\";}','N;'),(18,'PaypalCommercePlatform','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalCommercePlatform','CDev_Paypal',-103000,-106000,0,1,'C',0,NULL,'a:27:{i:0;s:2:\"AT\";i:1;s:2:\"AU\";i:2;s:2:\"BE\";i:3;s:2:\"CA\";i:4;s:2:\"CH\";i:5;s:2:\"CZ\";i:6;s:2:\"DE\";i:7;s:2:\"DK\";i:8;s:2:\"ES\";i:9;s:2:\"FI\";i:10;s:2:\"FR\";i:11;s:2:\"GB\";i:12;s:2:\"GB\";i:13;s:2:\"GR\";i:14;s:2:\"HU\";i:15;s:2:\"IE\";i:16;s:2:\"IL\";i:17;s:2:\"IN\";i:18;s:2:\"IT\";i:19;s:2:\"NL\";i:20;s:2:\"NO\";i:21;s:2:\"PL\";i:22;s:2:\"PT\";i:23;s:2:\"RU\";i:24;s:2:\"SE\";i:25;s:2:\"SK\";i:26;s:2:\"US\";}','N;'),(19,'QuantumGateway','Module\\CDev\\Quantum\\Model\\Payment\\Processor\\Quantum','CDev_Quantum',-10000,0,0,0,'C',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(20,'2Checkout.com','Module\\CDev\\TwoCheckout\\Model\\Payment\\Processor\\TwoCheckout','CDev_TwoCheckout',-10500,0,0,0,'C',0,NULL,'a:237:{i:0;s:2:\"AD\";i:1;s:2:\"AE\";i:2;s:2:\"AF\";i:3;s:2:\"AG\";i:4;s:2:\"AI\";i:5;s:2:\"AL\";i:6;s:2:\"AM\";i:7;s:2:\"AO\";i:8;s:2:\"AR\";i:9;s:2:\"AS\";i:10;s:2:\"AT\";i:11;s:2:\"AU\";i:12;s:2:\"AW\";i:13;s:2:\"AZ\";i:14;s:2:\"BA\";i:15;s:2:\"BB\";i:16;s:2:\"BD\";i:17;s:2:\"BE\";i:18;s:2:\"BF\";i:19;s:2:\"BG\";i:20;s:2:\"BH\";i:21;s:2:\"BI\";i:22;s:2:\"BJ\";i:23;s:2:\"BM\";i:24;s:2:\"BN\";i:25;s:2:\"BO\";i:26;s:2:\"BQ\";i:27;s:2:\"BR\";i:28;s:2:\"BS\";i:29;s:2:\"BT\";i:30;s:2:\"BV\";i:31;s:2:\"BW\";i:32;s:2:\"BY\";i:33;s:2:\"BZ\";i:34;s:2:\"CA\";i:35;s:2:\"CC\";i:36;s:2:\"CD\";i:37;s:2:\"CF\";i:38;s:2:\"CH\";i:39;s:2:\"CK\";i:40;s:2:\"CL\";i:41;s:2:\"CM\";i:42;s:2:\"CN\";i:43;s:2:\"CO\";i:44;s:2:\"CR\";i:45;s:2:\"CV\";i:46;s:2:\"CW\";i:47;s:2:\"CX\";i:48;s:2:\"CY\";i:49;s:2:\"CZ\";i:50;s:2:\"DE\";i:51;s:2:\"DJ\";i:52;s:2:\"DK\";i:53;s:2:\"DM\";i:54;s:2:\"DO\";i:55;s:2:\"DZ\";i:56;s:2:\"EC\";i:57;s:2:\"EE\";i:58;s:2:\"EG\";i:59;s:2:\"EH\";i:60;s:2:\"ER\";i:61;s:2:\"ES\";i:62;s:2:\"ET\";i:63;s:2:\"FI\";i:64;s:2:\"FJ\";i:65;s:2:\"FK\";i:66;s:2:\"FM\";i:67;s:2:\"FO\";i:68;s:2:\"FR\";i:69;s:2:\"GA\";i:70;s:2:\"GB\";i:71;s:2:\"GD\";i:72;s:2:\"GE\";i:73;s:2:\"GF\";i:74;s:2:\"GG\";i:75;s:2:\"GH\";i:76;s:2:\"GI\";i:77;s:2:\"GL\";i:78;s:2:\"GM\";i:79;s:2:\"GN\";i:80;s:2:\"GP\";i:81;s:2:\"GQ\";i:82;s:2:\"GR\";i:83;s:2:\"GS\";i:84;s:2:\"GT\";i:85;s:2:\"GU\";i:86;s:2:\"GW\";i:87;s:2:\"GY\";i:88;s:2:\"HK\";i:89;s:2:\"HM\";i:90;s:2:\"HN\";i:91;s:2:\"HR\";i:92;s:2:\"HT\";i:93;s:2:\"HU\";i:94;s:2:\"ID\";i:95;s:2:\"IE\";i:96;s:2:\"IL\";i:97;s:2:\"IM\";i:98;s:2:\"IN\";i:99;s:2:\"IO\";i:100;s:2:\"IS\";i:101;s:2:\"IT\";i:102;s:2:\"JE\";i:103;s:2:\"JM\";i:104;s:2:\"JO\";i:105;s:2:\"JP\";i:106;s:2:\"KE\";i:107;s:2:\"KG\";i:108;s:2:\"KH\";i:109;s:2:\"KI\";i:110;s:2:\"KM\";i:111;s:2:\"KN\";i:112;s:2:\"KR\";i:113;s:2:\"KW\";i:114;s:2:\"KY\";i:115;s:2:\"KZ\";i:116;s:2:\"LA\";i:117;s:2:\"LB\";i:118;s:2:\"LC\";i:119;s:2:\"LI\";i:120;s:2:\"LK\";i:121;s:2:\"LR\";i:122;s:2:\"LS\";i:123;s:2:\"LT\";i:124;s:2:\"LU\";i:125;s:2:\"LV\";i:126;s:2:\"MA\";i:127;s:2:\"MC\";i:128;s:2:\"MD\";i:129;s:2:\"ME\";i:130;s:2:\"MF\";i:131;s:2:\"MG\";i:132;s:2:\"MH\";i:133;s:2:\"MK\";i:134;s:2:\"ML\";i:135;s:2:\"MN\";i:136;s:2:\"MO\";i:137;s:2:\"MP\";i:138;s:2:\"MQ\";i:139;s:2:\"MR\";i:140;s:2:\"MS\";i:141;s:2:\"MT\";i:142;s:2:\"MU\";i:143;s:2:\"MV\";i:144;s:2:\"MW\";i:145;s:2:\"MX\";i:146;s:2:\"MY\";i:147;s:2:\"MZ\";i:148;s:2:\"NA\";i:149;s:2:\"NC\";i:150;s:2:\"NE\";i:151;s:2:\"NF\";i:152;s:2:\"NG\";i:153;s:2:\"NI\";i:154;s:2:\"NL\";i:155;s:2:\"NO\";i:156;s:2:\"NP\";i:157;s:2:\"NR\";i:158;s:2:\"NU\";i:159;s:2:\"NZ\";i:160;s:2:\"OM\";i:161;s:2:\"PA\";i:162;s:2:\"PE\";i:163;s:2:\"PF\";i:164;s:2:\"PG\";i:165;s:2:\"PH\";i:166;s:2:\"PK\";i:167;s:2:\"PL\";i:168;s:2:\"PM\";i:169;s:2:\"PN\";i:170;s:2:\"PR\";i:171;s:2:\"PS\";i:172;s:2:\"PT\";i:173;s:2:\"PW\";i:174;s:2:\"PY\";i:175;s:2:\"QA\";i:176;s:2:\"RE\";i:177;s:2:\"RO\";i:178;s:2:\"RS\";i:179;s:2:\"RU\";i:180;s:2:\"RW\";i:181;s:2:\"SA\";i:182;s:2:\"SB\";i:183;s:2:\"SC\";i:184;s:2:\"SE\";i:185;s:2:\"SG\";i:186;s:2:\"SH\";i:187;s:2:\"SI\";i:188;s:2:\"SJ\";i:189;s:2:\"SK\";i:190;s:2:\"SL\";i:191;s:2:\"SM\";i:192;s:2:\"SN\";i:193;s:2:\"SO\";i:194;s:2:\"SR\";i:195;s:2:\"ST\";i:196;s:2:\"SV\";i:197;s:2:\"SX\";i:198;s:2:\"SZ\";i:199;s:2:\"TC\";i:200;s:2:\"TD\";i:201;s:2:\"TF\";i:202;s:2:\"TG\";i:203;s:2:\"TH\";i:204;s:2:\"TJ\";i:205;s:2:\"TK\";i:206;s:2:\"TL\";i:207;s:2:\"TM\";i:208;s:2:\"TN\";i:209;s:2:\"TO\";i:210;s:2:\"TR\";i:211;s:2:\"TT\";i:212;s:2:\"TV\";i:213;s:2:\"TW\";i:214;s:2:\"TZ\";i:215;s:2:\"UA\";i:216;s:2:\"UG\";i:217;s:2:\"UM\";i:218;s:2:\"US\";i:219;s:2:\"UY\";i:220;s:2:\"UZ\";i:221;s:2:\"VA\";i:222;s:2:\"VC\";i:223;s:2:\"VE\";i:224;s:2:\"VG\";i:225;s:2:\"VI\";i:226;s:2:\"VN\";i:227;s:2:\"VU\";i:228;s:2:\"WF\";i:229;s:2:\"WS\";i:230;s:2:\"XA\";i:231;s:2:\"XK\";i:232;s:2:\"YE\";i:233;s:2:\"YT\";i:234;s:2:\"ZA\";i:235;s:2:\"ZM\";i:236;s:2:\"ZW\";}','N;'),(21,'COD_USPS','Module\\CDev\\USPS\\Model\\Payment\\Processor\\COD','CDev_USPS',0,0,0,1,'O',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(22,'AuthorizenetAcceptjs','Module\\QSL\\AuthorizenetAcceptjs\\Model\\Payment\\Processor\\AuthorizenetAcceptjs','QSL_AuthorizenetAcceptjs',-101800,-101800,0,1,'C',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(23,'PayPal powered by Braintree','Module\\QSL\\BraintreeVZ\\Model\\Payment\\Processor\\BraintreeVZ','QSL_BraintreeVZ',-101950,-101950,0,0,'A',0,NULL,'a:5:{i:0;s:2:\"US\";i:1;s:2:\"UK\";i:2;s:2:\"FR\";i:3;s:2:\"IT\";i:4;s:2:\"ES\";}','N;'),(24,'ePDQ e-Commerce','Module\\XC\\EPDQ\\Model\\Payment\\Processor\\EPDQ','XC_EPDQ',-10200,0,0,0,'C',0,NULL,'a:1:{i:0;s:2:\"GB\";}','N;'),(25,'Moneris (eSELECTplus- Hosted Pay Page)','Module\\XC\\ESelectHPP\\Model\\Payment\\Processor\\ESelectHPP','XC_ESelectHPP',0,0,0,0,'C',0,NULL,'a:2:{i:0;s:2:\"CA\";i:1;s:2:\"US\";}','N;'),(26,'iDEAL Professional','Module\\XC\\IdealPayments\\Model\\Payment\\Processor\\IdealProfessional','XC_IdealPayments',-10100,0,0,0,'C',0,NULL,'a:9:{i:0;s:2:\"NL\";i:1;s:2:\"DE\";i:2;s:2:\"GB\";i:3;s:2:\"FR\";i:4;s:2:\"BE\";i:5;s:2:\"MT\";i:6;s:2:\"BG\";i:7;s:2:\"LU\";i:8;s:2:\"SE\";}','N;'),(27,'Opayo form protocol','Module\\XC\\SagePay\\Model\\Payment\\Processor\\SagePayForm','XC_SagePay',-101500,0,0,0,'C',0,NULL,'a:5:{i:0;s:2:\"DE\";i:1;s:2:\"ES\";i:2;s:2:\"GB\";i:3;s:2:\"IE\";i:4;s:2:\"US\";}','N;'),(28,'Stripe','Module\\XC\\Stripe\\Model\\Payment\\Stripe','XC_Stripe',-10300,0,0,0,'C',0,NULL,'a:34:{i:0;s:2:\"AT\";i:1;s:2:\"AU\";i:2;s:2:\"BE\";i:3;s:2:\"BR\";i:4;s:2:\"CA\";i:5;s:2:\"CH\";i:6;s:2:\"DE\";i:7;s:2:\"DK\";i:8;s:2:\"EE\";i:9;s:2:\"ES\";i:10;s:2:\"FI\";i:11;s:2:\"FR\";i:12;s:2:\"GB\";i:13;s:2:\"GR\";i:14;s:2:\"HK\";i:15;s:2:\"IE\";i:16;s:2:\"IN\";i:17;s:2:\"IT\";i:18;s:2:\"JP\";i:19;s:2:\"LT\";i:20;s:2:\"LU\";i:21;s:2:\"LV\";i:22;s:2:\"MX\";i:23;s:2:\"MY\";i:24;s:2:\"NL\";i:25;s:2:\"NO\";i:26;s:2:\"NZ\";i:27;s:2:\"PL\";i:28;s:2:\"PT\";i:29;s:2:\"SE\";i:30;s:2:\"SG\";i:31;s:2:\"SI\";i:32;s:2:\"SK\";i:33;s:2:\"US\";}','N;'),(29,'StripeApplePay','Module\\XC\\Stripe\\StripeApplePay\\Model\\Payment\\StripeApplePay','XC_Stripe',-10299,0,0,0,'C',0,NULL,'a:34:{i:0;s:2:\"AT\";i:1;s:2:\"AU\";i:2;s:2:\"BE\";i:3;s:2:\"BR\";i:4;s:2:\"CA\";i:5;s:2:\"CH\";i:6;s:2:\"DE\";i:7;s:2:\"DK\";i:8;s:2:\"EE\";i:9;s:2:\"ES\";i:10;s:2:\"FI\";i:11;s:2:\"FR\";i:12;s:2:\"GB\";i:13;s:2:\"GR\";i:14;s:2:\"HK\";i:15;s:2:\"IE\";i:16;s:2:\"IN\";i:17;s:2:\"IT\";i:18;s:2:\"JP\";i:19;s:2:\"LT\";i:20;s:2:\"LU\";i:21;s:2:\"LV\";i:22;s:2:\"MX\";i:23;s:2:\"MY\";i:24;s:2:\"NL\";i:25;s:2:\"NO\";i:26;s:2:\"NZ\";i:27;s:2:\"PL\";i:28;s:2:\"PT\";i:29;s:2:\"SE\";i:30;s:2:\"SG\";i:31;s:2:\"SI\";i:32;s:2:\"SK\";i:33;s:2:\"US\";}','N;'),(30,'COD_UPS','Module\\XC\\UPS\\Model\\Payment\\Processor\\COD','XC_UPS',0,0,0,1,'O',0,NULL,'a:2:{i:0;s:2:\"US\";i:1;s:2:\"PR\";}','N;'),(31,'XPaymentsApplePay','Module\\XPay\\XPaymentsCloud\\Model\\Payment\\Processor\\ApplePay','XPay_XPaymentsCloud',0,0,1,1,'C',0,NULL,'N;','N;'),(32,'XPaymentsCloud','Module\\XPay\\XPaymentsCloud\\Model\\Payment\\Processor\\XPaymentsCloud','XPay_XPaymentsCloud',0,0,0,1,'C',0,NULL,'N;','N;');
/*!40000 ALTER TABLE `[[dbprefix]]payment_methods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]payment_transaction_data`
--

DROP TABLE IF EXISTS `[[dbprefix]]payment_transaction_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]payment_transaction_data` (
  `data_id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_level` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`data_id`),
  KEY `IDX_9BA8F92A12FC0CB0F` (`transaction_id`),
  KEY `tn` (`transaction_id`,`name`),
  CONSTRAINT `FK_9BA8F92A12FC0CB0F` FOREIGN KEY (`transaction_id`) REFERENCES `[[dbprefix]]payment_transactions` (`transaction_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]payment_transaction_data`
--

LOCK TABLES `[[dbprefix]]payment_transaction_data` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]payment_transaction_data` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]payment_transaction_data` VALUES (1,4,'test_mode','Test mode','A','1'),(2,4,'error_field_name_card.number','Error: field name','A','card.number'),(3,4,'error_field_code_card.number','Error: field code','A','country.bin.not.accepted'),(4,4,'error_field_message_card.number','Error: field message','A','Card bin Country rejected by acquirer'),(5,4,'cart_items','Cart items','A','a:1:{i:0;a:5:{s:4:\"name\";s:28:\"Caged Cutout Sandals in Gold\";s:3:\"sku\";s:11:\"10000000083\";s:5:\"price\";d:34.990000000000002;s:6:\"amount\";i:1;s:5:\"attrs\";a:0:{}}}'),(6,5,'test_mode','Test mode','A','1'),(7,5,'error_field_name_card.number','Error: field name','A','card.number'),(8,5,'error_field_code_card.number','Error: field code','A','card.expired'),(9,5,'error_field_message_card.number','Error: field message','A','Card has expired.'),(10,5,'cart_items','Cart items','A','a:1:{i:0;a:5:{s:4:\"name\";s:28:\"Caged Cutout Sandals in Gold\";s:3:\"sku\";s:11:\"10000000083\";s:5:\"price\";d:34.990000000000002;s:6:\"amount\";i:1;s:5:\"attrs\";a:0:{}}}');
/*!40000 ALTER TABLE `[[dbprefix]]payment_transaction_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]payment_transactions`
--

DROP TABLE IF EXISTS `[[dbprefix]]payment_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]payment_transactions` (
  `transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `method_id` int(11) DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `date` int(11) NOT NULL,
  `publicTxnId` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `method_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method_local_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `public_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `IDX_933CBDC008D9F6D38` (`order_id`),
  KEY `IDX_933CBDC0019883967` (`method_id`),
  KEY `IDX_933CBDC0038248176` (`currency_id`),
  KEY `status` (`status`),
  KEY `o` (`order_id`,`status`),
  KEY `pm` (`method_id`,`status`),
  KEY `publicTxnId` (`publicTxnId`),
  CONSTRAINT `FK_933CBDC0019883967` FOREIGN KEY (`method_id`) REFERENCES `[[dbprefix]]payment_methods` (`method_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_933CBDC0038248176` FOREIGN KEY (`currency_id`) REFERENCES `[[dbprefix]]currencies` (`currency_id`),
  CONSTRAINT `FK_933CBDC008D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]payment_transactions`
--

LOCK TABLES `[[dbprefix]]payment_transactions` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]payment_transactions` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]payment_transactions` VALUES (1,1,4,840,1551771900,'000001-KGSP','MoneyOrdering','Money Order','S',110.6500,'','sale','000001-KGSP'),(2,2,4,840,1553772240,'000002-FX7B','MoneyOrdering','Money Order','S',88.6700,'','sale','000002-FX7B'),(3,3,4,840,1564729080,'000002-FX7B','MoneyOrdering','Money Order','S',158.9400,'','sale','000002-FX7B'),(4,4,NULL,840,1575162780,'000012-AS2T','SimplifyCommerceHP','Simplify Commerce Hosted Payments','F',38.0100,'Simplify_BadRequestException: \"Request data is invalid\" (status: 400, error code: validation, reference: c5a0b8b8-92ac-4908-9506-88b843ecd399)\nField error: card.number\"Card bin Country rejected by acquirer\" (country.bin.not.accepted)','sale','demostore-000012-AS2T'),(5,4,NULL,840,1575162780,'000013-3I22','SimplifyCommerceHP','Simplify Commerce Hosted Payments','F',38.0100,'Simplify_BadRequestException: \"Request data is invalid\" (status: 400, error code: validation, reference: 195c1b1a-44c8-46d4-8e48-ee4e65f271af)\nField error: card.number\"Card has expired.\" (card.expired)','sale','demostore-000013-3I22'),(6,5,4,840,1575163080,'000005-KXAQ','MoneyOrdering','Money Order','S',352.8100,'','sale','000005-KXAQ');
/*!40000 ALTER TABLE `[[dbprefix]]payment_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]permission_translations`
--

DROP TABLE IF EXISTS `[[dbprefix]]permission_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]permission_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_998B75E86BF396750` (`id`),
  CONSTRAINT `FK_998B75E86BF396750` FOREIGN KEY (`id`) REFERENCES `[[dbprefix]]permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]permission_translations`
--

LOCK TABLES `[[dbprefix]]permission_translations` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]permission_translations` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]permission_translations` VALUES (1,1,'Root access','','en'),(2,2,'Manage catalog','','en'),(3,3,'Manage front page','','en'),(4,4,'Manage users','','en'),(5,5,'Manage administrators','','en'),(6,6,'Manage orders','','en'),(7,7,'Manage import','','en'),(8,8,'Manage export','','en'),(9,9,'Manage banners','','en'),(10,10,'Allow unfiltered HTML','','en'),(11,11,'Manage coupons','','en'),(12,11,'Управление купонами','','ru'),(13,12,'Manage sale discounts','','en'),(14,12,'Управление скидками','','ru'),(15,13,'Manage custom pages','','en'),(16,14,'Manage menus','','en'),(17,15,'Manage volume discounts','','en'),(18,15,'Управление скидками','','ru'),(19,16,'Manage news','','en'),(20,16,'Управление новостями','','ru'),(21,17,'Manage reviews','','en'),(22,17,'Управление отзывами','','ru'),(23,18,'Manage conversations','','en'),(24,18,'Управление разговорами','','ru');
/*!40000 ALTER TABLE `[[dbprefix]]permission_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]permissions`
--

DROP TABLE IF EXISTS `[[dbprefix]]permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `section` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]permissions`
--

LOCK TABLES `[[dbprefix]]permissions` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]permissions` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]permissions` VALUES (1,'root access','All'),(2,'manage catalog','Catalog'),(3,'manage front page','Content'),(4,'manage users','Users'),(5,'manage admins','Users'),(6,'manage orders','Sales'),(7,'manage import','Import and Export'),(8,'manage export','Import and Export'),(9,'manage banners','Content'),(10,'unfiltered html','Content'),(11,'manage coupons','Coupons'),(12,'manage sale discounts','Sale'),(13,'manage custom pages','Content'),(14,'manage menus','Content'),(15,'manage volume discounts','Volume discounts'),(16,'manage news','Content'),(17,'manage reviews','Catalog'),(18,'manage conversations','Conversations');
/*!40000 ALTER TABLE `[[dbprefix]]permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]pin_codes`
--

DROP TABLE IF EXISTS `[[dbprefix]]pin_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]pin_codes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `createDate` int(11) NOT NULL,
  `isSold` tinyint(1) NOT NULL,
  `isBlocked` tinyint(1) NOT NULL,
  `productId` int(10) unsigned DEFAULT NULL,
  `orderItemId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `productCode` (`code`,`productId`),
  KEY `IDX_9454145C536799605` (`productId`),
  KEY `IDX_9454145C5BBF22A26` (`orderItemId`),
  CONSTRAINT `FK_9454145C536799605` FOREIGN KEY (`productId`) REFERENCES `[[dbprefix]]products` (`product_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9454145C5BBF22A26` FOREIGN KEY (`orderItemId`) REFERENCES `[[dbprefix]]order_items` (`item_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]pin_codes`
--

LOCK TABLES `[[dbprefix]]pin_codes` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]pin_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]pin_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]product_attachment_history_points`
--

DROP TABLE IF EXISTS `[[dbprefix]]product_attachment_history_points`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]product_attachment_history_points` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` int(10) unsigned DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `profile_id` int(11) DEFAULT NULL,
  `login` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `path` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `additionalDetails` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_98F48E3E88D9F6D38` (`order_id`),
  KEY `IDX_98F48E3E8CCFA12B8` (`profile_id`),
  KEY `at