<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Module\XPay\XPaymentsCloud\View\Button;

/**
 * Checkout with Apple Pay base button
 */
abstract class ACheckoutWithApplePay extends \XLite\View\Button\Regular
{
    /**
     * @return boolean
     */
    protected function isVisible()
    {
        $cart = $this->getCart();

        return
            parent::isVisible()
            && \XLite\Module\XPay\XPaymentsCloud\Main::isCheckoutWithApplePayEnabled($cart)
            && $this->isXpaymentsMethodAvailable();
    }

    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/XPay/XPaymentsCloud/button/checkout_apple_pay.twig';
    }

    /**
     * Return list of required JS files
     *
     * @return array
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();
        $list[] = 'modules/XPay/XPaymentsCloud/checkout/widget.js';
        $list[] = 'modules/XPay/XPaymentsCloud/button/checkout_apple_pay.js';

        return $list;
    }

    /**
     * Get a list of CSS files required to display the widget properly
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();
        $list[] = 'modules/XPay/XPaymentsCloud/button/checkout_apple_pay.css';

        return $list;
    }

    /**
     * Return X-Payments Cloud payment method
     *
     * @return \XLite\Model\Payment\Method
     */
    public function getPaymentMethod()
    {
        return \XLite\Module\XPay\XPaymentsCloud\Main::getPaymentMethod();
    }

    /**
     * @return string
     */
    protected function getButtonClass()
    {
        return 'apple-pay-button';
    }

    /**
     * Checks if X-Payments Cloud method is available in checkout
     *
     * @return bool
     */
    public function isXpaymentsMethodAvailable()
    {
        static $result = null;

        if (is_null($result)) {
            $result = false;
            foreach ($this->getCart()->getPaymentMethods() as $method) {
                if ('Module\XPay\XPaymentsCloud\Model\Payment\Processor\XPaymentsCloud' == $method->getClass()) {
                    $result = true;
                    break;
                }
            }
        }

        return $result;
    }

    /**
     * @return string
     */
    protected function getRequiredAddressFields($type = 'shipping')
    {
        $result = [];
        if ('shipping' == $type) {
            $list = \XLite\Core\Database::getRepo('XLite\Model\AddressField')->getShippingRequiredFields();
        } else {
            $list = \XLite\Core\Database::getRepo('XLite\Model\AddressField')->getBillingRequiredFields();
        }
        foreach ($list as $field) {
            switch ($field) {
                case 'city':
                case 'country_code':
                case 'state_id':
                case 'street':
                case 'zipcode':
                    if (!in_array('postalAddress', $result)) {
                        $result[] = 'postalAddress';
                    }
                    break;
                case 'phone':
                    $result[] = 'phone';
                    break;
                case 'firstname':
                case 'lastname':
                    if (!in_array('name', $result)) {
                        $result[] = 'name';
                    }
                    break;
            }
        }
        $cart = $this->getCart();

        if (
            !$cart->getProfile() || $cart->getProfile()->getAnonymous()
        ) {
            $result[] = 'email';
        }
        return json_encode($result);
    }

    /**
     * @return string
     */
    protected function getShippingMethodsList()
    {
        $result = \XLite\Module\XPay\XPaymentsCloud\Main::getApplePayShippingMethodsList($this->getCart());
        return json_encode($result);
    }
 }
