<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Module\XPay\XPaymentsCloud\Controller\Customer;

use \XLite\Module\XPay\XPaymentsCloud\Main as XPaymentsCloud;

/**
 * Shipping estimator
 */
class ApplePayShipping extends \XLite\Controller\Customer\ShippingEstimate
{

    /**
     * Set estimate destination
     *
     * @return void
     */
    protected function doActionSetDestination()
    {
        $this->getCart()->setPaymentMethod(XPaymentsCloud::getApplePayMethod());

        parent::doActionSetDestination();

        $this->setPureAction(true);
        $this->setInternalRedirect(false);

        $result = new \StdClass();
        $result->newTotal = new \StdClass();
        $result->newTotal->amount = $this->getCart()->getTotal();
        $result->newTotal->type = 'final';

        if ($this->valid) {
            $result->newShippingMethods = XPaymentsCloud::getApplePayShippingMethodsList($this->getCart());
        } else {
            $error = new \StdClass();
            $error->code = 'shippingContactInvalid';
            $error->contactField = 'postalAddress';
            $error->message = static::t('Shipping address is invalid');

            $result->errors = [
                $error
            ];
        }

        echo json_encode($result);
    }

    /**
     * Change shipping method
     *
     * @return void
     */
    protected function doActionChangeMethod()
    {
        $this->getCart()->setPaymentMethod(XPaymentsCloud::getApplePayMethod());

        parent::doActionChangeMethod();

        $this->setPureAction(true);
        $this->setInternalRedirect(false);

        $result = new \StdClass();
        $result->newTotal = new \StdClass();
        $result->newTotal->amount = $this->getCart()->getTotal();
        $result->newTotal->type = 'final';
        $this->updateCart();
        echo json_encode($result);}

    /**
     * Force silent flag to avoid reloads when Apple Pay shipping selected
     *
     * @param boolean $silent
     *
     * @throws \Exception
     */
    protected function updateCart($silent = false)
    {
        parent::updateCart(true);
    }
}
