/* Checkout with Apple Pay */

function CheckoutWithApplePayWrapper()
{
    this.widget = new XPaymentsWidget();

    this.blockPage = function() {
        assignShadeOverlay(jQuery('#page-wrapper'));
    }
    this.unblockPage = function() {
        unassignShadeOverlay(jQuery('#page-wrapper'));
    }
    this.waitPage = function() {
        assignWaitOverlay(jQuery('#page-wrapper'));
        jQuery('.lc-minicart').hide();
    }
    this.load = function() {
        this.getWidget().load();
    }
    this.begin = function() {
        this.getWidget().beginCheckoutWithApplePay();
    }
    this.isSupported = function() {
        return this.getWidget().isApplePaySupportedByDevice();
    }
    this.getWidget = function() {
        return this.widget;
    }
}

CheckoutWithApplePayWrapper.prototype.initialize = function(settings)
{
    this.getWidget().initCheckoutWithApplePay(settings);

    var self = this;

    // Assign handlers
    this.getWidget().on('fail', function() {
        self.unblockPage();
    }).on('applepay.start', function() {
        self.blockPage();
    }).on('alert', function(params) {
        setTimeout(function () {
            if ('popup' === params.type) {
                core.trigger('message', {type: 'info', message: params.message});
            } else {
                core.showError(params.message);
            }
        }, 500)
    }).on('applepay.paymentauthorized', function(payment) {

        var data = {
            billingContact: payment.billingContact,
            shippingContact: payment.shippingContact
        }
        data[xliteConfig.form_id_name] = xliteConfig.form_id;

        core.post(
            {
                target: 'checkout',
                action: 'xpayments_apple_pay_prepare'
            },
            function (xhr) {
                var response = jQuery.parseJSON(xhr.responseText);
                if (response.errors && response.errors.length) {
                    response.errors.forEach(
                        function (error, i, arr) {
                            arr[i] = new ApplePayError(error.code, error.contactField, error.message);
                        }
                    );
                    self.getWidget().completeApplePayPayment({ status: ApplePaySession.STATUS_FAILURE, errors: response.errors });
                } else {
                    self.waitPage();
                    self.getWidget().succeedApplePayPayment(payment);
                }
            },
            data
        );

    }).on('applepay.shippingcontactselected', function(shippingContact) {
        var data = {
            destination_country: shippingContact.countryCode,
            destination_state: shippingContact.administrativeArea,
            destination_custom_state: shippingContact.administrativeArea,
            destination_zipcode: shippingContact.postalCode,
            destination_city: shippingContact.locality

        }
        data[xliteConfig.form_id_name] = xliteConfig.form_id;
        core.post(
            {
                target: 'apple_pay_shipping',
                action: 'set_destination'
            },
            function (xhr) {
                var response = jQuery.parseJSON(xhr.responseText);
                response.newTotal.label = self.getWidget().config.company.name;
                if (response.errors) {
                    response.errors.forEach(
                        function (error, i, arr) {
                            arr[i] = new ApplePayError(error.code, error.contactField, error.message);
                        }
                    );
                }
                self.getWidget().completeApplePayShippingContactSelection(response);
            },
            data
        );
    }).on('applepay.shippingmethodselected', function(shippingMethod) {
        var data = {
            methodId: shippingMethod.identifier,
        }
        data[xliteConfig.form_id_name] = xliteConfig.form_id;
        core.post(
            {
                target: 'apple_pay_shipping',
                action: 'change_method'
            },
            function (xhr) {
                var response = jQuery.parseJSON(xhr.responseText);
                response.newTotal.label = self.getWidget().config.company.name;
                self.getWidget().completeApplePayShippingMethodSelection(response);
            },
            data
        );
    });
}



