START TRANSACTION;
/*!40101 SET NAMES utf8, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET UNIQUE_CHECKS=0, FOREIGN_KEY_CHECKS=0 */;
/*!40111 SET SQL_NOTES=0 */;
CREATE TABLE `xlite_category_quick_flags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `subcategories_count_all` int(11) NOT NULL,
  `subcategories_count_enabled` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_5BA9C50312469DE2` (`category_id`),
  CONSTRAINT `FK_5BA9C50312469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_category_quick_flags` VALUES (1,1,3,3),(2,2,3,3),(3,3,0,0),(4,4,0,0),(5,5,0,0),(6,6,2,2),(7,7,0,0),(8,8,0,0),(9,9,3,3),(10,10,0,0),(11,11,0,0),(12,12,0,0);
CREATE TABLE `xlite_session_cells` (
  `cell_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`cell_id`),
  UNIQUE KEY `iname` (`id`,`name`),
  KEY `id` (`id`),
  CONSTRAINT `FK_C8BF5944BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_option_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_31550B83BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_options` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_option_translations` VALUES (1,1,'S','en'),(2,2,'M','en'),(3,3,'L','en'),(4,4,'XL','en'),(5,5,'XXL','en'),(8,8,'XXXL','en'),(109,109,'IndependentApparel','en'),(110,110,'YourStyle','en'),(111,111,'MyBestDress','en'),(112,112,'Toyty','en'),(113,113,'FunnyChildren','en'),(114,114,'MindSet','en'),(115,115,'GoodyBrand','en'),(116,116,'iBoutique','en'),(1001,1,'S','ru'),(1002,2,'M','ru'),(1003,3,'L','ru'),(1004,4,'XL','ru'),(1005,5,'XXL','ru'),(1008,8,'XXXL','ru'),(1109,109,'IndependentApparel','ru'),(1110,110,'YourStyle','ru'),(1111,111,'MyBestDress','ru'),(1112,112,'Toyty','ru'),(1113,113,'FunnyChildren','ru'),(1114,114,'MindSet','ru'),(1115,115,'GoodyBrand','ru'),(1116,116,'iBoutique','ru'),(2001,1,'S','ru'),(2002,2,'M','ru'),(2003,3,'L','ru'),(2004,4,'XL','ru'),(2005,5,'XXL','ru'),(2008,8,'XXXL','ru'),(2109,109,'IndependentApparel','ru'),(2110,110,'YourStyle','ru'),(2111,111,'MyBestDress','ru'),(2112,112,'Toyty','ru'),(2113,113,'FunnyChildren','ru'),(2114,114,'MindSet','ru'),(2115,115,'GoodyBrand','ru'),(2116,116,'iBoutique','ru'),(3001,1,'S','ru'),(3002,2,'M','ru'),(3003,3,'L','ru'),(3004,4,'XL','ru'),(3005,5,'XXL','ru'),(3008,8,'XXXL','ru'),(3109,109,'IndependentApparel','ru'),(3110,110,'YourStyle','ru'),(3111,111,'MyBestDress','ru'),(3112,112,'Toyty','ru'),(3113,113,'FunnyChildren','ru'),(3114,114,'MindSet','ru'),(3115,115,'GoodyBrand','ru'),(3116,116,'iBoutique','ru'),(3165,165,'16','en'),(3166,166,'64','en'),(3167,167,'128','en'),(3168,168,'Silver','en'),(3169,169,'Space Gray','en'),(3170,170,'Gold','en'),(3171,171,'A8 chip with 64‑bit architecture','en'),(3173,173,'Retina HD display','en'),(3181,181,'GSM/EDGE/LTE','en'),(3183,183,'Bluetooth 4.2','en'),(3186,186,'32','en'),(3187,187,'A7 chip with 64-bit architecture','en'),(3188,188,'White','en'),(3189,189,'Black','en'),(3196,196,'GSM/EDGE','en'),(3200,200,'A9 chip with 64‑bit architecture','en'),(3209,205,'Rose Gold','en'),(3210,168,'Серебристый','ru'),(3211,169,'Серый космос','ru'),(3212,170,'Золотой','ru'),(3213,188,'Белый','ru'),(3214,189,'Черный','ru'),(3215,205,'Розовое золото','ru'),(3216,165,'16','ru'),(3217,166,'64','ru'),(3218,167,'128','ru'),(3219,186,'32','ru'),(3221,207,'Nano-SIM','ru'),(3223,209,'4','ru'),(3224,210,'1136x640','ru'),(3225,211,'Built-in rechargeable lithium-ion battery','ru'),(3226,212,'Up to 14 hours on 3G','ru'),(3227,213,'Up to 10 days (250 hours)','ru'),(3228,214,'Up to 10 hours','ru'),(3229,215,'Up to 40 hours','ru'),(3231,217,'802.11a/b/g/n/ac','ru'),(3232,218,'One size','en'),(3233,218,'','ru'),(3234,219,'XS','en'),(3262,227,'US 6','en'),(3263,228,'US 7','en'),(3264,229,'US 8','en'),(3265,230,'US 9','en'),(3266,231,'Gray','en'),(3267,232,'Red','en'),(3268,233,'Black','en'),(3269,234,'UK 8','en'),(3270,235,'UK 10','en'),(3271,236,'UK 12','en'),(3272,237,'UK 14','en'),(3273,238,'UK 16','en'),(3280,245,'S','en'),(3281,246,'M','en'),(3282,247,'L','en'),(3283,248,'XL','en'),(3284,249,'256','en'),(3285,250,'Apple A11 Bionic','en'),(3286,251,'Super Retina HD (OLED)','en'),(3287,252,'5.8','en'),(3288,253,'2436x1125','en'),(3289,254,'Bluetooth 5.0','en'),(3290,255,'A11 Bionic + M11','en'),(3291,256,'UK 6','en'),(3292,257,'Uk 8','en'),(3293,258,'Uk 10','en'),(3294,259,'Uk 12','en'),(3295,260,'Uk 14','en'),(3296,261,'Uk 16','en'),(3297,227,'38','ru'),(3298,228,'39','ru'),(3299,229,'40','ru'),(3300,230,'41','ru'),(3301,171,'A8 64‑bit','ru'),(3302,187,'A7 64-bit','ru'),(3303,200,'A9 64‑bit','ru'),(3304,250,'Apple A11 Bionic','ru'),(3305,255,'A11 Bionic + M11','ru'),(3306,173,'Retina HD display','ru'),(3307,251,'Super Retina HD (OLED)','ru'),(3308,252,'5.8','ru'),(3309,253,'2436x1125','ru'),(3310,181,'GSM/EDGE/LTE','ru'),(3311,196,'GSM/EDGE','ru');
CREATE TABLE `xlite_language_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_610C29E2BF396750` (`id`),
  KEY `ci` (`code`,`id`),
  CONSTRAINT `FK_610C29E2BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_languages` (`lng_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_language_translations` VALUES (1,1,'Afar','en'),(2,2,'Abkhazian','en'),(3,3,'Afrikaans','en'),(4,4,'Akan','en'),(5,5,'Albanian','en'),(6,6,'Amharic','en'),(7,7,'Arabic','en'),(8,8,'Aragonese','en'),(9,9,'Armenian','en'),(10,10,'Assamese','en'),(11,11,'Avaric','en'),(12,12,'Avestan','en'),(13,13,'Aymara','en'),(14,14,'Azerbaijani','en'),(15,15,'Bashkir','en'),(16,16,'Bambara','en'),(17,17,'Basque','en'),(18,18,'Belarusian','en'),(19,19,'Bengali','en'),(20,20,'Bihari','en'),(21,21,'Bislama','en'),(22,22,'Bosnian','en'),(23,23,'Brazilian Portuguese','en'),(24,24,'British','en'),(25,25,'Bulgarian','en'),(26,26,'Burmese','en'),(27,27,'Catalan','en'),(28,28,'Chamorro','en'),(29,29,'Chechen','en'),(30,30,'Chinese','en'),(31,31,'Church Slavic','en'),(32,32,'Chuvash','en'),(33,33,'Cornish','en'),(34,34,'Corsican','en'),(35,35,'Cree','en'),(36,36,'Czech','en'),(37,37,'Danish','en'),(38,38,'Divehi','en'),(39,39,'Dutch','en'),(40,40,'Dzongkha','en'),(41,41,'English','en'),(42,42,'Esperanto','en'),(43,43,'Estonian','en'),(44,44,'Ewe','en'),(45,45,'Faroese','en'),(46,46,'Fijian','en'),(47,47,'Finnish','en'),(48,48,'French','en'),(49,49,'Western Frisian','en'),(50,50,'Fulah','en'),(51,51,'Georgian','en'),(52,52,'German','en'),(53,53,'Gaelic','en'),(54,54,'Irish','en'),(55,55,'Galician','en'),(56,56,'Manx','en'),(57,57,'Greek','en'),(58,58,'Guarani','en'),(59,59,'Gujarati','en'),(60,60,'Haitian','en'),(61,61,'Hausa','en'),(62,62,'Hebrew','en'),(63,63,'Herero','en'),(64,64,'Hindi','en'),(65,65,'Hiri Motu','en'),(66,66,'Croatian','en'),(67,67,'Hungarian','en'),(68,68,'Igbo','en'),(69,69,'Icelandic','en'),(70,70,'Ido','en'),(71,71,'Sichuan Yi','en'),(72,72,'Inuktitut','en'),(73,73,'Interlingue','en'),(74,74,'Interlingua','en'),(75,75,'Indonesian','en'),(76,76,'Inupiaq','en'),(77,77,'Italian','en'),(78,78,'Javanese','en'),(79,79,'Japanese','en'),(80,80,'Kalaallisut','en'),(81,81,'Kannada','en'),(82,82,'Kashmiri','en'),(83,83,'Kanuri','en'),(84,84,'Kazakh','en'),(85,85,'Khmer or Cambodian','en'),(86,86,'Kikuyu','en'),(87,87,'Kinyarwanda','en'),(88,88,'Kirghiz','en'),(89,89,'Komi','en'),(90,90,'Kongo','en'),(91,91,'Korean','en'),(92,92,'Kuanyama','en'),(93,93,'Kurdish','en'),(94,94,'Lao','en'),(95,95,'Latin','en'),(96,96,'Latvian','en'),(97,97,'Limburgan','en'),(98,98,'Lingala','en'),(99,99,'Lithuanian','en'),(100,100,'Luxembourgish','en'),(101,101,'Luba-Katanga','en'),(102,102,'Ganda','en'),(103,103,'Macedonian','en'),(104,104,'Marshallese','en'),(105,105,'Malayalam','en'),(106,106,'Maori','en'),(107,107,'Marathi','en'),(108,108,'Malay','en'),(109,109,'Malagasy','en'),(110,110,'Maltese','en'),(111,111,'Mongolian','en'),(112,112,'Nauru','en'),(113,113,'Navajo','en'),(114,114,'Ndebel','en'),(115,115,'Ndebel','en'),(116,116,'Ndonga','en'),(117,117,'Nepali','en'),(118,118,'Norwegian','en'),(119,119,'Chichewa','en'),(120,120,'Occitan','en'),(121,121,'Ojibwa','en'),(122,122,'Oriya','en'),(123,123,'Oromo','en'),(124,124,'Ossetian','en'),(125,125,'Panjabi','en'),(126,126,'Persian','en'),(127,127,'Pali','en'),(128,128,'Polish','en'),(129,129,'Portuguese','en'),(130,130,'Pushto','en'),(131,131,'Quechua','en'),(132,132,'Romansh','en'),(133,133,'Romanian','en'),(134,134,'Rundi','en'),(135,135,'Russian','en'),(136,136,'Sango','en'),(137,137,'Sanskrit','en'),(138,138,'Sinhala','en'),(139,139,'Slovak','en'),(140,140,'Slovenian','en'),(141,141,'Northern Sami','en'),(142,142,'Samoan','en'),(143,143,'Shona','en'),(144,144,'Sindhi','en'),(145,145,'Somali','en'),(146,146,'Soth','en'),(147,147,'Spanish','en'),(148,148,'Sardinian','en'),(149,149,'Serbian','en'),(150,150,'Swati','en'),(151,151,'Sundanese','en'),(152,152,'Swahili','en'),(153,153,'Swedish','en'),(154,154,'Tahitian','en'),(155,155,'Tamil','en'),(156,156,'Tatar','en'),(157,157,'Telugu','en'),(158,158,'Tajik','en'),(159,159,'Tagalog','en'),(160,160,'Thai','en'),(161,161,'Tibetan','en'),(162,162,'Tigrinya','en'),(163,163,'Tonga','en'),(164,164,'Tswana','en'),(165,165,'Tsonga','en'),(166,166,'Turkmen','en'),(167,167,'Turkish','en'),(168,168,'Twi','en'),(169,169,'Uighur','en'),(170,170,'Ukrainian','en'),(171,171,'Urdu','en'),(172,172,'Uzbek','en'),(173,173,'Venda','en'),(174,174,'Vietnamese','en'),(175,175,'Welsh','en'),(176,176,'Walloon','en'),(177,177,'Wolof','en'),(178,178,'Xhosa','en'),(179,179,'Yiddish','en'),(180,180,'Yoruba','en'),(181,181,'Zhuang','en'),(182,182,'Zulu','en');
CREATE TABLE `xlite_product_tabs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `global_tab_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `link` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_global_tab` (`product_id`,`global_tab_id`),
  KEY `IDX_F5B7716D4584665A` (`product_id`),
  KEY `IDX_F5B7716D629D8673` (`global_tab_id`),
  CONSTRAINT `FK_F5B7716D4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_F5B7716D629D8673` FOREIGN KEY (`global_tab_id`) REFERENCES `xlite_global_product_tabs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_product_tabs` VALUES (1,1,5,-10,1,NULL),(2,2,5,-10,1,NULL),(3,3,5,-10,1,NULL),(4,4,5,-10,1,NULL),(5,5,5,-10,1,NULL),(6,6,5,-10,1,NULL),(7,7,5,-10,1,NULL),(8,8,5,-10,1,NULL),(9,9,5,-10,1,NULL),(10,10,5,-10,1,NULL),(11,11,5,-10,1,NULL),(12,12,5,-10,1,NULL),(13,13,5,-10,1,NULL),(14,14,5,-10,1,NULL),(15,15,5,-10,1,NULL),(16,16,5,-10,1,NULL),(17,17,5,-10,1,NULL),(18,18,5,-10,1,NULL),(19,19,5,-10,1,NULL),(20,20,5,-10,1,NULL),(21,21,5,-10,1,NULL),(22,22,5,-10,1,NULL),(23,23,5,-10,1,NULL),(24,24,5,-10,1,NULL),(25,25,5,-10,1,NULL),(26,26,5,-10,1,NULL),(27,27,5,-10,1,NULL),(28,28,5,-10,1,NULL),(29,29,5,-10,1,NULL),(30,30,5,-10,1,NULL),(31,31,5,-10,1,NULL),(32,32,5,-10,1,NULL),(33,33,5,-10,1,NULL),(34,34,5,-10,1,NULL),(35,35,5,-10,1,NULL),(36,36,5,-10,1,NULL),(37,37,5,-10,1,NULL),(38,38,5,-10,1,NULL),(39,39,5,-10,1,NULL),(40,40,5,-10,1,NULL),(41,41,5,-10,1,NULL),(42,42,5,-10,1,NULL),(43,43,5,-10,1,NULL),(44,44,5,-10,1,NULL),(45,45,5,-10,1,NULL),(46,46,5,-10,1,NULL),(47,47,5,-10,1,NULL),(48,48,5,-10,1,NULL),(49,49,5,-10,1,NULL),(50,50,5,-10,1,NULL),(64,1,6,-10,1,NULL),(65,2,6,-10,1,NULL),(66,3,6,-10,1,NULL),(67,4,6,-10,1,NULL),(68,5,6,-10,1,NULL),(69,6,6,-10,1,NULL),(70,7,6,-10,1,NULL),(71,8,6,-10,1,NULL),(72,9,6,-10,1,NULL),(73,10,6,-10,1,NULL),(74,11,6,-10,1,NULL),(75,12,6,-10,1,NULL),(76,13,6,-10,1,NULL),(77,14,6,-10,1,NULL),(78,15,6,-10,1,NULL),(79,16,6,-10,1,NULL),(80,17,6,-10,1,NULL),(81,18,6,-10,1,NULL),(82,19,6,-10,1,NULL),(83,20,6,-10,1,NULL),(84,21,6,-10,1,NULL),(85,22,6,-10,1,NULL),(86,23,6,-10,1,NULL),(87,24,6,-10,1,NULL),(88,25,6,-10,1,NULL),(89,26,6,-10,1,NULL),(90,27,6,-10,1,NULL),(91,28,6,-10,1,NULL),(92,29,6,-10,1,NULL),(93,30,6,-10,1,NULL),(94,31,6,-10,1,NULL),(95,32,6,-10,1,NULL),(96,33,6,-10,1,NULL),(97,34,6,-10,1,NULL),(98,35,6,-10,1,NULL),(99,36,6,-10,1,NULL),(100,37,6,-10,1,NULL),(101,38,6,-10,1,NULL),(102,39,6,-10,1,NULL),(103,40,6,-10,1,NULL),(104,41,6,-10,1,NULL),(105,42,6,-10,1,NULL),(106,43,6,-10,1,NULL),(107,44,6,-10,1,NULL),(108,45,6,-10,1,NULL),(109,46,6,-10,1,NULL),(110,47,6,-10,1,NULL),(111,48,6,-10,1,NULL),(112,49,6,-10,1,NULL),(113,50,6,-10,1,NULL),(127,1,7,-10,1,NULL),(128,2,7,-10,1,NULL),(129,3,7,-10,1,NULL),(130,4,7,-10,1,NULL),(131,5,7,-10,1,NULL),(132,6,7,-10,1,NULL),(133,7,7,-10,1,NULL),(134,8,7,-10,1,NULL),(135,9,7,-10,1,NULL),(136,10,7,-10,1,NULL),(137,11,7,-10,1,NULL),(138,12,7,-10,1,NULL),(139,13,7,-10,1,NULL),(140,14,7,-10,1,NULL),(141,15,7,-10,1,NULL),(142,16,7,-10,1,NULL),(143,17,7,-10,1,NULL),(144,18,7,-10,1,NULL),(145,19,7,-10,1,NULL),(146,20,7,-10,1,NULL),(147,21,7,-10,1,NULL),(148,22,7,-10,1,NULL),(149,23,7,-10,1,NULL),(150,24,7,-10,1,NULL),(151,25,7,-10,1,NULL),(152,26,7,-10,1,NULL),(153,27,7,-10,1,NULL),(154,28,7,-10,1,NULL),(155,29,7,-10,1,NULL),(156,30,7,-10,1,NULL),(157,31,7,-10,1,NULL),(158,32,7,-10,1,NULL),(159,33,7,-10,1,NULL),(160,34,7,-10,1,NULL),(161,35,7,-10,1,NULL),(162,36,7,-10,1,NULL),(163,37,7,-10,1,NULL),(164,38,7,-10,1,NULL),(165,39,7,-10,1,NULL),(166,40,7,-10,1,NULL),(167,41,7,-10,1,NULL),(168,42,7,-10,1,NULL),(169,43,7,-10,1,NULL),(170,44,7,-10,1,NULL),(171,45,7,-10,1,NULL),(172,46,7,-10,1,NULL),(173,47,7,-10,1,NULL),(174,48,7,-10,1,NULL),(175,49,7,-10,1,NULL),(176,50,7,-10,1,NULL),(190,29,NULL,0,1,'Privacy'),(191,28,NULL,0,1,'Privacy'),(192,1,1,-80,1,NULL),(193,2,1,-80,1,NULL),(194,3,1,-80,1,NULL),(195,4,1,-80,1,NULL),(196,5,1,-80,1,NULL),(197,6,1,-80,1,NULL),(198,7,1,-80,1,NULL),(199,8,1,-80,1,NULL),(200,9,1,-80,1,NULL),(201,10,1,-80,1,NULL),(202,11,1,-80,1,NULL),(203,12,1,-80,1,NULL),(204,13,1,-80,1,NULL),(205,14,1,-80,1,NULL),(206,15,1,-80,1,NULL),(207,16,1,-80,1,NULL),(208,17,1,-80,1,NULL),(209,18,1,-80,1,NULL),(210,19,1,-80,1,NULL),(211,20,1,-80,1,NULL),(212,21,1,-80,1,NULL),(213,22,1,-80,1,NULL),(214,23,1,-80,1,NULL),(215,24,1,-80,1,NULL),(216,25,1,-80,1,NULL),(217,26,1,-80,1,NULL),(218,27,1,-80,1,NULL),(219,28,1,-80,1,NULL),(220,29,1,-80,1,NULL),(221,30,1,-80,1,NULL),(222,31,1,-80,1,NULL),(223,32,1,-80,1,NULL),(224,33,1,-80,1,NULL),(225,34,1,-80,1,NULL),(226,35,1,-80,1,NULL),(227,36,1,-80,1,NULL),(228,37,1,-80,1,NULL),(229,38,1,-80,1,NULL),(230,39,1,-80,1,NULL),(231,40,1,-80,1,NULL),(232,41,1,-80,1,NULL),(233,42,1,-80,1,NULL),(234,43,1,-80,1,NULL),(235,44,1,-80,1,NULL),(236,45,1,-80,1,NULL),(237,46,1,-80,1,NULL),(238,47,1,-80,1,NULL),(239,48,1,-80,1,NULL),(240,49,1,-80,1,NULL),(241,50,1,-80,1,NULL),(255,1,2,-70,1,NULL),(256,2,2,-70,1,NULL),(257,3,2,-70,1,NULL),(258,4,2,-70,1,NULL),(259,5,2,-70,1,NULL),(260,6,2,-70,1,NULL),(261,7,2,-70,1,NULL),(262,8,2,-70,1,NULL),(263,9,2,-70,1,NULL),(264,10,2,-70,1,NULL),(265,11,2,-70,1,NULL),(266,12,2,-70,1,NULL),(267,13,2,-70,1,NULL),(268,14,2,-70,1,NULL),(269,15,2,-70,1,NULL),(270,16,2,-70,1,NULL),(271,17,2,-70,1,NULL),(272,18,2,-70,1,NULL),(273,19,2,-70,1,NULL),(274,20,2,-70,1,NULL),(275,21,2,-70,1,NULL),(276,22,2,-70,1,NULL),(277,23,2,-70,1,NULL),(278,24,2,-70,1,NULL),(279,25,2,-70,1,NULL),(280,26,2,-70,1,NULL),(281,27,2,-70,1,NULL),(282,28,2,-70,1,NULL),(283,29,2,-70,1,NULL),(284,30,2,-70,1,NULL),(285,31,2,-70,1,NULL),(286,32,2,-70,1,NULL),(287,33,2,-70,1,NULL),(288,34,2,-70,1,NULL),(289,35,2,-70,1,NULL),(290,36,2,-70,1,NULL),(291,37,2,-70,1,NULL),(292,38,2,-70,1,NULL),(293,39,2,-70,1,NULL),(294,40,2,-70,1,NULL),(295,41,2,-70,1,NULL),(296,42,2,-70,1,NULL),(297,43,2,-70,1,NULL),(298,44,2,-70,1,NULL),(299,45,2,-70,1,NULL),(300,46,2,-70,1,NULL),(301,47,2,-70,1,NULL),(302,48,2,-70,1,NULL),(303,49,2,-70,1,NULL),(304,50,2,-70,1,NULL),(318,1,3,-60,1,NULL),(319,2,3,-60,1,NULL),(320,3,3,-60,1,NULL),(321,4,3,-60,1,NULL),(322,5,3,-60,1,NULL),(323,6,3,-60,1,NULL),(324,7,3,-60,1,NULL),(325,8,3,-60,1,NULL),(326,9,3,-60,1,NULL),(327,10,3,-60,1,NULL),(328,11,3,-60,1,NULL),(329,12,3,-60,1,NULL),(330,13,3,-60,1,NULL),(331,14,3,-60,1,NULL),(332,15,3,-60,1,NULL),(333,16,3,-60,1,NULL),(334,17,3,-60,1,NULL),(335,18,3,-60,1,NULL),(336,19,3,-60,1,NULL),(337,20,3,-60,1,NULL),(338,21,3,-60,1,NULL),(339,22,3,-60,1,NULL),(340,23,3,-60,1,NULL),(341,24,3,-60,1,NULL),(342,25,3,-60,1,NULL),(343,26,3,-60,1,NULL),(344,27,3,-60,1,NULL),(345,28,3,-60,1,NULL),(346,29,3,-60,1,NULL),(347,30,3,-60,1,NULL),(348,31,3,-60,1,NULL),(349,32,3,-60,1,NULL),(350,33,3,-60,1,NULL),(351,34,3,-60,1,NULL),(352,35,3,-60,1,NULL),(353,36,3,-60,1,NULL),(354,37,3,-60,1,NULL),(355,38,3,-60,1,NULL),(356,39,3,-60,1,NULL),(357,40,3,-60,1,NULL),(358,41,3,-60,1,NULL),(359,42,3,-60,1,NULL),(360,43,3,-60,1,NULL),(361,44,3,-60,1,NULL),(362,45,3,-60,1,NULL),(363,46,3,-60,1,NULL),(364,47,3,-60,1,NULL),(365,48,3,-60,1,NULL),(366,49,3,-60,1,NULL),(367,50,3,-60,1,NULL),(381,1,4,-30,1,NULL),(382,2,4,-30,1,NULL),(383,3,4,-30,1,NULL),(384,4,4,-30,1,NULL),(385,5,4,-30,1,NULL),(386,6,4,-30,1,NULL),(387,7,4,-30,1,NULL),(388,8,4,-30,1,NULL),(389,9,4,-30,1,NULL),(390,10,4,-30,1,NULL),(391,11,4,-30,1,NULL),(392,12,4,-30,1,NULL),(393,13,4,-30,1,NULL),(394,14,4,-30,1,NULL),(395,15,4,-30,1,NULL),(396,16,4,-30,1,NULL),(397,17,4,-30,1,NULL),(398,18,4,-30,1,NULL),(399,19,4,-30,1,NULL),(400,20,4,-30,1,NULL),(401,21,4,-30,1,NULL),(402,22,4,-30,1,NULL),(403,23,4,-30,1,NULL),(404,24,4,-30,1,NULL),(405,25,4,-30,1,NULL),(406,26,4,-30,1,NULL),(407,27,4,-30,1,NULL),(408,28,4,-30,1,NULL),(409,29,4,-30,1,NULL),(410,30,4,-30,1,NULL),(411,31,4,-30,1,NULL),(412,32,4,-30,1,NULL),(413,33,4,-30,1,NULL),(414,34,4,-30,1,NULL),(415,35,4,-30,1,NULL),(416,36,4,-30,1,NULL),(417,37,4,-30,1,NULL),(418,38,4,-30,1,NULL),(419,39,4,-30,1,NULL),(420,40,4,-30,1,NULL),(421,41,4,-30,1,NULL),(422,42,4,-30,1,NULL),(423,43,4,-30,1,NULL),(424,44,4,-30,1,NULL),(425,45,4,-30,1,NULL),(426,46,4,-30,1,NULL),(427,47,4,-30,1,NULL),(428,48,4,-30,1,NULL),(429,49,4,-30,1,NULL),(430,50,4,-30,1,NULL);
CREATE TABLE `xlite_data_source_parameters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_source_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_6D9196CA1A935C57` (`data_source_id`),
  CONSTRAINT `FK_6D9196CA1A935C57` FOREIGN KEY (`data_source_id`) REFERENCES `xlite_data_sources` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_select` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_option_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  `xpaymentsSubscriptionFeeModifier` decimal(14,4) NOT NULL DEFAULT 0.0000,
  `xpaymentsSubscriptionFeeModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'p',
  `priceModifier` decimal(14,4) NOT NULL,
  `priceModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `weightModifier` decimal(14,4) NOT NULL,
  `weightModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `defaultValue` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `attribute_option_id` (`attribute_option_id`),
  CONSTRAINT `FK_65258CAB1AE56DE9` FOREIGN KEY (`attribute_option_id`) REFERENCES `xlite_attribute_options` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_65258CAB4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_65258CABB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_values_select` VALUES (462,227,2,94,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(463,228,2,94,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(464,229,2,94,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(465,230,2,94,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(466,228,4,94,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(467,229,4,94,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(468,230,4,94,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(470,231,31,95,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(471,232,31,95,20,0.0000,'p',20.0000,'a',0.0000,'a',0),(472,233,31,95,30,0.0000,'p',5.0000,'p',0.0000,'a',0),(473,234,16,96,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(474,235,16,96,20,0.0000,'p',0.0000,'a',0.0000,'a',0),(475,236,16,96,30,0.0000,'p',0.0000,'a',0.0000,'a',0),(476,237,16,96,40,0.0000,'p',0.0000,'a',0.0000,'a',0),(477,238,16,96,50,0.0000,'p',0.0000,'a',0.0000,'a',0),(484,116,14,50,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(485,1,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(486,2,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(487,3,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(488,4,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(489,5,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(490,8,14,1,0,0.0000,'p',0.0000,'p',0.0000,'p',0),(491,2,17,1,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(493,3,17,1,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(494,4,17,1,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(495,5,17,1,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(496,8,17,1,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(497,109,17,50,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(502,166,29,71,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(504,167,29,71,10,0.0000,'p',100.0000,'a',0.0000,'a',0),(505,249,29,71,20,0.0000,'p',200.0000,'a',0.0000,'a',0),(506,250,29,72,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(507,189,29,73,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(509,251,29,75,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(510,252,29,76,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(511,253,29,77,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(513,181,29,83,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(515,254,29,85,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(516,166,28,71,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(517,249,28,71,0,0.0000,'p',0.0000,'a',0.0000,'a',0),(518,255,28,72,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(519,168,28,73,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(520,170,28,73,20,0.0000,'p',0.0000,'a',0.0000,'a',0),(521,169,28,73,30,0.0000,'p',0.0000,'a',0.0000,'a',0),(523,173,28,75,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(527,181,28,83,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(529,254,28,85,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(530,111,15,50,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(531,256,15,99,10,0.0000,'p',0.0000,'a',0.0000,'a',0),(532,257,15,99,20,0.0000,'p',0.0000,'a',0.0000,'a',0),(533,258,15,99,30,0.0000,'p',0.0000,'a',0.0000,'a',0),(534,259,15,99,40,0.0000,'p',0.0000,'a',0.0000,'a',0),(535,260,15,99,50,0.0000,'p',0.0000,'a',0.0000,'a',0),(536,261,15,99,60,0.0000,'p',0.0000,'a',0.0000,'a',0);
CREATE TABLE `xlite_theme_tweaker_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `template` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_text_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_753A596BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_values_text` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_stats` (
  `stat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `viewed_product_id` int(10) unsigned DEFAULT NULL,
  `bought_product_id` int(10) unsigned DEFAULT NULL,
  `count` int(10) unsigned NOT NULL,
  PRIMARY KEY (`stat_id`),
  KEY `IDX_B01836BC658EF086` (`viewed_product_id`),
  KEY `IDX_B01836BC3BA20971` (`bought_product_id`),
  CONSTRAINT `FK_B01836BC3BA20971` FOREIGN KEY (`bought_product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_B01836BC658EF086` FOREIGN KEY (`viewed_product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_hidden_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_B6B29289BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_values_hidden` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_content_videos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_membership_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_571DB741BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_membership_translations` VALUES (1,1,'Wholesaler','en'),(2,1,'Оптовый покупатель','ru');
CREATE TABLE `xlite_product_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `ogMeta` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `briefDescription` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaTags` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `metaDesc` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaTitle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  KEY `name` (`name`),
  CONSTRAINT `FK_F48089BABF396750` FOREIGN KEY (`id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_product_translations` VALUES (1,1,'','Timberland 45th Anniversary','','','','','','en'),(2,2,'','High Top Trainers in Red, Black and White [Tags]','<p><strong>Features:</strong></p><ul><li>Regular Fit</li><li>Leather upper with logo</li><li>Mesh lining</li><li>Foam padded tongue and collar</li><li>Ventilation holes</li><li>Abrasion-resistant rubber outsole</li><li>Leather upper, rubber outsole</li></ul>','<p>This sneaker delivers heritage style with premium materials and responsive cushioning. The red, black and white uppers provide a bold and stylish take on the iconic silhouette. Featuring a high top style, a lace-up front fastening, a round toe and a well padded ankle collar and tongue, this shoe is an ideal companion for sports and day to day wear.<br><br><br></p>','','This sneaker delivers heritage style with premium materials and responsive cushioning. The red, black and white uppers provide a bold and stylish take on the iconic silhouette. Featuring a high top style, a lace-up front fastening, a round toe and a well padded ankle collar and tongue, this shoe is an ideal companion for sports and day to day wear.','','en'),(3,3,'','Beige Sneakers','<p>Lightweight and breathable canvas construction. Vulcanized rubber sole for improved traction. An unmistakable logo patch to complete your look. An ortholite insole cushions each step. Versatile, fashionable, and looking better every time you wear them. &nbsp;</p><p><strong>Features:</strong></p><ul><li>Hi top plimsolls&nbsp;</li><li>Lace-up front</li><li>Embroidered logo to side</li><li>Regular Fit</li><li>Outer: Cotton 100%</li><li>Sole: Rubber 100%</li><li>Lining: Cotton 100%</li></ul>','<p>Beige cotton hi-top sneakers featuring a lace-up front fastening, a round toe, a branded ankle patch and a flat rubber sole.</p>','','Beige cotton hi-top sneakers featuring a lace-up front fastening, a round toe, a branded ankle patch and a flat rubber sole.','','en'),(4,4,'','Platform Brogue-Trim Leather Oxfords in White','<p>Take your style up a notch with these super fashionable platform oxfords. Wear with leggings and an oversized shirt or off-the-shoulder blouse for an on-trend look. Comfortable platform with a non-skid, much lighter than you imagine, manmade sole.</p><p><strong>Features:</strong></p><ul><li>Leather oxford with brogue detail</li><li>Espadrille-inspired platform</li><li>1.25 inch heel</li><li>Round Toe</li><li>Adjustable lace-up closure</li><li>Water resistant</li><li>Leather upper</li><li>Antiskid manmade sole</li></ul>','<p>A mixed-media oxford steals the scene with an espadrille-trimmed platform sole and dramatic brogue detailing on the burnished leather upper.</p>','','A mixed-media oxford steals the scene with an espadrille-trimmed platform sole and dramatic brogue detailing on the burnished leather upper.','','en'),(5,5,'','Grey Knitted Trainers','<p>This shoe hits the sweet spot of effortless comfort and universal style. Knitted from a lightweight sports-mesh that hugs the foot for a snug fit, with an easy-entry collar shaped to perfection cushioned with the lightweight EVA midsole and finished with a flexible rubber outsole for excellent grip in any conditions, this shoe has delighted many a runner who just want a shoe that feels indulgent on their foot.&nbsp;</p><p><strong>Features:</strong></p><ul><li>Regular Fit</li><li>Knit textile upper</li><li>EVA midsole</li><li>Flexible rubber outsole</li></ul>','<p>Designed with your comfort in mind, a pair of knitted trainers is a go to for any day! &nbsp;</p>','','Designed with your comfort in mind, a pair of knitted trainers is a go to for any day! &nbsp;','','en'),(6,6,'','Lace-Up Boots in Light Brown','<p>Waterproof, rugged, built for comfort and traction, these boots can go all day and will only look better with age.&nbsp;</p><p><strong>Features:</strong></p><ul><li>Premium leather upper</li><li>Seam-sealed waterproof construction</li><li>400 gram synthetic insulation</li><li>Padded collar</li><li>Leather lining</li><li>Flexible forefoot construction</li><li>Anti-fatigue midsole and footbed</li><li>Rubber lug outsole</li></ul>','<p>Insulated waterproof boots for your next adventure.</p>','','Insulated waterproof boots for your next adventure.','','en'),(7,7,'','Boyfriend T-Shirt with Chest Logo','<p>A wardrobe must-have, this crewneck tee features a comfortable cotton blend and a straight hem for easy, everyday wear. Think baggy and casual. Wear it again and again.</p>','','','A wardrobe must-have, this crewneck tee features a comfortable cotton blend and a straight hem for easy, everyday wear. Think baggy and casual. Wear it again and again.','','en'),(8,8,'','Pink Sneakers with White Soles','<p>Low-top silhouette with a durable canvas upper. &nbsp;Lace-up front with flat cotton laces. Round toe. Lightly padded tongue and collar. Vulcanized sole with high-wall foxings. Premium cushioned flexible sole. &nbsp;</p><p><strong>Features:</strong></p><ul><li>Regular Fit</li><li>Lace-up construction</li><li>Textile upper</li><li>Flexible rubber outsole</li></ul>','<p>Timeless low top sneakers in pink. &nbsp;</p>','','Timeless low top sneakers in pink. &nbsp;','','en'),(9,9,'','White Lace-Up Mesh Trainers','<p>This pair is perfect for a variety of workouts in and out of the gym. School, play, travel, jogging, running - you name it! A great gift for a sporty girl.</p><p><strong>Features:</strong></p><ul><li>Lightweight</li><li>Mesh textile upper</li><li>Flexible shock absorbing EVA midsole</li><li>Rugged and durable outsole for long lasting traction</li></ul>','<p>Breathable soft knit mesh sneakers for sports and more.</p>','','Breathable soft knit mesh sneakers for sports and more.','','en'),(10,10,'','Caged Cutout Sandals in Gold','<p>These sandals feature an exquisite cut-out design on the upper and high heels to showcase your unique sense of style. This time made with a gold finish to give this piece a sleek and refined look. &nbsp;</p><p><strong>Features:</strong></p><ul><li>Vegan-friendly leather with geometric cutout design</li><li>Adjustable buckle closure at ankle</li><li>Open toe</li><li>Stiletto heel</li><li>Heel height: 3 <sup>1</sup>&frasl;<sub>2</sub> in</li></ul>','<p>More feminine, more refined, more fun!</p>','','More feminine, more refined, more fun!','','en'),(11,11,'','Green Flat Slingback Sandals','<p>Quality made with premium elastic fabric, these strappy open toe sandals are a HOT TREND! Designed for all day comfort, they keep you moving while looking effortlessly stylish.&nbsp;</p><p><strong>Features:</strong></p><ul><li>Open toe sandal</li><li>Medium Width</li><li>Lightweight&nbsp;</li><li>Textile and synthetic leather upper</li><li>Soft rubber sole</li></ul>','<p>With the rubber sole and wide elastic straps hugging your foot, these open toe sandals are made for walking.</p>','','With the rubber sole and wide elastic straps hugging your foot, these open toe sandals are made for walking.','','en'),(12,12,'','Waist Tie Dress in Blue and White Stripe','<p>Crafted in a lightweight blend of linen and cotton and finished with muted stripes, this dress is an everyday piece that is perfect for long, sunny days.</p>','','','Crafted in a lightweight blend of linen and cotton and finished with muted stripes, this dress is an everyday piece that is perfect for long, sunny days.','','en'),(13,13,'','Ultimate T-Shirt with Crew Neck in Red','<p><br></p><ul><li>Crew neck</li><li>Short sleeves</li><li>Regular fit</li><li>100% Cotton</li></ul>','<p>Another stylish addition your wardrobe. This crew-neck tee was designed specifically for a fashionable, comfortable, feminine look.</p>','','Another stylish addition your wardrobe. This crew-neck tee was designed specifically for a fashionable, comfortable, feminine look.','','en'),(14,14,'','Multicolored Dress with Balloon Sleeves [Options & Attributes]','<ul><li>Round neck</li><li>Dropped shoulders</li><li>Balloon sleeves</li><li>Don&#39;t worry, you won&rsquo;t float away</li><li>Fitted cuffs&nbsp;</li><li>Relaxed fit</li><li>Loose but not oversized</li><li>100% Polyester</li></ul>','<p>Cute, right? Bright floral print in relaxed fit. Throw on a black leather jacket and wrap a belt around the waist &nbsp;and you&#39;re ready for a night out.</p>','','Cute, right? Bright floral print in relaxed fit. Throw on a black leather jacket and wrap a belt around the waist &nbsp;and you&#39;re ready for a night out.','','en'),(15,15,'','Tall Pleated Midi Skirt in Check','<ul><li>High rise</li><li>Just like your standards</li><li>Pleated design</li><li>Regular cut</li><li>Fits you just right</li><li>Lightweight knit. The kind that doesn&#39;t stretch</li><li>100% Polyester</li></ul>','<p>Suitable for spring, summer and autumn. You can&#39;t miss such a charming skirt in your wardrobe.<br>Besides, you can dress it up with heels, or dress it down with sandals and t-shirt for a more casual look.</p><p><br></p><p><br></p>','','Suitable for spring, summer and autumn. You can&#39;t miss such a charming skirt in your wardrobe. Besides, you can dress it up with heels, or dress it down with sandals and t-shirt for a more casual look.','','en'),(16,16,'','Sleeved Mini Dress in Color Block','<ul><li>Color-block design</li><li>55% Polyester, 45% Cotton</li><li>Round neck</li><li>Shift design</li><li>Regular cut</li><li>Fits you just right</li></ul>','<p>An easy way to wear more color - 3-in-1 mini dress in modern color block design. Sleeves are non-detachable and can be completely unzipped to show that extra skin.&nbsp;</p>','','An easy way to wear more color - 3-in-1 mini dress in modern color block design. Sleeves are non-detachable and can be completely unzipped to show that extra skin.&nbsp;','','en'),(17,17,'','Tall Slim Fit T-Shirt in White','<ul><li>Throw on and go</li><li>Crew neck</li><li>Short sleeves</li><li>Plain design</li><li>Slim fit</li><li>100% Cotton.</li></ul>','<p>This classic tee features all-cotton construction and a tag-free crew neckline for comfort. Affordable, high-quality, and long-lasting everyday clothing you can rely on.</p>','','This classic tee features all-cotton construction and a tag-free crew neckline for comfort. Affordable, high-quality, and long-lasting everyday clothing you can rely on.','','en'),(18,18,'','Skinny Western Denim Jacket in Light Blue Wash','<p>The original jean jacket since 1962, this denim trucker jacket is fit for anything. This classic trucker features a standard regular fit with a hem that hits below the waist and welt hand pockets.</p>','','','The original jean jacket since 1962, this denim trucker jacket is fit for anything. This classic trucker features a standard regular fit with a hem that hits below the waist and welt hand pockets.','','en'),(19,19,'','Oversized Hoodie in Grey','<p>An oversized hoodie in grey for your chill days. &nbsp;More style for your money, with drawstring hood, fitted trims and dropped shoulders. Part of the Eco Edit. </p>','','','An oversized hoodie in grey for your chill days. &nbsp;More style for your money, with drawstring hood, fitted trims and dropped shoulders. Part of the Eco Edit.','','en'),(20,20,'','Hooded Anorak Jacket in Black','<p>This wind- and water-resistant jacket is a versatile, all-season piece with an impeccable fit built to keep you protected in milder weather and layer under shells and jackets for bonus warmth in more severe conditions.</p>','','','This wind- and water-resistant jacket is a versatile, all-season piece with an impeccable fit built to keep you protected in milder weather and layer under shells and jackets for bonus warmth in more severe conditions.','','en'),(21,21,'','Leather Mini Tote Bag with Rose and Girl Print in Red','<p><br></p><ul><li>Grab handle</li><li>Detachable straps</li><li>Flap-top closure</li><li>Avoid contact with liquids</li></ul>','','','Grab handle Detachable straps Flap-top closure Avoid contact with liquids','','en'),(22,22,'','Mesh Strap Watch in Gold','<ul><li>Stainless-steel mesh strap</li><li>Gold-tone case</li><li>Three hand movement</li><li>Dash indices</li><li>Single crown to side</li><li>Presented in a branded gift-box</li></ul>','<p>Elegant, flawlessly feminine and easy to read with a large polished goldtone dial. Let your wrist do the talking.</p>','','Elegant, flawlessly feminine and easy to read with a large polished goldtone dial. Let your wrist do the talking.','','en'),(23,23,'','Square Glasses in Black with Clear Lens','<p>Frame: 100% Plastic, Lens: 100% Plastic.</p>','<p>Whether you are looking for reading glasses for the office or home. These reading glasses will provide you with the best service and the premium protection you are looking for.</p><p>Square frames. Moulded nose pads for added comfort. Clear lenses. Tapered arms with curved temple tips for a secure fit.&nbsp;</p><p>Cloth sunglasses pouch can be used as a lens wipe.</p><p><br></p>','','Whether you are looking for reading glasses for the office or home. These reading glasses will provide you with the best service and the premium protection you are looking for. Square frames. Moulded nose pads for added comfort. Clear lenses. Tapered arms with curved temple tips for a secure fit.&nbsp; Cloth sunglasses pouch can be used as a lens wipe.','','en'),(24,24,'','Chain Drop Earrings in Gold Tone','<p><br></p><ul><li>Drop design</li><li>Tiered hoops</li><li>Connecting chains</li><li>All earrings are non-returnable</li></ul>','<p>For all-day-everyday use. Just give them a wipe to clean.</p>','','For all-day-everyday use. Just give them a wipe to clean.','','en'),(25,25,'','Rooster Mug in White [Related products]','<p>For your AM coffee and PM tea break. Regular size. Silver-tone trims.</p>','','','For your AM coffee and PM tea break. Regular size. Silver-tone trims.','','en'),(26,26,'','Festival Braslet Pack in Gold Tone','<p>We know you like options. With the combination of woven design and polished shiny surface, this bracelet is just the thing to make any woman feel special. An elegant and generous visual enjoyment for you and the ones you love.</p>','','','We know you like options. With the combination of woven design and polished shiny surface, this bracelet is just the thing to make any woman feel special. An elegant and generous visual enjoyment for you and the ones you love.','','en'),(27,27,'','Samsung - Galaxy S6 Edge Plus 4g LTE with 32gb Memory Cell Phone','<ul><li>Wireless Compatibility - Wireless A|Wireless G|Wireless N|Wireless AC|Wireless B</li><li>Screen Size - 5.7 inches</li><li>Android 5.1.1 Lollipop</li><li>Internal Memory - 32 gigabytes</li></ul>','','','Wireless Compatibility - Wireless A|Wireless G|Wireless N|Wireless AC|Wireless B Screen Size - 5.7 inches Android 5.1.1 Lollipop Internal Memory - 32 gigabytes','','en'),(28,28,'','Apple iPhone 8 Plus, 64GB','<div data-cel-widget=\"productDescription_feature_div\" data-feature-name=\"productDescription\"><div data-cel-widget=\"productDescription_feature_div\" data-feature-name=\"productDescription\" data-template-name=\"productDescription\"><br></div></div><ul><li>5.5-inch (diagonal) widescreen LCD Multi-Touch display with IPS technology - 1920-by-1080-pixel resolution at 401 ppiA11 Bionic chip with 64-bit architecture, Neural engine, Embedded M11 motion coprocessor</li><li>12MP wide-angle and telephoto camera, 7MP FaceTime HD Camera</li><li>Splash, water, and dust resistant</li></ul>','<p>Designed with most durable glass and a stronger aerospace-grade aluminum band. Charges wirelessly. Resists water and dust. 5.5-inch Retina HD display with True Tone. 12MP dual cameras offer improved Portrait mode and new Portrait Lighting. Powered by A11 Bionic, a most powerful smartphone chip.</p>','','Designed with most durable glass and a stronger aerospace-grade aluminum band. Charges wirelessly. Resists water and dust. 5.5-inch Retina HD display with True Tone. 12MP dual cameras offer improved Portrait mode and new Portrait Lighting. Powered by A11 Bionic, a most powerful smartphone chip.','','en'),(29,29,'','Apple iPhone X [Options & Attributes] [Custom tabs]','<ul><li>An all-new 5.8-inch Super Retina screen with all-screen OLED Multi-Touch display</li><li>12MP wide-angle and telephoto cameras with Dual optical image stabilization</li><li>Wireless Qi charging</li></ul>','<div data-cel-widget=\"productDescription_feature_div\" data-feature-name=\"productDescription\"><div data-cel-widget=\"productDescription_feature_div\" data-feature-name=\"productDescription\" data-template-name=\"productDescription\"><p>iPhone that is entirely screen. One so immersive the device itself disappears into the experience. And so intelligent it can respond to a tap, your voice, and even a glance. With iPhone X, that vision is now a reality. Say hello to the future.</p></div></div><div data-cel-widget=\"renewedProgramDescriptionBtf_feature_div\" data-feature-name=\"renewedProgramDescriptionBtf\"><br></div>','','iPhone that is entirely screen. One so immersive the device itself disappears into the experience. And so intelligent it can respond to a tap, your voice, and even a glance. With iPhone X, that vision is now a reality. Say hello to the future.','','en'),(30,30,'','Apple Watch Series 3 (GPS, 38mm)','<table><tbody><tr><td style=\"width: 12.5352%;\"><p>Connectivity</p></td><td style=\"width: 87.3944%;\"><p>Wi-Fi (802.11b/g/n 2.4GHz), Bluetooth 4.2</p></td></tr><tr><td style=\"width: 12.5352%;\"><p>Power</p></td><td style=\"width: 87.3944%;\"><p>Up to 18 hours of battery life</p></td></tr><tr><td style=\"width: 12.5352%;\"><p>Width</p></td><td style=\"width: 87.3944%;\"><p>33.3mm</p></td></tr><tr><td style=\"width: 12.5352%;\"><p>Depth</p></td><td style=\"width: 87.3944%;\"><p>11.4mm</p></td></tr><tr><td style=\"width: 12.5352%;\"><p>Case Weight</p></td><td style=\"width: 87.3944%;\"><p>36.7g</p></td></tr></tbody></table><table><tbody><tr><td><p>Case Size</p></td><td><p>38mm, 42mm</p></td></tr><tr><td><p>Features</p></td><td><p>GLONASS, Galileo, and QZSS, Barometric altimeter, Optical heart sensor, Accelerometer and gyroscope, Ion-X strengthened glass, Composite back</p></td></tr><tr><td><p>Whats in the box</p></td><td><p>Case, Band (either S/M or M/L length), 1m Magnetic Charging Cable</p></td></tr></tbody></table><p><br></p><p><br></p><p><br></p>','<ul><li>GPS</li><li>Optical heart sensor</li><li>Digital Crown</li><li>S3 with dual-core processor</li><li>Accelerometer and gyroscope</li><li>Swim proof</li><li>watchOS 5</li><li>Aluminum case</li></ul>','','GPS Optical heart sensor Digital Crown S3 with dual-core processor Accelerometer and gyroscope Swim proof watchOS 5 Aluminum case','','en'),(31,31,'','Google Home Mini [Attributes & Options]','<p>A new Google smart speaker in mini format that shrinks down all the intelligence into a cheaper, smaller package.&nbsp;</p><p>A wifi-connected smart speaker that looks like a small fabric-covered pin cushion. It comes in a grey, black or coral with a colour-matched plastic base and rubber foot to keep it from sliding about when you prod it.</p>','','','A new Google smart speaker in mini format that shrinks down all the intelligence into a cheaper, smaller package.&nbsp; A wifi-connected smart speaker that looks like a small fabric-covered pin cushion. It comes in a grey, black or coral with a colour-matched plastic base and rubber foot to keep it from sliding about when you prod it.','','en'),(32,32,'','Fitness Tracker Smart Watch','<ul><li>Multifunction Smart Watch: The fitness tracker smart watch has data and 12/24H time display, Accurate heart rate, Blood pressure monitor, Sleep monitor, Auto pedometer, brightness adjustment, Weather, Clock alarm, Stopwatch, Sedentary reminder, Remote camera control, Music control, Find phone, Incoming call and SMS reminder, Message reminder etc.</li><li>Heart Rate Monitor &amp; Blood Pressure Fitness Tracker: Enter the watch face and long pressing the control area. Wait a moment about 30 seconds, then you can read the real time heart rate/blood pressure/blood oxygen data in the watch face. You can set the automatic heart rate monitor in the app. The history heart rate, blood pressure and blood oxygen details data are Available in the app.</li><li>IP67 Waterproof and Sleep tracking: The smart fitness tracker meets the international IP67 waterproof and dust proof standard. But we don&rsquo;t recommend to wear the fitness tracker while swimming or taking a shower; Comprehensively analyze data such as sleep duration, sleep depth and wakefulness sleep, guide you to improve sleep quality</li><li>See Calls &amp; Messages on Your Wrist: Receive call, SMS and SNS (Facebook, WhatsApp, LinkedIn, Instagram, and Twitter) notifications on display; Support system iOS 9.0 or above, Android 4.4 or above.(not for PC, iPad or Tablet).</li><li>Special Powerful Functions and Warranty:Weather forecast function, Music Player, Remote Camera Function, Change the Screen Brightness function and more other functions are available. 3-Months Warranty is Provided by Teamyo fitness tracker. Please feel free to contact us if you have any problem about our product, and we will response to you as soon as possible with full enthusiasm.</li></ul><p><strong>Warm Notes:</strong></p><p><strong>1. Compatibility:</strong> This fitness watch can be used with both Android and IOS system,Compatible with Android 4.4 or above, IOS 9 or above.Compatible with with bluetooth 4.0 or above.<br><strong>2. Waterproof Grade:</strong> IP67 Life Waterproof Grade. IP67 Waterproof resistant for sweat, rain, splash proof. Not recommend wear the fitness tracker when swimming or Take a shower.<br><strong>3. Charging cable:</strong> The smart watch is packed in a beautiful box. Please kindly find the charging cable under the box. Charge the fitness watch about 2 hours before firstly use.</p>','<h2><span style=\"font-size: 14px; font-family: Arial, Helvetica, sans-serif; color: rgb(128, 128, 128);background-color: rgb(255, 255, 255);\">A modern waterproof a</span><span style=\"color: rgb(204, 204, 204);\"><span style=\"background-color: rgb(255, 255, 255);\"><a href=\"https://www.amazon.com/Activity-Waterproof-Pressure-Pedometer-V11-gray/dp/B07PNMRBJY/ref=sr_1_5?keywords=smart+watch&qid=1560875842&s=gateway&sr=8-5\"></a></span></span><span style=\"color: rgb(124, 112, 107);\"><span style=\"font-size: 14px; font-family: Arial, Helvetica, sans-serif; background-color: rgb(255, 255, 255);\">ctivity tracker with heart rate monitor and blood pressure, step and calorie counter. Pedometer watch for women and men.&nbsp;</span></span><span style=\"color: rgb(204, 204, 204);\"><span style=\"background-color: rgb(255, 255, 255);\"><a href=\"https://www.amazon.com/Activity-Waterproof-Pressure-Pedometer-V11-gray/dp/B07PNMRBJY/ref=sr_1_5?keywords=smart+watch&qid=1560875842&s=gateway&sr=8-5\"></a></span></span></h2>','','A modern waterproof a ctivity tracker with heart rate monitor and blood pressure, step and calorie counter. Pedometer watch for women and men.&nbsp;','','en'),(33,33,'','Bluetooth Smartwatch with Touch Screen and Fitness Tracker','<p>The perfect companion to keep you organized and productive all day long. Receive one-way notifications for emails, SMS messages, and incoming phone calls (prompting you to take action on your smartphone), as well as alerts for Facebook, Twitter, WhatsApp, LinkedIn, Snap and other mobile apps.</p><p>It counts your steps, measures distance walked and estimate calories burned via a 3-axis accelerometer.<br>Monitor sleep quality and record sleep status data.</p><p>Rain and sweat water-resistant, can&#39;t be used for Hot Water washing and long time soak in water.</p><p>This wearable has an estimated 24-hour battery life. (Note: Battery life varies based on usage.)</p>','','','The perfect companion to keep you organized and productive all day long. Receive one-way notifications for emails, SMS messages, and incoming phone calls (prompting you to take action on your smartphone), as well as alerts for Facebook, Twitter, WhatsApp, LinkedIn, Snap and other mobile apps. It counts your steps, measures distance walked and estimate calories burned via a 3-axis accelerometer. Monitor sleep quality and record sleep status data. Rain and sweat water-resistant, can&#39;t be used for Hot Wat','','en'),(34,34,'','Aster i39 Headphones with Microphone','<ul><li>Microphone, Foldabe, Stereo, Portable, Lightweight</li><li>Weight - 6.6 ounces</li><li>Dimentions - 8.3 x 7.1 x 3.5 in</li></ul>','<p>Aster i39 on ear headphones are designed for ultimate comfort when you are travel, hang out, or on a business.</p><p>Take your headphones wherever you go. Just fold them up, twist up the cord, and be on your merry way</p>','','Aster i39 on ear headphones are designed for ultimate comfort when you are travel, hang out, or on a business. Take your headphones wherever you go. Just fold them up, twist up the cord, and be on your merry way','','en'),(35,35,'','Apple AirPods','<p>Unlike traditional, circular earbuds, the design of the EarPods is defined by the geometry of the ear which makes them more comfortable for more people than any other earbud-style headphones. &nbsp;The speakers inside the EarPods have been engineered to maximize sound output and minimize sound loss, which means you get high-quality audio.</p><p>Works with all devices that have a Lightning connector and support iOS 10 or later, including iPod touch, iPad, and iPhone.</p>','','','Unlike traditional, circular earbuds, the design of the EarPods is defined by the geometry of the ear which makes them more comfortable for more people than any other earbud-style headphones. &nbsp;The speakers inside the EarPods have been engineered to maximize sound output and minimize sound loss, which means you get high-quality audio. Works with all devices that have a Lightning connector and support iOS 10 or later, including iPod touch, iPad, and iPhone.','','en'),(36,36,'','Cocooil Body Oil','<p>Formulated with certified fair trade cold pressed organic coconut oil, produced sustainably in the Pacific Islands and supporting local communities. a Provides a luxurious feeling, perfect as your daily moisturiser all year long.</p><p>Ingredients: Helianthus Annuus (Sunflower) Seed Oil, Fair Trade Cold Pressed Organic Cocos Nucifera (Coconut) Oil, Vitas Vinifera (Grape) Seed Oil, Tocopherol.</p><p><strong>Features</strong>:</p><ul><li>Non-greasy body oil</li><li>Hydrating, nourishing and soothing &nbsp;<br><br></li></ul><p><br></p>','<p>This body oil will nourish and protect your skin.</p>','','This body oil will nourish and protect your skin.','','en'),(37,37,'','Maui Moisture','<p>With castor oil &amp; neem oil, this formula helps soften treated, natural, or transitioning hair.</p><p>Ingredients: Aloe Barbadensis Leaf Juice, Water (Aqua), Sodium C14-16 Olefin Sulfonate, Cocamidopropyl Betaine, PPG-2 Hydroxyethyl Coco/Isostearamide, Glycol Distearate, Cocos Nucifera (Coconut) Water, Bambusa Arundinacea Stem Extract, Ricinus Communis (Castor) Seed Oil, Melia Azadirachta Seed Oil, Chamomilla Recutita (Matricaria) Flower Extract, Polyquaternium-10, Cocamidopropyl Hydroxysultaine, Sodium Cocoyl Isethionate, PEG-120 Methyl Glucose Dioleate, Guar Hydroxypropyltrimonium Chloride, Methyl Gluceth-10, Tapioca Starch, Sodium Chloride, Propylene Glycol, Diazolidinyl Urea, Iodopropynyl Butylcarbamate, Fragrance (Parfum).&nbsp;</p><p><strong>Features</strong>:</p><ul><li>Fortifying</li><li>Encourages healthy-looking glow</li><li>Uses sulfate-free surfactants</li></ul>','<p>A lush, strengthening shampoo that helps your hair feel rejuvenated &amp; restored.</p>','','A lush, strengthening shampoo that helps your hair feel rejuvenated &amp; restored.','','en'),(38,38,'','Barth Body Oil','<p>Great for normal, sensitive and inflamed skin. Ideal for skin that needs to be calmed down and regenerated.&nbsp;</p><p><strong>Features</strong>:</p><ul><li>Penetrates the skin without leaving a greasy residue</li><li>Pleasant scent of exotic oils</li><li>Organic</li></ul>','<p>With this amazing oil serum your skin will immediately feel very silky and hydrated.&nbsp;</p>','','With this amazing oil serum your skin will immediately feel very silky and hydrated.&nbsp;','','en'),(39,39,'','Facial Spray','<p>Created with aloe, cucumber and green tee, this spray hydrates, cools and refreshes. Mist over the face before moisturising or throughout the day after makeup, for a quick antioxidant boost.&nbsp;</p><p>Ingredients: Aqua (Water, Eau), Propylene Glycol, Mentha Piperita (Peppermint) Leaf Water, Cucumis Sativus (Cucumber) Fruit Water, Aloe Barbadensis Leaf Juice, Camellia Sinensis Leaf Extract, Cucumis Sativus (Cucumber) Fruit Extract, Fucus Vesiculosus Extract, Propanediol, Polysorbate 20, Ethylhexylglycerin, Benzophenone-4, Parfum (Fragrance), Sodium Chloride, Citric Acid, Potassium Sorbate, Sodium Benzoate, CI 19140 (Yellow 5), CI 42090 (Blue 1), Hexyl Cinnamal, Limonene, Linalool.&nbsp;</p><p><strong>Features</strong>:</p><ul><li>Calms and soothes skin</li><li>Antioxidant</li><li>Organic</li></ul>','<p>A refreshing, hydrating mist for all skin types.</p>','','A refreshing, hydrating mist for all skin types.','','en'),(40,40,'','Red Dior','<p>This limited edition stick delivers all the colour and shine of a lacquer, plus the comfort of a balm, with 6h* of wear and an exceptionally fine texture.&nbsp;</p><p><strong>Features</strong>:</p><ul><li>Liquified shine</li><li>Saturated lip color</li><li>Weightless wear</li></ul>','<p>The new generation of lipstick: as easy to apply as it is to wear.</p>','','The new generation of lipstick: as easy to apply as it is to wear.','','en'),(41,41,'','Pink Unicorn Makeup Brushes','<p>Crafted with the highest quality materials, each brush features whisper-soft synthetic bristles bundled with a gold ferrule. The sleek embellished holder keeps the tools organized in style.</p><p><strong>Features</strong>:</p><ul><li><strong>&nbsp;</strong>Includes 3 makeup brushes and a holder</li><li>Made with synthetic hairs; cruelty free.</li></ul>','<p>Add some pink unicorn glam to your beauty routine! An essential collection of face and eye brushes for a perfected complexion and enchanting eye looks. &nbsp; &nbsp;</p>','','Add some pink unicorn glam to your beauty routine! An essential collection of face and eye brushes for a perfected complexion and enchanting eye looks. &nbsp; &nbsp;','','en'),(42,42,'','Perfect Snacks','<p>Made with freshly ground nut butters and organic honey, this snack bar is a delicious blend of creamy and crunchy with a cookie-dough-like texture. Each bar contains up to 17g of whole food protein.</p><p><strong>Features</strong>:</p><ul><li>A convenient source of vitamins and minerals</li><li>Non-GMO</li><li>Soy Free</li><li>Gluten Free</li><li>Organic</li><li>Kosher</li><li>Made in the USA</li></ul><p><br></p>','<p>Nutritious protein for active lifestyles.</p>','','Nutritious protein for active lifestyles.','','en'),(43,43,'','Blue & Green Matcha','<p>Pure organic matcha, blue and green. All natural weight loss, metabolism booster supplement. Delicious and nutricious. Enhances all day energy, mental clarity and focus. The best coffee substitute that does not give you jitters. Can be used in a variety of recipes for baking, lattes, smoothies, shakes, icecream and other foods.</p><p><strong>Features</strong>:</p><ul><li>Powerful antioxidant</li><li>Certified organic</li><li>Vegan</li><li>Non-GMO</li></ul>','<h4><span style=\"font-size: 14px; color: rgb(128, 128, 128);\">Give matcha a try and be amazed.</span></h4><p><br></p><p><br></p>','','Give matcha a try and be amazed.','','en'),(44,44,'','Chia Seed','<p>A rich source of protein, fiber, antioxidants, essential omega-3 fatty acids and minerals (magnesium, calcium, potassium, phosphorous). An ideal addition to vegetarian, vegan, whole food, paleo, ketogenic, and gluten-free diets. Can be consumed and digested whole. Add a healthful gourmet flair to salads, snacks, soups, and baked goods, or soak them for a satisfying pudding or gel.</p><p><strong>Features</strong>:</p><ul><li>Certified organic&nbsp;</li><li>Non-GMO&nbsp;</li><li>BPA-free packaging</li></ul>','<p>Organic superfood.</p>','','Organic superfood.','','en'),(45,45,'','Probiotic and Omega 3, 6, 9 Supplement','<p>Boost your energy, immune system and cognitive function by providing friendly bacteria for the digestive system and the Omega fatty acids for your brain. Each day, either morning or evening, take one capsule with a glass of water. Consistency is key.</p><p><strong>Features</strong>:</p><ul><li>Non-GMO</li><li>Antioxidant</li></ul>','<p>A proprietary probiotic blend to support your brain and gut health.</p>','','A proprietary probiotic blend to support your brain and gut health.','','en'),(46,46,'','Tea Infused Sparkling Water','<p>Sparkling water combined with organic tea and single-source, certified organic extracts. No &quot;natural flavors&quot;. &nbsp;</p><p><strong>Features</strong>:</p><ul><li>Unsweetened</li><li>Certified organic</li><li>Certified non-GMO</li></ul>','<p>Tea and sparkling water: the perfect match!</p>','','Tea and sparkling water: the perfect match!','','en'),(47,47,'','Cinnamon Sticks','<h1><span style=\"font-size: 14px; color: rgb(128, 128, 128);\">Imported 100% raw from Sri Lanka.&nbsp;</span><span style=\"color: rgb(128, 128, 128); font-size: 14px;\">Perfect for baking, cooking and beverages. Hand rolled, soft and break or crumble easy.&nbsp;</span></h1><p><strong>Features</strong>:</p><ul><li>100+ sticks, packed and sealed for freshness&nbsp;</li><li>Non-GMO</li><li>Certfied organic</li><li>Kosher</li></ul>','<p>Add some spice to your life with these finest quality pure Ceylon cinnamon sticks.</p>','','Add some spice to your life with these finest quality pure Ceylon cinnamon sticks.','','en'),(48,48,'','Peanut Butter','<p>Made with just one ingredient: Dry-roasted organic peanuts.</p><ul><li>All natural&nbsp;</li><li>Non-GMO</li><li>Gluten free</li><li>Dairy free</li><li>Preservative free</li><li>Vegan</li><li>Kosher</li><li>No palm fruit oil</li><li>No added sugar</li><li>No added salt</li></ul>','<p>Delicious peanut butter, all natural and loaded with protein.</p>','','Delicious peanut butter, all natural and loaded with protein.','','en'),(49,49,'','Sweet Hazelnut and Chocolate Natural Flavouring','<p>This natural food flavouring provides a classic hazelnut chocolate flavour to your cooking and baking, and can be used with various food and drink. Works great in general cooking/baking, cakes, yogurt, cheesecake, sorbets, drinks (including beer/cider), and ice-cream.&nbsp;</p><p>Ingredients:<strong>&nbsp;</strong>Natural Flavouring, Propylene Glycol (E1518).</p><p><strong>Features</strong>:</p><ul><li>Gluten free</li><li>Dairy free</li><li>Egg free</li><li>Vegan</li><li>Kosher</li></ul>','<p><span style=\"font-size: 14px;\">Add the delicious taste of hazelnut chocolate to your cakes and other desserts using this natural food flavouring.&nbsp;</span></p>','','Add the delicious taste of hazelnut chocolate to your cakes and other desserts using this natural food flavouring.&nbsp;','','en'),(50,50,'','Dose Juice','<p>A complete array of vitamins, minerals and enzymes &ndash; all with the great taste. 60% green vegetables vs 40% fruits.&nbsp;</p><p>Features:</p><ul><li>Cold pressed</li><li>Organic</li></ul>','<p>An organic juice to sustain you throughout the day. Drink it in the morning or between meals for a boost of energy and vitamins.&nbsp;</p>','','An organic juice to sustain you throughout the day. Drink it in the morning or between meals for a boost of energy and vitamins.&nbsp;','','en');
CREATE TABLE `xlite_category_class_links` (
  `category_id` int(10) unsigned NOT NULL,
  `class_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`category_id`,`class_id`),
  KEY `IDX_3F5DB31312469DE2` (`category_id`),
  KEY `IDX_3F5DB313EA000B10` (`class_id`),
  CONSTRAINT `FK_3F5DB31312469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_3F5DB313EA000B10` FOREIGN KEY (`class_id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_products` (
  `product_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_class_id` int(10) unsigned DEFAULT NULL,
  `tax_class_id` int(10) unsigned DEFAULT NULL,
  `marketPrice` decimal(14,4) NOT NULL,
  `pinCodesEnabled` tinyint(1) NOT NULL,
  `autoPinCodes` tinyint(1) NOT NULL,
  `participateSale` tinyint(1) NOT NULL,
  `discountType` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `salePriceValue` decimal(14,4) NOT NULL,
  `csLastUpdate` int(11) NOT NULL,
  `xcPendingBulkEdit` tinyint(1) NOT NULL,
  `isCustomerAttachmentsAvailable` tinyint(1) NOT NULL,
  `isCustomerAttachmentsRequired` tinyint(1) NOT NULL,
  `facebookMarketingEnabled` tinyint(1) NOT NULL DEFAULT 1,
  `freeShip` tinyint(1) NOT NULL,
  `shipForFree` tinyint(1) NOT NULL,
  `freightFixedFee` decimal(14,4) NOT NULL,
  `googleFeedEnabled` tinyint(1) NOT NULL DEFAULT 1,
  `useCustomOG` tinyint(1) NOT NULL,
  `useAsSegmentCondition` tinyint(1) NOT NULL,
  `demo` tinyint(1) NOT NULL,
  `price` decimal(14,4) NOT NULL COMMENT '(DC2Type:money)',
  `sku` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL,
  `weight` decimal(14,4) NOT NULL,
  `useSeparateBox` tinyint(1) NOT NULL,
  `boxWidth` decimal(14,4) NOT NULL,
  `boxLength` decimal(14,4) NOT NULL,
  `boxHeight` decimal(14,4) NOT NULL,
  `itemsPerBox` int(11) NOT NULL,
  `free_shipping` tinyint(1) NOT NULL,
  `taxable` tinyint(1) NOT NULL,
  `arrivalDate` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `updateDate` int(10) unsigned NOT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `inventoryEnabled` tinyint(1) NOT NULL,
  `amount` int(10) unsigned NOT NULL,
  `lowLimitEnabledCustomer` tinyint(1) NOT NULL,
  `lowLimitEnabled` tinyint(1) NOT NULL,
  `lowLimitAmount` int(10) unsigned NOT NULL,
  `attrSepTab` tinyint(1) NOT NULL,
  `metaDescType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `sales` int(10) unsigned NOT NULL,
  `xcPendingExport` tinyint(1) NOT NULL,
  `entityVersion` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`product_id`),
  KEY `IDX_2B79045921B06187` (`product_class_id`),
  KEY `IDX_2B790459A94AAAE` (`tax_class_id`),
  KEY `sku` (`sku`),
  KEY `price` (`price`),
  KEY `weight` (`weight`),
  KEY `free_shipping` (`free_shipping`),
  KEY `customerArea` (`enabled`,`arrivalDate`),
  KEY `csLastUpdate` (`csLastUpdate`),
  CONSTRAINT `FK_2B79045921B06187` FOREIGN KEY (`product_class_id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_2B790459A94AAAE` FOREIGN KEY (`tax_class_id`) REFERENCES `xlite_tax_classes` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_products` VALUES (1,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,19.9900,'10000000065',1,0.7000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972207,0,1,1000,1,1,10,1,'A',0,0,'8e9982ab-e56f-4093-b922-9a78bde8deca'),(2,3,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,49.9900,'10000000068',1,3.0000,0,0.0000,0.0000,0.0000,1,0,1,1603108208,1603972206,1603972207,0,1,7,1,1,10,1,'A',0,0,'e5bb9edb-bbc8-491a-b33d-5dbd1d9f6030'),(3,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,19.9900,'10000000069',1,2.6000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',2,0,'be8117c6-a145-4bd1-9dc4-263493e8fdc6'),(4,3,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,24.9900,'10000000070',1,1.3000,0,0.0000,0.0000,0.0000,1,0,1,1606564208,1603972206,1603972207,0,1,75,1,1,10,1,'A',0,0,'90bdc58b-7aaf-426a-ad5c-369ce8d69eb7'),(5,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,19.9900,'10000000074',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1603108208,1603972206,1603972207,0,1,6,1,1,10,1,'A',0,0,'0d9f4765-850e-4fb0-b3dd-da21cd3cd7f3'),(6,NULL,NULL,0.0000,0,0,1,'sale_price',47.9900,0,0,0,0,1,0,0,0.0000,1,0,0,1,79.9900,'10000000076',1,2.9000,0,0.0000,0.0000,0.0000,1,0,1,1606564208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',0,0,'d029989a-4d52-4f47-af79-9d2402c74f84'),(7,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,29.9900,'10000000079',1,0.6000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972207,0,1,100,1,1,10,1,'A',0,0,'bca6b82b-a3f4-4bc4-af13-7977f6491240'),(8,NULL,NULL,0.0000,0,0,1,'sale_price',14.9900,0,0,0,0,1,0,0,0.0000,1,0,0,1,19.9900,'10000000081',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1606564208,1603972206,1603972208,0,1,146,1,1,10,1,'A',3,0,'3b9fdf9f-fa51-4704-b5a4-77d4c1a6d79b'),(9,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,19.9900,'10000000082',1,2.8000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972207,0,1,218,1,1,10,1,'A',0,0,'cfc1f9a7-b314-4c18-a7ba-d0fba819074b'),(10,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,34.9900,'10000000083',1,1.1000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972207,0,1,0,1,1,10,1,'A',0,0,'9a41a3eb-4608-41f3-9424-8cfe48ba804b'),(11,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,14.9900,'10000000084',1,0.9000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972207,0,1,200,1,1,10,1,'A',0,0,'64cee878-f115-4bf3-b579-9f493742c8bf'),(12,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,9.9900,'10000000085',1,2.9000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',6,0,'50f6e837-1dbc-4080-b466-c2791d83b86b'),(13,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,39.9900,'10000000086',1,2.8000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972207,0,1,6,1,1,10,1,'A',0,0,'5b000767-b062-43ff-863b-9cf8216084e5'),(14,1,NULL,0.0000,0,0,1,'sale_percent',15.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,29.9900,'10000000087',1,0.7000,0,0.0000,0.0000,0.0000,1,0,1,1603108208,1603972206,1603972208,0,1,22,1,1,10,1,'A',12,0,'0bb7ada2-7883-4caa-a757-57f378d14271'),(15,NULL,NULL,0.0000,0,0,1,'sale_percent',25.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,19.9900,'10000000088',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,300,1,1,10,1,'A',0,0,'dccc119d-8977-4f33-a594-0ba25dd224e5'),(16,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,99.0000,'10000000089',1,1.0000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,999,1,1,10,1,'A',1,0,'6abdc633-9f88-4eb7-b143-dcc33ea31c46'),(17,1,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,49.9900,'10000000091',1,2.1000,0,0.0000,0.0000,0.0000,1,0,1,1606564208,1603972206,1603972207,0,1,1000,1,1,10,1,'A',0,0,'c9e4c4dc-1e01-4cb5-a48f-6182ca74865b'),(18,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,19.9900,'10000000093',1,0.5000,0,0.0000,0.0000,0.0000,1,0,1,1606564208,1603972206,1603972207,0,1,1000,1,1,10,1,'A',0,0,'c75803df-88a7-480b-8c54-3a44d399009a'),(19,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,9.9900,'10000000094',1,3.0000,0,0.0000,0.0000,0.0000,1,0,1,1603108208,1603972206,1603972207,0,1,12,1,1,10,1,'A',0,0,'91e30b10-7a47-4ee0-9998-e209d2b6125c'),(20,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,9.9900,'10000000095',1,1.1000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972207,0,1,1000,1,1,10,1,'A',0,0,'5130b5a6-9549-42ab-b465-ba82e9b34018'),(21,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,29.9900,'10000000096',1,2.8000,0,0.0000,0.0000,0.0000,1,0,1,1606564208,1603972206,1603972208,0,1,200,1,1,10,1,'A',0,0,'5c7da429-fb3c-4ee6-bccb-77c036863e62'),(22,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,19.9900,'10000000097',1,1.6000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',0,0,'0adee245-9f84-4381-8f93-17076dc97e0b'),(23,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,29.9900,'10000000098',1,1.0000,0,0.0000,0.0000,0.0000,1,0,1,1606564208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',0,0,'ae41c987-4c36-4ba7-ac5b-6044691d509a'),(24,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,14.9900,'10000000099',1,2.3000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',0,0,'6aee4dbe-6803-4bd2-b612-babd96b4eb70'),(25,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,19.9900,'10000000100',1,1.3000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,4,1,1,10,1,'A',0,0,'faeed49e-b84a-40f8-b501-0f020fb2685e'),(26,NULL,NULL,0.0000,0,0,1,'sale_price',6.4900,0,0,0,0,1,0,0,0.0000,1,0,0,1,12.9900,'10000000101',1,1.3000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,20,1,1,10,1,'A',7,0,'a5a708db-8619-48eb-814b-ed2666aa892e'),(27,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,69.9900,'10000000102',1,1.4000,0,0.0000,0.0000,0.0000,1,0,1,1603108208,1603972206,1603972208,0,1,10,1,1,10,1,'A',0,0,'6c9568b8-dde7-4ddd-b77c-1e1a5eb3b0a1'),(28,2,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,850.0000,'10000000103',1,2.5000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,50,1,1,10,1,'A',0,0,'8ab4defb-9353-4222-84b5-fa4d3439707e'),(29,2,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,650.0000,'10000000104',1,1.0000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',0,0,'3d66fe50-598c-4f35-b6f8-f963d77dbca4'),(30,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,399.0000,'10000000105',1,1.1000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,999,1,1,10,1,'A',0,0,'95b1677a-a45f-46cd-be10-fd8d23879dfc'),(31,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,299.0000,'10000000106',1,1.3000,0,0.0000,0.0000,0.0000,1,0,1,1603108208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',0,0,'4be15d34-7373-4d96-95a3-91e9b6dc53db'),(32,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,79.9900,'10000000107',1,1.2000,0,0.0000,0.0000,0.0000,1,0,1,1603108208,1603972206,1603972208,0,1,10,1,1,10,1,'A',0,0,'d316da4b-6637-4f6f-a07b-39a62b9f304d'),(33,NULL,NULL,0.0000,0,0,1,'sale_price',19.9900,0,0,0,0,1,0,0,0.0000,1,0,0,1,49.9900,'10000000109',1,2.2000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,999,1,1,10,1,'A',0,0,'0e4719ac-2036-48f0-a54d-b6cf4de63d83'),(34,NULL,NULL,0.0000,0,0,1,'sale_price',44.9900,0,0,0,0,1,0,0,0.0000,1,0,0,1,59.9900,'10000000110',1,2.7000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',0,0,'1ad5022e-b007-4bd2-9c8e-d75026c8297c'),(35,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,299.9900,'10000000111',1,1.7000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,999,1,1,10,1,'A',0,0,'51712a71-29e5-475c-93f5-e24e21bf8a02'),(36,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,11.9900,'10000000112',1,2.0000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,999,1,1,10,1,'A',0,0,'ec881c80-e981-4784-be1c-fce24e04a174'),(37,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,139.9900,'10000000113',1,1.7000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',0,0,'7d1f0548-1c5e-492b-9e54-41c5187696ba'),(38,NULL,NULL,0.0000,0,0,1,'sale_price',39.9900,0,0,0,0,1,0,0,0.0000,1,0,0,1,49.9900,'10000000114',1,1.6000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,10,1,1,10,1,'A',0,0,'84ec1f4b-0fd4-4e09-9be3-f828e6e3da14'),(39,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,34.9900,'10000000115',1,1.0000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',0,0,'2ac4fdbf-42c5-432d-b81d-8ea6faa26aef'),(40,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,817.5900,'10000000116',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,6,1,1,10,1,'A',0,0,'75f3b837-6eb9-4f4b-a808-ecbb79aae496'),(41,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,199.9900,'10000000117',1,2.1000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',0,0,'371b71ad-0d75-438e-9bba-4b96f22d40b6'),(42,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,19.9900,'10000000118',1,2.6000,0,0.0000,0.0000,0.0000,1,0,1,1603108208,1603972206,1603972208,0,1,1000,1,1,10,1,'A',1,0,'0579f569-2677-4ecf-9347-d6ee4e2e7145'),(43,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,12.0000,'10000000119',1,1.7000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972207,1603972208,0,1,1000,1,1,10,1,'A',0,0,'748a5601-7e8b-42d8-a237-965939b35705'),(44,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,28.0000,'10000000122',1,1.4000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972207,1603972208,0,1,1000,1,1,10,1,'A',0,0,'60dd4ef5-aa85-4426-ad3b-11cdc3313e7b'),(45,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,83.0000,'10000000123',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972207,1603972208,0,1,1000,1,1,10,1,'A',0,0,'597e92d3-6564-4d36-bf3e-00b4763fa7f8'),(46,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,25.0000,'10000000124',1,1.3000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972207,1603972208,0,1,1000,1,1,10,1,'A',0,0,'e13e80ca-ee6d-49c7-beb1-7cb4b178e33b'),(47,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,17.0000,'10000000125',1,1.8000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972207,1603972208,0,1,1000,1,1,10,1,'A',0,0,'f120a31a-1ebb-4b5b-a2e1-9645a799ec11'),(48,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,21.0000,'10000000126',1,2.8000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972207,1603972208,0,1,1000,1,1,10,1,'A',0,0,'730c9a5e-2db7-4be8-a9a7-8b221055cb16'),(49,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,16.0000,'10000000127',1,1.4000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972207,1603972208,0,1,12,1,1,10,1,'A',0,0,'1b825681-6901-4cc0-b3d6-82c89e908b77'),(50,NULL,NULL,0.0000,0,0,0,'sale_price',0.0000,0,0,0,0,1,0,0,0.0000,1,0,0,1,22.0000,'10000000128',1,1.7000,0,0.0000,0.0000,0.0000,1,0,1,1591012208,1603972207,1603972208,0,1,23,1,1,10,1,'A',0,0,'b327a2c1-2619-48d1-b683-fd3c0522986b');
CREATE TABLE `xlite_form_ids` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `form_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fs` (`form_id`,`session_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `FK_AD266A12613FECDF` FOREIGN KEY (`session_id`) REFERENCES `xlite_sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_payment_transactions` (
  `transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `method_id` int(11) DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `date` int(11) NOT NULL,
  `publicTxnId` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `method_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `method_local_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `note` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `public_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `IDX_33CBDC008D9F6D38` (`order_id`),
  KEY `IDX_33CBDC0019883967` (`method_id`),
  KEY `IDX_33CBDC0038248176` (`currency_id`),
  KEY `status` (`status`),
  KEY `o` (`order_id`,`status`),
  KEY `pm` (`method_id`,`status`),
  KEY `publicTxnId` (`publicTxnId`),
  CONSTRAINT `FK_33CBDC0019883967` FOREIGN KEY (`method_id`) REFERENCES `xlite_payment_methods` (`method_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_33CBDC0038248176` FOREIGN KEY (`currency_id`) REFERENCES `xlite_currencies` (`currency_id`),
  CONSTRAINT `FK_33CBDC008D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_transactions` VALUES (1,1,4,840,1551771900,'000001-KGSP','MoneyOrdering','Money Order','S',110.6500,'','sale','000001-KGSP'),(2,2,4,840,1553772240,'000002-FX7B','MoneyOrdering','Money Order','S',88.6700,'','sale','000002-FX7B'),(3,3,4,840,1564729080,'000002-FX7B','MoneyOrdering','Money Order','S',158.9400,'','sale','000002-FX7B'),(4,4,NULL,840,1575162780,'000012-AS2T','SimplifyCommerceHP','Simplify Commerce Hosted Payments','F',38.0100,'Simplify_BadRequestException: \"Request data is invalid\" (status: 400, error code: validation, reference: c5a0b8b8-92ac-4908-9506-88b843ecd399)\nField error: card.number\"Card bin Country rejected by acquirer\" (country.bin.not.accepted)','sale','demostore-000012-AS2T'),(5,4,NULL,840,1575162780,'000013-3I22','SimplifyCommerceHP','Simplify Commerce Hosted Payments','F',38.0100,'Simplify_BadRequestException: \"Request data is invalid\" (status: 400, error code: validation, reference: 195c1b1a-44c8-46d4-8e48-ee4e65f271af)\nField error: card.number\"Card has expired.\" (card.expired)','sale','demostore-000013-3I22'),(6,5,4,840,1575163080,'000005-KXAQ','MoneyOrdering','Money Order','S',352.8100,'','sale','000005-KXAQ');
CREATE TABLE `xlite_tag_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_EDCE6447BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_tags` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_upselling_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `parent_product_id` int(10) unsigned DEFAULT NULL,
  `orderBy` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_1DF3D3E14584665A` (`product_id`),
  KEY `parent_product_index` (`parent_product_id`),
  CONSTRAINT `FK_1DF3D3E12C7E20A` FOREIGN KEY (`parent_product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_1DF3D3E14584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_upselling_products` VALUES (1,12,16,0),(2,16,12,0),(3,13,16,0),(4,16,13,0),(5,14,16,0),(6,16,14,0),(7,17,16,0),(8,16,17,0),(9,13,12,0),(10,12,13,0),(11,14,12,0),(12,12,14,0),(13,17,12,0),(14,12,17,0),(15,14,13,0),(16,13,14,0),(17,17,13,0),(18,13,17,0),(19,14,17,0),(20,17,14,0),(27,28,41,0),(29,30,41,0),(31,39,41,0),(33,40,37,0),(35,40,41,0),(37,28,37,0),(39,30,37,0),(41,39,37,0),(43,28,42,0),(45,30,42,0),(47,39,42,0),(49,40,42,0),(50,43,25,0),(51,42,25,0),(52,50,25,0),(53,46,25,0),(54,49,25,0);
CREATE TABLE `xlite_regions` (
  `code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `country_code` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `weight` int(11) DEFAULT NULL,
  PRIMARY KEY (`code`),
  UNIQUE KEY `code` (`code`,`country_code`),
  KEY `IDX_B319C6B1F026BB7C` (`country_code`),
  KEY `name` (`name`),
  CONSTRAINT `FK_B319C6B1F026BB7C` FOREIGN KEY (`country_code`) REFERENCES `xlite_countries` (`code`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_regions` VALUES ('GB-ENG','GB','England',100),('GB-NIR','GB','Northern Ireland',400),('GB-SCT','GB','Scotland',200),('GB-WLS','GB','Wales',300);
CREATE TABLE `xlite_payment_methods` (
  `method_id` int(11) NOT NULL AUTO_INCREMENT,
  `service_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `moduleName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `orderby` int(11) NOT NULL,
  `adminOrderby` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `added` tinyint(1) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `fromMarketplace` tinyint(1) NOT NULL,
  `iconURL` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `countries` longtext COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:array)',
  `exCountries` longtext COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`method_id`),
  KEY `orderby` (`orderby`),
  KEY `class` (`class`,`enabled`),
  KEY `enabled` (`enabled`),
  KEY `serviceName` (`service_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_methods` VALUES (1,'PurchaseOrder','Model\\Payment\\Processor\\PurchaseOrder','',20,0,0,1,'O',0,NULL,'N;','N;'),(2,'PhoneOrdering','Model\\Payment\\Processor\\PhoneOrdering','',30,0,1,1,'O',0,NULL,'N;','N;'),(3,'FaxOrdering','Model\\Payment\\Processor\\Offline','',40,0,1,1,'O',0,NULL,'N;','N;'),(4,'MoneyOrdering','Model\\Payment\\Processor\\Offline','',50,0,1,1,'O',0,NULL,'N;','N;'),(5,'Echeck','Model\\Payment\\Processor\\Check','',60,0,0,1,'O',0,NULL,'N;','N;'),(6,'COD','Model\\Payment\\Processor\\Offline','',70,0,1,1,'O',0,NULL,'N;','N;'),(7,'PayWithAmazon','Module\\Amazon\\PayWithAmazon\\Model\\Payment\\Processor\\PayWithAmazon','Amazon_PayWithAmazon',-101600,-101600,0,0,'C',0,NULL,'a:35:{i:0;s:2:\"US\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"BG\";i:4;s:2:\"CH\";i:5;s:2:\"CY\";i:6;s:2:\"CZ\";i:7;s:2:\"DE\";i:8;s:2:\"DK\";i:9;s:2:\"EE\";i:10;s:2:\"ES\";i:11;s:2:\"FI\";i:12;s:2:\"FR\";i:13;s:2:\"GB\";i:14;s:2:\"GR\";i:15;s:2:\"HR\";i:16;s:2:\"HU\";i:17;s:2:\"IE\";i:18;s:2:\"IS\";i:19;s:2:\"IT\";i:20;s:2:\"LI\";i:21;s:2:\"LT\";i:22;s:2:\"LU\";i:23;s:2:\"LV\";i:24;s:2:\"MC\";i:25;s:2:\"MT\";i:26;s:2:\"NL\";i:27;s:2:\"NO\";i:28;s:2:\"PL\";i:29;s:2:\"PT\";i:30;s:2:\"RO\";i:31;s:2:\"SE\";i:32;s:2:\"SI\";i:33;s:2:\"SK\";i:34;s:2:\"SM\";}','N;'),(8,'AuthorizeNet SIM','Module\\CDev\\AuthorizeNet\\Model\\Payment\\Processor\\AuthorizeNetSIM','CDev_AuthorizeNet',-101000,0,0,0,'C',0,NULL,'a:36:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";i:3;s:2:\"GB\";i:4;s:2:\"AD\";i:5;s:2:\"AT\";i:6;s:2:\"BE\";i:7;s:2:\"BG\";i:8;s:2:\"CY\";i:9;s:2:\"CZ\";i:10;s:2:\"DK\";i:11;s:2:\"FI\";i:12;s:2:\"FR\";i:13;s:2:\"DE\";i:14;s:2:\"GI\";i:15;s:2:\"GR\";i:16;s:2:\"HU\";i:17;s:2:\"IE\";i:18;s:2:\"IT\";i:19;s:2:\"LI\";i:20;s:2:\"LU\";i:21;s:2:\"MT\";i:22;s:2:\"MC\";i:23;s:2:\"NL\";i:24;s:2:\"NO\";i:25;s:2:\"PL\";i:26;s:2:\"PT\";i:27;s:2:\"RO\";i:28;s:2:\"SE\";i:29;s:2:\"SI\";i:30;s:2:\"SK\";i:31;s:2:\"SM\";i:32;s:2:\"CH\";i:33;s:2:\"ES\";i:34;s:2:\"VA\";i:35;s:2:\"TR\";}','N;'),(9,'COD_FEDEX','Module\\CDev\\FedEx\\Model\\Payment\\Processor\\COD','CDev_FedEx',0,0,0,1,'O',0,NULL,'a:2:{i:0;s:2:\"CA\";i:1;s:2:\"US\";}','N;'),(10,'PayflowLink','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PayflowLink','CDev_Paypal',-10600,0,0,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";i:3;s:2:\"NZ\";}','N;'),(11,'PayflowTransparentRedirect','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PayflowTransparentRedirect','CDev_Paypal',-10650,0,0,0,'C',0,NULL,'a:4:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";i:3;s:2:\"NZ\";}','N;'),(12,'PaypalAdvanced','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalAdvanced','CDev_Paypal',-10700,0,0,0,'C',0,NULL,'a:2:{i:0;s:2:\"US\";i:1;s:2:\"CA\";}','N;'),(13,'PaypalWPS','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalWPS','CDev_Paypal',-10800,0,0,0,'A',0,NULL,'a:200:{i:0;s:2:\"AD\";i:1;s:2:\"AE\";i:2;s:2:\"AG\";i:3;s:2:\"AI\";i:4;s:2:\"AL\";i:5;s:2:\"AM\";i:6;s:2:\"AO\";i:7;s:2:\"AR\";i:8;s:2:\"AT\";i:9;s:2:\"AU\";i:10;s:2:\"AW\";i:11;s:2:\"AZ\";i:12;s:2:\"BA\";i:13;s:2:\"BB\";i:14;s:2:\"BE\";i:15;s:2:\"BF\";i:16;s:2:\"BG\";i:17;s:2:\"BH\";i:18;s:2:\"BI\";i:19;s:2:\"BJ\";i:20;s:2:\"BM\";i:21;s:2:\"BN\";i:22;s:2:\"BO\";i:23;s:2:\"BR\";i:24;s:2:\"BS\";i:25;s:2:\"BT\";i:26;s:2:\"BW\";i:27;s:2:\"BY\";i:28;s:2:\"BZ\";i:29;s:2:\"CA\";i:30;s:2:\"CD\";i:31;s:2:\"CH\";i:32;s:2:\"CI\";i:33;s:2:\"CK\";i:34;s:2:\"CL\";i:35;s:2:\"CM\";i:36;s:2:\"CN\";i:37;s:2:\"CO\";i:38;s:2:\"CR\";i:39;s:2:\"CV\";i:40;s:2:\"CY\";i:41;s:2:\"CZ\";i:42;s:2:\"DE\";i:43;s:2:\"DJ\";i:44;s:2:\"DK\";i:45;s:2:\"DM\";i:46;s:2:\"DO\";i:47;s:2:\"DZ\";i:48;s:2:\"EC\";i:49;s:2:\"EE\";i:50;s:2:\"EG\";i:51;s:2:\"ER\";i:52;s:2:\"ES\";i:53;s:2:\"ET\";i:54;s:2:\"FI\";i:55;s:2:\"FJ\";i:56;s:2:\"FK\";i:57;s:2:\"FM\";i:58;s:2:\"FO\";i:59;s:2:\"FR\";i:60;s:2:\"GA\";i:61;s:2:\"GB\";i:62;s:2:\"GD\";i:63;s:2:\"GE\";i:64;s:2:\"GF\";i:65;s:2:\"GI\";i:66;s:2:\"GL\";i:67;s:2:\"GM\";i:68;s:2:\"GN\";i:69;s:2:\"GP\";i:70;s:2:\"GR\";i:71;s:2:\"GT\";i:72;s:2:\"GW\";i:73;s:2:\"GY\";i:74;s:2:\"HK\";i:75;s:2:\"HN\";i:76;s:2:\"HR\";i:77;s:2:\"HU\";i:78;s:2:\"ID\";i:79;s:2:\"IE\";i:80;s:2:\"IL\";i:81;s:2:\"IN\";i:82;s:2:\"IS\";i:83;s:2:\"IT\";i:84;s:2:\"JM\";i:85;s:2:\"JO\";i:86;s:2:\"JP\";i:87;s:2:\"KE\";i:88;s:2:\"KG\";i:89;s:2:\"KH\";i:90;s:2:\"KI\";i:91;s:2:\"KM\";i:92;s:2:\"KN\";i:93;s:2:\"KR\";i:94;s:2:\"KW\";i:95;s:2:\"KY\";i:96;s:2:\"KZ\";i:97;s:2:\"LA\";i:98;s:2:\"LC\";i:99;s:2:\"LI\";i:100;s:2:\"LK\";i:101;s:2:\"LS\";i:102;s:2:\"LT\";i:103;s:2:\"LU\";i:104;s:2:\"LV\";i:105;s:2:\"MA\";i:106;s:2:\"MC\";i:107;s:2:\"MD\";i:108;s:2:\"ME\";i:109;s:2:\"MG\";i:110;s:2:\"MH\";i:111;s:2:\"MK\";i:112;s:2:\"ML\";i:113;s:2:\"MN\";i:114;s:2:\"MQ\";i:115;s:2:\"MR\";i:116;s:2:\"MS\";i:117;s:2:\"MT\";i:118;s:2:\"MU\";i:119;s:2:\"MV\";i:120;s:2:\"MW\";i:121;s:2:\"MX\";i:122;s:2:\"MY\";i:123;s:2:\"MZ\";i:124;s:2:\"NA\";i:125;s:2:\"NC\";i:126;s:2:\"NE\";i:127;s:2:\"NF\";i:128;s:2:\"NG\";i:129;s:2:\"NI\";i:130;s:2:\"NL\";i:131;s:2:\"NO\";i:132;s:2:\"NP\";i:133;s:2:\"NR\";i:134;s:2:\"NU\";i:135;s:2:\"NZ\";i:136;s:2:\"OM\";i:137;s:2:\"PA\";i:138;s:2:\"PE\";i:139;s:2:\"PF\";i:140;s:2:\"PG\";i:141;s:2:\"PH\";i:142;s:2:\"PL\";i:143;s:2:\"PM\";i:144;s:2:\"PN\";i:145;s:2:\"PT\";i:146;s:2:\"PW\";i:147;s:2:\"PY\";i:148;s:2:\"QA\";i:149;s:2:\"RE\";i:150;s:2:\"RO\";i:151;s:2:\"RS\";i:152;s:2:\"RU\";i:153;s:2:\"RW\";i:154;s:2:\"SA\";i:155;s:2:\"SB\";i:156;s:2:\"SC\";i:157;s:2:\"SE\";i:158;s:2:\"SG\";i:159;s:2:\"SH\";i:160;s:2:\"SI\";i:161;s:2:\"SJ\";i:162;s:2:\"SK\";i:163;s:2:\"SL\";i:164;s:2:\"SM\";i:165;s:2:\"SN\";i:166;s:2:\"SO\";i:167;s:2:\"SR\";i:168;s:2:\"ST\";i:169;s:2:\"SV\";i:170;s:2:\"SZ\";i:171;s:2:\"TC\";i:172;s:2:\"TD\";i:173;s:2:\"TG\";i:174;s:2:\"TH\";i:175;s:2:\"TJ\";i:176;s:2:\"TM\";i:177;s:2:\"TN\";i:178;s:2:\"TO\";i:179;s:2:\"TT\";i:180;s:2:\"TV\";i:181;s:2:\"TW\";i:182;s:2:\"TZ\";i:183;s:2:\"UA\";i:184;s:2:\"UG\";i:185;s:2:\"US\";i:186;s:2:\"UY\";i:187;s:2:\"VA\";i:188;s:2:\"VC\";i:189;s:2:\"VE\";i:190;s:2:\"VG\";i:191;s:2:\"VN\";i:192;s:2:\"VU\";i:193;s:2:\"WF\";i:194;s:2:\"WS\";i:195;s:2:\"YE\";i:196;s:2:\"YT\";i:197;s:2:\"ZA\";i:198;s:2:\"ZM\";i:199;s:2:\"ZW\";}','N;'),(14,'ExpressCheckout','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\ExpressCheckout','CDev_Paypal',-102000,0,0,0,'C',0,NULL,'a:23:{i:0;s:2:\"US\";i:1;s:2:\"MX\";i:2;s:2:\"BE\";i:3;s:2:\"DK\";i:4;s:2:\"FR\";i:5;s:2:\"DE\";i:6;s:2:\"IE\";i:7;s:2:\"IT\";i:8;s:2:\"LU\";i:9;s:2:\"NL\";i:10;s:2:\"NO\";i:11;s:2:\"PL\";i:12;s:2:\"RU\";i:13;s:2:\"ES\";i:14;s:2:\"NZ\";i:15;s:2:\"SE\";i:16;s:2:\"GB\";i:17;s:2:\"AU\";i:18;s:2:\"CN\";i:19;s:2:\"IL\";i:20;s:2:\"SG\";i:21;s:2:\"BR\";i:22;s:2:\"JP\";}','N;'),(15,'PaypalCredit','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalCredit','CDev_Paypal',-11000,0,0,1,'C',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(16,'PaypalAdaptive','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalAdaptive','CDev_Paypal',-11100,0,0,0,'C',0,NULL,'N;','N;'),(17,'PaypalForMarketplaces','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalForMarketplaces','CDev_Paypal',-11100,0,0,0,'C',0,NULL,'a:27:{i:0;s:2:\"AT\";i:1;s:2:\"AU\";i:2;s:2:\"BE\";i:3;s:2:\"CA\";i:4;s:2:\"CH\";i:5;s:2:\"CZ\";i:6;s:2:\"DE\";i:7;s:2:\"DK\";i:8;s:2:\"ES\";i:9;s:2:\"FI\";i:10;s:2:\"FR\";i:11;s:2:\"GB\";i:12;s:2:\"GB\";i:13;s:2:\"GR\";i:14;s:2:\"HU\";i:15;s:2:\"IE\";i:16;s:2:\"IL\";i:17;s:2:\"IN\";i:18;s:2:\"IT\";i:19;s:2:\"NL\";i:20;s:2:\"NO\";i:21;s:2:\"PL\";i:22;s:2:\"PT\";i:23;s:2:\"RU\";i:24;s:2:\"SE\";i:25;s:2:\"SK\";i:26;s:2:\"US\";}','N;'),(18,'PaypalCommercePlatform','Module\\CDev\\Paypal\\Model\\Payment\\Processor\\PaypalCommercePlatform','CDev_Paypal',-103000,-106000,0,1,'C',0,NULL,'a:27:{i:0;s:2:\"AT\";i:1;s:2:\"AU\";i:2;s:2:\"BE\";i:3;s:2:\"CA\";i:4;s:2:\"CH\";i:5;s:2:\"CZ\";i:6;s:2:\"DE\";i:7;s:2:\"DK\";i:8;s:2:\"ES\";i:9;s:2:\"FI\";i:10;s:2:\"FR\";i:11;s:2:\"GB\";i:12;s:2:\"GB\";i:13;s:2:\"GR\";i:14;s:2:\"HU\";i:15;s:2:\"IE\";i:16;s:2:\"IL\";i:17;s:2:\"IN\";i:18;s:2:\"IT\";i:19;s:2:\"NL\";i:20;s:2:\"NO\";i:21;s:2:\"PL\";i:22;s:2:\"PT\";i:23;s:2:\"RU\";i:24;s:2:\"SE\";i:25;s:2:\"SK\";i:26;s:2:\"US\";}','N;'),(19,'QuantumGateway','Module\\CDev\\Quantum\\Model\\Payment\\Processor\\Quantum','CDev_Quantum',-10000,0,0,0,'C',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(20,'2Checkout.com','Module\\CDev\\TwoCheckout\\Model\\Payment\\Processor\\TwoCheckout','CDev_TwoCheckout',-10500,0,0,0,'C',0,NULL,'a:237:{i:0;s:2:\"AD\";i:1;s:2:\"AE\";i:2;s:2:\"AF\";i:3;s:2:\"AG\";i:4;s:2:\"AI\";i:5;s:2:\"AL\";i:6;s:2:\"AM\";i:7;s:2:\"AO\";i:8;s:2:\"AR\";i:9;s:2:\"AS\";i:10;s:2:\"AT\";i:11;s:2:\"AU\";i:12;s:2:\"AW\";i:13;s:2:\"AZ\";i:14;s:2:\"BA\";i:15;s:2:\"BB\";i:16;s:2:\"BD\";i:17;s:2:\"BE\";i:18;s:2:\"BF\";i:19;s:2:\"BG\";i:20;s:2:\"BH\";i:21;s:2:\"BI\";i:22;s:2:\"BJ\";i:23;s:2:\"BM\";i:24;s:2:\"BN\";i:25;s:2:\"BO\";i:26;s:2:\"BQ\";i:27;s:2:\"BR\";i:28;s:2:\"BS\";i:29;s:2:\"BT\";i:30;s:2:\"BV\";i:31;s:2:\"BW\";i:32;s:2:\"BY\";i:33;s:2:\"BZ\";i:34;s:2:\"CA\";i:35;s:2:\"CC\";i:36;s:2:\"CD\";i:37;s:2:\"CF\";i:38;s:2:\"CH\";i:39;s:2:\"CK\";i:40;s:2:\"CL\";i:41;s:2:\"CM\";i:42;s:2:\"CN\";i:43;s:2:\"CO\";i:44;s:2:\"CR\";i:45;s:2:\"CV\";i:46;s:2:\"CW\";i:47;s:2:\"CX\";i:48;s:2:\"CY\";i:49;s:2:\"CZ\";i:50;s:2:\"DE\";i:51;s:2:\"DJ\";i:52;s:2:\"DK\";i:53;s:2:\"DM\";i:54;s:2:\"DO\";i:55;s:2:\"DZ\";i:56;s:2:\"EC\";i:57;s:2:\"EE\";i:58;s:2:\"EG\";i:59;s:2:\"EH\";i:60;s:2:\"ER\";i:61;s:2:\"ES\";i:62;s:2:\"ET\";i:63;s:2:\"FI\";i:64;s:2:\"FJ\";i:65;s:2:\"FK\";i:66;s:2:\"FM\";i:67;s:2:\"FO\";i:68;s:2:\"FR\";i:69;s:2:\"GA\";i:70;s:2:\"GB\";i:71;s:2:\"GD\";i:72;s:2:\"GE\";i:73;s:2:\"GF\";i:74;s:2:\"GG\";i:75;s:2:\"GH\";i:76;s:2:\"GI\";i:77;s:2:\"GL\";i:78;s:2:\"GM\";i:79;s:2:\"GN\";i:80;s:2:\"GP\";i:81;s:2:\"GQ\";i:82;s:2:\"GR\";i:83;s:2:\"GS\";i:84;s:2:\"GT\";i:85;s:2:\"GU\";i:86;s:2:\"GW\";i:87;s:2:\"GY\";i:88;s:2:\"HK\";i:89;s:2:\"HM\";i:90;s:2:\"HN\";i:91;s:2:\"HR\";i:92;s:2:\"HT\";i:93;s:2:\"HU\";i:94;s:2:\"ID\";i:95;s:2:\"IE\";i:96;s:2:\"IL\";i:97;s:2:\"IM\";i:98;s:2:\"IN\";i:99;s:2:\"IO\";i:100;s:2:\"IS\";i:101;s:2:\"IT\";i:102;s:2:\"JE\";i:103;s:2:\"JM\";i:104;s:2:\"JO\";i:105;s:2:\"JP\";i:106;s:2:\"KE\";i:107;s:2:\"KG\";i:108;s:2:\"KH\";i:109;s:2:\"KI\";i:110;s:2:\"KM\";i:111;s:2:\"KN\";i:112;s:2:\"KR\";i:113;s:2:\"KW\";i:114;s:2:\"KY\";i:115;s:2:\"KZ\";i:116;s:2:\"LA\";i:117;s:2:\"LB\";i:118;s:2:\"LC\";i:119;s:2:\"LI\";i:120;s:2:\"LK\";i:121;s:2:\"LR\";i:122;s:2:\"LS\";i:123;s:2:\"LT\";i:124;s:2:\"LU\";i:125;s:2:\"LV\";i:126;s:2:\"MA\";i:127;s:2:\"MC\";i:128;s:2:\"MD\";i:129;s:2:\"ME\";i:130;s:2:\"MF\";i:131;s:2:\"MG\";i:132;s:2:\"MH\";i:133;s:2:\"MK\";i:134;s:2:\"ML\";i:135;s:2:\"MN\";i:136;s:2:\"MO\";i:137;s:2:\"MP\";i:138;s:2:\"MQ\";i:139;s:2:\"MR\";i:140;s:2:\"MS\";i:141;s:2:\"MT\";i:142;s:2:\"MU\";i:143;s:2:\"MV\";i:144;s:2:\"MW\";i:145;s:2:\"MX\";i:146;s:2:\"MY\";i:147;s:2:\"MZ\";i:148;s:2:\"NA\";i:149;s:2:\"NC\";i:150;s:2:\"NE\";i:151;s:2:\"NF\";i:152;s:2:\"NG\";i:153;s:2:\"NI\";i:154;s:2:\"NL\";i:155;s:2:\"NO\";i:156;s:2:\"NP\";i:157;s:2:\"NR\";i:158;s:2:\"NU\";i:159;s:2:\"NZ\";i:160;s:2:\"OM\";i:161;s:2:\"PA\";i:162;s:2:\"PE\";i:163;s:2:\"PF\";i:164;s:2:\"PG\";i:165;s:2:\"PH\";i:166;s:2:\"PK\";i:167;s:2:\"PL\";i:168;s:2:\"PM\";i:169;s:2:\"PN\";i:170;s:2:\"PR\";i:171;s:2:\"PS\";i:172;s:2:\"PT\";i:173;s:2:\"PW\";i:174;s:2:\"PY\";i:175;s:2:\"QA\";i:176;s:2:\"RE\";i:177;s:2:\"RO\";i:178;s:2:\"RS\";i:179;s:2:\"RU\";i:180;s:2:\"RW\";i:181;s:2:\"SA\";i:182;s:2:\"SB\";i:183;s:2:\"SC\";i:184;s:2:\"SE\";i:185;s:2:\"SG\";i:186;s:2:\"SH\";i:187;s:2:\"SI\";i:188;s:2:\"SJ\";i:189;s:2:\"SK\";i:190;s:2:\"SL\";i:191;s:2:\"SM\";i:192;s:2:\"SN\";i:193;s:2:\"SO\";i:194;s:2:\"SR\";i:195;s:2:\"ST\";i:196;s:2:\"SV\";i:197;s:2:\"SX\";i:198;s:2:\"SZ\";i:199;s:2:\"TC\";i:200;s:2:\"TD\";i:201;s:2:\"TF\";i:202;s:2:\"TG\";i:203;s:2:\"TH\";i:204;s:2:\"TJ\";i:205;s:2:\"TK\";i:206;s:2:\"TL\";i:207;s:2:\"TM\";i:208;s:2:\"TN\";i:209;s:2:\"TO\";i:210;s:2:\"TR\";i:211;s:2:\"TT\";i:212;s:2:\"TV\";i:213;s:2:\"TW\";i:214;s:2:\"TZ\";i:215;s:2:\"UA\";i:216;s:2:\"UG\";i:217;s:2:\"UM\";i:218;s:2:\"US\";i:219;s:2:\"UY\";i:220;s:2:\"UZ\";i:221;s:2:\"VA\";i:222;s:2:\"VC\";i:223;s:2:\"VE\";i:224;s:2:\"VG\";i:225;s:2:\"VI\";i:226;s:2:\"VN\";i:227;s:2:\"VU\";i:228;s:2:\"WF\";i:229;s:2:\"WS\";i:230;s:2:\"XA\";i:231;s:2:\"XK\";i:232;s:2:\"YE\";i:233;s:2:\"YT\";i:234;s:2:\"ZA\";i:235;s:2:\"ZM\";i:236;s:2:\"ZW\";}','N;'),(21,'COD_USPS','Module\\CDev\\USPS\\Model\\Payment\\Processor\\COD','CDev_USPS',0,0,0,1,'O',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(22,'AuthorizenetAcceptjs','Module\\QSL\\AuthorizenetAcceptjs\\Model\\Payment\\Processor\\AuthorizenetAcceptjs','QSL_AuthorizenetAcceptjs',-101800,-101800,0,1,'C',0,NULL,'a:1:{i:0;s:2:\"US\";}','N;'),(23,'PayPal powered by Braintree','Module\\QSL\\BraintreeVZ\\Model\\Payment\\Processor\\BraintreeVZ','QSL_BraintreeVZ',-101950,-101950,0,0,'A',0,NULL,'a:5:{i:0;s:2:\"US\";i:1;s:2:\"UK\";i:2;s:2:\"FR\";i:3;s:2:\"IT\";i:4;s:2:\"ES\";}','N;'),(24,'ePDQ e-Commerce','Module\\XC\\EPDQ\\Model\\Payment\\Processor\\EPDQ','XC_EPDQ',-10200,0,0,0,'C',0,NULL,'a:1:{i:0;s:2:\"GB\";}','N;'),(25,'Moneris (eSELECTplus- Hosted Pay Page)','Module\\XC\\ESelectHPP\\Model\\Payment\\Processor\\ESelectHPP','XC_ESelectHPP',0,0,0,0,'C',0,NULL,'a:2:{i:0;s:2:\"CA\";i:1;s:2:\"US\";}','N;'),(26,'iDEAL Professional','Module\\XC\\IdealPayments\\Model\\Payment\\Processor\\IdealProfessional','XC_IdealPayments',-10100,0,0,0,'C',0,NULL,'a:9:{i:0;s:2:\"NL\";i:1;s:2:\"DE\";i:2;s:2:\"GB\";i:3;s:2:\"FR\";i:4;s:2:\"BE\";i:5;s:2:\"MT\";i:6;s:2:\"BG\";i:7;s:2:\"LU\";i:8;s:2:\"SE\";}','N;'),(27,'Opayo form protocol','Module\\XC\\SagePay\\Model\\Payment\\Processor\\SagePayForm','XC_SagePay',-101500,0,0,0,'C',0,NULL,'a:5:{i:0;s:2:\"DE\";i:1;s:2:\"ES\";i:2;s:2:\"GB\";i:3;s:2:\"IE\";i:4;s:2:\"US\";}','N;'),(28,'Stripe','Module\\XC\\Stripe\\Model\\Payment\\Stripe','XC_Stripe',-10300,0,0,0,'C',0,NULL,'a:34:{i:0;s:2:\"AT\";i:1;s:2:\"AU\";i:2;s:2:\"BE\";i:3;s:2:\"BR\";i:4;s:2:\"CA\";i:5;s:2:\"CH\";i:6;s:2:\"DE\";i:7;s:2:\"DK\";i:8;s:2:\"EE\";i:9;s:2:\"ES\";i:10;s:2:\"FI\";i:11;s:2:\"FR\";i:12;s:2:\"GB\";i:13;s:2:\"GR\";i:14;s:2:\"HK\";i:15;s:2:\"IE\";i:16;s:2:\"IN\";i:17;s:2:\"IT\";i:18;s:2:\"JP\";i:19;s:2:\"LT\";i:20;s:2:\"LU\";i:21;s:2:\"LV\";i:22;s:2:\"MX\";i:23;s:2:\"MY\";i:24;s:2:\"NL\";i:25;s:2:\"NO\";i:26;s:2:\"NZ\";i:27;s:2:\"PL\";i:28;s:2:\"PT\";i:29;s:2:\"SE\";i:30;s:2:\"SG\";i:31;s:2:\"SI\";i:32;s:2:\"SK\";i:33;s:2:\"US\";}','N;'),(29,'StripeApplePay','Module\\XC\\Stripe\\StripeApplePay\\Model\\Payment\\StripeApplePay','XC_Stripe',-10299,0,0,0,'C',0,NULL,'a:34:{i:0;s:2:\"AT\";i:1;s:2:\"AU\";i:2;s:2:\"BE\";i:3;s:2:\"BR\";i:4;s:2:\"CA\";i:5;s:2:\"CH\";i:6;s:2:\"DE\";i:7;s:2:\"DK\";i:8;s:2:\"EE\";i:9;s:2:\"ES\";i:10;s:2:\"FI\";i:11;s:2:\"FR\";i:12;s:2:\"GB\";i:13;s:2:\"GR\";i:14;s:2:\"HK\";i:15;s:2:\"IE\";i:16;s:2:\"IN\";i:17;s:2:\"IT\";i:18;s:2:\"JP\";i:19;s:2:\"LT\";i:20;s:2:\"LU\";i:21;s:2:\"LV\";i:22;s:2:\"MX\";i:23;s:2:\"MY\";i:24;s:2:\"NL\";i:25;s:2:\"NO\";i:26;s:2:\"NZ\";i:27;s:2:\"PL\";i:28;s:2:\"PT\";i:29;s:2:\"SE\";i:30;s:2:\"SG\";i:31;s:2:\"SI\";i:32;s:2:\"SK\";i:33;s:2:\"US\";}','N;'),(30,'COD_UPS','Module\\XC\\UPS\\Model\\Payment\\Processor\\COD','XC_UPS',0,0,0,1,'O',0,NULL,'a:2:{i:0;s:2:\"US\";i:1;s:2:\"PR\";}','N;'),(31,'XPaymentsApplePay','Module\\XPay\\XPaymentsCloud\\Model\\Payment\\Processor\\ApplePay','XPay_XPaymentsCloud',0,0,1,1,'C',0,NULL,'N;','N;'),(32,'XPaymentsCloud','Module\\XPay\\XPaymentsCloud\\Model\\Payment\\Processor\\XPaymentsCloud','XPay_XPaymentsCloud',0,0,0,1,'C',0,NULL,'N;','N;');
CREATE TABLE `xlite_global_product_tab_provider` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tab_id` int(10) unsigned DEFAULT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_5120A7CB8D0C9323` (`tab_id`),
  CONSTRAINT `FK_5120A7CB8D0C9323` FOREIGN KEY (`tab_id`) REFERENCES `xlite_global_product_tabs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_global_product_tab_provider` VALUES (1,1,'Core'),(2,2,'Core'),(3,3,'CDev-GoSocial'),(4,4,'XC-Reviews'),(5,5,'Core'),(6,6,'Core'),(7,7,'Core');
CREATE TABLE `xlite_xpayments_subscriptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Unique id',
  `calculateShipping` tinyint(1) NOT NULL,
  `shippingId` int(11) NOT NULL,
  `xpaymentsSubscriptionPublicId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `status` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `failedAttempts` int(11) DEFAULT NULL,
  `successfulAttempts` int(11) DEFAULT NULL,
  `startDate` int(11) DEFAULT NULL,
  `plannedDate` int(11) DEFAULT NULL,
  `actualDate` int(11) DEFAULT NULL,
  `cardId` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fee` decimal(14,4) NOT NULL COMMENT 'Fee for the plan(DC2Type:money)',
  `type` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `number` int(11) DEFAULT NULL,
  `period` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `reverse` tinyint(1) NOT NULL,
  `periods` int(11) DEFAULT NULL,
  `initialOrderItem` int(11) DEFAULT NULL,
  `shippingAddress` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_68417AC3C59142C9` (`initialOrderItem`),
  KEY `IDX_68417AC3109A74D1` (`shippingAddress`),
  CONSTRAINT `FK_68417AC3109A74D1` FOREIGN KEY (`shippingAddress`) REFERENCES `xlite_profile_addresses` (`address_id`),
  CONSTRAINT `FK_68417AC3C59142C9` FOREIGN KEY (`initialOrderItem`) REFERENCES `xlite_order_items` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_measures` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` int(10) unsigned NOT NULL,
  `fsTime` int(10) unsigned NOT NULL,
  `dbTime` int(10) unsigned NOT NULL,
  `cpuTime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_event_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `arguments` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_attachment_storages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` int(10) unsigned DEFAULT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_34701892464E68B` (`attachment_id`),
  CONSTRAINT `FK_34701892464E68B` FOREIGN KEY (`attachment_id`) REFERENCES `xlite_product_attachments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_group_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_8C43909EBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_group_translations` VALUES (1,1,'Display','en'),(2,2,'Cellular and Wireless','en'),(3,3,'Power and Battery','en'),(4,1,'Дисплей','ru'),(5,2,'Сотовая и беспроводняа связь','ru'),(6,3,'Батарея','ru');
CREATE TABLE `xlite_banner_rotation_image` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `banner_rotation_slide_id` int(10) unsigned DEFAULT NULL,
  `alt` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_BDC50932217A8232` (`banner_rotation_slide_id`),
  CONSTRAINT `FK_BDC50932217A8232` FOREIGN KEY (`banner_rotation_slide_id`) REFERENCES `xlite_banner_rotation_slide` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_banner_rotation_image` VALUES (1,1,'',3840,884,NULL,1,'1_2cosmentic_big.jpg','','image/jpeg','r',328874,1560755009),(2,2,'',3840,884,NULL,1,'1_1food_big_1.jpg','','image/jpeg','r',122740,1560757732),(3,3,'',3840,884,NULL,1,'1_4smart_big.jpg','','image/jpeg','r',122740,1560950874),(4,4,'',3840,884,NULL,1,'1_5fashion_1.jpg','','image/jpeg`','r',324727,1560865514);
CREATE TABLE `xlite_role_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `IDX_94D50124FED90CCA` (`permission_id`),
  KEY `IDX_94D50124D60322AC` (`role_id`),
  CONSTRAINT `FK_94D50124D60322AC` FOREIGN KEY (`role_id`) REFERENCES `xlite_roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_94D50124FED90CCA` FOREIGN KEY (`permission_id`) REFERENCES `xlite_permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_role_permissions` VALUES (1,1),(11,2),(12,3),(13,4),(14,4),(15,5);
CREATE TABLE `xlite_address_field_translation` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_430F4FF2BF396750` (`id`),
  CONSTRAINT `FK_430F4FF2BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_address_field` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_address_field_translation` VALUES (1,1,'Title','en'),(2,2,'First name','en'),(3,3,'Last name','en'),(4,4,'Address','en'),(5,5,'City','en'),(6,6,'Country','en'),(7,7,'State','en'),(8,8,'State','en'),(9,9,'Zip code','en'),(10,10,'Phone','en'),(11,11,'Address type','en');
CREATE TABLE `xlite_iframe_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `method` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `triggerTime` int(11) NOT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_tasks` VALUES (1,'XLite\\Core\\Task\\EventListener',0,'a:0:{}'),(2,'XLite\\Core\\Task\\OrdersGarbageCleaner',0,'a:0:{}'),(3,'XLite\\Core\\Task\\JobQueueCronRunner',0,'a:0:{}'),(4,'XLite\\Core\\Task\\SessionsGarbageCleaner',0,'a:0:{}'),(5,'XLite\\Core\\Task\\DataCacheGarbageCleaner',0,'a:0:{}'),(6,'XLite\\Module\\CDev\\XMLSitemap\\Core\\Task\\GenerateSitemap',0,'a:0:{}'),(7,'XLite\\Module\\XC\\FacebookMarketing\\Core\\Task\\GenerateProductFeed',0,'a:0:{}'),(8,'XLite\\Module\\XC\\GoogleFeed\\Core\\Task\\FeedUpdater',0,'a:0:{}'),(9,'XLite\\Module\\XC\\MailChimp\\Core\\Task\\UpdateLists',0,'a:0:{}'),(10,'XLite\\Module\\XC\\Reviews\\Core\\Task\\SendReviewKeys',0,'a:0:{}');
CREATE TABLE `xlite_money_modificators` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `modificator` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `validator` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  `behavior` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `purpose` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_money_modificators` VALUES (1,'XLite\\Logic\\AttributeSurcharge','modifyMoney','isApply',10,'','net'),(2,'XLite\\Module\\CDev\\Sale\\Logic\\SalePrice','modifyMoney','isApply',5,'','net'),(3,'XLite\\Module\\CDev\\Sale\\Logic\\PercentOff','modifyMoney','isApply',500,'','net'),(4,'XLite\\Module\\CDev\\Sale\\Logic\\SaleDiscount','modifyMoney','isApply',600,'','net'),(5,'XLite\\Module\\XPay\\XPaymentsCloud\\Logic\\IncludedVAT','modifyMoney','isApply',2000,'','xpaymentsNetFee'),(6,'XLite\\Module\\XPay\\XPaymentsCloud\\Logic\\ExcludedVAT','modifyMoney','isApply',2000,'','xpaymentsDisplayFee'),(7,'XLite\\Module\\XPay\\XPaymentsCloud\\Logic\\SubscriptionFeeModifier','modifyMoney','isApply',50,'','xpaymentsNetFee'),(8,'XLite\\Module\\XPay\\XPaymentsCloud\\Logic\\SubscriptionFee','modifyMoney','isApply',100000,'','net');
CREATE TABLE `xlite_payment_method_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `method_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`setting_id`),
  UNIQUE KEY `mn` (`method_id`,`name`),
  KEY `IDX_33B9DA0019883967` (`method_id`),
  CONSTRAINT `FK_33B9DA0019883967` FOREIGN KEY (`method_id`) REFERENCES `xlite_payment_methods` (`method_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_method_settings` VALUES (1,7,'merchant_id',''),(2,7,'mode',''),(3,7,'access_key',''),(4,7,'secret_key',''),(5,7,'client_id',''),(6,7,'region','USD'),(7,7,'capture_mode','C'),(8,7,'sync_mode','S'),(9,7,'order_id_prefix',''),(10,8,'login',''),(11,8,'key',''),(12,8,'signature',''),(13,8,'type','sale'),(14,8,'test','1'),(15,8,'prefix','xcart'),(16,10,'vendor',''),(17,10,'user',''),(18,10,'pwd',''),(19,10,'partner','PayPal'),(20,10,'prefix','mystore_'),(21,10,'transaction_type','S'),(22,10,'mode','test'),(23,10,'buyNowEnabled','1'),(24,10,'headIconEnabled','1'),(25,11,'vendor',''),(26,11,'user',''),(27,11,'pwd',''),(28,11,'partner','PayPal'),(29,11,'prefix','mystore_'),(30,11,'transaction_type','S'),(31,11,'mode','test'),(32,12,'vendor',''),(33,12,'user',''),(34,12,'pwd',''),(35,12,'partner','PayPal'),(36,12,'prefix','mystore_'),(37,12,'transaction_type','S'),(38,12,'mode','test'),(39,12,'buyNowEnabled','1'),(40,12,'headIconEnabled','1'),(41,13,'account',''),(42,13,'description',''),(43,13,'prefix','mystore_'),(44,13,'mode','test'),(45,14,'api_type','email'),(46,14,'email',''),(47,14,'api_solution','paypal'),(48,14,'vendor',''),(49,14,'user',''),(50,14,'pwd',''),(51,14,'partner','PayPal'),(52,14,'api_username',''),(53,14,'api_password',''),(54,14,'auth_method','signature'),(55,14,'signature',''),(56,14,'certificate',''),(57,14,'prefix','mystore_'),(58,14,'transaction_type','S'),(59,14,'mode','test'),(60,14,'merchantId',''),(61,14,'buyNowEnabled','1'),(62,14,'headIconEnabled','1'),(63,15,'enabled','1'),(64,15,'agreement','N'),(65,15,'publisherId',''),(66,15,'bannerOnHomePage','D'),(67,15,'bannerOnCategoryPages','D'),(68,15,'bannerOnProductDetailsPages','A'),(69,15,'bannerOnCartPage','C'),(70,15,'ppcm_enabled','1'),(71,15,'ppcm_product_page','1'),(72,15,'ppcm_cart_page','1'),(73,15,'ppcm_checkout_page','1'),(74,15,'ppcm_banner_type','flex'),(75,15,'ppcm_text_logo_type','primary'),(76,15,'ppcm_text_logo_position','left'),(77,15,'ppcm_text_size','12'),(78,15,'ppcm_text_color','black'),(79,15,'ppcm_flex_color_scheme','blue'),(80,15,'ppcm_flex_layout','8x1'),(81,16,'app_id',''),(82,16,'api_username',''),(83,16,'api_password',''),(84,16,'signature',''),(85,16,'paypal_login',''),(86,16,'partner','PayPal'),(87,16,'feesPayer','PRIMARYRECEIVER'),(88,16,'matchCriteria','name'),(89,16,'prefix','mystore_'),(90,16,'transaction_type','S'),(91,16,'mode','test'),(92,16,'buyNowEnabled','1'),(93,16,'headIconEnabled','1'),(94,17,'email',''),(95,17,'client_id',''),(96,17,'secret',''),(97,17,'partner_id',''),(98,17,'bn_code',''),(99,17,'additional_partner_referral_id',''),(100,17,'additional_merchant_id',''),(101,17,'payment_descriptor',''),(102,17,'prefix','mystore_'),(103,17,'transaction_type','S'),(104,17,'mode','test'),(105,17,'disburse_funds','INSTANT'),(106,18,'authCode',''),(107,18,'merchant_id',''),(108,18,'sellerNonce',''),(109,18,'client_id',''),(110,18,'client_secret',''),(111,18,'transaction_type','S'),(112,18,'3d_secure',''),(113,18,'3d_secure_soft_exception',''),(114,18,'mode','test'),(115,18,'buyNowEnabled','1'),(116,18,'headIconEnabled','1'),(117,19,'login',''),(118,19,'prefix','xcart'),(119,19,'hash',''),(120,19,'include_response','N'),(121,20,'account',''),(122,20,'secret',''),(123,20,'language','en'),(124,20,'mode','test'),(125,20,'prefix','xcart'),(126,20,'currency','USD'),(127,22,'api_login_id',''),(128,22,'transaction_key',''),(129,22,'public_key',''),(130,22,'type','sale'),(131,22,'mode','test'),(132,22,'prefix','xcart'),(133,23,'prefix',''),(134,23,'merchantId',''),(135,23,'accessToken',''),(136,23,'refreshToken',''),(137,23,'merchantAccountId',''),(138,23,'kountMerchantId',''),(139,23,'isAutoSettle','0'),(140,23,'testMode','1'),(141,23,'isPayPal','0'),(142,23,'paypalButtonColor','gold'),(143,23,'paypalButtonShape','pill'),(144,23,'paypalShippingAddressOverride','1'),(145,23,'is3dSecure','0'),(146,23,'isAcceptNo3dSecure','0'),(147,23,'is3dSecureForVault','0'),(148,23,'isUseVault','1'),(149,23,'isShowSaveCardBox','1'),(150,23,'isApplePay','0'),(151,23,'isGooglePay','0'),(152,23,'googleMerchantId',''),(153,23,'googlePaymentButtonColor','default'),(154,23,'googlePaymentButtonType','long'),(155,24,'pspid',''),(156,24,'sha_in',''),(157,24,'sha_out',''),(158,24,'currency','GBP'),(159,24,'test','1'),(160,24,'prefix','xcart_'),(161,24,'debug_enabled','0'),(162,25,'store_id',''),(163,25,'hpp_key',''),(164,25,'mode','test'),(165,25,'prefix','xcart'),(166,25,'currency','USD'),(167,26,'merchant_id',''),(168,26,'subid','0'),(169,26,'pub_cert','rabobank.cer'),(170,26,'pub_key',''),(171,26,'private_key',''),(172,26,'private_key_pass',''),(173,26,'currency','EUR'),(174,26,'test','Y'),(175,26,'prefix','xcart_'),(176,26,'debug_enabled','0'),(177,27,'vendorName',''),(178,27,'password',''),(179,27,'type','sale'),(180,27,'test','1'),(181,27,'prefix','xcart'),(182,28,'publishKey',''),(183,28,'accessToken',''),(184,28,'publishKeyTest',''),(185,28,'accessTokenTest',''),(186,28,'mode','live'),(187,28,'type','sale'),(188,28,'prefix','xcart'),(189,28,'userId',''),(190,28,'refreshToken',''),(191,29,'prefix','xc_apple'),(192,32,'account',''),(193,32,'api_key',''),(194,32,'secret_key',''),(195,32,'widget_key',''),(196,32,'quickaccess_key','');
CREATE TABLE `xlite_coupon_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pair` (`coupon_id`,`product_id`),
  KEY `IDX_7B142C3266C5951B` (`coupon_id`),
  KEY `IDX_7B142C324584665A` (`product_id`),
  CONSTRAINT `FK_7B142C324584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_7B142C3266C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `xlite_coupons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_coupons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `coupon_id` int(10) unsigned DEFAULT NULL,
  `code` char(16) COLLATE utf8_unicode_ci NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_451D92198D9F6D38` (`order_id`),
  KEY `IDX_451D921966C5951B` (`coupon_id`),
  CONSTRAINT `FK_451D921966C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `xlite_coupons` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_451D92198D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_capost_returns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` char(2) COLLATE utf8_unicode_ci NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `lastRenewDate` int(11) NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `adminNotes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `trackingPin` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_A90646B3FA237437` (`orderId`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  CONSTRAINT `FK_A90646B3FA237437` FOREIGN KEY (`orderId`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_capost_parcel_shipment_tracking_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `identifier` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `date` char(10) COLLATE utf8_unicode_ci NOT NULL,
  `time` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `timeZone` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `signatoryName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `site` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `province` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `retailLocationId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `retailName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trackingId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_75BDE7A6F76B6A7` (`trackingId`),
  CONSTRAINT `FK_75BDE7A6F76B6A7` FOREIGN KEY (`trackingId`) REFERENCES `xlite_order_capost_parcel_shipment_tracking` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_mailchimp_subscriptions` (
  `list_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `profile_id` int(11) NOT NULL,
  PRIMARY KEY (`list_id`,`profile_id`),
  KEY `IDX_CF18140A3DAE168B` (`list_id`),
  KEY `IDX_CF18140ACCFA12B8` (`profile_id`),
  CONSTRAINT `FK_CF18140A3DAE168B` FOREIGN KEY (`list_id`) REFERENCES `xlite_mailchimp_lists` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_CF18140ACCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_access_control_zone_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_access_control_zone_types` VALUES (1,'order');
CREATE TABLE `xlite_segment_products` (
  `segment_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`segment_id`,`product_id`),
  KEY `IDX_768E358DDB296AAD` (`segment_id`),
  KEY `IDX_768E358D4584665A` (`product_id`),
  CONSTRAINT `FK_768E358D4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_768E358DDB296AAD` FOREIGN KEY (`segment_id`) REFERENCES `xlite_mailchimp_list_segments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_membership_sale_discounts` (
  `sale_id` int(10) unsigned NOT NULL,
  `membership_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`sale_id`,`membership_id`),
  KEY `IDX_64E9C0254A7E4868` (`sale_id`),
  KEY `IDX_64E9C0251FB354CD` (`membership_id`),
  CONSTRAINT `FK_64E9C0251FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_64E9C0254A7E4868` FOREIGN KEY (`sale_id`) REFERENCES `xlite_sale_discounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_modifiers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `weight` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_modifiers` VALUES (1,'XLite\\Logic\\Order\\Modifier\\Shipping',100),(2,'XLite\\Module\\CDev\\Coupons\\Logic\\Order\\Modifier\\Discount',50),(3,'XLite\\Module\\CDev\\SalesTax\\Logic\\Order\\Modifier\\Tax',1100),(4,'XLite\\Module\\CDev\\VolumeDiscounts\\Logic\\Order\\Modifier\\Discount',50);
CREATE TABLE `xlite_attribute_values_checkbox` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `value` tinyint(1) NOT NULL,
  `xpaymentsSubscriptionFeeModifier` decimal(14,4) NOT NULL DEFAULT 0.0000,
  `xpaymentsSubscriptionFeeModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'p',
  `priceModifier` decimal(14,4) NOT NULL,
  `priceModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `weightModifier` decimal(14,4) NOT NULL,
  `weightModifierType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `defaultValue` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `value` (`value`),
  CONSTRAINT `FK_3CA3503B4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_3CA3503BB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_values_checkbox` VALUES (21,29,86,1,0.0000,'p',0.0000,'p',0.0000,'p',0),(22,28,86,1,0.0000,'p',0.0000,'p',0.0000,'p',0);
CREATE TABLE `xlite_import_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` int(11) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `arguments` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `row` int(10) unsigned NOT NULL,
  `processor` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_attachments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `private` tinyint(1) NOT NULL,
  `orderby` int(11) NOT NULL,
  `access` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_A8FB24FA4584665A` (`product_id`),
  KEY `o` (`orderby`),
  CONSTRAINT `FK_A8FB24FA4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_hidden` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_option_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `attribute_option_id` (`attribute_option_id`),
  CONSTRAINT `FK_A68A8FD61AE56DE9` FOREIGN KEY (`attribute_option_id`) REFERENCES `xlite_attribute_options` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A68A8FD64584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A68A8FD6B6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_search_filter_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_5D64D191BF396750` (`id`),
  KEY `name` (`name`),
  CONSTRAINT `FK_5D64D191BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_search_filters` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_search_filter_translations` VALUES (1,1,'Unpaid','en'),(2,1,'Не оплаченные','ru'),(3,2,'Paid but not shipped','en'),(4,2,'Оплаченные, но не отправленные','ru'),(5,3,'Not finished','en'),(6,3,'Незавершенные','ru');
CREATE TABLE `xlite_attribute_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  `displayMode` char(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_3C3647F44584665A` (`product_id`),
  KEY `IDX_3C3647F4B6E62EFA` (`attribute_id`),
  CONSTRAINT `FK_3C3647F44584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_3C3647F4B6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_language_labels` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`label_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_language_labels` VALUES (3925,' page and make sure that:'),(3578,'\"Cash on delivery\" status'),(3924,'\"Site management\"'),(2062,'\"X product\" options'),(1179,'\"{{number}}\" tracking number is added'),(1180,'\"{{number}}\" tracking number is removed'),(1844,'\"{{product}} product\" attributes'),(2012,'# selected'),(1,'%'),(2084,'\'RESULT\' argument not found'),(2079,'\'status\' request argument can not found'),(3976,'(disabled role)'),(4529,'(like categories, weight, description, color)'),(2077,'(optional)'),(4547,'(without writing a single line of code) - 2 min'),(427,'+12130000000'),(4189,'+15550000000'),(232,'-- No categories --'),(1929,'-- empty --'),(2613,'...Downloading {{entry}}...{{status}}'),(2611,'...Hooks {{hooksCount}}'),(2610,'...Hooks {{hooksCount}}, Items {{itemsCount}}...'),(2609,'...Invoke {{type}} hook for {{entry}}...'),(2612,'...Unpacking {{entry}}...{{status}}'),(4436,'1 day'),(4431,'1 hour'),(4427,'1 minute'),(4439,'1 week'),(4428,'10 minutes'),(4544,'100% mobile-friendly eCommerce website templates, fully customizable, affordable, and open source.'),(423,'1000 Example street'),(4190,'1000 Main Street'),(4435,'12 hours'),(4572,'120+ supported payment gateways, such as PayPal, Authorize.net and etc.'),(380,'14days'),(4429,'15 minutes'),(4111,'18 years'),(4112,'19 years'),(4437,'2 days'),(4432,'2 hours'),(3920,'2Checkout.com account number'),(4430,'30 minutes'),(381,'30days'),(3776,'3D Secure'),(4433,'4 hours'),(2783,'404 page'),(4438,'5 days'),(4434,'6 hours'),(379,'7days'),(426,'90001'),(2614,'<span>X</span> items'),(4186,'A - Z'),(1480,'A DB error occurred while uninstalling the module X'),(4992,'A dispute has been opened successfully'),(2234,'A new category will be created'),(431,'A new customer? Enter your e-mail'),(2231,'A new membership will be created'),(2232,'A new product class will be created'),(2230,'A new product will be created'),(4727,'A new review has been submitted for the product \"{{name}}\".'),(2233,'A new tax class will be created'),(3597,'A single domain'),(432,'ABA routing number'),(3456,'API Login ID'),(3667,'API access password'),(3666,'API access username'),(3671,'API certificate'),(3670,'API certificate filename'),(3661,'API credentials for payments and post-checkout operations'),(4645,'API key is a secret key that allows to access REST API functionality. If this key is not specified in a request will not be executed.'),(3669,'API signature'),(368,'APRIL'),(372,'AUGUST'),(2482,'About X remaining'),(2793,'About clean urls'),(433,'Absolute'),(434,'Accept'),(2737,'Accept[TT]'),(435,'Accepted orders'),(3407,'Access Key ID'),(3265,'Access denied'),(437,'Access denied!'),(438,'Access information'),(439,'Access is locked out'),(440,'Access level'),(2758,'Access level cannot be changed (from {{prevValue}} to {{value}}) for existing profile ({{login}})'),(3266,'Access link has been successfully sent'),(441,'Account'),(442,'Account details'),(241,'Account settings'),(443,'Account status'),(444,'Account summary'),(2619,'Accounting'),(2395,'Action'),(1476,'Action X::Y, M'),(18,'Activate'),(16,'Activate existing key'),(15,'Activate free license'),(3095,'Activate free license & remove premium features.'),(22,'Activate free license description'),(1669,'Activate key'),(445,'Activate license key'),(2517,'Activate purchased skin'),(2289,'Activate your X-Cart'),(2287,'Activate your X-Cart installation'),(2288,'Activate your X-Cart installation first'),(10,'Activate your license key'),(446,'Activate your paid module license'),(3378,'Activated! Your current domain is X'),(447,'Active'),(448,'Active from'),(449,'Active fromF'),(450,'Active till'),(451,'Active tillF'),(452,'Add'),(3627,'Add PIN codes'),(453,'Add Product'),(4924,'Add TWIG code'),(4536,'Add a few [more products] to your catalog or proceed to the next step - whatever makes you happy.'),(3267,'Add addons'),(3268,'Add address'),(454,'Add alternative payment method'),(1914,'Add attribute'),(2708,'Add banner'),(455,'Add category'),(456,'Add child'),(2704,'Add comment here'),(2887,'Add countries'),(3514,'Add coupon'),(457,'Add discount'),(458,'Add featured products'),(2067,'Add featured products for \"X\"'),(3575,'Add featured products for the front page'),(459,'Add file'),(4505,'Add first product'),(460,'Add image'),(123,'Add language'),(461,'Add markup'),(462,'Add new'),(463,'Add new address'),(464,'Add new country'),(3507,'Add new coupon'),(465,'Add new exception'),(122,'Add new label'),(126,'Add new language'),(466,'Add new membership level'),(467,'Add new option'),(468,'Add new option group'),(469,'Add new state'),(470,'Add offline payment method'),(4526,'Add other options'),(4606,'Add other products to compare'),(471,'Add payment method'),(3634,'Add pin codes'),(2848,'Add product'),(1967,'Add products'),(1649,'Add rates'),(4965,'Add related products'),(4740,'Add response'),(4658,'Add review'),(3133,'Add sales channel'),(472,'Add shipping method'),(1654,'Add state'),(1653,'Add states'),(4198,'Add status'),(473,'Add subcategory'),(2402,'Add to bag'),(28,'Add to cart'),(4609,'Add to compare'),(4367,'Add to google product feed'),(1182,'Add tracking number'),(474,'Add user'),(475,'Add your _products_'),(4678,'Add your own review'),(476,'Add zone'),(2422,'Add-on does not exist.'),(477,'Add-ons'),(478,'Add/update options'),(479,'Added'),(4224,'Added by modules'),(3513,'Added coupons'),(2965,'Added files'),(2198,'Added items'),(481,'Added to cart'),(4188,'Added to comparison table'),(3737,'Additional PayPal Business Account'),(3718,'Additional criteria to match for PayPal account verification'),(3650,'Additional settings'),(897,'Addons Marketplace'),(482,'Address'),(483,'Address book'),(484,'Address details'),(485,'Address field'),(486,'Address fields'),(3881,'Address for sales tax calculation'),(1847,'Address has been deleted'),(1842,'Address is not selected'),(4762,'Address line verification: X'),(3269,'Address masks'),(1843,'Address not found'),(487,'Address pattern'),(3270,'Address type'),(1841,'Address type has wrong value'),(4763,'Address zipcode verification: X'),(2573,'Address zone'),(3529,'Address zones (coupons)'),(4314,'Addresses'),(1780,'Addresses list is empty'),(3958,'Adds the sender’s signature and the date on CN22 and CP72 shipping labels. Enter the signature as a string. The Sender’s signature date is automatically populated.'),(488,'Admin'),(1322,'Admin has requested a change of password for your account. Please change the password before you proceed.'),(3342,'Admin panel'),(489,'Administration Zone'),(490,'Administrator'),(1534,'Administrator Zone'),(2437,'Administrator account cannot be deleted via customer interface.'),(2331,'Administrator header'),(4109,'Administrator notes'),(2332,'Administrator signature'),(2335,'Administrator subject'),(2336,'Administrator text'),(4020,'Advanced Options'),(2413,'Advanced Order Management'),(4570,'Advanced shipping settings'),(3593,'Advanced statistics with'),(2076,'After activation Skrill will give you access to a new section in your Skrill account called \"Merchant tools\". Please choose a secret word (do not use your password for this) and enter it into the merchant tools section and below.'),(1298,'After clicking this button, your hard/soft reset links will be regenerated. You need it in case old links were compromised.'),(1421,'After the problem has been fixed, try to connect again.'),(2764,'After the problem has been fixed, try to connect again.\', {\'clear_cache\': url(\'addons_list_marketplace'),(1506,'After the upgrade is completed please check your website. If you find that the site is inoperative, please try to do the following'),(1833,'Aggregation cache has been cleaned'),(4937,'Air service center'),(229,'All'),(665,'All Addresses (default zone)'),(346,'All Order Statuses'),(396,'All User Types'),(491,'All add-ons'),(2975,'All addons'),(2154,'All attributes'),(4628,'All classes from this category'),(4996,'All communication threads'),(1855,'All countries'),(492,'All customers'),(3973,'All dimensions must be greater than 0'),(2765,'All items'),(2195,'All items cannot be removed from the order.'),(2131,'All levels'),(394,'All membership levels'),(493,'All memberships'),(3824,'All newest products'),(4477,'All news'),(2135,'All orders'),(2120,'All payment statuses'),(2688,'All payment transaction statuses'),(495,'All products on sale'),(1779,'All rights reserved.'),(496,'All shipping methods'),(2121,'All shipping statuses'),(497,'All shipping zones'),(751,'All states'),(2405,'All statuses'),(494,'All the necessary adaptation will be done by the developer.'),(498,'All the products are in sufficient quantities'),(499,'All time'),(3825,'All upcoming products'),(2412,'All user types'),(4709,'All users'),(1785,'All words'),(4236,'Allow buyers to attach files to this product'),(4426,'Allow this product to be used as a MailChimp segment condition'),(4231,'Allowed file extensions: X'),(4631,'Alphabetical'),(501,'Alphabetically'),(1685,'Already added'),(1724,'Already exists'),(502,'Already have an account?'),(2680,'Also the system has detected problems with the following modules'),(2796,'Also, to manage your redirects you can define 301 redirects in .htaccess file.'),(3086,'Also, you can review X-Cart recommended hosting providers'),(89,'Alt'),(503,'Alternative payment methods'),(504,'Alternative text'),(277,'Alternatively, upload file sqldump.sql.php to the var/backup/ sub-directory click on the \"Restore from server\" button'),(4959,'Alternatives products you may be interested in'),(2766,'Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(3574,'Although you may find related products below.'),(2638,'Amazon'),(3434,'Amazon Order Ref ID'),(3447,'Amazon Pay was not able to process your payment.'),(3404,'Amazon Seller ID'),(3433,'Amazon callback URL help'),(3432,'Amazon could not process the transaction due to an internal processing error.'),(3431,'Amazon has rejected the authorisation.'),(3416,'AmazonRefresh'),(3417,'AmazonRefundRefresh'),(505,'Amount'),(506,'Amount: high to low'),(507,'Amount: low to high'),(1866,'An attempt to update settings of unknown payment method'),(3401,'An error occurred during the global attributes changing.'),(2358,'An error occurred while sending the request'),(3387,'An error occurred while transferring your store. Our engineers are already working on fixing it.'),(3397,'An error occurred while validating the domain name'),(2475,'An error occurred, please try again. If the problem persists, contact the administrator.'),(2476,'An error occurred, please try again. If the problem persists, contact the administrator. (txnNote)'),(1739,'An upgrade is a dangerous process that may result in a crashed website.'),(508,'An upgrade is a dangerous process that may result in a crashed website. It is strongly recommended to create a full back up of your shop (the code and the database) and download it to a local computer before proceeding to the next step.'),(5040,'Annually'),(1938,'Anonymous'),(2132,'Anonymous (access level)'),(201,'Anonymous Customer'),(202,'Anonymous Customer, _Registered User with the same email_'),(2022,'Anonymous Customers'),(4724,'Anonymous reviewer'),(3905,'Anonymous users only'),(3271,'Another bulk change in progress, please try again later'),(509,'Another state'),(110,'Any availability status'),(401,'Any category'),(113,'Any class'),(4352,'Any google group'),(510,'Any membership level'),(511,'Any product class'),(2554,'Any profile'),(4653,'Any rating'),(4296,'Any special needs?'),(402,'Any status'),(2178,'Any stock status'),(3904,'Any visitors'),(1786,'Any word'),(512,'Any zone'),(4191,'Anyland'),(4192,'Anytown'),(1339,'App Store update is available'),(2631,'App type'),(513,'Appearance'),(3802,'Applicable to stacked and single line logos only'),(3483,'Applied discount coupon'),(3117,'Apply attribute value changes for all the products'),(514,'Apply destination'),(3867,'Apply maximum discount'),(3868,'Apply minimum discount'),(515,'Apply price'),(3859,'Apply sale discount to wholesale prices'),(4215,'Apply sort and view settings for all products'),(2958,'Apply sorting globally'),(3272,'Apply to billing address'),(3115,'Apply unsharp mask filter on resize'),(1758,'Apply value changes globally'),(1757,'Apply value changes locally'),(3398,'Applying changes to global attributes'),(4669,'Approve'),(4660,'Approve review'),(4271,'Approved URL'),(516,'Are you sure you want to continue?'),(521,'Are you sure you want to delete the selected payment method?'),(517,'Are you sure you want to delete the selected user?'),(2655,'Are you sure you want to delete this filter?'),(1682,'Are you sure you want to delete this profile?'),(518,'Are you sure you want to disable this add-on?'),(2849,'Are you sure you want to enable https anyway?'),(519,'Are you sure you want to enable this add-on?'),(4913,'Are you sure you want to reset current layout? Custom layout settings will be lost.'),(4127,'Are you sure you want to transmit this shipment?'),(2400,'Are you sure you want to uninstall selected add-ons?'),(520,'Are you sure you want to uninstall this add-on?'),(4125,'Are you sure you want to void this shipment?'),(522,'Are you sure you wish to delete the selected zones?'),(523,'Are you sure?'),(524,'Arrival date'),(3580,'As a FedEx user, you are entitled to receive shipping refunds usually left unclaimed with default FedEx service ($2B/year globally)'),(4948,'As a UPS user, you are entitled to receive shipping refunds usually left unclaimed with default UPS service ($2B/year globally)'),(4179,'As a result of your latest order edit, previously created shipments for the order were dropped. Transmitted shipments (if any) remained unchanged. Visit the page X to manage shipments.'),(526,'Ask.com'),(2457,'Assign entered Clean URL to this page anyway'),(4368,'Assign shopping group'),(4359,'Assign your attributes to Google groups to import your variants.'),(527,'Assigned classes'),(525,'Asynchronous'),(4249,'Attach file'),(4234,'Attach files'),(4076,'Attached files'),(4232,'Attached files:'),(4244,'Attachment X is deleted'),(3584,'Attachment has been deleted successfully'),(528,'Attachment is not deleted'),(3535,'Attachment removed'),(529,'Attachments'),(530,'Attachments have been updated successfully'),(3083,'Attention!'),(3183,'Attention! You are creating an account with full access. Roles warning'),(1579,'Attribute'),(6,'Attribute data will be lost. warning text'),(1577,'Attribute group'),(1578,'Attribute groups'),(4369,'Attribute information has been successfully updated'),(1574,'Attribute name'),(1569,'Attribute option'),(4351,'Attribute type'),(3154,'Attribute value ID'),(1575,'Attribute values'),(3155,'Attribute values (select)'),(117,'Attributes'),(754,'Attributes block'),(316,'Attributes for X product class'),(1845,'Attributes have been successfully changed'),(1895,'Attributes have been updated successfully'),(1910,'Attributes imported'),(531,'Australia Post settings'),(2101,'Auth'),(3651,'Auth and Capture'),(3652,'Auth only'),(532,'Authentication'),(3777,'Authentication bypassed / unavailable liability shift'),(533,'Authentication code'),(4151,'Authentication options'),(534,'Author'),(2055,'Authorization and Capture'),(2056,'Authorization only'),(3418,'Authorization status: {{status}}'),(535,'Authorization then capture'),(4023,'AuthorizeNet accept.js instruction text'),(2725,'Authorize[TT]'),(348,'Authorized'),(1834,'Authorized amount'),(536,'Auto'),(4418,'Auto-Updated'),(2767,'Autogenerate'),(1683,'Autogenerate Clean URL'),(2074,'Autogenerated'),(2647,'Automate Shipping Refunds'),(4007,'Automate bidding to maximize sales for your marketing budget'),(2624,'Automate shipping'),(2626,'Automate your shipping process with the services of our partners: print shipping labels, grab shipping orders info from eBay, ETSY, Amazon and other marketplaces; integrate with several shipping carriers in one spot and more.'),(3630,'Automatically'),(537,'Availability'),(3557,'Available after purchase'),(3542,'Available for download'),(538,'Available for sale'),(2550,'Avalara provides our mutual customers with everything you need to calculate, file and remit sales tax for your business effortlessly by providing an integrated, end-to-end solution for every step of the tax compliance process.'),(2552,'Avalara.60 Day Free Trial'),(4685,'Average rating'),(2919,'Awaiting processing'),(539,'B'),(245,'BEGIN - END of TOTAL'),(1822,'Back'),(1789,'Back to Login form'),(2685,'Back to Trial mode'),(4867,'Back to Webmaster mode'),(753,'Back to Zones list'),(540,'Back to file select'),(541,'Back to layout settings'),(542,'Back to methods'),(1790,'Back to modules'),(4871,'Back to notification settings'),(2339,'Back to notifications list'),(543,'Back to order list'),(4695,'Back to product details'),(4056,'Back to products'),(4442,'Back to segments list'),(2601,'Back to shipping methods'),(4813,'Back to templates list'),(544,'Back to top'),(303,'Backend payment transaction X issued'),(2768,'Background export is in progress'),(3327,'Backordered'),(3328,'Backordered (qty: {{qty}})'),(545,'Backup'),(546,'Backup database'),(2033,'Backup your store with Backup Master'),(547,'Bank Account Number'),(908,'Bank name'),(3683,'Banner on Cart page'),(3681,'Banner on Category pages'),(3680,'Banner on Home page'),(3682,'Banner on Product details pages'),(3791,'Banner on product pages'),(3792,'Banner on the cart page'),(3793,'Banner on the checkout page'),(2707,'Banner rotation'),(3794,'Banner type'),(4687,'Based on'),(4708,'Be the first and leave a feedback.'),(1612,'Before editing attributes specific for the chosen type you should save the changes'),(2543,'Before enabling HTTPS protocol read this article:'),(2285,'Before installing a paid addon for this installation, you need to activate your X-Cart license.'),(3454,'Before you can start configure Australia Post module you should update available options from Australia Post. Please click button below.'),(548,'Benchmark completed in '),(549,'Benchmark result under 3000ms is considered good'),(550,'Bestsellers'),(2664,'Bill to'),(2891,'Billing'),(551,'Billing address'),(2087,'Billing address is not defined'),(552,'Billing address is not defined yet'),(1825,'Billing address is the same as Shipping'),(2895,'Billing to'),(553,'Bing'),(4567,'Bingo! You\'ve added carrier as a shipping carrier'),(3811,'Black (ppcm)'),(3569,'Block'),(4840,'Block is disabled'),(4839,'Block is enabled'),(2065,'Blocked'),(3541,'Blocked by administrator'),(3370,'Blocks'),(3817,'Blue (ppcm)'),(2879,'Body'),(4093,'Box maximum weight'),(554,'Brief description'),(555,'Brief descrption'),(4210,'Brief info'),(4216,'Brief info help'),(4592,'Browse Top Trending Tools'),(556,'Browse server'),(4017,'Build a campaign in a few minutes, and sell to customers as they search for your products on Google.'),(4054,'Bulk Edit processing in progress...'),(4046,'Bulk edit'),(4048,'Bulk edit all'),(4051,'Bulk edit has been processed successfully.'),(4052,'Bulk edit processing has been interrupted.'),(4053,'Bulk edit processing may take a while to complete. Please do not close this page until the process is fully completed.'),(4057,'Bulk edit selected'),(3273,'Business premium features'),(2208,'Buy'),(2492,'Buy Business Edition'),(557,'Buy more'),(2446,'Buy prolongation'),(1615,'Buyers can select an option'),(1799,'C.O.D. fee included'),(558,'CLOSE'),(2002,'CM'),(3945,'COD value'),(559,'CSS & JavaScript'),(2390,'CSV delimiter'),(2161,'CSV file has the wrong filename format.'),(3079,'CSV format tables'),(1982,'CSV or ZIP files, total max size: {{size}}'),(4761,'CVC verification: X'),(3274,'CVV / CVC'),(1810,'CVV2'),(2477,'Cache management'),(560,'Cache rebuild is already started, please wait'),(2480,'Calculate quick data'),(2481,'Calculate quick data help text'),(561,'Calculate rates'),(2483,'Calculating quick data...'),(425,'California'),(1812,'Call us: '),(3435,'Callback URL'),(4014,'Campaign Dashboard'),(3543,'Can be downloaded only after buying the product'),(2559,'Can be provided only for offline shipping methods.'),(2561,'Can be provided only for online shipping methods.'),(3662,'Can be set up later'),(3611,'Can not be disabled for products with manually defined PIN codes'),(562,'Can\'t be disabled. The module is required by:'),(563,'Can\'t connect to the Addons Marketplace server'),(4496,'Can\'t subscribe you right now. Try later'),(4066,'Canada Post module allows to use online shipping rates calculation via Canada Post'),(4104,'Canada Post settings'),(4134,'CanadaPost settings'),(138,'Cancel'),(3849,'Cancel sale'),(3852,'Cancel sale for all'),(350,'Canceled'),(2695,'Canceled[S]'),(2991,'Canceling'),(3391,'Cancellation request'),(4240,'Cannot attach the file. The maximum attached file size may not exceed X MB'),(4239,'Cannot attach the file. The number of attached files may not exceed X'),(4241,'Cannot attach the files. Total size of attached files may not exceed X MB'),(4461,'Cannot authenticate'),(1901,'Cannot autogenerate clean URL for the product name \"{{name}}\". Please specify it manually.'),(3366,'Cannot be disabled. The template is required by: {{moduleName}}'),(2963,'Cannot check the files for this module'),(2192,'Cannot create temporary order for modification'),(2344,'Cannot gather modules from the marketplace. Please try later.'),(4865,'Cannot get flexy content'),(3613,'Cannot remove a sold PIN code'),(282,'Cannot set X permissions for subdirectories:'),(2102,'Capture'),(3412,'Capture mode'),(2729,'Capture multiple[TT]'),(2728,'Capture partially[TT]'),(564,'Capture status'),(2727,'Capture[TT]'),(1835,'Captured amount'),(4117,'Card (hold) for pick up'),(2299,'Card number'),(2296,'Card type'),(1805,'Cardholder name'),(1173,'Carrier'),(2598,'Carrier service'),(2599,'Carrier service name'),(2597,'Carrier services'),(2563,'Carrier-calculated rates'),(1820,'Cart'),(565,'Cart & checkout'),(2175,'Cart contains products with wrong quantity'),(2174,'Cart contains products with wrong quantity. Please correct this to proceed'),(211,'Cart is empty'),(2070,'Cash on delivery'),(566,'Catalog'),(567,'Categories'),(4642,'Categories and tags'),(1911,'Categories imported'),(3001,'Categories processed'),(3004,'Categories processed: X out of Y'),(3003,'Categories processed: X out of Y with errors'),(3005,'Categories processed: {{count}}'),(568,'Category'),(4919,'Category description'),(79,'Category icon'),(3076,'Category id or path is required'),(569,'Category info'),(3337,'Category is not accessible'),(570,'Category name'),(571,'Category name contains invalid symbols'),(2763,'Category name should not be empty'),(572,'Category page title'),(573,'Category path contains invalid symbols'),(3078,'Category with id X not found, new category will be created'),(574,'Change'),(575,'Change address'),(1811,'Change attributes'),(4601,'Change domain name'),(3181,'Change fulfillment status for selected'),(576,'Change method'),(577,'Change options'),(1423,'Change password'),(578,'Change payment info'),(3180,'Change payment status for selected'),(580,'Change shipping'),(579,'Change shipping info'),(3275,'Change template'),(2196,'Changed items'),(2197,'Changed options'),(4831,'Changes may be incompatible with TinyMCE. Are you sure to proceed?'),(1755,'Changes of attributes globally'),(1756,'Changes of attributes locally'),(4896,'Changes were successfully saved'),(2210,'Character set'),(1737,'Check again'),(581,'Check all'),(4863,'Check directory permissions'),(2533,'Check for available free disk space has failed'),(2850,'Check for updates'),(582,'Check number'),(4311,'Check shipping info'),(3212,'Check the article how to check your emails'),(3214,'Check your email deliverability'),(583,'Checking'),(584,'Checking integrity, please wait...'),(215,'Checkout'),(4298,'Checkout type'),(585,'Choose'),(586,'Choose _payment methods_'),(2519,'Choose a new template'),(4312,'Choose another address'),(2298,'Choose card type'),(4630,'Choose classes...'),(587,'Choose file'),(588,'Choose from a variety of bundled payment solutions to accept credit cards and other methods of payment on your website'),(589,'Choose method'),(2897,'Choose shipping'),(590,'Choose shipping method'),(3795,'Choose text if you need a lightweight contextual message. Choose flex if you need a responsive banner'),(4600,'Choose the best way for customers to pay you.'),(1792,'Choose the product options first'),(2491,'Choose the right plan'),(4339,'Choose your location'),(1628,'Choosing \"URLs\" will link the exported data to your public files (product and category images, downloadable files shown on product pages, and so on) through direct URLs'),(2297,'Chose credit card type'),(591,'City'),(1435,'City masks'),(4374,'Class X'),(2155,'Classes & Attributes'),(1862,'Classes & attributes'),(4627,'Classes for product filter'),(592,'Clean URL'),(2770,'Clean URLs'),(646,'Clean URLs are disabled'),(644,'Clean URLs are disabled. More info'),(2769,'Clean URLs are disabled. More info\', {\'more_info_url\': url(\'settings\', \''),(645,'Clean URLs are enabled'),(648,'Clean URLs functionality may not be enabled. More info'),(598,'Clean aggregation cache'),(49,'Clean aggregation cache help text'),(599,'Clean widgets cache'),(50,'Clean widgets cache help text'),(600,'CleanURL'),(597,'Clean_urls_error_message'),(1530,'Cleanup'),(1527,'Cleanup queries'),(2915,'Clear all caches'),(2916,'Clear all caches text'),(1796,'Clear all fields'),(601,'Clear bag'),(3276,'Clear cache help text'),(33,'Clear cart'),(4607,'Clear list'),(108,'Clear search'),(4774,'Click Connect with Stripe to be redirected to Stripe.com'),(602,'Click here to access/add subcategories'),(3882,'Click here to specify tax rates that will apply only to shipping charges'),(4528,'Click here to upload product image'),(4540,'Click here to upload your logo. Recommended 221x40px (PNG, JPG or SVG)'),(603,'Click here to view states of country'),(1603,'Click if you do not want to add this value to new products or class’s assigns automatically'),(1604,'Click if you want to add this value to new products or class’s assigns automatically'),(4424,'Click rate'),(2209,'Click the link to increase product amount'),(3738,'Click this to access the PayPal sign-in page and sign in using your PayPal account different from the account specified above.'),(1648,'Click to add rates'),(1652,'Click to add states'),(1716,'Click to close'),(3586,'Click to edit'),(1655,'Click to edit all this label translations'),(1647,'Click to edit rates'),(1651,'Click to edit states'),(3110,'Click to expand menu'),(4308,'Click to finish your order'),(1715,'Click to open'),(4310,'Click to proceed to the next step'),(3335,'Click to select the date'),(4047,'Click to specify'),(604,'Click to unblock'),(179,'Clicking the Place order button you accept: Terms and Conditions'),(3409,'Client ID'),(3774,'Client Id'),(3775,'Client Secret'),(1561,'Clone'),(2983,'Clone selected'),(1560,'Clone this product'),(118,'Cloned products'),(357,'Close'),(4991,'Close dispute'),(605,'Close storefront'),(4512,'Close wizard'),(1946,'Closed'),(2632,'Cloud Service'),(2633,'Cloud Zoom'),(2634,'Cloud Zoom mode'),(2635,'Cloud Zoom mode Inside'),(2636,'Cloud Zoom mode Outside'),(4043,'CloudSearch sets default sort order to relevance'),(606,'Code'),(3740,'Color'),(3822,'Color scheme (ppcm)'),(2923,'Column X is required'),(3869,'Combine discounts'),(3826,'Coming soon'),(2386,'Coming soon (title)'),(3837,'Coming soon...'),(1708,'Comma'),(607,'Comment'),(608,'Comments'),(1998,'Commercial'),(4116,'Commercial - will return the contracted price between Canada Post and the contract holder'),(4152,'Common options'),(1189,'Common tax settings'),(2124,'Communication log'),(3727,'Communication problem'),(4998,'Communication threads with open disputes'),(4997,'Communication threads with unread messages'),(1932,'Compact view'),(609,'Company'),(610,'Company name'),(2086,'Compare'),(1813,'Compare products'),(1536,'Compare your result with other servers'),(4605,'Comparison table - X items'),(1727,'Complete'),(1826,'Complete billing address'),(611,'Completed'),(612,'Component'),(3019,'Config file'),(613,'Configuration'),(1643,'Configure'),(4892,'Configure Tag Manager'),(614,'Configure _shipping methods_'),(4150,'Configure manually'),(3595,'Configure the Google Analytics module'),(3566,'Configure your X-Cart installation to support large file downloads.'),(4548,'Configure your geographic settings to connect with local customers'),(615,'Configure your store'),(135,'Confirm deletion'),(616,'Confirm password'),(2498,'Confirmation'),(1725,'Confirmation does not match'),(157,'Congratulations! Your order has been placed successfully'),(3731,'Connect to PayPal'),(3788,'Connect with PayPal'),(4454,'Connect with your MailChimp account'),(3729,'Connected to PayPal; Merchant ID: {{merchantId}}'),(3789,'Connecting to PayPal with X-Cart installed on the local server is supported in manual mode only.'),(2797,'Connecting to the marketplace...'),(3150,'Consistency check'),(3159,'Consistency has not yet been checked. Initiate an consistency check by clicking the button \"Refresh consistency status\".'),(3184,'Contact Us page settings'),(4153,'Contact name for the manifest address'),(4580,'Contact our expert'),(4981,'Contact seller'),(3894,'Contact us'),(3096,'Contact us if you have any questions.'),(9,'Contact us trial notice'),(3565,'Contact your hosting provider to make sure X-Sendfile is installed on the server.'),(617,'Contacts'),(618,'Content'),(4336,'Content has script tags (Froala)'),(2326,'Content of this notification based on the body.twig template'),(3913,'Content page title'),(619,'Continue'),(1827,'Continue as guest'),(34,'Continue shopping'),(47,'Continue...'),(4154,'Contract ID'),(4155,'Contract shipping options'),(3962,'Convenience - Verify addresses and buy & print compliant USPS labels directly from the X-Cart application'),(5008,'Conversation'),(5010,'Conversation: X'),(5009,'Conversations'),(2712,'Convert failed transactions into real orders'),(4858,'Convert templates'),(90,'Copy'),(4767,'Copy Webhook URL and go to Account settings'),(620,'Copy file to local server'),(91,'Copy to clipboard'),(88,'Copy to file system'),(1695,'Core version'),(621,'Core version: '),(3978,'Could not add the discount because another discount already exists for the specified subtotal range, membership level, date range and shipping zones'),(3608,'Could not assign X PIN codes to order #Y.'),(2472,'Could not assign upgrade access level to your license keys'),(4593,'Could not save logo image'),(3979,'Could not update the discount because another discount already exists for the specified subtotal range, membership level, date range and shipping zones'),(2854,'Couldn\'t download the banner {{value}} from URL'),(2714,'Couldn\'t download the image {{value}} from URL'),(2040,'Couldn\'t move X images. See log for details.'),(2039,'Couldn\'t move image X'),(1525,'Count'),(5023,'Count days from the end'),(4115,'Counter - will return the regular price paid by retail consumers'),(622,'Countries'),(2307,'Countries information has been successfully updated'),(623,'Countries, states and zones'),(624,'Country'),(625,'Country is not selected'),(3411,'Country of Merchant account'),(3509,'Coupon'),(3517,'Coupon cannot be combined with other coupons'),(626,'Coupon code'),(3490,'Coupon discount'),(3505,'Coupon discount can be limited to customers with these membership levels'),(3504,'Coupon discount can be limited to these product classes'),(627,'Coupons'),(4156,'Coverage'),(628,'Create'),(630,'Create SQL file'),(4016,'Create a New Google Shopping Campaign'),(631,'Create a backup'),(632,'Create account'),(633,'Create an account for later use'),(634,'Create category'),(2430,'Create label'),(635,'Create new account'),(1979,'Create new items and update existing items'),(4482,'Create news message'),(4009,'Create perfect shopping campaigns in minutes'),(629,'Create profile'),(4070,'Create return'),(3959,'Create shipment'),(4566,'Create shipping rate'),(1308,'Create zone'),(636,'Created'),(4077,'Created on'),(1806,'Credit card number'),(2306,'Credit card security code (if present)'),(3757,'Credit or debit card (Visa, MasterCard, American Express, Discover, and so on)'),(3277,'Critical'),(1977,'Critical error'),(1509,'Critical errors have been detected in the files you are trying to import. Check the manual to correct the errors and try again.'),(1703,'Curl options'),(1702,'Curl version'),(637,'Currency'),(4157,'Currency rate'),(3919,'Current logo sizes: XхY px'),(3015,'Current password'),(2191,'Current price for the selected configuration and quantity: X'),(2512,'Current template'),(2075,'Custom'),(639,'Custom CSS'),(3128,'Custom CSS & JS'),(77,'Custom HTML title'),(640,'Custom JavaScript'),(638,'Custom addons'),(1987,'Custom attributes'),(641,'Custom images'),(1918,'Custom offline shipping'),(2564,'Custom table rates'),(642,'Custom translation'),(200,'Customer'),(2130,'Customer access level'),(3341,'Customer area'),(4938,'Customer counter'),(3256,'Customer email (if exist)'),(2329,'Customer header'),(2193,'Customer information'),(4671,'Customer name'),(199,'Customer note'),(4158,'Customer number'),(4696,'Customer reviews'),(2330,'Customer signature'),(2333,'Customer subject'),(2334,'Customer text'),(643,'Customer zip/postal code'),(1538,'Customer zone is closed for maintenance.'),(4245,'Customer`s attachments were changed'),(1907,'Customers'),(1908,'Customers imported'),(3827,'Customers who bought this product also bought'),(3828,'Customers who viewed this product bought'),(4898,'Customize storefront'),(3739,'Customize the PayPal button'),(4546,'Customize your store with Layout Editor option'),(376,'DECEMBER'),(2639,'DHL'),(2003,'DM'),(5024,'Daily'),(4939,'Daily Pickup'),(3323,'Dashboard'),(1510,'Data has not been found'),(650,'Data have been deleted successfully'),(651,'Data have been saved successfully'),(3278,'Data removal has been completed successfully.'),(3279,'Data removal has been stopped.'),(3280,'Database'),(652,'Database backup created successfully'),(1883,'Database restored successfully!'),(653,'Date'),(3281,'Date and time in the shop'),(3186,'Date and time in the store'),(3185,'Date and time on the server'),(1795,'Date range'),(388,'Date range should less than %d days'),(387,'Date range should longer than %d days'),(3500,'Date when customers can start using the coupon'),(3986,'Date when customers can start using the volume discount'),(3501,'Date when the coupon expires'),(3987,'Date when the volume discount expires'),(3829,'Date: newest first'),(3830,'Date: oldest first'),(654,'Day'),(356,'Days'),(655,'Dear'),(295,'Dear X'),(656,'Dear customer'),(657,'Decline'),(2738,'Decline[TT]'),(658,'Declined'),(4272,'Declined URL'),(659,'Default'),(1614,'Default attribute value'),(660,'Default customer address'),(1916,'Default for admins'),(661,'Default for customer zone and can not disabled or deleted'),(662,'Default for customer zone and cannot be disabled or deleted'),(1915,'Default for customers'),(2689,'Default image settings'),(663,'Default images settings'),(1571,'Default option'),(2788,'Default site meta description'),(2789,'Default site meta keywords'),(2787,'Default site title'),(114,'Default tax class'),(1613,'Default value'),(414,'Default zone tooltip text'),(1088,'Default-sort-option'),(3343,'Default: {{code}}'),(666,'Define classes'),(3752,'Delayed'),(137,'Delete'),(4533,'Delete Demo products'),(146,'Delete Language'),(667,'Delete SQL file'),(2436,'Delete account'),(668,'Delete all'),(1611,'Delete all files'),(4233,'Delete attachment'),(4906,'Delete custom file'),(2654,'Delete filter option'),(46,'Delete item'),(669,'Delete profile'),(670,'Delete selected'),(671,'Delete selected profile'),(1513,'Delete temporary files after the import is completed'),(672,'Delete the image'),(673,'Delete this address?'),(4071,'Deliver to Post Office'),(4159,'Deliver to Post Office options'),(37,'Delivery'),(4940,'Delivery confirmation - adult signature required'),(4941,'Delivery confirmation - no signature'),(4942,'Delivery confirmation - signature required'),(3938,'Delivery cost'),(3965,'Delivery date'),(4313,'Delivery method'),(674,'Delivery methods'),(2556,'Delivery time'),(4074,'Delivery to Post Office'),(259,'Depending on the size of your data file, importing may take some time.'),(2105,'Deploy'),(29,'Description'),(3346,'Description for customers'),(4539,'Design your online store to fit your brand'),(2048,'Destination address'),(675,'Destination zone'),(676,'Details'),(3282,'Developer'),(4584,'Developer docs'),(4160,'Developer mode'),(2988,'Developer wave'),(2376,'Developers docs'),(4608,'Differences only'),(3324,'Dimensions'),(4094,'Dimensions (cm)'),(677,'Directories and files permissions'),(337,'Directory X does not have permissions to write. Please set necessary permissions to directory X.'),(4149,'Directory X is not writable'),(1913,'Directory does not have permissions to write'),(1707,'Directory is empty'),(142,'Disable'),(3283,'Disable HTTPS'),(2982,'Disable all'),(678,'Disable all modules in the system'),(4925,'Disable block'),(4283,'Disable facebook product feed'),(4969,'Disable mutual links'),(2980,'Disable selected'),(679,'Disable suspicious modules'),(680,'Disabled'),(3027,'Disabled functions'),(1606,'Disabled in catalog'),(145,'Disabled language can not be set as default for customer zone'),(1900,'Disabled language cannot be default.'),(681,'Disabled language cannot be set as default for customer zone'),(2113,'Disabled modules hooks message body'),(2112,'Disabled modules hooks message head'),(2976,'Disabled only'),(775,'Disables all addons (core reset)'),(774,'Disables all addons except ones that are provided by X-Cart Team & Qualiteam (soft reset)'),(773,'Disables all addons except ones that are provided by X-Cart Team (hard reset)'),(1193,'Disables all modules except ones that were downloaded from marketplace (soft reset)'),(3331,'Discard'),(4835,'Discard changes'),(4772,'Disconnect'),(682,'Discount'),(683,'Discount amount'),(3363,'Discount cannot be more than 100%'),(684,'Discount type'),(3883,'Discounted subtotal'),(3884,'Discounted subtotal + Shipping cost'),(2575,'Discounted subtotal range'),(3125,'Discounts'),(3673,'Display \"Now Accepting PayPal\" badge'),(685,'Display \'inc/ex VAT\' labels next to prices'),(3872,'Display above categories list'),(4915,'Display all templates'),(3372,'Display as'),(1191,'Display common settings'),(3672,'Display the \"Buy Now with PayPal\" button'),(686,'Display type'),(3871,'Display under categories list'),(1924,'Displays the number of labels translated to the language'),(5002,'Dispute'),(4989,'Dispute closed by X'),(4999,'Dispute is open X by Y'),(4988,'Dispute opened by X'),(5007,'Disputes'),(687,'Do not close this page!'),(3870,'Do not display'),(1744,'Do not replace selected files and ignore their newer versions'),(4119,'Do not safe drop'),(2138,'Do not see your payment method? Find it on our Marketplace'),(2798,'Do not see your payment method? Find it on our Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(2177,'Do not select anything if you want to make the product visible to all customers.'),(688,'Do not show at startup anymore'),(4629,'Do not show the filter'),(1512,'Do not verify images to increase speed of the process'),(4555,'Do you need to ship your products?'),(2616,'Do you really want to close storefront?'),(4970,'Do you really want to delete all relations from this product?'),(689,'Do you really want to delete selected items?'),(3068,'DocBlocks support'),(4095,'Document'),(4078,'Documents'),(2673,'Does not match license type (requires {{list}} edition)'),(3379,'Domain name'),(3380,'Domain name transfer'),(3694,'Don\'t have account yet?'),(4753,'Don\'t have account yet? Sign up for SagePay now!'),(4781,'Don\'t have an account?'),(3839,'Don\'t label'),(4535,'Done! We ve just deleted all your demo products'),(690,'Dont have account yet?'),(3463,'Dont have an account? Sign Up Now'),(2032,'Don’t forget to create a backup!'),(3349,'Don’t lose any more sales that are coming to your website. LiveChat gives you an opportunity to engage in real-time conversations and convert more visitors before they leave. Create a LiveChat account here.'),(2205,'Don’t notify customer'),(1717,'Double quote'),(3284,'Download'),(1983,'Download CSV files'),(691,'Download SQL file'),(1629,'Download all files'),(2723,'Download error file'),(3547,'Download link did not found'),(3545,'Download link is blocked'),(3548,'Download link is not active'),(3549,'Download link is renew'),(3546,'Download links is blocked'),(3550,'Download links is renew'),(692,'Downloaded components'),(693,'Downloading updates'),(694,'Downloading updates, please wait...'),(3538,'Downloads left'),(695,'Drag and drop me to the bag'),(4879,'Drag-n-drop blocks'),(1511,'Drop existing items before import'),(696,'Drop items here to shop'),(697,'Drupal frontend'),(315,'Duplicated clean URL: X'),(4218,'Duplicated link'),(264,'During the import was recorded X errors. You can get them by downloading the log files.'),(2880,'Dynamic message'),(4833,'Dynamic message editor'),(4450,'E-Commerce features setup'),(1814,'E-Mail'),(3659,'E-Mail address to receive PayPal payment'),(3552,'E-goods'),(698,'E-mail'),(699,'E-mail is not defined yet'),(2903,'E-mail will also be updated in all the related orders.'),(3711,'EACHRECEIVER'),(3758,'ELV/SEPA'),(2640,'ETSY'),(5021,'Each'),(3963,'Easy payment options - Ship Now Pay Later with a Pitney Bowes Line of Credit or use a credit card.'),(1650,'Edit'),(4212,'Edit Globally'),(4928,'Edit Text'),(4302,'Edit address'),(4972,'Edit all'),(1686,'Edit attribute'),(1602,'Edit attribute values'),(1544,'Edit attributes'),(4316,'Edit billing address'),(700,'Edit charges for:'),(2515,'Edit custom options'),(4303,'Edit email'),(147,'Edit label'),(148,'Edit labels'),(404,'Edit labels (X)'),(4921,'Edit notification body'),(702,'Edit page'),(701,'Edit payment method data'),(1645,'Edit product'),(703,'Edit profile'),(420,'Edit rates (X)'),(4659,'Edit review'),(4317,'Edit shipping address'),(409,'Edit states (X)'),(342,'Edit subcategories (X)'),(4872,'Edit template based on'),(4677,'Edit your review'),(4810,'Edited templates'),(305,'Editing attribute groups on this page won\'t affect other product classes which use these groups'),(3555,'Egoods free'),(3554,'Egoods paid'),(704,'Email'),(705,'Email &amp; password'),(3473,'Email Address'),(218,'Email address'),(2024,'Email again'),(706,'Email body'),(3255,'Email from the contact information section according to the type of email message'),(2324,'Email notifications'),(4490,'Email or login'),(3358,'Email sent to the admin'),(3356,'Email sent to the customer'),(707,'Email settings'),(3203,'Email transfer settings'),(2029,'Empty \"class\" parameter is passed to the {{method}}'),(143,'Enable'),(4161,'Enable \"Deliver to Post Office\" feature'),(4290,'Enable Advanced Matching'),(708,'Enable HTTPS'),(2981,'Enable all'),(593,'Enable clean URL'),(647,'Enable clean URLs'),(4282,'Enable facebook product feed'),(4912,'Enable hidden block'),(3285,'Enable module'),(4968,'Enable mutual links'),(2979,'Enable selected'),(4270,'Enable the Use Enhanced Cancel option.'),(2455,'Enable the option \"Assign entered Clean URL to this page anyway\" to dissociate the entered Clean URL from the page it is currently used for and assign it to the page of the object being edited.'),(2892,'Enable this if you would like us to use your shipping address as your billing address'),(709,'Enabled'),(2327,'Enabled for administrator'),(2328,'Enabled for customer'),(1605,'Enabled in catalog'),(2977,'Enabled only'),(4875,'Enter Order number'),(4122,'Enter Return # or Order #'),(714,'Enter X more characters to start search'),(182,'Enter a correct email'),(2454,'Enter a different Clean URL value for this page'),(2858,'Enter a keyword to search.'),(4743,'Enter a name to be published with the review'),(187,'Enter a negative number'),(184,'Enter a number'),(186,'Enter a positive number'),(3334,'Enter alt text'),(183,'Enter an integer'),(3508,'Enter code'),(710,'Enter coupon code'),(347,'Enter date range'),(3641,'Enter description of the purchase that will be displayed on PayPal payment page.'),(4491,'Enter email address'),(4225,'Enter file extensions separated by comma; for example, \"jpg,txt,svg\"'),(2653,'Enter filter name'),(393,'Enter keyword'),(711,'Enter keywords'),(712,'Enter license key'),(1960,'Enter pattern here'),(4527,'Enter product name'),(2799,'Enter product name or SKU'),(1963,'Enter search pattern'),(713,'Enter shipping address'),(3640,'Enter the email address associated with your PayPal account.'),(1798,'Enter the shipping address to see delivery methods available to you'),(2418,'Enter tracking number'),(4457,'Enter your MailChimp API key manually'),(1828,'Enter your e-mail'),(17,'Enter your license key here'),(3094,'Enter your premium license key'),(4847,'Entity was successfully saved'),(715,'Environment'),(716,'Environment info'),(717,'Error'),(594,'Error code explanation:'),(2855,'Error of banner loading. Make sure the \"images\" directory has write permissions.'),(2254,'Error of image loading. Make sure the \"images\" directory has write permissions.'),(2715,'Error of image verification ({{value}}). Make sure you have specified the correct image file or URL.'),(1879,'Error of uploading file.'),(4848,'Error on saving image'),(4849,'Error on saving video'),(3286,'Error sending link'),(2721,'Errors'),(2968,'Errors files'),(3966,'Estimate delivery date'),(718,'Estimate shipping cost'),(719,'Estimate your server performance'),(720,'Estimated for'),(23,'Evaluation notice'),(5022,'Every'),(2795,'Every object stores history with 8 clean urls which were previously used for this object.'),(721,'Everything you need'),(4550,'Ex.'),(1784,'Exact phrase'),(722,'Example'),(424,'Example city'),(723,'Examples'),(4578,'Excellent! Storefront is ready to get orders!'),(724,'Exception'),(4330,'Exclude from shipping cost calculation'),(2553,'Existing Avalara Customer?'),(1800,'Existing Customer?'),(4841,'Exit editor'),(4828,'Exit product preview'),(2445,'Exp. date'),(725,'Expand the functionality of your store by installing and using add-on modules'),(4931,'Expand the toolbar below to personalize store layout and style. Click the icon below to exit Store Configuration Mode at any time.'),(1933,'Expanded view'),(3836,'Expected on'),(3843,'Expected on X'),(1808,'Expiration date'),(351,'Expired'),(3539,'Expired by TTL'),(3537,'Expired by limit'),(3540,'Expires in'),(726,'Export'),(2800,'Export all'),(1637,'Export cannot be started because it is disabled or there is another running export process'),(1631,'Export completed'),(4362,'Export duplicates as separate products'),(1635,'Export failed'),(1638,'Export in CSV'),(1636,'Export not started'),(4501,'Export of Not Finished orders is not supported. To export the orders which are now in this state, change their fulfillment status from Not Finished to any other.'),(4363,'Export only the original product'),(2620,'Export orders'),(2152,'Export product data with'),(727,'Export products'),(1625,'Export public files as'),(2801,'Export selected'),(1624,'Export settings'),(1630,'Exported files'),(336,'Exported in X'),(1632,'Exporting data...'),(3760,'Express Checkout process stopped.'),(728,'Extensions'),(366,'FEBRUARY'),(362,'FR'),(4319,'FREE'),(4321,'FREE SHIPPING'),(2521,'FREE quote'),(2629,'FREE trial'),(729,'Facebook'),(4273,'Facebook Ads & Instagram Ads'),(4278,'Facebook Pixel Id'),(4284,'Facebook product feed enabled'),(730,'Failed'),(731,'Failed to add detailed image'),(732,'Failed to add the attachment'),(733,'Failed to add the attachment. The file download is forbidden'),(2256,'Failed to load the banner {{value}} because it does not exist'),(2255,'Failed to load the file {{value}} because it does not exist'),(3583,'Failed to re-upload attachment'),(1891,'Failed to update category image'),(3899,'Failed to update page image'),(1912,'Failed write to file'),(338,'Failed write to file X. There may not be enough disc-space. Please check if there is enough disc-space.'),(734,'Failed/Declined'),(2694,'Failed[S]'),(1738,'Failure'),(1804,'Failure reason:'),(3359,'Failure sending email to the admin'),(3357,'Failure sending email to the customer'),(4874,'Failure sending test email to X'),(4866,'Failure to convert flexy-template. Check for syntax errors'),(4162,'Failure to finish registration process.'),(4163,'Failure to get token ID.'),(1590,'Failure: File has the wrong format.'),(4297,'Fast Lane checkout'),(3896,'Favicon'),(1672,'Fax'),(3576,'Featured'),(735,'Featured products'),(2641,'FedEx'),(3577,'FedEx module allows to use online shipping rates calculation via FedEx.'),(4357,'Feed generation & settings'),(4360,'Feed generation has been completed successfully.'),(4361,'Feed generation has been stopped.'),(4356,'Feed generation...'),(3761,'Fees payer'),(736,'Field is required!'),(4246,'File Attaching is mandatory for this product'),(4242,'File attachments are not allowed for this product'),(2744,'File can not be uploaded'),(3585,'File description'),(3562,'File is available by public URL'),(2428,'File is not an image'),(2429,'File is not uploaded'),(4918,'File name is too long, it should be less than 255 characters'),(1871,'File not found'),(3044,'File permissions'),(284,'File size exceeds the maximum size'),(737,'File title'),(3287,'File uploading'),(3187,'File uploading error 1'),(3188,'File uploading error 2'),(3189,'File uploading error 3'),(3190,'File uploading error 4'),(3191,'File uploading error 6'),(3192,'File uploading error 7'),(3193,'File uploading error 8'),(3034,'File uploads'),(4243,'File uploads forbidden by web server'),(2802,'File was successfully uploaded'),(4395,'File with certificate should be located in the directory {{certsDir}}'),(2607,'Files cannot be updated'),(4775,'Fill out the form with your Company info to setup your account and start processing payments immedately'),(4411,'Filter by order amount'),(4409,'Filter by order frequency'),(4413,'Filter by profile membership'),(4414,'Filter by specific products'),(2657,'Filter has been removed'),(2656,'Filter has been successfully saved'),(2490,'Filter transactions by status'),(4039,'Filters'),(1961,'Find countries'),(2139,'Find in Marketplace'),(1282,'Find language in marketplace'),(4006,'Find more customers on Google'),(1962,'Find states'),(2488,'Find transactions by ID'),(738,'Find us on'),(739,'Find us on Facebook'),(4589,'Find your payment method'),(3288,'Finish'),(5033,'Finished'),(2549,'Finished operating as user'),(740,'First name'),(4441,'First name or last name are empty. Please add a new address to your address book or modify existing and fill in those fields in order to subscribe to this list.'),(4742,'First name, Last name or E-mail'),(2906,'First, restore your website from the created backup - this is the fastest way to get your store back online.'),(4801,'Firstly, you have to connect to Stripe <a href=\"{{admin_link}}\" target=\"_blank\">here</a>'),(4299,'Firstname'),(741,'Flat markup'),(2593,'Flat shipping charge per item ordered.'),(2595,'Flat shipping charge per weight unit ordered (for example, per pound or per kilogram - depending on the weight units used by your store).'),(2592,'Flat shipping charge. This value will be added to the shipping rate regardless of the weight, price and number of items ordered.'),(3804,'Flex (ppcm)'),(4861,'Flexy templates have been removed'),(4853,'Flexy to twig converter'),(4854,'Flexy-template'),(4868,'Flexy-to-twig converter warning'),(742,'Footer menu'),(2027,'For any emergency you can use the hard, soft and restore-state links'),(1693,'For details refer to'),(7,'For details refer to X-Cart license'),(743,'For the period'),(2109,'Force customer to choose product options before the product can be added to cart'),(1782,'Forgot password'),(744,'Forgot password?'),(1542,'Forgot your password?'),(745,'Format'),(2305,'Four-digit number on the front side of your card'),(42,'Free'),(3219,'Free & paid'),(746,'Free add-ons'),(2169,'Free license is activated successfully'),(4320,'Free shipping'),(4323,'Free shipping tooltip text'),(4335,'Free shipping update import text'),(4334,'Free shipping update text'),(4329,'Freight'),(4280,'Frequency of Product Feed renewal'),(4337,'Froala Editor settings'),(747,'From'),(85,'From computer'),(755,'From email'),(1831,'Front page'),(2778,'Front page title'),(3474,'Full Name'),(756,'Full description'),(757,'Full name'),(3755,'Funding methods (checkout page)'),(2016,'G'),(3054,'GDlib extension'),(758,'General'),(759,'General Settings'),(760,'General info'),(2782,'General options'),(761,'General settings'),(3885,'General tax rates'),(4355,'Generate Google Feed'),(4370,'Generate Google Product feed'),(4276,'Generate Product Feed'),(3994,'Generate XML-Sitemap'),(4621,'Generate cache on the fly'),(4348,'Generate feed'),(4287,'Generate product feed'),(2370,'Generate resized images'),(2371,'Generate resized images help text'),(3993,'Generate sitemap'),(4554,'Geo settings & company info are all set. Congrats!'),(4343,'Geolocation header promo'),(1597,'Get CSV'),(4010,'Get Started'),(3977,'Get X off for order amount over Y'),(2743,'Get a more customizeable PDF invoice solution for your store'),(2740,'Get a more powerful banner system for your store'),(2736,'Get information[TT]'),(4635,'Get params'),(2565,'Get shipping rates from major shipping carrier companies.'),(3964,'Get started Now! Click here to create your PITNEY BOWES Postage Account'),(4003,'Get your products found on Google in a few steps. Click the \"%s\" button to get started!'),(3967,'Girth'),(762,'Give buyers a way to pay by adding an alternative payment method.'),(763,'Give buyers another way to pay by adding an alternative payment method'),(1888,'Global'),(2153,'Global & Classes attributes'),(4376,'Global Hidden field'),(4375,'Global Plain field'),(4377,'Global Textarea'),(4378,'Global Yes/No'),(1887,'Global attributes'),(3544,'Global eGood settings'),(4213,'Global product tabs'),(4219,'Global tab label'),(4217,'Global tab not found'),(4579,'Go on, make your first sale.'),(764,'Go to Marketplace'),(765,'Go to checkout'),(25,'Go to checkout as a New customer'),(4182,'Go to comparison table'),(4883,'Go to different page to edit the content'),(1269,'Go to home page'),(4728,'Go to see the review [in the Admin area]'),(4541,'Go to the next step'),(3339,'Good password'),(4002,'Google Ads'),(3594,'Google Analytics'),(4347,'Google Feed URL: X'),(4354,'Google Feed has not been generated yet'),(4358,'Google Shopping Group'),(4371,'Google feed'),(4365,'Google product feed'),(4353,'Google shopping group'),(40,'Grand total'),(3819,'Gray (ppcm)'),(3814,'Grayscale (ppcm)'),(2874,'Greeting'),(172,'Greetings, X'),(766,'Grid'),(767,'Group options'),(2271,'Group {{value}} does not exists and will be created'),(4449,'Groups'),(4263,'HPP Key'),(769,'HTML title (\'title\' tag)'),(3060,'HTTPS bouncers'),(770,'HTTPS check'),(1903,'HTTPS option has been disabled'),(1902,'HTTPS option has been successfully enabled'),(771,'HTTPS settings'),(2560,'Handling fee'),(1769,'Hard reset (disables all modules and runs application)'),(2909,'Hard reset. Disable all addons except those provided by X-Cart Team'),(4634,'Hash'),(2461,'Hash file for installed entry \"{{entry}}\" doesn\'t exist or is not readable'),(3787,'Have a PayPal account?'),(776,'Have a discount coupon?'),(3482,'Have more coupons?'),(2627,'Haven\'t found what you\'re looking for? View more shipping modules'),(2875,'Header'),(2873,'Header, greeting & signature'),(2052,'Height'),(777,'Height (px)'),(228,'Hello, user'),(102,'Help'),(778,'Help zone'),(779,'Here are shown only the methods enabled on the configuration page'),(768,'Here is a new link for access to your information: X'),(4542,'Here is the way it looks like on desktop & mobile devices. Do you like it?'),(4564,'Here you can add a flat-rate shipping method'),(780,'Here you can define how your payment methods will look in customer area'),(1547,'Here you can define how your payment methods will look in customer area.'),(4561,'Here you can manually define your shipping rates and etc.'),(2587,'Here you can provide general information about the shipping method and configure a table defining how shipping rates for this method should be calculated.'),(4448,'Here you can view and manage the MailChimp news lists and groups of the user.'),(4983,'Hidden X messages'),(1927,'Hidden attributes'),(1928,'Hidden field'),(4625,'Hidden from products filter'),(781,'Hide'),(4780,'Hide \"How to use\" instruction'),(2720,'Hide all warnings/errors'),(2803,'Hide and make them available only via a direct link'),(1190,'Hide common settings'),(4916,'Hide converted templates'),(4984,'Hide message history'),(3950,'Hide the carrier shipping charge on the label'),(3949,'Hide total carrier charge'),(782,'Hide trailing zeros in fractional part'),(5006,'Hide vendor’s products in the order'),(4184,'High - Low'),(4880,'Highlight labels'),(783,'History'),(3559,'History of downloads'),(784,'Home'),(4901,'Home page'),(2790,'Home page title and meta'),(3289,'Hot addons'),(2531,'How do I move X-Cart?'),(4692,'How do you rate this item?'),(785,'How to'),(786,'How to back up your store database'),(2588,'How to define shipping rates'),(787,'How to define shipping zones'),(3080,'How to set up free shipping help'),(2458,'Human readable and SEO friendly web address for the page.'),(178,'I accept Terms and Conditions'),(788,'I agree that these addons may require an adaptation.'),(3678,'I agree with PayPal terms & conditions'),(2294,'I confirm that I have created backups of my store\'s files and database before upgrading the store'),(3093,'I have a license key'),(4558,'I sell digital goods or services and do not need to set up shipping'),(2114,'I understand that the following disabled modules will be removed.'),(4532,'I\'ll do it later'),(4462,'ID'),(4646,'IMPORTANT:'),(2004,'IN'),(3657,'IPN HTTP error'),(3656,'IPN verification failed'),(789,'Icons'),(790,'Identity'),(3215,'If a category has subcategories, the value in brackets shows the overall number of products in both that category and all its subcategories.'),(3362,'If anything crops up, just rollback or contact our support team - they know how to fix it right away.'),(3262,'If the category is disabled, the system will return 404.'),(3260,'If the product is not available for sale, the system will return 404 response.'),(3261,'If the product is not available for sale, the system will return 404.'),(791,'If there are some critical errors occurred you can do the following'),(3385,'If you are planning to use an email hosting service for this domain, please send us your MX and TXT records to helpdesk@x-cart.com so that we could add the necessary DNS entries.'),(792,'If you choose the second option, you can download the file from the server later on and delete it from the server by clicking on the \'Delete SQL file\' button.'),(1555,'If you choose to create SQL file, you will be able to download the file from the server later and after that delete it from the server by clicking on the \"Delete SQL file\" button.'),(1268,'If you continue having trouble finding what you are looking for please contact our customer service department.'),(793,'If you do not have an account, you can easily'),(3405,'If you do not have seller account, you can register here: USA UK Germany'),(794,'If you don\'t have a moneybookers account yet, please sign up for a free moneybookers account at: http://www.skrill.com'),(795,'If you have a license key for a commercial module, you can enter it here to register the purchase of the appropriate module.'),(796,'If you have a plugin in the .tar format, you can install it by uploading it here'),(1568,'If you have multiple products sharing the same set of attributes, it makes sence to make them to be of the same product type and create the attributes on the product type level.'),(3395,'If you need help with the nameservers settings just drop us a line to helpdesk@x-cart.com, we\'ll help you fix it.'),(2518,'If you purchased a template but do not see it here, activate the license key that was provided to you.'),(2910,'If you still need help, please, feel free to contact X-Cart Help Desk at helpdesk@x-cart.com.'),(293,'If you store product images in the database, they are included in the SQL dump file'),(3518,'If you want the coupon discount to be applied only to products from specific categories, specify these categories here.'),(3861,'If you want the sale discount to be applied only to products from specific categories, specify these categories here.'),(4107,'If you want to enable merchant registration wizard once again, please click on the following link'),(1553,'If you want to upload the backup of another X-Cart installation, ensure that you have completed the steps described here'),(2031,'If your store is crashed after upgrade, you can recover it'),(2804,'Ignore membership'),(797,'Image'),(190,'Image X'),(798,'Image border will not be displayed in customer\'s frontend'),(799,'Image has been identified as a duplicate and has not been imported'),(3114,'Image quality after resize'),(2146,'Image resized: X out of Y'),(2150,'Image resized: X out of Y with errors'),(3136,'Image resizing requires libraries'),(115,'Images'),(116,'Images Settings & Uploading'),(2368,'Images resized'),(2384,'Images resized: {{count}}'),(3753,'Immediate'),(3436,'Immediate Charge'),(800,'Import'),(801,'Import / Export'),(3222,'Import and Export'),(1522,'Import by CSV'),(3635,'Import from CSV file'),(802,'Import from file'),(2151,'Import has been cancelled.'),(2432,'Import language'),(1964,'Import language from CSV file'),(260,'Import mechanism does not know the field of X and it can not be imported'),(1978,'Import mode'),(1981,'Import mode comment'),(2805,'Import results'),(1514,'Import settings'),(803,'Import/Export'),(2392,'Import/Export guide'),(804,'Important'),(4333,'Important info on the Free shipping addon update'),(2362,'Imported'),(2363,'Importing data...'),(257,'Importing will overwrite the existing product information. This operation cannot be undone.'),(2284,'In advanced mode you can choose specific modules for upgrade.'),(3840,'In catalog only'),(805,'In category'),(1548,'In order to accept credit cards payments you should install the necessary payment module from our Marketplace.'),(2690,'In progress[S]'),(806,'In stock'),(4620,'In stock only'),(4080,'In store currency (0 - do not use coverage)'),(4770,'In the form that opens, paste the \"Webhook URL\" value into the field \"URL to be called\" and click \"Add endpoint\".'),(4769,'In the section \"Endpoints receiving events from your account\", click \"+ Add endpoint\".'),(2460,'In this section you can review the recent payment transactions that have taken place at your store'),(807,'Inactive'),(2672,'Inactive license key ({{key}})'),(808,'Incl. X'),(4288,'Include out of stock products into feed'),(3846,'Include response in hash'),(250,'Including X'),(1583,'Including subcategories'),(1726,'Incomplete'),(809,'Incompleted'),(2752,'Incorrect amount'),(281,'Incorrect owner of X directory'),(283,'Incorrect owner of X file'),(2497,'Incorrect password. Please try again.'),(2751,'Incorrect permissions'),(4004,'Increase sales and revenue with Google Shopping Ads.'),(3886,'Individual settings for every rate'),(2806,'Info'),(4757,'Information'),(2691,'Initialized[S]'),(2807,'Initializing...'),(4882,'Inline editor'),(4830,'Inline editor is unavailable due to TinyMCE'),(3798,'Inline logo'),(810,'InnoDB engine support enabled'),(2125,'Input data'),(3348,'Insight: Boost your sales with Google Ads addon'),(811,'Install'),(4893,'Install Google Tag Manager'),(4456,'Install Mailchimp addon'),(3176,'Install TaxJar integration'),(812,'Install add-on'),(1966,'Install addons'),(2851,'Install anyway'),(813,'Install updates'),(2434,'Installation date'),(814,'Installation directory'),(3290,'Installation requirements'),(3017,'Installation script'),(2538,'Installation warnings'),(815,'Installed'),(3218,'Installed Addons'),(816,'Installed Modules'),(817,'Installed modules'),(1663,'Installed version'),(3182,'Installing addons'),(818,'Installing updates, please wait...'),(3946,'Insurance value'),(2625,'Integration with'),(2959,'Integrity check'),(2970,'Integrity check has been completed successfully.'),(2971,'Integrity check has been stopped.'),(2969,'Integrity has not yet been checked. Initiate an integrity check by clicking the button \"Refresh integrity status\".'),(595,'Internal server error'),(4587,'International: phone'),(819,'Invalid login or password'),(820,'Invalid login or password. You can use forgot password form to create a new password.'),(4049,'Inventory'),(1904,'Inventory has been successfully updated'),(821,'Inventory status'),(822,'Inventory tracking'),(3628,'Inventory tracking for product X will not be imported'),(823,'Inventory tracking for this product is'),(2808,'Inventory tracking is'),(2176,'Inventory tracking options'),(824,'Invoice'),(1840,'Invoice #{{orderId}}, {{time}}'),(207,'Invoice X'),(2057,'Invoice number prefix'),(3570,'Ip'),(3943,'Irregular parcel girth'),(1809,'Issue no'),(825,'It is impossible to delete or create user accounts because your store currently works as an integration with Drupal and shares users with Drupal. Deleting/creating user accounts is possible via Drupal administrator interface.'),(826,'It is impossible to edit some user profile fields because your store currently works as an integration with Drupal and shares users with Drupal. Modifying these fields is possible via Drupal administrator interface.'),(5062,'It will be charged on X'),(1502,'It\'s impossible to detect valid SSL certificate availability on your server because curl extension is not installed.'),(3460,'It\'s recommended to limit the length of invoice prefix to 9 characters'),(1934,'Item'),(827,'Item description'),(828,'Item has been deleted from cart'),(1850,'Item has not been deleted from cart'),(2861,'Item list'),(829,'Item name'),(2225,'Item not found ({{keys}})'),(213,'Items'),(160,'Items in your cart: X'),(830,'Items per page'),(2577,'Items range'),(365,'JANUARY'),(371,'JULY'),(370,'JUNE'),(4193,'Joe'),(831,'Join forces with your bank'),(480,'Joined'),(2953,'Just enter email address'),(832,'K'),(2015,'KG'),(4008,'Keep your marketing and store in sync'),(1477,'Key is validated, but the module X was not found'),(103,'Knowledge Base'),(4583,'Knowledge base'),(2013,'LB'),(1925,'Label'),(3947,'Label format'),(133,'Label name'),(3948,'Label size'),(1917,'Labels'),(4834,'Labels editor'),(833,'Language'),(834,'Language labels'),(140,'Language name in X'),(97,'Language options'),(1586,'Language:'),(101,'Languages'),(3810,'Large (ppcm)'),(1750,'Last 24 hours'),(1751,'Last 7 days'),(162,'Last added items'),(3077,'Last element of category path should be same as name'),(3347,'Last exported'),(835,'Last logged in'),(836,'Last login'),(1752,'Last month'),(837,'Last name'),(2304,'Last three numbers on the back side of your card'),(2900,'Last time re-deployed at'),(2464,'Last week'),(2466,'Last year'),(4300,'Lastname'),(3451,'Launch'),(4577,'Launch (Paypal Onboarding)'),(4011,'Launch Google Shopping ads and get your products found online easily.'),(3676,'Launch PayPal'),(2213,'Layout'),(3823,'Layout (ppcm)'),(4881,'Layout block'),(4832,'Layout editor'),(4844,'Layout editor allows you to change the position of the blocks in drag-n-drop fashion'),(4836,'Layout editor is'),(4843,'Layout editor is disabled'),(4842,'Layout editor is enabled'),(2522,'Layout has been changed. Review the updated storefront.'),(2514,'Layout type'),(4894,'Layout was successfully reset'),(2313,'Learn More'),(4890,'Learn more about Google Tag Manager'),(81,'Learn more about the top banner and how it shows in the page layout'),(2314,'Learn more.'),(4118,'Leave at door'),(2511,'Leave blank to use category name as Page Title.'),(4485,'Leave blank to use news title as Page Title.'),(3914,'Leave blank to use page name as Page Title.'),(2499,'Leave blank to use product name as Page Title.'),(3805,'Left (ppcm)'),(3333,'Left in stock: {{quantity}}'),(2050,'Length'),(1572,'Length x Width x Height'),(1787,'Less search options'),(3173,'Let TaxJar automate your sales tax calculations, reporting, and filings in minutes.'),(4943,'Letter center'),(4516,'Let’s set up your store'),(8,'License activation is not available'),(1483,'License is not received'),(2444,'License key'),(2440,'License key has been successfully verified and activated for \"{{name}}\" module by \"{{author}}\" author.'),(838,'License key has been successfully verified for \"{{name}}\" module by \"{{author}}\" author'),(2675,'License key is missing'),(3097,'License key registration'),(2671,'License warning'),(3291,'License warnings'),(2433,'License: trial version'),(839,'Lifetime'),(3495,'Limit number of uses'),(840,'Limit the number of uses'),(2143,'Lines checked: X out of Y'),(2144,'Lines imported: X out of Y'),(2148,'Lines imported: X out of Y with errors'),(2147,'Lines verified: X out of Y with errors'),(841,'Link'),(842,'List'),(843,'List of states'),(4421,'List rating'),(3858,'List sale products in a separate section'),(1993,'Live'),(2082,'Live mode'),(2859,'Loading more results...'),(1882,'Loading the database from file .'),(844,'Loading...'),(845,'Localization'),(4344,'Location is invalid'),(4341,'Location was successfully set'),(2090,'Locked'),(4164,'Log all communications between shopping cart and Canada Post server'),(2424,'Log files not found'),(846,'Log in'),(2742,'Log in as this admin'),(240,'Log off'),(847,'Log out'),(848,'Logged as'),(3906,'Logged in users only'),(239,'Logged in!'),(849,'Login'),(1801,'Login Here'),(2427,'Login dates'),(850,'Login here'),(851,'Login history'),(2809,'Login is locked out'),(2954,'Login to your account'),(3368,'Login with'),(1937,'Login/E-mail'),(3895,'Logo'),(3908,'Logo & Favicon'),(3367,'Logo alt'),(3801,'Logo position'),(3800,'Logo type'),(3011,'Logout this user'),(852,'Look & Feel'),(3072,'Loopback request'),(1697,'Loopback test'),(4185,'Low - High'),(320,'Low inventory products'),(853,'Low limit notification for this product is'),(854,'Low limit quantity'),(855,'Low stock'),(2465,'Low stock info'),(4062,'Low stock notification to admin'),(4061,'Low stock warning on product page'),(856,'M'),(367,'MARCH'),(3722,'MATCH_CRITERIA_DISABLED'),(3719,'MATCH_CRITERIA_HELP'),(3720,'MATCH_CRITERIA_NAME'),(3721,'MATCH_CRITERIA_NONE'),(369,'MAY'),(3844,'MD5 hash value'),(2001,'MM'),(358,'MO'),(2300,'MONTH'),(4396,'MailChimp'),(4397,'MailChimp Integration with E-commerce support'),(4402,'MailChimp Lists'),(4400,'MailChimp is an email marketing service with powerful tools to manage your email campaigns and subscribers while gathering advanced analytics information on your campaign performance.'),(4445,'MailChimp list group names'),(4444,'MailChimp list groups'),(4403,'MailChimp list segments'),(4463,'MailChimp lists'),(4440,'MailChimp lists update'),(4404,'MailChimp segment settings'),(4464,'MailChimp settings'),(4097,'Mailing tube'),(121,'Main categories'),(857,'Maintenance'),(858,'Maintenance and operation'),(2864,'Major improvements and new features'),(2863,'Major upgrade'),(3450,'Make Amazon’s customers your customers with Amazon Pay.'),(2507,'Make a discount available to all customers or only to specific membership levels;'),(859,'Make back-up of your store database'),(4019,'Make changes to your active campaigns, purchase one you built, or reinstate your cancelled campaigns.'),(4973,'Make mutual relations'),(3197,'Make sure the URL is correct and the file referenced by the URL is a PNG/JPG/JPEG'),(1880,'Making backup of the current database state ... '),(4018,'Manage Campaigns'),(867,'Manage admins'),(1877,'Manage attribute groups'),(860,'Manage catalog'),(861,'Manage categories'),(343,'Manage category (X)'),(862,'Manage customer and administrator accounts'),(4211,'Manage global tabs'),(1688,'Manage groups'),(863,'Manage layout'),(3202,'Manage logo dimensions'),(864,'Manage orders'),(865,'Manage orders placed at your store'),(1567,'Manage product classes'),(4465,'Manage segments'),(3388,'Manage subscriptions'),(866,'Manage users'),(4571,'Manage your payment options'),(868,'Manage your product inventory'),(2810,'Manage zones'),(869,'Mandatory fields are marked with an asterisk'),(4089,'Manifest ID'),(4088,'Manifests'),(4632,'Manual'),(3631,'Manually'),(870,'Manually defined shipping methods'),(5013,'Mark all'),(5014,'Mark selected'),(871,'Mark, the search engines you want to inform of the structure of your site using the site map'),(872,'Market price'),(2811,'Marketing'),(873,'Marketplace'),(874,'Marketplace [check_addon_key]: the \"{{url}}\" URL requested'),(875,'Marketplace [check_for_updates]: the \"{{url}}\" URL requested'),(876,'Marketplace [check_for_updates]: valid response received'),(877,'Marketplace [get_hosting_score]: response has an invalid format'),(878,'Marketplace [get_hosting_score]: the \"{{url}}\" URL requested'),(2290,'Marketplace-Vendor'),(879,'Markup per item'),(880,'Markup per weight unit'),(1783,'Max'),(4230,'Max allowed file size is X'),(4165,'Maximum Post Offices that will be displayed'),(2867,'Maximum items in box'),(1573,'Maximum number of items per box'),(3496,'Maximum number of uses'),(3492,'Maximum order subtotal must be greater than minimum order subtotal'),(3503,'Maximum order subtotal the coupon can be applied to'),(278,'Maximum size of the file to upload is N'),(1878,'Measuring productivity in manual mode failed.'),(3809,'Medium (ppcm)'),(4422,'Members count'),(881,'Membership'),(882,'Membership access'),(883,'Membership levels'),(884,'Membership name'),(885,'Memberships'),(3031,'Memory limit'),(2088,'Menu'),(3898,'Menu links help text'),(886,'Menus'),(3773,'Merchant Id'),(3646,'Merchant login'),(4105,'Merchant registration wizard'),(206,'Merge with Registered'),(887,'Message'),(3471,'Message has been sent'),(4977,'Message not found'),(4976,'Messages'),(83,'Meta desc'),(888,'Meta description'),(889,'Meta keywords'),(82,'Meta tags'),(2416,'Method name'),(890,'Methods'),(3491,'Minimum order subtotal must be less than maximum order subtotal'),(3502,'Minimum order subtotal the coupon can be applied to'),(3983,'Minimum order subtotal to which the volume discount can be applied'),(2812,'Minimum value is X'),(2865,'Minor improvements'),(2862,'Minor update'),(5029,'Missed payment'),(2966,'Modified files'),(1570,'Modifiers'),(891,'Modify'),(892,'Modify \"{{name}}\" option group'),(893,'Modify category'),(894,'Modify option groups exceptions'),(895,'Modify root category (the front shop page)'),(4001,'Module Kliken\\GoogleAds was unable to access your store\'s catalog . Please make sure the correct Account Id and Application Token are saved, or contact Kliken for support.'),(2391,'Module Marketplace. Terms of use'),(129,'Module available editions 3'),(130,'Module available editions 4'),(896,'Module has been successfully installed'),(3292,'Module name'),(1873,'Module packing is available in the DEVELOPER mode only. Check etc/config.php file'),(2401,'Module page'),(4563,'Module settings (shipping_rates)'),(1497,'Module with ID X is not found'),(1668,'Module\'s page'),(2813,'Modules'),(1488,'Modules have been successfully installed'),(1905,'Modules license agreements'),(3293,'Monday'),(4995,'Monitoring of communication related to oder #X has been disabled'),(4994,'Monitoring of communication related to oder #X has been enabled'),(3813,'Monochrome (ppcm)'),(384,'Month'),(5038,'Monthly'),(1821,'More'),(1968,'More actions for selected'),(898,'More add-ons'),(2615,'More attributes'),(899,'More details'),(2038,'More info is available in X-Cart\'s Knowledge Base article \'What to do if you cannot access your store...\''),(596,'More information about clean urls in X-Cart is available in '),(649,'More information on Clean URL problems on your system'),(4771,'More information on the setup of webhooks is available here: https://stripe.com/docs/webhooks#configuring-your-webhook-settings'),(4551,'More localisation settings'),(1788,'More search options'),(4565,'More shipping methods'),(2649,'More shipping solutions'),(900,'Most Popular'),(901,'Most Rated'),(902,'Move'),(4131,'Move item'),(4059,'Move to'),(2009,'Mr.'),(2011,'Mrs.'),(2010,'Ms.'),(3599,'Multiple top-level domains'),(4961,'Mutual link'),(4971,'Mutual link head help'),(4594,'My Shipping'),(903,'My account'),(3127,'My addons'),(4338,'My location'),(3131,'My profile'),(3140,'My purchases'),(4562,'My shipping'),(3052,'MySQL cache'),(904,'MySQL server'),(3048,'MySQL version'),(125,'N it.'),(95,'N items found'),(124,'N items total'),(375,'NOVEMBER'),(905,'Name'),(1922,'Name asc'),(1923,'Name desc'),(4596,'Name length must be less then {{length}}'),(909,'Name of account holder'),(906,'Name of address field'),(907,'Name of purchaser'),(1566,'Name, e.g. Apparel'),(1037,'Name-sort-option'),(2346,'Names, descriptions & sorting'),(141,'Native language name'),(3686,'Near \"Add to cart\" button'),(3687,'Near \"Checkout\" button'),(3169,'Need a customizable contact us form with location map? [Get it now!]'),(19,'Need a license key?'),(3111,'Need a way to set multicurrency prices? [Install the addon]'),(3112,'Need a way to set up product variants? [Install the addon]'),(3113,'Need a way to set wholesale prices? [Install the addon]'),(2520,'Need custom design? We can modify this template or create a completely unique design for you'),(1690,'Need license key?'),(1549,'Need more payment methods?'),(910,'Never'),(1621,'New Export'),(4205,'New Tab'),(2403,'New access codes were generated.'),(912,'New access key will also be sent to the Site administrator\'s email address'),(911,'New access link'),(2382,'New account'),(1541,'New address'),(913,'New address field'),(3831,'New arrivals'),(1687,'New attribute'),(2259,'New attribute group will be created'),(119,'New category'),(2703,'New customer note'),(914,'New discount coupon'),(1620,'New group'),(915,'New image'),(1508,'New import'),(916,'New item'),(109,'New membership'),(5012,'New message'),(4985,'New message for order'),(5004,'New messages'),(2117,'New module version available for core versions X'),(2468,'New modules'),(4474,'New news message'),(917,'New page'),(4132,'New parcel'),(918,'New product class'),(919,'New product has been added successfully'),(4719,'New product reviews'),(920,'New rate'),(921,'New role'),(1767,'New safe mode access key has been generated'),(3857,'New sale'),(3887,'New sale tax rate'),(2190,'New staff note'),(4204,'New tab'),(4638,'New tag'),(1307,'New tax class'),(2551,'New to Avalara?'),(24,'New to our store?'),(1748,'New user registered'),(1619,'New value'),(168,'New zone has been created successfully'),(3832,'New!'),(922,'Newest'),(923,'Newest first'),(4475,'News'),(4407,'News list subscriptions'),(4473,'News message'),(4472,'News messages'),(4483,'News page title'),(4484,'News title'),(4495,'Newsletters'),(924,'Next'),(4479,'Next news'),(3109,'Next order'),(925,'Next page'),(5028,'Next payment'),(32,'Next product'),(4318,'Next step'),(76,'Next wizard'),(926,'No'),(1416,'No Curl extension for PHP error'),(1417,'No OpenSSL extension for PHP error'),(3620,'No PIN codes found.'),(1415,'No Phar extension for PHP error'),(2952,'No account yet?'),(2623,'No accounting system has been selected yet. Choose your accounting system below and configure it.'),(1581,'No attributes'),(1689,'No attributes are defined for the product class yet.'),(1582,'No attributes assigned'),(2986,'No category assigned'),(1863,'No category defined'),(2166,'No class'),(4944,'No confirmation'),(927,'No countries found'),(1999,'No delimiter'),(2345,'No discount modules installed'),(4745,'No email'),(4075,'No events found'),(928,'No featured products defined for this category'),(3194,'No file was uploaded'),(4860,'No flexy-templates found.'),(1580,'No group'),(4466,'No groups defined'),(929,'No image'),(930,'No images uploaded'),(2407,'No items found'),(931,'No items found.'),(4148,'No items have been selected for return.'),(3799,'No logo'),(395,'No membership'),(932,'No merchant account required'),(500,'No merchant account required. Simple onboarding for you and easy checkout for your customers.'),(2408,'No model selected'),(1659,'No modules found'),(96,'No modules found for search_string'),(933,'No order have been placed yet'),(327,'No order on last day'),(330,'No order on last lifetime'),(329,'No order on last month'),(328,'No order on last week'),(331,'No orders'),(4870,'No orders available. Please create at least one order.'),(934,'No orders have been placed yet'),(100,'No other languages defined'),(1853,'No payment method selected'),(1854,'No payment methods found based on the selected criteria'),(935,'No payment modules installed'),(3623,'No pin codes are bought yet'),(1616,'No pre-defined value'),(1565,'No product class assigned'),(1661,'No products found'),(4610,'No products have been selected for comparison.'),(4042,'No products matching the current filtering criteria were found. Try clearing filters.'),(4617,'No products matching your criteria found. Please try again with different parameters.'),(936,'No products sold yet'),(1662,'No profiles found'),(2532,'No region'),(2857,'No results found.'),(4706,'No reviews.'),(3163,'No roundup'),(4467,'No segments'),(937,'No states found'),(4419,'No subscription'),(5026,'No subscriptions'),(1543,'No such user'),(938,'No tax rate defined'),(1177,'No tracking numbers are defined'),(1660,'No users found'),(3609,'No valid code found.'),(3951,'Non delivery option'),(939,'Non-administrator'),(3294,'Non-critical'),(4166,'Non-delivery instructions'),(230,'None'),(4502,'Not Finished orders were skipped during the export process. If you wish to export the orders which are now in this state, change their fulfillment status from Not Finished to any other.'),(2987,'Not assigned'),(3295,'Not available'),(1699,'Not detected'),(2028,'Not enough disk space. Required: {{req}} (+{{reserve}} reserve). Available: {{avail}}'),(4917,'Not enough permissions to update the template file'),(940,'Not finished'),(4497,'Not finished order'),(4504,'Not finished orders are skipped during the export process. Change the fulfillment status of these orders to make it exported.'),(941,'Not numeric'),(4707,'Not rated yet'),(2621,'Not seeing your accounting software here? Let us know'),(1598,'Not selected'),(4060,'Not set'),(4110,'Not specified'),(942,'Note'),(2049,'Note: a new window will be opened'),(943,'Notes'),(2338,'Notification'),(2877,'Notification state'),(2717,'Notify administrator if the stock quantity of this product goes below a certain limit'),(944,'Notify administrator inactivity help'),(3782,'Now Accepting'),(1734,'Now disabled'),(4569,'Now you can define how shipping rates should be calculated based on  delivery time, weight and other parameters.'),(1588,'Number of ignored rows:'),(374,'OCTOBER'),(4920,'OK'),(4597,'OK, now let’s get your store ready for sales'),(1679,'OR'),(2014,'OZ'),(2781,'Object name (category, product, etc)'),(2773,'Object name order first'),(2774,'Object name order last'),(3712,'Obtaining your live PayPal credentials'),(945,'Off'),(946,'Official website'),(4573,'Offline method'),(947,'Offline methods'),(3084,'Ok, Got it'),(2702,'Old customer note'),(948,'Old price'),(2189,'Old staff note'),(949,'On'),(950,'On all catalog pages'),(4945,'On call air'),(3841,'On catalog and product pages'),(2922,'On category and product details page'),(2921,'On category listing'),(4101,'On delivery'),(4100,'On exception'),(4697,'On moderation'),(951,'On product details only'),(3850,'On sale'),(4099,'On shipment'),(4595,'Onboarding Wizard'),(4603,'Onboarding: Get shipping rates from major shipping carrier companies.'),(1297,'Once links are regenerated, they will be sent to store administrator email.'),(4304,'One Page checkout'),(2217,'One column'),(3598,'One domain with multiple subdomains'),(4946,'One time pickup'),(952,'Online catalog structure setup'),(4574,'Online method'),(436,'Online methods'),(2136,'Online orders'),(2718,'Only X left in stock'),(4702,'Only customers who purchased this product can leave feedback on this product'),(112,'Only disabled'),(111,'Only enabled'),(1872,'Only enabled modules can be packed'),(2920,'Only orders awaiting processing'),(953,'Only small letter, digits and undescore sign are allowed'),(3325,'Oops, no products have been added to this category yet.'),(1944,'Open'),(954,'Open Graph meta tags'),(5001,'Open a dispute'),(4990,'Open dispute'),(3910,'Open graph image'),(955,'Open graph tags'),(4884,'Open home or category pages for more opportunities to adjust the website structure'),(4423,'Open rate'),(956,'Open storefront'),(4768,'Open the page \"Webhooks\" in the \"Developers\" section of dashboard.stripe.com: https://dashboard.stripe.com/account/webhooks'),(4543,'Open the storefront and check how it looks like on desktop.'),(4888,'Open the storefront while logged in as administrator to change the look & feel of the store.'),(4015,'Open your dashboard to review your campaign\'s performance'),(2545,'Operate as user'),(957,'Operating system'),(3406,'Operation mode'),(958,'Option group'),(3455,'Option values has been successfully updated.'),(2814,'Options'),(959,'Options have been successfully changed'),(2397,'Options:'),(3148,'Or add a video review powered by ShopperApproved'),(3698,'Or register with'),(3697,'Or sign in the classic way'),(3701,'Or use your social account'),(960,'Order'),(961,'Order #'),(266,'Order #X, Y'),(1959,'Order #{{id}}'),(1969,'Order #{{id}} details'),(3567,'Order #{{value}} doesn\'t contain any e-goods'),(3633,'Order #{{value}} doesn\'t have any associated pin codes'),(962,'Order ID'),(2666,'Order QTY'),(963,'Order Total'),(300,'Order Total X'),(267,'Order X'),(5061,'Order X created for next payment on subscription X'),(3006,'Order X has been confirmed as delivered to the customer'),(1523,'Order by'),(1829,'Order can not be placed because not all required fields are completed. Please check the form and try again.'),(4309,'Order cannot be placed because some steps are not completed'),(2815,'Order cannot be placed because there is no shipping methods available.'),(2206,'Order changes cannot be saved due to negative total value'),(3171,'Order customer notes changed'),(2663,'Order date'),(964,'Order date from'),(965,'Order date through'),(3616,'Order deleted'),(966,'Order details'),(2435,'Order failed'),(3563,'Order fulfilment status changed from {{oldStatus}} to {{newStatus}} by file download'),(3172,'Order has been edited'),(1931,'Order history'),(967,'Order id'),(3658,'Order id prefix'),(3536,'Order is not processed'),(318,'Order is placed'),(2200,'Order item attributes are out-of-date and cannot be edited'),(2943,'Order item modifier not found'),(968,'Order items'),(2933,'Order modifier not found'),(1852,'Order not found'),(969,'Order note'),(4305,'Order note. Any special needs?'),(1794,'Order number'),(2816,'Order number or email'),(970,'Order page'),(1781,'Order payment'),(2122,'Order payment status changed from {{oldStatus}} to {{newStatus}}'),(3350,'Order placed'),(3921,'Order prefix'),(971,'Order review'),(2123,'Order shipping status changed from {{oldStatus}} to {{newStatus}}'),(3170,'Order staff notes changed'),(972,'Order statistics'),(973,'Order status'),(2107,'Order status changed from {{oldStatus}} to {{newStatus}}'),(4197,'Order statuses'),(1174,'Order tracking information'),(2947,'Order transaction status not found'),(2949,'Order transaction type not found'),(2201,'Order will be delivered to the billing address.'),(2762,'OrderBy position number must be specified as a non-negative integer.'),(345,'OrderID or email, ID1-ID2 for range'),(3414,'OrderId prefix'),(3553,'Ordered files'),(4128,'Ordered qty'),(974,'Orders'),(2918,'Orders awaiting processing'),(975,'Orders count'),(2669,'Orders has been deleted successfully'),(4199,'Orders have this status tooltip'),(4410,'Orders last month'),(2385,'Orders list'),(976,'Orders placed'),(4979,'Orders with any messages'),(4978,'Orders with unread messages'),(2646,'Origin address'),(3344,'Original name'),(227,'Other'),(163,'Other items'),(4902,'Other pages'),(107,'Our Blog'),(3477,'Our location'),(1819,'Out of Stock'),(977,'Out of stock'),(4098,'Oversized'),(3037,'PDO extension'),(1701,'PHP \'gd\' extension is not installed.'),(3022,'PHP version'),(3610,'PIN'),(3625,'PIN code'),(3626,'PIN codes'),(3624,'PIN codes data have been successfully updated'),(3612,'PIN codes enabled'),(3629,'PIN codes generation method'),(4087,'PO Number'),(1072,'PO number'),(2137,'POS orders'),(3713,'PRIMARYRECEIVER'),(4262,'PS Store ID'),(978,'Pack it'),(1674,'Package'),(2073,'Package dimensions (inches)'),(4167,'Package height (cm)'),(4168,'Package length (cm)'),(4169,'Package maximum weight (kg)'),(2068,'Package properties'),(2044,'Package subtotal'),(2045,'Package subtotal (X)'),(2042,'Package weight'),(2043,'Package weight (X)'),(4170,'Package width (cm)'),(2072,'Packaging'),(2662,'Packing date'),(2660,'Packing slip'),(979,'Page'),(980,'Page URL'),(981,'Page name'),(982,'Page not found'),(2791,'Page title format'),(983,'Pages'),(984,'Paid'),(4081,'Parcel'),(4090,'Parcel characteristics'),(3942,'Parcel dimensions'),(4121,'Parcel is cannot be transmitted - wrong quote type'),(4120,'Parcel is cannot be voided or transmitted - wrong quote type'),(4079,'Parcel options'),(3940,'Parcel type'),(3941,'Parcel weight'),(4137,'Parcels have been successfully updated'),(985,'Parent category'),(2974,'Parent category name'),(2780,'Parent category path'),(354,'Partially refunded'),(3644,'Partner name'),(3296,'Passed'),(219,'Password'),(986,'Password and its confirmation do not match'),(378,'Past'),(4821,'Path for using in custom CSS'),(987,'Pattern search'),(3415,'Pay with Amazon'),(3703,'PayPal'),(3664,'PayPal API'),(3688,'PayPal API (Merchant API) will work for most merchants; however, some merchants may have access only to Payflow API.'),(3733,'PayPal API Client ID'),(3734,'PayPal API Secret'),(3736,'PayPal BN Code'),(3714,'PayPal Credit'),(3790,'PayPal Credit Messaging'),(3677,'PayPal Credit is'),(3762,'PayPal Express Checkout (legacy)'),(3732,'PayPal For Marketplaces account email'),(3639,'PayPal ID / Email'),(3728,'PayPal Merchant ID'),(3735,'PayPal Partner ID'),(3663,'PayPal Publisher ID'),(3785,'PayPal Settings'),(3679,'PayPal account email'),(3786,'PayPal checkout and PayPal express checkout (legacy) / PayPal Payments Advanced are not able to work together.'),(3648,'PayPal recommends entering a User Login here instead of your Merchant Login'),(3437,'PayWithAmazon available actions'),(3707,'PayerID value was not returned by PayPal. Please try again. If the problem persists, contact the administrator.'),(3665,'Payflow API'),(2898,'Payment'),(4599,'Payment Processing'),(3421,'Payment capture error: {{error}}'),(994,'Payment data ({{method}})'),(988,'Payment gateways'),(3427,'Payment has been authorized successfully.'),(3691,'Payment has been captured successfully'),(3420,'Payment has been captured successfully.'),(3428,'Payment has been declined.'),(3689,'Payment has been refunded successfully'),(3424,'Payment has been refunded successfully.'),(3690,'Payment has been voided successfully'),(3763,'Payment has bes refunded successfully'),(3765,'Payment have been voided successfully'),(3422,'Payment have been voided successfully.'),(989,'Payment info'),(990,'Payment instructions'),(2388,'Payment is not required'),(991,'Payment method'),(993,'Payment method data'),(2536,'Payment method has been added'),(1876,'Payment method has been added successfully'),(312,'Payment method has been disabled successfully'),(311,'Payment method has been enabled successfully'),(313,'Payment method has been removed successfully'),(314,'Payment method has not been configured properly'),(2348,'Payment method is disabled'),(2347,'Payment method is enabled'),(4800,'Payment method is not available'),(2425,'Payment method settings'),(2537,'Payment method was not added'),(992,'Payment methods'),(3297,'Payment order status'),(4022,'Payment processed with errors. Please, try again or ask administrator'),(3438,'Payment refresh error: {{error}}'),(3426,'Payment refund error: {{error}}'),(4390,'Payment return page requested without expected parameters'),(995,'Payment settings'),(2118,'Payment status'),(2931,'Payment status not found, \"Awaiting payment\" will be used for order'),(4201,'Payment status not found, new status will be created'),(4195,'Payment statuses'),(996,'Payment transaction ID'),(302,'Payment transaction X issued'),(3429,'Payment transaction is in progress...'),(997,'Payment transactions'),(3423,'Payment void error: {{error}}'),(301,'Payment was not finished'),(998,'Payments'),(3750,'Payments with this payment method are not allowed because HTTPS is not configured'),(3705,'Paypal capture warning message'),(3764,'Paypal login (email)'),(999,'Pending'),(234,'Pending membership'),(1000,'Pending memberships'),(2693,'Pending[S]'),(1001,'Per item markup'),(1002,'Per weight unit markup'),(1003,'Percent'),(3980,'Percent discount value cannot exceed 100%'),(1004,'Percent markup'),(1005,'Percent off'),(1006,'Perform order search'),(1007,'Performance'),(2911,'Performing task...'),(3365,'Period end date must be later than period start date'),(3364,'Period start date must be sooner than period end date'),(1008,'Permissions'),(1009,'Permissions checking failed'),(1010,'Personal info'),(1323,'Personal info: The new password must not coincide with the current password for your account.'),(4926,'Personalize Logos'),(3057,'Phar extension'),(1011,'Phone'),(1012,'Pick address from address book'),(4809,'Pick template from page element'),(4878,'Pick templates from page'),(3591,'Pin'),(3590,'Pin It'),(3968,'PitneyBowes'),(1013,'Place order'),(180,'Place order X'),(2184,'Placed by NAME'),(2183,'Placed by _NAME_'),(1678,'Placed on'),(2182,'Placed on DATE'),(298,'Placed on X by Y'),(299,'Placed on X by Y link'),(1926,'Plain field'),(5020,'Plan'),(5068,'Planned date of the next payment'),(1657,'Please'),(1014,'Please accept the Terms and Conditions to continue'),(4183,'Please add another product to comparison'),(2978,'Please be warned that proper operation of the site after an upgrade is not guaranteed if you choose to upgrade only some of the components listed below.'),(3394,'Please check the nameservers settings in your account on the registrar\'s website.'),(1015,'Please choose the appropriate action'),(1589,'Please confirm if you want proceed with the import otherwise cancel the operation.'),(1289,'Please contact the module developers to make sure that these modules are compatible with the upcoming upgrade'),(2126,'Please create a new password'),(1016,'Please enable JavaScript in your web browser.'),(2860,'Please enter 3 or more characters'),(3470,'Please enter the correct captcha'),(1722,'Please enter the correct file location or set correct file permissions.'),(4755,'Please enter your encryption password (This is different from your merchant password). More info on encryption passwords is available <here>'),(1017,'Please identify yourself'),(1533,'Please make sure that \"min weight\", \"min total\", \"min items\", \"shipping zone\", \"shipping method\" fields do not overlap with other shipping rates.'),(1595,'Please make sure your file format is as described.'),(3381,'Please note that during the domain name transferring your store will be temporarily blocked. This process may take several minutes.'),(4103,'Please note that rates are calculated for shipping from Canadian locations only.'),(1018,'Please note that some of these modules are definitely incompatible with the upcoming upgrade and will be disabled in order to prevent the system crash'),(2381,'Please note that the following modules will also be enabled'),(3960,'Please note: the USPS Web tools APIs print labels without postage.'),(3101,'Please register your license key now or purchase a premium license to skyrocket your business.'),(2443,'Please renew your access to upgrades to get new superior features from the latest releases.'),(4730,'Please review purchased product {{product}}'),(4732,'Please review purchased products'),(1019,'Please run the benchmark test in order to estimate your server performance'),(1020,'Please save the soft reset and hard reset links so that you can use them later in case the website crash happens'),(3216,'Please select'),(392,'Please select a date range'),(391,'Please select a date range between %d and %d days'),(390,'Please select a date range less than %d days'),(389,'Please select a date range longer than %d days'),(3374,'Please select an option'),(1021,'Please select one'),(397,'Please select one ...'),(398,'Please select option'),(1846,'Please select other attribute'),(4372,'Please select the attributes first'),(2308,'Please select the countries first'),(3298,'Please select the entities first'),(2668,'Please select the orders first'),(1832,'Please select the products first'),(4716,'Please select the reviews first'),(2173,'Please select the states first'),(4640,'Please select the tags first'),(4675,'Please sign in to add review'),(149,'Please specify a pattern to find the required labels'),(1479,'Please specify non-empty key'),(128,'Please specify text labels for each language'),(5067,'Please try to use another payment card or contact the store administrator'),(3448,'Please update your payment information'),(2817,'Please wait'),(225,'Please, clarify your search request or search in Marketplace'),(1413,'Please, contact administrator'),(1729,'Please, enter a valid IP address'),(1728,'Please, enter a valid e-mail address'),(1712,'Please, enter unique membership name'),(1639,'Please, make sure that the following modules are installed and enabled:'),(3375,'Please, re-generate the product catalog images to apply the new template settings.'),(3617,'Please, type in the new PIN codes one per line.'),(3781,'Please, use another card or payment method.'),(1667,'Popularity'),(1022,'Pos'),(1023,'Pos.'),(1024,'Pos.:'),(1025,'Position'),(2162,'Possible import file names are:'),(2164,'Possible reasons of data not found in import file'),(2047,'Postal Code'),(2053,'Postal/ZIP Code'),(1028,'Pre upgrade disabled modules hooks message body'),(1031,'Pre upgrade disabled modules hooks message footer'),(1027,'Pre upgrade disabled modules hooks message head'),(2606,'Pre-upgrade hooks cannot be run'),(1030,'Pre-upgrade off'),(1029,'Pre-upgrade on'),(1026,'Prefix'),(2165,'Premium license modules warning'),(1032,'Prev'),(4869,'Preview full email'),(1562,'Preview product page'),(382,'Previous'),(4478,'Previous news'),(3108,'Previous order'),(1033,'Previous page'),(31,'Previous product'),(223,'Price'),(4050,'Price and membership'),(1920,'Price asc'),(1921,'Price desc'),(1034,'Price modifier'),(4619,'Price range'),(1036,'Price-sort-option'),(1035,'Price: Not a numeric'),(2818,'Prices & Inventory'),(3922,'Pricing currency'),(1038,'Primary menu'),(1994,'Print'),(2628,'Print Shipping labels'),(3953,'Print custom message 1'),(3955,'Print custom message 2'),(1039,'Print invoice'),(2661,'Print packing slip'),(1995,'Print selected'),(2111,'Priority'),(2063,'Private'),(3299,'Private and custom modules:'),(3300,'Private link'),(3301,'Proceed'),(1517,'Proceed import'),(2893,'Proceed to payment'),(181,'Proceed to payment X'),(4511,'Proceed to the next step'),(1040,'Processed'),(1041,'Processed/Completed'),(3002,'Processing categories...'),(2367,'Processing products...'),(4655,'Product'),(4279,'Product Feed URL'),(1775,'Product ID'),(1042,'Product Name'),(1043,'Product SKU'),(1044,'Product Title'),(1045,'Product added to bag'),(2156,'Product attributes values'),(2160,'Product attributes values (Hidden field) has been imported'),(2158,'Product attributes values (Plain text) has been imported'),(2159,'Product attributes values (Textarea) has been imported'),(2157,'Product attributes values (Yes/No) has been imported'),(2406,'Product attributes values has been imported'),(1046,'Product class'),(1896,'Product class have been updated successfully'),(1897,'Product class name is empty'),(2270,'Product class {{value}} does not exists and will be created'),(1047,'Product classes'),(4350,'Product count'),(4277,'Product feed'),(4274,'Product feed generation has been completed successfully'),(4275,'Product feed generation has been stopped'),(1050,'Product has been added to cart'),(1048,'Product has been created'),(1049,'Product has been updated'),(1849,'Product has not been added to cart'),(1051,'Product images'),(1052,'Product info'),(1053,'Product info has been updated successfully'),(1054,'Product is out of stock'),(4058,'Product list'),(224,'Product name'),(3632,'Product not found'),(1055,'Product on sale'),(1056,'Product options'),(4955,'Product or product variant with SKU \"{{value}}\" not found'),(1057,'Product page title'),(1058,'Product prices are defined including this tax calculated for'),(3326,'Product quantity has changed'),(3534,'Product removed'),(4656,'Product reviews'),(4208,'Product tabs'),(4639,'Product tags'),(2264,'Product with SKU \"{{value}}\" does not exists'),(4952,'Product with SKU \"{{value}}\" not found'),(2187,'Product with selected properties cannot be purchased'),(4668,'Product, SKU or customer info'),(1898,'Product-Specific'),(1899,'Product-Specific attributes'),(4373,'Product-specific'),(2263,'ProductSKU is empty'),(1059,'Products'),(3530,'Products (X)'),(4954,'Products and product variants updated'),(1526,'Products found'),(3361,'Products have been split into parcels in order to estimate the shipping cost'),(1909,'Products imported'),(1060,'Products in bag'),(2990,'Products in this class: {{X}}'),(2431,'Products information has been successfully deleted'),(1061,'Products information has been successfully updated'),(2366,'Products processed'),(2145,'Products processed: X out of Y'),(2149,'Products processed: X out of Y with errors'),(2383,'Products processed: {{count}}'),(4067,'Products return X'),(4657,'Products reviews'),(2710,'Products search'),(4950,'Products updated'),(1062,'Products with low inventory'),(3007,'Products with no assigned categories'),(1063,'Profile'),(3012,'Profile actions'),(3082,'Profile details'),(1064,'Profile has been created successfully'),(1065,'Profile has been deleted successfully'),(1956,'Profile has been modified successfully'),(1066,'Profile has been updated successfully'),(2129,'Profile is not defined'),(2409,'Profile is not selected'),(1067,'Profile settings'),(1068,'Promotions'),(4171,'Proof of age'),(1069,'Properties'),(4194,'Public'),(2414,'Public ID'),(2415,'Public id'),(3302,'Public installed modules:'),(4021,'Public key'),(4782,'Publishable key'),(4783,'Publishable key (test mode)'),(4674,'Published'),(1070,'Purchase'),(1071,'Purchase SSL certificate'),(3092,'Purchase a premium license key'),(2081,'Purchase description'),(2670,'Purchase license'),(14,'Purchase premium license'),(1665,'Purchased'),(3139,'Purchased addons'),(3851,'Put all for sale'),(3848,'Put up for sale'),(1073,'Put up selected for sale'),(1074,'Qty'),(1075,'Qty.'),(209,'Quantity'),(3603,'Quantity in stock'),(3621,'Quantity in stock is determined by the amount of the remaining PIN codes'),(3618,'Quantity in stock is determined by the amount of the remaining PIN codes.'),(1076,'Quantity: high to low'),(1077,'Quantity: low to high'),(385,'Quarter'),(1524,'Query'),(1078,'Queued'),(1079,'Quick and easy setup'),(3132,'Quick menu'),(2890,'Quick view'),(2546,'Quit'),(4172,'Quote type'),(4647,'REST API allows to get or change any information in your store (including profiles, orders, payment transactions, inner store configuration, products, categories and so on), so your API key must be as complex as possible and kept private.'),(2398,'RSS feed'),(1080,'Rate'),(4700,'Rate asc'),(4701,'Rate desc'),(4699,'Rate sort'),(1081,'Rates'),(1082,'Rates / Conditions'),(4666,'Rating'),(4682,'Rating of votes'),(4720,'Ratings and Reviews of X'),(4712,'Ratings only'),(1083,'Raw online rate (on-line rate)'),(1084,'Re-build cache'),(3876,'Re-calculate quick data'),(2686,'Re-check'),(2478,'Re-deploy the store'),(2479,'Re-deploy the store help text'),(1085,'Re-generate access key'),(1576,'Re-generate links'),(1086,'Re-order'),(3558,'Re-upload file'),(2448,'Re-validate license keys'),(4974,'Read'),(4698,'Read all reviews about the product'),(4534,'Ready to delete demo products?'),(5003,'Reason'),(3303,'Rebuild view lists help text'),(2913,'Recalculate ViewLists'),(2914,'Recalculate ViewLists text'),(2203,'Recalculate this value automatically'),(2819,'Recalculate totals'),(2820,'Recent orders only'),(3217,'Recently installed addons'),(2426,'Recently installed modules'),(3833,'Recently viewed'),(4731,'Recently, you have made a purchase from our company:'),(1919,'Recommended'),(3730,'Reconnect to PayPal'),(4455,'Reconnect with your MailChimp account'),(220,'Recover password'),(3510,'Redeem'),(1087,'Redirect customers to HTTPS'),(3090,'Refer to X-Cart license agreement for further details.'),(1089,'Referer'),(3160,'Refresh consistency status'),(2964,'Refresh integrity status'),(3930,'Refresh list of available methods'),(3439,'Refresh status'),(4776,'Refresh token'),(2104,'Refund'),(3425,'Refund is in progress...'),(2735,'Refund multiple[TT]'),(2734,'Refund partially[TT]'),(352,'Refund requested'),(3440,'Refund status'),(3723,'Refund status:'),(3419,'Refund status: {{status}}'),(2733,'Refund[TT]'),(353,'Refunded'),(1836,'Refunded amount'),(2630,'Refunds'),(1090,'Register'),(3106,'Register license key'),(1761,'Register user'),(3699,'Register with'),(3696,'Register with PayPal or go to checkout as a New customer'),(3410,'Register your website as an application on the Login with Amazon App Console.'),(1091,'Registered'),(2133,'Registered (access level)'),(203,'Registered Customer'),(204,'Registered Customer, _Anonymous Customer with the same email_'),(2021,'Registered Customers'),(4710,'Registered users only'),(4703,'Registered users who purchased product'),(3715,'Registering your application with PayPal'),(4173,'Registration process has been canceled.'),(4174,'Registration process has been completed successfully.'),(3820,'Regular (ppcm)'),(2784,'Regular text for 404 page'),(4725,'Reject'),(4958,'Related products'),(4962,'Related products page'),(3573,'Related products you may be interested in'),(3461,'Relay Response URL note'),(3615,'Remaining PINs'),(3091,'Remind me on next sign-in'),(21,'Removal of this message is allowed only through activation of a free or premium license.'),(1092,'Remove'),(4622,'Remove cache when attribute, tag or product data is changed'),(2207,'Remove data'),(3304,'Remove expired sessions'),(3305,'Remove expired shopping carts'),(4859,'Remove flexy-templates'),(4366,'Remove from google product feed'),(3306,'Remove module'),(4624,'Remove product filter cache'),(4623,'Remove product filter cache tooltip'),(2683,'Remove unlicensed modules'),(3512,'Removed coupons'),(2967,'Removed files'),(2199,'Removed items'),(3307,'Removing expired datacache'),(1610,'Removing this attribute will affect all the products. Leave this blank to hide this option for the product.'),(1694,'Removing this message without buying a Full license is prohibited and will result in legal proceedings.'),(1192,'Rename label'),(4175,'Render detailed manifest'),(3571,'Renew'),(2447,'Renew your access to new features'),(1742,'Replace all modified files with the unmodified newer versions'),(4055,'Replace with'),(104,'Report a bug'),(2356,'Request for upgrade'),(2078,'Request type must be POST'),(4765,'Requested amount: X; real amount: Y'),(4766,'Requested currency: X; real currency: Y'),(4764,'Requested transaction type: X; real transaction type: Y'),(1965,'Requested zone does not exists'),(1422,'Require to change password on next log in'),(1093,'Required'),(1713,'Required field'),(262,'Required field X is not defined or empty'),(3464,'Required for SHA512 hash protection.'),(1094,'Required php extensions is not loaded: X'),(2984,'Required state_id checkbox help text'),(1095,'Requires registered merchant account'),(2711,'Requires shipping'),(2674,'Requires {{list}} edition'),(1096,'Rerun benchmark'),(1097,'Resend secret link to renew the access'),(4040,'Reset all filters'),(4616,'Reset filter'),(4900,'Reset layout'),(1997,'Residential'),(2369,'Resizing images...'),(2456,'Resolve the conflict'),(4739,'Response date is in wrong format'),(4260,'Response from ePDQ is not trusted (SHA checking is failed)'),(1098,'Response from marketplace is not received'),(1099,'Response from marketplace: '),(1478,'Response from marketplace: X'),(5032,'Restarted'),(1100,'Restore'),(1101,'Restore database'),(1102,'Restore from server'),(1103,'Restore last backup'),(1104,'Restore links'),(4806,'Restore this version'),(772,'Restores to current state of active addons (use in case of emergency)'),(1885,'Restoring database from the backup .'),(2453,'Result'),(1730,'Result pages'),(4146,'Return'),(4133,'Return #'),(4123,'Return products'),(4129,'Return qty'),(4069,'Return quantity'),(1105,'Return to Drupal'),(1886,'Return to admin interface'),(4301,'Return to cart'),(4346,'Return to default database'),(4086,'Return tracking pin'),(1518,'Reupload files'),(1106,'Revenue'),(4911,'Revert to default'),(4342,'Revert to default database'),(4714,'Review'),(2709,'Review & Submit order'),(4661,'Review has been created'),(4662,'Review has been deleted'),(4663,'Review has not been created since product is not found'),(4664,'Review has not been updated since product is not found'),(4805,'Review it.'),(3200,'Review modules'),(1107,'Review statistics on various aspects of your store\'s operation'),(4665,'Reviewer'),(4746,'Reviewer name'),(4689,'Reviews'),(4718,'Reviews about product'),(4711,'Reviews and ratings'),(4654,'Reviews for product'),(4667,'Reviews imported'),(4713,'Reviews only'),(4690,'Reviews: X'),(3806,'Right (ppcm)'),(1108,'Role'),(1109,'Roles'),(2757,'Roles cannot be changed for your profile via import'),(1110,'Root Level'),(1111,'Root access'),(1680,'Root categories'),(1112,'Root category'),(2141,'Root category listings format'),(231,'Root level'),(3162,'RoundUp'),(1975,'Row {{number}}'),(1976,'Row(s) {{numbers}}'),(1113,'Run Benchmark again'),(1114,'Run benchmark'),(363,'SA'),(3716,'SECONDARYONLY'),(3717,'SENDER'),(4722,'SEO'),(1149,'SEO settings'),(373,'SEPTEMBER'),(2596,'SHIPPING = flat + ITEMS*per_item + SUBTOTAL*(% of subtotal)/100 + WEIGHT*per_weight;'),(30,'SKU'),(2410,'SKU is not selected'),(2821,'SKU length must be less then {{length}}'),(3308,'SKU must be unique'),(4741,'SKU or Product name'),(2823,'SKU or SKU1, SKU2'),(1115,'SKU: a-z'),(1116,'SKU: z-a'),(1117,'SMTP server'),(1870,'SQL file was deleted successfully'),(1418,'SSL Error'),(1118,'STORE SETUP'),(364,'SU'),(1119,'SYSTEM SETTINGS'),(1120,'Safe mode'),(1121,'Safe mode access key'),(1864,'Safe mode access key has been re-generated'),(2025,'Safe mode links were emailed'),(4750,'Sage Pay password'),(4752,'Sage Pay pricing currency'),(4749,'Sage Pay processing mode'),(4748,'Sage Pay vendor name'),(4751,'Sage pay invoice number prefix'),(4754,'SagePay Form admin description'),(1122,'Sale'),(3860,'Sale discounts'),(3854,'Sale name'),(1123,'Sale price'),(2462,'Sale statistics'),(1124,'Sale statistics from the opening of the store'),(2726,'Sale[TT]'),(1125,'Sales'),(4586,'Sales & Customer Service:'),(4588,'Sales & Customer Service: [phone]'),(3467,'Sales asc'),(2700,'Sales calculation'),(3126,'Sales channels'),(3468,'Sales desc'),(3466,'Sales sort'),(1126,'Sales tax'),(1516,'Samples of the file structures'),(127,'Save'),(3907,'Save & Close'),(4510,'Save and go to the next step'),(1127,'Save as new'),(1128,'Save changes'),(2652,'Save filter'),(4340,'Save location'),(2204,'Save the existing value without re-calculating'),(1129,'Save zone details'),(3134,'Saving'),(1130,'Savings'),(3961,'Savings - Up to 49% off retail USPS postage rates'),(2878,'Scheme'),(4704,'Score: X. Votes: Y'),(75,'Search'),(4044,'Search & Filter'),(4045,'Search & Filter Dashboard'),(4349,'Search attribute name'),(4857,'Search flexy-templates'),(1131,'Search for modules'),(1132,'Search for orders'),(4136,'Search for returns'),(2489,'Search for transactions by date'),(1133,'Search for users'),(1134,'Search for users that are'),(403,'Search in'),(1135,'Search in subcategories'),(2140,'Search items...(customer header search form)'),(399,'Search keywords'),(400,'Search payment method'),(1136,'Search product'),(1137,'Search profiles'),(1138,'Search result'),(1139,'Search results'),(2134,'Search total'),(2856,'Searching...'),(2907,'Second, try to disable all non-X-Cart modules by using the links below:'),(3408,'Secret Access Key'),(2106,'Secret key'),(4784,'Secret key (test mode)'),(2091,'Secret word'),(216,'Secure Checkout'),(1140,'Secure connection cannot be established.'),(2295,'Secure credit card payment'),(1141,'Security'),(2303,'Security code'),(2467,'Security issue'),(1142,'Security settings'),(161,'See all items in the cart'),(1824,'See comparison chart'),(2167,'See log file for details'),(4585,'See the tutorials and documentation about X-Cart store customization.'),(4415,'Segment condition'),(292,'Select a country or a state from a list, specify the zone'),(1746,'Select all'),(4408,'Select box'),(1143,'Select country'),(92,'Select file'),(4393,'Select issuer'),(99,'Select language'),(2824,'Select language to edit'),(226,'Select one'),(1144,'Select options'),(1861,'Select products from the list'),(1145,'Select status'),(4723,'Select the review that should be included into the rich snippet shown for the page of this product when the page appears in search results by Google and other major search engines'),(3309,'Select type'),(3371,'Selectbox'),(4425,'Selected by default'),(750,'Selected countries'),(749,'Selected countries:'),(4715,'Selected reviews have been deleted'),(4717,'Selected reviews have been updated'),(752,'Selected states'),(4641,'Selected tags have been deleted'),(355,'Selected:'),(1709,'Semicolon'),(1146,'Send'),(3476,'Send a message'),(3382,'Send anyway'),(3016,'Send reset link'),(1147,'Send test email'),(1148,'Send to {{email}}'),(1176,'Send tracking info'),(2825,'Separate box'),(1150,'Service name'),(1151,'Service name of address field'),(1152,'Set'),(2508,'Set a single discount or add multiple volume discounts.'),(2506,'Set absolute or %-based discount rates;'),(4560,'Set flat shipping rates for your store'),(4602,'Set it up'),(4269,'Set the Response Method setting to Sent to your server as a POST.'),(1153,'Set the sale price'),(144,'Set this language as default for customer zone'),(4509,'Set up payment gateways'),(4557,'Set up shipping'),(4508,'Set up shipping methods'),(4552,'Set your company info'),(3224,'Setting up Canadian taxes'),(3226,'Setting up European / UK Taxes'),(3227,'Setting up US Taxes'),(3223,'Setting up tax'),(3225,'Setting up tax classes'),(1154,'Settings'),(1155,'Setup _address zones_ and _taxes_'),(4934,'Setup banners'),(5018,'Setup fee'),(4024,'Setup instruction'),(3767,'Setup quickly and offer the convenience and trusted security of PayPal.'),(2185,'Setup store price: X'),(3741,'Shape'),(3592,'Share'),(2667,'Ship QTY'),(3969,'Ship date'),(1558,'Ship in a separate box'),(2665,'Ship to'),(4083,'Shipment ID'),(3937,'Shipment Id'),(4139,'Shipment cannot be created'),(4144,'Shipment cannot be transmitted'),(4141,'Shipment cannot be voided'),(3936,'Shipment has been created successfully'),(4138,'Shipment has been created with errors'),(4142,'Shipment has been tranmitted with errors'),(4143,'Shipment has been transmitted successfully'),(3935,'Shipment has been voided successfully'),(4140,'Shipment has been voided with errors'),(4082,'Shipment info'),(2069,'Shipment options'),(4084,'Shipment status'),(4145,'Shipments'),(4176,'Shipments pick up type'),(349,'Shipped'),(3897,'Shipping'),(1156,'Shipping & Taxes'),(1309,'Shipping / Payment info'),(1157,'Shipping address'),(1839,'Shipping address is invalid'),(1158,'Shipping address is not completly defined yet'),(1159,'Shipping address is not defined'),(1160,'Shipping address is not defined yet'),(2594,'Shipping charge based on a percentage of the order subtotal.'),(1540,'Shipping charges'),(41,'Shipping cost'),(4324,'Shipping freight'),(4327,'Shipping freight + regular shipping rate'),(4326,'Shipping freight only'),(4328,'Shipping freight tooltip text'),(1673,'Shipping has been calculated based on the following split of the products into packages:'),(1161,'Shipping info'),(3939,'Shipping label'),(3957,'Shipping label sender signature'),(1162,'Shipping markup has been created successfully'),(1163,'Shipping markups have been updated'),(1164,'Shipping method'),(2826,'Shipping method / cost'),(1165,'Shipping method has been added'),(3310,'Shipping method is disabled'),(3311,'Shipping method is enabled'),(2555,'Shipping method is not configured.'),(2566,'Shipping method name'),(1166,'Shipping methods'),(1167,'Shipping methods are not available'),(165,'Shipping methods have been updated'),(3312,'Shipping order status'),(1532,'Shipping rate cannot be added'),(1531,'Shipping rate has been added successfully'),(1168,'Shipping rates'),(2590,'Shipping rates are calculated by the following formula:'),(1169,'Shipping settings'),(2648,'Shipping solutions'),(2119,'Shipping status'),(2930,'Shipping status not found, \"New\" will be used for order'),(4202,'Shipping status not found, new status will be created'),(4196,'Shipping statuses'),(2894,'Shipping to'),(1170,'Shipping zones'),(4747,'Shopper approved promo'),(1184,'Shopping bag'),(4614,'Shopping options'),(377,'Shortcuts'),(2023,'Show'),(4779,'Show \"How to use\" instruction'),(78,'Show Category title'),(3684,'Show above products'),(4852,'Show all'),(94,'Show all labels'),(4618,'Show all products in this category'),(2719,'Show all warnings/errors'),(3685,'Show below products'),(3918,'Show default menu along with the custom one'),(3479,'Show email as text'),(198,'Show filter options'),(2827,'Show in all the sections'),(2716,'Show low stock warning on product page'),(2792,'Show object name in page title'),(2828,'Show only in categories and search listings'),(2829,'Show only in search listing'),(3742,'Show payment card icons'),(4615,'Show products'),(3009,'Show products with no assigned category'),(1185,'Show social buttons'),(3081,'Show states for selected countries only'),(5005,'Show vendor’s products in the order'),(2785,'Show сustomer relations e-mails on 404 page'),(2830,'Show:'),(2315,'Sign Up'),(3695,'Sign Up Now'),(1186,'Sign in'),(2889,'Sign in / sign up'),(1187,'Sign out'),(4447,'Sign up for <Company name> news, sales and deals'),(4025,'Sign up for Authorize.net'),(3175,'Sign up for TaxJar'),(4446,'Sign up for news and updates from your favorite store. Be the first to know about exclusive sales, offers and deals.'),(4487,'Sign up for {{companyName}} news'),(2876,'Signature'),(3458,'Signature  key'),(3465,'Signature key'),(3797,'Single line logo'),(1718,'Single quote'),(3990,'Site map has not been registred in X'),(3991,'Site map successfully registred on X'),(4177,'Site number of the deposit location'),(4756,'Sitemap'),(3996,'Sitemap generation has been completed successfully.'),(3997,'Sitemap generation has been stopped.'),(3995,'Sitemap generation...'),(3999,'Sitemap settings'),(1188,'Size'),(4559,'Skip Shipping Step'),(4513,'Skip this step'),(3313,'Skipped'),(3821,'Slim (ppcm)'),(3808,'Small (ppcm)'),(2831,'Soft and Hard reset links for your store'),(3314,'Soft and hard reset links for your store'),(1770,'Soft reset (disables all modules except ones that were downloaded from marketplace)'),(2908,'Soft reset. Turn off all addons except those provided by X-Cart Team & Qualiteam'),(3604,'Sold'),(3614,'Sold PINs'),(4838,'Some'),(4910,'Some edited templates were selected to be disabled. You can enable them on the Edited templates page in the Admin area.'),(1740,'Some files are modified'),(4250,'Some files haven`t been attached'),(4862,'Some flexy-templates cannot be removed. Please correct file permissions or remove them manually'),(3330,'Some items were out of stock at the time of order placement.'),(4180,'Some of the items in the parcel were removed. To view all the items, including the removed ones, see the document.'),(2442,'Some of these updates are not available for you at the moment.'),(4575,'Some people simply prefer to place their orders by phone — let them do that.'),(265,'Some products could have been imported incorrectly'),(3377,'Something went wrong, please try again or contact us at X'),(4388,'Something wrong in the iDEAL payment module settings. Please try later or use other payment option.'),(3874,'Sorry, no products have been added to this discount offer.'),(3875,'Sorry, no products of {{vendor}} have been added to this discount offer.'),(3520,'Sorry, the coupon has expired'),(3521,'Sorry, the coupon use limit has been reached'),(3522,'Sorry, the coupon you entered cannot be applied to the items in your cart'),(3527,'Sorry, the coupon you entered cannot be applied to this delivery address'),(3519,'Sorry, the coupon you entered is invalid. Make sure the coupon code is spelled correctly'),(3523,'Sorry, the coupon you entered is not valid for your membership level. Contact the administrator'),(1267,'Sorry, this category is no longer available.'),(3516,'Sorry, this coupon cannot be combined with the coupon already applied. Revome the previously applied coupon and try again.'),(1265,'Sorry, this page is no longer available.'),(1266,'Sorry, this product is no longer available.'),(2659,'Sorry, your order cannot be placed as there are no shipping methods available.'),(1802,'Sorry, your order payment is canceled.'),(1803,'Sorry, your order payment is failed.'),(3315,'Sort'),(233,'Sort by'),(2832,'Sort by:'),(2833,'Sort settings'),(2046,'Source address'),(2000,'Space'),(3944,'Special services'),(429,'Specification'),(3207,'Specify email address'),(4291,'Specify the percentage of users who complete the transaction (Add to cart)'),(4295,'Specify the percentage of users who complete the transaction (Initiate checkout)'),(4294,'Specify the percentage of users who complete the transaction (View content)'),(1194,'Specify your _store information_'),(2834,'Specify your _store information_\', {\'URL\': url(\'settings\', \''),(1195,'Speed up your store'),(3796,'Stacked'),(2202,'Staff note'),(2642,'Stamps.com'),(2513,'Standard'),(2917,'Start'),(1623,'Start Export'),(1507,'Start Import'),(3660,'Start accepting Express Checkout payments immediately by simply plugging in the email address where you would like to receive payments.'),(1807,'Start date'),(1196,'Start selling!'),(3336,'Start typing a category name'),(4672,'Start typing customer email or name'),(4670,'Start typing product name or SKU'),(5027,'Started on'),(1197,'State'),(1495,'State cannot be created with unknown country code X'),(1198,'States'),(1199,'States have been deleted successfully'),(1200,'States have been updated successfully'),(2172,'States information has been successfully deleted'),(4417,'Static'),(1201,'Statistics'),(1202,'Status'),(3221,'Status comment (reason)'),(2411,'Status is not defined'),(4773,'Status: Connected'),(334,'Steps to complete your store for real sales'),(1936,'Stock'),(2932,'Stock status not found'),(5031,'Stopped'),(4930,'Store Configuration Mode'),(3316,'Store ID'),(1203,'Store Maintenance'),(1204,'Store currency'),(1205,'Store info'),(1206,'Store is closed'),(1207,'Store is open'),(1753,'Store lifetime'),(1208,'Store setup'),(1209,'Storefront'),(1943,'Storefront is closed'),(1945,'Storefront is open'),(4899,'Storefront layout'),(4306,'Street address'),(4786,'StripeJSerror amount_too_large'),(4785,'StripeJSerror amount_too_small'),(4787,'StripeJSerror authentication_required'),(4788,'StripeJSerror card_declined'),(4789,'StripeJSerror email_invalid'),(4790,'StripeJSerror expired_card'),(4791,'StripeJSerror incorrect_address'),(4792,'StripeJSerror incorrect_cvc'),(4793,'StripeJSerror incorrect_number'),(4794,'StripeJSerror incorrect_zip'),(4795,'StripeJSerror invalid_cvc'),(4797,'StripeJSerror invalid_expiry_month'),(4796,'StripeJSerror invalid_expiry_year'),(4798,'StripeJSerror invalid_number'),(4799,'StripeJSerror postal_code_invalid'),(3340,'Strong password'),(4932,'Style Your Banners'),(120,'Subcat'),(1210,'Subcategories'),(344,'Subcategories for'),(1211,'Subject'),(3912,'Submenu'),(35,'Submit'),(2888,'Subscribe'),(4443,'Subscribe by default'),(4406,'Subscribe to our news list and be in touch with our latest offers.'),(4493,'Subscriber with email {{email}} already subscribed'),(4489,'Subscribers'),(4492,'Subscribers imported'),(4405,'Subscription'),(5017,'Subscription ID'),(5071,'Subscription X has been activated'),(5066,'Subscription X has been failed'),(5074,'Subscription X has been stopped'),(5076,'Subscription X payment successfully charged'),(5019,'Subscription fee'),(5015,'Subscription plan'),(1212,'Substring'),(43,'Subtotal'),(3888,'Subtotal + Shipping cost'),(2574,'Subtotal range'),(1213,'Subtotal range (begin)'),(1214,'Subtotal range (end)'),(1671,'Success'),(2692,'Success[S]'),(4468,'Successfully authenticated'),(1215,'Successfully imported X new products'),(1216,'Successfully imported X new products and upgraded Y old products'),(1217,'Successfully upgraded Y old products'),(1218,'Suffix'),(4947,'Suggested retail rates'),(3317,'Sunday'),(1505,'Support'),(3151,'Surcharges'),(2973,'Switch to Category search'),(2972,'Switch to Category tree'),(2902,'Switcher NO'),(2901,'Switcher YES'),(1219,'Synchronous'),(3130,'System logs'),(1220,'System settings'),(4200,'System status tooltip'),(3129,'System tools'),(1856,'System will download and install this module from marketplace. Continue?'),(361,'TH'),(359,'TU'),(1710,'Tab'),(4222,'Tab displaying comments about the product. Added by the addons VK/GoSocial/Disqus'),(4744,'Tab displaying product reviews. Added by the addon Product Reviews'),(4221,'Tab displaying the product\'s attributes and other details. Added by the X-Cart core'),(4220,'Tab displaying the product\'s detailed description. Added by the X-Cart core'),(1221,'Table'),(2567,'Table based on'),(4203,'Tabs'),(4209,'Tabs imported'),(4637,'Tag'),(4891,'Tag Manager Dashboard'),(5,'Tags'),(2227,'Tags are not allowed in the column \"{{column}}\" and will be stripped'),(44,'Tax'),(4065,'Tax Class'),(1563,'Tax class'),(1893,'Tax classes'),(1222,'Tax disabled'),(1223,'Tax enabled'),(1224,'Tax has been disabled successfully'),(1225,'Tax has been enabled successfully'),(1227,'Tax rate has been deleted successfully'),(1228,'Tax rate has not been deleted successfully'),(3890,'Tax rates for shipping charges have not yet been created.'),(1226,'Tax rates have been updated successfully'),(3891,'Tax rates have not yet been created.'),(3892,'Tax rates on shipping cost'),(1229,'Tax title'),(3178,'TaxJar Category'),(3177,'TaxJar Dashboard'),(3174,'TaxJar enabled'),(3889,'Taxable base'),(1230,'Taxes'),(1231,'Teaser'),(4812,'Template'),(4856,'Template is converted'),(3909,'Terms and conditions'),(1493,'Terms and conditions text'),(1996,'Test'),(4102,'Test Canada Post rates calculation'),(3318,'Test e-mail have been successfully sent'),(1232,'Test email configuration'),(1762,'Test email notification'),(1763,'Test email notification:'),(2071,'Test mode'),(2180,'Test mode: Live'),(2179,'Test mode: Test'),(2600,'Test rates'),(1233,'Test shipping rates'),(2080,'Test/Live mode'),(2739,'Test[TT]'),(1234,'Tester'),(1235,'Text'),(3803,'Text (ppcm)'),(3816,'Text color (ppcm)'),(64,'Text labels have been deleted'),(60,'Text labels have been updated successfully'),(65,'Text labels have not been deleted: no text labels have been found or specified'),(62,'Text labels have not been updated successfully: the default application language has been set as the translation language'),(63,'Text labels have not been updated successfully: the translation language has not been found'),(61,'Text labels have not been updated successfully: the translation language has not been specified'),(3842,'Text links'),(4738,'Text of response'),(4673,'Text of review'),(3815,'Text size (ppcm)'),(1930,'Textarea'),(244,'Thank you for registering a customer account, your profile has been created successfully'),(4488,'Thank you for subscribing to the newsletter! We hope you enjoy shopping at {{companyName}}'),(194,'Thank you for using company services'),(1236,'Thank you for your order'),(296,'Thank you for your order FOOTER'),(4679,'Thank your for sharing your opinion with us!'),(3430,'That payment method was not accepted for this transaction. Please choose another.'),(3927,'The \"Approved URL\" value must be exact as this'),(3402,'The \"Pay With Amazon\" feature is not configured and cannot be used.'),(3403,'The \"Pay with Amazon\" feature requires https to be properly set up for your store.'),(3926,'The \"Pricing currency\" value must be exactly the same as on it.'),(4758,'The \"Stripe\" feature is not configured and cannot be used.'),(4759,'The \"Stripe\" feature requires https to be properly set up for your store.'),(3533,'The \"{{code}}\" coupon does not exist'),(2853,'The \"{{file}}\" file is not allowed and was not uploaded. Allowed extensions are: {{extensions}}'),(3911,'The \"{{file}}\" file is not allowed image and was not uploaded. Allowed images are: {{extensions}}'),(1830,'The \"{{file}}\" file was not uploaded'),(1868,'The \"{{file}}\" is not CSV or archive'),(3878,'The \"{{saleDiscount}}\" discount does not exist'),(2224,'The \"{{value}}\" category does not exist'),(2258,'The \"{{value}}\" group is not created'),(2222,'The \"{{value}}\" image does not exist'),(2219,'The \"{{value}}\" membership does not exist'),(2220,'The \"{{value}}\" product class does not exist'),(2221,'The \"{{value}}\" tax class does not exist'),(3915,'The AppleIcon image could not be uploaded (Unallowed image type. Must be a .png image with the resolution of 192x192 px)'),(4266,'The Approved URL value must be exact as this:'),(3332,'The Backorder status will be reset for the items. The stock quantity of the backorder items will not change. Adjust it manually if necessary.'),(3319,'The Clean URL entered has unallowed chars.'),(2451,'The Clean URL entered is a redirect to object.'),(2771,'The Clean URL entered is already in use by target alias.'),(2450,'The Clean URL entered is already in use.'),(2772,'The Clean URL you have specified matches the name of a folder on your server.'),(4268,'The Declined URL value must be exact as this:'),(2110,'The English language cannot be removed as it is primary language for all texts.'),(1251,'The HTTPS protocol is enabled for your website'),(1237,'The SSL certificate installed for your custom website domain is not valid.'),(1238,'The SSL certificate installed on your server is not valid. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(4265,'The Store ID and HPP Key value must be exactly the same as on it.'),(268,'The X field is empty'),(1239,'The X language has been added and enabled successfully'),(53,'The X language has been added successfully'),(55,'The X language has been deleted successfully'),(58,'The X language has been disabled successfully'),(59,'The X language has been enabled successfully'),(154,'The X module has been installed incorrectly. Please see the logs for more information'),(152,'The X module has been installed successfully'),(153,'The X module has been installed with errors: the DB has not been modified correctly'),(155,'The X module has been installed, but the module has a wrong module control class'),(1950,'The address field has been added'),(1949,'The address field has been updated'),(1240,'The attachment has been added successfully'),(3582,'The attachment has been successfully re-upload'),(1952,'The attribute has been added'),(1951,'The attribute has been updated'),(193,'The benchmark evaluates server environment'),(2186,'The button is inactive either because no changes have been detected on the current page or because the order totals need to be recalculated before the order can be updated.'),(2698,'The calculation completed'),(2697,'The calculation failed'),(2485,'The calculation of quick data has been completed successfully.'),(2486,'The calculation of quick data has been stopped.'),(1948,'The category has been added'),(1947,'The category has been updated'),(1241,'The changes will be applied to all selected products'),(2452,'The clean URL will be generated automatically.'),(2419,'The common notification fields has been updated'),(4613,'The comparison table has been cleared.'),(195,'The confirmation URL link was mailed to email'),(196,'The confirmation URL link was sent'),(2127,'The confirmation URL link will be emailed to you shortly'),(2961,'The core may be checked only if a valid license key is present.'),(2761,'The count of categories specified for a product and the count of orderBy position numbers describing the position of the product within these categories must be the same.'),(1874,'The countries list for zone is empty. Please specify it.'),(2904,'The countries to which the selected states belong will be added to the zone automatically.'),(3493,'The coupon has been added'),(3489,'The coupon has been applied to your order'),(3494,'The coupon has been updated'),(1884,'The database has not been restored because of the errors'),(4804,'The database stores different version of the custom changes.'),(57,'The default interface language cannot be disabled'),(1242,'The detailed image has been added successfully'),(1243,'The detailed image has been deleted'),(1894,'The detailed image has not been deleted'),(1244,'The detailed images have been updated successfully'),(1557,'The directory \'var/backup/\' does not exist or is not writable.'),(3369,'The directory selected as a parent directory has already been specified as a child directory'),(4824,'The directory {{dir}} does not exist or is not writable.'),(3528,'The discount is valid for the selected delivery area'),(4993,'The dispute has been closed'),(3383,'The domain are you looking for is available for registration:'),(2658,'The download should start automatically. Click the link if does not start.'),(4923,'The dynamic message is empty for this notification.'),(72,'The edited language has not been found'),(197,'The email with your account information was mailed to email'),(3452,'The email you tried to use is already registered in our store. Please sign in the classic way.'),(3768,'The email you tried to use is already registered in our store. Please try logging in using your X account.'),(3568,'The endpoint field value must contain the full path'),(1245,'The exceptions have been updated successfully'),(1771,'The export is complete.'),(4980,'The field Body may not be blank'),(2618,'The file extension is forbidden'),(2750,'The file extension is forbidden ({{file}}'),(285,'The file was not loaded because of a failure on the server'),(1892,'The file was not loaded because of a failure on the server.'),(4823,'The file {{file}} does not exist or is not writable.'),(4237,'The files have been attached successfully'),(3638,'The following PIN codes have already been sold: {{codes}}'),(1247,'The following add-on(s) must be disabled'),(1246,'The following add-on(s) must be enabled'),(1248,'The following categories were selected to be removed'),(1249,'The following dependent add-ons will be disabled  automatically'),(1499,'The following expected input data have wrong format or empty: X'),(1622,'The following files are too large to be included in the archive'),(2351,'The following modules currently do not have a version compatible with the X-Cart version to which you are upgrading'),(131,'The following modules will be disabled'),(3873,'The following sale discounts apply to this product: X'),(2380,'The following selected modules cannot be disabled due to architecture limitations'),(2377,'The following selected modules cannot be disabled or uninstalled as they have dependent modules'),(2378,'The following selected modules cannot be enabled as they depend on disabled modules which cannot be enabled'),(1860,'The form could not be identified as a form generated by X-Cart'),(1955,'The front page has been updated'),(2372,'The generation of resized images has been completed successfully.'),(2373,'The generation of resized images has been stopped.'),(3400,'The global attributes changing process has been canceled.'),(3399,'The global attributes have been successfully changed.'),(3561,'The history of downloads feature for this product is disabled. You can enable it here'),(1250,'The image has been updated'),(2374,'The image resizing process may take a while to complete. Please do not close this page until the process is fully completed.'),(1252,'The import is in progress'),(3010,'The import process has been canceled'),(1253,'The importing starts immediately upon selecting the data file. No additional confirmation prompts will appear.'),(2441,'The key does not allow getting new features and upgrades.'),(1591,'The language CSV file should be a text file which contains 3 columns per row (columns are separated by comma:'),(73,'The language data has been saved'),(56,'The language has not been found'),(1585,'The language labels have been successfully imported:'),(52,'The language you want to add has already been added'),(51,'The language you want to add has not been found'),(54,'The language you want to delete has not been found'),(1254,'The language you want to delete is the default application language and cannot be deleted'),(1255,'The language you want to delete is the default interface language and cannot be deleted'),(3480,'The length of X field must be greater than Y'),(3481,'The length of X field must be less than Y'),(2229,'The length of value for the column \"{{column}}\" exceeds length of field and will be cut'),(48,'The link was copied to your clipboard'),(74,'The maximum file size that can be uploaded: X'),(1256,'The maximum number of uses'),(3524,'The maximum number of uses per user'),(4251,'The maximum size of the uploaded file is limited by the following parameters in your server settings: X and Y'),(1711,'The membership name cannot contain such symbols as \\, \' and \". Also, it cannot exceed 32 characters.'),(3902,'The menu has been added'),(3901,'The menu has been updated'),(1837,'The method is not configured and cannot be used'),(1481,'The module X has been uninstalled successfully'),(1257,'The module has been partially uninstalled'),(151,'The module has been uninstalled successfully'),(1736,'The module is incompatible with the new core version going to be installed'),(1258,'The module is not released for your X-Cart version'),(2962,'The module may be checked only if a valid license key is present.'),(2379,'The module may not be disabled due to the limitations of the module architecture.'),(150,'The module to uninstall has not been found'),(2116,'The module version is incompatible with your core version and cannot be enabled. Minimum core version required for this module is X.'),(2115,'The module version is incompatible with your core version and cannot be installed. Minimum core version required for this module is X.'),(156,'The modules have been updated'),(2248,'The name is empty'),(3120,'The name will be changed globally'),(3392,'The nameservers for your domain may have been entered incorrectly.'),(4531,'The newly created product is already in your [storefront]. Have a look! Ready to delete demo products?'),(4481,'The news message has been added'),(4480,'The news message has been updated'),(2420,'The notification has been updated'),(2226,'The number of values in the row does not match the number of column headers for this CSV file'),(1838,'The only remaining active administrator profile cannot be deleted.'),(3637,'The order also contains items with missing PIN codes; you will be prompted to enter the PIN codes under item names.'),(1940,'The order subtotal exceeds the maximum allowed value ({{max_order_amount}})'),(1984,'The order subtotal exceeds the maximum allowed value ({{max_order_amount}}), please remove some items from the cart.'),(1941,'The order subtotal less than the minimum allowed value ({{min_order_amount}})'),(1985,'The order subtotal less than the minimum allowed value ({{min_order_amount}}), please add some items to the cart.'),(1259,'The page has been added'),(3903,'The page has been updated'),(1759,'The password is the one you specified during checkout.'),(1760,'The password is the one you specified.'),(339,'The process of export is complete. You can follow this_link to check the results and download the files containing data.'),(1634,'The process of export may take much time. Please do not close this page until the export is complete'),(1633,'The process of export may take much time. You may close the page, the operation will be in progress as background. If the operation takes long enough, we will send you a notification when it is complete.'),(4364,'The process of feed generation may take a while to complete. Please do not close this page until the process is fully completed.'),(1520,'The process of import may take much time. Please do not close this page until the import is complete'),(1519,'The process of import may take much time. You may close the page, the operation will be in progress as background. If the operation takes long enough, we will send you a notification when it is complete.'),(2484,'The process of quick data calculation may take a while to complete. Please do not close this page until the process is fully completed.'),(2699,'The process of sales calculation may take a while to complete. Please do not close this page until the process is fully completed.'),(3998,'The process of sitemap generation may take a while to complete. Please do not close this page until the process is fully completed.'),(4967,'The product SKU#\"X\" is already set as Related for the product'),(2066,'The product SKU#\"X\" is already set as featured for the category'),(4964,'The product SKU#\"X\" is already set as related for the product'),(4636,'The product filter cache has been removed successfully.'),(2617,'The product for which you attempted to upload an attachment has not been found'),(2421,'The product has been added'),(4612,'The product has been added to the comparison table'),(4611,'The product has been removed from comparison table'),(2168,'The product has been updated'),(1260,'The product option group has been added successfully'),(1261,'The product option group has been updated successfully'),(1262,'The product option groups have been updated successfully'),(1263,'The product option groups have not been successfully updated'),(1954,'The product selection has been added'),(1953,'The product selection has been updated'),(4207,'The product tab has been added'),(4206,'The product tab has been updated'),(2218,'The product with \"{{value}}\" SKU does not exist'),(4223,'The product with SKU \"{{value}}\" does not exist. The tab \"{{tab_name}}\" will not be imported'),(3014,'The product you are trying to add to cart is unavailable'),(3560,'The product\'s history of downloads is empty'),(4147,'The products return has been registered.'),(1492,'The profile has been registered. The password has been sent to the user\'s email address'),(1491,'The profiles have been merged'),(1584,'The provided file contains the following language labels:'),(1264,'The requested page could not be found.'),(1270,'The restoration procedure is irreversible and erases all data tables from your store database. It is highly recommended that you back your present database data up before restoring one of the previous states from a back-up.'),(3975,'The role has been added'),(3974,'The role has been updated'),(3866,'The sale discount has been added'),(3865,'The sale discount has been updated'),(3863,'The sale discount will be limited to customers with membership levels specified here'),(3862,'The sale discount will be limited to product classes specified here'),(3864,'The sale discount will be limited to the delivery area specified here'),(1271,'The same as shipping'),(3581,'The same file can not be assigned to one product'),(1974,'The script found {{number}} errors during import'),(4951,'The script found {{number}} errors during update inventory'),(1973,'The script found {{number}} errors during verification'),(2835,'The secure protocol for your website is disabled.'),(2836,'The secure protocol for your website is enabled.'),(2530,'The secure protocol is enabled for your website. But X-Cart hasn\'t found the valid SSL certificate on your server.'),(3008,'The selected categories have been deleted. There are products with no assigned category.'),(3526,'The selected date is outside the allowed date range'),(1859,'The selected payment method is obsolete or invalid. Select another payment method'),(1272,'The selected shipping markups have been deleted successfully'),(164,'The selected shipping method has been deleted successfully'),(166,'The selected zones have been deleted successfully'),(2181,'The service name X is reserved and cannot be used for an address field.'),(1867,'The settings of payment method successfully updated'),(2188,'The specified amount of product exceeds maximum amount of product in stock'),(1273,'The state has been added successfully'),(261,'The string is different from that of the title number of columns - X instead of Y'),(2394,'The system detects that some updates are available for enabled modules. It is strongly recommended to have all enabled modules updated to latest version for better compatibility before the install new ones from Marketplace.'),(2509,'The system has been restored to the selected snapshot of X'),(2676,'The system has detected one or more problems with some of the modules at your store:'),(1741,'The system has detected that some custom modifications were made by editing core and module files, not by writing new modules. In order to proceed with the upgrade you should decide what to do with the modifications'),(2684,'The system has detected that the license key that was activated for your store is invalid.'),(2510,'The system has failed to restore because there was no snapshot of X'),(1958,'The tax class has been added'),(1957,'The tax class has been updated'),(4818,'The template has been added'),(4817,'The template has been updated'),(4873,'The test email notification has been sent to X'),(70,'The text label has been added successfully'),(66,'The text label has been deleted'),(71,'The text label has been modified successfully'),(68,'The text label has not been added, because its name has not been specified'),(1274,'The text label has not been added, because its translation to the default application language has not been specified'),(1275,'The text label has not been added, because its translation to the default interface language has not been specified'),(69,'The text label has not been added, because such a text label already exists'),(67,'The text label has not been deleted: it has been either not found or not specified'),(1276,'The text label has not been modified, because its translation to the default application language has not been specified'),(1277,'The text label has not been modified, because its translation to the default interface language has not been specified'),(4252,'The total size of the attached files should not exceed X per once'),(3121,'The totals have been recalculated. Press \"Save changes\" to adjust the order'),(1278,'The upgrade is completed. Please, do not close this page until you check your web site and check that everything works properly'),(4514,'The uploaded image is too large.'),(205,'The user will be registered; a password will be sent to the user via email'),(2228,'The value in the column \"{{column}}\" will be adjusted according to HTML specification to prevent potential XSS attack'),(2724,'The value must be greater than the current maximum order number in the order list'),(1714,'The value must be in range'),(271,'The value of the X field has an incorrect format'),(269,'The value of the X field must be greater than Y'),(270,'The value of the X field must be less than Y'),(272,'The value of the X field should not be longer than Y'),(1537,'The values are average'),(3988,'The volume discount has been added'),(3989,'The volume discount has been updated'),(4808,'Theme tweaker'),(3153,'There are %model% with missing %another_model%'),(3152,'There are %model% without valid %another_model% relation'),(2473,'There are no activated license keys'),(1279,'There are no categories'),(4726,'There are no comments yet. Be the first to leave a comment'),(1564,'There are no images loaded for this product'),(3161,'There are no inconsistencies found'),(1496,'There are no labels translated to X'),(1280,'There are no markups selected'),(2753,'There are no permissions to import user access level'),(2755,'There are no permissions to import user roles'),(1281,'There are no rates available for specified source/destination and/or package measurements/weight.'),(1797,'There are no shipping methods available'),(1646,'There are no shipping methods defined for this carrier'),(4845,'There are some custom CSS styles in your store. These styles may affect the look of the installed template. Review the custom styles and disable them if necessary.'),(4846,'There are some custom templates in your store that may contain skin dependent code.'),(2528,'There are unsaved changes on the page. If you choose to continue, these changes will be lost. Do you want to proceed?'),(1172,'There is a maximum purchase limit of MaxQuantity'),(1171,'There is a minimum purchase limit of MinQuantity'),(176,'There is already an account with your email address. You can sign in or continue as guest'),(2899,'There is already state with code {{code}} in {{country}}'),(2487,'There is no data to process.'),(4281,'There is no products for facebook product feed generation'),(4922,'There is no special code for this notification'),(3487,'There is no such a coupon, please check the spelling: X'),(1283,'There is no user with specified email address'),(3158,'There is one valid root category, however there are multiple root category candidates'),(1284,'There were no orders placed'),(408,'There\'s no payment method available'),(4072,'There\'s no post offices available'),(3589,'These Open Graph meta tags were generated automatically based on general product information.'),(1990,'These attributes can be applied to all the products in the store.'),(1988,'These attributes can be applied to the \"{{name}}\" product class.'),(1989,'These attributes can only be applied to this particular product.'),(1285,'These components require your attention'),(1286,'These components will be updated'),(1287,'These instructions will appear below the order invoice on the page which customers see after they confirm their order.'),(1288,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process'),(2026,'These links were already provided to you after this store was installed and will be emailed to you again after you start the upgrade process.'),(2794,'These options separated by X, you can change it by modify X label'),(4864,'This action will remove all flexy-templates. Are you sure to proceed?'),(1815,'This address was used as a'),(1290,'This address was used as a billing address during the recent purchase'),(1291,'This address was used as a shipping address during the recent purchase'),(3506,'This comment will be visible to shop administrators only'),(1292,'This component is automatically calculated by shipping add-on module and cannot be edited'),(2325,'This content shows via %dynamic_message% variable. Do not use this variable to put content (if it exists) below the main message'),(3515,'This coupon cannot be combined with other coupons'),(1293,'This e-mail address is already in use by another user.'),(1294,'This email address is used for an existing account. Enter another email address or sign in'),(2459,'This feature is available only for paid (non-free) X-Cart license plans'),(4064,'This feature is not yet available. You will be redirected to the feature request page where you can vote to have this feature implemented in one of the upcoming versions.'),(4325,'This field can be used to set a fixed shipping fee for the product. Make sure the field value is a positive number (greater than zero).'),(188,'This field is required'),(3469,'This field is required.'),(1295,'This is a default zone which covers all addresses. It\'s impossible to edit this zone\'s countries, states etc'),(222,'This is a demo store with powerful X-Cart engine inside'),(3956,'This is a user specified message that gets printed on the bottom of the label. A string of up to 50 characters can be printed on the label.'),(3954,'This is a user specified message that gets printed on the face of the label. A string of up to 50 characters can be printed on the label.'),(5016,'This is subscription product'),(3647,'This is the login name you created when signing up for PayPal Payments Advanced.'),(3654,'This is the login name you created when signing up for Payflow.'),(3655,'This is the password you created when signing up for PayPal Payflow or the password you created for API calls.'),(3649,'This is the password you created when signing up for PayPal Payments Advanced or the password you created for API calls.'),(405,'This language is added by module and cannot be removed.'),(3089,'This message can be removed only through activation of a free or premium license.'),(1641,'This method does not support the current store currency and is not available for customers'),(2701,'This method is displayed because you are logged in as admin and operating as another user'),(1642,'This method is in test mode'),(319,'This module is available for X-Cart hosted stores only.'),(2041,'This module uses PHP\'s cURL functions which are disabled on your web server'),(1296,'This month'),(1793,'This operation is irreversible. Are you sure you want to proceed?'),(3441,'This operation will cancel order. Payment authorization will be voided. Please confirm to proceed.'),(3442,'This operation will capture funds from customer. Please confirm to proceed.'),(3443,'This operation will refund funds to customer. Please confirm to proceed.'),(3373,'This option applies only to attributes with multiple values'),(3329,'This order was placed at the same time as {{orders}}; as a result, some items were out of stock at the time of order placement.'),(2337,'This page allows you to adjust the types of email notifications your store sends to users'),(1539,'This page allows you to configure Shipping methods, zones and charges.'),(1546,'This page allows you to edit global attributes, which are available for all products in your store, and attributes specific for classes of your products.'),(2500,'This page is intended for the creation and management of discount coupons.'),(2505,'This page is intended for the management of volume discounts based on the order subtotal.'),(1644,'This payment method cannot be enabled until you configure it'),(3320,'This payment method is'),(2309,'This payment method is Active.'),(2310,'This payment method is Inactive.'),(2837,'This payment method is not configured.'),(2912,'This process may take much time. Please do not close this page until the task is complete'),(169,'This product has been added to your bag'),(4960,'This product is no longer available although you may find similar or newer version below.'),(38,'This product is out of stock or it has been disabled for sale'),(3835,'This product will be shown in coming soon section'),(3834,'This product will be shown in new arrivals'),(1302,'This quarter'),(1299,'This section displays order placement statistics'),(1535,'This section displays order processing statistics'),(3674,'This setting determines whether or not the \"Buy Now with PayPal\" button should be displayed on product list pages (in list view) and product details pages.'),(2602,'This shipping method is'),(2603,'This shipping method is not configured.'),(3653,'This should be the same partner name that is used when logging into your PayPal Payflow account.'),(1300,'This site requires JavaScript to function properly.'),(2495,'This tool allows you to get rid of any content that might have been created in your store for testing purposes and which you no longer need.'),(177,'This user name is used for an existing account. Enter another user name or sign in'),(3847,'This value must be set in exactly the same way as it is set on the payment gateway end.'),(1618,'This value will be added to new products or class assigns automatically'),(1301,'This week'),(340,'This will increase the shipping cost by XX'),(1303,'This year'),(2216,'Three columns'),(1304,'Through'),(1305,'Thumbnail'),(2838,'Time left'),(1419,'Timeout error'),(2323,'Tip from X-Cart'),(1306,'Title'),(3345,'Title for customers'),(11,'To activate your X-Cart license, enter your secret key into the field below and click Activate.'),(12,'To activate your X-Cart or commercial module license, enter your license key into the field below and click Activate.'),(273,'To boost your sales try to use Discounts coupons, Sale, Product Advisor, Volume discounts addons. Also you may be interested in all Marketing extensions from our Marketplace'),(1766,'To change the password, log into your company account and use the \'Modify profile\' link'),(1599,'To change the roles of your profile, contact the store administrator'),(4802,'To complete the StripeApplePay configuration'),(1310,'To contact us please fill the form below'),(1411,'To continue, please, sign in'),(1311,'To email'),(333,'To enable secure protocol for your website pages you need a valid SSL certificate purchased for the website domain and installed on your server.'),(3710,'To enable this payment method, you need <Multi-vendor> module installed.'),(3709,'To enable this payment method, you need Multi-vendor module installed.'),(3877,'To ensure that products sorting and the addon Product Filter works correctly, after changing or adding sale offers, launch the re-calculation of quick data.'),(275,'To fix this problem, do the following: 3 points'),(258,'To get the format of the import data you can export your products to a file'),(1545,'To have attributes specific for product classes, define product classes first.'),(332,'To make the online store use the secure protocol you need an SSL certificate purchased for the website domain and installed on your server.'),(2523,'To make your changes visible in the customer area, cache rebuild is required. It will take several seconds. You don’t need to close the storefront, the operation is executed in the background.'),(1312,'To place the order please accept Terms and Conditions'),(1313,'To place the order please complete the previous steps first'),(1314,'To recover your password, please type in the valid e-mail address you use as a login'),(4068,'To request a return please fill the form below'),(3179,'To send email asynchronously and improve website performance we recommend to set up queues in on your server. [Learn how to do it].'),(3923,'To set up the integration you should follow '),(4264,'To set up the integration, go to the _Site management_'),(13,'To setup Tax Rates, find and install the appropriate addons from Marketplace'),(2839,'To setup Tax Rates, find and install the appropriate addons from Marketplace\', {\'url\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Taxes'),(4106,'To start registration process for Canada Post merchant account click on the \"Register\" button.'),(3498,'To use the coupon, your order subtotal must be at least X'),(3497,'To use the coupon, your order subtotal must be between X and Y'),(3499,'To use the coupon, your order subtotal must not exceed Y'),(1315,'Today'),(3981,'Too large value for absolute discount'),(2687,'Tools'),(3807,'Top (ppcm)'),(4476,'Top News'),(191,'Top X products'),(80,'Top banner'),(1316,'Top sellers'),(1317,'Top selling products'),(210,'Total'),(4412,'Total amount of orders'),(4091,'Total items weight'),(4130,'Total weight'),(1772,'Totals'),(1175,'Track package'),(4135,'Tracking details'),(1183,'Tracking information has been sent'),(3934,'Tracking information was updated successfully'),(2417,'Tracking number'),(1181,'Tracking number is changed from \"{{old_number}}\" to \"{{new_number}}\"'),(1178,'Tracking numbers'),(4085,'Tracking pin'),(4073,'Tracking pins'),(3600,'Traditional'),(2423,'Transaction'),(2840,'Transaction ID'),(2085,'Transaction amount mismatch'),(5064,'Transaction for order has failed'),(5063,'Transaction for this order has failed. Next charge attempt will be at'),(3198,'Transaction is in progress'),(3457,'Transaction key'),(3360,'Transaction made'),(2054,'Transaction type'),(3258,'Transaction was failed'),(2650,'Transactions details'),(1318,'Translation driver'),(105,'Translations'),(4126,'Transmit shipment'),(3389,'Trial Plan'),(3105,'Trial has expired!'),(304,'Trial period X days'),(1992,'Trial period expires today'),(1991,'Trial period is expired'),(4041,'Try clearing filters or different search terms.'),(1791,'Try search-as-you-type feature...'),(1857,'Try to change the search criteria or find the needed solution in marketplace'),(2841,'Try to change the search criteria or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(3766,'Try to reconnect'),(1858,'Try to search worldwide or find the needed solution in marketplace'),(2842,'Try to search worldwide or find the needed solution in marketplace\', {\'URL\': url(\'addons_list_marketplace\', \'\', {\'tag\': \'Payment processing'),(1459,'Try to unpack them manually'),(274,'Trying to access the shop at X'),(2608,'Trying to run pre-upgrade hooks while not all archives were unpacked'),(3587,'Tweet'),(4855,'Twig-template path'),(1319,'Twitter'),(2215,'Two columns with left sidebar'),(2214,'Two columns with right sidebar'),(1320,'Type'),(1321,'Type of Account'),(3413,'Type of authorization request'),(4399,'Type: checkbox'),(4398,'Type: select box'),(3928,'U.S.P.S. module allows you to use online shipping rates calculation via USPS Web Tools Ecommerce API.'),(2643,'UPS'),(4935,'UPS module allows to use online shipping rates calculation via UPS service.'),(4822,'URL'),(4267,'URL is copied'),(1626,'URLs'),(2644,'USPS'),(3933,'USPS Shipments'),(1869,'Unable to delete file'),(1482,'Unable to delete module X files: some dirs have no writable permissions: Y'),(2747,'Unable to download the contents of {{url}}'),(2749,'Unable to get at the contents of {{url}}'),(3970,'Unable to get merchant info'),(279,'Unable to install module X because some modules, which it depends on, have not been installed or activated yet'),(4895,'Unable to reset layout'),(4897,'Unable to save changes'),(4850,'Unable to save edited content. Errors: '),(2746,'Unable to write data to file {{file}}'),(2682,'Unallowed modules will be disabled automatically on the next visit any page in the administrator interface.'),(2064,'Unavailable'),(3572,'Unblock and renew'),(1324,'Uncheck all'),(93,'Undelete'),(1325,'Understanding Online Payments'),(3780,'Unexpected error'),(1326,'Unexpected error: version value is not passed'),(4261,'Unexpected result was received from ePDQ (transaction status is not set)'),(4389,'Unexpected result was received from iDEAL (transaction status is not set)'),(3449,'Unfortunately, we cannot ship to the specified country'),(1410,'Unfortunately, you don\'t have permissions to access this page.'),(3693,'Unfortunately, your API credentials could not be obtained from your PayPal account automatically.'),(1327,'Uninstall'),(1328,'Units & Formats'),(1329,'Units of measurement'),(3601,'Universal Analytics'),(1330,'Unknown'),(2960,'Unknown core version'),(3321,'Unknown error'),(3636,'Unknown error occurred'),(1500,'Unknown language: X'),(4394,'Unknown payment transaction'),(2170,'Unknown payment. If you see this message after returning from the payment page, please contact the store administrator for information about the status of your payment.'),(4851,'Unknown temporary file'),(2089,'Unlimited'),(4096,'Unpackaged'),(1331,'Unpacking archives, please wait...'),(4975,'Unread'),(1747,'Unselect all'),(1332,'Unset'),(4238,'Unsupported file extension'),(39,'Update'),(4401,'Update MailChimp Lists'),(3971,'Update date'),(1333,'Update exceptions'),(1980,'Update existing items, but skip new items'),(1334,'Update module'),(2852,'Update modules'),(1335,'Update product'),(1336,'Update profile'),(4949,'Update quantity'),(4956,'Update quantity import guide'),(4469,'Update store data'),(3972,'Update tracking info'),(1337,'Updated components'),(1338,'Updates are available'),(1340,'Updates for the X-Cart core and/or installed modules are available'),(1341,'Updates for your version ({{version}})'),(2843,'Updating data from the marketplace...'),(1342,'Upgrade'),(2474,'Upgrade access level cannot be changed for default free license'),(2470,'Upgrade access level has been successfully assigned to your license keys'),(2471,'Upgrade access level tooltip message'),(1343,'Upgrade available'),(1344,'Upgrade core'),(1733,'Upgrade for X-Cart core is available'),(1345,'Upgrade module'),(2868,'Upgrade not allowed'),(2350,'Upgrade note'),(3085,'Upgrade phar warning'),(1346,'Upgrade to version {{version}}'),(1347,'Upload'),(4545,'Upload a new logo'),(1348,'Upload add-on'),(1349,'Upload and restore'),(4506,'Upload company logo'),(1350,'Upload file'),(3041,'Upload file size limit'),(1515,'Upload files'),(1550,'Upload from server'),(1551,'Upload from your computer'),(4825,'Upload image'),(4933,'Upload images and setup your banners to showcase top products or promote new sales.'),(4451,'Upload store data to MailChimp'),(87,'Upload via URL'),(4927,'Upload your brand logos to include in the store header and browser tab.'),(4538,'Upload your company logo'),(4470,'Uploading data has been completed successfully.'),(4471,'Uploading data has been stopped.'),(3668,'Use PayPal authentication method'),(3564,'Use X-Sendfile to facilitate the download of large file attachments (100 Mb and larger) by customers:'),(1351,'Use a merchant account from your financial institution or choose a bundled payment solution to accept credit cards and other methods of payment on your website.'),(1352,'Use a merchant account from your financial institution to accept online payments'),(4803,'Use custom css'),(1353,'Use custom js'),(1355,'Use default logo'),(1357,'Use dynamic image help'),(1356,'Use dynamic image resizing'),(3444,'Use existing Amazon account'),(3704,'Use existing PayPal account'),(3702,'Use existing account from'),(1354,'Use lazy loading'),(3845,'Use of Restriction key must be disabled in your Quantum Gateway merchant center account at all times.'),(3726,'Use of the unsupported Payment Data Transfer (PDT) method has been detected'),(2036,'Use our new nifty module to automatically backup your store and be able to restore it if anything crops up.'),(4929,'Use the Description Editor toolbar below to select and edit text on your store pages.'),(4889,'Use the Google Tag Manager addon for more flexibility when adding JS code to your web pages.'),(4286,'Use the addon Google Product Feed for advanced flexibility generating a data feed for Facebook based on the product attributes and variants from your store catalog'),(1358,'Use the category name'),(1768,'Use the following key to access safe mode'),(2286,'Use the form below to provide your license information.'),(1359,'Use the navigation bar above this dialog to navigate through the catalog categories'),(3893,'Use the same tax rates for all user membership levels'),(4005,'Use this X-Cart and Google Ads integration to:'),(3952,'Use this field for instructions in case the package is not delivered.'),(1360,'Use this section to back the database of your online store up. Please note that the database backup procedure can take up to several minutes.'),(1554,'Use this section to back up the database of your online store. Please note that the database backup procedure can take up to several minutes.'),(1361,'Use this section to define shipping zones.'),(1362,'Use this section to define your store\'s shipping methods.'),(1363,'Use this section to manage the list of existing countries. This list is used in the shipping settings and calculations, and in the registration form at the Customer Front-end.'),(1364,'Use this section to manage the lists of counties, provinces, regions and states of different countries. The lists are used in shipping settings and calculations, and in the registration form at the Customer Front-end.'),(1365,'Use this section to restore the database of your online store. Please note that the database restoration procedure can take up to several minutes'),(1366,'Use this section to review the list of existing membership levels and add new ones'),(2083,'User'),(242,'User X is logged in'),(1731,'User activity'),(1774,'User filled in Contact Us form'),(4582,'User manuals, release notes, modules, videos and more.'),(1367,'User membership'),(1368,'User type'),(1369,'Username or e-mail'),(1370,'Users'),(3135,'Users list'),(1371,'Uses count'),(1372,'Uses left'),(2679,'Using the modules with this type of license violation is illegal'),(2301,'VALID THRU'),(1373,'VAT'),(3532,'Valid only for specific products'),(1374,'Validate key'),(1375,'Value'),(4289,'Value for the \"Add to cart\" event is calculated as'),(4293,'Value for the \"InitiateCheckout\" event is calculated as'),(4292,'Value for the \"ViewContent\" event on a product page is calculated as'),(2375,'Variables for this notification'),(2223,'Variant attribute \"{{column}}\" cannot be empty'),(3759,'Venmo'),(1521,'Verification results'),(2364,'Verified'),(4507,'Verify geo settings'),(2365,'Verifying data before importing...'),(1376,'Version'),(1377,'Version change'),(86,'Via URL'),(1942,'View all addons'),(1754,'View all low inventory products'),(1378,'View all open orders'),(2142,'View all ordered items'),(4576,'View all payment methods'),(217,'View cart'),(84,'View image'),(1666,'View in list'),(3322,'View in my addons'),(1379,'View logs'),(2469,'View more addons in Marketplace'),(2706,'View order history'),(1380,'View profile'),(2387,'View storefront'),(1381,'View system logs'),(1382,'View update log'),(3900,'Visible for'),(4626,'Visible in products filter'),(1383,'Visit module details page'),(1384,'Visit storefront'),(2516,'Visit the template store'),(2103,'Void'),(2732,'Void multiple[TT]'),(2731,'Void partially[TT]'),(4124,'Void shipment'),(2696,'Void[S]'),(2730,'Void[TT]'),(1386,'Volume discount'),(3985,'Volume discount can be limited to customers with these address zones'),(3984,'Volume discount can be limited to customers with this membership level'),(1385,'Volume discounts'),(4705,'Votes: X'),(1681,'WARNING! There are no more available administrators\' profiles. You will not be able to manage your store after you delete this profile.'),(360,'WE'),(3602,'Want help with SEO? Ask X-Cart Guru'),(2622,'Want to change or add another accounting system? Choose the accounting system you require below and configure it.'),(3149,'Want to customize review surveys and display video testimonials? Try Shopper Approved and collect up to 70x more ratings and reviews'),(3778,'Want to use another account?'),(1387,'Warning'),(1700,'Warning!'),(1720,'Warning! CSV file was not specified.'),(1698,'Warning! InnoDB engine is not supported. It is required for software operation'),(1656,'Warning! Installing this module will overwrite all language labels translated to the appropriate language.'),(4392,'Warning! Please re-check public and private key values!'),(1723,'Warning! The file you have specified in the \'File (CSV) for upload\' field has not been uploaded to the server.'),(1721,'Warning! The file you have specified in the \'File (CSV) local\' field does not exist or cannot be read.'),(3107,'Warning! The image cannot be resized to reduce capacity for better site performance.'),(2496,'Warning! The selected types of content data will be deleted permanently.'),(1388,'Warning! There is not enough product items in stock to process the order'),(4391,'Warning! This payment method requires OpenSSL extension. Please install and enable this extension in your PHP configuration.'),(1552,'Warning: The restoration procedure is irreversible and erases all the data tables from the store database. It is highly recommended that you back up your current database before restoring one of the previous states from a back-up.'),(1389,'Warning: this operation can not be reverted!'),(2722,'Warnings'),(309,'Watch this short video and learn the basics of how online payment processing works'),(1390,'Watch video'),(4178,'Way to deliver'),(1498,'We are already aware of this problem and working on it. If you would like to get in touch, feel free to contact us via our Help center at _URL_'),(3475,'We are always glad to help you.'),(2035,'We are doing our best to make your upgrade process not only easy to do, but safe.'),(3754,'We are experiencing a problem with the \"PayPal For Marketplaces\" payment method.'),(3156,'We couldn\'t find one correct root category'),(3157,'We couldn\'t find one correct root category, however there are possible candidates'),(1504,'We have found a valid SSL certificate installed on the server. Now you can switch the store to use the secure protocol for the store back-end and checkout, sign-in and profile pages.'),(3588,'We recommend to use share button instead of like'),(4590,'We support 120+ payment gateways'),(4691,'We use this email in case we need additional information on your review. We do not use it for any kind of mailing lists or spam subscriptions'),(2037,'We will email you with emergency links to disable custom modules and stay only with original add-ons.'),(4553,'We will use this info to create invoices, send emails and calculate shipping rates for your customers.'),(4549,'We\'ve tried to guess your country, currency and weight. Verify, please.'),(3338,'Weak password'),(4420,'Web ID'),(1391,'Web server'),(4227,'Web server max number of files limit is X'),(4226,'Web server max upload file size limit is X'),(4778,'Webhook URL is your store\'s URL through which Stripe informs your store about any changes in the order'),(3751,'Webhook listener error: could not subscribe to event(s).'),(4814,'Webmaster Mode allows you to change the storefront design in click-and-edit mode'),(4811,'Webmaster mode'),(4816,'Webmaster mode is disabled'),(4815,'Webmaster mode is enabled'),(1749,'Website'),(383,'Week'),(5036,'Weekly'),(26,'Weight'),(27,'Weight X'),(1392,'Weight modifier'),(2576,'Weight range'),(1601,'Welcome'),(208,'Welcome to X-Cart'),(4591,'What about adding some marketing magic to your sales process?'),(1393,'What is benchmark?'),(1607,'What to export'),(2562,'What type of shipping rates would you like to use?'),(306,'What\'s new'),(3453,'When AustraliaPost returns shipping methods which does not exists in the available methods list, these methods will be created in the list automatically'),(3756,'When multiple funding sources are available to the buyer, PayPal automatically determines which additional buttons are appropriate to display. However, you can choose to opt-in or out-of displaying specific funding sources.'),(1394,'When the export is completed, you will be prompted to download the product data file'),(1617,'Whether customers should be able to select an option they require when ordering the product, or the information is provided purely as part of product specification'),(3818,'White (no border) (ppcm)'),(3812,'White (ppcm)'),(3879,'Wholesale prices for this product are disabled because its sale price is set as an absolute value (X). To enable wholesale prices, use the relative value in % for the Sale field.'),(3880,'Wholesale prices for this product variant are disabled because its sale price is set as an absolute value (X). To enable wholesale prices, use the relative value in % for the Sale field.'),(1889,'Widgets cache has been cleaned'),(1890,'Widgets cache has not been cleaned completely'),(2051,'Width'),(1395,'Width (px)'),(3118,'Will be added globally'),(3119,'Will be added to the product class'),(2985,'Will be available if core update is selected'),(2399,'Will be deleted:'),(1735,'Will be installed'),(2396,'Will be updated if core update is selected'),(2637,'Win app'),(3257,'Wonder why it may have happened? It’s likely that your customer entered a wrong card number, password or CVC'),(5000,'Write your message'),(4693,'Write your review'),(2267,'Wrong \"default\" format ({{value}}). Value should be one of \"Yes\" or \"No\"'),(4285,'Wrong \"facebook marketing enabled\" format'),(2266,'Wrong \"owner\" format ({{value}}). Value should be one of \"Yes\" or \"No\"'),(2268,'Wrong \"priceModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%'),(2265,'Wrong \"type\" value ({{value}}). This should be \"C\", \"S\", \"H\" or \"T\"'),(2269,'Wrong \"weightModifier\" format ({{value}}). Correct examples: +1, +1%, -1, -1%'),(2754,'Wrong access level format'),(2274,'Wrong added format'),(2926,'Wrong address same format'),(2925,'Wrong anonymous format'),(2241,'Wrong arrival date format'),(2281,'Wrong billing address format'),(2251,'Wrong box height format'),(2250,'Wrong box length format'),(2249,'Wrong box width format'),(3931,'Wrong container type selected: {{value}}. For large package size only the following types are allowed: RECTANGULAR, NONRECTANGULAR, VARIABLE'),(2282,'Wrong country code format'),(2929,'Wrong currency format'),(2242,'Wrong date format'),(2262,'Wrong display mode format for not selector'),(2261,'Wrong display mode format for selector'),(2236,'Wrong enabled format'),(4331,'Wrong exclude from shipping cost format'),(2275,'Wrong first login date format'),(2253,'Wrong format of Clean URL value (allowed alpha-numeric, \"_\" and \"-\" chars)'),(2449,'Wrong format: Field contains unallowed characters'),(4332,'Wrong free shipping format'),(4322,'Wrong freight fixed fee format'),(2244,'Wrong inventory tracking format'),(2944,'Wrong item order modifier format'),(2252,'Wrong items per box format'),(2279,'Wrong language format'),(2276,'Wrong last login date format'),(2273,'Wrong login format'),(2247,'Wrong low limit level format'),(2246,'Wrong low stock notification format'),(2237,'Wrong meta desc type format'),(1396,'Wrong method_id specifed'),(2942,'Wrong order item backordered quantity format'),(2935,'Wrong order item format'),(2937,'Wrong order item name format'),(2938,'Wrong order item price format'),(2941,'Wrong order item quantity format'),(2936,'Wrong order item sku format'),(2939,'Wrong order item subtotal format'),(2940,'Wrong order item total format'),(2934,'Wrong order modifier format'),(2924,'Wrong order number format'),(2951,'Wrong order transaction currency format'),(2945,'Wrong order transaction format'),(2950,'Wrong order transaction id format'),(2946,'Wrong order transaction method format'),(2948,'Wrong order transaction value format'),(2257,'Wrong position format'),(2235,'Wrong price format'),(4953,'Wrong product quantity value format (\"{{value}}\")'),(2278,'Wrong referer format'),(2756,'Wrong role format'),(2239,'Wrong shippable format'),(2280,'Wrong shipping address format'),(2272,'Wrong show title format'),(2283,'Wrong state id format'),(2277,'Wrong status format'),(2245,'Wrong stock level format'),(2927,'Wrong subtotal format'),(3706,'Wrong token of Express Checkout. Please try again. If the problem persists, contact the administrator.'),(2928,'Wrong total format'),(2260,'Wrong type format'),(2243,'Wrong update date format'),(2240,'Wrong use separate box format'),(4633,'Wrong useClasses format'),(1397,'Wrong value is specified for arrival date field. The field was not updated.'),(2238,'Wrong weight format'),(249,'X GB'),(139,'X Language (Code: Y)'),(248,'X MB'),(3622,'X PIN Codes were not assigned.'),(3605,'X PIN code duplicates ignored.'),(3606,'X PIN codes created successfully.'),(3607,'X PIN codes longer than Y characters ignored.'),(3142,'X addon'),(1494,'X addon(s) selected'),(3143,'X addons'),(3144,'X addons (5)'),(317,'X attributes in group'),(246,'X bytes'),(3486,'X code is already used for other coupon, please specify a different code'),(3485,'X coupon(s) has been created'),(3484,'X coupon(s) has been removed'),(3102,'X day left'),(253,'X days'),(3103,'X days left'),(3104,'X days left (5)'),(3855,'X discount(s) has been created'),(3856,'X discount(s) has been removed'),(291,'X entities has been created'),(290,'X entities has been removed'),(2171,'X expired shopping cart(s) have been successfully removed'),(189,'X field is required'),(1489,'X file type'),(4235,'X file(s) attached'),(254,'X hours'),(263,'X image unable to load'),(212,'X item'),(286,'X item available'),(158,'X item in bag'),(173,'X items'),(4760,'X items ($)'),(287,'X items available'),(159,'X items in bag'),(2866,'X items selected'),(247,'X kB'),(98,'X labels'),(407,'X language labels have been removed'),(406,'X languages have been removed'),(310,'X methods available'),(255,'X minutes'),(192,'X module settings'),(2352,'X module will be disabled'),(2354,'X module will be upgraded'),(2494,'X modules selected'),(2353,'X modules will be disabled'),(2355,'X modules will be upgraded'),(252,'X months'),(4986,'X new message for order'),(5011,'X new messages'),(3511,'X off'),(237,'X order'),(238,'X orders'),(321,'X orders on last day'),(323,'X orders on last month'),(322,'X orders on last week'),(5065,'X payment total of X'),(3531,'X product(s) added'),(289,'X product(s) has been created'),(288,'X product(s) has been removed'),(341,'X products'),(243,'X products found'),(4604,'X products selected'),(235,'X results found'),(324,'X revenue on last day'),(326,'X revenue on last month'),(325,'X revenue on last week'),(256,'X seconds'),(418,'X shipping methods have been created'),(419,'X shipping methods have been removed'),(4652,'X star_1'),(4651,'X stars_2'),(4650,'X stars_3'),(4649,'X stars_4'),(4648,'X stars_5'),(410,'X states have been removed'),(411,'X states have been successfully created'),(5025,'X subscriptions'),(4982,'X unread messages'),(251,'X years'),(412,'X zones have been removed'),(413,'X zones have been successfully created'),(4515,'X% Wizard completion'),(335,'X, including images and file attachments'),(1398,'X-Cart'),(3098,'X-Cart Business trial will expire in X day'),(3099,'X-Cart Business trial will expire in X days'),(3100,'X-Cart Business trial will expire in X days (5)'),(4000,'X-Cart Google Ads by Kliken'),(106,'X-Cart News'),(2905,'X-Cart Team have done their best to make your upgrade process as enjoyable as possible.'),(2542,'X-Cart could not find a valid SSL certificate on your server X.'),(2541,'X-Cart could not find a valid SSL certificate on your server.'),(2540,'X-Cart could not find a valid SSL certificate on your server. Although you can switch the store to use the secure protocol for the website pages, most Internet browsers will likely display a warning message scaring your website visitors away.'),(2163,'X-Cart could not find data in your file.'),(2529,'X-Cart found some issues with installed SSL certificate'),(2438,'X-Cart license key has been successfully verified'),(2439,'X-Cart license key has been successfully verified and activated. But this key has expired and do not allow upgrade store.'),(1399,'X-Cart online store builder'),(4581,'X-Cart professionals will easily materialize just about any idea you’ve got.'),(1400,'X-Cart shopping cart software'),(2869,'X-Cart v5.3 requires PHP version 5.4 or better. Please update the PHP version installed on your server before you proceed.'),(2871,'X-Cart v5.4 requires MariaDB version 10.2.4 or better. Please update the MariaDB version installed on your server before you proceed.'),(2872,'X-Cart v5.4 requires MySQL version 5.7.7 or better. Please update the MySQL version installed on your server before you proceed.'),(2870,'X-Cart v5.4 requires PHP version 7.2 or better. Please update the PHP version installed on your server before you proceed.'),(3065,'XML extensions support'),(1401,'XML parser'),(1402,'XML sitemap'),(3992,'XML sitemap URL: X'),(2302,'YEAR'),(1403,'Yahoo!'),(1404,'Yandex'),(386,'Year'),(2108,'Year when store started its operation'),(1405,'Yes'),(1406,'Yes, I agree with License agreement'),(2393,'Yes, I agree with License agreements'),(2034,'Yes, I have made the full backup of my store files and database'),(4556,'Yes, I sell tangible goods that needed to be shipped'),(1935,'Yes/No'),(2463,'Yesterday'),(4987,'You Have No Messages'),(136,'You are going to delete the X language'),(2548,'You are logged in as: user'),(1407,'You are not allowed to access this resource!'),(4826,'You are now in layout editing mode'),(4827,'You are now in preview mode'),(2544,'You are operating as:'),(2547,'You are operating as: user'),(1777,'You are sure to clear your cart?'),(2681,'You can also contact our CR department for help with this issue'),(4229,'You can attach X file(s)'),(4228,'You can attach X more file(s)'),(1692,'You can build your web-site during FREE evaluation, but you cannot use this installation for real sales without buying a license.'),(2212,'You can change the CSV delimiter for all subsequent imports and exports using this link'),(2211,'You can change the charset for all subsequent imports and exports using this link'),(3393,'You can check your nameservers settings by following the instructions here: {{helpUrl}}.'),(294,'You can choose if to download your database data'),(2957,'You can continue as guest or create an account'),(4914,'You can customize the look & feel of the store by configuring the layout and adding the custom CSS or HTML code.'),(3642,'You can define an order id prefix, which would precede each order number in your shop, to make it unique'),(2591,'You can define the following values:'),(4503,'You can find the failed order here'),(2651,'You can find the failed transaction here'),(2539,'You can get more information using this service: '),(132,'You can install these updates after purchasing and activating your X-Cart license key'),(5075,'You can manage your subscriptions here'),(1765,'You can now use the following credentials to access your account'),(2844,'You can purchase AntiFraud Service subscription'),(2589,'You can set up different shipping rates depending on the weight, price or quantity of items in the order.'),(276,'You can upload the database data directly from your local computer'),(4537,'You can view the newly created product in your [storefront] or add a few [more products] to your catalog.'),(4963,'You cannot choose this product'),(1556,'You cannot save database data to a file on the web server (\'var/backup/sqldump.sql.php\').'),(2760,'You cannot update administrator profile ({{value}}). Row is skipped'),(2759,'You cannot update administrator profile ({{value}}). Row will be skipped'),(3220,'You don’t have any notifications right now.'),(4530,'You have added 1 product'),(4676,'You have already reviewed this product'),(3488,'You have already used the coupon'),(1851,'You have an unpaid order #{{ORDER}}'),(1640,'You have no payment methods enabled in your shop'),(1414,'You have selected to delete your profile. Please, confirm you want to proceed'),(1600,'You have the following roles:'),(4248,'You have to attach file'),(4247,'You have to attach file to product'),(4829,'You have unsaved changes. Are you really sure to exit the preview?'),(4887,'You have unsaved changes. Are you really sure to exit?'),(4181,'You just added'),(3088,'You must register your X-Cart installation before using it for real sales. Activate your existing license key or purchase a premium license to skyrocket your business.'),(20,'You must register your installation before you can use it for real sales'),(2030,'You need hard and soft reset links in case some 3rd party module crashes your web-store'),(2845,'You need these links in case you want to recover your store'),(2535,'You should check available free disk space yourself before continuing installation'),(2534,'You should check available free disk space yourself before continuing upgrade'),(2349,'You should confirm that you have created backup before upgrading the store.'),(1848,'You tried to buy more items of \"{{product}}\" product {{description}} than are in stock. We have {{amount}} item(s) only. Please adjust the product quantity.'),(3619,'You will be able to add pin codes after saving changes.'),(1559,'You will be able to provide additional product info (images, attributes, etc.) after you submit this form.'),(4568,'You\'ve successfully set up shipping areas and rates for your store'),(2128,'Your \"Password reset key\" has expired. Please enter the email address associated with your user account to get a new \"Password reset key\".'),(3692,'Your API credentials have been successfully obtained from your PayPal account and saved for use by your X-Cart store.'),(1823,'Your Account'),(3472,'Your Message'),(3195,'Your PHP version is outdated'),(3196,'Your PHP version is outdated and no longer supported'),(3769,'Your PayPal account is not fully configured, please check that:'),(4777,'Your Stripe account is no longer accessible. Please connect with Stripe once again.'),(3087,'Your X-Cart Business trial has expired!'),(1691,'Your X-Cart installation is licensed for evaluation purposes only.'),(4013,'Your X-Cart store is connected to your Kliken account.'),(1408,'Your access link has been expired'),(3122,'Your access to X-Cart Business features expires in X day'),(3123,'Your access to X-Cart Business features expires in X days'),(3124,'Your access to X-Cart Business features expires in X days (5)'),(307,'Your account email is X'),(1424,'Your account information will be e-mailed to you shortly'),(1425,'Your account information will be e-mailed to you shortly.'),(308,'Your account password is X'),(3643,'Your account settings'),(3708,'Your address data was not received from PayPal. Please try again. If the problem persists, contact the administrator.'),(221,'Your cart'),(4598,'Your current domain is X'),(1409,'Your custom addons were prepared for certain core version'),(4807,'Your custom file is successfully saved'),(3386,'Your domain name has been changed. It may take a few days for your domain name provider to make all the necessary changes and a few more days for the changes to propagate throughout the internet.'),(1426,'Your e-mail'),(4683,'Your email'),(421,'Your first name'),(422,'Your last name'),(1427,'Your name'),(1764,'Your new password'),(1970,'Your order details will be sent to your e-mail address'),(4315,'Your order details will be sent to your email address'),(3645,'Your partner name is PayPal'),(3779,'Your payment could not be processed at this time. Please make sure the card information was entered correctly and resubmit. If the problem persists, please contact your credit card company to authorize the purchase.'),(3446,'Your payment could not be processed, please follow the instructions in the payment method box.'),(3445,'Your payment could not be processed. Please try to place the order again using another payment method.'),(3137,'Your payment has been processed; now the addon can be installed.'),(3138,'Your payment is being processed. The addon license key will be sent to your email address as soon as the processing has been completed. You will be able to use this key to install the addon at any time. '),(3556,'Your payment module to accept payments for digital items. [Get it now]!'),(4680,'Your product rating is saved. Thank you!'),(1428,'Your products will be exported as a CSV file.'),(1773,'Your profile modified'),(2357,'Your request has been sent successfully'),(3376,'Your request has been sent, our manager will contact you shortly.'),(4694,'Your review'),(4681,'Your review has been updated. Thank your for sharing your opinion with us!'),(170,'Your shopping bag - X item'),(171,'Your shopping bag - X items'),(1429,'Your shopping bag is empty'),(1430,'Your state'),(1431,'Your store'),(1503,'Your store is configured to use the secure protocol for the store back-end and checkout, sign-in and profile pages.'),(4012,'Your store is connected.'),(1432,'Your store is currently unable to calculate taxes'),(4345,'Your store uses the addon Geolocation'),(5070,'Your subscription X has been activated'),(5073,'Your subscription X has been stopped'),(5069,'Your subscription has been activated'),(5072,'Your subscription has been stopped'),(2361,'Your version (X) can be upgraded to'),(4187,'Z - A'),(185,'Zero cannot be used'),(1433,'Zip code'),(1434,'Zip/postal code masks'),(4307,'Zipcode'),(1436,'Zone'),(417,'Zone address masks help'),(416,'Zone city masks help'),(167,'Zone details have been updated successfully'),(1437,'Zone name'),(1490,'Zone not found (X)'),(415,'Zone zipcode masks help'),(1438,'Zones'),(2389,'Zoom image'),(3724,'[BT] In progress'),(2779,'[Edit]'),(3353,'[Inventory] Removed from stock: \"{{product}}\" product amount in stock changes from \"{{oldInStock}}\" to \"{{newInStock}}\" ({{qty}} items)'),(3352,'[Inventory] Return back to stock: \"{{product}}\" product amount in stock changes from \"{{oldInStock}}\" to \"{{newInStock}}\" ({{qty}} items)'),(3354,'[Inventory] Unable to reduce stock for product: \"{{product}}\", amount: \"{{qty}}\" items'),(3355,'[Tracking] Tracking information was updated'),(3259,'[field] year must be between 1970 and 2038'),(4452,'_MailChimp ecommerce info text_'),(174,'_X_ item'),(175,'_X_ items'),(3725,'__pdt-paypal-warning__'),(2058,'a side box'),(3838,'a2cp-source-code-PAB'),(4966,'a2cp-source-code-REL'),(1818,'address during the recent purchase'),(2095,'always'),(1439,'and'),(4905,'app icon uploader'),(1778,'attributes'),(3116,'attributes_popover_text'),(3459,'authorize_key_help'),(1816,'billing'),(3213,'body of the test email'),(4026,'braintree_merchant_account_id_help'),(4027,'braintree_paypal_shipping_override_help'),(4028,'braintree_settings_google_payment_button_color_help'),(4029,'braintree_settings_google_payment_button_type_help'),(1440,'by'),(4499,'by payment callback (Failed + Cancel)'),(4500,'by pressing Place order button'),(1420,'cURL error'),(1704,'cannot create directory'),(280,'cannot set X permissions'),(2343,'checkbox.firstlast.off'),(2342,'checkbox.firstlast.on'),(2341,'checkbox.onoff.off'),(2340,'checkbox.onoff.on'),(3396,'cloud_domain_name.error.domain_in_use'),(2006,'cm'),(3020,'config_file.error_message_1'),(3021,'config_file.label_message'),(4035,'cs_categories'),(4038,'cs_did_you_mean'),(4037,'cs_manufacturers'),(4036,'cs_pages'),(4034,'cs_products'),(4031,'cs_see_details'),(4032,'cs_see_more_results_for'),(4030,'cs_showing_results_for'),(4033,'cs_suggestions'),(4684,'customers'),(2097,'daily'),(1596,'default'),(2786,'default-404-text'),(664,'default-meta-description'),(2777,'default-meta-keywords'),(2776,'default-site-title'),(1501,'deleted'),(2557,'deliveryTime.help'),(4114,'deposit your items at a Post Office'),(1441,'details'),(1676,'dimensions'),(1442,'disabled'),(4837,'disabled blocks'),(2007,'dm'),(3069,'doc_blocks_support.error_message_1'),(3070,'doc_blocks_support.error_message_2'),(3071,'doc_blocks_support.label_message'),(2993,'dom.extension.alert'),(3384,'domain is on sale'),(1881,'done'),(1443,'downloads'),(4458,'e-Commerce Analytics disable warning'),(2645,'eBay'),(4257,'ePDQ Currency'),(4259,'ePDQ Enable logging of ePDQ transactions'),(4258,'ePDQ Invoice number prefix'),(4254,'ePDQ PSPID'),(4255,'ePDQ SHA-IN pass phrase'),(4256,'ePDQ SHA-OUT pass phrase'),(4253,'ePDQ settings note'),(2093,'each'),(1608,'editable'),(3204,'email from Contact information section'),(3771,'email is confirmed'),(428,'email@example.com'),(2320,'emailNotificationAdminGreeting'),(2319,'emailNotificationAdminHeader'),(2321,'emailNotificationAdminSignature'),(2317,'emailNotificationCustomerGreeting'),(2316,'emailNotificationCustomerHeader'),(2318,'emailNotificationCustomerSignature'),(2322,'emailNotificationTipGoogleADS'),(1719,'empty'),(4108,'enable merchant wizard'),(1444,'enabled'),(2060,'expired'),(2061,'expiredF'),(4904,'favicon uploader'),(3579,'fedex.CODStatusOptionComment'),(1706,'file does not exist'),(3045,'file_permissions.error_message_1'),(3046,'file_permissions.error_message_2'),(3047,'file_permissions.kb_message'),(2578,'flat rate'),(748,'from'),(1445,'from URL'),(1446,'from local computer'),(1447,'from local server'),(2020,'g'),(1448,'hard reset'),(4416,'here'),(2360,'hide list'),(2096,'hourly'),(3228,'https://kb.x-cart.com/'),(3247,'https://kb.x-cart.com/general_setup/inaccessible_admin_area_after_enabling_https.html'),(3232,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html'),(3230,'https://kb.x-cart.com/general_setup/moving_x-cart_to_another_location.html#transfering-database'),(3229,'https://kb.x-cart.com/general_setup/what_to_do_if_your_store_says_we_are_deploying_new_changes_and_you_cannot_access_it.html'),(3233,'https://kb.x-cart.com/import-export/'),(3236,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_categories.html'),(3234,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_classes_&_attributes.html'),(3237,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_customers.html'),(3239,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_orders.html'),(3235,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_product_attribute_values.html'),(3238,'https://kb.x-cart.com/import-export/csv_format_by_x-cart_data_type/csv_import_products.html'),(3245,'https://kb.x-cart.com/integrating_your_store_with_other_web-sites/sell_your_products_with_buy_button.html'),(4957,'https://kb.x-cart.com/modules/update_inventory.html'),(3241,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_express_checkout.html'),(3242,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payflow_link.html'),(3243,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_advanced.html'),(3244,'https://kb.x-cart.com/payments/paypal/setting_up_paypal_payments_standard.html'),(3231,'https://kb.x-cart.com/seo_and_promotion/setting_up_seo-friendly_urls.html'),(3240,'https://kb.x-cart.com/setting_up_x-cart_5_environment/configuring_attachments_sending.html'),(3246,'https://kb.x-cart.com/shipping/custom_table_rates.html'),(3249,'https://kb.x-cart.com/shipping/free_shipping.html'),(3251,'https://kb.x-cart.com/taxes/UK_EU_taxes/'),(3253,'https://kb.x-cart.com/taxes/canadian_taxes/'),(3254,'https://kb.x-cart.com/taxes/setting_up_tax_classes.html'),(3250,'https://kb.x-cart.com/taxes/tax_guide.html'),(3252,'https://kb.x-cart.com/taxes/us_taxes/'),(3248,'https://kb.x-cart.com/users/user_roles.html'),(3061,'https_bouncer.error_message_1'),(3062,'https_bouncer.error_message_2'),(3064,'https_bouncer.kb_message'),(3063,'https_bouncer.label_message'),(4385,'iDEAL Currency'),(4387,'iDEAL Enable logging of iDEAL transactions'),(4386,'iDEAL Invoice number prefix'),(4379,'iDEAL Merchant ID'),(4383,'iDEAL Private Key'),(4384,'iDEAL Private Key Password'),(4381,'iDEAL Public Certificate File'),(4382,'iDEAL Public Key'),(4380,'iDEAL SubID'),(1670,'if you have any questions'),(3201,'imgsize-XLite\\Model\\Image\\Common\\Logo-Default'),(2527,'imgsize-category-Default'),(2524,'imgsize-product-Default'),(2525,'imgsize-product-LGThumbnailGrid'),(2526,'imgsize-product-LGThumbnailList'),(1449,'in description'),(1450,'in title'),(2677,'inactive license key(s);'),(2008,'inches'),(3018,'install_script.error_message_1'),(2678,'installed module(s) not allowed by the type of X-Cart license activated at your store.'),(1484,'invalid module ID passed: X'),(1451,'is available'),(1677,'item(s)'),(1776,'item(s) in stock'),(214,'items'),(1452,'items available'),(2999,'itemslist.admin.category.blank'),(3525,'itemslist.admin.coupon.blank'),(3000,'itemslist.admin.membership.blank'),(3917,'itemslist.admin.menu.blank'),(4486,'itemslist.admin.news_message.blank'),(2995,'itemslist.admin.order.blank'),(2994,'itemslist.admin.order.search.blank'),(3916,'itemslist.admin.page.blank'),(2998,'itemslist.admin.product.blank'),(2997,'itemslist.admin.product.search.blank'),(4729,'itemslist.admin.review.blank'),(3853,'itemslist.admin.sale_discounts.blank'),(3013,'itemslist.admin.subcategory.blank'),(4494,'itemslist.admin.subscribers.blank'),(4643,'itemslist.admin.tag.blank'),(4877,'itemslist.admin.template.blank'),(2996,'itemslist.admin.transaction.blank'),(3982,'itemslist.admin.volume_discounts.blank'),(2019,'kg'),(1593,'label name,'),(1594,'label translation.'),(4063,'label.coming_soon'),(1587,'labels count:'),(1592,'language code,'),(2017,'lbs'),(4214,'learn more'),(1453,'less'),(3551,'less one hour'),(1627,'local files'),(4903,'logo uploader'),(3073,'loopback_request.error_message_1'),(3075,'loopback_request.kb_message'),(3074,'loopback_request.label_message'),(3208,'mail tester line 1'),(3209,'mail tester line 2'),(3210,'mail tester line 3'),(3211,'mail tester line 4'),(4453,'mailchimp_settings_promo_text'),(2992,'mbstring.extension.alert'),(2005,'mm'),(1486,'module version X is not equal to the core one (Y)'),(4,'module-sort-Alphabetically'),(2,'module-sort-Most popular'),(3,'module-sort-Newest'),(1454,'modules'),(2099,'monthly'),(2705,'more'),(1455,'ms'),(1609,'multi value'),(3053,'mysql_cache.error_message_1'),(3049,'mysql_version.error_message_1'),(3050,'mysql_version.error_message_2'),(3051,'mysql_version.error_message_3'),(45,'n/a'),(2741,'na_admin'),(2713,'na_customer'),(1456,'never'),(3141,'new core'),(3145,'new core and X addon'),(3146,'new core and X addons'),(3147,'new core and X addons (5)'),(4907,'new template'),(5030,'next attempt on'),(2194,'no comments'),(1457,'none'),(1458,'not all archives were unpacked'),(430,'not all upgrade packs were downloaded'),(1460,'not available for sale'),(4498,'not finished'),(1461,'not installed'),(1462,'not ready to download packs. Please, try again'),(2886,'notification.column.administrator'),(2885,'notification.column.customer'),(2882,'notification.section.administrator'),(2881,'notification.section.customer'),(2884,'notification.tab.administrator'),(2883,'notification.tab.customer'),(1732,'now disabled'),(1463,'of'),(4523,'onboarding.add_product.heading'),(4525,'onboarding.add_product.import'),(4524,'onboarding.add_product.text'),(4519,'onboarding.cloud.intro.text'),(4522,'onboarding.intro.disable_button'),(4517,'onboarding.intro.heading'),(4521,'onboarding.intro.later_button'),(4520,'onboarding.intro.next_button'),(4518,'onboarding.intro.text'),(1464,'options'),(1465,'or'),(3700,'or go to checkout as a New customer'),(2956,'or proceed with'),(2846,'or use the form below'),(4686,'out of'),(1664,'outdated'),(2018,'oz'),(2311,'paymentStatus.Active'),(2312,'paymentStatus.Inactive'),(3783,'paypal_commerce_platform_welcome_text'),(3784,'paypal_commerce_platform_welcome_text_configured'),(3675,'paypal_welcome_text'),(2579,'per item'),(236,'per page'),(2580,'per weight unit'),(297,'percent X off'),(3772,'permission granted for X-Cart app'),(3028,'php_disabled_functions.error_message_1'),(3030,'php_disabled_functions.kb_message'),(3029,'php_disabled_functions.label_message'),(3035,'php_file_uploads.error_message_1'),(3036,'php_file_uploads.label_message'),(3055,'php_gdlib.error_message_1'),(3056,'php_gdlib.error_message_2'),(3032,'php_memory_limit.error_message_1'),(3033,'php_memory_limit.label_message'),(3038,'php_pdo_mysql.error_message_1'),(3040,'php_pdo_mysql.kb_message'),(3039,'php_pdo_mysql.label_message'),(3058,'php_phar.error_message_1'),(3059,'php_phar.label_message'),(3042,'php_upload_max_file_size.error_message_1'),(3043,'php_upload_max_file_size.label_message'),(3023,'php_version.error_message_1'),(3024,'php_version.error_message_2'),(3025,'php_version.error_message_3'),(3026,'php_version.label_message'),(1412,'please sign in'),(3749,'pp-button-location:Add2Cart popup'),(3745,'pp-button-location:Cart'),(3747,'pp-button-location:Checkout'),(3748,'pp-button-location:Checkout (credit)'),(3746,'pp-button-location:Minicart'),(3744,'pp-button-location:Product list'),(3743,'pp-button-location:Product page'),(2291,'price-All'),(2293,'price-Free'),(2292,'price-Paid'),(1684,'products'),(1466,'proxy'),(3478,'recaptcha_terms_of_service'),(3462,'relay_response_help'),(1939,'requested for'),(1529,'requested once or twice'),(1528,'requested only once'),(134,'required'),(4721,'reviewMetaDescription'),(1467,'sale'),(2896,'same as shipping'),(2094,'save'),(4459,'send all discount coupons'),(4460,'send only discount coupons with matched rules'),(3205,'sender identified by server'),(4113,'shipments are picked up by Canada Post'),(1817,'shipping'),(2584,'shippingFormula.DiscountedSubtotal'),(2586,'shippingFormula.Free'),(2582,'shippingFormula.Items'),(2581,'shippingFormula.Shipping'),(2583,'shippingFormula.Subtotal'),(2585,'shippingFormula.Weight'),(2604,'shippingStatus.Active'),(2605,'shippingStatus.Inactive'),(2572,'shippingTableType.All'),(2569,'shippingTableType.DiscountedSubtotal'),(2571,'shippingTableType.Items'),(2568,'shippingTableType.Subtotal'),(2570,'shippingTableType.Weight'),(1468,'should be performed manually'),(2404,'show list'),(1469,'soft reset'),(3206,'specific email address (set up below)'),(4733,'star_tooltip_1'),(4734,'star_tooltip_2'),(4735,'star_tooltip_3'),(4736,'star_tooltip_4'),(4737,'star_tooltip_5'),(1705,'subdirectories problems'),(36,'submit_restore_pass'),(2558,'tableType.help'),(4909,'template weight'),(2503,'the categories and product classes to which the coupon may be applied;'),(1743,'the custom modifications will be lost'),(2501,'the dates the coupon should be valid for;'),(2059,'the main column'),(2502,'the order subtotal range for which the coupon can be used;'),(2847,'the same as billing'),(4886,'themetweaker.shortcut.save'),(4885,'themetweaker.shortcut.switcher'),(2775,'title-delimiter'),(3199,'to be uninstalled'),(2955,'to enjoy checkout'),(3596,'to view the advanced statistics'),(1470,'trying to install a non-marketplace module: X'),(1471,'trying to unpack non-downloaded archives'),(4908,'type filename and press Enter'),(1485,'unable to add module entry to the installation list: X'),(1472,'unable to install: not all archives were unpacked. Please, try again'),(1473,'unable to test files: not all archives were unpacked'),(1487,'unable to upload module'),(2493,'unavailable'),(2092,'units'),(1474,'unknown'),(1875,'unknown error'),(3165,'up to 1 decimal'),(3167,'up to 10'),(3168,'up to 100'),(3164,'up to 2 decimals'),(3166,'up to integer'),(1658,'upgrade core'),(2989,'upgrade_warning_text'),(4936,'ups.CODStatusOptionComment'),(3929,'usps.CODStatusOptionComment'),(1696,'verified version'),(2359,'view list'),(4688,'votes'),(4092,'warning: parcel is overweight'),(4820,'webmasterMode.Disabled'),(4819,'webmasterMode.Enabled'),(2098,'weekly'),(1675,'weight'),(2504,'whether the coupon may be used by everyone or only by users with specific memberships.'),(4876,'xlite-translation-popover.help'),(3066,'xml_support.error_message_1'),(3067,'xml_support.label_message'),(5056,'xps.days'),(5049,'xps.each__monthDay'),(5050,'xps.each__monthDay_reverse'),(5051,'xps.each__yearDay'),(5052,'xps.each__yearDay_reverse'),(5046,'xps.each_friday'),(5042,'xps.each_monday'),(5047,'xps.each_saturday'),(5048,'xps.each_sunday'),(5045,'xps.each_thursday'),(5043,'xps.each_tuesday'),(5044,'xps.each_wednesday'),(5035,'xps.every__days'),(5039,'xps.every__months'),(5037,'xps.every__weeks'),(5041,'xps.every__years'),(5054,'xps.month'),(5058,'xps.months'),(5034,'xps.number_suffix'),(5060,'xps.total_of__payments'),(5053,'xps.week'),(5057,'xps.weeks'),(5055,'xps.year'),(5059,'xps.years'),(2100,'yearly'),(3770,'you have permission to receive payments'),(1475,'you save'),(1745,'your web site may crash'),(4644,'{{count}} Tag duplicates ignored'),(1971,'{{count}} created'),(3263,'{{count}} day'),(3264,'{{count}} days'),(1972,'{{count}} updated'),(3390,'{{currentEdition}} Plan'),(2822,'{{field}} length must be less then {{length}}'),(2748,'{{file}} does not exist on the filesystem'),(2745,'{{file}} file could not be copied to a new location {{newPath}}'),(3351,'{{ip}} IP address used'),(1906,'{{module}} license agreement'),(1986,'{{name}} attributes'),(1865,'{{paymentMethod}} settings'),(3932,'{{value}} is an invalid container type for a REGULAR package. Valid Container is: VARIABLE');
CREATE TABLE `xlite_sales_taxes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_class_coupons` (
  `coupon_id` int(10) unsigned NOT NULL,
  `class_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`coupon_id`,`class_id`),
  KEY `IDX_684B0DA666C5951B` (`coupon_id`),
  KEY `IDX_684B0DA6EA000B10` (`class_id`),
  CONSTRAINT `FK_684B0DA666C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `xlite_coupons` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_684B0DA6EA000B10` FOREIGN KEY (`class_id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_classes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_product_classes` VALUES (1,0),(2,0),(3,0);
CREATE TABLE `xlite_sale_discount_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sale_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pair` (`sale_id`,`product_id`),
  KEY `IDX_9651D9A14A7E4868` (`sale_id`),
  KEY `IDX_9651D9A14584665A` (`product_id`),
  CONSTRAINT `FK_9651D9A14584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9651D9A14A7E4868` FOREIGN KEY (`sale_id`) REFERENCES `xlite_sale_discounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_payment_status_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `customerName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_702453C2BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_order_payment_statuses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_payment_status_translations` VALUES (1,1,'Awaiting payment','Awaiting payment','en'),(2,2,'Authorized','Authorization hold','en'),(3,3,'Partially Paid','Partially Paid','en'),(4,4,'Paid','Paid','en'),(5,5,'Declined','Declined','en'),(6,6,'Cancelled','Cancelled','en'),(7,7,'Refunded','Refunded','en');
CREATE TABLE `xlite_order_capost_parcels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `number` int(11) NOT NULL,
  `status` char(2) COLLATE utf8_unicode_ci NOT NULL,
  `quoteType` char(2) COLLATE utf8_unicode_ci NOT NULL,
  `boxWeight` decimal(14,4) NOT NULL,
  `boxWidth` decimal(14,4) NOT NULL,
  `boxLength` decimal(14,4) NOT NULL,
  `boxHeight` decimal(14,4) NOT NULL,
  `isDocument` tinyint(1) NOT NULL,
  `isUnpackaged` tinyint(1) NOT NULL,
  `isMailingTube` tinyint(1) NOT NULL,
  `isOversized` tinyint(1) NOT NULL,
  `notifyOnShipment` tinyint(1) NOT NULL,
  `notifyOnException` tinyint(1) NOT NULL,
  `notifyOnDelivery` tinyint(1) NOT NULL,
  `optSignature` tinyint(1) NOT NULL,
  `optCoverage` decimal(14,4) NOT NULL,
  `optAgeProof` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `optWayToDeliver` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `optNonDelivery` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `hasRemovedItems` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_35C9355A8D9F6D38` (`order_id`),
  KEY `status` (`status`),
  KEY `number` (`number`),
  CONSTRAINT `FK_35C9355A8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `orderby` int(11) NOT NULL,
  `alt` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_142C546A4584665A` (`product_id`),
  CONSTRAINT `FK_142C546A4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_product_images` VALUES (1,1,10,'',366,366,'5ded189d3bbd436c32879f41403c5275',1,'shoes_2.jpg','shoes_2.jpg','image/jpeg','r',122598,1603972218),(2,1,11,'',366,366,'72e1bc7df6b20b8ac86e4bac206ccfd7',1,'shoes_3.jpg','shoes_3.jpg','image/jpeg','r',112427,1603972218),(3,2,10,'',732,732,'b5ef96c15d71f393c7276b0ca3aa402b',1,'shoes_6_2.jpg','shoes_6_2.jpg','image/jpeg','r',211619,1603972218),(4,3,10,'',732,732,'f643d4f0a1e7d5fd405e77ae5672a4d5',1,'shoes_7.jpg','shoes_7.jpg','image/jpeg','r',278209,1603972218),(5,4,10,'',732,732,'fefe7884312c28889d8430380311b27d',1,'shoes_8.jpg','shoes_8.jpg','image/jpeg','r',319856,1603972218),(6,5,10,'',732,732,'48592510b2063993e5f803e59b2c8ab9',1,'shoes_12.jpg','shoes_12.jpg','image/jpeg','r',216275,1603972218),(7,6,10,'',732,732,'a94186fcd7e40c24765c982d7b576b5e',1,'shoes_1_1.jpg','shoes_1_1.jpg','image/jpeg','r',382721,1603972218),(8,6,11,'',366,366,'5ded189d3bbd436c32879f41403c5275',1,'shoes_2.jpg','shoes_2.jpg','image/jpeg','r',122598,1603972218),(9,6,12,'',366,366,'72e1bc7df6b20b8ac86e4bac206ccfd7',1,'shoes_3.jpg','shoes_3.jpg','image/jpeg','r',112427,1603972218),(10,7,10,'',732,732,'b3635fc2d8aa4ef1f19a2e248c138a44',1,'clo_1.jpg','clo_1.jpg','image/jpeg','r',304708,1603972218),(11,8,10,'',732,732,'47a8557ebe4e6218c90f1681dfae0c8e',1,'shoes_16.jpg','shoes_16.jpg','image/jpeg','r',316457,1603972218),(12,9,10,'',732,732,'c2b56da593cf6f7ad509f8c2559c897a',1,'shoes_17.jpg','shoes_17.jpg','image/jpeg','r',130244,1603972218),(13,10,10,'',732,732,'f0cc924cf94ff0303c908cc78f8d18d3',1,'shoes_10.jpg','shoes_10.jpg','image/jpeg','r',290912,1603972218),(14,11,10,'',732,732,'11f0f5f4b0af82e213144f395ab1a8c6',1,'shoes_18.jpg','shoes_18.jpg','image/jpeg','r',127631,1603972218),(15,12,10,'',732,732,'6fd16130fdc6aeaeecd0ba3e2014c18a',1,'clo_3.jpg','clo_3.jpg','image/jpeg','r',266231,1603972218),(16,13,10,'',732,732,'08bb0ea4e7356ff5cb14162aafa21a1f',1,'clo_4.jpg','clo_4.jpg','image/jpeg','r',344419,1603972218),(17,14,10,'',732,732,'cfa4ba9de77efad8cca49c03fab3ef75',1,'clo_5.jpg','clo_5.jpg','image/jpeg','r',349564,1603972218),(18,15,10,'',732,732,'0b2cc12280a1049d984645b44ddf327b',1,'clo_6.jpg','clo_6.jpg','image/jpeg','r',386365,1603972218),(19,16,10,'',732,732,'7b554c0a0dfd7325449e72b198f21511',1,'clo_7_1.jpg','clo_7_1.jpg','image/jpeg','r',257152,1603972218),(20,17,10,'',732,732,'e7832cbe893e541d964588a00ce09ffe',1,'clo_9.jpg','clo_9.jpg','image/jpeg','r',168183,1603972218),(21,17,11,'',732,732,'2ec7efdd4f94cc3550c391a403f3b02f',1,'clo_10.jpg','clo_10.jpg','image/jpeg','r',150421,1603972218),(22,18,10,'',732,732,'d539dc6b5c1f9f057a371539fefbcc41',1,'clo_12.jpg','clo_12.jpg','image/jpeg','r',329242,1603972218),(23,19,10,'',732,732,'d08ff25998edd09c022a4af53adb9aaa',1,'clo_13.jpg','clo_13.jpg','image/jpeg','r',172842,1603972218),(24,20,10,'',732,732,'6440ec8b5e91873c91c687ef1ba5cbd1',1,'clo_14.jpg','clo_14.jpg','image/jpeg','r',285489,1603972218),(25,21,10,'',732,732,'8205a559c6ecf4937622e54734654956',1,'bag_1.jpg','bag_1.jpg','image/jpeg','r',422982,1603972218),(26,22,10,'',732,732,'4ee66031d759af26b815259b5bd7259c',1,'bag_2.jpg','bag_2.jpg','image/jpeg','r',242971,1603972218),(27,23,10,'',732,732,'f4c3e62873d87a3519a08a3862f9b739',1,'bag_3.jpg','bag_3.jpg','image/jpeg','r',166282,1603972218),(28,24,10,'',732,732,'abe6df605d7772745b48a18fac670baa',1,'bag_4.jpg','bag_4.jpg','image/jpeg','r',224829,1603972218),(29,25,10,'',732,732,'942818e9a3913b795d77785675392554',1,'bag_5.jpg','bag_5.jpg','image/jpeg','r',243972,1603972218),(30,26,10,'',732,732,'70ff60f37fe9d23ce08deb010a1708f8',1,'bag_6.jpg','bag_6.jpg','image/jpeg','r',274653,1603972218),(31,27,10,'',732,732,'d1bc3f58d01be2f65a1e28cfd98d0b49',1,'elec_1.jpg','elec_1.jpg','image/jpeg','r',210637,1603972218),(32,28,10,'',732,732,'cc2a3adb9121c384ef11d477e09b929b',1,'elec_2.jpg','elec_2.jpg','image/jpeg','r',357996,1603972218),(33,29,10,'',732,732,'c70c156d3d6e2c4716bde1276747af7e',1,'elec_4.jpg','elec_4.jpg','image/jpeg','r',377716,1603972218),(34,30,10,'',732,732,'911afebafdd943f79ef0e3eaa0d5bcb4',1,'elec_5.jpg','elec_5.jpg','image/jpeg','r',158092,1603972218),(35,31,10,'',732,732,'912c2d7f331b894c4d4531d59b0e9c64',1,'elec_6.jpg','elec_6.jpg','image/jpeg','r',157887,1603972218),(36,31,11,'',732,732,'cc2401c4dc1a3887e39695ad79f944a0',1,'elec_8.jpg','elec_8.jpg','image/jpeg','r',302526,1603972218),(37,31,12,'',732,732,'53947100f508b88c3b89412c967c1415',1,'elec_7.jpg','elec_7.jpg','image/jpeg','r',348307,1603972218),(38,31,13,'',732,732,'8ff9d731d4ff8ee22ad3bb2edf22ccc4',1,'elec_9.jpg','elec_9.jpg','image/jpeg','r',272149,1603972218),(39,32,10,'',732,732,'632d92215fc060706f8e77526d93b060',1,'elec_10.jpg','elec_10.jpg','image/jpeg','r',193913,1603972218),(40,33,10,'',732,732,'8e23c85abbc90895d6823f8c81e044d5',1,'elec_12.jpg','elec_12.jpg','image/jpeg','r',308929,1603972218),(41,34,10,'',732,732,'8e1801b44956155d56aa8826662158ea',1,'elec_13.jpg','elec_13.jpg','image/jpeg','r',125903,1603972218),(42,35,10,'',732,732,'b34fc547c794e52aadd45dd1d42adf6d',1,'elec_14.jpg','elec_14.jpg','image/jpeg','r',41521,1603972218),(43,36,10,'',732,732,'f909745494a4a32f168b8879caeb11f8',1,'beauty_1.jpg','beauty_1.jpg','image/jpeg','r',152303,1603972218),(44,37,10,'',732,732,'0be418fe2ebfa9e7bc3c7ea783842c20',1,'beauty_2.jpg','beauty_2.jpg','image/jpeg','r',291973,1603972218),(45,38,10,'',732,732,'a9323bf9e9cb9a850d573d4a5d37e310',1,'beauty_3.jpg','beauty_3.jpg','image/jpeg','r',240346,1603972218),(46,39,10,'',732,732,'589f5f2b6b75018caff96366454a7858',1,'beauty_4.jpg','beauty_4.jpg','image/jpeg','r',281895,1603972218),(47,40,10,'',732,732,'6ca44c35b8a536e3243d0d54dfc5e04f',1,'beauty_5.jpg','beauty_5.jpg','image/jpeg','r',168037,1603972218),(48,40,11,'',732,732,'cf8d50e9fab8c339145c7aa5ff7a320f',1,'beauty_6.jpg','beauty_6.jpg','image/jpeg','r',233537,1603972218),(49,41,10,'',732,732,'4b48e48810902f52d77cf1598903832a',1,'beauty_7.jpg','beauty_7.jpg','image/jpeg','r',220062,1603972218),(50,42,10,'',732,732,'0bb1b7880af621138c3a537e98ec246f',1,'food_1.jpg','food_1.jpg','image/jpeg','r',438152,1603972218),(51,42,11,'',732,732,'c80ab97d165fcf7fb9e2ca5596088268',1,'food_2.jpg','food_2.jpg','image/jpeg','r',313970,1603972218),(52,43,10,'',732,732,'26fa9303c184873887ae5e3e0d520a7a',1,'food_15.jpg','food_15.jpg','image/jpeg','r',515802,1603972218),(53,43,11,'',732,732,'a6b8995329584c034309ae7eb42318a4',1,'food_3.jpg','food_3.jpg','image/jpeg','r',344415,1603972218),(54,43,12,'',732,732,'19f9adaf3e4d4eb84e26d3a6be8b54ee',1,'food_4.jpg','food_4.jpg','image/jpeg','r',384982,1603972218),(55,44,10,'',732,732,'0b28c5755b7101a4e50143872ecca959',1,'food_9.jpg','food_9.jpg','image/jpeg','r',488705,1603972218),(56,44,11,'',732,732,'315d1dd40665bf55ba566b5e094abd1a',1,'food_10_2.jpg','food_10_2.jpg','image/jpeg','r',206164,1603972218),(57,45,10,'',732,732,'b888e98bed413edd962cd3071b534208',1,'food_11.jpg','food_11.jpg','image/jpeg','r',183001,1603972218),(58,45,11,'',732,732,'d65c7ed048dd10121a841979842deda7',1,'food_12.jpg','food_12.jpg','image/jpeg','r',339607,1603972218),(59,45,12,'',732,732,'08baed017768c35d456c2438b2fff873',1,'food_13.jpg','food_13.jpg','image/jpeg','r',295407,1603972218),(60,46,10,'',732,732,'8ea7fd5acc5aa877ae148884550cf6ae',1,'food_14.jpg','food_14.jpg','image/jpeg','r',227528,1603972218),(61,47,10,'',732,732,'0484dec0681cfbd8f04dedb8299fafb7',1,'food_16.jpg','food_16.jpg','image/jpeg','r',170485,1603972218),(62,47,11,'',732,732,'cac50accc2edb61251252f71d0341f33',1,'food_19.jpg','food_19.jpg','image/jpeg','r',364744,1603972218),(63,47,12,'',732,732,'c76c6ec245c8bd57826a173a8cb6dd44',1,'food_18.jpg','food_18.jpg','image/jpeg','r',261434,1603972218),(64,47,13,'',732,732,'c633bde30412199791c88529d88482fe',1,'food_17.jpg','food_17.jpg','image/jpeg','r',325087,1603972218),(65,48,10,'',732,732,'eaca8963501712ca0df28a68056fc0f1',1,'food_21.jpg','food_21.jpg','image/jpeg','r',260735,1603972218),(66,48,11,'',732,732,'8d26d05267c9d9e3f8811c02857a9208',1,'food_20.jpg','food_20.jpg','image/jpeg','r',230787,1603972218),(67,49,10,'',732,732,'233a724571c3454382efca8fc792dad1',1,'food_22.jpg','food_22.jpg','image/jpeg','r',401814,1603972218),(68,50,10,'',732,732,'882cd0368249ebde28f7c2d9f1cd931e',1,'food_24.jpg','food_24.jpg','image/jpeg','r',361715,1603972218),(69,50,11,'',732,732,'842c2d550d3d002e4a44d42c330d623e',1,'food_23.jpg','food_23.jpg','image/jpeg','r',369035,1603972218),(70,50,12,'',732,732,'d0f576bc493a6a7bc8d699f51df7bc6a',1,'food_25.jpg','food_25.jpg','image/jpeg','r',268903,1603972218);
CREATE TABLE `xlite_category_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `alt` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_3EDA5C4B12469DE2` (`category_id`),
  CONSTRAINT `FK_3EDA5C4B12469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_category_images` VALUES (1,2,'',732,880,NULL,1,'clo_7_1.jpg','','image/jpeg','r',111237,1559324094),(2,3,'',732,880,NULL,1,'clo_5.jpg','','image/jpeg','r',199790,1559317753),(3,4,'',732,880,NULL,1,'shoes_6_2.jpg','','image/jpeg','r',80257,1559317794),(4,5,'',732,880,NULL,1,'bag_1.jpg','','image/jpeg','r',154680,1559320882),(5,6,'',732,880,NULL,1,'beauty_1.jpg','','image/jpeg','r',46495,1559892754),(6,7,'',732,880,NULL,1,'beauty_2.jpg','','image/jpeg','r',102218,1559894538),(7,8,'',732,880,NULL,1,'food_11.jpg','','image/jpeg','r',84336,1559898037),(8,9,'',732,880,NULL,1,'elec_2.jpg','','image/jpeg','r',132698,1559820383),(9,10,'',732,880,NULL,1,'elec_5.jpg','','image/jpeg','r',51859,1559822955),(10,11,'',732,880,NULL,1,'elec_4.jpg','','image/jpeg','r',125842,1559821038),(11,12,'',732,880,NULL,1,'elec_14.jpg','','image/jpeg','r',16200,1559828507);
CREATE TABLE `xlite_attribute_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_class_id` int(10) unsigned DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_59E382E821B06187` (`product_class_id`),
  CONSTRAINT `FK_59E382E821B06187` FOREIGN KEY (`product_class_id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_groups` VALUES (1,2,10),(2,2,20),(3,2,30);
CREATE TABLE `xlite_order_history_events` (
  `event_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `author_id` int(11) DEFAULT NULL,
  `date` int(11) NOT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `comment` longtext COLLATE utf8_unicode_ci NOT NULL,
  `authorName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `authorIp` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `IDX_57EBBA5F8D9F6D38` (`order_id`),
  KEY `IDX_57EBBA5FF675F31B` (`author_id`),
  CONSTRAINT `FK_57EBBA5F8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_57EBBA5FF675F31B` FOREIGN KEY (`author_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_history_events` VALUES (1,1,1,1551771900,'PLACE ORDER','Order placed','N;','',NULL,''),(2,1,1,1551771900,'TRANSACTION','Payment transaction [method: Phone Ordering, type: sale, amount: 18.49, status: Pending]','N;','',NULL,''),(3,1,1,1551771900,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:1;}','Order is initially created',NULL,''),(4,2,1,1553772240,'PLACE ORDER','Order placed','N;','',NULL,''),(5,2,1,1553772240,'TRANSACTION','Payment transaction [method: Phone Ordering, type: sale, amount: 88.67, status: Pending]','N;','',NULL,''),(6,2,1,1553772240,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:2;}','Order is initially created',NULL,''),(7,3,1,1564729080,'PLACE ORDER','Order placed','N;','',NULL,''),(8,3,1,1564729080,'TRANSACTION','Payment transaction [method: Phone Ordering, type: sale, amount: 158.94, status: Pending]','N;','',NULL,''),(9,3,1,1564729080,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:3;}','Order is initially created',NULL,''),(10,4,1,1575162780,'PLACE ORDER','Order placed','a:1:{s:7:\"orderId\";i:4;}','',NULL,''),(11,4,1,1575172780,'TRANSACTION','Back end payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed] [initial request]','N;','',NULL,''),(12,4,1,1575172780,'TRANSACTION','Payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed]','N;','',NULL,''),(13,4,1,1575172780,'CHANGE PAYMENT STATUS ORDER','Order payment status changed from {{oldStatus}} to {{newStatus}}','a:3:{s:7:\"orderId\";i:4;s:9:\"newStatus\";s:8:\"Declined\";s:9:\"oldStatus\";s:16:\"Awaiting payment\";}','',NULL,''),(14,4,1,1575175780,'CHANGE PAYMENT STATUS ORDER','Order payment status changed from {{oldStatus}} to {{newStatus}}','a:3:{s:7:\"orderId\";i:4;s:9:\"newStatus\";s:16:\"Awaiting payment\";s:9:\"oldStatus\";s:8:\"Declined\";}','',NULL,''),(15,4,1,1575475780,'TRANSACTION','Back end payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed] [initial request]','N;','',NULL,''),(16,4,1,1575475780,'TRANSACTION','Payment transaction [method: Simplify Commerce Hosted Payments, type: sale, amount: 38.01, status: Failed]','N;','',NULL,''),(17,4,1,1575485780,'CHANGE PAYMENT STATUS ORDER','Order payment status changed from {{oldStatus}} to {{newStatus}}','a:3:{s:7:\"orderId\";i:4;s:9:\"newStatus\";s:8:\"Declined\";s:9:\"oldStatus\";s:16:\"Awaiting payment\";}','',NULL,''),(18,5,1,1575163080,'PLACE ORDER','Order placed','N;','',NULL,''),(19,5,1,1575163080,'TRANSACTION','Payment transaction [method: Money Ordering, type: sale, amount: 352.81, status: Pending]','N;','',NULL,''),(20,5,1,1575163080,'EMAIL ADMIN SENT','Email sent to the admin','a:1:{s:7:\"orderId\";i:5;}','Order is initially created',NULL,'');
CREATE TABLE `xlite_shipping_markups` (
  `markup_id` int(11) NOT NULL AUTO_INCREMENT,
  `method_id` int(11) DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `min_weight` decimal(14,4) NOT NULL,
  `max_weight` decimal(14,4) NOT NULL,
  `min_total` decimal(14,2) NOT NULL,
  `max_total` decimal(14,2) NOT NULL,
  `min_discounted_total` decimal(14,2) NOT NULL,
  `max_discounted_total` decimal(14,2) NOT NULL,
  `min_items` decimal(14,0) NOT NULL,
  `max_items` decimal(14,0) NOT NULL,
  `markup_flat` decimal(14,2) NOT NULL,
  `markup_percent` decimal(14,2) NOT NULL,
  `markup_per_item` decimal(14,2) NOT NULL,
  `markup_per_weight` decimal(14,2) NOT NULL,
  PRIMARY KEY (`markup_id`),
  KEY `IDX_2BE8DC419883967` (`method_id`),
  KEY `IDX_2BE8DC49F2C3FAB` (`zone_id`),
  KEY `rate` (`method_id`,`zone_id`,`min_weight`,`min_total`,`min_discounted_total`,`min_items`),
  KEY `max_weight` (`max_weight`),
  KEY `max_total` (`max_total`),
  KEY `max_discounted_total` (`max_discounted_total`),
  KEY `max_items` (`max_items`),
  KEY `markup_flat` (`markup_flat`),
  KEY `markup_per_item` (`markup_per_item`),
  KEY `markup_percent` (`markup_percent`),
  KEY `markup_per_weight` (`markup_per_weight`),
  CONSTRAINT `FK_2BE8DC419883967` FOREIGN KEY (`method_id`) REFERENCES `xlite_shipping_methods` (`method_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_2BE8DC49F2C3FAB` FOREIGN KEY (`zone_id`) REFERENCES `xlite_zones` (`zone_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_shipping_markups` VALUES (1,91,2,0.0000,999999999.0000,0.00,999999999.00,0.00,999999999.00,0,999999999,2.45,1.50,0.00,0.00),(2,91,3,0.0000,999999999.0000,0.00,999999999.00,0.00,999999999.00,0,999999999,2.50,1.50,0.00,0.00),(3,91,1,0.0000,999999999.0000,0.00,999999999.00,0.00,999999999.00,0,999999999,5.50,1.75,0.00,0.00),(4,92,2,0.0000,999999999.0000,0.00,999999999.00,0.00,999999999.00,0,999999999,3.45,1.75,0.00,0.00),(5,92,3,0.0000,999999999.0000,0.00,999999999.00,0.00,999999999.00,0,999999999,3.50,1.75,0.00,0.00),(6,92,1,0.0000,999999999.0000,0.00,999999999.00,0.00,999999999.00,0,999999999,6.50,1.85,0.00,0.00),(7,93,2,0.0000,999999999.0000,0.00,999999999.00,0.00,999999999.00,0,999999999,100.00,10.00,0.00,0.00),(8,94,1,0.0000,999999999.0000,0.00,999999999.00,0.00,999999999.00,0,999999999,0.00,0.00,0.00,0.00),(9,95,1,0.0000,999999999.0000,50.00,999999999.00,0.00,999999999.00,0,999999999,0.00,0.00,0.00,0.00),(10,96,1,0.0000,999999999.0000,0.00,999999999.00,0.00,999999999.00,0,999999999,0.00,0.00,0.00,0.00),(11,97,1,0.0000,999999999.0000,0.00,999999999.00,0.00,999999999.00,0,999999999,0.00,0.00,0.00,0.00);
CREATE TABLE `xlite_attribute_values_checkbox_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_5A770E51BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_values_checkbox` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_mailchimp_lists` (
  `id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `date_created` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `date_updated` int(11) NOT NULL,
  `list_rating` decimal(3,2) NOT NULL,
  `subscribe_url_short` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `subscribe_url_long` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `member_count` int(11) NOT NULL,
  `open_rate` decimal(5,2) NOT NULL,
  `click_rate` decimal(5,2) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `subscribeByDefault` tinyint(1) NOT NULL,
  `isRemoved` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_usps_shipment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `transactionId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `requestData` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `responseData` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `printDate` int(11) NOT NULL,
  `price` decimal(14,4) NOT NULL,
  `shipmentId` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `trackingNumber` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `trackingData` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `labelURL` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `labelContent` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `IDX_9426ED218D9F6D38` (`order_id`),
  CONSTRAINT `FK_9426ED218D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `expiry` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sid` (`sid`),
  KEY `expiry` (`expiry`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_tab_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `brief_info` longtext COLLATE utf8_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `IDX_D669DEC9BF396750` (`id`),
  CONSTRAINT `FK_D669DEC9BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_product_tabs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_product_tab_translations` VALUES (1,190,'Privacy','','<h2 class=\"hero-headline\">Apple’s commitment to your privacy</h2>\n<p>At Apple, your trust means everything to us. That’s why we respect your privacy and protect it with strong encryption, plus strict policies that govern how all data is handled.</p>\n<p>Security and privacy are fundamental to the design of all our hardware, software, and services, including iCloud and new services like Apple Pay. And we continue to make improvements. Two-step verification, which we encourage all our customers to use, in addition to protecting your Apple ID account information, now also protects all of the data you store and keep up to date with iCloud.</p>\n<p>We believe in telling you up front exactly what’s going to happen to your personal information and asking for your permission before you share it with us. And if you change your mind later, we make it easy to stop sharing with us. Every Apple product is designed around those principles. When we do ask to use your data, it’s to provide you with a better user experience.</p>\n<p>We’re publishing this website to explain how we handle your personal information, what we do and don’t collect, and why. We’re going to make sure you get updates here about privacy at Apple at least once a year and whenever there are significant changes to our policies.</p>\n<p>A few years ago, users of Internet services began to realize that when an online service is free, you’re not the customer. You’re the product. But at Apple, we believe a great customer experience shouldn’t come at the expense of your privacy.</p>\n<p>Our business model is very straightforward: We sell great products. We don’t build a profile based on your email content or web browsing habits to sell to advertisers. We don’t “monetize” the information you store on your iPhone or in iCloud. And we don’t read your email or your messages to get information to market to you. Our software and services are designed to make our devices better. Plain and simple.</p>\n<p>One very small part of our business does serve advertisers, and that’s iAd. We built an advertising network because some app developers depend on that business model, and we want to support them as well as a free iTunes Radio service. iAd sticks to the same privacy policy that applies to every other Apple product. It doesn’t get data from Health and HomeKit, Maps, Siri, iMessage, your call history, or any iCloud service like Contacts or Mail, and you can always just opt out altogether.</p>\n<p>Finally, I want to be absolutely clear that we have never worked with any government agency from any country to create a backdoor in any of our products or services. We have also never allowed access to our servers. And we never will.</p>\n<p>Our commitment to protecting your privacy comes from a deep respect for our customers. We know that your trust doesn’t come easy. That’s why we have and always will work as hard as we can to earn and keep it.</p>\n<p><strong>Tim Cook</strong><br /><span class=\"attribution-title\">CEO, Apple Inc.</span></p>','en'),(2,190,'Конфиденциальность','','<h2 class=\"hero-headline\">Политика конфиденциальности Apple</h2>\n<p>Компания Apple очень дорожит вашим доверием. И мы уважаем ваше право на защиту личных данных. Чтобы обеспечить конфиденциальность, мы используем надёжное шифрование и выполняем строгие правила, которые применяются при обработке любой информации.</p>\n<p>Безопасность и конфиденциальность лежат в основе всех наших устройств, приложений и служб, включая iCloud и новые сервисы, такие как Apple Pay. И мы продолжаем совершенствовать средства защиты. Так, все данные, которые хранятся в iCloud или синхронизируются через него, теперь защищаются при помощи проверки подлинности в два этапа. Мы всем рекомендуем пользоваться ей и обязательно хранить в тайне Apple ID и пароль.</p>\n<p>Мы считаем своей обязанностью заранее предупреждать вас о том, что может случиться с вашей личной информацией, и получать согласие на предоставление этих данных. А если вы передумаете, то в любой момент сможете отключить передачу личных данных. По этому принципу работает каждый продукт Apple. Если мы запрашиваем ваши данные, то только для того, чтобы вам было проще и удобнее пользоваться нашей продукцией.</p>\n<p>Мы создали этот веб-сайт, чтобы объяснить вам, как и почему мы используем личную информацию, какие сведения мы собираем, а какие нет. Мы обязательно будем обновлять текст Политики конфиденциальности на этом сайте как минимум раз в год, а также при внесении любых существенных изменений.</p>\n<p>Несколько лет назад пользователи некоторых интернет-сервисов стали замечать, что из клиентов они превращаются в товар. Мы в Apple убеждены, что высокое качество обслуживания не должно достигаться в ущерб конфиденциальности.</p>\n<p>Модель нашего бизнеса крайне проста: мы продаём отличные продукты. Мы не создаём досье на основе переписки, истории просмотра веб-сайтов и других действий, и мы никогда не выставим на продажу данные своих пользователей. Мы не пытаемся заработать на информации, которую вы храните на iPad и в iCloud. И мы не читаем вашу почту и сообщения, чтобы показывать вам рекламу. Наше программное обеспечение и услуги созданы для вашего удобства. И ни для чего другого.</p>\n<p>Единственное, что мы делаем для рекламодателей — это iAd. Мы создали рекламную сеть, потому что некоторые разработчики зависят от такой модели ведения бизнеса, и нам хотелось бы их поддержать. То же самое можно сказать про бесплатную службу iTunes Radio. iAd подчиняется той же политике безопасности, что и все остальные решения Apple. Она не получает информацию от приложений Здоровье, HomeKit, Карты, Siri и iMessage, не имеет доступа к истории звонков, не подключается к таким службам iCloud, как Контакты или Mail, и так далее. И вы можете полностью от неё отказаться в любой момент.</p>\n<p>Наконец, я хотел бы прямо заявить, что мы никогда не сотрудничали с государственными органами каких бы то ни было стран на предмет создания «лазеек» в наших продуктах и службах. Мы никогда не давали доступа к нашим серверам. И обязуемся не делать этого в будущем.</p>\n<p>Мы защищаем вашу личную информацию, потому что уважаем вас. Мы знаем, как непросто заслужить доверие. И именно поэтому мы всегда будем делать всё возможное, чтобы не утратить его.</p>\n<p><strong>Тим Кук</strong><br /><span class=\"attribution-title\">Генеральный директор Apple Inc.</span></p>','ru'),(3,191,'Конфиденциальность','','<h2 class=\"hero-headline\">Политика конфиденциальности Apple</h2>\n<p>Компания Apple очень дорожит вашим доверием. И мы уважаем ваше право на защиту личных данных. Чтобы обеспечить конфиденциальность, мы используем надёжное шифрование и выполняем строгие правила, которые применяются при обработке любой информации.</p>\n<p>Безопасность и конфиденциальность лежат в основе всех наших устройств, приложений и служб, включая iCloud и новые сервисы, такие как Apple Pay. И мы продолжаем совершенствовать средства защиты. Так, все данные, которые хранятся в iCloud или синхронизируются через него, теперь защищаются при помощи проверки подлинности в два этапа. Мы всем рекомендуем пользоваться ей и обязательно хранить в тайне Apple ID и пароль.</p>\n<p>Мы считаем своей обязанностью заранее предупреждать вас о том, что может случиться с вашей личной информацией, и получать согласие на предоставление этих данных. А если вы передумаете, то в любой момент сможете отключить передачу личных данных. По этому принципу работает каждый продукт Apple. Если мы запрашиваем ваши данные, то только для того, чтобы вам было проще и удобнее пользоваться нашей продукцией.</p>\n<p>Мы создали этот веб-сайт, чтобы объяснить вам, как и почему мы используем личную информацию, какие сведения мы собираем, а какие нет. Мы обязательно будем обновлять текст Политики конфиденциальности на этом сайте как минимум раз в год, а также при внесении любых существенных изменений.</p>\n<p>Несколько лет назад пользователи некоторых интернет-сервисов стали замечать, что из клиентов они превращаются в товар. Мы в Apple убеждены, что высокое качество обслуживания не должно достигаться в ущерб конфиденциальности.</p>\n<p>Модель нашего бизнеса крайне проста: мы продаём отличные продукты. Мы не создаём досье на основе переписки, истории просмотра веб-сайтов и других действий, и мы никогда не выставим на продажу данные своих пользователей. Мы не пытаемся заработать на информации, которую вы храните на iPad и в iCloud. И мы не читаем вашу почту и сообщения, чтобы показывать вам рекламу. Наше программное обеспечение и услуги созданы для вашего удобства. И ни для чего другого.</p>\n<p>Единственное, что мы делаем для рекламодателей — это iAd. Мы создали рекламную сеть, потому что некоторые разработчики зависят от такой модели ведения бизнеса, и нам хотелось бы их поддержать. То же самое можно сказать про бесплатную службу iTunes Radio. iAd подчиняется той же политике безопасности, что и все остальные решения Apple. Она не получает информацию от приложений Здоровье, HomeKit, Карты, Siri и iMessage, не имеет доступа к истории звонков, не подключается к таким службам iCloud, как Контакты или Mail, и так далее. И вы можете полностью от неё отказаться в любой момент.</p>\n<p>Наконец, я хотел бы прямо заявить, что мы никогда не сотрудничали с государственными органами каких бы то ни было стран на предмет создания «лазеек» в наших продуктах и службах. Мы никогда не давали доступа к нашим серверам. И обязуемся не делать этого в будущем.</p>\n<p>Мы защищаем вашу личную информацию, потому что уважаем вас. Мы знаем, как непросто заслужить доверие. И именно поэтому мы всегда будем делать всё возможное, чтобы не утратить его.</p>\n<p><strong>Тим Кук</strong><br /><span class=\"attribution-title\">Генеральный директор Apple Inc.</span></p>','ru'),(4,191,'Privacy','','<h2 class=\"hero-headline\">Apple’s commitment to your privacy</h2>\n<p>At Apple, your trust means everything to us. That’s why we respect your privacy and protect it with strong encryption, plus strict policies that govern how all data is handled.</p>\n<p>Security and privacy are fundamental to the design of all our hardware, software, and services, including iCloud and new services like Apple Pay. And we continue to make improvements. Two-step verification, which we encourage all our customers to use, in addition to protecting your Apple ID account information, now also protects all of the data you store and keep up to date with iCloud.</p>\n<p>We believe in telling you up front exactly what’s going to happen to your personal information and asking for your permission before you share it with us. And if you change your mind later, we make it easy to stop sharing with us. Every Apple product is designed around those principles. When we do ask to use your data, it’s to provide you with a better user experience.</p>\n<p>We’re publishing this website to explain how we handle your personal information, what we do and don’t collect, and why. We’re going to make sure you get updates here about privacy at Apple at least once a year and whenever there are significant changes to our policies.</p>\n<p>A few years ago, users of Internet services began to realize that when an online service is free, you’re not the customer. You’re the product. But at Apple, we believe a great customer experience shouldn’t come at the expense of your privacy.</p>\n<p>Our business model is very straightforward: We sell great products. We don’t build a profile based on your email content or web browsing habits to sell to advertisers. We don’t “monetize” the information you store on your iPhone or in iCloud. And we don’t read your email or your messages to get information to market to you. Our software and services are designed to make our devices better. Plain and simple.</p>\n<p>One very small part of our business does serve advertisers, and that’s iAd. We built an advertising network because some app developers depend on that business model, and we want to support them as well as a free iTunes Radio service. iAd sticks to the same privacy policy that applies to every other Apple product. It doesn’t get data from Health and HomeKit, Maps, Siri, iMessage, your call history, or any iCloud service like Contacts or Mail, and you can always just opt out altogether.</p>\n<p>Finally, I want to be absolutely clear that we have never worked with any government agency from any country to create a backdoor in any of our products or services. We have also never allowed access to our servers. And we never will.</p>\n<p>Our commitment to protecting your privacy comes from a deep respect for our customers. We know that your trust doesn’t come easy. That’s why we have and always will work as hard as we can to earn and keep it.</p>\n<p><strong>Tim Cook</strong><br /><span class=\"attribution-title\">CEO, Apple Inc.</span></p>','en');
CREATE TABLE `xlite_page_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(10) unsigned DEFAULT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ABDA1565C4663E4` (`page_id`),
  CONSTRAINT `FK_ABDA1565C4663E4` FOREIGN KEY (`page_id`) REFERENCES `xlite_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_access_control_zones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cell_id` int(10) unsigned DEFAULT NULL,
  `type_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cz` (`cell_id`,`type_id`),
  KEY `IDX_19AE0547CB39D93A` (`cell_id`),
  KEY `IDX_19AE0547C54C8C93` (`type_id`),
  CONSTRAINT `FK_19AE0547C54C8C93` FOREIGN KEY (`type_id`) REFERENCES `xlite_access_control_zone_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_19AE0547CB39D93A` FOREIGN KEY (`cell_id`) REFERENCES `xlite_access_control_cells` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_category_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `ogMeta` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaTags` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `metaDesc` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metaTitle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9ED79EA5BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_category_translations` VALUES (1,1,'','Catalog','<h1>Welcome to X-Cart Demo Store!</h1><p>It illustrates operation and features of X-Cart - all-in-one eCommerce solution for swift and easy launch of a professional online store. Orders placed here cannot be fulfilled as all the sample products listed in this store are for demonstration and testing purposes only.</p>','','','','en'),(2,2,'','Fashion','','','','','en'),(3,3,'','Clothing','','','','','en'),(4,4,'','Shoes','','','','','en'),(5,5,'','Accessories','','','','','en'),(6,6,'','Beauty & Health','','','','','en'),(7,7,'','Cosmetics','','','','','en'),(8,8,'','Healthy Food & Snacks','','','','','en'),(9,9,'','Electronics','','','','','en'),(10,10,'','Smart watches','','','','','en'),(11,11,'','Mobile phones','','','','','en'),(12,12,'','Other','','','','','en');
CREATE TABLE `xlite_currency_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_E560C647BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_currencies` (`currency_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_currency_translations` VALUES (1,784,'UAE Dirham','en'),(2,971,'Afghani','en'),(3,8,'Lek','en'),(4,51,'Armenian Dram','en'),(5,532,'Netherlands Antillian Guilder','en'),(6,973,'Kwanza','en'),(7,32,'Argentine Peso','en'),(8,36,'Australian Dollar','en'),(9,533,'Aruban Guilder','en'),(10,944,'Azerbaijanian Manat','en'),(11,977,'Convertible Marks','en'),(12,52,'Barbados Dollar','en'),(13,50,'Bangladesh Taka','en'),(14,975,'Bulgarian Lev','en'),(15,48,'Bahraini dinar','en'),(16,108,'Burundi Franc','en'),(17,60,'Bermudian Dollar','en'),(18,96,'Brunei Dollar','en'),(19,68,'Boliviano','en'),(20,986,'Brazilian Real','en'),(21,44,'Bahamian dollar','en'),(22,64,'Ngultrum','en'),(23,72,'Botswana Pula','en'),(24,974,'Belarussian Rouble','en'),(25,84,'Belize Dollar','en'),(26,124,'Canadian Dollar','en'),(27,976,'Franc Congolais','en'),(28,756,'Swiss Franc','en'),(29,152,'Chilean Peso','en'),(30,156,'Chinese Renminbi Yuan','en'),(31,170,'Colombian Peso','en'),(32,188,'Cost Rican Colon','en'),(33,192,'Cuban Peso','en'),(34,132,'Cape Verde Escudo','en'),(35,203,'Czech Koruna','en'),(36,262,'Djibouti Franc','en'),(37,208,'Danish Krone','en'),(38,214,'Dominican Peso','en'),(39,12,'Algerian Dinar','en'),(40,818,'Egyptian Pound','en'),(41,232,'Nakfa','en'),(42,230,'Ethiopian Birr','en'),(43,978,'Euro','en'),(44,242,'Fiji Dollar','en'),(45,238,'Falkland Islands Pound','en'),(46,826,'Pound Sterling','en'),(47,981,'Lari','en'),(48,936,'Ghana Cedi','en'),(49,292,'Gilbraltar Pound','en'),(50,270,'Dalasi','en'),(51,324,'Guinea Franc','en'),(52,320,'Quetzal','en'),(53,328,'Guyana Dollar','en'),(54,344,'Hong Kong Dollar','en'),(55,340,'Lempira','en'),(56,191,'Croatian Kuna','en'),(57,332,'Gourde','en'),(58,348,'Hungary Forint','en'),(59,360,'Indonesian Rupiah','en'),(60,376,'New Israeli Sheqel','en'),(61,356,'Indian Rupee','en'),(62,368,'Iraqi Dinar','en'),(63,364,'Iranian Rial','en'),(64,352,'Iceland Krona','en'),(65,388,'Jamaican Dollar','en'),(66,400,'Jordanian Dinar','en'),(67,392,'Japanese Yen','en'),(68,404,'Kenyan Shilling','en'),(69,417,'Son','en'),(70,116,'Cambodian riel','en'),(71,174,'Comoro Franc','en'),(72,408,'North Korean Won','en'),(73,410,'South Korean Won','en'),(74,414,'Kuwaiti Dinar','en'),(75,136,'Cayman Islands Dollar','en'),(76,398,'Tenge','en'),(77,418,'Kip','en'),(78,422,'Lebanese Pound','en'),(79,144,'Sri Lanka Rupee','en'),(80,430,'Liberian Dollar','en'),(81,426,'Loti','en'),(82,440,'Lithuanian Litus','en'),(83,428,'Latvian Lats','en'),(84,434,'Libyan Dinar','en'),(85,504,'Moroccan Dirham','en'),(86,498,'Moldovan Leu','en'),(87,969,'Malagasy Ariary','en'),(88,807,'Denar','en'),(89,104,'Kyat','en'),(90,496,'Tugrik','en'),(91,446,'Pataca','en'),(92,478,'Ouguiya','en'),(93,480,'Mauritius Rupee','en'),(94,462,'Rufiyaa','en'),(95,454,'Malawian kwacha','en'),(96,484,'Mexican Peso','en'),(97,458,'Ringgit Malaysia','en'),(98,943,'Mozambique Metical','en'),(99,516,'Namibia Dollar','en'),(100,566,'Naira','en'),(101,558,'Cordoba Oro','en'),(102,578,'Norwegian Krone','en'),(103,524,'Nepalese Rupee','en'),(104,554,'New Zealand Dollar','en'),(105,512,'Rial Omani','en'),(106,590,'Balboa','en'),(107,604,'Nuevo Sol','en'),(108,598,'Kina','en'),(109,608,'Philippine Peso','en'),(110,586,'Pakistan Rupee','en'),(111,985,'Polish Zloty','en'),(112,600,'Guarani','en'),(113,634,'Qatari Rial','en'),(114,946,'Romanian Leu','en'),(115,941,'Serbian Dinar','en'),(116,643,'Russian Ruble','en'),(117,646,'Rwanda Franc','en'),(118,682,'Saudi Riyal','en'),(119,90,'Solomon Islands Dollar','en'),(120,690,'Seychelles Rupee','en'),(121,938,'Sudanese Pound','en'),(122,752,'Swedish Krona','en'),(123,702,'Singapore Dollar','en'),(124,654,'Saint Helena Pound','en'),(125,694,'Leone','en'),(126,706,'Somali Shilling','en'),(127,968,'Surinam Dollar','en'),(128,728,'South Sudanese Pound','en'),(129,678,'Dobra','en'),(130,222,'El Salvador Colon','en'),(131,760,'Syrian Pound','en'),(132,748,'Lilangeni','en'),(133,764,'Thailand Baht','en'),(134,972,'Somoni','en'),(135,934,'Turkmenistan New Manat','en'),(136,788,'Tunisian Dinar','en'),(137,776,'Pa\'anga','en'),(138,949,'Turkish Lira','en'),(139,780,'Trinidad and Tobago Dollar','en'),(140,901,'New Taiwan Dollar','en'),(141,834,'Tanzanian Shilling','en'),(142,980,'Hryvnia','en'),(143,800,'Uganda Shilling','en'),(144,840,'US Dollar','en'),(145,858,'Peso Uruguayo','en'),(146,860,'Uzbekistan som','en'),(147,937,'Bolivar Fuerte','en'),(148,704,'Vietnamese Dong','en'),(149,548,'Vatu','en'),(150,882,'Tala','en'),(151,950,'CFA Franc BEAC','en'),(152,951,'East Caribbean Dollar','en'),(153,952,'CFA Franc BCEAO','en'),(154,953,'CFP Franc','en'),(155,886,'Yemeni Rial','en'),(156,710,'South Africa Rand','en'),(157,894,'Zambian kwacha','en'),(158,932,'Zimbabwe Dollar','en');
CREATE TABLE `xlite_xpayments_fraud_check_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) DEFAULT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `service` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `module` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `result` int(11) NOT NULL,
  `status` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `score` int(11) NOT NULL,
  `message` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `serviceTransactionId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `errors` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `warnings` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `rules` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `data` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_BC7EC2A42FC0CB0F` (`transaction_id`),
  CONSTRAINT `FK_BC7EC2A42FC0CB0F` FOREIGN KEY (`transaction_id`) REFERENCES `xlite_payment_transactions` (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_select_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_CDF9A7AFBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attribute_values_select` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_surcharges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `type` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `include` tinyint(1) NOT NULL,
  `available` tinyint(1) NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `weight` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_3583A1698D9F6D38` (`order_id`),
  CONSTRAINT `FK_3583A1698D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_surcharges` VALUES (1,1,'shipping','SHIPPING','\\XLite\\Logic\\Order\\Modifier\\Shipping',0,1,1.5000,'Shipping cost',0),(2,1,'discount','DISCOUNT','\\XLite\\Module\\CDev\\VolumeDiscounts\\Logic\\Order\\Modifier\\Discount',0,1,-3.0000,'Discount',0),(3,2,'shipping','SHIPPING','\\XLite\\Logic\\Order\\Modifier\\Shipping',0,1,3.7200,'Shipping cost',0),(4,3,'shipping','SHIPPING','\\XLite\\Logic\\Order\\Modifier\\Shipping',0,1,0.0000,'Shipping cost',0),(5,4,'shipping','SHIPPING','\\XLite\\Logic\\Order\\Modifier\\Shipping',0,1,3.0200,'Shipping cost',0),(6,5,'shipping','SHIPPING','\\XLite\\Logic\\Order\\Modifier\\Shipping',0,1,1.5000,'Shipping cost',0);
CREATE TABLE `xlite_order_payment_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_A2C34C8E77153098` (`code`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_payment_statuses` VALUES (1,'Q',10),(2,'A',20),(3,'PP',30),(4,'P',40),(5,'D',50),(6,'C',60),(7,'R',70);
CREATE TABLE `xlite_sales_tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `tax_class_id` int(10) unsigned DEFAULT NULL,
  `membership_id` int(10) unsigned DEFAULT NULL,
  `value` decimal(14,4) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  `noTaxClass` tinyint(1) NOT NULL,
  `taxableBase` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_1ACD2E0EB2A824D8` (`tax_id`),
  KEY `IDX_1ACD2E0E9F2C3FAB` (`zone_id`),
  KEY `IDX_1ACD2E0EA94AAAE` (`tax_class_id`),
  KEY `IDX_1ACD2E0E1FB354CD` (`membership_id`),
  CONSTRAINT `FK_1ACD2E0E1FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_1ACD2E0E9F2C3FAB` FOREIGN KEY (`zone_id`) REFERENCES `xlite_zones` (`zone_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_1ACD2E0EA94AAAE` FOREIGN KEY (`tax_class_id`) REFERENCES `xlite_tax_classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_1ACD2E0EB2A824D8` FOREIGN KEY (`tax_id`) REFERENCES `xlite_sales_taxes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_quick_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `membership_id` int(10) unsigned DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `price` decimal(14,4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_C6F6D1AD4584665A` (`product_id`),
  KEY `IDX_C6F6D1AD1FB354CD` (`membership_id`),
  KEY `IDX_C6F6D1AD9F2C3FAB` (`zone_id`),
  KEY `customerArea` (`membership_id`,`product_id`),
  CONSTRAINT `FK_C6F6D1AD1FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_C6F6D1AD4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_C6F6D1AD9F2C3FAB` FOREIGN KEY (`zone_id`) REFERENCES `xlite_zones` (`zone_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_quick_data` VALUES (1,1,1,NULL,19.9900),(2,1,NULL,NULL,19.9900),(3,2,1,NULL,49.9900),(4,2,NULL,NULL,49.9900),(5,3,1,NULL,19.9900),(6,3,NULL,NULL,19.9900),(7,4,1,NULL,24.9900),(8,4,NULL,NULL,24.9900),(9,5,1,NULL,19.9900),(10,5,NULL,NULL,19.9900),(11,6,1,NULL,79.9900),(12,6,NULL,NULL,47.9900),(13,7,1,NULL,29.9900),(14,7,NULL,NULL,29.9900),(15,8,1,NULL,19.9900),(16,8,NULL,NULL,14.9900),(17,9,1,NULL,19.9900),(18,9,NULL,NULL,19.9900),(19,10,1,NULL,34.9900),(20,10,NULL,NULL,34.9900),(21,11,1,NULL,14.9900),(22,11,NULL,NULL,14.9900),(23,12,1,NULL,9.9900),(24,12,NULL,NULL,9.9900),(25,13,1,NULL,39.9900),(26,13,NULL,NULL,39.9900),(27,14,1,NULL,29.9900),(28,14,NULL,NULL,25.4900),(29,15,1,NULL,19.9900),(30,15,NULL,NULL,14.9900),(31,16,1,NULL,99.0000),(32,16,NULL,NULL,99.0000),(33,17,1,NULL,49.9900),(34,17,NULL,NULL,49.9900),(35,18,1,NULL,19.9900),(36,18,NULL,NULL,19.9900),(37,19,1,NULL,9.9900),(38,19,NULL,NULL,9.9900),(39,20,1,NULL,9.9900),(40,20,NULL,NULL,9.9900),(41,21,1,NULL,29.9900),(42,21,NULL,NULL,29.9900),(43,22,1,NULL,19.9900),(44,22,NULL,NULL,19.9900),(45,23,1,NULL,29.9900),(46,23,NULL,NULL,29.9900),(47,24,1,NULL,14.9900),(48,24,NULL,NULL,14.9900),(49,25,1,NULL,19.9900),(50,25,NULL,NULL,19.9900),(51,26,1,NULL,12.9900),(52,26,NULL,NULL,6.4900),(53,27,1,NULL,69.9900),(54,27,NULL,NULL,69.9900),(55,28,1,NULL,850.0000),(56,28,NULL,NULL,850.0000),(57,29,1,NULL,650.0000),(58,29,NULL,NULL,650.0000),(59,30,1,NULL,399.0000),(60,30,NULL,NULL,399.0000),(61,31,1,NULL,299.0000),(62,31,NULL,NULL,299.0000),(63,32,1,NULL,79.9900),(64,32,NULL,NULL,79.9900),(65,33,1,NULL,49.9900),(66,33,NULL,NULL,19.9900),(67,34,1,NULL,59.9900),(68,34,NULL,NULL,44.9900),(69,35,1,NULL,299.9900),(70,35,NULL,NULL,299.9900),(71,36,1,NULL,11.9900),(72,36,NULL,NULL,11.9900),(73,37,1,NULL,139.9900),(74,37,NULL,NULL,139.9900),(75,38,1,NULL,49.9900),(76,38,NULL,NULL,39.9900),(77,39,1,NULL,34.9900),(78,39,NULL,NULL,34.9900),(79,40,1,NULL,817.5900),(80,40,NULL,NULL,817.5900),(81,41,1,NULL,199.9900),(82,41,NULL,NULL,199.9900),(83,42,1,NULL,19.9900),(84,42,NULL,NULL,19.9900),(85,43,1,NULL,12.0000),(86,43,NULL,NULL,12.0000),(87,44,1,NULL,28.0000),(88,44,NULL,NULL,28.0000),(89,45,1,NULL,83.0000),(90,45,NULL,NULL,83.0000),(91,46,1,NULL,25.0000),(92,46,NULL,NULL,25.0000),(93,47,1,NULL,17.0000),(94,47,NULL,NULL,17.0000),(95,48,1,NULL,21.0000),(96,48,NULL,NULL,21.0000),(97,49,1,NULL,16.0000),(98,49,NULL,NULL,16.0000),(99,50,1,NULL,22.0000),(100,50,NULL,NULL,22.0000);
CREATE TABLE `xlite_tax_classes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_country_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `country` (`country`),
  KEY `id` (`id`),
  CONSTRAINT `FK_758727C3BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_countries` (`code`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_country_translations` VALUES (1,'AF','Afghanistan','en'),(2,'AX','Åland Islands','en'),(3,'AL','Albania','en'),(4,'DZ','Algeria','en'),(5,'AS','American Samoa','en'),(6,'AD','Andorra','en'),(7,'AO','Angola','en'),(8,'AI','Anguilla','en'),(9,'AQ','Antarctica','en'),(10,'AG','Antigua and Barbuda','en'),(11,'AR','Argentina','en'),(12,'AM','Armenia','en'),(13,'AW','Aruba','en'),(14,'AT','Austria','en'),(15,'AZ','Azerbaijan','en'),(16,'BS','Bahamas','en'),(17,'BH','Bahrain','en'),(18,'BD','Bangladesh','en'),(19,'BB','Barbados','en'),(20,'BY','Belarus','en'),(21,'BE','Belgium','en'),(22,'BZ','Belize','en'),(23,'BJ','Benin','en'),(24,'BM','Bermuda','en'),(25,'BT','Bhutan','en'),(26,'BO','Bolivia, Plurinational State of','en'),(27,'BQ','Bonaire, Sint Eustatius and Saba','en'),(28,'BA','Bosnia and Herzegowina','en'),(29,'BW','Botswana','en'),(30,'BV','Bouvet Island','en'),(31,'BR','Brazil','en'),(32,'IO','British Indian Ocean Territory','en'),(33,'BN','Brunei Darussalam','en'),(34,'BG','Bulgaria','en'),(35,'BF','Burkina Faso','en'),(36,'BI','Burundi','en'),(37,'KH','Cambodia','en'),(38,'CM','Cameroon','en'),(39,'CA','Canada','en'),(40,'CV','Cape Verde','en'),(41,'KY','Cayman Islands','en'),(42,'CF','Central African Republic','en'),(43,'TD','Chad','en'),(44,'CL','Chile','en'),(45,'CN','China','en'),(46,'CX','Christmas Island','en'),(47,'CC','Cocos (Keeling) Islands','en'),(48,'CO','Colombia','en'),(49,'KM','Comoros','en'),(50,'CG','Congo','en'),(51,'CD','Congo, the Democratic Republic of the','en'),(52,'CK','Cook Islands','en'),(53,'CR','Costa Rica','en'),(54,'CI','Côte d\'Ivoire','en'),(55,'HR','Croatia','en'),(56,'CU','Cuba','en'),(57,'CW','Curaçao','en'),(58,'CY','Cyprus','en'),(59,'CZ','Czech Republic','en'),(60,'DK','Denmark','en'),(61,'DJ','Djibouti','en'),(62,'DM','Dominica','en'),(63,'DO','Dominican Republic','en'),(64,'EC','Ecuador','en'),(65,'EG','Egypt','en'),(66,'SV','El Salvador','en'),(67,'GQ','Equatorial Guinea','en'),(68,'ER','Eritrea','en'),(69,'EE','Estonia','en'),(70,'ET','Ethiopia','en'),(71,'FK','Falkland Islands (Malvinas)','en'),(72,'FO','Faroe Islands','en'),(73,'FJ','Fiji','en'),(74,'FI','Finland','en'),(75,'FR','France','en'),(76,'GF','French Guiana','en'),(77,'PF','French Polynesia','en'),(78,'TF','French Southern Territories','en'),(79,'GA','Gabon','en'),(80,'GM','Gambia','en'),(81,'GE','Georgia','en'),(82,'DE','Germany','en'),(83,'GH','Ghana','en'),(84,'GI','Gibraltar','en'),(85,'GR','Greece','en'),(86,'GL','Greenland','en'),(87,'GD','Grenada','en'),(88,'GP','Guadeloupe','en'),(89,'GU','Guam','en'),(90,'GT','Guatemala','en'),(91,'GG','Guernsey','en'),(92,'GN','Guinea','en'),(93,'GW','Guinea-Bissau','en'),(94,'GY','Guyana','en'),(95,'HT','Haiti','en'),(96,'HM','Heard and McDonald Islands','en'),(97,'VA','Holy See (Vatican City State)','en'),(98,'HN','Honduras','en'),(99,'HK','Hong Kong','en'),(100,'HU','Hungary','en'),(101,'IS','Iceland','en'),(102,'IN','India','en'),(103,'ID','Indonesia','en'),(104,'IR','Iran, Islamic Republic of','en'),(105,'IQ','Iraq','en'),(106,'IE','Ireland','en'),(107,'IM','Isle of Man','en'),(108,'IL','Israel','en'),(109,'IT','Italy','en'),(110,'JM','Jamaica','en'),(111,'JP','Japan','en'),(112,'JE','Jersey','en'),(113,'JO','Jordan','en'),(114,'KZ','Kazakhstan','en'),(115,'KE','Kenya','en'),(116,'KI','Kiribati','en'),(117,'KP','Korea, Democratic People\'s Republic of','en'),(118,'KR','Korea, Republic of','en'),(119,'KW','Kuwait','en'),(120,'KG','Kyrgyzstan','en'),(121,'LA','Lao People\'s Democratic Republic','en'),(122,'LV','Latvia','en'),(123,'LB','Lebanon','en'),(124,'LS','Lesotho','en'),(125,'LR','Liberia','en'),(126,'LY','Libya','en'),(127,'LI','Liechtenstein','en'),(128,'LT','Lithuania','en'),(129,'LU','Luxembourg','en'),(130,'MO','Macao','en'),(131,'MK','North Macedonia','en'),(132,'MG','Madagascar','en'),(133,'MW','Malawi','en'),(134,'MY','Malaysia','en'),(135,'MV','Maldives','en'),(136,'ML','Mali','en'),(137,'MT','Malta','en'),(138,'MH','Marshall Islands','en'),(139,'MQ','Martinique','en'),(140,'MR','Mauritania','en'),(141,'MU','Mauritius','en'),(142,'YT','Mayotte','en'),(143,'MX','Mexico','en'),(144,'FM','Micronesia, Federated States of','en'),(145,'MD','Moldova, Republic of','en'),(146,'MC','Monaco','en'),(147,'MN','Mongolia','en'),(148,'ME','Montenegro','en'),(149,'MS','Montserrat','en'),(150,'MA','Morocco','en'),(151,'MZ','Mozambique','en'),(152,'MM','Myanmar','en'),(153,'NA','Namibia','en'),(154,'NR','Nauru','en'),(155,'NP','Nepal','en'),(156,'NL','Netherlands','en'),(157,'NC','New Caledonia','en'),(158,'NZ','New Zealand','en'),(159,'NI','Nicaragua','en'),(160,'NE','Niger','en'),(161,'NG','Nigeria','en'),(162,'NU','Niue','en'),(163,'NF','Norfolk Island','en'),(164,'MP','Northern Mariana Islands','en'),(165,'NO','Norway','en'),(166,'OM','Oman','en'),(167,'PK','Pakistan','en'),(168,'PW','Palau','en'),(169,'PS','Palestinian Territory, Occupied','en'),(170,'PA','Panama','en'),(171,'PG','Papua New Guinea','en'),(172,'PY','Paraguay','en'),(173,'PE','Peru','en'),(174,'PH','Philippines','en'),(175,'PN','Pitcairn','en'),(176,'PL','Poland','en'),(177,'PT','Portugal','en'),(178,'PR','Puerto Rico','en'),(179,'QA','Qatar','en'),(180,'RE','Réunion','en'),(181,'RO','Romania','en'),(182,'RU','Russian Federation','en'),(183,'RW','Rwanda','en'),(184,'BL','Saint Barthélemy','en'),(185,'SH','Saint Helena, Ascension and Tristan da Cunha','en'),(186,'KN','Saint Kitts and Nevis','en'),(187,'LC','Saint Lucia','en'),(188,'MF','Saint Martin','en'),(189,'PM','Saint Pierre and Miquelon','en'),(190,'VC','Saint Vincent and the Grenadines','en'),(191,'WS','Samoa','en'),(192,'SM','San Marino','en'),(193,'ST','Sao Tome and Principe','en'),(194,'SA','Saudi Arabia','en'),(195,'SN','Senegal','en'),(196,'RS','Serbia','en'),(197,'SC','Seychelles','en'),(198,'SL','Sierra Leone','en'),(199,'SG','Singapore','en'),(200,'SX','Sint Maarten','en'),(201,'SK','Slovakia','en'),(202,'SI','Slovenia','en'),(203,'SB','Solomon Islands','en'),(204,'SO','Somalia','en'),(205,'ZA','South Africa','en'),(206,'GS','South Georgia and the South Sandwich Islands','en'),(207,'SS','South Sudan','en'),(208,'ES','Spain','en'),(209,'LK','Sri Lanka','en'),(210,'SD','Sudan','en'),(211,'SR','Suriname','en'),(212,'SJ','Svalbard and Jan Mayen','en'),(213,'SZ','Swaziland','en'),(214,'SE','Sweden','en'),(215,'CH','Switzerland','en'),(216,'SY','Syrian Arab Republic','en'),(217,'TW','Taiwan, Province of China','en'),(218,'TJ','Tajikistan','en'),(219,'TZ','Tanzania, United Republic of','en'),(220,'TH','Thailand','en'),(221,'TL','Timor-Leste','en'),(222,'TG','Togo','en'),(223,'TK','Tokelau','en'),(224,'TO','Tonga','en'),(225,'TT','Trinidad and Tobago','en'),(226,'TN','Tunisia','en'),(227,'TR','Turkey','en'),(228,'TM','Turkmenistan','en'),(229,'TC','Turks and Caicos Islands','en'),(230,'TV','Tuvalu','en'),(231,'UG','Uganda','en'),(232,'UA','Ukraine','en'),(233,'AE','United Arab Emirates','en'),(234,'GB','United Kingdom','en'),(235,'US','United States','en'),(236,'UM','United States Minor Outlying Islands','en'),(237,'UY','Uruguay','en'),(238,'UZ','Uzbekistan','en'),(239,'VU','Vanuatu','en'),(240,'VE','Venezuela, Bolivarian Republic of','en'),(241,'VN','Viet Nam','en'),(242,'VG','Virgin Islands, British','en'),(243,'VI','Virgin Islands, U.S.','en'),(244,'WF','Wallis And Futuna Islands','en'),(245,'EH','Western Sahara','en'),(246,'YE','Yemen','en'),(247,'ZM','Zambia','en'),(248,'ZW','Zimbabwe','en'),(249,'AU','Australia','en');
CREATE TABLE `xlite_access_control_cells` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `returnData` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `resendMethod` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date` int(11) NOT NULL,
  `resendDate` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  `date` int(11) NOT NULL,
  `metaDescType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_item_attribute_values` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `attribute_value_checkbox_id` int(10) unsigned DEFAULT NULL,
  `attribute_value_select_id` int(10) unsigned DEFAULT NULL,
  `attribute_value_text_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `attributeId` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_46E30CEA126F525E` (`item_id`),
  KEY `IDX_46E30CEA571B5A02` (`attribute_value_checkbox_id`),
  KEY `IDX_46E30CEAA16D6CC9` (`attribute_value_select_id`),
  KEY `IDX_46E30CEA27A31B4D` (`attribute_value_text_id`),
  CONSTRAINT `FK_46E30CEA126F525E` FOREIGN KEY (`item_id`) REFERENCES `xlite_order_items` (`item_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_46E30CEA27A31B4D` FOREIGN KEY (`attribute_value_text_id`) REFERENCES `xlite_attribute_values_text` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_46E30CEA571B5A02` FOREIGN KEY (`attribute_value_checkbox_id`) REFERENCES `xlite_attribute_values_checkbox` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_46E30CEAA16D6CC9` FOREIGN KEY (`attribute_value_select_id`) REFERENCES `xlite_attribute_values_select` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_zone_coupons` (
  `coupon_id` int(10) unsigned NOT NULL,
  `zone_id` int(11) NOT NULL,
  PRIMARY KEY (`coupon_id`,`zone_id`),
  KEY `IDX_21C4218F66C5951B` (`coupon_id`),
  KEY `IDX_21C4218F9F2C3FAB` (`zone_id`),
  CONSTRAINT `FK_21C4218F66C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `xlite_coupons` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_21C4218F9F2C3FAB` FOREIGN KEY (`zone_id`) REFERENCES `xlite_zones` (`zone_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_capost_delivery_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `countryCode` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `expiry` int(10) unsigned NOT NULL,
  `maxWeight` int(11) NOT NULL,
  `minWeight` int(11) NOT NULL,
  `maxLength` decimal(11,1) NOT NULL,
  `minLength` decimal(11,1) NOT NULL,
  `maxWidth` decimal(11,1) NOT NULL,
  `minWidth` decimal(11,1) NOT NULL,
  `maxHeight` decimal(11,1) NOT NULL,
  `minHeight` decimal(11,1) NOT NULL,
  `lengthPlusGirthMax` decimal(11,1) DEFAULT NULL,
  `lengthHeightWidthSumMax` decimal(11,1) DEFAULT NULL,
  `oversizeLimit` decimal(11,1) DEFAULT NULL,
  `densityFactor` int(11) DEFAULT NULL,
  `canShipInMailingTube` tinyint(1) NOT NULL,
  `canShipUnpackaged` tinyint(1) NOT NULL,
  `allowedAsReturnService` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code_country` (`code`,`countryCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_shipping_status_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `customerName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_53DEE45BBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_order_shipping_statuses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_shipping_status_translations` VALUES (1,1,'New','New','en'),(2,2,'Processing','Processing','en'),(3,3,'Shipped','Shipped','en'),(4,4,'Delivered','Delivered','en'),(5,5,'Will Not Deliver','Will Not Deliver','en'),(6,6,'Returned','Returned','en'),(7,7,'Waiting for approve','Waiting for approve','en'),(8,8,'New/Backorder','New','en'),(9,9,'Not Finished','Not finished','en'),(10,9,'Не завершен','Не завершен','ru');
CREATE TABLE `xlite_payment_method_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `adminDescription` longtext COLLATE utf8_unicode_ci NOT NULL,
  `altAdminDescription` longtext COLLATE utf8_unicode_ci NOT NULL,
  `instruction` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_9FBF065BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_payment_methods` (`method_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_payment_method_translations` VALUES (1,1,'Purchase Order','','','','','','en'),(2,1,'Заказ-наряд','','Оформить заказ на поставку товара','','','','ru'),(3,2,'Phone Ordering','','Phone: (555) 555-5555','','','','en'),(4,2,'Заказ по телефону','','Тел. (555) 555-5555','','','','ru'),(5,3,'Fax Ordering','','Fax: (555) 555-5555','','','','en'),(6,3,'Заказ по факсу','','','','','','ru'),(7,4,'Money Order','','US Banks Only','','','','en'),(8,4,'Денежный перевод','','Оплата через отделение банка','','','','ru'),(9,5,'Check','','Check payment','','','','en'),(10,5,'Чек','','Оплата банковским чеком','','','','ru'),(11,6,'COD','','Cash On Delivery','','','','en'),(12,6,'Наложенный платеж','','Оплата товара при получении','','','','ru'),(13,7,'Amazon Pay','','','','','','en'),(14,8,'Authorize.Net SIM','','','','','','en'),(15,9,'Cash on Delivery (FedEx)','','','','','','en'),(16,10,'PayPal Payflow Link','Credit/Debit card or PayPal','','','Accept Visa, MasterCard®, American Express, Discover and PayPal payments on your site by connecting a PayPal-hosted checkout page with your own internet merchant account. Customize the page to look like the rest of your site and make sure customer transactions are secure.','','en'),(17,11,'PayPal Partner Hosted with PCI Compliance','Credit/Debit card','','','PCI compliant payments on your site with Visa, MasterCard, American Express and Discover - without PayPal-hosted pages. Maintain full control over your customers\' checkout experience by providing a credit card form that will post your customers\' payment details from your site\'s native checkout page directly to the Gateway server.','','en'),(18,12,'PayPal Payments Advanced','Credit/Debit card or PayPal','','','Accept Visa, MasterCard®, American Express, Discover and PayPal payments securely. With this all-in-one option, customers stay on your site for the entire checkout process. It simplifies PCI compliance and opens the door to more than 100 million active PayPal customers. Requires credit approval (2-3 business days).','','en'),(19,13,'PayPal Payments Standard','PayPal','','','Add a PayPal payment button to your site to accept Visa, MasterCard®, American Express, Discover and PayPal payments securely. When your customers check out, they are redirected to PayPal to pay, then return to your site after they are finished.','','en'),(20,14,'PayPal Express Checkout (legacy)','PayPal','','','Create a seamless checkout experience and increase your conversion rate by opening the door to over 100 million active PayPal customers who look for and use this fast, easy, and secure way to pay.','','en'),(21,15,'PayPal Credit','PayPal Credit','','','','','en'),(22,16,'PayPal Adaptive payments (legacy)','PayPal','','','This method provides automatic transfer of payments to vendor users (the type of users enabled by the Multi-vendor module). The method may not be activated unless the module <a href=\'admin.php?target=addons_list_marketplace&moduleName=XC\\MultiVendor\' target=\'_blank\'>Multi-vendor</a> is installed and enabled. To use this method, store administrator is required to have an Application ID for PayPal Adaptive Payments API.','','en'),(23,17,'PayPal for Marketplaces','PayPal','','','PayPal for Marketplaces is a comprehensive payments solution for marketplaces, crowdfunding platforms, and other environments where people buy and sell goods and services or raise money. The solution is ideal if you run a multi-party commerce platform and want a flexible, end-to-end solution for processing payments.','','en'),(24,17,'PayPal for Marketplaces','PayPal','','','PayPal for Marketplaces - это комплексное решение по приёму платежей для торговых площадок, платформ для сбора средств под проект (\"краудфандинг\") и других сфер, где осуществляется продажа и покупка товаров и услуг, либо сбор средств. Данное решение идеально подойдет для платформ, осуществляющих коммерческую деятельность от лица нескольких участников, и представляет собой комплексное и гибкое решение для обработки платежей на всех этапах этой деятельности.','','ru'),(25,18,'PayPal Checkout','PayPal','','','PayPal Checkout can be set up quickly and offers a convenient way for customers to complete online purchases. Configure PayPal on your product pages and cart to increase conversion.','','en'),(26,19,'QuantumGateway','','','','','','en'),(27,20,'2Checkout.com','','','','','','en'),(28,21,'Cash on Delivery (USPS)','','','','','','en'),(29,22,'Authorize.Net Accept.js','','','','','','en'),(30,23,'PayPal powered by Braintree','','','Supported countries: US, UK, France, Italy & Spain.','','','en'),(31,24,'Barclaycard ePDQ e-Commerce','','','','','','en'),(32,25,'Moneris (eSELECTplus- Hosted Pay Page)','','','','','','en'),(33,26,'iDEAL Professional (Rabobank)','','','','','','en'),(34,27,'Opayo form protocol','','','','','','en'),(35,28,'Stripe','','','','','','en'),(36,29,'Stripe (Apple / Google / Microsoft Pay)','','','','','','en'),(37,30,'Cash on Delivery (UPS)','','','','','','en'),(38,31,'Apple Pay','Apple Pay','','','Enable Apple Pay in your checkout via X-Payments Cloud','','en'),(39,32,'X-Payments Cloud','Credit or Debit card by X-Payments','','','','','en');
CREATE TABLE `xlite_address_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serviceName` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `viewGetterName` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `schemaClass` varchar(256) COLLATE utf8_unicode_ci NOT NULL,
  `additional` tinyint(1) NOT NULL,
  `required` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_2A531832912ABBB5` (`serviceName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_address_field` VALUES (1,'title','','\\XLite\\View\\FormField\\Select\\Title',0,0,0,0),(2,'firstname','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(3,'lastname','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(4,'street','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(5,'city','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(6,'country_code','country_name','\\XLite\\View\\FormField\\Select\\Country',0,1,1,0),(7,'state_id','state_name','\\XLite\\View\\FormField\\Select\\State',0,1,1,0),(8,'custom_state','state_name','\\XLite\\View\\FormField\\Input\\Text',0,0,1,0),(9,'zipcode','','\\XLite\\View\\FormField\\Input\\Text',0,1,1,0),(10,'phone','','\\XLite\\View\\FormField\\Input\\Text',0,0,1,0),(11,'type','type_name','\\XLite\\View\\FormField\\Select\\AddressType',0,0,0,0);
CREATE TABLE `xlite_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_roles` VALUES (1,1),(2,1),(3,1),(4,1),(5,1);
CREATE TABLE `xlite_order_capost_parcel_shipment_tracking_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `docType` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `trackingId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_4EB59AF6F76B6A7` (`trackingId`),
  CONSTRAINT `FK_4EB59AF6F76B6A7` FOREIGN KEY (`trackingId`) REFERENCES `xlite_order_capost_parcel_shipment_tracking` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_memberships` (
  `membership_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `position` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`membership_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_memberships` VALUES (1,10,1);
CREATE TABLE `xlite_attributes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_class_id` int(10) unsigned DEFAULT NULL,
  `attribute_group_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `googleShoppingGroup` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT 1,
  `position` int(11) NOT NULL,
  `decimals` int(11) NOT NULL,
  `type` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `displayMode` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `addToNew` char(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9665298321B06187` (`product_class_id`),
  KEY `IDX_9665298362D643B7` (`attribute_group_id`),
  KEY `IDX_966529834584665A` (`product_id`),
  CONSTRAINT `FK_9665298321B06187` FOREIGN KEY (`product_class_id`) REFERENCES `xlite_product_classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_966529834584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9665298362D643B7` FOREIGN KEY (`attribute_group_id`) REFERENCES `xlite_attribute_groups` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attributes` VALUES (1,1,NULL,NULL,NULL,1,0,0,'S','S',''),(50,NULL,NULL,NULL,NULL,1,0,0,'S','S',''),(71,2,NULL,NULL,NULL,1,0,0,'S','S',''),(72,2,NULL,NULL,NULL,1,0,0,'S','S',''),(73,2,NULL,NULL,NULL,1,0,0,'S','S',''),(74,2,NULL,NULL,NULL,0,0,0,'S','S',''),(75,2,1,NULL,NULL,1,0,0,'S','S',''),(76,2,1,NULL,NULL,1,0,0,'S','S',''),(77,2,1,NULL,NULL,1,0,0,'S','S',''),(78,2,3,NULL,NULL,0,0,0,'S','S',''),(79,2,3,NULL,NULL,0,0,0,'S','S',''),(80,2,3,NULL,NULL,0,0,0,'S','S',''),(81,2,3,NULL,NULL,0,0,0,'S','S',''),(82,2,3,NULL,NULL,0,0,0,'S','S',''),(83,2,2,NULL,NULL,1,0,0,'S','S',''),(84,2,2,NULL,NULL,1,0,0,'S','S',''),(85,2,2,NULL,NULL,0,0,0,'S','S',''),(86,2,2,NULL,NULL,1,0,0,'C','',''),(94,3,NULL,NULL,NULL,1,0,0,'S','S',''),(95,NULL,NULL,31,NULL,1,0,0,'S','S',''),(96,NULL,NULL,16,NULL,1,0,0,'S','S',''),(99,NULL,NULL,15,NULL,1,0,0,'S','S','');
CREATE TABLE `xlite_menu_quick_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(10) unsigned DEFAULT NULL,
  `submenus_count_all` int(11) NOT NULL,
  `submenus_count_enabled` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_B0327DB0CCD7E912` (`menu_id`),
  CONSTRAINT `FK_B0327DB0CCD7E912` FOREIGN KEY (`menu_id`) REFERENCES `xlite_menus` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_menu_quick_flags` VALUES (1,3,2,2),(3,1,0,0),(4,2,11,11),(5,4,0,0),(6,5,0,0),(8,6,0,0),(9,7,0,0),(10,8,0,0),(11,9,3,2),(12,10,0,0),(13,11,0,0),(14,12,0,0),(15,14,3,3),(16,13,0,0),(17,15,0,0),(18,16,0,0),(19,17,0,0),(20,18,3,3),(21,19,0,0),(22,20,0,0),(23,21,0,0),(24,22,2,2),(25,23,0,0),(26,24,0,0),(27,25,3,3),(28,26,0,0),(29,27,0,0),(30,28,0,0);
CREATE TABLE `xlite_capost_return_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` int(10) unsigned NOT NULL,
  `returnId` int(10) unsigned DEFAULT NULL,
  `orderItemId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_32022371B43D59E` (`returnId`),
  KEY `IDX_3202237BBF22A26` (`orderItemId`),
  CONSTRAINT `FK_32022371B43D59E` FOREIGN KEY (`returnId`) REFERENCES `xlite_capost_returns` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_3202237BBF22A26` FOREIGN KEY (`orderItemId`) REFERENCES `xlite_order_items` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_currencies` (
  `currency_id` int(10) unsigned NOT NULL,
  `code` char(3) COLLATE utf8_unicode_ci NOT NULL,
  `symbol` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `prefix` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `suffix` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `e` smallint(6) NOT NULL,
  `decimalDelimiter` varchar(8) COLLATE utf8_unicode_ci NOT NULL,
  `thousandDelimiter` varchar(8) COLLATE utf8_unicode_ci NOT NULL,
  `roundUp` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`currency_id`),
  UNIQUE KEY `UNIQ_903AF16077153098` (`code`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_currencies` VALUES (8,'ALL','L','L','',2,'.','','N'),(12,'DZD','د.ج','د.ج','',2,'.','','N'),(32,'ARS','$','$','',2,'.','','N'),(36,'AUD','$','$','',2,'.','','N'),(44,'BSD','$','$','',2,'.','','N'),(48,'BHD','.د.ب','.د.ب','',3,'.','','N'),(50,'BDT','৳','৳','',2,'.','','N'),(51,'AMD','դր.','դր.','',2,'.','','N'),(52,'BBD','$','$','',2,'.','','N'),(60,'BMD','$','$','',2,'.','','N'),(64,'BTN','Nu','Nu','',2,'.','','N'),(68,'BOB','$','$','',2,'.','','N'),(72,'BWP','P','P','',2,'.','','N'),(84,'BZD','$','$','',2,'.','','N'),(90,'SBD','$','$','',2,'.','','N'),(96,'BND','$','$','',2,'.','','N'),(104,'MMK','K','K','',2,'.','','N'),(108,'BIF','₣','₣','',0,'.','','N'),(116,'KHR','$','$','',2,'.','','N'),(124,'CAD','$','$','',2,'.','','N'),(132,'CVE','$','$','',2,'.','','N'),(136,'KYD','$','$','',2,'.','','N'),(144,'LKR','Re','Re','',2,'.','','N'),(152,'CLP','$','$','',0,'.','','N'),(156,'CNY','¥','¥','',2,'.','','N'),(170,'COP','$','$','',2,'.','','N'),(174,'KMF','₣','₣','',0,'.','','N'),(188,'CRC','₡','₡','',2,'.','','N'),(191,'HRK','Kn','Kn','',2,'.','','N'),(192,'CUP','$','$','',2,'.','','N'),(203,'CZK','Kč','Kč','',2,'.','','N'),(208,'DKK','kr','kr','',2,'.','','N'),(214,'DOP','$','$','',2,'.','','N'),(222,'SVC','₡','₡','',2,'.','','N'),(230,'ETB','Br','Br','',2,'.','','N'),(232,'ERN','Nfk','Nfk','',2,'.','','N'),(238,'FKP','£','£','',2,'.','','N'),(242,'FJD','$','$','',2,'.','','N'),(262,'DJF','₣','₣','',0,'.','','N'),(270,'GMD','D','D','',2,'.','','N'),(292,'GIP','£','£','',2,'.','','N'),(320,'GTQ','Q','Q','',2,'.','','N'),(324,'GNF','₣','₣','',0,'.','','N'),(328,'GYD','$','$','',2,'.','','N'),(332,'HTG','G','G','',2,'.','','N'),(340,'HNL','L','L','',2,'.','','N'),(344,'HKD','$','$','',2,'.','','N'),(348,'HUF','ƒ','ƒ','',2,'.','','N'),(352,'ISK','kr','kr','',0,'.','','N'),(356,'INR','₹','₹','',2,'.','','N'),(360,'IDR','Rp','Rp','',0,'.','','N'),(364,'IRR','﷼','﷼','',2,'.','','N'),(368,'IQD','ع.د','ع.د','',3,'.','','N'),(376,'ILS','₪','₪','',2,'.','','N'),(388,'JMD','$','$','',2,'.','','N'),(392,'JPY','¥','¥','',0,'.','','N'),(398,'KZT','₸','₸','',2,'.','','N'),(400,'JOD','د.ا','د.ا','',3,'.','','N'),(404,'KES','KSh','KSh','',2,'.','','N'),(408,'KPW','₩','₩','',2,'.','','N'),(410,'KRW','₩','₩','',0,'.','','N'),(414,'KWD','د.ك','د.ك','',3,'.','','N'),(417,'KGS','C','C','',2,'.','','N'),(418,'LAK','₭','₭','',2,'.','','N'),(422,'LBP','.ل.ل','.ل.ل','',2,'.','','N'),(426,'LSL','L','L','',2,'.','','N'),(428,'LVL','Ls','Ls','',2,'.','','N'),(430,'LRD','$','$','',2,'.','','N'),(434,'LYD','ل.د','ل.د','',3,'.','','N'),(440,'LTL','Lt','Lt','',2,'.','','N'),(446,'MOP','$','$','',2,'.','','N'),(454,'MWK','K','K','',2,'.','','N'),(458,'MYR','RM','RM','',2,'.','','N'),(462,'MVR','Rf','Rf','',2,'.','','N'),(478,'MRO','UM','UM','',0,'.','','N'),(480,'MUR','Re','Re','',2,'.','','N'),(484,'MXN','$','$','',2,'.','','N'),(496,'MNT','₮','₮','',2,'.','','N'),(498,'MDL','L','L','',2,'.','','N'),(504,'MAD','د. م.','د. م.','',2,'.','','N'),(512,'OMR','ر.ع.','ر.ع.','',3,'.','','N'),(516,'NAD','N$','N$','',2,'.','','N'),(524,'NPR','Re','Re','',2,'.','','N'),(532,'ANG','ƒ','ƒ','',2,'.','','N'),(533,'AWG','ƒ','ƒ','',2,'.','','N'),(548,'VUV','Vt','Vt','',0,'.','','N'),(554,'NZD','$','$','',2,'.','','N'),(558,'NIO','$','$','',2,'.','','N'),(566,'NGN','₦','₦','',2,'.','','N'),(578,'NOK','kr','kr','',2,'.','','N'),(586,'PKR','Re','Re','',2,'.','','N'),(590,'PAB','B/.','B/.','',2,'.','','N'),(598,'PGK','K','K','',2,'.','','N'),(600,'PYG','₲','₲','',0,'.','','N'),(604,'PEN','S/.','S/.','',2,'.','','N'),(608,'PHP','₱','₱','',2,'.','','N'),(634,'QAR','ر.ق','ر.ق','',2,'.','','N'),(643,'RUB','₽','','₽',2,'.','','N'),(646,'RWF','₣','₣','',0,'.','','N'),(654,'SHP','£','£','',2,'.','','N'),(678,'STD','Db','Db','',2,'.','','N'),(682,'SAR','ر.س','ر.س','',2,'.','','N'),(690,'SCR','Re','Re','',2,'.','','N'),(694,'SLL','Le','Le','',2,'.','','N'),(702,'SGD','$','$','',2,'.','','N'),(704,'VND','₫','₫','',0,'.','','N'),(706,'SOS','S','S','',2,'.','','N'),(710,'ZAR','R','R','',2,'.','','N'),(728,'SSP','SSP','SSP','',2,'.','','N'),(748,'SZL','L','L','',2,'.','','N'),(752,'SEK','kr','kr','',2,'.','','N'),(756,'CHF','₣','₣','',2,'.','','N'),(760,'SYP','S£','S£','',2,'.','','N'),(764,'THB','฿','฿','',2,'.','','N'),(776,'TOP','$','$','',2,'.','','N'),(780,'TTD','$','$','',2,'.','','N'),(784,'AED','د.إ','د.إ','',2,'.','','N'),(788,'TND','د.ت','د.ت','',3,'.','','N'),(800,'UGX','USh','USh','',2,'.','','N'),(807,'MKD','ден.','ден.','',2,'.','','N'),(818,'EGP','LE','LE','',2,'.','','N'),(826,'GBP','£','£','',2,'.','','N'),(834,'TZS','TSh','TSh','',2,'.','','N'),(840,'USD','$','$','',2,'.','','N'),(858,'UYU','$','$','',2,'.','','N'),(860,'UZS','сўм','сўм','',2,'.','','N'),(882,'WST','$','$','',2,'.','','N'),(886,'YER','﷼','﷼','',2,'.','','N'),(894,'ZMK','K','K','',2,'.','','N'),(901,'TWD','NT$','NT$','',2,'.','','N'),(932,'ZWL','Z$','Z$','',2,'.','','N'),(934,'TMT','m','m','',2,'.','','N'),(936,'GHS','₵','₵','',2,'.','','N'),(937,'VEF','Bs','Bs','',2,'.','','N'),(938,'SDG','£','£','',2,'.','','N'),(941,'RSD','дин.','дин.','',2,'.','','N'),(943,'MZN','MT','MT','',2,'.','','N'),(944,'AZN','m','m','',2,'.','','N'),(946,'RON','L','L','',2,'.','','N'),(949,'TRY','₤','₤','',2,'.','','N'),(950,'XAF','₣','₣','',0,'.','','N'),(951,'XCD','$','$','',2,'.','','N'),(952,'XOF','₣','₣','',0,'.','','N'),(953,'XPF','₣','₣','',0,'.','','N'),(968,'SRD','$','$','',2,'.','','N'),(969,'MGA','Ar.','Ar.','',0,'.','','N'),(971,'AFN','؋','؋','',2,'.','','N'),(972,'TJS','с.','с.','',2,'.','','N'),(973,'AOA','Kz','Kz','',2,'.','','N'),(974,'BYR','Br','','Br',0,'.','','N'),(975,'BGN','лв','лв','',2,'.','','N'),(976,'CDF','₣','₣','',2,'.','','N'),(977,'BAM','KM','KM','',2,'.','','N'),(978,'EUR','€','€','',2,'.','','N'),(980,'UAH','₴','₴','',2,'.','','N'),(981,'GEL','ლ.','ლ.','',2,'.','','N'),(985,'PLN','zł','zł','',2,'.','','N'),(986,'BRL','$','$','',2,'.','','N');
CREATE TABLE `xlite_mailchimp_list_segments` (
  `id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `list_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `created_date` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `static` tinyint(1) NOT NULL,
  `useOrdersLastMonth` tinyint(1) NOT NULL,
  `ordersLastMonth` int(11) NOT NULL,
  `useOrderAmount` tinyint(1) NOT NULL,
  `orderAmount` decimal(14,4) NOT NULL,
  `useMemberships` tinyint(1) NOT NULL,
  `useProducts` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_93CC76423DAE168B` (`list_id`),
  CONSTRAINT `FK_93CC76423DAE168B` FOREIGN KEY (`list_id`) REFERENCES `xlite_mailchimp_lists` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_capost_office` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `officeId` char(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `location` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `distance` decimal(12,2) NOT NULL,
  `bilingualDesignation` tinyint(1) NOT NULL,
  `city` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `latitude` decimal(15,5) NOT NULL,
  `longitude` decimal(15,5) NOT NULL,
  `postalCode` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `province` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `officeAddress` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `workingHours` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `orderId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CE3DE61FFA237437` (`orderId`),
  CONSTRAINT `FK_CE3DE61FFA237437` FOREIGN KEY (`orderId`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_product_attachment_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `title` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_C05C8533BF396750` FOREIGN KEY (`id`) REFERENCES `xlite_product_attachments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_access_control_entities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(10) unsigned DEFAULT NULL,
  `cell_id` int(10) unsigned DEFAULT NULL,
  `uid` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_A98BAB59C54C8C93` (`type_id`),
  KEY `IDX_A98BAB59CB39D93A` (`cell_id`),
  CONSTRAINT `FK_A98BAB59C54C8C93` FOREIGN KEY (`type_id`) REFERENCES `xlite_access_control_entity_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A98BAB59CB39D93A` FOREIGN KEY (`cell_id`) REFERENCES `xlite_access_control_cells` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_tmp_vars` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_tmp_vars` VALUES (1,'cache_build_timestamp','i:1603972216;'),(2,'cloud_search_reg_scheduled','1');
CREATE TABLE `xlite_order_shipping_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_F46FC21177153098` (`code`),
  KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_shipping_statuses` VALUES (1,'N',10),(2,'P',20),(3,'S',30),(4,'D',40),(5,'WND',50),(6,'R',60),(7,'WFA',70),(8,'NBA',80),(9,'NF',100);
CREATE TABLE `xlite_order_item_surcharges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `type` char(8) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `include` tinyint(1) NOT NULL,
  `available` tinyint(1) NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `weight` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_F9394518126F525E` (`item_id`),
  CONSTRAINT `FK_F9394518126F525E` FOREIGN KEY (`item_id`) REFERENCES `xlite_order_items` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_capost_parcel_shipments_manifests` (
  `manifest_id` int(11) NOT NULL,
  `shipment_id` int(11) NOT NULL,
  PRIMARY KEY (`manifest_id`,`shipment_id`),
  KEY `IDX_8D3D4D8FE697B2FB` (`manifest_id`),
  KEY `IDX_8D3D4D8F7BE036FC` (`shipment_id`),
  CONSTRAINT `FK_8D3D4D8F7BE036FC` FOREIGN KEY (`shipment_id`) REFERENCES `xlite_order_capost_parcel_shipment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_8D3D4D8FE697B2FB` FOREIGN KEY (`manifest_id`) REFERENCES `xlite_order_capost_parcel_manifests` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `ogMeta` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `useCustomOG` tinyint(1) NOT NULL,
  `csLastUpdate` int(11) NOT NULL,
  `demo` tinyint(1) NOT NULL,
  `useClasses` char(1) COLLATE utf8_unicode_ci NOT NULL,
  `lpos` int(11) NOT NULL,
  `rpos` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `show_title` tinyint(1) NOT NULL,
  `depth` int(11) NOT NULL,
  `pos` int(11) NOT NULL,
  `root_category_look` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `metaDescType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `xcPendingExport` tinyint(1) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `IDX_9D0DF19B727ACA70` (`parent_id`),
  KEY `lpos` (`lpos`),
  KEY `rpos` (`rpos`),
  KEY `enabled` (`enabled`),
  KEY `csLastUpdate` (`csLastUpdate`),
  CONSTRAINT `FK_9D0DF19B727ACA70` FOREIGN KEY (`parent_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_categories` VALUES (1,NULL,'',0,0,0,'A',1,24,1,0,-1,0,'icons','A',0),(2,1,'',0,0,1,'A',2,9,1,1,0,10,NULL,'A',0),(3,2,'',0,0,1,'A',3,4,1,1,1,10,NULL,'A',0),(4,2,'',0,0,1,'A',5,6,1,1,1,20,NULL,'A',0),(5,2,'',0,0,1,'A',7,8,1,1,1,30,NULL,'A',0),(6,1,'',0,0,1,'A',10,15,1,1,0,20,NULL,'A',0),(7,6,'',0,0,1,'A',13,14,1,1,1,10,NULL,'A',0),(8,6,'',0,0,1,'A',11,12,1,1,1,10,NULL,'A',0),(9,1,'',0,0,1,'A',16,23,1,1,0,30,NULL,'A',0),(10,9,'',0,0,1,'A',17,18,1,1,1,10,NULL,'A',0),(11,9,'',0,0,1,'A',19,20,1,1,1,20,NULL,'A',0),(12,9,'',0,0,1,'A',21,22,1,1,1,30,NULL,'A',0);
CREATE TABLE `xlite_orders` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `not_finished_order_id` int(11) DEFAULT NULL,
  `profile_id` int(11) DEFAULT NULL,
  `orig_profile_id` int(11) DEFAULT NULL,
  `payment_status_id` int(10) unsigned DEFAULT NULL,
  `shipping_status_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `mailchimpStoreId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `demo` tinyint(1) NOT NULL,
  `xpaymentsFraudStatus` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `xpaymentsFraudType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `xpaymentsFraudCheckTransactionId` int(11) NOT NULL,
  `shipping_id` int(11) NOT NULL,
  `shipping_method_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_method_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tracking` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `date` int(11) NOT NULL,
  `lastRenewDate` int(11) NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `adminNotes` longtext COLLATE utf8_unicode_ci NOT NULL,
  `orderNumber` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recent` tinyint(1) NOT NULL,
  `stockStatus` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `xcPendingExport` tinyint(1) NOT NULL,
  `total` decimal(14,4) NOT NULL,
  `subtotal` decimal(14,4) NOT NULL,
  `is_order` int(11) NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `IDX_9A9BE335791AE370` (`not_finished_order_id`),
  KEY `IDX_9A9BE335CCFA12B8` (`profile_id`),
  KEY `IDX_9A9BE335DBFEF46C` (`orig_profile_id`),
  KEY `IDX_9A9BE33538248176` (`currency_id`),
  KEY `date` (`date`),
  KEY `total` (`total`),
  KEY `subtotal` (`subtotal`),
  KEY `tracking` (`tracking`),
  KEY `payment_status` (`payment_status_id`),
  KEY `shipping_status` (`shipping_status_id`),
  KEY `shipping_id` (`shipping_id`),
  KEY `lastRenewDate` (`lastRenewDate`),
  KEY `orderNumber` (`orderNumber`),
  KEY `is_order` (`is_order`),
  KEY `xcPendingExport` (`xcPendingExport`),
  CONSTRAINT `FK_9A9BE33528DE2F95` FOREIGN KEY (`payment_status_id`) REFERENCES `xlite_order_payment_statuses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9A9BE3352D02518A` FOREIGN KEY (`shipping_status_id`) REFERENCES `xlite_order_shipping_statuses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9A9BE33538248176` FOREIGN KEY (`currency_id`) REFERENCES `xlite_currencies` (`currency_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9A9BE335791AE370` FOREIGN KEY (`not_finished_order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_9A9BE335CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_9A9BE335DBFEF46C` FOREIGN KEY (`orig_profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_orders` VALUES (1,NULL,2,1,4,4,840,'',1,'','',0,91,'Courier','','',1551771900,1603972208,'','','1',0,'',0,18.4900,19.9900,1),(2,NULL,3,1,4,4,840,'',1,'','',0,91,'Courier','','',1553772240,1603972208,'','','2',1,'',0,88.6700,84.9500,1),(3,NULL,4,1,4,4,840,'',1,'','',0,91,'Courier','','',1564729080,1603972208,'','','3',1,'',0,158.9400,158.9400,1),(4,NULL,5,1,5,5,840,'',1,'','',0,91,'Courier','Simplify Commerce Hosted Payments','',1575162780,1603972208,'','','4',1,'',0,38.0100,34.9900,1),(5,NULL,6,1,4,4,840,'',1,'','',0,91,'Courier','','',1575163080,1603972208,'','','5',0,'',0,352.8100,351.3100,1);
CREATE TABLE `xlite_order_backorder_competitors` (
  `id` int(11) NOT NULL,
  `competitor_id` int(11) NOT NULL,
  PRIMARY KEY (`id`,`competitor_id`),
  KEY `IDX_C73B739BBF396750` (`id`),
  KEY `IDX_C73B739B78A5D405` (`competitor_id`),
  CONSTRAINT `FK_C73B739B78A5D405` FOREIGN KEY (`competitor_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_C73B739BBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_tracking_number` (
  `tracking_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `creationDate` int(11) NOT NULL,
  PRIMARY KEY (`tracking_id`),
  KEY `IDX_77A238F48D9F6D38` (`order_id`),
  CONSTRAINT `FK_77A238F48D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_mailchimp_segment_subscriptions` (
  `segment_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `profile_id` int(11) NOT NULL,
  PRIMARY KEY (`segment_id`,`profile_id`),
  KEY `IDX_CE45B298DB296AAD` (`segment_id`),
  KEY `IDX_CE45B298CCFA12B8` (`profile_id`),
  CONSTRAINT `FK_CE45B298CCFA12B8` FOREIGN KEY (`profile_id`) REFERENCES `xlite_profiles` (`profile_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_CE45B298DB296AAD` FOREIGN KEY (`segment_id`) REFERENCES `xlite_mailchimp_list_segments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_entity_type_versions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entityType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `version` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_4A1BBA741F08814A` (`entityType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_entity_type_versions` VALUES (1,'XLite\\Model\\Config','a9e4173d-f409-4f48-8b61-b2c9331e75f9'),(2,'XLite\\Model\\ConfigTranslation','c1bae04a-759c-441f-916b-1280314b6743'),(3,'XLite\\Model\\Category','cb273714-4afa-4196-9066-8e0368042ead'),(4,'XLite\\Model\\CategoryTranslation','1f1c5cd0-aaa7-43e1-95db-1bd7b48be2b9'),(5,'XLite\\Model\\Category\\QuickFlags','bce6e5e7-9ae0-47c4-9973-987f3966d11a'),(6,'XLite\\Model\\Currency','fbb0e084-f6c6-4f8a-a62c-ecfb6e6f22be'),(7,'XLite\\Model\\CurrencyTranslation','8a3ca2ef-a6e9-4830-aaa0-d5eb6bd1e85f'),(8,'XLite\\Model\\Membership','64d15024-29ca-4076-b0bb-397a9fc1c67e'),(9,'XLite\\Model\\MembershipTranslation','73454698-881e-4b13-8008-639fdb735704'),(10,'XLite\\Model\\Language','1926a57f-8f8d-4f5a-ba4e-19db69a58fb0'),(11,'XLite\\Model\\LanguageTranslation','47cc53dd-96d0-45c7-be0a-7ac3a1a6ec80'),(12,'XLite\\Model\\Payment\\Method','32fded55-d3e1-4718-97ee-c26eec9b2bf9'),(13,'XLite\\Model\\Payment\\MethodTranslation','a58765f3-b6b9-4996-bf87-e3de0610a15e'),(14,'XLite\\Model\\Region','283c8a4f-1847-4b3e-b0ed-9899ebad8a17'),(15,'XLite\\Model\\Country','b695fec8-788f-46bf-91de-2b30c8d71ca6'),(16,'XLite\\Model\\CountryTranslation','07ca7c21-4311-42a5-b155-6857c10298a8'),(17,'XLite\\Model\\State','b7688174-a1f4-4a0d-b71b-436202f64828'),(19,'XLite\\Model\\Order\\Modifier','bdd243fa-3e60-46ed-abf4-c43c6f221097'),(20,'XLite\\Model\\Task','8e61981d-3b11-4b0d-989c-61c10c16affa'),(21,'XLite\\Model\\Role','62b013cc-0f7d-445c-99bb-950a3fc92cab'),(22,'XLite\\Model\\RoleTranslation','95368bb6-17f3-49e4-91ef-8f17cd38e60c'),(23,'XLite\\Model\\Role\\Permission','77de2584-7fdb-4451-a8b3-6bbb4ca3f7ab'),(24,'XLite\\Model\\Role\\PermissionTranslation','c06d0d94-08e9-46cc-8142-a5b3bfa54bb4'),(27,'XLite\\Model\\AddressField','9c28cfa0-d3cb-41d4-9fd5-bdae940d4dc2'),(28,'XLite\\Model\\AddressFieldTranslation','a16d26b7-b472-4404-97f2-c3beca109ff3'),(29,'XLite\\Model\\MoneyModificator','db7d3596-d8ea-4195-b430-893c993b9445'),(30,'XLite\\Model\\Order\\Status\\Payment','cba4da2d-21b7-449a-a46b-40f2cebf38ce'),(31,'XLite\\Model\\Order\\Status\\PaymentTranslation','f38910a7-78d5-4964-ba51-661bbd37e410'),(32,'XLite\\Model\\Order\\Status\\Shipping','6ecf6edb-ca1c-49e6-aa31-a96bf274f6ab'),(33,'XLite\\Model\\Order\\Status\\ShippingTranslation','f34be983-4e27-417e-9f47-19076ebe2ee5'),(34,'XLite\\Model\\Order\\Status\\Property','fe025f0e-f1a6-4a2f-b4b4-ce2e6fb3dfac'),(35,'XLite\\Model\\Notification','1d2b242b-65f9-417b-be6b-48d96ed5d0a2'),(36,'XLite\\Model\\NotificationTranslation','5c17399f-ac11-4cf3-ab85-7757ac9449f1'),(37,'XLite\\Model\\ImageSettings','aae80502-bb95-42df-aabd-62c6ff08988e'),(38,'XLite\\Model\\SearchFilter','36dd4e12-5fd8-4af9-ab43-6d68c64bea8a'),(39,'XLite\\Model\\SearchFilterTranslation','3b27bb41-8a89-4079-8edd-65cb2a0bae39'),(40,'XLite\\Model\\AccessControlEntityType','0e5dcf21-8dba-4d75-93c3-c2ea68ff332d'),(41,'XLite\\Model\\AccessControlZoneType','1ac897b9-c4b8-434a-9468-c8e2496f53e0'),(42,'XLite\\Model\\Product\\GlobalTab','18797f29-491a-4579-8c63-003bcdc7a7eb'),(43,'XLite\\Model\\Product\\GlobalTabProvider','1c1cbb7e-effa-47d0-be27-714d186cf65f'),(46,'XLite\\Model\\LanguageLabel','bebe6366-f99d-418f-ad88-02e263d03423'),(47,'XLite\\Model\\LanguageLabelTranslation','9e61d19a-24cd-432b-8d69-0bbaf9c3724a'),(50,'XLite\\Model\\Payment\\MethodSetting','10698151-be32-4ef1-800e-1bb4a87a8213'),(55,'XLite\\Model\\Shipping\\Method','8b221799-e22f-4c37-9986-2d04272baea5'),(56,'XLite\\Model\\Shipping\\MethodTranslation','9b1e5167-aea4-4890-a7eb-e7e149623e12'),(164,'XLite\\Module\\CDev\\SimpleCMS\\Model\\Page','7146df3a-e8a5-4d79-a50e-5ae99be7e708'),(165,'XLite\\Model\\CleanURL','b7c64c5d-9e79-47c4-bf40-26203f0e5995'),(166,'XLite\\Module\\CDev\\SimpleCMS\\Model\\PageTranslation','6a6774b4-ff14-4cd3-8107-ccdce9817618'),(167,'XLite\\Module\\CDev\\SimpleCMS\\Model\\Menu','83f0d7e4-7ae5-44cf-861b-303b46bf9050'),(169,'XLite\\Module\\CDev\\SimpleCMS\\Model\\MenuTranslation','b3d59d3e-bd68-4f7a-b24b-c525e2082e11'),(171,'XLite\\Module\\CDev\\SimpleCMS\\Model\\Menu\\QuickFlags','46cc4b1b-49ac-4ebf-9a49-fc7ff740d647'),(395,'XLite\\Model\\Product','a02ba755-c6c1-47c8-8e8d-211a4c9bb107'),(396,'XLite\\Model\\QuickData','2035447c-e187-4c30-9b9d-61271df25326'),(398,'XLite\\Model\\Image\\Product\\Image','380d5ccd-cb53-42b1-9b14-59b6ab12cccf'),(399,'XLite\\Model\\ProductTranslation','f0499dbc-675d-4bf3-a351-93605fbaa4fd'),(650,'XLite\\Model\\Image\\Category\\Image','b6a91ae7-f0e3-4a39-b8b3-ab407addb0f6'),(651,'XLite\\Model\\Image\\Category\\Banner','3e5f536d-a45b-46fc-b34c-d8d4a715f1da'),(658,'XLite\\Model\\CategoryProducts','79d62d83-f399-4638-a452-89623a428d71'),(776,'XLite\\Model\\BannerRotationSlide','77cad8e6-2613-474a-9684-ea516b81febd'),(777,'XLite\\Model\\Image\\BannerRotationImage','1df97855-e595-46d3-a1cf-2e86cd9da496'),(778,'XLite\\Module\\XC\\CustomProductTabs\\Model\\Product\\CustomGlobalTab','8fe9818f-1d8a-41b8-bf8c-bc7cf8607482'),(781,'XLite\\Module\\XC\\CustomProductTabs\\Model\\Product\\CustomGlobalTabTranslation','53808f0c-d6dc-4bc0-87b8-eb06e1972b52'),(791,'XLite\\Module\\CDev\\FeaturedProducts\\Model\\FeaturedProduct','68191413-6d20-4121-bc84-7a24ba19ac0c'),(875,'XLite\\Model\\Order','17dd85e4-0607-4434-91c7-673f232253f8'),(876,'XLite\\Model\\Zone','c9437bab-94bd-4370-aa15-78264cc52d60'),(877,'XLite\\Model\\ZoneElement','962c702d-a541-4850-a5fb-82345eaef7f2'),(880,'XLite\\Model\\Shipping\\Markup','ce72b568-db35-4837-b5d1-9065f0a32067'),(881,'XLite\\Model\\Profile','a8fb7fe0-dff6-4bd4-9b3c-122cc47554fd'),(882,'XLite\\Model\\Address','a8f9480b-8ff9-4cd9-9f73-724b77350fbe'),(883,'XLite\\Model\\AddressFieldValue','1b5c28bd-97e4-41ea-ab3e-48e8ce533b54'),(887,'XLite\\Model\\Payment\\Transaction','c97086bf-bc96-45c9-8600-820273a9cb98'),(888,'XLite\\Model\\OrderItem','96ead802-3289-4e2d-83b7-b61b61252409'),(890,'XLite\\Model\\Order\\Surcharge','7f989d81-84a9-4a51-86c3-4358a9553406'),(891,'XLite\\Model\\OrderHistoryEvents','9f0a6313-24c4-48fa-9454-c7a8e2349915'),(914,'XLite\\Model\\Payment\\TransactionData','aba2764a-6705-4abc-87d5-1a20e4475a3b'),(952,'XLite\\Model\\ViewList','a1ec967a-133a-42c1-bab7-8dd57072715f');
CREATE TABLE `xlite_category_banners` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned DEFAULT NULL,
  `alt` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `hash` char(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `needProcess` tinyint(1) NOT NULL,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_69B8F0D412469DE2` (`category_id`),
  CONSTRAINT `FK_69B8F0D412469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_category_banners` VALUES (1,2,'',2996,520,NULL,1,'fashion_6.jpeg','','image/jpeg','r',331715,1560863809),(2,6,'',2996,520,NULL,1,'beauty_banner5.jpg','','image/jpeg','r',340745,1559911154),(3,9,'',2996,520,NULL,1,'9_electronic.jpeg','','image/jpeg','r',334750,1560943954);
CREATE TABLE `xlite_access_control_entity_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_access_control_entity_types` VALUES (1,'\\XLite\\Model\\Order');
CREATE TABLE `xlite_order_capost_parcel_shipment_link_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `fileName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mime` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `storageType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `linkId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_82EA5F8AAEC98E42` (`linkId`),
  CONSTRAINT `FK_82EA5F8AAEC98E42` FOREIGN KEY (`linkId`) REFERENCES `xlite_order_capost_parcel_shipment_links` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_translations` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `unit` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`label_id`),
  KEY `ci` (`code`,`id`),
  KEY `id` (`id`),
  CONSTRAINT `FK_8BBAD04BBF396750` FOREIGN KEY (`id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_attribute_translations` VALUES (1,1,'Size','','en'),(50,50,'Manufacturer','','en'),(51,1,'Размер','','ru'),(100,50,'Производитель','','ru'),(141,71,'Capacity, GB','','en'),(142,72,'Chip','','en'),(143,73,'Color','','en'),(144,74,'Sim card','','en'),(145,75,'Display type','','en'),(146,76,'Dimension, inches','','en'),(147,77,'Resolution','','en'),(148,78,'Battery type','','en'),(149,79,'Talk time','','en'),(150,80,'Standby time','','en'),(151,81,'Video playback','','en'),(152,82,'Audio playback','','en'),(153,83,'GSM model','','en'),(154,84,'Wi-Fi','','en'),(155,85,'Bluetooth','','en'),(156,86,'GPS','','en'),(159,73,'Цвет','','ru'),(160,71,'Объем памяти, Гб','','ru'),(161,72,'Процессор','','ru'),(162,74,'Тип Sim-карты','','ru'),(163,75,'Тип дисплея','','ru'),(164,76,'Диагональ в дюймах','','ru'),(165,77,'Разрешение','','ru'),(166,78,'Тип аккумулятора','','ru'),(167,79,'Работа в режиме разговора','','ru'),(168,80,'Работа в режиме ожидания','','ru'),(169,81,'Работа в режиме проигрывания видео','','ru'),(170,82,'Работа в режиме проигрывания аудио','','ru'),(171,83,'Тип GSM','','ru'),(172,84,'Тип Wi-Fi','','ru'),(173,85,'Bluetooth','','ru'),(174,86,'GPS','','ru'),(181,94,'Size','','en'),(182,95,'Color','','en'),(183,96,'Size','','en'),(186,99,'Size','','en'),(187,94,'Размер','','ru');
CREATE TABLE `xlite_membership_coupons` (
  `coupon_id` int(10) unsigned NOT NULL,
  `membership_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`coupon_id`,`membership_id`),
  KEY `IDX_560DE2166C5951B` (`coupon_id`),
  KEY `IDX_560DE211FB354CD` (`membership_id`),
  CONSTRAINT `FK_560DE211FB354CD` FOREIGN KEY (`membership_id`) REFERENCES `xlite_memberships` (`membership_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_560DE2166C5951B` FOREIGN KEY (`coupon_id`) REFERENCES `xlite_coupons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_item_private_attachments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `attachment_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `downloadKey` char(128) COLLATE utf8_unicode_ci NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  `attempt` int(10) unsigned NOT NULL,
  `attemptLimit` int(10) unsigned NOT NULL,
  `blocked` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_BC5B98F1126F525E` (`item_id`),
  KEY `IDX_BC5B98F1464E68B` (`attachment_id`),
  CONSTRAINT `FK_BC5B98F1126F525E` FOREIGN KEY (`item_id`) REFERENCES `xlite_order_items` (`item_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_BC5B98F1464E68B` FOREIGN KEY (`attachment_id`) REFERENCES `xlite_product_attachments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_menus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `link` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lpos` int(11) NOT NULL,
  `rpos` int(11) NOT NULL,
  `depth` int(11) NOT NULL,
  `type` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `visibleFor` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_AC666883727ACA70` (`parent_id`),
  KEY `enabled` (`enabled`,`type`),
  KEY `position` (`position`),
  CONSTRAINT `FK_AC666883727ACA70` FOREIGN KEY (`parent_id`) REFERENCES `xlite_menus` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_menus` VALUES (1,2,'{home}',2,3,0,'P',100,1,'AL'),(2,NULL,'link',1,56,-1,'P',0,1,'AL'),(3,2,'{my account}',4,9,0,'P',600,1,'L'),(4,3,'?target=order_list',5,6,1,'P',100,1,'L'),(5,3,'?target=address_book',7,8,1,'P',200,1,'L'),(6,2,'shipping',10,11,0,'P',200,1,'AL'),(7,2,'{new arrivals}',12,13,0,'P',400,1,'AL'),(8,2,'{coming soon}',14,15,0,'P',500,1,'AL'),(9,2,NULL,16,23,0,'P',150,1,'AL'),(10,9,'{sale}',17,18,1,'P',100,1,'AL'),(11,9,'{bestsellers}',19,20,1,'P',200,1,'AL'),(12,9,'?target=special_offers',21,22,1,'P',300,0,'AL'),(13,2,'{contact us}',24,25,0,'P',700,1,'AL'),(14,2,NULL,26,33,0,'F',200,1,'AL'),(15,14,'{sale}',27,28,1,'F',100,1,'AL'),(16,14,'{coming soon}',29,30,1,'F',200,1,'AL'),(17,14,'{new arrivals}',31,32,1,'F',300,1,'AL'),(18,2,NULL,34,41,0,'F',300,1,'AL'),(19,18,'shipping',35,36,1,'F',100,1,'AL'),(20,18,'?target=map',37,38,1,'F',200,1,'AL'),(21,18,'terms-and-conditions',39,40,1,'F',300,1,'AL'),(22,2,NULL,42,47,0,'F',400,1,'AL'),(23,22,'shipping',43,44,1,'F',100,1,'AL'),(24,22,'{contact us}',45,46,1,'F',200,1,'AL'),(25,2,NULL,48,55,0,'F',500,1,'L'),(26,25,'?target=address_book',49,50,1,'F',100,1,'L'),(27,25,'?target=order_list',51,52,1,'F',200,1,'L'),(28,25,'?target=profile',53,54,1,'F',300,1,'L');
CREATE TABLE `xlite_clean_urls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sale_discount_id` int(10) unsigned DEFAULT NULL,
  `page_id` int(10) unsigned DEFAULT NULL,
  `news_message_id` int(10) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `cleanURL` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_F25425453D30B072` (`sale_discount_id`),
  KEY `IDX_F2542545C4663E4` (`page_id`),
  KEY `IDX_F2542545BF05C450` (`news_message_id`),
  KEY `IDX_F25425454584665A` (`product_id`),
  KEY `IDX_F254254512469DE2` (`category_id`),
  KEY `cleanURL` (`cleanURL`),
  CONSTRAINT `FK_F254254512469DE2` FOREIGN KEY (`category_id`) REFERENCES `xlite_categories` (`category_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_F25425453D30B072` FOREIGN KEY (`sale_discount_id`) REFERENCES `xlite_sale_discounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_F25425454584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_F2542545BF05C450` FOREIGN KEY (`news_message_id`) REFERENCES `xlite_news` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_F2542545C4663E4` FOREIGN KEY (`page_id`) REFERENCES `xlite_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_clean_urls` VALUES (1,NULL,1,NULL,NULL,NULL,'terms-and-conditions'),(2,NULL,2,NULL,NULL,NULL,'shipping'),(3,NULL,NULL,NULL,1,NULL,'timberland-45th-anniversary'),(4,NULL,NULL,NULL,2,NULL,'high-top-trainers-in-red-black-and-white'),(5,NULL,NULL,NULL,3,NULL,'beige-sneakers'),(6,NULL,NULL,NULL,4,NULL,'platform-brogue-trim-leather-oxfords-in-white'),(7,NULL,NULL,NULL,5,NULL,'grey-knitted-trainers'),(8,NULL,NULL,NULL,6,NULL,'lace-up-boots-in-light-brown'),(9,NULL,NULL,NULL,7,NULL,'boyfriend-t-shirt-with-chest-logo'),(10,NULL,NULL,NULL,8,NULL,'pink-sneakers-with-white-soles'),(11,NULL,NULL,NULL,9,NULL,'white-lace-up-mesh-trainers'),(12,NULL,NULL,NULL,10,NULL,'caged-cutout-sandals-in-gold'),(13,NULL,NULL,NULL,11,NULL,'green-flat-slingback-sandals'),(14,NULL,NULL,NULL,12,NULL,'waist-tie-dress-in-blue-and-white-stripe'),(15,NULL,NULL,NULL,13,NULL,'ultimate-t-shirt-with-crew-neck-in-red'),(16,NULL,NULL,NULL,14,NULL,'multicolored-dress-with-balloon-sleeves'),(17,NULL,NULL,NULL,15,NULL,'tall-pleated-midi-skirt-in-check'),(18,NULL,NULL,NULL,16,NULL,'sleeved-mini-dress-in-color-block'),(19,NULL,NULL,NULL,17,NULL,'tall-slim-fit-t-shirt-in-white'),(20,NULL,NULL,NULL,18,NULL,'skinny-western-denim-jacket-in-light-blue-wash'),(21,NULL,NULL,NULL,19,NULL,'oversized-hoodie-in-grey'),(22,NULL,NULL,NULL,20,NULL,'hooded-anorak-jacket-in-black'),(23,NULL,NULL,NULL,21,NULL,'leather-mini-tote-bag-with-rose-and-girl-print-in-red'),(24,NULL,NULL,NULL,22,NULL,'mesh-strap-watch-in-gold'),(25,NULL,NULL,NULL,23,NULL,'square-glasses-in-black-with-clear-lens'),(26,NULL,NULL,NULL,24,NULL,'chain-drop-earrings-in-gold-tone'),(27,NULL,NULL,NULL,25,NULL,'rooster-mug-in-white'),(28,NULL,NULL,NULL,26,NULL,'festival-braslet-pack-in-gold-tone'),(29,NULL,NULL,NULL,27,NULL,'samsung-galaxy-s6-edge-plus-4g-lte-with-32gb-memory-cell-phone'),(30,NULL,NULL,NULL,28,NULL,'apple-iphone-8-plus-64gb'),(31,NULL,NULL,NULL,29,NULL,'apple-iphone-x'),(32,NULL,NULL,NULL,30,NULL,'apple-watch-series-3-gps-38mm'),(33,NULL,NULL,NULL,31,NULL,'google-home-mini'),(34,NULL,NULL,NULL,32,NULL,'fitness-tracker-smart-watch'),(35,NULL,NULL,NULL,33,NULL,'bluetooth-smartwatch-with-touch-screen-and-fitness-tracker'),(36,NULL,NULL,NULL,34,NULL,'aster-i39-headphones-with-microphone'),(37,NULL,NULL,NULL,35,NULL,'apple-airpods'),(38,NULL,NULL,NULL,36,NULL,'cocooil-body-oil'),(39,NULL,NULL,NULL,37,NULL,'maui-moisture'),(40,NULL,NULL,NULL,38,NULL,'barth-body-oil'),(41,NULL,NULL,NULL,39,NULL,'facial-spray'),(42,NULL,NULL,NULL,40,NULL,'red-dior'),(43,NULL,NULL,NULL,41,NULL,'pink-unicorn-makeup-brushes'),(44,NULL,NULL,NULL,42,NULL,'perfect-snacks'),(45,NULL,NULL,NULL,43,NULL,'blue-and-green-matcha'),(46,NULL,NULL,NULL,44,NULL,'chia-seed'),(47,NULL,NULL,NULL,45,NULL,'probiotic-and-omega-3-6-9-supplement'),(48,NULL,NULL,NULL,46,NULL,'tea-infused-sparkling-water'),(49,NULL,NULL,NULL,47,NULL,'cinnamon-sticks'),(50,NULL,NULL,NULL,48,NULL,'peanut-butter'),(51,NULL,NULL,NULL,49,NULL,'sweet-hazelnut-and-chocolate-natural-flavouring'),(52,NULL,NULL,NULL,50,NULL,'dose-juice'),(53,NULL,NULL,NULL,NULL,2,'fashion'),(54,NULL,NULL,NULL,NULL,3,'clothing'),(55,NULL,NULL,NULL,NULL,4,'shoes'),(56,NULL,NULL,NULL,NULL,5,'accessories'),(57,NULL,NULL,NULL,NULL,6,'beauty-and-health'),(58,NULL,NULL,NULL,NULL,7,'cosmetics'),(59,NULL,NULL,NULL,NULL,8,'healthy-food-and-snacks'),(60,NULL,NULL,NULL,NULL,9,'electronics'),(61,NULL,NULL,NULL,NULL,10,'smart-watches'),(62,NULL,NULL,NULL,NULL,11,'mobile-phones'),(63,NULL,NULL,NULL,NULL,12,'other');
CREATE TABLE `xlite_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `useCustomOG` tinyint(1) NOT NULL,
  `ogMeta` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `showSocialButtons` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `metaDescType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_pages` VALUES (1,0,'',0,1,'A',0),(2,0,'',0,1,'A',0);
CREATE TABLE `xlite_order_review_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `keyValue` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `addedDate` int(11) NOT NULL,
  `sentDate` int(11) NOT NULL,
  `firstClickDate` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_3869BA7B8D9F6D38` (`order_id`),
  KEY `keyValue` (`keyValue`),
  KEY `addedDate` (`addedDate`),
  KEY `sentDate` (`sentDate`),
  CONSTRAINT `FK_3869BA7B8D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_attribute_values_text` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned DEFAULT NULL,
  `attribute_id` int(10) unsigned DEFAULT NULL,
  `editable` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`),
  CONSTRAINT `FK_560D03DA4584665A` FOREIGN KEY (`product_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_560D03DAB6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `xlite_attributes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `section` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_permissions` VALUES (1,'root access','All'),(2,'manage catalog','Catalog'),(3,'manage front page','Content'),(4,'manage users','Users'),(5,'manage admins','Users'),(6,'manage orders','Sales'),(7,'manage import','Import and Export'),(8,'manage export','Import and Export'),(9,'manage banners','Content'),(10,'unfiltered html','Content'),(11,'manage coupons','Coupons'),(12,'manage sale discounts','Sale'),(13,'manage custom pages','Content'),(14,'manage menus','Content'),(15,'manage volume discounts','Volume discounts'),(16,'manage news','Content'),(17,'manage reviews','Catalog'),(18,'manage conversations','Conversations');
CREATE TABLE `xlite_order_capost_parcel_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` int(11) NOT NULL,
  `parcelId` int(11) DEFAULT NULL,
  `orderItemId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_18699C805A9ACC87` (`parcelId`),
  KEY `IDX_18699C80BBF22A26` (`orderItemId`),
  CONSTRAINT `FK_18699C805A9ACC87` FOREIGN KEY (`parcelId`) REFERENCES `xlite_order_capost_parcels` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_18699C80BBF22A26` FOREIGN KEY (`orderItemId`) REFERENCES `xlite_order_items` (`item_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_order_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(10) unsigned DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `categoryAdded` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `xpaymentsEmulated` tinyint(1) NOT NULL,
  `xpaymentsUniqueId` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sku` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `price` decimal(14,4) NOT NULL COMMENT '(DC2Type:money)',
  `itemNetPrice` decimal(14,4) NOT NULL,
  `discountedSubtotal` decimal(14,4) NOT NULL,
  `amount` int(11) NOT NULL,
  `backorderedAmount` int(11) NOT NULL,
  `total` decimal(14,4) NOT NULL,
  `subtotal` decimal(14,4) NOT NULL,
  `subscriptionId` int(10) unsigned DEFAULT NULL COMMENT 'Unique id',
  `object_type` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `IDX_4693C0A1CA77D3A9` (`subscriptionId`),
  KEY `IDX_4693C0A18D9F6D38` (`order_id`),
  KEY `ooo` (`order_id`,`object_type`,`object_id`),
  KEY `object_id` (`object_id`),
  KEY `price` (`price`),
  KEY `amount` (`amount`),
  CONSTRAINT `FK_4693C0A1232D562B` FOREIGN KEY (`object_id`) REFERENCES `xlite_products` (`product_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_4693C0A18D9F6D38` FOREIGN KEY (`order_id`) REFERENCES `xlite_orders` (`order_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_4693C0A1CA77D3A9` FOREIGN KEY (`subscriptionId`) REFERENCES `xlite_xpayments_subscriptions` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `xlite_order_items` VALUES (1,42,1,'',0,'','Perfect Snacks','10000000118',19.9900,19.9900,16.9900,1,0,19.9900,19.9900,NULL,'product'),(2,3,2,'',0,'','Beige Sneakers','10000000069',19.9900,19.9900,39.9800,2,0,39.9800,39.9800,NULL,'product'),(3,8,2,'',0,'','Pink Sneakers with White Soles','10000000081',19.9900,14.9900,44.9700,3,0,44.9700,44.9700,NULL,'product'),(4,12,3,'',0,'','Waist Tie Dress in Blue and White Stripe','10000000085',9.9900,9.9900,59.9400,6,0,59.9400,59.9400,NULL,'product'),(5,16,3,'',0,'','Sleeved Mini Dress in Color Block','10000000089',99.0000,99.0000,99.9900,1,0,99.0000,99.0000,NULL,'product'),(6,10,4,'',0,'','Caged Cutout Sandals in Gold','10000000083',34.9900,34.9900,34.9900,1,0,34.9900,34.9900,NULL,'product'),(7,14,5,'',0,'','Multicolored Dress with Balloon Sleeves [Options & Attributes]','10000000087',29.9900,25.4900,305.8800,12,0,305.8800,305.8800,NULL,'product'),(8,26,5,'',0,'','Festival Braslet Pack in Gold Tone','10000000101',12.9900,6.4900,45.4300,7,0,45.4300,45.4300,NULL,'product');
CREATE TABLE `xlite_order_capost_parcel_shipment_tracking_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `trackingId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_F6B816A26F76B6A7` (`trackingId`),
  CONSTRAINT `FK_F6B816A26F76B6A7` FOREIGN KEY (`trackingId`) REFERENCES `xlite_order_capost_parcel_shipment_tracking` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE `xlite_sale_discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `useCustomOG` tinyint(1) NOT NULL,
  `ogMeta` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL,
  `value` decimal(14,4) NOT NULL,
  `dateRangeBegin` int(10) unsigned NOT NULL,
  `dateRangeEnd` int(10) unsigned NOT NULL,
  `showInSeparateSection` tinyint(1) NOT NULL,
  `metaDescType` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `specificProducts` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
COMMIT;