<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Module\XPay\XPaymentsCloud\Model\Payment\Processor;

use \XLite\Module\XPay\XPaymentsCloud\Main as ModuleMain;

class ApplePay extends \XLite\Module\XPay\XPaymentsCloud\Model\Payment\Processor\XPaymentsCloud
{
    /**
     * Get payment method admin zone icon URL
     *
     * @param \XLite\Model\Payment\Method $method Payment method
     *
     * @return string
     */
    public function getAdminIconURL(\XLite\Model\Payment\Method $method)
    {
        return \XLite\Core\Layout::getInstance()
                ->getResourceWebPath('modules/XPay/XPaymentsCloud/apple_pay.png');
    }

    /**
     * Payment is configured when required keys set and HTTPS enabled
     *
     * @param \XLite\Model\Payment\Method $method
     *
     * @return bool
     */
    public function isConfigured(\XLite\Model\Payment\Method $method)
    {
        $xpMethod = ModuleMain::getPaymentMethod();
        return $xpMethod
            && $xpMethod->getProcessor()->isConfigured($xpMethod);
    }

    /**
     * Prevent enabling Apple Pay if main method is disabled
     *
     * @param \XLite\Model\Payment\Method $method Payment method object
     *
     * @return boolean
     */
    public function canEnable(\XLite\Model\Payment\Method $method)
    {
        $xpMethod = ModuleMain::getPaymentMethod();
        return parent::canEnable($method)
            && $xpMethod
            && $xpMethod->canEnable();
    }

    /**
     * Get payment method row checkout template
     *
     * @param \XLite\Model\Payment\Method $method Payment method
     *
     * @return string
     */
    public function getCheckoutTemplate(\XLite\Model\Payment\Method $method)
    {
        return 'modules/XPay/XPaymentsCloud/checkout/apple_pay_method.twig';
    }

    /**
     * If Apple Pay has been enabled but for some reason X-Payments Cloud is disabled,
     * then we need to enable that payment method as well
     *
     * NOTE: We also must disable inherited actions!
     *
     * @return void
     */
    public function enableMethod(\XLite\Model\Payment\Method $method)
    {
        if (
            $method->getEnabled()
            && ModuleMain::getPaymentMethod()
            && !ModuleMain::getPaymentMethod()->getEnabled()
        ) {
            ModuleMain::getPaymentMethod()->setEnabled(true);
        }
    }

}
