<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XLite\Module\XC\BulkEditing\View\Button;

use XLite\Core\PreloadedLabels\ProviderInterface;

/**
 * ItemsExport button
 */
abstract class ABulkEdit extends \XLite\View\Button\Dropdown\ADropdown implements ProviderInterface
{
    /**
     * getJSFiles
     *
     * @return array
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();
        $list[] = 'modules/XC/BulkEditing/button/bulk_edit.js';

        return $list;
    }

    /**
     * getDefaultLabel
     *
     * @return string
     */
    protected function getDefaultLabel()
    {
        return static::t('Bulk edit all');
    }

    /**
     * Defines CSS class for widget to use in templates
     *
     * @return string
     */
    protected function getClass()
    {
        return parent::getClass() . ' bulk-edit';
    }

    /**
     * Get commented data
     *
     * @return array
     */
    public function getPreloadedLanguageLabels()
    {
        return [
            'Bulk edit all'      => static::t('Bulk edit all'),
            'Bulk edit selected' => static::t('Bulk edit selected'),
        ];
    }
}
