<?php
/***********************************************************************************
 * X2Engine Open Source Edition is a customer relationship management program developed by
 * X2 Engine, Inc. Copyright (C) 2011-2019 X2 Engine Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY X2ENGINE, X2ENGINE DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact X2Engine, Inc. P.O. Box 610121, Redwood City,
 * California 94061, USA. or at email address contact@x2engine.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * X2 Engine" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by X2 Engine".
 **********************************************************************************/




class MigrateLayoutsTest extends X2DbTestCase {

    // skipped since migration script tests aren't relevant after corresponding release
    protected static $skipAllTests = true;

    public function insertPlaFixture() {
        // create pre-5.0.2 profile table and insert saved profiles
        Yii::app()->db->createCommand("
delete from x2_settings where true;
DROP TABLE IF EXISTS x2_profile;
/*&*/
CREATE TABLE `x2_profile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fullName` varchar(255) NOT NULL,
  `username` varchar(50) NOT NULL,
  `officePhone` varchar(40) DEFAULT NULL,
  `extension` varchar(40) DEFAULT NULL,
  `cellPhone` varchar(40) DEFAULT NULL,
  `emailAddress` varchar(255) NOT NULL,
  `notes` text,
  `status` tinyint(4) NOT NULL,
  `tagLine` varchar(255) DEFAULT NULL,
  `lastUpdated` bigint(20) DEFAULT NULL,
  `updatedBy` varchar(255) DEFAULT NULL,
  `avatar` text,
  `allowPost` tinyint(4) DEFAULT '1',
  `disablePhoneLinks` tinyint(4) DEFAULT '0',
  `disableNotifPopup` tinyint(4) DEFAULT '0',
  `disableAutomaticRecordTagging` tinyint(4) DEFAULT '0',
  `disableTimeInTitle` tinyint(4) DEFAULT '0',
  `language` varchar(40) DEFAULT 'en',
  `timeZone` varchar(100) DEFAULT 'UTC',
  `resultsPerPage` int(11) DEFAULT '20',
  `widgets` varchar(255) DEFAULT NULL,
  `widgetOrder` text,
  `widgetSettings` text,
  `defaultEmailTemplates` text,
  `activityFeedOrder` tinyint(4) DEFAULT '0',
  `theme` text,
  `showActions` varchar(20) DEFAULT NULL,
  `profileWidgetLayout` text,
  `recordViewWidgetLayout` text,
  `dataWidgetLayout` text,
  `miscLayoutSettings` text,
  `notificationSound` varchar(100) DEFAULT 'X2_Notification.mp3',
  `loginSound` varchar(100) DEFAULT '',
  `startPage` varchar(30) DEFAULT NULL,
  `showSocialMedia` tinyint(4) NOT NULL DEFAULT '0',
  `showDetailView` tinyint(4) NOT NULL DEFAULT '1',
  `gridviewSettings` text,
  `generalGridViewSettings` text,
  `formSettings` text,
  `emailUseSignature` varchar(5) DEFAULT 'user',
  `emailSignature` longtext,
  `enableFullWidth` tinyint(4) DEFAULT '1',
  `syncGoogleCalendarId` text,
  `syncGoogleCalendarAccessToken` text,
  `syncGoogleCalendarRefreshToken` text,
  `googleId` varchar(250) DEFAULT NULL,
  `userCalendarsVisible` tinyint(4) DEFAULT '1',
  `groupCalendarsVisible` tinyint(4) DEFAULT '1',
  `tagsShowAllUsers` tinyint(4) DEFAULT NULL,
  `hideCasesWithStatus` text,
  `hiddenTags` text,
  `address` text,
  `defaultFeedFilters` text,
  `layout` text,
  `minimizeFeed` tinyint(4) DEFAULT '0',
  `fullscreen` tinyint(4) DEFAULT '0',
  `fullFeedControls` tinyint(4) DEFAULT '0',
  `feedFilters` text,
  `hideBugsWithStatus` text,
  `actionFilters` text,
  `oldActions` tinyint(4) DEFAULT '0',
  `mediaWidgetDrive` tinyint(4) DEFAULT '0',
  `historyShowAll` tinyint(4) DEFAULT '0',
  `historyShowRels` tinyint(4) DEFAULT '0',
  `googleRefreshToken` varchar(255) DEFAULT NULL,
  `leadRoutingAvailability` tinyint(4) DEFAULT '1',
  `emailInboxes` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`,`emailAddress`),
  KEY `username_2` (`username`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
INSERT INTO `x2_profile` VALUES (1,'Chloe Greigo','admin','831-555-5555',NULL,'831-222-5333','admin@foo.com','',1,'Pretty in Pink, Wicked in Uniform',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',100,'1:1:1:1:1:1:1:1:1:1:1:1:1:1','TimeZone:SmallCalendar:HelpfulTips:ActionMenu:MessageBox:ChatBox:TagCloud:OnlineUsers:QuickContact:NoteBox:MediaBox:DocViewer:TopSites:TopSites','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]},\"TimeZone\":{\"clockType\":\"analog\"},\"SmallCalendar\":{\"justMe\":\"false\"}}',NULL,1,'{\"background\":null,\"content\":null,\"text\":null,\"link\":null,\"highlight1\":null,\"highlight2\":null,\"themeName\":null,\"smart_text\":\"\",\"smart_text2\":\"\",\"darker_background\":\"\",\"dark_background\":\"\",\"brighter_background\":\"\",\"bright_background\":\"\",\"lighter_background\":\"\",\"light_background\":\"\",\"opaque_background\":\"\",\"darker_content\":\"\",\"dark_content\":\"\",\"brighter_content\":\"\",\"bright_content\":\"\",\"lighter_content\":\"\",\"light_content\":\"\",\"opaque_content\":\"\",\"darker_text\":\"\",\"dark_text\":\"\",\"brighter_text\":\"\",\"bright_text\":\"\",\"lighter_text\":\"\",\"light_text\":\"\",\"opaque_text\":\"\",\"darker_link\":\"\",\"dark_link\":\"\",\"brighter_link\":\"\",\"bright_link\":\"\",\"lighter_link\":\"\",\"light_link\":\"\",\"opaque_link\":\"\",\"darker_highlight1\":\"\",\"dark_highlight1\":\"\",\"brighter_highlight1\":\"\",\"bright_highlight1\":\"\",\"lighter_highlight1\":\"\",\"light_highlight1\":\"\",\"opaque_highlight1\":\"\",\"darker_highlight2\":\"\",\"dark_highlight2\":\"\",\"brighter_highlight2\":\"\",\"bright_highlight2\":\"\",\"lighter_highlight2\":\"\",\"light_highlight2\":\"\",\"opaque_highlight2\":\"\",\"border\":\"\",\"generated\":true,\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":\"1\",\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":\"1\",\"containerNumber\":\"1\",\"chartSubtype\":\"line\",\"uid\":\"\",\"softDeleted\":false,\"chartSettings\":{\"startDate\":\"1418198400000\",\"endDate\":\"1418803200000\",\"dateRange\":null,\"binSize\":null,\"firstMetric\":null,\"showRelationships\":null,\"chartSetting\":null,\"usersFilter\":null,\"socialSubtypesFilter\":null,\"visibilityFilter\":null}},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":0,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"IframeWidget_5493379e73c4d\":{\"hidden\":false,\"minimized\":false,\"label\":\"Website Viewer\",\"uid\":\"\",\"containerNumber\":\"1\",\"softDeleted\":false,\"url\":\"\",\"height\":\"200\"},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":0,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\",\"uid\":\"\",\"softDeleted\":false},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\",\"uid\":\"\",\"softDeleted\":false,\"chartSettings\":{\"startDate\":null,\"endDate\":null,\"binSize\":null,\"firstMetric\":null,\"chartSetting\":null,\"eventsFilter\":null,\"socialSubtypesFilter\":null,\"visibilityFilter\":null,\"dateRange\":null}},\"ActionsGridViewProfileWidget\":{\"label\":\"Actions Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"IframeWidget\":{\"label\":\"Website Viewer\",\"uid\":\"\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false,\"url\":\"\",\"height\":\"200\"},\"X2LeadsGridViewProfileWidget\":{\"label\":\"Leads Summary\",\"uid\":\"\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false,\"resultsPerPage\":10,\"dbPersistentGridSettings\":false}}','{\"InlineRelationshipsWidget\":{\"label\":\"Relationships\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false,\"pageSize\":10,\"mode\":\"simple\",\"displayMode\":\"grid\",\"height\":\"200\"},\"ActionHistoryChartWidget\":{\"label\":\"Action History\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false,\"chartSubtype\":\"line\",\"chartSettings\":{\"startDate\":null,\"endDate\":null,\"dateRange\":null,\"binSize\":null,\"firstMetric\":null,\"showRelationships\":null}},\"CampaignChartWidget\":{\"label\":\"Campaign\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false,\"chartSubtype\":\"line\",\"chartSettings\":{\"binSize\":null,\"firstMetric\":null,\"showRelationships\":null}},\"ImageGalleryWidget\":{\"label\":\"Image Gallery\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false},\"InlineTagsWidget\":{\"label\":\"Tags\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false},\"TwitterFeedWidget\":{\"label\":\"Twitter Feed\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false},\"WorkflowStageDetailsWidget\":{\"label\":\"Process\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false}}','{\"BarWidget\":{\"label\":\"Bar Chart\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false,\"chartId\":null,\"displayType\":\"bar\",\"legend\":null},\"DataWidget\":{\"label\":\"Data Widget\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false,\"chartId\":null,\"displayType\":null,\"legend\":null},\"TimeSeriesWidget\":{\"label\":\"Activity Chart\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false,\"chartId\":null,\"displayType\":\"line\",\"legend\":null,\"subchart\":false,\"timeBucket\":\"day\",\"filter\":\"month\",\"filterType\":\"trailing\",\"filterFrom\":null,\"filterTo\":null},\"TimeSeriesWidget_549339bcc9306\":{\"hidden\":false,\"minimized\":false,\"label\":\"Lead Volume\",\"chartId\":\"1\",\"uid\":\"\",\"containerNumber\":2,\"softDeleted\":false,\"displayType\":\"pie\",\"legend\":[\"Portland trade show\",\"null\"],\"subchart\":false,\"timeBucket\":\"day\",\"filter\":\"week\",\"filterType\":\"trailing\",\"filterFrom\":null,\"filterTo\":null},\"TimeSeriesWidget_549339becde2d\":{\"hidden\":false,\"minimized\":false,\"label\":\"Test\",\"chartId\":\"1\",\"uid\":\"\",\"containerNumber\":\"1\",\"softDeleted\":false,\"displayType\":\"bar\",\"legend\":[\"Portland trade show\",\"null\"],\"subchart\":false,\"timeBucket\":\"day\",\"filter\":\"week\",\"filterType\":\"trailing\",\"filterFrom\":null,\"filterTo\":null}}','{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false,\"perStageWorkflowView\":false}','X2_Notification.mp3','','',0,1,'{\"campaigns\":{\"gvCheckbox\":30,\"name\":156,\"listId\":106,\"subject\":271,\"launchDate\":76,\"active\":44,\"lastUpdated\":78},\"contacts\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107,\"lastActivity\":78,\"gvControls\":73},\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":35,\"name\":119,\"email\":154,\"leadSource\":89,\"leadstatus\":89,\"phone\":89},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":158,\"type\":108,\"annualRevenue\":108,\"lastUpdated\":111,\"assignedTo\":99},\"inlinerelationshipsgrid\":{\"name\":180,\"myModelName\":180,\"assignedTo\":180,\"createDate\":180,\"deletion\":60},\"docs\":{\"gvCheckbox\":49,\"name\":253,\"createdBy\":76,\"createDate\":111,\"lastUpdated\":115},\"quotes\":{\"gvCheckbox\":30,\"name\":244,\"probability\":67,\"expectedCloseDate\":117,\"assignedTo\":120,\"lastActivity\":90,\"gvControls\":72},\"savedreports\":{\"gvCheckbox\":28,\"name\":123,\"type\":199,\"createdBy\":81,\"createDate\":89,\"gvControls\":71}}',NULL,'{\"contacts\":[1,1,1,1,0,1],\"opportunity\":[1,1,1,1,1,1],\"undefined\":[1,1,1,1,0,1,1]}','user','Chloe Greigo \r\nCampbell\'s Cloud Computing\r\nSales Manager\r\n831.555.5555',1,NULL,NULL,NULL,'CholeG',1,1,1,NULL,'[\"#3366CC\",\"#39\",\"#servers\",\"#hardware\"]',NULL,NULL,'{\"left\":{\"EmailInboxMenu\":{\"title\":\"Inbox Menu\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false}},\"center\":{\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false}},\"right\":{\"SmallCalendar\":{\"title\":\"Calendar\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false},\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Clock\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1,''),(2,'API User','api',NULL,NULL,NULL,'x2crm@x2contact.com',NULL,0,NULL,NULL,NULL,NULL,1,0,0,0,0,'en','UTC',20,'0:1:1:1:1:1:0:0:0:0:0:0:0:0','OnlineUsers:TimeZone:SmallCalendar:GoogleMaps:ChatBox:TagCloud:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'X2_Notification.mp3','',NULL,0,1,NULL,NULL,NULL,'user',NULL,1,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1,''),(-1,'','__x2_guest_profile__',NULL,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,1,0,0,0,0,'en','UTC',20,'0:1:1:1:1:1:0:0:0:0:0:0:0:0','OnlineUsers:TimeZone:SmallCalendar:GoogleMaps:ChatBox:TagCloud:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'X2_Notification.mp3','',NULL,0,1,NULL,NULL,NULL,'user',NULL,1,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1,''),(3,'Chris Hames','chames','831-555-5555',NULL,'831.555.5578','chris@hames.com',NULL,1,'That Guy',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99},\"docs\":{\"gvCheckbox\":80,\"name\":253,\"createdBy\":76,\"createDate\":111,\"lastUpdated\":115},\"campaigns\":{\"gvCheckbox\":30,\"name\":156,\"listId\":106,\"subject\":271,\"launchDate\":76,\"active\":44,\"lastUpdated\":78}}',NULL,'{\"contacts\":[1,1,1,1,0,1]}','user','Chris Hames\nCampbell\'s Cloud Computing\nSales Representative\n831.555.5555',1,NULL,NULL,NULL,NULL,1,1,NULL,'[\"Work around provided, waiting for fix\",\"WIP\",\"Waiting for response\",\"Reopened\",\"Program Manager investigation\",\"New\",\"Needs more info\",\"Escalated\",\"Closed - No Response\"]',NULL,NULL,NULL,'{\"left\":{\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false}},\"center\":{\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false},\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false}},\"right\":{\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false},\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1,''),(4,'Nick Cordova','ncordova','831-555-5555',NULL,'831.555.5515','nick.cordova@example.com','',1,'One for the Money',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99}}',NULL,NULL,'user','Nick Cordova\r\nCampbell\'s Cloud Computing\r\nSales Representative\r\n831.555.5555',1,NULL,NULL,NULL,'',1,1,1,NULL,NULL,NULL,NULL,'{\"left\":{\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false}},\"center\":{\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false},\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false}},\"right\":{\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false},\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1,''),(5,'Amelie Pelletier','apelletier','831-555-5555','','831.555.5535','amiep@example.com','',1,'Marketing Maverick',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"pie\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99},\"inlinerelationshipsgrid\":{\"name\":180,\"myModelName\":180,\"assignedTo\":180,\"createDate\":180,\"deletion\":60}}',NULL,NULL,'user','Amelie Pelletier Campbell&#39;s Cloud Computing Marketing Representative 831.555.5555',1,NULL,NULL,NULL,'AmieP',1,1,NULL,NULL,NULL,'',NULL,'{\"left\":{\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false}},\"center\":{\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false}},\"right\":{\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1,''),(6,'Kevin Xu','kxu','831-555-5555',NULL,'555.555.8311','Kevin.xu@example.com','',1,'If I Can\'t Do It, Nobody Can',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99}}',NULL,NULL,'user','Kevin Xu\r\nCampbell\'s Cloud Computing\r\nSales Representative\r\n831.555.5555',1,NULL,NULL,NULL,'Kevvyxu',1,1,NULL,NULL,NULL,NULL,NULL,'{\"left\":{\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false}},\"center\":{\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false}},\"right\":{\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1,''),(7,'Rani Patel','rpatel','831-555-5555',NULL,'831.555.5525','rani.patel@example.com','',1,'How Can I Help You?',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99},\"inlinerelationshipsgrid\":{\"name\":180,\"myModelName\":180,\"assignedTo\":180,\"createDate\":180,\"deletion\":60}}',NULL,NULL,'user','Rani Patel\r\nCampbell\'s Cloud Computing\r\nCustomer Service Representative\r\n831.555.5555',1,NULL,NULL,NULL,'RaniMan',1,1,NULL,NULL,NULL,NULL,NULL,'{\"left\":{\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false}},\"center\":{\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false},\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false}},\"right\":{\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false},\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1,''),(8,'Campbell O\'Conner','coconner','831.555.5555',NULL,'831.555.5575','campbell@oconner.com','',1,'Boss Man',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99}}',NULL,NULL,'user','Campbell O\'Conner\r\nCEO & Founder\r\nCampbell\'s Cloud Computing\r\n831.555.5555',1,NULL,NULL,NULL,'OconnerCamp',1,1,NULL,NULL,NULL,NULL,NULL,'{\"left\":{\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false}},\"center\":{\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false}},\"right\":{\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1,''),(9,'Brian To','bto','831.555.5555',NULL,'831.555.5545','brian@to.com','',1,'There is no better time than the present',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99}}',NULL,NULL,'user','Brian To\r\nCampbell\'s Cloud Computing\r\nVP Marketing\r\n831.555.5555',1,NULL,NULL,NULL,'BTo',1,1,NULL,NULL,NULL,NULL,NULL,'{\"left\":{\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false}},\"center\":{\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false}},\"right\":{\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1,''),(10,'Alyssa Carisella','acarisella','555-555-5555',NULL,'555-555-5564','acarisella@example.com','',1,'Get \'er Done',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99}}',NULL,NULL,'user','Arianna Carisella\r\nVP Sales\r\nCampbell\'s Computing\r\n555-555-5555',1,NULL,NULL,NULL,'',1,1,NULL,NULL,NULL,NULL,NULL,'{\"left\":{\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false}},\"center\":{\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false}},\"right\":{\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1,'');
        ")->execute();
    }

    public function insertOpensourceFixture() {
        // create pre-5.0.2 profile table and insert saved profiles
        Yii::app()->db->createCommand("
delete from x2_settings where true;
DROP TABLE IF EXISTS `x2_profile`;
CREATE TABLE `x2_profile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fullName` varchar(255) NOT NULL,
  `username` varchar(50) NOT NULL,
  `officePhone` varchar(40) DEFAULT NULL,
  `extension` varchar(40) DEFAULT NULL,
  `cellPhone` varchar(40) DEFAULT NULL,
  `emailAddress` varchar(255) NOT NULL,
  `notes` text,
  `status` tinyint(4) NOT NULL,
  `tagLine` varchar(255) DEFAULT NULL,
  `lastUpdated` bigint(20) DEFAULT NULL,
  `updatedBy` varchar(255) DEFAULT NULL,
  `avatar` text,
  `allowPost` tinyint(4) DEFAULT '1',
  `disablePhoneLinks` tinyint(4) DEFAULT '0',
  `disableNotifPopup` tinyint(4) DEFAULT '0',
  `disableAutomaticRecordTagging` tinyint(4) DEFAULT '0',
  `disableTimeInTitle` tinyint(4) DEFAULT '0',
  `language` varchar(40) DEFAULT 'en',
  `timeZone` varchar(100) DEFAULT 'UTC',
  `resultsPerPage` int(11) DEFAULT '20',
  `widgets` varchar(255) DEFAULT NULL,
  `widgetOrder` text,
  `widgetSettings` text,
  `defaultEmailTemplates` text,
  `activityFeedOrder` tinyint(4) DEFAULT '0',
  `theme` text,
  `showActions` varchar(20) DEFAULT NULL,
  `profileWidgetLayout` text,
  `recordViewWidgetLayout` text,
  `dataWidgetLayout` text,
  `miscLayoutSettings` text,
  `notificationSound` varchar(100) DEFAULT 'X2_Notification.mp3',
  `loginSound` varchar(100) DEFAULT '',
  `startPage` varchar(30) DEFAULT NULL,
  `showSocialMedia` tinyint(4) NOT NULL DEFAULT '0',
  `showDetailView` tinyint(4) NOT NULL DEFAULT '1',
  `gridviewSettings` text,
  `generalGridViewSettings` text,
  `formSettings` text,
  `emailUseSignature` varchar(5) DEFAULT 'user',
  `emailSignature` longtext,
  `enableFullWidth` tinyint(4) DEFAULT '1',
  `syncGoogleCalendarId` text,
  `syncGoogleCalendarAccessToken` text,
  `syncGoogleCalendarRefreshToken` text,
  `googleId` varchar(250) DEFAULT NULL,
  `userCalendarsVisible` tinyint(4) DEFAULT '1',
  `groupCalendarsVisible` tinyint(4) DEFAULT '1',
  `tagsShowAllUsers` tinyint(4) DEFAULT NULL,
  `hideCasesWithStatus` text,
  `hiddenTags` text,
  `address` text,
  `defaultFeedFilters` text,
  `layout` text,
  `minimizeFeed` tinyint(4) DEFAULT '0',
  `fullscreen` tinyint(4) DEFAULT '0',
  `fullFeedControls` tinyint(4) DEFAULT '0',
  `feedFilters` text,
  `hideBugsWithStatus` text,
  `actionFilters` text,
  `oldActions` tinyint(4) DEFAULT '0',
  `mediaWidgetDrive` tinyint(4) DEFAULT '0',
  `historyShowAll` tinyint(4) DEFAULT '0',
  `historyShowRels` tinyint(4) DEFAULT '0',
  `googleRefreshToken` varchar(255) DEFAULT NULL,
  `leadRoutingAvailability` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`,`emailAddress`),
  KEY `username_2` (`username`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;
INSERT INTO `x2_profile` VALUES (1,'Chloe Greigo','admin','831-555-5555',NULL,'831-222-5333','admin@foo.com','',1,'Pretty in Pink, Wicked in Uniform',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',100,'1:1:1:1:1:1:1:1:1:1:1:1:1:1','TimeZone:SmallCalendar:HelpfulTips:ActionMenu:MessageBox:ChatBox:TagCloud:OnlineUsers:QuickContact:NoteBox:MediaBox:DocViewer:TopSites:TopSites','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]},\"TimeZone\":{\"clockType\":\"analog\"},\"SmallCalendar\":{\"justMe\":\"false\"}}',NULL,1,'{\"background\":null,\"content\":null,\"text\":null,\"link\":null,\"highlight1\":null,\"highlight2\":null,\"themeName\":null,\"smart_text\":\"\",\"smart_text2\":\"\",\"darker_background\":\"\",\"dark_background\":\"\",\"brighter_background\":\"\",\"bright_background\":\"\",\"lighter_background\":\"\",\"light_background\":\"\",\"opaque_background\":\"\",\"darker_content\":\"\",\"dark_content\":\"\",\"brighter_content\":\"\",\"bright_content\":\"\",\"lighter_content\":\"\",\"light_content\":\"\",\"opaque_content\":\"\",\"darker_text\":\"\",\"dark_text\":\"\",\"brighter_text\":\"\",\"bright_text\":\"\",\"lighter_text\":\"\",\"light_text\":\"\",\"opaque_text\":\"\",\"darker_link\":\"\",\"dark_link\":\"\",\"brighter_link\":\"\",\"bright_link\":\"\",\"lighter_link\":\"\",\"light_link\":\"\",\"opaque_link\":\"\",\"darker_highlight1\":\"\",\"dark_highlight1\":\"\",\"brighter_highlight1\":\"\",\"bright_highlight1\":\"\",\"lighter_highlight1\":\"\",\"light_highlight1\":\"\",\"opaque_highlight1\":\"\",\"darker_highlight2\":\"\",\"dark_highlight2\":\"\",\"brighter_highlight2\":\"\",\"bright_highlight2\":\"\",\"lighter_highlight2\":\"\",\"light_highlight2\":\"\",\"opaque_highlight2\":\"\",\"border\":\"\",\"generated\":true,\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":\"1\",\"chartSubtype\":\"line\",\"uid\":\"\",\"softDeleted\":false,\"chartSettings\":{\"startDate\":\"1418284800000\",\"endDate\":null,\"dateRange\":null,\"binSize\":null,\"firstMetric\":null,\"showRelationships\":null,\"chartSetting\":null,\"usersFilter\":null,\"socialSubtypesFilter\":null,\"visibilityFilter\":null}},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":0,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":0,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\",\"uid\":\"\",\"softDeleted\":false},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\",\"uid\":\"\",\"softDeleted\":false,\"chartSettings\":{\"startDate\":null,\"endDate\":null,\"binSize\":null,\"firstMetric\":null,\"chartSetting\":null,\"eventsFilter\":null,\"socialSubtypesFilter\":null,\"visibilityFilter\":null,\"dateRange\":null}},\"ActionsGridViewProfileWidget\":{\"label\":\"Actions Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10,\"uid\":\"\",\"softDeleted\":false,\"dbPersistentGridSettings\":false},\"IframeWidget\":{\"label\":\"Website Viewer\",\"uid\":\"\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false,\"url\":\"\",\"height\":\"200\"},\"X2LeadsGridViewProfileWidget\":{\"label\":\"Leads Summary\",\"uid\":\"\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false,\"resultsPerPage\":10,\"dbPersistentGridSettings\":false}}','{\"WorkflowStageDetailsWidget\":{\"label\":\"Process\",\"uid\":\"\",\"hidden\":false,\"minimized\":\"1\",\"containerNumber\":1,\"softDeleted\":false},\"InlineRelationshipsWidget\":{\"label\":\"Relationships\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false,\"pageSize\":10,\"mode\":\"simple\",\"displayMode\":\"grid\",\"height\":\"200\"},\"InlineTagsWidget\":{\"label\":\"Tags\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false},\"TwitterFeedWidget\":{\"label\":\"Twitter Feed\",\"uid\":\"\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"softDeleted\":false}}',NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false,\"perStageWorkflowView\":false}','X2_Notification.mp3','','',0,1,'{\"campaigns\":{\"gvCheckbox\":30,\"name\":156,\"listId\":106,\"subject\":271,\"launchDate\":76,\"active\":44,\"lastUpdated\":78},\"contacts\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107,\"lastActivity\":78,\"gvControls\":73},\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":35,\"name\":119,\"email\":154,\"leadSource\":89,\"leadstatus\":89,\"phone\":89},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":158,\"type\":108,\"annualRevenue\":108,\"lastUpdated\":111,\"assignedTo\":99},\"inlinerelationshipsgrid\":{\"name\":180,\"myModelName\":180,\"assignedTo\":180,\"createDate\":180,\"deletion\":60},\"docs\":{\"gvCheckbox\":49,\"name\":253,\"createdBy\":76,\"createDate\":111,\"lastUpdated\":115},\"quotes\":{\"gvCheckbox\":30,\"name\":244,\"probability\":67,\"expectedCloseDate\":117,\"assignedTo\":120,\"lastActivity\":90,\"gvControls\":72}}',NULL,'{\"contacts\":[1,1,1,1,0,1],\"opportunity\":[1,1,1,1,1,1],\"undefined\":[1,1,1,1,0,1,1]}','user','Chloe Greigo \r\nCampbell\'s Cloud Computing\r\nSales Manager\r\n831.555.5555',1,NULL,NULL,NULL,'CholeG',1,1,1,NULL,'[\"#3366CC\",\"#39\",\"#servers\",\"#hardware\"]',NULL,NULL,'{\"left\":{\"EmailInboxMenu\":{\"title\":\"Inbox Menu\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false}},\"center\":{\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false}},\"right\":{\"SmallCalendar\":{\"title\":\"Calendar\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false},\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Clock\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1),(2,'API User','api',NULL,NULL,NULL,'x2crm@x2contact.com',NULL,0,NULL,NULL,NULL,NULL,1,0,0,0,0,'en','UTC',20,'0:1:1:1:1:1:0:0:0:0:0:0:0:0','OnlineUsers:TimeZone:SmallCalendar:GoogleMaps:ChatBox:TagCloud:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'X2_Notification.mp3','',NULL,0,1,NULL,NULL,NULL,'user',NULL,1,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1),(-1,'','__x2_guest_profile__',NULL,NULL,NULL,'',NULL,0,NULL,NULL,NULL,NULL,1,0,0,0,0,'en','UTC',20,'0:1:1:1:1:1:0:0:0:0:0:0:0:0','OnlineUsers:TimeZone:SmallCalendar:GoogleMaps:ChatBox:TagCloud:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'X2_Notification.mp3','',NULL,0,1,NULL,NULL,NULL,'user',NULL,1,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1),(3,'Chris Hames','chames','831-555-5555',NULL,'831.555.5578','chris@hames.com',NULL,1,'That Guy',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99},\"docs\":{\"gvCheckbox\":80,\"name\":253,\"createdBy\":76,\"createDate\":111,\"lastUpdated\":115},\"campaigns\":{\"gvCheckbox\":30,\"name\":156,\"listId\":106,\"subject\":271,\"launchDate\":76,\"active\":44,\"lastUpdated\":78}}',NULL,'{\"contacts\":[1,1,1,1,0,1]}','user','Chris Hames\nCampbell\'s Cloud Computing\nSales Representative\n831.555.5555',1,NULL,NULL,NULL,NULL,1,1,NULL,'[\"Work around provided, waiting for fix\",\"WIP\",\"Waiting for response\",\"Reopened\",\"Program Manager investigation\",\"New\",\"Needs more info\",\"Escalated\",\"Closed - No Response\"]',NULL,NULL,NULL,'{\"left\":{\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false}},\"center\":{\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false},\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false}},\"right\":{\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false},\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1),(4,'Nick Cordova','ncordova','831-555-5555',NULL,'831.555.5515','nick.cordova@example.com','',1,'One for the Money',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99}}',NULL,NULL,'user','Nick Cordova\r\nCampbell\'s Cloud Computing\r\nSales Representative\r\n831.555.5555',1,NULL,NULL,NULL,'',1,1,1,NULL,NULL,NULL,NULL,'{\"left\":{\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false}},\"center\":{\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false},\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false}},\"right\":{\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false},\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1),(5,'Amelie Pelletier','apelletier','831-555-5555','','831.555.5535','amiep@example.com','',1,'Marketing Maverick',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"pie\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99},\"inlinerelationshipsgrid\":{\"name\":180,\"myModelName\":180,\"assignedTo\":180,\"createDate\":180,\"deletion\":60}}',NULL,NULL,'user','Amelie Pelletier Campbell&#39;s Cloud Computing Marketing Representative 831.555.5555',1,NULL,NULL,NULL,'AmieP',1,1,NULL,NULL,NULL,'',NULL,'{\"left\":{\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false}},\"center\":{\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false}},\"right\":{\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1),(6,'Kevin Xu','kxu','831-555-5555',NULL,'555.555.8311','Kevin.xu@example.com','',1,'If I Can\'t Do It, Nobody Can',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99}}',NULL,NULL,'user','Kevin Xu\r\nCampbell\'s Cloud Computing\r\nSales Representative\r\n831.555.5555',1,NULL,NULL,NULL,'Kevvyxu',1,1,NULL,NULL,NULL,NULL,NULL,'{\"left\":{\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false}},\"center\":{\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false}},\"right\":{\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1),(7,'Rani Patel','rpatel','831-555-5555',NULL,'831.555.5525','rani.patel@example.com','',1,'How Can I Help You?',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99},\"inlinerelationshipsgrid\":{\"name\":180,\"myModelName\":180,\"assignedTo\":180,\"createDate\":180,\"deletion\":60}}',NULL,NULL,'user','Rani Patel\r\nCampbell\'s Cloud Computing\r\nCustomer Service Representative\r\n831.555.5555',1,NULL,NULL,NULL,'RaniMan',1,1,NULL,NULL,NULL,NULL,NULL,'{\"left\":{\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false}},\"center\":{\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false},\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false}},\"right\":{\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false},\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1),(8,'Campbell O\'Conner','coconner','831.555.5555',NULL,'831.555.5575','campbell@oconner.com','',1,'Boss Man',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99}}',NULL,NULL,'user','Campbell O\'Conner\r\nCEO & Founder\r\nCampbell\'s Cloud Computing\r\n831.555.5555',1,NULL,NULL,NULL,'OconnerCamp',1,1,NULL,NULL,NULL,NULL,NULL,'{\"left\":{\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false}},\"center\":{\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false}},\"right\":{\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1),(9,'Brian To','bto','831.555.5555',NULL,'831.555.5545','brian@to.com','',1,'There is no better time than the present',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99}}',NULL,NULL,'user','Brian To\r\nCampbell\'s Cloud Computing\r\nVP Marketing\r\n831.555.5555',1,NULL,NULL,NULL,'BTo',1,1,NULL,NULL,NULL,NULL,NULL,'{\"left\":{\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false}},\"center\":{\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false}},\"right\":{\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1),(10,'Alyssa Carisella','acarisella','555-555-5555',NULL,'555-555-5564','acarisella@example.com','',1,'Get \'er Done',NULL,NULL,NULL,1,0,0,0,0,'en','US/Pacific',20,'1:1:1:1:0:0:0:0:0:0:0:0:0','TimeZone:ChatBox:GoogleMaps:TagCloud:OnlineUsers:MessageBox:QuickContact:NoteBox:ActionMenu:MediaBox:DocViewer:TopSites:HelpfulTips','{\"ChatBox\":{\"chatboxHeight\":200,\"chatmessageHeight\":50},\"NoteBox\":{\"noteboxHeight\":200,\"notemessageHeight\":50},\"DocViewer\":{\"docboxHeight\":200},\"TopSites\":{\"topsitesHeight\":200,\"urltitleHeight\":10},\"MediaBox\":{\"mediaBoxHeight\":150,\"hideUsers\":[]}}',NULL,0,'{\"backgroundColor\":null,\"menuBgColor\":null,\"menuTextColor\":null,\"pageHeaderBgColor\":null,\"pageHeaderTextColor\":null,\"activityFeedWidgetBgColor\":null,\"activityFeedWidgetTextColor\":null,\"backgroundImg\":null,\"backgroundTiling\":null,\"pageOpacity\":null,\"themeName\":null,\"private\":null,\"owner\":null,\"loginSound\":null,\"notificationSound\":null,\"gridViewRowColorOdd\":null,\"gridViewRowColorEven\":null}',NULL,'{\"EventsChartProfileWidget\":{\"label\":\"Events\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"chartSubtype\":\"line\"},\"UsersChartProfileWidget\":{\"label\":\"User Events\",\"hidden\":true,\"minimized\":false,\"containerNumber\":2,\"chartSubtype\":\"pie\"},\"ProfilesGridViewProfileWidget\":{\"label\":\"People\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ContactsGridViewProfileWidget\":{\"label\":\"Contacts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"AccountsGridViewProfileWidget\":{\"label\":\"Accounts Summary\",\"hidden\":false,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"OpportunitiesGridViewProfileWidget\":{\"label\":\"Opportunities Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"MarketingGridViewProfileWidget\":{\"label\":\"Campaigns Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"ServicesGridViewProfileWidget\":{\"label\":\"Services Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"QuotesGridViewProfileWidget\":{\"label\":\"Quotes Summary\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"resultsPerPage\":10},\"DocViewerProfileWidget\":{\"label\":\"Doc Viewer\",\"hidden\":true,\"minimized\":false,\"containerNumber\":1,\"docId\":\"\",\"height\":\"200\"}}',NULL,NULL,'{\"themeSectionExpanded\":true,\"unhideTagsSectionExpanded\":true,\"x2flowShowLabels\":true,\"profileInfoIsMinimized\":false,\"fullProfileInfo\":false}','X2_Notification.mp3','',NULL,0,1,'{\"profilesgridviewprofilewidget\":{\"isActive\":65,\"fullName\":125,\"tagLine\":100,\"emailAddress\":100,\"cellPhone\":100,\"lastLogin\":80},\"contactsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":125,\"email\":165,\"leadSource\":83,\"leadstatus\":91,\"phone\":107},\"accountsgridviewprofilewidget\":{\"gvCheckbox\":30,\"name\":184,\"type\":153,\"annualRevenue\":108,\"phone\":115,\"lastUpdated\":77,\"assignedTo\":99}}',NULL,NULL,'user','Arianna Carisella\r\nVP Sales\r\nCampbell\'s Computing\r\n555-555-5555',1,NULL,NULL,NULL,'',1,1,NULL,NULL,NULL,NULL,NULL,'{\"left\":{\"TopContacts\":{\"title\":\"Top Contacts\",\"minimize\":false},\"RecentItems\":{\"title\":\"Recently Viewed\",\"minimize\":false},\"ActionMenu\":{\"title\":\"Actions\",\"minimize\":false},\"ActionTimer\":{\"title\":\"Action Timer\",\"minimize\":false},\"UserCalendars\":{\"title\":\"User Calendars\",\"minimize\":false},\"CalendarFilter\":{\"title\":\"Filter\",\"minimize\":false},\"GroupCalendars\":{\"title\":\"Group Calendars\",\"minimize\":false},\"FilterControls\":{\"title\":\"Filter Controls\",\"minimize\":false},\"SimpleFilterControlEventTypes\":{\"title\":\"Event Types\",\"minimize\":false}},\"center\":{\"RecordViewChart\":{\"title\":\"Record View Chart\",\"minimize\":false},\"InlineTags\":{\"title\":\"Tags\",\"minimize\":false},\"WorkflowStageDetails\":{\"title\":\"Process\",\"minimize\":false},\"InlineRelationships\":{\"title\":\"Relationships\",\"minimize\":false},\"GalleryWidget\":{\"title\":\"Image Gallery\",\"minimize\":false}},\"right\":{\"ActionMenu\":{\"title\":\"My Actions\",\"minimize\":false},\"ChatBox\":{\"title\":\"Activity Feed\",\"minimize\":false},\"GoogleMaps\":{\"title\":\"Google Map\",\"minimize\":false},\"OnlineUsers\":{\"title\":\"Active Users\",\"minimize\":false},\"TagCloud\":{\"title\":\"Tag Cloud\",\"minimize\":false},\"TimeZone\":{\"title\":\"Time Zone\",\"minimize\":false},\"MessageBox\":{\"title\":\"Message Board\",\"minimize\":false},\"QuickContact\":{\"title\":\"Quick Contact\",\"minimize\":false},\"NoteBox\":{\"title\":\"Note Pad\",\"minimize\":false},\"MediaBox\":{\"title\":\"Files\",\"minimize\":false},\"DocViewer\":{\"title\":\"Doc Viewer\",\"minimize\":false},\"TopSites\":{\"title\":\"Top Sites\",\"minimize\":false},\"HelpfulTips\":{\"title\":\"Helpful Tips\",\"minimize\":false}},\"hidden\":[],\"hiddenRight\":[]}',0,0,0,NULL,NULL,NULL,0,0,0,0,NULL,1);
        ")->execute();
    }

    /**
     * Runs migration script 
     * Asserts that pre-5.0 layouts were correctly migrated to x2_settings table
     */
    public function testMigrationScriptOpensource() {
        $this->assertLayoutMigrationSuccess('opensource');
    }

    /**
     * Runs migration script 
     * Asserts that pre-5.0 layouts were correctly migrated to x2_settings table
     */
    public function testMigrationScriptPla() {
        $this->assertLayoutMigrationSuccess('pla');
    }

    /**
     * Insert profile fixture, run migrationscript, and ensure that migration script correctly  
     * migrates layouts to x2_settings table
     */
    private function assertLayoutMigrationSuccess($edition) {
        if ($edition === 'opensource') {
            $this->insertOpensourceFixture();
        } else {
            $this->insertPlaFixture();
        }

        $profiles = Yii::app()->db->createCommand("select * from x2_profile")->queryAll();

        $command = Yii::app()->basePath . '/yiic runmigrationscript ' .
                'migrations/pending/1418870085-migrate-layouts.php';
        $return_var;
        $output = array();
        if (X2_TEST_DEBUG_LEVEL > 1)
            X2_TEST_DEBUG_LEVEL > 1 && print_r(exec($command, $return_var, $output));
        else
            exec($command, $return_var, $output);
        X2_TEST_DEBUG_LEVEL > 1 && print_r($return_var);
        X2_TEST_DEBUG_LEVEL > 1 && print_r($output);

        $layouts = array('recordViewWidgetLayout', 'profileWidgetLayout');
        if ($edition === 'pla')
            $layouts[] = 'dataWidgetLayout';
        foreach ($profiles as $profile) {
            foreach ($layouts as $layout) {
                if (!isset($profile[$layout]))
                    continue;
                $embeddedModelName = ucfirst($layout);
                $settings = Settings::model()->findByAttributes(array(
                    'recordId' => $profile['id'],
                    'recordType' => 'Profile',
                    'embeddedModelName' => $embeddedModelName,
                    'isDefault' => 1,
                ));
                $this->assertNotNull($settings);
                $embeddedModel = new $embeddedModelName;
                // normalize widget settings of layout form old profile
                $embeddedModel->attributes = CJSON::decode($profile[$layout]);
                //AuxLib::debugLogR ($profile['id']);
                //AuxLib::debugLogR ($settings->settings->attributes);
                //AuxLib::debugLogR ($embeddedModel->attributes);
                $this->assertEquals(
                        $settings->settings->attributes, $embeddedModel->attributes);

                $newProfile = Profile::model()->findByPk($profile['id']);
                $this->assertFalse(isset($newProfile->$layout));
            }
        }
    }

}

?>
