<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Taskrouter\V1\Workspace\TaskQueue;

use Twilio\Options;
use Twilio\Values;

abstract class TaskQueueStatisticsOptions {
    /**
     * @param \DateTime $endDate The end_date
     * @param string $friendlyName The friendly_name
     * @param string $minutes The minutes
     * @param \DateTime $startDate The start_date
     * @return FetchTaskQueueStatisticsOptions Options builder
     */
    public static function fetch($endDate = Values::NONE, $friendlyName = Values::NONE, $minutes = Values::NONE, $startDate = Values::NONE) {
        return new FetchTaskQueueStatisticsOptions($endDate, $friendlyName, $minutes, $startDate);
    }
}

class FetchTaskQueueStatisticsOptions extends Options {
    /**
     * @param \DateTime $endDate The end_date
     * @param string $friendlyName The friendly_name
     * @param string $minutes The minutes
     * @param \DateTime $startDate The start_date
     */
    public function __construct($endDate = Values::NONE, $friendlyName = Values::NONE, $minutes = Values::NONE, $startDate = Values::NONE) {
        $this->options['endDate'] = $endDate;
        $this->options['friendlyName'] = $friendlyName;
        $this->options['minutes'] = $minutes;
        $this->options['startDate'] = $startDate;
    }

    /**
     * The end_date
     * 
     * @param \DateTime $endDate The end_date
     * @return $this Fluent Builder
     */
    public function setEndDate($endDate) {
        $this->options['endDate'] = $endDate;
        return $this;
    }

    /**
     * The friendly_name
     * 
     * @param string $friendlyName The friendly_name
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The minutes
     * 
     * @param string $minutes The minutes
     * @return $this Fluent Builder
     */
    public function setMinutes($minutes) {
        $this->options['minutes'] = $minutes;
        return $this;
    }

    /**
     * The start_date
     * 
     * @param \DateTime $startDate The start_date
     * @return $this Fluent Builder
     */
    public function setStartDate($startDate) {
        $this->options['startDate'] = $startDate;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Taskrouter.V1.FetchTaskQueueStatisticsOptions ' . implode(' ', $options) . ']';
    }
}