/***********************************************************************************
 * X2Engine Open Source Edition is a customer relationship management program developed by
 * X2 Engine, Inc. Copyright (C) 2011-2019 X2 Engine Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY X2ENGINE, X2ENGINE DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact X2Engine, Inc. P.O. Box 610121, Redwood City,
 * California 94061, USA. or at email address contact@x2engine.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * X2 Engine" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by X2 Engine".
 **********************************************************************************/




drop table if exists `x2_auth_assignment`,`x2_auth_item_child`,`x2_auth_item`,`x2_auth_cache`;
/*&*/
create table `x2_auth_item`
(
   `name`                 varchar(64) not null,
   `type`                 integer not null, /* {0, 1, 2} operation, task, or role */
   `description`          text,
   `bizrule`              text,
   `data`                 text,
   primary key (`name`)
) COLLATE = utf8_general_ci, ENGINE=INNODB;
/*&*/
create table `x2_auth_item_child`
(
   `parent`               varchar(64) not null,
   `child`                varchar(64) not null,
   primary key (`parent`,`child`),
   foreign key (`parent`) references `x2_auth_item` (`name`) on delete cascade on update cascade,
   foreign key (`child`) references `x2_auth_item` (`name`) on delete cascade on update cascade
) COLLATE = utf8_general_ci, ENGINE=INNODB;
/*&*/
create table `x2_auth_assignment`
(
   `itemname`             varchar(64) not null,
   /* this acutally refers to the role id, not the user id */
   `userid`               varchar(64) not null,
   `bizrule`              text,
   `data`                 text,
   primary key (`itemname`,`userid`),
   foreign key (`itemname`) references `x2_auth_item` (`name`) on delete cascade on update cascade
) COLLATE = utf8_general_ci, ENGINE=INNODB;
/*&*/
CREATE TABLE x2_auth_cache(
	authItem			VARCHAR(100)	NOT NULL,
	userId				INT				NOT NULL,
	expire				INT				NOT NULL,
	value				TINYINT(1),
        params                          VARCHAR(100) NOT NULL,
	PRIMARY KEY (userId, authItem, params),
	INDEX (userId)
) COLLATE = utf8_general_ci;
/*&*/
INSERT INTO `x2_auth_item`
(`name`,`type`,`description`,`bizrule`,`data`)
VALUES
('ContactsMobileActionHistoryPublish', 0, '', NULL, 'N;'),
('AccountsMobileActionHistoryPublish', 0, '', NULL, 'N;'),
('OpportunitiesMobileActionHistoryPublish', 0, '', NULL, 'N;'),
('ProductsMobileActionHistoryPublish', 0, '', NULL, 'N;'),
('ServicesMobileActionHistoryPublish', 0, '', NULL, 'N;'),
('X2LeadsMobileActionHistoryPublish', 0, '', NULL, 'N;'),
('BugReportsMobileActionHistoryPublish', 0, '', NULL, 'N;'),
('ContactsMobileActionHistoryAttachmentsPublish', 0, '', NULL, 'N;'),
('AccountsMobileActionHistoryAttachmentsPublish', 0, '', NULL, 'N;'),
('OpportunitiesMobileActionHistoryAttachmentsPublish', 0, '', NULL, 'N;'),
('ProductsMobileActionHistoryAttachmentsPublish', 0, '', NULL, 'N;'),
('ServicesMobileActionHistoryAttachmentsPublish', 0, '', NULL, 'N;'),
('X2LeadsMobileActionHistoryAttachmentsPublish', 0, '', NULL, 'N;'),
('BugReportsMobileActionHistoryAttachmentsPublish', 0, '', NULL, 'N;'),
('AccountsMobileCreate', 0, '', NULL, 'N;'),
('AccountsMobileUpdate', 0, '', NULL, 'N;'),
('ContactsMobileCreate', 0, '', NULL, 'N;'),
('ContactsMobileUpdate', 0, '', NULL, 'N;'),
('OpportunitiesMobileCreate', 0, '', NULL, 'N;'),
('OpportunitiesMobileUpdate', 0, '', NULL, 'N;'),
('ProductsMobileCreate', 0, '', NULL, 'N;'),
('ProductsMobileUpdate', 0, '', NULL, 'N;'),
('QuotesMobileCreate', 0, '', NULL, 'N;'),
('QuotesMobileUpdate', 0, '', NULL, 'N;'),
('ServicesMobileCreate', 0, '', NULL, 'N;'),
('ServicesMobileUpdate', 0, '', NULL, 'N;'),
('UsersMobileCreate', 0, '', NULL, 'N;'),
('UsersMobileUpdate', 0, '', NULL, 'N;'),
('X2LeadsMobileCreate', 0, '', NULL, 'N;'),
('X2LeadsMobileUpdate', 0, '', NULL, 'N;'),
('BugReportsMobileCreate', 0, '', NULL, 'N;'),
('BugReportsMobileUpdate', 0, '', NULL, 'N;'),
('AccountsMobileIndex', 0, '', NULL, 'N;'),
('AccountsMobileView', 0, '', NULL, 'N;'),
('ContactsMobileIndex', 0, '', NULL, 'N;'),
('ContactsMobileView', 0, '', NULL, 'N;'),
('OpportunitiesMobileIndex', 0, '', NULL, 'N;'),
('OpportunitiesMobileView', 0, '', NULL, 'N;'),
('ProductsMobileIndex', 0, '', NULL, 'N;'),
('ProductsMobileView', 0, '', NULL, 'N;'),
('QuotesMobileIndex', 0, '', NULL, 'N;'),
('QuotesMobileView', 0, '', NULL, 'N;'),
('ServicesMobileIndex', 0, '', NULL, 'N;'),
('ServicesMobileView', 0, '', NULL, 'N;'),
('UsersMobileIndex', 0, '', NULL, 'N;'),
('UsersMobileView', 0, '', NULL, 'N;'),
('X2LeadsMobileIndex', 0, '', NULL, 'N;'),
('X2LeadsMobileView', 0, '', NULL, 'N;'),
('BugReportsMobileIndex', 0, '', NULL, 'N;'),
('BugReportsMobileView', 0, '', NULL, 'N;'),
('AccountsMobileDelete', 0, '', NULL, 'N;'),
('ActionsMobileDelete', 0, '', NULL, 'N;'),
('ContactsMobileDelete', 0, '', NULL, 'N;'),
('OpportunitiesMobileDelete', 0, '', NULL, 'N;'),
('ProductsMobileDelete', 0, '', NULL, 'N;'),
('ServicesMobileDelete', 0, '', NULL, 'N;'),
('UsersMobileDelete', 0, '', NULL, 'N;'),
('X2LeadsMobileDelete', 0, '', NULL, 'N;'),
('BugReportsMobileDelete', 0, '', NULL, 'N;'),
('ReportsMobileChartDashboard', 0, '', NULL, 'N;'),
('AccountsX2GridViewMassAction', 0, '', NULL, 'N;'),
('AccountsInlineEmail', 0, '', NULL, 'N;'),
('AccountsAccountsCampaign', 0, '', NULL, 'N;'),
('ActionsX2GridViewMassAction', 0, '', NULL, 'N;'),
('ActionsInlineEmail', 0, '', NULL, 'N;'),
('ActionsCaptcha', 0, '', 'return true', 'N;'),
('CalendarX2GridViewMassAction', 0, '', NULL, 'N;'),
('CalendarInlineEmail', 0, '', NULL, 'N;'),
('ContactsX2GridViewMassAction', 0, '', NULL, 'N;'),
('ContactsInlineEmail', 0, '', NULL, 'N;'),
('ContactsCreateRecordAlias', 0, '', NULL, 'N;'),
('ContactsDeleteRecordAlias', 0, '', NULL, 'N;'),
('DocsX2GridViewMassAction', 0, '', NULL, 'N;'),
('DocsInlineEmail', 0, '', NULL, 'N;'),
('GroupsX2GridViewMassAction', 0, '', NULL, 'N;'),
('GroupsInlineEmail', 0, '', NULL, 'N;'),
('MarketingX2GridViewMassAction', 0, '', NULL, 'N;'),
('MarketingInlineEmail', 0, '', NULL, 'N;'),
('WeblistX2GridViewMassAction', 0, '', NULL, 'N;'),
('WeblistInlineEmail', 0, '', NULL, 'N;'),
('MediaX2GridViewMassAction', 0, '', NULL, 'N;'),
('MediaInlineEmail', 0, '', NULL, 'N;'),
('OpportunitiesX2GridViewMassAction', 0, '', NULL, 'N;'),
('OpportunitiesInlineEmail', 0, '', NULL, 'N;'),
('ProductsX2GridViewMassAction', 0, '', NULL, 'N;'),
('ProductsInlineEmail', 0, '', NULL, 'N;'),
('QuotesX2GridViewMassAction', 0, '', NULL, 'N;'),
('QuotesInlineEmail', 0, '', NULL, 'N;'),
('ReportsX2GridViewMassAction', 0, '', NULL, 'N;'),
('ReportsInlineEmail', 0, '', NULL, 'N;'),
('ServicesX2GridViewMassAction', 0, '', NULL, 'N;'),
('ServicesInlineEmail', 0, '', NULL, 'N;'),
('UsersX2GridViewMassAction', 0, '', NULL, 'N;'),
('UsersInlineEmail', 0, '', NULL, 'N;'),
('WorkflowX2GridViewMassAction', 0, '', NULL, 'N;'),
('WorkflowInlineEmail', 0, '', NULL, 'N;'),
('X2LeadsX2GridViewMassAction', 0, '', NULL, 'N;'),
('X2LeadsInlineEmail', 0, '', NULL, 'N;'),
('X2LeadsConvert', 0, '', NULL, 'N;'),
('BugReportsX2GridViewMassAction', 0, '', NULL, 'N;'),
('BugReportsInlineEmail', 0, '', NULL, 'N;'),
('EmailInboxesX2GridViewMassAction', 0, '', NULL, 'N;'),
('EmailInboxesInlineEmail', 0, '', NULL, 'N;'),
('AccountsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('AccountsAddUser',0,'',NULL,'N;'),
('AccountsAdmin',0,'',NULL,'N;'),
('AccountsAdminAccess',1,'',NULL,'N;'),
('AccountsBasicAccess',1,'',NULL,'N;'),
('AccountsCreate',0,'',NULL,'N;'),
('AccountsDelete',0,'',NULL,'N;'),
('AccountsDeleteNote',0,'',NULL,'N;'),
('AccountsDeletePrivate',1,'Delete their own records.','return $this->checkAssignment($params);','N;'),
('AccountsFullAccess',1,'',NULL,'N;'),
('AccountsGetItems',0,'',NULL,'N;'),
('AccountsGetX2ModelInput',0,'',NULL,'N;'),
('AccountsIndex',0,'',NULL,'N;'),
('AccountsMinimumRequirements',1,'',NULL,'N;'),
('AccountsPrivateFullAccess',1,'',NULL,'N;'),
('AccountsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('AccountsPrivateUpdateAccess',1,'',NULL,'N;'),
('AccountsReadOnlyAccess',1,'',NULL,'N;'),
('AccountsRemoveUser',0,'',NULL,'N;'),
('AccountsSearch',0,'',NULL,'N;'),
('AccountsShareAccount',0,'',NULL,'N;'),
('AccountsUpdate',0,'',NULL,'N;'),
('AccountsUpdateAccess',1,'',NULL,'N;'),
('AccountsUpdatePrivate',1,'Update their own records','return $this->checkAssignment($params);','N;'),
('AccountsView',0,'',NULL,'N;'),
('AccountsQuickView',0,'',NULL,'N;'),
('AccountsViewPrivate',1,'View their own records','return $this->checkAssignment($params);','N;'),
('AccountsAccountsReport',0,'',NULL,'N;'),
('AccountsExportAccountsReport',0,'',NULL,'N;'),
('AccountsQtip',0,'',NULL,'N;'),
('ActionsAdmin',0,'',NULL,'N;'),
('ActionsGetItems',0,'',NULL,'N;'),
('ActionsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('ActionsAdminAccess',1,'',NULL,'N;'),
('ActionsBasicAccess',1,'',NULL,'N;'),
('ActionsComplete',0,'',NULL,'N;'),
('ActionsCompleteSelected',0,'',NULL,'N;'),
('ActionsCreate',0,'',NULL,'N;'),
('ActionsCopyEvent',0,'',NULL,'N;'),
('ActionsViewAction',0,'',NULL,'N;'),
('ActionsToggleSticky',0,'',NULL,'N;'),
('ActionsDelete',0,'',NULL,'N;'),
('ActionsDeleteNote',0,'',NULL,'N;'),
('ActionsDeletePrivate',1,'Delete assigned records','return $this->checkAssignment($params);','N;'),
('ActionsFullAccess',1,'',NULL,'N;'),
('ActionsGetAutocompleteAssocLink',0,'',NULL,'N;'),
('ActionsGetTerms',0,'',NULL,'N;'),
('ActionsGetX2ModelInput',0,'',NULL,'N;'),
('ActionsIndex',0,'',NULL,'N;'),
('ActionsInvalid',0,'',NULL,'N;'),
('ActionsMinimumRequirements',1,'Minimum requirements to access the actions module.',NULL,'N;'),
('ActionsParseType',0,'',NULL,'N;'),
('ActionsPrivateFullAccess',1,'',NULL,'N;'),
('ActionsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('ActionsPrivateUpdateAccess',1,'',NULL,'N;'),
('ActionsPublisherCreate',0,'',NULL,'N;'),
('ActionsQuickUpdate',0,'',NULL,'N;'),
('ActionsReadOnlyAccess',1,'',NULL,'N;'),
('ActionsSaveShowActions',0,'',NULL,'N;'),
('ActionsSearch',0,'',NULL,'N;'),
('ActionsSendReminder',0,'',NULL,'N;'),
('ActionsShareAction',0,'',NULL,'N;'),
('ActionsTimerControl',0,'',NULL,'N;'),
('ActionsTomorrow',0,'',NULL,'N;'),
('ActionsUncomplete',0,'',NULL,'N;'),
('ActionsUncompleteSelected',0,'',NULL,'N;'),
('ActionsUpdate',0,'',NULL,'N;'),
('ActionsUpdateAccess',1,'',NULL,'N;'),
('ActionsUpdatePrivate',1,'Update assigned records.','return $this->checkAssignment($params);','N;'),
('ActionsView',0,'',NULL,'N;'),
('ActionsQuickView',0,'',NULL,'N;'),
('ActionsViewAll',0,'',NULL,'N;'),
('ActionsViewGroup',0,'',NULL,'N;'),
('ActionsViewPrivate',1,'View assigned records','return $this->checkAssignment($params);','N;'),
('admin',2,'Default admin user','return ((int) $params[\'userId\'] === X2_PRIMARY_ADMIN_ID);','N;'),
('administrator',2,'Admin user','','N;'),
('AdminAutomateTranslation',0,'',NULL,'N;'),
('AdminGetRoleAccess',0,'',NULL,'N;'),
('AdminDeleteMenuItem',0,'',NULL,'N;'),
('AdminAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('AdminSetDefaultTheme',0,'',NULL,'N;'),
('AdminManageActionPublisherTabs',0,'',NULL,'N;'),
('AdminFlowSettings',0,'',NULL,'N;'),
('AdminChangeApplicationName',0,'',NULL,'N;'),
('AdminClearChangelog',0,'Clear out the changelog.',NULL,'N;'),
('AdminAddCriteria',0,'Access the page to create criteria which will trigger notifications.',NULL,'N;'),
('AdminCreateUpdateField',0,'Create a new field, or update a field.',NULL,'N;'),
('AdminAppSettings',0,'General settings for the application.',NULL,'N;'),
('AdminUserLocationHistory',0,'General Location History for the application.',NULL,'N;'),
('AdminLocationSettings',0,'General Location settings for the application.',NULL,'N;'),
('AdminManageUserCount',0,'General max user count for the application.',NULL,'N;'),
('AdminApi2Settings',0,'Advance REST API settings.',NULL,'N;'),
('AdminManageSessions',0,'Manage user sessions.',NULL,'N;'),
('AdminToggleSession',0,'',NULL,'N;'),
('AdminEndSession',0,'',NULL,'N;'),
('AdminPrepareImport',0,'',NULL,'N;'),
('AdminGlobalImport',0,'',NULL,'N;'),
('AdminCleanUpImport',0,'',NULL,'N;'),
('AdminDownloadData',0,'',NULL,'N;'),
('AdminPrepareExport',0,'',NULL,'N;'),
('AdminGlobalExport',0,'',NULL,'N;'),
('AdminFinishGlobalExport',0,'',NULL,'N;'),
('AdminLocateMissingRecords',0,'',NULL,'N;'),
('AdminRollbackImport',0,'',NULL,'N;'),
('AdminRollbackStage',0,'',NULL,'N;'),
('AdminManageTags',0,'',NULL,'N;'),
('AdminDeleteTag',0,'',NULL,'N;'),
('AdminConvertCustomModules',0,'',NULL,'N;'),
('AdminCreateModule',0,'Create a new module.',NULL,'N;'),
('AdminCreatePage',0,'Create a static page for the top menu bar.',NULL,'N;'),
('AdminDeleteDropdown',0,'Delete a dropdown.',NULL,'N;'),
('AdminDeleteField',0,'Delete a custom field.',NULL,'N;'),
('AdminDeleteModule',0,'Delete a module or static page.',NULL,'N;'),
('AdminDeleteRole',0,'',NULL,'N;'),
('AdminDropDownEditor',0,'Create a new dropdown.',NULL,'N;'),
('AdminEditDropdown',0,'Customize a dropdown.',NULL,'N;'),
('AdminEditor',0,'Form editor control.',NULL,'N;'),
('AdminEditMobileForms',0,'',NULL,'N;'),
('AdminGetMobileLayouts',0,'',NULL,'N;'),
('AdminEditRole',0,'',NULL,'N;'),
('AdminEditRoleAccess',0,'',NULL,'N;'),
('AdminEmailDropboxSettings',0,'Edit the email dropbox settings.',NULL,'N;'),
('AdminEmailSetup',0,'Configure email settings for the application.',NULL,'N;'),
('AdminExport',0,'Global data export.',NULL,'N;'),
('AdminExportModule',0,'Export a module to a .zip file.',NULL,'N;'),
('AdminGoogleIntegration',0,'Permissions for integrating the application with Google.',NULL,'N;'),
('AdminX2HubIntegration',0,'Permissions for integrating the application with X2 Hub Services.',NULL,'N;'),
('AdminTwitterIntegration',0,'Permissions for integrating the application with Twitter.',NULL,'N;'),
('AdminJasperIntegration',0,'Permissions for integrating the application with Jasper Reports.',NULL,'N;'),
('AdminUndoMerge',0,'',NULL, 'N;'),
('AdminImport',0,'Global data import.',NULL,'N;'),
('AdminExportModels',0,'','return $this->checkAdminOn($params);','N;'),
('AdminExportMapping',0,'',NULL,'N;'),
('AdminExportModelRecords',0,'','return $this->checkAdminOn($params);','N;'),
('AdminImportModels',0,'',NULL,'N;'),
('AdminImportModelRecords',0,'',NULL,'N;'),
('AdminPrepareModelImport',0,'',NULL,'N;'),
('AdminCleanUpModelImport',0,'',NULL,'N;'),
('AdminImportModule',0,'Import a zip file of a module.',NULL,'N;'),
('AdminIndex',0,'Access the index page of the administrator tab.',NULL,'N;'),
('AdminWorkflowSettings',0,'Control settings for editing workflow actions.',NULL,'N;'),
('AdminUpdaterSettings',0,'Control settings for the auto-updater.',NULL,'N;'),
('AdminUpdater',0,'',NULL,'N;'),
('AdminUpdateStage',0,'',NULL,'N;'),
('AdminViewLog',0,'',NULL,'N;'),
('AdminLockApp',0,'',NULL,'N;'),
('AdminManageDropDowns',0,'General dropdown management.',NULL,'N;'),
('AdminManageFields',0,'Manage created fields.',NULL,'N;'),
('AdminManageModules',0,'Manage top bar menu items.',NULL,'N;'),
('AdminManageRoles',0,'',NULL,'N;'),
('AdminPackager',0,'',NULL,'N;'),
('AdminDisableUser',0,'',NULL,'N;'),
('AdminBanIp',0,'',NULL,'N;'),
('AdminWhitelistIp',0,'',NULL,'N;'),
('AdminImportPackage',0,'',NULL,'N;'),
('AdminPreviewPackageImport',0,'',NULL,'N;'),
('AdminExportPackage',0,'',NULL,'N;'),
('AdminBeginPackageRevert',0,'',NULL,'N;'),
('AdminFinishPackageRevert',0,'',NULL,'N;'),
('AdminRevertPackage',0,'',NULL,'N;'),
('AdminPublicInfo',0,'',NULL,'N;'),
('AdminRenameModules',0,'Rename a module in the top menu bar.',NULL,'N;'),
('AdminRoleEditor',0,'',NULL,'N;'),
('AdminRoleException',0,'',NULL,'N;'),
('AdminRoundRobinRules',0,'Edit custom round robin lead distribution rules.',NULL,'N;'),
('AdminSetLeadRouting',0,'Manage lead distribution methods.',NULL,'N;'),
('AdminToggleDefaultLogo',0,'Toggle the logo in the top left corner.',NULL,'N;'),
('AdminTranslationManager',0,'Translation manager for the application',NULL,'N;'),
('AdminUploadLogo',0,'Upload your own logo for the top left corner.',NULL,'N;'),
('AdminGetNUsers',0,'',NULL,'N;'),
('AdminSaveEdition',0,'',NULL,'N;'),
('AdminSecuritySettings',0,'',NULL,'N;'),
('AdminViewChangelog',0,'View a list of all changes made by users.',NULL,'N;'),
('AdminExportChangelog',0,'Export a complete list of changelog entries to CSV',NULL,'N;'),
('AdminViewSessionLog',0,'',NULL,'N;'),
('AdminViewSessionHistory',0,'',NULL,'N;'),
('AdminUserViewLog',0,'',NULL,'N;'),
('AdminClearViewHistory',0,'',NULL,'N;'),
('AdminCalculateMissingTranslations',0,'',NULL,'N;'),
('AdminX2CronSettings',0,'',NULL,'N;'),
('AdminExportLoginHistory',0,'',NULL,'N;'),
('AdminBackup',0,'',NULL,'N;'),
('AdminCheckDatabaseBackup',0,'',NULL,'N;'),
('AdminLayoutPreview',0,'',NULL,'N;'),
('AdminEditGlobalCss',0,'',NULL,'N;'),
('AdminPrepareModelExport',0,'','return $this->checkAdminOn($params);','N;'),
('AdminConvertEmailTemplates',0,'',NULL,'N;'),
('AdminMassDedupe',0,'',NULL,'N;'),
('AdminAutoMergeDuplicates',0,'',NULL,'N;'),
('AdminUserHistory',0,'',NULL,'N;'),
('StudioImportFlow',0,'',NULL,'N;'),
('StudioQuickView',0,'',NULL,'N;'),
('StudioExportFlow',0,'',NULL,'N;'),
('StudioAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('StudioFlowIndex',0,'',NULL,'N;'),
('StudioFlowDesigner',0,'',NULL,'N;'),
('StudioDeleteFlow',0,'',NULL,'N;'),
('StudioTest',0,'',NULL,'N;'),
('StudioGetParams',0,'',NULL,'N;'),
('StudioGetFields',0,'',NULL,'N;'),
('StudioDeleteNote',0,'',NULL,'N;'),
('StudioSearch',0,'',NULL,'N;'),
('StudioGetX2ModelInput',0,'',NULL,'N;'),
('StudioTriggerLogs',0,'',NULL,'N;'),
('StudioDeleteAllTriggerLogs',0,'',NULL,'N;'),
('StudioDeleteAllTriggerLogsForAllFlows',0,'',NULL,'N;'),
('StudioDeleteTriggerLog',0,'',NULL,'N;'),
('StudioExecuteMacro',0,'',NULL,'N;'),
('authenticated',2,'Authenticated user','return !Yii::app()->isUserGuest;','N;'),
('DefaultRole',2,'Default permission set','','N;'),
('AuthenticatedSiteFunctionsTask',1,'A set of permissions required to use the site while logged in.',NULL,'N;'),
('CalendarAdmin',0,'',NULL,'N;'),
('CalendarAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('CalendarAdminAccess',1,'',NULL,'N;'),
('CalendarBasicAccess',1,'',NULL,'N;'),
('CalendarCompleteAction',0,'',NULL,'N;'),
('CalendarCreate',0,'',NULL,'N;'),
('CalendarDelete',0,'',NULL,'N;'),
('CalendarDeleteAction',0,'',NULL,'N;'),
('CalendarDeleteGoogleEvent',0,'',NULL,'N;'),
('CalendarDeleteNote',0,'',NULL,'N;'),
('CalendarEditAction',0,'',NULL,'N;'),
('CalendarEditGoogleEvent',0,'',NULL,'N;'),
('CalendarFullAccess',1,'',NULL,'N;'),
('CalendarGetX2ModelInput',0,'',NULL,'N;'),
('CalendarIndex',0,'',NULL,'N;'),
('CalendarIcal',0,'',NULL,'N;'),
('CalendarJsonFeed',0,'',NULL,'N;'),
('CalendarJsonFeedGoogle',0,'',NULL,'N;'),
('CalendarJsonFeedGroup',0,'',NULL,'N;'),
('CalendarJsonFeedShared',0,'',NULL,'N;'),
('CalendarMinimumRequirements',1,'',NULL,'N;'),
('CalendarMoveAction',0,'',NULL,'N;'),
('CalendarMoveGoogleEvent',0,'',NULL,'N;'),
('CalendarMyCalendarPermissions',0,'',NULL,'N;'),
('CalendarReadOnlyAccess',1,'',NULL,'N;'),
('CalendarResizeAction',0,'',NULL,'N;'),
('CalendarResizeGoogleEvent',0,'',NULL,'N;'),
('CalendarSaveCheckedCalendar',0,'',NULL,'N;'),
('CalendarSaveCheckedCalendarFilter',0,'',NULL,'N;'),
('CalendarSaveGoogleEvent',0,'',NULL,'N;'),
('CalendarSearch',0,'',NULL,'N;'),
('CalendarSyncActionsToGoogleCalendar',0,'',NULL,'N;'),
('CalendarTogglePortletVisible',0,'',NULL,'N;'),
('CalendarToggleUserCalendarsVisible',0,'',NULL,'N;'),
('CalendarUncompleteAction',0,'',NULL,'N;'),
('CalendarUpdate',0,'',NULL,'N;'),
('CalendarUpdateAccess',1,'',NULL,'N;'),
('CalendarUserCalendarPermissions',0,'',NULL,'N;'),
('CalendarView',0,'',NULL,'N;'),
('CalendarQuickView',0,'',NULL,'N;'),
('CalendarViewAction',0,'',NULL,'N;'),
('CalendarViewGoogleEvent',0,'',NULL,'N;'),
('CalendarEventRsvp',0,'',NULL,'N;'),
('ContactsAddToList',0,'',NULL,'N;'),
('ContactsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('ContactsAdmin',0,'',NULL,'N;'),
('ContactsAdminAccess',1,'',NULL,'N;'),
('ContactsBasicAccess',1,'',NULL,'N;'),
('ContactsCreate',0,'',NULL,'N;'),
('ContactsCreateList',0,'',NULL,'N;'),
('ContactsCreateListFromSelection',0,'',NULL,'N;'),
('ContactsDelete',0,'',NULL,'N;'),
('ContactsDeleteList',0,'',NULL,'N;'),
('ContactsDeleteNote',0,'',NULL,'N;'),
('ContactsDeletePrivate',1,'This task allows a user to delete their own records','return $this->checkAssignment($params);','N;'),
('ContactsDiscardNew',0,'',NULL,'N;'),
('ContactsFullAccess',1,'',NULL,'N;'),
('ContactsGetContacts',0,'',NULL,'N;'),
('ContactsGetItems',0,'',NULL,'N;'),
('ContactsGetLists',0,'',NULL,'N;'),
('ContactsGetTerms',0,'',NULL,'N;'),
('ContactsGetX2ModelInput',0,'',NULL,'N;'),
('ContactsIgnoreDuplicates',0,'',NULL,'N;'),
('ContactsPrepareImport',0,'',NULL,'N;'),
('ContactsCleanUpImport',0,'',NULL,'N;'),
('ContactsImportRecords',0,'',NULL,'N;'),
('ContactsImportExcel',0,'',NULL,'N;'),
('ContactsTrigger',0,'',NULL,'N;'),
('ContactsIndex',0,'',NULL,'N;'),
('ContactsList',0,'',NULL,'N;'),
('ContactsLists',0,'',NULL,'N;'),
('ContactsMinimumRequirements',1,'Permissions required by anyone able to access the contacts module.',NULL,'N;'),
('ContactsMyContacts',0,'',NULL,'N;'),
('ContactsNewContacts',0,'',NULL,'N;'),
('ContactsPrivateFullAccess',1,'',NULL,'N;'),
('ContactsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('ContactsPrivateUpdateAccess',1,'',NULL,'N;'),
('ContactsQtip',0,'',NULL,'N;'),
('ContactsQuickContact',0,'',NULL,'N;'),
('ContactsReadOnlyAccess',1,'',NULL,'N;'),
('ContactsRemoveFromList',0,'',NULL,'N;'),
('ContactsSearch',0,'',NULL,'N;'),
('ContactsShareContact',0,'',NULL,'N;'),
('ContactsSubscribe',0,'',NULL,'N;'),
('ContactsUpdate',0,'',NULL,'N;'),
('ContactsUpdateAccess',1,'',NULL,'N;'),
('ContactsUpdateList',0,'',NULL,'N;'),
('ContactsUpdatePrivate',1,'This task allows a user to update their own records','return $this->checkAssignment($params);','N;'),
('ContactsView',0,'',NULL,'N;'),
('ContactsQuickView',0,'',NULL,'N;'),
('ContactsViewPrivate',1,'This task allows a user to view their own records','return $this->checkAssignment($params);','N;'),
('ContactsViewRelationships',0,'',NULL,'N;'),
('CredentialsAdmin',1,'Administrative credentials access',NULL,'N;'),
('CredentialsCreateUpdate',0,'Create or update credentials',NULL,'N;'),
('CredentialsCreateUpdateOwn',1,'Access to a user\'s own credentials, by the user','return $params[\'userId\'] == $params[\'model\']->userId;','N;'),
('CredentialsCreateUpdateSystemwide',1,'Create or update system-wide credentials','return $params[\'model\']->userId == Credentials::SYS_ID;','N;'),
('CredentialsDelete',0,'Delete a credentials record not in use.','','N;'),
('CredentialsDeleteOwn',1,'Delete one\'s own credentials.','return $params[\'userId\'] == $params[\'model\']->userId;','N;'),
('CredentialsDeleteSystemwide',1,'Delete system-wide credentials that aren\'t in use','return (!$params[\'model\']->getIsInUseBySystem()) && $params[\'model\']->userId == Credentials::SYS_ID;','N;'),
('CredentialsSelect',1,'Select a credentials record to use as default.',NULL,'N;'),
('CredentialsSelectOwn',1,'Select one\'s own credentials','return $params[\'model\']->userId == $params[\'userId\'];','N;'),
('CredentialsSelectSystemwide',1,'Select system-owned credentials.','return $params[\'model\']->userId == Credentials::SYS_ID;','N;'),
('CredentialsSetDefault',0,'Set a credentials record as default.',NULL,'N;'),
('CredentialsSetDefaultOwn',1,'Set one\'s own credentials',NULL,'N;'),
('CredentialsSelectNonPrivate',1,'Select other users\' credentials that are designated not-private','return $params[\'model\']->private == 0;','N;'),
('CredentialsSetDefaultSystemwide',1,'Set system-wide default credentials, i.e. for bulk email.','return $params[\'model\']->userId == Credentials::SYS_ID;','N;'),
('DocsAdmin',0,'',NULL,'N;'),
('DocsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('DocsAdminAccess',1,'',NULL,'N;'),
('DocsAutosave',0,'',NULL,'N;'),
('DocsBasicAccess',1,'',NULL,'N;'),
('DocsChangePermissions',0,'',NULL,'N;'),
('DocsCreate',0,'',NULL,'N;'),
('DocsCreateEmail',0,'',NULL,'N;'),
('DocsCreateQuote',0,'',NULL,'N;'),
('DocsDelete',0,'',NULL,'N;'),
('DocsDeleteNote',0,'',NULL,'N;'),
('DocsDeletePrivate',1,'Users can delete their own docs','return $this->checkAssignment($params);','N;'),
('DocsDownloadExport',0,'',NULL,'N;'),
('DocsExportToHtml',0,'',NULL,'N;'),
('DocsFullAccess',1,'',NULL,'N;'),
('DocsGetItem',0,'',NULL,'N;'),
('DocsGetItems',0,'',NULL,'N;'),
('DocsGetFolderSelector',0,'',NULL,'N;'),
('DocsGetX2ModelInput',0,'',NULL,'N;'),
('DocsIndex',0,'',NULL,'N;'),
('DocsMoveFolder',0,'',NULL,'N;'),
('DocsDeleteFileFolder',0,'',NULL,'N;'),
('DocsMinimumRequirements',1,'',NULL,'N;'),
('DocsPrivateFullAccess',1,'',NULL,'N;'),
('DocsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('DocsPrivateUpdateAccess',1,'',NULL,'N;'),
('DocsReadOnlyAccess',1,'',NULL,'N;'),
('DocsSearch',0,'',NULL,'N;'),
('DocsUpdate',0,'',NULL,'N;'),
('DocsUpdateAccess',1,'',NULL,'N;'),
('DocsUpdatePrivate',1,'Update their own docs','return $this->checkAssignment($params);','N;'),
('DocsView',0,'',NULL,'N;'),
('DocsQuickView',0,'',NULL,'N;'),
('DocsFullView',0,'',NULL,'N;'),
('DocsViewPrivate',1,'View their own docs','return $this->checkAssignment($params);','N;'),
('DropDownsTask',1,'Dropdown editor control.',NULL,'N;'),
('EmailInboxesAdminAccess',1,'Enables configuration of shared email inboxes',NULL,'N;'),
('EmailInboxesAdmin',1,'',NULL,'N;'),
('EmailInboxesReadOnlyAccess',1,'Enables setup and use of personal email inbox',NULL,'N;'),
('EmailInboxesMinimumRequirements',1,'',NULL,'N;'),
('EmailInboxesIndex',0,'',NULL,'N;'),
('EmailInboxesSaveTabSettings',0,'',NULL,'N;'),
('EmailInboxesSharedInboxesIndex',0,'',NULL,'N;'),
('EmailInboxesForgetInbox',0,'',NULL,'N;'),
('EmailInboxesCreateSharedInbox',0,'',NULL,'N;'),
('EmailInboxesUpdateSharedInbox',0,'',NULL,'N;'),
('EmailInboxesDeleteSharedInbox',0,'',NULL,'N;'),
('EmailInboxesConfigureMyInbox',0,'',NULL,'N;'),
('EmailInboxesViewMessage',0,'',NULL,'N;'),
('EmailInboxesQuickView',0,'',NULL,'N;'),
('EmailInboxesDownloadAttachment',0,'',NULL,'N;'),
('EmailInboxesViewAttachment',0,'',NULL,'N;'),
('EmailInboxesMarkMessages',0,'',NULL,'N;'),
('EmailInboxesDeleteNote',0,'',NULL,'N;'),
('EmailInboxesGetItems',0,'',NULL,'N;'),
('EmailInboxesSearch',0,'',NULL,'N;'),
('EmailInboxesAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('EmailInboxesGetX2ModelInput',0,'',NULL,'N;'),
('EmailInboxesAssociateAttachment',0,'',NULL,'N;'),
('FieldsTask',1,'Field editor control.',NULL,'N;'),
('GeneralAdminSettingsTask',1,'A suite of application wide settings configurable by the administrator.',NULL,'N;'),
('GroupsAdmin',0,'',NULL,'N;'),
('GroupsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('GroupsGetItems',0,'',NULL,'N;'),
('GroupsAdminAccess',1,'',NULL,'N;'),
('GroupsBasicAccess',1,'',NULL,'N;'),
('GroupsCreate',0,'',NULL,'N;'),
('GroupsDelete',0,'',NULL,'N;'),
('GroupsDeleteNote',0,'',NULL,'N;'),
('GroupsFullAccess',1,'',NULL,'N;'),
('GroupsGetGroups',0,'',NULL,'N;'),
('GroupsGetX2ModelInput',0,'',NULL,'N;'),
('GroupsIndex',0,'',NULL,'N;'),
('GroupsMinimumRequirements',1,'',NULL,'N;'),
('GroupsReadOnlyAccess',1,'',NULL,'N;'),
('GroupsSearch',0,'',NULL,'N;'),
('GroupsUpdate',0,'',NULL,'N;'),
('GroupsUpdateAccess',1,'',NULL,'N;'),
('GroupsView',0,'',NULL,'N;'),
('GroupsQuickView',0,'',NULL,'N;'),
('guest',2,'Guest user','return Yii::app()->user->isGuest;','N;'),
('GuestSiteFunctionsTask',1,'A set of permissions required for guests to be able to log in and see the website.',NULL,'N;'),
('LeadRoutingTask',1,'A set of operations for configuring lead distribution.',NULL,'N;'),
('MarketingAdmin',0,'',NULL,'N;'),
('MarketingAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('MarketingAdminAccess',1,'',NULL,'N;'),
('MarketingAnonContactIndex',0,'',NULL,'N;'),
('MarketingAnonContactView',0,'',NULL,'N;'),
('MarketingAnonContactDelete',0,'',NULL,'N;'),
('MarketingFingerprintIndex',0,'',NULL,'N;'),
('MarketingBasicAccess',1,'',NULL,'N;'),
('MarketingBasicPrivate',1,'Control their own records','return $this->checkAssignment($params);','N;'),
('MarketingDeleteWebForm',0,'',NULL,'N;'),
('MarketingClick',0,'',NULL,'N;'),
('MarketingDoNotEmailLinkClick',0,'',NULL,'N;'),
('MarketingComplete',0,'',NULL,'N;'),
('MarketingCreate',0,'',NULL,'N;'),
('MarketingCreateFromTag',0,'',NULL,'N;'),
('MarketingDelete',0,'',NULL,'N;'),
('MarketingDeleteNote',0,'',NULL,'N;'),
('MarketingDeletePrivate',1,'Delete their own records','return $this->checkAssignment($params);','N;'),
('MarketingFullAccess',1,'',NULL,'N;'),
('MarketingGetItems',0,'',NULL,'N;'),
('MarketingGetX2ModelInput',0,'',NULL,'N;'),
('MarketingIndex',0,'',NULL,'N;'),
('MarketingLaunch',0,'',NULL,'N;'),
('MarketingMailIndividual',0,'The AJAX action that sends mails in a batch sequence, one at a time.',NULL,'N;'),
('MarketingMinimumRequirements',1,'',NULL,'N;'),
('MarketingPrivateBasicAccess',1,'',NULL,'N;'),
('MarketingPrivateFullAccess',1,'',NULL,'N;'),
('MarketingPrivateReadOnlyAccess',1,'',NULL,'N;'),
('MarketingPrivateUpdateAccess',1,'',NULL,'N;'),
('MarketingReadOnlyAccess',1,'',NULL,'N;'),
('MarketingSearch',0,'',NULL,'N;'),
('MarketingToggle',0,'',NULL,'N;'),
('MarketingUpdate',0,'',NULL,'N;'),
('MarketingUpdateAccess',1,'',NULL,'N;'),
('MarketingUpdatePrivate',1,'Update their own records','return $this->checkAssignment($params);','N;'),
('MarketingValidate',0,'',NULL,'N;'),
('MarketingView',0,'',NULL,'N;'),
('MarketingQuickView',0,'',NULL,'N;'),
('MarketingViewPrivate',1,'View their own records','return $this->checkAssignment($params);','N;'),
('MarketingWebLeadForm',0,'Edit the lead capture form.',NULL,'N;'),
('MarketingWebTracker',0,'View embed code for web tracker.',NULL,'N;'),
('MarketingExportWebTracker',0,'Export code for web tracker.',NULL,'N;'),
('MarketingRemoveWebLeadFormCustomHtml',0,'View embed code for web tracker.',NULL,'N;'),
('MarketingSaveWebLeadFormCustomHtml',0,'View embed code for web tracker.',NULL,'N;'),
('MarketingGetCampaignChartData',0,'View embed code for web tracker.',NULL,'N;'),
('MediaAdmin',0,'',NULL,'N;'),
('MediaAdminAccess',1,'',NULL,'N;'),
('MediaBasicAccess',1,'',NULL,'N;'),
('MediaDelete',0,'',NULL,'N;'),
('MediaDeleteNote',0,'',NULL,'N;'),
('MediaDownload',0,'',NULL,'N;'),
('MediaFullAccess',1,'',NULL,'N;'),
('MediaIndex',0,'',NULL,'N;'),
('MediaMinimumRequirements',1,'',NULL,'N;'),
('MediaReadOnlyAccess',1,'',NULL,'N;'),
('MediaSearch',0,'',NULL,'N;'),
('MediaToggleUserMediaVisible',0,'',NULL,'N;'),
('MediaUpdate',0,'',NULL,'N;'),
('MediaUpdateAccess',1,'',NULL,'N;'),
('MediaUpload',0,'',NULL,'N;'),
('MediaCreate',0,'',NULL,'N;'),
('MediaView',0,'',NULL,'N;'),
('MediaQuickView',0,'',NULL,'N;'),
('MediaRecursiveDriveFiles',0,'',NULL,'N;'),
('MediaRefreshDriveCache',0,'',NULL,'N;'),
('MediaQtip',0,'',NULL,'N;'),
('MediaMediaSelector',0,'',NULL,'N;'),
('MediaGetFile',0,'',NULL,'N;'),
('OpportunitiesAddContact',0,'',NULL,'N;'),
('OpportunitiesAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('OpportunitiesAddUser',0,'',NULL,'N;'),
('OpportunitiesAdmin',0,'',NULL,'N;'),
('OpportunitiesAdminAccess',1,'',NULL,'N;'),
('OpportunitiesBasicAccess',1,'',NULL,'N;'),
('OpportunitiesCreate',0,'',NULL,'N;'),
('OpportunitiesDelete',0,'',NULL,'N;'),
('OpportunitiesDeleteNote',0,'',NULL,'N;'),
('OpportunitiesDeletePrivate',1,'Delete their own records','return $this->checkAssignment($params);','N;'),
('OpportunitiesFullAccess',1,'',NULL,'N;'),
('OpportunitiesGetItems',0,'',NULL,'N;'),
('OpportunitiesGetTerms',0,'',NULL,'N;'),
('OpportunitiesGetX2ModelInput',0,'',NULL,'N;'),
('OpportunitiesIndex',0,'',NULL,'N;'),
('OpportunitiesMinimumRequirements',1,'',NULL,'N;'),
('OpportunitiesQtip',0,'',NULL,'N;'),
('OpportunitiesPrivateReadOnlyAccess',1,'',NULL,'N;'),
('OpportunitiesPrivateUpdateAccess',1,'',NULL,'N;'),
('OpportunitiesReadOnlyAccess',1,'',NULL,'N;'),
('OpportunitiesRemoveContact',0,'',NULL,'N;'),
('OpportunitiesRemoveUser',0,'',NULL,'N;'),
('OpportunitiesSearch',0,'',NULL,'N;'),
('OpportunitiesShareOpportunity',0,'',NULL,'N;'),
('OpportunitiesUpdate',0,'',NULL,'N;'),
('OpportunitiesUpdateAccess',1,'',NULL,'N;'),
('OpportunitiesUpdatePrivate',1,'Update their own records','return $this->checkAssignment($params);','N;'),
('OpportunitiesView',0,'',NULL,'N;'),
('OpportunitiesQuickView',0,'',NULL,'N;'),
('OpportunitiesViewPrivate',1,'View their own record','return $this->checkAssignment($params);','N;'),
('X2LeadsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('X2LeadsConvertLead',0,'',NULL,'N;'),
('X2LeadsAdmin',0,'',NULL,'N;'),
('X2LeadsAdminAccess',1,'',NULL,'N;'),
('X2LeadsBasicAccess',1,'',NULL,'N;'),
('X2LeadsCreate',0,'',NULL,'N;'),
('X2LeadsDelete',0,'',NULL,'N;'),
('X2LeadsDeleteNote',0,'',NULL,'N;'),
('X2LeadsDeletePrivate',1,'Delete their own records','return $this->checkAssignment($params);','N;'),
('X2LeadsFullAccess',1,'',NULL,'N;'),
('X2LeadsGetItems',0,'',NULL,'N;'),
('X2LeadsGetTerms',0,'',NULL,'N;'),
('X2LeadsGetX2ModelInput',0,'',NULL,'N;'),
('X2LeadsIndex',0,'',NULL,'N;'),
('X2LeadsMinimumRequirements',1,'',NULL,'N;'),
('X2LeadsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('X2LeadsPrivateUpdateAccess',1,'',NULL,'N;'),
('X2LeadsReadOnlyAccess',1,'',NULL,'N;'),
('X2LeadsSearch',0,'',NULL,'N;'),
('X2LeadsUpdate',0,'',NULL,'N;'),
('X2LeadsUpdateAccess',1,'',NULL,'N;'),
('X2LeadsUpdatePrivate',1,'Update their own records','return $this->checkAssignment($params);','N;'),
('X2LeadsView',0,'',NULL,'N;'),
('X2LeadsQuickView',0,'',NULL,'N;'),
('X2LeadsViewPrivate',1,'View their own record','return $this->checkAssignment($params);','N;'),
('X2LeadsPrivateFullAccess',1,'',NULL,'N;'),
('OpportunitiesPrivateFullAccess',1,'',NULL,'N;'),
('ProductsAdmin',0,'',NULL,'N;'),
('ProductsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('ProductsAdminAccess',1,'',NULL,'N;'),
('ProductsBasicAccess',1,'',NULL,'N;'),
('ProductsCreate',0,'',NULL,'N;'),
('ProductsDelete',0,'',NULL,'N;'),
('ProductsDeleteNote',0,'',NULL,'N;'),
('ProductsDeletePrivate',1,'Delete their own records','return $this->checkAssignment($params);','N;'),
('ProductsFullAccess',1,'',NULL,'N;'),
('ProductsGetItems',0,'',NULL,'N;'),
('ProductsGetItems2',0,'',NULL,'N;'),
('ProductsGetX2ModelInput',0,'',NULL,'N;'),
('ProductsIndex',0,'',NULL,'N;'),
('ProductsMinimumRequirements',1,'',NULL,'N;'),
('ProductsPrivateFullAccess',1,'',NULL,'N;'),
('ProductsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('ProductsPrivateUpdateAccess',1,'',NULL,'N;'),
('ProductsReadOnlyAccess',1,'',NULL,'N;'),
('ProductsSearch',0,'',NULL,'N;'),
('ProductsUpdate',0,'',NULL,'N;'),
('ProductsUpdateAccess',1,'',NULL,'N;'),
('ProductsUpdatePrivate',1,'Update their own records','return $this->checkAssignment($params);','N;'),
('ProductsView',0,'',NULL,'N;'),
('ProductsQuickView',0,'',NULL,'N;'),
('ProductsViewPrivate',1,'View their own records','return $this->checkAssignment($params);','N;'),
('QuotesAddContact',0,'',NULL,'N;'),
('QuotesAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('QuotesAddProduct',0,'',NULL,'N;'),
('QuotesAddUser',0,'',NULL,'N;'),
('QuotesAdmin',0,'',NULL,'N;'),
('QuotesAdminAccess',1,'',NULL,'N;'),
('QuotesBasicAccess',1,'',NULL,'N;'),
('QuotesCreate',0,'',NULL,'N;'),
('QuotesDelete',0,'',NULL,'N;'),
('QuotesDeleteNote',0,'',NULL,'N;'),
('QuotesDeletePrivate',1,'Delete their own records','return $this->checkAssignment($params);','N;'),
('QuotesDeleteProduct',0,'',NULL,'N;'),
('QuotesFullAccess',1,'',NULL,'N;'),
('QuotesGetItems',0,'',NULL,'N;'),
('QuotesGetTerms',0,'',NULL,'N;'),
('QuotesGetX2ModelInput',0,'',NULL,'N;'),
('QuotesIndex',0,'',NULL,'N;'),
('QuotesMinimumRequirements',1,'',NULL,'N;'),
('QuotesPrint',0,'',NULL,'N;'),
('QuotesPrivateFullAccess',1,'',NULL,'N;'),
('QuotesPrivateReadOnlyAccess',1,'',NULL,'N;'),
('QuotesPrivateUpdateAccess',1,'',NULL,'N;'),
('QuotesQuickCreate',0,'',NULL,'N;'),
('QuotesQuickDelete',0,'',NULL,'N;'),
('QuotesQuickUpdate',0,'',NULL,'N;'),
('QuotesReadOnlyAccess',1,'',NULL,'N;'),
('QuotesRemoveContact',0,'',NULL,'N;'),
('QuotesRemoveUser',0,'',NULL,'N;'),
('QuotesSearch',0,'',NULL,'N;'),
('QuotesShareQuote',0,'',NULL,'N;'),
('QuotesUpdate',0,'',NULL,'N;'),
('QuotesUpdateAccess',1,'',NULL,'N;'),
('QuotesUpdatePrivate',1,'Update their own records','return $this->checkAssignment($params);',
'N;'),
('QuotesView',0,'',NULL,'N;'),
('QuotesQuickView',0,'',NULL,'N;'),
('QuotesViewInline',0,'',NULL,'N;'),
('QuotesViewPrivate',1,'View their own record','return $this->checkAssignment($params);','N;'),
('ReportsGetItems',0,'',NULL,'N;'),
('ReportsActivityReport',0,'',NULL,'N;'),
('ReportsChartDashboard',0,'',NULL,'N;'),
('ReportsViewChart',0,'',NULL,'N;'),
('ReportsCloneChart',0,'',NULL,'N;'),
('ReportsAddToDashboard',0,'',NULL,'N;'),
('ReportsCreateChart',0,'',NULL,'N;'),
('ReportsFetchData',0,'',NULL,'N;'),
('ReportsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('ReportsAdmin',0,'',NULL,'N;'),
('ReportsAdminAccess',1,'',NULL,'N;'),
('ReportsDealReport',0,'',NULL,'N;'),
('ReportsDelete',0,'',NULL,'N;'),
('ReportsDeleteNote',0,'',NULL,'N;'),
('ReportsReadOnlyAccess',1,'',NULL,'N;'),
('ReportsGetOptions',0,'',NULL,'N;'),
('ReportsGetX2ModelInput',0,'',NULL,'N;'),
('ReportsGridReport',0,'',NULL,'N;'),
('ReportsIndex',0,'',NULL,'N;'),
('ReportsLeadPerformance',0,'',NULL,'N;'),
('ReportsMinimumRequirements',1,'',NULL,'N;'),
('ReportsPrintReport',0,'',NULL,'N;'),
('ReportsSavedReports',0,'',NULL,'N;'),
('ReportsSaveReport',0,'',NULL,'N;'),
('ReportsSaveTempImage',0,'',NULL,'N;'),
('ReportsSearch',0,'',NULL,'N;'),
('ReportsWorkflow',0,'',NULL,'N;'),
('ReportsView',0,'',NULL,'N;'),
('ReportsQuickView',0,'',NULL,'N;'),
('ReportsCopy',0,'',NULL,'N;'),
('ReportsUpdate',0,'',NULL,'N;'),
('ReportsRowsAndColumnsReport',0,'',NULL,'N;'),
('ReportsSummationReport',0,'',NULL,'N;'),
('ReportsExternalReport',0,'',NULL,'N;'),
('ReportsPrintChart',0,'',NULL,'N;'),
('ReportsCallChartFunction',0,'',NULL,'N;'),
('RoleAccessTask',1,'A set of operations for managing roles.',NULL,'N;'),
('ServicesAdmin',0,'',NULL,'N;'),
('ServicesAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('ServicesAdminAccess',1,'',NULL,'N;'),
('ServicesBasicAccess',1,'',NULL,'N;'),
('ServicesCreate',0,'',NULL,'N;'),
('ServicesDelete',0,'',NULL,'N;'),
('ServicesDeleteNote',0,'',NULL,'N;'),
('ServicesDeletePrivate',1,'Delete their own records.','return $this->checkAssignment($params);','N;'),
('ServicesFullAccess',1,'',NULL,'N;'),
('ServicesGetItems',0,'',NULL,'N;'),
('ServicesGetX2ModelInput',0,'',NULL,'N;'),
('ServicesIndex',0,'',NULL,'N;'),
('ServicesMinimumRequirements',1,'',NULL,'N;'),
('ServicesPrivateFullAccess',1,'',NULL,'N;'),
('ServicesPrivateReadOnlyAccess',1,'',NULL,'N;'),
('ServicesPrivateUpdateAccess',1,'',NULL,'N;'),
('ServicesReadOnlyAccess',1,'',NULL,'N;'),
('ServicesSearch',0,'',NULL,'N;'),
('ServicesUpdate',0,'',NULL,'N;'),
('ServicesUpdateAccess',1,'',NULL,'N;'),
('ServicesUpdatePrivate',1,'Update their own records','return $this->checkAssignment($params);','N;'),
('ServicesView',0,'',NULL,'N;'),
('ServicesQuickView',0,'',NULL,'N;'),
('ServicesViewPrivate',1,'View their own records','return $this->checkAssignment($params);','N;'),
('ServicesCreateWebForm',0,'Edit the web form.',NULL,'N;'),
('ServicesServicesReport',0,'',NULL,'N;'),
('ServicesExportServiceReport',0,'',NULL,'N;'),
('TopicsMobileIndex',0,'',NULL,'N;'),
('TopicsMobileView',0,'',NULL,'N;'),
('TopicsMobileDelete',0,'',NULL,'N;'),
('TopicsMobileCreate',0,'',NULL,'N;'),
('TopicsMobileUpdate',0,'',NULL,'N;'),
('TopicsMobileUpdateReply',0,'',NULL,'N;'),
('TopicsMobileDeleteReply',0,'',NULL,'N;'),
('TopicsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('TopicsAdmin',0,'',NULL,'N;'),
('TopicsAdminAccess',1,'',NULL,'N;'),
('TopicsBasicAccess',1,'',NULL,'N;'),
('TopicsCreate',0,'',NULL,'N;'),
('TopicsDelete',0,'',NULL,'N;'),
('TopicsDeleteNote',0,'',NULL,'N;'),
('TopicsDeletePrivate',1,'Delete their own records','return $this->checkAssignment($params);','N;'),
('TopicsFullAccess',1,'',NULL,'N;'),
('TopicsGetItems',0,'',NULL,'N;'),
('TopicsGetTerms',0,'',NULL,'N;'),
('TopicsGetX2ModelInput',0,'',NULL,'N;'),
('TopicsIndex',0,'',NULL,'N;'),
('TopicsInlineEmail',0,'',NULL,'N;'),
('TopicsMinimumRequirements',1,'',NULL,'N;'),
('TopicsQtip',0,'',NULL,'N;'),
('TopicsX2GridViewMassAction',0,'',NULL,'N;'),
('TopicsPrivateFullAccess',1,'',NULL,'N;'),
('TopicsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('TopicsPrivateUpdateAccess',1,'',NULL,'N;'),
('TopicsReadOnlyAccess',1,'',NULL,'N;'),
('TopicsSearch',0,'',NULL,'N;'),
('TopicsUpdate',0,'',NULL,'N;'),
('TopicsUpdateAccess',1,'',NULL,'N;'),
('TopicsUpdatePrivate',1,'Update their own records','return $this->checkAssignment($params);','N;'),
('TopicsView',0,'',NULL,'N;'),
('TopicsQuickView',0,'',NULL,'N;'),
('TopicsViewPrivate',1,'View their own record','return $this->checkAssignment($params);','N;'),
('TopicsNewReply',0,'',NULL,'N;'),
('TopicsUpdateReply',0,'',NULL,'N;'),
('TopicsDeleteReply',0,'',NULL,'N;'),
('TopicsPinUnpinTopic',0,'',NULL,'N;'),
('SiteIndex',0,'Index of SiteController.',NULL,'N;'),
('SiteLogin',0,'Log in to the software.',NULL,'N;'),
('SiteLogout',0,'Logout out of the software.',NULL,'N;'),
('SiteToggleVisibility',0,'Toglge visible/invisible user status.',NULL,'N;'),
('SiteWhatsNew',0,'What\'s New page of the app.',NULL,'N;'),
('TranslationsTask',1,'A set of permissions required to access translation features.',NULL,'N;'),
('UsersAddTopContact',0,'',NULL,'N;'),
('UsersAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('UsersAdmin',0,'',NULL,'N;'),
('UsersAdminAccess',1,'',NULL,'N;'),
('UsersBasicAccess',1,'',NULL,'N;'),
('UsersCreate',0,'',NULL,'N;'),
('UsersCreateAccount',0,'',NULL,'N;'),
('UsersDelete',0,'',NULL,'N;'),
('UsersDeleteNote',0,'',NULL,'N;'),
('UsersFullAccess',1,'',NULL,'N;'),
('UsersGetX2ModelInput',0,'',NULL,'N;'),
('UsersIndex',0,'',NULL,'N;'),
('UsersDeactivateTwoFactor',0,'',NULL,'N;'),
('UsersInviteUsers',0,'',NULL,'N;'),
('UsersMinimumRequirements',1,'',NULL,'N;'),
('UsersReadOnlyAccess',1,'',NULL,'N;'),
('UsersRemoveTopContact',0,'',NULL,'N;'),
('UsersSearch',0,'',NULL,'N;'),
('UsersUpdate',0,'',NULL,'N;'),
('UsersUpdateAccess',1,'',NULL,'N;'),
('UsersView',0,'',NULL,'N;'),
('UsersQuickView',0,'',NULL,'N;'),
('UsersUserMap',0,'',NULL,'N;'),
('WeblistCreate',0,'',NULL,'N;'),
('WeblistAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('WeblistRemoveFromList', 0, '', NULL, 'N;'),
('WeblistDelete',0,'',NULL,'N;'),
('WeblistIndex',0,'',NULL,'N;'),
('WeblistUpdate',0,'',NULL,'N;'),
('WeblistView',0,'',NULL,'N;'),
('WeblistQuickView',0,'',NULL,'N;'),
('WeblistGetX2ModelInput',0,'',NULL,'N;'),
('WorkflowAdmin',0,'',NULL,'N;'),
('WorkflowAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('WorkflowAdminAccess',1,'',NULL,'N;'),
('WorkflowBasicAccess',1,'',NULL,'N;'),
('WorkflowCompleteStage',0,'',NULL,'N;'),
('WorkflowCreate',0,'',NULL,'N;'),
('WorkflowDelete',0,'',NULL,'N;'),
('WorkflowDeleteNote',0,'',NULL,'N;'),
('WorkflowFullAccess',1,'',NULL,'N;'),
('WorkflowGetStageDetails',0,'',NULL,'N;'),
('WorkflowGetStageMembers',0,'',NULL,'N;'),
('WorkflowGetStages',0,'',NULL,'N;'),
('WorkflowGetWorkflow',0,'',NULL,'N;'),
('WorkflowGetX2ModelInput',0,'',NULL,'N;'),
('WorkflowIndex',0,'',NULL,'N;'),
('WorkflowMinimumRequirements',1,'',NULL,'N;'),
('WorkflowReadOnlyAccess',1,'',NULL,'N;'),
('WorkflowMoveFromStageAToStageB',0,'',NULL,'N;'),
('WorkflowChangeUI',0,'',NULL,'N;'),
('WorkflowAjaxAddADeal',0,'',NULL,'N;'),
('WorkflowGetItems',0,'',NULL,'N;'),
('WorkflowGetStageNames',0,'',NULL,'N;'),
('WorkflowGetStageNameItems',0,'',NULL,'N;'),
('WorkflowRevertStage',0,'',NULL,'N;'),
('WorkflowSearch',0,'',NULL,'N;'),
('WorkflowStartStage',0,'',NULL,'N;'),
('WorkflowUpdate',0,'',NULL,'N;'),
('WorkflowUpdateAccess',1,'',NULL,'N;'),
('WorkflowUpdateStageDetails',0,'',NULL,'N;'),
('WorkflowView',0,'',NULL,'N;'),
('WorkflowQuickView',0,'',NULL,'N;'),
('WorkflowViewStage',0,'',NULL,'N;'),
('WorkflowGetStageValue',0,'',NULL,'N;'),
('WorkflowGetFinancialFields',0,'',NULL,'N;'),
('X2StudioTask',1,'A set of permissions for the use of X2Studio.',NULL,'N;'),
('AdminCalculateTranslationRedundancy',0,'',NULL,'N;'),
('AdminFindMissingPermissions',0,'',NULL,'N;'),
('AdminGetWorkflowStages',0,'',NULL,'N;'),
('AdminGetRole',0,'',NULL,'N;'),
('AdminDeleteCriteria',0,'',NULL,'N;'),
('AdminDeleteRouting',0,'',NULL,'N;'),
('AdminGetAttributes',0,'',NULL,'N;'),
('AdminActivitySettings',0,'',NULL,'N;'),
('AdminSetServiceRouting',0,'',NULL,'N;'),
('AdminValidateField',0,'',NULL,'N;'),
('AdminRemoveField',0,'',NULL,'N;'),
('AdminGetFieldData',0,'',NULL,'N;'),
('AdminViewPage',0,'',NULL,'N;'),
('AdminRegisterModules',0,'',NULL,'N;'),
('AdminToggleModule',0,'',NULL,'N;'),
('AdminCreateFormLayout',0,'',NULL,'N;'),
('AdminDeleteFormLayout',0,'',NULL,'N;'),
('AdminGetDropdown',0,'',NULL,'N;'),
('AdminGetFieldType',0,'',NULL,'N;'),
('AdminDelete',0,'',NULL,'N;'),
('AdminInstallUpdate',0,'',NULL,'N;'),
('AdminCleanUp',0,'',NULL,'N;'),
('AdminViewLogs',0,'',NULL,'N;'),
('AdminAuthGraph',0,'',NULL,'N;'),
('AdminFlowDesigner',0,'',NULL,'N;'),
('AdminGetRoutingType',0,'',NULL,'N;'),
('ActionsViewEmail',0,'',NULL,'N;'),
('ActionsEmailOpened',0,'',NULL,'N;'),
('CalendarList',0,'',NULL,'N;'),
('ContactsRevisions',0,'',NULL,'N;'),
('ContactsSyncAccount',0,'',NULL,'N;'),
('ContactsGoogleMaps',0,'',NULL,'N;'),
('ContactsSaveMap',0,'',NULL,'N;'),
('ContactsSavedMaps',0,'',NULL,'N;'),
('ContactsDeleteMap',0,'',NULL,'N;'),
('ContactsUpdateLocation',0,'',NULL,'N;'),
('ContactsCleanFailedLeads',0,'',NULL,'N;'),
('ContactsWeblead',0,'',NULL,'N;'),
('MarketingViewContent',0,'',NULL,'N;'),
('WeblistWeblist',0,'',NULL,'N;'),
('WeblistDeleteNote',0,'',NULL,'N;'),
('WeblistSearch',0,'',NULL,'N;'),
('MediaAjaxUpload',0,'',NULL,'N;'),
('MediaAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('MediaGetItems',0,'',NULL,'N;'),
('MediaGetX2ModelInput',0,'',NULL,'N;'),
('QuotesIndexInvoice',0,'',NULL,'N;'),
('QuotesConvertToInvoice',0,'',NULL,'N;'),
('ServicesWebForm',0,'',NULL,'N;'),
('ServicesStatusFilter',0,'',NULL,'N;'),
('UsersDeleteTemporary',0,'',NULL,'N;'),
('BugReportsIndex',0,'',NULL,'N;'),
('BugReportsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('BugReportsAdmin',0,'',NULL,'N;'),
('BugReportsView',0,'',NULL,'N;'),
('BugReportsQuickView',0,'',NULL,'N;'),
('BugReportsCreate',0,'',NULL,'N;'),
('BugReportsUpdate',0,'',NULL,'N;'),
('BugReportsDelete',0,'',NULL,'N;'),
('BugReportsGetItems',0,'',NULL,'N;'),
('BugReportsGetX2ModelInput',0,'',NULL,'N;'),
('BugReportsStatusFilter',0,'',NULL,'N;'),
('BugReportsDeleteNote',0,'',NULL,'N;'),
('BugReportsSearch',0,'',NULL,'N;'),
('BugReportsMinimumRequirements',1,'',NULL,'N;'),
('BugReportsReadOnlyAccess',1,'',NULL,'N;'),
('BugReportsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('BugReportsBasicAccess',1,'',NULL,'N;'),
('BugReportsPrivateUpdateAccess',1,'',NULL,'N;'),
('BugReportsUpdateAccess',1,'',NULL,'N;'),
('BugReportsFullAccess',1,'',NULL,'N;'),
('BugReportsPrivateFullAccess',1,'',NULL,'N;'),
('BugReportsAdminAccess',1,'',NULL,'N;'),
('BugReportsViewPrivate',1,'','return $this->checkAssignment($params);','N;'),
('BugReportsUpdatePrivate',1,'','return $this->checkAssignment($params);','N;'),
('BugReportsDeletePrivate',1,'','return $this->checkAssignment($params);','N;');
/*&*/
INSERT INTO `x2_auth_item_child` (`parent`,`child`) VALUES
('ContactsView', 'ContactsMobileActionHistoryPublish'),
('AccountsView', 'AccountsMobileActionHistoryPublish'),
('OpportunitiesView', 'OpportunitiesMobileActionHistoryPublish'),
('ProductsView', 'ProductsMobileActionHistoryPublish'),
('ServicesView', 'ServicesMobileActionHistoryPublish'),
('X2LeadsView', 'X2LeadsMobileActionHistoryPublish'),
('BugReportsView', 'BugReportsMobileActionHistoryPublish'),
('ContactsView', 'ContactsMobileActionHistoryAttachmentsPublish'),
('AccountsView', 'AccountsMobileActionHistoryAttachmentsPublish'),
('OpportunitiesView', 'OpportunitiesMobileActionHistoryAttachmentsPublish'),
('ProductsView', 'ProductsMobileActionHistoryAttachmentsPublish'),
('ServicesView', 'ServicesMobileActionHistoryAttachmentsPublish'),
('X2LeadsView', 'X2LeadsMobileActionHistoryAttachmentsPublish'),
('BugReportsView', 'BugReportsMobileActionHistoryAttachmentsPublish'),
('AccountsDelete','AccountsMobileDelete'),
('ActionsDelete','ActionsMobileDelete'),
('ContactsDelete','ContactsMobileDelete'),
('OpportunitiesDelete','OpportunitiesMobileDelete'),
('ProductsDelete','ProductsMobileDelete'),
('ServicesDelete','ServicesMobileDelete'),
('UsersDelete','UsersMobileDelete'),
('X2LeadsDelete','X2LeadsMobileDelete'),
('BugReportsDelete','BugReportsMobileDelete'),
('AccountsUpdate','AccountsMobileUpdate'),
('AccountsUpdatePrivate','AccountsMobileUpdate'),
('AccountsCreate','AccountsMobileCreate'),
('ContactsUpdate','ContactsMobileUpdate'),
('ContactsUpdatePrivate','ContactsMobileUpdate'),
('ContactsCreate','ContactsMobileCreate'),
('OpportunitiesUpdate','OpportunitiesMobileUpdate'),
('OpportunitiesUpdatePrivate','OpportunitiesMobileUpdate'),
('OpportunitiesCreate','OpportunitiesMobileCreate'),
('ProductsUpdate','ProductsMobileUpdate'),
('ProductsUpdatePrivate','ProductsMobileUpdate'),
('ProductsCreate','ProductsMobileCreate'),
('QuotesUpdate','QuotesMobileUpdate'),
('QuotesUpdatePrivate','QuotesMobileUpdate'),
('QuotesCreate','QuotesMobileCreate'),
('ServicesUpdate','ServicesMobileUpdate'),
('ServicesUpdatePrivate','ServicesMobileUpdate'),
('ServicesCreate','ServicesMobileCreate'),
('UsersUpdate','UsersMobileUpdate'),
('UsersCreate','UsersMobileCreate'),
('X2LeadsUpdate','X2LeadsMobileUpdate'),
('X2LeadsUpdatePrivate','X2LeadsMobileUpdate'),
('X2LeadsCreate','X2LeadsMobileCreate'),
('BugReportsUpdate','BugReportsMobileUpdate'),
('BugReportsUpdatePrivate','BugReportsMobileUpdate'),
('BugReportsCreate','BugReportsMobileCreate'),
('AccountsUpdateAccess','AccountsAddUser'),
('AccountsUpdatePrivate','AccountsAddUser'),
('AccountsAdminAccess','AccountsAdmin'),
('administrator','AccountsAdminAccess'),
('administrator','AccountsFullAccess'),
('administrator','AccountsUpdateAccess'),
('administrator','AccountsBasicAccess'),
('administrator','AccountsReadOnlyAccess'),
('AccountsPrivateUpdateAccess','AccountsMinimumRequirements'),
('AccountsUpdateAccess','AccountsMinimumRequirements'),
('AccountsBasicAccess','AccountsCreate'),
('AccountsReadOnlyAccess', 'AccountsInlineEmail'),
('AccountsPrivateReadOnlyAccess', 'AccountsInlineEmail'),
('AccountsIndex','AccountsAjaxGetModelAutocomplete'),
('AccountsIndex', 'AccountsX2GridViewMassAction'),
('AccountsIndex', 'AccountsMobileIndex'),
('AccountsDeletePrivate','AccountsDelete'),
('AccountsFullAccess','AccountsDelete'),
('AccountsFullAccess','AccountsDeleteNote'),
('AccountsPrivateFullAccess','AccountsDeleteNote'),
('AccountsPrivateFullAccess','AccountsDeletePrivate'),
('AccountsAdminAccess','AccountsMinimumRequirements'),
('AccountsMinimumRequirements','AccountsGetItems'),
('AccountsMinimumRequirements','AccountsIndex'),
('AccountsPrivateReadOnlyAccess','AccountsMinimumRequirements'),
('AccountsReadOnlyAccess','AccountsMinimumRequirements'),
('AccountsPrivateFullAccess','AccountsMinimumRequirements'),
('AccountsBasicAccess','AccountsMinimumRequirements'),
('AccountsUpdateAccess','AccountsRemoveUser'),
('AccountsUpdatePrivate','AccountsRemoveUser'),
('AccountsMinimumRequirements','AccountsSearch'),
('AccountsReadOnlyAccess','AccountsShareAccount'),
('AccountsViewPrivate','AccountsShareAccount'),
('AccountsUpdateAccess','AccountsUpdate'),
('AccountsUpdateAccess','AccountsGetX2ModelInput'),
('AccountsPrivateUpdateAccess','AccountsGetX2ModelInput'),
('AccountsUpdatePrivate','AccountsUpdate'),
('AccountsFullAccess','AccountsMinimumRequirements'),
('DefaultRole','AccountsUpdateAccess'),
('DefaultRole','AccountsBasicAccess'),
('DefaultRole','AccountsReadOnlyAccess'),
('AccountsPrivateUpdateAccess','AccountsUpdatePrivate'),
('AccountsReadOnlyAccess','AccountsView'),
('AccountsView', 'AccountsMobileView'),
('AccountsReadOnlyAccess','AccountsQuickView'),
('AccountsViewPrivate','AccountsView'),
('AccountsViewPrivate','AccountsQuickView'),
('AccountsPrivateReadOnlyAccess','AccountsViewPrivate'),
('AccountsMinimumRequirements','AccountsQtip'),
('ActionsAdminAccess','ActionsAdmin'),
('administrator','ActionsAdminAccess'),
('administrator','ActionsFullAccess'),
('administrator','ActionsUpdateAccess'),
('administrator','ActionsBasicAccess'),
('administrator','ActionsReadOnlyAccess'),
('ActionsPrivateUpdateAccess','ActionsMinimumRequirements'),
('ActionsUpdateAccess','ActionsMinimumRequirements'),
('ActionsUpdateAccess','ActionsComplete'),
('ActionsReadOnlyAccess','ActionsViewAction'),
('ActionsUpdatePrivate','ActionsComplete'),
('ActionsViewPrivate','ActionsViewAction'),
('ActionsReadOnlyAccess','ActionsCompleteSelected'),
('ActionsViewPrivate','ActionsCompleteSelected'),
('ActionsBasicAccess','ActionsCreate'),
('ActionsBasicAccess','ActionsCopyEvent'),
('ActionsReadOnlyAccess', 'ActionsInlineEmail'),
('ActionsPrivateReadOnlyAccess', 'ActionsInlineEmail'),
('ActionsIndex','ActionsAjaxGetModelAutocomplete'),
('ActionsIndex', 'ActionsX2GridViewMassAction'),
('ActionsIndex','ActionsGetItems'),
('ActionsDeletePrivate','ActionsDelete'),
('ActionsFullAccess','ActionsDelete'),
('ActionsFullAccess','ActionsDeleteNote'),
('ActionsPrivateFullAccess','ActionsDeleteNote'),
('ActionsPrivateFullAccess','ActionsDeletePrivate'),
('ActionsAdminAccess','ActionsMinimumRequirements'),
('ActionsMinimumRequirements','ActionsGetAutocompleteAssocLink'),
('ActionsMinimumRequirements','ActionsGetTerms'),
('ActionsMinimumRequirements','ActionsIndex'),
('ActionsMinimumRequirements','ActionsInvalid'),
('ActionsPrivateReadOnlyAccess','ActionsMinimumRequirements'),
('ActionsReadOnlyAccess','ActionsMinimumRequirements'),
('ActionsMinimumRequirements','ActionsParseType'),
('ActionsPrivateFullAccess','ActionsMinimumRequirements'),
('ActionsBasicAccess','ActionsPublisherCreate'),
('GuestSiteFunctionsTask','ActionsPublisherCreate'),
('ActionsUpdateAccess','ActionsQuickUpdate'),
('ActionsUpdateAccess','ActionsToggleSticky'),
('ActionsUpdatePrivate','ActionsQuickUpdate'),
('ActionsUpdatePrivate','ActionsToggleSticky'),
('ActionsBasicAccess','ActionsMinimumRequirements'),
('ActionsMinimumRequirements','ActionsSaveShowActions'),
('ActionsMinimumRequirements','ActionsSearch'),
('GuestSiteFunctionsTask','ActionsSendReminder'),
('GuestSiteFunctionsTask','ActionsViewEmail'),
('GuestSiteFunctionsTask','CalendarEventRsvp'),
('ActionsReadOnlyAccess','ActionsSendReminder'),
('ActionsViewPrivate','ActionsSendReminder'),
('ActionsReadOnlyAccess','ActionsShareAction'),
('ActionsViewPrivate','ActionsShareAction'),
('ActionsPublisherCreate','ActionsTimerControl'),
('ActionsReadOnlyAccess','ActionsTomorrow'),
('ActionsViewPrivate','ActionsTomorrow'),
('ActionsReadOnlyAccess','ActionsUncomplete'),
('ActionsViewPrivate','ActionsUncomplete'),
('ActionsReadOnlyAccess','ActionsUncompleteSelected'),
('ActionsViewPrivate','ActionsUncompleteSelected'),
('ActionsUpdateAccess','ActionsUpdate'),
('ActionsUpdateAccess','ActionsGetX2ModelInput'),
('ActionsPrivateUpdateAccess','ActionsGetX2ModelInput'),
('ActionsUpdatePrivate','ActionsUpdate'),
('ActionsFullAccess','ActionsMinimumRequirements'),
('DefaultRole','ActionsPrivateFullAccess'),
('DefaultRole','ActionsUpdateAccess'),
('DefaultRole','ActionsBasicAccess'),
('DefaultRole','ActionsReadOnlyAccess'),
('ActionsPrivateUpdateAccess','ActionsUpdatePrivate'),
('ActionsReadOnlyAccess','ActionsView'),
('ActionsReadOnlyAccess','ActionsQuickView'),
('ActionsViewPrivate','ActionsView'),
('ActionsViewPrivate','ActionsQuickView'),
('ActionsMinimumRequirements','ActionsViewAll'),
('ActionsMinimumRequirements','ActionsViewGroup'),
('ActionsPrivateReadOnlyAccess','ActionsViewPrivate'),
('LeadRoutingTask','AdminAddCriteria'),
('FieldsTask','AdminCreateUpdateField'),
('GeneralAdminSettingsTask','AdminChangeApplicationName'),
('GeneralAdminSettingsTask','AdminAppSettings'),
('GeneralAdminSettingsTask','AdminManageTags'),
('GeneralAdminSettingsTask','AdminDeleteTag'),
('GeneralAdminSettingsTask','AdminPrepareImport'),
('GeneralAdminSettingsTask','AdminGlobalImport'),
('GeneralAdminSettingsTask','AdminCleanUpImport'),
('GeneralAdminSettingsTask','AdminPrepareExport'),
('GeneralAdminSettingsTask','AdminGlobalExport'),
('GeneralAdminSettingsTask','AdminFinishGlobalExport'),
('GeneralAdminSettingsTask','AdminPublicInfo'),
('GeneralAdminSettingsTask','AdminRollbackImport'),
('GeneralAdminSettingsTask','AdminRollbackStage'),
('GeneralAdminSettingsTask','AdminViewSessionLog'),
('GeneralAdminSettingsTask','AdminViewSessionHistory'),
('GeneralAdminSettingsTask','AdminBackup'),
('GeneralAdminSettingsTask','AdminCheckDatabaseBackup'),
('GeneralAdminSettingsTask','AdminEditGlobalCss'),
('GeneralAdminSettingsTask','AdminConvertEmailTemplates'),
('GeneralAdminSettingsTask','AdminMassDedupe'),
('GeneralAdminSettingsTask','AdminAutoMergeDuplicates'),
('GeneralAdminSettingsTask','AdminUserHistory'),
('GeneralAdminSettingsTask','AdminManageUserCount'),
('GeneralAdminSettingsTask','AdminUserLocationHistory'),
('GeneralAdminSettingsTask','AdminLocationSettings'),
('GeneralAdminSettingsTask','AdminLocateMissingRecords'),
('AuthenticatedSiteFunctionsTask','StudioExecuteMacro'),
('AuthenticatedSiteFunctionsTask','AdminDownloadData'),
('X2StudioTask','AdminCreateModule'),
('GeneralAdminSettingsTask','AdminCreatePage'),
('DropDownsTask','AdminDeleteDropdown'),
('FieldsTask','AdminDeleteField'),
('X2StudioTask','AdminDeleteModule'),
('RoleAccessTask','AdminDeleteRole'),
('DropDownsTask','AdminDropDownEditor'),
('DropDownsTask','AdminEditDropdown'),
('X2StudioTask','AdminEditor'),
('X2StudioTask','AdminEditMobileForms'),
('X2StudioTask','AdminGetMobileLayouts'),
('RoleAccessTask','AdminEditRole'),
('GeneralAdminSettingsTask','AdminEmailSetup'),
('GeneralAdminSettingsTask','AdminExport'),
('X2StudioTask','AdminExportModule'),
('DefaultRole','AdminExportModels'), -- uses X2AuthManager.checkAdminOn
('DefaultRole','AdminPrepareModelExport'), -- uses X2AuthManager.checkAdminOn
('AdminExport','AdminExportMapping'),
('DefaultRole','AdminExportModelRecords'), -- uses X2AuthManager.checkAdminOn
('AdminImport','AdminImportModels'),
('AdminImport','AdminImportModelRecords'),
('AdminImport','AdminPrepareModelImport'),
('AdminImport','AdminCleanUpModelImport'),
('GeneralAdminSettingsTask','AdminGoogleIntegration'),
('GeneralAdminSettingsTask','AdminX2HubIntegration'),
('GeneralAdminSettingsTask','AdminTwitterIntegration'),
('GeneralAdminSettingsTask','AdminJasperIntegration'),
('GeneralAdminSettingsTask','AdminUndoMerge'),
('GeneralAdminSettingsTask','AdminImport'),
('X2StudioTask','AdminImportModule'),
('GeneralAdminSettingsTask','AdminIndex'),
('TranslationsTask','AdminIndex'),
('DropDownsTask','AdminManageDropDowns'),
('FieldsTask','AdminManageFields'),
('GeneralAdminSettingsTask','AdminManageModules'),
('GeneralAdminSettingsTask','AdminWorkflowSettings'),
('GeneralAdminSettingsTask','AdminUpdater'),
('GeneralAdminSettingsTask','AdminUpdateStage'),
('GeneralAdminSettingsTask','AdminUpdaterSettings'),
('GeneralAdminSettingsTask','AdminManageSessions'),
('GeneralAdminSettingsTask','AdminToggleSession'),
('GeneralAdminSettingsTask','AdminEndSession'),
('RoleAccessTask','AdminManageRoles'),
('X2StudioTask','AdminRenameModules'),
('RoleAccessTask','AdminRoleEditor'),
('RoleAccessTask','AdminRoleException'),
('LeadRoutingTask','AdminRoundRobinRules'),
('LeadRoutingTask','AdminSetLeadRouting'),
('GeneralAdminSettingsTask','AdminToggleDefaultLogo'),
('TranslationsTask','AdminTranslationManager'),
('GeneralAdminSettingsTask','AdminUploadLogo'),
('GeneralAdminSettingsTask','AdminViewChangelog'),
('GeneralAdminSettingsTask','AdminExportChangelog'),
('GeneralAdminSettingsTask','AdminClearChangelog'),
('administrator','authenticated'),
('administrator','AdminIndex'),
('DefaultRole','AuthenticatedSiteFunctionsTask'),
('CalendarAdminAccess','CalendarAdmin'),
('administrator','CalendarAdminAccess'),
('administrator','CalendarFullAccess'),
('administrator','CalendarUpdateAccess'),
('administrator','CalendarBasicAccess'),
('administrator','CalendarReadOnlyAccess'),
('CalendarUpdateAccess','CalendarMinimumRequirements'),
('CalendarUpdateAccess','CalendarCompleteAction'),
('CalendarBasicAccess','CalendarCreate'),
('CalendarReadOnlyAccess', 'CalendarInlineEmail'),
('CalendarIndex', 'CalendarX2GridViewMassAction'),
('CalendarIndex','CalendarAjaxGetModelAutocomplete'),
('CalendarFullAccess','CalendarDelete'),
('CalendarFullAccess','CalendarDeleteAction'),
('CalendarFullAccess','CalendarDeleteGoogleEvent'),
('CalendarFullAccess','CalendarDeleteNote'),
('CalendarUpdateAccess','CalendarEditAction'),
('CalendarUpdateAccess','CalendarEditGoogleEvent'),
('CalendarAdminAccess','CalendarMinimumRequirements'),
('CalendarMinimumRequirements','CalendarIndex'),
('CalendarMinimumRequirements','CalendarJsonFeed'),
('CalendarMinimumRequirements','CalendarJsonFeedGoogle'),
('CalendarMinimumRequirements','CalendarJsonFeedGroup'),
('CalendarMinimumRequirements','CalendarJsonFeedShared'),
('CalendarReadOnlyAccess','CalendarMinimumRequirements'),
('CalendarUpdateAccess','CalendarMoveAction'),
('CalendarUpdateAccess','CalendarMoveGoogleEvent'),
('CalendarMinimumRequirements','CalendarMyCalendarPermissions'),
('CalendarBasicAccess','CalendarMinimumRequirements'),
('CalendarUpdateAccess','CalendarResizeAction'),
('CalendarUpdateAccess','CalendarResizeGoogleEvent'),
('CalendarMinimumRequirements','CalendarSaveCheckedCalendar'),
('CalendarMinimumRequirements','CalendarSaveCheckedCalendarFilter'),
('CalendarBasicAccess','CalendarSaveGoogleEvent'),
('CalendarMinimumRequirements','CalendarSearch'),
('CalendarBasicAccess','CalendarSyncActionsToGoogleCalendar'),
('CalendarMinimumRequirements','CalendarTogglePortletVisible'),
('CalendarMinimumRequirements','CalendarToggleUserCalendarsVisible'),
('CalendarUpdateAccess','CalendarUncompleteAction'),
('CalendarUpdateAccess','CalendarUpdate'),
('DefaultRole','CalendarFullAccess'),
('DefaultRole','CalendarUpdateAccess'),
('DefaultRole','CalendarBasicAccess'),
('DefaultRole','CalendarReadOnlyAccess'),
('CalendarFullAccess','CalendarMinimumRequirements'),
('CalendarAdminAccess','CalendarUserCalendarPermissions'),
('CalendarReadOnlyAccess','CalendarView'),
('CalendarReadOnlyAccess','CalendarQuickView'),
('CalendarReadOnlyAccess','CalendarViewAction'),
('CalendarReadOnlyAccess','CalendarViewGoogleEvent'),
('ContactsBasicAccess','ContactsAddToList'),
('ContactsReadOnlyAccess', 'ContactsInlineEmail'),
('ContactsPrivateReadOnlyAccess', 'ContactsInlineEmail'),
('ContactsIndex','ContactsAjaxGetModelAutocomplete'),
('ContactsIndex', 'ContactsX2GridViewMassAction'),
('ContactsIndex', 'ContactsMobileIndex'),
('ContactsAdminAccess','ContactsAdmin'),
('administrator','ContactsAdminAccess'),
('administrator','ContactsFullAccess'),
('administrator','ContactsUpdateAccess'),
('administrator','ContactsBasicAccess'),
('administrator','ContactsReadOnlyAccess'),
('ContactsPrivateUpdateAccess','ContactsMinimumRequirements'),
('ContactsUpdateAccess','ContactsMinimumRequirements'),
('ContactsUpdateAccess','ContactsCreateRecordAlias'),
('ContactsPrivateUpdateAccess','ContactsCreateRecordAlias'),
('ContactsBasicAccess','ContactsCreate'),
('ContactsBasicAccess','ContactsCreateList'),
('ContactsBasicAccess','ContactsCreateListFromSelection'),
('ContactsDeletePrivate','ContactsDelete'),
('ContactsFullAccess','ContactsDelete'),
('ContactsFullAccess','ContactsDeleteRecordAlias'),
('ContactsDeletePrivate','ContactsDeleteList'),
('ContactsFullAccess','ContactsDeleteList'),
('ContactsFullAccess','ContactsDeleteNote'),
('ContactsPrivateFullAccess','ContactsDeleteNote'),
('ContactsPrivateFullAccess','ContactsDeletePrivate'),
('ContactsMinimumRequirements','ContactsDiscardNew'),
('ContactsAdminAccess','ContactsMinimumRequirements'),
('ContactsMinimumRequirements','ContactsGetContacts'),
('ContactsMinimumRequirements','ContactsGetItems'),
('ContactsMinimumRequirements','ContactsGetLists'),
('ContactsMinimumRequirements','ContactsGetTerms'),
('ContactsMinimumRequirements','ContactsIgnoreDuplicates'),
('ContactsAdminAccess','ContactsPrepareImport'),
('ContactsAdminAccess','ContactsCleanUpImport'),
('ContactsAdminAccess','ContactsImportRecords'),
('ContactsAdminAccess','ContactsImportExcel'),
('ContactsAdminAccess','ContactsTrigger'),
('ContactsMinimumRequirements','ContactsIndex'),
('ContactsMinimumRequirements','ContactsList'),
('ContactsMinimumRequirements','ContactsLists'),
('ContactsPrivateReadOnlyAccess','ContactsMinimumRequirements'),
('ContactsReadOnlyAccess','ContactsMinimumRequirements'),
('ContactsMinimumRequirements','ContactsMyContacts'),
('ContactsMinimumRequirements','ContactsNewContacts'),
('ContactsPrivateFullAccess','ContactsMinimumRequirements'),
('ContactsMinimumRequirements','ContactsQtip'),
('ContactsBasicAccess','ContactsQuickContact'),
('ContactsBasicAccess','ContactsMinimumRequirements'),
('ContactsUpdateAccess','ContactsRemoveFromList'),
('ContactsUpdatePrivate','ContactsRemoveFromList'),
('ContactsMinimumRequirements','ContactsSearch'),
('ContactsReadOnlyAccess','ContactsShareContact'),
('ContactsViewPrivate','ContactsShareContact'),
('ContactsReadOnlyAccess','ContactsSubscribe'),
('ContactsViewPrivate','ContactsSubscribe'),
('ContactsUpdateAccess','ContactsUpdate'),
('ContactsUpdateAccess','ContactsGetX2ModelInput'),
('ContactsPrivateUpdateAccess','ContactsGetX2ModelInput'),
('ContactsUpdatePrivate','ContactsUpdate'),
('DefaultRole','ContactsUpdateAccess'),
('DefaultRole','ContactsBasicAccess'),
('DefaultRole','ContactsReadOnlyAccess'),
('ContactsFullAccess','ContactsMinimumRequirements'),
('ContactsPrivateUpdateAccess','ContactsUpdateList'),
('ContactsUpdateAccess','ContactsUpdateList'),
('ContactsPrivateUpdateAccess','ContactsUpdatePrivate'),
('ContactsReadOnlyAccess','ContactsView'),
('ContactsView','ContactsMobileView'),
('ContactsReadOnlyAccess','ContactsQuickView'),
('ContactsViewPrivate','ContactsView'),
('ContactsViewPrivate','ContactsQuickView'),
('ContactsPrivateReadOnlyAccess','ContactsViewPrivate'),
('ContactsReadOnlyAccess','ContactsViewRelationships'),
('ContactsViewPrivate','ContactsViewRelationships'),
('DocsAdminAccess','DocsAdmin'),
('administrator','DocsAdminAccess'),
('administrator','DocsFullAccess'),
('administrator','DocsUpdateAccess'),
('administrator','DocsBasicAccess'),
('administrator','DocsReadOnlyAccess'),
('DocsMinimumRequirements','DocsAutosave'),
('DocsPrivateUpdateAccess','DocsMinimumRequirements'),
('DocsUpdateAccess','DocsMinimumRequirements'),
('DocsUpdatePrivate','DocsChangePermissions'),
('DocsBasicAccess','DocsCreate'),
('DocsIndex','DocsAjaxGetModelAutocomplete'),
('DocsIndex', 'DocsX2GridViewMassAction'),
('DocsBasicAccess','DocsCreateEmail'),
('DocsReadOnlyAccess', 'DocsInlineEmail'),
('DocsBasicAccess','DocsCreateQuote'),
('DocsDeletePrivate','DocsDelete'),
('DocsFullAccess','DocsDelete'),
('DocsFullAccess','DocsDeleteNote'),
('DocsPrivateFullAccess','DocsDeleteNote'),
('DocsPrivateFullAccess','DocsDeletePrivate'),
('DocsReadOnlyAccess','DocsExportToHtml'),
('DocsViewPrivate','DocsExportToHtml'),
('DocsExportToHtml','DocsDownloadExport'),
('DocsAdminAccess','DocsMinimumRequirements'),
('DocsMinimumRequirements','DocsGetItem'),
('DocsMinimumRequirements','DocsGetItems'),
('DocsMinimumRequirements','DocsGetFolderSelector'),
('DocsMinimumRequirements','DocsIndex'),
('DocsMinimumRequirements','DocsMoveFolder'),
('DocsMinimumRequirements','DocsDeleteFileFolder'),
('DocsPrivateReadOnlyAccess','DocsMinimumRequirements'),
('DocsReadOnlyAccess','DocsMinimumRequirements'),
('DocsPrivateFullAccess','DocsMinimumRequirements'),
('DocsBasicAccess','DocsMinimumRequirements'),
('DocsMinimumRequirements','DocsSearch'),
('DocsUpdateAccess','DocsUpdate'),
('DocsUpdateAccess','DocsGetX2ModelInput'),
('DocsPrivateUpdateAccess','DocsGetX2ModelInput'),
('DocsUpdatePrivate','DocsUpdate'),
('DefaultRole','DocsUpdateAccess'),
('DefaultRole','DocsBasicAccess'),
('DefaultRole','DocsReadOnlyAccess'),
('DocsFullAccess','DocsMinimumRequirements'),
('DocsPrivateUpdateAccess','DocsUpdatePrivate'),
('DocsReadOnlyAccess','DocsView'),
('DocsReadOnlyAccess','DocsQuickView'),
('DocsReadOnlyAccess','DocsFullView'),
('DocsViewPrivate','DocsView'),
('DocsViewPrivate','DocsQuickView'),
('DocsViewPrivate','DocsFullView'),
('DocsPrivateReadOnlyAccess','DocsViewPrivate'),
('X2StudioTask','DropDownsTask'),
('X2StudioTask','FieldsTask'),
('administrator','GeneralAdminSettingsTask'),
('GroupsAdminAccess','GroupsAdmin'),
('administrator','GroupsAdminAccess'),
('administrator','GroupsFullAccess'),
('administrator','GroupsUpdateAccess'),
('administrator','GroupsBasicAccess'),
('administrator','GroupsReadOnlyAccess'),
('GroupsUpdateAccess','GroupsMinimumRequirements'),
('GroupsBasicAccess','GroupsCreate'),
('GroupsReadOnlyAccess', 'GroupsInlineEmail'),
('GroupsIndex','GroupsAjaxGetModelAutocomplete'),
('GroupsIndex','GroupsGetItems'),
('GroupsIndex', 'GroupsX2GridViewMassAction'),
('GroupsFullAccess','GroupsDelete'),
('GroupsFullAccess','GroupsDeleteNote'),
('GroupsAdminAccess','GroupsMinimumRequirements'),
('GroupsMinimumRequirements','GroupsGetGroups'),
('GroupsMinimumRequirements','GroupsIndex'),
('GroupsReadOnlyAccess','GroupsMinimumRequirements'),
('DefaultRole','GroupsReadOnlyAccess'),
('GroupsBasicAccess','GroupsMinimumRequirements'),
('GroupsMinimumRequirements','GroupsSearch'),
('GroupsUpdateAccess','GroupsUpdate'),
('GroupsFullAccess','GroupsMinimumRequirements'),
('GroupsReadOnlyAccess','GroupsView'),
('GroupsReadOnlyAccess','GroupsQuickView'),
('guest','GuestSiteFunctionsTask'),
('administrator','LeadRoutingTask'),
('MarketingAdminAccess','MarketingAdmin'),
('MarketingAdminAccess','MarketingAnonContactIndex'),
('MarketingAdminAccess','MarketingAnonContactView'),
('MarketingAdminAccess','MarketingAnonContactDelete'),
('MarketingAdminAccess','MarketingFingerprintIndex'),
('administrator','MarketingAdminAccess'),
('administrator','MarketingFullAccess'),
('administrator','MarketingUpdateAccess'),
('administrator','MarketingBasicAccess'),
('administrator','MarketingReadOnlyAccess'),
('MarketingUpdateAccess','MarketingMinimumRequirements'),
('MarketingPrivateBasicAccess','MarketingBasicPrivate'),
('GuestSiteFunctionsTask','MarketingClick'),
('GuestSiteFunctionsTask','MarketingDoNotEmailLinkClick'),
('MarketingUpdateAccess','MarketingComplete'),
('MarketingUpdateAccess','MarketingGetX2ModelInput'),
('MarketingPrivateUpdateAccess','MarketingGetX2ModelInput'),
('MarketingUpdatePrivate','MarketingComplete'),
('MarketingBasicAccess','MarketingCreate'),
('MarketingReadOnlyAccess', 'MarketingInlineEmail'),
('MarketingPrivateReadOnlyAccess', 'MarketingInlineEmail'),
('MarketingIndex','MarketingAjaxGetModelAutocomplete'),
('MarketingIndex', 'MarketingX2GridViewMassAction'),
('MarketingMinimumRequirements','MarketingMailIndividual'),
('MarketingPrivateBasicAccess','MarketingCreate'),
('MarketingBasicAccess','MarketingCreateFromTag'),
('MarketingPrivateBasicAccess','MarketingCreateFromTag'),
('MarketingDeletePrivate','MarketingDelete'),
('MarketingFullAccess','MarketingRemoveWebLeadFormCustomHtml'),
('MarketingFullAccess','MarketingSaveWebLeadFormCustomHtml'),
('MarketingFullAccess','MarketingDelete'),
('MarketingDeletePrivate','MarketingDeleteNote'),
('MarketingFullAccess','MarketingDeleteNote'),
('MarketingPrivateFullAccess','MarketingDeletePrivate'),
('MarketingAdminAccess','MarketingMinimumRequirements'),
('MarketingMinimumRequirements','MarketingGetItems'),
('MarketingMinimumRequirements','MarketingIndex'),
('MarketingBasicAccess','MarketingLaunch'),
('MarketingBasicPrivate','MarketingLaunch'),
('MarketingBasicAccess','MarketingValidate'),
('MarketingPrivateReadOnlyAccess','MarketingMinimumRequirements'),
('MarketingReadOnlyAccess','MarketingMinimumRequirements'),
('DefaultRole','MarketingPrivateUpdateAccess'),
('DefaultRole','MarketingBasicAccess'),
('DefaultRole','MarketingReadOnlyAccess'),
('MarketingPrivateUpdateAccess','MarketingMinimumRequirements'),
('MarketingPrivateBasicAccess','MarketingMinimumRequirements'),
('MarketingPrivateFullAccess','MarketingMinimumRequirements'),
('MarketingBasicAccess','MarketingMinimumRequirements'),
('MarketingBasicAccess','MarketingGetCampaignChartData'),
('MarketingMinimumRequirements','MarketingSearch'),
('MarketingBasicAccess','MarketingToggle'),
('MarketingBasicPrivate','MarketingToggle'),
('MarketingUpdateAccess','MarketingUpdate'),
('MarketingUpdatePrivate','MarketingUpdate'),
('MarketingFullAccess','MarketingMinimumRequirements'),
('MarketingPrivateUpdateAccess','MarketingUpdatePrivate'),
('MarketingReadOnlyAccess','MarketingView'),
('MarketingViewPrivate','MarketingView'),
('AuthenticatedSiteFunctionsTask','MediaRecursiveDriveFiles'),
('AuthenticatedSiteFunctionsTask','MediaRefreshDriveCache'),
('MarketingPrivateReadOnlyAccess','MarketingViewPrivate'),
('LeadRoutingTask','MarketingWebLeadForm'),
('MarketingAdminAccess','MarketingWebleadForm'),
('MarketingAdminAccess','MarketingDeleteWebForm'),
('MediaAdminAccess','MediaAdmin'),
('administrator','MediaAdminAccess'),
('administrator','MediaFullAccess'),
('administrator','MediaUpdateAccess'),
('administrator','MediaBasicAccess'),
('administrator','MediaReadOnlyAccess'),
('MediaUpdateAccess','MediaMinimumRequirements'),
('MediaFullAccess','MediaDelete'),
('MediaFullAccess','MediaDeleteNote'),
('MediaReadOnlyAccess','MediaDownload'),
('MediaAdminAccess','MediaMinimumRequirements'),
('MediaMinimumRequirements','MediaIndex'),
('MediaReadOnlyAccess','MediaMinimumRequirements'),
('MediaBasicAccess','MediaMinimumRequirements'),
('MediaMinimumRequirements','MediaSearch'),
('AuthenticatedSiteFunctionsTask','MediaToggleUserMediaVisible'),
('MediaUpdateAccess','MediaUpdate'),
('MediaUpdateAccess','MediaGetX2ModelInput'),
('DefaultRole','MediaUpdateAccess'),
('DefaultRole','MediaBasicAccess'),
('DefaultRole','MediaReadOnlyAccess'),
('MediaFullAccess','MediaMinimumRequirements'),
('MediaBasicAccess','MediaUpload'),
('MediaBasicAccess','MediaCreate'),
('MediaReadOnlyAccess', 'MediaInlineEmail'),
('MediaReadOnlyAccess','MediaView'),
('MediaReadOnlyAccess','MediaQuickView'),
('MediaReadOnlyAccess','MediaQtip'),
('MediaIndex','MediaAjaxGetModelAutocomplete'),
('MediaIndex', 'MediaX2GridViewMassAction'),
('MediaIndex','MediaGetItems'),
('GuestSiteFunctionsTask','MediaGetFile'),
('MediaIndex','MediaMediaSelector'),
('OpportunitiesUpdateAccess','OpportunitiesAddContact'),
('OpportunitiesUpdatePrivate','OpportunitiesAddContact'),
('OpportunitiesUpdateAccess','OpportunitiesAddUser'),
('OpportunitiesUpdatePrivate','OpportunitiesAddUser'),
('OpportunitiesAdminAccess','OpportunitiesAdmin'),
('administrator','OpportunitiesAdminAccess'),
('administrator','OpportunitiesFullAccess'),
('administrator','OpportunitiesUpdateAccess'),
('administrator','OpportunitiesBasicAccess'),
('administrator','OpportunitiesReadOnlyAccess'),
('OpportunitiesPrivateUpdateAccess','OpportunitiesMinimumRequirements'),
('OpportunitiesUpdateAccess','OpportunitiesMinimumRequirements'),
('OpportunitiesBasicAccess','OpportunitiesCreate'),
('OpportunitiesDeletePrivate','OpportunitiesDelete'),
('OpportunitiesFullAccess','OpportunitiesDelete'),
('OpportunitiesDeletePrivate','OpportunitiesDeleteNote'),
('OpportunitiesFullAccess','OpportunitiesDeleteNote'),
('OpportunitiesPrivateFullAccess','OpportunitiesDeletePrivate'),
('OpportunitiesAdminAccess','OpportunitiesMinimumRequirements'),
('GuestSiteFunctionsTask','OpportunitiesGetItems'),
('OpportunitiesMinimumRequirements','OpportunitiesGetTerms'),
('OpportunitiesMinimumRequirements','OpportunitiesQtip'),
('OpportunitiesMinimumRequirements','OpportunitiesIndex'),
('OpportunitiesIndex', 'OpportunitiesMobileIndex'),
('OpportunitiesIndex', 'OpportunitiesAjaxGetModelAutocomplete'),
('OpportunitiesIndex', 'OpportunitiesX2GridViewMassAction'),
('OpportunitiesPrivateReadOnlyAccess','OpportunitiesMinimumRequirements'),
('OpportunitiesReadOnlyAccess','OpportunitiesMinimumRequirements'),
('OpportunitiesPrivateFullAccess','OpportunitiesMinimumRequirements'),
('OpportunitiesBasicAccess','OpportunitiesMinimumRequirements'),
('OpportunitiesReadOnlyAccess', 'OpportunitiesInlineEmail'),
('OpportunitiesPrivateReadOnlyAccess', 'OpportunitiesInlineEmail'),
('OpportunitiesUpdateAccess','OpportunitiesRemoveContact'),
('OpportunitiesUpdatePrivate','OpportunitiesRemoveContact'),
('OpportunitiesUpdateAccess','OpportunitiesRemoveUser'),
('OpportunitiesUpdatePrivate','OpportunitiesRemoveUser'),
('OpportunitiesMinimumRequirements','OpportunitiesSearch'),
('OpportunitiesReadOnlyAccess','OpportunitiesShareOpportunity'),
('OpportunitiesViewPrivate','OpportunitiesShareOpportunity'),
('OpportunitiesUpdateAccess','OpportunitiesUpdate'),
('OpportunitiesUpdateAccess','OpportunitiesGetX2ModelInput'),
('OpportunitiesPrivateUpdateAccess','OpportunitiesGetX2ModelInput'),
('OpportunitiesUpdatePrivate','OpportunitiesUpdate'),
('DefaultRole','OpportunitiesUpdateAccess'),
('DefaultRole','OpportunitiesBasicAccess'),
('DefaultRole','OpportunitiesReadOnlyAccess'),
('OpportunitiesFullAccess','OpportunitiesMinimumRequirements'),
('OpportunitiesPrivateUpdateAccess','OpportunitiesUpdatePrivate'),
('OpportunitiesReadOnlyAccess','OpportunitiesView'),
('OpportunitiesReadOnlyAccess','OpportunitiesQuickView'),
('OpportunitiesViewPrivate','OpportunitiesView'),
('OpportunitiesView','OpportunitiesMobileView'),
('OpportunitiesViewPrivate','OpportunitiesQuickView'),
('OpportunitiesPrivateReadOnlyAccess','OpportunitiesViewPrivate'),
('X2LeadsAdminAccess','X2LeadsAdmin'),
('administrator','X2LeadsAdminAccess'),
('administrator','X2LeadsFullAccess'),
('administrator','X2LeadsUpdateAccess'),
('administrator','X2LeadsBasicAccess'),
('administrator','X2LeadsReadOnlyAccess'),
('X2LeadsPrivateUpdateAccess','X2LeadsMinimumRequirements'),
('X2LeadsUpdateAccess','X2LeadsMinimumRequirements'),
('X2LeadsUpdateAccess','X2LeadsConvert'),
('X2LeadsBasicAccess','X2LeadsCreate'),
('X2LeadsReadOnlyAccess', 'X2LeadsInlineEmail'),
('X2LeadsPrivateReadOnlyAccess', 'X2LeadsInlineEmail'),
('X2LeadsDeletePrivate','X2LeadsDelete'),
('X2LeadsFullAccess','X2LeadsDelete'),
('X2LeadsDeletePrivate','X2LeadsDeleteNote'),
('X2LeadsFullAccess','X2LeadsDeleteNote'),
('X2LeadsPrivateFullAccess','X2LeadsDeletePrivate'),
('X2LeadsAdminAccess','X2LeadsMinimumRequirements'),
('GuestSiteFunctionsTask','X2LeadsGetItems'),
('X2LeadsMinimumRequirements','X2LeadsGetTerms'),
('X2LeadsMinimumRequirements','X2LeadsIndex'),
('X2LeadsIndex', 'X2LeadsMobileIndex'),
('X2LeadsIndex', 'X2LeadsAjaxGetModelAutocomplete'),
('X2LeadsIndex', 'X2LeadsX2GridViewMassAction'),
('X2LeadsPrivateReadOnlyAccess','X2LeadsMinimumRequirements'),
('X2LeadsReadOnlyAccess','X2LeadsMinimumRequirements'),
('X2LeadsPrivateFullAccess','X2LeadsMinimumRequirements'),
('X2LeadsBasicAccess','X2LeadsMinimumRequirements'),
('X2LeadsMinimumRequirements','X2LeadsSearch'),
('X2LeadsUpdateAccess','X2LeadsUpdate'),
('X2LeadsUpdateAccess','X2LeadsGetX2ModelInput'),
('X2LeadsPrivateUpdateAccess','X2LeadsGetX2ModelInput'),
('X2LeadsUpdatePrivate','X2LeadsUpdate'),
('DefaultRole','X2LeadsUpdateAccess'),
('DefaultRole','X2LeadsBasicAccess'),
('DefaultRole','X2LeadsReadOnlyAccess'),
('X2LeadsFullAccess','X2LeadsMinimumRequirements'),
('X2LeadsPrivateUpdateAccess','X2LeadsUpdatePrivate'),
('X2LeadsView','X2LeadsMobileView'),
('X2LeadsReadOnlyAccess','X2LeadsView'),
('X2LeadsReadOnlyAccess','X2LeadsQuickView'),
('X2LeadsViewPrivate','X2LeadsView'),
('X2LeadsViewPrivate','X2LeadsQuickView'),
('X2LeadsPrivateReadOnlyAccess','X2LeadsViewPrivate'),
('ProductsAdminAccess','ProductsAdmin'),
('administrator','ProductsAdminAccess'),
('administrator','ProductsFullAccess'),
('administrator','ProductsUpdateAccess'),
('administrator','ProductsBasicAccess'),
('administrator','ProductsReadOnlyAccess'),
('ProductsPrivateUpdateAccess','ProductsMinimumRequirements'),
('ProductsUpdateAccess','ProductsMinimumRequirements'),
('ProductsBasicAccess','ProductsCreate'),
('ProductsBasicAccess', 'ProductsInlineEmail'),
('ProductsDeletePrivate','ProductsDelete'),
('ProductsFullAccess','ProductsDelete'),
('ProductsDeletePrivate','ProductsDeleteNote'),
('ProductsFullAccess','ProductsDeleteNote'),
('ProductsPrivateFullAccess','ProductsDeletePrivate'),
('ProductsAdminAccess','ProductsMinimumRequirements'),
('ProductsMinimumRequirements','ProductsGetItems'),
('ProductsMinimumRequirements','ProductsGetItems2'),
('ProductsMinimumRequirements','ProductsIndex'),
('ProductsIndex', 'ProductsMobileIndex'),
('ProductsIndex', 'ProductsAjaxGetModelAutocomplete'),
('ProductsIndex', 'ProductsX2GridViewMassAction'),
('ProductsPrivateReadOnlyAccess','ProductsMinimumRequirements'),
('ProductsReadOnlyAccess','ProductsMinimumRequirements'),
('ProductsPrivateFullAccess','ProductsMinimumRequirements'),
('ProductsBasicAccess','ProductsMinimumRequirements'),
('ProductsMinimumRequirements','ProductsSearch'),
('ProductsUpdateAccess','ProductsUpdate'),
('ProductsUpdatePrivate','ProductsUpdate'),
('ProductsUpdateAccess','ProductsGetX2ModelInput'),
('ProductsPrivateUpdateAccess','ProductsGetX2ModelInput'),
('GeneralAdminSettingsTask','CredentialsAdmin'),
('DefaultRole','CredentialsCreateUpdateOwn'),
('DefaultRole','CredentialsDeleteOwn'),
('DefaultRole','CredentialsSelectOwn'),
('DefaultRole','CredentialsSelectSystemwide'),
('CredentialsAdmin','CredentialsCreateUpdateSystemwide'),
('CredentialsAdmin','CredentialsDeleteSystemwide'),
('CredentialsAdmin','CredentialsSelectNonPrivate'),
('CredentialsAdmin','CredentialsSetDefaultSystemwide'),
('CredentialsCreateUpdateOwn','CredentialsCreateUpdate'),
('CredentialsCreateUpdateSystemwide','CredentialsCreateUpdate'),
('CredentialsDeleteOwn','CredentialsDelete'),
('CredentialsDeleteSystemwide','CredentialsDelete'),
('CredentialsSelectOwn','CredentialsSelect'),
('CredentialsSelectNonPrivate','CredentialsSelect'),
('CredentialsSelectSystemwide','CredentialsSelect'),
('CredentialsSelect','CredentialsSetDefaultOwn'),
('CredentialsSetDefaultOwn','CredentialsSetDefault'),
('CredentialsSetDefaultSystemwide','CredentialsSetDefault'),
('DefaultRole','ProductsUpdateAccess'),
('DefaultRole','ProductsBasicAccess'),
('DefaultRole','ProductsReadOnlyAccess'),
('ProductsFullAccess','ProductsMinimumRequirements'),
('ProductsPrivateUpdateAccess','ProductsUpdatePrivate'),
('ProductsReadOnlyAccess','ProductsView'),
('ProductsView','ProductsMobileView'),
('ProductsReadOnlyAccess','ProductsQuickView'),
('ProductsViewPrivate','ProductsView'),
('ProductsViewPrivate','ProductsQuickView'),
('ProductsPrivateReadOnlyAccess','ProductsViewPrivate'),
('QuotesAdminAccess','QuotesAdmin'),
('administrator','QuotesAdminAccess'),
('administrator','QuotesFullAccess'),
('administrator','QuotesUpdateAccess'),
('administrator','QuotesBasicAccess'),
('administrator','QuotesReadOnlyAccess'),
('QuotesPrivateUpdateAccess','QuotesMinimumRequirements'),
('QuotesUpdateAccess','QuotesMinimumRequirements'),
('QuotesBasicAccess','QuotesCreate'),
('QuotesDeletePrivate','QuotesDelete'),
('QuotesFullAccess','QuotesDelete'),
('QuotesDeletePrivate','QuotesDeleteNote'),
('QuotesFullAccess','QuotesDeleteNote'),
('QuotesPrivateFullAccess','QuotesDeletePrivate'),
('QuotesUpdateAccess','QuotesDeleteProduct'),
('QuotesUpdatePrivate','QuotesDeleteProduct'),
('QuotesAdminAccess','QuotesMinimumRequirements'),
('GuestSiteFunctionsTask','QuotesGetItems'),
('QuotesMinimumRequirements','QuotesGetTerms'),
('QuotesMinimumRequirements','QuotesIndex'),
('QuotesIndex', 'QuotesMobileIndex'),
('QuotesIndex', 'QuotesX2GridViewMassAction'),
('QuotesIndex', 'QuotesAjaxGetModelAutocomplete'),
('QuotesPrivateReadOnlyAccess','QuotesMinimumRequirements'),
('QuotesReadOnlyAccess','QuotesMinimumRequirements'),
('QuotesReadOnlyAccess','QuotesPrint'),
('QuotesViewPrivate','QuotesPrint'),
('QuotesPrivateFullAccess','QuotesMinimumRequirements'),
('QuotesBasicAccess','QuotesQuickCreate'),
('QuotesReadOnlyAccess', 'QuotesInlineEmail'),
('QuotesPrivateReadOnlyAccess', 'QuotesInlineEmail'),
('QuotesDeletePrivate','QuotesQuickDelete'),
('QuotesFullAccess','QuotesQuickDelete'),
('QuotesUpdateAccess','QuotesQuickUpdate'),
('QuotesUpdatePrivate','QuotesQuickUpdate'),
('QuotesBasicAccess','QuotesMinimumRequirements'),
('QuotesUpdateAccess','QuotesRemoveUser'),
('QuotesUpdatePrivate','QuotesRemoveUser'),
('QuotesMinimumRequirements','QuotesSearch'),
('QuotesReadOnlyAccess','QuotesShareQuote'),
('QuotesViewPrivate','QuotesShareQuote'),
('QuotesUpdateAccess','QuotesUpdate'),
('QuotesUpdateAccess','QuotesGetX2ModelInput'),
('QuotesPrivateUpdateAccess','QuotesGetX2ModelInput'),
('QuotesUpdatePrivate','QuotesUpdate'),
('DefaultRole','QuotesUpdateAccess'),
('DefaultRole','QuotesBasicAccess'),
('DefaultRole','QuotesReadOnlyAccess'),
('QuotesFullAccess','QuotesMinimumRequirements'),
('QuotesPrivateUpdateAccess','QuotesUpdatePrivate'),
('QuotesView','QuotesMobileView'),
('QuotesReadOnlyAccess','QuotesView'),
('QuotesReadOnlyAccess','QuotesQuickView'),
('QuotesViewPrivate','QuotesView'),
('QuotesViewPrivate','QuotesQuickView'),
('QuotesReadOnlyAccess','QuotesViewInline'),
('QuotesViewPrivate','QuotesViewInline'),
('QuotesPrivateReadOnlyAccess','QuotesViewPrivate'),
('ServicesAdminAccess','ServicesAdmin'),
('administrator','ServicesAdminAccess'),
('administrator','ServicesFullAccess'),
('administrator','ServicesUpdateAccess'),
('administrator','ServicesBasicAccess'),
('administrator','ServicesReadOnlyAccess'),
('ServicesPrivateUpdateAccess','ServicesMinimumRequirements'),
('ServicesUpdateAccess','ServicesMinimumRequirements'),
('ServicesBasicAccess','ServicesCreate'),
('ServicesReadOnlyAccess', 'ServicesInlineEmail'),
('ServicesPrivateReadOnlyAccess', 'ServicesInlineEmail'),
('ServicesDeletePrivate','ServicesDelete'),
('ServicesFullAccess','ServicesDelete'),
('ServicesFullAccess','ServicesDeleteNote'),
('ServicesPrivateFullAccess','ServicesDeleteNote'),
('ServicesPrivateFullAccess','ServicesDeletePrivate'),
('ServicesAdminAccess','ServicesMinimumRequirements'),
('ServicesMinimumRequirements','ServicesGetItems'),
('ServicesMinimumRequirements','ServicesIndex'),
('ServicesIndex', 'ServicesMobileIndex'),
('ServicesIndex', 'ServicesAjaxGetModelAutocomplete'),
('ServicesIndex', 'ServicesX2GridViewMassAction'),
('ServicesPrivateReadOnlyAccess','ServicesMinimumRequirements'),
('ServicesReadOnlyAccess','ServicesMinimumRequirements'),
('ServicesPrivateFullAccess','ServicesMinimumRequirements'),
('ServicesBasicAccess','ServicesMinimumRequirements'),
('ServicesMinimumRequirements','ServicesSearch'),
('ServicesUpdateAccess','ServicesUpdate'),
('ServicesUpdateAccess','ServicesGetX2ModelInput'),
('ServicesPrivateUpdateAccess','ServicesGetX2ModelInput'),
('ServicesUpdatePrivate','ServicesUpdate'),
('ServicesFullAccess','ServicesMinimumRequirements'),
('DefaultRole','ServicesUpdateAccess'),
('DefaultRole','ServicesBasicAccess'),
('DefaultRole','ServicesReadOnlyAccess'),
('ServicesPrivateUpdateAccess','ServicesUpdatePrivate'),
('ServicesView','ServicesMobileView'),
('ServicesReadOnlyAccess','ServicesView'),
('ServicesReadOnlyAccess','ServicesQuickView'),
('ServicesViewPrivate','ServicesView'),
('ServicesViewPrivate','ServicesQuickView'),
('ServicesPrivateReadOnlyAccess','ServicesViewPrivate'),
('ServicesAdminAccess','ServicesCreateWebForm'),
('TopicsMinimumRequirements','TopicsAjaxGetModelAutocomplete'),
('TopicsMinimumRequirements','TopicsGetItems'),
('TopicsMinimumRequirements','TopicsGetTerms'),
('TopicsMinimumRequirements','TopicsGetX2ModelInput'),
('TopicsMinimumRequirements','TopicsIndex'),
('TopicsIndex','TopicsMobileIndex'),
('TopicsView','TopicsMobileView'),
('TopicsDelete','TopicsMobileDelete'),
('TopicsCreate','TopicsMobileCreate'),
('TopicsUpdate','TopicsMobileUpdate'),
('TopicsUpdateReply','TopicsMobileUpdateReply'),
('TopicsDeleteReply','TopicsMobileDeleteReply'),
('TopicsMinimumRequirements','TopicsQtip'),
('TopicsMinimumRequirements','TopicsSearch'),
('TopicsMinimumRequirements','TopicsX2GridViewMassAction'),
('TopicsReadOnlyAccess','TopicsMinimumRequirements'),
('TopicsReadOnlyAccess','TopicsView'),
('TopicsReadOnlyAccess','TopicsDeleteNote'),
('TopicsReadOnlyAccess','TopicsInlineEmail'),
('TopicsReadOnlyAccess','TopicsQuickView'),
('TopicsReadOnlyAccess','TopicsNewReply'),
('TopicsReadOnlyAccess','TopicsUpdateReply'),
('TopicsReadOnlyAccess','TopicsDeleteReply'),
('TopicsPrivateReadOnlyAccess','TopicsMinimumRequirements'),
('TopicsPrivateReadOnlyAccess','TopicsViewPrivate'),
('TopicsViewPrivate','TopicsView'),
('TopicsPrivateReadOnlyAccess','TopicsQuickView'),
('TopicsPrivateReadOnlyAccess','TopicsNewReply'),
('TopicsPrivateReadOnlyAccess','TopicsUpdateReply'),
('TopicsPrivateReadOnlyAccess','TopicsDeleteReply'),
('TopicsPrivateReadOnlyAccess','TopicsDeleteNote'),
('TopicsPrivateReadOnlyAccess','TopicsInlineEmail'),
('TopicsBasicAccess','TopicsMinimumRequirements'),
('TopicsBasicAccess','TopicsCreate'),
('TopicsUpdateAccess','TopicsMinimumRequirements'),
('TopicsUpdateAccess','TopicsUpdate'),
('TopicsPrivateUpdateAccess','TopicsMinimumRequirements'),
('TopicsPrivateUpdateAccess','TopicsUpdatePrivate'),
('TopicsUpdatePrivate','TopicsUpdate'),
('TopicsFullAccess','TopicsMinimumRequirements'),
('TopicsFullAccess','TopicsDelete'),
('TopicsPrivateFullAccess','TopicsMinimumRequirements'),
('TopicsPrivateFullAccess','TopicsDeletePrivate'),
('TopicsDeletePrivate','TopicsDelete'),
('TopicsAdminAccess','TopicsMinimumRequirements'),
('TopicsAdminAccess','TopicsAdmin'),
('TopicsAdminAccess','TopicsPinUnpinTopic'),
('DefaultRole','TopicsReadOnlyAccess'),
('DefaultRole','TopicsBasicAccess'),
('DefaultRole','TopicsPrivateUpdateAccess'),
('DefaultRole','TopicsPrivateFullAccess'),
('administrator','TopicsReadOnlyAccess'),
('administrator','TopicsBasicAccess'),
('administrator','TopicsUpdateAccess'),
('administrator','TopicsFullAccess'),
('administrator','TopicsAdminAccess'),
('administrator','RoleAccessTask'),
('AuthenticatedSiteFunctionsTask','GuestSiteFunctionsTask'),
('GuestSiteFunctionsTask','SiteIndex'),
('GuestSiteFunctionsTask','SiteLogin'),
('AuthenticatedSiteFunctionsTask','SiteLogout'),
('AuthenticatedSiteFunctionsTask','SiteToggleVisibility'),
('AuthenticatedSiteFunctionsTask','SiteWhatsNew'),
('administrator','TranslationsTask'),
('AuthenticatedSiteFunctionsTask','UsersAddTopContact'),
('UsersMinimumRequirements','UsersAdmin'),
('administrator','UsersAdminAccess'),
('administrator','UsersFullAccess'),
('administrator','UsersUpdateAccess'),
('administrator','UsersBasicAccess'),
('administrator','UsersReadOnlyAccess'),
('UsersUpdateAccess','UsersMinimumRequirements'),
('UsersBasicAccess','UsersCreate'),
('GuestSiteFunctionsTask','UsersCreateAccount'),
('UsersFullAccess','UsersDelete'),
('UsersFullAccess','UsersDeleteNote'),
('UsersAdminAccess','UsersMinimumRequirements'),
('UsersMinimumRequirements','UsersIndex'),
('UsersIndex', 'UsersMobileIndex'),
('UsersIndex', 'UsersAjaxGetModelAutocomplete'),
('UsersIndex', 'UsersX2GridViewMassAction'),
('UsersAdminAccess','UsersDeactivateTwoFactor'),
('UsersAdminAccess','UsersInviteUsers'),
('UsersAdminAccess','UsersUserMap'),
('UsersReadOnlyAccess','UsersMinimumRequirements'),
('UsersBasicAccess','UsersMinimumRequirements'),
('UsersReadOnlyAccess', 'UsersInlineEmail'),
('AuthenticatedSiteFunctionsTask','UsersRemoveTopContact'),
('UsersMinimumRequirements','UsersSearch'),
('UsersUpdateAccess','UsersUpdate'),
('UsersFullAccess','UsersMinimumRequirements'),
('UsersView','UsersMobileView'),
('UsersReadOnlyAccess','UsersView'),
('UsersReadOnlyAccess','UsersQuickView'),
('WorkflowAdminAccess','WorkflowAdmin'),
('administrator','WorkflowAdminAccess'),
('administrator','WorkflowFullAccess'),
('administrator','WorkflowUpdateAccess'),
('administrator','WorkflowBasicAccess'),
('administrator','WorkflowReadOnlyAccess'),
('WorkflowUpdateAccess','WorkflowMinimumRequirements'),
('AuthenticatedSiteFunctionsTask','WorkflowCompleteStage'),
('WorkflowBasicAccess','WorkflowCreate'),
('WorkflowReadOnlyAccess', 'WorkflowInlineEmail'),
('WorkflowFullAccess','WorkflowDelete'),
('WorkflowFullAccess','WorkflowDeleteNote'),
('WorkflowAdminAccess','WorkflowMinimumRequirements'),
('AuthenticatedSiteFunctionsTask','WorkflowGetStageMembers'),
('AuthenticatedSiteFunctionsTask','WorkflowGetStages'),
('AuthenticatedSiteFunctionsTask','WorkflowGetWorkflow'),
('WorkflowMinimumRequirements','WorkflowGetFinancialFields'),
('WorkflowMinimumRequirements','WorkflowIndex'),
('WorkflowIndex', 'WorkflowX2GridViewMassAction'),
('WorkflowIndex','WorkflowAjaxGetModelAutocomplete'),
('WorkflowReadOnlyAccess','WorkflowMinimumRequirements'),
('WorkflowReadOnlyAccess','WorkflowMoveFromStageAToStageB'),
('WorkflowReadOnlyAccess','WorkflowAjaxAddADeal'),
('WorkflowReadOnlyAccess','WorkflowChangeUI'),
('WorkflowReadOnlyAccess','WorkflowGetItems'),
('WorkflowReadOnlyAccess','WorkflowGetStageNames'),
('WorkflowReadOnlyAccess','WorkflowGetStageNameItems'),
('DefaultRole','WorkflowReadOnlyAccess'),
('WorkflowBasicAccess','WorkflowMinimumRequirements'),
('AuthenticatedSiteFunctionsTask','WorkflowRevertStage'),
('WorkflowMinimumRequirements','WorkflowSearch'),
('AuthenticatedSiteFunctionsTask','WorkflowStartStage'),
('WorkflowUpdateAccess','WorkflowUpdate'),
('WorkflowFullAccess','WorkflowMinimumRequirements'),
('AuthenticatedSiteFunctionsTask','WorkflowUpdateStageDetails'),
('WorkflowReadOnlyAccess','WorkflowView'),
('WorkflowReadOnlyAccess','WorkflowQuickView'),
('AuthenticatedSiteFunctionsTask','WorkflowViewStage'),
('AuthenticatedSiteFunctionsTask','WorkflowGetStageValue'),
('administrator','X2StudioTask'),
('AuthenticatedSiteFunctionsTask','WorkflowGetStageDetails'),
('admin','administrator'),
('authenticated','DefaultRole'),
('GeneralAdminSettingsTask','AdminCalculateTranslationRedundancy'),
('GeneralAdminSettingsTask','AdminFindMissingPermissions'),
('GeneralAdminSettingsTask','AdminGetWorkflowStages'),
('GeneralAdminSettingsTask','AdminGetRole'),
('GeneralAdminSettingsTask','AdminDeleteCriteria'),
('GeneralAdminSettingsTask','AdminDeleteRouting'),
('GeneralAdminSettingsTask','AdminGetAttributes'),
('GeneralAdminSettingsTask','AdminActivitySettings'),
('GeneralAdminSettingsTask','AdminSetServiceRouting'),
('GeneralAdminSettingsTask','AdminValidateField'),
('GeneralAdminSettingsTask','AdminRemoveField'),
('GeneralAdminSettingsTask','AdminGetFieldData'),
('AuthenticatedSiteFunctionsTask','AdminViewPage'),
('AuthenticatedSiteFunctionsTask','AdminGetRoutingType'),
('GeneralAdminSettingsTask','AdminRegisterModules'),
('GeneralAdminSettingsTask','AdminToggleModule'),
('GeneralAdminSettingsTask','AdminCreateFormLayout'),
('GeneralAdminSettingsTask','AdminDeleteFormLayout'),
('GeneralAdminSettingsTask','AdminGetDropdown'),
('GeneralAdminSettingsTask','AdminGetFieldType'),
('GeneralAdminSettingsTask','AdminDelete'),
('GeneralAdminSettingsTask','AdminInstallUpdate'),
('GeneralAdminSettingsTask','AdminCleanUp'),
('GeneralAdminSettingsTask','AdminViewLogs'),
('GeneralAdminSettingsTask','AdminAuthGraph'),
('GeneralAdminSettingsTask','AdminFlowDesigner'),
('GeneralAdminSettingsTask','AdminUserViewLog'),
('GeneralAdminSettingsTask','AdminClearViewHistory'),
('GeneralAdminSettingsTask','AdminCalculateMissingTranslations'),
('GeneralAdminSettingsTask','AdminConvertCustomModules'),
('GeneralAdminSettingsTask','AdminDeleteMenuItem'),
('GeneralAdminSettingsTask','AdminAjaxGetModelAutocomplete'),
('GeneralAdminSettingsTask','AdminGetRoleAccess'),
('GeneralAdminSettingsTask','AdminAutomateTranslation'),
('ActionsReadOnlyAccess','ActionsViewEmail'),
('ActionsViewPrivate','ActionsViewEmail'),
('GuestSiteFunctionsTask','ActionsEmailOpened'),
('CalendarMinimumRequirements','CalendarList'),
('ContactsReadOnlyAccess','ContactsRevisions'),
('ContactsViewPrivate','ContactsRevisions'),
('ContactsUpdateAccess','ContactsSyncAccount'),
('ContactsUpdatePrivate','ContactsSyncAccount'),
('ContactsMinimumRequirements','ContactsGoogleMaps'),
('ContactsMinimumRequirements','ContactsSaveMap'),
('ContactsMinimumRequirements','ContactsSavedMaps'),
('ContactsMinimumRequirements','ContactsDeleteMap'),
('ContactsMinimumRequirements','ContactsUpdateLocation'),
('ContactsAdminAccess','ContactsCleanFailedLeads'),
('GuestSiteFunctionsTask','ContactsWeblead'),
('AuthenticatedSiteFunctionsTask','ContactsWeblead'),
('MarketingReadOnlyAccess','MarketingViewContent'),
('MarketingViewPrivate','MarketingViewContent'),
('GuestSiteFunctionsTask','WeblistWeblist'),
('AuthenticatedSiteFunctionsTask','WeblistWeblist'),
('AuthenticatedSiteFunctionsTask','MediaAjaxUpload'),
('QuotesMinimumRequirements','QuotesIndexInvoice'),
('QuotesUpdateAccess','QuotesConvertToInvoice'),
('QuotesUpdatePrivate','QuotesConvertToInvoice'),
('GuestSiteFunctionsTask','ServicesWebForm'),
('AuthenticatedSiteFunctionsTask','ServicesWebForm'),
('ServicesMinimumRequirements','ServicesStatusFilter'),
('UsersAdminAccess','UsersDeleteTemporary'),
('BugReportsMinimumRequirements','BugReportsIndex'),
('BugReportsIndex','BugReportsMobileIndex'),
('BugReportsIndex','BugReportsAjaxGetModelAutocomplete'),
('BugReportsIndex', 'BugReportsX2GridViewMassAction'),
('BugReportsMinimumRequirements','BugReportsGetItems'),
('BugReportsMinimumRequirements','BugReportsStatusFilter'),
('BugReportsMinimumRequirements','BugReportsDeleteNote'),
('BugReportsMinimumRequirements','BugReportsSearch'),
('BugReportsView','BugReportsMobileView'),
('BugReportsReadOnlyAccess','BugReportsView'),
('BugReportsReadOnlyAccess','BugReportsQuickView'),
('BugReportsReadOnlyAccess','BugReportsMinimumRequirements'),
('BugReportsBasicAccess','BugReportsCreate'),
('BugReportsReadOnlyAccess', 'BugReportsInlineEmail'),
('BugReportsPrivateReadOnlyAccess', 'BugReportsInlineEmail'),
('BugReportsBasicAccess','BugReportsMinimumRequirements'),
('BugReportsUpdateAccess','BugReportsUpdate'),
('BugReportsUpdateAccess','BugReportsGetX2ModelInput'),
('BugReportsPrivateUpdateAccess','BugReportsGetX2ModelInput'),
('BugReportsUpdateAccess','BugReportsMinimumRequirements'),
('BugReportsFullAccess','BugReportsDelete'),
('BugReportsFullAccess','BugReportsMinimumRequirements'),
('BugReportsAdminAccess','BugReportsAdmin'),
('BugReportsAdminAccess','BugReportsMinimumRequirements'),
('BugReportsViewPrivate','BugReportsView'),
('BugReportsViewPrivate','BugReportsQuickView'),
('BugReportsUpdatePrivate','BugReportsUpdate'),
('BugReportsDeletePrivate','BugReportsDelete'),
('BugReportsPrivateReadOnlyAccess','BugReportsMinimumRequirements'),
('BugReportsPrivateReadOnlyAccess','BugReportsViewPrivate'),
('BugReportsPrivateUpdateAccess','BugReportsMinimumRequirements'),
('BugReportsPrivateUpdateAccess','BugReportsUpdatePrivate'),
('BugReportsPrivateFullAccess','BugReportsMinimumRequirements'),
('BugReportsPrivateFullAccess','BugReportsDeletePrivate'),
('ReportsIndex','ReportsAjaxGetModelAutocomplete'),
('WeblistIndex','WeblistAjaxGetModelAutocomplete'),
('WeblistIndex', 'WeblistX2GridViewMassAction'),
('WeblistIndex', 'WeblistInlineEmail'),
('DefaultRole','BugReportsUpdateAccess'),
('DefaultRole','BugReportsBasicAccess'),
('DefaultRole','BugReportsReadOnlyAccess'),
('administrator','BugReportsAdminAccess'),
('administrator','BugReportsFullAccess'),
('administrator','BugReportsUpdateAccess'),
('administrator','BugReportsBasicAccess'),
('administrator','BugReportsReadOnlyAccess');
