<?php
/***********************************************************************************
 * X2Engine Open Source Edition is a customer relationship management program developed by
 * X2 Engine, Inc. Copyright (C) 2011-2019 X2 Engine Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY X2ENGINE, X2ENGINE DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact X2Engine, Inc. P.O. Box 610121, Redwood City,
 * California 94061, USA. or at email address contact@x2engine.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * X2 Engine" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by X2 Engine".
 **********************************************************************************/






Yii::app()->clientScript->registerCss('imageGalleryCss',"

.GalleryEditor .x2-button-group .x2-button {
    margin-right: -4px;
}

.GalleryEditor .image-preview {
    height: inherit;
}

.GalleryEditor .x2-button {
    cursor: pointer;
}

.GalleryEditor .x2-button-group {
    display: inline-block;
    margin-top: 7px;
}

.GalleryEditor .fileinput-button {
    display: inline-block;
}

.GalleryEditor .select_all[type='checkbox'] {
    position: relative;
    top: 3px;
}

.gallery-widget-dialog {
	position: fixed !important;
	padding: 0 0 0 0 !important;
}

.gallery-widget.input-xlarge {
	margin-bottom: 10px;
}

.gallery-widget-image {
	margin: auto;
	position: absolute;
	overflow: auto;
	top: 0;
	left: 0;
	bottom: 0;
	right: 0;
}


");

if($model->galleryBehavior->getGallery() === null){
    echo Yii::t(
        'app', 'A gallery will be created for this model the next time this model is saved.');
}else{
    $this->widget('application.extensions.gallerymanager.GalleryManager', array(
        'gallery' => $model->galleryBehavior->getGallery(),
    ));
}
