<?php
/*
 * Wolf CMS - Content Management Simplified. <http://www.wolfcms.org>
 * Copyright (C) 2009-2010 Martijn van der Kleijn <martijn.niji@gmail.com>
 *
 * This file is part of Wolf CMS. Wolf CMS is licensed under the GNU GPLv3 license.
 * Please see license.txt for the full license text.
 */


/**
 * @package Installer
 */

/* Make sure we've been called using index.php */
if (!defined('INSTALL_SEQUENCE')) {
    echo '<p>Illegal call. Terminating.</p>';
    exit();
}
?>

    <h1>Installation result <img src="install-logo.png" alt="Wolf CMS logo" class="logo" /></h1>
    <?php if (isset($error) && false !== $error): ?>
        <p style="color: red;"><?php echo $error; ?></p>
        <p><a href="index.php">Click here to try again</a></p>
    <?php else: ?>
        <p><?php echo $msg; ?></p><br/>
        <h3>Post install actions</h3>
        <p>
            Wolf CMS was succesfully installed.
            To enhance security <b>you should now:</b>
        </p>
        <ol>
            <li><strong>Run <a href="../../security.php">the security check</a>.</strong></li>
            <li>Delete the <em>wolf/install/</em> folder!</li>
            <li>Remove write permissions from the <em>config.php</em> file! <sup>2)</sup></li>
            <li>Remove the <em>docs/</em> folder and <em>readme.txt</em> to enhance security.</li>
        </ol>
        <h3>Footnotes</h3>
        <p class="footnotes">
            <sup>1)</sup> Be aware: the password is generated by Wolf CMS.
            Use it to login to Wolf CMS and <strong>change your password</strong>!<br/>
            
            <sup>2)</sup> Actually, Wolf CMS will not run unless you remove write permissions from config.php!
        </p>
    <?php endif; ?>