<?php
/*
  $Id$

  WebCollab

  ---------------------------------------
  This program is free software; you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software Foundation;
  either version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
  PARTICULAR PURPOSE. See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with this
  program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
  Cambridge, MA 02139, USA.

  Function:
  ---------

  Help page for 'bg' (Bulgarian)

  Maintainer: Stoyan Dimitrov <stoyan at adiumdesign dot com>

  NOTE: This file is written in UTF-8 character set

*/

//get our location
require_once("path.php" );
require_once(BASE.'path_config.php' );
require_once(BASE_CONFIG.'config.php' );

define('CHARACTER_SET', 'UTF-8' );
define('XML_LANG', "bg" );

include_once(BASE . "includes/screen.php" );

create_top("Помощ", 1 );

$content = "
<a name=\"usergroup\"></a>
<p><b>Потребителски групи:</b></p>
<p>Повечето проекти или задачи имат група на потребители, работещи заедно в една специфична област. Това е група
потребители, които поделят подобна област на работа. Електронните писма за известяване могат да бъдат изпратени към
групата, по-скоро от индивидуален потребител.</p>
<p>Потребителски групи също може да бъдат използвани за контрол на достъп. Той може да бъде ограничен до точно определена 
потребителска група, в този случай другите потребители няма да виждат ограниченият проект / задача, или бъдат способни 
да ги достигат. Ограничението за достъпът може да бъде приложено при ниво на проект или задача чрез използване на избора 
&quot;Видим за всички&quot;.
</p>
<p>Където е възможно, потребителските групи получават собствен поверителен форум за всеки проект или задача.
</p>
<a name=\"taskgroup\"></a>
<p><b>Групи задачи:</b></p>
<p>Разликите между група задачи и потребителска група не са очевидни за начинаещите потребители. Както разликата е следната, потребителска група контролира новото на достъп и поток на информацията, а групите задачи са просто за по-добра четимост на списъка задачи.
</p>
<p>Когато един проект расте, растът и подзадачите му, списъкът им може да е дълъг и не четим. С поставянето на задачи в групи списъкът ще бъде автоматично групиран в подсекции и бъде по-лесен за четене. Задачи, които нямат група, ще бъдат групирани като <i>[без група]</i>
</p>
<p>На кратко: Ако никоя от задачите в проект не е в група от задачи, списъкът на задачите ще бъде дълъг. Ако поне една задача е в група, всички задачи ще бъдат подредени по групи.
</p>
<a name=\"globalaccess\"></a>
<p><b>Видим за всички:</b></p>
<p>Този отметка позволява разглеждането на задача / проект да бъде ограничено само до членовете на избрана потребителска група. Когато има отметка, всички потребители могат да разглеждат задачата / проект. Обратно, когато няма само членове на избрана потребителска група могат да ги разглеждат.
</p>
<p>За задачи: потребител, които не е в избраните групи ще бъде способен да вижда задачите в списъка на проекта, но няма да бъде способен да ги чете.
</p>
<p>За проекти: потребител, които не е в избраните групи няма да бъде способен да вижда нито проекта, нито свързаните с него задачи.
</p>
<p>Ако няма избрана група, този отметка няма значение.
</p>
<a name=\"groupaccess\"></a>
<p><b>Всеки в групата може да променя:</b></p>
Този отметка позволява на всички членове на потребителска група да редактират задача / проект. Когато има отметка, всички членове на дадена група могат да редактират този елемент. Ако няма отметка, само собственикът може да редактира таза задача / проект.
</p>
<p>Ако няма избрана група, този отметка няма значение.
</p>
<a name=\"summarypage\"></a>
<p><b>Съдържание:</b></p>
<p>Страницата на съдържанието съдържа шест колони, които кратко показват състоянието на всяка задача / проект.
</p>
<ul>
<li><b>Флагове</b>:
Показва какво е новото за съответната задача / проект:
<ul>
<li><b>C</b>:<br />
показва, че е съседна</li>
<li><b>M</b>:<br />
показва, че е променяна</li>
<li><b>P</b>:<br />
показва, че е писано мнение във форума на тази задача / проект</li>
<li><b>F</b>:<br />
показва, че е качен файл към задачата</li>
</ul>
Ако има флаг, можете да щракнете върху него за да видите свързаната задача / проект.</li>
<li><b>Краен срок</b>:<br />
Показва кога задачата / проекта се очаква да бъде завършена. Ако датата е в <span class=\"red\">червен цвят</span>, тогава задачата / проектът е просрочена. Ако датата е в <span class=\"green\">зелен</span>, тогава задачата се очаквана да е готова за днес.</li>
<li><b>Статус</b>:<br />
показва работният статус на елемента
<ul>
<li><b>Планиран</b>:<br />
показва, че задачата / проекта скоро е била създадена, но (умиплено) не е планирана</li>
<li><b>Нов</b>:<br />
показва, че задачата / проектът скоро е била създадена и очаква ресурси за да започне</li>
<li><b><span class=\"blue\">В застой</span>:</b><br />
показва, че работата по задачата / проектът е спряна, изчакваща някакво външно събитие</li>
<li><b><span class=\"orange\">Активен</span>:</b><br />
показва. че по задачата / проектът се работи</li>
<li><span class=\"green\">Готов</span>:<br />
показва, че работата е приключила</li>
</ul>
</li>
<li><b>Притежател</b>:<br />
показва, за кого е предназначена тази задача / проект. Можете на кликнете върху името за да видите подробна информация за човека.</li>
<li><b>Група</b>:<br />
показва потребителската или групата задачи свързани с тази задача / проект. Кликването върху заглавната клетка на тази колона, превключва между два вида групи.</li>
<li><b>Задача</b>:<br />
показва име на задачата. Можете да кликнете върху името за да видите повече информация.</li>
</ul>
";
  new_box("Help", $content );
  create_bottom();
?>
