

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `webcollab352`
--


-- --------------------------------------------------------

--
-- Table structure for table `config`
--

CREATE TABLE `config` (
  `email_admin` varchar(200) DEFAULT NULL,
  `reply_to` varchar(200) DEFAULT NULL,
  `email_from` varchar(200) DEFAULT NULL,
  `globalaccess` varchar(50) DEFAULT NULL,
  `groupaccess` varchar(50) DEFAULT NULL,
  `config_owner` varchar(50) DEFAULT NULL,
  `usergroup` varchar(50) DEFAULT NULL,
  `project_order` varchar(200) DEFAULT NULL,
  `task_order` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `config`
--

INSERT INTO `config` VALUES
(NULL, NULL, NULL, 'checked="checked"', '', NULL, NULL, 'ORDER BY task_name', 'ORDER BY task_name');

-- --------------------------------------------------------

--
-- Table structure for table `contacts`
--

CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `firstname` varchar(100) NOT NULL,
  `lastname` varchar(100) NOT NULL,
  `company` varchar(100) DEFAULT NULL,
  `tel_home` varchar(100) DEFAULT NULL,
  `gsm` varchar(100) DEFAULT NULL,
  `fax` varchar(100) DEFAULT NULL,
  `tel_business` varchar(100) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `postal` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `notes` text,
  `email` varchar(100) DEFAULT NULL,
  `added_by` int(10) unsigned NOT NULL,
  `date_mod` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int(10) unsigned NOT NULL,
  `taskid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `contacts_tasks`
--

CREATE TABLE `contacts_tasks` (
  `contact_id` int(11) DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `files`
--

CREATE TABLE `files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fileid` int(10) unsigned NOT NULL DEFAULT '0',
  `hashid` varchar(200) DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `file_size` bigint(20) NOT NULL DEFAULT '0',
  `file_description` text,
  `uploaded` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `uploader` int(10) unsigned NOT NULL,
  `mime` varchar(200) DEFAULT NULL,
  `taskid` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `taskid` (`taskid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `forum`
--

CREATE TABLE `forum` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent` int(10) unsigned NOT NULL,
  `taskid` int(10) unsigned NOT NULL,
  `posted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `edited` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `forum_text` text,
  `userid` int(10) unsigned NOT NULL,
  `usergroupid` int(10) unsigned NOT NULL,
  `sequence` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `taskid` (`taskid`),
  KEY `edited` (`edited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `logins`
--

CREATE TABLE `logins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `session_key` varchar(100) NOT NULL,
  `ip` varchar(100) NOT NULL,
  `lastaccess` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `token` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_key` (`session_key`(10),`user_id`),
  KEY `lastaccess` (`lastaccess`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `logins`
--

-- --------------------------------------------------------

--
-- Table structure for table `login_attempt`
--

CREATE TABLE `login_attempt` (
  `login_name` varchar(100) NOT NULL,
  `ip` varchar(100) NOT NULL,
  `last_attempt` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `maillist`
--

CREATE TABLE `maillist` (
  `email` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `seen`
--

CREATE TABLE `seen` (
  `taskid` int(10) unsigned NOT NULL,
  `userid` int(10) unsigned NOT NULL,
  `seen_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  KEY `taskid` (`taskid`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `site_name`
--

CREATE TABLE `site_name` (
  `manager_name` varchar(100) DEFAULT NULL,
  `abbr_manager_name` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `site_name`
--

INSERT INTO `site_name` VALUES
('[[site_name]]', 'WebCollab');

-- --------------------------------------------------------

--
-- Table structure for table `taskgroups`
--

CREATE TABLE `taskgroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(100) NOT NULL,
  `group_description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `group_name` (`group_name`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tasks`
--

CREATE TABLE `tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent` int(10) unsigned NOT NULL,
  `task_name` varchar(255) NOT NULL,
  `task_text` text,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `edited` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `task_owner` int(10) unsigned NOT NULL DEFAULT '0',
  `creator` int(10) unsigned NOT NULL,
  `finished_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `projectid` int(10) unsigned NOT NULL DEFAULT '0',
  `deadline` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(4) NOT NULL DEFAULT '2',
  `task_status` varchar(20) NOT NULL DEFAULT 'created',
  `taskgroupid` int(10) unsigned NOT NULL,
  `lastforumpost` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `usergroupid` int(10) unsigned NOT NULL,
  `globalaccess` varchar(5) NOT NULL DEFAULT 't',
  `groupaccess` varchar(5) NOT NULL DEFAULT 'f',
  `lastfileupload` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `completed` tinyint(4) NOT NULL DEFAULT '0',
  `completion_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `archive` tinyint(4) NOT NULL DEFAULT '0',
  `sequence` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `task_owner` (`task_owner`),
  KEY `parent` (`parent`),
  KEY `task_name` (`task_name`(10)),
  KEY `projectid` (`projectid`),
  KEY `taskgroupid` (`taskgroupid`),
  KEY `deadline` (`deadline`),
  KEY `task_status` (`task_status`,`parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tokens`
--

CREATE TABLE `tokens` (
  `token` varchar(100) DEFAULT NULL,
  `user_action` varchar(100) DEFAULT NULL,
  `userid` int(10) unsigned NOT NULL,
  `lastaccess` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `usergroups`
--

CREATE TABLE `usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(100) NOT NULL,
  `group_description` varchar(255) DEFAULT NULL,
  `private` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `group_name` (`group_name`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `usergroups_users`
--

CREATE TABLE `usergroups_users` (
  `usergroupid` int(10) unsigned NOT NULL,
  `userid` int(10) unsigned NOT NULL,
  KEY `userid` (`userid`,`usergroupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(200) NOT NULL,
  `fullname` varchar(200) NOT NULL,
  `user_password` varchar(255) NOT NULL,
  `email` varchar(200) NOT NULL,
  `user_admin` varchar(5) NOT NULL DEFAULT 'f',
  `private` tinyint(4) NOT NULL DEFAULT '0',
  `guest` tinyint(4) NOT NULL DEFAULT '0',
  `deleted` varchar(5) NOT NULL DEFAULT 'f',
  `locale` varchar(10) NOT NULL DEFAULT 'en',
  PRIMARY KEY (`id`),
  KEY `fullname` (`fullname`(10))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES
(1, '[[admin_username]]', '[[admin_realname]]', '[[admin_pass]]', '[[admin_email]]', 't', 0, 0, 'f', 'en');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
