<?php
/*
  $Id$

  WebCollab
  ---------------------------------------
  
  This program is free software; you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software Foundation;
  either version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
  PARTICULAR PURPOSE. See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with this
  program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
  Cambridge, MA 02139, USA.

  Function:
  ---------

  Help page
  
  Help files for 'ru' (Russian)

  Translation by Eugene N. Shilaev
  
  NOTE: This file is written in UTF-8 character set

*/

//get our location
require_once("path.php" );
require_once(BASE.'path_config.php' );
require_once(BASE_CONFIG.'config.php' );

define('CHARACTER_SET', 'UTF-8' );
define('XML_LANG', "ru" );

include_once(BASE."includes/screen.php" );

create_top("Справка", 1 );

$content = "
<a name=\"usergroup\"></a>
<p><b>Группа пользователей:</b></p>
<p>Работу над большинством проектов ведут группы людей, работающие вместе в какой-нибудь специфической области. 
Группа пользователей - это группа людей, которые объеденены каким-либо единым признаком. Уведомления по email 
могут быть разосланы сразу всей группе, согласитесь, это удобнее, нежели отписывать письма каждому члену группы.</p>
<p>Группа пользователей также используется для контроля доступом к информации. Ограничения доступа могут быть применены 
сразу для всех членов группы; в этом случае другие пользователи нес могут получить доступ к закрытому проекту или заданию. 
Общий доступ для просмотра может быть произведен посредством переключателя \"Все пользователи могут видеть это\" 
при сохдании или редактирвании проекта или задания.</p>
<p>Там где возможно, группа пользователей имеет свой собственный, закрытый форум, связанный с проектом или заданием.</p>
<br /> 
<a name=\"taskgroup\"></a>
<p><b>Группа заданий:</b></p>
<p>Разница между группой заданий и группой пользователей не кажется слишком очевидной для начинающих пользователей.
Тем не менее, разница существует; Группа пользователей делает возможным контроль доступа к информации; Группа заданий только лишь 
позволяет сделать просмотр заданий более удобным.</p>
<p>Когда проект становится чересчур большим и имеет множество подзаданий, просмотр списка всех заданий становится сам по себе
трудной задачей. Разделение заданий по группам позволяет длинный список заданий разделить на части, 
отсортированные по названиям групп заданий. Задания, не принадлежащие ни одной группе помечены как 'Uncategorised'.</p>
<p>Подытожим:  Если задания не принадлежат ни одной группе заданий - список заданий представляет собой один длинный лист. 
В противном случае, задания отображаются по разделам, носящим наименование групп заданий.</p>
<br />
<a name=\"globalaccess\"></a>
<p><b>Все пользователи могут видеть это?</b></p>
<p>Этот переключатель управляет видимостью задания или проекта, принадлежащего группе пользователей.  
Когда переключатель включен, то это задание/проект доступно для просмотра пользователям, не входящим в группу пользователей. 
если выключен - только члены группы, к которой принадлежит проект/задание могут видеть это.</p>
<p>Задание: Пользователи, которые не входят в группу, к которой принадлежит задание 
будут видеть задание в списке заданий. но не будут иметь к нему доступа.</p>
<p>Проекты: Пользователи, которые не входят в группу, к которой принадлежит проект не будут видеть проект.</p>
<p>Если не выбрана ни одна группа пользователей, этот переключатель не действует.</p>
<a name=\"groupaccess\"><br /></a>
<p><b>Все пользователи группы могут редактировать?</b></p>
<p>Этот переключатель контролирует возможность редактирования членами группы.  Когда преключатель включен 
все члены группы могут вносить изменения в проект или задания, если выключен - изменения доступны только 
координатору проекта или исполнителю задания.</p>
<p>Если не выбрана ни одна группа пользователей, этот переключатель не действует.</p>
<br />
<a name=\"summarypage\"></a>
<p><b>Обзор:</b></p>
<p>Страница \"Обзор\" имеет шесть колонок в которых отображено текущее состояние каждого задания.</p>
<ul>
<li><b>Метки</b>:
показывают что-нибудь новое для задания.
Возможные значения:
<ul>
<li><b>C</b>:<br />
задание было создано<br /></li>
<li><b>M</b>:<br />
задание было изменено<br /></li>
<li><b>P</b>:<br />
в форуме задания появилось новое сообщение<br /></li>
<li><b>F</b>:<br />
был загружен новый файл, касающийся задания<br /></li>
</ul>
Если метка видна, Вы можете кликнуть по ней, для того что бы просмотреть новые или измененные объекты задания.<br /></li>
<li><b>Дата завершения</b>:<br />
когда задание должно быть выполнено.<br />
Если дата подсвечена <span class=\"red\">красным</span>, значит, работа задерживается;
если же дата подсвечена <span class=\"green\">зеленым</span> - работа должна быть закончена сегодня<br /></li>
<li><b>Статус</b>:<br />
указывает на текущее состояние задания:
<ul>
<li><b>Планируется</b>:<br />
задание создано, но еще не сформировано и не задан срок его выполнения, то есть, работа еще не началась.</li>
<li><b>Новое</b>:<br />
задание создано и ожидает начала работы.</li>
<li><span class=\"blue\">Ждем</span>:<br />
работа приостановлена, ожидание некоего события, связанного или непосредственно не связанного с заданием</li>
<li><span class=\"orange\">В работе</span>:<br />
над заданием идет работа</li>
<li><span class=\"green\">Завершен</span>:<br />
работа закончена, всем спасибо, все свободны.<br /></li>
</ul>
</li>
<li><b>Координатор</b>:<br />
пользователь, осуществляющий руководство над проектом или выполняющий задание. 
Вы можете щелкнуть по имени, что бы увидеть дополнительную информацию.<br /></li>
<li><b>Группа</b>:<br />
показывает группы заданий или группы пользователей, которые связаны с конкретным заданием.
если Вы кликнете по заголовку \"Группа\" Вы можете переключать отображение либо по группам заданий,
либо по группам пользователей.<br /></li>
<li><b>Задание</b>:<br />
название задания. Вы можете получить подробную информацию при нажатии на название задания.</li>
</ul>
";
  new_box("Справка", $content );
  create_bottom();
?>
