<?php 
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: showgroup.inc
 *    Description:  Gets all data for showgroup.module, displays group details
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
global $db,$sitepath,$rootpath,$template,$templateimagepath,$joinlink,$isAdmin,$isPrivate,$loggedIn ;
$haltmessage = "" ;
$isPrivate = false ;
$groupDeleted = 0 ;
$showMembers = $_GET['cmd'] == 'smb' ;
$showMedia = $_GET['cmd'] == 'smd' ;
$mainPageLink = '<a href="'.$sitepath.'showgroup/'.$_GET['grp'].'">>>Back to main group page</a>' ;
if (isset($_GET['grp'])) {
	$groupName = str_replace('_', ' ', $_GET['grp']) ;
	$db->query("SELECT * FROM `group` WHERE `name`='".quote_smart($groupName)."'") ;
	if ($db->numRows() < 1) {
		$haltmessage = "The group name does not exist!" ;
	}
	else {
		$res = $db->fetch() ;
		$groupId = $res['group_id'] ;
		$ownerId = $res['owner_id'] ;
		$groupDesc = '"'.$res['group_description'].'"' ;
		$db->query("SELECT * FROM `member` WHERE id=".$ownerId) ;
		$ores = $db->fetch() ;
		$avatarfile = $ores['avatar'] ;
		$avatarpath = "uploads/avatars/".$avatarfile ;
		$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
		$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
		if (@file_exists($avatarpath) && ($avatarfile != "")) {
			$avatar = $sitepath.$avatarpath ;
		}
		$submitted = '<div><a href="'.$sitepath.'profile/'.$ores['username'].'"><img class="thumb" src="'.$avatar.'" alt=""  border=0/></a>
					<p>Created by:<br/>
						<a href="'.$sitepath.'profile/'.$ores['username'].'">'.$ores['username'].'</a> <br/>
					<div class="clear">&nbsp;</div>
					<a class="button" href="'.$sitepath.'profile/'.$ores['username'].'">profile</a></div>' ;
		if ($res['privacy'] == 1) {
			$isPrivate = true ;
		}
	}
	if (($_GET['cmd'] == 'dc') && ($loggedIn)) {
		$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$pres = $db->fetch() ;
		$memberid = $pres['id'] ;
		if (($ownerId == $memberid) || ($isAdmin)) {
			$rowid = $_GET['page'] ;
			if ($rowid > 0) {
				$db->query('DELETE FROM group_comment WHERE id='.$rowid) ;
			}
		}
	}
	if (($_GET['cmd'] == 'confdel') && ($isAdmin)) {
		if ($groupId != '') {
			$db->query("SELECT * FROM `group` WHERE `group_id` = ".$groupId) ;
			if ($db->numRows() > 0) {
				$gres = $db->fetch() ;
				$icon = $gres['icon'] ;
				if ($icon != "") {
					unlink($rootpath.'uploads/groupicons/'.$icon) ;
				}
				$db->query("DELETE FROM `group` WHERE `group_id` = ".$groupId) ;
				$db->query("DELETE FROM `group_comment` WHERE `group_id` = ".$groupId) ;
				$db->query("DELETE FROM `group_member` WHERE `group_id_g` = ".$groupId) ;
				$db->query("SELECT `id`,`mediaurl`,`thumb` FROM `media` WHERE `groupid` = ".$groupId) ;
				if ($db->numRows() > 0) {
					$dres = $db->fetchAll() ;
					foreach ($dres as $key=>$value) {
						if (($value['mediaurl'] != "") && ($value['mediatype'] != 'embed'))
							unlink($rootpath.'uploads/'.$value['mediaurl']) ;
						if ($value['thumb'] != "") {
							unlink($rootpath.'uploads/thumbs/'.$value['thumb'].'.large.jpg') ;
							unlink($rootpath.'uploads/thumbs/'.$value['thumb'].'.small.jpg') ;
						}
					}
				}
				$db->query("DELETE FROM `media` WHERE `groupid` = ".$groupId) ;
				$groupDeleted = 1 ;
			}
		}
	}
	//The next bit of code adds a record when someone has asked to join the group
	//First check the user is logged in
	if (($_GET['cmd'] == "join") && ($loggedIn)) {
		//Get member id
		$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$pres = $db->fetch() ;
		$memberid = $pres['id'] ;
		//Check if member has already joined the group
		$db->query("SELECT * FROM `group_member` WHERE `group_id_g`=".$groupId." AND `member_id`=".$memberid) ;
		if ($db->numRows() < 1) {
			if (getSetting("groupaddnotify", $db) == '1') {
				//Put a message in the group owner's inbox
				$messageAdd = $_SESSION['username'].' has joined your group - "'.$groupName.'", you may need to approve a request (you can do that by <a href="'.$sitepath.'usermenu/managegroup/'.$groupId.'">clicking here</a>)' ;
				$db->query("INSERT INTO message (fromid, toid, body, sentdate, msgread,auto) VALUES (1,".$ownerId.",'".$messageAdd."',".time().",0,1)") ;
			}
			//Now add the record
			if ($isPrivate) {
				//If it is a private group, add it 'unapproved'
				$db->query("INSERT INTO `group_member` (`group_id_g`, `member_id`, `approved`,`joined`) VALUES (".$groupId.",".$memberid.", 0,'".time()."')") ;
			}
			else {
				//If it is public, just auto-approve the member
				$db->query("INSERT INTO `group_member` (`group_id_g`, `member_id`, `approved`,`joined`) VALUES (".$groupId.",".$memberid.", 1,'".time()."')") ;
			}
		}
	}
	//The next bit of code deletes a record when someone has asked to leave the group
	//First check the user is logged in
	if (($_GET['cmd'] == "leave") && ($loggedIn)) {
		//Get member id
		$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$pres = $db->fetch() ;
		$memberid = $pres['id'] ;
		//Check if member has already joined the group
		$db->query("SELECT * FROM `group_member` WHERE `group_id_g`=".$groupId." AND `member_id`=".$memberid) ;
		if ($db->numRows() > 0) {
			$db->query("DELETE FROM `group_member` WHERE `group_id_g`=".$groupId." AND `member_id`=".$memberid) ;
		}
	}
	//Create the link for joining this groups
	$joinlink = $sitepath.'showgroup/'.$_GET['grp'].'/join' ;
	//If the group is private, check the user is logged in and an approved member of this group
	$isAdmin = isset($_SESSION['privs']) && ($_SESSION['privs'] == 7) ;
	if ($isPrivate) {
		//If not show the appropriate message
		if ($loggedIn) {
			$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
			$pres = $db->fetch() ;
			$memberid = $pres['id'] ;
			//Is the user the owner of this group?
			if (($ownerId != $memberid) && (!$isAdmin)) {
				//Is the user a member of this group?
				$db->query("SELECT * FROM `group_member` WHERE `group_id_g`=".$groupId." AND `member_id`=".$memberid) ;
				$approved = 0 ;
				if ($db->numRows() > 0)
				//This user is a member of the group
				{
					$mres = $db->fetch() ;
					$approved = $mres['approved'] ;
					//Check if the member is approved yet
					if ($approved == 0) {
						$haltmessage = "You have requested to join this group. The group owner has not approved your membership yet." ;
					}
				}
				else {
					$haltmessage = "This is a private group, click <a href='".$joinlink."'>here</a> to request group membership" ;
				}
			}
		}
		else {
			$haltmessage = "This is a private group, you need to log in before you can see it" ;
		}
	}
}
else {
	$haltmessage = "Please choose a group before visiting this page" ;
}
$message = "" ;
if (isset($_POST['submit']) && ($_POST['type'] == 'addcomment')) {
	if ((($_SESSION['security_code'] == $_POST['security_code']) && (! empty($_SESSION['security_code']))) || ((getSetting("captchaformembers", $db) == 0) && ($loggedIn))) {
		if (isVisible()) {
			if (! empty($_POST['name'])) {
				$doComment = true ;
				if (! empty($_POST['text'])) {
					$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
					$pres = $db->fetch() ;
					if (!isset($pres['id']))
						$haltMessage = "Invalid user ID" ;
					else
						$posterid = $pres['id'] ;
					if ($doComment) {
						if (strlen($_POST['text']) <= getSetting('comment_length', $db)) {
							$commenttext = quote_smart($_POST['text']) ;
							$commenttext = apply_word_censor($commenttext) ;
							if ($_POST['visitor'] == 'visitorposting') {
								$db->query("INSERT INTO `group_comment` (`group_id`, `leftbyname`, `date`, `comment`,`regdposter`) VALUES ('".$groupId."', '".quote_smart($_POST['name'])."', '".time()."', '".$commenttext."',0);") ;
							}
							else {
								$db->query("INSERT INTO `group_comment` (`group_id`, `leftbyname`, `date`, `comment`,`regdposter`) VALUES ('".$groupId."', '".quote_smart($_SESSION['username'])."', '".time()."', '".$commenttext."',1);") ;
							}
							$message = '<b>Your comment was added successfully. Thank you.</b>' ;
						}
						else {
							$message = '<blink><b>Your comment is too long, please make it less then '.getSetting('comment_length', $db).' characters.</b></blink>' ;
						}
					}
				}
			}
			else {
				$message = '<blink><b>You did not enter a comment! Please try again</b></blink>' ;
			}
		}
	}
	else {
		$message = '<blink><b>Please enter the security code on the form</b></blink>' ;
	}
}
function displayGroupOwner($res) {
	global $db,$sitepath,$templateimagepath ;
	$size = sizeof($res) ;
	$output = '' ;
	$avatargender = $res['gender'] > 0 ? 'female' : 'male' ;
	$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
	if (@file_exists("uploads/avatars/".$res['avatar']) && ($res['avatar'] != "")) {
		$avatar = $sitepath."uploads/avatars/".$res['avatar'] ;
	}
	$avatar = str_replace(" ", "%20", $avatar) ;
	$id = $res['id'] ;
	$username = $res['username'] ;
	$db->query("SELECT id FROM media WHERE status='true' AND poster ='".$username."'".$hide." ORDER BY allviews DESC") ;
	$mediacount = $db->numRows() ;
	$rres = $db->fetch() ;
	$db->query("SELECT * FROM member LEFT JOIN friend ON (member.id = friend.friendid OR member.id = friend.userid) WHERE (friend.userid =".$id." OR friend.friendid =".$id.") AND (username!='".$username."') AND friend.friend_removed=0 AND friend.friend_approved=1 GROUP BY member.id") ;
	$friendcount = $db->numRows() ;
	$output .= "<li><a href=\"".$sitepath."profile/$username\"><img class='thumb' width=".getSetting("avatar_w", $db)."px height=".getSetting("avatar_h", $db)."px class='thumb' src='".$avatar."' /></a>\n" ;
	$res['username'] = force_length($res['username'], 25) ;
	$output .= "<p><a href=\"".$sitepath."profile/$username\">".$res['username']."</a></p><h4>friends: $friendcount</h4><h4>media: $mediacount</h4><h4>profile views: ".$res['profileviews']."</h4>" ;
	$output .= "</li>\n" ;
	$output .= "<li class=\"clear\">&nbsp;</li>\n" ;
	$output .= "</ul>" ;
	return $output ;
}
function date_diff($str_start, $str_end) {
	$defdate = $str_start ;
	$str_start = strtotime($str_start) ;
	$str_end = strtotime($str_end) ;
	$nseconds = $str_end - $str_start ;
	$ndays = floor($nseconds / 86400) ;
	$nseconds = $nseconds % 86400 ;
	$nhours = floor($nseconds / 3600) ;
	$nseconds = $nseconds % 3600 ;
	$nminutes = floor($nseconds / 60) ;
	$nseconds = $nseconds % 60 ;
	$retString = "" ;
	if ($ndays > 0) {
		$retString .= $defdate ;
		return "at  ".$retString ;
	}
	if ($nhours > 0) {
		$retString .= " ".$nhours." hour" ;
		if ($nhours > 1)
			$retString .= "s" ;
	}
	if ($nminutes > 0) {
		$retString .= " ".$nminutes." minute" ;
		if ($nminutes > 1)
			$retString .= "s" ;
	}
	if (strcmp($retString, "") == 0)
		$retString = "< 1 minute" ;
	return $retString." ago" ;
}
function addCommentLink() {
	global $db ;
	$sitefolder = getSetting("sitefolder", $db) ;
	$sitetemplate = getSetting("sitetemplate", $db) ;
	$rootpath = $_SERVER['DOCUMENT_ROOT'].$sitefolder ;
	$path = "http://".$_SERVER['SERVER_NAME'].$sitefolder ;
	$link = $path."profile/".$_GET['user'].'?action=addcomment' ;
	return $link ;
}
function commentCount() {
	global $db ;
	$username = quote_smart($_GET['user']) ;
	$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
	$res = $db->fetch() ;
	$loggedInid = $res['id'] ;
	$db->query("SELECT * FROM profile_comment WHERE userid = ".$loggedInid) ;
	$count = $db->numRows() ;
	return $count ;
}
function getGroupComments() {
	global $db,$loggedIn,$sitepath,$templateimagepath ;
	if ($_GET['grp'] != "") {
		$groupname = str_replace('_', ' ', $_GET['grp']) ;
		$db->query("SELECT * FROM `group` WHERE `name` = '".quote_smart($groupname)."'") ;
		$res = $db->fetch() ;
		$groupid = $res['group_id'] ;
		$ownerId = $res['owner_id'] ;
		$db->query("SELECT * FROM `group_comment` WHERE `group_id` =".$groupid." ORDER BY `date` DESC") ;
		$result = $db->fetchAll() ;
		$comments = "" ;
		$perpage = getsetting("groupcommentspp", $db) ;
		$size = sizeof($result) ;
		$pages = ceil(sizeof($result) / $perpage) ;
		$url = $sitepath.'showgroup/'.$_GET['grp'].'/' ;
		if ((isset($_GET['page'])) && ($_GET['cmd'] == "gc"))
			$page = $_GET['page'] ;
		else
			$page = 1 ;
		if ($page < 1)
			$page = 1 ;
		$pageLinks = "<div align=right>" ;
		$pp = $page - 1 ;
		if ($pp >= 1) {
			$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
		}
		if ($pages > 10 && $page > 6) {
			if (!$nomr) {
				$pageLinks .= "<a href='".$url."gc/1'>1</a> ... " ;
			}
			else {
				$pageLinks .= "<a href='".$url."gc/1'>1</a> ... " ;
			}
		}
		$p = 1 ;
		$stopat = ($pages <= 10) ? $pages : 10 ;
		if ($pages > 10 && $page > 5) {
			$p = $page - 5 ;
			$stopat = $page + 5 ;
			if ($stopat > $pages)
				$stopat = $pages ;
		}
		for ($p; $p <= $stopat; $p++) {
			if (!$nomr) {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."gc/".$p."'>$p</a> " ;
			}
			else {
				if ($p == $page)
					$pageLinks .= "$p " ;
				else
					$pageLinks .= "<a href='".$url."gc/".$p."'>$p</a> " ;
			}
		}
		if ($pages > 10) {
			if (!$nomr) {
				$pageLinks .= "... <a href='".$url."gc/".$pages."'>$pages</a>" ;
			}
			else {
				$pageLinks .= "... <a href='".$url."gc/".$pages."'>$pages</a>" ;
			}
		}
		$np = $page + 1 ;
		if ($np <= $pages) {
			$pageLinks .= "<a class=\"nextp\" href='".$url."gc/".$np."'>Next Page</a>" ;
		}
		$pageLinks .= "</div>" ;
		$count = 0 ;
		$page-- ;
		//Clear previous page results
		$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$res = $db->fetch() ;
		$loggedInid = $res['id'] ;
		for ($i = 0; $i < $perpage * $page; $i++)
			unset($result[$i]) ;
		$colcount = 0 ;
		$comments = '' ;
		foreach ($result as $key=>$row) {
			$postername = $row['leftbyname'] ;
			if (((isset($_SESSION['privs']) && $_SESSION['privs'] == 7) || ($ownerId == $loggedInid)) && ($loggedIn)) {
				$del = '<div align=right><a href="'.$sitepath.'showgroup/'.$_GET['grp'].'/dc/'.$row['id'].'">delete this comment</a></div>' ;
			}
			else {
				$del = '' ;
			}
			if ($row['regdposter'] == 1) {
				$posterString = '<a href="'.$sitepath.'profile/'.htmlentities($row['leftbyname']).'">'.htmlentities($row['leftbyname']).'</a>' ;
				$db->query("SELECT * FROM `member` WHERE `username` = '".quote_smart($row['leftbyname'])."'") ;
				$user = $db->fetch() ;
				if (($user['avatar'] == '') || ($db->numRows() < 1)) {
					$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
					$avatar_tag = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
				}
				else {
					$avatar_tag = $sitepath.'uploads/avatars/'.$user['avatar'] ;
				}
			}
			else {
				$posterString = htmlentities($row['leftbyname'])." (visitor)" ;
				$avatar_tag = $sitepath.'uploads/avatars/default_avatar.jpg' ;
			}
			$str_today = date("Y-m-d H:i:s") ;
			$comments .= '<dl class="no-format full-com2"><dt><a href="'.$sitepath.'profile/'.htmlentities($postername).'"><img width=30px height=30px class="thumb" src="'.$avatar_tag.'" alt="" /></a><b>'.$posterString.' </b></dt>' ;
			$comments .= '<dd>'.nl2br(($row['comment'])).$del.'</dd><h4>'.date_diff(date("Y-m-d H:i:s", $row["date"]), $str_today).'</h4></dl>' ;
			$count++ ;
			if ($count == $perpage)
				break ;
		}
		if ($pages > 1) {
			$comments .= $pageLinks ;
		}
		$comments .= '' ;
		$comments .= '<div>' ;
		if (!$loggedIn) {
			$comments .= '<h2>Please log in to comment</h2>' ;
		}
		else {
			$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
			$pres = $db->fetch() ;
			$memberid = $pres['id'] ;
			$db->query("SELECT * FROM `group_member` WHERE `group_id_g`=".$groupid." AND `member_id`=".$memberid." AND `approved`=1") ;
			$isMember = $db->numRows() > 0 ;
			$joinlink = $sitepath.'showgroup/'.$_GET['grp'].'/join' ;
			if (($ownerId == $memberid) || ($isAdmin) || ($isMember)) {
				$comments .= '<h2>Add comment</h2><form action="" method="post"><input type="hidden" name="type" value="addcomment">' ;
				if ($loggedIn) {
					$comments .= '<input type="hidden" id="name" name="name" value="'.$_SESSION['username'].'"/>' ;
				}
				else {
					$comments .= '<li><label for="name" class="comment">name</label>
					<input type="hidden" id="visitor" name="visitor" value="visitorposting">
					<input id="name" name="name"  />
					</li>' ;
				}
				$comments .= '<div id="message"><textarea name="text"></textarea></div>' ;
				if ((!$loggedIn) || (getSetting("captchaformembers", $db) == 1)) {
					$comments .= '<p><img src="'.$sitepath.'includes/CaptchaSecurityImages.php" /><br>Enter code above<br>
<input id="security_code" name="security_code" type="text" size="6"/></p>' ;
				}
				$comments .= '<p><input class="biggerbutton" type="submit" name="submit" value="Post comment" style="margin-right: 30px;"/></p>			
				</form><br />'.$message ;
			}
			else {
				$comments .= '<h2>You must be a group member to post comments or upload media to this group - <a href="'.$joinlink.'">click here</a> to join</h2>' ;
			}
		}
		$comments .= '</div>' ;
	}
	return $comments ;
}
function displayMyMedia($res, $page = 1, $url = "", $filter) {
	global $db,$sitepath,$templateimagepath ;
	$perpage = getSetting("groupmediapp", $db) ;
	$pages = ceil(sizeof($res) / $perpage) ;
	$path = getSetting("sitefolder", $db) ;
	$pageLinks = "" ;
	//Page formatting
	$pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
		else {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
		else {
			if ($p == $page)
				$pageLinks .= "$p " ;
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
		else {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
	}
	$pageLinks .= "</div></div></div></div>" ;
	$output = '<ul class="no-format vert-list">' ;
	$count = 0 ;
	$page-- ;
	//Clear previous page results
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$count++ ;
			if ($count == getSetting("adsense_pos1", $db) || $count == getSetting("adsense_pos2", $db))
				$output .= getAdmedia() ;
			$thumbpath = "http://".$_SERVER['SERVER_NAME'].$path.'uploads/thumbs/' ;
			if (checkHideThumbnails() && ($value['requires_agreement'] == 1)) {
				$thumb = $thumbpath."default_mature_thumb.jpg" ;
			}
			else {
				if (@file_exists($thumbpath.$value['thumb'].".small.jpg"))
					$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
				elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg"))
					$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
				elseif (@file_exists(str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb'])))
					$thumb = $sitepath.str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb']) ;
				elseif (findThumb($value['thumb'], true)) {
					$thumb = findThumb($value['thumb'], true) ;
					$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
				}
				$thumb = str_replace(" ", "%20", $thumb) ;
				if ($value['thumb'] == '') {
					$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
				}
			}
			$kat = getCategoryPath($value['category']) ;
			$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
			$resR = $db->fetch() ;
			$title = url_encode($value['title']) ;
			$vidid = $value['vidid'] ;
			$removelink = $sitepath."usermenu/rfav/".$vidid ;
			$title = url_encode($value['title']) ;
			$output .= "<li><a href=\"".$sitepath."play$kat/$title\"><img class='thumb' src='$thumb' />\n" ;
			$value['title'] = force_length($value['title'], 55) ;
			$output .= "<h3>&nbsp;".str_replace("_", " ", $title)."</a><span class=\"rating\">".show_rating($value['id'])."</span></h3>\n" ;
			$value['description'] = force_length($value['description'], 130) ;
			$output .= "<h4><b>&nbsp;&nbsp;".$value['description']."</b></h4>" ;
			$tags = strtolower($value['tags']) ;
			$taglinks = getTagLinks($tags) ;
			if (str_replace(" ", "", $tags) != '') {
				$output .= "<p>&nbsp;&nbsp;tags: $taglinks</p>" ;
			}
			else {
				$output .= "<p>&nbsp;</p>" ;
			}
			if (($filter == "all") || ($filter == "")) {
				$viewstring = $value['allviews'] ;
			}
			else if ($filter == "today") {
				$viewstring = $value['dayviews'] ;
			}
			else if ($filter == "week") {
				$viewstring = $value['weekviews'] ;
			}
			else if ($filter == "month") {
				$viewstring = $value['monthviews'] ;
			}
			if ($viewstring == '') {
				$viewstring = 0 ;
			}
			$output .= "<div class=\"inf\"><div class=\"inf-right\"><b>From <a href=\"#\">".$value['poster']."</a> on:</b> ".date("m.d.y", $value['added'])."<span class=\"views\"><b>views:</b> ".$viewstring ;
			$output .= "</span></div></div>" ;
			$output .= "</li>\n" ;
			if ($count == $perpage)
				break ;
		}
	}
	$output .= "</ul>" ;
	if ($pages != 1)
		$output .= $pageLinks ;
	return $output ;
}
function display5MyMedia($res, $page = 1, $url = "", $filter) {
	global $db,$sitepath,$templateimagepath ;
	$path = getSetting("sitefolder", $db) ;
	$output = '<ul class="no-format horiz-thumbs-list">' ;
	$count = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$count++ ;
			$thumbpath = "http://".$_SERVER['SERVER_NAME'].$path.'uploads/thumbs/' ;
			if (checkHideThumbnails() && ($value['requires_agreement'] == 1)) {
				$thumb = $thumbpath."default_mature_thumb.jpg" ;
			}
			else {
				if (@file_exists($thumbpath.$value['thumb'].".small.jpg"))
					$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
				elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg"))
					$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
				elseif (@file_exists(str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb'])))
					$thumb = $sitepath.str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb']) ;
				elseif (findThumb($value['thumb'], true)) {
					$thumb = findThumb($value['thumb'], true) ;
					$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
				}
				$thumb = str_replace(" ", "%20", $thumb) ;
				if ($value['thumb'] == '') {
					$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
				}
			}
			$kat = getCategoryPath($value['category']) ;
			$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
			$resR = $db->fetch() ;
			$title = url_encode($value['title']) ;
			$vidid = $value['vidid'] ;
			$removelink = $sitepath."usermenu/rfav/".$vidid ;
			$title = url_encode($value['title']) ;
			$output .= "<li><a href=\"".$sitepath."play$kat/$title\"><img class='thumb' src='$thumb' /></a>\n" ;
			$value['username'] = force_length($value['username'], 25) ;
			$value['title'] = force_length($value['title'], 55) ;
			$output .= "<h4>".str_replace("_", " ", $title)."</h4><p><span class=\"rating\">".show_rating($value['id'])."</span></p>" ;
			$output .= "</li>\n" ;
		}
	}
	$output .= "<li class=\"clear\">&nbsp;</li>\n" ;
	$output .= "</ul>\n" ;
	return $output ;
}
function getMemStatus() {
	global $db,$sitepath,$loggedIn,$joinlink,$isPrivate ;
	$message = "" ;
	if ($isPrivate) {
		$privateString = "private " ;
	}
	else {
		$privateString = "public" ;
	}
	$isAdmin = isset($_SESSION['privs']) && ($_SESSION['privs'] == 7) ;
	if ($loggedIn) {
		if (isset($_GET['grp'])) {
			$groupName = str_replace('_', ' ', $_GET['grp']) ;
			$db->query("SELECT * FROM `group` WHERE `name`='".quote_smart($groupName)."'") ;
			if ($db->numRows() < 1) {
				$haltmessage = "The group name does not exist!<br>" ;
			}
			else {
				$res = $db->fetch() ;
				$groupId = $res['group_id'] ;
				$ownerId = $res['owner_id'] ;
				$privacy = $res['privacy'] ;
				$suspended = $res['suspended'] > 0 ;
			}
		}
		if ($suspended) {
			$message = "This group has been suspended by the group owner<br>" ;
		}
		else {
			$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
			$pres = $db->fetch() ;
			$memberid = $pres['id'] ;
			if (($ownerId != $memberid) && (!$isAdmin)) {
				$db->query("SELECT * FROM `group_member` WHERE (`group_id_g` = ".$groupId." AND `member_id` = ".$memberid.")") ;
				$approved = false ;
				$isMember = false ;
				if ($db->numRows() > 0) {
					$isMember = true ;
					$mres = $db->fetch() ;
					if ($mres['approved'] == 1) {
						$approved = true ;
					}
				}
				if ($isMember) {
					if ($approved) {
						$message = "You are a member of this $privateString group<br>" ;
					}
					else {
						$message = "The group owner has not approved you yet<br>" ;
					}
				}
				else {
					$message = "<a href='".$joinlink."'>Click here to join this $privateString group</a><br>" ;
				}
			}
			else {
				if (!$isAdmin) {
					$message = "You created this $privateString group" ;
				}
			}
		}
	}
	else {
		$message = "(Log in if you are a member of this $privateString group or would like to join)" ;
	}
	return $message ;
}
function isVisible() {
	global $db,$sitepath,$loggedIn,$joinlink,$isPrivate ;
	$message = "" ;
	$result = false ;
	if (isset($_GET['grp'])) {
		$groupName = str_replace('_', ' ', $_GET['grp']) ;
		$db->query("SELECT * FROM `group` WHERE `name`='".quote_smart($groupName)."' AND (`suspended`!=1 OR `suspended` IS NULL) ") ;
		if ($db->numRows() < 1) {
			$haltmessage = "The group name does not exist!" ;
		}
		else {
			if ($res['privacy'] == 1) {
				if ($loggedIn) {
					$res = $db->fetch() ;
					$groupId = $res['group_id'] ;
					$ownerId = $res['owner_id'] ;
					$db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
					$pres = $db->fetch() ;
					$memberid = $pres['id'] ;
					$isAdmin = isset($_SESSION['privs']) && ($_SESSION['privs'] == 7) ;
					if (($ownerId != $memberid) && (!$isAdmin)) {
						$db->query("SELECT * FROM `group_member` WHERE (`group_id_g` = ".$groupId." AND `member_id` = ".$memberid.")") ;
						$approved = false ;
						$isMember = false ;
						if ($db->numRows() > 0) {
							$isMember = true ;
							$mres = $db->fetch() ;
							if ($mres['approved'] == 1) {
								$approved = true ;
							}
						}
						if (($isMember) && ($approved)) {
							$result = true ;
						}
					}
					else {
						$result = true ;
					}
				}
				else {
					//log in to view private
					$result = false ;
				}
			}
			else {
				$result = true ;
			}
		}
	}
	return $result ;
}
function groupOwner() {
	global $db,$sitepath ;
	if (isset($_GET['grp'])) {
		$groupName = str_replace('_', ' ', $_GET['grp']) ;
		$db->query("SELECT * FROM `group` WHERE `name`='".quote_smart($groupName)."'") ;
		$res = $db->fetch() ;
		$groupId = $res['group_id'] ;
		$ownerId = $res['owner_id'] ;
	}
	$messages = '' ;
	$db->query("SELECT * FROM `member` WHERE id=".$ownerId) ;
	$ores = $db->fetch() ;
	$messages .= displayGroupOwner($ores) ;
	return $messages ;
}
function get5GroupMembers() {
	global $db,$sitepath ;
	if (isset($_GET['grp'])) {
		$groupName = str_replace('_', ' ', $_GET['grp']) ;
		$db->query("SELECT * FROM `group` WHERE `name`='".quote_smart($groupName)."'") ;
		$res = $db->fetch() ;
		$groupId = $res['group_id'] ;
		$ownerId = $res['owner_id'] ;
	}
	$messages = '' ;
	$memberquery = "SELECT * FROM `member` LEFT JOIN `group_member` ON `group_member`.`member_id` = `member`.`id` WHERE `group_member`.`group_id_g` = ".$groupId." AND `approved`=1 ORDER BY joined DESC LIMIT 5" ;
	$db->query($memberquery) ;
	if ($db->numRows() > 0) {
		$resLV = $db->fetchAll() ;
		$messages .= display5GroupMembers($resLV, $_GET['page'], $sitepath."showgroup/".$_GET['grp']."/smb") ;
	}
	else {
		$messages .= "<h2><b>This group doesn't have any members yet</b></h2>" ;
	}
	return $messages ;
}
function groupMembers() {
	global $db,$sitepath ;
	if (isset($_GET['grp'])) {
		$groupName = str_replace('_', ' ', $_GET['grp']) ;
		$db->query("SELECT * FROM `group` WHERE `name`='".quote_smart($groupName)."'") ;
		$res = $db->fetch() ;
		$groupId = $res['group_id'] ;
		$ownerId = $res['owner_id'] ;
	}
	$messages = '' ;
	$memberquery = "SELECT * FROM `member` LEFT JOIN `group_member` ON `group_member`.`member_id` = `member`.`id` WHERE `group_member`.`group_id_g` = ".$groupId." AND `approved`=1" ;
	$db->query($memberquery) ;
	if ($db->numRows() > 0) {
		$messages .= '<br><h1><b>Group</b> Members</h1>' ;
		$resLV = $db->fetchAll() ;
		if ((isset($_GET['page'])) && ($_GET['cmd'] == "smb"))
			$messages .= displayGroupMembers($resLV, $_GET['page'], $sitepath."showgroup/".$_GET['grp']."/smb") ;
		else
			$messages .= displayGroupMembers($resLV, 1, $sitepath."showgroup/".$_GET['grp']."/smb") ;
	}
	else {
		$messages .= "<br><h1><b>Group</b> Members</h1><h2><b>This group doesn't have any members yet</b></h2>" ;
	}
	return $messages ;
}
function groupRecentMembers() {
	global $db,$sitepath ;
	$messages = get5GroupMembers() ;
	$messages .= '<h3><a href="'.$sitepath.'showgroup/'.$_GET['grp'].'/smb">show all group members</a></h3><br><br>' ;
	return $messages ;
}
function groupRecentMedia() {
	global $db,$sitepath ;
	$messages = get5GroupMedia() ;
	$messages .= '<h3><a href="'.$sitepath.'showgroup/'.$_GET['grp'].'/smd">show all group media</a></h3><br><br>' ;
	return $messages ;
}
function groupMedia() {
	global $db,$sitepath,$template,$templateimagepath ;
	if (checkHideMedia() == 1) {
		$hide = " AND (`requires_agreement` = 0)" ;
	}
	else {
		$hide = "" ;
	}
	$today = mktime(0, 0, 0, date("m"), date("d"), date("Y")) ;
	$startofyear = mktime(0, 0, 0, 1, 0, date("Y")) ;
	$aweek = 60 * 60 * 24 * 7 ;
	$startofweek = $startofyear + ($aweek * (intval(date("W") - 1))) ;
	$startofmonth = mktime(0, 0, 0, date("m"), 1, date("Y")) ;
	$mostviewed = false ;
	$toprated = false ;
	$recent = false ;
	if (isset($_POST['mostviewedsubmit'])) {
		$mostviewed = true ;
		if ($_POST['mostviewed'] == "alltime") {
			$mvalltimesel = "SELECTED" ;
			$filterstring = "ORDER BY allviews DESC" ;
			$filter = "all" ;
		}
		if ($_POST['mostviewed'] == "today") {
			$mvtodaysel = "SELECTED" ;
			$filterstring = "ORDER BY dayviews DESC" ;
			$filter = "today" ;
		}
		if ($_POST['mostviewed'] == "thisweek") {
			$mvweeksel = "SELECTED" ;
			$filterstring = "ORDER BY weekviews DESC" ;
			$filter = "week" ;
		}
		if ($_POST['mostviewed'] == "thismonth") {
			$mvmonthsel = "SELECTED" ;
			$filterstring = "ORDER BY monthviews DESC" ;
			$filter = "month" ;
		}
	}
	if (isset($_POST['recentsubmit'])) {
		$recent = true ;
		if ($_POST['recent'] == "today") {
			$rctodaysel = "SELECTED" ;
			$filterstring = "AND (added>".$today.") ORDER BY added DESC" ;
		}
		if ($_POST['recent'] == "thisweek") {
			$rcweeksel = "SELECTED" ;
			$filterstring = "AND (added>".$startofweek.") ORDER BY added DESC" ;
		}
		if ($_POST['recent'] == "thismonth") {
			$rcmonthsel = "SELECTED" ;
			$filterstring = "AND (added>".$startofmonth.") ORDER BY added DESC" ;
		}
	}
	if (isset($_POST['topratedsubmit'])) {
		$toprated = true ;
	}
	$filterlink = "<div align=right><form action=\"\" method=\"POST\" name=\"orderform\">most viewed&nbsp;<select name=\"mostviewed\">
	<option value=\"alltime\" ".$mvalltimesel.">all time</option>
	<option value=\"today\" ".$mvtodaysel.">today</option>
	<option value=\"thisweek\" ".$mvweeksel.">this week</option>
	<option value=\"thismonth\" ".$mvmonthsel.">this month</option>
	</select>&nbsp;<input class=\"biggerbutton\" type=\"submit\" name=\"mostviewedsubmit\" value=\"go\">&nbsp;&nbsp;&nbsp;&nbsp;" ;
	$filterlink .= "&nbsp;recently uploaded&nbsp;<select name=\"recent\" >
	<option value=\"today\" ".$rctodaysel.">today</option>
	<option value=\"thisweek\" ".$rcweeksel.">this week</option>
	<option value=\"thismonth\" ".$rcmonthsel.">this month</option>
	</select>&nbsp;<input class=\"biggerbutton\" type=\"submit\" name=\"recentsubmit\" value=\"go\">&nbsp;&nbsp;&nbsp;&nbsp;top rated&nbsp;<input class=\"biggerbutton\" type=\"submit\" name=\"topratedsubmit\" value=\"go\"></form></div>" ;
	if (isset($_GET['grp'])) {
		$groupName = str_replace('_', ' ', $_GET['grp']) ;
		$db->query("SELECT * FROM `group` WHERE `name`='".quote_smart($groupName)."'") ;
		$res = $db->fetch() ;
		$groupId = $res['group_id'] ;
	}
	$groupquery = "SELECT * FROM media WHERE status='true' AND groupid =".$groupId.$hide." ORDER BY allviews DESC" ;
	if (($mostviewed) || ($recent)) {
		$groupquery = "SELECT * FROM media WHERE status='true' AND groupid =".$groupId.$hide." ".$filterstring ;
	}
	else if ($toprated) {
		$groupquery = "SELECT v.*, g.*, (r.total_value/r.total_votes) as rating FROM media v LEFT JOIN rating r ON r.id = v.id LEFT JOIN `group` g ON g.group_id = v.groupid WHERE v.status = 'true' AND (`suspended`!=1 OR `suspended` IS NULL) AND (v.groupid=".$groupId.") ".$hide." ORDER BY (r.total_value/r.total_votes) DESC" ;
	}
	$messages .= $filterlink.'<br><br>' ;
	$db->query($groupquery) ;
	if (($db->numRows() > 0) && ($groupId != 0)) {
		$resLV = $db->fetchAll() ;
		if ((isset($_GET['page'])) && ($_GET['cmd'] == "smd"))
			$messages .= displayMyMedia($resLV, $_GET['page'], $sitepath."showgroup/".$_GET['grp']."/smd", $filter) ;
		else
			$messages .= '<br><br>'.displayMyMedia($resLV, 1, $sitepath."showgroup/".$_GET['grp']."/smd", $filter) ;
	}
	else {
		$messages .= "<h2><b>There is no media to display</b></h2><br><br" ;
	}
	$messages .= '' ;
	if (!isVisible()) {
		$messages = '' ;
	}
	return $messages ;
}
function get5GroupMedia() {
	global $db,$sitepath,$template,$templateimagepath ;
	if (checkHideMedia() == 1) {
		$hide = " AND (`requires_agreement` = 0)" ;
	}
	else {
		$hide = "" ;
	}
	if (isset($_GET['grp'])) {
		$groupName = str_replace('_', ' ', $_GET['grp']) ;
		$db->query("SELECT * FROM `group` WHERE `name`='".quote_smart($groupName)."'") ;
		$res = $db->fetch() ;
		$groupId = $res['group_id'] ;
	}
	$groupquery = "SELECT * FROM media WHERE status='true' AND groupid =".$groupId.$hide." ORDER BY added DESC LIMIT 5" ;
	$db->query($groupquery) ;
	if (($db->numRows() > 0) && ($groupId != 0)) {
		$resLV = $db->fetchAll() ;
		$messages .= display5MyMedia($resLV, $_GET['page'], $sitepath."showgroup/".$_GET['grp']."/smd", $filter) ;
	}
	else {
		$messages .= "<h2><b>There is no media to display</b></h2><br><br" ;
	}
	$messages .= '' ;
	if (!isVisible()) {
		$messages = '' ;
	}
	return $messages ;
}
function groupComments() {
	global $templateimagepath ;
	if (isVisible()) {
		$output = '<h1><img src="'.$templateimagepath.'icn_latest_media.jpg" alt="" /><b>Comments</b></h1>'.getGroupComments() ;
	}
	else {
		$ouput = '' ;
	}
	return $output ;
}
function groupMembershipStatus() {
	global $isAdmin,$sitepath ;
	$output = "<br>" ;
	if ($isAdmin) {
		if ($_GET['cmd'] == 'del') {
			$output .= "<a href='".$sitepath."showgroup/".$_GET['grp']."/confdel'>If you click this link, ALL media in this group will be removed from the site completely! Only click this link if you are sure you want to delete the group and all the media it contains</a><br><br>" ;
		}
		else {
			$output .= "<a href='".$sitepath."showgroup/".$_GET['grp']."/del'>Delete this group including all media in the group</a><br><br>" ;
		}
	}
	return $output ;
}
function displayGroupMembers($res, $page = 1, $url) {
	global $db,$sitepath,$templateimagepath ;
	$perpage = getsetting("groupmemberpp", $db) ;
	$size = sizeof($res) ;
	$pages = ceil(sizeof($res) / $perpage) ;
	$pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= "<a class=\"prevp\" href='".$url."/".$pp."'>Previous Page</a>" ;
	}
	if ($pages > 10 && $page > 6) {
		if (!$nomr) {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
		else {
			$pageLinks .= "<a href='".$url."/1'>1</a> ... " ;
		}
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if (!$nomr) {
			if ($p == $page)
				if ($pages > 1) {
					$pageLinks .= "<em>$p</em> " ;
				}
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
		else {
			if ($p == $page)
				if ($pages > 1) {
					$pageLinks .= "<em>$p</em> " ;
				}
			else
				$pageLinks .= "<a href='".$url."/".$p."'>$p</a> " ;
		}
	}
	if ($pages > 10) {
		if (!$nomr) {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
		else {
			$pageLinks .= "... <a href='".$url."/".$pages."'>$pages</a>" ;
		}
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= "<a class=\"nextp\" href='".$url."/".$np."'>Next Page</a>" ;
	}
	$pageLinks .= "</div></div></div></div>" ;
	$output = '' ;
	$count = 0 ;
	$page-- ;
	//Clear previous page results
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	$colcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['activationkey'] == 0) {
			$count++ ;
			$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
			$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
			if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
				$avatar = $sitepath."uploads/avatars/".$value['avatar'] ;
			}
			$avatar = str_replace(" ", "%20", $avatar) ;
			$id = $value['id'] ;
			$username = $value['username'] ;
			$db->query("SELECT id FROM media WHERE status='true' AND poster ='".$username."'".$hide." ORDER BY allviews DESC") ;
			$mediacount = $db->numRows() ;
			$rres = $db->fetch() ;
			$db->query("SELECT * FROM member LEFT JOIN friend ON (member.id = friend.friendid OR member.id = friend.userid) WHERE (friend.userid =".$id." OR friend.friendid =".$id.") AND (username!='".$username."') AND friend.friend_removed=0 AND friend.friend_approved=1 GROUP BY member.id") ;
			$friendcount = $db->numRows() ;
			$output .= "<li><a href=\"".$sitepath."profile/$username\"><img class='thumb' width=".getSetting("avatar_w", $db)."px height=".getSetting("avatar_h", $db)."px class='thumb' src='".$avatar."' /></a>\n" ;
			$value['username'] = force_length($value['username'], 25) ;
			$output .= "<p><a href=\"".$sitepath."profile/$username\">".$value['username']."</a></p><h4>friends: $friendcount</h4><h4>media: $mediacount</h4><h4>profile views: ".$value['profileviews']."</h4>" ;
			$output .= "</li>\n" ;
			if ($count == $perpage)
				break ;
		}
	}
	$output .= "<li class=\"clear\">&nbsp;</li>\n" ;
	$output .= "" ;
	if ($pages > 0)
		$output .= $pageLinks ;
	return $output ;
}
function display5GroupMembers($res, $page = 1, $url) {
	global $db,$sitepath,$templateimagepath ;
	$size = sizeof($res) ;
	$output = '' ;
	$count = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['activationkey'] == 0) {
			$count++ ;
			$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
			$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
			if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
				$avatar = $sitepath."uploads/avatars/".$value['avatar'] ;
			}
			$avatar = str_replace(" ", "%20", $avatar) ;
			$id = $value['id'] ;
			$username = $value['username'] ;
			$db->query("SELECT id FROM media WHERE status='true' AND poster ='".$username."'".$hide." ORDER BY allviews DESC") ;
			$mediacount = $db->numRows() ;
			$rres = $db->fetch() ;
			$db->query("SELECT * FROM member LEFT JOIN friend ON (member.id = friend.friendid OR member.id = friend.userid) WHERE (friend.userid =".$id." OR friend.friendid =".$id.") AND (username!='".$username."') AND friend.friend_removed=0 AND friend.friend_approved=1 GROUP BY member.id") ;
			$friendcount = $db->numRows() ;
			$output .= "<li><a href=\"".$sitepath."profile/$username\"><img class='thumb' width=".getSetting("avatar_w", $db)."px height=".getSetting("avatar_h", $db)."px class='thumb' src='".$avatar."' /></a>\n" ;
			$value['username'] = force_length($value['username'], 25) ;
			$output .= "<p><a href=\"".$sitepath."profile/$username\">".$value['username']."</a></p><h4>friends: $friendcount</h4><h4>media: $mediacount</h4><h4>profile views: ".$value['profileviews']."</h4>" ;
			$output .= "</li>\n" ;
		}
	}
	$output .= "<li class=\"clear\">&nbsp;</li>\n" ;
	$output .= "</ul>" ;
	return $output ;
}
?>
