<?php 
/*
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: loginfunctions.inc
 *    Description:  More log in functions!
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
if (file_exists('includes/mysql.inc')) {
	require_once 'includes/mysql.inc' ;
	require_once 'includes/settings.inc' ;
	require_once 'includes/functions.inc' ;
}
else {
	require_once '../includes/mysql.inc' ;
	require_once '../includes/settings.inc' ;
	require_once '../includes/functions.inc' ;
}
function db_connect() {
	global $db_host,$db_user,$db_password,$db_database ;
	$db = new mysql($db_host, $db_user, $db_password, $db_database) ;
	return $db ;
}
function session_defaults() {
	$_SESSION['logged'] = false ;
	$_SESSION['uid'] = 0 ;
	$_SESSION['username'] = '' ;
	$_SESSION['cookie'] = 0 ;
	$_SESSION['remember'] = false ;
	$_SESSION['privs'] = 0 ;
	setcookie('vidlogin', $cookie, time() - 31104000, '/') ;
}
class User {
	var $db = null ; // DB pointer
	var $failed = false ; // failed login attempt
	var $date ; // current date GMT
	var $id = 0 ; // the current user's id
	function User(&$db) {
		$this->db = $db ;
		$this->date = $GLOBALS['date'] ;
		if (isset($_SESSION['logged'])) {
			if ($_SESSION['logged']) {
				$this->_checkSession() ;
			}
		}
		elseif (isset($_COOKIE['vidlogin'])) {
			$this->_checkRemembered($_COOKIE['vidlogin']) ;
		}
	}
	function _checkLogin($username, $password, $remember) {
		$password = md5($password) ;
		$testcook = md5(uniqid(rand())) ;
		$this->db->query("SELECT * FROM member WHERE username = '".quote_smart($username)."' AND password = '".quote_smart($password)."'") ;
		$result = $this->db->fetch() ;
		if (isset($result['id'])) {
			if ($result['activationkey'] == "0") {
				$this->db->query("UPDATE member SET cookie = '$testcook',lastlogin = '".time()."' WHERE id = ".$result['id']) ;
				$result['cookie'] = $testcook ;
				$this->_setSession($result, $remember) ;
				return 0 ;
			}
			else {
				return 2 ;
			}
		}
		else {
			$this->failed = true ;
			$this->_logout() ;
			return 1 ;
		}
	}
	function _setSession(&$values, $remember, $init = true) {
		$this->id = $values['id'] ;
		$_SESSION['uid'] = $this->id ;
		$_SESSION['username'] = htmlspecialchars($values['username']) ;
		$_SESSION['cookie'] = $values['cookie'] ;
		$_SESSION['logged'] = true ;
		$_SESSION['privs'] = $values['privs'] ;
		if ($remember) {
			$this->updateCookie($values['cookie'], true) ;
		}
		if ($init) {
			$session = session_id() ;
			$ip = $_SERVER['REMOTE_ADDR'] ;
			$this->db->query("UPDATE member SET session = '$session', ip = '$ip' WHERE id = $this->id") ;
		}
	}
	function updateCookie($cookie, $save) {
		$_SESSION['cookie'] = $cookie ;
		if ($save) {
			$cookie = serialize(array($_SESSION['username'], $cookie)) ;
			setcookie('vidlogin', $cookie, time() + 31104000, '/') ;
		}
	}
	function _checkRemembered($cookie) {
		list($username, $cookie) = @unserialize($cookie) ;
		if (!$username or !$cookie)
			return ;
		$this->db->query("SELECT * FROM member WHERE username = '".quote_smart($username)."' AND cookie = '$cookie'") ;
		$result = $this->db->fetch() ;
		if (isset($result['id'])) {
			$this->_setSession($result, true) ;
		}
	}
	function _checkSession() {
		$username = $_SESSION['username'] ;
		$cookie = $_SESSION['cookie'] ;
		$session = session_id() ;
		$ip = $_SERVER['REMOTE_ADDR'] ;
		$this->db->query("SELECT * FROM member WHERE (username = '".quote_smart($username)."') AND (cookie = '$cookie') AND (session = '$session') AND (ip = '$ip')") ;
		$result = $this->db->fetch() ;
		if (isset($result)) {
			$this->_setSession($result, false, false) ;
		}
		else {
			$this->_logout() ;
		}
	}
	function _logout() {
		session_defaults() ;
	}
}
?>