<?php
/*
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: latest.inc
 *    Description: Functions  for home page content
 *    $Date: 2010-03-08 00:18:17 +0000 (Mon, 08 Mar 2010) $
 *    $Revision: 43 $
 */
include_once ("includes/common.inc") ;
global $db,$sitepath,$rootpath,$template,$templateimagepath ;
function ShortenText($text, $length = 10) {
	// Change to the number of characters you want to display
	if (strlen($text) > $length) {
		$text = substr($text, 0, $length).'..' ;
	}
	return $text ;
}
//Get the most recently added media
function latestmedia() {
	global $db ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/latest_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = latestmedia_new() ;
	}
	else {
		//Check if mature content should be hidded - only active when mature content
		$hide = (checkHideMedia() == 1) ? " AND (`requires_agreement` = 0)" : "" ;
		$db->query("SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE `status` ='true' ".$hide."AND (`suspended`!=1 OR `suspended` IS NULL) ORDER BY `added` DESC") ;
		$resLV = $db->fetchAll() ;
		//Create output for latest media
		if (getSetting("latest_page_table_layout", $db) == 1) {
			if (isset($_GET['vp']))
				$output = displaymediaintable($resLV, $_GET['vp'], "", true) ;
			else
				$output = displaymediaintable($resLV, 1, "", true) ;
		}
		else {
			if (isset($_GET['vp']))
				$output = displaymedia($resLV, $_GET['vp'], "", true) ;
			else
				$output = displaymedia($resLV, 1, "", true) ;
		}
	}
	return $output ;
}
function newestMembers() {
	global $db ;
	//Create output for newest members
	$db->query("SELECT * FROM member WHERE activationkey=0 ORDER BY id DESC LIMIT 20") ;
	$rowcount = $db->numRows() ;
	$resLV = $db->fetchAll() ;
	$output = displayNewestMembers($resLV, $rowcount, "") ;
	return $output ;
}
function flashLatest() {
	$output = '<div id="flashcontent"> You need to upgrade your Flash Player</div><script type="text/javascript">// <![CDATA[	var so = new SWFObject("HScroller.swf", "flash", "600", "300", "8", "#fff");so.addVariable("xml", "data.xml");so.write("flashcontent");	// ]]></script>' ;
	return $output ;
}
function featuredmedia() {
	global $db,$sitepath,$rootpath,$template,$templateimagepath,$loggedIn ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/latest_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = featuredmedia_new() ;
	}
	else {
		if (checkHideMedia() == 1) {
			$hide = " AND (`requires_agreement` = 0)" ;
		}
		else {
			$hide = "" ;
		}
		$db->query("SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE `status` ='true'".$hide."   AND (`suspended`!=1 OR `suspended` IS NULL) AND featured = 1 ORDER BY added DESC") ;
		$res = $db->fetchALL() ;
		include $rootpath."templates/".$template."/config.inc" ;
		$vrw = str_replace(' ', '_', $_GET['vrw']) ;
		$crw = str_replace(' ', '_', $_GET['crw']) ;
		$scrw = str_replace(' ', '_', $_GET['scrw']) ;
		$sscrw = str_replace(' ', '_', $_GET['sscrw']) ;
		$xmlpath = 'data/scroller/scroller.xml' ;
		//Create XML file
		$file = fopen($xmlpath, "w") ;
		$xml_contents = '<scroller>' ;
		if ($loggedIn) {
			$db->query("SELECT id,agreed,hidemature FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
			$ures = $db->fetch() ;
			$memberid = $ures['id'] ;
			$useragreed = $ures['agreed'] == 1 ;
			$db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
			$groupmembership = $db->fetchAll() ;
		}
		else {
			$useragreed = false ;
		}
		foreach ($res as $row=>$value) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$thumb = '' ;
				$thumbpath = $sitepath.'uploads/thumbs/' ;
				if ((checkHideThumbnails()) && ($value['requires_agreement'] == 1)) {
					$thumb = $templateimagepath."default_mature_thumb.jpg" ;
				}
				else {
					if (@file_exists($thumbpath.$value['thumb'].".small.jpg"))
						$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
					elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg"))
						$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
					elseif (@file_exists(str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb'])))
						$thumb = str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb']) ;
					elseif (findThumb($value['thumb'], true)) {
						$thumb = findThumb($value['thumb'], true) ;
						$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
					}
					$thumb = str_replace(" ", "%20", $thumb) ;
					if ($thumb == '') {
						$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
					}
				}
				if ($value['category'] > 0) {
					$db->query("SELECT name, parent, `url` FROM category WHERE id = ".$value['category']) ;
					$rescat = $db->fetch() ;
					$cat = urlencode($rescat['name'])."/" ;
				}
				else {
					$cat = '' ;
				}
				$url = $sitepath.'play/'.$cat.urlencode($value['title']) ;
				$url = str_replace('+', '_', $url) ;
				$title = $value['title'] ;
				$xml_contents .= '<item image="'.$thumb.'" label="'.$title.'" data="'.$url.'" />' ;
			}
		}
		$xml_contents .= '</scroller>' ;
		fwrite($file, $xml_contents) ;
		fclose($file) ;
		if (sizeof($res) > 0) {
			$site_template = getSetting("sitetemplate", $db) ;
			if (!file_exists("templates/".$site_template."/style.css"))
				$site_template = "main" ;
			$output = '<h1><img src="'.$templateimagepath.'icn_featured_media.jpg" alt="" /><b>Featured</b> Media</h1>' ;
			$scroller = getFlashScroller($scrollerthumbwidth, $scrollerthumbheight, $scrollerbordercolor, $scrollerbgcolor, $scrollertextblockheight, $scrollerfontsize, $scrollerfontcolor, $scrollerantialiasing) ;
			if ($scroller != '') {
				$output .= $scroller ;
			}
			else {
				$output .= displayfeaturedmainpage($res) ;
			}
		}
	}
	return $output ;
}
function watchednow() {
	global $db,$sitepath,$rootpath,$template,$templateimagepath,$loggedIn ;
	$site_template = getSetting("sitetemplate", $db) ;
	$template_file = "templates/".$site_template."/modules/latest_content.php" ;
	if ((getSetting("new_template", $db) == 1) && (file_exists($template_file))) {
		include_once ($template_file) ;
		$output = watchednow_new() ;
	}
	else {
		if (checkHideMedia() == 1) {
			$hide = " AND (`requires_agreement` = 0)" ;
		}
		else {
			$hide = "" ;
		}
		$db->query("SELECT * FROM `media` LEFT JOIN `group` ON (`media`.`groupid` = `group`.`group_id`) WHERE `status` ='true'".$hide."   AND (`suspended`!=1 OR `suspended` IS NULL) ORDER BY lastviewed DESC LIMIT 0,12") ;
		$res = $db->fetchALL() ;
		$rows = $db->numRows() ;
		include $rootpath."templates/".$template."/config.inc" ;
		$vrw = str_replace(' ', '_', $_GET['vrw']) ;
		$crw = str_replace(' ', '_', $_GET['crw']) ;
		$scrw = str_replace(' ', '_', $_GET['scrw']) ;
		$sscrw = str_replace(' ', '_', $_GET['sscrw']) ;
		$xmlpath = 'data/watchednow/widget.xml' ;
		//Create XML file
		$file = fopen($xmlpath, "w") ;
		$xml_contents = '<?xml version="1.0" encoding="UTF-8" ?>
							<!--
							<ut_response status="ok">
							-->
							<video_list>' ;
		if ($loggedIn) {
			$db->query("SELECT id,agreed,hidemature FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
			$ures = $db->fetch() ;
			$memberid = $ures['id'] ;
			$useragreed = $ures['agreed'] == 1 ;
			$db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
			$groupmembership = $db->fetchAll() ;
		}
		else {
			$useragreed = false ;
		}
		foreach ($res as $row=>$value) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$thumb = '' ;
				$thumbpath = $sitepath.'uploads/thumbs/' ;
				if ((checkHideThumbnails()) && ($value['requires_agreement'] == 1)) {
					$thumb = $templateimagepath."default_mature_thumb.jpg" ;
				}
				else {
					if (@file_exists($thumbpath.$value['thumb'].".small.jpg"))
						$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
					elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg"))
						$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
					elseif (@file_exists(str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb'])))
						$thumb = str_replace("[SIZE]", ".small", "uploads/thumbs/".$value['thumb']) ;
					elseif (findThumb($value['thumb'], true)) {
						$thumb = findThumb($value['thumb'], true) ;
						$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
					}
					$thumb = str_replace(" ", "%20", $thumb) ;
					if ($thumb == '') {
						$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
					}
				}
				if ($value['category'] > 0) {
					$db->query("SELECT name, parent, `url` FROM category WHERE id = ".$value['category']) ;
					$rescat = $db->fetch() ;
					$cat = urlencode($rescat['name'])."/" ;
				}
				else {
					$cat = '' ;
				}
				$url = $sitepath.'play/'.$cat.urlencode($value['title']) ;
				$url = str_replace('+', '_', $url) ;
				$title = $value['title'] ;
				$views = $value['allviews'] ;
				$description = $value['description'] ;
				$xml_contents .= '<video>
									<title>'.$title.' - '.$description.'</title>
									<url>'.$url.'</url>
									<run_time>'.ShortenText($title, 7).'</run_time>
									<thumbnail_url>'.$thumb.'</thumbnail_url>
								</video>' ;
			}
		}
		$xml_contents .= '</video_list>' ;
		fwrite($file, $xml_contents) ;
		fclose($file) ;
		if (sizeof($res) > 0) {
			$site_template = getSetting("sitetemplate", $db) ;
			if (!file_exists("templates/".$site_template."/style.css"))
				$site_template = "main" ;
			$widget = getWatchedNow('Your Text Here') ;
			if (($widget != '') && ($rows > 5)) {
				$output = '<h1><img src="'.$templateimagepath.'icn_featured_media.jpg" alt="" /><b>Watched</b> Now</h1>' ;
				$output .= $widget ;
			}
			else {
				$widget .= '' ;
			}
		}
	}
	return $output ;
}
function displayfeaturedmainpage($res) {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	if ($loggedIn) {
		$db->query("SELECT id FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$ures = $db->fetch() ;
		$memberid = $ures['id'] ;
		$db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
		$groupmembership = $db->fetchAll() ;
	}
	$vidcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$vidcount++ ;
			}
		}
	}
	$output = '<ul class="no-format horiz-thumbs-list">' ;
	$count = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$count++ ;
				$thumbpath = 'uploads/thumbs/' ;
				$thumb = '' ;
				$anim = '' ;
				if (checkHideThumbnails() && ($value['requires_agreement'] == 1)) {
					$thumb = $templateimagepath."default_mature_thumb.jpg" ;
				}
				else {
					if (file_exists($thumbpath.$value['thumb'].".small.jpg")) {
						$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
						if (file_exists($thumbpath.$value['thumb'].".prv")) {
							$anim = $sitepath."uploads/thumbs/".$value['thumb'] ;
						}
					}
					elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg")) {
						$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
						$anim = $sitepath."uploads/thumbs/".$value['mediaurl'] ;
					}
					elseif (findThumb($value['thumb'], true)) {
						$thumb = findThumb($value['thumb'], true) ;
						$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
						$anim = $sitepath."uploads/thumbs/".$thumb[0] ;
					}
					if ($thumb == '') {
						$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
					}
					$thumb = str_replace(" ", "%20", $thumb) ;
				}
				$thumb = str_replace(" ", "%20", $thumb) ;
				$kat = getCategoryPath($value['category']) ;
				$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
				$resR = $db->fetch() ;
				$title = url_encode($value['title']) ;
				$shortTitle = force_length($value['title'], getSetting("titledisplaylength", $db)) ;
				$output .= "<li>" ;
				$thumb_index = $count + 40 ;
				//thumbnail
				if ($anim != "" && checkfeature('Video Preview Thumbnails', 18)) {
					$output .= "<div class=\"thumbholder\" id='thumb".$thumb_index."' onmouseover='replace_thumb(".$thumb_index.", \"<a href=&#39;play".$kat."/".$title."&#39;><img src=&#39;".$thumb."&#39;></a>\");'>" ;
					$output .= "<a href='play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
					$output .= "</div>" ;
					$output .= "<img class=\"preview\" onmouseover='start_thumb(".$thumb_index." ,\"".$anim."\")' src=\"".$templateimagepath."preview_box.png\">" ;
				}
				else {
					$output .= "<div class=\"thumbholder\" id='thumb".$thumb_index."'>" ;
					$output .= "<a href='play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
					$output .= "</div>" ;
				}
				$output .= "<h4>" ;
				$output .= "&nbsp;&nbsp;<b><a href=\"play$kat/$title\">".str_replace("_", " ", $shortTitle)."</a></b></h4>" ;
				//$output .= "<li><a href=\"play$kat/$title\"><img class='thumb' src='$thumb' />\n";
				$value['title'] = force_length($value['title'], 25) ;
				$output .= "<p>".$value['title']."</p></a>\n" ;
				$output .= "</li>\n" ;
				if ($count >= 5)
					break ;
			}
		}
	}
	$output .= "<li class=\"clear\">&nbsp;</li></ul>" ;
	return $output ;
}
function displaymedia($res, $page = 1, $url = "", $showad = false) {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	if ($loggedIn) {
		$db->query("SELECT id FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$ures = $db->fetch() ;
		$memberid = $ures['id'] ;
		$db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
		$groupmembership = $db->fetchAll() ;
	}
	$vidcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$vidcount++ ;
			}
		}
	}
	if ($showad) {
		$db->query("SELECT * FROM sitead WHERE adname='ad2'") ;
		if ($db->numRows() > 0) {
			$ares = $db->fetch() ;
			$adtext = $ares['adtext'] ;
		}
	}
	if ($adtext != '') {
		$adtext = '<div id="horizbanner">'.$adtext.'</div>' ;
	}
	$perpage = getSetting("mainpp", $db) ;
	$pages = ceil($vidcount / $perpage) ;
	$path = getSetting("sitefolder", $db) ;
	$pageLinks = "" ;
	if ($pages > 0) {
		$pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
	}
	else {
		$pageLinks = "<div><div><div><div>" ;
	}
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= "<a class=\"prevp\" href='".$url."?vp=".$pp."'>Previous Page</a>" ;
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 6) {
		$pageLinks .= "<a href='".$url."?vp=1'>1</a> ... " ;
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if ($p == $page)
			$pageLinks .= "$p " ;
		else
			$pageLinks .= "<a href='".$url."?vp=".$p."'>$p</a> " ;
	}
	if ($pages > 10) {
		$pageLinks .= "... <a href='".$url."?vp=".$pages."'>$pages</a>" ;
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= "<a class=\"nextp\" href='".$url."?vp=".$np."'>Next Page</a>" ;
	}
	$pageLinks .= "</div></div></div></div>" ;
	$output = '<ul class="no-format vert-list">' ;
	$count = 0 ;
	$page-- ;
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$count++ ;
				$thumbpath = 'uploads/thumbs/' ;
				$thumb = '' ;
				$anim = '' ;
				if (checkHideThumbnails() && ($value['requires_agreement'] == 1)) {
					$thumb = $templateimagepath."default_mature_thumb.jpg" ;
				}
				else {
					if (file_exists($thumbpath.$value['thumb'].".small.jpg")) {
						$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
						if (file_exists($thumbpath.$value['thumb'].".prv")) {
							$anim = $sitepath."uploads/thumbs/".$value['thumb'] ;
						}
					}
					elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg")) {
						$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
						$anim = $sitepath."uploads/thumbs/".$value['mediaurl'] ;
					}
					elseif (findThumb($value['thumb'], true)) {
						$thumb = findThumb($value['thumb'], true) ;
						$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
						$anim = $sitepath."uploads/thumbs/".$thumb[0] ;
					}
					if ($thumb == '') {
						$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
					}
					$thumb = str_replace(" ", "%20", $thumb) ;
				}
				$kat = getCategoryPath($value['category']) ;
				$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
				$resR = $db->fetch() ;
				$shortTitle = force_length($value['title'], getSetting("titledisplaylength", $db)) ;
				$title = url_encode($value['title']) ;
				$value['description'] = force_length($value['description'], 130) ;
				$output .= "<li>" ;
				//thumbnail
				if ($anim != "" && checkfeature('Video Preview Thumbnails', 18)) {
					$output .= "<div class=\"thumbholder\" id='thumb".$count."' onmouseover='replace_thumb(".$count.", \"<a href=&#39;play".$kat."/".$title."&#39;><img src=&#39;".$thumb."&#39;></a>\");'>" ;
					$output .= "<a href='play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
					$output .= "</div>" ;
					$output .= "<h3>" ;
					$output .= "<img class=\"preview\" onmouseover='start_thumb(".$count." ,\"".$anim."\")' src=\"".$templateimagepath."preview_box.png\">" ;
				}
				else {
					$output .= "<div class=\"thumbholder\" id='thumb".$count."'>" ;
					$output .= "<a href='play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
					$output .= "</div>" ;
					$output .= "<h3>" ;
				}
				$output .= "&nbsp;&nbsp;<b><a href=\"play$kat/$title\">".str_replace("_", " ", $shortTitle)."</a></b></h3>" ; 
				//description
				$output .= "<h4><b>&nbsp;&nbsp;&nbsp;".$value['description']."</b></h4>" ;
				$tags = strtolower($value['tags']) ;
				$taglinks = getTagLinks($tags) ;
				if (str_replace(" ", "", $tags) != '') {
					$output .= "<p>&nbsp;&nbsp;&nbsp;tags: $taglinks</p>" ;
				}
				else {
					$output .= "<p>&nbsp;</p>" ;
				}
				$output .= "<div class=\"inf\"><div class=\"inf-right\"><b>From <a href=\"".$sitepath."profile/".$value['poster']."\">".$value['poster']."</a> on:</b> ".date("m.d.y", $value['added'])." <b> Rating: </b><span class=\"rating\">".show_rating($value['id'])."</span><span class=\"views\"><b>views:</b> ".$value['allviews'] ;
				$output .= "</span></div></div>" ;
				$output .= "</li>\n" ;
				if (($count == 3) && ($showad) && (str_replace(" ", "", $adtext) != '')) {
					$output .= '<li class="alt"><div align=center>'.$adtext.'</div></li><br><br>' ;
				}
				if ($count == $perpage)
					break ;
			}
		}
	}
	$output .= "</ul>" ;
	if ($pages != 1)
		$output .= $pageLinks ;
	return $output ;
}
function displaymediaintable($res, $page = 1, $url = "", $showad = false) {
	global $db,$sitepath,$loggedIn,$templateimagepath ;
	if ($loggedIn) {
		$db->query("SELECT id FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
		$ures = $db->fetch() ;
		$memberid = $ures['id'] ;
		$db->query("SELECT * FROM group_member WHERE member_id = ".$memberid." AND approved = 1") ;
		$groupmembership = $db->fetchAll() ;
	}
	$vidcount = 0 ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$vidcount++ ;
			}
		}
	}
	if ($showad) {
		$db->query("SELECT * FROM sitead WHERE adname='ad2'") ;
		if ($db->numRows() > 0) {
			$ares = $db->fetch() ;
			$adtext = $ares['adtext'] ;
		}
	}
	if ($adtext != '') {
		$adtext = '<div id="horizbanner">'.$adtext.'</div>' ;
	}
	$perpage = getSetting("mainpp", $db) ;
	$pages = ceil($vidcount / $perpage) ;
	$path = getSetting("sitefolder", $db) ;
	$pageLinks = "" ;
	if ($pages > 0) {
		$pageLinks = "<div class=\"paging\"><div class=\"paging-right\"><div class=\"paging-mid\">Page&nbsp;".$page."&nbsp;of&nbsp;".$pages."<div class=\"pages\">" ;
	}
	else {
		$pageLinks = "<div><div><div><div>" ;
	}
	$pp = $page - 1 ;
	if ($pp >= 1) {
		$pageLinks .= "<a class=\"prevp\" href='".$url."?vp=".$pp."'>Previous Page</a>" ;
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 6) {
		$pageLinks .= "<a href='".$url."?vp=1'>1</a> ... " ;
	}
	$p = 1 ;
	$stopat = ($pages <= 10) ? $pages : 10 ;
	if ($pages > 10 && $page > 5) {
		$p = $page - 5 ;
		$stopat = $page + 5 ;
		if ($stopat > $pages)
			$stopat = $pages ;
	}
	for ($p; $p <= $stopat; $p++) {
		if ($p == $page)
			$pageLinks .= "$p " ;
		else
			$pageLinks .= "<a href='".$url."?vp=".$p."'>$p</a> " ;
	}
	if ($pages > 10) {
		$pageLinks .= "... <a href='".$url."?vp=".$pages."'>$pages</a>" ;
	}
	$np = $page + 1 ;
	if ($np <= $pages) {
		$pageLinks .= "<a class=\"nextp\" href='".$url."?vp=".$np."'>Next Page</a>" ;
	}
	$pageLinks .= "</div></div></div></div>" ;
	$output = '<ul class="no-format horiz2-thumbs-list">' ;
	$count = 0 ;
	$colcount = 0 ;
	$page-- ;
	for ($i = 0; $i < $perpage * $page; $i++)
		unset($res[$i]) ;
	foreach ($res as $key=>$value) {
		if ($value['added'] < time()) {
			$groupid = $value['groupid'] ;
			$groupprivate = $value['privacy'] ;
			$visible = true ;
			if (($groupid > 0) && ($groupprivate == 1) && ($value['owner_id'] != $memberid)) {
				if ($loggedIn) {
					$approvedmember = false ;
					foreach ($groupmembership as $gmkey=>$groupmember) {
						if ($groupmember['group_id_g'] == $groupid) {
							$approvedmember = true ;
							break ;
						}
					}
					if (!$approvedmember) {
						$visible = false ;
					}
				}
				else {
					$visible = false ;
				}
			}
			if ($visible) {
				$count++ ;
				$colcount++ ;
				if ($colcount > 3) {
					$colcount = 0 ;
					$output .= '</ul><ul class="no-format horiz2-thumbs-list">' ;
				}
				$thumb = '' ;
				$anim = '' ;
				$thumbpath = 'uploads/thumbs/' ;
				if (checkHideThumbnails() && ($value['requires_agreement'] == 1)) {
					$thumb = $templateimagepath."default_mature_thumb.jpg" ;
				}
				else {
					if (file_exists($thumbpath.$value['thumb'].".small.jpg")) {
						$thumb = $sitepath."uploads/thumbs/".$value['thumb'].".small.jpg" ;
						if (file_exists($thumbpath.$value['thumb'].".prv")) {
							$anim = $sitepath."uploads/thumbs/".$value['thumb'] ;
						}
					}
					elseif (@file_exists($thumbpath.$value['mediaurl'].".small.jpg")) {
						$thumb = $sitepath."uploads/thumbs/".$value['mediaurl'].".small.jpg" ;
						$anim = $sitepath."uploads/thumbs/".$value['mediaurl'] ;
					}
					elseif (findThumb($value['thumb'], true)) {
						$thumb = findThumb($value['thumb'], true) ;
						$thumb = $sitepath."uploads/thumbs/".$thumb[0] ;
					}
					if ($thumb == '') {
						$thumb = $templateimagepath.getDefaultThumb($value['mediatype']) ;
					}
					$thumb = str_replace(" ", "%20", $thumb) ;
				}
				$kat = getCategoryPath($value['category']) ;
				$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
				$resR = $db->fetch() ;
				$shortTitle = force_length($value['title'], getSetting("titledisplaylength", $db)) ;
				$title = url_encode($value['title']) ;
				$kat = getCategoryPath($value['category']) ;
				$db->query("SELECT * FROM rating WHERE id = ".$value['id']) ;
				$resR = $db->fetch() ;
				$title = url_encode($value['title']) ;
				$vidid = $value['vidid'] ;
				$removelink = $sitepath."usermenu/rfav/".$vidid ;
				$output .= "<li>" ;
				//thumbnail
				if ($anim != "" && checkfeature('Video Preview Thumbnails')) {
					$output .= "<div class=\"thumbholder\" id='thumb".$count."' onmouseover='replace_thumb(".$count.", \"<a href=&#39;play".$kat."/".$title."&#39;><img src=&#39;".$thumb."&#39;></a>\");'>" ;
					$output .= "<a href='play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
					$output .= "</div>" ;
					$output .= "<img class=\"preview\" onmouseover='start_thumb(".$count." ,\"".$anim."\")' src=\"".$templateimagepath."preview_box.png\">" ;
				}
				else {
					$output .= "<div class=\"thumbholder\" id='thumb".$count."'>" ;
					$output .= "<a href='play".$kat."/".$title."'><img  src='".$thumb."'/></a>" ;
					$output .= "</div>" ;
				}
				$value['username'] = force_length($value['username'], 35) ;
				$value['title'] = force_length($value['title'], 30) ;
				$value['description'] = force_length($value['description'], 20) ;
				if (($filter == "all") || ($filter == "")) {
					$viewstring = $value['allviews'] ;
				}
				else if ($filter == "today") {
					$viewstring = $value['dayviews'] ;
				}
				else if ($filter == "week") {
					$viewstring = $value['weekviews'] ;
				}
				else if ($filter == "month") {
					$viewstring = $value['monthviews'] ;
				}
				else if ($filter == "toprated") {
					$viewstring = $value['allviews'] ;
				}
				if ($viewstring == '') {
					$viewstring = 0 ;
				}
				$output .= "<h4><b><a href='play".$kat."/".$title."'>".str_replace("_", " ", $shortTitle)."</a></b></h4><h4>".$value['description']."</h4><h4>views: ".$viewstring."</h4><p><span class=\"rating\">".show_rating($value['id'])."</span></p>" ;
				$output .= "</li>\n" ;
				if (($count == 4) && ($showad) && (str_replace(" ", "", $adtext) != '')) {
					$output .= '</ul><ul class="no-format horiz3-thumbs-list"><li class="alt"><div align=center>'.$adtext.'</div></li>' ;
					$colcount = 4 ;
				}
				if ($count == $perpage)
					break ;
			}
		}
	}
	$output .= "<li class=\"clear\">&nbsp;</li>\n" ;
	$output .= "" ;
	$output .= "</ul>" ;
	if ($pages != 1)
		$output .= $pageLinks ;
	return $output ;
}
function displayNewestMembers($res, $rowcount, $url = "", $nomr = false) {
	global $db,$sitepath,$templateimagepath ;
	$output = '<ul class="no-format horiz-thumbs-list">' ;
	$count = 0 ;
	$page-- ;
	$perpage = getSetting("newestpp", $db) ;
	$show = $rowcount ;
	if ($show > $perpage) {
		$show = $perpage ;
	}
	//Clear previous page results
	for ($i = 0; $i < $show; $i++) {
		$value = $res[$i] ;
		$count++ ;
		$avatargender = $value['gender'] > 0 ? 'female' : 'male' ;
		$avatar = $templateimagepath."default_".$avatargender."_avatar.jpg" ;
		if (@file_exists("uploads/avatars/".$value['avatar']) && ($value['avatar'] != "")) {
			$avatar = $sitepath."uploads/avatars/".$value['avatar'] ;
		}
		$avatar = str_replace(" ", "%20", $avatar) ;
		$id = $value['id'] ;
		$username = $value['username'] ;
		$output .= "<li><a href=\"profile/$username\"><img class=\"thumb\" src='".$avatar."' /></a>\n" ;
		$value['username'] = force_length($value['username'], 25) ;
		$output .= "<p><a href=\"profile/$username\">".$value['username']."</a></p>\n" ;
		$output .= "</li>\n" ;
	}
	$output .= "<li class=\"clear\">&nbsp;</li></ul>" ;
	if ($rowcount > $perpage) {
		$output .= "<h3><a href=\"".$sitepath."members\">more members >></a></h3><br>" ;
	}
	return $output ;
}
?>