<?php 
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: content.inc
 *    Description: Gets the file path of module files based on the URL
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
global $register_category,$register_content,$sitepath;
$accountManagementPage = false ;
if (($_GET['id'] == '56') && (getSetting("accountpageon", $db) == 0)) {
      $_GET['id'] = '1' ;
}
if ($_GET['id'] >= 200) {
      $db->query("SELECT * FROM content WHERE linkid = ".quote_smart($_GET['id'])) ;
      $res = $db->fetch() ;
      $c_content = $res['page'] ;
      $c_header = $res['title'] ;
      $c_file = "" ;
}
else {
      switch ($_GET['id']) {
            //Accessible to all
            case '1':
                  $c_file = 'modules/latest.module' ;
                  $c_header = 'Home' ;
                  break ;
            case '2':
                  $c_file = 'modules/toprated.module' ;
                  $c_header = 'Top Rated <strong>Media</strong>' ;
                  break ;
            case '3':
                  $c_file = 'modules/mostviewed.module' ;
                  $c_header = 'Most Viewed <strong>Media</strong>' ;
                  break ;
            case '4':
                  $c_file = 'modules/forgot.module' ;
                  $c_header = 'Forgotten Login' ;
                  break ;
            case '5':
                  $c_file = 'modules/upload.module' ;
                  $c_header = 'Upload Media' ;
                  break ;
            case '6':
                  $c_file = 'modules/register.module' ;
                  $c_header = 'Register' ;
                  break ;
            case '8':
                  $c_file = 'modules/play.module' ;
                  $c_header = dec_VID ;
                  break ;
            case '10':
                  $c_file = 'modules/activate.module' ;
                  $c_header = 'Activate Your Account' ;
                  break ;
            case '11':
                  $c_file = 'modules/tellafriend.module' ;
                  $c_header = 'Tell a Friend' ;
                  break ;
            case '88':
                  $c_file = 'modules/members.module' ;
                  $c_header = 'Members' ;
                  break ;
            case '16':
                  $c_file = 'modules/terms.module' ;
                  $c_header = 'Terms of Service' ;
                  break ;
            case '18':
                  $c_file = 'modules/profile.module' ;
                  $c_header = 'Profile' ;
                  break ;
            case '19':
                  $c_file = 'modules/groups.module' ;
                  $c_header = 'Groups' ;
                  break ;
            case '20':
                  $c_file = 'modules/showgroup.module' ;
                  $c_header = 'View Group' ;
                  break ;
            case '21':
                  $c_file = 'modules/category.module' ;
                  $c_header = 'Category' ;
                  break ;
            case '22':
                  $c_file = 'modules/mediasearch.module' ;
                  $c_header = 'Search' ;
                  break ;
            case '23':
                  $c_file = 'modules/showimage.module' ;
                  $c_header = 'Display Image' ;
                  break ;
            case '24':
                  $c_file = 'modules/alltags.module' ;
                  $c_header = 'Tags' ;
                  break ;
            case '25':
                  $c_file = 'modules/add.module' ;
                  $c_header = 'Add' ;
                  break ;
            case '26':
                  $c_file = 'modules/out.module' ;
                  $c_header = 'Out' ;
                  break ;
            case '27':
                  $c_file = 'modules/showallfriends.module' ;
                  $c_header = 'All My Friends' ;
                  break ;
            case '28':
                  $c_file = 'modules/domedia.module' ;
                  $c_header = 'Change Media Ad' ;
                  break ;
            case '29':
                  $c_file = 'modules/rss.module' ;
                  $c_header = 'Rss Feeds' ;
                  break ;
            case '30':
                  $c_file = 'modules/news.module' ;
                  $c_header = 'Sites News' ;
                  break ;
            case '31':
                  $c_file = 'modules/edit.module' ;
                  $c_header = 'Edit My Media' ;
                  break ;
            //User only pages
            case '55':
                  $c_file = 'modules/usercp.module' ;
                  $c_header = 'Control Panel' ;
                  break ;
            case '56':
                  $c_file = 'modules/account.module' ;
                  $c_header = 'Account Management' ;
                  $accountManagementPage = true ;
                  break ;
            //Admin only pages
            case '100':
                  $c_file = 'modules/admin/index.module' ;
                  $c_header = 'Administration' ;
                  break ;
            case '101':
                  $c_file = 'modules/admin/add_cat.module' ;
                  $c_header = 'Add Category' ;
                  break ;
            case '102':
                  $c_file = 'modules/admin/show_cats.module' ;
                  $c_header = 'Category Overview' ;
                  break ;
            case '103':
                  $c_file = 'modules/admin/show_media.module' ;
                  $c_header = 'Media Overview' ;
                  break ;
            case '104':
                  $c_file = 'modules/admin/new_uploads.module' ;
                  $c_header = 'New Uploads' ;
                  break ;
            case '105':
                  $c_file = 'modules/admin/users.module' ;
                  $c_header = 'Registered Users' ;
                  break ;
            case '106':
                  $c_file = 'modules/admin/settings.module' ;
                  $c_header = 'Settings' ;
                  break ;
            case '107':
                  $c_file = 'modules/admin/play.module' ;
                  $c_header = 'Preview Media' ;
                  break ;
            case '108':
                  $c_file = 'modules/admin/contentmanager.module' ;
                  $c_header = 'Content Management' ;
                  break ;
            case '109':
                  $c_file = 'modules/admin/menumanager.module' ;
                  $c_header = 'Menu Management' ;
                  break ;
            case '111':
                  $c_file = 'modules/admin/emailmanager.module' ;
                  $c_header = 'Email Management' ;
                  break ;
            case '113':
                  $c_file = 'modules/admin/badwords.module' ;
                  $c_header = 'Bad Words' ;
                  break ;
            case '115':
                  $c_file = 'modules/preview.module' ;
                  $c_header = 'Preview Page' ;
                  break ;
            case '116':
                  $c_file = 'modules/admin/mediasetting.module' ;
                  $c_header = 'Media Settings' ;
                  break ;
            case '117':
                  $c_file = 'modules/admin/videoads.module' ;
                  $c_header = 'Manage Video Ads' ;
                  break ;
            case '118':
                  $c_file = 'modules/admin/adblocks.module' ;
                  $c_header = 'Manage Site Ads' ;
                  break ;
            case '150':
                  $c_file = 'modules/admin/features.module' ;
                  $c_header = 'Manage Features and Mods' ;
                  break ;
            case '119':
                  $c_file = 'modules/admin/traffic.module' ;
                  $c_header = 'Manage Traffic Exchange' ;
                  break ;
            case '121':
                  $c_file = 'modules/admin/rewards.module' ;
                  $c_header = 'Manage Reward System' ;
                  break ;
            case '123':
                  $c_file = 'modules/admin/stats.module' ;
                  $c_header = 'Admin Stats' ;
                  break ;
            default:
                  $c_file = 'modules/error.php' ;
                  $c_header = 'Error 404' ;
                  break ;
      }

}
?>
