<?php 
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: account.inc
 *    Description: Gets all data for account.module - displays account management page after login, if enabled in admin
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
global $db,$sitepath ;
if (!$loggedIn) {
      $haltMessage = "<h2>You must log in to use Account Management</h2>" ;
}
else {
      //Get ID of logged in user
      $db->query("SELECT * FROM member WHERE username = '".quote_smart($_SESSION['username'])."'") ;
      $resUID = $db->fetch() ;
      $username = $resUID['username'] ;
      //Count favorites, messages, subscriptions, etc. for numbers on account management page
      if (isset($resUID['id'])) {
            $uid = $resUID['id'] ;
            $db->query("SELECT * FROM favorite WHERE userid = $uid") ;
            $favorites = $db->numRows() ;
            $db->query("SELECT * FROM friend WHERE (userid =".$uid." OR friendid =".$uid.") AND friend_removed=0 AND friend_approved=1") ;
            $friends = $db->numRows() ;
            $db->query("SELECT * FROM friend WHERE userid =".$uid." AND friend_approved = 0") ;
            $receivedRequests = $db->numRows() ;
            $db->query("SELECT * FROM friend WHERE friendid =".$uid." AND friend_approved = 0 AND friend_removed = 0") ; //don't count declined messages
            $sentRequests = $db->numRows() ;
            $db->query("SELECT * FROM blocked WHERE blocker_id = $uid") ;
            $blocked = $db->numRows() ;
            $db->query("SELECT * FROM subscription WHERE userid = $uid") ;
            $subscriptions = $db->numRows() ;
            $db->query("SELECT * FROM `group` WHERE `owner_id` = $uid") ;
            $groups = $db->numRows() ;
            $db->query("SELECT * FROM media WHERE LOWER(poster) = '".quote_smart(strtolower($_SESSION['username']))."' AND status = 'true'") ;
            $media = $db->numRows() ;
            $db->query("SELECT * FROM message WHERE toid = $uid") ;
            $totalMessages = $db->numRows() ;
            $db->query("SELECT * FROM message WHERE toid = $uid AND msgread = 0") ;
            $newMessages = $db->numRows() ;
            $db->query("SELECT * FROM message WHERE fromid = $uid AND auto=0") ;
            $sentMessages = $db->numRows() ;
            $db->query("SELECT * FROM message WHERE fromid = $uid AND auto=0 AND msgread = 0") ;
            $unreadMessages = $db->numRows() ;
      }
}
$SnewMessage = $newMessages != 1 ? ' new messages' : ' new message' ;
$SsentMessage = $sentMessages != 1 ? ' sent messages' : ' sent message' ;
$Sfriend = $friends != 1 ? ' members' : ' member' ;
$SreceivedRequest = $receivedRequests != 1 ? ' friend requests' : ' friend request' ;
$SsentRequest = $sentRequests != 1 ? ' friend requests' : ' friend request' ;
$Ssubscription = $subscriptions != 1 ? ' members' : ' member' ;
$Sblocked = $blocked != 1 ? ' members' : ' member' ;
$Smedia = $media != 1 ? ' media items' : ' media item' ;
$Sgroup = $groups != 1 ? ' groups' : ' group' ;
$Sfavorite = $favorites != 1 ? ' media items' : ' media item' ;
$newMessages = $newMessages.''.$SnewMessage ;
$sentMessages = $sentMessages.''.$SsentMessage ;
$friends = $friends.''.$Sfriend ;
$receivedRequests = $receivedRequests.''.$SreceivedRequest ;
$sentRequests = $sentRequests.''.$SsentRequest ;
$subscriptions = $subscriptions.''.$Ssubscription ;
$blocked = $blocked.''.$Sblocked ;
$media = $media.''.$Smedia ;
$groups = $groups.''.$Sgroup ;
$favorites = $favorites.''.$Sfavorite ;
//Create links used in account.module
$inboxLink = '<a href="'.$sitepath.'usermenu/inbox">' ;
$outboxLink = '<a href="'.$sitepath.'usermenu/outbox">' ;
$receivedRequestsLink = '<a href="'.$sitepath.'usermenu/myreceivedrequests">' ;
$sentRequestsLink = '<a href="'.$sitepath.'usermenu/mysentrequests">' ;
$blockedLink = '<a href="'.$sitepath.'usermenu/blocked">' ;
$subscriptionsLink = '<a href="'.$sitepath.'usermenu/subscriptions">' ;
$friendsLink = '<a href="'.$sitepath.'usermenu/myfriends">' ;
$favoritesLink = '<a href="'.$sitepath.'usermenu/favorites">' ;
$mediaLink = '<a href="'.$sitepath.'usermenu/media">' ;
$groupsLink = '<a href="'.$sitepath.'usermenu/managegroups">' ;
$profileLink = '<a href="'.$sitepath.'usermenu/profile">' ;
$historyLink = '<a href="'.$sitepath.'usermenu/history">' ;
$profileHistoryLink = '<a href="'.$sitepath.'usermenu/profilehistory">' ;
$uploadLink = '<a href="'.$sitepath.'upload">' ;
?>
