<?php
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: mrss.php
 *    Description: RSS script
 *    $Date: 2010-02-21 23:16:57 +0000 (Sun, 21 Feb 2010) $
 *    $Revision: 12 $
 */
header("Content-Type: application/xml; ") ;
include_once 'includes/bootstrap.inc' ;
include_once 'includes/common.inc' ;
include_once 'includes/content.inc' ;
global $db,$sitepath ;
$sitename = getSetting("sitename", $db) ;
$email = getSetting("contact_email", $db) ;
$sitetitle = getSetting("sitetitle", $db) ;
echo "<?xml version='1.0' encoding='ISO-8859-1' ?> 
<rss version='2.0'  xmlns:media='http://search.yahoo.com/mrss/'>>
<channel>
<title>".$sitename."</title>
<link>".$sitepath."</link>
<description>".$sitetitle."</description>
<language>en-us</language>
<pubDate>".date("Y-m-d", time())." GMT</pubDate>
<lastBuildDate>".date("Y-m-d", time())." GMT</lastBuildDate>
<copyright>".$sitename."</copyright>
<author>".$sitetitle."</author>
<image><url>".$sitepath."images/013.png</url><title>".$row['title']."</title><link>".$sitepath."</link></image>
" ;
if (!$_GET['feed']) {
	$db->query('SELECT * FROM media ORDER BY id DESC') ;
	while ($row = $db->fetch()) {
		echo '
<item>
	<title>'.$row['title'].'</title>
	<link>'.$sitepath.'play/'.$row['url'].'</link>
	<description><![CDATA['.$row['description'].']]></description>
	<guid isPermaLink="false">'.$sitepath.'play/'.$row['url'].'</guid>
	<media:content url="'.$row['mediaurl'].'" type="video/x-msvideo" height="240" width="320" medium="video" isDefault="true">
	<media:title>'.$row['title'].'</media:title>
	<media:description><![CDATA['.$row['description'].']]></media:description>
	<media:keywords>'.$row['tags'].'</media:keywords>
	<media:thumbnail url="" height="96" width="96"/>
	</media:content>
	<tags>'.$row['tags'].'</tags>
	<uploadedby>'.$row['poster'].'</uploadedby>
	<visits>'.$row['visits'].'</visits>
	<pubDate>'.date("D, j M Y H:i:s", $row['added']).' EST</pubDate>
	<thumb>'.$sitepath.'uploads/thumbs/'.$row['thumb'].'.small.jpg</thumb>
	<image><url>'.$sitepath.'uploads/thumbs/'.$row['thumb'].'.large.jpg</url><title>'.$row['title'].'</title><link>'.$sitepath.'</link></image>
</item>' ;
	}
}
else {
	$db->query("SELECT name FROM category WHERE id = '".$_GET['feed']."'") ;
	$res = $db->fetch() ;
	$db->query("SELECT * FROM media WHERE category = '".$_GET['feed']."' ORDER BY id DESC") ;
	while ($row = $db->fetch()) {
		echo '
<item>
	<title>'.$row['title'].'</title>
	<link>'.$sitepath.'play/'.$row['url'].'</link>
	<description><![CDATA['.$row['description'].']]></description>
	<guid isPermaLink="false">'.$sitepath.'play/'.$row['url'].'</guid>
	<media:content url="" type="video/x-msvideo" height="240" width="320" medium="video" isDefault="true">
	<media:title>'.$row['title'].'</media:title>
	<media:description><![CDATA['.$row['description'].']]></media:description>
	<media:keywords>'.$row['tags'].'</media:keywords>
	<media:thumbnail url="" height="96" width="96"/>
	</media:content>
	<tags>'.$row['tags'].'</tags>
	<uploadedby>'.$row['poster'].'</uploadedby>
	<visits>'.$row['visits'].'</visits>
	<pubDate>'.date("D, j M Y H:i:s", $row['added']).' EST</pubDate>
	<thumb>'.$sitepath.'uploads/thumbs/'.$row['thumb'].'.small.jpg</thumb>
	<image><url>'.$sitepath.'uploads/thumbs/'.$row['thumb'].'.large.jpg</url><title>'.$row['title'].'</title><link>'.$sitepath.'</link></image>
</item>' ;
		}
}
echo "</channel>" ;
echo "</rss>" ;
?>