<?php
/*    
 *    Copyright (c) 2010 VidiScript
 *
 *    This file is part of VidiScript.
 *
 *    VidiScript is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    VidiScript is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with VidiScript.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    File Name: index.php
 *    Description: Installation script
 *    $Date: 2010-03-26 11:41:38 +0000 (Fri, 26 Mar 2010) $
 *    $Revision: 56 $
 */
include '../includes/mysql.inc' ;
if (!isset($_POST['page'])) {
	$pagenumber = 1 ;
}
else {
	$pagenumber = $_POST['page'] ;
}
switch ($pagenumber) {
	case 1:
		//Page 1 - Check server is ready
		$servercheckfail=false;
		//check server settings
		$settingmaxexec=ini_get('max_execution_time')!=1000?"<font color=red>(we recommend 1000)</font>":"<font color=green> OK</font>";
		$settingmaxinput=ini_get('max_input_time')!=1000?"<font color=red>(we recommend 1000)</font>":"<font color=green> OK</font>";
		$settinguploadmax=ini_get('upload_max_filesize')!='200M'?"<font color=red>(we recommend 200M)</font>":"<font color=green> OK</font>";
		$settingpostmax=ini_get('post_max_size')!='200M'?"<font color=red>(we recommend 200M)</font>":"<font color=green> OK</font>";
		$settingregister=((bool) ini_get('register_argc_argv')?'on':'off')=='off'?"<font color=red>(we recommend on)</font>":"<font color=green> OK</font>";
		$settingopenbase=ini_get('open_basedir')!=''?"<font color=red>(we recommend 'no value')</font>":"<font color=green> OK</font>";
		$settingsafemode=((bool) ini_get('safe_mode')?'on':'off')=='on'?"<font color=red>(we recommend off)</font>":"<font color=green> OK</font>";
		//check ffmpeg, etc. installed
		$ffmpegfail=(file_exists('/usr/bin/ffmpeg')?'yes':'no')=='no'?'<font color=red>FFMPEG is not installed at /usr/bin/ffmpeg - please set the path to FFMPEG in admin settings after you have installed VidiScript</font>':'<font color=green>FFMPEG is installed at /usr/bin/ffmpeg</font>';
		$mencoderfail=(file_exists('/usr/bin/mencoder')?'yes':'no')=='no'?'<font color=red>MEncoder is not installed at /usr/bin/mencoder - please set the path to Mencoder in admin settings after you have installed VidiScript</font>':'<font color=green>Mencoder is installed at /usr/bin/mencoder</font>';
		//check folder permissions
		if (!is_writable('../data'))
		{
			$folderdatafail="<font color=red>Folder 'data' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$folderdatafail="<font color=green>Folder 'data' is writable</font>";
		}
		if (!is_writable('../data/scroller/scroller.xml'))
		{
			$folderdatascrollerfail="<font color=red>File 'data/scroller/scroller.xml' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$folderdatascrollerfail="<font color=green>File 'data/scroller/scroller.xml' is writable</font>";
		}
		if (!is_writable('../uploads'))
		{
			$folderuploadsfail="<font color=red>Folder 'uploads' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$folderuploadsfail="<font color=green>Folder 'uploads' is writable</font>";
		}
		if (!is_writable('../uploads/thumbs'))
		{
			$folderuploadsthumbsfail="<font color=red>Folder 'uploads/thumbs' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$folderuploadsthumbsfail="<font color=green>Folder 'uploads/thumbs'  is writable</font>";
		}
		if (!is_writable('../uploads/avatars'))
		{
			$folderuploadsavatarsfail="<font color=red>Folder 'uploads/avatars' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$folderuploadsavatarsfail="<font color=green>Folder 'uploads/avatars' is writable</font>";
		}
		if (!is_writable('../uploads/ads'))
		{
			$folderuploadsadsfail="<font color=red>Folder 'uploads/ads' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$folderuploadsadsfail="<font color=green>Folder 'uploads/ads' is writable</font>";
		}
		if (!is_writable('../uploads/groupicons'))
		{
			$folderdatauploadsgroupiconsfail="<font color=red>Folder 'uploads/groupicons' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$folderdatauploadsgroupiconsfail="<font color=green>Folder 'uploads/groupicons' is writable</font>";
		}
		if (!is_writable('../includes/common.inc'))
		{
			$filecommonfail="<font color=red>File 'includes/common.inc' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$filecommonfail="<font color=green>File 'includes/common.inc' is writable</font>";
		}   
		if (!is_writable('../includes/bootstrap.inc'))
		{
			$filebootstrapfail="<font color=red>File 'includes/bootstrap.inc' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$filebootstrapfail="<font color=green>File 'includes/bootstrap.inc' is writable</font>";
		}   
		if (!is_writable('../includes/settings.inc'))
		{
			$filesettingsfail="<font color=red>File 'includes/settings.inc' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$filesettingsfail="<font color=green>File 'includes/settings.inc' is writable</font>";
		}
		
		if (!is_writable('../index.php'))
		{
			$fileindexfail="<font color=red>File 'index.php' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$fileindexfail="<font color=green>File 'index.php' is writable</font>";
		}   
		
		
		   
		if (!is_writable('../includes/badwords.inc'))
		{
			$filebadwordsfail="<font color=red>File 'includes/badwords.inc' is not writable - please CHMOD to 755 or 777</font>";
			$servercheckfail=true;
		}
		else
		{
			$filebadwordsfail="<font color=green>File 'includes/badwords.inc' is writable</font>";
		}   
		//$servercheckfail=false;
		if ($servercheckfail==true)
		{
			$submit1="<h3><font color=red>Please change the above folder permissions then refresh the page to continue</font></h3>";
		}
		else
		{
			$submit1="<form action='' method='POST'>
			<input type='hidden' name='page' value='1'>
			<input type='submit' name='submit1' value='Next Step'>
		</form>";
		}
		//If anything goes wrong set $servercheckfail=true
   		if (!$servercheckfail&&(isset($_POST['submit1'])))
		{
			$pagenumber++;
		}
		break;
	case 2:
	    //Page 2 - Enter Database Details
		$dbdetailsfail=false;
		//Try to connect to the database
		$dbhost = $_POST['dbhost'];
		if ($dbhost=='') {$dbhost='localhost';}
		$dbusername = $_POST['dbusername'];
		$dbpassword = $_POST['dbpassword'];
		$dbname = $_POST['dbname'];
		if (isset($_POST['submit2']))
		{
			$databaseconnect=mysql_connect($dbhost, $dbusername, $dbpassword);
			$connect=(!$databaseconnect)?"<h3><font color=red>Could not connect to MySQL - Please check Host Name, User Name and Password</font></h3>":"";
			if ($databaseconnect)
			{
				$databaseselect=mysql_select_db($dbname,$databaseconnect);
				$select=(!$databaseselect)?"<h3><font color=red>Could not find database '$dbname' - Please check the name is correct and that the user you specified has the correct permissions</font></h3>":"";
				if (!$databaseselect)
				{
					$dbdetailsfail=true;
				}
			}
			else
			{
				$dbdetailsfail=true;
			}
		}
		if (!$dbdetailsfail)
		{
			$settingsfile = '<?php
						$db_host = "' . $dbhost . '";
						$db_user = "' . $dbusername . '";
						$db_password = "' . $dbpassword. '";
						$db_database = "' . $dbname . '";
					?>';
			$fp = fopen('../includes/settings.inc', 'w');
			fwrite($fp, $settingsfile);
			fclose($fp);		
			//Set up tables with SQL from database folder
			$db = new mysql($dbhost,$dbusername,$dbpassword,$dbname);
			$templine = '';
			$lines = file("../database/database.sql");
			foreach ($lines as $line_num => $line)
			 {
				if (substr($line, 0, 2) != '--' && $line != '') 
				{
					$templine .= $line;
					if (substr(trim($line), -1, 1) == ';') 
					{
						$db->query($templine);
						$templine = '';
					}
				}
			}
 		}
		//If it fails then set $databasefail=true
   		if (!$dbdetailsfail&&(isset($_POST['submit2']))) {$pagenumber++;}
		break;
	case 3:
	    //Page 3 - Enter Site Details
		$sitedetailsfail=false;		
		//If site name, folder, admin username or password are empty set each of these
		if (isset($_POST['submit3']))
		{
			$dbhost = $_POST['dbhost'];
			$dbusername = $_POST['dbusername'];
			$dbpassword = $_POST['dbpassword'];
			$dbname = $_POST['dbname'];
			$sitename=$_POST['sitename'];
			$sitefolder=$_POST['sitefolder'];
			$sitefolder= ($sitefolder!='')?'/'.$sitefolder.'/':'/'.$sitefolder;
			$adminuname=$_POST['adminuname'];
			$adminpass=$_POST['adminpass'];
			$adminemail=$_POST['adminemail'];			
			$sitenameerror=($sitename=='')?"<font color=red>Required</font>":"";
			$adminunameerror=($adminuname=='')?"<font color=red>Required</font>":"";
			$adminpasserror=($adminpass=='')?"<font color=red>Required</font>":"";
			$adminemailerror=($adminemail=='')?"<font color=red>Required</font>":"";
			$sitedetailsfail=(($sitename=='')||($adminuname=='')||($adminpass=='')||($adminemail==''));
		}
		$sitedetailserror=($sitedetailsfail)?"<h3><font color=red>Please fill in all fields below</font></h3>":"";
   		if (!$sitedetailsfail&&(isset($_POST['submit3']))) {
			//Insert Admin Record
			$db = new mysql($dbhost,$dbusername,$dbpassword,$dbname);
			$db->query("INSERT INTO member (username,password,email,activationkey,privs) VALUES ('".$adminuname."','".md5($adminpass)."','".$adminemail."','0','7')");
			$db->query("UPDATE setting SET value='".$sitename."' WHERE setting='sitetitle'");
			$db->query("UPDATE setting SET value='".$sitefolder."' WHERE setting='sitefolder'");
			$pagenumber++;
		}
	    break;
//No checks needed for page 4 :)
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
    <head>
        <title>Vidiscript - Installation</title>
        <link rel="stylesheet" type="text/css" media="all" href="style.css" />
    </head>
    <body>
        <div id="top">
            <div id="topmid">
                <div id="topright">
                    <ul>
                        <li>
                            <a href="http://www.vidiscript.co.uk/support-forum">Forums</a>
                        </li>
                        <li>
                            <a href="http://www.vidiscript.co.uk/vidiscript-features">Features</a>
                        </li>
                        <li>
                            <a href="http://www.vidiscript.co.uk/contact-us">Contact</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div id="midbar">
            <div id="midbarinside">
            </div>
        </div>
        <div id="contentcontain">
            <div id="content">
                <div id="secondbox">
                    <div id="secondboxhead">
                        <img src="images/install.png" alt="Installation" />
                    </div>
                    <div id="boxcontent">
                        <br>
   
 <?php  
	switch ($pagenumber) {
	case 1:
		//Page 1 - Check server is ready
		?>		
			<h2>Step 1 - Checking your server is ready to install VidiScript 1.0.3a</h2>
		<?php
		//check server settings
		?>
        <h3>Server settings:</h3>
        <ul>
		<li>max_execution_time: <?php echo ini_get('max_execution_time');?><?php echo $settingmaxexec?></li>
		<li>max_input_time: <?php echo ini_get('max_input_time');?><?php echo $settingmaxinput?></li>
		<li>upload_max_filesize: <?php echo ini_get('upload_max_filesize');?><?php echo $settinguploadmax?></li>
		<li>post_max_size: <?php echo ini_get('post_max_size');?><?php echo $settingpostmax?></li>
		<li>register_argc_argv: <?php echo ini_get('register_argc_argv');?><?php echo $settingregister?></li>
		<li>open_basedir: <?php echo  (bool) ini_get('open_basedir')==''?'no value':ini_get('open_basedir');?><?php echo $settingopenbase?></li>
		<li>safe_mode: <?php echo  (bool) ini_get('safe_mode')?'on':'off';?><?php echo $settingsafemode?></li>
		</ul>
		<br>
		<?php 
		//check ffmpeg, etc. installed
		?>
		<h3>Encoders Installed:</h3>
		<ul>
		<li>FFMPEG - <?php echo $ffmpegfail?><li>
		<li>MEncoder - <?php echo $mencoderfail?><li>
		</ul>
	    <?php 
		//check folder permissions
		?>
		<h3>Folder Permissions:</h3><br>
		<ul>
		<li>Folder 'data' - <?php echo $folderdatafail?></li>
		<li>File 'data/scroller/scroller.xml' - <?php echo $folderdatascrollerfail?></li>
		<li>Folder 'uploads' - <?php echo $folderuploadsfail?></li>
		<li>Folder 'uploads/thumbs' - <?php echo $folderuploadsthumbsfail?></li>
		<li>Folder 'uploads/avatars' - <?php echo $folderuploadsavatarsfail?></li>
		<li>Folder 'uploads/ads' - <?php echo $folderuploadsadsfail?></li>
		<li>Folder 'uploads/groupicons' - <?php echo $folderdatauploadsgroupiconsfail?></li>
		<li>File 'includes/common' - <?php echo $filecommonfail?></li>
		<li>File 'includes/bootstrap' - <?php echo $filebootstrapfail?></li>
		<li>File 'includes/settings' - <?php echo $filesettingsfail?></li>
		<li>File 'includes/badwords' - <?php echo $filebadwordsfail?></li>
		<li>File 'index.php' - <?php echo $fileindexfail?></li>
		<br>
		<br>
		<?php echo $submit1?>
		</ul>
		<?php 
		//for all the above, there is the option of an error message, that will happen if the checks at the top fail
		//form submits with page = 1
		break;
	case 2:
	    //Page 2 - Enter Database Details
		?>
		<h2>Step 2 - Database Details</h2>
		<br>
		<?php echo $connect?>
		<?php echo $select?>
		<br>
		<form action='' method="POST">
		<table>
			<tr>
				<td>
					<label for="dbname">Database name</label>
				</td>
				<td>
					<input type="text" size="20" name="dbname" value="<?php echo $dbname?>">
					<?php echo $dbnameerror?>
				</td>
			</tr>
			<tr>
				<td>
					<label for="dbhost">Host Name</label>
				</td>
				<td>
					<input type="text" size="20" name="dbhost" value="<?php echo $dbhost?>">
					<?php echo $dbhosterror?>
				</td>
			</tr>
			<tr>
				<td>
					<label for="dbusername">Login Username</label>
				</td>
				<td>
					<input type="text" size="20" name="dbusername" value="<?php echo $dbusername?>">
					<?php echo $dbusernameerror?>
				</td>
			</tr>
			<tr>
				<td>
					<label for="dbpassword">Login Password</label>
				</td>
				<td>
					<input type="text" size="20" name="dbpassword" value="<?php echo $dbpassword?>">
					<?php echo $dbpassworderror?>
				</td>
			</tr>
			<tr><td>&nbsp;</td><td>&nbsp;</td></tr>
			<input type="hidden" name="page" value="2">
			<tr><td>&nbsp;</td><td><input type="submit" name="submit2" value="Next Step">
		</table>
		</form>
		
		<?php 
        //Form with mysql hostname, db name, username, password
		//Form submits with page = 2
		break;
	case 3:
	    //Page 3 - Enter Site Details
		?>
		<h2>Step 3 - Site Details And Admin Login</h2>
		<br>
		<?php echo $sitedetailserror?>
		<form action='' method="POST">
		<table>
			<tr>
				<td>
					<label for="sitename">Site Name (you can change this later)</label>
				</td>
				<td>
					<input type="text" size="20" name="sitename" value="<?php echo $sitename?>">
					<?php echo $sitenameerror?>
				</td>
			</tr>
			<tr>
				<td width=500px>
					<label for="sitefolder">Site Folder (eg. if you have uploaded to 'http://yoursite.com/myfolder' enter 'myfolder' (not 'myfolder/') or leave blank if root folder)</label>
				</td>
				<td>
					<input type="text" size="20" name="sitefolder" value="<?php echo $sitefolder?>">
					<?php echo $sitefoldererror?>
				</td>
			</tr>
			<tr>
				<td>
					<label for="adminuname">Admin Username</label>
				</td>
				<td>
					<input type="text" size="20" name="adminuname" value="<?php echo $adminuname?>">
					<?php echo $adminunameerror?>
				</td>
			</tr>
			<tr>
				<td>
					<label for="adminpass">Admin Password</label>
				</td>
				<td>
					<input type="text" size="20" name="adminpass" value="<?php echo $adminpass?>">
					<?php echo $adminpasserror?>
				</td>
			</tr>
			<tr>
				<td>
					<label for="adminpass">Admin Email Address</label>
				</td>
				<td>
					<input type="text" size="20" name="adminemail" value="<?php echo $adminemail?>">
					<?php echo $adminemailerror?>
				</td>
			</tr>
			<tr><td>&nbsp;</td><td>&nbsp;</td></tr>
			<input type="hidden" name="page" value="3">
			<input type="hidden" name="dbname" value="<?php echo $_POST['dbname']?>">
			<input type="hidden" name="dbhost" value="<?php echo $_POST['dbhost']?>">
			<input type="hidden" name="dbusername" value="<?php echo $_POST['dbusername']?>">
			<input type="hidden" name="dbpassword" value="<?php echo $_POST['dbpassword']?>">
			<tr><td>&nbsp;</td><td><input type="submit" name="submit3" value="Next Step">
		</table>
		</form>	
		<?php 
		//Form with site name, folder in which installed, admin username, admin password
		//Form submits with page = 3
	    break;
	case 4:
	    //Page 5 - Done Site Details
		?>
		<h2>Congratulations! Your new VidiScript 1.0.3a site is installed and ready to go</h2>
		<br>
		<h3>IMPORTANT Please delete the 'install' folder as soon as possible, you will see a warning on your site until you have done this.</h3>
		<br>
		<h3>Also change the file permissions on includes/settings.inc to 644, if you leave it writable it could be a security risk.</h3>
		<h3>For Vidiscript Templates, Mods and more go to <a href="http://www.vidiscript.co.uk" target="_blank">www.vidiscript.co.uk</a></h3>
		<br>

		<h3><a href="../">Click here to go to your VidiScript site</a></h3>
		<?php 
		//Message that says install was successful, delete install files asap
		//Link to the home page
	    break;
}
?>
   </div>
   </div>
</div>
</div>
<div id="bottom">
</div>
</body>
</html>